<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    calendar
 */

/**
 * Hook class.
 */
class Hook_search_calendar extends FieldsSearchHook
{
    /**
     * Find details for this search hook.
     *
     * @param  boolean $check_permissions Whether to check permissions
     * @param  ?MEMBER $member_id The member ID to check with (null: current member)
     * @return ~?array Map of search hook details (null: hook is disabled) (false: access denied)
     */
    public function info($check_permissions = true, $member_id = null)
    {
        if ($member_id === null) {
            $member_id = get_member();
        }

        if (!module_installed('calendar')) {
            return null;
        }

        if ($check_permissions) {
            if (!has_actual_page_access($member_id, 'calendar')) {
                return false;
            }
        }

        if ($GLOBALS['SITE_DB']->query_select_value('calendar_events', 'COUNT(*)') == 0) {
            return null;
        }

        require_lang('calendar');

        $info = array();
        $info['lang'] = do_lang_tempcode('CALENDAR');
        $info['default'] = false;
        $info['extra_sort_fields'] = $this->_get_extra_sort_fields('_event');

        $info['permissions'] = array(
            array(
                'type' => 'zone',
                'zone_name' => get_module_zone('calendar'),
            ),
            array(
                'type' => 'page',
                'zone_name' => get_module_zone('calendar'),
                'page_name' => 'calendar',
            ),
        );

        return $info;
    }

    /**
     * Get a list of extra fields to ask for.
     *
     * @return ?array A list of maps specifying extra fields (null: no tree)
     */
    public function get_fields()
    {
        return $this->_get_fields('_event');
    }

    /**
     * Run function for search results.
     *
     * @param  string $content Search string
     * @param  boolean $only_search_meta Whether to only do a META (tags) search
     * @param  ID_TEXT $direction Order direction
     * @param  integer $max Start position in total results
     * @param  integer $start Maximum results to return in total
     * @param  boolean $only_titles Whether only to search titles (as opposed to both titles and content)
     * @param  string $content_where Where clause that selects the content according to the main search string (SQL query fragment) (blank: full-text search)
     * @param  SHORT_TEXT $author Username/Author to match for
     * @param  ?MEMBER $author_id Member-ID to match for (null: unknown)
     * @param  mixed $cutoff Cutoff date (TIME or a pair representing the range)
     * @param  string $sort The sort type (gets remapped to a field in this function)
     * @set    title add_date
     * @param  integer $limit_to Limit to this number of results
     * @param  string $boolean_operator What kind of boolean search to do
     * @set    or and
     * @param  string $where_clause Where constraints known by the main search code (SQL query fragment)
     * @param  string $search_under Comma-separated list of categories to search under
     * @param  boolean $boolean_search Whether it is a boolean search
     * @return array List of maps (template, orderer)
     */
    public function run($content, $only_search_meta, $direction, $max, $start, $only_titles, $content_where, $author, $author_id, $cutoff, $sort, $limit_to, $boolean_operator, $where_clause, $search_under, $boolean_search)
    {
        require_lang('calendar');

        $remapped_orderer = '';
        switch ($sort) {
            case 'title':
                $remapped_orderer = 'e_title';
                break;

            case 'add_date':
                $remapped_orderer = 'e_add_date';
                break;
        }

        // Calculate our where clause (search)
        if (addon_installed('content_privacy')) {
            require_code('content_privacy');
            list($privacy_join, $privacy_where) = get_privacy_where_clause('event', 'r', null, 'r.e_member_calendar=' . strval(get_member()));
            $where_clause .= $privacy_where;
        } else {
            $privacy_join = '';
        }
        if (get_option('filter_regions') == '1') {
            require_code('locations');
            $where_clause .= sql_region_filter('event', 'r.id');
        }
        $where_clause .= ' AND ';
        $where_clause .= '(e_member_calendar IS NULL'; // Not a privacy thing, more of a relevance thing
        if (!is_guest()) {
            $where_clause .= ' OR e_submitter=' . strval(get_member());
            $where_clause .= ' OR e_member_calendar=' . strval(get_member());
        }
        $where_clause .= ')';
        $sq = build_search_submitter_clauses('e_submitter', $author_id, $author);
        if (is_null($sq)) {
            return array();
        } else {
            $where_clause .= $sq;
        }
        $this->_handle_date_check($cutoff, 'e_add_date', $where_clause);
        $where_clause .= ' AND ';
        $where_clause .= 'e_type<>' . strval(db_get_first_id());
        if ((!has_privilege(get_member(), 'see_unvalidated')) && (addon_installed('unvalidated'))) {
            $where_clause .= ' AND ';
            $where_clause .= 'validated=1';
        }

        $table = 'calendar_events r';
        $trans_fields = array('r.e_title' => 'SHORT_TRANS', 'r.e_content' => 'LONG_TRANS__COMCODE');
        $nontrans_fields = array();
        $this->_get_search_parameterisation_advanced_for_content_type('_event', $table, $where_clause, $trans_fields, $nontrans_fields);

        // Calculate and perform query
        $rows = get_search_rows('event', 'id', $content, $boolean_search, $boolean_operator, $only_search_meta, $direction, $max, $start, $only_titles, $table . $privacy_join, $trans_fields, $where_clause, $content_where, $remapped_orderer, 'r.*', $nontrans_fields, 'calendar', 'e_type');

        $out = array();
        foreach ($rows as $i => $row) {
            $out[$i]['data'] = $row;
            unset($rows[$i]);
            if (($remapped_orderer != '') && (array_key_exists($remapped_orderer, $row))) {
                $out[$i]['orderer'] = $row[$remapped_orderer];
            } elseif (strpos($remapped_orderer, '_rating:') !== false) {
                $out[$i]['orderer'] = $row[$remapped_orderer];
            }
        }

        return $out;
    }

    /**
     * Run function for rendering a search result.
     *
     * @param  array $row The data row stored when we retrieved the result
     * @return Tempcode The output
     */
    public function render($row)
    {
        global $SEARCH__CONTENT_BITS, $LAX_COMCODE;
        $highlight_bits = ($SEARCH__CONTENT_BITS === null) ? array() : $SEARCH__CONTENT_BITS;
        $LAX_COMCODE = true;
        $summary = get_translated_text($row['e_content']);
        $text_summary_h = comcode_to_tempcode($summary, null, false, null, null, null, false, false, false, false, false, $highlight_bits);
        $LAX_COMCODE = false;
        $text_summary = generate_text_summary($text_summary_h->evaluate(), $highlight_bits);

        require_code('calendar');
        return render_event_box($row, '_SEARCH', true, '', protect_from_escaping($text_summary));
    }
}
