<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    core
 */

/**
 * Hook class.
 */
class Hook_addon_registry_core
{
    /**
     * Get a list of file permissions to set
     *
     * @param  boolean $runtime Whether to include wildcards represented runtime-created chmoddable files
     * @return array File permissions to set
     */
    public function get_chmod_array($runtime = false)
    {
        return array();
    }

    /**
     * Get the version of Composr this addon is for
     *
     * @return float Version number
     */
    public function get_version()
    {
        return cms_version_number();
    }

    /**
     * Get the description of the addon
     *
     * @return string Description of the addon
     */
    public function get_description()
    {
        return '(Core Composr code)';
    }

    /**
     * Get a list of tutorials that apply to this addon
     *
     * @return array List of tutorials
     */
    public function get_applicable_tutorials()
    {
        return array(
            'tut_do',
            'tut_drinking',
            'tut_metadata',
            'tut_sql',
            'tut_short_urls',
            'tut_seo',
            'tut_selectcode',
            'tut_filtercode',
            'tut_keymap',
            'tut_email',
            'tut_disaster',
            'tut_antispam',
        );
    }

    /**
     * Get a mapping of dependency types
     *
     * @return array File permissions to set
     */
    public function get_dependencies()
    {
        return array(
            'requires' => array(),
            'recommends' => array(),
            'conflicts_with' => array(),
        );
    }

    /**
     * Explicitly say which icon should be used
     *
     * @return URLPATH Icon
     */
    public function get_default_icon()
    {
        return 'themes/default/images/icons/48x48/menu/_generic_admin/component.png';
    }

    /**
     * Get a list of files that belong to this addon
     *
     * @return array List of files
     */
    public function get_file_list()
    {
        return array(
            'data/empty.php',
            'adminzone/pages/comcode/EN/_modsecurity.txt',
            'themes/default/images/icons/24x24/menu/_generic_admin/merge.png',
            'themes/default/images/icons/48x48/menu/_generic_admin/merge.png',
            'themes/default/images/icons/24x24/menu/rich_content.png',
            'themes/default/images/icons/48x48/menu/rich_content.png',
            'themes/default/images/icons/24x24/menu/_generic_admin/add_one_category.png',
            'themes/default/images/icons/48x48/menu/_generic_admin/add_one_category.png',
            'themes/default/images/icons/24x24/menu/pages.png',
            'themes/default/images/icons/48x48/menu/pages.png',
            'themes/default/images/icons/24x24/menu/_generic_admin/edit_one_category.png',
            'themes/default/images/icons/48x48/menu/_generic_admin/edit_one_category.png',
            'themes/default/images/icons/24x24/menu/_generic_admin/export.png',
            'themes/default/images/icons/48x48/menu/_generic_admin/export.png',
            'themes/default/images/icons/24x24/menu/rich_content/atoz.png',
            'themes/default/images/icons/48x48/menu/rich_content/atoz.png',
            'themes/default/images/icons/24x24/menu/_generic_admin/import_csv.png',
            'themes/default/images/icons/48x48/menu/_generic_admin/import_csv.png',
            'themes/default/images/icons/24x24/menu/social.png',
            'themes/default/images/icons/24x24/menu/social/members.png',
            'themes/default/images/icons/48x48/menu/social.png',
            'themes/default/images/icons/48x48/menu/social/members.png',
            'themes/default/images/icons/24x24/menu/_generic_admin/delete.png',
            'themes/default/images/icons/48x48/menu/_generic_admin/delete.png',
            'themes/default/images/icons/24x24/menu/_generic_admin/tool.png',
            'themes/default/images/icons/48x48/menu/_generic_admin/tool.png',
            'themes/default/images/icons/24x24/menu/_generic_admin/index.html',
            'themes/default/images/icons/24x24/menu/_generic_spare/1.png',
            'themes/default/images/icons/24x24/menu/_generic_spare/2.png',
            'themes/default/images/icons/24x24/menu/_generic_spare/3.png',
            'themes/default/images/icons/24x24/menu/_generic_spare/4.png',
            'themes/default/images/icons/24x24/menu/_generic_spare/5.png',
            'themes/default/images/icons/24x24/menu/_generic_spare/6.png',
            'themes/default/images/icons/24x24/menu/_generic_spare/7.png',
            'themes/default/images/icons/24x24/menu/_generic_spare/8.png',
            'themes/default/images/icons/24x24/menu/_generic_spare/features.png',
            'themes/default/images/icons/24x24/menu/_generic_spare/index.html',
            'themes/default/images/icons/24x24/menu/_generic_spare/page.png',
            'themes/default/images/icons/48x48/menu/_generic_admin/index.html',
            'themes/default/images/icons/48x48/menu/_generic_spare/1.png',
            'themes/default/images/icons/48x48/menu/_generic_spare/2.png',
            'themes/default/images/icons/48x48/menu/_generic_spare/3.png',
            'themes/default/images/icons/48x48/menu/_generic_spare/4.png',
            'themes/default/images/icons/48x48/menu/_generic_spare/5.png',
            'themes/default/images/icons/48x48/menu/_generic_spare/6.png',
            'themes/default/images/icons/48x48/menu/_generic_spare/7.png',
            'themes/default/images/icons/48x48/menu/_generic_spare/8.png',
            'themes/default/images/icons/48x48/menu/_generic_spare/features.png',
            'themes/default/images/icons/48x48/menu/_generic_spare/index.html',
            'themes/default/images/icons/48x48/menu/_generic_spare/page.png',
            'themes/default/images/icons/24x24/tabs/edit.png',
            'themes/default/images/icons/24x24/tabs/index.html',
            'themes/default/images/icons/48x48/tabs/edit.png',
            'themes/default/images/icons/48x48/tabs/index.html',
            'themes/default/images/icons/24x24/menu/pages/about_us.png',
            'themes/default/images/icons/48x48/menu/pages/about_us.png',
            'themes/default/images/icons/24x24/menu/_generic_admin/add_one.png',
            'themes/default/images/icons/48x48/menu/_generic_admin/add_one.png',
            'themes/default/images/icons/24x24/menu/_generic_admin/add_to_category.png',
            'themes/default/images/icons/48x48/menu/_generic_admin/add_to_category.png',
            'themes/default/images/icons/24x24/menu/adminzone/adminzone.png',
            'themes/default/images/icons/48x48/menu/adminzone/adminzone.png',
            'themes/default/images/icons/24x24/buttons/advanced.png',
            'themes/default/images/icons/48x48/buttons/advanced.png',
            'themes/default/images/icons/24x24/buttons/help.png',
            'themes/default/images/icons/48x48/buttons/help.png',
            'themes/default/images/icons/24x24/buttons/simple.png',
            'themes/default/images/icons/48x48/buttons/simple.png',
            'themes/default/images/icons/24x24/buttons/all.png',
            'themes/default/images/icons/48x48/buttons/all.png',
            'themes/default/images/icons/24x24/buttons/all2.png',
            'themes/default/images/icons/48x48/buttons/all2.png',
            'themes/default/images/icons/24x24/menu/adminzone/audit.png',
            'themes/default/images/icons/48x48/menu/adminzone/audit.png',
            'themes/default/images/icons/32x32/menu/adminzone/audit.png',
            'themes/default/images/icons/24x24/menu/_generic_admin/back.png',
            'themes/default/images/icons/48x48/menu/_generic_admin/back.png', // Red, used as a full-size icon (24x24 version is not currently used)
            'themes/default/images/icons/24x24/buttons/back.png', // Yellow, used within a button
            'themes/default/images/icons/48x48/buttons/back.png',
            'themes/default/images/icons/24x24/menu/adminzone/setup/config/base_config.png',
            'themes/default/images/icons/48x48/menu/adminzone/setup/config/base_config.png',
            'themes/default/images/icons/24x24/buttons/cancel.png',
            'themes/default/images/icons/48x48/buttons/cancel.png',
            'themes/default/images/icons/24x24/buttons/choose.png',
            'themes/default/images/icons/48x48/buttons/choose.png',
            'themes/default/images/icons/24x24/buttons/clear.png',
            'themes/default/images/icons/48x48/buttons/clear.png',
            'themes/default/images/icons/24x24/buttons/closed.png',
            'themes/default/images/icons/48x48/buttons/closed.png',
            'themes/default/images/icons/24x24/buttons/save_and_stay.png',
            'themes/default/images/icons/48x48/buttons/save_and_stay.png',
            'themes/default/images/icons/24x24/buttons/filter.png',
            'themes/default/images/icons/48x48/buttons/filter.png',
            'themes/default/images/icons/24x24/buttons/new_comment.png',
            'themes/default/images/icons/48x48/buttons/new_comment.png',
            'themes/default/images/icons/24x24/menu/cms/cms.png',
            'themes/default/images/icons/48x48/menu/cms/cms.png',
            'themes/default/images/icons/32x32/menu/cms/cms.png',
            'themes/default/images/icons/64x64/menu/cms/cms.png',
            'themes/default/images/icons/64x64/menu/adminzone/help.png',
            'themes/default/images/icons/24x24/links/download_as_archive.png',
            'themes/default/images/icons/48x48/links/download_as_archive.png',
            'themes/default/images/icons/48x48/menu/_generic_admin/download_csv.png',
            'themes/default/images/icons/24x24/menu/_generic_admin/download_csv.png',
            'themes/default/images/icons/24x24/buttons/edit.png',
            'themes/default/images/icons/48x48/buttons/edit.png',
            'themes/default/images/icons/24x24/menu/_generic_admin/edit_one.png',
            'themes/default/images/icons/48x48/menu/_generic_admin/edit_one.png',
            'themes/default/images/icons/24x24/menu/_generic_admin/edit_this.png',
            'themes/default/images/icons/48x48/menu/_generic_admin/edit_this.png',
            'themes/default/images/icons/24x24/menu/_generic_admin/edit_this_category.png',
            'themes/default/images/icons/48x48/menu/_generic_admin/edit_this_category.png',
            'themes/default/images/icons/24x24/menu/adminzone/audit/email_log.png',
            'themes/default/images/icons/48x48/menu/adminzone/audit/email_log.png',
            'themes/default/images/icons/24x24/menu/adminzone/help.png',
            'themes/default/images/icons/48x48/menu/adminzone/help.png',
            'themes/default/images/icons/32x32/menu/adminzone/help.png',
            'themes/default/images/icons/24x24/menu/site_meta/user_actions/join.png',
            'themes/default/images/icons/48x48/menu/site_meta/user_actions/join.png',
            'themes/default/images/icons/24x24/menu/pages/keymap.png',
            'themes/default/images/icons/48x48/menu/pages/keymap.png',
            'themes/default/images/icons/24x24/menu/site_meta/user_actions/login.png',
            'themes/default/images/icons/48x48/menu/site_meta/user_actions/login.png',
            'themes/default/images/icons/24x24/menu/site_meta/user_actions/logout.png',
            'themes/default/images/icons/48x48/menu/site_meta/user_actions/logout.png',
            'themes/default/images/icons/24x24/menu/site_meta/user_actions/concede.png',
            'themes/default/images/icons/48x48/menu/site_meta/user_actions/concede.png',
            'themes/default/images/icons/24x24/menu/site_meta/user_actions/invisible.png',
            'themes/default/images/icons/48x48/menu/site_meta/user_actions/invisible.png',
            'themes/default/images/icons/24x24/buttons/more.png',
            'themes/default/images/icons/48x48/buttons/more.png',
            'themes/default/images/icons/24x24/buttons/move.png',
            'themes/default/images/icons/48x48/buttons/move.png',
            'themes/default/images/icons/24x24/buttons/new_post_full.png',
            'themes/default/images/icons/48x48/buttons/new_post_full.png',
            'themes/default/images/icons/24x24/buttons/next.png',
            'themes/default/images/icons/48x48/buttons/next.png',
            'themes/default/images/icons/24x24/buttons/no.png',
            'themes/default/images/icons/48x48/buttons/no.png',
            'themes/default/images/icons/24x24/buttons/next_none.png',
            'themes/default/images/icons/48x48/buttons/next_none.png',
            'themes/default/images/icons/24x24/buttons/previous_none.png',
            'themes/default/images/icons/48x48/buttons/previous_none.png',
            'themes/default/images/icons/24x24/tabs/preview.png',
            'themes/default/images/icons/48x48/tabs/preview.png',
            'themes/default/images/icons/24x24/buttons/previous.png',
            'themes/default/images/icons/48x48/buttons/previous.png',
            'themes/default/images/icons/24x24/menu/pages/privacy_policy.png',
            'themes/default/images/icons/48x48/menu/pages/privacy_policy.png',
            'themes/default/images/icons/24x24/buttons/convert.png',
            'themes/default/images/icons/48x48/buttons/convert.png',
            'themes/default/images/icons/24x24/buttons/fullsize.png',
            'themes/default/images/icons/48x48/buttons/fullsize.png',
            'themes/default/images/icons/24x24/buttons/thumbnail.png',
            'themes/default/images/icons/48x48/buttons/thumbnail.png',
            'themes/default/images/icons/24x24/buttons/redirect.png',
            'themes/default/images/icons/48x48/buttons/redirect.png',
            'themes/default/images/icons/24x24/buttons/new_reply.png',
            'themes/default/images/icons/48x48/buttons/new_reply.png',
            'themes/default/images/icons/24x24/buttons/report.png',
            'themes/default/images/icons/48x48/buttons/report.png',
            'themes/default/images/icons/24x24/menu/pages/rules.png',
            'themes/default/images/icons/48x48/menu/pages/rules.png',
            'themes/default/images/icons/24x24/buttons/search.png',
            'themes/default/images/icons/48x48/buttons/search.png',
            'themes/default/images/icons/24x24/menu/adminzone/security.png',
            'themes/default/images/icons/48x48/menu/adminzone/security.png',
            'themes/default/images/icons/32x32/menu/adminzone/security.png',
            'themes/default/images/icons/64x64/menu/adminzone/security.png',
            'themes/default/images/icons/24x24/menu/adminzone/setup.png',
            'themes/default/images/icons/48x48/menu/adminzone/setup.png',
            'themes/default/images/icons/32x32/menu/adminzone/setup.png',
            'themes/default/images/icons/64x64/menu/adminzone/setup.png',
            'themes/default/images/icons/24x24/menu/site_meta.png',
            'themes/default/images/icons/48x48/menu/site_meta.png',
            'themes/default/images/icons/24x24/tool_buttons/software_chat.png',
            'themes/default/images/icons/48x48/tool_buttons/software_chat.png',
            'themes/default/images/icons/24x24/menu/start.png',
            'themes/default/images/icons/48x48/menu/start.png',
            'themes/default/images/icons/24x24/menu/welcome.png',
            'themes/default/images/icons/48x48/menu/welcome.png',
            'themes/default/images/icons/24x24/menu/adminzone/start.png',
            'themes/default/images/icons/48x48/menu/adminzone/start.png',
            'themes/default/images/icons/32x32/menu/adminzone/start.png',
            'themes/default/images/icons/64x64/menu/adminzone/start.png',
            'themes/default/images/icons/24x24/menu/adminzone/structure.png',
            'themes/default/images/icons/48x48/menu/adminzone/structure.png',
            'themes/default/images/icons/32x32/menu/adminzone/structure.png',
            'themes/default/images/icons/64x64/menu/adminzone/structure.png',
            'themes/default/images/icons/24x24/menu/adminzone/style.png',
            'themes/default/images/icons/48x48/menu/adminzone/style.png',
            'themes/default/images/icons/32x32/menu/adminzone/style.png',
            'themes/default/images/icons/64x64/menu/adminzone/style.png',
            'themes/default/images/icons/24x24/menu/_generic_admin/sync.png',
            'themes/default/images/icons/48x48/menu/_generic_admin/sync.png',
            'themes/default/images/icons/24x24/menu/_generic_admin/xml.png',
            'themes/default/images/icons/48x48/menu/_generic_admin/xml.png',
            'themes/default/images/icons/24x24/menu/adminzone/tools.png',
            'themes/default/images/icons/48x48/menu/adminzone/tools.png',
            'themes/default/images/icons/32x32/menu/adminzone/tools.png',
            'themes/default/images/icons/64x64/menu/adminzone/tools.png',
            'themes/default/images/icons/24x24/tool_buttons/top.png',
            'themes/default/images/icons/48x48/tool_buttons/top.png',
            'themes/default/images/icons/24x24/buttons/upload.png',
            'themes/default/images/icons/48x48/buttons/upload.png',
            'themes/default/images/icons/64x64/menu/adminzone/audit.png',
            'themes/default/images/icons/24x24/menu/social/users_online.png',
            'themes/default/images/icons/48x48/menu/social/users_online.png',
            'themes/default/images/icons/24x24/menu/_generic_admin/view_archive.png',
            'themes/default/images/icons/48x48/menu/_generic_admin/view_archive.png',
            'themes/default/images/icons/24x24/menu/_generic_admin/view_this.png',
            'themes/default/images/icons/48x48/menu/_generic_admin/view_this.png',
            'themes/default/images/icons/24x24/menu/_generic_admin/view_this_category.png',
            'themes/default/images/icons/48x48/menu/_generic_admin/view_this_category.png',
            'themes/default/images/icons/24x24/tabs/settings.png',
            'themes/default/images/icons/48x48/tabs/settings.png',
            'themes/default/images/icons/24x24/menu/_generic_admin/import.png',
            'themes/default/images/icons/48x48/menu/_generic_admin/import.png',
            'themes/default/images/icons/24x24/buttons/yes.png',
            'themes/default/images/icons/48x48/buttons/yes.png',
            'themes/default/images/icons/24x24/links/print.png',
            'themes/default/images/icons/48x48/links/print.png',
            'themes/default/images/icons/24x24/links/rss.png',
            'themes/default/images/icons/48x48/links/rss.png',
            'themes/default/images/icons/24x24/menu/pages/help.png',
            'themes/default/images/icons/48x48/menu/pages/help.png',
            'themes/default/images/icons/24x24/menu/adminzone/structure/zones/zones.png',
            'themes/default/images/icons/48x48/menu/adminzone/structure/zones/zones.png',
            'themes/default/images/icons/24x24/index.html',
            'themes/default/images/icons/32x32/index.html',
            'themes/default/images/icons/48x48/index.html',
            'themes/default/images/icons/64x64/index.html',
            'themes/default/images/icons/24x24/buttons/index.html',
            'themes/default/images/icons/24x24/feedback/index.html',
            'themes/default/images/icons/24x24/links/index.html',
            'themes/default/images/icons/24x24/menu/adminzone/audit/index.html',
            'themes/default/images/icons/24x24/menu/adminzone/index.html',
            'themes/default/images/icons/24x24/menu/adminzone/security/index.html',
            'themes/default/images/icons/24x24/menu/adminzone/setup/config/index.html',
            'themes/default/images/icons/24x24/menu/adminzone/setup/index.html',
            'themes/default/images/icons/24x24/menu/adminzone/structure/index.html',
            'themes/default/images/icons/24x24/menu/adminzone/structure/sitemap/index.html',
            'themes/default/images/icons/24x24/menu/adminzone/structure/zones/index.html',
            'themes/default/images/icons/24x24/menu/adminzone/style/index.html',
            'themes/default/images/icons/24x24/menu/adminzone/style/themes/index.html',
            'themes/default/images/icons/24x24/menu/adminzone/tools/bulk_content_actions/index.html',
            'themes/default/images/icons/24x24/menu/adminzone/tools/index.html',
            'themes/default/images/icons/24x24/menu/adminzone/tools/users/index.html',
            'themes/default/images/icons/24x24/menu/cms/index.html',
            'themes/default/images/icons/24x24/menu/index.html',
            'themes/default/images/icons/24x24/menu/pages/index.html',
            'themes/default/images/icons/24x24/menu/rich_content/index.html',
            'themes/default/images/icons/24x24/menu/site_meta/index.html',
            'themes/default/images/icons/24x24/menu/site_meta/user_actions/index.html',
            'themes/default/images/icons/24x24/menu/social/index.html',
            'themes/default/images/icons/24x24/status/index.html',
            'themes/default/images/icons/24x24/tool_buttons/index.html',
            'themes/default/images/icons/48x48/buttons/index.html',
            'themes/default/images/icons/48x48/feedback/index.html',
            'themes/default/images/icons/48x48/links/index.html',
            'themes/default/images/icons/48x48/menu/adminzone/audit/index.html',
            'themes/default/images/icons/48x48/menu/adminzone/index.html',
            'themes/default/images/icons/48x48/menu/adminzone/security/index.html',
            'themes/default/images/icons/48x48/menu/adminzone/setup/config/index.html',
            'themes/default/images/icons/48x48/menu/adminzone/setup/index.html',
            'themes/default/images/icons/48x48/menu/adminzone/structure/index.html',
            'themes/default/images/icons/48x48/menu/adminzone/structure/sitemap/index.html',
            'themes/default/images/icons/48x48/menu/adminzone/structure/zones/index.html',
            'themes/default/images/icons/48x48/menu/adminzone/style/index.html',
            'themes/default/images/icons/48x48/menu/adminzone/style/themes/index.html',
            'themes/default/images/icons/48x48/menu/adminzone/tools/bulk_content_actions/index.html',
            'themes/default/images/icons/48x48/menu/adminzone/tools/index.html',
            'themes/default/images/icons/48x48/menu/adminzone/tools/users/index.html',
            'themes/default/images/icons/48x48/menu/cms/index.html',
            'themes/default/images/icons/48x48/menu/index.html',
            'themes/default/images/icons/48x48/menu/pages/index.html',
            'themes/default/images/icons/48x48/menu/rich_content/index.html',
            'themes/default/images/icons/48x48/menu/site_meta/index.html',
            'themes/default/images/icons/48x48/menu/site_meta/user_actions/index.html',
            'themes/default/images/icons/48x48/menu/social/index.html',
            'themes/default/images/icons/48x48/status/index.html',
            'themes/default/images/icons/48x48/tool_buttons/index.html',
            'themes/default/images/icons/24x24/buttons/calculate.png',
            'themes/default/images/icons/24x24/buttons/save.png',
            'themes/default/images/icons/24x24/buttons/send.png',
            'themes/default/images/icons/24x24/buttons/sort.png',
            'themes/default/images/icons/24x24/buttons/proceed.png',
            'themes/default/images/icons/24x24/buttons/copy.png', // Perform a 'copy' action on the same screen, variation of "proceed"
            'themes/default/images/icons/24x24/buttons/vote.png',
            'themes/default/images/icons/48x48/buttons/calculate.png',
            'themes/default/images/icons/48x48/buttons/save.png',
            'themes/default/images/icons/48x48/buttons/send.png',
            'themes/default/images/icons/48x48/buttons/sort.png',
            'themes/default/images/icons/48x48/buttons/proceed.png',
            'themes/default/images/icons/48x48/buttons/copy.png',
            'themes/default/images/icons/48x48/buttons/vote.png',
            'themes/default/images/icons/24x24/buttons/gotopage.png',
            'themes/default/images/icons/24x24/buttons/perpage.png',
            'themes/default/images/icons/24x24/buttons/skip.png',
            'themes/default/images/icons/48x48/buttons/gotopage.png',
            'themes/default/images/icons/48x48/buttons/perpage.png',
            'themes/default/images/icons/48x48/buttons/skip.png',
            'themes/default/images/icons/32x32/menu/index.html',
            'themes/default/images/icons/32x32/menu/adminzone/index.html',
            'themes/default/images/icons/32x32/menu/cms/index.html',
            'themes/default/images/icons/64x64/menu/index.html',
            'themes/default/images/icons/64x64/menu/adminzone/index.html',
            'themes/default/images/icons/64x64/menu/cms/index.html',
            'themes/default/images/icons/index.html',
            'themes/default/images/1x/boxless_title_leadin_leftcomp.png',
            'themes/default/images/1x/boxless_title_leadin_rightcomp.png',
            'themes/default/images/1x/breadcrumbs.png',
            'themes/default/images/icons/16x16/close.png',
            'themes/default/images/icons/16x16/help.png',
            'themes/default/images/1x/index.html',
            'themes/default/images/icons/14x14/rating.png',
            'themes/default/images/icons/28x28/rating.png',
            'themes/default/images/1x/trays/contract.png',
            'themes/default/images/1x/trays/expand.png',
            'themes/default/images/1x/trays/expcon.png',
            'themes/default/images/1x/trays/contract2.png',
            'themes/default/images/1x/trays/expand2.png',
            'themes/default/images/1x/trays/expcon2.png',
            'themes/default/images/1x/trays/index.html',
            'themes/default/images/2x/trays/contract.png',
            'themes/default/images/2x/trays/expand.png',
            'themes/default/images/2x/trays/expcon.png',
            'themes/default/images/2x/trays/contract2.png',
            'themes/default/images/2x/trays/expand2.png',
            'themes/default/images/2x/trays/expcon2.png',
            'themes/default/images/2x/trays/index.html',
            'themes/default/images/2x/boxless_title_leadin_leftcomp.png',
            'themes/default/images/2x/boxless_title_leadin_rightcomp.png',
            'themes/default/images/2x/breadcrumbs.png',
            'themes/default/images/icons/32x32/close.png',
            'themes/default/images/icons/32x32/help.png',
            'themes/default/images/2x/index.html',
            'themes/default/images/banner_frame.png',
            'themes/default/images/icons/14x14/add.png',
            'themes/default/images/icons/14x14/edit2.png',
            'themes/default/images/icons/14x14/export.png',
            'themes/default/images/icons/14x14/proceed.png',
            'themes/default/images/icons/14x14/remove.png',
            'themes/default/images/icons/14x14/remove_manage.png',
            'themes/default/images/icons/14x14/tools.png',
            'themes/default/images/icons/28x28/add.png',
            'themes/default/images/icons/28x28/edit2.png',
            'themes/default/images/icons/28x28/export.png',
            'themes/default/images/icons/28x28/proceed.png',
            'themes/default/images/icons/28x28/remove.png',
            'themes/default/images/icons/28x28/remove_manage.png',
            'themes/default/images/icons/28x28/tools.png',
            'sources/hooks/systems/resource_meta_aware/.htaccess',
            'sources_custom/hooks/systems/resource_meta_aware/.htaccess',
            'sources/hooks/systems/resource_meta_aware/index.html',
            'sources_custom/hooks/systems/resource_meta_aware/index.html',
            'sources/hooks/systems/commandr_fs_extended_member/group_timeouts.php',
            'sources/block_add.php',
            'themes/default/css/carousels.css',
            'themes/default/css/adminzone.css',
            'themes/default/templates/BLOCK_MAIN_CONTENT.tpl',
            'themes/default/templates/BLOCK_MAIN_MULTI_CONTENT.tpl',
            'sources/blocks/main_content.php',
            'sources/blocks/main_multi_content.php',
            'themes/default/images/icons/14x14/action_small.png',
            'themes/default/images/icons/28x28/action_small.png',
            'sources/hooks/systems/symbols/BETA_CSS_PROPERTY.php',
            'sources/antispam.php',
            'sources/static_cache.php',
            'sources/hooks/systems/notifications/spam_check_block.php',
            'sources/hooks/systems/notifications/low_disk_space.php',
            'sources/hooks/systems/notifications/hack_attack.php',
            'sources/hooks/systems/notifications/auto_ban.php',
            'sources/hooks/systems/notifications/error_occurred.php',
            'sources/hooks/systems/notifications/error_occurred_missing_resource.php',
            'sources/hooks/systems/notifications/error_occurred_missing_page.php',
            'sources/hooks/systems/notifications/error_occurred_cron.php',
            'sources/hooks/systems/notifications/error_occurred_missing_reference.php',
            'sources/hooks/systems/notifications/error_occurred_missing_reference_important.php',
            'sources/hooks/systems/notifications/adminzone_dashboard_accessed.php',
            'sources/hooks/systems/disposable_values/page_views.php',
            'sources/password_strength.php',
            'sources/hooks/systems/snippets/password_strength.php',
            'sources/hooks/blocks/main_staff_checklist/version.php',
            'sources/hooks/systems/sitemap/.htaccess',
            'sources_custom/hooks/systems/sitemap/.htaccess',
            'sources/hooks/systems/sitemap/index.html',
            'sources_custom/hooks/systems/sitemap/index.html',
            'sources/hooks/systems/sitemap/root.php',
            'sources/hooks/systems/sitemap/page.php',
            'sources/hooks/systems/sitemap/page_grouping.php',
            'sources/hooks/systems/sitemap/zone.php',
            'sources/hooks/systems/sitemap/entry_point.php',
            'web.config',
            'data_custom/execute_temp.php.bundle',
            'data/html5.js', // LEGACY
            'data/external_url_proxy.php',
            'adminzone/.htaccess',
            'themes/default/images/no_image.png',
            'themes/default/css/install.css',
            'lang/EN/installer.ini',
            'lang/EN/encryption.ini',
            'sources/json.php',
            'sources/json_inner.php',
            'sources/locations.php',
            'sources/locations_geocoding.php',
            'sources/locations_cpfs.php',
            'sources/hooks/systems/cns_cpf_filter/options.php',
            'sources/cpf_install.php',
            'sources/hooks/systems/symbols/COUNTRY.php',
            'sources/hooks/systems/symbols/COUNTRY_CODE_TO_NAME.php',
            'sources/hooks/systems/symbols/COUNTRY_NAME_TO_CODE.php',
            'sources/hooks/systems/symbols/CURRENCY.php',
            'sources/hooks/systems/symbols/REGION.php',
            'lang/EN/locations.ini',
            'data/geocode.php',
            'sources/web_resources.php',
            'sources/hooks/systems/cron/git_autopull.php',
            'sources/hooks/systems/cron/dynamic_firewall.php',
            'data_custom/firewall_rules.txt',
            'sources/hooks/systems/cron/group_member_timeouts.php',
            'sources/group_member_timeouts.php',
            'adminzone/pages/modules/admin_group_member_timeouts.php',
            'lang/EN/group_member_timeouts.ini',
            'themes/default/templates/GROUP_MEMBER_TIMEOUT_MANAGE_SCREEN.tpl',
            'sources/inst_special.php',
            'sources/actionlog.php',
            'themes/admin/javascript/.htaccess',
            'themes/admin/javascript/index.html',
            'themes/admin/text/.htaccess',
            'themes/admin/text/index.html',
            'themes/admin/xml/.htaccess',
            'themes/admin/xml/index.html',
            'themes/default/javascript/.htaccess',
            'themes/default/javascript/index.html',
            'themes/default/text/.htaccess',
            'themes/default/text/index.html',
            'themes/default/xml/.htaccess',
            'themes/default/xml/index.html',
            'data/no_banning.txt',
            'data/editarea/edit_area.css',
            'data/editarea/edit_area_compressor.php',
            'data/editarea/edit_area_full.js',
            'data/editarea/images/autocompletion.gif',
            'data/editarea/images/close.gif',
            'data/editarea/images/fullscreen.gif',
            'data/editarea/images/go_to_line.gif',
            'data/editarea/images/help.gif',
            'data/editarea/images/highlight.gif',
            'data/editarea/images/index.html',
            'data/editarea/images/load.gif',
            'data/editarea/images/move.gif',
            'data/editarea/images/newdocument.gif',
            'data/editarea/images/opacity.png',
            'data/editarea/images/processing.gif',
            'data/editarea/images/redo.gif',
            'data/editarea/images/reset_highlight.gif',
            'data/editarea/images/save.gif',
            'data/editarea/images/search.gif',
            'data/editarea/images/smooth_selection.gif',
            'data/editarea/images/spacer.gif',
            'data/editarea/images/statusbar_resize.gif',
            'data/editarea/images/undo.gif',
            'data/editarea/images/word_wrap.gif',
            'data/editarea/index.html',
            'data/editarea/langs/bg.js',
            'data/editarea/langs/cs.js',
            'data/editarea/langs/de.js',
            'data/editarea/langs/dk.js',
            'data/editarea/langs/en.js',
            'data/editarea/langs/eo.js',
            'data/editarea/langs/es.js',
            'data/editarea/langs/fi.js',
            'data/editarea/langs/fr.js',
            'data/editarea/langs/hr.js',
            'data/editarea/langs/index.html',
            'data/editarea/langs/it.js',
            'data/editarea/langs/ja.js',
            'data/editarea/langs/mk.js',
            'data/editarea/langs/nl.js',
            'data/editarea/langs/pl.js',
            'data/editarea/langs/pt.js',
            'data/editarea/langs/ru.js',
            'data/editarea/langs/sk.js',
            'data/editarea/langs/zh.js',
            'data/editarea/license_bsd.txt',
            'data/editarea/reg_syntax/css.js',
            'data/editarea/reg_syntax/html.js',
            'data/editarea/reg_syntax/js.js',
            'data/editarea/reg_syntax/php.js',
            'data/editarea/reg_syntax/xml.js',
            'data/editarea/template.html',
            'sources/hooks/systems/meta/index.html',
            'sources_custom/hooks/systems/meta/index.html',
            'uploads/website_specific/index.html',
            'sources/hooks/systems/upon_page_load/index.html',
            'sources_custom/hooks/systems/upon_page_load/index.html',
            'sources/hooks/systems/upon_access_denied/index.html',
            'sources_custom/hooks/systems/upon_access_denied/index.html',
            'sources/hooks/systems/upon_query/index.html',
            'sources_custom/hooks/systems/upon_query/index.html',
            'sources/hooks/systems/upon_login/index.html',
            'sources_custom/hooks/systems/upon_login/index.html',
            'sources/hooks/systems/login_providers/.htaccess',
            'sources_custom/hooks/systems/login_providers/.htaccess',
            'sources/hooks/systems/login_providers/index.html',
            'sources_custom/hooks/systems/login_providers/index.html',
            'sources/hooks/systems/login_providers/httpauth.php',
            'data/question_ui.php',
            'data/crossdomain.php',
            'data_custom/.htaccess',
            'data/xml_config/.htaccess',
            'data/xml_config/index.html',
            'data_custom/xml_config/.htaccess',
            'data_custom/xml_config/index.html',
            'sources/firephp.php',
            'sources/content.php',
            'sources/content2.php',
            'lang/EN/metadata.ini',
            'adminzone/find_permissions.php',
            'themes/default/javascript/sound.js',
            'data/sounds/message_background.mp3',
            'data/sounds/message_received.mp3',
            'themes/default/templates/INLINE_WIP_MESSAGE.tpl',
            'themes/default/images_custom/.htaccess',
            'themes/default/templates_cached/.htaccess',
            'themes/default/images_custom/index.html',
            'themes/default/images/help_jumpout.png',
            'themes/default/images/messageicons/index.html',
            'themes/default/images/messageicons/inform_large.png',
            'themes/default/images/messageicons/warn_large.png',
            'themes/default/images/arrow_ruler.png',
            'themes/default/images/arrow_ruler_small.png',
            'themes/default/images/outer_background.jpg',
            'themes/default/images/inner_background.jpg',
            'themes/default/images/block_background.png',
            'pages/comcode/EN/panel_top.txt',
            'pages/comcode/EN/panel_bottom.txt',
            'lang/EN/dearchive.ini',
            'sources/selectcode.php',
            'sources/filtercode.php',
            'lang/EN/filtercode.ini',
            'sources/mail_dkim.php',
            'sources/blocks/main_content_filtering.php',
            'sources/lang_stemmer_EN.php',
            'sources/lang_filter_EN.php',
            'themes/default/templates/MISSING_SCREEN.tpl',
            'themes/default/templates/PARAM_INFO.tpl',
            'sources/profiler.php',
            'sources/temporal.php',
            'sources/temporal2.php',
            'sources/blocks/main_comcode_page_children.php',
            'sources/blocks/main_include_module.php',
            'themes/default/images/icons/16x16/filetypes/email_link.png',
            'themes/default/images/icons/16x16/filetypes/external_link.png',
            'themes/default/images/icons/16x16/filetypes/feed.png',
            'themes/default/images/icons/16x16/filetypes/index.html',
            'themes/default/images/icons/16x16/filetypes/page_archive.png',
            'themes/default/images/icons/16x16/filetypes/page_doc.png',
            'themes/default/images/icons/16x16/filetypes/page_media.png',
            'themes/default/images/icons/16x16/filetypes/page_odp.png',
            'themes/default/images/icons/16x16/filetypes/page_ods.png',
            'themes/default/images/icons/16x16/filetypes/page_odt.png',
            'themes/default/images/icons/16x16/filetypes/page_pdf.png',
            'themes/default/images/icons/16x16/filetypes/page_ppt.png',
            'themes/default/images/icons/16x16/filetypes/page_torrent.png',
            'themes/default/images/icons/16x16/filetypes/page_txt.png',
            'themes/default/images/icons/16x16/filetypes/page_xls.png',
            'themes/default/images/icons/32x32/filetypes/email_link.png',
            'themes/default/images/icons/32x32/filetypes/external_link.png',
            'themes/default/images/icons/32x32/filetypes/feed.png',
            'themes/default/images/icons/32x32/filetypes/index.html',
            'themes/default/images/icons/32x32/filetypes/page_archive.png',
            'themes/default/images/icons/32x32/filetypes/page_doc.png',
            'themes/default/images/icons/32x32/filetypes/page_media.png',
            'themes/default/images/icons/32x32/filetypes/page_odp.png',
            'themes/default/images/icons/32x32/filetypes/page_ods.png',
            'themes/default/images/icons/32x32/filetypes/page_odt.png',
            'themes/default/images/icons/32x32/filetypes/page_pdf.png',
            'themes/default/images/icons/32x32/filetypes/page_ppt.png',
            'themes/default/images/icons/32x32/filetypes/page_torrent.png',
            'themes/default/images/icons/32x32/filetypes/page_txt.png',
            'themes/default/images/icons/32x32/filetypes/page_xls.png',
            'data/autosave.php',
            'sources/hooks/systems/addon_registry/core.php',
            'sources/hooks/modules/video_syndication/.htaccess',
            'sources_custom/hooks/modules/video_syndication/.htaccess',
            'sources/hooks/modules/video_syndication/index.html',
            'sources_custom/hooks/modules/video_syndication/index.html',
            'sources/hooks/systems/activities/.htaccess',
            'sources_custom/hooks/systems/activities/.htaccess',
            'sources/hooks/systems/activities/index.html',
            'sources_custom/hooks/systems/activities/index.html',
            'sources/hooks/systems/cdn_transfer/.htaccess',
            'sources_custom/hooks/systems/cdn_transfer/.htaccess',
            'sources/hooks/systems/cdn_transfer/index.html',
            'sources_custom/hooks/systems/cdn_transfer/index.html',
            'sources/hooks/systems/login_providers_direct_auth/.htaccess',
            'sources_custom/hooks/systems/login_providers_direct_auth/.htaccess',
            'sources/hooks/systems/login_providers_direct_auth/index.html',
            'sources_custom/hooks/systems/login_providers_direct_auth/index.html',
            'sources/hooks/systems/referrals/.htaccess',
            'sources_custom/hooks/systems/referrals/.htaccess',
            'sources/hooks/systems/referrals/index.html',
            'sources_custom/hooks/systems/referrals/index.html',
            'sources/hooks/systems/syndication/.htaccess',
            'sources_custom/hooks/systems/syndication/.htaccess',
            'sources/hooks/systems/syndication/index.html',
            'sources_custom/hooks/systems/syndication/index.html',
            'sources/hooks/systems/upload_syndication/.htaccess',
            'sources_custom/hooks/systems/upload_syndication/.htaccess',
            'sources/hooks/systems/upload_syndication/index.html',
            'sources_custom/hooks/systems/upload_syndication/index.html',
            'sources/hooks/systems/non_active_urls/.htaccess',
            'sources_custom/hooks/systems/non_active_urls/.htaccess',
            'sources/hooks/systems/non_active_urls/index.html',
            'sources_custom/hooks/systems/non_active_urls/index.html',
            'sources/hooks/systems/addon_registry/index.html',
            'sources_custom/hooks/systems/addon_registry/index.html',
            'sources/hooks/blocks/main_notes/.htaccess',
            'sources_custom/hooks/blocks/main_notes/.htaccess',
            'sources/hooks/blocks/main_notes/index.html',
            'sources_custom/hooks/blocks/main_notes/index.html',
            'sources/hooks/systems/chmod/.htaccess',
            'sources_custom/hooks/systems/chmod/.htaccess',
            'sources/hooks/systems/chmod/index.html',
            'sources_custom/hooks/systems/chmod/index.html',
            'sources/hooks/systems/disposable_values/.htaccess',
            'sources_custom/hooks/systems/disposable_values/.htaccess',
            'sources/hooks/systems/disposable_values/index.html',
            'sources_custom/hooks/systems/disposable_values/index.html',
            'sources/hooks/systems/symbols/.htaccess',
            'sources_custom/hooks/systems/symbols/.htaccess',
            'sources/hooks/systems/symbols/index.html',
            'sources_custom/hooks/systems/symbols/index.html',
            'sources/url_remappings.php',
            'sources/hooks/systems/addon_registry/.htaccess',
            'sources_custom/hooks/systems/addon_registry/.htaccess',
            'sources/activities.php',
            'sources/crypt.php',
            'sources/crypt_master.php',
            'data_custom/sitemaps/index.html',
            'themes/default/templates/JS_BLOCK.tpl',
            'themes/default/javascript/modernizr.js',
            'themes/default/javascript/jquery.js',
            'themes/default/javascript/jquery_ui.js',
            'themes/default/images/jquery_ui/index.html',
            'themes/default/images/jquery_ui/ui-bg_flat_0_aaaaaa_40x100.png',
            'themes/default/images/jquery_ui/ui-bg_flat_75_ffffff_40x100.png',
            'themes/default/images/jquery_ui/ui-bg_glass_55_fbf9ee_1x400.png',
            'themes/default/images/jquery_ui/ui-bg_glass_75_dadada_1x400.png',
            'themes/default/images/jquery_ui/ui-bg_glass_75_e6e6e6_1x400.png',
            'themes/default/images/jquery_ui/ui-bg_glass_95_fef1ec_1x400.png',
            'themes/default/images/jquery_ui/ui-bg_glass_65_ffffff_1x400.png',
            'themes/default/images/jquery_ui/ui-icons_222222_256x240.png',
            'themes/default/images/jquery_ui/ui-bg_highlight-soft_75_cccccc_1x100.png',
            'themes/default/images/jquery_ui/ui-icons_2e83ff_256x240.png',
            'themes/default/images/jquery_ui/ui-icons_454545_256x240.png',
            'themes/default/images/jquery_ui/ui-icons_888888_256x240.png',
            'themes/default/images/jquery_ui/ui-icons_cd0a0a_256x240.png',
            'themes/default/css/jquery_ui.css',
            'themes/default/javascript/global.js',
            'themes/default/javascript/ajax.js',
            'themes/default/templates/JAVASCRIPT_NEED.tpl',
            'themes/default/templates/JAVASCRIPT_NEED_FULL.tpl',
            'themes/default/templates/JAVASCRIPT_NEED_INLINE.tpl',
            'themes/default/templates/CSS_NEED.tpl',
            'themes/default/templates/CSS_NEED_FULL.tpl',
            'themes/default/templates/CSS_NEED_INLINE.tpl',
            'themes/default/javascript/staff.js',
            'themes/default/javascript/transitions.js',
            'themes/default/javascript/tree_list.js',
            'themes/default/javascript/xsl_mopup.js',
            'themes/default/templates/BLOCK_SIDE_PERSONAL_STATS.tpl',
            'themes/default/templates/BLOCK_SIDE_PERSONAL_STATS_LINE.tpl',
            'themes/default/templates/BLOCK_SIDE_PERSONAL_STATS_LINE_COMPLEX.tpl',
            'themes/default/templates/BLOCK_SIDE_PERSONAL_STATS_LINK.tpl',
            'themes/default/templates/BLOCK_SIDE_PERSONAL_STATS_LINK_2.tpl',
            'themes/default/templates/BLOCK_SIDE_PERSONAL_STATS_LOGOUT.tpl',
            'themes/default/templates/BLOCK_SIDE_PERSONAL_STATS_NO.tpl',
            'themes/default/templates/BLOCK_TOP_LOGIN.tpl',
            'themes/default/templates/BLOCK_TOP_PERSONAL_STATS.tpl',
            'themes/default/templates/BLOCK_MAIN_CONTENT_FILTERING.tpl',
            'themes/default/templates/REDIRECT_POST_METHOD_SCREEN.tpl',
            'themes/default/templates/LOGIN_SCREEN.tpl',
            'themes/default/css/login.css',
            'themes/default/templates/BROKEN_LANG_STRINGS.tpl',
            'themes/default/templates/BROKEN_URLS.tpl',
            'themes/default/templates/FORUMS_EMBED.tpl',
            'themes/default/templates/ACTIONLOGS_SCREEN.tpl',
            'themes/default/templates/ACTIONLOGS_TOGGLE_LINK.tpl',
            'themes/default/templates/FORUM_ATTACHMENT_IMAGE.tpl',
            'themes/default/templates/FORUM_ATTACHMENT_IMAGE_THUMB.tpl',
            'themes/default/templates/FORUM_ATTACHMENT_LINK.tpl',
            'themes/default/templates/LOOKUP_IP_LIST_ENTRY.tpl',
            'themes/default/templates/LOOKUP_SCREEN.tpl',
            'themes/default/templates/FATAL_SCREEN.tpl',
            'themes/default/templates/STACK_TRACE.tpl',
            'themes/default/templates/BLOCK_MAIN_EMOTICON_CODES.tpl',
            'themes/default/templates/BLOCK_NO_ENTRIES.tpl',
            'adminzone/index.php',
            'adminzone/pages/comcode/.htaccess',
            'adminzone/pages/comcode/EN/.htaccess',
            'adminzone/pages/comcode/EN/index.html',
            'adminzone/pages/comcode/EN/start.txt',
            'adminzone/pages/comcode/index.html',
            'adminzone/pages/comcode_custom/.htaccess',
            'adminzone/pages/comcode_custom/EN/.htaccess',
            'adminzone/pages/comcode_custom/EN/index.html',
            'adminzone/pages/comcode_custom/index.html',
            'adminzone/pages/html/.htaccess',
            'adminzone/pages/html/EN/.htaccess',
            'adminzone/pages/html/EN/index.html',
            'adminzone/pages/html/index.html',
            'adminzone/pages/html_custom/EN/index.html',
            'adminzone/pages/html_custom/index.html',
            'adminzone/pages/html_custom/EN/.htaccess',
            'adminzone/pages/index.html',
            'adminzone/pages/minimodules/.htaccess',
            'adminzone/pages/minimodules/index.html',
            'adminzone/pages/minimodules_custom/.htaccess',
            'adminzone/pages/minimodules_custom/index.html',
            'adminzone/pages/modules/.htaccess',
            'adminzone/pages/modules/admin.php',
            'themes/default/images/keyboard.png',
            'sources/sitemap.php',
            'sources/sitemap_ajax.php',
            'sources/sitemap_xml.php',
            'sources/hooks/systems/tasks/sitemap.php',
            'sources/hooks/systems/cron/sitemap.php',
            'themes/default/templates/IP_BAN_SCREEN.tpl',
            'themes/default/templates/LOOKUP_IP_LIST_GROUP.tpl',
            'themes/default/templates/BLOCK_MAIN_COMCODE_PAGE_CHILDREN.tpl',
            'adminzone/pages/modules/admin_version.php',
            'adminzone/pages/modules/index.html',
            'adminzone/pages/modules_custom/.htaccess',
            'adminzone/pages/modules_custom/index.html',
            'text/.htaccess',
            'text/bots.txt',
            'text/EN/.htaccess',
            'text/EN/index.html',
            'text/EN/licence.txt',
            'text/EN/too_common_words.txt',
            'text/EN/word_characters.txt',
            'text/EN/synonyms.txt',
            'text/index.html',
            'text_custom/.htaccess',
            'text_custom/EN/.htaccess',
            'text_custom/EN/index.html',
            'text_custom/index.html',
            'safe_mode_temp/.htaccess',
            'safe_mode_temp/index.html',
            'config_editor.php',
            'index.php',
            '_config.php',
            'uploads/auto_thumbs/index.html',
            'uploads/auto_thumbs/.htaccess',
            'exports/file_backups/.htaccess',
            'uploads/index.html',
            'sources/xml.php',
            'sources_custom/.htaccess',
            'sources_custom/blocks/.htaccess',
            'sources_custom/blocks/index.html',
            'sources_custom/hooks/.htaccess',
            'sources_custom/hooks/index.html',
            'sources_custom/index.html',
            'sources_custom/miniblocks/.htaccess',
            'sources_custom/miniblocks/index.html',
            'lang/index.html',
            'lang/langs.ini',
            'lang/map.ini',
            'caches/.htaccess',
            'caches/index.html',
            'caches/lang/.htaccess',
            'caches/lang/index.html',
            'caches/lang/EN/.htaccess',
            'caches/lang/EN/index.html',
            'caches/guest_pages/.htaccess',
            'caches/guest_pages/index.html',
            'caches/self_learning/.htaccess',
            'caches/self_learning/index.html',
            'lang_custom/.htaccess',
            'lang_custom/EN/.htaccess',
            'lang_custom/EN/index.html',
            'lang_custom/index.html',
            'themes/default/css/sitemap_editor.css',
            'themes/default/css/global.css',
            'themes/default/css/email.css',
            'themes/default/css/font_sizer.css',
            'themes/default/templates/FONT_SIZER.tpl',
            'themes/default/css/index.html',
            'themes/default/css/.htaccess',
            'themes/default/css/no_cache.css',
            'data/editarea/reg_syntax/index.html',
            'themes/default/css_custom/index.html',
            'themes/default/css_custom/.htaccess',
            'themes/default/index.html',
            'themes/default/templates/.htaccess',
            'themes/default/templates/index.html',
            'themes/default/templates_cached/EN/index.html',
            'themes/default/templates_cached/index.html',
            'themes/default/templates_custom/.htaccess',
            'themes/default/templates_custom/index.html',
            'themes/default/javascript_custom/.htaccess',
            'themes/default/javascript_custom/index.html',
            'themes/default/xml_custom/.htaccess',
            'themes/default/xml_custom/index.html',
            'themes/default/text_custom/.htaccess',
            'themes/default/text_custom/index.html',
            'themes/default/theme.ini',
            'themes/admin/theme.ini',
            'themes/index.html',
            'themes/map.ini',
            'sources/hooks/systems/module_permissions/.htaccess',
            'sources_custom/hooks/systems/module_permissions/.htaccess',
            'sources/hooks/systems/module_permissions/forums.php',
            'sources/hooks/systems/module_permissions/index.html',
            'sources_custom/hooks/systems/module_permissions/index.html',
            'lang/EN/permissions.ini',
            'sources/permissions.php',
            'sources/permissions2.php',
            'sources/hooks/systems/block_ui_renderers/.htaccess',
            'sources_custom/hooks/systems/block_ui_renderers/.htaccess',
            'sources/hooks/systems/block_ui_renderers/index.html',
            'sources_custom/hooks/systems/block_ui_renderers/index.html',
            'themes/default/images/1x/arrow_box.png',
            'themes/default/images/1x/arrow_box_hover.png',
            'themes/default/images/2x/arrow_box.png',
            'themes/default/images/2x/arrow_box_hover.png',
            'themes/default/images/background_image.png',
            'themes/default/images/blank.gif',
            'themes/default/images/loading.gif',
            'themes/default/images/1x/edited.png',
            'themes/default/images/2x/edited.png',
            'themes/default/images/icons/14x14/action_link.png',
            'themes/default/images/icons/28x28/action_link.png',
            'themes/default/images/1x/cannot_show.png',
            'themes/default/images/2x/cannot_show.png',
            'themes/default/images/icons/16x16/editor/comcode.png',
            'themes/default/images/icons/32x32/editor/comcode.png',
            'themes/default/images/EN/index.html',
            'themes/default/images/EN/logo/-logo.png',
            'themes/default/images/EN/logo/index.html',
            'themes/default/images/EN/logo/standalone_logo.png',
            'themes/default/images/icons/14x14/helper_panel_hide.png',
            'themes/default/images/icons/14x14/helper_panel_show.png',
            'themes/default/images/icons/28x28/helper_panel_hide.png',
            'themes/default/images/icons/28x28/helper_panel_show.png',
            'themes/default/images/index.html',
            'themes/default/images/led_off.png',
            'themes/default/images/led_on.png',
            'themes/default/images/na.png',
            'themes/default/images/poll/index.html',
            'themes/default/images/poll/poll_l.png',
            'themes/default/images/poll/poll_m.png',
            'themes/default/images/poll/poll_r.png',
            'themes/default/images/1x/box_arrow.png',
            'themes/default/images/2x/box_arrow.png',
            'themes/default/images/results/index.html',
            'themes/default/images/results/sortablefield_asc.png',
            'themes/default/images/results/sortablefield_desc.png',
            'themes/default/images/results/sortablefield_asc_nonselected.png',
            'themes/default/images/results/sortablefield_desc_nonselected.png',
            'themes/default/images/gradient.png',
            'themes/default/images/tab.png',
            'themes/default/images/icons/14x14/index.html',
            'themes/default/images/icons/14x14/delete.png',
            'themes/default/images/icons/14x14/download.png',
            'themes/default/images/icons/14x14/edit.png',
            'themes/default/images/icons/28x28/index.html',
            'themes/default/images/icons/28x28/delete.png',
            'themes/default/images/icons/28x28/download.png',
            'themes/default/images/icons/28x28/edit.png',
            'sources/hooks/systems/startup/index.html',
            'sources_custom/hooks/systems/startup/index.html',
            'data/confirm_session.php',
            'data/cron_bridge.php',
            'data/cron_bridge.sh',
            'data/curl-ca-bundle.crt',
            'data/db_meta.bin',
            'data/empty.html',
            'data/files.bin',
            'data/files_previous.bin',
            'data/guids.bin',
            'data/iframe.php',
            'data/images/index.html',
            'data/images/.htaccess',
            'data_custom/images/index.html',
            'data_custom/images/.htaccess',
            'data/index.html',
            'data/javascript.php',
            'data/modules/index.html',
            'data/page_link_redirect.php',
            'data/quash_referer.php',
            'data/sheet.php',
            'data/script.php',
            'data/sitemap.php',
            'data/snippet.php',
            'data/soundmanager/soundmanager2.swf',
            'data/soundmanager/soundmanager2_flash9.swf',
            'data/soundmanager/soundmanager2_flash9_debug.swf',
            'data/soundmanager/soundmanager2_debug.swf',
            'data/soundmanager/index.html',
            'data/sounds/index.html',
            'data_custom/execute_temp.php',
            'data_custom/functions.bin',
            'data_custom/index.html',
            'data_custom/modules/index.html',
            'cms/index.php',
            'cms/pages/comcode/.htaccess',
            'cms/pages/comcode/EN/.htaccess',
            'cms/pages/comcode/EN/index.html',
            'cms/pages/comcode/index.html',
            'cms/pages/comcode_custom/.htaccess',
            'cms/pages/comcode_custom/EN/.htaccess',
            'cms/pages/comcode_custom/EN/index.html',
            'cms/pages/comcode_custom/index.html',
            'cms/pages/html/.htaccess',
            'cms/pages/html/EN/.htaccess',
            'cms/pages/html/EN/index.html',
            'cms/pages/html/index.html',
            'cms/pages/html_custom/EN/.htaccess',
            'cms/pages/html_custom/EN/index.html',
            'cms/pages/html_custom/index.html',
            'cms/pages/index.html',
            'cms/pages/minimodules/.htaccess',
            'cms/pages/minimodules/index.html',
            'cms/pages/minimodules_custom/.htaccess',
            'cms/pages/minimodules_custom/index.html',
            'cms/pages/modules/.htaccess',
            'cms/pages/modules/cms.php',
            'cms/pages/modules/index.html',
            'cms/pages/modules_custom/.htaccess',
            'cms/pages/modules_custom/index.html',
            'lang/.htaccess',
            'lang/EN/.htaccess',
            'lang/EN/abstract_file_manager.ini',
            'lang/EN/blocks.ini',
            'lang/EN/critical_error.ini',
            'lang/EN/dates.ini',
            'lang/EN/debrand.ini',
            'lang/EN/do_next.ini',
            'lang/EN/global.ini',
            'lang/EN/index.html',
            'lang/EN/javascript.ini',
            'lang/EN/lang.ini',
            'lang/EN/mail.ini',
            'lang/EN/profiling.ini',
            'lang/EN/version.ini',
            'lang/EN/zones.ini',
            'pages/comcode/.htaccess',
            'pages/comcode/EN/.htaccess',
            'pages/comcode/EN/404.txt',
            'pages/comcode/EN/index.html',
            'pages/comcode/EN/keymap.txt',
            'pages/comcode/EN/panel_left.txt',
            'pages/comcode/EN/panel_right.txt',
            'pages/comcode/EN/privacy.txt',
            'pages/comcode/EN/_rules.txt',
            'pages/comcode/EN/rules.txt',
            'pages/comcode/EN/sitemap.txt',
            'pages/comcode/EN/start.txt',
            'pages/comcode/index.html',
            'pages/comcode_custom/.htaccess',
            'pages/comcode_custom/EN/.htaccess',
            'pages/comcode_custom/EN/index.html',
            'pages/comcode_custom/index.html',
            'pages/html/.htaccess',
            'pages/html/EN/.htaccess',
            'pages/html/EN/index.html',
            'pages/html/index.html',
            'pages/html_custom/EN/.htaccess',
            'pages/html_custom/EN/index.html',
            'pages/html_custom/index.html',
            'pages/index.html',
            'pages/minimodules/.htaccess',
            'pages/minimodules/index.html',
            'pages/minimodules_custom/.htaccess',
            'pages/minimodules_custom/index.html',
            'pages/modules/.htaccess',
            'pages/modules/forums.php',
            'pages/modules/index.html',
            'pages/modules/login.php',
            'pages/modules_custom/.htaccess',
            'pages/modules_custom/index.html',
            'site/index.php',
            'site/pages/comcode/.htaccess',
            'site/pages/comcode/EN/.htaccess',
            'site/pages/comcode/EN/index.html',
            'site/pages/comcode/EN/panel_left.txt',
            'site/pages/comcode/EN/panel_right.txt',
            'site/pages/comcode/EN/start.txt',
            'site/pages/comcode/EN/userguide_comcode.txt',
            'site/pages/comcode/index.html',
            'site/pages/comcode_custom/.htaccess',
            'site/pages/comcode_custom/EN/.htaccess',
            'site/pages/comcode_custom/EN/index.html',
            'site/pages/comcode_custom/index.html',
            'site/pages/html/.htaccess',
            'site/pages/html/EN/.htaccess',
            'site/pages/html/EN/index.html',
            'site/pages/html/index.html',
            'site/pages/html_custom/EN/.htaccess',
            'site/pages/html_custom/EN/index.html',
            'site/pages/html_custom/index.html',
            'site/pages/index.html',
            'site/pages/minimodules/.htaccess',
            'site/pages/minimodules/index.html',
            'site/pages/minimodules_custom/.htaccess',
            'site/pages/minimodules_custom/index.html',
            'site/pages/modules/.htaccess',
            'site/pages/modules/index.html',
            'site/pages/modules_custom/.htaccess',
            'site/pages/modules_custom/index.html',
            'sources/.htaccess',
            'sources/abstract_file_manager.php',
            'sources/crud_module.php',
            'sources/ajax.php',
            'sources/blocks/.htaccess',
            'sources/blocks/index.html',
            'sources/blocks/main_db_notes.php',
            'sources/blocks/main_notes.php',
            'sources/blocks/main_only_if_match.php',
            'sources/blocks/side_personal_stats.php',
            'sources/blocks/top_login.php',
            'sources/blocks/top_personal_stats.php',
            'sources/caches.php',
            'sources/caches2.php',
            'sources/caches3.php',
            'sources/persistent_caching/index.html',
            'sources/persistent_caching/filesystem.php',
            'sources/persistent_caching/eaccelerator.php',
            'sources/persistent_caching/apc.php',
            'sources/persistent_caching/xcache.php',
            'sources/persistent_caching/wincache.php',
            'sources/persistent_caching/memcache.php',
            'sources/persistent_caching/memcached.php',
            'sources/config.php',
            'sources/config2.php',
            'sources/critical_errors.php',
            'sources/database.php',
            'sources/database_security_filter.php',
            'sources/database_helper.php',
            'sources/database_repair.php',
            'sources/database_action.php',
            'sources/database_search.php',
            'sources/diff.php',
            'sources/diff/Diff/Engine/index.html',
            'sources/diff/Diff/index.html',
            'sources/diff/Diff/Renderer/index.html',
            'sources/diff/index.html',
            'sources/diff/Diff/Engine/native.php',
            'sources/diff/Diff/Engine/shell.php',
            'sources/diff/Diff/Engine/string.php',
            'sources/diff/Diff/Engine/xdiff.php',
            'sources/diff/Diff/Mapped.php',
            'sources/diff/Diff/Renderer/context.php',
            'sources/diff/Diff/Renderer/inline.php',
            'sources/diff/Diff/Renderer/unified.php',
            'sources/diff/Diff/Renderer.php',
            'sources/diff/Diff/ThreeWay.php',
            'sources/diff/Diff.php',
            'sources/diff/Diff3.php',
            'sources/encryption.php',
            'sources/files.php',
            'sources/files2.php',
            'sources/forum_stub.php',
            'sources/global.php',
            'sources/shared_installs.php',
            'sources/override_api.php',
            'sources/global2.php',
            'sources/debug_fs.php',
            'sources/character_sets.php',
            'sources/css_and_js.php',
            'sources/jsmin.php',
            'sources/database_relations.php',
            'sources/wordfilter.php',
            'sources/input_filter.php',
            'sources/csrf_filter.php',
            'sources/input_filter_2.php',
            'sources/hooks/systems/checks/.htaccess',
            'sources_custom/hooks/systems/checks/.htaccess',
            'sources/hooks/systems/checks/base_url.php',
            'sources/hooks/systems/checks/no_ad_script.php',
            'data/blank.php',
            'sources/hooks/systems/checks/disk_space.php',
            'sources/hooks/systems/checks/file_uploads.php',
            'sources/hooks/systems/checks/functions_needed.php',
            'sources/hooks/systems/checks/gd.php',
            'sources/hooks/systems/checks/index.html',
            'sources_custom/hooks/systems/checks/index.html',
            'sources/hooks/systems/checks/max_execution_time.php',
            'sources/hooks/systems/checks/max_input_vars.php',
            'sources/hooks/systems/checks/mbstring_overload.php',
            'sources/hooks/systems/checks/memory.php',
            'sources/hooks/systems/checks/mysql_version.php',
            'sources/hooks/systems/checks/php_version.php',
            'sources/hooks/systems/checks/suhosin_eval.php',
            'sources/hooks/systems/checks/unzip.php',
            'sources/hooks/systems/checks/xml.php',
            'sources/hooks/systems/checks/directory_name.php',
            'sources/hooks/systems/checks/normative_performance.php',
            'sources/hooks/systems/checks/utf.php',
            'sources/hooks/systems/checks/modsecurity.php',
            'sources/failure.php',
            'sources/failure_spammers.php',
            'sources/images.php',
            'sources/images_cleanup_pipeline.php',
            'sources/images2.php',
            'sources/exif.php',
            'sources/index.html',
            'sources/integrator.php',
            'sources/lang.php',
            'sources/lang_compile.php',
            'sources/lang2.php',
            'sources/lang3.php',
            'sources/mail.php',
            'sources/mail2.php',
            'sources/miniblocks/.htaccess',
            'sources/miniblocks/index.html',
            'sources/minikernel.php',
            'sources/misc_scripts.php',
            'sources/hooks/systems/preview/block_comcode.php',
            'sources/m_zip.php',
            'sources/seo2.php',
            'sources/site.php',
            'sources/site_adminzone.php',
            'sources/site_html_pages.php',
            'sources/site2.php',
            'sources/submit.php',
            'sources/global3.php',
            'sources/global4.php',
            'sources/mime_types.php',
            'sources/obfuscate.php',
            'sources/xhtml.php',
            'sources/xmlrpc.php',
            'sources/textfiles.php',
            'sources/autosave.php',
            'sources/symbols.php',
            'sources/symbols2.php',
            'sources/tar.php',
            'sources/tar2.php',
            'sources/tempcode.php',
            'sources/tempcode_compiler.php',
            'sources/tempcode_optimiser.php',
            'sources/templates.php',
            'sources/themes.php',
            'sources/type_sanitisation.php',
            'sources/uploads.php',
            'sources/urls_simplifier.php',
            'sources/uploads2.php',
            'sources/upload_syndication.php',
            'data/upload_syndication_auth.php',
            'lang/EN/upload_syndication.ini',
            'themes/default/templates/UPLOAD_SYNDICATION_SETUP_SCREEN.tpl',
            'sources/urls.php',
            'sources/urls2.php',
            'sources/users.php',
            'sources/users2.php',
            'sources/users_active_actions.php',
            'sources/users_inactive_occasionals.php',
            'sources/version.php',
            'sources/version2.php',
            'sources/view_modes.php',
            'sources/zip.php',
            'sources/zones.php',
            'sources/zones2.php',
            'sources/zones3.php',
            'sources/developer_tools.php',
            'sources/hooks/.htaccess',
            'sources/hooks/blocks/.htaccess',
            'sources/hooks/blocks/index.html',
            'sources_custom/hooks/blocks/.htaccess',
            'sources_custom/hooks/blocks/index.html',
            'sources/hooks/index.html',
            'sources/hooks/modules/.htaccess',
            'sources/hooks/modules/index.html',
            'sources_custom/hooks/modules/.htaccess',
            'sources_custom/hooks/modules/index.html',
            'sources/hooks/systems/.htaccess',
            'sources/hooks/systems/index.html',
            'sources_custom/hooks/systems/.htaccess',
            'sources_custom/hooks/systems/index.html',
            'data/ajax_tree.php',
            'sources/hooks/systems/ajax_tree/.htaccess',
            'sources_custom/hooks/systems/ajax_tree/.htaccess',
            'sources/hooks/systems/ajax_tree/index.html',
            'sources_custom/hooks/systems/ajax_tree/index.html',
            'sources/hooks/systems/cron/.htaccess',
            'sources_custom/hooks/systems/cron/.htaccess',
            'sources/hooks/systems/cron/index.html',
            'sources_custom/hooks/systems/cron/index.html',
            'sources/hooks/systems/page_groupings/.htaccess',
            'sources_custom/hooks/systems/page_groupings/.htaccess',
            'sources/hooks/systems/page_groupings/core.php',
            'sources/hooks/systems/page_groupings/index.html',
            'sources_custom/hooks/systems/page_groupings/index.html',
            'sources/hooks/systems/preview/.htaccess',
            'sources_custom/hooks/systems/preview/.htaccess',
            'sources/hooks/systems/preview/index.html',
            'sources_custom/hooks/systems/preview/index.html',
            'sources/hooks/systems/snippets/.htaccess',
            'sources_custom/hooks/systems/snippets/.htaccess',
            'sources/hooks/systems/snippets/index.html',
            'sources_custom/hooks/systems/snippets/index.html',
            'sources/hooks/systems/snippets/css_compile__text.php',
            'sources/hooks/systems/snippets/block.php',
            'sources/blocks.php',
            'sources/hooks/systems/cron/block_caching.php',
            'themes/default/text/tempcode_test.txt',
            'themes/default/templates/QUERY_LOG.tpl',
            'themes/default/templates/QUERY_SCREEN.tpl',
            'themes/default/javascript/custom_globals.js',
            'themes/default/javascript/modalwindow.js',
            'themes/default/images/product_logo.png',
            'themes/default/images/button_lightbox_close.png',
            'sources/blocks/main_greeting.php',
            'themes/default/images/iphone.png',
            'themes/default/images/quote_gradient.png',
            'sources/hooks/systems/content_meta_aware/.htaccess',
            'sources_custom/hooks/systems/content_meta_aware/.htaccess',
            'sources/hooks/systems/content_meta_aware/index.html',
            'sources_custom/hooks/systems/content_meta_aware/index.html',
            'sources/hooks/systems/meta/.htaccess',
            'sources_custom/hooks/systems/meta/.htaccess',
            'sources/hooks/systems/cns_auth/.htaccess',
            'sources_custom/hooks/systems/cns_auth/.htaccess',
            'sources/hooks/systems/startup/.htaccess',
            'sources_custom/hooks/systems/startup/.htaccess',
            'sources/hooks/systems/upon_access_denied/.htaccess',
            'sources_custom/hooks/systems/upon_access_denied/.htaccess',
            'sources/hooks/systems/upon_login/.htaccess',
            'sources_custom/hooks/systems/upon_login/.htaccess',
            'sources/hooks/systems/upon_page_load/.htaccess',
            'sources_custom/hooks/systems/upon_page_load/.htaccess',
            'sources/hooks/systems/upon_query/.htaccess',
            'sources_custom/hooks/systems/upon_query/.htaccess',
            'sources_custom/database/.htaccess',
            'sources_custom/database/index.html',
            'sources/decision_tree.php',
            'lang/EN/decision_tree.ini',
            'sources/rss.php',
            'lang/EN/rss.ini',
            'data/incoming_uploads.php',
            'sources/incoming_uploads.php',
            'themes/default/images/uploader/cancelbutton.gif',
            'themes/default/images/uploader/index.html',
            'themes/default/images/icons/24x24/links/facebook.png',
            'themes/default/images/icons/24x24/links/twitter.png',
            'themes/default/images/icons/48x48/links/facebook.png',
            'themes/default/images/icons/48x48/links/twitter.png',
            'uploads/repimages/index.html',
            'uploads/repimages/.htaccess',
            'uploads/incoming/index.html',
            'uploads/incoming/.htaccess',
            'uploads/.htaccess',
            'data/plupload/index.html',
            'data/plupload/plupload.flash.swf',
            'data/plupload/plupload.silverlight.xap',
            'themes/default/css/widget_plupload.css',
            'themes/default/javascript/plupload.js',
            'themes/admin/templates/ADMIN_ZONE_SEARCH.tpl',
            'themes/default/text/NEWSLETTER_DEFAULT_FCOMCODE.txt',
            'themes/default/images/.htaccess',
            'themes/default/images/favicon.ico',
            'themes/default/images/webclipicon.ico',
            'themes/default/javascript/menu_mobile.js',
            'adminzone/pages/modules/admin_email_log.php',
            'sources/hooks/systems/cron/mail_queue.php',
            'lang/EN/email_log.ini',
            'themes/default/templates/EMAIL_LOG_SCREEN.tpl',
            'sources/hooks/systems/cron/implicit_usergroup_sync.php',
            'sources/hooks/systems/cns_implicit_usergroups/index.html',
            'sources_custom/hooks/systems/cns_implicit_usergroups/index.html',
            'sources/hooks/systems/cns_implicit_usergroups/.htaccess',
            'sources_custom/hooks/systems/cns_implicit_usergroups/.htaccess',
            'themes/default/css/personal_stats.css',
            'themes/default/templates/MASS_SELECT_MARKER.tpl',
            'themes/default/templates/MASS_SELECT_DELETE_FORM.tpl',
            'themes/default/templates/MASS_SELECT_FORM_BUTTONS.tpl',
            'data/tasks.php',
            'sources/tasks.php',
            'lang/EN/tasks.ini',
            'sources/hooks/systems/cron/tasks.php',
            'sources/hooks/systems/tasks/index.html',
            'sources_custom/hooks/systems/tasks/index.html',
            'sources/hooks/systems/notifications/task_completed.php',
            'sources/hooks/systems/tasks/.htaccess',
            'sources_custom/hooks/systems/tasks/.htaccess',
            'themes/default/images/EN/1x/index.html',
            'themes/default/images/EN/2x/index.html',
            'themes/default/images/icons/16x16/index.html',
            'sources/persistent_caching/.htaccess',
            'sources/deep_clean.php',
            'sources/hooks/systems/symbols/DEEP_CLEAN.php',
            'themes/default/templates/PASSWORD_CHECK_JS.tpl',
            'themes/default/templates/SPONSORS_SCREEN.tpl',

            // External endpoints (API) - no actual endpoints defined in core (or even bundled at time of writing), but may be added by other addons
            'data/endpoint.php',
            'sources/endpoints.php',
            'sources/hooks/endpoints/.htaccess',
            'sources/hooks/endpoints/index.html',
            'sources/hooks/endpoints/account/.htaccess',
            'sources/hooks/endpoints/account/index.html',
            'sources/hooks/endpoints/content/.htaccess',
            'sources/hooks/endpoints/content/index.html',
            'sources/hooks/endpoints/misc/.htaccess',
            'sources/hooks/endpoints/misc/index.html',
            'sources_custom/hooks/endpoints/.htaccess',
            'sources_custom/hooks/endpoints/index.html',
            'sources_custom/hooks/endpoints/account/.htaccess',
            'sources_custom/hooks/endpoints/account/index.html',
            'sources_custom/hooks/endpoints/content/.htaccess',
            'sources_custom/hooks/endpoints/content/index.html',
            'sources_custom/hooks/endpoints/misc/.htaccess',
            'sources_custom/hooks/endpoints/misc/index.html',

            // Form handlers - no actual handlers defined in core (or even bundled at time of writing), but may be added by other addons
            'sources/hooks/form_handlers/index.html',
            'sources/hooks/form_handlers/join/index.html',
            'sources/hooks/form_handlers/profile_edit/index.html',
            'sources_custom/hooks/form_handlers/index.html',
            'sources_custom/hooks/form_handlers/join/index.html',
            'sources_custom/hooks/form_handlers/profile_edit/index.html',

            // Additional html page processing - no actual hooks defined in core (or even bundled at time of writing), but may be added by other addons
            'sources/hooks/systems/site_html_pages/.htaccess',
            'sources/hooks/systems/site_html_pages/index.html',

            // Admin theme
            'themes/admin/css/index.html',
            'themes/admin/css/.htaccess',
            'themes/admin/css/adminzone.css',
            'themes/admin/css_custom/.htaccess',
            'themes/admin/css_custom/index.html',
            'themes/admin/images/index.html',
            'themes/admin/images_custom/index.html',
            'themes/admin/images/.htaccess',
            'themes/admin/images_custom/.htaccess',
            'themes/admin/index.html',
            'themes/admin/templates/.htaccess',
            'themes/admin/templates/GLOBAL_HTML_WRAP.tpl',
            'themes/admin/templates/index.html',
            'themes/admin/templates_custom/.htaccess',
            'themes/admin/templates_custom/index.html',
            'themes/admin/javascript_custom/.htaccess',
            'themes/admin/javascript_custom/index.html',
            'themes/admin/xml_custom/.htaccess',
            'themes/admin/xml_custom/index.html',
            'themes/admin/text_custom/.htaccess',
            'themes/admin/text_custom/index.html',
            'themes/admin/templates_cached/.htaccess',
            'themes/admin/templates_cached/EN/index.html',
            'themes/admin/templates_cached/index.html',

            // These are not used by default, as have text links - but may be useful for some
            'themes/default/images/icons/24x24/tool_buttons/version_desktop.png',
            'themes/default/images/icons/48x48/tool_buttons/version_desktop.png',
            'themes/default/images/icons/24x24/tool_buttons/version_mobile.png',
            'themes/default/images/icons/48x48/tool_buttons/version_mobile.png',
            'themes/default/images/icons/24x24/tool_buttons/sitemap.png',
            'themes/default/images/icons/48x48/tool_buttons/sitemap.png',
        );
    }

    /**
     * Get mapping between template names and the method of this class that can render a preview of them
     *
     * @return array The mapping
     */
    public function tpl_previews()
    {
        return array(
            'templates/ACTIONLOGS_SCREEN.tpl' => 'administrative__actionlogs_screen',
            'templates/ACTIONLOGS_TOGGLE_LINK.tpl' => 'administrative__actionlogs_toggle_link',
            'templates/LOGIN_SCREEN.tpl' => 'login_screen',
            'templates/REDIRECT_POST_METHOD_SCREEN.tpl' => 'redirect_post_method_screen',
            'templates/FORUMS_EMBED.tpl' => 'forums_embed',
            'templates/JS_BLOCK.tpl' => 'js_block',
            'templates/JAVASCRIPT_NEED.tpl' => 'javascript_need',
            'templates/JAVASCRIPT_NEED_FULL.tpl' => 'javascript_need_full',
            'templates/JAVASCRIPT_NEED_INLINE.tpl' => 'javascript_need_inline',
            'templates/CSS_NEED.tpl' => 'css_need',
            'templates/CSS_NEED_FULL.tpl' => 'css_need_full',
            'templates/CSS_NEED_INLINE.tpl' => 'css_need_inline',
            'templates/FATAL_SCREEN.tpl' => 'administrative__fatal_screen',
            'templates/STACK_TRACE.tpl' => 'administrative__stack_trace',
            'templates/INLINE_WIP_MESSAGE.tpl' => 'inline_wip_message',
            'templates/MISSING_SCREEN.tpl' => 'missing_screen',
            'templates/PARAM_INFO.tpl' => 'param_info',
            'templates/BLOCK_SIDE_PERSONAL_STATS.tpl' => 'block_side_personal_stats',
            'templates/BLOCK_SIDE_PERSONAL_STATS_LINE.tpl' => 'block_side_personal_stats',
            'templates/BLOCK_SIDE_PERSONAL_STATS_LINK_2.tpl' => 'block_side_personal_stats',
            'templates/BLOCK_SIDE_PERSONAL_STATS_LINK.tpl' => 'block_side_personal_stats',
            'templates/BLOCK_SIDE_PERSONAL_STATS_LINE_COMPLEX.tpl' => 'block_side_personal_stats',
            'templates/BLOCK_SIDE_PERSONAL_STATS_LOGOUT.tpl' => 'block_side_personal_stats',
            'templates/BLOCK_SIDE_PERSONAL_STATS_NO.tpl' => 'block_side_personal_stats_no',
            'templates/BLOCK_TOP_LOGIN.tpl' => 'block_top_login',
            'templates/BLOCK_TOP_PERSONAL_STATS.tpl' => 'block_top_personal_stats',
            'templates/BLOCK_NO_ENTRIES.tpl' => 'nothing_here',
            'templates/BLOCK_MAIN_EMOTICON_CODES.tpl' => 'block_main_emoticon_codes',
            'templates/BLOCK_MAIN_COMCODE_PAGE_CHILDREN.tpl' => 'block_main_comcode_page_children',
            'templates/QUERY_LOG.tpl' => 'administrative__query_screen',
            'templates/QUERY_SCREEN.tpl' => 'administrative__query_screen',
            'templates/BROKEN_URLS.tpl' => 'administrative__broken_urls',
            'templates/BROKEN_LANG_STRINGS.tpl' => 'administrative__broken_lang_strings',
            'templates/FORUM_ATTACHMENT_IMAGE.tpl' => 'forum_attachment_image',
            'templates/FORUM_ATTACHMENT_IMAGE_THUMB.tpl' => 'forum_attachment_link',
            'templates/FORUM_ATTACHMENT_LINK.tpl' => 'forum_attachment_link',
            'text/tempcode_test.txt' => 'administrative__tempcode_test',
            'templates/EMAIL_LOG_SCREEN.tpl' => 'email_log_screen',
            'templates/BLOCK_MAIN_CONTENT_FILTERING.tpl' => 'block_main_content_filtering',
            'templates/BLOCK_MAIN_CONTENT.tpl' => 'block_main_content',
            'templates/BLOCK_MAIN_MULTI_CONTENT.tpl' => 'block_main_multi_content',
            'templates/MASS_SELECT_FORM_BUTTONS.tpl' => 'mass_select_form_buttons',
            'templates/MASS_SELECT_MARKER.tpl' => 'mass_select_marker',
            'templates/MASS_SELECT_DELETE_FORM.tpl' => 'mass_select_delete_form',
            'templates/UPLOAD_SYNDICATION_SETUP_SCREEN.tpl' => 'upload_syndication_setup_screen',
            'templates/GROUP_MEMBER_TIMEOUT_MANAGE_SCREEN.tpl' => 'group_member_timeout_manage_screen',
            'templates/SPONSORS_SCREEN.tpl' => 'sponsors_screen',
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__block_main_content()
    {
        return array(
            lorem_globalise(do_lorem_template('BLOCK_MAIN_CONTENT', array(
                'TYPE' => lorem_phrase(),
                'TITLE' => lorem_word(),
                'RAW_AWARD_DATE' => placeholder_date(),
                'AWARD_DATE' => placeholder_date(),
                'CONTENT' => lorem_phrase_html(),
                'SUBMIT_URL' => placeholder_url(),
                'ARCHIVE_URL' => placeholder_url(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__block_main_multi_content()
    {
        return array(
            lorem_globalise(do_lorem_template('BLOCK_MAIN_MULTI_CONTENT', array(
                'TYPE' => lorem_phrase(),
                'CONTENT_TYPE' => lorem_phrase(),
                'TITLE' => lorem_word(),
                'RAW_AWARD_DATE' => placeholder_date(),
                'AWARD_DATE' => placeholder_date(),
                'CONTENT' => array(
                    lorem_phrase_html()
                ),
                'SUBMIT_URL' => placeholder_url(),
                'ARCHIVE_URL' => placeholder_url(),
                'BLOCK_PARAMS' => '',
                'ADD_STRING' => lorem_phrase(),

                'START' => '0',
                'MAX' => '10',
                'START_PARAM' => 'x_start',
                'MAX_PARAM' => 'x_max',
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__email_log_screen()
    {
        return array(
            lorem_globalise(do_lorem_template('EMAIL_LOG_SCREEN', array(
                'TITLE' => lorem_title(),
                'RESULTS_TABLE' => placeholder_table(),
                'MASS_DELETE_URL' => placeholder_url(),
                'MASS_SEND_URL' => placeholder_url(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__administrative__actionlogs_toggle_link()
    {
        return array(
            lorem_globalise(do_lorem_template('ACTIONLOGS_TOGGLE_LINK', array(
                'URL' => placeholder_url(),
                'page' => lorem_phrase(),
                'type' => lorem_phrase(),
                'id' => lorem_phrase(),
                'mode' => lorem_phrase(),
                'action_id' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__administrative__actionlogs_screen()
    {
        return array(
            lorem_globalise(do_lorem_template('ACTIONLOGS_SCREEN', array(
                'TABLE' => placeholder_table(),
                'TITLE' => lorem_title(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__login_screen()
    {
        $_GET['wide'] = '1';

        return array(
            lorem_globalise(do_lorem_template('LOGIN_SCREEN', array(
                'EXTRA' => lorem_phrase(),
                'USERNAME' => lorem_word(),
                'JOIN_URL' => placeholder_url(),
                'TITLE' => lorem_title(),
                'LOGIN_URL' => placeholder_url(),
                'PASSION' => '',
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__redirect_post_method_screen()
    {
        return array(
            lorem_globalise(do_lorem_template('REDIRECT_POST_METHOD_SCREEN', array(
                'REFRESH' => '',
                'TITLE' => lorem_title(),
                'TEXT' => lorem_sentence_html(),
                'URL' => placeholder_url(),
                'POST' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__forums_embed()
    {
        return array(
            lorem_globalise(do_lorem_template('FORUMS_EMBED', array(
                'FORUMS' => placeholder_url(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__js_block()
    {
        return array(
            lorem_globalise(do_lorem_template('JS_BLOCK', array(
                'BLOCK_PARAMS' => '',
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__javascript_need()
    {
        return array(
            lorem_globalise(do_lorem_template('JAVASCRIPT_NEED', array(
                'CODE' => placeholder_javascript_code(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__javascript_need_full()
    {
        return array(
            lorem_globalise(do_lorem_template('JAVASCRIPT_NEED_FULL', array(
                'URL' => placeholder_url(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__javascript_need_inline()
    {
        return array(
            lorem_globalise(do_lorem_template('JAVASCRIPT_NEED_INLINE', array(
                'CODE' => placeholder_javascript_code(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__css_need()
    {
        return array(
            lorem_globalise(do_lorem_template('CSS_NEED', array(
                'CODE' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__css_need_full()
    {
        return array(
            lorem_globalise(do_lorem_template('CSS_NEED_FULL', array(
                'URL' => placeholder_url(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__css_need_inline()
    {
        return array(
            lorem_globalise(do_lorem_template('CSS_NEED_INLINE', array(
                'CODE' => '',
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__administrative__fatal_screen()
    {
        return array(
            lorem_globalise(do_lorem_template('FATAL_SCREEN', array(
                'TITLE' => lorem_title(),
                'MESSAGE' => lorem_phrase(),
                'TRACE' => lorem_phrase(),
                'MAY_SEE_TRACE' => true,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__administrative__stack_trace()
    {
        $trace = array();
        foreach (placeholder_array() as $value) {
            $traces = array();
            foreach (placeholder_array() as $key => $value1) {
                $traces[] = array(
                    'LINE' => $value1,
                    'FILE' => lorem_phrase(),
                    'KEY' => ucfirst($value1),
                    'VALUE' => lorem_sentence(),
                );
            }
            $trace[] = array(
                'TRACES' => $traces,
            );
        }

        return array(
            lorem_globalise(do_lorem_template('STACK_TRACE', array(
                'TRACE' => $trace,
                'POST' => placeholder_array(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__inline_wip_message()
    {
        return array(
            lorem_globalise(do_lorem_template('INLINE_WIP_MESSAGE', array(
                'MESSAGE' => lorem_phrase(),
                'NO_ENTRIES' => lorem_word(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__missing_screen()
    {
        return array(
            lorem_globalise(do_lorem_template('MISSING_SCREEN', array(
                'TITLE' => lorem_title(),
                'ADD_URL' => placeholder_url(),
                'PAGE' => lorem_phrase(),
                'DID_MEAN' => lorem_word(),
                'ADD_REDIRECT_URL' => placeholder_url(),
                'SKIP_SITEMAP' => true,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__param_info()
    {
        return array(
            lorem_globalise(do_lorem_template('PARAM_INFO', array(
                'MAP' => array(
                    'A' => 'a',
                    'B' => 'b',
                )
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__block_side_personal_stats()
    {
        $details = new Tempcode();
        $details->attach(do_lorem_template('BLOCK_SIDE_PERSONAL_STATS_LINE', array(
            'KEY' => lorem_word(),
            'VALUE' => placeholder_number(),
        )));
        $details->attach(do_lorem_template('BLOCK_SIDE_PERSONAL_STATS_LINE_COMPLEX', array(
            'KEY' => do_lang_tempcode('USERGROUP'),
            'VALUE' => placeholder_link(),
        )));

        $links = new Tempcode();
        $links->attach(do_lorem_template('BLOCK_SIDE_PERSONAL_STATS_LINK_2', array(
            'NAME' => lorem_word_2(),
            'DESCRIPTION' => lorem_phrase(),
            'URL' => placeholder_url(),
        )));
        $links->attach(do_lorem_template('BLOCK_SIDE_PERSONAL_STATS_LINK', array(
            'NAME' => lorem_word(),
            'URL' => placeholder_url(),
            'REL' => 'me',
        )));
        $links->attach(do_lorem_template('BLOCK_SIDE_PERSONAL_STATS_LOGOUT', array(
            'NAME' => do_lang_tempcode('LOGOUT'),
            'URL' => placeholder_url(),
        )));

        $links_ecommerce = new Tempcode();
        $links_ecommerce->attach(do_lorem_template('BLOCK_SIDE_PERSONAL_STATS_LINK_2', array(
            'NAME' => lorem_word_2(),
            'DESCRIPTION' => lorem_phrase(),
            'URL' => placeholder_url(),
        )));

        return array(
            lorem_globalise(do_lorem_template('BLOCK_SIDE_PERSONAL_STATS', array(
                'AVATAR_URL' => placeholder_avatar(),
                'LINKS' => $links,
                'LINKS_ECOMMERCE' => $links_ecommerce,
                'DETAILS' => $details,
                'USERNAME' => lorem_word(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__block_top_personal_stats()
    {
        $details = new Tempcode();
        $details->attach(do_lorem_template('BLOCK_SIDE_PERSONAL_STATS_LINE', array(
            'KEY' => lorem_word(),
            'VALUE' => placeholder_number(),
        )));
        $details->attach(do_lorem_template('BLOCK_SIDE_PERSONAL_STATS_LINE_COMPLEX', array(
            'KEY' => do_lang_tempcode('USERGROUP'),
            'VALUE' => placeholder_link(),
        )));

        $links = new Tempcode();
        $links->attach(do_lorem_template('BLOCK_SIDE_PERSONAL_STATS_LINK_2', array(
            'NAME' => lorem_word_2(),
            'DESCRIPTION' => lorem_phrase(),
            'URL' => placeholder_url(),
        )));
        $links->attach(do_lorem_template('BLOCK_SIDE_PERSONAL_STATS_LINK', array(
            'NAME' => lorem_word(),
            'URL' => placeholder_url(),
            'REL' => 'me',
        )));
        $links->attach(do_lorem_template('BLOCK_SIDE_PERSONAL_STATS_LOGOUT', array(
            'NAME' => do_lang_tempcode('LOGOUT'),
            'URL' => placeholder_url(),
        )));

        $links_ecommerce = new Tempcode();
        $links_ecommerce->attach(do_lorem_template('BLOCK_SIDE_PERSONAL_STATS_LINK_2', array(
            'NAME' => lorem_word_2(),
            'DESCRIPTION' => lorem_phrase(),
            'URL' => placeholder_url(),
        )));

        return array(
            lorem_globalise(do_lorem_template('BLOCK_TOP_PERSONAL_STATS', array(
                'AVATAR_URL' => placeholder_avatar(),
                'LINKS' => $links,
                'LINKS_ECOMMERCE' => $links_ecommerce,
                'DETAILS' => $details,
                'USERNAME' => lorem_word(),
                'MEMBER_ID' => placeholder_id(),
            )), null, '', false)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__block_side_personal_stats_no()
    {
        return array(
            lorem_globalise(do_lorem_template('BLOCK_SIDE_PERSONAL_STATS_NO', array(
                'TITLE' => lorem_phrase(),
                'FULL_LOGIN_URL' => placeholder_url(),
                'JOIN_URL' => placeholder_url(),
                'LOGIN_URL' => placeholder_url(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__block_top_login()
    {
        return array(
            lorem_globalise(do_lorem_template('BLOCK_TOP_LOGIN', array(
                'TITLE' => lorem_phrase(),
                'FULL_LOGIN_URL' => placeholder_url(),
                'JOIN_URL' => placeholder_url(),
                'LOGIN_URL' => placeholder_url(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__nothing_here()
    {
        return array(
            lorem_globalise(do_lorem_template('BLOCK_NO_ENTRIES', array(
                'HIGH' => lorem_phrase(),
                'TITLE' => lorem_word(),
                'MESSAGE' => lorem_phrase(),
                'ADD_NAME' => lorem_word(),
                'SUBMIT_URL' => placeholder_url(),
                'RECENT' => lorem_word(),
                'MEMBERS' => lorem_word(),
                'NO_ENTRIES' => lorem_word(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__block_main_emoticon_codes()
    {
        require_code('comcode_renderer');

        $emoticons = placeholder_emoticons();

        $rows = array();
        global $EMOTICON_LEVELS;
        foreach ($emoticons as $code => $imgcode) {
            if ((is_null($EMOTICON_LEVELS)) || ($EMOTICON_LEVELS[$code] < 3)) {
                $rows[] = array(
                    'COLUMNS' => array(array(
                       'CODE' => $code,
                       'TPL' => do_emoticon($imgcode),
                   )),
                );
            }
        }

        return array(
            lorem_globalise(do_lorem_template('BLOCK_MAIN_EMOTICON_CODES', array(
                'ROWS' => $rows,
                'NUM_COLUMNS' => '1',
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__block_main_comcode_page_children()
    {
        $children = array();
        foreach (placeholder_array() as $i => $temp) {
            $child = array();
            $child['TITLE'] = $temp;
            $child['PAGE'] = lorem_word();
            $child['ZONE'] = lorem_word();

            $children[$i] = $child;
        }

        return array(
            lorem_globalise(do_lorem_template('BLOCK_MAIN_COMCODE_PAGE_CHILDREN', array(
                'CHILDREN' => $children,
                'THE_PAGE' => lorem_phrase(),
                'THE_ZONE' => lorem_phrase(),
                'TITLE' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__administrative__query_screen()
    {
        $queries = new Tempcode();
        foreach (placeholder_array() as $value) {
            $queries->attach(do_lorem_template('QUERY_LOG', array(
                'TIME' => placeholder_number(),
                'ROWS' => placeholder_number(),
                'TEXT' => lorem_sentence(),
            )));
        }

        return array(
            lorem_globalise(do_lorem_template('QUERY_SCREEN', array(
                'TITLE' => lorem_title(),
                'TOTAL' => lorem_phrase(),
                'TOTAL_TIME' => placeholder_number(),
                'QUERIES' => $queries,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__administrative__broken_urls()
    {
        require_lang('cleanup');

        $found_404 = array();
        foreach (placeholder_array() as $value) {
            $found_404[] = array(
                'URL' => placeholder_url(),
                'SPOT' => $value,
            );
        }

        $found = array();
        foreach (placeholder_array() as $k => $value) {
            $found[] = array(
                'URL' => placeholder_url(),
                'TABLE' => $value,
                'FIELD' => lorem_word_2(),
                'ID' => strval($k),
            );
        }

        return array(
            lorem_globalise(do_lorem_template('BROKEN_URLS', array(
                'FOUND' => $found,
                'FOUND_404' => $found_404,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__administrative__broken_lang_strings()
    {
        require_lang('cleanup');

        return array(
            lorem_globalise(do_lorem_template('BROKEN_LANG_STRINGS', array(
                'MISSING_LANG_STRINGS' => placeholder_array(),
                'FUSED_LANG_STRINGS' => placeholder_array(),
                'ORPHANED_LANG_STRINGS' => placeholder_array(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__forum_attachment_image()
    {
        return array(
            lorem_globalise(do_lorem_template('FORUM_ATTACHMENT_IMAGE', array(
                'URL' => placeholder_image_url(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__forum_attachment_link()
    {
        $content = do_lorem_template('FORUM_ATTACHMENT_IMAGE_THUMB', array(
            'FULL' => placeholder_url(),
            'URL' => placeholder_image_url(),
        ));

        $content->attach(do_lorem_template('FORUM_ATTACHMENT_LINK', array(
            'FULL' => placeholder_url(),
            'FILENAME' => lorem_word(),
            'CLEAN_SIZE' => placeholder_filesize(),
            'NUM_DOWNLOADS' => placeholder_number(),
        )));
        return array(
            lorem_globalise($content, null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__administrative__tempcode_test()
    {
        return array(
            lorem_globalise(do_lorem_template('tempcode_test', array(
                'EMPTY1' => '',
                'EMPTY2' => new Tempcode(),
                'NONEMPTY' => lorem_word(),
                'PASSED' => 'This is a passed parameter',
                'SIMPLE_ARRAY' => array('1', '2', '3'),
                'ARRAY' => array(array('a' => 'A1', 'b' => 'B1', 'c' => 'C1'), array('a' => 'A2', 'b' => 'B2', 'c' => 'C2'), array('a' => 'A3', 'b' => 'B3', 'c' => 'C3'), array('a' => 'A4', 'b' => 'B4', 'c' => 'C4')),
            ), null, false, null, '.txt', 'text'), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__mass_select_marker()
    {
        return array(
            lorem_globalise(do_lorem_template('MASS_SELECT_MARKER', array(
                'TYPE' => placeholder_id(),
                'ID' => placeholder_id(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__mass_select_delete_form()
    {
        return array(
            lorem_globalise(do_lorem_template('MASS_SELECT_DELETE_FORM', array()), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__mass_select_form_buttons()
    {
        $buttons = do_lorem_template('MASS_SELECT_FORM_BUTTONS', array(
            'TYPE' => placeholder_id(),
        ));

        $fields = new Tempcode();
        $fields->attach(do_lorem_template('FORM_SCREEN_INPUT_HUGE', array(
            'RAW' => true,
            'SCROLLS' => '',
            'DESCRIPTION_SIDE' => lorem_sentence(),
            'REQUIRED' => '',
            '_REQUIRED' => '',
            'TABINDEX' => placeholder_number(),
            'PRETTY_NAME' => lorem_word(),
            'DESCRIPTION' => lorem_sentence(),
            'NAME' => placeholder_random_id(),
            'DEFAULT' => '',
            'ROWS' => '20',
        )));

        return array(
            lorem_globalise(do_lorem_template('FORM', array(
                'GET' => null,
                'SKIP_WEBSTANDARDS' => true,
                'HIDDEN' => $buttons,
                'TITLE' => lorem_title(),
                'URL' => placeholder_url(),
                'FIELDS' => $fields,
                'SUBMIT_ICON' => 'buttons__proceed',
                'SUBMIT_NAME' => lorem_word(),
                'TEXT' => '',
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__block_main_content_filtering()
    {
        return array(
            lorem_globalise(do_lorem_template('BLOCK_MAIN_CONTENT_FILTERING', array(
                'FIELDS' => placeholder_fields(),
                'ACTIVE_FILTER' => placeholder_id(),
                'SUBMIT_ICON' => 'buttons__proceed',
                'LINKS' => array(
                    array(
                        'ACTIVE' => true,
                        'TITLE' => lorem_phrase(),
                        'URL' => placeholder_url(),
                    )
                )
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__upload_syndication_setup_screen()
    {
        return array(
            lorem_globalise(do_lorem_template('UPLOAD_SYNDICATION_SETUP_SCREEN', array(
                'LABEL' => lorem_phrase(),
                'HOOK' => lorem_word(),
                'NAME' => lorem_word(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__group_member_timeout_manage_screen()
    {
        return array(
            lorem_globalise(do_lorem_template('GROUP_MEMBER_TIMEOUT_MANAGE_SCREEN', array(
                'TITLE' => lorem_title(),
                'TIMEOUTS' => array(
                    array(
                        'USERNAME' => lorem_word(),
                        'MEMBER_ID' => placeholder_id(),
                        'GROUP_ID' => placeholder_id(),
                        'DATE_INPUT' => lorem_phrase(),
                    ),
                ),
                'GROUPS' => array(placeholder_id() => lorem_word()),
                'DATE_INPUT' => lorem_phrase(),
                'URL' => placeholder_url(),
                'PAGINATION' => placeholder_pagination(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__sponsors_screen()
    {
        return array(
            lorem_globalise(do_lorem_template('SPONSORS_SCREEN', array(
                'TITLE' => lorem_title(),
                'PATREONS' => array(
                    array(
                        'USERNAME' => lorem_word(),
                        'NAME' => lorem_word(),
                        'MONTHLY' => placeholder_number(),
                    ),
                ),
            )), null, '', true)
        );
    }
}
