<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    core_abstract_interfaces
 */

/**
 * Hook class.
 */
class Hook_addon_registry_core_abstract_interfaces
{
    /**
     * Get a list of file permissions to set
     *
     * @param  boolean $runtime Whether to include wildcards represented runtime-created chmoddable files
     * @return array File permissions to set
     */
    public function get_chmod_array($runtime = false)
    {
        return array();
    }

    /**
     * Get the version of Composr this addon is for
     *
     * @return float Version number
     */
    public function get_version()
    {
        return cms_version_number();
    }

    /**
     * Get the description of the addon
     *
     * @return string Description of the addon
     */
    public function get_description()
    {
        return 'Core rendering functionality.';
    }

    /**
     * Get a list of tutorials that apply to this addon
     *
     * @return array List of tutorials
     */
    public function get_applicable_tutorials()
    {
        return array(
            'tut_themes',
        );
    }

    /**
     * Get a mapping of dependency types
     *
     * @return array File permissions to set
     */
    public function get_dependencies()
    {
        return array(
            'requires' => array(),
            'recommends' => array(),
            'conflicts_with' => array(),
        );
    }

    /**
     * Explicitly say which icon should be used
     *
     * @return URLPATH Icon
     */
    public function get_default_icon()
    {
        return 'themes/default/images/icons/48x48/menu/_generic_admin/component.png';
    }

    /**
     * Get a list of files that belong to this addon
     *
     * @return array List of files
     */
    public function get_file_list()
    {
        return array(
            'themes/default/images/icons/24x24/status/inform.png',
            'themes/default/images/icons/48x48/status/inform.png',
            'themes/default/images/icons/24x24/status/notice.png',
            'themes/default/images/icons/48x48/status/notice.png',
            'themes/default/images/icons/24x24/status/warn.png',
            'themes/default/images/icons/48x48/status/warn.png',
            'sources/hooks/systems/addon_registry/core_abstract_interfaces.php',
            'themes/default/templates/QUESTION_UI_BUTTONS.tpl',
            'themes/default/templates/PAGINATION_SCREEN.tpl',
            'themes/default/templates/AJAX_PAGINATION.tpl',
            'themes/default/templates/CONFIRM_SCREEN.tpl',
            'themes/default/templates/WARN_SCREEN.tpl',
            'themes/default/templates/FULL_MESSAGE_SCREEN.tpl',
            'themes/default/templates/INFORM_SCREEN.tpl',
            'themes/default/templates/REDIRECT_SCREEN.tpl',
            'themes/default/templates/WARNING_BOX.tpl',
            'themes/default/templates/DO_NEXT_SCREEN.tpl',
            'themes/default/templates/DO_NEXT_ITEM.tpl',
            'themes/default/templates/DO_NEXT_SECTION.tpl',
            'themes/default/css/do_next.css',
            'themes/default/templates/INDEX_SCREEN.tpl',
            'themes/default/templates/INDEX_SCREEN_ENTRY.tpl',
            'themes/default/templates/INDEX_SCREEN_FANCIER_SCREEN.tpl',
            'themes/default/templates/INDEX_SCREEN_FANCIER_ENTRY.tpl',
            'themes/default/templates/MAP_TABLE.tpl',
            'themes/default/templates/MAP_TABLE_FIELD.tpl',
            'themes/default/templates/MAP_TABLE_SCREEN.tpl',
            'themes/default/templates/COLUMNED_TABLE.tpl',
            'themes/default/templates/COLUMNED_TABLE_SCREEN.tpl',
            'themes/default/templates/COLUMNED_TABLE_ROW_CELL_TICK.tpl',
            'themes/default/templates/COLUMNED_TABLE_ROW_CELL_LINE.tpl',
            'themes/default/templates/COLUMNED_TABLE_ROW_CELL_SELECT.tpl',
            'themes/default/templates/COLUMNED_TABLE_ACTION_DELETE_CATEGORY.tpl',
            'themes/default/templates/COLUMNED_TABLE_ACTION_DELETE_ENTRY.tpl',
            'themes/default/templates/COLUMNED_TABLE_ACTION_INSTALL_ENTRY.tpl',
            'themes/default/templates/COLUMNED_TABLE_ACTION_REINSTALL_ENTRY.tpl',
            'themes/default/templates/COLUMNED_TABLE_ACTION_TRANSLATE.tpl',
            'themes/default/templates/COLUMNED_TABLE_ACTION_UPGRADE_ENTRY.tpl',
            'themes/default/templates/COLUMNED_TABLE_ACTION_DOWNLOAD.tpl',
            'themes/default/templates/COLUMNED_TABLE_HEADER_ROW.tpl',
            'themes/default/templates/COLUMNED_TABLE_HEADER_ROW_CELL.tpl',
            'themes/default/templates/COLUMNED_TABLE_ROW.tpl',
            'themes/default/templates/COLUMNED_TABLE_ROW_CELL.tpl',
            'themes/default/templates/PAGINATION_CONTINUE.tpl',
            'themes/default/templates/PAGINATION_CONTINUE_LAST.tpl',
            'themes/default/templates/PAGINATION_CONTINUE_FIRST.tpl',
            'themes/default/templates/PAGINATION_LIST_PAGES.tpl',
            'themes/default/templates/PAGINATION_NEXT.tpl',
            'themes/default/templates/PAGINATION_NEXT_LINK.tpl',
            'themes/default/templates/PAGINATION_PAGE_NUMBER.tpl',
            'themes/default/templates/PAGINATION_PAGE_NUMBER_LINK.tpl',
            'themes/default/templates/PAGINATION_PER_PAGE.tpl',
            'themes/default/templates/PAGINATION_PER_PAGE_OPTION.tpl',
            'themes/default/templates/PAGINATION_PREVIOUS.tpl',
            'themes/default/templates/PAGINATION_PREVIOUS_LINK.tpl',
            'themes/default/templates/PAGINATION_SORT.tpl',
            'themes/default/templates/PAGINATION_SORTER.tpl',
            'themes/default/templates/PAGINATION_WRAP.tpl',
            'themes/default/templates/RESULTS_LAUNCHER_CONTINUE.tpl',
            'themes/default/templates/RESULTS_LAUNCHER_PAGE_NUMBER_LINK.tpl',
            'themes/default/templates/RESULTS_LAUNCHER_WRAP.tpl',
            'themes/default/templates/RESULTS_TABLE.tpl',
            'themes/default/templates/RESULTS_TABLE_ENTRY.tpl',
            'themes/default/templates/RESULTS_TABLE_FIELD.tpl',
            'themes/default/templates/RESULTS_TABLE_FIELD_TITLE.tpl',
            'themes/default/templates/RESULTS_TABLE_FIELD_TITLE_SORTABLE.tpl',
            'themes/default/templates/RESULTS_TABLE_TICK.tpl',
            'themes/default/javascript/pagination.js',
            'themes/default/templates/INTERNALISED_AJAX_SCREEN.tpl',
            'themes/default/templates/MEMBER_TOOLTIP.tpl',
            'themes/default/templates/SIMPLE_PREVIEW_BOX.tpl',
            'themes/default/javascript/internalised_ajax_screen.js',
            'themes/default/templates/RESULTS_TABLE_SCREEN.tpl',
            'sources/templates_interfaces.php',
            'sources/templates_redirect_screen.php',
            'sources/templates_confirm_screen.php',
            'sources/templates_internalise_screen.php',
            'sources/templates_results_table.php',
            'sources/templates_result_launcher.php',
            'sources/templates_pagination.php',
            'sources/templates_columned_table.php',
            'sources/templates_map_table.php',
            'sources/templates_donext.php',
            'themes/default/images/progress_indicator/index.html',
            'themes/default/images/progress_indicator/stage_future.png',
            'themes/default/images/progress_indicator/stage_past.png',
            'themes/default/images/progress_indicator/stage_present.png',
        );
    }

    /**
     * Get mapping between template names and the method of this class that can render a preview of them
     *
     * @return array The mapping
     */
    public function tpl_previews()
    {
        return array(
            'templates/AJAX_PAGINATION.tpl' => 'ajax_pagination',
            'templates/RESULTS_TABLE_TICK.tpl' => 'result_table_screen',
            'templates/REDIRECT_SCREEN.tpl' => 'redirect_screen',
            'templates/CONFIRM_SCREEN.tpl' => 'confirm_screen',
            'templates/RESULTS_TABLE_SCREEN.tpl' => 'result_table_screen',
            'templates/COLUMNED_TABLE_ACTION_DELETE_ENTRY.tpl' => 'full_table_screen',
            'templates/COLUMNED_TABLE.tpl' => 'full_table_screen',
            'templates/INDEX_SCREEN_ENTRY.tpl' => 'index_screen',
            'templates/INDEX_SCREEN.tpl' => 'index_screen',
            'templates/INDEX_SCREEN_FANCIER_ENTRY.tpl' => 'index_screen_fancier_screen',
            'templates/INDEX_SCREEN_FANCIER_SCREEN.tpl' => 'index_screen_fancier_screen',
            'templates/COLUMNED_TABLE_ACTION_INSTALL_ENTRY.tpl' => 'full_table_screen',
            'templates/COLUMNED_TABLE_ACTION_UPGRADE_ENTRY.tpl' => 'full_table_screen',
            'templates/COLUMNED_TABLE_ACTION_REINSTALL_ENTRY.tpl' => 'full_table_screen',
            'templates/MAP_TABLE.tpl' => 'map_table',
            'templates/MAP_TABLE_SCREEN.tpl' => 'map_table_screen',
            'templates/COLUMNED_TABLE_ACTION_DELETE_CATEGORY.tpl' => 'columned_table_action_delete_category',
            'templates/WARNING_BOX.tpl' => 'warning_box',
            'templates/PAGINATION_SORTER.tpl' => 'result_table_screen',
            'templates/PAGINATION_SORT.tpl' => 'result_table_screen',
            'templates/RESULTS_TABLE_FIELD.tpl' => 'result_table_screen',
            'templates/RESULTS_TABLE_ENTRY.tpl' => 'result_table_screen',
            'templates/RESULTS_TABLE_FIELD_TITLE_SORTABLE.tpl' => 'result_table_screen',
            'templates/RESULTS_TABLE_FIELD_TITLE.tpl' => 'result_table_screen',
            'templates/COLUMNED_TABLE_HEADER_ROW_CELL.tpl' => 'full_table_screen',
            'templates/COLUMNED_TABLE_HEADER_ROW.tpl' => 'full_table_screen',
            'templates/COLUMNED_TABLE_ROW_CELL.tpl' => 'full_table_screen',
            'templates/COLUMNED_TABLE_ROW.tpl' => 'full_table_screen',
            'templates/RESULTS_LAUNCHER_PAGE_NUMBER_LINK.tpl' => 'result_launcher_screen',
            'templates/RESULTS_LAUNCHER_CONTINUE.tpl' => 'result_launcher_screen',
            'templates/RESULTS_LAUNCHER_WRAP.tpl' => 'result_launcher_screen',
            'templates/SIMPLE_PREVIEW_BOX.tpl' => 'simple_preview_box',
            'templates/INFORM_SCREEN.tpl' => 'inform_screen',
            'templates/PAGINATION_PER_PAGE_OPTION.tpl' => 'result_table_screen',
            'templates/PAGINATION_PER_PAGE.tpl' => 'result_table_screen',
            'templates/PAGINATION_CONTINUE_FIRST.tpl' => 'result_table_screen',
            'templates/PAGINATION_PREVIOUS_LINK.tpl' => 'result_table_screen',
            'templates/PAGINATION_PREVIOUS.tpl' => 'result_table_screen_2',
            'templates/PAGINATION_CONTINUE.tpl' => 'result_table_screen_2',
            'templates/PAGINATION_PAGE_NUMBER.tpl' => 'result_table_screen',
            'templates/PAGINATION_PAGE_NUMBER_LINK.tpl' => 'result_table_screen',
            'templates/PAGINATION_NEXT_LINK.tpl' => 'result_table_screen',
            'templates/PAGINATION_NEXT.tpl' => 'result_table_screen_2',
            'templates/PAGINATION_CONTINUE_LAST.tpl' => 'result_table_screen',
            'templates/PAGINATION_LIST_PAGES.tpl' => 'result_table_screen',
            'templates/PAGINATION_WRAP.tpl' => 'result_table_screen',
            'templates/MAP_TABLE_FIELD.tpl' => 'map_table',
            'templates/INTERNALISED_AJAX_SCREEN.tpl' => 'internalised_ajax_screen',
            'templates/WARN_SCREEN.tpl' => 'warn_screen',
            'templates/DO_NEXT_SCREEN.tpl' => 'administrative__do_next_screen',
            'templates/DO_NEXT_ITEM.tpl' => 'administrative__do_next_screen',
            'templates/DO_NEXT_SECTION.tpl' => 'administrative__do_next_screen',
            'templates/QUESTION_UI_BUTTONS.tpl' => 'question_ui_buttons',
            'templates/PAGINATION_SCREEN.tpl' => 'pagination_screen',
            'templates/FULL_MESSAGE_SCREEN.tpl' => 'full_message_screen',
            'templates/RESULTS_TABLE.tpl' => 'result_table_screen',
            'templates/MEMBER_TOOLTIP.tpl' => 'member_tooltip',
            'templates/COLUMNED_TABLE_ACTION_DOWNLOAD.tpl' => 'columned_table_action_download',
            'templates/COLUMNED_TABLE_ACTION_TRANSLATE.tpl' => 'administrative__columned_table_action_translate',
            'templates/COLUMNED_TABLE_ROW_CELL_SELECT.tpl' => 'full_table_screen',
            'templates/COLUMNED_TABLE_ROW_CELL_TICK.tpl' => 'full_table_screen',
            'templates/COLUMNED_TABLE_ROW_CELL_LINE.tpl' => 'full_table_screen',
            'templates/COLUMNED_TABLE_SCREEN.tpl' => 'administrative__columned_table_screen',
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__ajax_pagination()
    {
        return array(
            do_lorem_template('AJAX_PAGINATION', array(
                'BLOCK_PARAMS' => '',
                'ALLOW_INFINITE_SCROLL' => '1',
                'WRAPPER_ID' => placeholder_id(),
            ))
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__administrative__columned_table_action_translate()
    {
        require_lang('lang');
        return array(
            lorem_globalise(do_lorem_template('COLUMNED_TABLE_ACTION_TRANSLATE', array(
                'URL' => placeholder_url(),
                'NAME' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__columned_table_action_download()
    {
        return array(
            lorem_globalise(do_lorem_template('COLUMNED_TABLE_ACTION_DOWNLOAD', array(
                'URL' => placeholder_url(),
                'NAME' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__redirect_screen()
    {
        return array(
            lorem_globalise(do_lorem_template('REDIRECT_SCREEN', array(
                'URL' => placeholder_url(),
                'TITLE' => lorem_title(),
                'TEXT' => lorem_sentence_html(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__confirm_screen()
    {
        return array(
            lorem_globalise(do_lorem_template('CONFIRM_SCREEN', array(
                'URL' => placeholder_url(),
                'BACK_URL' => placeholder_url(),
                'PREVIEW' => lorem_phrase(),
                'FIELDS' => lorem_phrase(),
                'TITLE' => lorem_title(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__index_screen()
    {
        $entry = new Tempcode();

        foreach (placeholder_array() as $value) {
            $entry->attach(do_lorem_template('INDEX_SCREEN_ENTRY', array(
                'NAME' => lorem_word(),
                'URL' => placeholder_url(),
                'DISPLAY_STRING' => lorem_phrase(),
            )));
        }

        return array(
            lorem_globalise(do_lorem_template('INDEX_SCREEN', array(
                'TITLE' => lorem_title(),
                'PRE' => lorem_phrase(),
                'POST' => lorem_phrase(),
                'CONTENT' => $entry,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__index_screen_fancier_screen()
    {
        $entries = new Tempcode();
        foreach (placeholder_array() as $value) {
            $entries->attach(do_lorem_template('INDEX_SCREEN_FANCIER_ENTRY', array(
                'TITLE' => lorem_phrase(),
                'URL' => placeholder_url(),
                'NAME' => $value,
                'DESCRIPTION' => lorem_paragraph_html(),
                'COUNT' => placeholder_number(),
            )));
        }

        return array(
            lorem_globalise(do_lorem_template('INDEX_SCREEN_FANCIER_SCREEN', array(
                'CONTENT' => $entries,
                'TITLE' => lorem_title(),
                'POST' => lorem_phrase(),
                'PRE' => lorem_phrase(),
                'ADD_URL' => placeholder_url(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__map_table()
    {
        $fields = new Tempcode();
        $fields->attach(do_lorem_template('MAP_TABLE_FIELD', array(
            'NAME' => lorem_word(),
            'VALUE' => lorem_phrase(),
        )));

        return array(
            lorem_globalise(do_lorem_template('MAP_TABLE', array(
                'WIDTH' => placeholder_number(),
                'FIELDS' => $fields,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__map_table_screen()
    {
        $fields = do_lorem_template('MAP_TABLE_FIELD', array(
            'ABBR' => lorem_phrase(),
            'NAME' => lorem_word(),
            'VALUE' => lorem_phrase(),
        ));

        return array(
            lorem_globalise(do_lorem_template('MAP_TABLE_SCREEN', array(
                'TITLE' => lorem_title(),
                'FIELDS' => $fields,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__columned_table_action_delete_category()
    {
        return array(
            lorem_globalise(do_lorem_template('COLUMNED_TABLE_ACTION_DELETE_CATEGORY', array(
                'URL' => placeholder_url(),
                'NAME' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__warning_box()
    {
        return array(
            lorem_globalise(do_lorem_template('WARNING_BOX', array(
                'WARNING' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__simple_preview_box()
    {
        return array(
            lorem_globalise(do_lorem_template('SIMPLE_PREVIEW_BOX', array(
                'SUMMARY' => lorem_paragraph_html(),
                'URL' => placeholder_url(),
                'RESOURCE_TYPE' => '',
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__inform_screen()
    {
        return array(
            lorem_globalise(do_lorem_template('INFORM_SCREEN', array(
                'TITLE' => lorem_title(),
                'TEXT' => lorem_sentence(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__internalised_ajax_screen()
    {
        return array(
            lorem_globalise(do_lorem_template('INTERNALISED_AJAX_SCREEN', array(
                'SCREEN_CONTENT' => lorem_paragraph_html(),
                'REFRESH_IF_CHANGED' => lorem_phrase(),
                'CHANGE_DETECTION_URL' => placeholder_url(),
                'REFRESH_TIME' => placeholder_date_raw(),
                'URL' => placeholder_url(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__warn_screen()
    {
        return array(
            lorem_globalise(do_lorem_template('WARN_SCREEN', array(
                'TITLE' => lorem_title(),
                'WEBSERVICE_RESULT' => lorem_phrase(),
                'TEXT' => lorem_sentence(),
                'PROVIDE_BACK' => placeholder_id(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__administrative__do_next_screen()
    {
        require_lang('do_next');
        $list = array(
            array(
                'menu/welcome',
                array(
                    null,
                    array(),
                    ''
                )
            ),
            array(
                'menu/cms/cms',
                array(
                    null,
                    array(),
                    ''
                )
            ),
            array(
                'menu/adminzone/adminzone',
                array(
                    null,
                    array(),
                    ''
                )
            )
        );

        $sections = new Tempcode();
        $next_items = new Tempcode();
        $i = 0;
        foreach ($list as $_option) {
            $option = $_option[0];
            $next_items->attach(do_lorem_template('DO_NEXT_ITEM', array(
                'I' => strval($i),
                'TARGET' => null,
                'PICTURE' => $option,
                'DESCRIPTION' => lorem_phrase(),
                'URL' => placeholder_url(),
                'NUM_SIBLINGS' => strval(count($list)),
                'DOC' => '',
                'WARNING' => '',
            )));
            $i++;
        }
        $do_next_section = do_lorem_template('DO_NEXT_SECTION', array(
            'I' => placeholder_number(),
            'TITLE' => lorem_phrase(),
            'CONTENT' => $next_items,
        ));
        $sections->attach($do_next_section);

        return array(
            lorem_globalise(do_lorem_template('DO_NEXT_SCREEN', array(
                'INTRO' => lorem_phrase_html(),
                'QUESTION' => lorem_phrase(),
                'TITLE' => lorem_title(),
                'SECTIONS' => $sections,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__question_ui_buttons()
    {
        return array(
            lorem_globalise(do_lorem_template('QUESTION_UI_BUTTONS', array(
                'BUTTONS' => placeholder_array(),
                'IMAGES' => array(),
                'TITLE' => lorem_phrase(),
                'MESSAGE' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__pagination_screen()
    {
        return array(
            lorem_globalise(do_lorem_template('PAGINATION_SCREEN', array(
                'TITLE' => lorem_title(),
                'CONTENT' => lorem_phrase(),
                'BROWSE' => placeholder_pagination(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__full_message_screen()
    {
        return array(
            lorem_globalise(do_lorem_template('FULL_MESSAGE_SCREEN', array(
                'TITLE' => lorem_title(),
                'TEXT' => lorem_sentence(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__full_table_screen()
    {
        $table_rows = new Tempcode();
        foreach (placeholder_array() as $row) {
            $actions = do_lorem_template('COLUMNED_TABLE_ACTION_DELETE_ENTRY', array(
                'GET' => true,
                'HIDDEN' => '',
                'NAME' => lorem_phrase(),
                'URL' => placeholder_url(),
            ));
            $actions->attach(do_lorem_template('COLUMNED_TABLE_ACTION_INSTALL_ENTRY', array(
                'GET' => true,
                'HIDDEN' => '',
                'NAME' => lorem_phrase(),
                'URL' => placeholder_url(),
            )));
            $actions->attach(do_lorem_template('COLUMNED_TABLE_ACTION_UPGRADE_ENTRY', array(
                'GET' => true,
                'HIDDEN' => '',
                'NAME' => lorem_phrase(),
                'URL' => placeholder_url(),
            )));
            $actions->attach(do_lorem_template('COLUMNED_TABLE_ACTION_REINSTALL_ENTRY', array(
                'GET' => true,
                'HIDDEN' => '',
                'NAME' => lorem_phrase(),
                'URL' => placeholder_url(),
            )));

            $line = do_lorem_template('COLUMNED_TABLE_ROW_CELL_LINE', array(
                'LABEL' => lorem_phrase(),
                'NAME' => placeholder_random_id(),
                'VALUE' => lorem_phrase(),
            ));

            $select = do_lorem_template('COLUMNED_TABLE_ROW_CELL_SELECT', array(
                'LABEL' => lorem_phrase(),
                'NAME' => placeholder_random_id(),
                'LIST' => placeholder_options(),
            ));

            $tick = do_lorem_template('COLUMNED_TABLE_ROW_CELL_TICK', array(
                'LABEL' => lorem_phrase(),
                'NAME' => placeholder_random_id(),
                'VALUE' => lorem_phrase(),
            ));

            $values = array(
                lorem_word(),
                lorem_word(),
                lorem_word(),
                placeholder_date(),
                $line,
                $select,
                $tick,
                $actions
            );
            $cells = new Tempcode();
            foreach ($values as $value) {
                $cells->attach(do_lorem_template('COLUMNED_TABLE_ROW_CELL', array(
                    'VALUE' => $value,
                )));
            }

            $tpl = do_lorem_template('COLUMNED_TABLE_ROW', array(
                'CELLS' => $cells,
            ));
            $table_rows->attach($tpl);
        }

        $values = array(
            lorem_word(),
            lorem_word_2(),
            lorem_word(),
            lorem_word_2(),
            lorem_word(),
            lorem_word(),
            lorem_word(),
            lorem_word()
        );
        $cells = new Tempcode();
        foreach ($values as $value) {
            $cells->attach(do_lorem_template('COLUMNED_TABLE_HEADER_ROW_CELL', array(
                'VALUE' => $value,
            )));
        }

        $header_row = do_lorem_template('COLUMNED_TABLE_HEADER_ROW', array(
            'CELLS' => $cells,
        ));

        $field_rows = do_lorem_template('COLUMNED_TABLE', array(
            'HEADER_ROW' => $header_row,
            'ROWS' => $table_rows,
        ));

        $return = do_lorem_template('FORM_GROUPED', array(
            'TEXT' => '',
            'URL' => '#',
            'FIELD_GROUPS' => $field_rows,
            'SUBMIT_ICON' => 'buttons__proceed',
            'SUBMIT_NAME' => lorem_word_2(),
        ));

        return array(
            lorem_globalise($return, null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__result_table_screen()
    {
        //results_table starts
        //results_entry starts
        $array = placeholder_array();
        $cells = new Tempcode();
        foreach ($array as $k => $v) {
            if ($k == 1) {
                $cells->attach(do_lorem_template('RESULTS_TABLE_FIELD_TITLE', array(
                    'VALUE' => $v,
                )));
            } else {
                $cells->attach(do_lorem_template('RESULTS_TABLE_FIELD_TITLE_SORTABLE', array(
                    'VALUE' => $v,
                    'SORT_URL_DESC' => placeholder_url(),
                    'SORT_DESC_SELECTED' => lorem_word(),
                    'SORT_ASC_SELECTED' => lorem_word(),
                    'SORT_URL_ASC' => placeholder_url(),
                )));
            }
        }
        $fields_title = $cells;

        $order_entries = new Tempcode();
        foreach ($array as $k1 => $v) {
            $cells = new Tempcode();
            foreach ($array as $k2 => $v2) {
                $tick = do_lorem_template('RESULTS_TABLE_TICK', array(
                    'ID' => placeholder_id() . '_' . strval($k1) . '_' . strval($k2),
                ));
                $cells->attach(do_lorem_template('RESULTS_TABLE_FIELD', array(
                    'VALUE' => $tick,
                )));
            }
            $order_entries->attach(do_lorem_template('RESULTS_TABLE_ENTRY', array(
                'VALUES' => $cells,
            )));
        }
        //results_entry ends

        $selectors = new Tempcode();
        $sortable = null;
        foreach ($array as $k => $v) {
            $selectors->attach(do_lorem_template('PAGINATION_SORTER', array(
                'SELECTED' => '',
                'NAME' => $v,
                'VALUE' => $v,
            )));
        }
        $sort = do_lorem_template('PAGINATION_SORT', array(
            'HIDDEN' => '',
            'SORT' => lorem_word(),
            'URL' => placeholder_url(),
            'SELECTORS' => $selectors,
        ));

        $results_table = do_lorem_template('RESULTS_TABLE', array(
            'WIDTHS' => array(),
            'TEXT_ID' => placeholder_random_id(),
            'FIELDS_TITLE' => $fields_title,
            'FIELDS' => $order_entries,
            'MESSAGE' => '',
            'SORT' => $sort,
            'PAGINATION' => placeholder_pagination(),
        ));
        //results_table ends

        $table = do_lorem_template('RESULTS_TABLE_SCREEN', array(
            'TITLE' => lorem_title(),
            'RESULTS_TABLE' => $results_table,
        ));

        return array(
            lorem_globalise($table, null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__result_table_screen_2()
    {
        //results_table starts
        //results_entry starts
        $array = placeholder_array();
        $cells = new Tempcode();
        foreach ($array as $k => $v) {
            if ($k == 1) {
                $cells->attach(do_lorem_template('RESULTS_TABLE_FIELD_TITLE', array(
                    'VALUE' => $v,
                )));
            } else {
                $cells->attach(do_lorem_template('RESULTS_TABLE_FIELD_TITLE_SORTABLE', array(
                    'VALUE' => $v,
                    'SORT_URL_DESC' => placeholder_url(),
                    'SORT_DESC_SELECTED' => lorem_word(),
                    'SORT_ASC_SELECTED' => lorem_word(),
                    'SORT_URL_ASC' => placeholder_url(),
                )));
            }
        }
        $fields_title = $cells;

        $order_entries = new Tempcode();
        foreach ($array as $k1 => $v) {
            $cells = new Tempcode();
            foreach ($array as $k2 => $v2) {
                $tick = do_lorem_template('RESULTS_TABLE_TICK', array(
                    'ID' => placeholder_id() . '_' . strval($k1) . '_' . strval($k2),
                ));
                $cells->attach(do_lorem_template('RESULTS_TABLE_FIELD', array(
                    'VALUE' => $tick,
                )));
            }
            $order_entries->attach(do_lorem_template('RESULTS_TABLE_ENTRY', array(
                'VALUES' => $cells,
            )));
        }
        //results_entry ends

        $selectors = new Tempcode();
        $sortable = null;
        foreach ($array as $k => $v) {
            $selectors->attach(do_lorem_template('PAGINATION_SORTER', array(
                'SELECTED' => '',
                'NAME' => $v,
                'VALUE' => $v,
            )));
        }
        $sort = do_lorem_template('PAGINATION_SORT', array(
            'HIDDEN' => '',
            'SORT' => lorem_word(),
            'URL' => placeholder_url(),
            'SELECTORS' => $selectors,
        ));

        $results_table = do_lorem_template('RESULTS_TABLE', array(
            'WIDTHS' => array(),
            'TEXT_ID' => placeholder_random_id(),
            'FIELDS_TITLE' => $fields_title,
            'FIELDS' => $order_entries,
            'MESSAGE' => '',
            'SORT' => $sort,
            'PAGINATION' => placeholder_pagination(),
        ));
        //results_table ends

        $table = do_lorem_template('RESULTS_TABLE_SCREEN', array(
            'TITLE' => lorem_title(),
            'RESULTS_TABLE' => $results_table,
        ));

        return array(
            lorem_globalise($table, null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__result_launcher_screen()
    {
        require_lang('cns');
        $part = new Tempcode();
        foreach (placeholder_array() as $k => $v) {
            $part->attach(do_lorem_template('RESULTS_LAUNCHER_PAGE_NUMBER_LINK', array(
                'TITLE' => lorem_phrase(),
                'URL' => placeholder_url(),
                'P' => placeholder_number(),
            )));
            $part->attach(do_lorem_template('RESULTS_LAUNCHER_CONTINUE', array(
                'TITLE' => lorem_phrase(),
                'MAX' => placeholder_number(),
                'NUM_PAGES' => placeholder_number(),
                'URL_STUB' => placeholder_url(),
            )));
        }

        $pages = do_lorem_template('RESULTS_LAUNCHER_WRAP', array(
            'PART' => $part,
        ));

        return array(
            lorem_globalise($pages, null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__administrative__columned_table_screen()
    {
        return array(
            lorem_globalise(do_lorem_template('COLUMNED_TABLE_SCREEN', array(
                'TITLE' => lorem_title(),
                'TABLE' => placeholder_table(),
                'SUBMIT_ICON' => 'buttons__proceed',
                'SUBMIT_NAME' => lorem_word(),
                'POST_URL' => placeholder_url(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__member_tooltip()
    {
        return array(
            lorem_globalise(do_lorem_template('MEMBER_TOOLTIP', array(
                'SUBMITTER' => placeholder_id(),
            )), null, '', true)
        );
    }
}
