<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    core_rich_media
 */

/**
 * Hook class.
 */
class Hook_addon_registry_core_rich_media
{
    /**
     * Get a list of file permissions to set
     *
     * @param  boolean $runtime Whether to include wildcards represented runtime-created chmoddable files
     * @return array File permissions to set
     */
    public function get_chmod_array($runtime = false)
    {
        return array();
    }

    /**
     * Get the version of Composr this addon is for
     *
     * @return float Version number
     */
    public function get_version()
    {
        return cms_version_number();
    }

    /**
     * Get the description of the addon
     *
     * @return string Description of the addon
     */
    public function get_description()
    {
        return 'Comcode and attachments.';
    }

    /**
     * Get a list of tutorials that apply to this addon
     *
     * @return array List of tutorials
     */
    public function get_applicable_tutorials()
    {
        return array(
            'tut_comcode',
            'tut_adv_comcode',
            'tut_wysiwyg',
        );
    }

    /**
     * Get a mapping of dependency types
     *
     * @return array File permissions to set
     */
    public function get_dependencies()
    {
        return array(
            'requires' => array(),
            'recommends' => array(),
            'conflicts_with' => array(),
        );
    }

    /**
     * Explicitly say which icon should be used
     *
     * @return URLPATH Icon
     */
    public function get_default_icon()
    {
        return 'themes/default/images/icons/48x48/menu/_generic_admin/component.png';
    }

    /**
     * Get a list of files that belong to this addon
     *
     * @return array List of files
     */
    public function get_file_list()
    {
        return array(
            'themes/default/images/EN/1x/editor/index.html',
            'themes/default/images/EN/2x/editor/index.html',
            'themes/default/images/icons/16x16/editor/insert_emoticons.png',
            'themes/default/images/icons/16x16/editor/wysiwyg_off.png',
            'themes/default/images/icons/16x16/editor/wysiwyg_on.png',
            'themes/default/images/icons/32x32/editor/insert_emoticons.png',
            'themes/default/images/icons/32x32/editor/wysiwyg_off.png',
            'themes/default/images/icons/32x32/editor/wysiwyg_on.png',
            'themes/default/images/icons/16x16/editor/index.html',
            'themes/default/images/icons/32x32/editor/index.html',
            'sources/hooks/systems/addon_registry/core_rich_media.php',
            'themes/default/javascript/dyn_comcode.js',
            'themes/default/templates/EMOTICON_CLICK_CODE.tpl',
            'themes/default/templates/EMOTICON_IMG_CODE_DIR.tpl',
            'themes/default/templates/EMOTICON_IMG_CODE_THEMED.tpl',
            'themes/default/templates/ATTACHMENT.tpl',
            'themes/default/templates/ATTACHMENTS.tpl',
            'themes/default/templates/ATTACHMENTS_BROWSER.tpl',
            'themes/default/templates/COMCODE_ABBR.tpl',
            'themes/default/templates/COMCODE_ADDRESS.tpl',
            'themes/default/templates/COMCODE_ALIGN.tpl',
            'themes/default/templates/COMCODE_BOLD.tpl',
            'themes/default/templates/COMCODE_CITE.tpl',
            'themes/default/templates/COMCODE_CODE.tpl',
            'themes/default/templates/COMCODE_CODE_SCROLL.tpl',
            'themes/default/templates/COMCODE_CONCEPT.tpl',
            'themes/default/templates/COMCODE_CONCEPTS.tpl',
            'themes/default/templates/COMCODE_CONTENTS.tpl',
            'themes/default/templates/COMCODE_CONTENTS_LEVEL.tpl',
            'themes/default/templates/COMCODE_CRITICAL_PARSE_ERROR.tpl',
            'themes/default/templates/COMCODE_DEL.tpl',
            'themes/default/templates/COMCODE_DFN.tpl',
            'themes/default/templates/COMCODE_EDITOR_BUTTON.tpl',
            'themes/default/templates/COMCODE_EDITOR_MICRO_BUTTON.tpl',
            'themes/default/templates/COMCODE_PAGE_EDIT_SCREEN.tpl',
            'themes/default/templates/COMCODE_EMAIL.tpl',
            'themes/default/templates/COMCODE_FONT.tpl',
            'themes/default/templates/COMCODE_TELETYPE.tpl',
            'themes/default/templates/COMCODE_SAMP.tpl',
            'themes/default/templates/COMCODE_Q.tpl',
            'themes/default/templates/COMCODE_VAR.tpl',
            'themes/default/templates/COMCODE_SHOCKER.tpl',
            'themes/default/templates/COMCODE_HIDE.tpl',
            'themes/default/templates/COMCODE_HIGHLIGHT.tpl',
            'themes/default/templates/COMCODE_IMG.tpl',
            'themes/default/templates/COMCODE_INDENT.tpl',
            'themes/default/templates/COMCODE_INS.tpl',
            'themes/default/templates/COMCODE_ITALICS.tpl',
            'themes/default/templates/COMCODE_JUMPING.tpl',
            'themes/default/templates/COMCODE_MESSAGE.tpl',
            'themes/default/templates/COMCODE_SUBTITLE.tpl',
            'themes/default/templates/COMCODE_MISTAKE_ERROR.tpl',
            'themes/default/templates/COMCODE_MISTAKE_LINE.tpl',
            'themes/default/templates/COMCODE_MISTAKE_SCREEN.tpl',
            'themes/default/templates/COMCODE_QUOTE.tpl',
            'themes/default/templates/COMCODE_QUOTE_BY.tpl',
            'themes/default/templates/COMCODE_RANDOM.tpl',
            'themes/default/templates/COMCODE_REFERENCE.tpl',
            'themes/default/templates/COMCODE_STRIKE.tpl',
            'themes/default/templates/COMCODE_SUB.tpl',
            'themes/default/templates/COMCODE_SUP.tpl',
            'themes/default/templates/COMCODE_THUMB.tpl',
            'themes/default/templates/COMCODE_TICKER.tpl',
            'themes/default/templates/COMCODE_UNDERLINE.tpl',
            'themes/default/templates/COMCODE_URL.tpl',
            'themes/default/templates/COMCODE_SURROUND.tpl',
            'themes/default/templates/COMCODE_TEXTCODE_LINE.tpl',
            'themes/default/templates/COMCODE_TEXTCODE_TAB.tpl',
            'themes/default/templates/COMCODE_WIKI_LINK.tpl',
            'themes/default/templates/COMCODE_CONCEPT_INLINE.tpl',
            'themes/default/templates/COMCODE_CURRENCY.tpl',
            'themes/default/templates/COMCODE_FAKE_TABLE_WRAP_START.tpl',
            'themes/default/templates/COMCODE_FAKE_TABLE_START_CELL.tpl',
            'themes/default/templates/COMCODE_FAKE_TABLE_WIDE_START_CELL.tpl',
            'themes/default/templates/COMCODE_FAKE_TABLE_WIDE_CELL.tpl',
            'themes/default/templates/COMCODE_FAKE_TABLE_CELL.tpl',
            'themes/default/templates/COMCODE_FAKE_TABLE_END_CELL.tpl',
            'themes/default/templates/COMCODE_FAKE_TABLE_WRAP_END.tpl',
            'themes/default/templates/COMCODE_IF_IN_GROUP.tpl',
            'themes/default/templates/COMCODE_OVERLAY.tpl',
            'themes/default/templates/COMCODE_CAROUSEL.tpl',
            'themes/default/templates/COMCODE_SECTION.tpl',
            'themes/default/templates/COMCODE_SECTION_CONTROLLER.tpl',
            'themes/default/templates/COMCODE_TAB_CONTROLLER.tpl',
            'themes/default/templates/COMCODE_TAB_HEAD.tpl',
            'themes/default/templates/COMCODE_TAB_BODY.tpl',
            'themes/default/templates/COMCODE_SNAPBACK.tpl',
            'themes/default/templates/COMCODE_TOOLTIP.tpl',
            'themes/default/templates/COMCODE_REAL_TABLE_CELL.tpl',
            'themes/default/templates/COMCODE_REAL_TABLE_END.tpl',
            'themes/default/templates/COMCODE_REAL_TABLE_ROW_END.tpl',
            'themes/default/templates/COMCODE_REAL_TABLE_ROW_START.tpl',
            'themes/default/templates/COMCODE_REAL_TABLE_START.tpl',
            'themes/default/templates/COMCODE_PULSE.tpl',
            'themes/default/javascript/pulse.js',
            'themes/default/templates/COMCODE_BIG_TABS_CONTROLLER.tpl',
            'themes/default/templates/COMCODE_BIG_TABS_TAB.tpl',
            'themes/default/templates/MEDIA_AUDIO_WEBSAFE.tpl',
            'themes/default/templates/MEDIA_FLASH.tpl',
            'themes/default/templates/MEDIA_IMAGE_WEBSAFE.tpl',
            'themes/default/templates/MEDIA_PDF.tpl',
            'themes/default/templates/MEDIA_QUICKTIME.tpl',
            'themes/default/templates/MEDIA_REALMEDIA.tpl',
            'themes/default/templates/MEDIA_SVG.tpl',
            'themes/default/templates/MEDIA_VIDEO_FACEBOOK.tpl',
            'themes/default/templates/MEDIA_VIDEO_GENERAL.tpl',
            'themes/default/templates/MEDIA_VIDEO_WEBSAFE.tpl',
            'themes/default/templates/MEDIA_VIMEO.tpl',
            'themes/default/templates/MEDIA_WEBPAGE_OEMBED_RICH.tpl',
            'themes/default/templates/MEDIA_WEBPAGE_OEMBED_VIDEO.tpl',
            'themes/default/templates/MEDIA_WEBPAGE_SEMANTIC.tpl',
            'themes/default/templates/MEDIA_YOUTUBE.tpl',
            'themes/default/templates/MEDIA_DOWNLOAD.tpl',
            'themes/default/templates/MEDIA__DOWNLOAD_LINK.tpl',
            'themes/default/css/big_tabs.css',
            'themes/default/css/comcode_mistakes.css',
            'themes/default/images/icons/14x14/wiki_link.png',
            'themes/default/images/icons/14x14/wiki_link_hover.png',
            'themes/default/images/icons/28x28/wiki_link.png',
            'themes/default/images/icons/28x28/wiki_link_hover.png',
            'themes/default/images/carousel/button_left_hover.png',
            'themes/default/images/carousel/button_left.png',
            'themes/default/images/carousel/button_right_hover.png',
            'themes/default/images/carousel/button_right.png',
            'themes/default/images/carousel/fade_left.png',
            'themes/default/images/carousel/fade_right.png',
            'themes/default/images/carousel/index.html',
            'themes/default/images/big_tabs_controller_button_active.png',
            'themes/default/images/big_tabs_controller_button_top_active.png',
            'themes/default/images/big_tabs_controller_button_top.png',
            'themes/default/images/big_tabs_controller_button.png',
            'data/jwplayer.flash.swf',
            'themes/default/javascript/jwplayer.js',
            'sources/hooks/systems/notifications/member_mention.php',
            'sources/member_mentions.php',
            'data/attachment.php',
            'data/attachment_popup.php',
            'data/emoticons.php',
            'data/comcode_helper.php',
            'data/thumb.php',
            'data/comcode_convert.php',
            'lang/EN/comcode.ini',
            'sources/comcode.php',
            'sources/comcode_tools.php',
            'sources/comcode_cleanup.php',
            'sources/comcode_check.php',
            'sources/comcode_from_html.php',
            'sources/comcode_renderer.php',
            'sources/comcode_compiler.php',
            'sources/attachments.php',
            'sources/attachments2.php',
            'sources/attachments3.php',
            'sources/comcode_add.php',
            'sources/hooks/systems/attachments/.htaccess',
            'sources_custom/hooks/systems/attachments/.htaccess',
            'sources/hooks/systems/attachments/index.html',
            'sources_custom/hooks/systems/attachments/index.html',
            'sources/hooks/systems/attachments/null.php',
            'sources/blocks/main_emoticon_codes.php',
            'sources/hooks/systems/comcode_link_handlers/.htaccess',
            'sources_custom/hooks/systems/comcode_link_handlers/.htaccess',
            'sources/hooks/systems/comcode_link_handlers/index.html',
            'sources_custom/hooks/systems/comcode_link_handlers/index.html',
            'sources/hooks/systems/preview/comcode_tag.php',
            'sources/hooks/systems/config/attachment_cleanup.php',
            'sources/hooks/systems/config/attachment_default_height.php',
            'sources/hooks/systems/config/attachment_default_width.php',
            'sources/hooks/systems/config/simplified_attachments_ui.php',
            'sources/hooks/systems/config/oembed_html_whitelist.php',
            'sources/hooks/systems/config/oembed_manual_patterns.php',
            'sources/hooks/systems/config/oembed_max_size.php',
            'sources/hooks/systems/media_rendering/audio_general.php',
            'sources/hooks/systems/media_rendering/audio_microsoft.php',
            'sources/hooks/systems/media_rendering/audio_websafe.php',
            'sources/hooks/systems/media_rendering/code.php',
            'sources/hooks/systems/media_rendering/flash.php',
            'sources/hooks/systems/media_rendering/hyperlink.php',
            'sources/hooks/systems/media_rendering/image_websafe.php',
            'sources/hooks/systems/media_rendering/index.html',
            'sources_custom/hooks/systems/media_rendering/.htaccess',
            'sources_custom/hooks/systems/media_rendering/index.html',
            'sources/hooks/systems/comcode_preparse/.htaccess',
            'sources_custom/hooks/systems/comcode_preparse/.htaccess',
            'sources/hooks/systems/comcode_preparse/index.html',
            'sources_custom/hooks/systems/comcode_preparse/index.html',
            'sources/hooks/systems/media_rendering/email.php',
            'sources/hooks/systems/media_rendering/oembed.php',
            'sources/hooks/systems/media_rendering/pdf.php',
            'sources/hooks/systems/media_rendering/quicktime.php',
            'sources/hooks/systems/media_rendering/realaudio.php',
            'sources/hooks/systems/media_rendering/realmedia.php',
            'sources/hooks/systems/media_rendering/svg.php',
            'sources/hooks/systems/media_rendering/video_facebook.php',
            'sources/hooks/systems/media_rendering/video_general.php',
            'sources/hooks/systems/media_rendering/video_microsoft.php',
            'sources/hooks/systems/media_rendering/video_websafe.php',
            'sources/hooks/systems/media_rendering/vimeo.php',
            'sources/hooks/systems/media_rendering/youtube.php',
            'sources/hooks/systems/media_rendering/.htaccess',
            'sources/hooks/systems/comcode_link_handlers/media_rendering.php',
            'sources/media_renderer.php',
            'uploads/attachments/index.html',
            'uploads/attachments_thumbs/index.html',
            'uploads/attachments/.htaccess',
            'uploads/attachments_thumbs/.htaccess',
            'themes/default/templates/COMCODE_MEMBER_LINK.tpl',
            'themes/default/templates/COMCODE_MEDIA_SET.tpl',
            'themes/default/javascript/jquery_autocomplete.js',
            'themes/default/css/autocomplete.css',
            'themes/default/javascript/AUTOCOMPLETE_LOAD.js',
            'themes/default/images/mediaset_next.png',
            'themes/default/images/mediaset_previous.png',
        );
    }

    /**
     * Get mapping between template names and the method of this class that can render a preview of them
     *
     * @return array The mapping
     */
    public function tpl_previews()
    {
        return array(
            'templates/EMOTICON_CLICK_CODE.tpl' => 'emoticon_click_code',
            'templates/EMOTICON_IMG_CODE_DIR.tpl' => 'emoticon_click_code',
            'templates/EMOTICON_IMG_CODE_THEMED.tpl' => 'emoticon_click_code',
            'templates/ATTACHMENT.tpl' => 'attachments',
            'templates/ATTACHMENTS.tpl' => 'attachments',
            'templates/ATTACHMENTS_BROWSER.tpl' => 'attachments_browser',
            'templates/COMCODE_BIG_TABS_TAB.tpl' => 'comcode_big_tabs',
            'templates/COMCODE_BIG_TABS_CONTROLLER.tpl' => 'comcode_big_tabs',
            'templates/COMCODE_PAGE_EDIT_SCREEN.tpl' => 'comcode_page_edit_screen',
            'templates/COMCODE_TOOLTIP.tpl' => 'comcode_tooltip',
            'templates/COMCODE_CRITICAL_PARSE_ERROR.tpl' => 'comcode_critical_parse_error',
            'templates/COMCODE_MISTAKE_ERROR.tpl' => 'comcode_mistake_screen',
            'templates/COMCODE_MISTAKE_LINE.tpl' => 'comcode_mistake_screen',
            'templates/COMCODE_MISTAKE_SCREEN.tpl' => 'comcode_mistake_screen',
            'templates/COMCODE_CURRENCY.tpl' => 'comcode_currency',
            'templates/COMCODE_OVERLAY.tpl' => 'comcode_overlay',
            'templates/COMCODE_SNAPBACK.tpl' => 'comcode_snapback',
            'templates/COMCODE_SECTION.tpl' => 'comcode_section_controller',
            'templates/COMCODE_SECTION_CONTROLLER.tpl' => 'comcode_section_controller',
            'templates/COMCODE_CAROUSEL.tpl' => 'comcode_carousel',
            'templates/COMCODE_IF_IN_GROUP.tpl' => 'comcode_if_in_group',
            'templates/COMCODE_ABBR.tpl' => 'comcode_abbr',
            'templates/COMCODE_ADDRESS.tpl' => 'comcode_address',
            'templates/COMCODE_DFN.tpl' => 'comcode_dfn',
            'templates/COMCODE_PULSE.tpl' => 'comcode_pulse',
            'templates/COMCODE_DEL.tpl' => 'comcode_del',
            'templates/COMCODE_INS.tpl' => 'comcode_ins',
            'templates/COMCODE_CITE.tpl' => 'comcode_cite',
            'templates/COMCODE_BOLD.tpl' => 'comcode_bold',
            'templates/COMCODE_ALIGN.tpl' => 'comcode_align',
            'templates/COMCODE_INDENT.tpl' => 'comcode_indent',
            'templates/COMCODE_SURROUND.tpl' => 'comcode_surround',
            'templates/COMCODE_ITALICS.tpl' => 'comcode_italics',
            'templates/COMCODE_UNDERLINE.tpl' => 'comcode_underline',
            'templates/COMCODE_STRIKE.tpl' => 'comcode_strike',
            'templates/COMCODE_SUP.tpl' => 'comcode_sup',
            'templates/COMCODE_SUB.tpl' => 'comcode_sub',
            'templates/COMCODE_RANDOM.tpl' => 'comcode_random',
            'templates/COMCODE_JUMPING.tpl' => 'comcode_jumping',
            'templates/COMCODE_TICKER.tpl' => 'comcode_ticker',
            'templates/COMCODE_HIGHLIGHT.tpl' => 'comcode_highlight',
            'templates/COMCODE_FONT.tpl' => 'comcode_font',
            'templates/COMCODE_CONCEPT.tpl' => 'comcode_concept',
            'templates/COMCODE_CONCEPT_INLINE.tpl' => 'comcode_concept_inline',
            'templates/COMCODE_CONCEPTS.tpl' => 'comcode_concepts',
            'templates/COMCODE_THUMB.tpl' => 'comcode_thumb',
            'templates/COMCODE_IMG.tpl' => 'comcode_img',
            'templates/COMCODE_URL.tpl' => 'comcode_url',
            'templates/COMCODE_EMAIL.tpl' => 'comcode_email',
            'templates/COMCODE_REFERENCE.tpl' => 'comcode_reference',
            'templates/COMCODE_HIDE.tpl' => 'comcode_hide',
            'templates/COMCODE_SHOCKER.tpl' => 'comcode_shocker',
            'templates/COMCODE_QUOTE_BY.tpl' => 'comcode_quote_by',
            'templates/COMCODE_Q.tpl' => 'comcode_q',
            'templates/COMCODE_QUOTE.tpl' => 'comcode_quote',
            'templates/COMCODE_CONTENTS.tpl' => 'comcode_contents',
            'templates/COMCODE_CONTENTS_LEVEL.tpl' => 'comcode_contents',
            'templates/COMCODE_TEXTCODE_LINE.tpl' => 'comcode_textcode_line',
            'templates/COMCODE_TEXTCODE_TAB.tpl' => 'comcode_textcode_tab',
            'templates/COMCODE_WIKI_LINK.tpl' => 'comcode_wiki_link',
            'templates/COMCODE_FAKE_TABLE_WRAP_START.tpl' => 'comcode_table_fake_screen',
            'templates/COMCODE_FAKE_TABLE_WIDE_START_CELL.tpl' => 'comcode_table_fake_wide_screen',
            'templates/COMCODE_FAKE_TABLE_START_CELL.tpl' => 'comcode_table_fake_screen',
            'templates/COMCODE_FAKE_TABLE_END_CELL.tpl' => 'comcode_table_fake_screen',
            'templates/COMCODE_FAKE_TABLE_WIDE_CELL.tpl' => 'comcode_table_fake_wide_screen',
            'templates/COMCODE_FAKE_TABLE_CELL.tpl' => 'comcode_table_fake_screen',
            'templates/COMCODE_FAKE_TABLE_WRAP_END.tpl' => 'comcode_table_fake_screen',
            'templates/COMCODE_REAL_TABLE_START.tpl' => 'comcode_table_real_screen',
            'templates/COMCODE_REAL_TABLE_ROW_START.tpl' => 'comcode_table_real_screen',
            'templates/COMCODE_REAL_TABLE_CELL.tpl' => 'comcode_table_real_screen',
            'templates/COMCODE_REAL_TABLE_ROW_END.tpl' => 'comcode_table_real_screen',
            'templates/COMCODE_REAL_TABLE_END.tpl' => 'comcode_table_real_screen',
            'templates/COMCODE_SUBTITLE.tpl' => 'comcode_subtitle',
            'templates/COMCODE_TAB_BODY.tpl' => 'comcode_tab_body',
            'templates/COMCODE_SAMP.tpl' => 'comcode_samp',
            'templates/COMCODE_VAR.tpl' => 'comcode_var',
            'templates/COMCODE_TELETYPE.tpl' => 'comcode_teletype',
            'templates/COMCODE_TAB_CONTROLLER.tpl' => 'comcode_tab_body',
            'templates/COMCODE_TAB_HEAD.tpl' => 'comcode_tab_body',
            'templates/COMCODE_CODE.tpl' => 'comcode_code',
            'templates/COMCODE_CODE_SCROLL.tpl' => 'comcode_code_scroll',
            'templates/MEDIA_AUDIO_WEBSAFE.tpl' => 'media_audio_websafe',
            'templates/MEDIA_FLASH.tpl' => 'media_flash',
            'templates/MEDIA_IMAGE_WEBSAFE.tpl' => 'media_image_websafe',
            'templates/MEDIA_PDF.tpl' => 'media_pdf',
            'templates/MEDIA_QUICKTIME.tpl' => 'media_quicktime',
            'templates/MEDIA_REALMEDIA.tpl' => 'media_realmedia',
            'templates/MEDIA_SVG.tpl' => 'media_svg',
            'templates/MEDIA_VIDEO_FACEBOOK.tpl' => 'media_video_facebook',
            'templates/MEDIA_VIDEO_GENERAL.tpl' => 'media_video_general',
            'templates/MEDIA_VIDEO_WEBSAFE.tpl' => 'media_video_websafe',
            'templates/MEDIA_VIMEO.tpl' => 'media_vimeo',
            'templates/MEDIA_WEBPAGE_OEMBED_RICH.tpl' => 'media_webpage_oembed_rich',
            'templates/MEDIA_WEBPAGE_OEMBED_VIDEO.tpl' => 'media_webpage_oembed_video',
            'templates/MEDIA_WEBPAGE_SEMANTIC.tpl' => 'media_webpage_semantic',
            'templates/MEDIA_YOUTUBE.tpl' => 'media_youtube',
            'templates/MEDIA_DOWNLOAD.tpl' => 'media_download',
            'templates/MEDIA__DOWNLOAD_LINK.tpl' => 'media__download_link',
            'templates/COMCODE_MEMBER_LINK.tpl' => 'comcode_member_link',
            'javascript/AUTOCOMPLETE_LOAD.js' => 'autocomplete_load',
            'templates/COMCODE_MEDIA_SET.tpl' => 'comcode_media_set',
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_big_tabs()
    {
        $content = new Tempcode();

        $page = array();
        foreach (placeholder_array(4) as $v) {
            $page[] = $v;
        }
        $content->attach(do_lorem_template('COMCODE_BIG_TABS_CONTROLLER', array(
            'PASS_ID' => placeholder_random_id(),
            'SWITCH_TIME' => '6000',
            'TABS' => $page,
        )));

        foreach ($page as $i => $v) {
            $content->attach(do_lorem_template('COMCODE_BIG_TABS_TAB', array(
                'PASS_ID' => placeholder_random_id() . strval($i),
                'CONTENT' => lorem_paragraph() . strval($i),
                'NAME' => $v,
                'DEFAULT' => ($i == 0),
            )));
        }

        $content = do_lorem_template('COMCODE_SURROUND', array(
            'CLASS' => 'float_surrounder',
            'CONTENT' => $content,
        ));

        return array(
            lorem_globalise($content, null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_page_edit_screen()
    {
        require_lang('zones');

        return array(
            lorem_globalise(do_lorem_template('COMCODE_PAGE_EDIT_SCREEN', array(
                'NEW' => lorem_phrase(),
                'PING_URL' => placeholder_url(),
                'WARNING_DETAILS' => '',
                'TEXT' => lorem_sentence_html(),
                'TITLE' => lorem_title(),
                'DELETE_URL' => placeholder_url(),
                'ZONE' => lorem_phrase(),
                'FILE' => lorem_phrase(),
                'EXPORT_URL' => placeholder_url(),
                'POSTING_FORM' => placeholder_form(),
                'REVISIONS' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_tooltip()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_TOOLTIP', array(
                'URL' => placeholder_url(),
                'TOOLTIP' => lorem_phrase(),
                'CONTENT' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__emoticon_click_code()
    {
        $emoticon = placeholder_emoticons();
        $emt = new Tempcode();
        foreach ($emoticon as $k => $v) {
            $_emt = do_lorem_template('EMOTICON_IMG_CODE_THEMED', array(
                'EMOTICON' => $k,
                'SRC' => $v[1],
            ));
            $emt->attach(do_lorem_template('EMOTICON_CLICK_CODE', array(
                'FIELD_NAME' => lorem_word(),
                'CODE' => lorem_word(),
                'IMAGE' => $_emt,
            )));
        }
        $_emt = do_lorem_template('EMOTICON_IMG_CODE_DIR', array(
            'EMOTICON' => lorem_word(),
            'SRC' => get_base_url() . '/themes/default/images//cns_emoticons/constipated.png',
        ));
        $emt->attach(do_lorem_template('EMOTICON_CLICK_CODE', array(
            'FIELD_NAME' => lorem_word(),
            'CODE' => lorem_word(),
            'IMAGE' => $_emt,
        )));

        return array(
            lorem_globalise($emt, null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__attachments()
    {
        require_javascript('checking');
        require_javascript('plupload');
        require_javascript('posting');
        require_javascript('editing');

        require_css('forms');

        $content = do_lorem_template('ATTACHMENT', array(
            'I' => placeholder_number(),
            'POSTING_FIELD_NAME' => '',
        ));

        $attachments = do_lorem_template('ATTACHMENTS', array(
            'ATTACHMENT_TEMPLATE' => $content,
            'IMAGE_TYPES' => placeholder_types(),
            'ATTACHMENTS' => $content,
            'POSTING_FIELD_NAME' => '',
            'MAX_ATTACHMENTS' => placeholder_number(),
            'NUM_ATTACHMENTS' => placeholder_number(),
        ));

        return array(
            lorem_globalise(do_lorem_template('POSTING_FORM', array(
                'TABINDEX_PF' => placeholder_number(),
                'JAVASCRIPT' => '',
                'PREVIEW' => lorem_phrase(),
                'COMCODE_EDITOR' => lorem_phrase(),
                'COMCODE_EDITOR_SMALL' => lorem_phrase(),
                'CLASS' => lorem_phrase(),
                'COMCODE_URL' => placeholder_url(),
                'EXTRA' => lorem_phrase(),
                'POST_COMMENT' => lorem_phrase(),
                'EMOTICON_CHOOSER' => lorem_phrase(),
                'SUBMIT_ICON' => 'buttons__proceed',
                'SUBMIT_NAME' => lorem_word(),
                'HIDDEN_FIELDS' => '',
                'URL' => placeholder_url(),
                'POST' => lorem_phrase(),
                'DEFAULT_PARSED' => lorem_phrase(),
                'CONTINUE_URL' => placeholder_url(),
                'ATTACHMENTS' => $attachments,
                'SPECIALISATION' => placeholder_fields(),
                'SPECIALISATION2' => placeholder_fields(),
                'REQUIRED' => true,
                'SUPPORT_AUTOSAVE' => true,
                'DESCRIPTION' => lorem_paragraph(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_critical_parse_error()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_CRITICAL_PARSE_ERROR', array(
                'LINE' => lorem_phrase(),
                'MESSAGE' => lorem_phrase(),
                'SOURCE' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_mistake_screen()
    {
        $line = new Tempcode();
        foreach (placeholder_array() as $key => $value) {
            $line_content = new Tempcode();
            $line_content->attach(lorem_phrase());
            if ($key == 0) {
                $line_content->attach(do_lorem_template('COMCODE_MISTAKE_ERROR', array()));
            }

            $line->attach(do_lorem_template('COMCODE_MISTAKE_LINE', array(
                'NUMBER' => placeholder_number(),
                'LINE' => $line_content,
            )));
        }

        return array(
            lorem_globalise(do_lorem_template('COMCODE_MISTAKE_SCREEN', array(
                'EDITABLE' => true,
                'FORM' => placeholder_form(),
                'TITLE' => lorem_title(),
                'LINE' => lorem_phrase(),
                'MESSAGE' => lorem_phrase(),
                'LINES' => $line,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_currency()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_CURRENCY', array(
                'AMOUNT' => placeholder_number(),
                'FROM_CURRENCY' => 'USD',
                'BRACKET' => true,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_overlay()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_OVERLAY', array(
                'EMBED' => lorem_phrase(),
                'ID' => placeholder_id(),
                'X' => placeholder_number(),
                'Y' => placeholder_number(),
                'WIDTH' => placeholder_number(),
                'HEIGHT' => placeholder_number(),
                'TIMEIN' => '1000',
                'TIMEOUT' => '5000',
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_snapback()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_SNAPBACK', array(
                'URL' => placeholder_url(),
                'TITLE' => lorem_phrase(),
                'POST_ID' => placeholder_id(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_section_controller()
    {
        $section = new Tempcode();
        foreach (placeholder_array() as $k => $v) {
            $section->attach(do_lorem_template('COMCODE_SECTION', array(
                'PASS_ID' => placeholder_random_id(),
                'DEFAULT' => false,
                'NAME' => strval($k + 1),
                'CONTENT' => lorem_paragraph(),
            )));
        }
        $k++;
        $section->attach(do_lorem_template('COMCODE_SECTION', array(
            'PASS_ID' => placeholder_random_id(),
            'DEFAULT' => true,
            'NAME' => strval($k + 1),
            'CONTENT' => lorem_paragraph(),
        )));
        $page = array();
        foreach (placeholder_array(4) as $k => $v) {
            $page[] = strval($k + 1);
        }
        $section->attach(do_lorem_template('COMCODE_SECTION_CONTROLLER', array(
            'SECTIONS' => $page,
            'PASS_ID' => placeholder_random_id(),
        )));

        return array(
            lorem_globalise($section, null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_carousel()
    {
        $content = new Tempcode();
        foreach (placeholder_array(10) as $v) {
            $content->attach(placeholder_image());
        }
        return array(
            lorem_globalise(do_lorem_template('COMCODE_CAROUSEL', array(
                'CONTENT' => $content,
                'SCROLL_AMOUNT' => placeholder_number(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_if_in_group()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_IF_IN_GROUP', array(
                'TYPE' => '',
                'CONTENT' => lorem_phrase(),
                'GROUPS' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_abbr()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_ABBR', array(
                'CONTENT' => lorem_phrase(),
                'TITLE' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_address()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_ADDRESS', array(
                'CONTENT' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_dfn()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_DFN', array(
                'CONTENT' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_q()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_Q', array(
                'CONTENT' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_pulse()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_PULSE', array(
                'CONTENT' => lorem_phrase(),
                'MIN_COLOR' => '#000000',
                'MAX_COLOR' => '#FFFFFF',
                'SPEED' => '1000',
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_del()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_DEL', array(
                'CONTENT' => lorem_phrase(),
                'CITE' => lorem_word(),
                'DATETIME' => placeholder_date(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_ins()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_INS', array(
                'CONTENT' => lorem_phrase(),
                'CITE' => lorem_word(),
                'DATETIME' => placeholder_date(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_cite()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_CITE', array(
                'CONTENT' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_bold()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_BOLD', array(
                'CONTENT' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_align()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_ALIGN', array(
                'ALIGN' => 'left',
                'CONTENT' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_indent()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_INDENT', array(
                'INDENT' => placeholder_id(),
                'CONTENT' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_surround()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_SURROUND', array(
                'CLASS' => lorem_phrase(),
                'CONTENT' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_italics()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_ITALICS', array(
                'CONTENT' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_underline()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_UNDERLINE', array(
                'CONTENT' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_strike()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_STRIKE', array(
                'CONTENT' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_sup()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_SUP', array(
                'CONTENT' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_sub()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_SUB', array(
                'CONTENT' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_random()
    {
        $parts = array();
        foreach (placeholder_array(5) as $k => $v) {
            $parts[] = array(
                'NUM' => strval($k),
                'VAL' => placeholder_number(),
            );
        }
        return array(
            lorem_globalise(do_lorem_template('COMCODE_RANDOM', array(
                'FULL' => placeholder_number(),
                'MAX' => '3',
                'PARTS' => $parts,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_jumping()
    {
        $parts = array();
        $parts[] = array(
            'PART' => lorem_phrase(),
        );

        return array(
            lorem_globalise(do_lorem_template('COMCODE_JUMPING', array(
                'FULL' => lorem_phrase(),
                'TIME' => '1000',
                'PARTS' => $parts,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_ticker()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_TICKER', array(
                'SPEED' => '10',
                'WIDTH' => '400',
                'TEXT' => lorem_sentence_html(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_highlight()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_HIGHLIGHT', array(
                'CONTENT' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_font()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_FONT', array(
                'CONTENT' => lorem_phrase(),
                'SIZE' => 'font-size:2em;',
                'COLOR' => 'color:red;',
                'FACE' => 'font-family:Arial;'
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_concept()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_CONCEPT', array(
                'TEXT' => lorem_sentence(),
                'URL' => placeholder_url(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_concept_inline()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_CONCEPT_INLINE', array(
                'TEXT' => lorem_sentence(),
                'FULL' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_concepts()
    {
        $concepts = array();
        foreach (placeholder_array() as $i => $v) {
            $concepts[] = array(
                'A' => lorem_word() . strval($i),
                'KEY' => lorem_phrase(),
                'VALUE' => lorem_phrase(),
            );
        }

        return array(
            lorem_globalise(do_lorem_template('COMCODE_CONCEPTS', array(
                'TITLE' => lorem_phrase(),
                'CONCEPTS' => $concepts,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_thumb()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_THUMB', array(
                'CAPTION' => lorem_phrase(),
                'ALIGN' => 'top',
                'URL_THUMB' => placeholder_image_url(),
                'URL_FULL' => placeholder_url(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_img()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_IMG', array(
                'REFRESH_TIME' => '20000',
                'ROLLOVER' => lorem_phrase(),
                'ALIGN' => 'top',
                'URL' => placeholder_image_url(),
                'CAPTION' => lorem_phrase(),
                'TOOLTIP' => lorem_word(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_url()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_URL', array(
                'TITLE' => lorem_phrase(),
                'REL' => lorem_phrase(),
                'TARGET' => lorem_phrase(),
                'URL' => placeholder_url(),
                'CAPTION' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_email()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_EMAIL', array(
                'TITLE' => lorem_phrase(),
                'ADDRESS' => lorem_phrase(),
                'SUBJECT' => lorem_phrase(),
                'BODY' => lorem_phrase(),
                'CAPTION' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_reference()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_REFERENCE', array(
                'SOURCE' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_shocker()
    {
        $attributes = array(
            'left_1' => 'Ra Ra',
            'right_1' => 'ah-ah-ah',
            'left_2' => 'Roma',
            'right_2' => 'Roma-ma',
            'left_3' => 'GaGa',
            'right_3' => 'Oh la-la',
            'left_4' => 'Want your',
            'right_4' => 'bad romance',
        );

        $_parts = array();
        foreach ($attributes as $key => $val) {
            if (substr($key, 0, 5) == 'left_') {
                $left = $val;
                $right = array_key_exists('right_' . substr($key, 5), $attributes) ? $attributes['right_' . substr($key, 5)] : '';

                $left = make_string_tempcode($left);
                $right = make_string_tempcode($right);
                $_parts[] = array(
                    'LEFT' => $left,
                    'RIGHT' => $right,
                );
            }
        }

        $min_color = '0000FF';
        $max_color = 'FF0044';

        $temp_tpl = do_lorem_template('COMCODE_SHOCKER', array(
            'MIN_COLOR' => $min_color,
            'MAX_COLOR' => $max_color,
            'FULL' => implode(', ', $attributes),
            'TIME' => strval(4000),
            'PARTS' => $_parts,
        ));

        return array(
            lorem_globalise($temp_tpl, null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_hide()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_HIDE', array(
                'TEXT' => lorem_sentence_html(),
                'CONTENT' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_quote_by()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_QUOTE_BY', array(
                'CONTENT' => lorem_phrase(),
                'BY' => lorem_phrase(),
                'CITE' => lorem_word(),
                'SAIDLESS' => false,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_quote()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_QUOTE', array(
                'CONTENT' => lorem_phrase(),
                'CITE' => lorem_word(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_contents()
    {
        $lines = array();
        foreach (placeholder_array() as $v) {
            $lines[] = array(
                'URL' => placeholder_url(),
                'LINE' => lorem_phrase(),
                'ID' => placeholder_id(),
                'UNDER' => '',
            );
        }
        $level = do_lorem_template('COMCODE_CONTENTS_LEVEL', array(
            'TYPE' => 'disc',
            'LINES' => $lines,
        ));
        $line = do_lorem_template('COMCODE_CONTENTS', array(
            'LEVELS' => $level,
        ));
        return array(
            lorem_globalise($line, null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_textcode_line()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_TEXTCODE_LINE', array()), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_textcode_tab()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_TEXTCODE_TAB', array()), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_wiki_link()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_WIKI_LINK', array(
                'URL' => placeholder_url(),
                'TEXT' => lorem_sentence(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_code_scroll()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_CODE_SCROLL', array(
                'TITLE' => lorem_phrase(),
                'CONTENT' => lorem_phrase(),
                'TYPE' => '',
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_table_fake_wide_screen()
    {
        $tag_output = new Tempcode();

        /*
        COMCODE_FAKE_TABLE_WRAP_START (row start)
            COMCODE_FAKE_TABLE_WIDE_START_CELL (cell start)
                ...
            COMCODE_FAKE_TABLE_END_CELL (cell end)
            ...
            COMCODE_FAKE_TABLE_WIDE_CELL (cell start)
                ...
            COMCODE_FAKE_TABLE_END_CELL (cell end)
        COMCODE_FAKE_TABLE_WRAP_END (row end)
        */

        $tag_output->attach(do_lorem_template('COMCODE_FAKE_TABLE_WRAP_START', array()));
        $tag_output->attach(do_lorem_template('COMCODE_FAKE_TABLE_WIDE_START_CELL', array(
            'WIDTH' => '100%',
            'PADDING_AMOUNT' => '0',
            'FLOAT' => 'left',
            'PADDING' => '',
        )));
        $tag_output->attach(lorem_paragraph());
        $tag_output->attach(do_lorem_template('COMCODE_FAKE_TABLE_END_CELL'));
        foreach (placeholder_array(2) as $cell) {
            $tag_output->attach(do_lorem_template('COMCODE_FAKE_TABLE_WIDE_CELL', array(
                'WIDTH' => '100%',
                'PADDING_AMOUNT' => '0',
                'FLOAT' => 'left',
                'PADDING' => '',
            )));
            $tag_output->attach($cell);
            $tag_output->attach(do_lorem_template('COMCODE_FAKE_TABLE_END_CELL'));
        }
        $tag_output->attach(do_lorem_template('COMCODE_FAKE_TABLE_WRAP_END'));

        return array(
            lorem_globalise($tag_output, null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_table_fake_screen()
    {
        $tag_output = new Tempcode();

        /*
        COMCODE_FAKE_TABLE_WRAP_START (row start)
            COMCODE_FAKE_TABLE_START_CELL (cell start)
                ...
            COMCODE_FAKE_TABLE_END_CELL (cell end)
            ...
            COMCODE_FAKE_TABLE_CELL (cell start)
                ...
            COMCODE_FAKE_TABLE_END_CELL (cell end)
        COMCODE_FAKE_TABLE_WRAP_END (row end)
        */

        $tag_output->attach(do_lorem_template('COMCODE_FAKE_TABLE_WRAP_START'));
        $tag_output->attach(do_lorem_template('COMCODE_FAKE_TABLE_START_CELL', array(
            'WIDTH' => '40%',
            'FLOAT' => 'left',
            'PADDING' => '-left',
            'PADDING_AMOUNT' => '10',
        )));
        $tag_output->attach(lorem_paragraph());
        $tag_output->attach(do_lorem_template('COMCODE_FAKE_TABLE_END_CELL'));
        foreach (placeholder_array(2) as $cell) {
            $tag_output->attach(do_lorem_template('COMCODE_FAKE_TABLE_CELL', array(
                'WIDTH' => '100%',
                'FLOAT' => 'left',
                'PADDING' => '',
                'PADDING_AMOUNT' => '5',
            )));
            $tag_output->attach($cell);
            $tag_output->attach(do_lorem_template('COMCODE_FAKE_TABLE_END_CELL'));
        }
        $tag_output->attach(do_lorem_template('COMCODE_FAKE_TABLE_WRAP_END'));

        return array(
            lorem_globalise($tag_output, null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_table_real_screen()
    {
        $tag_output = new Tempcode();

        $column_sizes = array();

        $tag_output->attach(do_lorem_template('COMCODE_REAL_TABLE_START', array(
            'SUMMARY' => lorem_phrase(),
            'CAPTION' => lorem_word(),
            'COLUMNED_TABLE' => false,
            'WIDE' => true,
            'COLUMN_SIZES' => $column_sizes,
        )));
        foreach (placeholder_array(2) as $i => $table_row) {
            $map = array();
            if ($i == 0) {
                $map['START_BODY'] = true;
            }
            $tag_output->attach(do_lorem_template('COMCODE_REAL_TABLE_ROW_START', $map));
            foreach (placeholder_array(2) as $cell) {
                $tag_output->attach(do_lorem_template('COMCODE_REAL_TABLE_CELL', array(
                    'WIDTH' => '',
                    'C_TYPE' => 'td',
                    'MID' => $cell,
                )));
            }
            $tag_output->attach(do_lorem_template('COMCODE_REAL_TABLE_ROW_END'));
        }
        $tag_output->attach(do_lorem_template('COMCODE_REAL_TABLE_END', array('END_BODY' => true)));

        return array(
            lorem_globalise($tag_output, null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_subtitle()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_SUBTITLE', array(
                'ID' => placeholder_id(),
                'TITLE' => lorem_phrase(),
                'SUB' => lorem_sentence(),
                'LEVEL' => '2',
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__attachments_browser()
    {
        $list_cont = new Tempcode();
        foreach (placeholder_array() as $k => $v) {
            $list_cont->attach(do_lorem_template('FORM_SCREEN_INPUT_LIST_ENTRY', array(
                'SELECTED' => '',
                'DISABLED' => '',
                'CLASS' => '',
                'NAME' => $v,
                'TEXT' => $v,
            )));
        }

        $attachments = array();
        $attachments[] = array(
            'FIELD_NAME' => lorem_phrase(),
            'TPL' => lorem_phrase(),
            'DESCRIPTION' => lorem_sentence(),
            'ID' => placeholder_id(),
            'MAY_DELETE' => true,
            'DELETE_URL' => placeholder_url(),
        );

        return array(
            lorem_globalise(do_lorem_template('ATTACHMENTS_BROWSER', array(
                'LIST' => $list_cont,
                'ATTACHMENTS' => $attachments,
                'URL' => placeholder_url(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_code()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_CODE', array(
                'STYLE' => lorem_phrase(),
                'TYPE' => lorem_phrase(),
                'CONTENT' => lorem_phrase(),
                'TITLE' => lorem_phrase(),
                'SUP_PARAMS' => placeholder_blank(),
                'FORUM_DB_BIN' => placeholder_blank(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_tab_body()
    {
        $content = new Tempcode();
        $head = new Tempcode();
        foreach (placeholder_array() as $k => $v) {
            if ($k == 0) {
                $first = true;
                $last = false;
            } elseif ($k == 2) {
                $first = false;
                $last = true;
            } else {
                $first = false;
                $last = false;
            }
            $head->attach(do_lorem_template('COMCODE_TAB_HEAD', array(
                'TITLE' => lorem_word() . $v,
                'FIRST' => $first,
                'LAST' => $last,
            )));
            $content->attach(do_lorem_template('COMCODE_TAB_BODY', array(
                'DEFAULT' => ($k == 0),
                'TITLE' => lorem_word() . $v,
                'CONTENT' => lorem_paragraph_html(),
            )));
        }
        return array(
            lorem_globalise(do_lorem_template('COMCODE_TAB_CONTROLLER', array(
                'HEADS' => $head,
                'CONTENT' => $content,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_samp()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_SAMP', array(
                'CONTENT' => lorem_sentence(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_var()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_VAR', array(
                'CONTENT' => lorem_sentence(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_teletype()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_TELETYPE', array(
                'CONTENT' => lorem_sentence(),
            )), null, '', true)
        );
    }

    /**
     * Render a media preview through a specific template.
     *
     * @param  ID_TEXT $template Template name.
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function do_media_preview($template)
    {
        require_code('files');

        return array(
            lorem_globalise(do_lorem_template($template, array(
                'URL' => placeholder_url(),
                'REMOTE_ID' => placeholder_id(),
                'THUMB_URL' => placeholder_image_url(),
                'FILENAME' => lorem_word(),
                'MIME_TYPE' => lorem_word(),
                'CLICK_URL' => placeholder_url(),

                'WIDTH' => placeholder_number(),
                'HEIGHT' => placeholder_number(),

                'LENGTH' => placeholder_number(),

                'FILESIZE' => placeholder_number(),
                'CLEAN_FILESIZE' => clean_file_size(intval(placeholder_number())),

                'THUMB' => true,
                'FRAMED' => true,
                'WYSIWYG_EDITABLE' => true,
                'NUM_DOWNLOADS' => placeholder_number(),
                'DESCRIPTION' => '',
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__media_audio_websafe()
    {
        return $this->do_media_preview('MEDIA_AUDIO_WEBSAFE');
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__media_flash()
    {
        return $this->do_media_preview('MEDIA_FLASH');
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__media_image_websafe()
    {
        return $this->do_media_preview('MEDIA_IMAGE_WEBSAFE');
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__media_pdf()
    {
        return $this->do_media_preview('MEDIA_PDF');
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__media_quicktime()
    {
        return $this->do_media_preview('MEDIA_QUICKTIME');
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__media_realmedia()
    {
        return $this->do_media_preview('MEDIA_REALMEDIA');
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__media_svg()
    {
        return $this->do_media_preview('MEDIA_SVG');
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__media_video_facebook()
    {
        return $this->do_media_preview('MEDIA_VIDEO_FACEBOOK');
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__media_video_general()
    {
        return $this->do_media_preview('MEDIA_VIDEO_GENERAL');
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__media_video_websafe()
    {
        return $this->do_media_preview('MEDIA_VIDEO_WEBSAFE');
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__media_vimeo()
    {
        return $this->do_media_preview('MEDIA_VIMEO');
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__media_youtube()
    {
        return $this->do_media_preview('MEDIA_YOUTUBE');
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__media_download()
    {
        return $this->do_media_preview('MEDIA_DOWNLOAD');
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__media__download_link()
    {
        return $this->do_media_preview('MEDIA__DOWNLOAD_LINK');
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__media_webpage_oembed_rich()
    {
        require_code('files');

        return array(
            lorem_globalise(do_lorem_template('MEDIA_WEBPAGE_OEMBED_RICH', array(
                'TITLE' => lorem_title(),
                'HTML' => lorem_paragraph_html(),
                'WIDTH' => placeholder_number(),
                'HEIGHT' => placeholder_number(),
                'URL' => placeholder_url(),
                'REL' => null,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__media_webpage_oembed_video()
    {
        require_code('files');

        return array(
            lorem_globalise(do_lorem_template('MEDIA_WEBPAGE_OEMBED_VIDEO', array(
                'TITLE' => lorem_title(),
                'HTML' => lorem_paragraph_html(),
                'WIDTH' => placeholder_number(),
                'HEIGHT' => placeholder_number(),
                'URL' => placeholder_url(),
                'REL' => null,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__media_webpage_semantic()
    {
        require_code('files');

        return array(
            lorem_globalise(do_lorem_template('MEDIA_WEBPAGE_SEMANTIC', array(
                'TITLE' => lorem_title(),
                'META_TITLE' => lorem_title(),
                'DESCRIPTION' => lorem_paragraph_html(),
                'IMAGE_URL' => placeholder_image_url(),
                'URL' => placeholder_url(),
                'WIDTH' => placeholder_number(),
                'HEIGHT' => placeholder_number(),
                'REL' => null,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_member_link()
    {
        return array(
            lorem_globalise(do_lorem_template('COMCODE_MEMBER_LINK', array(
                //'DETAILS' => lorem_sentence(),
                'MEMBER_ID' => placeholder_id(),
                'USERNAME' => lorem_phrase(),
                'MEMBER_URL' => placeholder_url(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__autocomplete_load()
    {
        return array(
            do_lorem_template('AUTOCOMPLETE_LOAD', array(
                'NAME' => 'field',
            ), null, false, null, '.js', 'javascript')
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__comcode_media_set()
    {
        $media = new Tempcode();

        for ($i = 0; $i < 3; $i++) {
            $media->attach(do_lorem_template('MEDIA_IMAGE_WEBSAFE', array(
                'URL' => placeholder_url(),
                'REMOTE_ID' => placeholder_id(),
                'THUMB_URL' => placeholder_image_url(),
                'FILENAME' => lorem_word(),
                'MIME_TYPE' => lorem_word(),
                'CLICK_URL' => placeholder_url(),

                'WIDTH' => placeholder_number(),
                'HEIGHT' => placeholder_number(),

                'LENGTH' => placeholder_number(),

                'FILESIZE' => placeholder_number(),
                'CLEAN_FILESIZE' => clean_file_size(intval(placeholder_number())),

                'THUMB' => true,
                'FRAMED' => true,
                'WYSIWYG_EDITABLE' => true,
                'NUM_DOWNLOADS' => placeholder_number(),
                'DESCRIPTION' => '',
            )));
        }

        return array(
            lorem_globalise(do_lorem_template('COMCODE_MEDIA_SET', array(
                'MEDIA' => $media,
                'WIDTH' => placeholder_number(),
                'HEIGHT' => placeholder_number(),
            )), null, '', true)
        );
    }
}
