<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    import
 */

/**
 * Hook class.
 */
class Hook_addon_registry_import
{
    /**
     * Get a list of file permissions to set
     *
     * @param  boolean $runtime Whether to include wildcards represented runtime-created chmoddable files
     * @return array File permissions to set
     */
    public function get_chmod_array($runtime = false)
    {
        return array();
    }

    /**
     * Get the version of Composr this addon is for
     *
     * @return float Version number
     */
    public function get_version()
    {
        return cms_version_number();
    }

    /**
     * Get the description of the addon
     *
     * @return string Description of the addon
     */
    public function get_description()
    {
        return 'Switch to Composr from other software. This addon provides the architecture for importing, and a number of prewritten importers.';
    }

    /**
     * Get a list of tutorials that apply to this addon
     *
     * @return array List of tutorials
     */
    public function get_applicable_tutorials()
    {
        return array(
            'tut_importer',
        );
    }

    /**
     * Get a mapping of dependency types
     *
     * @return array File permissions to set
     */
    public function get_dependencies()
    {
        return array(
            'requires' => array(),
            'recommends' => array(),
            'conflicts_with' => array(),
        );
    }

    /**
     * Explicitly say which icon should be used
     *
     * @return URLPATH Icon
     */
    public function get_default_icon()
    {
        return 'themes/default/images/icons/48x48/menu/_generic_admin/import.png';
    }

    /**
     * Get a list of files that belong to this addon
     *
     * @return array List of files
     */
    public function get_file_list()
    {
        return array(
            'themes/default/css/importing.css',
            'sources/hooks/modules/admin_import/html_site.php',
            'sources/hooks/modules/admin_import/index.html',
            'sources_custom/hooks/modules/admin_import/index.html',
            'sources/hooks/modules/admin_import/shared/.htaccess',
            'sources/hooks/modules/admin_import/shared/index.html',
            'sources/hooks/systems/addon_registry/import.php',
            'sources/hooks/modules/admin_import_types/.htaccess',
            'sources_custom/hooks/modules/admin_import_types/.htaccess',
            'sources/hooks/modules/admin_import_types/core.php',
            'sources/hooks/modules/admin_import_types/index.html',
            'sources_custom/hooks/modules/admin_import_types/index.html',
            'themes/default/templates/IMPORT_ACTION_LINE.tpl',
            'themes/default/templates/IMPORT_ACTION_SCREEN.tpl',
            'themes/default/templates/IMPORT_MESSAGE.tpl',
            'themes/default/text/IMPORT_PHPNUKE_FCOMCODEPAGE.txt',
            'themes/default/text/IMPORT_MKPORTAL_FCOMCODEPAGE.txt',
            'adminzone/pages/modules/admin_import.php',
            'lang/EN/import.ini',
            'sources/hooks/modules/admin_import/.htaccess',
            'sources_custom/hooks/modules/admin_import/.htaccess',
            'sources/hooks/modules/admin_import/ipb1.php',
            'sources/hooks/modules/admin_import/ipb2.php',
            'sources/hooks/modules/admin_import/cms_merge.php',
            'sources/hooks/modules/admin_import/phpbb2.php',
            'sources/hooks/modules/admin_import/shared/ipb.php',
            'sources/hooks/modules/admin_import/vb3.php',
            'sources/hooks/modules/admin_import/mybb.php',
            'sources/hooks/modules/admin_import/wowbb.php',
            'sources/hooks/modules/admin_import/phpbb3.php',
            'sources/hooks/modules/admin_import/aef.php',
            'sources/hooks/modules/admin_import/smf.php',
            'sources/hooks/modules/admin_import/smf2.php',
            'sources/hooks/systems/page_groupings/import.php',
            'sources/hooks/modules/admin_import/wordpress.php',
            'sources/hooks/systems/cns_auth/wordpress.php',
            'sources/import.php',
            'sources/hooks/systems/commandr_commands/continue_import.php',
        );
    }

    /**
     * Get mapping between template names and the method of this class that can render a preview of them
     *
     * @return array The mapping
     */
    public function tpl_previews()
    {
        return array(
            'templates/IMPORT_ACTION_LINE.tpl' => 'administrative__import_action_screen',
            'templates/IMPORT_ACTION_SCREEN.tpl' => 'administrative__import_action_screen',
            'templates/IMPORT_MESSAGE.tpl' => 'administrative__import_action_screen',
            'text/IMPORT_MKPORTAL_FCOMCODEPAGE.txt' => 'administrative__import_mkportal_fcomcodepage',
            'text/IMPORT_PHPNUKE_FCOMCODEPAGE.txt' => 'administrative__import_phpnuke_fcomcodepage'
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__administrative__import_action_screen()
    {
        $extra = do_lorem_template('IMPORT_MESSAGE', array(
            'MESSAGE' => lorem_phrase(),
        ));
        $import_list = do_lorem_template('IMPORT_ACTION_LINE', array(
            'CHECKED' => false,
            'DISABLED' => true,
            'NAME' => lorem_word(),
            'TEXT' => lorem_phrase(),
            'ADVANCED_URL' => placeholder_url(),
        ));

        return array(
            lorem_globalise(do_lorem_template('IMPORT_ACTION_SCREEN', array(
                'EXTRA' => $extra,
                'MESSAGE' => lorem_phrase(),
                'TITLE' => lorem_title(),
                'FIELDS' => lorem_phrase(),
                'HIDDEN' => '',
                'IMPORTER' => lorem_phrase(),
                'IMPORT_LIST' => $import_list,
                'URL' => placeholder_url(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__administrative__import_mkportal_fcomcodepage()
    {
        return array(
            lorem_globalise(do_lorem_template('IMPORT_MKPORTAL_FCOMCODEPAGE', array(
                'TITLE' => lorem_phrase(),
                'SUBTITLE' => lorem_phrase(),
                'PAGE_HEADER' => lorem_phrase(),
                'TEXT' => lorem_sentence_html(),
                'PAGE_FOOTER' => lorem_phrase(),
                'SIGNATURE' => lorem_phrase(),
            ), null, false, null, '.txt', 'text'), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__administrative__import_phpnuke_fcomcodepage()
    {
        return array(
            lorem_globalise(do_lorem_template('IMPORT_PHPNUKE_FCOMCODEPAGE', array(
                'TITLE' => lorem_phrase(),
                'SUBTITLE' => lorem_phrase(),
                'PAGE_HEADER' => lorem_phrase(),
                'TEXT' => lorem_sentence_html(),
                'PAGE_FOOTER' => lorem_phrase(),
                'SIGNATURE' => lorem_phrase(),
            ), null, false, null, '.txt', 'text'), null, '', true)
        );
    }
}
