<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    ldap
 */

/**
 * Hook class.
 */
class Hook_addon_registry_ldap
{
    /**
     * Get a list of file permissions to set
     *
     * @param  boolean $runtime Whether to include wildcards represented runtime-created chmoddable files
     * @return array File permissions to set
     */
    public function get_chmod_array($runtime = false)
    {
        return array();
    }

    /**
     * Get the version of Composr this addon is for
     *
     * @return float Version number
     */
    public function get_version()
    {
        return cms_version_number();
    }

    /**
     * Get the description of the addon
     *
     * @return string Description of the addon
     */
    public function get_description()
    {
        return 'Support for integrating Conversr with an LDAP server, so usergroup and members can be the same as those already on the network';
    }

    /**
     * Get a list of tutorials that apply to this addon
     *
     * @return array List of tutorials
     */
    public function get_applicable_tutorials()
    {
        return array(
            'tut_ldap',
        );
    }

    /**
     * Get a mapping of dependency types
     *
     * @return array File permissions to set
     */
    public function get_dependencies()
    {
        return array(
            'requires' => array(),
            'recommends' => array(),
            'conflicts_with' => array(),
        );
    }

    /**
     * Explicitly say which icon should be used
     *
     * @return URLPATH Icon
     */
    public function get_default_icon()
    {
        return 'themes/default/images/icons/48x48/menu/adminzone/security/ldap.png';
    }

    /**
     * Get a list of files that belong to this addon
     *
     * @return array List of files
     */
    public function get_file_list()
    {
        return array(
            'themes/default/images/icons/24x24/menu/adminzone/security/ldap.png',
            'themes/default/images/icons/48x48/menu/adminzone/security/ldap.png',
            'sources/hooks/systems/config/ldap_allow_joining.php',
            'sources/hooks/systems/config/ldap_base_dn.php',
            'sources/hooks/systems/config/ldap_bind_password.php',
            'sources/hooks/systems/config/ldap_bind_rdn.php',
            'sources/hooks/systems/config/ldap_group_class.php',
            'sources/hooks/systems/config/ldap_group_search_qualifier.php',
            'sources/hooks/systems/config/ldap_hostname.php',
            'sources/hooks/systems/config/ldap_is_enabled.php',
            'sources/hooks/systems/config/ldap_is_windows.php',
            'sources/hooks/systems/config/ldap_login_qualifier.php',
            'sources/hooks/systems/config/ldap_member_class.php',
            'sources/hooks/systems/config/ldap_member_property.php',
            'sources/hooks/systems/config/ldap_member_search_qualifier.php',
            'sources/hooks/systems/config/ldap_none_bind_logins.php',
            'sources/hooks/systems/config/ldap_version.php',
            'sources/hooks/systems/addon_registry/ldap.php',
            'themes/default/templates/CNS_LDAP_LIST_ENTRY.tpl',
            'themes/default/templates/CNS_LDAP_SYNC_SCREEN.tpl',
            'adminzone/pages/modules/admin_cns_ldap.php',
            'sources/cns_ldap.php',
            'sources/hooks/systems/page_groupings/ldap.php',
        );
    }

    /**
     * Get mapping between template names and the method of this class that can render a preview of them
     *
     * @return array The mapping
     */
    public function tpl_previews()
    {
        return array(
            'templates/CNS_LDAP_LIST_ENTRY.tpl' => 'administrative__cns_ldap_sync_screen',
            'templates/CNS_LDAP_SYNC_SCREEN.tpl' => 'administrative__cns_ldap_sync_screen'
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__administrative__cns_ldap_sync_screen()
    {
        require_lang('cns');

        $members_delete = new Tempcode();
        foreach (placeholder_array() as $k => $v) {
            $tpl = do_lorem_template('CNS_LDAP_LIST_ENTRY', array(
                'NAME' => placeholder_random_id(),
                'NICE_NAME' => lorem_word(),
            ));
            $members_delete->attach($tpl);
        }

        $groups_delete = new Tempcode();
        foreach (placeholder_array() as $k => $v) {
            $tpl = do_lorem_template('CNS_LDAP_LIST_ENTRY', array(
                'NAME' => placeholder_random_id(),
                'NICE_NAME' => lorem_word(),
            ));
            $groups_delete->attach($tpl);
        }

        $groups_add = new Tempcode();
        foreach (placeholder_array() as $k => $v) {
            $tpl = do_lorem_template('CNS_LDAP_LIST_ENTRY', array(
                'NAME' => placeholder_random_id(),
                'NICE_NAME' => lorem_word(),
            ));
            $groups_add->attach($tpl);
        }

        return array(
            lorem_globalise(do_lorem_template('CNS_LDAP_SYNC_SCREEN', array(
                'URL' => placeholder_url(),
                'TITLE' => lorem_title(),
                'MEMBERS_DELETE' => $members_delete,
                'GROUPS_DELETE' => $groups_delete,
                'GROUPS_ADD' => $groups_add,
            )), null, '', true)
        );
    }
}
