<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    staff_messaging
 */

/**
 * Hook class.
 */
class Hook_addon_registry_staff_messaging
{
    /**
     * Get a list of file permissions to set
     *
     * @param  boolean $runtime Whether to include wildcards represented runtime-created chmoddable files
     * @return array File permissions to set
     */
    public function get_chmod_array($runtime = false)
    {
        return array();
    }

    /**
     * Get the version of Composr this addon is for
     *
     * @return float Version number
     */
    public function get_version()
    {
        return cms_version_number();
    }

    /**
     * Get the description of the addon
     *
     * @return string Description of the addon
     */
    public function get_description()
    {
        return 'Blocks to allow visitors to contact the staff, either via e-mail, or via a special administrative interface which the staff may use to comment on the messages and assign task ownership.';
    }

    /**
     * Get a list of tutorials that apply to this addon
     *
     * @return array List of tutorials
     */
    public function get_applicable_tutorials()
    {
        return array(
            'tut_feedback',
            'tut_support_desk',
        );
    }

    /**
     * Get a mapping of dependency types
     *
     * @return array File permissions to set
     */
    public function get_dependencies()
    {
        return array(
            'requires' => array(
                'cns_forum',
            ),
            'recommends' => array(),
            'conflicts_with' => array(),
        );
    }

    /**
     * Explicitly say which icon should be used
     *
     * @return URLPATH Icon
     */
    public function get_default_icon()
    {
        return 'themes/default/images/icons/48x48/menu/adminzone/audit/messaging.png';
    }

    /**
     * Get a list of files that belong to this addon
     *
     * @return array List of files
     */
    public function get_file_list()
    {
        return array(
            'themes/default/images/icons/24x24/menu/adminzone/audit/messaging.png',
            'themes/default/images/icons/48x48/menu/adminzone/audit/messaging.png',
            'themes/default/images/icons/24x24/menu/site_meta/contact_us.png',
            'themes/default/images/icons/48x48/menu/site_meta/contact_us.png',
            'sources/hooks/blocks/main_staff_checklist/messaging.php',
            'sources/hooks/systems/config/messaging_forum_name.php',
            'sources/hooks/systems/addon_registry/staff_messaging.php',
            'sources/hooks/systems/page_groupings/messaging.php',
            'themes/default/templates/BLOCK_MAIN_CONTACT_SIMPLE.tpl',
            'themes/default/templates/BLOCK_MAIN_CONTACT_US.tpl',
            'adminzone/pages/modules/admin_messaging.php',
            'themes/default/templates/MESSAGING_MESSAGE_SCREEN.tpl',
            'themes/default/css/messaging.css',
            'sources/hooks/systems/notifications/messaging.php',
            'lang/EN/messaging.ini',
            'data/form_to_email.php',
            'sources/blocks/main_contact_simple.php',
            'sources/blocks/main_contact_us.php',
        );
    }

    /**
     * Get mapping between template names and the method of this class that can render a preview of them
     *
     * @return array The mapping
     */
    public function tpl_previews()
    {
        return array(
            'templates/MESSAGING_MESSAGE_SCREEN.tpl' => 'administrative__messaging_message_screen',
            'templates/BLOCK_MAIN_CONTACT_US.tpl' => 'block_main_contact_us',
            'templates/BLOCK_MAIN_CONTACT_SIMPLE.tpl' => 'block_main_contact_simple'
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__administrative__messaging_message_screen()
    {
        require_javascript('editing');

        $comment_details = do_lorem_template('COMMENTS_POSTING_FORM', array(
            'JOIN_BITS' => lorem_phrase_html(),
            'USE_CAPTCHA' => false,
            'EMAIL_OPTIONAL' => true,
            'POST_WARNING' => '',
            'COMMENT_TEXT' => '',
            'GET_EMAIL' => true,
            'GET_TITLE' => true,
            'EM' => placeholder_emoticon_chooser(),
            'DISPLAY' => 'block',
            'COMMENT_URL' => placeholder_url(),
            'TITLE' => lorem_phrase(),
            'MAKE_POST' => true,
            'CREATE_TICKET_MAKE_POST' => true,
            'FIRST_POST_URL' => '',
            'FIRST_POST' => '',
            'NAME' => 'field',
        ));

        return array(
            lorem_globalise(do_lorem_template('MESSAGING_MESSAGE_SCREEN', array(
                'TITLE' => lorem_title(),
                'MESSAGE_TITLE' => lorem_phrase(),
                'MESSAGE' => lorem_phrase(),
                'BY' => lorem_phrase(),
                'WHOS_READ' => placeholder_array(),
                'COMMENT_DETAILS' => $comment_details,
                'TAKE_RESPONSIBILITY_URL' => placeholder_url(),
                'RESPONSIBLE' => lorem_phrase(),
                'USERNAME' => lorem_word(),
                'DATE' => placeholder_date(),
                'MEMBER_URL' => placeholder_url(),
                'MEMBER_ID' => placeholder_id(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__block_main_contact_us()
    {
        require_javascript('posting');
        require_javascript('editing');

        $comment_details = do_lorem_template('COMMENTS_POSTING_FORM', array(
            'JOIN_BITS' => lorem_phrase_html(),
            'USE_CAPTCHA' => false,
            'EMAIL_OPTIONAL' => true,
            'POST_WARNING' => '',
            'COMMENT_TEXT' => '',
            'GET_EMAIL' => true,
            'GET_TITLE' => true,
            'EM' => placeholder_emoticon_chooser(),
            'DISPLAY' => 'block',
            'COMMENT_URL' => placeholder_url(),
            'TITLE' => lorem_phrase(),
            'MAKE_POST' => true,
            'CREATE_TICKET_MAKE_POST' => true,
            'FIRST_POST_URL' => '',
            'FIRST_POST' => '',
            'NAME' => 'field',
        ));

        return array(
            lorem_globalise(do_lorem_template('BLOCK_MAIN_CONTACT_US', array(
                'COMMENT_DETAILS' => $comment_details,
                'MESSAGE' => lorem_phrase(),
                'NOTIFICATIONS_ENABLED' => lorem_phrase(),
                'TYPE' => placeholder_id(),
                'FIRST_POST' => lorem_paragraph_html(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__block_main_contact_simple()
    {
        require_lang('cns');

        require_javascript('editing');

        $comment_details = do_lorem_template('COMMENTS_POSTING_FORM', array(
            'JOIN_BITS' => lorem_phrase_html(),
            'FIRST_POST_URL' => placeholder_url(),
            'FIRST_POST' => lorem_paragraph_html(),
            'USE_CAPTCHA' => false,
            'EMAIL_OPTIONAL' => true,
            'POST_WARNING' => '',
            'COMMENT_TEXT' => '',
            'GET_EMAIL' => lorem_word(),
            'GET_TITLE' => lorem_word(),
            'EM' => placeholder_emoticon_chooser(),
            'DISPLAY' => 'block',
            'TITLE' => lorem_phrase(),
            'COMMENT_URL' => placeholder_url(),
            'MAKE_POST' => true,
            'CREATE_TICKET_MAKE_POST' => true,
            'NAME' => 'field',
        ));

        return array(
            lorem_globalise(do_lorem_template('BLOCK_MAIN_CONTACT_SIMPLE', array(
                'EMAIL_OPTIONAL' => true,
                'COMMENT_DETAILS' => $comment_details,
                'MESSAGE' => lorem_phrase(),
            )), null, '', true)
        );
    }
}
