<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    cns_forum
 */

/**
 * Hook class.
 */
class Hook_attachments_cns_post
{
    /**
     * Run function for attachment hooks. They see if permission to an attachment of an ID relating to this content is present for a member.
     *
     * @param  ID_TEXT $id The ID
     * @param  object $connection The database connection to check on
     * @param  MEMBER $member_id The member to check for
     * @return boolean Whether there is permission
     */
    public function run($id, $connection, $member_id)
    {
        if (get_forum_type() != 'cns') {
            return false; // Shouldn't be here, but maybe it's left over somehow
        }
        require_code('cns_forums');
        require_code('cns_topics');
        $info = $GLOBALS['FORUM_DB']->query_select('f_posts', array('p_cache_forum_id', 'p_intended_solely_for', 'p_poster', 'p_topic_id'), array('id' => intval($id)), '', 1);
        if (!array_key_exists(0, $info)) {
            return false;
        }
        $forum_id = $info[0]['p_cache_forum_id'];
        $forum_id_parent = is_null($forum_id) ? null : $GLOBALS['FORUM_DB']->query_select_value_if_there('f_forums', 'f_parent_forum', array('id' => $forum_id));
        $forum_id_parent_parent = is_null($forum_id_parent) ? null : $GLOBALS['FORUM_DB']->query_select_value_if_there('f_forums', 'f_parent_forum', array('id' => $forum_id_parent));
        $poster = $info[0]['p_poster'];
        $intended_solely_for = $info[0]['p_intended_solely_for'];
        if ((!is_null($intended_solely_for)) && ($poster != $member_id) && ($intended_solely_for != $member_id)) {
            return false;
        }
        if (cns_may_access_topic($info[0]['p_topic_id'])) {
            return true;
        }
        if (addon_installed('tickets')) {
            $tf = get_option('ticket_forum_name', true);
            if (!is_null($tf)) {
                $forum2 = $GLOBALS['FORUM_DRIVER']->forum_id_from_name($tf);
            } else {
                $forum2 = null;
            }
            if (($forum2 === $forum_id) || ($forum2 === $forum_id_parent) || ($forum2 === $forum_id_parent_parent)) {
                $title = $GLOBALS['FORUM_DB']->query_select_value('f_topics', 't_cache_first_title', array('id' => $info[0]['p_topic_id']));
                if (substr($title, 0, strlen(strval($member_id)) + 1) == strval($member_id) . '_') {
                    return true;
                }
                require_lang('tickets');

                $description = $GLOBALS['FORUM_DB']->query_select_value('f_topics', 't_description', array('id' => $info[0]['p_topic_id']));
                if (substr($description, 0, strlen(do_lang('SUPPORT_TICKET') . ': #' . strval($member_id)) + 1) == do_lang('SUPPORT_TICKET') . ': #' . strval($member_id) . '_') {
                    return true;
                }
            }
        }
        return false;
    }
}
