<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    core
 */

/**
 * Hook class.
 */
class Hook_check_php_version
{
    /**
     * Check various input var restrictions.
     *
     * @return array List of warnings
     */
    public function run()
    {
        // Minimum required PHP for the website software
        $warning = array();
        $phpv = PHP_VERSION;
        if ((substr($phpv, 0, 2) == '3.') || (substr($phpv, 0, 2) == '4.') || (substr($phpv, 0, 4) == '5.0.')) {
            $warning[] = do_lang_tempcode('PHP_OLD');
        }
        
        // Whether this version of PHP is supported by the developers (only check on installer)
        if (running_script('install')) {
            require_code('version2');
            $v = strval(PHP_MAJOR_VERSION) . '.' . strval(PHP_MINOR_VERSION);
            $is_supported = is_php_version_supported($v);
            if ($is_supported === null) {
                $warning[] = do_lang_tempcode('PHP_VERSION_CHECK_ERROR', escape_html($v));
            } elseif (!$is_supported) {
                $warning[] = do_lang_tempcode('PHP_VERSION_UNSUPPORTED', escape_html($v));
            }
        }
        
        return $warning;
    }
}
