<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    core_cleanup_tools
 */

/**
 * Hook class.
 */
class Hook_cleanup_tags
{
    /**
     * Find details about this cleanup hook.
     *
     * @return ?array Map of cleanup hook info (null: hook is disabled).
     */
    public function info()
    {
        $info = array();
        $info['title'] = do_lang_tempcode('ORPHANED_TAGS');
        $info['description'] = do_lang_tempcode('DESCRIPTION_ORPHANED_TAGS');
        $info['type'] = 'optimise';

        return $info;
    }

    /**
     * Run the cleanup hook action.
     *
     * @return Tempcode Results
     */
    public function run()
    {
        require_code('content');

        $hooks = find_all_hooks('systems', 'content_meta_aware');
        foreach (array_keys($hooks) as $hook) {
            require_code('hooks/systems/content_meta_aware/' . $hook);
            $ob = get_content_object($hook);
            if (is_null($ob)) {
                continue;
            }

            $info = $ob->info();
            if (is_null($info)) {
                continue;
            }

            $seo_type_code = $info['seo_type_code'];
            if (!is_null($seo_type_code)) {
                $table = $info['table'];

                $id_field = $info['id_field'];

                if (($table == 'comcode_pages') || (is_array($id_field))) {
                    continue; // Can't handle these cases
                }

                $sql = 'SELECT m.* FROM ' . get_table_prefix() . 'seo_meta m';
                $sql .= ' LEFT JOIN ' . get_table_prefix() . $table . ' r ON ' . db_cast('r.' . $id_field, 'CHAR') . '=m.meta_for_id AND ' . db_string_equal_to('m.meta_for_type', $seo_type_code);
                $sql .= ' WHERE r.' . $id_field . ' IS NULL AND ' . db_string_equal_to('m.meta_for_type', $seo_type_code);
                $orphaned = $GLOBALS[((substr($table, 0, 2) == 'f_') && ($GLOBALS['FORUM_DB'] !== null)) ? 'FORUM_DB' : 'SITE_DB']->query($sql);
                if (count($orphaned) != 0) {
                    foreach ($orphaned as $o) {
                        $keywords = $GLOBALS['SITE_DB']->query_select('seo_meta_keywords', array('meta_keyword'), array('meta_for_type' => $o['meta_for_type'], 'meta_for_id' => $o['meta_for_id']));
                        foreach ($keywords as $k) {
                            delete_lang($k['meta_keyword']);
                        }
                        $GLOBALS['SITE_DB']->query_delete('seo_meta_keywords', array('meta_for_type' => $o['meta_for_type'], 'meta_for_id' => $o['meta_for_id']));

                        delete_lang($o['meta_description']);
                        $GLOBALS['SITE_DB']->query_delete('seo_meta', array('meta_for_type' => $o['meta_for_type'], 'meta_for_id' => $o['meta_for_id']), '', 1);
                    }
                }
            }
        }

        decache('side_tag_cloud');

        return new Tempcode();
    }
}
