<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    core_fields
 */

/**
 * Hook class.
 */
class Hook_fields_posting_field
{
    // ==============
    // Module: search
    // ==============

    /**
     * Get special Tempcode for inputting this field.
     *
     * @param  array $field The field details
     * @return ?array Specially encoded input detail rows (null: nothing special)
     */
    public function get_search_inputter($field)
    {
        return null;
    }

    /**
     * Get special SQL from POSTed parameters for this field.
     *
     * @param  array $field The field details
     * @param  integer $i We're processing for the ith row
     * @param string $table_alias Table alias for catalogue entry table
     * @return ?array Tuple of SQL details (array: extra trans fields to search, array: extra plain fields to search, string: an extra table segment for a join, string: the name of the field to use as a title, if this is the title, extra WHERE clause stuff) (null: nothing special)
     */
    public function inputted_to_sql_for_search($field, $i, $table_alias = 'r')
    {
        return null;
    }

    // ===================
    // Backend: fields API
    // ===================

    /**
     * Get some info bits relating to our field type, that helps us look it up / set defaults.
     *
     * @param  ?array $field The field details (null: new field)
     * @param  ?boolean $required Whether a default value cannot be blank (null: don't "lock in" a new default value) (may be passed as false also if we want to avoid "lock in" of a new default value, but in this case possible cleanup of $default may still happen where appropriate)
     * @param  ?string $default The given default value as a string (null: don't "lock in" a new default value) (blank: only "lock in" a new default value if $required is true)
     * @param  ?object $db Database connection (null: main site database)
     * @return array Tuple of details (row-type,default-value-to-use,db row-type)
     */
    public function get_field_value_row_bits($field, $required = null, $default = null, $db = null)
    {
        return array('long_trans', $default, 'long_trans');
    }

    /**
     * Convert a field value to something renderable.
     *
     * @param  array $field The field details
     * @param  mixed $ev The raw value
     * @param  integer $i Position in fieldset
     * @param  ?array $only_fields List of fields the output is being limited to (null: N/A)
     * @param  ?ID_TEXT $table The table we store in (null: N/A)
     * @param  ?AUTO_LINK $id The ID of the row in the table (null: N/A)
     * @param  ?ID_TEXT $id_field Name of the ID field in the table (null: N/A)
     * @param  ?ID_TEXT $field_id_field Name of the field ID field in the table (null: N/A)
     * @param  ?ID_TEXT $url_field Name of the URL field in the table (null: N/A)
     * @param  ?MEMBER $submitter Submitter (null: current member)
     * @return mixed Rendered field (Tempcode or string)
     */
    public function render_field_value(&$field, $ev, $i, $only_fields, $table = null, $id = null, $id_field = null, $field_id_field = null, $url_field = null, $submitter = null)
    {
        if (is_object($ev)) {
            return $ev;
        }
        return comcode_to_tempcode($ev, $submitter);
    }

    // ======================
    // Frontend: fields input
    // ======================

    /**
     * Get form inputter.
     *
     * @param  string $_cf_name The field name
     * @param  string $_cf_description The field description
     * @param  array $field The field details
     * @param  ?string $actual_value The actual current value of the field (null: none)
     * @param  boolean $new Whether this is for a new entry
     * @param  boolean $last Whether this is the last field in the catalogue
     * @return ?Tempcode The Tempcode for the input field (null: skip the field - it's not input)
     */
    public function get_field_inputter($_cf_name, $_cf_description, $field, $actual_value, $new, $last = true)
    {
        static $done_one = false;

        global $BLOCK_EXTRA_POSTING_FIELDS;
        if (!empty($BLOCK_EXTRA_POSTING_FIELDS)) {
            $done_one = true;
        }

        if ($done_one) {
            if (is_null($actual_value)) {
                $actual_value = ''; // Plug anomaly due to unusual corruption
            }

            $wysiwyg = (option_value_from_field_array($field, 'wysiwyg', 'on') == 'on');

            $wordwrap = (option_value_from_field_array($field, 'wordwrap', 'on') == 'on');

            $input_size = max(1, intval(option_value_from_field_array($field, 'input_size', '9')));

            $_maxlength = option_value_from_field_array($field, 'maxlength', '');
            $maxlength = ($_maxlength == '') ? null : intval($_maxlength);

            $input_name = empty($field['cf_input_name']) ? ('field_' . strval($field['id'])) : $field['cf_input_name'];
            return form_input_text_comcode($_cf_name, $_cf_description, $input_name, $actual_value, $field['cf_required'] == 1, null, !$wysiwyg, '', null, !$wordwrap, $input_size);
        }

        $done_one = true;

        if (is_null($actual_value)) {
            $actual_value = ''; // Plug anomaly due to unusual corruption
        }

        require_javascript('posting');
        require_javascript('editing');
        require_javascript('ajax');
        require_javascript('plupload');
        require_css('widget_plupload');

        require_lang('comcode');

        $tabindex = get_form_field_tabindex();

        $input_name = empty($field['cf_input_name']) ? ('field_' . strval($field['id'])) : $field['cf_input_name'];

        $actual_value = filter_form_field_default($_cf_name, $actual_value);

        list($attachments, $attach_size_field) = get_attachments($input_name);

        $hidden_fields = new Tempcode();
        $hidden_fields->attach($attach_size_field);

        $help_zone = get_comcode_zone('userguide_comcode', false);

        $emoticon_chooser = $GLOBALS['FORUM_DRIVER']->get_emoticon_chooser($input_name);

        $comcode_editor = get_comcode_editor($input_name, false, true);
        $comcode_editor_small = get_comcode_editor($input_name, true);

        $w = (has_js()) && (browser_matches('wysiwyg') && (strpos($actual_value, '{$,page hint: no_wysiwyg}') === false));

        $class = '';
        attach_wysiwyg();
        if ($w) {
            $class .= ' wysiwyg';
        }

        global $LAX_COMCODE;
        $temp = $LAX_COMCODE;
        $LAX_COMCODE = true;
        $GLOBALS['COMCODE_PARSE_URLS_CHECKED'] = 100; // Little hack to stop it checking any URLs
        /*We want to always reparse with semi-parse mode if (is_null($default_parsed)) */
        $default_parsed = comcode_to_tempcode($actual_value, null, false, null, null, null, true);
        $LAX_COMCODE = $temp;

        $attachments_done = true;

        $ret = new Tempcode();

        $ret->attach(do_template('FORM_SCREEN_FIELD_SPACER', array('_GUID' => '2201f130af229cbadd92bb1b377739f5', 'TITLE' => $_cf_name)));

        $ret->attach(do_template('POSTING_FIELD', array(
            '_GUID' => 'b6c65227a28e0650154393033e005f67',
            'REQUIRED' => ($field['cf_required'] == 1),
            'DESCRIPTION' => $_cf_description,
            'HIDDEN_FIELDS' => $hidden_fields,
            'PRETTY_NAME' => $_cf_name,
            'NAME' => $input_name,
            'TABINDEX_PF' => strval($tabindex)/*not called TABINDEX due to conflict with FORM_STANDARD_END*/,
            'COMCODE_EDITOR' => $comcode_editor,
            'COMCODE_EDITOR_SMALL' => $comcode_editor_small,
            'CLASS' => $class,
            'COMCODE_URL' => is_null($help_zone) ? new Tempcode() : build_url(array('page' => 'userguide_comcode'), $help_zone),
            'EMOTICON_CHOOSER' => $emoticon_chooser,
            'POST' => $actual_value,
            'DEFAULT_PARSED' => $default_parsed,
            'ATTACHMENTS' => $attachments,
        )));

        if (!$last) {
            $ret->attach(do_template('FORM_SCREEN_FIELD_SPACER', array('_GUID' => '168edca41bd0c3da936d9154d696163e', 'TITLE' => do_lang_tempcode('ADDITIONAL_INFO'))));
        }

        return $ret;
    }

    /**
     * Find the posted value from the get_field_inputter field
     *
     * @param  boolean $editing Whether we were editing (because on edit, it could be a fractional edit)
     * @param  array $field The field details
     * @param  ?string $upload_dir Where the files will be uploaded to (null: do not store an upload, return null if we would need to do so)
     * @param  ?array $old_value Former value of field (null: none)
     * @return ?string The value (null: could not process)
     */
    public function inputted_to_field_value($editing, $field, $upload_dir = 'uploads/catalogues', $old_value = null)
    {
        $id = $field['id'];
        $tmp_name = 'field_' . strval($id);
        return post_param_string($tmp_name, $editing ? STRING_MAGIC_NULL : '');
    }
}
