<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    ecommerce
 */

/**
 * Hook class.
 */
class Hook_page_groupings_ecommerce
{
    /**
     * Run function for do_next_menu hooks. They find links to put on standard navigation menus of the system.
     *
     * @param  ?MEMBER $member_id Member ID to run as (null: current member)
     * @param  boolean $extensive_docs Whether to use extensive documentation tooltips, rather than short summaries
     * @return array List of tuple of links (page grouping, icon, do-next-style linking data), label, help (optional) and/or nulls
     */
    public function run($member_id = null, $extensive_docs = false)
    {
        if (!addon_installed('ecommerce')) {
            return array();
        }

        $ret = array(
            array('setup', 'menu/adminzone/audit/ecommerce/ecommerce', array('admin_ecommerce', array('type' => 'browse'), get_module_zone('admin_ecommerce')), do_lang_tempcode('ecommerce:CUSTOM_PRODUCT_USERGROUP'), 'ecommerce:DOC_ECOMMERCE'),
            array('audit', 'menu/adminzone/audit/ecommerce/ecommerce', array('admin_ecommerce_logs', array('type' => 'browse'), get_module_zone('admin_ecommerce')), do_lang_tempcode('ecommerce:ECOMMERCE'), 'ecommerce:DOC_ECOMMERCE'),
            array('rich_content', 'menu/rich_content/ecommerce/purchase', array('purchase', array(), get_module_zone('purchase')), do_lang_tempcode('ecommerce:PURCHASING')),
        );
        if ((!is_guest($member_id)) && (@intval($GLOBALS['SITE_DB']->query_select_value_if_there('invoices', 'COUNT(*)', array('i_member_id' => get_member()), '', true)) > 0)) {
            $ret = array_merge($ret, array(
                array('rich_content', 'menu/adminzone/audit/ecommerce/invoices', array('invoices', array(), get_module_zone('invoices')), do_lang_tempcode('ecommerce:MY_INVOICES')),
            ));
        }
        if ((!is_guest($member_id)) && (@intval($GLOBALS['SITE_DB']->query_select_value_if_there('subscriptions', 'COUNT(*)', array('s_member_id' => get_member()), '', true)) > 0)) {
            $ret = array_merge($ret, array(
                array('rich_content', 'menu/adminzone/audit/ecommerce/subscriptions', array('subscriptions', array(), get_module_zone('subscriptions')), do_lang_tempcode('ecommerce:MY_SUBSCRIPTIONS')),
            ));
        }
        if (addon_installed('shopping')) {
            $ret = array_merge($ret, array(
                array('rich_content', 'menu/rich_content/ecommerce/shopping_cart', array('shopping', array(), get_module_zone('shopping')), do_lang_tempcode('shopping:SHOPPING')),
            ));
        }
        return $ret;
    }
}
