<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    points
 */

/**
 * Hook class.
 */
class Hook_page_groupings_points
{
    /**
     * Run function for do_next_menu hooks. They find links to put on standard navigation menus of the system.
     *
     * @param  ?MEMBER $member_id Member ID to run as (null: current member)
     * @param  boolean $extensive_docs Whether to use extensive documentation tooltips, rather than short summaries
     * @return array List of tuple of links (page grouping, icon, do-next-style linking data), label, help (optional) and/or nulls
     */
    public function run($member_id = null, $extensive_docs = false)
    {
        if (!addon_installed('points')) {
            return array();
        }

        return array(
            array('audit', 'menu/adminzone/audit/points_log', array('admin_points', array('type' => 'browse'), get_module_zone('admin_points')), do_lang_tempcode('points:GIFT_TRANSACTIONS'), 'points:DOC_POINTS'),
            array('audit', 'menu/social/points', array('admin_points', array('type' => 'export'), get_module_zone('admin_points')), do_lang_tempcode('points:EXPORT_POINTS'), 'points:DOC_EXPORT_POINTS'),
            (get_forum_type() == 'cns' || get_forum_type() == 'none') ? null : array('social', 'menu/social/points', array('points', array(), get_module_zone('points')), do_lang_tempcode('points:VIEW_POINTS')),
            array('social', 'menu/social/leader_board', array('leader_board', array(), get_module_zone('leader_board')), do_lang_tempcode('leader_board:POINT_LEADER_BOARD')),
        );
    }
}
