<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    cns_forum
 */

/**
 * Hook class.
 */
class Hook_rss_cns_private_topics
{
    /**
     * Run function for RSS hooks.
     *
     * @param  string $_filters A list of categories we accept from
     * @param  TIME $cutoff Cutoff time, before which we do not show results from
     * @param  string $prefix Prefix that represents the template set we use
     * @set    RSS_ ATOM_
     * @param  string $date_string The standard format of date to use for the syndication type represented in the prefix
     * @param  integer $max The maximum number of entries to return, ordering by date
     * @return ?array A pair: The main syndication section, and a title (null: error)
     */
    public function run($_filters, $cutoff, $prefix, $date_string, $max)
    {
        if (get_forum_type() != 'cns') {
            return null;
        }
        if (is_guest()) {
            return null;
        }

        $member_id = get_member();

        if (get_forum_type() != 'cns') {
            return null;
        }
        if (!has_actual_page_access($member_id, 'forumview')) {
            return null;
        }
        if (is_guest()) {
            return null;
        }

        require_code('cns_notifications');
        $rows = cns_get_pp_rows($max);

        $content = new Tempcode();
        foreach ($rows as $row) {
            $id = strval($row['p_id']);
            $author = $row['t_cache_first_username'];

            $news_date = date($date_string, $row['t_cache_first_time']);
            $edit_date = date($date_string, $row['t_cache_last_time']);
            if ($edit_date == $news_date) {
                $edit_date = '';
            }

            if ($row['t_cache_first_time'] < $cutoff) {
                continue;
            }

            $news_title = xmlentities($row['t_cache_first_title']);
            $post_row = db_map_restrict($row, array('id', 'p_post_first'), array('id' => 't_cache_first_post_id'));
            $_summary = get_translated_tempcode('f_posts', $post_row, 'p_post_first', $GLOBALS['FORUM_DB']);
            $summary = xmlentities($_summary->evaluate());
            $news = '';

            $category = do_lang('NA');
            $category_raw = '';

            $_view_url = build_url(array('page' => 'topicview', 'id' => $row['t_id']), get_module_zone('forumview'));
            $view_url = $_view_url->evaluate();
            $view_url .= '#post_' . $id;

            if ($prefix == 'RSS_') {
                $if_comments = do_template('RSS_ENTRY_COMMENTS', array('_GUID' => '448f736ecf0154960177c131dde76125', 'COMMENT_URL' => $view_url, 'ID' => $id), null, false, null, '.xml', 'xml');
            } else {
                $if_comments = new Tempcode();
            }

            $content->attach(do_template($prefix . 'ENTRY', array('VIEW_URL' => $view_url, 'SUMMARY' => $summary, 'EDIT_DATE' => $edit_date, 'IF_COMMENTS' => $if_comments, 'TITLE' => $news_title, 'CATEGORY_RAW' => $category_raw, 'CATEGORY' => $category, 'AUTHOR' => $author, 'ID' => $id, 'NEWS' => $news, 'DATE' => $news_date), null, false, null, '.xml', 'xml'));
        }

        require_lang('cns');
        return array($content, do_lang('PRIVATE_TOPICS'));
    }
}
