<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    core_menus
 */

/**
 * Takes some Comcode, and return an XHTML menu created from it.
 *
 * @param  LONG_TEXT $comcode The contents of the Comcode menu tag
 * @param  SHORT_TEXT $menu An identifier for this menu (will be used as a unique ID by menu javascript code)
 * @param  MEMBER $source_member The member the menu is being built as
 * @param  ID_TEXT $type The menu type (determines what templates get used)
 * @return Tempcode The generated Tempcode of the menu
 */
function build_comcode_menu($comcode, $menu, $source_member, $type)
{
    // Reset
    $level = -1;
    $expanded = true;
    $expander = array();
    $expander[0] = -1;

    // Loop
    $i = 0;
    $lines = explode("\n", $comcode);
    $stack = array(); // Stores the previous level(s) if we are jumping down to a further one
    $root = _get_menu_root_wrapper();
    $root['content_id'] = $menu;
    $current_level = $root;

    if (count($lines) == 0) {
        return new Tempcode();
    }

    foreach ($lines as $line) {
        if (trim($line) == '') {
            if (($i != 0) && ($i < count($lines) - 2)) {
                $current = array(
                    'title' => '',
                    'content_type' => 'spacer',
                    'content_id' => null,
                    'modifiers' => array(),
                    'only_on_page' => '',
                    'page_link' => null,
                    'url' => null,
                    'extra_meta' => array(
                        'description' => null,
                        'image' => null,
                        'image_2x' => null,
                    ),
                    'has_possible_children' => true,
                    'children' => array(),
                );

                $current_level[] = $current;
            }
            continue;
        }

        // Detect which level we are on
        $last_level = $level; // Only update our parent level if we actually went down a level last time

        // See what level we are on by counting the spaces
        for ($levels = 1; $levels < 10; $levels++) {
            if ($line[$levels - 1] != ' ') {
                break;
            }
        }
        $level = $levels - 1;

        if ($level > $last_level + 1) {
            require_code('comcode_renderer');
            comcode_parse_error(false, array('CCP_MENU_JUMPYNESS'), $i, $comcode);
        }
        if (($last_level - $level == 0) && ($current_level['content_type'] == 'comcode_drawer_branch') && (strpos($line, '=') === false)) { // little hack to make case of branch having no children work
            $last_level++;
        }
        for ($x = 0; $x < $last_level - $level; $x++) {
            if (strpos($line, '=') !== false) {
                require_code('comcode_renderer');
                comcode_parse_error(false, array('CCP_MENU_JUMPYNESS'), $i, $comcode);
            }

            $this_level = $current_level;
            $current_level = array_pop($stack);
            if ($current_level === null) {
                $current_level = $this_level;
                break;
            }
            $current_level['children'][] = $this_level;
        }

        // Expansion method
        if ($line[$level] == '+') { // Yes, it always is
            $expanded = true;
            $expander[$level] = -1;
        } else { // No (well maybe its not even expandable, maybe its a link)
            /*$expand_this = get_param_integer('keep_' . $menu . '_expand_' . $i, 0);
            $expanded = ($expand_this == 1); PROBLEMS WITH CACHE - SO WE'LL USE JAVASCRIPT FOR THIS  */
            $expanded = false;
            $expander[$level] = $i;
        }

        // Find where the URL starts
        $pos = strpos($line, '=');
        // Find the caption
        if ($pos === false) {
            $caption = rtrim(substr($line, ($line[$level] != '+' && $line[$level] != '-') ? $level : ($level + 1)));
        } else {
            $caption = rtrim(substr($line, $level, $pos - $level));
        }

        $modifiers = array();
        if ($caption[0] == '@') {
            $caption = substr($caption, 1);
        }

        // For childed branches
        if ($pos === false) {
            // Are we expanding or contracting?
            if (($expanded) || ($expander[$level] == -1)) { // If is naturally expanded, or there is nothing that can expand it (probably because it has no parent)
                $modifiers['expanded'] = true;
            }

            array_push($stack, $current_level);
            $current_level = array(
                'title' => make_string_tempcode($caption),
                'content_type' => 'comcode_drawer_branch',
                'content_id' => null,
                'modifiers' => $modifiers,
                'only_on_page' => '',
                'page_link' => null,
                'url' => '',
                'extra_meta' => array(
                    'description' => null,
                    'image' => null,
                    'image_2x' => null,
                ),
                'has_possible_children' => true,
                'children' => array(),
            );
        } else { // For simple link branches
            $url = ltrim(substr($line, $pos + 1));
            if (substr($url, 0, 1) == '~') {
                $url = substr($url, 1);
                $modifiers['new_window'] = true;
            }
            /*elseif ($url[0]=='?')   Cache says no-no
            {
                    $url = substr($url, 1);
                    $modifers['check_perms'] = true;
            }*/

            $current_level['children'][] = array(
                'title' => make_string_tempcode($caption),
                'content_type' => 'comcode_end_branch',
                'content_id' => null,
                'modifiers' => $modifiers,
                'only_on_page' => '',
                'page_link' => null,
                'url' => @html_entity_decode($url, ENT_QUOTES, get_charset()),
                'extra_meta' => array(
                    'description' => null,
                    'image' => null,
                    'image_2x' => null,
                ),
                'has_possible_children' => true,
                'children' => array(),
            );
        }

        $i++;
    }

    // Reverse the order into a proper tree structure
    $stack_size = count($stack);
    for ($x = 0; $x < $stack_size; $x++) {
        $this_level = $current_level;
        $current_level = array_pop($stack);
        if ($current_level === null) {
            $current_level = $this_level;
            break;
        }
        $current_level['children'][] = $this_level;
    }

    return _render_menu($current_level, $source_member, $type);
}
