<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    core_cns
 */

/**
 * Hook class.
 */
class Hook_addon_registry_core_cns
{
    /**
     * Get a list of file permissions to set
     *
     * @param  boolean $runtime Whether to include wildcards represented runtime-created chmoddable files
     * @return array File permissions to set
     */
    public function get_chmod_array($runtime = false)
    {
        return array();
    }

    /**
     * Get the version of Composr this addon is for
     *
     * @return float Version number
     */
    public function get_version()
    {
        return cms_version_number();
    }

    /**
     * Get the description of the addon
     *
     * @return string Description of the addon
     */
    public function get_description()
    {
        return 'The Composr member/usergroup system.';
    }

    /**
     * Get a list of tutorials that apply to this addon
     *
     * @return array List of tutorials
     */
    public function get_applicable_tutorials()
    {
        return array(
            'tut_members',
            'tut_adv_members',
            'tut_users',
            'tut_httpauth',
            'tut_emoticons',
        );
    }

    /**
     * Get a mapping of dependency types
     *
     * @return array File permissions to set
     */
    public function get_dependencies()
    {
        return array(
            'requires' => array(),
            'recommends' => array(),
            'conflicts_with' => array(),
        );
    }

    /**
     * Explicitly say which icon should be used
     *
     * @return URLPATH Icon
     */
    public function get_default_icon()
    {
        return 'themes/default/images/icons/48x48/tabs/member_account/profile.png';
    }

    /**
     * Get a list of files that belong to this addon
     *
     * @return array List of files
     */
    public function get_file_list()
    {
        return array(
            'themes/default/images/cns_default_avatars/default.png',
            'themes/default/images/icons/24x24/tool_buttons/inbox.png',
            'themes/default/images/icons/48x48/tool_buttons/inbox.png',
            'themes/default/images/icons/24x24/tool_buttons/inbox2.png',
            'themes/default/images/icons/48x48/tool_buttons/inbox2.png',
            'themes/default/images/icons/24x24/menu/adminzone/tools/users/member_add.png',
            'themes/default/images/icons/48x48/menu/adminzone/tools/users/member_add.png',
            'themes/default/images/icons/24x24/menu/adminzone/security/usergroups_temp.png',
            'themes/default/images/icons/24x24/menu/adminzone/tools/users/delete_lurkers.png',
            'themes/default/images/icons/24x24/menu/adminzone/tools/users/member_edit.png',
            'themes/default/images/icons/24x24/menu/adminzone/tools/users/merge_members.png',
            'themes/default/images/icons/48x48/menu/adminzone/security/usergroups_temp.png',
            'themes/default/images/icons/48x48/menu/adminzone/tools/users/delete_lurkers.png',
            'themes/default/images/icons/48x48/menu/adminzone/tools/users/member_edit.png',
            'themes/default/images/icons/48x48/menu/adminzone/tools/users/merge_members.png',
            'themes/default/images/icons/24x24/tabs/member_account/profile.png',
            'themes/default/images/icons/48x48/tabs/member_account/profile.png',
            'themes/default/images/icons/24x24/tabs/member_account/profile2.png',
            'themes/default/images/icons/48x48/tabs/member_account/profile2.png',
            'themes/default/images/icons/24x24/tabs/member_account/edit/profile.png',
            'themes/default/images/icons/48x48/tabs/member_account/edit/profile.png',
            'themes/default/images/icons/24x24/tabs/member_account/edit/delete.png',
            'themes/default/images/icons/48x48/tabs/member_account/edit/delete.png',
            'themes/default/images/icons/24x24/tabs/member_account/edit/settings.png',
            'themes/default/images/icons/48x48/tabs/member_account/edit/settings.png',
            'themes/default/images/icons/24x24/menu/adminzone/audit/statistics/demographics.png',
            'themes/default/images/icons/48x48/menu/adminzone/audit/statistics/demographics.png',
            'themes/default/images/icons/24x24/tabs/member_account/edit/index.html',
            'themes/default/images/icons/24x24/tabs/member_account/index.html',
            'themes/default/images/icons/48x48/tabs/member_account/edit/index.html',
            'themes/default/images/icons/48x48/tabs/member_account/index.html',
            'themes/default/images/icons/14x14/birthday.png',
            'themes/default/images/icons/28x28/birthday.png',
            'themes/default/images/icons/24x24/menu/adminzone/style/emoticons.png',
            'themes/default/images/icons/48x48/menu/adminzone/style/emoticons.png',
            'themes/default/images/icons/24x24/menu/social/groups.png',
            'themes/default/images/icons/48x48/menu/social/groups.png',
            'themes/default/images/icons/24x24/buttons/ignore.png',
            'themes/default/images/icons/48x48/buttons/ignore.png',
            'themes/default/images/icons/24x24/menu/site_meta/user_actions/lost_password.png',
            'themes/default/images/icons/48x48/menu/site_meta/user_actions/lost_password.png',
            'themes/default/images/1x/cns_general/index.html',
            'themes/default/images/2x/cns_general/index.html',
            'themes/default/images/1x/cns_general/isoff.png',
            'themes/default/images/1x/cns_general/ison.png',
            'themes/default/images/2x/cns_general/isoff.png',
            'themes/default/images/2x/cns_general/ison.png',
            'sources/cns_forum_driver_helper_auth.php',
            'sources/hooks/modules/admin_setupwizard/core_cns.php',
            'sources/hooks/systems/content_meta_aware/topic.php',
            'sources/hooks/systems/content_meta_aware/post.php',
            'sources/hooks/modules/admin_import/emoticons.php',
            'sources/hooks/systems/notifications/cns_password_changed.php',
            'sources/hooks/systems/snippets/member_tooltip.php',
            'sources/hooks/systems/notifications/cns_rank_promoted.php',
            'sources/hooks/systems/snippets/exists_email.php',
            'sources/hooks/systems/snippets/profile_tab.php',
            'sources/hooks/systems/snippets/invite_missing.php',
            'sources/hooks/systems/snippets/exists_usergroup.php',
            'sources/hooks/systems/snippets/exists_emoticon.php',
            'sources/hooks/systems/sitemap/group.php',
            'sources/hooks/systems/sitemap/member.php',
            'sources/hooks/systems/config/allow_alpha_search.php',
            'sources/hooks/systems/config/allow_email_disable.php',
            'sources/hooks/systems/config/allow_email_from_staff_disable.php',
            'sources/hooks/systems/config/allow_international.php',
            'sources/hooks/systems/config/decryption_key.php',
            'sources/hooks/systems/config/encryption_key.php',
            'sources/hooks/systems/config/hot_topic_definition.php',
            'sources/hooks/systems/config/httpauth_is_enabled.php',
            'sources/hooks/systems/config/invites_per_day.php',
            'sources/hooks/systems/config/is_on_coppa.php',
            'sources/hooks/systems/config/is_on_invisibility.php',
            'sources/hooks/systems/config/is_on_invites.php',
            'sources/hooks/systems/config/is_on_timezone_detection.php',
            'sources/hooks/systems/config/maximum_password_length.php',
            'sources/hooks/systems/config/maximum_username_length.php',
            'sources/hooks/systems/config/minimum_password_length.php',
            'sources/hooks/systems/config/minimum_username_length.php',
            'sources/hooks/systems/config/dobs.php',
            'sources/hooks/systems/config/one_per_email_address.php',
            'sources/hooks/systems/config/privacy_fax.php',
            'sources/hooks/systems/config/privacy_postal_address.php',
            'sources/hooks/systems/config/probation_usergroup.php',
            'sources/hooks/systems/config/prohibit_password_whitespace.php',
            'sources/hooks/systems/config/prohibit_username_whitespace.php',
            'sources/hooks/systems/config/require_new_member_validation.php',
            'sources/hooks/systems/config/restricted_usernames.php',
            'sources/hooks/systems/config/show_first_join_page.php',
            'sources/hooks/systems/notifications/cns_username_changed.php',
            'sources/hooks/systems/notifications/cns_group_join_request.php',
            'sources/hooks/systems/notifications/cns_group_declined.php',
            'sources/hooks/systems/notifications/cns_birthday.php',
            'sources/hooks/systems/notifications/cns_member_joined_group.php',
            'sources/hooks/systems/notifications/cns_new_member.php',
            'sources/hooks/systems/notifications/cns_member_needs_validation.php',
            'sources/hooks/systems/notifications/cns_username_changed_staff.php',
            'sources/hooks/systems/notifications/cns_group_join_request_staff.php',
            'sources/hooks/systems/realtime_rain/cns.php',
            'sources/hooks/systems/cron/cns_birthdays.php',
            'sources/hooks/systems/content_meta_aware/member.php',
            'sources/hooks/systems/content_meta_aware/group.php',
            'sources/hooks/systems/commandr_fs/groups.php',
            'sources/hooks/systems/disposable_values/cns_member_count.php',
            'sources/hooks/systems/disposable_values/cns_topic_count.php',
            'sources/hooks/systems/disposable_values/cns_post_count.php',
            'sources/hooks/systems/disposable_values/cns_newest_member_id.php',
            'sources/hooks/systems/disposable_values/cns_newest_member_username.php',
            'sources/hooks/modules/members/.htaccess',
            'sources_custom/hooks/modules/members/.htaccess',
            'sources/hooks/modules/members/index.html',
            'sources_custom/hooks/modules/members/index.html',
            'sources/hooks/modules/search/cns_members.php',
            'sources/hooks/systems/addon_registry/core_cns.php',
            'sources/hooks/blocks/main_staff_checklist/usergroup_membership.php',
            'adminzone/pages/modules/admin_cns_emoticons.php',
            'adminzone/pages/modules/admin_cns_groups.php',
            'adminzone/pages/modules/admin_cns_merge_members.php',
            'adminzone/pages/modules/admin_cns_members.php',
            'themes/default/images/cns_rank_images/0.png',
            'themes/default/images/cns_rank_images/1.png',
            'themes/default/images/cns_rank_images/2.png',
            'themes/default/images/cns_rank_images/3.png',
            'themes/default/images/cns_rank_images/4.png',
            'themes/default/images/cns_rank_images/admin.png',
            'themes/default/images/cns_rank_images/index.html',
            'themes/default/images/cns_rank_images/mod.png',
            'sources/hooks/modules/admin_import/csv_members.php',
            'themes/default/templates/CNS_EMOTICON_TABLE.tpl',
            'themes/default/templates/CNS_JOIN_STEP1_SCREEN.tpl',
            'themes/default/templates/CNS_USERS_ONLINE_SCREEN.tpl',
            'themes/default/templates/CNS_MEMBER_ACTION.tpl',
            'themes/default/templates/CNS_MEMBER_DIRECTORY_SCREEN.tpl',
            'themes/default/templates/CNS_MEMBER_PROFILE_SCREEN.tpl',
            'themes/default/templates/CNS_MEMBER_PROFILE_ABOUT.tpl',
            'themes/default/templates/CNS_MEMBER_PROFILE_EDIT.tpl',
            'themes/default/javascript/profile.js',
            'themes/default/templates/CNS_MEMBER_BOX_CUSTOM_FIELD.tpl',
            'themes/default/templates/CNS_USER_MEMBER.tpl',
            'themes/default/templates/CNS_VIEW_GROUP_SCREEN.tpl',
            'themes/default/templates/CNS_VIEW_GROUP_MEMBER.tpl',
            'themes/default/templates/CNS_VIEW_GROUP_MEMBER_PROSPECTIVE.tpl',
            'themes/default/templates/CNS_VIEW_GROUP_MEMBER_SECONDARY.tpl',
            'data/approve_ip.php',
            'themes/default/images/cns_emoticons/birthday.png',
            'themes/default/images/cns_emoticons/angry.png',
            'themes/default/images/cns_emoticons/blink.gif',
            'themes/default/images/cns_emoticons/blush.png',
            'themes/default/images/cns_emoticons/cheeky.png',
            'themes/default/images/cns_emoticons/christmas.png',
            'themes/default/images/cns_emoticons/confused.png',
            'themes/default/images/cns_emoticons/constipated.png',
            'themes/default/images/cns_emoticons/cool.png',
            'themes/default/images/cns_emoticons/cry.png',
            'themes/default/images/cns_emoticons/cyborg.png',
            'themes/default/images/cns_emoticons/depressed.png',
            'themes/default/images/cns_emoticons/devil.gif',
            'themes/default/images/cns_emoticons/drool.png',
            'themes/default/images/cns_emoticons/dry.png',
            'themes/default/images/cns_emoticons/glee.png',
            'themes/default/images/cns_emoticons/grin.png',
            'themes/default/images/cns_emoticons/guitar.gif',
            'themes/default/images/cns_emoticons/hand.png',
            'themes/default/images/cns_emoticons/hippie.png',
            'themes/default/images/cns_emoticons/index.html',
            'themes/default/images/cns_emoticons/king.png',
            'themes/default/images/cns_emoticons/kiss.png',
            'themes/default/images/cns_emoticons/lol.gif',
            'themes/default/images/cns_emoticons/mellow.png',
            'themes/default/images/cns_emoticons/nerd.png',
            'themes/default/images/cns_emoticons/ninja2.gif',
            'themes/default/images/cns_emoticons/nod.gif',
            'themes/default/images/cns_emoticons/offtopic.png',
            'themes/default/images/cns_emoticons/party.png',
            'themes/default/images/cns_emoticons/ph34r.png',
            'themes/default/images/cns_emoticons/puppyeyes.png',
            'themes/default/images/cns_emoticons/rockon.gif',
            'themes/default/images/cns_emoticons/rolleyes.gif',
            'themes/default/images/cns_emoticons/sad.png',
            'themes/default/images/cns_emoticons/sarcy.png',
            'themes/default/images/cns_emoticons/shake.gif',
            'themes/default/images/cns_emoticons/shocked.png',
            'themes/default/images/cns_emoticons/shutup.gif',
            'themes/default/images/cns_emoticons/sick.png',
            'themes/default/images/cns_emoticons/sinner.png',
            'themes/default/images/cns_emoticons/smile.png',
            'themes/default/images/cns_emoticons/thumbs.png',
            'themes/default/images/cns_emoticons/upsidedown.png',
            'themes/default/images/cns_emoticons/whistle.png',
            'themes/default/images/cns_emoticons/wink.png',
            'themes/default/images/cns_emoticons/wub.png',
            'themes/default/images/cns_emoticons/zzz.png',
            'themes/default/images/cns_emoticons/none.png',
            'themes/default/images/cns_emoticons/angel.png',
            'themes/default/images/cns_emoticons/cowboy.png',
            'themes/default/images/cns_emoticons/fight.png',
            'themes/default/images/cns_emoticons/goodbye.png',
            'themes/default/images/cns_emoticons/idea.png',
            'themes/default/images/cns_emoticons/boat.png',
            'themes/default/images/cns_emoticons/fishing.png',
            'themes/default/images/cns_emoticons/reallybadday.gif',
            'lang/EN/cns.ini',
            'lang/EN/cns_special_cpf.ini',
            'lang/EN/cns_components.ini',
            'lang/EN/cns_config.ini',
            'sources/forum/cns.php',
            'sources/cns_forum_driver_helper.php',
            'sources/cns_forum_driver_helper_install.php',
            'sources/hooks/systems/cleanup/cns_members.php',
            'sources/hooks/modules/admin_unvalidated/cns_members.php',
            'sources/hooks/systems/cns_cpf_filter/.htaccess',
            'sources_custom/hooks/systems/cns_cpf_filter/.htaccess',
            'sources/hooks/systems/cns_cpf_filter/index.html',
            'sources_custom/hooks/systems/cns_cpf_filter/index.html',
            'sources/hooks/systems/rss/cns_birthdays.php',
            'sources/hooks/systems/rss/cns_members.php',
            'sources/cns_forums.php',
            'sources/cns_forums2.php',
            'sources/cns_forums_action.php',
            'sources/cns_forums_action2.php',
            'sources/cns_general.php',
            'sources/cns_notifications.php',
            'sources/cns_general_action.php',
            'sources/cns_general_action2.php',
            'sources/cns_groups.php',
            'sources/cns_groups2.php',
            'sources/cns_groups_action.php',
            'sources/cns_groups_action2.php',
            'sources/cns_install.php',
            'sources/cns_members.php',
            'sources/cns_members2.php',
            'sources/cns_members_action.php',
            'sources/cns_members_action2.php',
            'sources/cns_moderation.php',
            'sources/cns_moderation_action.php',
            'sources/cns_moderation_action2.php',
            'sources/cns_polls.php',
            'sources/cns_polls_action.php',
            'sources/cns_polls_action2.php',
            'sources/cns_posts.php',
            'sources/cns_posts2.php',
            'sources/cns_posts_action.php',
            'sources/cns_posts_action2.php',
            'sources/cns_posts_action3.php',
            'sources/cns_topics.php',
            'sources/cns_topics_action.php',
            'sources/cns_topics_action2.php',
            'site/pages/modules/groups.php',
            'site/pages/modules/members.php',
            'site/pages/modules/users_online.php',
            'sources/hooks/systems/profiles_tabs/.htaccess',
            'sources_custom/hooks/systems/profiles_tabs/.htaccess',
            'sources/hooks/systems/profiles_tabs_edit/.htaccess',
            'sources_custom/hooks/systems/profiles_tabs_edit/.htaccess',
            'sources/hooks/systems/commandr_fs/members.php',
            'sources/hooks/modules/admin_stats/cns_demographics.php',
            'pages/modules/join.php',
            'sources/cns_join.php',
            'pages/modules/lost_password.php',
            'themes/default/templates/CNS_AUTO_TIME_ZONE_ENTRY.tpl',
            'themes/default/templates/CNS_DELURK_CONFIRM.tpl',
            'themes/default/templates/CNS_JOIN_STEP2_SCREEN.tpl',
            'lang/EN/cns_lurkers.ini',
            'sources/cns_profiles.php',
            'sources/cns_lost_password.php',
            'sources/hooks/systems/profiles_tabs/index.html',
            'sources_custom/hooks/systems/profiles_tabs/index.html',
            'sources/hooks/systems/profiles_tabs/about.php',
            'sources/hooks/systems/profiles_tabs/edit.php',
            'sources/hooks/systems/profiles_tabs_edit/index.html',
            'sources_custom/hooks/systems/profiles_tabs_edit/index.html',
            'sources/hooks/systems/profiles_tabs_edit/profile.php',
            'sources/hooks/systems/profiles_tabs_edit/settings.php',
            'sources/hooks/systems/profiles_tabs_edit/delete.php',
            'sources/cns_popups.php',
            'sources/hooks/systems/commandr_fs/emoticons.php',
            'sources/hooks/systems/resource_meta_aware/emoticon.php',
            'sources/hooks/systems/commandr_fs_extended_member/known_login_ips.php',
            'sources/hooks/systems/preview/cns_emoticon.php',
            'sources/hooks/systems/cron/cns_confirm_reminder.php',
            'themes/default/templates/CNS_TOPIC_POST_AVATAR.tpl',
            'themes/default/templates/CNS_GROUP_DIRECTORY_SCREEN.tpl',
            'themes/default/css/cns.css',
            'themes/default/css/cns_editor.css',
            'lang/EN/cns_member_directory.ini',
            'data/username_check.php',
            'sources/hooks/systems/cns_auth/aef.php',
            'sources/hooks/systems/cns_auth/converge.php',
            'sources/hooks/systems/cns_auth/phpbb3.php',
            'sources/hooks/systems/cns_auth/smf.php',
            'sources/hooks/systems/cns_auth/vb3.php',
            'sources/hooks/systems/cns_auth/index.html',
            'sources_custom/hooks/systems/cns_auth/index.html',
            'themes/default/templates/POSTING_FIELD.tpl',
            'themes/default/templates/CNS_MEMBER_BOX.tpl',
            'themes/default/templates/CNS_RANK_IMAGE.tpl',
            'sources/password_rules.php',
            'lang/EN/password_rules.ini',
            'sources/hooks/systems/config/complex_privacy_options.php',
            'sources/hooks/systems/config/display_name_generator.php',
            'sources/hooks/systems/config/email_confirm_join.php',
            'sources/hooks/systems/config/enable_highlight_name.php',
            'sources/hooks/systems/config/enable_privacy_tab.php',
            'sources/hooks/systems/config/enable_user_online_groups.php',
            'sources/hooks/systems/config/finish_profile.php',
            'sources/hooks/systems/config/important_groups_per_page.php',
            'sources/hooks/systems/config/md_default_sort_order.php',
            'sources/hooks/systems/config/members_per_page.php',
            'sources/hooks/systems/config/minimum_password_strength.php',
            'sources/hooks/systems/config/normal_groups_per_page.php',
            'sources/hooks/systems/config/password_change_days.php',
            'sources/hooks/systems/config/password_expiry_days.php',
            'sources/hooks/systems/config/password_reset_process.php',
            'sources/hooks/systems/config/primary_members_per_page.php',
            'sources/hooks/systems/config/secondary_members_per_page.php',
            'sources/hooks/systems/config/show_empty_cpfs.php',
            'sources/hooks/systems/config/use_joindate.php',
            'sources/hooks/systems/config/use_lastondate.php',
            'sources/hooks/systems/config/username_profile_links.php',
            'sources/hooks/systems/config/valid_email_domains.php',
            'sources/hooks/systems/config/enable_birthdays.php',
            'sources/hooks/systems/config/new_member_default_email_message.php',
            'sources/hooks/systems/config/new_member_default_email_subject.php',
            'sources/hooks/systems/config/new_member_default_temporary_password.php',
            'sources/cns_field_editability.php',
            'sources/hooks/systems/tasks/download_member_csv.php',
            'sources/hooks/systems/tasks/cns_members_recache.php',
            'sources/hooks/systems/tasks/import_member_csv.php',
            'sources/blocks/main_members.php',
            'themes/default/templates/BLOCK_MAIN_MEMBERS.tpl',
            'themes/default/templates/BLOCK_MAIN_MEMBERS_COMPLEX.tpl',
            'themes/default/templates/CNS_MEMBER_DIRECTORY_SCREEN_FILTERS.tpl',
            'themes/default/templates/CNS_MEMBER_DIRECTORY_SCREEN_FILTER.tpl',
            'themes/default/templates/CNS_MEMBER_DIRECTORY_USERNAME.tpl',
            'sources/hooks/systems/symbols/CPF_LIST.php',
            'themes/default/css/cns_member_profiles.css',
            'themes/default/css/cns_member_directory.css',
            'themes/default/css/cns_admin.css',
            'themes/default/css/cns_header.css',
            'themes/default/css/cns_footer.css',

            // Files for post map functionality
            'themes/default/templates/CNS_POST_MAP.tpl',
            'themes/default/templates/CNS_POST_MAP_ITEM.tpl',
            'themes/default/images/cns_post_map/index.html',
            'themes/default/images/cns_post_map/last_mesg_level.png',
            'themes/default/images/cns_post_map/mesg_level.png',
            'themes/default/images/cns_post_map/middle_mesg_level.png',
            'sources/hooks/systems/config/is_on_post_map.php',
            'sources/hooks/systems/config/is_on_automatic_mark_topic_read.php',
        );
    }

    /**
     * Get mapping between template names and the method of this class that can render a preview of them
     *
     * @return array The mapping
     */
    public function tpl_previews()
    {
        return array(
            'templates/CNS_DELURK_CONFIRM.tpl' => 'administrative__cns_delurk_confirm',
            'templates/CNS_JOIN_STEP1_SCREEN.tpl' => 'cns_join_step1_screen',
            'templates/CNS_JOIN_STEP2_SCREEN.tpl' => 'cns_join_step2_screen',
            'templates/CNS_AUTO_TIME_ZONE_ENTRY.tpl' => 'cns_auto_time_zone_entry',
            'templates/CNS_USER_MEMBER.tpl' => 'cns_user_member',
            'templates/CNS_MEMBER_ACTION.tpl' => 'cns_member_profile_screen',
            'templates/CNS_EMOTICON_TABLE.tpl' => 'cns_emoticon_table',
            'templates/CNS_MEMBER_DIRECTORY_SCREEN.tpl' => 'cns_member_directory_screen',
            'templates/CNS_MEMBER_PROFILE_SCREEN.tpl' => 'cns_member_profile_screen',
            'templates/CNS_MEMBER_PROFILE_ABOUT.tpl' => 'cns_member_profile_screen',
            'templates/CNS_MEMBER_PROFILE_EDIT.tpl' => 'cns_member_profile_screen',
            'templates/CNS_USERS_ONLINE_SCREEN.tpl' => 'cns_users_online_screen',
            'templates/CNS_GROUP_DIRECTORY_SCREEN.tpl' => 'cns_group_directory_screen',
            'templates/CNS_VIEW_GROUP_MEMBER.tpl' => 'cns_view_group_screen',
            'templates/CNS_VIEW_GROUP_MEMBER_PROSPECTIVE.tpl' => 'cns_view_group_screen',
            'templates/CNS_VIEW_GROUP_MEMBER_SECONDARY.tpl' => 'cns_view_group_screen',
            'templates/CNS_VIEW_GROUP_SCREEN.tpl' => 'cns_view_group_screen',
            'templates/BLOCK_MAIN_MEMBERS.tpl' => 'block_main_members',
            'templates/BLOCK_MAIN_MEMBERS_COMPLEX.tpl' => 'block_main_members',
            'templates/CNS_MEMBER_DIRECTORY_SCREEN_FILTERS.tpl' => 'block_main_members',
            'templates/CNS_MEMBER_DIRECTORY_SCREEN_FILTER.tpl' => 'block_main_members',
            'templates/CNS_MEMBER_DIRECTORY_USERNAME.tpl' => 'cns_member_directory_username',
            'templates/CNS_POST_MAP.tpl' => 'cns_post_map',
            'templates/CNS_POST_MAP_ITEM.tpl' => 'cns_post_map',
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__administrative__cns_delurk_confirm()
    {
        return array(
            lorem_globalise(do_lorem_template('CNS_DELURK_CONFIRM', array(
                'TITLE' => lorem_title(),
                'LURKERS' => array(
                    array(
                        'ID' => '1',
                        'USERNAME' => lorem_word(),
                        'PROFILE_URL' => placeholder_url(),
                    ),
                    array(
                        'ID' => '2',
                        'USERNAME' => lorem_word_2(),
                        'PROFILE_URL' => placeholder_url(),
                    )
                ),
                'URL' => placeholder_url(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_join_step1_screen()
    {
        $group_select = new Tempcode();

        foreach (placeholder_array() as $key => $value) {
            $group_select->attach(form_input_list_entry(strval($key), false, $value));
        }

        return array(
            lorem_globalise(do_lorem_template('CNS_JOIN_STEP1_SCREEN', array(
                'TITLE' => lorem_title(),
                'RULES' => lorem_chunk_html(),
                'URL' => placeholder_url(),
                'GROUP_SELECT' => $group_select,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_join_step2_screen()
    {
        require_css('forms');

        require_lang('dates');

        $fields = new Tempcode();

        $name = placeholder_random_id();
        $input = do_lorem_template('FORM_SCREEN_INPUT_LINE', array(
            'MAXLENGTH' => '3',
            'TABINDEX' => placeholder_number(),
            'REQUIRED' => '',
            'NAME' => $name,
            'DEFAULT' => '',
        ));
        $fields->attach(do_lorem_template('FORM_SCREEN_FIELD', array(
            'REQUIRED' => true,
            'SKIP_LABEL' => false,
            'NAME' => $name,
            'PRETTY_NAME' => lorem_phrase(),
            'DESCRIPTION' => lorem_sentence_html(),
            'DESCRIPTION_SIDE' => '',
            'INPUT' => $input,
            'COMCODE' => '',
        )));

        $name = placeholder_random_id();
        $input = do_lorem_template('FORM_SCREEN_INPUT_PASSWORD', array(
            'TABINDEX' => placeholder_number(),
            'REQUIRED' => '',
            'NAME' => $name,
            'VALUE' => '',
        ));
        $fields->attach(do_lorem_template('FORM_SCREEN_FIELD', array(
            'REQUIRED' => true,
            'SKIP_LABEL' => false,
            'NAME' => $name,
            'PRETTY_NAME' => lorem_phrase(),
            'DESCRIPTION' => lorem_sentence_html(),
            'DESCRIPTION_SIDE' => '',
            'INPUT' => $input,
            'COMCODE' => '',
        )));

        $name = placeholder_random_id();
        $input = do_lorem_template('FORM_SCREEN_INPUT_PASSWORD', array(
            'TABINDEX' => placeholder_number(),
            'REQUIRED' => '',
            'NAME' => $name,
            'VALUE' => '',
        ));
        $fields->attach(do_lorem_template('FORM_SCREEN_FIELD', array(
            'REQUIRED' => true,
            'SKIP_LABEL' => false,
            'NAME' => $name,
            'PRETTY_NAME' => lorem_phrase(),
            'DESCRIPTION' => lorem_sentence_html(),
            'DESCRIPTION_SIDE' => '',
            'INPUT' => $input,
            'COMCODE' => '',
        )));

        $name = placeholder_random_id();
        $input = do_lorem_template('FORM_SCREEN_INPUT_EMAIL', array(
            'TABINDEX' => placeholder_number(),
            'REQUIRED' => '',
            'NAME' => $name,
            'DEFAULT' => '',
        ));
        $fields->attach(do_lorem_template('FORM_SCREEN_FIELD', array(
            'REQUIRED' => true,
            'SKIP_LABEL' => false,
            'NAME' => $name,
            'PRETTY_NAME' => lorem_phrase(),
            'DESCRIPTION' => lorem_sentence_html(),
            'DESCRIPTION_SIDE' => '',
            'INPUT' => $input,
            'COMCODE' => '',
        )));

        $fields->attach(do_lorem_template('FORM_SCREEN_FIELD_SPACER', array(
            'TITLE' => lorem_phrase(),
            'THEME_ALSO_INCLUDE_PAGES' => false,
        )));

        $name = placeholder_random_id();
        $timezone_list = new Tempcode();
        foreach (placeholder_array() as $key => $value) {
            $timezone_list->attach(do_lorem_template('CNS_AUTO_TIME_ZONE_ENTRY', array(
                'HOUR' => $value,
                'DW' => placeholder_date_raw(),
                'NAME' => $name,
                'SELECTED' => '',
                'CLASS' => '',
                'TEXT' => lorem_phrase(),
            )));
        }
        $input = do_lorem_template('FORM_SCREEN_INPUT_LIST', array(
            'TABINDEX' => placeholder_number(),
            'REQUIRED' => '',
            'NAME' => $name,
            'CONTENT' => $timezone_list,
            'INLINE_LIST' => false,
            'SIZE' => '9',
        ));
        $fields->attach(do_lorem_template('FORM_SCREEN_FIELD', array(
            'REQUIRED' => true,
            'SKIP_LABEL' => false,
            'NAME' => $name,
            'PRETTY_NAME' => lorem_phrase(),
            'DESCRIPTION' => lorem_sentence_html(),
            'DESCRIPTION_SIDE' => '',
            'INPUT' => $input,
            'COMCODE' => '',
        )));

        $form = do_lorem_template('FORM', array(
            'TEXT' => '',
            'HIDDEN' => '',
            'FIELDS' => $fields,
            'SUBMIT_ICON' => 'buttons__proceed',
            'SUBMIT_NAME' => do_lang_tempcode('PROCEED'),
            'URL' => placeholder_url(),
            'BATCH_IMPORT_ARCHIVE_CONTENTS' => lorem_phrase(),
        ));

        return array(
            lorem_globalise(do_lorem_template('CNS_JOIN_STEP2_SCREEN', array(
                'JAVASCRIPT' => '',
                'TITLE' => lorem_title(),
                'FORM' => $form,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_auto_time_zone_entry()
    {
        return array(
            lorem_globalise(do_lorem_template('CNS_AUTO_TIME_ZONE_ENTRY', array(
                'HOUR' => placeholder_number(),
                'DW' => date('w', time()),
                'NAME' => lorem_word(),
                'SELECTED' => false,
                'CLASS' => '',
                'TEXT' => lorem_word(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_user_member()
    {
        return array(
            lorem_globalise(do_lorem_template('CNS_USER_MEMBER', array(
                'FIRST' => true,
                'COLOUR' => '',
                'PROFILE_URL' => placeholder_url(),
                'USERNAME' => lorem_word(),
                'MEMBER_ID' => placeholder_id(),
                'USERGROUP' => lorem_word_2(),
                'AT' => lorem_phrase(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_emoticon_table()
    {
        $rows = array();
        $cols = 4;
        $cells = array();
        for ($i = 0; $i < 10; $i++) {
            if (($i % $cols == 0) && ($i != 0)) {
                $rows[] = array(
                    'CELLS' => $cells,
                );
                $cells = array();
            }
            $cells[] = array(
                'FIELD_NAME' => lorem_word(),
                'COLS' => strval($cols),
                'CODE_ESC' => '',
                'THEME_IMG_CODE' => 'cns_emoticons/smile',
                'CODE' => ':)',
            );
        }
        if ($cells !== array()) {
            $rows[] = array(
                'CELLS' => $cells,
            );
        }

        $content = do_lorem_template('CNS_EMOTICON_TABLE', array(
            'ROWS' => $rows,
        ));

        return array(
            lorem_globalise($content, null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_member_directory_username()
    {
        return array(
            lorem_globalise(do_lorem_template('CNS_MEMBER_DIRECTORY_USERNAME', array(
                'ID' => placeholder_id(),
                'USERNAME' => lorem_phrase(),
                'URL' => placeholder_url(),
                'AVATAR_URL' => placeholder_image_url(),
                'PHOTO_THUMB_URL' => placeholder_image_url(),
                'VALIDATED' => true,
                'CONFIRMED' => true,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_member_directory_screen()
    {
        return array(
            lorem_globalise(do_lorem_template('CNS_MEMBER_DIRECTORY_SCREEN', array(
                'TITLE' => lorem_title(),
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__block_main_members()
    {
        $out = array();

        foreach (array('BLOCK_MAIN_MEMBERS', 'BLOCK_MAIN_MEMBERS_COMPLEX') as $tpl) {
            $custom_fields = do_lorem_template('CNS_MEMBER_BOX_CUSTOM_FIELD', array(
                'NAME' => lorem_phrase(),
                'VALUE' => placeholder_ip(),
            ));
            $poster_details = do_lorem_template('CNS_GUEST_DETAILS', array(
                'CUSTOM_FIELDS' => $custom_fields,
            ));
            $box = do_lorem_template('CNS_MEMBER_BOX', array(
                'AVATAR_URL' => placeholder_image_url(),
                'ONLINE' => false,
                'POSTS' => placeholder_number(),
                'POINTS' => placeholder_number(),
                'JOIN_DATE_RAW' => placeholder_date_raw(),
                'MEMBER_ID' => placeholder_id(),
                'JOIN_DATE' => placeholder_date(),
                'PRIMARY_GROUP_NAME' => lorem_phrase(),
                'CUSTOM_FIELDS' => lorem_phrase(),
                'CUSTOM_FIELDS_FULL' => lorem_phrase(),
                'GIVE_CONTEXT' => false,
            ));

            $member_boxes = array();
            $member_boxes[] = array(
                'I' => '0',
                'BREAK' => false,
                'BOX' => $box,
                'MEMBER_ID' => placeholder_id(),
                'GALLERY_NAME' => '',
                'GALLERY_TITLE' => '',
            );

            $per_row = 6;

            $usergroups = array();
            $usergroups[placeholder_id()] = array('USERGROUP' => lorem_phrase(), 'NUM' => placeholder_number());

            $symbols = array(
                array(
                    'START' => '0',
                    'SYMBOL' => 'a',
                ),
                array(
                    'START' => '1',
                    'SYMBOL' => 'b',
                ),
                array(
                    'START' => '3',
                    'SYMBOL' => 'c',
                )
            );

            $out[] = lorem_globalise(do_lorem_template($tpl, array(
                'BLOCK_ID' => '',
                'START' => strval(0),
                'MAX' => strval(30),
                'SORTABLE' => 'm_join_time',
                'SORT_ORDER' => 'DESC',
                'ITEM_WIDTH' => is_null($per_row) ? '' : float_to_raw_string(99.0/*avoid possibility of rounding issues as pixels won't divide perfectly*/ / floatval($per_row)) . '%',
                'PER_ROW' => strval($per_row),
                'DISPLAY_MODE' => 'avatars',
                'MEMBER_BOXES' => $member_boxes,
                'PAGINATION' => placeholder_pagination(),
                'RESULTS_TABLE' => placeholder_table(),
                'USERGROUPS' => $usergroups,
                'SYMBOLS' => $symbols,
                'HAS_ACTIVE_FILTER' => true,
                'INCLUDE_FORM' => false,
                'SORT' => '',
            )), null, '', true);
        }

        return $out;
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_member_profile_screen()
    {
        $sections = array(
            'contact' => lorem_word(),
            'profile' => lorem_word_2(),
            'views' => lorem_word(),
            'audit' => lorem_word_2(),
            'content' => lorem_word(),
        );
        $actions = array();
        $i = 0;
        foreach ($sections as $section_code => $section_title) {
            $actions[$section_code] = do_lorem_template('CNS_MEMBER_ACTION', array(
                'ID' => strval($i),
                'URL' => placeholder_url(),
                'ICON' => 'menu/_generic_spare/1',
                'LANG' => lorem_word(),
                'REL' => '',
                'NAME' => $section_title,
            ));
            $i++;
        }

        $tabs = array();
        $tab_content = do_lorem_template('CNS_MEMBER_PROFILE_ABOUT', array(
            'RIGHT_MARGIN' => lorem_phrase(),
            'AVATAR_WIDTH' => placeholder_id(),
            'PHOTO_WIDTH' => placeholder_id(),
            'MOST_ACTIVE_FORUM' => lorem_phrase(),
            'TIME_FOR_THEM' => placeholder_date(),
            'TIME_FOR_THEM_RAW' => placeholder_date_raw(),
            'SUBMIT_DAYS_AGO' => lorem_phrase(),
            'SUBMIT_TIME_RAW' => placeholder_date_raw(),
            'LAST_VISIT_TIME_RAW' => placeholder_date_raw(),
            'ONLINE_NOW' => lorem_phrase(),
            '_ONLINE_NOW' => false,
            'BANNED' => lorem_phrase(),
            'USER_AGENT' => lorem_phrase(),
            'OPERATING_SYSTEM' => lorem_phrase(),
            'DOB' => lorem_phrase(),
            '_DOB' => placeholder_date_raw(),
            '_DOB_CENSORED' => placeholder_date_raw(),
            'IP_ADDRESS' => lorem_phrase(),
            'COUNT_POSTS' => placeholder_number(),
            'COUNT_POINTS' => placeholder_number(),
            'PRIMARY_GROUP' => lorem_phrase(),
            'PRIMARY_GROUP_ID' => placeholder_id(),
            'PHOTO_URL' => placeholder_image_url(),
            'PHOTO_THUMB_URL' => placeholder_image_url(),
            'EMAIL_ADDRESS' => lorem_word() . '@example.com',
            'AVATAR_URL' => placeholder_avatar(),
            'SIGNATURE' => lorem_phrase(),
            'JOIN_DATE' => placeholder_date(),
            'JOIN_DATE_RAW' => placeholder_date_raw(),
            'CUSTOM_FIELDS' => array(
                array(
                    'FIELD_ID' => placeholder_id(),
                    'NAME' => lorem_phrase(),
                    'VALUE' => lorem_phrase(),
                    'ENCRYPTED_VALUE' => '',
                )
            ),
            'ACTIONS_contact' => $actions['contact'],
            'ACTIONS_profile' => $actions['profile'],
            'ACTIONS_views' => $actions['views'],
            'ACTIONS_audit' => $actions['audit'],
            'ACTIONS_content' => $actions['content'],
            'USERNAME' => lorem_word(),
            'MEMBER_ID' => placeholder_id(),
            'SECONDARY_GROUPS' => placeholder_array(),
            'VIEW_PROFILES' => true,
            'ON_PROBATION' => placeholder_date_raw(),
            'USERGROUP' => lorem_word(),
            'CLUBS' => lorem_phrase(),
            'VIEWS' => placeholder_number(),
            'TOTAL_SESSIONS' => placeholder_number(),
            'EXTRA_INFO_DETAILS' => array(),
            'EXTRA_TRACKING_DETAILS' => array(),
            'USERS_TIMEZONE' => lorem_word(),
            'USERS_TIMEZONE_RAW' => lorem_word(),
        ));
        $tabs[] = array(
            'TAB_CODE' => placeholder_id() . '0',
            'TAB_TITLE' => lorem_phrase(),
            'TAB_ICON' => 'tabs/member_account/profile',
            'TAB_CONTENT' => $tab_content,
            'TAB_FIRST' => true,
            'TAB_LAST' => false,
        );
        $tabs2 = array();
        $fields = new Tempcode();
        $name = placeholder_random_id();
        $input = do_lorem_template('FORM_SCREEN_INPUT_INTEGER', array(
            'TABINDEX' => placeholder_number(),
            'REQUIRED' => '',
            'NAME' => $name,
            'DEFAULT' => '',
        ));
        $fields->attach(do_lorem_template('FORM_SCREEN_FIELD', array(
            'REQUIRED' => true,
            'SKIP_LABEL' => false,
            'NAME' => $name,
            'PRETTY_NAME' => lorem_phrase(),
            'DESCRIPTION' => lorem_sentence_html(),
            'DESCRIPTION_SIDE' => '',
            'INPUT' => $input,
            'COMCODE' => '',
        )));
        $tabs2[] = array(
            'TAB_TITLE' => lorem_phrase(),
            'TAB_ICON' => 'tabs/member_account/profile',
            'TAB_FIELDS' => $fields,
            'TAB_TEXT' => lorem_paragraph(),
            'TAB_SINGLE_FIELD' => false,
            'TAB_FIRST' => true,
            'TAB_LAST' => true,
        );
        $tab_content = do_lorem_template('CNS_MEMBER_PROFILE_EDIT', array(
            'URL' => placeholder_url(),
            'SUBMIT_ICON' => 'buttons__edit',
            'SUBMIT_NAME' => lorem_phrase(),
            'SKIP_WEBSTANDARDS' => true,
            'TABS' => $tabs2,
            'HIDDEN' => '',
        ));
        $tabs[] = array(
            'TAB_CODE' => placeholder_id() . '1',
            'TAB_TITLE' => lorem_phrase(),
            'TAB_ICON' => 'tabs/member_account/profile',
            'TAB_CONTENT' => $tab_content,
            'TAB_FIRST' => false,
            'TAB_LAST' => true,
        );

        return array(
            lorem_globalise(do_lorem_template('CNS_MEMBER_PROFILE_SCREEN', array(
                'TITLE' => get_screen_title('MEMBER_ACCOUNT', true, array(lorem_phrase(), lorem_phrase())),
                'MEMBER_ID' => placeholder_id(),
                'TABS' => $tabs,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_users_online_screen()
    {
        $rows = array();
        foreach (placeholder_array() as $key => $value) {
            $rows[] = array(
                'IP' => placeholder_ip(),
                'AT_URL' => placeholder_url(),
                'LOCATION' => lorem_word(),
                'MEMBER' => placeholder_link(),
                'TIME' => placeholder_date(),
            );
        }

        return array(
            lorem_globalise(do_lorem_template('CNS_USERS_ONLINE_SCREEN', array(
                'TITLE' => lorem_title(),
                'ROWS' => $rows,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_group_directory_screen()
    {
        return array(
            lorem_globalise(do_lorem_template('CNS_GROUP_DIRECTORY_SCREEN', array(
                'TITLE' => lorem_title(),
                'STAFF' => lorem_phrase(),
                'OTHERS' => lorem_phrase(),
                'RANKS' => array(placeholder_table(), placeholder_table())
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_view_group_screen()
    {
        $_primary_members = placeholder_array();
        $primary_members = new Tempcode();
        $_secondary_members = new Tempcode();
        $secondary_members = new Tempcode();
        $prospective_members = new Tempcode();
        $_prospective_members = new Tempcode();
        foreach ($_primary_members as $i => $primary_member) {
            $temp = do_lorem_template('CNS_VIEW_GROUP_MEMBER', array(
                'ID' => placeholder_id(),
                'NAME' => $primary_member,
                'URL' => placeholder_url(),
            ));

            //results_entry starts
            $cells = do_lorem_template('RESULTS_TABLE_FIELD', array(
                'VALUE' => $temp,
            ), null, false);
            $entries = do_lorem_template('RESULTS_TABLE_ENTRY', array(
                'VALUES' => $cells,
            ), null, false);
            //results_entry ends

            $primary_members->attach($entries);
        }

        $fields_title = do_lorem_template('RESULTS_TABLE_FIELD_TITLE', array(
            'VALUE' => lorem_word(),
        ));

        //results_table
        $primary_members = do_lorem_template('RESULTS_TABLE', array(
            'WIDTHS' => array(),
            'TEXT_ID' => placeholder_random_id(),
            'FIELDS_TITLE' => $fields_title,
            'FIELDS' => $primary_members,
            'MESSAGE' => '',
            'SORT' => '',
            'PAGINATION' => '',
        ), null, false);

        $temp = new Tempcode();
        foreach (placeholder_array() as $i => $v) {
            $temp = do_lorem_template('CNS_VIEW_GROUP_MEMBER_SECONDARY', array(
                'ID' => placeholder_id(),
                'URL' => placeholder_url(),
                'REMOVE_URL' => placeholder_url(),
                'NAME' => $v,
            ));
            $cells = do_lorem_template('RESULTS_TABLE_FIELD', array(
                'VALUE' => $temp,
            ), null, false);
            $entries = do_lorem_template('RESULTS_TABLE_ENTRY', array(
                'VALUES' => $cells,
            ), null, false);

            $_secondary_members->attach($entries);
        }
        $fields_title = do_lorem_template('RESULTS_TABLE_FIELD_TITLE', array(
            'VALUE' => lorem_word(),
        ));

        //results_table
        $secondary_members = do_lorem_template('RESULTS_TABLE', array(
            'WIDTHS' => array(),
            'TEXT_ID' => placeholder_random_id(),
            'FIELDS_TITLE' => $fields_title,
            'FIELDS' => $_secondary_members,
            'MESSAGE' => '',
            'SORT' => '',
            'PAGINATION' => '',
        ), null, false);

        foreach (placeholder_array() as $i => $v) {
            $temp = do_lorem_template('CNS_VIEW_GROUP_MEMBER_PROSPECTIVE', array(
                'ID' => placeholder_id(),
                'ACCEPT_URL' => placeholder_url(),
                'DECLINE_URL' => placeholder_url(),
                'NAME' => lorem_word(),
                'URL' => placeholder_url(),
            ));
            $cells = do_lorem_template('RESULTS_TABLE_FIELD', array(
                'VALUE' => $temp,
            ), null, false);
            $entries = do_lorem_template('RESULTS_TABLE_ENTRY', array(
                'VALUES' => $cells,
            ), null, false);

            $_prospective_members->attach($entries);
        }
        $fields_title = do_lorem_template('RESULTS_TABLE_FIELD_TITLE', array(
            'VALUE' => lorem_word(),
        ));

        //results_table
        $prospective_members = do_lorem_template('RESULTS_TABLE', array(
            'WIDTHS' => array(),
            'TEXT_ID' => placeholder_random_id(),
            'FIELDS_TITLE' => $fields_title,
            'FIELDS' => $_prospective_members,
            'MESSAGE' => '',
            'SORT' => '',
            'PAGINATION' => '',
        ), null, false);

        return array(
            lorem_globalise(do_lorem_template('CNS_VIEW_GROUP_SCREEN', array(
                'GROUP_NAME' => lorem_phrase(),
                'ID' => placeholder_id(),
                'FORUM' => '',
                'CLUB' => false,
                'EDIT_URL' => placeholder_url(),
                'TITLE' => lorem_title(),
                'LEADER' => lorem_phrase(),
                'NAME' => lorem_word(),
                'PROMOTION_INFO' => new Tempcode(),
                'ADD_URL' => placeholder_url(),
                'APPLY_URL' => placeholder_url(),
                'APPLY_TEXT' => lorem_phrase(),
                'PRIMARY_MEMBERS' => $primary_members,
                'SECONDARY_MEMBERS' => $secondary_members,
                'PROSPECTIVE_MEMBERS' => $prospective_members,
            )), null, '', true)
        );
    }

    /**
     * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
     * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
     * Assumptions: You can assume all Lang/CSS/JavaScript files in this addon have been pre-required.
     *
     * @return array Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
     */
    public function tpl_preview__cns_post_map()
    {
        $items = new Tempcode();

        $items->attach(do_lorem_template('CNS_POST_MAP_ITEM', array(
            'TITLE' => lorem_phrase(),
            'URL' => placeholder_url(),
            'POST_NUMBER'  =>  placeholder_number(),
            'POSTER_ID' => placeholder_number(),
            'POSTER_IS_GUEST' => false,
            'POSTER_URL' => placeholder_url(),
            'POSTER_NAME' => lorem_phrase(),
            'LEVEL_HAS_ADJACENT_SIBLING' => array(true),
            'POST_LEVEL' => '0',
            'TIME' => placeholder_date(),
            'IS_UNREAD' => true,
        )));
        $items->attach(do_lorem_template('CNS_POST_MAP_ITEM', array(
            'TITLE' => lorem_phrase(),
            'URL' => placeholder_url(),
            'POST_NUMBER'  =>  placeholder_number(),
            'POSTER_ID' => placeholder_number(),
            'POSTER_IS_GUEST' => false,
            'POSTER_URL' => placeholder_url(),
            'POSTER_NAME' => lorem_phrase(),
            'LEVEL_HAS_ADJACENT_SIBLING' => array(true),
            'POST_LEVEL' => '0',
            'TIME' => placeholder_date(),
            'IS_UNREAD' => false,
        )));
        $items->attach(do_lorem_template('CNS_POST_MAP_ITEM', array(
            'TITLE' => lorem_phrase(),
            'URL' => placeholder_url(),
            'POST_NUMBER'  =>  placeholder_number(),
            'POSTER_ID' => placeholder_number(),
            'POSTER_IS_GUEST' => false,
            'POSTER_URL' => placeholder_url(),
            'POSTER_NAME' => lorem_phrase(),
            'LEVEL_HAS_ADJACENT_SIBLING' => array(false, true),
            'POST_LEVEL' => '1',
            'TIME' => placeholder_date(),
            'IS_UNREAD' => false,
        )));

        return array(
            lorem_globalise(do_lorem_template('CNS_POST_MAP', array(
                'ITEMS' => $items,
            )), null, '', true)
        );
    }
}
