<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    core
 */

/**
 * Hook class.
 */
class Hook_check_mysql_version
{
    /**
     * Check various input var restrictions.
     *
     * @return array List of warnings
     */
    public function run()
    {
        $minimum_version = '5.5.3'; // also maintain in tut_webhosting.txt
        // ^ Why? We need this for proper Unicode support: https://dev.mysql.com/doc/refman/5.5/en/charset-unicode-utf8mb4.html

        // If you really need to fiddle it and don't care about emoji, add this to _config.php while installing (before step 5 runs):   $SITE_INFO['database_charset'] = 'utf8';

        if (!isset($GLOBALS['SITE_DB'])) {
            return array();
        }

        $warning = array();
        if ((!is_array($GLOBALS['SITE_DB']->connection_read)) || (count($GLOBALS['SITE_DB']->connection_read) <= 4)) {
            if (function_exists('mysqli_get_server_version') && get_db_type() == 'mysqli') {
                $__version = @mysqli_get_server_version($GLOBALS['SITE_DB']->connection_read[0]);
                if ($__version !== false) {
                    $_version = strval($__version);
                    $version = strval(intval(substr($_version, 0, strlen($_version) - 4))) . '.' . strval(intval(substr($_version, -4, 2))) . '.' . strval(intval(substr($_version, -2, 2)));
                    if (version_compare($version, $minimum_version, '<')) {
                        $warning[] = do_lang_tempcode('MYSQL_TOO_OLD', escape_html($minimum_version), escape_html($version));
                    }
                }
            } elseif (function_exists('mysql_get_server_info') && get_db_type() == 'mysql') {
                $version = @mysql_get_server_info($GLOBALS['SITE_DB']->connection_read[0]);
                if ($version !== false) {
                    if (version_compare($version, $minimum_version, '<')) {
                        $warning[] = do_lang_tempcode('MYSQL_TOO_OLD', escape_html($minimum_version), escape_html($version));
                    }
                }
            } elseif (get_db_type() == 'mysql_pdo') {
                $version = $GLOBALS['SITE_DB']->query_value_if_there('SELECT version()');
                if (version_compare($version, $minimum_version, '<')) {
                    $warning[] = do_lang_tempcode('MYSQL_TOO_OLD', escape_html($minimum_version), escape_html($version));
                }
            }
        }
        return $warning;
    }
}
