<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    core_rich_media
 */

/**
 * Hook class.
 */
class Hook_preview_comcode_tag
{
    /**
     * Find whether this preview hook applies.
     *
     * @return array Triplet: Whether it applies, the attachment ID type, whether the forum DB is used [optional]
     */
    public function applies()
    {
        $applies = !is_null(post_param_string('tag_contents', null)) || !is_null(post_param_string('tag_contents__a', null)) || !is_null(post_param_string('tag_contents__b', null)) || !is_null(post_param_string('tag_contents_0', null));
        return array($applies, null, false);
    }

    /**
     * Run function for preview hooks.
     *
     * @return array A pair: The preview, the updated post Comcode
     */
    public function run()
    {
        require_code('comcode_add');

        $comcode = _get_preview_environment_comcode(post_param_string('tag'));
        $temp_tpl = comcode_to_tempcode($comcode);

        return array($temp_tpl, null);
    }
}
