<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    core_cns
 */

/**
 * Hook class.
 */
class Hook_rss_cns_birthdays
{
    /**
     * Run function for RSS hooks.
     *
     * @param  string $_filters A list of categories we accept from
     * @param  TIME $cutoff Cutoff time, before which we do not show results from
     * @param  string $prefix Prefix that represents the template set we use
     * @set    RSS_ ATOM_
     * @param  string $date_string The standard format of date to use for the syndication type represented in the prefix
     * @param  integer $max The maximum number of entries to return, ordering by date
     * @return ?array A pair: The main syndication section, and a title (null: error)
     */
    public function run($_filters, $cutoff, $prefix, $date_string, $max)
    {
        if (get_forum_type() != 'cns') {
            return null;
        }

        $days = get_param_integer('days', 30);

        $method = get_param_string('method', 'happened'); // happened|happening|stream_in

        if ($method == 'happening') {
            if ($cutoff < time()) {
                $cutoff += (time() - $cutoff) * 2;
            }
        }

        require_lang('dates');

        $filters_1 = selectcode_to_sqlfragment($_filters, 'd.gm_group_id', 'f_groups', null, 'd.gm_group_id', 'id', true, true, $GLOBALS['FORUM_DB']); // Note that the parameters are fiddled here so that category-set and record-set are the same, yet SQL is returned to deal in an entirely different record-set (entries' record-set)
        $filters_2 = selectcode_to_sqlfragment($_filters, 'p.m_primary_group', 'f_groups', null, 'p.m_primary_group', 'id', true, true, $GLOBALS['FORUM_DB']); // Note that the parameters are fiddled here so that category-set and record-set are the same, yet SQL is returned to deal in an entirely different record-set (entries' record-set)
        $filters = '(' . $filters_1 . ' OR ' . $filters_2 . ')';

        if ($method == 'stream_in') {
            $filters .= ' AND m_join_time>' . strval(time() - 60 * 60 * 24 * $days);
            $order = 'm_join_time DESC';
        } else {
            $order = 'm_last_visit_time DESC';
            $max = 10000;
        }

        $join = '';
        if ($filters != '(1=1 OR 1=1)') {
            $join = ' LEFT JOIN ' . $GLOBALS['FORUM_DB']->get_table_prefix() . 'f_group_members d ON (d.gm_member_id=p.id AND d.gm_validated=1)';
        }
        $rows = $GLOBALS['FORUM_DB']->query('SELECT id,m_dob_day,m_dob_month,m_dob_year,m_username,m_reveal_age,m_join_time FROM ' . $GLOBALS['FORUM_DB']->get_table_prefix() . 'f_members p' . $join . ' WHERE m_validated=1 AND ' . $filters . ' AND m_dob_day IS NOT NULL ORDER BY ' . $order, $max);

        $rows = remove_duplicate_rows($rows);

        $done = 0;

        $year = intval(date('Y', time()));

        $content = new Tempcode();

        foreach ($rows as $i => &$row) {
            if ($method == 'happened') {
                $cutoff_today = (time() + 60 * 60 * 24 * 1/*1 international time line*/);
                $previous_birthday_time_this_year = mktime(0, 0, 0, $row['m_dob_month'], $row['m_dob_day'], $year);
                $previous_birthday_time_last_year = mktime(0, 0, 0, $row['m_dob_month'], $row['m_dob_day'], $year - 1);
                $birthday_time = ($previous_birthday_time_this_year > $cutoff_today) ? $previous_birthday_time_last_year : $previous_birthday_time_this_year;
                $display = ($birthday_time > $cutoff) && ($birthday_time < $cutoff_today) && ($birthday_time > time() - 60 * 60 * 24 * $days);
            } elseif ($method == 'happening') {
                $cutoff_today = (time() - 60 * 60 * 24 * 1/*1 international time line*/);
                $next_birthday_time_this_year = mktime(0, 0, 0, $row['m_dob_month'], $row['m_dob_day'], $year);
                $next_birthday_time_next_year = mktime(0, 0, 0, $row['m_dob_month'], $row['m_dob_day'], $year + 1);
                $birthday_time = ($next_birthday_time_this_year < $cutoff_today) ? $next_birthday_time_next_year : $next_birthday_time_this_year;
                $display = ($birthday_time < $cutoff) && ($birthday_time > $cutoff_today) && ($birthday_time < time() + 60 * 60 * 24 * $days);
            } else { // stream_in
                $cutoff_today = (time() - 60 * 60 * 24 * 1/*1 international time line*/);
                $next_birthday_time_this_year = mktime(0, 0, 0, $row['m_dob_month'], $row['m_dob_day'], $year);
                $next_birthday_time_next_year = mktime(0, 0, 0, $row['m_dob_month'], $row['m_dob_day'], $year + 1);
                $birthday_time = ($next_birthday_time_this_year < $cutoff_today) ? $next_birthday_time_next_year : $next_birthday_time_this_year;
                $display = true;
            }

            if ($display) {
                $row['birthday_time'] = $birthday_time;
            } else {
                unset($rows[$i]);
            }
        }

        if ($method == 'happened') {
            sort_maps_by($rows, '!birthday_time');
        } elseif ($method == 'happening') {
            sort_maps_by($rows, 'birthday_time');
        }

        $GLOBALS['NO_QUERY_LIMIT'] = true;

        foreach ($rows as $row) {
            $id = strval($row['id']);
            $author = $row['m_username'];

            $news_date = date($date_string, $row['birthday_time']); // The "post" date is actually the birthday
            $edit_date = date($date_string, max($row['m_join_time'], $row['birthday_time'])); // The "edit" date is actually the join date

            if ($row['m_reveal_age'] == 1) {
                $news_title = xmlentities(do_lang('BIRTHDAY_OF_AGE', $author, strval($year - $row['m_dob_year'])));
            } else {
                $news_title = xmlentities(do_lang('BIRTHDAY_OF', $author));
            }
            $summary = '';
            $news = '';

            $category = do_lang('BIRTHDAY');
            $category_raw = do_lang('BIRTHDAY');

            $view_url = $GLOBALS['FORUM_DRIVER']->member_profile_url($row['id'], true, false, $row['m_username']);

            $if_comments = new Tempcode();

            $content->attach(do_template($prefix . 'ENTRY', array('VIEW_URL' => $view_url, 'SUMMARY' => $summary, 'EDIT_DATE' => $edit_date, 'IF_COMMENTS' => $if_comments, 'TITLE' => $news_title, 'CATEGORY_RAW' => $category_raw, 'CATEGORY' => $category, 'AUTHOR' => $author, 'ID' => $id, 'NEWS' => $news, 'DATE' => $news_date), null, false, null, '.xml', 'xml'));

            $done++;
            if ($done == $max) {
                break;
            }
        }

        require_lang('cns');
        return array($content, do_lang('BIRTHDAYS'));
    }
}
