<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    wiki
 */

/**
 * Hook class.
 */
class Hook_stats_wiki
{
    /**
     * Show a stats section.
     *
     * @return Tempcode The result of execution.
     */
    public function run()
    {
        if (!addon_installed('wiki')) {
            return new Tempcode();
        }

        require_code('wiki_stats');
        require_lang('wiki');

        $bits = new Tempcode();
        if (get_option('wiki_show_stats_count_pages') == '1') {
            $bits->attach(do_template('BLOCK_SIDE_STATS_SUBLINE', array('_GUID' => '8bbd18d5169c4e5449b252880ecda716', 'KEY' => do_lang_tempcode('COUNT_PAGES'), 'VALUE' => integer_format(get_num_wiki_pages()))));
        }
        if (get_option('wiki_show_stats_count_posts') == '1') {
            $bits->attach(do_template('BLOCK_SIDE_STATS_SUBLINE', array('_GUID' => 'd8cf3d5aabc18777f609760010303ace', 'KEY' => do_lang_tempcode('COUNT_POSTS'), 'VALUE' => integer_format(get_num_wiki_posts()))));
        }
        if ($bits->is_empty_shell()) {
            return new Tempcode();
        }
        $wiki = do_template('BLOCK_SIDE_STATS_SECTION', array('_GUID' => 'ea19e51db4e62958843ace808016af1e', 'SECTION' => do_lang_tempcode('WIKI'), 'CONTENT' => $bits));

        return $wiki;
    }
}
