<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    commandr
 */

/**
 * Hook class.
 */
class Hook_commandr_command_phpinfo
{
    /**
     * Run function for Commandr hooks.
     *
     * @param  array $options The options with which the command was called
     * @param  array $parameters The parameters with which the command was called
     * @param  object $commandr_fs A reference to the Commandr filesystem object
     * @return array Array of stdcommand, stdhtml, stdout, and stderr responses
     */
    public function run($options, $parameters, &$commandr_fs)
    {
        if ((array_key_exists('h', $options)) || (array_key_exists('help', $options))) {
            return array('', do_command_help('phpinfo', array('h'), array()), '', '');
        } else {
            ob_start();
            if (php_function_allowed('phpinfo')) {
                phpinfo();
            } else {
                var_dump(PHP_VERSION);
                var_dump($_SERVER);
                var_dump($_ENV);
                var_dump($_COOKIE);
                if (function_exists('ini_get_all')) {
                    var_dump(ini_get_all());
                }
                if (function_exists('get_loaded_extensions')) {
                    var_dump(get_loaded_extensions());
                }
                if (function_exists('phpcredits')) {
                    var_dump(phpcredits());
                }
            }
            $out = ob_get_clean();
            require_code('xhtml');

            $out = preg_replace('#<!DOCTYPE[^>]*>#s', '', preg_replace('#</body[^>]*>#', '', preg_replace('#<body[^>]*>#', '', preg_replace('#</html[^>]*>#', '', preg_replace('#<html[^>]*>#', '', $out)))));
            $matches = array();
            if (preg_match('#<style[^>]*>#', $out, $matches) != 0) {
                $offset = strpos($out, $matches[0]) + strlen($matches[0]);
                $end = strpos($out, '</style>', $offset);
                if ($end !== false) {
                    $style = substr($out, $offset - strlen($matches[0]), $end - $offset + strlen('</style>') + strlen($matches[0]));
                    //attach_to_screen_header($style);      Not relevant due to running in Commandr

                    $out = substr($out, 0, $offset) . substr($out, $end);
                }
            }
            $out = preg_replace('#<head[^>]*>.*</head[^>]*>#s', '', $out);

            $out = str_replace(' width="600"', ' width="100%"', $out);
            $out = cms_preg_replace_safe('#([^\s<>"\']{65}&[^;]+;)#', '${1}<br />', $out);
            $out = cms_preg_replace_safe('#([^\s<>"\']{95})#', '${1}<br />', $out);
            $url_parts = parse_url(get_base_url());
            $out = str_replace('<img border="0" src="/', '<img border="0" style="padding-top: 20px" src="http://' . escape_html($url_parts['host']) . '/', $out);

            return array('', xhtmlise_html($out, true), '', '');
        }
    }
}
