<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    core_menus
 */

/**
 * Hook class.
 */
class Hook_preview_menu
{
    /**
     * Find whether this preview hook applies.
     *
     * @return array Triplet: Whether it applies, the attachment ID type, whether the forum DB is used [optional]
     */
    public function applies()
    {
        $applies = (get_page_name() == 'admin_menus');
        return array($applies, null, false);
    }

    /**
     * Run function for preview hooks.
     *
     * @return array A pair: The preview, the updated post Comcode
     */
    public function run()
    {
        require_code('menus');
        require_code('menus2');

        $menu_type = get_param_string('menu_type', '');
        $menu_types = array();
        if ($menu_type == '') {
            $matches = array();
            $dh = opendir(get_file_base() . '/themes/default/templates/');
            while (($file = readdir($dh)) !== false) {
                if (preg_match('^MENU\_([a-z]+)\.tpl$^', $file, $matches) != 0) {
                    $menu_types[] = $matches[1];
                }
            }
            closedir($dh);
            $dh = opendir(get_custom_file_base() . '/themes/default/templates_custom/');
            while (($file = readdir($dh)) !== false) {
                if ((preg_match('^MENU\_([a-z]+)\.tpl$^', $file, $matches) != 0) && (!file_exists(get_file_base() . '/themes/default/templates/' . $file))) {
                    $menu_types[] = $matches[1];
                }
            }
            closedir($dh);
            sort($menu_types);
        } else {
            $menu_types[]  = $menu_type;
        }

        $menu_id = '_preview';

        delete_menu($menu_id);

        $old_ids = array();

        // Now, process everything on the root
        $ids = menu_items_being_saved();
        $order = 0;
        foreach (array_keys($ids) as $id) {
            $parent = $ids[$id];

            if ($parent == '') {
                save_add_menu_item_from_post($menu_id, $id, $ids, null, $old_ids, $order);
                $order++;
            }
        }

        $output = new Tempcode();
        foreach ($menu_types as $menu_type) {
            if (($menu_type == 'mobile') && (count($menu_types) > 1)) {
                continue; // Does not preview well
            }

            list($_output, ) = build_menu($menu_type, $menu_id);
            if (count($menu_types) > 1) {
                $output->attach('<h3>' . escape_html($menu_type) . '</h3>');
            }
            $output->attach(div($_output, '', 'float_surrounder'));
        }

        delete_menu($menu_id);

        return array($output, null);
    }
}
