<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    core_feedback_features
 */

/**
 * Hook class.
 */
class Hook_snippet_comments
{
    /**
     * Run function for snippet hooks. Generates XHTML to insert into a page using AJAX.
     *
     * @return Tempcode The snippet
     */
    public function run()
    {
        if (get_option('is_on_comments') == '0') {
            warn_exit(do_lang_tempcode('INTERNAL_ERROR'));
        }

        $serialized_options = get_param_string('serialized_options', false, true);
        $hash = get_param_string('hash');

        require_code('crypt');
        if (ratchet_hash($serialized_options, get_site_salt()) != $hash) {
            warn_exit(do_lang_tempcode('INTERNAL_ERROR'));
        }

        secure_serialized_data($serialized_options);
        list($topic_id, $num_to_show_limit, $allow_comments, $invisible_if_no_comments, $forum, $reverse, $may_reply, $highlight_by_user, $allow_reviews) = cms_unserialize($serialized_options);

        $posts = array_map('intval', explode(',', get_param_string('ids', false, true)));

        $_parent_id = get_param_string('id', '');
        $parent_id = ($_parent_id == '') ? mixed() : intval($_parent_id);

        require_code('topics');
        $renderer = new CMS_Topic();
        return $renderer->render_posts_from_topic($topic_id, $num_to_show_limit, $allow_comments, $invisible_if_no_comments, $forum, null, $reverse, $may_reply, $highlight_by_user, $allow_reviews, $posts, $parent_id);
    }
}
