<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license        http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright      ocProducts Ltd
 * @package        core_cns
 */

/**
 * Hook class.
 */
class Hook_snippet_member_tooltip
{
    /**
     * Standard modular run function for snippet hooks. Generates XHTML to insert into a page using AJAX.
     *
     * @return Tempcode The snippet
     */
    public function run()
    {
        require_lang('cns');
        require_code('cns_members2');

        $hooks = find_all_hooks('modules', 'topicview');
        $sga_hook_objects = array();
        foreach (array_keys($hooks) as $hook) {
            require_code('hooks/modules/topicview/' . filter_naughty_harsh($hook));
            $object = object_factory('Hook_topicview_' . filter_naughty_harsh($hook), true);
            if (is_null($object)) {
                continue;
            }
            $sga_hook_objects[$hook] = $object;
        }

        return render_member_box(get_param_integer('member_id'), true, $hooks, $sga_hook_objects, false);
    }
}


