<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    core
 */

/**
 * Get obfuscate version of 'mailto:' (which'll hopefully fool e-mail scavengers to not pick up these e-mail addresses).
 *
 * @return string The obfuscated 'mailto:' string
 */
function mailto_obfuscated()
{
    static $ret = null;
    if ($ret === null) {
        $ret = 'm' . obfuscate_entities('ailto:');
    }
    return $ret;
}

/**
 * Obfuscate the given text using HTML entity encoding.
 *
 * @param  string $val The text to obfuscate
 * @return string The obfuscated version
 */
function obfuscate_entities($val)
{
    if (strpos($val, '&') !== false) {
        return $val; // Prevent double encoding
    }

    $out = '';
    for ($i = 0; $i < strlen($val); $i++) {
        $char = $val[$i];
        if ($char == '<') {
            $_char = '&lt;';
        } elseif ($char == '>') {
            $_char = '&gt;';
        } elseif ($char == '&') {
            $_char = '&amp;';
        } elseif ($i % 2 == 0) {
            $_char = '&#' . strval(ord($char)) . ';';
        } else {
            $_char = '&#x' . dechex(ord($char)) . ';';
        }

        $out .= $_char;
    }
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($out);
    }
    return $out;
}

/**
 * Obfuscate the given e-mail address.
 * This function may want to be modified on a per-site basis, to stop spammers triggering onto Composr's default method (possible some already do, although I think it unlikely they would go to this much effort/computation unless it was more widespread to do this).
 *
 * @param  string $email The e-mail address to obfuscate
 * @return string The obfuscated version
 */
function obfuscate_email_address($email)
{
    /* One possibility (conventional, but annoying)...
    $i = mt_rand(0, strlen($email));
    $rep = '^remove_me^';
    return substr($email, 0, $i) . $rep . substr($email, $i);
    */

    /* One possibility (conventional, but annoying)...
    $at_pos = strpos($email, '@');
    return substr($email, 0, $at_pos) . 'AT' . substr($email, $at_pos + 1);
    */

    /* Randomly mutated e-mail addresses, so that we can block e-mail address mutations that have become spammed. This would be for webmasters who have default mail for the domain forwarded to themselves.
    $at_pos = strpos($email, '@');
    return substr($email, 0, $at_pos) . mt_rand(0, mt_getrandmax()) . substr($email, $at_pos);
    */

    /* Another possibility would be to write some JavaScript that scans the page after loading, and rewrite algorithmically mangled addresses. (You'd need to write some JavaScript to match this, we haven't)
    $remap = array('a' => 'alpha',
                   'b' => 'beta',
                   'c' => 'no',
                   'd' => 'delta',
                   'e' => 'epsilon',
                   'f' => 'more',
                   'g' => 'gamma',
                   'h' => 'eta',
                   'i' => 'iota',
                   'j' => 'letters',
                   'k' => 'kappa',
                   'l' => 'lambda',
                   'm' => 'mu',
                   'n' => 'nu',
                   'o' => 'omicron',
                   'p' => 'pi',
                   'q' => 'xi',
                   'r' => 'rho',
                   's' => 'psi',
                   't' => 'tau',
                   'u' => 'theta',
                   'v' => 'sigma',
                   'w' => 'phi',
                   'x' => 'chi',
                   'y' => 'upsilon',
                   'z' => 'zeta',
    );
    $out = '';
    for ($i = 0; $i < strlen($email)) {
        $at = $email[$i];
        $out .= (array_key_exists($at, $remap)) ? ('{' . $remap[$at] . '}') : $at;
    }
    return $out;
    */

    return obfuscate_entities($email);
}
