<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    core
 */

/**
 * Helper function for *_text_file
 *
 * @param  string $codename The file name (without .txt)
 * @param  ?LANGUAGE_NAME $lang The language to load from (null: none) (blank: search)
 * @return string The path to the file
 *
 * @ignore
 */
function _find_text_file_path($codename, $lang)
{
    if ($lang === null) {
        $langs = array('');
    } elseif ($lang != '') {
        $langs = array($lang);
    } else {
        $langs = array(user_lang());
        if (get_site_default_lang() != user_lang()) {
            $langs[] = get_site_default_lang();
        }
        if (fallback_lang() != get_site_default_lang()) {
            $langs[] = fallback_lang();
        }
    }
    $i = 0;
    $path = '';
    do {
        $lang = $langs[$i];
        $path = get_custom_file_base() . '/text_custom/' . $lang . (($lang == '') ? '' : '/') . $codename . '.txt';
        if (!is_file($path)) {
            $path = get_file_base() . '/text_custom/' . $lang . (($lang == '') ? '' : '/') . $codename . '.txt';
        }
        if (!is_file($path)) {
            $path = get_file_base() . '/text/' . $lang . (($lang == '') ? '' : '/') . $codename . '.txt';
        }
        $i++;
    } while ((!is_file($path)) && (array_key_exists($i, $langs)));
    if (!is_file($path)) {
        $path = '';
    }

    return $path;
}

/**
 * Read a text file, using the _custom system
 *
 * @param  string $codename The file name (without .txt)
 * @param  ?LANGUAGE_NAME $lang The language to load from (null: none) (blank: search)
 * @param  boolean $missing_blank Whether to tolerate missing files
 * @return string The file contents
 */
function read_text_file($codename, $lang = null, $missing_blank = false)
{
    $path = _find_text_file_path($codename, $lang);

    if (!is_file($path)) {
        if ($lang !== fallback_lang()) {
            return read_text_file($codename, fallback_lang(), $missing_blank);
        }

        if ($missing_blank) {
            return '';
        }
        warn_exit(do_lang_tempcode('MISSING_TEXT_FILE', escape_html($codename), escape_html('text/' . (is_null($lang) ? '' : ($lang . '/')) . $codename . '.txt')));
    }
    $in = unixify_line_format(cms_file_get_contents_safe($path));

    if (strpos($path, '_custom/') === false) {
        global $LANG_FILTER_OB;
        $in = $LANG_FILTER_OB->compile_time(null, $in, $lang);
    }

    return $in;
}

/**
 * Write a text file, using the _custom system
 *
 * @param  string $codename The file name (without .txt)
 * @param  ?LANGUAGE_NAME $lang The language to write for (null: none) (blank: search)
 * @param  string $out The data to write
 */
function write_text_file($codename, $lang, $out)
{
    $xpath = _find_text_file_path($codename, $lang);
    if ($xpath == '') {
        $xpath = get_file_base() . '/text/' . user_lang() . '/' . $codename . '.txt';
    }
    $path = str_replace(get_file_base() . '/text/', get_custom_file_base() . '/text_custom/', $xpath);

    require_code('files');

    cms_file_put_contents_safe($path, $out, FILE_WRITE_FIX_PERMISSIONS | FILE_WRITE_SYNC_FILE);

    // Backup with a timestamp (useful if for example an addon update replaces changes)
    $path .= '.' . strval(time());
    cms_file_put_contents_safe($path, $out, FILE_WRITE_FIX_PERMISSIONS | FILE_WRITE_SYNC_FILE);
}
