SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `ojs3409`
--
-- --------------------------------------------------------

--
-- Table structure for table `access_keys`
--

CREATE TABLE `access_keys` (
  `access_key_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context` varchar(40) NOT NULL,
  `key_hash` varchar(40) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `assoc_id` bigint(20) DEFAULT NULL,
  `expiry_date` datetime NOT NULL,
  PRIMARY KEY (`access_key_id`),
  KEY `access_keys_user_id` (`user_id`),
  KEY `access_keys_hash` (`key_hash`,`user_id`,`context`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Access keys are used to provide pseudo-login functionality for security-minimal tasks. Passkeys can be emailed directly to users, who can use them for a limited time in lieu of standard username and password.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `announcements`
--

CREATE TABLE `announcements` (
  `announcement_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` smallint(6) DEFAULT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `type_id` bigint(20) DEFAULT NULL,
  `date_expire` date DEFAULT NULL,
  `date_posted` datetime NOT NULL,
  PRIMARY KEY (`announcement_id`),
  KEY `announcements_type_id` (`type_id`),
  KEY `announcements_assoc` (`assoc_type`,`assoc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Announcements are messages that can be presented to users e.g. on the homepage.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `announcement_settings`
--

CREATE TABLE `announcement_settings` (
  `announcement_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `announcement_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`announcement_setting_id`),
  UNIQUE KEY `announcement_settings_unique` (`announcement_id`,`locale`,`setting_name`),
  KEY `announcement_settings_announcement_id` (`announcement_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about announcements, including localized properties like names and contents.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `announcement_types`
--

CREATE TABLE `announcement_types` (
  `type_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  PRIMARY KEY (`type_id`),
  KEY `announcement_types_context_id` (`context_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Announcement types allow for announcements to optionally be categorized.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `announcement_type_settings`
--

CREATE TABLE `announcement_type_settings` (
  `announcement_type_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`announcement_type_setting_id`),
  UNIQUE KEY `announcement_type_settings_unique` (`type_id`,`locale`,`setting_name`),
  KEY `announcement_type_settings_type_id` (`type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about announcement types, including localized properties like their names.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `authors`
--

CREATE TABLE `authors` (
  `author_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `email` varchar(90) NOT NULL,
  `include_in_browse` smallint(6) NOT NULL DEFAULT '1',
  `publication_id` bigint(20) NOT NULL,
  `seq` double(8,2) NOT NULL DEFAULT '0.00',
  `user_group_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`author_id`),
  KEY `authors_user_group_id` (`user_group_id`),
  KEY `authors_publication_id` (`publication_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The authors of a publication.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `author_settings`
--

CREATE TABLE `author_settings` (
  `author_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `author_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`author_setting_id`),
  UNIQUE KEY `author_settings_unique` (`author_id`,`locale`,`setting_name`),
  KEY `author_settings_author_id` (`author_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about authors, including localized properties such as their name and affiliation.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `categories`
--

CREATE TABLE `categories` (
  `category_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `parent_id` bigint(20) DEFAULT NULL,
  `seq` bigint(20) DEFAULT NULL,
  `path` varchar(255) NOT NULL,
  `image` text,
  PRIMARY KEY (`category_id`),
  UNIQUE KEY `category_path` (`context_id`,`path`),
  KEY `category_context_id` (`context_id`),
  KEY `category_context_parent_id` (`context_id`,`parent_id`),
  KEY `category_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Categories permit the organization of submissions into a heirarchical structure.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `category_settings`
--

CREATE TABLE `category_settings` (
  `category_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`category_setting_id`),
  UNIQUE KEY `category_settings_unique` (`category_id`,`locale`,`setting_name`),
  KEY `category_settings_category_id` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about categories, including localized properties such as names.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `citations`
--

CREATE TABLE `citations` (
  `citation_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `publication_id` bigint(20) NOT NULL,
  `raw_citation` text NOT NULL,
  `seq` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`citation_id`),
  UNIQUE KEY `citations_publication_seq` (`publication_id`,`seq`),
  KEY `citations_publication` (`publication_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A citation made by an associated publication.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `citation_settings`
--

CREATE TABLE `citation_settings` (
  `citation_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `citation_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`citation_setting_id`),
  UNIQUE KEY `citation_settings_unique` (`citation_id`,`locale`,`setting_name`),
  KEY `citation_settings_citation_id` (`citation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Additional data about citations, including localized content.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `completed_payments`
--

CREATE TABLE `completed_payments` (
  `completed_payment_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `payment_type` bigint(20) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `assoc_id` bigint(20) DEFAULT NULL,
  `amount` double(8,2) NOT NULL,
  `currency_code_alpha` varchar(3) DEFAULT NULL,
  `payment_method_plugin_name` varchar(80) DEFAULT NULL,
  PRIMARY KEY (`completed_payment_id`),
  KEY `completed_payments_context_id` (`context_id`),
  KEY `completed_payments_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A list of completed (fulfilled) payments relating to a payment type such as a subscription payment.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `controlled_vocabs`
--

CREATE TABLE `controlled_vocabs` (
  `controlled_vocab_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `symbolic` varchar(64) NOT NULL,
  `assoc_type` bigint(20) NOT NULL DEFAULT '0',
  `assoc_id` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`controlled_vocab_id`),
  UNIQUE KEY `controlled_vocab_symbolic` (`symbolic`,`assoc_type`,`assoc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Every word or phrase used in a controlled vocabulary. Controlled vocabularies are used for submission metadata like keywords and subjects, reviewer interests, and wherever a similar dictionary of words or phrases is required. Each entry corresponds to a word or phrase like "cellular reproduction" and a type like "submissionKeyword".' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `controlled_vocab_entries`
--

CREATE TABLE `controlled_vocab_entries` (
  `controlled_vocab_entry_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `controlled_vocab_id` bigint(20) NOT NULL,
  `seq` double(8,2) DEFAULT NULL,
  PRIMARY KEY (`controlled_vocab_entry_id`),
  KEY `controlled_vocab_entries_controlled_vocab_id` (`controlled_vocab_id`),
  KEY `controlled_vocab_entries_cv_id` (`controlled_vocab_id`,`seq`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The order that a word or phrase used in a controlled vocabulary should appear. For example, the order of keywords in a publication.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `controlled_vocab_entry_settings`
--

CREATE TABLE `controlled_vocab_entry_settings` (
  `controlled_vocab_entry_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `controlled_vocab_entry_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`controlled_vocab_entry_setting_id`),
  UNIQUE KEY `c_v_e_s_pkey` (`controlled_vocab_entry_id`,`locale`,`setting_name`),
  KEY `c_v_e_s_entry_id` (`controlled_vocab_entry_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about a controlled vocabulary entry, including localized properties such as the actual word or phrase.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `custom_issue_orders`
--

CREATE TABLE `custom_issue_orders` (
  `custom_issue_order_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `issue_id` bigint(20) NOT NULL,
  `journal_id` bigint(20) NOT NULL,
  `seq` double(8,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`custom_issue_order_id`),
  UNIQUE KEY `custom_issue_orders_unique` (`issue_id`),
  KEY `custom_issue_orders_issue_id` (`issue_id`),
  KEY `custom_issue_orders_journal_id` (`journal_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Ordering information for the issue list, when custom issue ordering is specified.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `custom_section_orders`
--

CREATE TABLE `custom_section_orders` (
  `custom_section_order_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `issue_id` bigint(20) NOT NULL,
  `section_id` bigint(20) NOT NULL,
  `seq` double(8,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`custom_section_order_id`),
  UNIQUE KEY `custom_section_orders_unique` (`issue_id`,`section_id`),
  KEY `custom_section_orders_issue_id` (`issue_id`),
  KEY `custom_section_orders_section_id` (`section_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Ordering information for sections within issues, when issue-specific section ordering is specified.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `data_object_tombstones`
--

CREATE TABLE `data_object_tombstones` (
  `tombstone_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `data_object_id` bigint(20) NOT NULL,
  `date_deleted` datetime NOT NULL,
  `set_spec` varchar(255) NOT NULL,
  `set_name` varchar(255) NOT NULL,
  `oai_identifier` varchar(255) NOT NULL,
  PRIMARY KEY (`tombstone_id`),
  KEY `data_object_tombstones_data_object_id` (`data_object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Entries for published data that has been removed. Usually used in the OAI endpoint.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `data_object_tombstone_oai_set_objects`
--

CREATE TABLE `data_object_tombstone_oai_set_objects` (
  `object_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `tombstone_id` bigint(20) NOT NULL,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  PRIMARY KEY (`object_id`),
  KEY `data_object_tombstone_oai_set_objects_tombstone_id` (`tombstone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Relationships between tombstones and other data that can be collected in OAI sets, e.g. sections.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `data_object_tombstone_settings`
--

CREATE TABLE `data_object_tombstone_settings` (
  `tombstone_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tombstone_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  PRIMARY KEY (`tombstone_setting_id`),
  UNIQUE KEY `data_object_tombstone_settings_unique` (`tombstone_id`,`locale`,`setting_name`),
  KEY `data_object_tombstone_settings_tombstone_id` (`tombstone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about data object tombstones, including localized content.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `dois`
--

CREATE TABLE `dois` (
  `doi_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `doi` varchar(255) NOT NULL,
  `status` smallint(6) NOT NULL DEFAULT '1',
  PRIMARY KEY (`doi_id`),
  KEY `dois_context_id` (`context_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores all DOIs used in the system.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `doi_settings`
--

CREATE TABLE `doi_settings` (
  `doi_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `doi_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`doi_setting_id`),
  UNIQUE KEY `doi_settings_unique` (`doi_id`,`locale`,`setting_name`),
  KEY `doi_settings_doi_id` (`doi_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about DOIs, including the registration agency.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `edit_decisions`
--

CREATE TABLE `edit_decisions` (
  `edit_decision_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `review_round_id` bigint(20) DEFAULT NULL,
  `stage_id` bigint(20) DEFAULT NULL,
  `round` smallint(6) DEFAULT NULL,
  `editor_id` bigint(20) NOT NULL,
  `decision` smallint(6) NOT NULL COMMENT 'A numeric constant indicating the decision that was taken. Possible values are listed in the Decision class.',
  `date_decided` datetime NOT NULL,
  PRIMARY KEY (`edit_decision_id`),
  KEY `edit_decisions_submission_id` (`submission_id`),
  KEY `edit_decisions_editor_id` (`editor_id`),
  KEY `edit_decisions_review_round_id` (`review_round_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Editorial decisions recorded on a submission, such as decisions to accept or decline the submission, as well as decisions to send for review, send to copyediting, request revisions, and more.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `email_log`
--

CREATE TABLE `email_log` (
  `log_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `sender_id` bigint(20) NOT NULL,
  `date_sent` datetime NOT NULL,
  `event_type` bigint(20) DEFAULT NULL,
  `from_address` varchar(255) DEFAULT NULL,
  `recipients` text,
  `cc_recipients` text,
  `bcc_recipients` text,
  `subject` varchar(255) DEFAULT NULL,
  `body` text,
  PRIMARY KEY (`log_id`),
  KEY `email_log_assoc` (`assoc_type`,`assoc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A record of email messages that are sent in relation to an associated entity, such as a submission.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `email_log_users`
--

CREATE TABLE `email_log_users` (
  `email_log_user_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `email_log_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  PRIMARY KEY (`email_log_user_id`),
  UNIQUE KEY `email_log_user_id` (`email_log_id`,`user_id`),
  KEY `email_log_users_email_log_id` (`email_log_id`),
  KEY `email_log_users_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A record of users associated with an email log entry.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `email_templates`
--

CREATE TABLE `email_templates` (
  `email_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `email_key` varchar(255) NOT NULL COMMENT 'Unique identifier for this email.',
  `context_id` bigint(20) NOT NULL,
  `alternate_to` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`email_id`),
  UNIQUE KEY `email_templates_email_key` (`email_key`,`context_id`),
  KEY `email_templates_context_id` (`context_id`),
  KEY `email_templates_alternate_to` (`alternate_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Custom email templates created by each context, and overrides of the default templates.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `email_templates_default_data`
--

CREATE TABLE `email_templates_default_data` (
  `email_templates_default_data_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `email_key` varchar(255) NOT NULL COMMENT 'Unique identifier for this email.',
  `locale` varchar(14) NOT NULL DEFAULT 'en',
  `name` varchar(255) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `body` text,
  PRIMARY KEY (`email_templates_default_data_id`),
  UNIQUE KEY `email_templates_default_data_unique` (`email_key`,`locale`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Default email templates created for every installed locale.' AUTO_INCREMENT=484 ;

--
-- Dumping data for table `email_templates_default_data`
--

INSERT INTO `email_templates_default_data` VALUES
(1, 'PASSWORD_RESET_CONFIRM', 'de', 'Bestätigung der Passwortzurücksetzung', 'Bestätigung der Passwortzurücksetzung', 'Wir wurden aufgefordert, Ihr Passwort für die Webseite {$siteTitle} neu zu setzen.<br />\n<br />\nFalls die Aufforderung nicht von Ihnen stammt, ignorieren Sie bitte diese E-Mail und Ihr Passwort bleibt unverändert. Falls Sie Ihr Passwort neu setzen möchten, klicken Sie bitte auf die folgende URL:<br />\n<br />\nMein Passwort neu setzen: {$passwordResetUrl}<br />\n<br />\n{$siteContactName}'),
(2, 'PASSWORD_RESET_CONFIRM', 'es', 'Confirmación de restablecimiento de contraseña', 'Confirmación de cambio de contraseña', 'Hemos recibido una petición para cambiar su contraseña en {$siteTitle}.<br />\n<br />\nSi no hizo usted esta petición ignore este correo-e y su contraseña no cambiará. Si desea cambiar su contraseña pinche en el enlace que le mostramos a continuación.<br />\n<br />\nCambiar mi contraseña: {$passwordResetUrl}<br />\n<br />\n{$siteContactName}'),
(3, 'PASSWORD_RESET_CONFIRM', 'fr_CA', 'Confirmation de la réinitialisation du mot de passe', 'Confirmation de la réinitialisation du mot de passe', 'Nous avons reçu une demande concernant la réinitialisation de votre mot de passe pour le site Web {$siteTitle}.<br />\n<br />\nSi vous n''avez pas fait cette demande, veuillez ne pas tenir compte du présent message, votre mot de passe restera le même. Si vous souhaitez réinitialiser votre mot de passe, cliquer sur l''URL ci-dessous.<br />\n<br />\nRéinitialisation de mon mot de passe : {$passwordResetUrl}<br />\n<br />\n{$siteContactName}'),
(4, 'PASSWORD_RESET_CONFIRM', 'it', '', 'Conferma di modifica della password', 'Abbiamo ricevuto una richiesta di modifica della password per {$siteTitle}.<br />\n<br />\nSe non ha inviato Lei la richiesta, ignori semplicemente questo messaggio e la password non sarà modificata. Se invece desidera generare una nuova password, clicchi sul link sottostante:<br />\n<br />\nReset della password: {$passwordResetUrl}<br />\n<br />\n{$siteContactName}'),
(5, 'PASSWORD_RESET_CONFIRM', 'nl', 'Bevestiging wachtwoord herstellen', 'Bevestiging wachtwoord herstellen', 'We hebben een verzoek van u ontvangen om uw wachtwoord voor de website {$siteTitle} te herstellen.<br />\n<br />\nAls u dat verzoek niet gedaan hebt, negeer dan deze e-mail en uw wachtwoord wordt niet veranderd. Als u uw wachtwoord wilt herstellen , klik dan op de url hieronder.<br />\n<br />\nHerstel mijn wachtwoord: {$passwordResetUrl}<br />\n<br />\n{$siteContactName}'),
(6, 'PASSWORD_RESET_CONFIRM', 'ru', 'Подтверждение сброса пароля', 'Подтверждение сброса пароля', 'Мы получили запрос на сброс Вашего пароля на сайте «{$siteTitle}».<br />\n<br />\nЕсли Вы не отправляли этот запрос, пожалуйста, проигнорируйте это письмо и Ваш пароль не будет изменен. Если Вы хотите сбросить свой пароль, то щелкните по ссылке ниже.<br />\n<br />\nСбросить мой пароль: {$passwordResetUrl}<br />\n<br />\n{$siteContactName}'),
(7, 'PASSWORD_RESET_CONFIRM', 'en', 'Password Reset Confirm', 'Password Reset Confirmation', 'We have received a request to reset your password for the {$siteTitle} web site.<br />\n<br />\nIf you did not make this request, please ignore this email and your password will not be changed. If you wish to reset your password, click on the below URL.<br />\n<br />\nReset my password: {$passwordResetUrl}<br />\n<br />\n{$siteContactName}'),
(8, 'USER_REGISTER', 'de', 'Benutzer/in angelegt', 'Registrierung bei der Zeitschrift', '{$recipientName}<br />\n<br />\nSie sind nun als neue/r Benutzer/in von {$journalName} registriert. Wir haben Ihren Benutzer/innennamen und Ihr Passwort in dieser Mail aufgeführt, beides wird für alle Arbeiten mit dieser Zeitschrift gebraucht. Sie können sich zu jedem Zeitpunkt als Benutzer/in der Zeitschrift austragen lassen, indem Sie mich kontaktieren.<br />\n<br />\nBenutzer/innenname: {$recipientUsername}<br />\nPasswort: {$password}<br />\n<br />\nVielen Dank <br />\n{$signature}'),
(9, 'USER_REGISTER', 'es', 'Usuario/a creado', 'Nuevo registro de usuaria/o', '{$recipientName}<br />\n<br />\nSe ha registrado con éxito como usuario/a en {$journalName}. En este correo se incluyen su nombre de usuario/a y contraseña, datos necesarios para realizar cualquier tarea relacionada con la revista a través de la página web. En cualquier momento puede solicitar que se le elimine de la lista de usuarios/as de la revista contactándome.<br />\n<br />\nNombre de usuario/a: {$recipientUsername}<br />\nContraseña: {$password}<br />\n<br />\nGracias,<br />\n{$signature}'),
(10, 'USER_REGISTER', 'fr_CA', 'Création de l''utilisateur-trice', 'Inscription à la revue', '{$recipientName},<br />\n<br />\nVous êtes désormais inscrit-e en tant qu''utilisateur-trice pour la revue {$journalName}. Votre nom d''utilisateur-trice et votre mot de passe figurent dans ce courriel, lesquels sont requis pour toute interaction avec la revue via son site Web. À n''importe quel moment, vous pouvez demander à être retiré-e de la liste des utilisateurs-trices de la revue en nous contactant.<br />\n<br />\nNom d''utilisateur-trice : {$recipientUsername}<br />\nMot de passe : {$password}<br />\n<br />\nMerci,<br />\n{$signature}'),
(11, 'USER_REGISTER', 'it', '', 'Registrazione nuovo utente', 'Gentile {$recipientName}<br />\n<br />\nGrazie per aver effettuato la registrazione a {$journalName}. Riportiamo qui di seguito le Sue credenziali, necessarie per l''accesso all''area riservata del sito web della rivista. Potrà richiedere in qualsiasi momento di essere rimosso dall''elenco degli utenti della rivista contattandoci via e-mail.<br />\n<br />\nNome utente: {$recipientUsername}<br />\nPassword: {$password}<br />\n<br />\nGrazie,<br />\n{$signature}'),
(12, 'USER_REGISTER', 'nl', 'Tijdschriftregistratie', 'Tijdschriftregistratie', '{$recipientName}<br />\n<br />\nU bent nu geregistreerd als gebruiker bij {$journalName}. We hebben uw gebruikersnaam en wachtwoord in deze e-mail opgenomen. U heeft die nodig om met het tijdschrift te werken. U kunt op ieder gewenst moment verwijderd worden van de lijst gebruikers van dit tijdschrift door contact met mij op te nemen<br />\n<br />\nGebruikersnaam: {$recipientUsername}<br />\nWachtwoord: {$password}<br />\n<br />\nDank u,<br />\n{$signature}'),
(13, 'USER_REGISTER', 'ru', 'Пользователь создан', 'Регистрация в журнале', 'Здравствуйте, {$recipientName}!<br />\n<br />\nТеперь Вы зарегистрированы как пользователь в журнале «{$journalName}». В этом письме мы указали Ваши имя пользователя и пароль, которые потребуются для работы с этим журналом через сайт. Вы в любой момент можете попросить, чтобы Вас удалили из списка пользователей журнала, для этого просто свяжитесь со мной.<br />\n<br />\nИмя пользователя: {$recipientUsername}<br />\nПароль: {$password}<br />\n<br />\nС уважением,<br />\n{$signature}'),
(14, 'USER_REGISTER', 'en', 'User Created', 'Journal Registration', '{$recipientName}<br />\n<br />\nYou have now been registered as a user with {$journalName}. We have included your username and password in this email, which are needed for all work with this journal through its website. At any point, you can ask to be removed from the journal''s list of users by contacting me.<br />\n<br />\nUsername: {$recipientUsername}<br />\nPassword: {$password}<br />\n<br />\nThank you,<br />\n{$signature}'),
(15, 'USER_VALIDATE_CONTEXT', 'de', 'E-Mail überprüfen (Zeitschrift Registrierung)', 'Account validieren', '{$recipientName}<br />\n<br />\nSie haben ein Benutzer/innenkonto bei {$journalName} angelegt, aber bevor Sie es benutzen können, müssen Sie Ihre E-Mail-Adresse bestätigen. Dazu folgen Sie bitte einfach dem folgenden Link:<br />\n<br />\n{$activateUrl}<br />\n<br />\nVielen Dank<br />\n{$journalSignature}'),
(16, 'USER_VALIDATE_CONTEXT', 'es', 'Validar correo electrónico (registro en la revista)', 'Valide su cuenta', 'Estimado/a {$recipientName}<br />\n<br />\nHa creado una cuenta de usuario/a en {$journalName}, pero antes de poder utilizarla debe validar su correo electrónico. Para ello, simplemente haga clic en el siguiente enlace:<br />\n<br />\n{$activateUrl}<br />\n<br />\nGracias,<br />\n{$journalSignature}'),
(17, 'USER_VALIDATE_CONTEXT', 'fr_CA', 'Validez l''adresse courriel (enregistrement de la revue)', 'Valider votre compte', '{$recipientName},<br />\n<br />\nVous avez créé un compte pour la revue {$journalName}. Pour pouvoir commencer à l''utiliser il nous faut d''abord valider votre adresse de courriel. Pour ce faire, vous n''avez qu''à suivre le lien ci-dessous :<br />\n<br />\n{$activateUrl}<br />\n<br />\nMerci,<br />\n{$journalSignature}'),
(18, 'USER_VALIDATE_CONTEXT', 'it', 'Confermare e-mail (registrazione di una rivista)', 'Convalida dell''account', 'Gentile {$recipientName}<br />\n<br />\nÈ stato creato un account per {$journalName}, ma prima di poter interagire sul sito web, è necessario validare il Suo indirizzo e-mail. Per fare ciò, clicchi semplicemente sul link sottostante:<br />\n<br />\n{$activateUrl}<br />\n<br />\nGrazie,<br />\n{$journalSignature}'),
(19, 'USER_VALIDATE_CONTEXT', 'nl', 'Valideer Email (tijdschriftregistratie)', 'Valideer uw account', '{$recipientName}<br />\n<br />\nU hebt een account aangemaakt bij {$journalName}. Voordat u dat kunt gebruiken moet u uw account valideren. U doet dat door de link hieronder te volgen:<br />\n<br />\n{$activateUrl}<br />\n<br />\nDank u,<br />\n{$journalSignature}'),
(20, 'USER_VALIDATE_CONTEXT', 'ru', 'Проверка адреса почты (регистрация в журнале)', 'Подтвердите свою учетную запись', 'Здравствуйте, {$recipientName}!<br />\n<br />\nВы создали учетную запись в журнале «{$journalName}», но перед тем как начать ее использовать, Вам нужно подтвердить свой адрес электронной почты. Чтобы сделать это, просто пройдите по ссылке ниже:<br />\n<br />\n{$activateUrl}<br />\n<br />\nС уважением,<br />\n{$journalSignature}'),
(21, 'USER_VALIDATE_CONTEXT', 'en', 'Validate Email (Journal Registration)', 'Validate Your Account', '{$recipientName}<br />\n<br />\nYou have created an account with {$journalName}, but before you can start using it, you need to validate your email account. To do this, simply follow the link below:<br />\n<br />\n{$activateUrl}<br />\n<br />\nThank you,<br />\n{$journalSignature}'),
(22, 'USER_VALIDATE_SITE', 'de', 'E-Mail überprüfen (Seite)', 'Account validieren', '{$recipientName}<br />\n<br />\nSie haben ein Benutzer/innenkonto bei {$siteTitle} angelegt, aber bevor Sie es benutzen können, müssen Sie Ihre E-Mail-Adresse bestätigen. Dazu folgen Sie bitte einfach dem folgenden Link:<br />\n<br />\n{$activateUrl}<br />\n<br />\nVielen Dank<br />\n{$siteSignature}'),
(23, 'USER_VALIDATE_SITE', 'es', 'Validar correo electrónico (Sitio)', 'Valide su cuenta', '{$recipientName}<br />\n<br />\nHa creado una cuenta en {$siteTitle}, pero antes de poder utilizarla, debe validar su email. Para hacerlo, simplemente haga clic en el siguiente enlace:<br />\n<br />\n{$activateUrl}<br />\n<br />\nGracias,<br />\n{$siteSignature}'),
(24, 'USER_VALIDATE_SITE', 'fr_CA', 'Valider le courriel (site)', 'Valider votre compte', '{$recipientName},<br />\n<br />\nVous avez créé un compte dans {$siteTitle}. Avant de pouvoir commencer à l''utiliser, il nous faut d''abord valider votre adresse de courriel. Pour ce faire, vous n''avez qu''à suivre le lien ci-dessous :<br />\n<br />\n{$activateUrl}<br />\n<br />\nMerci,<br />\n{$siteSignature}'),
(25, 'USER_VALIDATE_SITE', 'it', 'Convalidare l''e-mail (sito)', 'Conferma dell''account', 'Gentile {$recipientName}<br />\n<br />\nÈ necessario confermare l''indirizzo email associato al Suo nuovo account per la rivista {$siteTitle} cliccando sul link sottostante:<br />\n<br />\n{$activateUrl}<br />\n<br />\nGrazie e cordiali saluti,<br />\n{$siteSignature}'),
(26, 'USER_VALIDATE_SITE', 'nl', 'Valideer E-mail (Website)', 'Valideer uw account', '<p>Beste {$recipientName},</p>U heeft een account aangemaakt bij {$siteTitle}, maar voordat u het kunt gaan gebruiken, moet u uw e-mailadres valideren. Volg hiervoor de onderstaande link:<p>{$activateUrl},</p><p>Bedankt,</p>{$siteSignature}'),
(27, 'USER_VALIDATE_SITE', 'ru', 'Проверка адреса почты (сайт)', 'Подтвердите свою учетную запись', 'Здравствуйте, {$recipientName}!<br />\n<br />\nВы создали учетную запись на сайте «{$siteTitle}», но перед тем как начать её использовать, Вам нужно подтвердить адрес электронной почты. Чтобы сделать это, просто пройдите по ссылке ниже:<br />\n<br />\n{$activateUrl}<br />\n<br />\nС уважением,<br />\n{$siteSignature}'),
(28, 'USER_VALIDATE_SITE', 'en', 'Validate Email (Site)', 'Validate Your Account', '{$recipientName}<br />\n<br />\nYou have created an account with {$siteTitle}, but before you can start using it, you need to validate your email account. To do this, simply follow the link below:<br />\n<br />\n{$activateUrl}<br />\n<br />\nThank you,<br />\n{$siteSignature}'),
(29, 'REVIEWER_REGISTER', 'de', 'Gutachter/in registriert', 'Registrierung als Benutzer/in bei {$journalName}', '<p>Guten Tag {$recipientName}, </p><p>angesichts Ihrer Expertise haben wir uns erlaubt, Ihren Namen der Gutachter/innendatenbank von {$journalName} hinzuzufügen. Dies verpflichtet Sie zu nichts, ermöglicht uns aber, Sie um mögliche Gutachten für eine Einreichung zu bitten. Wenn Sie zu einem Gutachten eingeladen werden, werden Sie Titel und Abstract des Beitrags sehen können und werden stets selber entscheiden können, ob Sie der Einladung folgen oder nicht. Sie können zu jedem Zeitpunkt Ihren Namen von der Gutachter/innenliste entfernen lassen.</p><p>Wir senden Ihnen einen Benutzer/innennamen und ein Passwort, die Sie in allen Schritten der Zusammenarbeit mit der Zeitschrift über deren Website benötigen. Vielleicht möchten Sie z.B. Ihr Profil inkl. Ihrer Begutachtungsinteressen aktualisieren.</p><p>Benutzer/innenname: {$recipientUsername}<br />Passwort: {$password}</p><p>Vielen Dank</p>{$signature}'),
(30, 'REVIEWER_REGISTER', 'es', 'Registro de revisor/a', 'Registro como Revisor en {$journalName}', '<p>Estimado/a {$recipientName},</p><p>En vista de su experiencia, hemos registrado su nombre en la base de datos de revisores/as de {$journalName}. Esto no implica ningún compromiso por su parte, simplemente nos permite contactarle para una posible revisión de un trabajo. Cuando reciba una invitación para revisar podrá ver el título y el resumen del artículo en cuestión, y siempre tendrá la posibilidad de aceptar o rechazar la invitación. También puede pedirnos en cualquier momento que lo eliminemos de la lista de revisores/as.</p><p>Le enviamos el nombre de usuario/a y la contraseña, que le servirán para realizar cualquier tarea de la revista a través de su página web. Por ejemplo, puede actualizar su perfil e incluir sus intereses de revisión.</p><p>Nombre de usuario/a: {$recipientUsername}<br />Contraseña: {$password}</p><p>Gracias,</p>{$signature}'),
(31, 'REVIEWER_REGISTER', 'fr_CA', 'Inscription d''une évaluateur-trice', 'Inscription en tant qu''évaluateur-trice pour la revue {$journalName}', '<p>Bonjour {$recipientName},</p><p>Compte tenu de votre expertise, nous avons pris l''initiative d''inscrire votre nom dans la base de données des évaluateurs-trices de la revue {$journalName}. Cela ne vous engage d''aucune façon, mais nous permet simplement de solliciter vos services pour l''évaluation d''une soumission. Si vous êtes invité-e à effectuer une évaluation, vous recevrez le titre et le résumé de l''article en question, et serez toujours libre d''accepter ou de refuser une telle invitation. À tout moment, il vous est également possible de demander à ce que votre nom soit retiré de la liste des évaluateurs-trices.</p>\n<p>Nous vous acheminons un nom d''utilisateur-trice et un mot de passe, car tous deux sont requis pour tout échange avec la revue via son site Web. Vous pouvez, par exemple, si vous le souhaitez, effectuer la mise à jour de votre profil, y compris vos domaines d''intérêt en matière d''évaluation.</p>\n<p>Nom d''utilisateur-trice : {$recipientUsername}<br />\nMot de passe : {$password}</p>\n<p>Merci,</p>{$signature}'),
(32, 'REVIEWER_REGISTER', 'it', '', 'Registrazione come revisore per {$journalName}', '<p>Gentile {$recipientName},</p><p>Considerati i Suoi ambiti di competenza, vorremmo cortesemente registrare il Suo nominativo nell''elenco dei valutatori per {$journalName}. Ciò non implica nessun tipo di impegno da parte Sua, ma semplicemente ci consentirà di contattarLa, tramite il nostro sito web, per sottoporLe richieste di valutazione di proposte editoriali. In caso di richieste di valutazione, riceverà in primo luogo il titolo e il riassunto dei contributi e potrà, contestualmente, accettare o declinare l''invito alla revisione.</p><p>Troverà dunque qui di seguito il Suo nome utente e la Sua password, utili per tutte le interazioni con la rivista attraverso il sito web. Qualora fosse disponibile, le saremmo grati se volesse verificare le informazioni inserite e completare il profilo, compilando i campi suggeriti, tra cui anche le Sue aree tematiche di interesse.</p><p>Nome utente: {$recipientUsername}<br />Password: {$password}</p><p>Grazie,</p>{$signature}'),
(33, 'REVIEWER_REGISTER', 'nl', 'Registratie als Reviewer', 'Registratie als Reviewer bij {$journalName}', 'Met het oog op uw expertise hebben wij de vrijheid genomen om uw naam op te nemen in de lijst met reviewers van {$journalName}. Dit verplicht u tot niets maar geeft ons de mogelijkheid u te benaderen met het verzoek eventueel een inzending te reviewen. Bij de uitnodiging krijgt u de gelegenheid de titel en samenvatting van het stuk in kwestie te bekijken. U kunt de uitnodiging te allen tijde accepteren of weigeren. U kunt ook altijd vragen om uw naam van deze lijst te laten verwijderen.<br />\n<br />\nWe geven u een gebruikersnaam en wachtwoord, die gebruikt worden voor alle interacties met de website van het tijdschrift. Zo kunt u bijvoorbeeld uw profiel bijwerken, waaronder uw review-interesses.<br />\n<br />\nGebruikersnaam: {$recipientUsername}<br />\nWachtwoord: {$password}<br />\n<br />\nDank u,<br />\n{$signature}'),
(34, 'REVIEWER_REGISTER', 'ru', 'Регистрация рецензента', 'Регистрация в качестве рецензента в журнале «{$journalName}»', '<p>Здравствуйте, {$recipientName}!</p><p>Принимая во внимание Ваш опыт, мы взяли на себя смелость зарегистрировать Вас в базе данных потенциальных рецензентов для журнала «{$journalName}». Это не налагает на Вас никаких обязательств, а просто позволяет нам обращаться к Вам при поступлении в наш журнал материалов, рецензентом которых Вы могли бы стать. Получив предложение дать рецензию, Вы сможете увидеть название и аннотацию рукописи в запросе, и у Вас всегда будет возможность принять или отклонить это предложение. Вы также в любой момент можете попросить, чтобы мы удалили Ваше имя из этого списка рецензентов.</p><p>Мы высылаем Вам имя пользователя и пароль, которые используются при любом взаимодействии с нашим журналом через веб-сайт. Например, Вы можете откорректировать свои данные в профиле пользователя, указав интересующую Вас как рецензента тематику.</p><p>Имя пользователя: {$recipientUsername}<br /> Пароль: {$password}</p><p>С уважением,</p>{$signature}'),
(35, 'REVIEWER_REGISTER', 'en', 'Reviewer Register', 'Registration as Reviewer with {$journalName}', '<p>Dear {$recipientName},</p><p>In light of your expertise, we have registered your name in the reviewer database for {$journalName}. This does not entail any form of commitment on your part, but simply enables us to approach you with a submission to possibly review. On being invited to review, you will have an opportunity to see the title and abstract of the paper in question, and you''ll always be in a position to accept or decline the invitation. You can also ask at any point to have your name removed from this reviewer list.</p><p>We are providing you with a username and password, which is used in all interactions with the journal through its website. You may wish, for example, to update your profile, including your reviewing interests.</p><p>Username: {$recipientUsername}<br />Password: {$password}</p><p>Thank you,</p>{$signature}'),
(36, 'ISSUE_PUBLISH_NOTIFY', 'de', 'Ausgabe veröffentlicht Benachrichtigung', 'Gerade veröffentlicht: {$issueIdentification} von {$journalName}', '<p>Guten Tag {$recipientName},</p><p> wir freuen uns Ihnen mitteilen zu können, dass eine neue Ausgabe von {$journalName} veröffentlicht wurde: <a href="{$issueUrl}">{$issueIdentification}</a>. Wir laden Sie dazu ein, die Ausgabe zu lesen und mit Anderen Ihrer wissenschaftlichen Community zu teilen.</p><p>Vielen Dank an unsere Autor/innen, Gutachter/innen und Redakteur/innen für ihre wertvollen Beiträge - und natürlich an unsere Leser/innen für das anhaltende Interesse an unserer Arbeit.</p><p>Vielen Dank</p>{$signature}'),
(37, 'ISSUE_PUBLISH_NOTIFY', 'es', 'Notificación de número publicado', 'Nuevo número publicado: {$issueIdentification} en {$journalName}', '<p>Estimado/a {$recipientName},</p><p>Nos complace anunciar la publicación de <a href="{$issueUrl}">{$issueIdentification}</a> de {$journalName}. Le invitamos a leer y compartir este trabajo con su comunidad académica.</p><p>Agradecemos a nuestros autores/as, revisores/as y editores/as sus valiosas contribuciones, y a nuestros lectores/as su interés.</p><p>Gracias,</p>{$signature}'),
(38, 'ISSUE_PUBLISH_NOTIFY', 'fr_CA', 'Notification de numéro paru', 'Parution du dernier numéro : {$issueIdentification} de la revue {$journalName}', '<p>Chers-ères lecteurs-trices,</p><p>La revue {$journalName} a le plaisir de vous annoncer la publication de son dernier numéro :  <a href="{$issueUrl}">{$issueIdentification}</a>. Nous vous invitons à consulter le sommaire, puis à visiter notre site Web pour y lire les articles qui vous intéressent. Nous remercions vivement nos auteurs-trices, réviseurs-es et rédacteurs-trices pour leurs précieuses contributions à cet ouvrage, ainsi que nos lecteurs-trices pour leur intérêt constant.</p><p>Cordialement,</p>{$signature}'),
(39, 'ISSUE_PUBLISH_NOTIFY', 'it', 'Notifica di numero pubblicato', 'Nuova pubblicazione: {$issueIdentification} per {$journalName}', '<p>Gentile {$recipientName},</p><p>Siamo lieti di comunicarLe che è stato pubblicato il nuovo <a href="{$issueUrl}">{$issueIdentification}</a> di {$journalName}.  La invitiamo gentilmente a consultare la pubblicazione e a condividerla con la Sua comunità di riferimento.</p><p>Siamo particolarmente grati agli autori, ai valutatori e ai curatori per i loro preziosi contributi, e ai nostri lettori per l''interesse nei confronti della nostra rivista.</p><p>Con i più cordiali saluti,</p>{$signature}'),
(40, 'ISSUE_PUBLISH_NOTIFY', 'nl', 'Nummer gepubliceerd notificatie', 'Nieuw nummer gepubliceerd: {$issueIdentification} van {$journalName}', 'Lezers:<br />\n<br />\n{$journalName} heeft zijn nieuwste nummer gepubliceerd op {$journalUrl}. We nodigen u uit om de inhoudsopgave te bekijken en de website te bezoeken voor het bekijken van de artikelen en andere interessante items.<br />\n<br />\nDank voor uw interesse in ons werk,<br />\n{$signature}'),
(41, 'ISSUE_PUBLISH_NOTIFY', 'ru', 'Уведомление о публикации выпуска', 'Только что опубликован: {$issueIdentification} журнала «{$journalName}»', '<p>Здравствуйте, {$recipientName}!</p><p>Журнал «{$journalName}» рад сообщить, что только что был опубликован наш последний выпуск <a href="{$issueUrl}">{$issueIdentification}</a>. Мы приглашаем вас ознакомиться с материалами выпуска и поделиться этой работой с вашим научным сообществом.</p><p>Благодарим наших авторов, рецензентов и редакторов за их неоценимый вклад, а наших читателей — за постоянный интерес к нашей работе.</p><p>С уважением,</p>{$signature}'),
(42, 'ISSUE_PUBLISH_NOTIFY', 'en', 'Issue Published Notify', 'Just published: {$issueIdentification} of {$journalName}', '<p>Dear {$recipientName},</p><p>We are pleased to announce the publication of <a href="{$issueUrl}">{$issueIdentification}</a> of {$journalName}.  We invite you to read and share this work with your scholarly community.</p><p>Many thanks to our authors, reviewers, and editors for their valuable contributions, and to our readers for your continued interest.</p><p>Thank you,</p>{$signature}'),
(43, 'SUBMISSION_ACK', 'de', 'Bestätigung der Einreichung', 'Ihre Einreichung für {$journalName}: Eingangsbestätigung', '<p>Sehr geehrte/r {$recipientName},</p><p>vielen Dank für die Einreichung Ihres Manuskripts &quot;{$submissionTitle}&quot; zur Veröffentlichung in {$journalName}. Ein Mitglied unseres Redaktionsteams wird sie sich bald ansehen. Sie erhalten eine E-Mail, wenn eine erste Entscheidung getroffen wurde, und wir können Sie auch für weitere Informationen kontaktieren.</p><p>Das Verwaltungssystem unserer Webzeitschrift erlaubt Ihnen, jederzeit den Lauf Ihres Beitrags im Redaktionsprozess zu beobachten. Sie loggen sich dazu einfach auf unserer Webseite ein:</p><p>URL des Manuskripts: {$submissionUrl}</p><p>Benutzer/innenname: {$recipientUsername}</p><p>Wenn Sie Fragen haben, kontaktieren Sie mich bitte über das <a href="{$authorSubmissionUrl}">Dashboard Ihrer Einreichung</a>.</p><p>Danke für Ihr Interesse an einer Veröffentlichung in unserer Zeitschrift {$journalName} .</p>{$journalSignature}'),
(44, 'SUBMISSION_ACK', 'es', 'Confirmación de envío', 'Gracias por su envío a {$journalName}', '<p>Estimado/a {$recipientName}:</p><p>Gracias por su envío a {$journalName}. Hemos recibido su original, {$submissionTitle}, y un miembro de nuestro equipo editorial lo revisará pronto. Le enviaremos un correo electrónico cuando se tome una decisión inicial, y podríamos contactarlo para darle más información.</p></p> Puede ver el envío y seguir su progreso a través del proceso editorial en el enlace siguiente:</p><p>URL del envío: {$authorSubmissionUrl}</p><p>Si se ha cerrado la sesión, puede volver a iniciarla con su nombre de usuario/a {$recipientUsername}.</p><p>Si tiene cualquier duda contacte con nosotros desde el <a href="{$authorSubmissionUrl}">panel de control del envío</a>.</p><p>Gracias por tener en cuenta {$journalName} como hogar para su trabajo.</p>{$journalSignature}'),
(45, 'SUBMISSION_ACK', 'fr_CA', 'Confirmation de soumission', 'Accusé de réception de la soumission à {$journalName}', '<p>{$recipientName},</p><p>Nous vous remercions d''avoir soumis le manuscrit intitulé « {$submissionTitle} » à la revue {$journalName}. Nous l''avons bien reçu et un membre de notre équipe éditorial le prendre en charge sous peu. Grâce à notre système de gestion en ligne, vous pourrez suivre votre soumission tout au long du processus d''édition en accédant au site Web de la revue :</p>\n<br />\nURL de la soumission : {$submissionUrl}<br />\nNom d''utilisateur-trice : {$recipientUsername}<br />\n<br />\nSi vous avez des questions, n''hésitez pas à communiquer avec nous. Nous vous remercions d''avoir pensé à notre revue pour la publication de vos travaux.<br />\n<br />\n{$journalSignature}'),
(46, 'SUBMISSION_ACK', 'it', '', 'Grazie per avere inviato il suo contributo a {$journalName}', 'Gentile {$recipientName},<br />\n<br />\nGrazie per aver inviato il suo contributo &quot;{$submissionTitle}&quot; alla testata  {$journalName}. Potrà il processo di revisione del suo manoscritto attraverso portale utilizzando la sua login al sito:<br />\n<br />\nURL della proposta: {$submissionUrl}<br />\nUsername: {$recipientUsername}<br />\n<br />\nPer qualsiasi domanda non esiti a contattarmi.<br />\nLa ringrazio per la preferenza espressa nei confronti di {$journalName}.<br />\n<br />\n{$journalSignature}'),
(47, 'SUBMISSION_ACK', 'nl', 'Bevestiging Inzending', 'Bedankt voor uw inzending aan {$journalName}', '<p>Beste {$recipientName},</p><p>Bedankt voor je inzending bij {$journalName}. We hebben je inzending, {$submissionTitle}, ontvangen en een lid van ons redactieteam zal het binnenkort bekijken. Je ontvangt een e-mail wanneer er een eerste beslissing is genomen, en we kunnen contact met je opnemen voor verdere informatie.</p><p>Je kunt je inzending bekijken en de voortgang ervan door de redactionele processen volgen op de volgende locatie:</p><p>Inzendings-URL: {$authorSubmissionUrl}</p><p>Als je bent uitgelogd, kun je opnieuw inloggen met de gebruikersnaam {$recipientUsername}.</p><p>Als je vragen hebt, neem dan contact met me op via je <a href="{$authorSubmissionUrl}">inzendingsdashboard</a>.</p><p>Bedankt voor het overwegen van {$journalName} als platform voor je werk.</p>{$journalSignature}'),
(48, 'SUBMISSION_ACK', 'ru', 'Подтверждение отправки', 'Благодарим за Ваш материал в журнал «{$journalName}»', '<p>Здравствуйте, {$recipientName}!</p><p>Благодарим Вас за отправку материала в «{$journalName}». Мы получили Ваш материал «{$submissionTitle}» и вскоре один из членов нашей редакции займётся его изучением. Вы получите письмо, когда первоначальное решение по материалу будет принято, мы также можем связаться с Вами для получения дополнительной информации.</p><p>Вы можете видеть свой материал и отслеживать его прохождение через редакционный процесс по следующей ссылке:</p><p>URL материала: {$authorSubmissionUrl}</p><p>Если Вы вышли из системы, Вы можете снова войти в нее с именем пользователя {$recipientUsername}.</p><p>Если у Вас возникнут какие-то вопросы, пожалуйста, свяжитесь со мной через <a href="{$authorSubmissionUrl}">страницу Вашего материала</a>.</p><p>Спасибо за выбор нашего журнала «{$journalName}» для публикации Вашей работы.</p>{$journalSignature}'),
(49, 'SUBMISSION_ACK', 'en', 'Submission Confirmation', 'Thank you for your submission to {$journalName}', '<p>Dear {$recipientName},</p><p>Thank you for your submission to {$journalName}. We have received your submission, {$submissionTitle}, and a member of our editorial team will see it soon. You will be sent an email when an initial decision is made, and we may contact you for further information.</p><p>You can view your submission and track its progress through the editorial process at the following location:</p><p>Submission URL: {$authorSubmissionUrl}</p><p>If you have been logged out, you can login again with the username {$recipientUsername}.</p><p>If you have any questions, please contact me from your <a href="{$authorSubmissionUrl}">submission dashboard</a>.</p><p>Thank you for considering {$journalName} as a venue for your work.</p>{$journalSignature}'),
(50, 'SUBMISSION_ACK_NOT_USER', 'de', 'Bestätigung der Einreichung (andere Autor/innen)', 'Eingangsbestätigung', '<p>Sehr geehrte/r {$recipientName},</p><p>Sie wurden als Mitautor/in bei einer Einreichung bei {$KontextName} genannt. Der Verfasser/die Verfasserin, {$Einreichername}, hat die folgenden Angaben gemacht:</p><p>{$submissionTitle}<br>{$authorsWithAffiliation}</p><p>Wenn eine dieser Angaben nicht korrekt ist oder Sie nicht in diesem Beitrag genannt werden möchten, setzen Sie sich bitte mit mir in Verbindung.</p><p>Vielen Dank, dass Sie {$journalName} als Plattform für Ihre Arbeit in Betracht ziehen.</p><p>Mit freundlichen Grüßen,</p>{$journalSignature}'),
(51, 'SUBMISSION_ACK_NOT_USER', 'es', 'Confirmación del envío (otros autores/as)', 'Acuse de recibo del envío', 'Hola,<br />\n<br />\n{$submitterName} ha enviado el manuscrito &quot;{$submissionTitle}&quot; a {$journalName}. <br />\n<br />\nSi tiene cualquier pregunta no dude en contactarme. Le agradecemos que haya elegido esta revista para dar a conocer su obra.<br />\n<br />\n{$journalSignature}'),
(52, 'SUBMISSION_ACK_NOT_USER', 'fr_CA', 'Confirmation de soumission (autres auteur-es)', 'Accusé de réception de la soumission', '<p>Bonjour,</p><p>Le manuscrit intitulé , « {$submissionTitle} » , a été soumis par {$submitterName} à la revue {$journalName}.</p><p>Si vous avez des questions, n''hésitez pas à communiquer avec nous. Nous vous remercions d''avoir pensé à la revue {$journalName} pour la publication de vos travaux.</p><p>Cordialement,</p>{$journalSignature}'),
(53, 'SUBMISSION_ACK_NOT_USER', 'it', '', 'Conferma di ricezione della proposta', '<p>Gentilissimo {$recipientName}</p>\n<p>{$submitterName} ha aggiunto il suo nominativo in qualità di co-author del manoscritto "{$submissionTitle}" inviato per la pubblicazione alla rivista {$journalName}. </p>\n<p>questi sono i dettagli forniti: {$authorsWithAffiliation}</p>\n<p>Se non fossero corretti la prego di contattarci. Siamo a disposizione per qualsiasi chiarimento e la ringraziamo per la sua collaborazione.</p>\n<p>{$journalSignature}</p>'),
(54, 'SUBMISSION_ACK_NOT_USER', 'nl', 'Bevestiging Inzending (Overige Auteurs)', 'Bevestiging van inzending', '<p>Beste {$recipientName},</p><p>Je bent genoemd als medeauteur bij een inzending voor {$journalName}. De indiener, {$submitterName}, heeft de volgende details verstrekt:</p><p>{$submissionTitle}<br>{$authorsWithAffiliation}</p><p>Als een van deze details onjuist is, of als je niet genoemd wilt worden bij deze inzending, neem dan contact met me op.</p><p>Bedankt voor je overweging van {$journalName} als platform voor je werk.</p><p>Met vriendelijke groet,</p>{$journalSignature}'),
(55, 'SUBMISSION_ACK_NOT_USER', 'ru', 'Подтверждение отправки (другие авторы)', 'Подтверждение отправки', '<p>Здравствуйте, {$recipientName}!</p><p>Вы были указаны в качестве соавтора материала, направленного в журнал «{$journalName}». Отправитель, {$submitterName}, указал следующую информацию:</p><p>{$submissionTitle}<br>{$authorsWithAffiliation}</p><p>Если что-то в этой информации неправильно или Вы не хотите, чтобы Вас указывали в этом материале, пожалуйста, свяжитесь со мной.</p><p>Спасибо за выбор журнала «{$journalName}» для публикации Вашей работы.</p><p>С уважением,</p>{$journalSignature}'),
(56, 'SUBMISSION_ACK_NOT_USER', 'en', 'Submission Confirmation (Other Authors)', 'Submission confirmation', '<p>Dear {$recipientName},</p><p>You have been named as a co-author on a submission to {$journalName}. The submitter, {$submitterName}, provided the following details:</p><p>{$submissionTitle}<br>{$authorsWithAffiliation}</p><p>If any of these details are incorrect, or you do not wish to be named on this submission, please contact me.</p><p>Thank you for considering {$journalName} as a venue for your work.</p><p>Kind regards,</p>{$journalSignature}'),
(57, 'EDITOR_ASSIGN', 'de', 'Redakteur/in zugewiesen', 'Sie wurden als Redakteur/in von einer Einreichung bei {$journalName} zugewiesen', '<p>Sehr geehrte/r {$recipientName},</p><p>Die folgende Einreichung wurde Ihnen zur redaktionellen Bearbeitung zugewiesen. </p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Wenn Sie der Meinung sind, dass die Einreichung für die Zeitschrift {$journalName} relevant ist, leiten Sie die Einreichung bitte zur Begutachtung weiter, indem Sie "In die Begutachtung schicken" wählen und dann Gutachter zuweisen, indem Sie auf "Gutachter/in hinzufügen" klicken. </p><p>Wenn die Einreichung nicht für diese Zeitschrift geeignet ist, lehnen Sie die Einreichung bitte ab.</p><p>Danke im Voraus.</p><p>Mit freundlichen Grüßen,</p>{$journalSignature}'),
(58, 'EDITOR_ASSIGN', 'es', 'Editor/a asignado', 'Ha sido asignado como editor/a de un envío para {$journalName}', '<p>Estimado/a {$recipientName},</p><p>Se le ha asignado el siguiente envío para que coordine su proceso editorial.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Resumen</b></p>{$submissionAbstract}<p>Si le parece que el envío es relevante para {$journalName}, envíelo a la fase de revisión seleccionando "Enviar a revisión" y luego asigne revisores/as haciendo clic en "Añadir revisor/a".</p><p>Si el envío no es apropiado para esta revista, rechácelo.</p><p>Gracias de antemano.</p><p>Atentamente,</p>{$journalSignature}'),
(59, 'EDITOR_ASSIGN', 'fr_CA', 'Rédacteur-trice assigné', 'Vous avez été assigné.e en tant que rédacteur.trice d''une soumission de la revue {$journalName}', '<p>{$recipientName},</p><p>La soumission suivante vous a été assignée pour le suivi du processus éditorial.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Résumé</b></p>{$submissionAbstract}</p><p>Si vous jugez la soumission pertinente pour la revue {$journalName}, veuillez la transmettre à l''étape d''évaluation en sélectionnant "Envoyer en évaluation" et en désignant des évaluateur.trice.s en cliquant sur « Ajouter un.e évaluateur.trice ».</p><p>Si la soumission n''est pas appropriée pour cette revue, veuillez la décliner.</p><p>Je vous remercie d''avance.</p><p>Cordialement,</p>{$journalSignature}'),
(60, 'EDITOR_ASSIGN', 'it', '', 'Assegnazione di una proposta editoriale {$journalName}', '<p>Gentile {$recipientName},</p><p>La seguente proposta Le è stata assegnata per il processo editoriale:</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>ualora dovesse ritenere a proposta sia rilevante per {$journalName}, potrà inoltrarla alla fase di revisione selezionando "Invia alla revisione" e, successivamente, potrà assegnare i revisori utilizzando il tasto "Aggiungi revisore".</p><p>Se la proposta non dovesse essere a Suo giudizio appropriata per questa rivista, La preghiamo di rifiutarla.</p><p>Grazie in anticipo.</p><p>Cordiali saluti,</p>{$journalSignature}'),
(61, 'EDITOR_ASSIGN', 'nl', 'Redacteur toegewezen', 'Redactietaak', '{$recipientName}:<br />\n<br />\nDe inzending &quot;{$submissionTitle}&quot; voor {$journalName} is aan u toegewezen om in uw rol als sectieredacteur door het redactieproces te leiden.<br />\n<br />\nURL inzending: {$submissionUrl}<br />\nGebruikersnaam: {$recipientUsername}<br />\n<br />\nDank u, </p>{$journalSignature}'),
(62, 'EDITOR_ASSIGN', 'ru', 'Редактор назначен', 'Вы были назначены редактором материала в журнале «{$journalName}»', '<p>Здравствуйте, {$recipientName}!</p><p>Вам поручен контроль прохождения через редакционный процесс следующего материала:</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Аннотация</b></p>{$submissionAbstract}<p>Если Вы считаете, что данный материал соответствует тематике журнала «{$journalName}», пожалуйста, направьте его на этап рецензирования, выбрав «Отправить на рецензию», а затем назначив рецензентов, щелкнув на «Добавить рецензента».</p><p>Если материал не подходит для этого журнала, пожалуйста отклоните его.</p><p>Заранее благодарю.</p><p>С уважением,</p>{$journalSignature}'),
(63, 'EDITOR_ASSIGN', 'en', 'Editor Assigned', 'You have been assigned as an editor on a submission to {$journalName}', '<p>Dear {$recipientName},</p><p>The following submission has been assigned to you to see through the editorial process.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>If you find the submission to be relevant for {$journalName}, please forward the submission to the review stage by selecting "Send to Review" and then assign reviewers by clicking "Add Reviewer".</p><p>If the submission is not appropriate for this journal, please decline the submission.</p><p>Thank you in advance.</p><p>Kind regards,</p>{$journalSignature}'),
(64, 'REVIEW_CANCEL', 'de', 'Gutachter/in nicht mehr zugeordnet', 'Anfrage zur Begutachtung zurückgezogen', '<p>Sehr geehrte/r {$recipientName},</p><p>vor kurzem haben wir Sie gebeten, eine Einsendung an die Zeitschrift{$KontextName} zu begutachten. Wir haben uns entschlossen, die Bitte um Begutachtung der Einreichung {$submissionTitle} zu stornieren.</p><p>Wir entschuldigen uns für alle Unannehmlichkeiten, die Ihnen dadurch entstehen, und hoffen, dass wir Sie auch in Zukunft zur Unterstützung des Begutachtungsprozesses dieser Zeitschrift heranziehen können.</p><p>Wenn Sie irgendwelche Fragen haben, wenden Sie sich bitte an mich.</p>{$signature}'),
(65, 'REVIEW_CANCEL', 'es', 'Desasignar revisor/a', 'Petición de revisión cancelada', '<p>Estimado/a {$recipientName},</p><p>Recientemente, le pedimos que revisara una presentación para {$journalName}. Hemos decidido cancelar la solicitud para que revise el artículo, {$submissionTitle}.</p><p>Lamentamos cualquier inconveniente que esto pueda causarle y esperamos poder contar con su ayuda en el futuro para el proceso de revisión de esta revista.</p><p>Si tiene alguna pregunta, por favor contácteme.</p>{$signature}'),
(66, 'REVIEW_CANCEL', 'fr_CA', 'Évaluateur.trice non assigné.e', 'Annulation de la demande d''évaluation', '<p>Bonjour {$recipientName},</p><p>Nous avons décidé d''annuler notre demande concernant l''évaluation du manuscrit intitulé « {$submissionTitle} » pour la revue {$journalName}. Nous sommes désolés des inconvénients que cela pourrait vous causer et espérons que nous pourrons de nouveau faire appel à vous pour contribuer au processus de révision par les pairs de cette revue dans le futur.</p><p>Si vous avez des questions, n''hésitez pas à communiquer avec nous.</p>{$signature}'),
(67, 'REVIEW_CANCEL', 'it', 'Revisore non assegnato', 'Cancellazione della richiesta di revisione', '<p>Gentile {$recipientName},</p><p>Di recente Le abbiamo chiesto di esaminare una proposta per {$journalName}. Abbiamo tuttavia deciso di annullare tale la richiesta di revisione per il contributo {$submissionTitle}.</p><p>Ci scusiamo per l''inconveniente e speriamo di poterLa contattare in futuro per nuove occasioni di collaborazione.</p><p>Per ogni quesito o necessità, non esiti a contattarci. Grazie e cordiali saluti,</p>{$signature}'),
(68, 'REVIEW_CANCEL', 'nl', 'Reviewverzoek Intrekken', 'Reviewverzoek ingetrokken', '<p>Dear {$recipientName}:<br />\n<br />\nWe hebben besloten om ons verzoek aan u om de inzending &quot;{$submissionTitle}&quot; voor {$journalName}in te trekken. We verontschuldigen ons voor enig ongemak dat we daarmee veroorzaken en hopen dat we u in de toekomst mogen vragen om een bijdrage aan het reviewproces van dit tijdschrift.<br />\n<br />\nAls u nog vragen heeft, kunt u contact met mij opnemen.</p>{$signature}'),
(69, 'REVIEW_CANCEL', 'ru', 'Назначение рецензентом отменено', 'Запрос на рецензирование отменен', '<p>Здравствуйте, {$recipientName}!</p><p>Недавно мы просили Вас дать рецензию на материал, присланный в журнал «{$journalName}», и теперь решили отменить наш запрос на рецензирование Вами материала «{$submissionTitle}».</p><p>Мы приносим свои извинения за причиненное Вам беспокойство и надеемся, что в будущем мы сможем к Вам обратиться за помощью в рецензировании материалов для нашего журнала.</p><p>Если у Вас есть вопросы, пожалуйста, свяжитесь со мной.</p>{$signature}'),
(70, 'REVIEW_CANCEL', 'en', 'Reviewer Unassign', 'Request for Review Cancelled', '<p>Dear {$recipientName},</p><p>Recently, we asked you to review a submission to {$journalName}. We have decided to cancel the request for you to reivew the submission, {$submissionTitle}.</p><p>We apologize any inconvenience this may cause you and hope that we will be able to call on you to assist with this journal''s review process in the future.</p><p>If you have any questions, please contact me.</p>{$signature}'),
(71, 'REVIEW_REINSTATE', 'de', 'Gutachter/in wieder eingesetzt', 'Können Sie weiterhin einen Beitrag für {$journalName} begutachten?', '<p>Sehr geehrte/r {$recipientName},</p><p>wir haben vor kurzem unsere Anfrage an Sie, eine Einreichung, {$submissionTitle}, für die Zeitschrift {$journalName} zu begutachten, storniert. Wir haben diese Entscheidung rückgängig gemacht und hoffen, dass Sie immer noch in der Lage sind, die Begutachtung durchzuführen.</p><p>Wenn Sie in der Lage sind, bei der Begutachtung dieser Einreichung zu helfen, können Sie sich <a href="{$reviewAssignmentUrl}">bei der Zeitschrift anmelden</a>, um die Einreichung zu sehen, Begutachtungsdateien hochzuladen und Ihre Begutachtungsanfrage zu übermitteln.</p><p>Wenn Sie irgendwelche Fragen haben, kontaktieren Sie mich bitte.</p><p>Mit freundlichen Grüßen,</p>{$signature}'),
(72, 'REVIEW_REINSTATE', 'es', 'Restaurar revisor/a', '¿Aún puede hacer revisiones para {$journalName}?', '<p>Estimado {$recipientName},</p><p>Recientemente cancelamos nuestra solicitud para que revisara una presentación, {$submissionTitle}, para {$journalName}. Hemos revertido esa decisión y esperamos que todavía pueda llevar a cabo la revisión.</p><p>Si puede ayudar con la revisión de este artículo, puede <a href="{$reviewAssignmentUrl}">iniciar sesión en la revista</a> para ver la presentación, cargar archivos de revisión y enviar su solicitud de revisión.</p><p>Si tiene alguna pregunta, por favor contácteme.</p><p>Atentamente,</p>{$signature}'),
(73, 'REVIEW_REINSTATE', 'fr_CA', 'Évaluateur.trice réintégré.e', 'Êtes-vous encore en mesure d''évaluer des travaux pour la revue {$journalName} ?', '<p>{$recipientName},</p><p>Nous avons récemment annulé notre demande vous demandant d''évaluer la soumission, {$submissionTitle}, pour la revue {$journalName}. Nous sommes revenus sur cette décision et nous espérons que vous êtes toujours en mesure d''effectuer l''évaluation.</p><p>Si vous êtes en mesure d''aider au processus d''évaluation de cette revue, vous pouvez vous <a href="{$reviewAssignmentUrl}">connecter au site de la revue</a> pour voir la soumission, téléverser les fichiers d''évaluation ainsi que soumettre votre évaluation.</p><p>Si vous avez des questions, n''hésitez pas à communiquer avec moi,</p><p>Cordialement,</p>{$signature}');
INSERT INTO `email_templates_default_data` VALUES
(74, 'REVIEW_REINSTATE', 'it', 'Revisore reintegrato', 'È ancora disponibile per la revisione per {$journalName}?', '<p>Gentile {$recipientName},</p><p>La contattiamo perché avevamo di recente annullato la nostra richiesta di revisione per la proposta {$submissionTitle}, per {$journalName}. Tuttavia, abbiamo ora riveduto tale decisione e speriamo vivamente che Lei possa ancora effettuare la revisione.</p><p>Qualora possa contribuire alla revisione di questa proposta editoriale, potrà <a href="{$reviewAssignmentUrl}">effettuare l''accesso</a> per visualizzare la proposta, per caricare i file di revisione e per inviare le richieste.</p><p>Per ogni quesito, non esiti a contattarci.</p><p>Cordiali saluti,</p>{$signature}'),
(75, 'REVIEW_REINSTATE', 'nl', '', 'Herindienen beoordelingsverzoek', '<p>Dear {$recipientName}:<br />\n<br />\nWe willen graag ons beoordelingsverzoek over de inzending, &quot;{$submissionTitle},&quot; for {$journalName}, herindienen.<br />\n<br />\nVoor vragen kunt u contact met mij opnemen,</p>{$signature}'),
(76, 'REVIEW_REINSTATE', 'ru', 'Рецензент назначен заново', 'Можете ли Вы ещё отрецензировать кое-что для «{$journalName}»?', '<p>Здравствуйте, {$recipientName}!</p><p>Мы недавно отменили наш запрос на Вашу рецензию для материала «{$submissionTitle}» в журнал «{$journalName}». Сейчас мы изменили это решение и надеемся, что Вы ещё можете дать эту рецензию.</p><p>Если Вы можете помочь нашему журналу с процессом рецензирования данного материала, Вы можете <a href="{$reviewAssignmentUrl}">войти в систему</a>, чтобы просмотреть материал, загрузить файлы рецензии и отправить Вашу рецензию.</p><p>Если у Вас есть какие-то вопросы, пожалуйста, свяжитесь со мной.</p><p>С уважением,</p>{$signature}'),
(77, 'REVIEW_REINSTATE', 'en', 'Reviewer Reinstate', 'Can you still review something for {$journalName}?', '<p>Dear {$recipientName},</p><p>We recently cancelled our request for you to review a submission, {$submissionTitle}, for {$journalName}. We''ve reversed that decision and we hope that you are still able to conduct the review.</p><p>If you are able to assist with this submission''s review, you can <a href="{$reviewAssignmentUrl}">login to the journal</a> to view the submission, upload review files, and submit your review request.</p><p>If you have any questions, please contact me.</p><p>Kind regards,</p>{$signature}'),
(78, 'REVIEW_RESEND_REQUEST', 'de', 'Gutachtenanfrage erneut an Gutachter/in senden', 'Erneute Anfrage nach Ihrem Gutachten für {$journalName}', '<p>Sehr geehrte/r {$recipientName},</p><p>Kürzlich haben Sie unsere Bitte abgelehnt, eine Einreichung, {$submissionTitle}, für {$journalName} zu prüfen. Ich schreibe Ihnen, um zu erfahren, ob Sie die Prüfung doch noch durchführen können.</p><p>Wir wären Ihnen dankbar, wenn Sie diese Beurteilung vornehmen könnten, haben aber Verständnis dafür, wenn dies zum jetzigen Zeitpunkt nicht möglich ist. In jedem Fall bitten wir Sie, <a href="{$reviewAssignmentUrl}">die Anfrage</a> bis zum {$responseDueDate} anzunehmen oder abzulehnen, damit wir einen alternativen Gutachter oder eine alternative Gutachterin finden können.</p><p>Wenn Sie Fragen haben, wenden Sie sich bitte an mich.</p><p>Mit freundlichen Grüßen,</p>{$signature}'),
(79, 'REVIEW_RESEND_REQUEST', 'es', 'Reenviar la solicitud de revisión al revisor/a', 'Solicitando de nuevo su revisión para {$journalName}', ''),
(80, 'REVIEW_RESEND_REQUEST', 'fr_CA', 'Envoyer de nouveau la demande d''évaluation à l''évaluateur-trice', 'Demande d''évaluation réitérée pour {$journalName}', '<p>{$recipientName},</p><p>Vous avez décliné récemment notre invitation à évaluer la soumission, {$submissionTitle}, pour {$journalName}. Je vous écris afin de vous demander si vous accepteriez de reconsidérer votre décision et d''accepter de l''évaluer.</p><p>Nous vous en serions très reconnaissant, mais nous comprenons également que vous soyez dans l''impossibilité de le faire en ce moment. Quoi qu''il en soit, pouvez-vous s''il vous plait <a href="{$reviewAssignmentUrl}">accepter ou approuver notre demande</a> avant le {$responseDueDate}.</p><p>Si vous avez des questions, n''hésitez pas nous contacter.</p><p>Cordialement,</p>{$signature}'),
(81, 'REVIEW_RESEND_REQUEST', 'it', '', '', ''),
(82, 'REVIEW_RESEND_REQUEST', 'nl', '', 'Verzoek om je nieuwe beoordeling voor {$journalName}', '<p>Beste {$recipientName},</p><p>Onlangs heb je ons verzoek om een inzending, {$submissionTitle}, voor {$journalName} te beoordelen, afgewezen. Ik schrijf om te vragen of je toch in staat bent om de beoordeling uit te voeren.</p><p>We zouden je dankbaar zijn als je deze beoordeling kunt uitvoeren, maar we begrijpen het als dat op dit moment niet mogelijk is. Hoe dan ook, graag <a href="{$reviewAssignmentUrl}">accepteer of wijs het verzoek af</a> voor {$responseDueDate}, zodat we een alternatieve beoordelaar kunnen vinden.</p><p>Als je vragen hebt, neem dan contact met me op.</p><p>Met vriendelijke groet,</p>{$signature}'),
(83, 'REVIEW_RESEND_REQUEST', 'ru', 'Повторная отправка рецензенту запроса на рецензию', 'Повторный запрос Вашей рецензии для журнала «{$journalName}»', '<p>Здравствуйте, {$recipientName}!</p><p>Недавно Вы отклонили наш запрос на рецензирование материала «{$submissionTitle}» для журнала «{$journalName}». Я пишу Вам, чтобы узнать, может Вы всё-таки сможете провести рецензирование этого материала.</p><p>Мы будем благодарны, если Вы сможете дать эту рецензию, но также поймём, если Вы не сможете это сделать в данный момент. В любом случае, пожалуйста, <a href="{$reviewAssignmentUrl}">примите или отклоните запрос</a> до {$responseDueDate}, чтобы мы смогли найти другого рецензента.</p><p>Если у Вас есть какие-то вопросы, пожалуйста, свяжитесь со мной.</p><p>С уважением,</p>{$signature}'),
(84, 'REVIEW_RESEND_REQUEST', 'en', 'Resend Review Request to Reviewer', 'Requesting your review again for {$journalName}', '<p>Dear {$recipientName},</p><p>Recently, you declined our request to review a submission, {$submissionTitle}, for {$journalName}. I''m writing to see if you are able to conduct the review after all.</p><p>We would be grateful if you''re able to perform this review, but we understand if that is not possible at this time. Either way, please <a href="{$reviewAssignmentUrl}">accept or decline the request</a> by {$responseDueDate}, so that we can find an alternate reviewer.</p><p>If you have any questions, please contact me.</p><p>Kind regards,</p>{$signature}'),
(85, 'REVIEW_REQUEST', 'de', 'Gutachtenanfrage', 'Einladung zur Begutachtung', '<p>Sehr geehrte/r {$recipientName},</p><p>Ich glaube, dass Sie ein hervorragender Gutachter für einen Beitrag bei der Zeitschrift {$journalName} sein könnten. Ich hoffe, dass Sie diese wichtige Aufgabe für uns übernehmen werden.</p><p>Wenn Sie in der Lage sind, diesen Beitrag zu begutachten, ist Ihre Begutachtung bis zum {$reviewDueDate} fällig. Sie können die Einreichung einsehen, Begutachtungsdateien hochladen und Ihre Begutachtung einreichen, indem Sie sich auf der Website der Zeitschrift anmelden und den Schritten unter dem unten stehenden Link folgen. </p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a></p><p><b>Abstract</b></p>{$submissionAbstract}<p>Ich erbitte die <a href="{$reviewAssignmentUrl}">Annahme oder Ablehnung</a> des Gutachtens bis <b>{$responseDueDate}</b>. </p><p>Gerne stehe ich Ihnen zur Verfügung, wenn Sie Fragen zur Einreichung oder zum Begutachtungsverfahren haben.</p><p>Danke, dass Sie diesen Anfrage berücksichtigen. Ihre Hilfe wird sehr geschätzt.</p><p>Mit freundlichen Grüßen,</p>{$signature}'),
(86, 'REVIEW_REQUEST', 'es', 'Solicitud de revisión', 'Invitación de revisión', '<p>Estimado/a {$recipientName},</p><p>Creemos que sería un excelente revisor/a para el envío a {$journalName}. El título y el resumen del envío se encuentran a continuación, espero que considere asumir esta tarea tan importante para nosotros.</p><p>Si puede revisar este envío, debería devolvernos su revisión antes del {$reviewDueDate}. Puede ver el envío, cargar los archivos de revisión y enviarnos su revisión iniciando sesión en el sitio de la revista y siguiendo los pasos del siguiente enlace.</p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a></p><p><b>Resumen</b></p>{$submissionAbstract}<p>Por favor, <a href="{$reviewAssignmentUrl}">acepte o rechace</a> la revisión antes del <b>{$responseDueDate}</b>.</p><p>Puede ponerse en contacto con nosotros si tiene alguna pregunta sobre el envío o el proceso de revisión.</p><p>Gracias por considerar esta solicitud. Apreciamos mucho su ayuda.</p><p>Atentamente,</p>{$signature}'),
(87, 'REVIEW_REQUEST', 'fr_CA', 'Demande d''évaluation', 'Demande d''évaluation d''un article', '<p>Bonjour {$recipientName},</p><p>Nous croyons que vous feriez un-e excellent-e évaluateur-trice pour le manuscrit intitulé « {$submissionTitle} » qui a été soumis à la revue {$journalName}. Vous trouverez un résumé de la soumission ci-dessous. Nous espérons que vous accepterez ce travail essentiel à la publication de la revue.</p><p>Veuillez accéder au site Web de la revue avant le {$responseDueDate} pour nous laisser savoir  <a href="{$reviewAssignmentUrl}">si vous acceptez de faire l''évaluation ou non</a>.</p><p>« {$submissionTitle} »</p><p>{$submissionAbstract}</p><p>La date d''échéance de l''évaluation a été fixée au {$reviewDueDate}.</p><p>Si vous n''avez pas de nom d''utilisateur-trice et de mot de passe pour le site Web de la revue, cliquez sur le lien ci-dessous pour réinitialiser votre mot de passe (lequel vous sera envoyé par courriel avec votre nom d''utilisateur-trice). {$passwordLostUrl}</p><p>URL de la soumission : {$reviewAssignmentUrl}</p><p>Nous vous remercions de l''attention que vous porterez à notre demande.</p>{$signature}'),
(88, 'REVIEW_REQUEST', 'it', '', 'Proposta di revisione', '<p>Gentile {$recipientName},</p><p>Ritengo che Lei sarebbe un eccellente revisore per una proposta editoriale che è stata sottoposta a {$journalName}. Il titolo e l''abstract della proposta sono riportati qui di seguito; spero che potrà prendere in considerazione l''idea di svolgere questo importante compito per noi.</p><p>In caso di Sua disponibilità, la scadenza per la revisione è fissata al {$reviewDueDate}. È possibile visualizzare la proposta, caricare i file di revisione e inviare la propria revisione accedendo al sito della rivista e seguendo i passaggi indicati nel link sottostante.</p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a></p><p><b>Abstract</b></p>{$submissionAbstract}<p>Per cortesia <a href="{$reviewAssignmentUrl}">accetti o declini</a> la proposta di revisione entro il <b>{$responseDueDate}</b>.</p><p>Non esiti a contattarci per qualsiasi domanda sull''invio o sul processo di revisione.</p><p>Grazie per aver preso in considerazione questa richiesta e per la preziosa collaborazione.</p><p>Cordiali saluti,</p>{$signature}'),
(89, 'REVIEW_REQUEST', 'nl', 'Artikel Review Verzoek', 'Artikel review verzoek', '{$recipientName}:<br />\n<br />\nIk geloof dat u een excellente reviewer zou zijn voor het manuscript &quot;{$submissionTitle}&quot; dat is ingestuurd bij {$journalName}. De samenvatting van de inzending staat hieronder. Ik hoop dat u wilt overwegen deze belangrijke taak voor ons uit te voeren.<br />\n<br />\nWilt u voor {$responseDueDate} inloggen op de website van het tijdschrift om aan te geven of u de review al of niet doet. Daar kunt u ook de inzending vinden en uw review en aanbeveling vastleggen. De website is {$journalUrl}<br />\n<br />\nHet review wordt verwacht op {$reviewDueDate}.<br />\n<br />\nAls u uw gebruikersnaam en het wachtwoord van de website van het tijdschrift niet heeft, kunt u deze link gebruiken voor het herstellen van uw wachtwoord (dat samen met uw gebruikersnaam in een e-mail naar u verstuurd wordt). {$passwordLostUrl}<br />\n<br />\nURL inzending: {$reviewAssignmentUrl}<br />\n<br />\nDank u voor het overwegen van dit verzoek.<br />\n<br />\n{$signature}<br />\n<br />\n<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}'),
(90, 'REVIEW_REQUEST', 'ru', 'Запрос на рецензию', 'Приглашение к рецензированию', '<p>Здравствуйте, {$recipientName}!</p><p>Я полагаю, что Вы могли бы быть прекрасным рецензентом для материала, который был направлен в журнал «{$journalName}». Название и аннотация статьи приведены ниже, и я надеюсь, что Вы возьметесь выполнить эту важную задачу для нас.</p><p>Если Вы можете дать рецензию, то её надо сделать к {$reviewDueDate}. Вы можете просмотреть материал, загрузить файлы рецензии и отправить Вашу рецензию, войдя в систему на сайте журнала и следуя шагам по ссылке ниже.</p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a></p><p><b>Аннотация</b></p>{$submissionAbstract}<p>Пожалуйста, <a href="{$reviewAssignmentUrl}">подтвердите Ваше согласие или откажитесь</a> от рецензирования до <b>{$responseDueDate}</b>.</p><p>Вы можете связаться со мной, если у Вас есть какие-то вопросы относительно материала или процесса рецензирования.</p><p>Благодарю Вас за рассмотрение этой просьбы. Мы высоко ценим вашу помощь.</p><p>С уважением,</p>{$signature}'),
(91, 'REVIEW_REQUEST', 'en', 'Review Request', 'Invitation to review', '<p>Dear {$recipientName},</p><p>I believe that you would serve as an excellent reviewer for a submission  to {$journalName}. The submission''s title and abstract are below, and I hope that you will consider undertaking this important task for us.</p><p>If you are able to review this submission, your review is due by {$reviewDueDate}. You can view the submission, upload review files, and submit your review by logging into the journal site and following the steps at the link below.</p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a></p><p><b>Abstract</b></p>{$submissionAbstract}<p>Please <a href="{$reviewAssignmentUrl}">accept or decline</a> the review by <b>{$responseDueDate}</b>.</p><p>You may contact me with any questions about the submission or the review process.</p><p>Thank you for considering this request. Your help is much appreciated.</p><p>Kind regards,</p>{$signature}'),
(92, 'REVIEW_REQUEST_SUBSEQUENT', 'de', 'Nachfolgende Gutachtenanfrage', 'Anfrage zur Begutachtung einer überarbeiteten Einreichung', '<p>Sehr geehrte/r {$recipientName},</p><p>Danke für Ihr Gutachten zu <a href="{$reviewAssignmentUrl}">{$submissionTitle}</a>. Die Autor/innen haben das Feedback der Gutachter/innen berücksichtigt und nun eine überarbeitete Version ihrer Arbeit eingereicht. Ich schreibe Ihnen, um Sie zu fragen, ob Sie eine zweite Begutachtungsrunde für diese Einreichung durchführen würden.</p><p>Wenn Sie in der Lage sind, diese Einreichung zu begutachten, ist Ihre Begutachtung bis {$reviewDueDate} fällig. Sie können <a href="{$reviewAssignmentUrl}">den Begutachtungsschritten folgen</a>, um die Einreichung anzusehen, Begutachtungsdateien hochzuladen und Ihre Begutachtungskommentare einzureichen. <p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a></p><p><b>Abstract</b></p>{$submissionAbstract}<p>Bitte <a href="{$reviewAssignmentUrl}">Annahme oder Ablehnung</a> des Gutachtens bis zum <b>{$responseDueDate}</b>. </p><p>Bei Fragen zur Einreichung oder zum Begutachtungsverfahren können Sie sich gerne an mich wenden.</p><p>Danke, dass Sie diesen Anfrage berücksichtigen. Ihre Hilfe wird sehr geschätzt.</p><p>Mit freundlichen Grüßen,</p>{$signature}'),
(93, 'REVIEW_REQUEST_SUBSEQUENT', 'es', 'Solicitud de revisión posterior', 'Solicitud para revisar un envío ya revisado', '<p>Estimado/a {$recipientName},</p><p>Le agradecemos su revisión de <a href="{$reviewAssignmentUrl}">{$submissionTitle}</a>. Los autores/as han tenido en cuenta los comentarios de los revisores/as y han enviado una versión revisada de su trabajo. Le escribo para preguntarle si podría realizar una segunda ronda de revisión por pares de este envío.</p><p>Si está disponible para revisar este envío, debería devolvernos su revisión antes del {$reviewDueDate}. Puede <a href="{$reviewAssignmentUrl}">seguir los pasos de revisión</a> para ver el envío, cargar archivos de revisión y enviar sus comentarios de revisión.</p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a></p><p><b>Resumen</b></p>{$submissionAbstract}<p>Por favor, <a href="{$reviewAssignmentUrl}">acepte o rechace</a> la revisión antes del <b>{$responseDueDate}</b>.</p><p>No dude en ponerse en contacto con nosotros si tiene alguna pregunta sobre el envío o el proceso de revisión.</p><p>Gracias por considerar esta solicitud. Apreciamos mucho su ayuda.</p><p>Atentamente,</p>{$signature}'),
(94, 'REVIEW_REQUEST_SUBSEQUENT', 'fr_CA', 'Demande d''évaluation (nouveau cycle)', 'Demande d''évaluation d''un article révisé', '<p>{$recipientName},</p><p>Nous vous remercions d''avoir effectué l''évaluation du manuscrit intitulé <a href="{$reviewAssignmentUrl}">{$submissionTitle}</a>.</p><p><br/>{$submissionAbstract}</p>\n<p>Suivant les commentaire de l''évaluation de la dernière version du manuscrit, l''auteur-trice a soumis une version révisée de son document. Nous apprécierions que vous évaluiez cette nouvelle version dans le cadre d''un second cycle d''évaluation.</p><p>Si vous êtes en mesure d''effectuer cette évaluation, veuillez vous authentifier sur la page de la revue avant le {$responseDueDate} pour y indiquer si vous participerez à cette évaluation ou non, ou encore pour accéder à la soumission et y enregistrer votre évaluation et vos recommandations. Le site Web est {$journalUrl}</p>\n<p>L''évaluation est due pour le {$reviewDueDate}.</p><p>Si vous n''avez pas vos nom d''utilisateur-trice et mot de passe pour le site de la revue, vous pouvez utiliser le lien suivant pour réinitialiser votre mot de passe (lequel vous sera envoyé par courriel avec votre nom d''utilisateur-trice). {$passwordLostUrl}</p><p>URL de la soumission : {$reviewAssignmentUrl}</p><p>Nous vous remercions de l''attention que vous porterez à notre demande.</p>{$signature}'),
(95, 'REVIEW_REQUEST_SUBSEQUENT', 'it', '', 'Richiesta di ulteriore revisione per una proposta già valutata', '<p>Gentile {$recipientName},</p><p>Grazie per la Sua cortese valutazione di <a href="{$reviewAssignmentUrl}">{$submissionTitle}</a>. A seguito delle considerazioni formulate, sono stati ricevuti riscontri e una nuova versione della proposta editoriale. Saremmo dunque grati se potesse effettuare una nuova e ulteriore valutazione per questa proposta editoriale.</p><p>In caso di disponibilità, Le saremmo grati se potesse comunicare la Sua valutazione entro il {$reviewDueDate}. Le ricordiamo che potrà accedere al <a href="{$reviewAssignmentUrl}">processo editoriale</a>per visualizzare la proposta, caricare nuovi file di revisione, e sottoporre i Suoi eventuali commenti.<p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a></p><p><b>Abstract</b></p>{$submissionAbstract}<p>La preghiamo dunque di <a href="{$reviewAssignmentUrl}">accettare o declinare</a> la revisione entro il <b>{$responseDueDate}</b>.</p><p>Per ogni esigenza o necessità, non esiti a contattarci.</p><p>Grazie infinite, e con i più cordiali saluti,</p>{$signature}'),
(96, 'REVIEW_REQUEST_SUBSEQUENT', 'nl', 'Verzoek tot reviewen van een artikel', 'Verzoek tot reviewen van een herzien artikel', '{$recipientName}:<br />\n<br />\nDit betreft het manuscript &quot;{$submissionTitle},&quot; dat wordt overwogen door {$journalName}.<br />\n<br />\nNa de review van een vorige versie van hun manuscript hebben de auteurs een gereviseerde versie ingestuurd. We zouden het waarderen als u wilt helpen die te evalueren.<br />\n<br />\nGelieve in te loggen op de website van het tijdschrift vóór {$responseDueDate} om aan te geven of u deze review wilt doen of niet, alsmede om toegang te krijgen tot de inzending en uw bevindingen en aanbeveling vast te leggen. De website is {$journalUrl}<br />\n<br />\nDe revieuw moet gereed zijn op {$reviewDueDate}.<br />\n<br />\nAls u uw gebruikersnaam en wachtwoord niet meer heeft, kunt u deze link gebruiken om uw wachtwoord terug te zetten (dat u met uw gebruikersnaam in een e-mail zult ontvangen). {$passwordLostUrl}<br />\n<br />\nURL van de inzending: {$reviewAssignmentUrl}<br />\n<br />\nHartelijk dank voor het overwegen van dit verzoek.<br />\n<br />\n{$signature}<br />\n<br />\n<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}'),
(97, 'REVIEW_REQUEST_SUBSEQUENT', 'ru', 'Запрос на повторную рецензию', 'Запрос на рецензирование исправленного материала', '<p>Здравствуйте, {$recipientName}!</p><p>Благодарю Вас за рецензирование материала <a href="{$reviewAssignmentUrl}">«{$submissionTitle}»</a>. Авторы ознакомились с отзывами рецензентов и прислали откорректированную версию их работы. В связи с этим хочу спросить Вас: сможете ли Вы принять участие во втором раунде рецензирования этого материала?</p><p>Если Вы сможете дать рецензию на этот материал, то её нужно прислать до {$reviewDueDate}. Вы можете <a href="{$reviewAssignmentUrl}">следовать шагам процесса рецензирования</a>, чтобы просмотреть материал, загрузить файлы рецензии и отправить Ваши комментарии по рецензии.<p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a></p><p><b>Аннотация</b></p>{$submissionAbstract}<p>Пожалуйста, <a href="{$reviewAssignmentUrl}">подтвердите Ваше согласие или откажитесь</a> от рецензирования до <b>{$responseDueDate}</b>.</p><p>Пожалуйста, свяжитесь со мной, если у Вас есть какие-то вопросы по материалу или процессу рецензирования.</p><p>Благодарю Вас за рассмотрение этой просьбы. Мы высоко ценим вашу помощь.</p><p>С уважением,</p>{$signature}'),
(98, 'REVIEW_REQUEST_SUBSEQUENT', 'en', 'Review Request Subsequent', 'Request to review a revised submission', '<p>Dear {$recipientName},</p><p>Thank you for your review of <a href="{$reviewAssignmentUrl}">{$submissionTitle}</a>. The authors have considered the reviewers'' feedback and have now submitted a revised version of their work. I''m writing to ask if you would conduct a second round of peer review for this submission.</p><p>If you are able to review this submission, your review is due by {$reviewDueDate}. You can <a href="{$reviewAssignmentUrl}">follow the review steps</a> to view the submission, upload review files, and submit your review comments.<p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a></p><p><b>Abstract</b></p>{$submissionAbstract}<p>Please <a href="{$reviewAssignmentUrl}">accept or decline</a> the review by <b>{$responseDueDate}</b>.</p><p>Please feel free to contact me with any questions about the submission or the review process.</p><p>Thank you for considering this request. Your help is much appreciated.</p><p>Kind regards,</p>{$signature}'),
(99, 'REVIEW_RESPONSE_OVERDUE_AUTO', 'de', 'Antwort auf eine Gutachtenanfrage fällig (Automatisiert)', 'Können Sie den Beitrag für uns begutachten?', '<p>Sehr geehrte/r {$recipientName},</p><p>Diese E-Mail ist eine automatische Erinnerung der Zeitschrift {$Kontextname} in Bezug auf unsere Aufforderung zur Begutachtung der Einreichung "{$submissionTitle}".</p><p>Sie erhalten diese E-Mail, weil wir noch keine Bestätigung von Ihnen erhalten haben, ob Sie in der Lage sind, diese Einreichung zu begutachen oder nicht. </p><p>Bitte teilen Sie uns mit, ob Sie in der Lage sind, diesen Beitrag zu prüfen, indem Sie unsere Software zur Verwaltung der Einreichungen verwenden, um diese Anfrage anzunehmen oder abzulehnen.</p><p>Wenn Sie in der Lage sind, diesen Beitrag zu prüfen, ist Ihr Gutachten bis zum {$reviewDueDate} fällig. Sie können die Begutachtungsschritte befolgen, um die Einreichung einzusehen, Begutachtungsdateien hochzuladen und Ihre Begutachtungskommentare zu übermitteln.</p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a></p><p><b>Abstract</b></p>{$submissionAbstract}<p>Bei Fragen zur Einreichung oder zum Begutachtungsprozess können Sie sich gerne an mich wenden.</p><p>Danke, dass Sie diese Anfrage berücksichtigen. Ihre Hilfe ist mir sehr willkommen.</p><p>Mit freundlichen Grüßen,</p>{$journalSignature}'),
(100, 'REVIEW_RESPONSE_OVERDUE_AUTO', 'es', 'Respuesta de revisión vencida (automática)', '¿Podrá llevar a cabo la revisión?', '<p>Estimado/a {$recipientName},</p><p>Este correo electrónico es un recordatorio automático de {$journalName} en relación con la solicitud de revisión del envío, "{$submissionTitle}."</p><p>El motivo de este mensaje es que aún no hemos recibido la confirmación de si podrá llevar a cabo la revisión de este envío.</p><p>Por favor, háganos saber su decisión mediante nuestro software de gestión de envíos aceptando o rechazando dicha solicitud.</p><p>Si está dispuesto a aceptar el encargo, su revisión debería estar lista el {$reviewDueDate}. Puede seguir los pasos de revisión para visualizar el envío, cargar archivos de revisión y enviar sus comentarios.</p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a></p><p><b>Resumen</b></p>{$submissionAbstract}<p>No dude en ponerse en contacto con nosotros si tiene cualquier pregunta acerca del envío o del proceso de revisión.</p><p>Gracias por tomar en consideración esta petición. Su ayuda es muy valiosa.</p><p>Saludos cordiales,</p>{$journalSignature}'),
(101, 'REVIEW_RESPONSE_OVERDUE_AUTO', 'fr_CA', 'Rappel automatique pour une invitation à évaluer', 'Seriez-vous en mesure d''évaluer ce manuscrit pour nous ?', '<p>Bonjour {$recipientName},</p><p>Ceci est un petit rappel concernant notre demande d''évaluation de « {$submissionTitle} » pour la revue {$journalName}. Puisque nous n''avons pas reçu, comme nous l''espérions, une réponse avant le {$responseDueDate}, ce courriel a été généré et envoyé automatiquement après l''échéance du délai.</p><p>Nous pensons que vous seriez un-e excellent-e évaluateur-trice pour le manuscrit. Vous trouverez un résumé de la soumission ci-dessous. Nous espérons que vous envisagerez d''entreprendre cette tâche essentielle à la publication de la revue.</p>\n<p>Veuillez vous authentifier sur la page de la revue pour y indiquer si vous participerez à cette évaluation ou non, ou encore pour accéder à la soumission et y enregistrer votre évaluation et vos recommandations. Le site Web est {$journalUrl}</p><p>L''évaluation est dû pour le {$reviewDueDate}.</p><p>Si vous n''avez pas vos nom d''utilisateur-trice et mot de passe pour le site de la revue, vous pouvez utiliser le lien suivant pour réinitialiser votre mot de passe (lequel vous sera envoyé par courriel avec votre nom d''utilisateur-trice). {$passwordLostUrl}</p><p>URL de la soumission : {$reviewAssignmentUrl}</p><p>Nous vous remercions de l''attention que vous porterez à notre demande.</p><p>« {$submissionTitle} »</p><p>{$submissionAbstract}</p>{$journalSignature}'),
(102, 'REVIEW_RESPONSE_OVERDUE_AUTO', 'it', '', 'Può effettuare una revisione per la nostra rivista?', '<p>Gentile {$recipientName},</p><p>Questa e-mail è un promemoria automatico da parte di {$journalName} in merito alla richiesta di revisione del contributo "{$submissionTitle}."</p><p>Riceve questa e-mail perché non abbiamo ancora raccolto una conferma da parte Sua che indichi se potrà essere in grado o meno di effettuare la revisione proposta .</p><p>La preghiamo di comunicarci la Sua eventuale disponibilità circa la possibilità di accettare o di rifiutare tale proposta utilizzando la nostra piattaforma editoriale.</p><p>Qualora fosse in grado di effettuare la revisione, la scadenza è fissata al {$reviewDueDate}. È possibile seguire le fasi di revisione per visualizzare il contributo, per caricare i file di revisione e per inviare i propri commenti di revisione.</p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a></p><p><b>Abstract</b></p>{$submissionAbstract}<p>Per ogni necessità, non esiti a contattarci.</p><p>Grazie per la preziosa collaborazione.</p><p>Con i più cordiali saluti,</p>{$journalSignature}'),
(103, 'REVIEW_RESPONSE_OVERDUE_AUTO', 'nl', 'Geautomatiseerde Review Herinnering', 'Verzoek om artikelbeoordeling', '{$recipientName}:<br />\nWe willen u vriendelijk herinneren aan ons verzoek voor een review van het manuscript &quot;{$submissionTitle},&quot; voor {$journalName}. We verwachtten uw antwoord voor {$responseDueDate}; dit bericht werd automatisch verstuurd na het verstrijken van die datum. \n<br />\nIk geloof dat u een excellente reviewer zou zijn voor het manuscript. De samenvatting van de inzending staat hieronder. Ik hoop dat u wilt overwegen deze belangrijke taak voor ons uit te voeren.<br />\n<br />\nWilt u inloggen op de website van het tijdschrift om aan te geven of u de review al of niet doet. Daar kunt u ook de inzending vinden en uw review en aanbeveling vastleggen. De website is {$journalUrl}<br />\n<br />\nHet review wordt verwacht op {$reviewDueDate}.<br />\n<br />\nAls u uw gebruikersnaam en het wachtwoord van de website van het tijdschrift niet heeft, kunt u deze link gebruiken voor het herstellen van uw wachtwoord (dat samen met uw gebruikersnaam in een e-mail naar u verstuurd wordt). {$passwordLostUrl}<br />\n<br />\nURL inzending: {$reviewAssignmentUrl}<br />\n<br />\nDank u voor het overwegen van dit verzoek.<br />\n<br />\n{$journalSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}'),
(104, 'REVIEW_RESPONSE_OVERDUE_AUTO', 'ru', 'Срок ответа на запрос рецензии прошёл (автоматическое)', 'Сможете ли Вы сделать рецензию этого материала для нас?', '<p>Здравствуйте, {$recipientName}!</p><p>Это письмо — автоматическое напоминание из журнала «{$journalName}» о нашем запросе Вашей рецензии на материал «{$submissionTitle}».</p><p>Вы получили это письмо, поскольку мы ещё не получили от Вас информации о том, что Вы сможете или не сможете сделать рецензию на этот материал.</p><p>Пожалуйста, воспользуйтесь нашей системой управления материалами, чтобы принять или отклонить этот запрос на рецензию и чтобы мы знали о Вашем решении.</p><p>Если Вы сможете дать рецензию на этот материал, то её нужно прислать до {$reviewDueDate}. Вы можете следовать шагам процесса рецензирования, чтобы просмотреть материал, загрузить файлы рецензии и отправить Ваши комментарии по рецензии.</p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a></p><p><b>Аннотация</b></p>{$submissionAbstract}<p>Пожалуйста, свяжитесь со мной, если у Вас есть какие-то вопросы по материалу или процессу рецензирования.</p><p>Благодарю Вас за рассмотрение этой просьбы. Мы высоко ценим вашу помощь.</p><p>С уважением,</p>{$journalSignature}'),
(105, 'REVIEW_RESPONSE_OVERDUE_AUTO', 'en', 'Review Response Overdue (Automated)', 'Will you be able to review this for us?', '<p>Dear {$recipientName},</p><p>This email is an automated reminder from {$journalName} in regards to our request for your review of the submission, "{$submissionTitle}."</p><p>You are receiving this email because we have not yet received a confirmation from you indicating whether or not you are able to undertake the review of this submission.</p><p>Please let us know whether or not you are able to undertake this review by using our submission management software to accept or decline this request.</p><p>If you are able to review this submission, your review is due by {$reviewDueDate}. You can follow the review steps to view the submission, upload review files, and submit your review comments.</p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a></p><p><b>Abstract</b></p>{$submissionAbstract}<p>Please feel free to contact me with any questions about the submission or the review process.</p><p>Thank you for considering this request. Your help is much appreciated.</p><p>Kind regards,</p>{$journalSignature}'),
(106, 'REVIEW_CONFIRM', 'de', 'Gutachten bestätigt', 'Überprüfung angenommen: {$reviewerName} hat den Überprüfungsauftrag angenommen für #{$submissionId} {$authorsShort} — {$submissionTitle}', '<p>Sehr geehrte/r {$recipientName},</p><p>{$reviewerName} hat die folgende Überprüfung akzeptiert:</p><p><a href="{$submissionUrl}">#{$submissionId} {$authorsShort} — {$submissionTitle}</a><br /><b>Gutachtenmethode:</b> {$reviewMethod}</p><p><b>Gutachten fällig am:</b> {$reviewDueDate}</p><p>Melden Sie sich an, um <a href="{$submissionUrl}">alle Gutachteraufgaben</a> für diese Einreichung zu sehen.</p><br><br>—<br>Dies ist eine automatische Nachricht von <a href="{$journalUrl}">{$journalName}</a>.'),
(107, 'REVIEW_CONFIRM', 'es', 'Confirmación de la revisión', 'Revisión aceptada: {$reviewerName} aceptó la asignación de revisión de #{$submissionId} {$authorsShort} — {$submissionTitle}', 'Editores/as:<br />\n<br />\nTengo la capacidad y deseo revisar el envío &quot;{$submissionTitle},&quot; para {$journalName}. Gracias por acordarse de mí, es mi intención tener la revisión completa en el plazo indicado: {$reviewDueDate}, a ser posible antes.<br />\n<br />\n{$senderName}'),
(108, 'REVIEW_CONFIRM', 'fr_CA', 'Évaluation confirmée', 'Acceptation d''évaluation', 'Rédacteurs-trices,<br />\n<br />\nJe suis en mesure d''évaluer la soumission intitulée « {$submissionTitle} » pour la revue {$journalName}. Je vous remercie d''avoir pensé à moi. Je devrais être en mesure de compléter l''évaluation pour la date du {$reviewDueDate}, voire avant.<br />\n<br />\n{$senderName}'),
(109, 'REVIEW_CONFIRM', 'it', '', 'Accettazione incarico di revisione', 'Gentile Editor,<br />\n<br />\nAccetto l''incarico di revisionare &quot;{$submissionTitle},&quot; per {$journalName}.<br />\nPenso di completare la revisione per la data che mi avete comunicato, {$reviewDueDate}, se non prima.<br />\n<br />\n{$senderName}'),
(110, 'REVIEW_CONFIRM', 'nl', 'Review mogelijk', 'Beoordeling geaccepteerd: {$reviewerName} heeft de beoordelingsopdracht geaccepteerd voor #{$submissionId} {$authorsShort} — {$submissionTitle}', '<p>Beste {$recipientName},</p><p>{$reviewerName} heeft de volgende beoordeling geaccepteerd:</p><p><a href="{$submissionUrl}">#{$submissionId} {$authorsShort} — {$submissionTitle}</a><br /><b>Type:</b> {$reviewMethod}</p><p><b>Beoordeling vereist voor:</b> {$reviewDueDate}</p><p>Log in om <a href="{$submissionUrl}">alle beoordelingsopdrachten van de beoordelaar</a> voor deze inzending te bekijken.</p><br><br>—<br>Dit is een geautomatiseerd bericht vanuit <a href="{$journalUrl}">{$journalName}</a>.'),
(111, 'REVIEW_CONFIRM', 'ru', 'Подтверждение рецензирования', 'Согласие на рецензию: {$reviewerName} принимает задание на рецензию для #{$submissionId} {$authorsShort} — «{$submissionTitle}»', '<p>Здравствуйте, {$recipientName}!</p><p>Рецензент {$reviewerName} дал согласие на следующую рецензию:</p><p><a href="{$submissionUrl}">#{$submissionId} {$authorsShort} — «{$submissionTitle}»</a><br /><b>Тип:</b> {$reviewMethod}</p><b>Срок отправки рецензии:</b> {$reviewDueDate}</p><p>Войдите в системк, чтобы <a href="{$submissionUrl}">просмотреть все задания на рецензию</a> для этого материала.</p><br><br>—<br>Это автоматическое сообщение, отправленное из журнала <a href="{$journalUrl}">«{$journalName}»</a>.'),
(112, 'REVIEW_CONFIRM', 'en', 'Review Confirm', 'Review accepted: {$reviewerName} accepted review assignment for #{$submissionId} {$authorsShort} — {$submissionTitle}', '<p>Dear {$recipientName},</p><p>{$reviewerName} has accepted the following review:</p><p><a href="{$submissionUrl}">#{$submissionId} {$authorsShort} — {$submissionTitle}</a><br /><b>Type:</b> {$reviewMethod}</p><p><b>Review Due:</b> {$reviewDueDate}</p><p>Login to <a href="{$submissionUrl}">view all reviewer assignments</a> for this submission.</p><br><br>—<br>This is an automated message from <a href="{$journalUrl}">{$journalName}</a>.'),
(113, 'REVIEW_DECLINE', 'de', 'Gutachten abgelehnt', 'Nicht in der Lage zu begutachten', 'Sehr geehrte Redakteure/innen:<br />\n<br />\nIch fürchte, dass ich die Einreichung "{$submissionTitle}" für die Zeitschrift {$journalName} zur Zeit nicht begutachten kann. Vielen Dank, dass Sie an mich gedacht haben. Sie können mich gerne ein anderes Mal kontaktieren.<br />\n<br />\n{$Absendername}'),
(114, 'REVIEW_DECLINE', 'es', 'Rechazo de la revisión', 'Rechazo la revisión', 'Editores/as:<br />\n<br />\nMe temo que en este momento no voy a poder revisar el envío &quot;{$submissionTitle},&quot; para {$journalName}. Gracias por pensar en mí, espero que vuelvan a contar conmigo en futuras ocasiones.<br />\n<br />\n{$senderName}'),
(115, 'REVIEW_DECLINE', 'fr_CA', 'Évaluation refusée', 'Refus d''évaluation', 'Rédacteurs-trices,<br />\n<br />\nPour le moment, il m''est impossible d''évaluer la soumission intitulée « {$submissionTitle} » pour la revue {$journalName}. Je vous remercie d''avoir pensé à moi. N''hésitez pas à communiquer avec moi pour un autre projet.<br />\n<br />\n{$senderName}'),
(116, 'REVIEW_DECLINE', 'it', '', 'Rifiuto dell''incarico di revisione', 'Gentili Editor,<br />\n<br />\nSono spiacente di comunicarVi che non posso attualmente accogliere la proposta di valutazione della proposta &quot;{$submissionTitle}&quot; per {$journalName}. Nella speranza di future occasioni di collaborazione, porgo cordiali saluti,<br />\n<br />\n{$senderName}'),
(117, 'REVIEW_DECLINE', 'nl', 'Review niet mogelijk', 'Review niet mogelijk', '{$recipientName}:<br />\n<br />\nIk ben bang dat ik op dit moment niet in staat ben om een review te doen van inzending &quot;{$submissionTitle}&quot; voor {$journalName}. Dank u dat u aan mij gedacht heeft en voel u vrij om op een ander moment een beroep op mij te doen.<br />\n<br />\n{$senderName}'),
(118, 'REVIEW_DECLINE', 'ru', 'Отказ от рецензирования', 'Не могу дать рецензию', 'Уважаемые редакторы!<br />\n<br />\nБоюсь, что в данный момент я не могу дать рецензию на материал «{$submissionTitle}» для журнала «{$journalName}». Благодарю вас, что обратились ко мне, в другой раз также не стесняйтесь, обращайтесь ко мне.<br />\n<br />\n{$senderName}'),
(119, 'REVIEW_DECLINE', 'en', 'Review Decline', 'Unable to Review', 'Editors:<br />\n<br />\nI am afraid that at this time I am unable to review the submission, &quot;{$submissionTitle},&quot; for {$journalName}. Thank you for thinking of me, and another time feel free to call on me.<br />\n<br />\n{$senderName}'),
(120, 'REVIEW_ACK', 'de', 'Gutachten erhalten', 'Eingangsbestätigung für Ihr Gutachten', '<p>Sehr geehrte/r {$recipientName},</p>\n<p>vielen Dank für Ihr Gutachten zum Beitrag &quot;{$submissionTitle}&quot; für die Zeitschrift {$journalName}. Ihre Stellungnahme ist eine wichtige Unterstützung für unsere Bemühungen um die Qualität der von uns veröffentlichten Arbeiten.</p>\n<p>Es war uns eine Freude, mit Ihnen als Gutachter/in für {$journalName} zusammenzuarbeiten, und wir hoffen, dass wir auch in Zukunft die Gelegenheit haben werden, mit Ihnen zusammenzuarbeiten.</p>\n<p>Mit freundlichen Grüßen,</p>\n<p>{$Unterschrift}</p>'),
(121, 'REVIEW_ACK', 'es', 'Agradecimiento por la revisión', 'Gracias por su revisión', '<p>Estimado/a {$recipientName},</p>\n<p>Gracias por completar la revisión del envío, {$submissionTitle}, para {$journalName}. Le agradecemos su tiempo y su pericia, que contribuyen a la calidad de las obras que publicamos.</p>\n<p>Ha sido un placer trabajar con usted como revisor/a para {$journalName}, y esperamos tener la oportunidad de seguir haciéndolo en el futuro.</p>\n<p>Saludos cordiales,</p>\n<p>{$signature}</p>'),
(122, 'REVIEW_ACK', 'fr_CA', 'Accusé de réception de l''évaluation', 'Accusé de réception de l''évaluation d''une soumission', '<p>{$recipientName},</p>\n<p>Nous vous remercions d''avoir évaluer la soumission, {$submissionTitle}, pour {$journalName}. Nous apprécions l''expertise et le temps que vous y avez consacrés et qui contribuent à la qualité des travaux que nous publions.</p>\n<p>Ce fut un plaisir de travailler avec vous et nous espérons avoir opportunité de le faire encore à l''avenir.</p>\n<p>Cordialement,</p>\n<p>{$signature}</p>'),
(123, 'REVIEW_ACK', 'it', '', 'Ringraziamenti per la revisione', 'Gentile {$recipientName}:<br />\n<br />\nGrazie per aver completato la revisione del manoscritto &quot;{$submissionTitle},&quot; per {$journalName}. Apprezziamo il tuo contributo nel mantenere alta la qualità della rivista.'),
(124, 'REVIEW_ACK', 'nl', 'Review Bevestiging', 'Bedankt voor uw recensie', '<p>Dear {$recipientName},</p>\n<p>Dank u voor het voltooien van uw beoordeling van de inzending, {$submissionTitle}, voor {$journalName}. We waarderen uw tijd en expertise in het bijdragen aan de kwaliteit van het werk dat we publiceren.</p>\n<p>Het was een genoegen om met u samen te werken als reviewer voor {$journalName}, en we hopen in de toekomst weer met u te kunnen samenwerken.</p>\n<p>Vriendelijke groeten,</p>\n<p>{$signature}</p>'),
(125, 'REVIEW_ACK', 'ru', 'Благодарность за рецензию', 'Благодарим за Вашу рецензию', '<p>Здравствуйте, {$recipientName}!</p>\n<p>Благодарю Вас за рецензирование материала «{$submissionTitle}» для журнала «{$journalName}». Мы ценим Ваш вклад, который способствует повышению качества публикуемых нами работ.</p>\n<p>Нам было очень приятно работать с Вами в качестве рецензента журнала «{$journalName}», и мы надеемся, что в будущем у нас еще будет возможность сотрудничать с Вами.</p>\n<p>С уважением,</p>\n<p>{$signature}</p>'),
(126, 'REVIEW_ACK', 'en', 'Review Acknowledgement', 'Thank you for your review', '<p>Dear {$recipientName},</p>\n<p>Thank you for completing your review of the submission, {$submissionTitle}, for {$journalName}. We appreciate your time and expertise in contributing to the quality of the work that we publish.</p>\n<p>It has been a pleasure to work with you as a reviewer for {$journalName}, and we hope to have the opportunity to work with you again in the future.</p>\n<p>Kind regards,</p>\n<p>{$signature}</p>'),
(127, 'REVIEW_REMIND', 'de', 'Erinnerung an das Gutachten', 'Eine Erinnerung, Ihr Gutachten bitte abzuschließen', '<p>Sehr geehrte/r {$recipientName},</p><p>nur eine freundliche Erinnerung an unsere Bitte um Ihre Begutachtung der Einreichung "{$submissionTitle}" für die Zeitschrift {$journalName}. Wir haben erwartet, dass wir diese Begutachtung bis zum {$reviewDueDate} erhalten, und würden uns freuen, sie zu bekommen, sobald Sie in der Lage sind, sie vorzubereiten.</p><p>Sie können sich <a href="{$reviewAssignmentUrl}">bei der Zeitschrift anmelden</a> und den Begutachtungsschritten folgen, um die Einreichung zu sehen, Begutachtungsdateien hochzuladen und Ihre Begutachtungskommentare einzureichen.</p><p>Wenn Sie eine Verlängerung der Frist benötigen, kontaktieren Sie mich bitte. Ich freue mich darauf, von Ihnen zu hören.</p><p>Vielen Dank im Voraus und mit freundlichen Grüßen,</p>{$signature}'),
(128, 'REVIEW_REMIND', 'es', 'Recordatorio de la revisión', 'Recordatorio para que complete la revisión', '<p>Estimado/a {$recipientName},</p><p>Esto es solo un amable recordatorio de nuestra solicitud de revisión del artículo "{$submissionTitle}" para {$journalName}. Esperábamos recibir la revisión el {$reviewDueDate}, por lo que nos complacería recibirla tan pronto como sea posible.</p><p>Puede <a href="{$reviewAssignmentUrl}">iniciar sesión en la revista</a> y seguir los pasos de revisión para ver el artículo, cargar archivos de revisión y enviar sus comentarios.</p><p>Si necesita una prórroga en la fecha límite, póngase en contacto con nosotros. Espero tener noticias suyas pronto.</p><p>Muchas gracias y cordiales saludos,</p>{$signature}'),
(129, 'REVIEW_REMIND', 'fr_CA', 'Rappel d''évaluation', 'Un rappel pour vous demander de bien vouloir terminer votre évaluation', '<p>Bonjour {$recipientName},</p><p>Ceci est un petit rappel concernant notre demande d''évaluation de la soumission « {$submissionTitle} » pour la revue {$journalName}. Nous espérions recevoir votre évaluation avant le {$reviewDueDate}. Nous serions heureux de la recevoir dès que possible.</p><p>Vous pouvez vous <a href="{$reviewAssignmentUrl}">connecter au site de la revue</a> et suivre les étapes d''évaluation afin de consulter le texte, soumettre votre fichier d''évaluation ainsi que vos commentaires. </p><p>Si vous avez besoin de plus de temps, contactez moi. Je vous remercie.</p>\n<p>Cordialement</p>{$signature}'),
(130, 'REVIEW_REMIND', 'it', '', 'Promemoria per il completamento di una revisione', '<p>Gentile {$recipientName},</p><p>Ci permettiamo di sottoporre gentilmente alla Sua attenzione un promemoria relativo alla richiesta di revisione della proposta editoriale, "{$submissionTitle}," for {$journalName}. Avremmo necessità di ricevere la sua revisione entro il {$reviewDueDate} e saremmo lieti di conoscere la Sua opinione non appena potrà comunicarcela.</p><p>Le ricordiamo che può <a href="{$reviewAssignmentUrl}">effettuare l''accesso</a> e seguire la procedura di revisione per visualizzare la proposta, per caricare i file di revisione e per inviare i commenti di revisione.</p><p>Qualora necessitasse di una proroga, non esiti a contattarci</p><p>Grazie in anticipo per la preziosa collaborazione, e con i più cordiali saluti,</p>{$signature}'),
(131, 'REVIEW_REMIND', 'nl', 'Herinnering Reviewverzoek', 'Review herinnering', '{$recipientName}:<br /><br />We willen u vriendelijk herinneren aan ons verzoek om de inzending &quot;{$submissionTitle}&quot; voor {$journalName} te reviewen. We verwachtten uw review op {$reviewDueDate}. We stellen het zeer op prijs om de review te ontvangen zodra u in de gelegenheid bent om die uit te voeren.<br /><br />Als u de gebruikersnaam en het wachtwoord van de website van het tijdschrift niet heeft, kunt u deze link gebruiken voor het herstellen van uw wachtwoord (dat samen met uw gebruikersnaam in een e-mail naar u verstuurd wordt). {$passwordLostUrl}<br /><br />URL inzending: {$reviewAssignmentUrl}<br /><br />Wilt u uw beschikbaarheid voor het voltooien van deze voor het werk van het tijdschrift vitale taak bevestigen. Ik kijk uit naar uw reactie.<br /><br />{$signature}');
INSERT INTO `email_templates_default_data` VALUES
(132, 'REVIEW_REMIND', 'ru', 'Напоминание о рецензии', 'Напоминание о необходимости завершить рецензирование', '<p>Здравствуйте, {$recipientName}!</p><p>Это напоминание о нашем запросе Вашей рецензии на материал «{$submissionTitle}» для журнала «{$journalName}». Мы надеялись получить эту рецензию до {$reviewDueDate} и будем рады, если Вы как можно скорее ее подготовите.</p><p>Вы можете <a href="{$reviewAssignmentUrl}">войти в систему</a> и следовать шагам процесса рецензирования: просмотреть материал, загрузить файлы рецензии и отправить Ваши комментарии по рецензии.</p><p>Если Вам нужно продлить срок отправки рецензии, пожалуйста, свяжитесь со мной. Жду вашего ответа.</p><p>Заранее спасибо и с уважением,</p>{$signature}'),
(133, 'REVIEW_REMIND', 'en', 'Review Reminder', 'A reminder to please complete your review', '<p>Dear {$recipientName},</p><p>Just a gentle reminder of our request for your review of the submission, "{$submissionTitle}," for {$journalName}. We were expecting to have this review by {$reviewDueDate} and we would be pleased to receive it as soon as you are able to prepare it.</p><p>You can <a href="{$reviewAssignmentUrl}">login to the journal</a> and follow the review steps to view the submission, upload review files, and submit your review comments.</p><p>If you need an extension of the deadline, please contact me. I look forward to hearing from you.</p><p>Thank you in advance and kind regards,</p>{$signature}'),
(134, 'REVIEW_REMIND_AUTO', 'de', 'Erinnerung an das Gutachten (Automatisiert)', 'Eine Erinnerung, Ihr Gutachten bitte abzuschließen', '<p>Sehr geehrte/r {$recipientName}</p><p>Diese E-Mail ist eine automatische Erinnerung von {$journalName} in Bezug auf unsere Bitte um Ihre Begutachtung der Einreichung "{$submissionTitle}"</p><p>Wir haben Ihr Gutachten bis zum {$reviewDueDate} erwartet und würden uns freuen, es zu erhalten, sobald Sie es vorbereiten können. </p><p>Bitte <a href="{$reviewAssignmentUrl}">melden Sie sich bei der Zeitschrift an</a> und folgen Sie den Begutachtungsschritten, um die Einreichung einzusehen, die Begutachtungsdateien hochzuladen und Ihre Begutachtungskommentare abzugeben.</p><p>Wenn Sie eine Verlängerung der Frist benötigen, setzen Sie sich bitte mit mir in Verbindung. Ich freue mich darauf, von Ihnen zu hören.</p><p>Vielen Dank im Voraus und mit freundlichen Grüßen,</p>{$journalSignature}'),
(135, 'REVIEW_REMIND_AUTO', 'es', 'Recordatorio de revisión (automático)', 'Recordatorio para que complete su revisión', '<p>Estimado/a {$recipientName}:</p><p>Este correo electrónico es un recordatorio automático de {$journalName} en relación con nuestra solicitud de revisión del envío "{$submissionTitle}".</p><p>Esperábamos disponer de esta revisión el {$reviewDueDate} y nos complacería recibirla tan pronto como sea posible.</p><p>Por favor, <a href="{$reviewAssignmentUrl}">inicie sesión en la revista</a> y siga los pasos de revisión para ver el artículo, cargar archivos de revisión y enviar sus comentarios de revisión.</p><p>Si necesita una extensión de la fecha límite, póngase en contacto con nosotros. Espero tener noticias suyas pronto.</p><p>Muchas gracias y saludos cordiales,</p>{$journalSignature}'),
(136, 'REVIEW_REMIND_AUTO', 'fr_CA', 'Rappel automatique d''évaluation', 'Un rappel automatique pour vous demander de bien vouloir terminer votre évaluation', '<p>{$recipientName},</p><p>Ceci est un rappel automatisé concernant notre demande d''évaluation de la soumission « {$submissionTitle} » pour la revue {$journalName}. Puisque nous n''avons pas reçu, comme nous l''espérions, votre évaluation avant le {$reviewDueDate}, ce courriel a été généré et envoyé automatiquement après l''échéance du délai. Nous serions toutefois heureux de recevoir votre évaluation dès que possible.</p><p>S''il vous plait, <a href="{$reviewAssignmentUrl}">connectez-vous à la revue</a> et suivez les étapes d''évaluation afin de consulter le texte et soumettre votre fichier d''évaluation ainsi que vos commentaires.</p><p>Si vous avez besoin d''un délai supplémentaire, n''hésitez pas à me contacter.</p><p>Je vous remercie. <br/>Cordialement, </p>{$journalSignature}'),
(137, 'REVIEW_REMIND_AUTO', 'it', '', 'Promemoria per il completamento di una revisione', '<p>Gentile {$recipientName},</p><p>Questa e-mail è un promemoria automatico da parte di {$journalName} per la richiesta di revisione della proposta editoriale, "{$submissionTitle}".</p><p> Avremmo necessità di ricevere la sua revisione entro il {$reviewDueDate} e saremmo lieti di conoscere la Sua opinione non appena potrà comunicarcela.</p><p>Le ricordiamo che può <a href="{$reviewAssignmentUrl}">effettuare l''accesso</a> e seguire la procedura di revisione per visualizzare la proposta, per caricare i file di revisione e per inviare i commenti di revisione.</p><p>Qualora necessitasse di una proroga, non esiti a contattarci</p><p>Grazie in anticipo per la preziosa collaborazione, e con i più cordiali saluti,</p>{$journalSignature}'),
(138, 'REVIEW_REMIND_AUTO', 'nl', 'Herinnering Reviewverzoek (geautomatiseerd)', 'Geautomatiseerde review herinnering', '{$recipientName}:<br />\n<br />\nWe willen u vriendelijk herinneren aan ons verzoek om de inzending &quot;{$submissionTitle}&quot; voor {$journalName} te reviewen. We verwachtten uw review op {$reviewDueDate}. We stellen het zeer op prijs om de review te ontvangen zodra u in de gelegenheid bent om die uit te voeren.<br />\n<br />\nAls u de gebruikersnaam en het wachtwoord van de website van het tijdschrift niet heeft, kunt u deze link gebruiken voor het herstellen van uw wachtwoord (dat samen met uw gebruikersnaam in een e-mail naar u verstuurd wordt). {$passwordLostUrl}<br />\n<br />\nURL inzending: {$reviewAssignmentUrl}<br />\n<br />\nWilt u uw beschikbaarheid voor het voltooien van deze voor het werk van het tijdschrift vitale taak bevestigen. Ik kijk uit naar uw reactie.<br />\n<br />\n{$journalSignature}'),
(139, 'REVIEW_REMIND_AUTO', 'ru', 'Напоминание о рецензии (автоматическое)', 'Напоминание о необходимости завершить рецензирование', '<p>Здравствуйте, {$recipientName}!</p><p>Это письмо — автоматическое напоминание из журнала «{$journalName}» о нашем запросе Вашей рецензии на материал «{$submissionTitle}».</p><p>Мы ожидали получить Вашу рецензию до {$reviewDueDate} и мы будем рады получить её, если Вы как можно скорее ее подготовите.</p><p>Пожалуйста, <a href="{$reviewAssignmentUrl}">войдите в систему</a> и следуйте шагам процесса рецензирования, чтобы просмотреть материал, загрузить файлы рецензии и отправить Ваши комментарии по рецензии.</p><p>Если Вам нужно продлить срок отправки рецензии, пожалуйста, свяжитесь со мной. Жду вашего ответа.</p><p>Заранее спасибо и с уважением,</p>{$journalSignature}'),
(140, 'REVIEW_REMIND_AUTO', 'en', 'Review Reminder (Automated)', 'A reminder to please complete your review', '<p>Dear {$recipientName}:</p><p>This email is an automated reminder from {$journalName} in regards to our request for your review of the submission, "{$submissionTitle}."</p><p>We were expecting to have this review by {$reviewDueDate} and we would be pleased to receive it as soon as you are able to prepare it.</p><p>Please <a href="{$reviewAssignmentUrl}">login to the journal</a> and follow the review steps to view the submission, upload review files, and submit your review comments.</p><p>If you need an extension of the deadline, please contact me. I look forward to hearing from you.</p><p>Thank you in advance and kind regards,</p>{$journalSignature}'),
(141, 'REVIEW_COMPLETE', 'de', 'Gutachten abgeschlossen', 'Gutachten abgeschlossen: {$reviewerName} empfiehlt {$reviewRecommendation} für #{$submissionId} {$authorsShort} - {$submissionTitle}', '<p>Sehr geehrte/r {$recipientName},</p><p>{$reviewerName} hat die folgende Überprüfung abgeschlossen:</p><p><a href="{$submissionUrl}">#{$submissionId} {$authorsShort} — {$submissionTitle}</a><br /><b>Empfehlung:</b> {$reviewRecommendation}<br /><b>Gutachtenmethode:</b> {$reviewMethod}</p><p>Melden Sie sich an, um <a href="{$submissionUrl}">alle Dateien und Kommentare</a> dieses Gutachters/dieser Gutachterin zu sehen.</p>'),
(142, 'REVIEW_COMPLETE', 'es', 'Revisión finalizada', 'Revisión completada: {$reviewerName} recomienda {$reviewRecommendation} para #{$submissionId} {$authorsShort} — {$submissionTitle}', ''),
(143, 'REVIEW_COMPLETE', 'fr_CA', 'Évaluation terminée', 'Évaluation terminée: {$reviewerName} recommande {$reviewRecommendation} pour #{$submissionId} {$authorsShort} — {$submissionTitle}', '<p>{$recipientName},</p><p>{$reviewerName} a terminé son évaluation :</p><p><a href="{$submissionUrl}">#{$submissionId} {$authorsShort} — {$submissionTitle}</a><br /><b>Recommandation :</b> {$reviewRecommendation}<br /><b>Type :</b> {$reviewMethod}</p><p>Connectez-vous <a href="{$submissionUrl}">afin de consulter les commentaires</a> de l''évaluateur-trice.</p>'),
(144, 'REVIEW_COMPLETE', 'it', '', '', ''),
(145, 'REVIEW_COMPLETE', 'nl', 'Review Voltooid', 'Beoordeling voltooid: {$reviewerName} beveelt {$reviewRecommendation} aan voor #{$submissionId} {$authorsShort} — {$submissionTitle}', '<p>Beste {$recipientName},</p><p>{$reviewerName} heeft de volgende beoordeling voltooid:</p><p><a href="{$submissionUrl}">#{$submissionId} {$authorsShort} — {$submissionTitle}</a><br /><b>Aanbeveling:</b> {$reviewRecommendation}<br /><b>Type:</b> {$reviewMethod}</p><p>Log in om <a href="{$submissionUrl}">alle bestanden en opmerkingen</a> te bekijken die door deze beoordelaar zijn verstrekt.</p>'),
(146, 'REVIEW_COMPLETE', 'ru', 'Рецензия завершена', 'Рецензирование завершено: {$reviewerName} рекомендует {$reviewRecommendation} для #{$submissionId} {$authorsShort} — «{$submissionTitle}»', '<p>Здравствуйте, {$recipientName}!</p><p>Рецензент {$reviewerName} завершил следующую рецензию:</p><p><a href="{$submissionUrl}">#{$submissionId} {$authorsShort} — «{$submissionTitle}»</a><br /><b>Рекомендация:</b> {$reviewRecommendation}<br /><b>Тип:</b> {$reviewMethod}</p><p>Войдите в систему, чтобы <a href="{$submissionUrl}">просмотреть все файлы и комментарии</a>, предоставленные этим рецензентом.</p>'),
(147, 'REVIEW_COMPLETE', 'en', 'Review Completed', 'Review complete: {$reviewerName} recommends {$reviewRecommendation} for #{$submissionId} {$authorsShort} — {$submissionTitle}', '<p>Dear {$recipientName},</p><p>{$reviewerName} completed the following review:</p><p><a href="{$submissionUrl}">#{$submissionId} {$authorsShort} — {$submissionTitle}</a><br /><b>Recommendation:</b> {$reviewRecommendation}<br /><b>Type:</b> {$reviewMethod}</p><p>Login to <a href="{$submissionUrl}">view all files and comments</a> provided by this reviewer.</p>'),
(148, 'REVIEW_EDIT', 'de', 'Gutachten bearbeitet', 'Ihre Zuweisung für ein Gutachten für {$journalName} wurde geändert', '<p>Sehr geehrte/r {$recipientName},</p><p>Ein Redakteur/eine Redakteurin hat Änderungen an Ihrer Überprüfungsaufgabe für {$journalName} vorgenommen. Bitte überprüfen Sie die folgenden Details und lassen Sie uns wissen, wenn Sie Fragen haben.</p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a><br /><b>Gutachtenmethode:</b> {$reviewMethod}<br /><b>Annehmen oder Ablehnen bis:</b> {$responseDueDate}<br /><b>Gutachteneinreichung bis:</b> {$reviewDueDate}</p><p>Sie können sich jederzeit anmelden, um <a href="{$reviewAssignmentUrl}">diese Überprüfung abzuschließen</a>.</p>'),
(149, 'REVIEW_EDIT', 'es', 'Revisión editada', 'Se ha modificado su asignación de revisión para {$journalName}', ''),
(150, 'REVIEW_EDIT', 'fr_CA', '', '', '<p>{$recipientName},</p><p>Un-e rédacteur-trice a modifié l''assignation de votre évaluation pour {$journalName}. S''il vous plaît, consulter les détails ci-dessous et n''hésitez pas à nous contacter si vous avez des questions.</p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a><br /><b>Type :</b> {$reviewMethod}<br /><b>Accepté ou rejeté avant le :</b> {$responseDueDate}<br /><b>Évaluation soumise avant le :</b> {$reviewDueDate}</p><p>Vous pouvez vous connectez afin de <a href="{$reviewAssignmentUrl}">terminer cette évaluation</a>.</p>'),
(151, 'REVIEW_EDIT', 'it', '', '', ''),
(152, 'REVIEW_EDIT', 'nl', 'Review aangepast', 'Je beoordelingsopdracht is gewijzigd voor {$journalName}', '<p>Beste {$recipientName},</p><p>Een redacteur heeft wijzigingen aangebracht in je beoordelingsopdracht voor {$journalName}. Bekijk alsjeblieft de details hieronder en laat het ons weten als je vragen hebt.</p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a><br /><b>Type:</b> {$reviewMethod}<br /><b>Accepteer of Wijs Af Voor:</b> {$responseDueDate}<br /><b>Beoordeling Indienen Voor:</b> {$reviewDueDate}</p><p>Je kunt inloggen om <a href="{$reviewAssignmentUrl}">deze beoordeling te voltooien</a> op elk gewenst moment.</p>'),
(153, 'REVIEW_EDIT', 'ru', 'Рецензия отредактирована', 'Изменилось Ваше задание на рецензию для журнала «{$journalName}»', '<p>Здравствуйте, {$recipientName}!</p><p>Редактор изменил Ваше задание на рецензирование для журнала «{$journalName}». Пожалуйста, ознакомьтесь с приведенной ниже информацией и сообщите нам, если у Вас возникнут вопросы.</p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a><br /><b>Тип:</b> {$reviewMethod}<br /><b>Принять или отклонить до:</b> {$responseDueDate}<br /><b>Отправить рецензию до:</b> {$reviewDueDate}</p><p>Вы можете войти в систему, чтобы <a href="{$reviewAssignmentUrl}">выполнить эту рецензию</a> в любой момент.</p>'),
(154, 'REVIEW_EDIT', 'en', 'Review Edited', 'Your review assignment has been changed for {$journalName}', '<p>Dear {$recipientName},</p><p>An editor has made changes to your review assignment for {$journalName}. Please review the details below and let us know if you have any questions.</p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a><br /><b>Type:</b> {$reviewMethod}<br /><b>Accept or Decline By:</b> {$responseDueDate}<br /><b>Submit Review By:</b> {$reviewDueDate}</p><p>You can login to <a href="{$reviewAssignmentUrl}">complete this review</a> at any time.</p>'),
(155, 'EDITOR_DECISION_ACCEPT', 'de', 'Einreichung akzeptiert', 'Ihre Einreichung wurde bei {$journalName} angenommen', '<p>Sehr geehrte/r {$recipientName},</p><p>ich freue mich, Ihnen mitteilen zu können, dass wir beschlossen haben, Ihre Einreichung ohne weitere Überarbeitung zu akzeptieren. Nach sorgfältiger Prüfung haben wir festgestellt, dass Ihr Beitrag {$submissionTitle} unsere Erwartungen erfüllt oder sogar übertrifft. Wir freuen uns, Ihren Beitrag in {$journalName} zu veröffentlichen, und danken Ihnen, dass Sie unsere Zeitschrift als Ort für Ihre Arbeit gewählt haben.</p><p>Ihr Beitrag wird nun in einer zukünftigen Ausgabe von {$journalName} erscheinen, und Sie können ihn gerne in Ihre Liste der Veröffentlichungen aufnehmen. Wir erkennen die harte Arbeit an, die in jeder erfolgreichen Einreichung steckt, und wir möchten Ihnen dazu gratulieren, dass Sie dieses Stadium erreicht haben.</p><p>Ihre Einreichung wird nun redaktionell bearbeitet und formatiert, um sie für die Veröffentlichung vorzubereiten.</p><p>Sie werden in Kürze weitere Anweisungen erhalten.</p><p>Wenn Sie Fragen haben, kontaktieren Sie mich bitte über Ihr <a href="{$authorSubmissionUrl}">Einreichungs-Dashboard</a>.</p><p>Mit freundlichen Grüßen,</p>{$signature}'),
(156, 'EDITOR_DECISION_ACCEPT', 'es', 'Envío aceptado', 'Su envío a {$journalName} ha sido aceptado', '<p>Estimado/a {$recipientName},</p><p>Nos complace informarle de que hemos decidido aceptar su envío sin necesidad de realizar más revisiones. Tras una minuciosa revisión le confirmamos que su artículo "{$submissionTitle}" cumple o supera nuestras expectativas. Estamos entusiasmados por publicar su trabajo en {$journalName} y le agradecemos que haya elegido nuestra revista como hogar de su obra.</p><p>Su envío se publicará en un número futuro de {$journalName}, le invitamos a incluirlo en su lista de publicaciones. Reconocemos el arduo trabajo que conlleva cada envío exitoso, así que queremos felicitarlo por haber alcanzado esta fase.</p><p>Ahora su envío será sometido a edición y formateo para prepararlo para su publicación.</p><p>Pronto recibirá más instrucciones.</p><p>Si tiene alguna pregunta, póngase en contacto con nosotros a través del <a href="{$authorSubmissionUrl}">panel de envío</a>.</p><p>Atentamente,</p>{$signature}'),
(157, 'EDITOR_DECISION_ACCEPT', 'fr_CA', 'Soumission acceptée', 'Votre soumission a été acceptée dans la revue {$journalName}', '<p>Bonjour {$authors},</p><p>Nous avons pris une décision concernant votre soumission « {$submissionTitle} » à la revue {$journalName}.</p><p>Notre décision est d''accepter votre soumission.</p><p>Cordialement,</p>{$signature}'),
(158, 'EDITOR_DECISION_ACCEPT', 'it', '', 'La Sua proposta è stata accettata per la pubblicazione su {$journalName}', '<p>Gentile {$recipientName},</p><p>Siamo lieti di comunicarLe che la Sua proposta editoriale è stata ritenuta idonea alla pubblicazione senza necessità di ulteriori revisioni. Dopo attenta valutazione, abbiamo infatti rinvenuto che la Sua proposta, {$submissionTitle}, soddisfi pienamente le nostre aspettative. Siamo pertanto entusiasti di poter pubblicare il Suo lavoro su {$journalName} e La ringraziamo per aver scelto la nostra rivista come sede di pubblicazione.</p><p>Il contributo sarà dunque pubblicato in un futuro numero di {$journalName} e La preghiamo di considerare tale e-mail come conferma. Siamo consapevoli dell''impegnativo lavoro necessario ai fini di ogni proposta editoriale di successo e pertanto desideriamo complimentarci per aver ottenuto tale risultato .</p><p>Il Suo contributo sarà ora sottoposto a un processo di copy-editing e sarà formattato ai fini della pubblicazione.</p><p>Riceverà entro breve, a tal proposito, ulteriori indicazioni.</p><p>In caso di necessità o quesiti, non esiti a contattarci tramite la Sua area di<a href="{$authorSubmissionUrl}">gestione delle proposte</a>.</p><p>Con i più cordiali saluti,</p>{$signature}'),
(159, 'EDITOR_DECISION_ACCEPT', 'nl', 'Inzending Geaccepteerd', 'Redacteursbeslissing', '{$authors}:<br />\n<br />\nWe hebben een beslissing genomen over uw inzending voor {$journalName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nOnze beslissing is: Accepteer inzending'),
(160, 'EDITOR_DECISION_ACCEPT', 'ru', 'Материал принят', 'Ваш материал был принят в «{$journalName}»', '<p>Здравствуйте, {$recipientName}!</p><p> Хочу Вам с радостью сообщить, что мы решили принять Ваш материал без дополнительной доработки. После тщательного рецензирования мы полагаем, что Ваш материал «{$submissionTitle}» соответствует или превосходит наши ожидания. Мы с удовольствием опубликуем его в «{$journalName}» и благодарим Вас за выбор нашего журнала для публикации.</p><p>Ваш материал будет опубликован в одном из будущих выпусков журнала «{$journalName}» и Вы сможете включить его в список своих публикаций. Мы понимаем, что каждый успешный материал — это тяжелая работа, и хотим поздравить Вас с достижением этого этапа.</p><p>Далее Ваш материал пройдёт этапы литературного редактирования и вёрстки, чтобы подготовить его к публикации.</p><p>Вскоре Вы получите дальнейшие инструкции.</p><p>Если у Вас есть какие-то вопросы, пожалуйста, свяжитесь со мной через <a href="{$authorSubmissionUrl}">страницу Вашего материала</a>.</p><p>С уважением,</p>{$signature}'),
(161, 'EDITOR_DECISION_ACCEPT', 'en', 'Submission Accepted', 'Your submission has been accepted to {$journalName}', '<p>Dear {$recipientName},</p><p>I am pleased to inform you that we have decided to accept your submission without further revision. After careful review, we found your submission, {$submissionTitle}, to meet or exceed our expectations. We are excited to publish your piece in {$journalName} and we thank you for choosing our journal as a venue for your work.</p><p>Your submission is now forthcoming in a future issue of {$journalName} and you are welcome to include it in your list of publications. We recognize the hard work that goes into every successful submission and we want to congratulate you on reaching this stage.</p><p>Your submission will now undergo copy editing and formatting to prepare it for publication.</p><p>You will shortly receive further instructions.</p><p>If you have any questions, please contact me from your <a href="{$authorSubmissionUrl}">submission dashboard</a>.</p><p>Kind regards,</p>{$signature}'),
(162, 'EDITOR_DECISION_SEND_TO_EXTERNAL', 'de', 'Zur Begutachtung geschickt', 'Ihr Beitrag wurde zur Überprüfung gesendet', '<p>Sehr geehrte/r {$recipientName},</p><p>Ich freue mich, Ihnen mitzuteilen, dass ein Redakteur/eine Redakteurin Ihre Einreichung {$submissionTitle} begutachtet hat und beschlossen hat, sie zur Begutachtung zu schicken. Ein Redakteur/eine Redakteurin wird qualifizierte Gutachter/Gutachterinnen benennen, die ein Feedback zu Ihrer Einreichung geben werden.</p><p>{$reviewTypeDescription} Sie erhalten von uns eine Rückmeldung von den Gutachter/Gutachterinnen und Informationen über die nächsten Schritte.</p><p>Bitte beachten Sie, dass die Einsendung des Beitrags zur Begutachtung keine Garantie dafür ist, dass er veröffentlicht wird. Wir werden die Empfehlungen der Gutachter/innen berücksichtigen, bevor wir entscheiden, ob der Beitrag zur Veröffentlichung angenommen wird. Es kann sein, dass Sie aufgefordert werden, den Beitrag zu überarbeiten und auf die Kommentare der Gutachter/innen zu antworten, bevor eine endgültige Entscheidung getroffen wird.</p><p>Wenn Sie Fragen haben, wenden Sie sich bitte über das Dashboard Ihres Beitrags an mich.</p><p>{$signature}</p>'),
(163, 'EDITOR_DECISION_SEND_TO_EXTERNAL', 'es', 'Enviar a revisión', 'Su envío se ha enviado a revisión', '<p>Estimado/a {$recipientName},</p><p>Me complace anunciarle que un editor/a ha revisado su envío, {$submissionTitle}, y ha decidido remitirlo a evaluación por pares. El editor/a identificará a revisores/as cualificados que aportarán comentarios sobre su envío.</p><p>{$reviewTypeDescription} Le enviaremos dichos comentarios y la información acerca de los próximos pasos.</p><p>Tenga en cuenta que el hecho de enviar su artículo a evaluación por pares no garantiza que se acabe publicando. Consideraremos las recomendaciones de los revisores/as antes de decidir si aceptamos el envío para publicarse. Podríamos solicitarle que haga revisiones y responda a los comentarios de los revisores/as antes de tomar la decisión final.</p><p>Si tiene cualquier duda puede contactar con nosotros desde su panel de control del envío.</p><p>{$signature}</p>'),
(164, 'EDITOR_DECISION_SEND_TO_EXTERNAL', 'fr_CA', 'Envoyé à l''évaluation', 'Votre manuscrit a été envoyé en évaluation', '<p>{$recipientName},</p><p>Nous sommes heureux de vous annoncer qu''un-e redacteur-trice à évaluer votre manuscrit, {$submissionTitle}, et a décidé de l''envoyer en évaluation. Un-e redacteur-trice identifiera des évaluateurs-trices qui feront des commentaires sur votre manuscrit.</p><p>{$reviewTypeDescription} Nous vous ferons part de leurs commentaires et vous informerons des prochaines étapes par la suite.</p><p>S''il vous plait, prenez en considération que le fait d''envoyer votre manuscrit en évaluation ne garantit en rien le fait d''être publié. Nous prendrons en considération les recommandations des évaluateurs avant de décider de publier votre manuscrit.</p><p>Si vous avez des questions, vous pouvez nous contacter à partir de votre <a href="{$authorSubmissionUrl}">tableau de bord de soumission</a>.</p><p>{$signature}</p>'),
(165, 'EDITOR_DECISION_SEND_TO_EXTERNAL', 'it', '', 'Decisione dell''editor', 'Gentilissimo {$authors}:<br />\n<br />\nAbbiamo preso una decisione circa la tua proposta a {$journalName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nLa nostra decisione: invio a un revisore esterno<br />\n<br />\nSubmission URL: {$submissionUrl}'),
(166, 'EDITOR_DECISION_SEND_TO_EXTERNAL', 'nl', 'Verzonden naar Review', 'Redacteursbeslissing', '<p>Beste {$recipientName},</p>\n<p>Ik ben verheugd u mee te delen dat een redacteur uw inzending, {$submissionTitle}, heeft beoordeeld en heeft besloten deze naar peer review te sturen. Een redacteur zal gekwalificeerde beoordelaars identificeren die feedback zullen geven op uw inzending.</p>\n<p>{$reviewTypeDescription} U zult van ons horen met feedback van de beoordelaars en informatie over de volgende stappen.</p>\n<p>Houd er rekening mee dat het verzenden van de inzending naar peer review niet garandeert dat deze zal worden gepubliceerd. We zullen de aanbevelingen van de beoordelaars overwegen voordat we beslissen om de inzending te accepteren voor publicatie. Het kan zijn dat u gevraagd wordt om wijzigingen aan te brengen en te reageren op de opmerkingen van de beoordelaars voordat er een definitieve beslissing wordt genomen.</p>\n<p>Als u vragen heeft, neem dan contact met mij op via uw inzending dashboard.</p>\n<p>{$signature}</p>'),
(167, 'EDITOR_DECISION_SEND_TO_EXTERNAL', 'ru', 'Отправка на рецензию', 'Ваш материал был отправлен на рецензию', '<p>Здравствуйте, {$recipientName}!</p><p>Рады сообщить вам, что редактор рассмотрел Ваш материал «{$submissionTitle}» и решил отправить его на рецензирование. Редактор определит квалифицированных рецензентов, которые предоставят рецензии на Вашу работу.</p><p>{$reviewTypeDescription} Вы получите от нас сообщение с отзывами рецензентов и информацией о дальнейших шагах.</p><p>Обратите внимание, что отправка материала на рецензирование не гарантирует его публикацию. Мы рассмотрим рекомендации рецензентов, прежде чем примем решение о принятии материала к публикации. Вам может быть предложено внести изменения в матери ал и ответить на комментарии рецензентов, прежде чем будет принято окончательное решение.</p><p>Если у вас есть какие-либо вопросы, пожалуйста, свяжитесь со мной через страницу Вашего материала.</p><p>{$signature}</p>'),
(168, 'EDITOR_DECISION_SEND_TO_EXTERNAL', 'en', 'Sent to Review', 'Your submission has been sent for review', '<p>Dear {$recipientName},</p><p>I am pleased to inform you that an editor has reviewed your submission, {$submissionTitle}, and has decided to send it for peer review. An editor will identify qualified reviewers who will provide feedback on your submission.</p><p>{$reviewTypeDescription} You will hear from us with feedback from the reviewers and information about the next steps.</p><p>Please note that sending the submission to peer review does not guarantee that it will be published. We will consider the reviewers'' recommendations before deciding to accept the submission for publication. You may be asked to make revisions and respond to the reviewers'' comments before a final decision is made.</p><p>If you have any questions, please contact me from your submission dashboard.</p><p>{$signature}</p>'),
(169, 'EDITOR_DECISION_SEND_TO_PRODUCTION', 'de', 'In die Produktion geschickt', 'Nächste Schritte zur Veröffentlichung Ihres Beitrags', '<p>Sehr geehrte/r {$recipientName},</p><p>ich schreibe Ihnen von {$journalName}, um Ihnen mitzuteilen, dass die Bearbeitung Ihrer Einreichung {$submissionTitle} abgeschlossen ist. Ihre Einreichung geht nun in die Produktionsphase über, in der die endgültigen Druckfahnen für die Veröffentlichung vorbereitet werden. Wir werden uns mit Ihnen in Verbindung setzen, wenn wir weitere Unterstützung benötigen.</p><p>Wenn Sie Fragen haben, kontaktieren Sie mich bitte über das <a href="{$authorSubmissionUrl}">Dashboard Ihrer Einreichung</a>.</p><p>Mit freundlichen Grüßen,</p>{$signature}'),
(170, 'EDITOR_DECISION_SEND_TO_PRODUCTION', 'es', 'Enviar a producción', 'Próximos pasos para publicar su envío', '<p>Estimado/a {$recipientName},</p><p>Le escribo de {$journalName} para informarle de que la edición de su envío, {$submissionTitle}, ha finalizado. Ahora su envío avanzará a la fase de producción, donde prepararemos las galeradas finales para su publicación. Nos pondremos en contacto con usted si necesitamos más ayuda.</p><p>Si tiene cualquier duda contacte con nosotros desde su <a href="{$authorSubmissionUrl}">panel de control del envío</a>.</p><p>Saludos cordiales,</p>{$signature}'),
(171, 'EDITOR_DECISION_SEND_TO_PRODUCTION', 'fr_CA', 'Envoyé en production', 'Décision du rédacteur', '<p>{$recipientName},</p><p>Je vous écris de la part de {$journalName} afin de vous confirmer que la révision de votre soumission, {$submissionTitle}, est terminée. Votre soumission sera envoyée à l''étape de production, nous procéderons à la mise en page avant publication. Nous vous contacterons au besoin.</p><p>Si vous avez des questions, vous pouvez nous rejoindre à partir du <a href="{$authorSubmissionUrl}">tableau de bord de votre soumission</a>.</p><p>Cordialement,</p>{$signature}'),
(172, 'EDITOR_DECISION_SEND_TO_PRODUCTION', 'it', '', 'Decisione dell''editor', 'Gentilissimo {$authors}:<br />\n<br />\nLa lavorazione editoriale della sua proposta, &quot;{$submissionTitle},&quot; è completa.  Ora viene preparata per l''uscita sulla rivista.<br />\n<br />\nURL proposta: {$submissionUrl}'),
(173, 'EDITOR_DECISION_SEND_TO_PRODUCTION', 'nl', 'Verzonden naar Productie', 'Volgende stappen voor het publiceren van uw inzending', '<p>Beste {$recipientName},</p>\n<p>Ik schrijf u namens {$journalName} om u te laten weten dat de bewerking van uw inzending, {$submissionTitle}, is voltooid. Uw inzending gaat nu naar de productiefase, waar de definitieve drukproeven zullen worden voorbereid voor publicatie. We nemen contact met u op als we verdere hulp nodig hebben.</p>\n<p>Als u vragen heeft, neem dan contact met mij op via uw <a href="{$authorSubmissionUrl}">inzending dashboard</a>.</p>\n<p>Met vriendelijke groet,</p>\n<p>{$signature}</p>'),
(174, 'EDITOR_DECISION_SEND_TO_PRODUCTION', 'ru', 'Отправка на подготовку к публикации', 'Следующие шаги для публикации Вашего материала', '<p>Здравствуйте, {$recipientName}!</p><p>Пишу Вам от имени журнала «{$journalName}» и хочу сообщить, что редактирование Вашего материала «{$submissionTitle}» завершено. Ваш материал далее переходит на этап публикации, где будут подготовлены финальные гранки Вашего материала. Мы свяжемся с Вами, если нам потребуется Ваша помощь.</p><p>Если у Вас есть какие-то вопросы, пожалуйста, свяжитесь со мной через <a href="{$authorSubmissionUrl}">страницу Вашего материала</a>.</p><p>С уважением,</p>{$signature}'),
(175, 'EDITOR_DECISION_SEND_TO_PRODUCTION', 'en', 'Sent to Production', 'Next steps for publishing your submission', '<p>Dear {$recipientName},</p><p>I am writing from {$journalName} to let you know that the editing of your submission, {$submissionTitle}, is complete. Your submission will now advance to the production stage, where the final galleys will be prepared for publication. We will contact you if we need any further assistance.</p><p>If you have any questions, please contact me from your <a href="{$authorSubmissionUrl}">submission dashboard</a>.</p><p>Kind regards,</p>{$signature}'),
(176, 'EDITOR_DECISION_REVISIONS', 'de', 'Überarbeitungen angefordert', 'Ihr Beitrag wurde geprüft. Bitte reichen Sie Überarbeitungen ein', '<p>Sehr geehrte/r {$recipientName},</p><p>Ihre Einreichung {$submissionTitle} wurde begutachtet und wir möchten Sie auffordern, Überarbeitungen einzureichen, die auf die Kommentare der Gutachter/innen eingehen. Ein Redakteur/eine Redakteurin wird diese Überarbeitungen prüfen, und wenn sie die Bedenken hinreichend berücksichtigen, kann Ihr Beitrag zur Veröffentlichung angenommen werden.</p><p>Die Kommentare der Gutachter/innen sind am Ende dieser E-Mail enthalten. Bitte gehen Sie auf jeden Punkt in den Kommentaren der Reviewer ein und geben Sie an, welche Änderungen Sie vorgenommen haben. Wenn Sie einen der Kommentare für ungerechtfertigt oder unangemessen halten, erläutern Sie bitte Ihren Standpunkt.</p><p>Wenn Sie Ihre Überarbeitungen abgeschlossen haben, können Sie die überarbeiteten Dokumente zusammen mit Ihrer Antwort auf die Kommentare der Prüfer im <a href=„{$authorSubmissionUrl}“>Dashboard Ihrer Einreichung</a> hochladen. Wenn Sie abgemeldet waren, können Sie sich erneut mit dem Benutzernamen {$recipientUsername} anmelden.</p><p>Wenn Sie Fragen haben, kontaktieren Sie mich bitte über das <a href=„{$authorSubmissionUrl}“>Dashboard Ihrer Einreichung</a>.</p><p>Wir freuen uns auf Ihre überarbeitete Eingabe.</p><p>Mit freundlichen Grüßen,</p>{$signature}<hr><p>Die folgenden Kommentare wurden von den Gutachter/innen abgegeben.</p>{$allReviewerComments}'),
(177, 'EDITOR_DECISION_REVISIONS', 'es', 'Revisiones solicitadas', 'Su envío se ha revisado y le animamos a que tramite sus revisiones', '<p>Estimado/a {$recipientName},</p><p>Su envío {$submissionTitle} ha sido revisado y nos gustaría animarlo a que nos remita las revisiones que respondan a los comentarios de los revisores/as. Un editor/a examinará dichas revisiones y, si resuelven adecuadamente los problemas, su envío podrá ser aceptado para publicarse.</p><p>Los comentarios de los revisores/as se incluyen al final de este correo electrónico. Responda a cada uno de los punto de los comentarios de los revisores/as e identifique los cambios que haya hecho. Si considera que alguno de los comentarios de los revisores/as no está justificado o es inapropiado, explíquenos su punto de vista.</p><p>Cuando haya completado las revisiones puede cargar los documentos revisados, junto con la respuesta a los comentarios de los revisores/as, en su <a href="{$authorSubmissionUrl}">panel de control del envío</a>. Si ha cerrado la sesión puede volver a iniciarla con su nombre de usuario/a {$recipientUsername}.</p><p>Si tiene cualquier pregunta no dude en contactarnos desde su <a href="{$authorSubmissionUrl}">panel de control del envío</a>.</p><p>Quedamos a la espera de recibir su envío revisado.</p><p>Saludos cordiales,</p>{$signature}<hr><p>Se recibieron los siguientes comentarios de los revisores/as.</p>{$allReviewerComments}'),
(178, 'EDITOR_DECISION_REVISIONS', 'fr_CA', 'Révisions demandées', 'Décision du rédacteur', '{$authors},<br />\n<br />\nNous avons pris une décision concernant votre soumission « {$submissionTitle} » à la revue {$journalName}.<br />\n<br />\nNotre décision est de vous demander d''apporter des révisions à votre soumission.'),
(179, 'EDITOR_DECISION_REVISIONS', 'it', '', 'Decisione dell''editor', '&lt;![CDATA[{$authors}:<br />\n<br />\nAbbiamo raggiunto una decisione sulla Sua proposta a {$journalName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nLa nostra decisione: è necessaria ciclo di peer-review'),
(180, 'EDITOR_DECISION_REVISIONS', 'nl', 'Revisies Gevraagd', 'Uw inzending is beoordeeld en we moedigen u aan om herzieningen in te dienen', '<p>Beste {$recipientName},</p>\n<p>Uw inzending {$submissionTitle} is beoordeeld en we willen u aanmoedigen om herzieningen in te dienen die de opmerkingen van de beoordelaars adresseren. Een redacteur zal deze herzieningen bekijken en als ze de zorgen adequaat aanpakken, kan uw inzending worden geaccepteerd voor publicatie.</p>\n<p>De opmerkingen van de beoordelaars zijn onderaan deze e-mail opgenomen. Graag ontvangen wij uw reactie op elk punt in de opmerkingen van de beoordelaars en geef aan welke wijzigingen u heeft aangebracht. Als u van mening bent dat bepaalde opmerkingen van de beoordelaars ongegrond of ongepast zijn, licht dan alstublieft uw perspectief toe.</p>\n<p>Wanneer u uw herzieningen heeft voltooid, kunt u de herziene documenten samen met uw reactie op de opmerkingen van de beoordelaars uploaden via uw <a href="{$authorSubmissionUrl}">inzending dashboard</a>. Indien u bent uitgelogd, kunt u opnieuw inloggen met de gebruikersnaam {$recipientUsername}.</p>\n<p>Als u vragen heeft, neem dan contact met mij op via uw <a href="{$authorSubmissionUrl}">inzending dashboard</a>.</p>\n<p>Wij kijken uit naar ontvangst van uw herziene inzending.</p>\n<p>Met vriendelijke groet,</p>\n{$signature}<hr>\n<p>De volgende opmerkingen zijn ontvangen van de beoordelaars.</p>\n{$allReviewerComments}'),
(181, 'EDITOR_DECISION_REVISIONS', 'ru', 'Требуются изменения', 'Ваш материал был отрецензирован и мы предлагаем Вам прислать его откорректированную версию', '<p>Здравствуйте, {$recipientName}!</p><p>Ваш материал «{$submissionTitle}» был отрецензирован и мы хотели бы предложить Вам внести изменения, учитывающие замечания рецензентов. Редактор рассмотрит эти правки, и если они адекватно устранят замечания рецензентов, Ваша работа может быть принята к публикации.</p><p>Комментарии рецензентов приведены в конце этого письма. Пожалуйста, ответьте на каждый пункт замечаний рецензентов и укажите, какие изменения Вы внесли. Если Вы считаете какие-либо замечания рецензента необоснованными или неуместными, объясните свою точку зрения.</p><p>Когда Вы завершите внесение правок, загрузите изменённые документы вместе с ответами на замечания рецензентов на <a href="{$authorSubmissionUrl}"> странице Вашего материала</a>. Если Вы вышли из системы, Вы можете снова войти в нее с именем пользователя {$recipientUsername}.</p><p>Если у Вас есть какие-то вопросы, пожалуйста, свяжитесь со мной через <a href="{$authorSubmissionUrl}">страницу Вашего материала</a>.</p><p>Мы с нетерпением ждем получения Вашего доработанного материала.</p><p>С уважением,</p>{$signature}<hr><p>Следующие комментарии были получены от рецензентов.</p>{$allReviewerComments}'),
(182, 'EDITOR_DECISION_REVISIONS', 'en', 'Revisions Requested', 'Your submission has been reviewed and we encourage you to submit revisions', '<p>Dear {$recipientName},</p><p>Your submission {$submissionTitle} has been reviewed and we would like to encourage you to submit revisions that address the reviewers'' comments. An editor will review these revisions and if they address the concerns adequately, your submission may be accepted for publication.</p><p>The reviewers'' comments are included at the bottom of this email. Please respond to each point in the reviewers'' comments and identify what changes you have made. If you find any of the reviewer''s comments to be unjustified or inappropriate, please explain your perspective.</p><p>When you have completed your revisions, you can upload revised documents along with your response to the reviewers'' comments at your <a href="{$authorSubmissionUrl}">submission dashboard</a>. If you have been logged out, you can login again with the username {$recipientUsername}.</p><p>If you have any questions, please contact me from your <a href="{$authorSubmissionUrl}">submission dashboard</a>.</p><p>We look forward to receiving your revised submission.</p><p>Kind regards,</p>{$signature}<hr><p>The following comments were received from reviewers.</p>{$allReviewerComments}'),
(183, 'EDITOR_DECISION_RESUBMIT', 'de', 'Erneut für die Begutachtung vorlegen', 'Ihr Beitrag wurde geprüft - bitte überarbeiten Sie ihn und reichen Sie ihn erneut ein', '<p>Sehr geehrte/r {$recipientName},</p><p>Nach Durchsicht Ihrer Einreichung {$submissionTitle} haben die Gutachter/innen empfohlen, dass Ihre Einreichung in der vorliegenden Form nicht zur Veröffentlichung angenommen werden kann. Wir möchten Sie jedoch ermutigen, eine überarbeitete Version einzureichen, die auf die Kommentare der Gutachter/innen eingeht. Ihre überarbeitete Fassung wird von einem Redakteur/einer Redaktion geprüft und möglicherweise zu einer weiteren Begutachtungsrunde weitergeleitet.</p><p>Bitte beachten Sie, dass die erneute Einreichung Ihrer Arbeit keine Garantie dafür ist, dass sie angenommen wird.</p><p>Die Kommentare der Gutachter/innen sind am Ende dieser E-Mail enthalten. Bitte gehen Sie auf jeden Punkt ein und geben Sie an, welche Änderungen Sie vorgenommen haben. Wenn Sie einen der Kommentare für unangemessen halten, erläutern Sie bitte Ihren Standpunkt. Wenn Sie Fragen zu den Empfehlungen im Bericht haben, geben Sie diese bitte in Ihrer Antwort an.</p><p>Wenn Sie Ihre Überarbeitungen abgeschlossen haben, können Sie die überarbeiteten Dokumente zusammen mit Ihrer Antwort auf die Kommentare der Gutachter/innen im <a href="{$authorSubmissionUrl}">Dashboard Ihrer Einreichung</a> hochladen.Wenn Sie abgemeldet waren, können Sie sich erneut mit dem Benutzernamen {$recipientUsername} anmelden.</p><p>Wenn Sie Fragen haben, kontaktieren Sie mich bitte über das <a href=„{$authorSubmissionUrl}“>Dashboard Ihrer Einreichung</a>.</p><p>Wir freuen uns auf Ihre überarbeitete Eingabe.</p><p>Mit freundlichen Grüßen,</p>{$signature}<hr><p>Die folgenden Kommentare wurden von den Gutachter/innen abgegeben.</p>{$allReviewerComments}'),
(184, 'EDITOR_DECISION_RESUBMIT', 'es', 'Reenviar para revisión', 'Se ha revisado su envío. Por favor, revíselo y vuelva a enviarlo', '<p>Estimado/a {$recipientName},</p><p>Tras revisar su envío, {$submissionTitle}, los revisores/as han recomendado que no puede ser aceptado para publicarse en su estado actual. No obstante, nos gustaría animarle a que nos envíe una versión revisada que tenga en cuenta los comentarios de los revisores/as. Los cambios serán revisados por el editor/a y el artículo podría ser enviado a una nueva ronda de evaluación por pares.</p><p>Tenga en cuenta que el hecho de volver a enviar su artículo no garantiza que sea aceptado.</p><p>Los comentarios de los revisores/as se incluyen al final de este correo electrónico. Por favor, responda a cada punto e identifique los cambios que haga. Si considera inapropiado algún comentario de los revisores/as, explíquenos su punto de vista. Si tiene dudas acerca de las recomendaciones en su revisión, inclúyalas en su respuesta.</p><p>Cuando haya completado las revisiones puede cargar los documentos revisados, junto con la respuesta a los comentarios de los revisores/as, en su <a href="{$authorSubmissionUrl}">panel de control del envío</a>. Si ha cerrado la sesión puede volver a iniciarla con su nombre de usuario/a {$recipientUsername}.</p><p>Si tiene cualquier pregunta no dude en contactarnos desde su <a href="{$authorSubmissionUrl}">panel de control del envío</a>.</p><p>Quedamos a la espera de recibir su envío revisado.</p><p>Saludos cordiales,</p>{$signature}<hr><p>Se recibieron los siguientes comentarios de los revisores/as.</p>{$allReviewerComments}'),
(185, 'EDITOR_DECISION_RESUBMIT', 'fr_CA', 'Soumettez à nouveau pour évaluation', 'Décision du rédacteur', '{$authors},<br />\n<br />\nNous avons pris une décision concernant votre soumission « {$submissionTitle} » à la revue {$journalName}.<br />\n<br />\nNotre décision est de vous demander d''apporter des révisions à votre soumission et de la soumettre à nouveau.'),
(186, 'EDITOR_DECISION_RESUBMIT', 'it', '', 'Decisione dell''editor', '{$authors}:<br />\n<br />\nAbbiamo raggiunto una decisione riguardo alla Sua submission a {$journalName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nLa decisione è: mandarla di nuovo in revisione'),
(187, 'EDITOR_DECISION_RESUBMIT', 'nl', 'Opnieuw ter beoordeling indienen', 'Uw inzending is beoordeeld - gelieve deze te herzien en opnieuw in te dienen', '<p>Beste {$recipientName},</p>\n<p>Na het beoordelen van uw inzending, {$submissionTitle}, hebben de beoordelaars aanbevolen dat uw inzending in zijn huidige vorm niet kan worden geaccepteerd voor publicatie. Desondanks willen we u aanmoedigen om een herziene versie in te dienen die de opmerkingen van de beoordelaars adresseert. Uw herzieningen zullen worden beoordeeld door een redacteur en kunnen worden doorgestuurd voor een volgende ronde van peer review.</p>\n<p>Houd er rekening mee dat het opnieuw indienen van uw werk niet garandeert dat het zal worden geaccepteerd.</p>\n<p>De opmerkingen van de beoordelaars zijn onderaan deze e-mail opgenomen. Reageer alstublieft op elk punt en geef aan welke wijzigingen u heeft aangebracht. Als u van mening bent dat bepaalde opmerkingen van de beoordelaars ongepast zijn, licht dan alstublieft uw perspectief toe. Als u vragen heeft over de aanbevelingen in uw beoordeling, neem deze dan op in uw reactie.</p>\n<p>Wanneer u uw herzieningen heeft voltooid, kunt u de herziene documenten samen met uw reactie op de opmerkingen van de beoordelaars <a href="{$authorSubmissionUrl}">indienen via uw inzendingsdashboard</a>. Als u bent uitgelogd, kunt u opnieuw inloggen met de gebruikersnaam {$recipientUsername}.</p>\n<p>Als u vragen heeft, neem dan contact met mij op via uw <a href="{$authorSubmissionUrl}">inzendingsdashboard</a>.</p>\n<p>Wij kijken uit naar ontvangst van uw herziene inzending.</p>\n<p>Met vriendelijke groet,</p>\n{$signature}<hr>\n<p>De volgende opmerkingen zijn ontvangen van de beoordelaars.</p>\n{$allReviewerComments}');
INSERT INTO `email_templates_default_data` VALUES
(188, 'EDITOR_DECISION_RESUBMIT', 'ru', 'Повторная отправка на рецензирование', 'Ваш материал был отрецензирован — пожалуйста, переработайте его и отправьте заново', '<p>Здравствуйте, {$recipientName}!</p><p>Расссмотрев Ваш материал «{$submissionTitle}» рецензенты рекомендовали не принимать его к публикации в текущем виде. Однако, мы хотели бы предложить Вам представить переработанную версию, учитывающую замечания рецензентов. Ваши правки будут рассмотрены редактором и могут быть отправлены на повторное рецензирование.</p><p>Обратите внимание, что повторное представление Вашего материала не гарантирует, что он будет принят.</p><p>Комментарии рецензентов приведены в конце этого письма. Пожалуйста, ответьте на каждый пункт замечаний рецензентов и укажите, какие изменения Вы внесли. Если Вы считаете какие-либо замечания рецензента необоснованными или неуместными, объясните свою точку зрения. Если у вас есть вопросы по поводу рекомендаций, содержащихся в рецензиях, пожалуйста, включите их в свой ответ.</p><p>Когда Вы завершите внесение правок, загрузите изменённые документы вместе с ответами на замечания рецензентов на <a href="{$authorSubmissionUrl}"> странице Вашего материала</a>. Если Вы вышли из системы, Вы можете снова войти в нее с именем пользователя {$recipientUsername}.</p><p>Если у Вас есть какие-то вопросы, пожалуйста, свяжитесь со мной через <a href="{$authorSubmissionUrl}">страницу Вашего материала</a>.</p><p>Мы с нетерпением ждем получения Вашего переработанного материала.</p><p>С уважением,</p>{$signature}<hr><p>Следующие комментарии были получены от рецензентов.</p>{$allReviewerComments}'),
(189, 'EDITOR_DECISION_RESUBMIT', 'en', 'Resubmit for Review', 'Your submission has been reviewed - please revise and resubmit', '<p>Dear {$recipientName},</p><p>After reviewing your submission, {$submissionTitle}, the reviewers have recommended that your submission cannot be accepted for publication in its current form. However, we would like to encourage you to submit a revised version that addresses the reviewers'' comments. Your revisions will be reviewed by an editor and may be sent out for another round of peer review.</p><p>Please note that resubmitting your work does not guarantee that it will be accepted.</p><p>The reviewers'' comments are included at the bottom of this email. Please respond to each point and identify what changes you have made. If you find any of the reviewer''s comments inappropriate, please explain your perspective. If you have questions about the recommendations in your review, please include these in your response.</p><p>When you have completed your revisions, you can upload revised documents along with your response to the reviewers'' comments <a href="{$authorSubmissionUrl}">at your submission dashboard</a>. If you have been logged out, you can login again with the username {$recipientUsername}.</p><p>If you have any questions, please contact me from your <a href="{$authorSubmissionUrl}">submission dashboard</a>.</p><p>We look forward to receiving your revised submission.</p><p>Kind regards,</p>{$signature}<hr><p>The following comments were received from reviewers.</p>{$allReviewerComments}'),
(190, 'EDITOR_DECISION_DECLINE', 'de', 'Einreichung abgelehnt', 'Entscheidung der Redaktion: Ihre Einreichung wurde abgelehnt', '<p>Sehr geehrte/ {$recipientName},</p><p>Wir freuen uns über Ihre Einreichung, können aber {$submissionTitle} auf Grund der Kommentare der Gutachter/innen nicht zur Veröffentlichung annehmen.</p><p>Die Kommentare der Gutachter/innen sind am Ende dieser E-Mail enthalten.</p><p>Vielen Dank für Ihre Einreichung bei {$journalName}. Obwohl es enttäuschend ist, wenn eine Einreichung abgelehnt wird, hoffe ich, dass Sie die Kommentare der Gutachter/innen als konstruktiv und hilfreich empfinden.</p><p>Es steht Ihnen nun frei, die Arbeit an anderer Stelle einzureichen, wenn Sie dies wünschen.</p><p>Mit freundlichen Grüßen,</p>{$signature}<hr><p>Die folgenden Kommentare wurden von den Gutachter/innen abgegeben.</p>{$allReviewerComments}'),
(191, 'EDITOR_DECISION_DECLINE', 'es', 'Envío rechazado', 'Se ha rechazado su envío', '<p>Estimado/a{$recipientName},</p><p>Aunque valoramos mucho la recepción de su envío, de acuerdo con los comentarios de los revisores/as no podemos aceptar {$submissionTitle} para publicarse.</p><p>Dichos comentarios se incluyen al final de este correo electrónico.</p><p>Gracias por su envío a {$journalName}. A pesar de que es decepcionante que se rechace el envío, esperamos que los comentarios de los revisores/as le resulten constructivos y útiles.</p><p>Ahora es libre de presentar el trabajo en otro sitio si así lo desea.</p><p>Saludos cordiales,</p>{$signature}<hr><p>Se recibieron los siguientes comentarios de los revisores.</p>{$allReviewerComments}'),
(192, 'EDITOR_DECISION_DECLINE', 'fr_CA', 'Soumission refusée', 'Décision du rédacteur', '{$authors}:<br />\n<br />\nNous avons pris une décision concernant votre soumission « {$submissionTitle} » à la revue {$journalName}.<br />\n<br />\nNotre décision est de refuser votre soumission.'),
(193, 'EDITOR_DECISION_DECLINE', 'it', '', 'Decisione dell''editor', '{$authors}:<br />\n<br />\nAbbiamo raggiunto una decisione riguardo alla Sua submission a {$journalName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nLa decisione è di non accettare la proposta'),
(194, 'EDITOR_DECISION_DECLINE', 'nl', 'Inzending Afgewezen', 'Uw inzending is afgewezen', '<p>Beste {$recipientName},</p>\n<p>Hoewel we uw inzending hebben ontvangen, kunnen we {$submissionTitle} niet accepteren voor publicatie op basis van de opmerkingen van de beoordelaars.</p>\n<p>De opmerkingen van de beoordelaars zijn onderaan deze e-mail opgenomen.</p>\n<p>Bedankt voor uw inzending aan {$journalName}. Hoewel het teleurstellend is dat uw inzending is afgewezen, hoop ik dat u de opmerkingen van de beoordelaars als constructief en nuttig beschouwt.</p>\n<p>U bent nu vrij om het werk elders in te dienen als u dat wenst.</p>\n<p>Met vriendelijke groet,</p>\n{$signature}<hr>\n<p>De volgende opmerkingen zijn ontvangen van de beoordelaars.</p>\n{$allReviewerComments}'),
(195, 'EDITOR_DECISION_DECLINE', 'ru', 'Материал отклонен', 'Ваш материал был отклонен', '<p>Здравствуйте, {$recipientName}!</p><p>Хотя мы ценим то, что Вы решили отправить нам свой материал для публикации, мы не можем принять «{$submissionTitle}» к публикации на основании замечаний рецензентов.</p><p>Комментарии рецензентов приведены в конце этого письма.</p><p>Благодарим Вас за подачу материала в журнал «{$journalName}». Хотя отклонение материала от публикации расстраивает, я надеюсь, что комментарии рецензентов будут для Вас конструктивными и полезными.</p><p>Вы можете отправить материал для публикации в другое место, если решите это сделать.</p><p>С уважением,</p>{$signature}<hr><p>Следующие комментарии были получены от рецензентов.</p>{$allReviewerComments}'),
(196, 'EDITOR_DECISION_DECLINE', 'en', 'Submission Declined', 'Your submission has been declined', '<p>Dear {$recipientName},</p><p>While we appreciate receiving your submission, we are unable to accept {$submissionTitle} for publication on the basis of the comments from reviewers.</p><p>The reviewers'' comments are included at the bottom of this email.</p><p>Thank you for submitting to {$journalName}. Although it is disappointing to have a submission declined, I hope you find the reviewers'' comments to be constructive and helpful.</p><p>You are now free to submit the work elsewhere if you choose to do so.</p><p>Kind regards,</p>{$signature}<hr><p>The following comments were received from reviewers.</p>{$allReviewerComments}'),
(197, 'EDITOR_DECISION_INITIAL_DECLINE', 'de', 'Einreichung abgelehnt (Vor dem Gutachten)', 'Entscheidung der Redaktion: Ihre Einreichung wurde abgelehnt', '<p>Sehr geehrte/r {$recipientName},</p><p>es tut mir leid, Ihnen mitzuteilen, dass die Redaktion nach Durchsicht Ihrer Einreichung {$submissionTitle} festgestellt hat, dass sie unsere Anforderungen für eine Veröffentlichung in {$journalName} nicht erfüllt.</p><p>Ich wünsche Ihnen viel Erfolg, wenn Sie erwägen, Ihre Arbeit anderswo einzureichen.</p><p>Mit freundlichen Grüßen,</p>{$signature}'),
(198, 'EDITOR_DECISION_INITIAL_DECLINE', 'es', 'Envío rechazado (antes de revisión)', 'Su envío ha sido rechazado', '<p>Estimado/a {$recipientName},</p><p>Lamento informarlo de que, tras la revisión de su artículo, {$submissionTitle}, el editor/a ha considerado que no cumple los requisitos de publicación en {$journalName}.</p><p>Le deseo mucha suerte si decide enviarlo a otro sitio.</p><p>Saludos cordiales,</p>{$signature}'),
(199, 'EDITOR_DECISION_INITIAL_DECLINE', 'fr_CA', 'Soumission refusée avant évaluation', 'Décision du rédacteur', '<p>{$recipientName},</p><p>Nous avons le regret de vous informer qu''après avoir évaluer votre manuscrit, {$submissionTitle}, le-la rédacteur-trice en a conclue qu''il ne rencontre pas les exigences nécessaires pour être publier dans {$journalName}.</p><p>Cordialement,</p>{$signature}'),
(200, 'EDITOR_DECISION_INITIAL_DECLINE', 'it', '', 'Decisione dell''editor', '\n			Gentilissimo {$authors}:<br />\n<br />\nAbbiamo preso una decisione in merito al suo manoscritto dal titolo &quot;{$submissionTitle}&quot; inviato a {$journalName} .<br />\n<br />\nCi rincresce informarla che non ci è possibile accettare il suo contributo'),
(201, 'EDITOR_DECISION_INITIAL_DECLINE', 'nl', 'Inzending Afgewezen (Pre-Review)', 'Uw inzending is afgewezen', '<p>Beste {$recipientName},</p>\n<p>Helaas moet ik u mededelen dat na beoordeling van uw inzending, {$submissionTitle}, de redacteur heeft vastgesteld dat deze niet voldoet aan onze publicatie-eisen voor {$journalName}.</p>\n<p>Ik wens u succes als u overweegt uw werk elders in te dienen.</p>\n<p>Met vriendelijke groet,</p>\n{$signature}'),
(202, 'EDITOR_DECISION_INITIAL_DECLINE', 'ru', 'Материал отклонен (до рецензирования)', 'Ваш материал был отклонен', '<p>Здравствуйте, {$recipientName}!</p><p> С сожалением вынужден Вам сообщить, что по результатам рецензирования Вашего материала «{$submissionTitle}» редактор принял решение, что он не соответствует нашим требованиям к публикации в журнале «{$journalName}».</p><p>Желаю Вам успеха, если Вы решите отправить Вашу работу в другой журнал.</p><p>С уважением,</p>{$signature}'),
(203, 'EDITOR_DECISION_INITIAL_DECLINE', 'en', 'Submission Declined (Pre-Review)', 'Your submission has been declined', '<p>Dear {$recipientName},</p><p>I’m sorry to inform you that, after reviewing your submission, {$submissionTitle}, the editor has found that it does not meet our requirements for publication in {$journalName}.</p><p>I wish you success if you consider submitting your work elsewhere.</p><p>Kind regards,</p>{$signature}'),
(204, 'EDITOR_RECOMMENDATION', 'de', 'Empfehlung gegeben', 'Empfehlung der Redaktion', '<p>Sehr geehrte/r {$recipientName},</p><p>Nach Abwägung des Feedbacks der Gutachter/innen möchte ich folgende Empfehlung für die Einreichung {$submissionTitle} aussprechen .</p><p>Meine Empfehlung lautet: {$recommendation}.</p><p>Bitte besuchen Sie den <a href="{$submissionUrl}">Redaktionsworkflow</a> des Beitrags, um dieser Empfehlung nachzukommen.</p><p>Bitte zögern Sie nicht, mich bei Fragen zu kontaktieren.</p><p>Mit freundlichen Grüßen,</p><p>{$senderName}</p>'),
(205, 'EDITOR_RECOMMENDATION', 'es', 'Recomendación hecha', 'Recomendación del editor/a', '<p>Estimado/a{$recipientName},</p><p>Tras considerar los comentarios de los revisores/as, me gustaría emitir la siguiente recomendación en relación con su envío {$submissionTitle}.</p><p>Mi recomendación es: {$recommendation}.</p><p>Visite el <a href="{$submissionUrl}">flujo editorial</a> del envío para actuar sobre esta recomendación.</p><p>Si tiene alguna pregunta, no dude en ponerse en contacto conmigo.</p><p>Saludos cordiales,</p><p>{$senderName}</p>'),
(206, 'EDITOR_RECOMMENDATION', 'fr_CA', 'Recommandation émise', 'Recommandation du rédacteur', '<p>{$recipientName},</p><p>Ma recommandation concernant la soumission « {$submissionTitle} » à la revue {$journalName} est de : {$recommendation}</p><p>S''il vous plait, consulter la <a href="{$submissionUrl}">page de la soumission</a> afin de donner suite à cette recommandation.</p><p>Cordialement,</p><p>{$senderName}</p>'),
(207, 'EDITOR_RECOMMENDATION', 'it', '', 'Raccomandazione dell''editor', '{$editors}:<br />\n<br />\nLa raccomandazione riguardo la proposta &quot;{$submissionTitle}&quot;, giunta per  {$journalName}, è: {$recommendation}'),
(208, 'EDITOR_RECOMMENDATION', 'nl', 'Aanbeveling Gedaan', 'Redacteursaanbeveling', '<p>Beste {$recipientName},</p>\n<p>Na het overwegen van de feedback van de beoordelaars, wil ik graag de volgende aanbeveling doen met betrekking tot de inzending {$submissionTitle}.</p>\n<p>Mijn aanbeveling is: {$recommendation}.</p>\n<p>Bezoek alstublieft de <a href="{$submissionUrl}">redactionele workflow van de inzending</a> om actie te ondernemen op deze aanbeveling.</p>\n<p>Voel u vrij om contact met mij op te nemen als u vragen heeft.</p>\n<p>Met vriendelijke groet,</p>\n<p>{$senderName}</p>'),
(209, 'EDITOR_RECOMMENDATION', 'ru', 'Рекомендация сделана', 'Рекомендация редактора', '<p>Здравствуйте, {$recipientName}!</p><p>После рассмотрения рецензий, присланных рецензентами, я бы хотел дать следующую рекомендацию относительно материала «{$submissionTitle}».</p><p>Моя рекомендация: {$recommendation}.</p><p>Пожалуйста, зайдите на страницу <a href="{$submissionUrl}">«Редакционный процесс»</a> данного материала, чтобы выполнить действия, связанные с этой рекомендацией.</p><p>Если у вас есть вопросы, пожалуйста, свяжитесь со мной.</p><p>С уважением,</p><p>{$senderName}</p>'),
(210, 'EDITOR_RECOMMENDATION', 'en', 'Recommendation Made', 'Editor Recommendation', '<p>Dear {$recipientName},</p><p>After considering the reviewers'' feedback, I would like to make the following recommendation regarding the submission {$submissionTitle}.</p><p>My recommendation is: {$recommendation}.</p><p>Please visit the submission''s <a href="{$submissionUrl}">editorial workflow</a> to act on this recommendation.</p><p>Please feel free to contact me with any questions.</p><p>Kind regards,</p><p>{$senderName}</p>'),
(211, 'EDITOR_DECISION_NOTIFY_OTHER_AUTHORS', 'de', 'Andere Autor/innen benachrichtigen', 'Ein Update zu Ihrer Einreichung', '<p>Die folgende E-Mail wurde an {$submittingAuthorName} von {$journalName} bezüglich {$submissionTitle} gesendet.</p>\n<p>Sie erhalten eine Kopie dieser Benachrichtigung, da Sie als Autor/in der Einreichung identifiziert sind. Alle Anweisungen in der folgenden Nachricht sind für den einreichenden Autor/die einreichende Autorin {$submittingAuthorName} bestimmt, und von Ihnen wird zu diesem Zeitpunkt keine Aktion verlangt.</p>\n\n{$messageToSubmittingAuthor}'),
(212, 'EDITOR_DECISION_NOTIFY_OTHER_AUTHORS', 'es', 'Notificar a los otros autores/as', 'Actualización acerca de su envío', '<p>El siguiente correo electrónico fue enviado a {$submittingAuthorName} desde {$journalName} en relación con {$submissionTitle}.</p>\n<p>El motivo por el que recibe una copia de esta notificación es porque está identificado como autor/a de este envío. Las instrucciones que figuran en el siguiente mensaje se dirigen al autor/a principal del envío, {$submittingAuthorName}, por lo que no se requiere ninguna acción suya en este momento.</p>\n\n{$messageToSubmittingAuthor}'),
(213, 'EDITOR_DECISION_NOTIFY_OTHER_AUTHORS', 'fr_CA', 'Envoyer une notification aux autres auteur-es', 'Mise à jour concernant votre soumission', '<p>Ce courriel a été envoyé à {$submittingAuthorName} par {$journalName} concernant {$submissionTitle}.</p>\n<p>Vous recevez une copie de cet avis car vous êtes identifié comme auteur-e de cette soumission. Toutes les instructions dans le message ci-dessous sont à l''intention de l''auteur-e de correspondance, {$submittingAuthorName}. </p><p>Aucune action n''est attendue de votre part.</p>\n\n{$messageToSubmittingAuthor}'),
(214, 'EDITOR_DECISION_NOTIFY_OTHER_AUTHORS', 'it', '', '', ''),
(215, 'EDITOR_DECISION_NOTIFY_OTHER_AUTHORS', 'nl', 'Andere Auteurs Inlichten', 'Een update over uw inzending', '<p>De volgende e-mail is verzonden naar {$submittingAuthorName} van {$journalName} betreffende {$submissionTitle}.</p>\n<p>U ontvangt een kopie van deze kennisgeving omdat u bent geïdentificeerd als een auteur van de inzending. Eventuele instructies in het onderstaande bericht zijn bedoeld voor de indienende auteur, {$submittingAuthorName}, en er is op dit moment geen actie van u vereist.</p>\n\n{$messageToSubmittingAuthor}'),
(216, 'EDITOR_DECISION_NOTIFY_OTHER_AUTHORS', 'ru', 'Уведомить других авторов', 'Обновление информации о Вашем материале', '<p>В адрес {$submittingAuthorName} от журнала «{$journalName}» было отправлено следующее письмо относительно материала «{$submissionTitle}».</p>\n<p>Вы получили копию этого уведомления, потому что Вы указаны как автор материала. Любые инструкции в сообщении ниже предназначены для автора-отправителя ({$submittingAuthorName}) и от вас сейчас не требуется никаких действий.</p> \n\n{$messageToSubmittingAuthor}'),
(217, 'EDITOR_DECISION_NOTIFY_OTHER_AUTHORS', 'en', 'Notify Other Authors', 'An update regarding your submission', '<p>The following email was sent to {$submittingAuthorName} from {$journalName} regarding {$submissionTitle}.</p>\n<p>You are receiving a copy of this notification because you are identified as an author of the submission. Any instructions in the message below are intended for the submitting author, {$submittingAuthorName}, and no action is required of you at this time.</p>\n\n{$messageToSubmittingAuthor}'),
(218, 'EDITOR_DECISION_NOTIFY_REVIEWERS', 'de', 'Gutachter/innen über die Entscheidung benachrichtigen', 'Eingangsbestätigung für Ihr Gutachten', '<p>Sehr geehrte/r {$recipientName},</p>\n<p>Vielen Dank, dass Sie den Beitrag {$submissionTitle} für {$journalName} begutachtet haben. Wir wissen Ihre Zeit und Ihr Fachwissen zu schätzen, mit denen Sie zur Qualität der von uns veröffentlichten Arbeiten beitragen. Wir haben Ihre Kommentare mit den Autoren geteilt, zusammen mit den Kommentaren unserer anderen Gutachter und der Entscheidung der Redaktion.</p>\n<p>Auf der Grundlage des erhaltenen Feedbacks haben wir die Autoren über Folgendes informiert:</p>\n<p>{$decisionDescription}</p>\n<p>Ihre Empfehlung wurde zusammen mit den Empfehlungen der anderen Gutachter/innen geprüft, bevor eine Entscheidung getroffen wurde. Gelegentlich kann die Entscheidung des Herausgebers von der Empfehlung eines oder mehrerer Gutachter/innen abweichen. Die Redaktion wägt viele Faktoren ab und nimmt diese Entscheidungen nicht auf die leichte Schulter. Wir sind dankbar für das Fachwissen und die Vorschläge unserer Gutachter/innen.</p>\n<p>Es war uns eine Freude, mit Ihnen als Gutachter/in für {$journalName} zusammenzuarbeiten, und wir hoffen, dass wir auch in Zukunft die Gelegenheit haben werden, mit Ihnen zusammenzuarbeiten.</p>\n<p>Mit freundlichen Grüßen,</p>\n<p>{$Unterschrift}</p>'),
(219, 'EDITOR_DECISION_NOTIFY_REVIEWERS', 'es', 'Notificar a los revisores/as de la decisión', 'Gracias por su revisión', '<p>Estimado/a {$recipientName},</p>\n<p>Gracias por completar la revisión del envío, {$submissionTitle}, para {$journalName}. Le agradecemos su tiempo y su pericia, que contribuyen a la calidad de las obras que publicamos. Hemos compartido sus comentarios con los autores/as, junto con los comentarios de los otros revisores/as y la decisión editorial.</p>\n<p>A partir de los comentarios recibidos, hemos notificado a los autores/as lo siguiente:</p>\n<p>{$decisionDescription}</p>\n<p>Su recomendación, junto con la de otros revisores/as, se ha considerado antes de llegar a una decisión final. A veces, la decisión del editor/a puede diferir de la recomendación hecha por uno o más revisores/as. El editor/a tiene en cuenta muchos factores y no se toma estas decisiones a la ligera. Estamos muy agradecidos por la pericia y las sugerencias de nuestros revisores/as.</p>\n<p>Ha sido un placer trabajar con usted como revisor/a para {$journalName}, y esperamos tener la oportunidad de seguir haciéndolo en el futuro.</p>\n<p>Saludos cordiales,</p>\n<p>{$signature}</p>'),
(220, 'EDITOR_DECISION_NOTIFY_REVIEWERS', 'fr_CA', 'Notifier les évaluateurs-trices de la décision', 'Décision éditoriale suite à votre évaluation', '<p>{$recipientName},</p>\n<p>Nous vous remercions d''avoir complété votre évaluation de la soumission, {$submissionTitle}, pour {$journalName}. Nous vous sommes reconnaissant pour votre temps et votre expertise qui contribue à la qualité des travaux que nous publions. Nous avons partagé vos commentaires avec l''auteur-e, ainsi que ceux des autres évaluateurs-trices. </p>\n<p>En fonction des recommandations reçues, nous avons informé l''auteur-e de notre décision qui est la suivante: </p>\n<p>{$decisionDescription}</p>\n<p>Votre recommandation a été prise en considération conjointement avec celles des autres évaluateurs-trices avant d''en arriver à cette décision.</p>\n<p>Ce fut un plaisir de travailler avec vous à cette évaluation pour {$journalName}. Nous espérons avoir l''opportunité de renouveler cette expérience avec vous à l''avenir.</p>\n<p>Cordialement,</p>\n<p>{$signature}</p>'),
(221, 'EDITOR_DECISION_NOTIFY_REVIEWERS', 'it', '', '', ''),
(222, 'EDITOR_DECISION_NOTIFY_REVIEWERS', 'nl', 'Reviewers Inlichten over Beslissing', 'Bedankt voor uw recensie', '<p>Beste {$recipientName},</p>\n<p>Dank u voor het voltooien van uw beoordeling van de inzending, {$submissionTitle}, voor {$journalName}. We waarderen uw tijd en expertise in het bijdragen aan de kwaliteit van het werk dat we publiceren. We hebben uw opmerkingen gedeeld met de auteurs, samen met de opmerkingen van onze andere beoordelaars en het besluit van de redacteur.</p>\n<p>Op basis van de ontvangen feedback hebben we de auteurs het volgende laten weten:</p>\n<p>{$decisionDescription}</p>\n<p>Uw aanbeveling werd in overweging genomen naast de aanbevelingen van andere beoordelaars voordat er een beslissing werd genomen. Soms kan de beslissing van de redacteur afwijken van de aanbeveling van een of meer beoordelaars. De redacteur houdt rekening met veel factoren en neemt deze beslissingen niet lichtvaardig. We zijn dankbaar voor de expertise en suggesties van onze beoordelaars.</p>\n<p>Het was een genoegen om met u samen te werken als beoordelaar voor {$journalName}, en we hopen in de toekomst weer met u te kunnen samenwerken.</p>\n<p>Met vriendelijke groet,</p>\n<p>{$signature}</p>'),
(223, 'EDITOR_DECISION_NOTIFY_REVIEWERS', 'ru', 'Уведомить рецензентов о принятом решении', 'Благодарим за Вашу рецензию', '<p>Здравствуйте, {$recipientName}!</p>\n<p>Благодарю Вас за рецензирование материала «{$submissionTitle}» для журнала «{$journalName}». Мы ценим Ваш вклад, который способствует повышению качества публикуемых нами работ. Мы поделились Вашими замечаниями с авторами, а также замечаниями других рецензентов и решением редактора.</p>\n<p>На основании полученных рецензий мы уведомили авторов о следующем:</p>\n<p>{$decisionDescription}</p>\n<p>Ваши рекомендации были рассмотрены наряду с рекомендациями других рецензентов, прежде чем было принято такое решение. Иногда решение редактора может отличаться от рекомендации одного или нескольких рецензентов. Редактор учитывает множество факторов и принимает такие решения очень взвешенно. Мы благодарны нашим рецензентам за их опыт и предложения.</p>\n<p>Нам было очень приятно работать с Вами в качестве рецензента журнала «{$journalName}», и мы надеемся, что в будущем у нас еще будет возможность сотрудничать с Вами.</p>\n<p>С уважением,</p>\n<p>{$signature}</p>'),
(224, 'EDITOR_DECISION_NOTIFY_REVIEWERS', 'en', 'Notify Reviewers of Decision', 'Thank you for your review', '<p>Dear {$recipientName},</p>\n<p>Thank you for completing your review of the submission, {$submissionTitle}, for {$journalName}. We appreciate your time and expertise in contributing to the quality of the work that we publish. We have shared your comments with the authors, along with our other reviewers'' comments and the editor''s decision.</p>\n<p>Based on the feedback we received, we have notified the authors of the following:</p>\n<p>{$decisionDescription}</p>\n<p>Your recommendation was considered alongside the recommendations of other reviewers before coming to a decision. Occasionally the editor''s decision may differ from the recommendation made by one or more reviewers. The editor considers many factors, and does not take these decisions lightly. We are grateful for our reviewers'' expertise and suggestions.</p>\n<p>It has been a pleasure to work with you as a reviewer for {$journalName}, and we hope to have the opportunity to work with you again in the future.</p>\n<p>Kind regards,</p>\n<p>{$signature}</p>'),
(225, 'EDITOR_DECISION_NEW_ROUND', 'de', 'Neue Gutachtenrunde gestartet', 'Ihr Beitrag wurde für eine weitere Begutachtungsrunde weitergeleitet', '<p>Sehr geehrte/r {$recipientName},</p>\n<p>Ihre überarbeitete Einreichung {$submissionTitle} wurde zu einer neuen Runde der Begutachtung geschickt. \nSie werden von uns eine Rückmeldung von den Gutachter/innen und Informationen über die nächsten Schritte erhalten.</p>\n<p>Wenn Sie Fragen haben, kontaktieren Sie mich bitte über das <a href="{$authorSubmissionUrl}">Dashboard Ihrer Einreichung</a>.</p>\n<p>Mit freundlichen Grüßen,</p>\n<p>{$signature}</p>\n'),
(226, 'EDITOR_DECISION_NEW_ROUND', 'es', 'Se inició una ronda de revisión nueva', 'Su envío se ha tramitado a otra ronda de revisión', '<p>Estimado/a {$recipientName},</p>\n<p>Su manuscrito revisado, {$submissionTitle}, se ha enviado a una ronda de evaluación por pares nueva.\nLe comunicaremos los comentarios de los revisores/as y la información sobre los próximos pasos.</p>\n<p>Si tiene cualquier pregunta puede contactar con nosotros desde el <a href="{$authorSubmissionUrl}">panel de control del envío</a>.</p>\n<p>Saludos cordiales,</p>\n<p>{$signature}</p>\n'),
(227, 'EDITOR_DECISION_NEW_ROUND', 'fr_CA', 'Un nouveau cycle d''évaluation a été lancé', 'Votre soumission fera l''objet d''un nouveau cycle d''évaluation', '<p>{$recipientName},</p>\n<p>Votre soumission révisée, {$submissionTitle}, fera l''objet d''un nouveau cycle d''évaluation par les pairs. \nNous vous contacterons afin de vous faire part des commentaires des évaluateurs et vous fournir des informations sur les prochaines étapes.</p>\n<p>Si vous avec des questions, vous pouvez nous contacter à partir de votre <a href="{$authorSubmissionUrl}">tableau de bord de soumission</a>.</p>\n<p>Cordialement,</p>\n<p>{$signature}</p>\n'),
(228, 'EDITOR_DECISION_NEW_ROUND', 'it', '', '', ''),
(229, 'EDITOR_DECISION_NEW_ROUND', 'nl', 'Nieuwe Reviewronde Gestart', 'Uw inzending is doorgestuurd voor een volgende ronde van beoordeling', '<p>Beste {$recipientName},</p>\n<p>Uw herziene inzending, {$submissionTitle}, is doorgestuurd voor een nieuwe ronde van peer review.</p>\n<p>U zult van ons horen met feedback van de beoordelaars en informatie over de volgende stappen.</p>\n<p>Als u vragen heeft, neem dan contact met mij op via uw <a href="{$authorSubmissionUrl}">inzending dashboard</a>.\n</p>\n<p>Met vriendelijke groet,</p>\n<p>{$signature}</p>\n'),
(230, 'EDITOR_DECISION_NEW_ROUND', 'ru', 'Начался новый раунд рецензирования', 'Ваш материал был отправлен на повторный раунд рецензирования', '<p>Здравствуйте, {$recipientName}!</p>\n<p>ВАш переработанный материал «{$submissionTitle}» был отправлен на новый раунд рецензирования. \nВы получите от нас отзывы рецензентов и информацию о дальнейших шагах.</p>\n<p>Если у Вас есть какие-то вопросы, пожалуйста, свяжитесь со мной через <a href="{$authorSubmissionUrl}">страницу Вашего материала</a>.</p>\n<p>С уважением,</p>\n<p>{$signature}</p>\n'),
(231, 'EDITOR_DECISION_NEW_ROUND', 'en', 'New Review Round Initiated', 'Your submission has been sent for another round of review', '<p>Dear {$recipientName},</p>\n<p>Your revised submission, {$submissionTitle}, has been sent for a new round of peer review. \nYou will hear from us with feedback from the reviewers and information about the next steps.</p>\n<p>If you have any questions, please contact me from your <a href="{$authorSubmissionUrl}">submission dashboard</a>.</p>\n<p>Kind regards,</p>\n<p>{$signature}</p>\n'),
(232, 'EDITOR_DECISION_REVERT_DECLINE', 'de', 'Abgelehnte Einreichung wieder aufnehmen', 'Wir haben die Entscheidung, Ihre Einreichung abzulehnen, rückgängig gemacht', '<p>Sehr geehrte/r {$recipientName},</p>\n<p>Die Entscheidung, Ihre Einreichung {$submissionTitle} abzulehnen, wurde rückgängig gemacht. Ein Redakteur/eine Redakteurin wird die Überprüfungsrunde abschließen und Sie werden benachrichtigt, wenn eine Entscheidung getroffen ist.</p>\n<p>Gelegentlich wird die Entscheidung, eine Einreichung abzulehnen, versehentlich in unserem System gespeichert und muss dann rückgängig gemacht werden. Ich möchte mich für die Verwirrung entschuldigen, die dies verursacht haben könnte.</p>\n<p>Wir werden uns mit Ihnen in Verbindung setzen, wenn wir weitere Unterstützung benötigen.</p>\n<p>Wenn Sie Fragen haben, kontaktieren Sie mich bitte über das <a href="{$authorSubmissionUrl}">Dashboard Ihrer Einreichung</a>.</p>\n<p>Mit freundlichen Grüßen,</p>\n<p>{$signature}</p>\n'),
(233, 'EDITOR_DECISION_REVERT_DECLINE', 'es', 'Restaurar envío rechazado', 'Hemos revertido la decisión de rechazar su envío', '<p>Estimado/a {$recipientName},</p>\n<p>La decisión de rechazar su envío, {$submissionTitle}, se ha revertido.\nUn editor/a completará la ronda de revisión y, cuando se haya tomado una decisión, \nse le notificará.</p>\n<p>A veces se registra accidentalmente en nuestro sistema la decisión de rechazar un envío\ny esta acción debe ser revertida. Le pedimos disculpas por la confusión que esto le haya podido causar.</p>\n<p>Nos pondremos en contacto con usted si necesitamos más ayuda.</p>\n<p>Si tiene cualquier pregunta puede contactarnos desde el <a href="{$authorSubmissionUrl}">panel de control del envío</a>.</p>\n<p>Saludos cordiales,</p>\n<p>{$signature}</p>\n'),
(234, 'EDITOR_DECISION_REVERT_DECLINE', 'fr_CA', 'Rétablir une soumission refusée', 'Nous avons renversé la décision de rejeter votre soumission', '<p>{$recipientName},</p>\n<p>La décision de rejeter votre soumission, {$submissionTitle}, a été renversée. Un-e rédacteur-trice complétera le cycle d''évaluation et vous serez informé-e lorsqu''une décision éditoriale sera prise.</p>\n<p>Si vous avez des questions, vous pouvez nous contacter sur votre <a href="{$authorSubmissionUrl}">tableau de bord de soumissions</a>.</p>\n<p>Cordialement,</p>\n<p>{$signature}</p>\n'),
(235, 'EDITOR_DECISION_REVERT_DECLINE', 'it', '', '', ''),
(236, 'EDITOR_DECISION_REVERT_DECLINE', 'nl', 'Herstel Afgewezen Inzending', 'We hebben besloten om de afwijzing van uw inzending ongedaan te maken', '<p>Beste {$recipientName},</p>\n<p>De beslissing om uw inzending, {$submissionTitle}, af te wijzen is teruggedraaid.</p>\n<p>Een redacteur zal de ronde van beoordeling voltooien en u wordt op de hoogte gebracht wanneer er een beslissing is genomen.</p>\n<p>Soms wordt een beslissing om een inzending af te wijzen per ongeluk vastgelegd in ons systeem en moet deze worden teruggedraaid. Excuses voor eventuele verwarring die dit heeft veroorzaakt.</p>\n<p>We zullen contact met u opnemen als we verdere hulp nodig hebben.</p>\n<p>Als u vragen heeft, neem dan contact met mij op via uw <a href="{$authorSubmissionUrl}">inzending dashboard</a>.</p>\n<p>Met vriendelijke groet,</p>\n<p>{$signature}</p>\n'),
(237, 'EDITOR_DECISION_REVERT_DECLINE', 'ru', 'Восстановление отклонённый материал', 'Мы отменили решение отклонить Ваш материал', '<p>Здравствуйте, {$recipientName}!</p>\n<p>Решение отклонить Ваш материал «{$submissionTitle}» было отменено. \nРедактор проведёт раунд рецензирования, и вы получите уведомление \nо принятом решении.</p>\n<p>Иногда решение об отклонении материала может быть случайно записано \nв нашей системе и должно быть отменено. Приношу Вам свои извинения за ту путаницу, которую эта ситуация могла вызвать.</p>\n<p>Мы свяжемся с Вами, если нам понадобится дополнительная помощь.</p>\n<p>Если у Вас есть какие-то вопросы, пожалуйста, свяжитесь со мной через <a href="{$authorSubmissionUrl}">страницу Вашего материала</a>.</p>\n<p>С уважением,</p>\n<p>{$signature}</p>\n'),
(238, 'EDITOR_DECISION_REVERT_DECLINE', 'en', 'Reinstate Declined Submission', 'We have reversed the decision to decline your submission', '<p>Dear {$recipientName},</p>\n<p>The decision to decline your submission, {$submissionTitle}, has been reversed. \nAn editor will complete the round of review and you will be notified when a \ndecision is made.</p>\n<p>Occasionally, a decision to decline a submission will be recorded accidentally in \nour system and must be reverted. I apologize for any confusion this may have caused.</p>\n<p>We will contact you if we need any further assistance.</p>\n<p>If you have any questions, please contact me from your <a href="{$authorSubmissionUrl}">submission dashboard</a>.</p>\n<p>Kind regards,</p>\n<p>{$signature}</p>\n'),
(239, 'EDITOR_DECISION_REVERT_INITIAL_DECLINE', 'de', 'Ohne Gutachten abgelehnte Einreichung wieder aufnehmen', 'Wir haben die Entscheidung, Ihre Einreichung abzulehnen, rückgängig gemacht', '<p>Sehr geehrte/r {$recipientName},</p><p>Die Entscheidung, Ihre Einreichung {$submissionTitle} abzulehnen, wurde rückgängig gemacht. Ein Redakteur/eine Redakteurin wird sich Ihre Einreichung genauer ansehen, bevor er entscheidet, ob er sie ablehnt oder zur Überprüfung zu schickt.</p><p>Gelegentlich wird die Entscheidung, eine Einreichung abzulehnen, versehentlich in unserem System gespeichert und muss dann rückgängig gemacht werden. Ich möchte mich für die Verwirrung entschuldigen, die dies verursacht haben könnte.</p><p>Wir werden uns mit Ihnen in Verbindung setzen, wenn wir weitere Unterstützung benötigen.</p><p>Wenn Sie Fragen haben, kontaktieren Sie mich bitte über das <a href="{$authorSubmissionUrl}">Dashboard Ihrer Einreichung</a>.</p><p>Mit freundlichen Grüßen,</p><p>{$signature}</p>\n'),
(240, 'EDITOR_DECISION_REVERT_INITIAL_DECLINE', 'es', 'Restaurar el envío rechazado sin revisión', 'Hemos revertido la decisión de rechazar su envío', '<p>Estimado/a {$recipientName},</p>\n<p>La decisión de rechazar su envío, {$submissionTitle}, se ha revertido. \nUn editor/a estudiará su propuesta antes de decidir si la rechaza \no la envía a revisión.</p>\n<p>A veces se registra accidentalmente en nuestro sistema la decisión de rechazar un envío\ny esta acción debe ser revertida. Le pedimos disculpas por la confusión que esto le haya podido causar.</p>\n<p>Nos pondremos en contacto con usted si necesitamos más ayuda.</p>\n<p>Si tiene cualquier pregunta puede contactarnos desde el <a href="{$authorSubmissionUrl}">panel de control del envío</a>.</p>\n<p>Saludos cordiales,</p>\n<p>{$signature}</p>\n'),
(241, 'EDITOR_DECISION_REVERT_INITIAL_DECLINE', 'fr_CA', 'Rétablir une soumission refusée sans évaluation', 'Nous avons renversé la décision de rejeter votre soumission', '<p>{$recipientName},</p>\n<p>La décision de rejeter votre soumission, {$submissionTitle}, a été renversée. Un-e rédacteur-trice consultera en détail votre soumission avant de décider de la rejeter ou de l''envoyer en évaluation.</p>\n<p>Si vous avez des questions, vous pouvez nous contacter à partir de votre <a href="{$authorSubmissionUrl}">tableau de bord de soumission</a>.</p>\n<p>Cordialement,</p>\n<p>{$signature}</p>\n'),
(242, 'EDITOR_DECISION_REVERT_INITIAL_DECLINE', 'it', '', '', ''),
(243, 'EDITOR_DECISION_REVERT_INITIAL_DECLINE', 'nl', 'Herstel Inzending Geweigerd zonder Review', 'We hebben besloten om de afwijzing van uw inzending ongedaan te maken', '<p>Beste {$recipientName},</p>\n<p>De beslissing om uw inzending, {$submissionTitle}, af te wijzen is teruggedraaid.</p>\n<p>Een redacteur zal uw inzending verder bekijken voordat besloten wordt of deze alsnog afgewezen wordt of doorgestuurd wordt voor beoordeling.</p>\n<p>Soms wordt een beslissing om een inzending af te wijzen per ongeluk vastgelegd in ons systeem en moet deze worden teruggedraaid. Excuses voor eventuele verwarring die dit heeft veroorzaakt.</p>\n<p>We zullen contact met u opnemen als we verdere hulp nodig hebben.</p>\n<p>Als u vragen heeft, neem dan contact met mij op via uw <a href="{$authorSubmissionUrl}">inzending dashboard</a>.</p>\n<p>Met vriendelijke groet,</p>\n<p>{$signature}</p>\n'),
(244, 'EDITOR_DECISION_REVERT_INITIAL_DECLINE', 'ru', 'Восстановить материал, отклонённый без рецензирования', 'Мы отменили решение отклонить Ваш материал', '<p>Здравствуйте, {$recipientName}!</p>\n<p>Решение отклонить Ваш материал «{$submissionTitle}» было отменено. \nРедактор дополнительно изучит Ваш материал, прежде чем решит отклонить \nматериал или отправить его на рецензирование.</p>\n<p>Иногда решение об отклонении материала может быть случайно записано \nв нашей системе и должно быть отменено. Приношу Вам свои извинения за ту путаницу, которую эта ситуация могла вызвать.</p>\n<p>Мы свяжемся с Вами, если нам понадобится дополнительная помощь.</p>\n<p>Если у Вас есть какие-то вопросы, пожалуйста, свяжитесь со мной через <a href="{$authorSubmissionUrl}">страницу Вашего материала</a>.</p>\n<p>С уважением,</p>\n<p>{$signature}</p>\n'),
(245, 'EDITOR_DECISION_REVERT_INITIAL_DECLINE', 'en', 'Reinstate Submission Declined Without Review', 'We have reversed the decision to decline your submission', '<p>Dear {$recipientName},</p>\n<p>The decision to decline your submission, {$submissionTitle}, has been reversed. \nAn editor will look further at your submission before deciding whether to decline \nthe submission or send it for review.</p>\n<p>Occasionally, a decision to decline a submission will be recorded accidentally in \nour system and must be reverted. I apologize for any confusion this may have caused.</p>\n<p>We will contact you if we need any further assistance.</p>\n<p>If you have any questions, please contact me from your <a href="{$authorSubmissionUrl}">submission dashboard</a>.</p>\n<p>Kind regards,</p>\n<p>{$signature}</p>\n'),
(246, 'EDITOR_DECISION_SKIP_REVIEW', 'de', 'Einreichung angenommen (ohne Begutachtung)', 'Ihre Einreichung wurde in das Lektorat geschickt', '<p>Sehr geehrte/r {$recipientName},</p>\n<p>Ich freue mich, Ihnen mitteilen zu können, dass wir beschlossen haben, Ihre Einreichung ohne Peer Review anzunehmen. Wir sind der Meinung, dass Ihre Einreichung {$submissionTitle} unseren Erwartungen entspricht, und wir verlangen nicht, dass Arbeiten dieser Art einem Peer-Review unterzogen werden. Wir freuen uns, Ihren Beitrag in {$journalName} zu veröffentlichen und danken Ihnen, dass Sie unsere Zeitschrift für Ihre Arbeit gewählt haben.</p>\nIhr Beitrag wird nun in einer zukünftigen Ausgabe von {$journalName} veröffentlicht und Sie können ihn gerne in Ihre Publikationsliste aufnehmen. Wir wissen um die harte Arbeit, die hinter jeder erfolgreichen Einreichung steckt, und möchten Ihnen zu Ihren Bemühungen gratulieren.</p>>\n<p>Ihre Einreichung wird nun redaktionell bearbeitet und formatiert, um sie für die Veröffentlichung vorzubereiten. </p>\n<p>Sie werden in Kürze weitere Anweisungen erhalten.</p>\n<p>Wenn Sie Fragen haben, kontaktieren Sie mich bitte über Ihr <a href="{$authorSubmissionUrl}">Einreichungs-Dashboard</a>.</p>\n<p>Mit freundlichen Grüßen,</p>\n<p>{$signature}</p>\n'),
(247, 'EDITOR_DECISION_SKIP_REVIEW', 'es', 'Envío aceptado (sin revisión)', 'Su artículo se ha enviado a edición', '<p>Estimado/a {$recipientName},</p>\n<p>Me complace informarle de que hemos decidido aceptar su envío sin pasar por la fase de revisión por pares. Le confirmamos que su envío "{$submissionTitle}" cumple con nuestras expectativas, por lo que no necesitamos que este tipo de trabajo pase por la fase de revisión por pares. Estamos emocionados por publicar su trabajo en {$journalName} y le agradecemos que haya elegido nuestra revista como hogar de su trabajo.</p>\n<p>Su envío se publicará en un número futuro de {$journalName}, así que le invitamos a incluirlo en su lista de publicaciones. Reconocemos el arduo trabajo que implica cada envío exitoso y queremos felicitarle por sus esfuerzos.</p>\n<p>Ahora su envío pasará a edición y formateo para su posterior publicación. </p>\n<p>En breve recibirá más instrucciones.</p>\n<p>Si tiene alguna pregunta, póngase en contacto con nosotros a través de su <a href="{$authorSubmissionUrl}">panel de envíos</a>.</p>\n<p>Atentamente,</p>\n<p>{$signature}</p>\n'),
(248, 'EDITOR_DECISION_SKIP_REVIEW', 'fr_CA', 'Soumission acceptée (sans évaluation)', 'Votre soumission a été envoyée à la révision linguistique', '<p>{$recipientName},</p>\n<p>Nous avons le plaisir de vous informer que nous avons décidé d''accepter votre soumission sans processus d''évaluation par les pairs. Nous trouvons que votre soumission, {$submissionTitle}, répond à nos exigences et ne requerrons pas une évaluation par les pairs. Nous sommes enthousiastes à l''idée de publier votre texte dans la revue {$journalName} et voulons vous remercier d''avoir choisi notre revue pour diffuser vos travaux. </p>\nVotre texte sera publié dans un prochain numéro de la revue {$journalName} et vous pouvez l''inclure dès à présent dans votre liste de publications. Nous reconnaissons les efforts nécessaire à toute publication et vous en félicitons. </p>\n<p>Votre texte va faire l''objet d''une révision linguistique et être mise en page avant publication.</p>\n<p>Vous recevrez des instructions sous peu.</p>\n<p>Si vous avez des questions, n''hésitez pas à me contacter à partir de votre <a href="{$authorSubmissionUrl}">tableau de bord de soumission</a>.</p>\n<p>Cordialement,</p>\n<p>{$signature}</p>\n'),
(249, 'EDITOR_DECISION_SKIP_REVIEW', 'it', '', 'Il Suo contributo è stato assegnato per la fase di copy-editing', '<p>Gentile {$recipientName},</p>\n<p>Abbiamo il piacere di informarLa che il Suo contributo {$submissionTitle} è stato accettato senza necessità del processo di revisione fra pari. Siamo pertanto lieti di poter pubblicare il Suo contributo in {$journalName} e La ringraziamo per avere scelto la nostra rivista.</p>\n<p>Il contributo sarà dunque pubblicato in un futuro numero di {$journalName} e La preghiamo di considerare tale e-mail già valida come conferma in tal senso. Siamo consapevoli dell''impegnativo lavoro necessario ai fini di ogni proposta editoriale di successo e pertanto desideriamo complimentarci per aver ottenuto tale risultato .</p><p>Il Suo contributo sarà entro breve assegnato per il lavoro di copy-editing e di formazione ai fini della pubblicazione.</p><p>Riceverà entro breve, a tal proposito, ulteriori indicazioni.</p><p>In caso di necessità o quesiti, non esiti a contattarci tramite la Sua area di<a href="{$authorSubmissionUrl}">gestione delle proposte</a>.</p><p>Con i più cordiali saluti,</p>{$signature}\n'),
(250, 'EDITOR_DECISION_SKIP_REVIEW', 'nl', 'Inzending Geaccepteerd (Zonder Beoordeling)', 'Uw inzending is verzonden voor bureauredactie', '<p>Beste {$recipientName},</p>\n<p>Het doet mij genoegen u te kunnen meedelen dat we hebben besloten uw inzending zonder peer review te accepteren. We hebben vastgesteld dat uw inzending, {$submissionTitle}, aan onze verwachtingen voldoet, en we vereisen niet dat dit soort werk peer review ondergaat. We zijn verheugd om uw stuk te publiceren in {$journalName} en wij danken u dat u ons tijdschrift heeft gekozen als locatie voor uw werk.</p>\nUw inzending verschijnt nu in een toekomstige uitgave van {$journalName} en u bent van harte welkom om deze op te nemen in uw lijst met publicaties. We erkennen het harde werk dat in elke succesvolle inzending zit en we willen u feliciteren met uw inspanningen.</p>\n<p>Je inzending wordt nu gekopieerd en opgemaakt om deze klaar te maken voor publicatie. </p>\n<p>Je ontvangt binnenkort verdere instructies.</p>\n<p>Als u vragen heeft, kunt u contact met mij opnemen via uw <a href="{$authorSubmissionUrl}">inzendingsdashboard</a>.</p>\n<p>Vriendelijke groeten,</p>\n<p>{$signature}</p>\n');
INSERT INTO `email_templates_default_data` VALUES
(251, 'EDITOR_DECISION_SKIP_REVIEW', 'ru', 'Материал принят (без рецензирования)', 'Ваш материал отправлен на корректуру', '<p>Уважаемый {$recipientName}!</p>\n<p>Я рад сообщить Вам, что мы решили принять Ваш материал без рецензирования. Мы считаем, что материал {$submissionTitle} полностью соответствует требованиям нашего журнала и не нуждается в дополнительной экспертной оценке. Мы рады опубликовать Ваш материал в журнале {$journalName} и благодарим Вас за выбор нашего журнала для публикации результатов Ваших исследований.</p>\nВаша статья будет опубликована в ближайшем выпуске журнала {$journalName}, и Вы сможете включить её в Ваш список публикаций. Мы понимаем, какая серьёзная работа предшествует каждой научной публикации, и хотим поздравить Вас с её успешным завершением.</p>\n<p>Теперь Ваш материал будет отредактирован и отформатирован для подготовки к публикации. </p>\n<p>В ближайшее время Вы получите от меня дальнейшие инструкции.</p>\n<p>Если у Вас возникли вопросы, пожалуйста, свяжитесь со мной из Вашего <a href="{$authorSubmissionUrl}">аккаунта</a>.</p>\n<p>С уважением,</p>\n<p>{$signature}</p>\n'),
(252, 'EDITOR_DECISION_SKIP_REVIEW', 'en', 'Submission Accepted (Without Review)', 'Your submission has been sent for copyediting', '<p>Dear {$recipientName},</p>\n<p>I am pleased to inform you that we have decided to accept your submission without peer review. We found your submission, {$submissionTitle}, to meet our expectations, and we do not require that work of this type undergo peer review. We are excited to publish your piece in {$journalName} and we thank you for choosing our journal as a venue for your work.</p>\nYour submission is now forthcoming in a future issue of {$journalName} and you are welcome to include it in your list of publications. We recognize the hard work that goes into every successful submission and we want to congratulate you on your efforts.</p>\n<p>Your submission will now undergo copy editing and formatting to prepare it for publication. </p>\n<p>You will shortly receive further instructions.</p>\n<p>If you have any questions, please contact me from your <a href="{$authorSubmissionUrl}">submission dashboard</a>.</p>\n<p>Kind regards,</p>\n<p>{$signature}</p>\n'),
(253, 'EDITOR_DECISION_BACK_FROM_PRODUCTION', 'de', 'Einreichung wurde ins Lektorat zurückgeschickt', 'Ihr Beitrag wurde an das Lektorat zurückgeschickt', '<p>Sehr geehrte/r {$recipientName},</p><p>Ihre Einsendung {$submissionTitle} wurde an das Lektorat zurückgeschickt, wo sie weiter bearbeitet und formatiert wird, um sie zur Veröffentlichung vorzubereiten.</p><p>Es kann vorkommen, dass eine Einsendung in die Produktionsphase geht, bevor die endgültigen Druckfahnen für die Veröffentlichung vorbereitet sind. Ihre Einsendung ist noch nicht abgeschlossen. Für etwaige Unklarheiten bitte ich um Entschuldigung.</p><p>Wenn Sie Fragen haben, kontaktieren Sie mich bitte über das <a href="{$authorSubmissionUrl}">Dashboard Ihrer Einreichung</a>.</p><p>Wir werden uns mit Ihnen in Verbindung setzen, wenn wir weitere Unterstützung benötigen.</p><p>Mit freundlichen Grüßen,</p><p>{$signature}</p>'),
(254, 'EDITOR_DECISION_BACK_FROM_PRODUCTION', 'es', 'Se ha retornado el envío a Edición', 'Su envío se ha devuelto a edición', '<p>Estimado/a {$recipientName},</p><p>Su envío, {$submissionTitle}, se ha devuelto a la fase de edición, donde se someterá a una nueva corrección y formateo para prepararlo para su publicación.</p><p>A veces, un envío pasa a la fase de producción antes de estar listo para preparar las galeradas finales que se utilizarán para su publicación. Su envío aún está en preparación. Lamentamos cualquier confusión que le hayamos causado.</p><p>Si tiene cualquier duda puede contactarnos desde su <a href="{$authorSubmissionUrl}">panel de control del envío</a>.</p><p>Nos pondremos en contacto con usted si necesitamos más ayuda.</p><p>Saludos cordiales,</p><p>{$signature}</p>'),
(255, 'EDITOR_DECISION_BACK_FROM_PRODUCTION', 'fr_CA', 'Soumission renvoyée à la révision', 'Votre soumission a été renvoyée à l''étape de révision', '<p>{$recipientName},</p><p>Votre soumission, {$submissionTitle}, a été renvoyée à l''étape de révision, où nous procéderons à des révisions supplémentaires ainsi qu''à la mise en page en prévision de la publication.</p><p>Nous nous excusons pour la confusion que cette opération peut occasionner.</p><p>Si vous avez des questions, vous pouvez nous contacter à partir de votre <a href="{$authorSubmissionUrl}">tableau de bord de soumission</a>.</p><p>Cordialement,</p><p>{$signature}</p>'),
(256, 'EDITOR_DECISION_BACK_FROM_PRODUCTION', 'it', '', '', ''),
(257, 'EDITOR_DECISION_BACK_FROM_PRODUCTION', 'nl', 'Inzending teruggestuurd naar Copyediting', 'Je inzending is teruggestuurd voor het corrigeren van de tekst', '<p>Beste {$recipientName},</p><p>Je inzending, {$submissionTitle}, is teruggestuurd naar de tekstredactiefase, waar het verder zal worden geredigeerd en opgemaakt om het voor publicatie gereed te maken.</p><p>Soms wordt een inzending naar de productiefase gestuurd voordat het klaar is voor de definitieve proefdrukken voor publicatie. Jouw inzending komt er nog aan. Excuses voor eventuele verwarring.</p><p>Als je vragen hebt, neem dan contact met me op via je <a href="{$authorSubmissionUrl}">inzendingsdashboard</a>.</p><p>We zullen contact met je opnemen als we verdere assistentie nodig hebben.</p><p>Met vriendelijke groet,</p><p>{$signature}</p>'),
(258, 'EDITOR_DECISION_BACK_FROM_PRODUCTION', 'ru', 'Материал отправлен обратно на литературное редактирование', 'Ваш материал был возвращён на литературное редактирование', '<p>Здравствуйте, {$recipientName}!</p><p>Ваш материал «{$submissionTitle}» был возвращён на этап литературного редактирования, где он пройдёт дальнейшее литературное редактирование и форматирование для подготовки к публикации.</p><p>Иногда материалы отправляются на публикацию до того, как они будут готовы к тому, чтобы их финальные гранки прошли подготовку к публикации. Редактирование Вашего материала ещё не завершено, приношу Вам свои извинения за ту путаницу, которую эта ситуация могла вызвать.</p><p>Если у Вас есть какие-то вопросы, пожалуйста, свяжитесь со мной через <a href="{$authorSubmissionUrl}">страницу Вашего материала</a>.</p><p>Мы свяжемся с Вами, если нам понадобится дополнительная помощь.</p><p>С уважением,</p><p>{$signature}</p>'),
(259, 'EDITOR_DECISION_BACK_FROM_PRODUCTION', 'en', 'Submission Sent Back to Copyediting', 'Your submission has been sent back to copyediting', '<p>Dear {$recipientName},</p><p>Your submission, {$submissionTitle}, has been sent back to the copyediting stage, where it will undergo further copyediting and formatting to prepare it for publication.</p><p>Occasionally, a submission is sent to the production stage before it is ready for the final galleys to be prepared for publication. Your submission is still forthcoming. I apologize for any confusion.</p><p>If you have any questions, please contact me from your <a href="{$authorSubmissionUrl}">submission dashboard</a>.</p><p>We will contact you if we need any further assistance.</p><p>Kind regards,</p><p>{$signature}</p>'),
(260, 'EDITOR_DECISION_BACK_FROM_COPYEDITING', 'de', 'Einreichung vom Lektorat aus zurückgeschickt', 'Ihr Beitrag wurde zur Überprüfung zurückgeschickt', '<p>Sehr geehrte/r {$recipientName},</p><p>ihr Beitrag {$submissionTitle} wurde zur Überprüfung zurückgeschickt. Er wird einer weiteren Überprüfung unterzogen, bevor er zur Veröffentlichung angenommen werden kann.</p><p>Gelegentlich wird eine Entscheidung über die Annahme einer Einreichung versehentlich in unserem System gespeichert und wir müssen sie zur Überprüfung zurückschicken. Ich bitte um Entschuldigung für jegliche Verwirrung, die dies verursacht hat. Wir werden uns bemühen, alle weiteren Überprüfungen schnell abzuschließen, damit Sie so schnell wie möglich eine endgültige Entscheidung erhalten.</p><p>Wir werden uns mit Ihnen in Verbindung setzen, wenn wir weitere Unterstützung benötigen.</p><p>Wenn Sie Fragen haben, kontaktieren Sie mich bitte über das <a href="{$authorSubmissionUrl}">Dashboard Ihrer Einreichung</a>.</p><p>Mit freundlichen Grüßen,</p><p>{$signature}</p>'),
(261, 'EDITOR_DECISION_BACK_FROM_COPYEDITING', 'es', 'Envío retornado desde Edición', 'Su envío se ha devuelto a revisión', '<p>Estimado/a {$recipientName},</p><p>Su envío, {$submissionTitle}, se ha devuelto a la fase de revisión, donde se someterá a una nueva revisión antes de ser aceptado para su publicación.</p><p>A veces, la decisión de aceptar un envío puede registrarse accidentalmente en el sistema y por ello debemos enviarlo de nuevo a revisión. Lamentamos cualquier confusión que le hayamos causado. Nos encargaremos de completar rápidamente cualquier otra revisión para darle la decisión final lo antes posible.</p><p>Nos pondremos en contacto con usted si necesitamos más ayuda.</p><p>Si tiene cualquier duda puede contactarnos desde su <a href="{$authorSubmissionUrl}">panel de control del envío</a>.</p><p>Saludos cordiales,</p><p>{$signature}</p>'),
(262, 'EDITOR_DECISION_BACK_FROM_COPYEDITING', 'fr_CA', 'Soumission renvoyée de l''étape de révision', 'Votre soumission a été renvoyée à l''étape d''évaluation.', '<p>{$recipientName},</p><p>Votre soumission, {$submissionTitle}, a été renvoyée à l''étape d''évaluation. Elle sera réévaluée avant de pouvoir être acceptée.</p><p>Il peut arriver qu''une décision d''accepter une soumission soit prise par erreur dans notre système et qu''elle doive être renvoyée à l''étape d''évaluation. Nous nous excusons cette la confusion. Nous allons faire en sorte de compléter le processus d''évaluation rapidement afin de vous communiquer notre décision finale le plus tôt possible.</p><p>Nous vous contacterons au besoin.</p><p>Si vous avez des questions, n''hésitez pas à nous contacter à partir de votre <a href="{$authorSubmissionUrl}">tableau de bord de soumission</a>.</p><p>Cordialement,</p><p>{$signature}</p>'),
(263, 'EDITOR_DECISION_BACK_FROM_COPYEDITING', 'it', '', '', ''),
(264, 'EDITOR_DECISION_BACK_FROM_COPYEDITING', 'nl', 'Inzending teruggestuurd van Copyediting', 'Je inzending is teruggezonden voor recensie', '<p>Beste {$recipientName},</p><p>Je inzending, {$submissionTitle}, is teruggestuurd naar de beoordelingsfase. Het zal verder worden beoordeeld voordat het kan worden geaccepteerd voor publicatie.</p><p>Soms wordt een beslissing om een inzending te accepteren per ongeluk in ons systeem geregistreerd en moeten we het terugsturen naar de beoordelingsfase. Mijn excuses voor de verwarring die dit heeft veroorzaakt. We zullen ons best doen om de verdere beoordeling snel af te ronden, zodat je zo snel mogelijk een definitieve beslissing krijgt.</p><p>We zullen contact met je opnemen als we verdere assistentie nodig hebben.</p><p>Als je vragen hebt, neem dan contact met me op via je <a href="{$authorSubmissionUrl}">inzendingsdashboard</a>.</p><p>Met vriendelijke groet,</p><p>{$signature}</p>'),
(265, 'EDITOR_DECISION_BACK_FROM_COPYEDITING', 'ru', 'Материал отправлен обратно после литературного редактирования', 'Ваш материал был возвращён на рецензирование', '<p>Здравствуйте, {$recipientName}!</p><p>Ваш материал «{$submissionTitle}» был возвращён на этап рецензирования. Он пройдёт дальнейшее рецензирование прежде чем будет принят к публикации.</p><p>Иногда решение о приёме материала может быть случайно записано в нашей системе и мы должны вернуть материал обратно на рецензирование. Приношу Вам свои извинения за ту путаницу, которую эта ситуация могла вызвать. Мы постараемся быстро завершить рецензирование, чтобы Вы получили окончательное решение как можно скорее.</p><p>Мы свяжемся с Вами, если нам понадобится дополнительная помощь.</p><p>Если у Вас есть какие-то вопросы, пожалуйста, свяжитесь со мной через <a href="{$authorSubmissionUrl}">страницу Вашего материала</a>.</p><p>С уважением,</p><p>{$signature}</p>'),
(266, 'EDITOR_DECISION_BACK_FROM_COPYEDITING', 'en', 'Submission Sent Back from Copyediting', 'Your submission has been sent back to review', '<p>Dear {$recipientName},</p><p>Your submission, {$submissionTitle}, has been sent back to the review stage. It will undergo further review before it can be accepted for publication.</p><p>Occasionally, a decision to accept a submission will be recorded accidentally in our system and we must send it back to review. I apologize for any confusion this has caused. We will work to complete any further review quickly so that you have a final decision as soon as possible.</p><p>We will contact you if we need any further assistance.</p><p>If you have any questions, please contact me from your <a href="{$authorSubmissionUrl}">submission dashboard</a>.</p><p>Kind regards,</p><p>{$signature}</p>'),
(267, 'EDITOR_DECISION_CANCEL_REVIEW_ROUND', 'de', 'Gutachtenrunde abgebrochen', 'Eine Überprüfungsrunde für Ihren Beitrag wurde abgesagt', '<p>Sehr geehrte/r {$recipientName},</p><p>wir haben kürzlich eine neue Überprüfungsrunde für Ihre Einreichung {$submissionTitle} eröffnet. Wir schließen diese Überprüfungsrunde jetzt ab.</p><p>Es kann vorkommen, dass eine Entscheidung zur Eröffnung einer Überprüfungsrunde versehentlich in unserem System gespeichert wird und wir diese Überprüfungsrunde abbrechen müssen. Ich bitte um Entschuldigung für jegliche Verwirrung, die dies verursacht haben könnte.</p><p>Wir werden uns mit Ihnen in Verbindung setzen, wenn wir weitere Unterstützung benötigen.</p><p>Wenn Sie Fragen haben, kontaktieren Sie mich bitte über das <a href="{$authorSubmissionUrl}">Dashboard Ihrer Einreichung</a>.</p><p>Mit freundlichen Grüßen,</p><p>{$signature}</p>'),
(268, 'EDITOR_DECISION_CANCEL_REVIEW_ROUND', 'es', 'Ronda de revisión cancelada', 'Se ha cancelado una ronda de revisión de su envío', '<p>Estimado/a {$recipientName},</p><p>Hace poco iniciamos una ronda de revisión nueva para su envío, {$submissionTitle}. Ahora la vamos a cerrar.</p><p>A veces, la decisión de iniciar una ronda de revisión nueva puede registrarse accidentalmente en el sistema y por ello debemos cancelarla. Lamentamos cualquier confusión que le hayamos causado.</p><p>Nos pondremos en contacto con usted si necesitamos más ayuda.</p><p>Si tiene cualquier duda puede contactarnos desde su <a href="{$authorSubmissionUrl}">panel de control del envío</a>.</p><p>Saludos cordiales,</p><p>{$signature}</p>'),
(269, 'EDITOR_DECISION_CANCEL_REVIEW_ROUND', 'fr_CA', 'Cycle d''évaluation annulé', 'Un cycle d''évaluation de votre soumission a été annulé', '<p>{$recipientName},</p><p>Nous avions déclenché un nouveau cycle d''évaluation pour votre soumission, {$submissionTitle}. Nous fermons désormais ce cycle.</p><p>Nous nous excusons pour la confusion que cette action peut occasionner. </p><p>Nous vous contacterons si nous avons besoin d''une aide supplémentaire de votre part.</p><p>Si vous avez des questions, vous pouvez nous contacter à partir de votre <a href="{$authorSubmissionUrl}">tableau de bord de soumissions</a></p>.<p>Kind regards,</p><p>{$signature}</p>'),
(270, 'EDITOR_DECISION_CANCEL_REVIEW_ROUND', 'it', '', '', ''),
(271, 'EDITOR_DECISION_CANCEL_REVIEW_ROUND', 'nl', 'Reviewronde Geannuleerd', 'Een beoordelingsronde voor je inzending is geannuleerd', '<p>Beste {$recipientName},</p><p>We hebben onlangs een nieuwe beoordelingsronde geopend voor je inzending, {$submissionTitle}. We sluiten deze beoordelingsronde nu af.</p><p>Soms wordt een beslissing om een beoordelingsronde te openen per ongeluk in ons systeem geregistreerd en moeten we deze beoordelingsronde annuleren. Mijn excuses voor eventuele verwarring die dit heeft veroorzaakt.</p><p>We zullen contact met je opnemen als we verdere assistentie nodig hebben.</p><p>Als je vragen hebt, neem dan contact met me op via je <a href="{$authorSubmissionUrl}">inzendingsdashboard</a>.</p><p>Met vriendelijke groet,</p><p>{$signature}</p>'),
(272, 'EDITOR_DECISION_CANCEL_REVIEW_ROUND', 'ru', 'Раунд рецензирования отменен', 'Раунд рецензирования Вашего материала был отменен', '<p>Здравствуйте, {$recipientName}!</p><p>Недавно мы запустили новый раунд рецензирования для Вашего материала «{$submissionTitle}». Сейчас мы отменяем этот раунд рецензирования.</p><p>Иногда решение о начале раунда рецензирования может быть случайно записано в нашей системе и мы должны отменить этот раунд. Приношу Вам свои извинения за ту путаницу, которую эта ситуация могла вызвать.</p><p>Мы свяжемся с Вами, если нам понадобится дополнительная помощь.</p><p>Если у Вас есть какие-то вопросы, пожалуйста, свяжитесь со мной через <a href="{$authorSubmissionUrl}">страницу Вашего материала</a>.</p><p>С уважением,</p><p>{$signature}</p>'),
(273, 'EDITOR_DECISION_CANCEL_REVIEW_ROUND', 'en', 'Review Round Cancelled', 'A review round for your submission has been cancelled', '<p>Dear {$recipientName},</p><p>We recently opened a new review round for your submission, {$submissionTitle}. We are closing this review round now.</p><p>Occasionally, a decision to open a round of review will be recorded accidentally in our system and we must cancel this review round. I apologize for any confusion this may have caused.</p><p>We will contact you if we need any further assistance.</p><p>If you have any questions, please contact me from your <a href="{$authorSubmissionUrl}">submission dashboard</a>.</p><p>Kind regards,</p><p>{$signature}</p>'),
(274, 'SUBSCRIPTION_NOTIFY', 'de', 'Abonnementbenachrichtigung', 'Benachrichtigung zu einem Abonnement', 'Sehr geehrte/r {$recipientName}<br />\n<br />\nSie sind jetzt als Abonnent/in in unserem Online-Zeitschriftenverwaltungssystem für {$journalName} mit dem folgenden Abonnement registriert:<br />\n<br />\n{$subscriptionType}<br />\n<br />\nUm auf Inhalte zuzugreifen, die nur für Abonnent/innen verfügbar sind, melden Sie sich einfach mit Ihrem Benutzernamen "{$recipientUsername}" am System an.<br />\n<br />\nSobald Sie sich im System angemeldet haben, können Sie Ihre Profildaten und Ihr Passwort jederzeit ändern.<br />\n<br />\nWenn Sie ein institutionelles Abonnement haben, brauchen sich die Benutzer/innen Ihrer Einrichtung nicht anzumelden, da Anfragen nach Abonnementinhalten automatisch vom System authentifiziert werden.<br />\n<br />\nWenn Sie Fragen haben, können Sie sich gerne an mich wenden.<br />\n<br />\n{$subscriptionSignature}'),
(275, 'SUBSCRIPTION_NOTIFY', 'es', 'Notificación de suscripción', 'Notificación de suscripción', '{$recipientName}:<br />\n<br />\nAcaba de registrarse como suscriptor/a en nuestro sistema de gestión de revistas online para la revista {$journalName}, a continuación le mostramos los datos de su suscripción:<br />\n<br />\n{$subscriptionType}<br />\n<br />\nPara acceder al contenido exclusivo para suscriptores/as, simplemente tiene que identificarse con su nombre de usuaria/o, &quot;{$recipientUsername}&quot;.<br />\n<br />\nUna vez se haya identificado en el sistema puede cambiar los detalles de su perfil y su contraseña en cualquier momento.<br />\n<br />\nTenga en cuenta que si se trata de una suscripción institucional no es necesario que los/as usuarios/as de su institución se identifiquen, ya que las peticiones de contenido bajo suscripción serán autentificadas automáticamente por el sistema.<br />\n<br />\nSi tiene cualquier pregunta no dude en contactar con nosotros/as.<br />\n<br />\n{$subscriptionSignature}'),
(276, 'SUBSCRIPTION_NOTIFY', 'fr_CA', 'Notification d''abonnement', 'Avis d''abonnement', '{$recipientName},<br />\n<br />\nVous êtes maintenant abonné-e à notre système de gestion de revue en ligne pour la revue {$journalName}, avec le type d''abonnement suivant  :<br />\n<br />\n{$subscriptionType}<br />\n<br />\nPour accéder au contenu destiné seulement aux abonnés, connectez-vous au système à l''aide de votre nom d''utilisateur-trice : {$recipientUsername}.<br />\n<br />\nUne fois connecté-e dans le système, vous pouvez, en tout temps, modifier les renseignements de votre profil et votre mot de passe.<br />\n<br />\nVeuillez prendre note que si vous disposez d''un abonnement institutionnel, les utilisateurs-trices n''ont pas à entrer de nom d''utilisateur-trice puisque le système authentifiera automatiquement les demandes.<br />\n<br />\nSi vous avez des questions, n''hésitez pas à communiquer avec nous.<br />\n<br />\n{$subscriptionSignature}'),
(277, 'SUBSCRIPTION_NOTIFY', 'it', 'Notifica di sottoscrizione', 'Notifica di sottoscrizione', 'Gentile {$recipientName}:<br />\n<br />\nLa Sua registrazione a {$journalName} è stata attivata con le seguenti caratteristiche:<br />\n<br />\n{$subscriptionType}<br />\n<br />\nPer accedere al contenuto riservato agli abbonati, effettui semplicemente l''accesso al sistema con il Suo username, &quot;{$recipientUsername}&quot;.<br />\n<br />\nUna volta effettuato l''accesso potrà modificare in ogni momento i dettagli del profilo e la password.<br />\n<br />\nGli utenti istituzionali vengono riconosciuti automaticamente dal sistema.<br />\n<br />\nPer qualsiasi domanda non esiti a contattarci.<br />\n<br />\nCordiali saluti, <br />{$subscriptionSignature}'),
(278, 'SUBSCRIPTION_NOTIFY', 'nl', 'Abonnementsnotificatie', 'Bevestiging abonnement', '{$recipientName}:<br />\n<br />\nU bent in ons online tijdschriftsysteem geregistreerd als abonnee van {$journalName} met het volgende abonnement:<br />\n<br />\n{$subscriptionType}<br />\n<br />\nOm toegang te krijgen tot de inhoud die is voorbehouden aan abonnees kunt u inloggen in het systeem met uw gebruikersnaam, &quot;{$recipientUsername}&quot;.<br />\n<br />\nEenmaal ingelogd op het systeem kunt u uw profielgegevens en wachtwoord op ieder gewenst moment veranderen.<br />\n<br />\nMerk op dat in het geval van een institutioneel abonnement gebruikers niet in hoeven te loggen, het systeem zal verzoeken automatisch authenticeren.<br />\n<br />\nAls vragen heeft, neemt u dan alstublieft contact met me op.<br />\n<br />\n{$subscriptionSignature}'),
(279, 'SUBSCRIPTION_NOTIFY', 'ru', 'Уведомление о подписке', 'Уведомление о подписке', 'Здравствуйте, {$recipientName}!<br />\n<br />\nВы теперь зарегистрированы в нашей онлайн-системе управления журналом как подписчик журнала «{$journalName}» со следующей подпиской:<br />\n<br />\n{$subscriptionType}<br />\n<br />\nЧтобы получить доступ к контенту, который доступен только для подписчиков, просто войдите на сайт журнала со своим именем пользователя «{$recipientUsername}».<br />\n<br />\nКак только Вы войдете в систему, Вы можете в любой момент изменить Ваш профиль пользователя и пароль.<br />\n<br />\nПожалуйста, обратите внимание, что если у Вас есть подписка на всю организацию, то пользователям Вашей организации не нужно будет входить в систему, так как запросы на контент, предоставляемый по подписке, автоматически будут аутентифицированы системой.<br />\n<br />\nЕсли у Вас есть какие-либо вопросы, пожалуйста, не стесняйтесь, связывайтесь со мной.<br />\n<br />\n{$subscriptionSignature}'),
(280, 'SUBSCRIPTION_NOTIFY', 'en', 'Subscription Notify', 'Subscription Notification', '{$recipientName}:<br />\n<br />\nYou have now been registered as a subscriber in our online journal management system for {$journalName}, with the following subscription:<br />\n<br />\n{$subscriptionType}<br />\n<br />\nTo access content that is available only to subscribers, simply log in to the system with your username, &quot;{$recipientUsername}&quot;.<br />\n<br />\nOnce you have logged in to the system you can change your profile details and password at any point.<br />\n<br />\nPlease note that if you have an institutional subscription, there is no need for users at your institution to log in, since requests for subscription content will be automatically authenticated by the system.<br />\n<br />\nIf you have any questions, please feel free to contact me.<br />\n<br />\n{$subscriptionSignature}'),
(281, 'OPEN_ACCESS_NOTIFY', 'de', 'Open Access Benachrichtigung', 'Frei zugänglich: {$issueIdentification} der Zeitschrift {$journalName} ist jetzt Open Access', '<p>Sehr geehrte/r {$recipientName},</p><p>wir freuen uns, Ihnen mitteilen zu können, dass <a href="{$issueUrl}">{$issueIdentification}</a> der Zeitschrift {$journalName} jetzt im Open Access verfügbar ist. Ein Abonnement ist nicht mehr erforderlich, um diese Ausgabe zu lesen.</p><p>Wir danken Ihnen für Ihr anhaltendes Interesse an unserer Arbeit.</p>{$journalSignature}'),
(282, 'OPEN_ACCESS_NOTIFY', 'es', 'Notificación de acceso abierto', 'Acceso libre: {$issueIdentification} de {$journalName} ahora está disponible en acceso abierto', '<p>Estimado/a {$recipientName},</p><p>Nos complace informarle de que <a href="{$issueUrl}">{$issueIdentification}</a> de {$journalName} ya está disponible en acceso abierto. Por lo tanto, ya no es necesaria una suscripción para leer este número.</p><p>Gracias por mantener el interés en nuestro trabajo.</p>{$journalSignature}'),
(283, 'OPEN_ACCESS_NOTIFY', 'fr_CA', 'Notification de diffusion en libre accès', 'Gratuitement accessible : le numéro {$issueIdentification} de la revue {$journalName} est maintenant en accès libre', '<p>Chers lecteurs et lectrices,</p><p>La revue {$journalName} vient de rendre disponible en libre accès le numéro suivant. Nous vous invitons à lire ici le sommaire puis visiter notre site Web ({$journalUrl}) pour lire les articles et autres textes qui pourraient vous intéresser.</p><p>Merci de votre intérêt continu pour notre travail.</p>{$journalSignature}'),
(284, 'OPEN_ACCESS_NOTIFY', 'it', 'Notifica di accesso aperto', 'Nuovo fascicolo ad accesso aperto: {$issueIdentification} di {$journalName}', '<p>Gentile {$recipientName},</p><p>Siamo lieti di informarLa che <a href="{$issueUrl}">{$issueIdentification}</a> di {$journalName} è ora disponibile in modalità ad accesso aperto.  Non è più richiesto alcun abbonamento per poter accedere a tale rivista.</p><p>Grazie per la sua cortese attenzione, e con i più cordiali saluti,</p>{$journalSignature}'),
(285, 'OPEN_ACCESS_NOTIFY', 'nl', 'Open Access Notificatie', 'Nummer nu Open Access', '<p>Beste {$recipientName},</p><p>We zijn blij u te kunnen informeren dat <a href=“{$issueUrl}”>{$issueIdentification}</a> van {$journalName} nu open access beschikbaar is. Een abonnement is niet langer vereist om dit nummer te lezen.</p><p>Bedankt voor uw voortdurende interesse in ons werk.</p>{$journalSignature}'),
(286, 'OPEN_ACCESS_NOTIFY', 'ru', 'Уведомление об открытом доступе', 'Читать бесплатно: {$issueIdentification} журнала «{$journalName}» теперь в открытом доступе', '<p>Здравствуйте, {$recipientName}!</p><p>Журнал «{$journalName}» рад сообщить, что выпуск <a href="{$issueUrl}">{$issueIdentification}</a> теперь находится в открытом доступе. Для чтения этого номера подписка больше не требуется.</p><p>Благодарю Вас за постоянный интерес к нашей работе,</p>{$journalSignature}'),
(287, 'OPEN_ACCESS_NOTIFY', 'en', 'Open Access Notify', 'Free to read: {$issueIdentification} of {$journalName} is now open access', '<p>Dear {$recipientName},</p><p>We are pleased to inform you that <a href="{$issueUrl}">{$issueIdentification}</a> of {$journalName} is now available under open access.  A subscription is no longer required to read this issue.</p><p>Thank you for your continuing interest in our work.</p>{$journalSignature}'),
(288, 'SUBSCRIPTION_BEFORE_EXPIRY', 'de', 'Abonnement läuft bald aus', 'Benachrichtigung über das Ablaufen eines Abonnements', 'Sehr geehrte/r {$recipientName}<br />\n<br />\nIhr Abonnement für {$journalName} läuft in Kürze ab.<br />\n<br />\n{$subscriptionType}<br />\nVerfallsdatum: {$expiryDate}<br />\n<br />\nUm sicherzustellen, dass Sie weiterhin Zugang zu dieser Zeitschrift haben, gehen Sie bitte auf die Website der Zeitschrift und verlängern Sie Ihr Abonnement. Sie können sich mit Ihrem Benutzernamen "{$recipientUsername}" in das System einloggen.<br />\n<br />\nWenn Sie Fragen haben, können Sie mich gerne kontaktieren.<br />\n<br />\n{$subscriptionSignature}'),
(289, 'SUBSCRIPTION_BEFORE_EXPIRY', 'es', 'La suscripción caduca pronto', 'Notificación de expiración de suscripción', '{$recipientName}:<br />\n<br />\n	Su suscripción a {$journalName} está a punto de caducar.<br />\n<br />\n	{$subscriptionType}<br />\n	Fecha de caducidad: {$expiryDate}<br />\n<br />\n	Para asegurarse de que continúa teniendo acceso a la revista, acceda a la página web de la revista y renueve su suscripción. Puede iniciar sesión en el sistema con su nombre de usuario/a, &quot;{$recipientUsername}&quot;.<br />\n<br />\n	Si tiene cualquier pregunta no dude en contactarme.<br />\n<br />\n	{$subscriptionSignature}'),
(290, 'SUBSCRIPTION_BEFORE_EXPIRY', 'fr_CA', 'L''abonnement arrive bientôt à échéance', 'Avis d''expiration de l''abonnement', '{$recipientName},<br />\n<br />\nVotre abonnement à la revue {$journalName} expirera bientôt.<br />\n<br />\n{$subscriptionType}<br />\nDate d''expiration : {$expiryDate}<br />\n<br />\nAfin d''assurer la continuité de votre accès à cette revue, nous vous invitons à aller sur le site Web de la revue et à renouveler votre abonnement. Vous pouvez vous y ouvrir une session avec votre nom d''utilisateur-trice, soit « {$recipientUsername} ».<br />\n<br />\nSi vous avez des questions, ne pas hésiter à communiquer avec nous.<br />\n<br />\n{$subscriptionSignature}'),
(291, 'SUBSCRIPTION_BEFORE_EXPIRY', 'it', 'L''abbonamento scade tra poco', 'Avviso di scadenza dell''abbonamento', 'Gentile {$recipientName}:<br />\n<br />\nIl suo abbonamento a {$journalName} sta per scadere.<br />\n<br />\n{$subscriptionType}<br />\nData di scadenza: {$expiryDate}<br />\n<br />\nPer continuare ad accedere a questa rivista, si rechi sul sito e rinnovi l''abbonamento. Per l''accesso utilizzi la sua username, &quot;{$recipientUsername}&quot;.<br />\n<br />\nPer qualsiasi domanda e ulteriore informazione, non esiti a contattarci.<br />\n<br />\n{$subscriptionSignature}'),
(292, 'SUBSCRIPTION_BEFORE_EXPIRY', 'nl', 'Abonnement verloopt binnenkort', 'Bericht van aflopen abonnement', '{$recipientName}:<br />\n<br />\nUw abonnement op {$journalName} verloopt binnenkort.<br />\n<br />\n{$subscriptionType}<br />\nAfloopdatum: {$expiryDate}<br />\n<br />\nOm de continuïteit van uw toegang tot het tijdschrift te verzekeren kunt u uw abonnement verlengen op de website van het tijdschrift. U kunt inloggen op de website van het tijdschrift met uw gebruikersnaam &quot;{$recipientUsername}&quot;.<br />\n<br />\nAarzel niet om contact met me op te nemen als u vragen heeft.<br />\n<br />\n{$subscriptionSignature}'),
(293, 'SUBSCRIPTION_BEFORE_EXPIRY', 'ru', 'Подписка скоро заканчивается', 'Уведомление об окончании срока подписки', 'Здравствуйте, {$recipientName}!<br />\n<br />\nВаша подписка на журнал «{$journalName}» истекает в ближайшее время.<br />\n<br />\n{$subscriptionType}<br />\nДата окончания подписки: {$expiryDate}<br />\n<br />\nЧтобы Ваш доступ к этому журналу не прерывался, пожалуйста, перейдите на сайт журнала и продлите Вашу подписку. Вы можете войти на сайт журнала со своим именем пользователя «{$recipientUsername}».<br />\n<br />\nЕсли у Вас есть какие-либо вопросы, пожалуйста, не стесняйтесь, связывайтесь со мной.<br />\n<br />\n{$subscriptionSignature}'),
(294, 'SUBSCRIPTION_BEFORE_EXPIRY', 'en', 'Subscription Expires Soon', 'Notice of Subscription Expiry', '{$recipientName}:<br />\n<br />\nYour {$journalName} subscription is about to expire.<br />\n<br />\n{$subscriptionType}<br />\nExpiry date: {$expiryDate}<br />\n<br />\nTo ensure the continuity of your access to this journal, please go to the journal website and renew your subscription. You are able to log in to the system with your username, &quot;{$recipientUsername}&quot;.<br />\n<br />\nIf you have any questions, please feel free to contact me.<br />\n<br />\n{$subscriptionSignature}'),
(295, 'SUBSCRIPTION_AFTER_EXPIRY', 'de', 'Abonnement abgelaufen', 'Abonnement abgelaufen', 'Sehr geehrte/r {$recipientName}<br />\n<br />\nIhr Abonnement für {$journalName} ist abgelaufen.<br />\n<br />\n{$subscriptionType}<br />\nVerfallsdatum: {$expiryDate}<br />\n<br />\nUm Ihr Abonnement zu erneuern, gehen Sie bitte auf die Website der Zeitschrift. Sie können sich mit Ihrem Benutzernamen "{$recipientUsername}" in das System einloggen.<br />\n<br />\nWenn Sie Fragen haben, können Sie mich gerne kontaktieren.<br />\n<br />\n{$subscriptionSignature}'),
(296, 'SUBSCRIPTION_AFTER_EXPIRY', 'es', 'Suscripción caducada', 'Subscripción expirada', '{$recipientName}:<br />\n<br />\n	Su suscripción a {$journalName} ha caducado.<br />\n<br />\n	{$subscriptionType}<br />\n	Fecha de caducidad: {$expiryDate}<br />\n<br />\n	Para renovar su suscripción acceda a la página web de la revista. Puede iniciar sesión en el sistema con su nombre de usuario/a, &quot;{$recipientUsername}&quot;.<br />\n<br />\n	Si tiene cualquier pregunta no dude en contactarme.<br />\n<br />\n	{$subscriptionSignature}'),
(297, 'SUBSCRIPTION_AFTER_EXPIRY', 'fr_CA', 'Abonnement échu', 'Abonnement expiré', '{$recipientName},<br />\n<br />\nVotre abonnement à la revue {$journalName} est expiré.<br />\n<br />\n{$subscriptionType}<br />\nDate d''expiration : {$expiryDate}<br />\n<br />\nPour renouveler votre abonnement, veuillez vous rendre sur le site Web de la revue. Vous pouvez y ouvrir une session en utilisant votre nom d''utilisateur-trice, soit « {$recipientUsername} ».<br />\n<br />\nSi vous avez des questions, n''hésitez pas à communiquer avec nous.<br />\n<br />\n{$subscriptionSignature}'),
(298, 'SUBSCRIPTION_AFTER_EXPIRY', 'it', 'Abbonamento scaduto', 'Abbonamento scaduto', 'Gentile {$recipientName}:<br />\n<br />\nIl suo abbonamento a {$journalName} è scaduto.<br />\n<br />\n{$subscriptionType}<br />\nData di scadenza: {$expiryDate}<br />\n<br />\nPer rinnovare l''abbonamento, si rechi sul nostro sito. Per l''accesso utilizzi la sua username, &quot;{$recipientUsername}&quot;.<br />\n<br />\nPer qualsiasi domanda e ulteriore informazione, non esiti a contattarmi.<br />\n<br />\n{$subscriptionSignature}'),
(299, 'SUBSCRIPTION_AFTER_EXPIRY', 'nl', 'Abonnement verlopen', 'Abonnement verlopen - laatste herinnering', '{$recipientName}:<br />\n<br />\nUw abonnement op {$journalName} is verlopen.<br />\n<br />\n{$subscriptionType}<br />\nAfloopdatum: {$expiryDate}<br />\n<br />\nOm uw abonnement te verlengen kunt u inloggen op de website van het tijdschrift met uw gebruikersnaam &quot;{$recipientUsername}&quot;.<br />\n<br />\nAarzel niet om contact met me op te nemen als u vragen heeft.<br />\n<br />\n{$subscriptionSignature}'),
(300, 'SUBSCRIPTION_AFTER_EXPIRY', 'ru', 'Подписка закончилась', 'уведомление об окончании срока подписки', 'Здравствуйте, {$recipientName}!<br />\n<br />\nЗакончилась Ваша подписка на «{$journalName}».<br />\n<br />\n{$subscriptionType}<br />\nДата окончания: {$expiryDate}<br />\n<br />\nДля возобновления подписки, пожалуйста зайдите на сайт журнала. Вы можете авторизоваться в системе с помощью вашего логина &quot;{$recipientUsername}&quot;.<br />\n<br />\nЕсли у Вас возникли вопросы, пожалуйста, свяжитесь со мной.<br />\n<br />\n{$subscriptionSignature}'),
(301, 'SUBSCRIPTION_AFTER_EXPIRY', 'en', 'Subscription Expired', 'Subscription Expired', '{$recipientName}:<br />\n<br />\nYour {$journalName} subscription has expired.<br />\n<br />\n{$subscriptionType}<br />\nExpiry date: {$expiryDate}<br />\n<br />\nTo renew your subscription, please go to the journal website. You are able to log in to the system with your username, &quot;{$recipientUsername}&quot;.<br />\n<br />\nIf you have any questions, please feel free to contact me.<br />\n<br />\n{$subscriptionSignature}'),
(302, 'SUBSCRIPTION_AFTER_EXPIRY_LAST', 'de', 'Zuletzt abgelaufenes Abbonement', 'Abonnement abgelaufen - Letzte Erinnerung', 'Sehr geehrte/r {{$recipientName}<br />\n<br />\nIhr Abonnement für {$journalName} ist abgelaufen.<br />\nBitte beachten Sie, dass dies die letzte Erinnerung ist, die Sie per E-Mail erhalten werden.<br />\n<br />\n{$subscriptionType}<br />\nVerfallsdatum: {$expiryDate}<br />\n<br />\nUm Ihr Abonnement zu verlängern, gehen Sie bitte auf die Website der Zeitschrift. Sie können sich mit Ihrem Benutzernamen "{$recipientUsername}" in das System einloggen.<br />\n<br />\nWenn Sie Fragen haben, können Sie mich gerne kontaktieren.<br />\n<br />\n{$subscriptionSignature}'),
(303, 'SUBSCRIPTION_AFTER_EXPIRY_LAST', 'es', 'Última suscripción caducada', 'Suscripción expirada - Último recordatorio', '{$recipientName}:<br />\n<br />\n	Su suscripción a {$journalName} ha caducado.<br />\n	Tenga en cuenta que este es el último correo que recibirá para recordárselo.<br />\n<br />\n	{$subscriptionType}<br />\n	Fecha de caducidad: {$expiryDate}<br />\n<br />\n	Para renovar su suscripción acceda a la página web de la revista. Puede iniciar sesión en el sistema con su nombre de usuario/a, &quot;{$recipientUsername}&quot;.<br />\n<br />\n	Si tiene cualquier pregunta no dude en contactarme.<br />\n<br />\n	{$subscriptionSignature}'),
(304, 'SUBSCRIPTION_AFTER_EXPIRY_LAST', 'fr_CA', 'Abonnement échu en dernier', 'Abonnement expiré - Dernier rappel', '<p>Bonjour {$recipientName},</p><p>Votre abonnement à la revue {$journalName} est expiré. Veuillez prendre note que ceci est le dernier rappel qui vous sera envoyé.</p><p>{$subscriptionType}</p>\n<p>Date d''expiration : {$expiryDate}</p><p>Pour renouveler votre abonnement, veuillez vous rendre sur le site Web de la revue. Vous pouvez y ouvrir une session avec votre nom d''utilisateur-trice, soit « {$recipientUsername} ».</p><p>Si vous avez des questions, ne hésitez pas à communiquer avec nous.</p>{$subscriptionSignature}'),
(305, 'SUBSCRIPTION_AFTER_EXPIRY_LAST', 'it', 'Abbonamento scaduto l''ultima volta', 'Abbonamento scaduto (ultimo avviso)', 'Gentile {$recipientName}:<br />\n<br />\nIl Suo abbonamento a {$journalName} è scaduto.<br />\nQuesto è l''ultimo promemoria che Le sarà inviato via e-mail.<br />\n<br />\n{$subscriptionType}<br />\nData di scadenza: {$expiryDate}<br />\n<br />\nPer rinnovare l''abbonamento visiti il sito della rivista. Per l''accesso utilizzi il suo username &quot;{$recipientUsername}&quot;.<br />\n<br />\nPer qualsiasi domanda e ulteriore informazione, non esiti a contattarci.<br />\n<br />\n{$subscriptionSignature}'),
(306, 'SUBSCRIPTION_AFTER_EXPIRY_LAST', 'nl', 'Abonnement is verlopen sinds', 'Abonnement verlopen - laatste herinnering', '{$recipientName}:<br />\n<br />\nUw abonnement op {$journalName} is verlopen.<br />\nDit is de laatste herinnering die naar u wordt verstuurd.<br />\n<br />\n{$subscriptionType}<br />\nAfloopdatum: {$expiryDate}<br />\n<br />\nOm uw abonnement te verlengen, kunt u naar de website van het tijdschrift gaan en inloggen met uw gebruikersnaam: &quot;{$recipientUsername}&quot;.<br />\n<br />\nAarzel niet om contact met mij op te nemen als u vragen heeft.<br />\n<br />\n{$subscriptionSignature}'),
(307, 'SUBSCRIPTION_AFTER_EXPIRY_LAST', 'ru', 'Подписка недавно закончилась', 'Срок подписки истек — последнее напоминание', 'Здравствуйте, {$recipientName}!<br />\n<br />\nСрок Вашей подписки на журнал «{$journalName}» истек.<br />\nПожалуйста, обратите внимание, что это — последнее напоминание, которое будет отправлено Вам электронной почтой.<br />\n<br />\n{$subscriptionType}<br />\nДата окончания подписки: {$expiryDate}<br />\n<br />\nДля продления Вашей подписки, пожалуйста, перейдите на сайт журнала. Вы можете войти на сайт журнала со своим именем пользователя «{$recipientUsername}».<br />\n<br />\nЕсли у Вас есть какие-либо вопросы, пожалуйста, не стесняйтесь, связывайтесь со мной.<br />\n<br />\n{$subscriptionSignature}'),
(308, 'SUBSCRIPTION_AFTER_EXPIRY_LAST', 'en', 'Subscription Expired Last', 'Subscription Expired - Final Reminder', '{$recipientName}:<br />\n<br />\nYour {$journalName} subscription has expired.<br />\nPlease note that this is the final reminder that will be emailed to you.<br />\n<br />\n{$subscriptionType}<br />\nExpiry date: {$expiryDate}<br />\n<br />\nTo renew your subscription, please go to the journal website. You are able to log in to the system with your username, &quot;{$recipientUsername}&quot;.<br />\n<br />\nIf you have any questions, please feel free to contact me.<br />\n<br />\n{$subscriptionSignature}'),
(309, 'SUBSCRIPTION_PURCHASE_INDL', 'de', 'Ein individuelles Abonnement kaufen', 'Abonnementkauf: Individuell', 'Ein individuelles Abonnement wurde online für {$journalName} mit den folgenden Details erworben.<br />\n<br />\nAbonnementtyp:<br />\n{$subscriptionType}<br />\n<br />\nBenutzer:<br />\n{$subscriberDetails}<br />\n<br />\nMitgliedschaftsinformationen (falls vorhanden):<br />\n{$membership}<br />\n<br />\nUm dieses Abonnement anzuzeigen oder zu bearbeiten, verwenden Sie bitte die folgende URL.<br />\n<br />\nAbonnement-URL: {$subscriptionUrl}<br />\n'),
(310, 'SUBSCRIPTION_PURCHASE_INDL', 'es', 'Adquirir suscripción individual', 'Compra de suscripción: Individual', 'Se ha adquirido en línea una suscripción individual para {$journalName} con los detalles siguientes:<br />\n<br />\nTipo de suscripción:<br />\n{$subscriptionType}<br />\n<br />\nUsuario/a:<br />\n{$subscriberDetails}<br />\n<br />\nInformación de membresía (si se proporciona):<br />\n{$membership}<br />\n<br />\nPara ver o editar esta suscripción, use la siguiente URL.<br />\n<br />\nURL de la suscripción: {$subscriptionUrl}<br />\n'),
(311, 'SUBSCRIPTION_PURCHASE_INDL', 'fr_CA', 'Acheter un abonnement individuel', 'Souscription à un abonnement individuel', 'Une souscription en ligne à un abonnement individuel pour la revue {$journalName} avec les renseignements suivants :<br />\n<br />\nType d''abonnement :<br />\n{$subscriptionType}<br />\n<br />\nUtilisateur-trice :<br />\n{$subscriberDetails}<br />\n<br />\nInformation d''adhésion (si fournie) :<br />\n{$membership}<br />\n<br />\nPour afficher ou modifier cet abonnement, veuillez utiliser l''URL suivante.<br />\n<br />\nURL d''abonnement : {$subscriptionUrl}<br/>\n'),
(312, 'SUBSCRIPTION_PURCHASE_INDL', 'it', 'Acquisto di un abbonamento individuale', 'Acquisto di un abbonamento individuale', 'Un abbonamento individuale è stato acquistato per {$journalName} con i seguenti dettagli.<br />\n<br />\nTipologia di abbonamento:<br />\n{$subscriptionType}<br />\n<br />\nUser:<br />\n{$subscriberDetails}<br />\n<br />\nInformazioni sulla sottoscrizione (se sono state fornite):<br />\n{$membership}<br />\n<br />\nPer visualizzare o modificare questo abbonamento, utilizzare il seguente URL.<br />\n<br />\nSubscription URL: {$subscriptionUrl}<br />\n'),
(313, 'SUBSCRIPTION_PURCHASE_INDL', 'nl', 'Koop individueel abonnement', 'Aankoop abonnement: individueel', 'Een individueel abonnement met de volgende details is online aangeschaft voor {$journalName}.<br />\n<br />\nAbonnementsoort:<br />\n{$subscriptionType}<br />\n<br />\nGebruiker:<br />\n{$subscriberDetails}<br />\n<br />\nLidmaatschapsinformatie (indien opgegeven):<br />\n{$membership}<br />\n<br />\nGebruik de volgende URL om dit abonnement te bekijken of te wijzigen.<br />\n<br />\nAbonnement URL: {$subscriptionUrl}<br />\n'),
(314, 'SUBSCRIPTION_PURCHASE_INDL', 'ru', 'Приобрести индивидуальную подписку', 'Покупка подписки: индивидуальная', 'На сайте была приобретена индивидуальная подписка на журнал «{$journalName}» со следующими деталями.<br />\n<br />\nТип подписки:<br />\n{$subscriptionType}<br />\n<br />\nПользователь:<br />\n{$subscriberDetails}<br />\n<br />\nИнформация о членстве (если указана):<br />\n{$membership}<br />\n<br />\nДля просмотра или редактирования этой подписки, пожалуйста, используйте следующий URL.<br />\n<br />\nURL подписки: {$subscriptionUrl}<br />\n'),
(315, 'SUBSCRIPTION_PURCHASE_INDL', 'en', 'Purchase Individual Subscription', 'Subscription Purchase: Individual', 'An individual subscription has been purchased online for {$journalName} with the following details.<br />\n<br />\nSubscription Type:<br />\n{$subscriptionType}<br />\n<br />\nUser:<br />\n{$subscriberDetails}<br />\n<br />\nMembership Information (if provided):<br />\n{$membership}<br />\n<br />\nTo view or edit this subscription, please use the following URL.<br />\n<br />\nSubscription URL: {$subscriptionUrl}<br />\n');
INSERT INTO `email_templates_default_data` VALUES
(316, 'SUBSCRIPTION_PURCHASE_INSTL', 'de', 'Ein institutionelles Abonnement kaufen', 'Abonnementkauf: Institutionell', 'Ein institutionelles Abonnement wurde online für {$journalName} mit den folgenden Details erworben. Um dieses Abonnement zu aktivieren, verwenden Sie bitte die bereitgestellte Abonnement-URL und setzen Sie den Abonnementstatus auf ''Aktiv''.<br />\n<br />\nAbonnementtyp:<br />\n{$subscriptionType}<br />\n<br />\nInstitution:<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nDomain (falls vorhanden):<br />\n{$domain}<br />\n<br />\nIP-Bereiche (falls angegeben):<br />\n{$ipRanges}<br />\n<br />\nKontaktperson:<br />\n{$subscriberDetails}<br />\n<br />\nMitgliedschaftsinformationen (falls vorhanden):<br />\n{$membership}<br />\n<br />\nUm dieses Abonnement anzuzeigen oder zu bearbeiten, verwenden Sie bitte die folgende URL.<br />\n<br />\nAbonnement-URL: {$subscriptionUrl}<br />\n'),
(317, 'SUBSCRIPTION_PURCHASE_INSTL', 'es', 'Adquirir suscripción institucional', 'Compra de suscripción: Institucional', 'Se ha adquirido en línea una suscripción institucional para {$journalName} con los siguientes detalles. Para activar la suscripción, use el enlace proporcionado y configure el estado de la suscripción como ''Activo''.<br />\n<br />\nTipo de suscripción:<br />\n{$subscriptionType}<br />\n<br />\nInstitución:<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nDominio (si se proporciona):<br />\n{$domain}<br />\n<br />\nRangos de IP (si se proporcionan):<br />\n{$ipRanges}<br />\n<br />\nPersona de contacto:<br />\n{$subscriberDetails}<br />\n<br />\nInformación de membresía (si se proporciona):<br />\n{$membership}<br />\n<br />\nPara ver o editar esta suscripción, use el siguiente enlace.<br />\n<br />\nEnlace de la suscripción: {$subscriptionUrl}<br />\n'),
(318, 'SUBSCRIPTION_PURCHASE_INSTL', 'fr_CA', 'Acheter un abonnement institutionnel', 'Souscription à un abonnement institutionnel', 'Souscription en ligne à un abonnement institutionnel pour la revue {$journalName} avec les renseignements suivants. Pour activer cet abonnement, veuillez utiliser l''URL d''abonnement fourni et fixer le statut de l''abonnement à « actif ».<br />\n<br />\nType d''abonnement :<br />\n{$subscriptionType}<br />\n<br />\nÉtablissement :<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nDomaine (si fourni) :<br />\n{$domain}<br />\n<br />\nPlage d''adresses IP (si fournie) :<br />\n{$ipRanges}<br />\n<br />\nPersonne-ressource :<br />\n{$subscriberDetails}<br />\n<br />\nRenseignements d''adhésion (si fournis) :<br />\n{$membership}<br />\n<br />\nPour afficher ou modifier cet abonnement, veuillez utiliser l''URL suivant :<br />\n<br />\nURL de l''abonnement : {$subscriptionUrl}<br />\n'),
(319, 'SUBSCRIPTION_PURCHASE_INSTL', 'it', 'Acquisto di un abbonamento istituzionale', 'Acquisto di un abbonamento istituzionale', 'È stato acquistato un abbonamento istituzionale a {$journalName} con i dettagli indicati sotto. Per attivare l''abbonamento, utilizzare il link fornito sotto e selezionare lo status ''Attivo'' per tale abbonamento.<br />\n<br />\nTipologia di abbonamento::<br />\n{$subscriptionType}<br />\n<br />\nInstituzione:<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nDominio (se indicato):<br />\n{$domain}<br />\n<br />\nIndirizzi IP (se indicati):<br />\n{$ipRanges}<br />\n<br />\nPersona di contatto:<br />\n{$subscriberDetails}<br />\n<br />\nTipologia di membership (se indicata):<br />\n{$membership}<br />\n<br />\nPer vedere o modificare i dettagli, andare alla pagina:<br />\n<br />\nSubscription URL: {$subscriptionUrl}<br />\n'),
(320, 'SUBSCRIPTION_PURCHASE_INSTL', 'nl', 'Koop instituutsabonnement', 'Aankoop abonnement: institutioneel', 'Er is online een institutioneel abonnement gekocht voor {$journalName} met de volgende details. Gebruik de abonnement-url om dit abonnement te activeren. Zet de status van het abonnement op ''Actief''.<br />\n<br />\nAbonnementsoort:<br />\n{$subscriptionType}<br />\n<br />\nInstituut:<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nDomein (indien opgegeven):<br />\n{$domain}<br />\n<br />\nIP reeksen (indien opgegeven):<br />\n{$ipRanges}<br />\n<br />\nContactpersoon:<br />\n{$subscriberDetails}<br />\n<br />\nLidmaatschapsinformatie (indien opgegeven):<br />\n{$membership}<br />\n<br />\nGebruik de volgende URL om het abonnement te bekijken of te bewerken.<br />\n<br />\nAbonnement URL: {$subscriptionUrl}<br />\n'),
(321, 'SUBSCRIPTION_PURCHASE_INSTL', 'ru', 'Приобрести подписку на организацию', 'Покупка подписки: на организацию', 'На сайте была приобретена для организации подписка на журнал «{$journalName}» со следующими деталями. Для активации подписки, пожалуйста, используйте приведенный URL подписки и установите статус подписки в «Активна».<br />\n<br />\nТип подписки:<br />\n{$subscriptionType}<br />\n<br />\nОрганизация:<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nДоменное имя (если указано):<br />\n{$domain}<br />\n<br />\nIP-диапазоны (если указаны):<br />\n{$ipRanges}<br />\n<br />\nКонтактное лицо:<br />\n{$subscriberDetails}<br />\n<br />\nИнформация о членстве (если указана):<br />\n{$membership}<br />\n<br />\nДля просмотра или редактирования этой подписки, пожалуйста, используйте следующий URL.<br />\n<br />\nURL подписки: {$subscriptionUrl}<br />\n'),
(322, 'SUBSCRIPTION_PURCHASE_INSTL', 'en', 'Purchase Institutional Subscription', 'Subscription Purchase: Institutional', 'An institutional subscription has been purchased online for {$journalName} with the following details. To activate this subscription, please use the provided Subscription URL and set the subscription status to ''Active''.<br />\n<br />\nSubscription Type:<br />\n{$subscriptionType}<br />\n<br />\nInstitution:<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nDomain (if provided):<br />\n{$domain}<br />\n<br />\nIP Ranges (if provided):<br />\n{$ipRanges}<br />\n<br />\nContact Person:<br />\n{$subscriberDetails}<br />\n<br />\nMembership Information (if provided):<br />\n{$membership}<br />\n<br />\nTo view or edit this subscription, please use the following URL.<br />\n<br />\nSubscription URL: {$subscriptionUrl}<br />\n'),
(323, 'SUBSCRIPTION_RENEW_INDL', 'de', 'Individuelles Abonnement erneuern', 'Abonnementerneuerung: Individuell', 'Ein individuelles Abonnement wurde online für {$journalName} mit den folgenden Details verlängert.<br />\n<br />\nAbonnementtyp:<br />\n{$subscriptionType}<br />\n<br />\nBenutzer:<br />\n{$subscriberDetails}<br />\n<br />\nMitgliedschaftsinformationen (falls vorhanden):<br />\n{$membership}<br />\n<br />\nUm dieses Abonnement anzuzeigen oder zu bearbeiten, verwenden Sie bitte die folgende URL.<br />\n<br />\nAbonnement-URL: {$subscriptionUrl}<br />\n'),
(324, 'SUBSCRIPTION_RENEW_INDL', 'es', 'Renovar suscripción individual', 'Renovación de suscripción: Individual', 'Una suscripción individual ha sido renovada en línea para {$journalName} con los siguientes detalles.<br />\n<br />\nTipo de suscripción:<br />\n{$subscriptionType}<br />\n<br />\nUsuario/a:<br />\n{$subscriberDetails}<br />\n<br />\nInformación de membresía (si se proporciona):<br />\n{$membership}<br />\n<br />\nPara ver o editar esta suscripción use la siguiente URL:<br />\n<br />\nURL para gestionar la suscripción: {$subscriptionUrl}<br />\n'),
(325, 'SUBSCRIPTION_RENEW_INDL', 'fr_CA', 'Renouveler l''abonnement individuel', 'Renouvellement d''abonnement individuel', 'Un abonnement individuel a été renouvelé en ligne pour la revue {$journalName} avec les renseignements suivants.<br />\n<br />\nType d''abonnement :<br />\n{$subscriptionType}<br />\n<br />\nUtilisateur-trice :<br />\n{$subscriberDetails}<br />\n<br />\nRenseignements d''adhésion (si fournis) :<br />\n{$membership}<br />\n<br />\nPour afficher ou modifier cet abonnement, veuillez utiliser l''URL suivant.<br />\n<br />\nURL de l''abonnement : {$subscriptionUrl}<br />\n'),
(326, 'SUBSCRIPTION_RENEW_INDL', 'it', 'Rinnovo dell''abbonamento individuale', 'Rinnovo dell''abbonamento individuale', 'È stato rinnovato un abbonamento individuale a {$journalName} con i seguenti dettagli.<br />\n<br />\nTipologia di abbonamento:<br />\n{$subscriptionType}<br />\n<br />\nUtente:<br />\n{$subscriberDetails}<br />\n<br />\nMembership (se indicata):<br />\n{$membership}<br />\n<br />\nPer vedere o modificare i dettagli dell''abbonamento, andare alla seguente pagina:<br />\n<br />\nSubscription URL: {$subscriptionUrl}<br />\n'),
(327, 'SUBSCRIPTION_RENEW_INDL', 'nl', 'Vernieuw individueel abonnement', 'Verlenging abonnement: individueel', 'Een individueel abonnement is met de volgende details online verlengd voor {$journalName}.<br />\n<br />\nAbonnementsoort:<br />\n{$subscriptionType}<br />\n<br />\nGebruiker:<br />\n{$subscriberDetails}<br />\n<br />\nLidmaatschapsinformatie (indien opgegeven):<br />\n{$membership}<br />\n<br />\nGebruik de volgende URL om het abonnement te bekijken of bewerken.<br />\n<br />\nAbonnement URL: {$subscriptionUrl}<br />\n'),
(328, 'SUBSCRIPTION_RENEW_INDL', 'ru', 'Продлить индивидуальную подписку', 'Продление подписки: индивидуальная', 'На сайте была продлена индивидуальная подписка на журнал «{$journalName}» со следующими деталями.<br />\n<br />\nТип подписки:<br />\n{$subscriptionType}<br />\n<br />\nПользователь:<br />\n{$subscriberDetails}<br />\n<br />\nИнформация о членстве (если указана):<br />\n{$membership}<br />\n<br />\nДля просмотра или редактирования этой подписки, пожалуйста, используйте следующий URL.<br />\n<br />\nURL подписки: {$subscriptionUrl}<br />\n'),
(329, 'SUBSCRIPTION_RENEW_INDL', 'en', 'Renew Individual Subscription', 'Subscription Renewal: Individual', 'An individual subscription has been renewed online for {$journalName} with the following details.<br />\n<br />\nSubscription Type:<br />\n{$subscriptionType}<br />\n<br />\nUser:<br />\n{$subscriberDetails}<br />\n<br />\nMembership Information (if provided):<br />\n{$membership}<br />\n<br />\nTo view or edit this subscription, please use the following URL.<br />\n<br />\nSubscription URL: {$subscriptionUrl}<br />\n'),
(330, 'SUBSCRIPTION_RENEW_INSTL', 'de', 'Institutionelles Abonnement erneuern', 'Abonnementerneuerung: Institutionell', 'Ein institutionelles Abonnement wurde online für {$journalName} mit den folgenden Angaben verlängert.<br />\n<br />\nAbonnementtyp:<br />\n{$subscriptionType}<br />\n<br />\nInstitution:<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nDomain (falls vorhanden):<br />\n{$domain}<br />\n<br />\nIP-Bereiche (falls angegeben):<br />\n{$ipRanges}<br />\n<br />\nKontaktperson:<br />\n{$subscriberDetails}<br />\n<br />\nMitgliedschaftsinformationen (falls vorhanden):<br />\n{$membership}<br />\n<br />\nUm dieses Abonnement anzuzeigen oder zu bearbeiten, verwenden Sie bitte die folgende URL.<br />\n<br />\nAbonnement-URL: {$subscriptionUrl}<br />\n'),
(331, 'SUBSCRIPTION_RENEW_INSTL', 'es', 'Renovar suscripción institucional', 'Renovación de suscripción: Institucional', 'Se ha renovado en línea una suscripción institucional para {$journalName} con los detalles siguientes.<br />\n<br />\nTipo de suscripción:<br />\n{$subscriptionType}<br />\n<br />\nInstitución:<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nDominio (si se proporciona):<br />\n{$domain}<br />\n<br />\nRangos IP (si se proporcionan):<br />\n{$ipRanges}<br />\n<br />\nPersona de contacto:<br />\n{$subscriberDetails}<br />\n<br />\nInformación de membresía (si se proporciona):<br />\n{$membership}<br />\n<br />\nPara ver o editar esta suscripción use la siguiente URL:<br />\n<br />\nURL para gestionar la suscripción: {$subscriptionUrl}<br />\n'),
(332, 'SUBSCRIPTION_RENEW_INSTL', 'fr_CA', 'Renouveler l''abonnement institutionnel', 'Renouvellement d''abonnement institutionnel', 'Un abonnement institutionnel a été renouvelé en ligne pour la revue {$journalName} avec les renseignements suivants.<br />\n<br />\nType d''abonnement :<br />\n{$subscriptionType}<br />\n<br />\nÉtablissement :<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nDomaine (si fourni) :<br />\n{$domain}<br />\n<br />\nPlage d''adresses IP (si fournie) :<br />\n{$ipRanges}<br />\n<br />\nPersonne-ressource :<br />\n{$subscriberDetails}<br />\n<br />\nRenseignements d''adhésion (si fournis) :<br />\n{$membership}<br />\n<br />\nPour afficher ou modifier cet abonnement, veuillez utiliser l''URL suivant.<br />\n<br />\nURL de l''abonnement : {$subscriptionUrl}<br />\n'),
(333, 'SUBSCRIPTION_RENEW_INSTL', 'it', 'Rinnovo dell''abbonamento istituzionale', 'Rinnovo dell''abbonamento istituzionale', 'È stato rinnovato online un abbonamento istituzionale a {$journalName} con i seguenti dettagli.<br />\n<br />\nTipologia di abbonamento:<br />\n{$subscriptionType}<br />\n<br />\nInstituzione:<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nDominio (se fornito):<br />\n{$domain}<br />\n<br />\nIndirizzi IP (se indicati):<br />\n{$ipRanges}<br />\n<br />\nPersona di contatto:<br />\n{$subscriberDetails}<br />\n<br />\nMembership (se indicata):<br />\n{$membership}<br />\n<br />\nPer vedere o modificare i dettagli, andare alla seguente pagina:<br />\n<br />\nSubscription URL: {$subscriptionUrl}<br />\n'),
(334, 'SUBSCRIPTION_RENEW_INSTL', 'nl', 'Vernieuw instituutsabonnement', 'Verlenging abonnement: institutioneel', 'Een institutioneell abonnement voor {$journalName} is met de volgende gegevens online verlengd.<br />\n<br />\nAbonnementsoort:<br />\n{$subscriptionType}<br />\n<br />\nInstituut:<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nDomein (indien opgegeven):<br />\n{$domain}<br />\n<br />\nIP reeksen (indien opgegeven):<br />\n{$ipRanges}<br />\n<br />\nContactpersoon:<br />\n{$subscriberDetails}<br />\n<br />\nLidmaatschapsinformatie (indien opgegeven):<br />\n{$membership}<br />\n<br />\nGebruik de volgende URL om dit abonnement te bekijken of bewerken.<br />\n<br />\nAbonnement URL: {$subscriptionUrl}<br />\n'),
(335, 'SUBSCRIPTION_RENEW_INSTL', 'ru', 'Продлить подписку на организацию', 'Продление подписки: на организацию', 'На сайте для организации была продлена подписка на журнал «{$journalName}» со следующими деталями.<br />\n<br />\nТип подписки:<br />\n{$subscriptionType}<br />\n<br />\nОрганизация:<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nДоменное имя (если указано):<br />\n{$domain}<br />\n<br />\nIP-диапазоны (если указаны):<br />\n{$ipRanges}<br />\n<br />\nКонтактное лицо:<br />\n{$subscriberDetails}<br />\n<br />\nИнформация о членстве (если указана):<br />\n{$membership}<br />\n<br />\nДля просмотра или редактирования этой подписки, пожалуйста, используйте следующий URL.<br />\n<br />\nURL подписки: {$subscriptionUrl}<br />\n'),
(336, 'SUBSCRIPTION_RENEW_INSTL', 'en', 'Renew Institutional Subscription', 'Subscription Renewal: Institutional', 'An institutional subscription has been renewed online for {$journalName} with the following details.<br />\n<br />\nSubscription Type:<br />\n{$subscriptionType}<br />\n<br />\nInstitution:<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nDomain (if provided):<br />\n{$domain}<br />\n<br />\nIP Ranges (if provided):<br />\n{$ipRanges}<br />\n<br />\nContact Person:<br />\n{$subscriberDetails}<br />\n<br />\nMembership Information (if provided):<br />\n{$membership}<br />\n<br />\nTo view or edit this subscription, please use the following URL.<br />\n<br />\nSubscription URL: {$subscriptionUrl}<br />\n'),
(337, 'REVISED_VERSION_NOTIFY', 'de', 'Benachrichtigung über eine überarbeitete Version', 'Überarbeitete Version hochgeladen', '<p>Liebe/r {$recipientName},</p><p>der Autor/die Autorin hat Überarbeitungen für die Einreichung <b>{$authorsShort} - {$submissionTitle}</b> hochgeladen. <p>Als zugewiesene/r Redakteur/in bitten wir Sie, sich einzuloggen und <a href="{$submissionUrl}">die Überarbeitungen</a> anzusehen und eine Entscheidung zu treffen, ob Sie die Einreichung annehmen, ablehnen oder zur weiteren Überprüfung weiterleiten möchten.</p><br><br>-<br>Dies ist eine automatische Nachricht von <a href="{$journalUrl}">{$journalName}</a>.'),
(338, 'REVISED_VERSION_NOTIFY', 'es', 'Notificación de versión revisada', 'Versión revisada cargada', '<p>Estimado/a {$recipientName},</p><p>El autor/a ha cargado revisiones para el envío, <b>{$authorsShort} — {$submissionTitle}</b>.</p><p>Como editor/a asignado, le solicitamos que inicie sesión, <a href="{$submissionUrl}">visualice las revisiones</a> y tome la decisión de aceptar, rechazar o remitir el envío a otra revisión.</p><br><br>—<br>Este es un mensaje automatizado de <a href="{$journalUrl}">{$journalName}</a>.'),
(339, 'REVISED_VERSION_NOTIFY', 'fr_CA', 'Notification de la version révisée', 'Version révisée téléversée', '<p>Bonjour {$recipientName},</p><p>Une version révisée de « {$submissionTitle} » a été téléversée par l''auteur-e {$submitterName}.</p><p>URL de la soumission : {$submissionUrl}</p>. <p>Ceci est un message automatique de <a href="{$journalUrl}">{$journalName}</a>.</p>'),
(340, 'REVISED_VERSION_NOTIFY', 'it', '', 'Caricamento della versione revisionata', '<p>Gentile {$recipientName},</p><p>L''autore ha caricato la revisione della sua proposta editoriale, <b>{$authorsShort} — {$submissionTitle}</b>. <p>In quanto editor assegnato, Le saremmo grati se potesse effettuare il login, <a href="{$submissionUrl}">visualizzare le revisioni</a> e infine decidere sull''accettazione, sul rifiuto, o sull''eventuale invio della proposta a ulteriori richieste di revisioni.</p><br><br>—<br>Questo è un messaggio automatico da <a href="{$journalUrl}">{$journalName}</a>.'),
(341, 'REVISED_VERSION_NOTIFY', 'nl', 'Bericht Herziene Versie', 'Herziene versie geladen', '{$recipientName}:<br />\n<br />\nEen herziene versie van &quot;{$submissionTitle}&quot; is geladen door de auteur {$submitterName}.<br />\n<br />\nURL van de inzending: {$submissionUrl}<br />\n<br />\n{$signature}'),
(342, 'REVISED_VERSION_NOTIFY', 'ru', 'Уведомление об измененной версии', 'Загружена исправленная версия', '<p>Здравствуйте, {$recipientName}!</p><p>Автор загрузил исправленную версию для материала <b>{$authorsShort} — «{$submissionTitle}»</b>. <p>Как назначенного редактора мы просим Вас войти в систему, <a href="{$submissionUrl}">просмотреть исправленную версию</a> и принять решение о приёме, отклонении или отправке материала на дальнейшее рецензирование.</p><br><br>—<br>Это автоматическое сообщение из журнала <a href="{$journalUrl}">«{$journalName}»</a>.'),
(343, 'REVISED_VERSION_NOTIFY', 'en', 'Revised Version Notification', 'Revised Version Uploaded', '<p>Dear {$recipientName},</p><p>The author has uploaded revisions for the submission, <b>{$authorsShort} — {$submissionTitle}</b>. <p>As an assigned editor, we ask that you login and <a href="{$submissionUrl}">view the revisions</a> and make a decision to accept, decline or send the submission for further review.</p><br><br>—<br>This is an automated message from <a href="{$journalUrl}">{$journalName}</a>.'),
(344, 'STATISTICS_REPORT_NOTIFICATION', 'de', 'Benachrichtigung über einen Statistikbericht', 'Redaktionelle Aktivitäten für {$month}, {$year}', '\nSehr geehrte/r {$recipientName} <br />\n<br />\nIhr Zeitschriftenbericht für {$month}, {$year} ist jetzt verfügbar. Ihre wichtigsten Statistiken für diesen Monat:<br />\n<ul>\n	<li>Neue Einreichungen diesen Monat: {$newSubmissions}</li>\n	<li>Abgelehnte Einreichungen diesen Monat: {$declinedSubmissions}</li>\n	<li>Angenommene Einsendungen in diesem Monat: {$acceptedSubmissions}</li>\n	<li>Gesamtanzahl der Einreichungen im System: {$totalSubmissions}</li>\n</ul>\nMelden Sie sich bei der Zeitschrift an, um detailliertere <a href="{$editorialStatsLink}">Redaktionstrends</a> und <a href="{$publicationStatsLink}">Statistiken zu veröffentlichten Artikeln</a> anzuzeigen. Eine vollständige Kopie der redaktionellen Trends für diesen Monat ist beigefügt.<br />\n<br />\nMit freundlichen Grüßen,<br />\n{$journalSignature}'),
(345, 'STATISTICS_REPORT_NOTIFICATION', 'es', 'Notificación de informe de estadísticas', 'Actividad editorial por {$month}, {$year}', '\n{$recipientName}, <br />\n<br />\nEl informe de estado de su revista de {$month}, {$year} ya está disponible. Las estadísticas clave de este mes son las siguientes.<br />\n<ul>\n	<li>Nuevos envíos este mes: {$newSubmissions}</li>\n	<li>Envíos rechazados este mes: {$declinedSubmissions}</li>\n	<li>Envíos aceptados este mes: {$acceptedSubmissions}</li>\n	<li>Envíos totales en el sistema: {$totalSubmissions}</li>\n</ul>\nInicie sesión en la revista para obtener más detalles sobre las <a href="{$editorialStatsLink}">tendencias editoriales</a> y las <a href="{$publicationStatsLink}">estadísticas de artículos publicados</a>. Se adjunta una copia completa del informe correspondiente a este mes .<br />\n<br />\nSaludos cordiales,<br />\n{$journalSignature}'),
(346, 'STATISTICS_REPORT_NOTIFICATION', 'fr_CA', 'Notification sur les rapports statistiques', 'Activité éditoriale pour {$month} {$year}', '\n{$recipientName}, <br />\n<br />\nLe rapport d''activité éditoriale de votre revue pour {$month} {$year} est maintenant disponible. Les principales statistiques pour ce mois sont affichées ci-dessous.<br />\n<ul>\n	<li> Nouvelles soumissions pour ce mois : {$newSubmissions} </li>\n	<li> Soumissions refusées pour ce mois : {$declinedSubmissions} </li>\n	<li> Soumissions acceptées pour ce mois : {$acceptedSubmissions} </li>\n	<li> Nombre total de soumissions dans la plateforme : {$totalSubmissions} </li>\n</ul>\nConnectez-vous au site de la revue pour voir davantage de <a href="{$editorialStatsLink}">tendances dans l''activité éditoriale</a> ainsi que des <a href="{$publicationStatsLink}">statistiques relatives aux articles publiés</a>. Le rapport complet des tendances de l''activité éditoriale de ce mois-ci est joint au présent envoi.<br />\n<br />\nCordialement,<br />\n{$journalSignature}'),
(347, 'STATISTICS_REPORT_NOTIFICATION', 'it', '', 'Attività editoriali per {$month}, {$year}', '\nGentile {$recipientName}, <br />\n<br />\nIl riepilogo della sua rivista per il mese di {$month}, {$year} è ora disponibile. Di seguito sono indicate le statistiche principali:<br />\n<ul>\n	<li>nuove proposte ricevute: {$newSubmissions}</li>\n	<li>proposte rifiutate: {$declinedSubmissions}</li>\n	<li>proposte accettate: {$acceptedSubmissions}</li>\n	<li>contributi totali presenti nel sistema: {$totalSubmissions}</li>\n</ul>\nAcceda al sito web per consultare maggiori dettagli relativi alle <a href="{$editorialStatsLink}">statistiche editoriali</a> e <a href="{$publicationStatsLink}">ai dati relativi ai contributi pubblicati</a>. Una copia completa del riepilogo mensile è inviata in allegato.<br />\n<br />\nCordiali saluti,<br />\n{$journalSignature}'),
(348, 'STATISTICS_REPORT_NOTIFICATION', 'nl', '', 'Redactionele activiteit voor {$month}, {$year}', '\n{$recipientName}, <br />\n<br />\nUw tijdschriftgezondheidsrapport voor {$month}, {$year} is nu beschikbaar. Hieronder vindt u uw belangrijkste statistieken voor deze maand.<br />\n<ul>\n	<li>Nieuwe inzendingen deze maand: {$newSubmissions}</li>\n	<li>Afgewezen inzendingen deze maand: {$declinedSubmissions}</li>\n	<li>Geaccepteerde inzendingen deze maand: {$acceptedSubmissions}</li>\n	<li>Totaal aantal inzendingen in het systeem: {$totalSubmissions}</li>\n</ul>\nLog in op het tijdschrift om meer gedetailleerde <a href="{$editorialStatsLink}">redactionele trends </a> and <a href="{$publicationStatsLink}">gepubliceerde artikelstatistieken</a> te bekijken . Een volledig exemplaar van de redactionele trends van deze maand is bijgevoegd.<br />\n<br />\nVriendelijke groet,<br />\n{$journalSignature}'),
(349, 'STATISTICS_REPORT_NOTIFICATION', 'ru', 'Уведомление о статистическом отчете', 'Активность журнала за {$month} {$year} года', '\nЗдравствуйте, {$recipientName}! <br />\n<br />\nОтчёт об активности журнала за {$month} {$year} года уже доступен. Ключевые статистические параметры этого месяца приведены ниже.<br />\n<ul>\n	<li>Новых материалов за месяц: {$newSubmissions}</li>\n	<li>Отклонено материалов за месяц: {$declinedSubmissions}</li>\n	<li>Принято материалов за месяц: {$acceptedSubmissions}</li>\n	<li>Общее число материалов в системе: {$totalSubmissions}</li>\n</ul>\nВойдите в систему, чтобы посмотреть более подробные отчёты о <a href="{$editorialStatsLink}">тенденциях редакции</a> и <a href="{$publicationStatsLink}">статистике опубликованных статей</a>. Полная копия отчёта о тенденциях редакции за данный месяц прилагается к письму.<br />\n<br />\nС уважением,<br />\n{$journalSignature}'),
(350, 'STATISTICS_REPORT_NOTIFICATION', 'en', 'Statistics Report Notification', 'Editorial activity for {$month}, {$year}', '\n{$recipientName}, <br />\n<br />\nYour journal health report for {$month}, {$year} is now available. Your key stats for this month are below.<br />\n<ul>\n	<li>New submissions this month: {$newSubmissions}</li>\n	<li>Declined submissions this month: {$declinedSubmissions}</li>\n	<li>Accepted submissions this month: {$acceptedSubmissions}</li>\n	<li>Total submissions in the system: {$totalSubmissions}</li>\n</ul>\nLogin to the journal to view more detailed <a href="{$editorialStatsLink}">editorial trends</a> and <a href="{$publicationStatsLink}">published article stats</a>. A full copy of this month''s editorial trends is attached.<br />\n<br />\nSincerely,<br />\n{$journalSignature}'),
(351, 'ANNOUNCEMENT', 'de', 'Neue Mitteilung', '{$announcementTitle}', '<b>{$announcementTitle}</b><br />\n<br />\n{$announcementSummary}<br />\n<br />\nBesuchen Sie unsere Website, um die <a href="{$announcementUrl}">vollständige Ankündigung</a> zu lesen.'),
(352, 'ANNOUNCEMENT', 'es', 'Nuevo aviso', '{$announcementTitle}', '<b>{$announcementTitle}</b><br />\n<br />\n{$announcementSummary}<br />\n<br />\nVisite nuestro site para leer el <a href="{$announcementUrl}">anuncio completo</a>.'),
(353, 'ANNOUNCEMENT', 'fr_CA', 'Nouvelle annonce', '{$announcementTitle}', '<b>{$announcementTitle}</b><br />\n<br />\n{$announcementSummary}<br />\n<br />\nVisiter notre site Web pour consulter <a href="{$announcementUrl}">l''annonce complète</a>.'),
(354, 'ANNOUNCEMENT', 'it', '', '{$announcementTitle}', '<b>{$announcementTitle}</b><br />\n<br />\n{$announcementSummary}<br />\n<br />\nVisiti il nostro sito per leggere <a href="{$announcementUrl}">l''informazione completa</a>.'),
(355, 'ANNOUNCEMENT', 'nl', 'Nieuw nieuwsbericht', '{$announcementTitle}', '<b>{$announcementTitle}</b><br />\n<br />\n{$announcementSummary}<br />\n<br />\nBezoek onze website om de <a href="{$announcementUrl}">volledige aankondiging</a> te lezen.'),
(356, 'ANNOUNCEMENT', 'ru', 'Новое объявление', '{$announcementTitle}', '<b>{$announcementTitle}</b><br />\n<br />\n{$announcementSummary}<br />\n<br />\nПосетите наш веб-сайт, чтобы прочитать <a href="{$announcementUrl}">объявление полностью</a>.'),
(357, 'ANNOUNCEMENT', 'en', 'New Announcement', '{$announcementTitle}', '<b>{$announcementTitle}</b><br />\n<br />\n{$announcementSummary}<br />\n<br />\nVisit our website to read the <a href="{$announcementUrl}">full announcement</a>.'),
(358, 'DISCUSSION_NOTIFICATION_SUBMISSION', 'de', 'Diskussion (Einreichung)', 'Eine Nachricht bezüglich {$journalName}', 'Bitte geben Sie Ihre Nachricht ein.'),
(359, 'DISCUSSION_NOTIFICATION_SUBMISSION', 'es', 'Discusión (envío)', 'Mensaje sobre {$journalName}', 'Introduzca su mensaje.'),
(360, 'DISCUSSION_NOTIFICATION_SUBMISSION', 'fr_CA', 'Discussion (soumission)', 'Un message à propos de la revue {$journalName}', 'Prière de saisir votre message.'),
(361, 'DISCUSSION_NOTIFICATION_SUBMISSION', 'it', '', 'Nuovo messaggio da: {$journalName}', 'Inserisci qui il testo del tuo messaggio.'),
(362, 'DISCUSSION_NOTIFICATION_SUBMISSION', 'nl', 'Discussie (Inzending)', 'Een bericht over {$journalName}', 'Voeg hier uw boodschap in.'),
(363, 'DISCUSSION_NOTIFICATION_SUBMISSION', 'ru', 'Обсуждение (Материал)', 'Сообщение о журнале «{$journalName}»', 'Пожалуйста, введите свое сообщение.'),
(364, 'DISCUSSION_NOTIFICATION_SUBMISSION', 'en', 'Discussion (Submission)', 'A message regarding {$journalName}', 'Please enter your message.'),
(365, 'DISCUSSION_NOTIFICATION_REVIEW', 'de', 'Diskussion (Begutachtung)', 'Eine Nachricht bezüglich {$journalName}', 'Bitte geben Sie Ihre Nachricht ein.'),
(366, 'DISCUSSION_NOTIFICATION_REVIEW', 'es', 'Discusión (revisión)', 'Mensaje sobre {$journalName}', 'Introduzca su mensaje.'),
(367, 'DISCUSSION_NOTIFICATION_REVIEW', 'fr_CA', 'Discussion (évaluation)', 'Un message à propos de la revue {$journalName}', 'Prière de saisir votre message.'),
(368, 'DISCUSSION_NOTIFICATION_REVIEW', 'it', '', 'Nuovo messaggio da: {$journalName}', 'Inserisci qui il testo del tuo messaggio.'),
(369, 'DISCUSSION_NOTIFICATION_REVIEW', 'nl', 'Discussie (Review)', 'Een bericht over {$journalName}', 'Voeg hier uw boodschap in.'),
(370, 'DISCUSSION_NOTIFICATION_REVIEW', 'ru', 'Обсуждение (Рецензирование)', 'Сообщение о журнале «{$journalName}»', 'Пожалуйста, введите свое сообщение.'),
(371, 'DISCUSSION_NOTIFICATION_REVIEW', 'en', 'Discussion (Review)', 'A message regarding {$journalName}', 'Please enter your message.'),
(372, 'DISCUSSION_NOTIFICATION_COPYEDITING', 'de', 'Diskussion (Lektorat)', 'Eine Nachricht bezüglich {$journalName}', 'Bitte geben Sie Ihre Nachricht ein.'),
(373, 'DISCUSSION_NOTIFICATION_COPYEDITING', 'es', 'Discusión (edición)', 'Mensaje sobre {$journalName}', 'Introduzca su mensaje.'),
(374, 'DISCUSSION_NOTIFICATION_COPYEDITING', 'fr_CA', 'Discussion (révision)', 'Un message à propos de la revue {$journalName}', 'Prière de saisir votre message.'),
(375, 'DISCUSSION_NOTIFICATION_COPYEDITING', 'it', '', 'Nuovo messaggio da: {$journalName}', 'Inserisci qui il testo del tuo messaggio.'),
(376, 'DISCUSSION_NOTIFICATION_COPYEDITING', 'nl', 'Discussie (Copyediting)', 'Een bericht over {$journalName}', 'Voeg hier uw boodschap in.'),
(377, 'DISCUSSION_NOTIFICATION_COPYEDITING', 'ru', 'Обсуждение (Литературное редактирование)', 'Сообщение о журнале «{$journalName}»', 'Пожалуйста, введите свое сообщение.'),
(378, 'DISCUSSION_NOTIFICATION_COPYEDITING', 'en', 'Discussion (Copyediting)', 'A message regarding {$journalName}', 'Please enter your message.'),
(379, 'DISCUSSION_NOTIFICATION_PRODUCTION', 'de', 'Diskussion (Produktion)', 'Eine Nachricht bezüglich {$journalName}', 'Bitte geben Sie Ihre Nachricht ein.'),
(380, 'DISCUSSION_NOTIFICATION_PRODUCTION', 'es', 'Discusión (producción)', 'Mensaje sobre {$journalName}', 'Introduzca su mensaje.'),
(381, 'DISCUSSION_NOTIFICATION_PRODUCTION', 'fr_CA', 'Discussion (production)', 'Un message à propos de la revue {$journalName}', 'Prière de saisir votre message.'),
(382, 'DISCUSSION_NOTIFICATION_PRODUCTION', 'it', '', 'Nuovo messaggio da: {$journalName}', 'Inserisci qui il testo del tuo messaggio.'),
(383, 'DISCUSSION_NOTIFICATION_PRODUCTION', 'nl', 'Discussie (Production)', 'Een bericht over {$journalName}', 'Voeg hier uw boodschap in.'),
(384, 'DISCUSSION_NOTIFICATION_PRODUCTION', 'ru', 'Обсуждение (Подготовка к публикации)', 'Сообщение о журнале «{$journalName}»', 'Пожалуйста, введите свое сообщение.'),
(385, 'DISCUSSION_NOTIFICATION_PRODUCTION', 'en', 'Discussion (Production)', 'A message regarding {$journalName}', 'Please enter your message.'),
(386, 'COPYEDIT_REQUEST', 'de', 'Lektorat anfragen', 'Einreichung {$submissionId} ist bereit für die Bearbeitung von {$contextAcronym}', '<p>Sehr geehrte/r {$recipientName},</p><p>Ein neuer Beitrag ist bereit für das Lektorat:</p><p><a href"{$submissionUrl}">{$submissionId} — {$submissionTitle}</a><br />{$journalName}</p><p>Bitte befolgen Sie diese Schritte, um diese Aufgabe zu erledigen:</p><ol><li>Klicken Sie auf die URL für die Einreichung unten.</li><li>Öffnen Sie alle Dateien, die unter Entwurfsdateien verfügbar sind, und bearbeiten Sie die Dateien. Benutzen Sie den Bereich Diskussionen zum Lektorat, wenn Sie mit dem/den Redakteur(en) oder Autor(en) Kontakt aufnehmen möchten.</li><li>Speichern Sie die bearbeitete(n) Datei(en) und laden Sie sie in das Bedienfeld Lektorierte Dateien hoch.</li><li>Benutzen Sie die Lektorats-Diskussionen, um den/die Redakteur/in zu benachrichtigen, dass alle Dateien vorbereitet wurden und der Produktionsprozess beginnen kann.</li></ol><p>Wenn Sie diese Arbeit zu diesem Zeitpunkt nicht übernehmen können oder Fragen haben, wenden Sie sich bitte an mich. Vielen Dank für Ihren Beitrag zu {$journalName}.</p><p>Mit freundlichen Grüßen,</p>{$signature}'),
(387, 'COPYEDIT_REQUEST', 'es', 'Solicitar corrección', 'El envío {$submissionId} está listo para ser corregido para {$contextAcronym}', '<p>Estimado/a{$recipientName},</p><p>Hay un envío nuevo listo para ser corregido:</p><p><a href"{$submissionUrl}">{$submissionId} — {$submissionTitle}</a><br />{$journalName}</p><p>Siga estos pasos para completar la tarea:</p><ol><li>Haga clic en la URL del envío que encontrará más abajo.</li><li>Abra todos los archivos disponibles en "Borradores finales" y haga la corrección. Utilice las "Discusiones de corrección" si necesita contactar con editores/as o autores/as.</li><li>Guarde los archivos corregidos y cárguelos en el panel "Corregido".</li><li>Utilice las "Discusiones de corrección" para notificar a los editores/as que los documentos están preparados y que el proceso de producción podría empezar.</li></ol><p>Si no puede llevar a cabo esta tarea en este momento, o si tiene cualquier duda, contacte conmigo por favor. Gracias por su contribución a {$journalName}.</p><p>Saludos cordiales,</p>{$signature}'),
(388, 'COPYEDIT_REQUEST', 'fr_CA', 'Demande de révision', 'Demande de révision d''une soumission', '{$recipientName},<br />\n<br />\nJ''aimerais que vous effectuiez la révision du manuscrit intitulé « {$submissionTitle} » pour la revue {$journalName} à l''aide des étapes suivantes.<br />\n1. Cliquer sur l''URL de la soumission ci-dessous.<br />\n2. Ouvrir le(s) fichier(s) disponible(s) sous Fichiers des ébauches finales et effectuer votre révision, tout en ajoutant des discussions sur la révision, le cas échéant.<br />\n3. Enregistrer le(s) fichier(s) révisé(s) et le(s) téléverser dans la section Version(s) révisée(s).<br />\n4. Informer le,la rédacteur-trice que tous les fichiers ont été révisés et que l''étape de production peut débuter.<br />\n<br />\nURL de la revue {$journalName} : {$journalUrl}<br />\nURL de la soumission : {$submissionUrl}<br />\nNom d''utilisateur-trice : {$recipientUsername}'),
(389, 'COPYEDIT_REQUEST', 'it', '', 'Assegnazione di copyediting', '{$recipientName}:<br />\n<br />\nTi chiedo di prendere in carico il copyediting del manoscritto &quot;{$submissionTitle}&quot; inviato alla testata {$journalName}.<br />\nIl documento si trova su sito web della rivista, insieme alle istruzioni per il copyediting.<br />\nSe non puoi prendere in carico il lavoro in questo periodo o hai qualche domanda, ti prego di contattarmi.<br />\n<br />\n{$journalName} URL: {$journalUrl}<br />\nURL Manoscritto: {$submissionUrl}<br />\nUsername: {$recipientUsername}<br />'),
(390, 'COPYEDIT_REQUEST', 'nl', '', 'De inzending {$submissionId} staat klaar om geredigeerd te worden voor {$contextAcronym}', '{$recipientName}:<br />\n<br />\nIk wil u vragen om de teksredactie uit te voeren voor artikel &quot;{$submissionTitle}&quot; voor {$journalName} door deze stappen te volgen.<br />\n1. Klik op de inzendings-URL hieronder.<br />\n2. Log in bij het tijdschrift en klik op het bestand dat verschijnt bij Stap 1.<br />\n3. Raadpleeg de tekstredactie-instructies die op de webpagina staan.<br />\n4. Open het gedownloade bestand en doe de tekstredactie. Voeg auteursvragen toe waar nodig.<br />\n5. Bewaar het bewerkte bestand en laad het bij stap 1 van Tekstredactie.<br />\n6. Stuur de GEREED e-mail naar de redacteur.<br />\n<br />\n{$journalName} URL: {$journalUrl}<br />\nURL inzending: {$submissionUrl}<br />\nGerbruikersnaam: {$recipientUsername}'),
(391, 'COPYEDIT_REQUEST', 'ru', 'Запрос на литературное редактирование', 'Материал «{$submissionId}» готов к литературному редактированию для «{$contextAcronym}»', '<p>Здравствуйте, {$recipientName}!</p><p>Новый материал готов к литературному редактированию:</p><p><a href"{$submissionUrl}">{$submissionId} — {$submissionTitle}</a><br />Журнал «{$journalName}»</p>Пожалуйста, выполните следующие шаги, что завершить эту задачу:</p><ol><li>Щелкните на URL материала ниже.</li><li>Откройте все файлы, доступные в панели «Черновики», и выполните их литературное редактирование. Используйте область «Обсуждения литературного редактирования», если Вам необходимо связаться с редактором или автором.</li><li>Сохраните отредактированные файлы и загрузите их в панель «Отредактированные».</li><li>Используйте «Обсуждения литературного редактирования», чтобы уведомить редактора о том, что все файлы были подготовлены и можно их запускать в производство.</li></ol><p>Если Вы не можете выполнить эту работу в данный момент или у Вас есть вопросы, пожалуйста, свяжитесь со мной. Спасибо за Ваш вклад в работу журнала «{$journalName}».</p><p>С уважением,</p>{$signature}'),
(392, 'COPYEDIT_REQUEST', 'en', 'Request Copyedit', 'Submission {$submissionId} is ready to be copyedited for {$contextAcronym}', '<p>Dear {$recipientName},</p><p>A new submission is ready to be copyedited:</p><p><a href"{$submissionUrl}">{$submissionId} — {$submissionTitle}</a><br />{$journalName}</p><p>Please follow these steps to complete this task:</p><ol><li>Click on the Submission URL below.</li><li>Open any files available under Draft Files and edit the files. Use the Copyediting Discussions area if you need to contact the editor(s) or author(s).</li><li>Save the copyedited file(s) and upload them to the Copyedited panel.</li><li>Use the Copyediting Discussions to notify the editor(s) that all files have been prepared, and that the Production process may begin.</li></ol><p>If you are unable to undertake this work at this time or have any questions, please contact me. Thank you for your contribution to {$journalName}.</p><p>Kind regards,</p>{$signature}'),
(393, 'EDITOR_ASSIGN_SUBMISSION', 'de', 'Redakteur/in zuweisen', 'Sie wurden als Redakteur/in von einer Einreichung bei {$journalName} zugewiesen', '<p>Sehr geehrte/r {$recipientName},</p><p>Die folgende Einreichung wurde Ihnen zur redaktionellen Bearbeitung zugewiesen. </p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Wenn Sie der Meinung sind, dass die Einreichung für die Zeitschrift {$journalName} relevant ist, leiten Sie die Einreichung bitte zur Begutachtung weiter, indem Sie "In die Begutachtung schicken" wählen und dann Gutachter zuweisen, indem Sie auf "Gutachter/in hinzufügen" klicken. </p><p>Wenn die Einreichung nicht für diese Zeitschrift geeignet ist, lehnen Sie die Einreichung bitte ab.</p><p>Danke im Voraus.</p><p>Mit freundlichen Grüßen,</p>{$journalSignature}'),
(394, 'EDITOR_ASSIGN_SUBMISSION', 'es', 'Asignar editor/a', 'Ha sido asignado como editor/a de un envío para {$journalName}', '<p>Estimado/a {$recipientName},</p><p>Se le ha asignado el siguiente envío para que coordine su proceso editorial.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Resumen</b></p>{$submissionAbstract}<p>Si le parece que el envío es relevante para {$journalName}, envíelo a la fase de revisión seleccionando "Enviar a revisión" y luego asigne revisores/as haciendo clic en "Añadir revisor/a".</p><p>Si el envío no es apropiado para esta revista, rechácelo.</p><p>Gracias de antemano.</p><p>Atentamente,</p>{$journalSignature}'),
(395, 'EDITOR_ASSIGN_SUBMISSION', 'fr_CA', 'Assigner un-e rédacteur-trice', 'Vous avez été assigné.e en tant que rédacteur.trice d''une soumission de la revue {$journalName}', '<p>{$recipientName},</p><p>La soumission suivante vous a été assignée pour le suivi du processus éditorial.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Résumé</b></p>{$submissionAbstract}</p><p>Si vous jugez la soumission pertinente pour la revue {$journalName}, veuillez la transmettre à l''étape d''évaluation en sélectionnant "Envoyer en évaluation" et en désignant des évaluateur.trice.s en cliquant sur « Ajouter un.e évaluateur.trice ».</p><p>Si la soumission n''est pas appropriée pour cette revue, veuillez la décliner.</p><p>Je vous remercie d''avance.</p><p>Cordialement,</p>{$journalSignature}'),
(396, 'EDITOR_ASSIGN_SUBMISSION', 'it', '', 'Assegnazione di una proposta editoriale {$journalName}', '<p>Gentile {$recipientName},</p><p>La seguente proposta Le è stata assegnata per il processo editoriale:</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>ualora dovesse ritenere a proposta sia rilevante per {$journalName}, potrà inoltrarla alla fase di revisione selezionando "Invia alla revisione" e, successivamente, potrà assegnare i revisori utilizzando il tasto "Aggiungi revisore".</p><p>Se la proposta non dovesse essere a Suo giudizio appropriata per questa rivista, La preghiamo di rifiutarla.</p><p>Grazie in anticipo.</p><p>Cordiali saluti,</p>{$journalSignature}'),
(397, 'EDITOR_ASSIGN_SUBMISSION', 'nl', 'Redacteur toekennen', 'Redactietaak', '{$recipientName}:<br />\n<br />\nDe inzending &quot;{$submissionTitle}&quot; voor {$journalName} is aan u toegewezen om in uw rol als sectieredacteur door het redactieproces te leiden.<br />\n<br />\nURL inzending: {$submissionUrl}<br />\nGebruikersnaam: {$recipientUsername}<br />\n<br />\nDank u, </p>{$journalSignature}'),
(398, 'EDITOR_ASSIGN_SUBMISSION', 'ru', 'Назначить редактора', 'Вы были назначены редактором материала в журнале «{$journalName}»', '<p>Здравствуйте, {$recipientName}!</p><p>Вам поручен контроль прохождения через редакционный процесс следующего материала:</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Аннотация</b></p>{$submissionAbstract}<p>Если Вы считаете, что данный материал соответствует тематике журнала «{$journalName}», пожалуйста, направьте его на этап рецензирования, выбрав «Отправить на рецензию», а затем назначив рецензентов, щелкнув на «Добавить рецензента».</p><p>Если материал не подходит для этого журнала, пожалуйста отклоните его.</p><p>Заранее благодарю.</p><p>С уважением,</p>{$journalSignature}'),
(399, 'EDITOR_ASSIGN_SUBMISSION', 'en', 'Assign Editor', 'You have been assigned as an editor on a submission to {$journalName}', '<p>Dear {$recipientName},</p><p>The following submission has been assigned to you to see through the editorial process.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>If you find the submission to be relevant for {$journalName}, please forward the submission to the review stage by selecting "Send to Review" and then assign reviewers by clicking "Add Reviewer".</p><p>If the submission is not appropriate for this journal, please decline the submission.</p><p>Thank you in advance.</p><p>Kind regards,</p>{$journalSignature}'),
(400, 'EDITOR_ASSIGN_REVIEW', 'de', 'Redakteur/in zuweisen', 'Sie wurden als Redakteur/in von einer Einreichung bei {$journalName} zugewiesen', '<p>Sehr geehrte/r {$recipientName},</p><p>Die folgende Einreichung wurde Ihnen zur Begutachtung zugewiesen.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Bitte melden Sie sich an, um <a href="{$submissionUrl}">die Einreichung einzusehen</a> und qualifizierte Gutachter/innen zuzuweisen. Sie können eine/n Gutachter/in zuweisen, indem Sie auf "Gutachter/in hinzufügen" klicken.</p><p>Danke im Voraus.</p><p>Mit freundlichen Grüßen,</p>{$signature}'),
(401, 'EDITOR_ASSIGN_REVIEW', 'es', 'Asignar editor/a', 'Ha sido asignado como editor/a de un envío para {$journalName}', '<p>Estimado/a {$recipientName},</p><p>Se le ha asignado el siguiente envío para que lo supervise durante el proceso de revisión por pares.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Resumen</b></p>{$submissionAbstract}<p>Inicie sesión para <a href="{$submissionUrl}">ver el envío</a> y asignar revisores/as cualificados. Puede asignar un revisor/a haciendo clic en "Añadir revisor/a".</p><p>Gracias de antemano.</p><p>Atentamente,</p>{$signature}'),
(402, 'EDITOR_ASSIGN_REVIEW', 'fr_CA', 'Assigner un-e rédacteur-trice', 'Vous avez été assigné.e en tant que rédacteur.trice d''une soumission de la revue {$journalName}', '<p>{$recipientName},</p><p>La soumission suivante vous a été assignée pour le processus d''évaluation par les pairs.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Résumé</b></p>{$submissionAbstract}<p>Veuillez vous connecter pour <a href="{$submissionUrl}">voir la soumission</a> et désigner des évaluateur.trice.s qualifié.es. Vous pouvez désigner un.e évaluateur.trice en cliquant sur « Ajouter un.e évaluateur.trice ».</p><p>Je vous remercie d''avance.</p><p>Cordialement,</p>{$signature}'),
(403, 'EDITOR_ASSIGN_REVIEW', 'it', '', 'Assegnazione di una proposta editoriale {$journalName}', '<p>Gentile {$recipientName},</p><p>La seguente proposta Le è stata assegnata per una supervisione del processo di revisione tra pari.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Effettui gentilmente il login per <a href="{$submissionUrl}">visualizzare la proposta</a> e per assegnare revisori qualificati. È possibile assegnare un revisore facendo clic su "Aggiungi revisore".</p><p>Grazie in anticipo.</p><p>Cordiali saluti,</p>{$signature}');
INSERT INTO `email_templates_default_data` VALUES
(404, 'EDITOR_ASSIGN_REVIEW', 'nl', 'Redacteur toekennen', 'Redactietaak', '<p>Beste{$recipientName},</p><p>De volgende inzending is aan u toegwezen voor begeleiding door het peer review process.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Log alstublieft in om <a href="{$submissionUrl}">de inzending te bekijken</a> en wijs geschikte reviewers toe. Reviewers kunnen toe gewezen door op "Voeg Reviewer Toe" te klikken.</p><p>Bij voorbaat dank.</p><p>Met vriendelijke groet,</p>{$signature}'),
(405, 'EDITOR_ASSIGN_REVIEW', 'ru', 'Назначить редактора', 'Вы были назначены редактором материала в журнале «{$journalName}»', '<p>Здравствуйте, {$recipientName}!</p><p>Вам поручен контроль прохождения через процесс рецензирования следующего материала.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Аннотация</b></p>{$submissionAbstract}<p>Пожалуйста, войдите в систему, чтобы <a href="{$submissionUrl}">просмотреть материал</a> и назначить квалифицированных рецензентов. Вы можете назначить рецензента, щелкнув на «Добавить рецензента».</p><p>Заранее благодарю.</p><p>С уважением,</p>{$signature}'),
(406, 'EDITOR_ASSIGN_REVIEW', 'en', 'Assign Editor', 'You have been assigned as an editor on a submission to {$journalName}', '<p>Dear {$recipientName},</p><p>The following submission has been assigned to you to see through the peer review process.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Please login to <a href="{$submissionUrl}">view the submission</a> and assign qualified reviewers. You can assign a reviewer by clicking "Add Reviewer".</p><p>Thank you in advance.</p><p>Kind regards,</p>{$signature}'),
(407, 'EDITOR_ASSIGN_PRODUCTION', 'de', 'Redakteur/in zuweisen', 'Sie wurden als Redakteur/in von einer Einreichung bei {$journalName} zugewiesen', '<p>Sehr geehrte/r {$recipientName},</p><p>Die folgende Einreichung wurde Ihnen für die Produktionsphase zugewiesen.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Bitte melden Sie sich an, um <a href="{$submissionUrl}">die Einreichung einzusehen</a>. Sobald die produktionsfertigen Dateien vorliegen, laden Sie sie unter <strong>Publikation > Fahnen</strong> hoch. Klicken Sie dann auf die Schaltfläche <strong>Zur Veröffentlichung vorsehen</strong>.</p><p>Vielen Dank im Voraus.</p><p>Mit freundlichen Grüßen,</p>{$signature}'),
(408, 'EDITOR_ASSIGN_PRODUCTION', 'es', 'Asignar editor/a', 'Ha sido asignado como editor/a de un envío para {$journalName}', '<p>Estimado/a {$recipientName},</p><p>Se le ha asignado el siguiente envío para que coordine su fase de producción.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Resumen</b></p>{$submissionAbstract}<p>Inicie sesión para <a href="{$submissionUrl}">ver el envío</a>. Cuando estén disponibles los archivos de producción cárguelos en la sección <strong>Publicación > Galeradas</strong>. Después programe el trabajo para su publicación haciendo clic en el botón <strong>Programar para publicación</strong>.</p><p>Gracias de antemano.</p><p>Atentamente,</p>{$signature}'),
(409, 'EDITOR_ASSIGN_PRODUCTION', 'fr_CA', 'Assigner un-e rédacteur-trice', 'Vous avez été assigné.e en tant que rédacteur.trice d''une soumission de la revue {$journalName}', '<p>{$recipientName},</p><p>La soumission suivante vous a été assignée pour suivre le processus de production.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Résumé</b></p>{$submissionAbstract}<p>Veuillez vous connecter pour <a href="{$submissionUrl}">afficher la soumission</a>. Une fois les fichiers prêts pour la production disponibles, les téléverser sous la section <strong>Publication &gt; Épreuves</strong>. Ensuite, planifier la publication en cliquant sur le bouton <strong>Planifier la publication</strong>.</p><p>Merci d''avance.</p><p>Cordialement,</p>{$signature}'),
(410, 'EDITOR_ASSIGN_PRODUCTION', 'it', '', 'Assegnazione di una proposta editoriale {$journalName}', '<p>Gentile {$recipientName},</p><p>La seguente proposta editoriale Le è stata assegnata per la fase di produzione</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Effettui gentilmente l''accesso per <a href="{$submissionUrl}">visualizzare la proposta</a>. Quando i file pronti per la produzione saranno disponibili, li carichi cortesemente nella sezione <strong>Pubblicazione > Gabbie</strong>. Quindi segnali il lavoro pronto la pubblicazione facendo clic sul pulsante <strong>Programma per la pubblicazione</strong>.</p><p>Grazie in anticipo.</p><p>Cordiali saluti,</p>{$signature}'),
(411, 'EDITOR_ASSIGN_PRODUCTION', 'nl', 'Redacteur toekennen', 'Redactietaak', '<p>Beste {$recipientName},</p><p>De volgende inzending is aan u toegewezen voor begeleiding door het productieprocess.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Log alstublieft in om <a href="{$submissionUrl}">de inzending te bekijken</a>. Wanneer de productiebestanden gereed zijn, kunt u ze uploaden via<strong>Publicatie> Drukproeven</strong> . Plan daarna het werk in voor publicatie via de <strong>Inplannen voor publicatie</strong> knop.</p><p>Bij voorbaat dank.</p><p>Met vriendelijke groet,</p>{$signature}'),
(412, 'EDITOR_ASSIGN_PRODUCTION', 'ru', 'Назначить редактора', 'Вы были назначены редактором материала в журнале «{$journalName}»', '<p>Здравствуйте, {$recipientName}!</p><p>Вам поручен контроль прохождения через процесс публикации следующего материала.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Аннотация</b></p>{$submissionAbstract}<p>Пожалуйста, войдите в систему, чтобы <a href="{$submissionUrl}">просмотреть материал</a>. Когда файлы для публикации будут готовы, загрузите их в раздел <strong>Публикация > Гранки</strong>. Затем запланируйте материал к публикации, нажав на кнопку <strong>«Запланировать для публикации»</strong>.</p><p>Заранее благодарю.</p><p>С уважением,</p>{$signature}'),
(413, 'EDITOR_ASSIGN_PRODUCTION', 'en', 'Assign Editor', 'You have been assigned as an editor on a submission to {$journalName}', '<p>Dear {$recipientName},</p><p>The following submission has been assigned to you to see through the production stage.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Please login to <a href="{$submissionUrl}">view the submission</a>. Once production-ready files are available, upload them under the <strong>Publication > Galleys</strong> section. Then schedule the work for publication by clicking the <strong>Schedule for Publication</strong> button.</p><p>Thank you in advance.</p><p>Kind regards,</p>{$signature}'),
(414, 'LAYOUT_REQUEST', 'de', 'Für die Produktion bereit', 'Die Einreichung {$submissionId} ist bereit für die Produktion bei {$contextAcronym}', '<p>Liebe/r {$recipientName},</p><p>eine neue Einreichung steht für die Layout-Bearbeitung bereit:</p><p><a href="{$submissionUrl}">{$submissionId} - {$submissionTitle}</a><br />{$journalName}</p><ol><li>Klicken Sie auf die obige Einreichungs-URL.</li><li>Laden Sie die produktionsfertigen Dateien herunter und verwenden Sie sie, um die Druckfahnen gemäß den Standards der Zeitschrift zu erstellen. </li><li>Laden Sie die Druckfahnen in den Publikationsbereich der Einreichung hoch.</li><li>Benutzen Sie die Produktionsdiskussionen, um der Redaktion mitzuteilen, dass die Druckfahnen fertig sind.</li></ol><p>Wenn Sie diese Arbeit zu diesem Zeitpunkt noch nicht erledigen können oder Fragen haben, wenden Sie sich bitte an mich. Vielen Dank für Ihren Beitrag zu dieser Zeitschrift.</p><p>Mit freundlichen Grüßen,</p>{$signature}'),
(415, 'LAYOUT_REQUEST', 'es', 'Listo para producción', 'El envío {$submissionId} está listo para producción en {$contextAcronym}', '<p>Estimado/a {$recipientName},</p><p>Un nuevo envío está listo para la maquetación:</p><p><a href="{$submissionUrl}">{$submissionId} — {$submissionTitle}</a><br />{$journalName}</p><ol><li>Haga clic en la URL anterior.</li><li>Descargue los archivos de producción y utilícelos para crear las galeradas de acuerdo con los estándares de la revista.</li><li>Cargue las galeradas en la sección de publicación del envío.</li><li>Use las discusiones de producción para notificar al editor/a que las galeradas están listas.</li></ol><p>Si no puede llevar a cabo este trabajo en este momento o tiene alguna pregunta, póngase en contacto con nosotros. Gracias por su contribución a esta revista.</p><p>Atentamente,</p>{$signature}'),
(416, 'LAYOUT_REQUEST', 'fr_CA', 'Prêt pour production', 'La soumission {$submissionId} est prête pour production à la revue {$contextAcronym}', '<p>Bonjour {$recipientName},</p><p>J''aimerais que vous prépariez les épreuves du manuscrit intitulé « {$submissionTitle} » pour la revue {$journalName} à l''aide des étapes suivantes.</p>\n<ol><li>Cliquer sur l''URL de la soumission ci-dessous.</li><li>Se connecter au site Web de la revue et utiliser les fichiers disponibles sous Fichiers prêts pour la production pour créer les épreuves en fonction des normes de la revue.</li><li>Téléverser les épreuves dans la section Épreuves.</li><li>Informer le-la rédacteur-trice, via une discussion sur la production, que les épreuves ont été téléversées et qu''elles sont prêtes.</li></ol><p>URL de la revue {$journalName} : {$journalUrl}</p><p>URL du manuscrit : {$submissionUrl}</p><p>Nom d''utilisateur-trice : {$recipientUsername}</p><p>Si vous ne pouvez pas effectuer ce travail pour le moment ou si vous avez des questions, veuillez communiquer avec moi. Je vous remercie de votre collaboration.</p>{$signature}'),
(417, 'LAYOUT_REQUEST', 'it', '', 'La proposta {$submissionId} è stata accettata da {$contextAcronym} ed è pronta per le bozze', '<p>Gentile {$recipientName},</p><p>Un nuovo contributo è pronto per l''impaginazione:</p><p><a href="{$submissionUrl}">{$submissionId} — {$submissionTitle}</a><br />{$journalName}</p><ol><li>Clicchi gentilmente sul link sopra riportato.</li><li>Scarichi i file di produzione e li usi per creare i file impaginati in accordo con gli standard della rivista.</li><li>Carichi i file nella sezione di Pubblicazione della proposta editoriale.</li><li>Usi la funzione di "Discussione" per poter notificare agli editor della rivista che i file sono pronti.</li></ol><p>Qualora non potesse assumere tale lavoro, o in caso di ulteriori esigenze, non esiti a contattarci. Grazie per la preziosa collaborazione</p><p>Cordiali saluti,</p>{$signature}'),
(418, 'LAYOUT_REQUEST', 'nl', 'Naar Productie', 'Verzoek aanmaken proeven', '{$recipientName}:<br />\n<br />\nDe proeven van inzending &quot;{$submissionTitle}&quot; bij {$journalName} kunnen aangemaakt worden door de volgende stappen te doorlopen.<br />\n1. Klik op de inzendings-URL hieronder.<br />\n2. Log in bij het tijdschrift en gebruik het Layout versie bestand om de proeven aan te maken conform de regels van het tijdschrift.<br />\n3. Stuur de GEREED e-mail naar de redacteur.<br />\n<br />\n{$journalName} URL: {$journalUrl}<br />\nURL inzending: {$submissionUrl}<br />\nGebruikersnaam: {$recipientUsername}<br />\n<br />\nAls u op dit moment niet in staat bent om dit werk te doen of als u vragen heeft, neem dan contact met me op.'),
(419, 'LAYOUT_REQUEST', 'ru', 'Готова для подготовки к публикации', 'Материал «{$submissionId}» готов к верстке в «{$contextAcronym}»', '<p>Здравствуйте, {$recipientName}!</p><p>Новый материал готов для верстки:</p><p><a href="{$submissionUrl}">{$submissionId} — {$submissionTitle}</a><br />{$journalName}</p><ol><li>Щелкните по URL материала выше.</li><li>Скачайте «Файлы для публикации» и используйте их для создания гранок в соответствии со стандартами журнала.</li><li>Загрузите гранки в раздел «Публикация» материала.</li><li>Используйте «Обсуждения публикации», чтобы уведомить редактора о готовности гранок.</li></ol><p>Если Вы не можете выполнить эту работу в данное время или у Вас есть какие-то вопросы, пожалуйста, свяжитесь со мной. Спасибо за Ваш вклад в наш журнал.</p><p>С уважением,</p>{$signature}'),
(420, 'LAYOUT_REQUEST', 'en', 'Ready for Production', 'Submission {$submissionId} is ready for production at {$contextAcronym}', '<p>Dear {$recipientName},</p><p>A new submission is ready for layout editing:</p><p><a href="{$submissionUrl}">{$submissionId} — {$submissionTitle}</a><br />{$journalName}</p><ol><li>Click on the Submission URL above.</li><li>Download the Production Ready files and use them to create the galleys according to the journal''s standards.</li><li>Upload the galleys to the Publication section of the submission.</li><li>Use the  Production Discussions to notify the editor that the galleys are ready.</li></ol><p>If you are unable to undertake this work at this time or have any questions, please contact me. Thank you for your contribution to this journal.</p><p>Kind regards,</p>{$signature}'),
(421, 'LAYOUT_COMPLETE', 'de', 'Fahnen vollständig', 'Fahnen vollständig', '<p>Sehr geehrte/r {$recipientName},</p><p>die Druckfahnen für die folgende Einreichung wurden nun vorbereitet und sind bereit für die endgültige Überprüfung.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$journalName}</p><p>Wenn Sie Fragen haben, kontaktieren Sie mich bitte.</p><p>Mit freundlichen Grüßen,</p><p>{$signature}</p>'),
(422, 'LAYOUT_COMPLETE', 'es', 'Galeradas completas', 'Galeradas completadas', '<p>Estimado/a {$recipientName},</p><p>Le informamos que las galeradas del siguiente envío ya han sido preparadas y están listas para su revisión final.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$journalName}</p><p>Si tiene alguna pregunta, póngase en contacto con nosotros.</p><p>Atentamente,</p><p>{$signature}</p>'),
(423, 'LAYOUT_COMPLETE', 'fr_CA', 'Épreuves complétées', 'Mise en page des épreuves terminée', '<p>Bonjour {$recipientName},</p><p>Les épreuves du manuscrit intitulé « <a href="{$submissionUrl}">{$submissionTitle}</a> » pour la revue {$journalName} sont maintenant prêtes pour la relecture.</p><p>Si vous avez des questions, n''hésitez pas à communiquer avec moi.</p><p>{$signature}</p>'),
(424, 'LAYOUT_COMPLETE', 'it', 'Gabbia completa', 'Bozze complete', '<p>Gentile {$recipientName},</p><p>La presente per comunicarLe che Le bozze del seguente contributo sono state preparate e sono ora pronte per la revisione finale.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$journalName}</p><p>Per ogni quesito o necessità, non esiti a contattarci.</p><p>Cordiali saluti,</p><p>{$signature}</p>'),
(425, 'LAYOUT_COMPLETE', 'nl', 'Drukproeven compleet', 'Proeven gereed', '{$recipientName}:<br />\n<br />\nDe proeven voor manuscript &quot;{$submissionTitle}&quot; voor {$journalName} zijn gereed voor proeflezen.<br />\n<br />\nNeemt u alstublieft contact met me op als u vragen heeft.<br />\n<br />\n{$senderName}'),
(426, 'LAYOUT_COMPLETE', 'ru', 'Гранки готовы', 'Гранки сделаны', '<p>Здравствуйте, {$recipientName}!</p><p>Гранки для следующего материала уже свёрстаны и готовы для финальной вычитки.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$journalName}</p><p>Если у Вас есть какие-либо вопросы, пожалуйста, свяжитесь со мной.</p><p>С уважением,</p><p>{$signature}</p>'),
(427, 'LAYOUT_COMPLETE', 'en', 'Galleys Complete', 'Galleys Complete', '<p>Dear {$recipientName},</p><p>Galleys have now been prepared for the following submission and are ready for final review.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$journalName}</p><p>If you have any questions, please contact me.</p><p>Kind regards,</p><p>{$signature}</p>'),
(428, 'VERSION_CREATED', 'de', 'Version erstellt', 'Eine neue Version wurde für {$submissionTitle} erstellt', '<p>Sehr geehrte/r {$recipientName}, </p><p>dies ist eine automatische Nachricht, die Sie darüber informiert, dass eine neue Version Ihres Beitrags {$submissionTitle} erstellt wurde. Sie können diese Version in Ihrem Dashboard für die Einreichung unter folgendem Link einsehen:</p><p><a href="{$submissionUrl}">{$submissionTitle}</a></p><hr><p>Dies ist eine automatische E-Mail, gesendet von <a href="{$journalUrl}">{$journalName}</a>.</p>'),
(429, 'VERSION_CREATED', 'es', 'Versión creada', 'Se ha creado una versión nueva de {$submissionTitle}', ''),
(430, 'VERSION_CREATED', 'fr_CA', 'Version créée', 'Une nouvelle version a été créée pour {$submissionTitle}', '<p>{$recipientName}, </p><p>Ceci est un courriel automatique de <a href="{$journalUrl}">{$journalName}</a> pour vous informer qu''une nouvelle version de votre soumission, {$submissionTitle}, a été créée. Vous pouvez consulter cette version à partir de votre tableau de bord de soumission:</p><p><a href="{$submissionUrl}">{$submissionTitle}</a></p><hr>'),
(431, 'VERSION_CREATED', 'it', '', '', ''),
(432, 'VERSION_CREATED', 'nl', '', 'Een nieuwe versie is aangemaakt voor {$submissionTitle}', '<p>Beste {$recipientName},</p><p>Dit is een geautomatiseerd bericht om je te informeren dat er een nieuwe versie van je inzending, {$submissionTitle}, is aangemaakt. Je kunt deze versie bekijken vanuit je inzendingsdashboard via de volgende link:</p><p><a href="{$submissionUrl}">{$submissionTitle}</a></p><hr><p>Dit is een automatische e-mail verzonden vanuit <a href="{$journalUrl}">{$journalName}</a>.</p>'),
(433, 'VERSION_CREATED', 'ru', 'Версия создана', 'Была создана новая версия материала для «{$submissionTitle}»', '<p>Здравствуйте, {$recipientName}!</p><p>Это автоматическое сообщение, информирующее Вас о том, что была создана новая версия Вашего материала «{$submissionTitle}». Вы можете просмотреть эту версию на странице Вашего материала по следующей ссылке:</p><p><a href="{$submissionUrl}">{$submissionTitle}</a></p><hr><p>Это автоматическое письмо, отправленное из журнала <a href="{$journalUrl}">«{$journalName}»</a>.</p>'),
(434, 'VERSION_CREATED', 'en', 'Version Created', 'A new version was created for {$submissionTitle}', '<p>Dear {$recipientName}, </p><p>This is an automated message to inform you that a new version of your submission, {$submissionTitle}, was created. You can view this version from your submission dashboard at the following link:</p><p><a href="{$submissionUrl}">{$submissionTitle}</a></p><hr><p>This is an automatic email sent from <a href="{$journalUrl}">{$journalName}</a>.</p>'),
(435, 'EDITORIAL_REMINDER', 'de', 'Redaktionserinnerung', 'Ausstehende redaktionelle Aufgaben für {$journalName}', '<p>Sehr geehrte/r {$recipientName},</p><p>Sie sind derzeit {$numberOfSubmissions} Einreichung(en) zugewiesen in <a href="{$journalUrl}">{$journalName}</a>. Die folgenden Einsendungen <b>warten auf Ihre Antwort</b></p>{$outstandingTasks}<p>Sehen Sie alle Ihre Aufgaben an in Ihrem <a href="{$submissionsUrl}">Dashboard der Einreichungen</a>.</p><p>Wenn Sie Fragen zu Ihren Aufgaben haben, wenden Sie sich bitte an {$contactName} unter {$contactEmail}.</p>'),
(436, 'EDITORIAL_REMINDER', 'es', 'Recordatorio editorial', 'Tareas editoriales pendientes de {$journalName}', '<p>Estimado/a {$recipientName},</p><p>Actualmente tiene asignado(s) {$numberOfSubmissions} envío(s) en <a href="{$journalUrl}">{$journalName}</a>. Los envíos siguientes están <b>esperando su respuesta</b>.</p>{$outstandingTasks}<p>Puede ver todas sus tareas en su <a href="{$submissionsUrl}">panel de control del envío</a>.</p><p>Si tiene cualquier duda acerca de sus asignaciones contacte con {$contactName} en {$contactEmail}.</p>'),
(437, 'EDITORIAL_REMINDER', 'fr_CA', 'Rappel éditorial', 'Tâches éditoriales en attente pour {$journalName}', '<p>$recipientName}, </p><p>Vous êtes présentement assigné-e à {$numberOfSubmissions} soumissions dans <a href="{$journalUrl}">{$journalName}</a>. Des actions sont <b>attendues de votre part pour ces soumissions</b>.</p>{$outstandingTasks}<p>Vous pouvez consulter toutes vos soumissions dans votre <a href="{$submissionsUrl}">tableau de bord des soumissions</a>.</p><p>Si vous avez des questions, contactez {$contactName} par courriel à l’adresse: {$contactEmail}. </p>'),
(438, 'EDITORIAL_REMINDER', 'it', '', '', ''),
(439, 'EDITORIAL_REMINDER', 'nl', 'Redactionele Herinnering', 'Uitstaande redactionele taken voor {$journalName}', '<p>Beste {$recipientName},</p><p>Op dit moment ben je toegewezen aan {$numberOfSubmissions} inzendingen in <a href="{$journalUrl}">{$journalName}</a>. De volgende inzendingen wachten op <b>jouw reactie</b>.</p>{$outstandingTasks}<p>Bekijk al je toewijzingen in je <a href="{$submissionsUrl}">inzendingsdashboard</a>.</p><p>Als je vragen hebt over je toewijzingen, neem dan contact op met {$contactName} via {$contactEmail}.</p>'),
(440, 'EDITORIAL_REMINDER', 'ru', 'Напоминание редакции', 'Невыполненные редакционные задания в журнале «{$journalName}»', '<p>Здравствуйте, {$recipientName}!</p><p>В настоящее время в журнале <a href="{$journalUrl}">{$journalName}</a> Вам назначено материалов: {$numberOfSubmissions}. Следующие материалы <b>ждут Вашего ответа</b>.</p>{$outstandingTasks}<p>Просмтотреть все назначенные материалы Вы можете на <a href="{$submissionsUrl}">странице материалов</a>.</p><p>Если у Вас есть какие-то вопросы по назначенным материалам, пожалуйста напишите по адресу {$contactEmail} ({$contactName}).</p>'),
(441, 'EDITORIAL_REMINDER', 'en', 'Editorial Reminder', 'Outstanding editorial tasks for {$journalName}', '<p>Dear {$recipientName},</p><p>You are currently assigned to {$numberOfSubmissions} submissions in <a href="{$journalUrl}">{$journalName}</a>. The following submissions are <b>waiting for your response</b>.</p>{$outstandingTasks}<p>View all of your assignments in your <a href="{$submissionsUrl}">submission dashboard</a>.</p><p>If you have any questions about your assignments, please contact {$contactName} at {$contactEmail}.</p>'),
(442, 'SUBMISSION_SAVED_FOR_LATER', 'de', 'Einreichung für später gespeichert', 'Setzen Sie Ihre Einreichung bei {$journalName} fort', '<p>Sehr geehrte/r {$recipientName},</p><p>Die Angaben zu Ihrem Beitrag sind in unserem System gespeichert, aber noch nicht zur Prüfung eingereicht worden. Sie können jederzeit zurückkehren, um Ihre Einreichung zu vervollständigen, indem Sie dem unten stehenden Link folgen.</p><p><a href="{$submissionWizardUrl}">{$authorsShort} — {$submissionTitle}</a></p><hr><p>Dies ist eine automatische E-Mail von <a href="{$journalUrl}">{$journalName}</a>.</p>'),
(443, 'SUBMISSION_SAVED_FOR_LATER', 'es', 'Se guardó el envío para más adelante', 'Continuar su envío a {$journalName}', ''),
(444, 'SUBMISSION_SAVED_FOR_LATER', 'fr_CA', 'Soumission incomplète sauvegardée', 'Reprendre votre soumission à {$journalName}', '<p>{$recipientName},</p><p>Les détails de votre soumission ont été enregistrés, mais vous ne l''avez pas encore finalisée. Vous pouvez le faire en cliquant sur le lien ci-dessous: </p><p><a href="{$submissionWizardUrl}">{$authorsShort} — {$submissionTitle}</a></p><hr><p>Ceci est un message automatique de <a href="{$journalUrl}">{$journalName}</a>.</p>'),
(445, 'SUBMISSION_SAVED_FOR_LATER', 'it', '', '', ''),
(446, 'SUBMISSION_SAVED_FOR_LATER', 'nl', 'Inzending bewaard voor later', 'Ga door met je inzending aan {$journalName}', '<p>Beste {$recipientName},</p><p>Je inzending details zijn opgeslagen in ons systeem, maar het is nog niet ingediend ter overweging. Je kunt op elk moment terugkeren om je inzending te voltooien door de onderstaande link te volgen.</p><p><a href="{$submissionWizardUrl}">{$authorsShort} — {$submissionTitle}</a></p><hr><p>Dit is een geautomatiseerde e-mail vanuit <a href="{$journalUrl}">{$journalName}</a>.</p>'),
(447, 'SUBMISSION_SAVED_FOR_LATER', 'ru', 'Материал сохранен на будущее', 'Завершите отправку материала в журнал «{$journalName}»', '<p>Здравствуйте, {$recipientName}!</p><p>Данные о Вашем материале были сохранены в нашей системе, но он еще не был отправлен на рассмотрение. Вы можете в любое время вернуться в систему для завершения отправки материала, перейдя по ссылке ниже.</p><p><a href="{$submissionWizardUrl}">{$authorsShort} — «{$submissionTitle}»</a></p><hr><p>Это автоматическое письмо, отправленное из журнала <a href="{$journalUrl}">«{$journalName}»</a>.</p>'),
(448, 'SUBMISSION_SAVED_FOR_LATER', 'en', 'Submission Saved for Later', 'Resume your submission to {$journalName}', '<p>Dear {$recipientName},</p><p>Your submission details have been saved in our system, but it has not yet been submitted for consideration. You can return to complete your submission at any time by following the link below.</p><p><a href="{$submissionWizardUrl}">{$authorsShort} — {$submissionTitle}</a></p><hr><p>This is an automated email from <a href="{$journalUrl}">{$journalName}</a>.</p>'),
(449, 'SUBMISSION_NEEDS_EDITOR', 'de', 'Einreichung benötigt Redakteur/in', 'Einer neuen Einreichung muss ein Redakteur/eine Redakteurin zugewiesen werden: {$submissionTitle}', '<p>Sehr geehrte/r {$recipientName},</p><p>Der folgende Beitrag wurde eingereicht und es wurde kein/e Redakteur/in zugewiesen.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Bitte weisen Sie eine/n Redakteur/in zu, der für die Einreichung verantwortlich sein wird, indem Sie auf den Titel oben klicken, und dann eine/n Redakteur/in unter der Rubrik Teilnehmer zuweisen.</p><hr><p>Dies ist eine automatische E-Mail von <a href="{$journalUrl}">{$journalName}</a>.</p>'),
(450, 'SUBMISSION_NEEDS_EDITOR', 'es', 'El envío necesita un editor/a', 'Un envío nuevo necesita que le asignen un editor/a: {$submissionTitle}', ''),
(451, 'SUBMISSION_NEEDS_EDITOR', 'fr_CA', 'Soumission en attente de rédacteur-trice', 'Un-e rédacteur-trice doit être assigné-e à la nouvelle soumission : {$submissionTitle}', '<p>{$recipientName},</p><p>La soumission suivante a été soumise et aucun-e rédacteur-trice ne lui est assigné-e.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>S''il vous plait, assignez un-e rédacteur-trice qui sera responsable de la soumission. </p><hr><p>Ceci est un courriel automatique de <a href="{$journalUrl}">{$journalName}</a>.</p>'),
(452, 'SUBMISSION_NEEDS_EDITOR', 'it', '', '', ''),
(453, 'SUBMISSION_NEEDS_EDITOR', 'nl', 'Inzending Redacteur Nodig', 'Er moet een redacteur worden toegewezen aan een nieuwe inzending: {$submissionTitle}', '<p>Beste {$recipientName},</p><p>De volgende inzending is ingediend en er is nog geen redacteur toegewezen.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Samenvatting</b></p>{$submissionAbstract}<p>Wijs alsjeblieft een redacteur toe die verantwoordelijk zal zijn voor de inzending door op de titel hierboven te klikken en een redacteur toe te wijzen onder de sectie Deelnemers.</p><hr><p>Dit is een geautomatiseerde e-mail vanuit <a href="{$journalUrl}">{$journalName}</a>.</p>'),
(454, 'SUBMISSION_NEEDS_EDITOR', 'ru', 'Материалу нужен редактор', 'Новому материалу необходимо назначить редактора: «{$submissionTitle}»', '<p>Здравствуйте, {$recipientName}!</p><p>Следующий материал поступил в журнал, но редактор ему не назначен.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Аннотация</b></p>{$submissionAbstract}<p>Пожалуйста, назначьте редактора, который будет отвечать за материал, нажав на название материала выше и назначив редактора в разделе «Участники».</p><hr><p>Это автоматическое письмо, отправленное из журнала <a href="{$journalUrl}">«{$journalName}»</a>.</p>'),
(455, 'SUBMISSION_NEEDS_EDITOR', 'en', 'Submission Needs Editor', 'A new submission needs an editor to be assigned: {$submissionTitle}', '<p>Dear {$recipientName},</p><p>The following submission has been submitted and there is no editor assigned.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Please assign an editor who will be responsible for the submission by clicking the title above and assigning an editor under the Participants section.</p><hr><p>This is an automated email from <a href="{$journalUrl}">{$journalName}</a>.</p>'),
(456, 'PAYMENT_REQUEST_NOTIFICATION', 'de', 'Zahlungsanfrage', 'Benachrichtigung über eine Zahlungsanforderung', '<p>Sehr geehrte/r {$recipientName},</p><p>herzlichen Glückwunsch zur Annahme Ihrer Einreichung {$submissionTitle} bei {$journalName}. Nachdem Ihre Einreichung angenommen wurde, möchten wir Sie nun um die Zahlung der Veröffentlichungsgebühr bitten.</p><p>Diese Gebühr deckt die Produktionskosten für die Veröffentlichung Ihrer Einreichung. Um die Zahlung vorzunehmen, besuchen Sie bitte <a href="{$queuedPaymentUrl}">{$queuedPaymentUrl}</a>.</p><p>Wenn Sie Fragen haben, lesen Sie bitte unsere <a href="{$submissionGuidelinesUrl}">Einreichungsrichtlinien</a>.</p>'),
(457, 'PAYMENT_REQUEST_NOTIFICATION', 'es', 'Solicitud de pago', 'Notificación de solicitud de pago', '<p>Estimado/a {$recipientName},</p><p>Le felicitamos por la aceptación de su envío, {$submissionTitle}, en {$journalName}. Ahora que ha sido aceptado, nos gustaría solicitarle el pago de la tasa de publicación.</p><p>Esta tasa cubre los costes de producción para su publicación. Para realizar el pago, visite <a href="{$queuedPaymentUrl}">{$queuedPaymentUrl}</a>.</p><p>Si tiene alguna pregunta consulte nuestras <a href="{$submissionGuidelinesUrl}">directrices de envío</a>.</p>'),
(458, 'PAYMENT_REQUEST_NOTIFICATION', 'fr_CA', 'Demande de paiement', 'Avis de demande de paiement', '<p>Bonjour {$recipientName},</p><p>Félicitations pour l''acceptation de votre texte, {$submissionTitle}, dans {$journalName}. Maintenant que votre texte a été accepté, il est nécessaire de payer les frais de publication afin de compléter le processus.</p><p>Ces frais couvrent les coûts de production permettant d''assurer la publication de votre texte. Pour effectuer le paiement, rendez-vous sur <a href="{$queuedPaymentUrl}">{$queuedPaymentUrl}</a>.</p><p> Si vous avez des questions, référez-vous à nos <a href="{$submissionGuidelinesUrl}">directives de soumissions</a>.</p>'),
(459, 'PAYMENT_REQUEST_NOTIFICATION', 'it', 'Richiesta di pagamento', 'Notifica di richiesta di pagamento', '<p>Gentile {$recipientName},</p><p>Congratulazioni per l''accettazione della Sua proposta, {$submissionTitle}, a {$journalName}. Ora che la proposta è stata accettata, vorremmo domandare se potesse procedere al pagamento delle tariffe di pubblicazione. </p><p>Questa tariffa copre i costi di produzione necessari per il raggiungimento della pubblicazione. Al fine di poter effettuare il pagamento, visiti la seguente pagina <a href="{$queuedPaymentUrl}">{$queuedPaymentUrl}</a>.</p><p>Per ulteriori informazioni, visiti le nostre <a href="{$submissionGuidelinesUrl}">linee guide per le proposte editoriali</a>.</p>'),
(460, 'PAYMENT_REQUEST_NOTIFICATION', 'nl', 'Betalingsverzoek', 'Betalingsverzoeknotificatie', '<p>Beste {$recipientName},</p><p>Gefeliciteerd met de acceptatie van uw inzending, {$submissionTitle}, aan {$journalName}. Nu uw inzending is geaccepteerd, willen wij u verzoeken om betaling van de publicatiekosten.</p><p>Deze vergoeding dekt de productiekosten voor het publiceren van uw inzending. Om de betaling uit te voeren, gaat u naar <a href="{$queuedPaymentUrl}">{$queuedPaymentUrl}</a>.</p><p>Als u vragen heeft, raadpleegt u onze <a href="{$ submissionGuidelinesUrl}">Inzendingsrichtlijnen</a></p>'),
(461, 'PAYMENT_REQUEST_NOTIFICATION', 'ru', 'Запрос на оплату', 'Уведомление о необходимости оплаты', '<p>Здравствуйте, {$recipientName}!</p><p>Поздравляем с принятием Вашего материала «{$submissionTitle}» к публикации в журнале «{$journalName}». Теперь, когда Ваш материал принят, мы хотели бы попросить вас оплатить взнос за публикацию.</p><p>Эта сумма покрывает производственные расходы, связанные с подготовкой вашего материала к публикации. Чтобы произвести оплату, пожалуйста посетите <a href="{$queuedPaymentUrl}">{$queuedPaymentUrl}</a>.</p><p>Если у вас есть вопросы, пожалуйста, ознакомьтесь с нашим <a href="{$submissionGuidelinesUrl}">Руководством по подаче материалов</a></p>'),
(462, 'PAYMENT_REQUEST_NOTIFICATION', 'en', 'Payment Request', 'Payment Request Notification', '<p>Dear {$recipientName},</p><p>Congratulations on the acceptance of your submission, {$submissionTitle}, to {$journalName}. Now that your submission has been accepted, we would like to request payment of the publication fee.</p><p>This fee covers the production costs of bringing your submission to publication. To make the payment, please visit <a href="{$queuedPaymentUrl}">{$queuedPaymentUrl}</a>.</p><p>If you have any questions, please see our <a href="{$submissionGuidelinesUrl}">Submission Guidelines</a></p>'),
(463, 'ORCID_COLLECT_AUTHOR_ID', 'de', '', 'ORCID Zugriff erbeten', 'Liebe/r {$recipientName},<br/>\n<br/>\nSie sind als Autor/in eines eingereichten Beitrags bei der Zeitschrift {$journalName} benannt worden.<br/>\nUm Ihre Autor/innenschaft zu bestätigen, geben Sie bitte Ihre ORCID iD für diese Einreichung an, indem Sie den unten angegebenen Link aufrufen.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>ORCID iD anlegen oder verknüpfen</a><br/>\n<br/>\n<a href="{$orcidAboutUrl}">Mehr Informationen zu ORCID</a><br/>\n<br/>\nWenn Sie Fragen dazu haben, antworten Sie einfach auf diese E-Mail.<br/>\n<br/>\n{$principalContactSignature}<br/>\n'),
(464, 'ORCID_COLLECT_AUTHOR_ID', 'es', 'orcidCollectAuthorId', 'ORCID de envío', 'Estimado/a {$recipientName},\n<br/>\nSe le ha añadido como coautor/a de un artículo para {$journalName}. <br/>\nPara confirmar su autoría, añada su identificador ORCID a este envío mediante el siguiente enlace.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Registrar o conectar su identificador ORCID</a><br/>\n<br/>\n<br>\n<a href="{$orcidAboutUrl}">Puede encontrar más información sobre ORCID en {$journalName}</a><br/>\n<br/>\nSi tiene cualquier pregunta no dude en contactarme.<br/>\n<br/>\n{$principalContactSignature}<br/>\n'),
(465, 'ORCID_COLLECT_AUTHOR_ID', 'fr_CA', 'orcidCollectAuthorId', 'Soumission ORCID', '{$recipientName},<br/>\n<br/>\nVous avez été inscrit ou inscrite en tant qu''auteur ou auteure pour un manuscrit soumis à {$journalName}.<br/>\nPour confirmer votre statut d''auteur ou d''auteure, veuillez ajouter votre identifiant ORCID à cette soumission en cliquant sur le lien ci-dessous.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="icône identifiant ORCID" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Se connecter avec votre identifiant ORCID ou s''inscrire</a><br/>\n<br/>\n<br/>\n<a href="{$orcidAboutUrl}">Plus de renseignements sur votre identifiant ORCID dans {$journalName}</a><br/>\n<br/>\nSi vous avez des questions, veuillez communiquer avec nous.<br/>\n<br/>\n{$principalContactSignature}<br/>\n'),
(466, 'ORCID_COLLECT_AUTHOR_ID', 'it', '', 'Le chiediamo di inserire l''ORCID', 'Gentile {$recipientName},<br/>\n<br/>Il suo nominativo è stato inserito come co-autore di un manoscritto inviato per la pubblicazione a {$journalName}.<br/>\nPer confermare la sua partecipazione quale autore, le chiediamo di aggiungere il suo ORCID iD alla sottomissione utilizzando il link sottostante. <br/>\n<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Register or connect your ORCID iD</a><br/>\n<br/>\n<br>\n<a href="{$orcidAboutUrl}">Maggiori informazioni in merito ad ORCID sono disponibili al sito {$journalName}</a><br/>\n<br/>\nPer qualsiasi ulteriore chiarimento, la prego di contattarci.<br/>\n<br/>\n{$principalContactSignature}<br/>\n'),
(467, 'ORCID_COLLECT_AUTHOR_ID', 'nl', '', 'ORCID van uw inzending', 'Beste {$recipientName},<br/>\n<br/>\nU bent auteur van een inzending voor {$journalName}.<br/> \nWilt u bevestigen dat u co-auteur bent door uw ORCID id toe te voegen via volgende link?<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Registreer of koppel uw ORCID ID</a><br/>\n<br/>\n<br/>\n<a href="{$orcidAboutUrl}">Meer informatie over ORCID op {$journalName}</a><br/>\n<br/>\nNeemt u alstublieft contact op als u vragen heeft.<br/>\n<br/>\n{$principalContactSignature}<br/>\n'),
(468, 'ORCID_COLLECT_AUTHOR_ID', 'ru', '', 'ORCID материала', '{$recipientName}!<br/>\n<br/>\nВы были указаны как автор материала, отправленного в «{$journalName}».<br/>\nЧтобы подтвердить свое авторство, пожалуйста, добавьте свой идентификатор ORCID к этому материалу, перейдя по приведенной ниже ссылке.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Создать или подключить ваш ORCID iD</a><br/>\n<br/>\n<br>\n<a href="{$orcidAboutUrl}">Дополнительная информация об ORCID в «{$journalName}»</a><br/>\n<br/>\nЕсли у Вас есть какие-либо вопросы, пожалуйста, свяжитесь со мной.<br/>\n<br/>\n{$principalContactSignature}<br/>\n'),
(469, 'ORCID_COLLECT_AUTHOR_ID', 'en', 'orcidCollectAuthorId', 'Submission ORCID', 'Dear {$recipientName},<br/>\n<br/>\nYou have been listed as an author on a manuscript submission to {$journalName}.<br/>\nTo confirm your authorship, please add your ORCID id to this submission by visiting the link provided below.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Register or connect your ORCID iD</a><br/>\n<br/>\n<br>\n<a href="{$orcidAboutUrl}">More information about ORCID at {$journalName}</a><br/>\n<br/>\nIf you have any questions, please contact me.<br/>\n<br/>\n{$principalContactSignature}<br/>\n'),
(470, 'ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'de', '', 'ORCID Zugriff erbeten', 'Liebe/r {$recipientName},<br>\n<br>\nSie sind als Autor/in des eingereichten Beitrags "{$submissionTitle}" bei der Zeitschrift {$journalName} benannt worden.<br>\n<br>\nBitte gestatten Sie uns Ihre ORCID iD, falls vorhanden, zu diesem Beitrag hinzuzufügen, sowie ihr ORCID-Profil bei Veröffentlichung des Beitrags zu aktualisieren.<br>\nDazu folgen Sie dem unten stehenden Link zur offiziellen ORCID-Seite, melden sich mit Ihren Daten an und authorisieren den Zugriff, indem\nSie den Anweisungen auf der Seite folgen.<br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>ORCID id anlegen oder verknüpfen</a><br/>\n<br>\n<a href="{$orcidAboutUrl}">Mehr Informationen zu ORCID</a><br />\n<br>\nWenn Sie Fragen dazu haben, antworten Sie einfach auf diese E-Mail.<br>\n<br>\n{$principalContactSignature}<br>\n'),
(471, 'ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'es', 'orcidRequestAuthorAuthorization', 'Solicitando acceso de registro ORCID', 'Estimado/a {$recipientName},<br>\n<br>\nUsted ha sido incluido como autor en la presentación del manuscrito "{$submissionTitle}" a {$journalName}.\n<br>\n<br>\nPermítanos agregar su identificación ORCID a este envío y también agregar el mismo a su perfil ORCID en la publicación.<br>\nVisite el enlace al sitio web oficial de ORCID, inicie sesión con su perfil y autorice el acceso siguiendo las instrucciones.<br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Registre o conecte su ORCID iD</a><br/>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">Más acerca de ORCID en{$journalName}</a><br/>\n<br>\nSi tiene alguna pregunta, por favor póngase en contacto conmigo.<br>\n<br>\n{$principalContactSignature}<br>\n'),
(472, 'ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'fr_CA', 'orcidRequestAuthorAuthorization', 'Demande d''accès au dossier ORCID', '{$recipientName},<br/>\n<br/>\nVous avez été inscrit ou inscrite en tant qu''auteur ou auteure pour le manuscrit « {$submissionTitle} » soumis à {$journalName}.\n<br/>\n<br/>\nVeuillez nous autoriser à ajouter votre identifiant ORCID à cette soumission et à ajouter également la soumission à votre dossier ORCID suite à sa publication.\n<br/>\nSuivre le lien vers le site officiel ORCID, vous connecter avec votre profil et autoriser l''accès en suivant les instructions.<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="icône identifiant ORCID" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Se connecter avec votre identifiant ORCID ou s''inscrire</a><br/>\n<br/>\n<br/>\n<a href="{$orcidAboutUrl}">Plus de renseignements sur votre identifiant ORCID dans {$journalName}</a><br/>\n<br/>\nSi vous avez des questions, veuillez communiquer avec nous.<br/>\n<br/>\n{$principalContactSignature}<br/>\n'),
(473, 'ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'it', '', 'Richiesta di accesso al record ORCID', 'Gentile {$recipientName},<br>\n<br>\nIl suo nominativo è stato aggiunto come co-autore nel manoscritto "{$submissionTitle}" sottoposto per la pubblicazione a {$journalName}.\n<br>\n<br>\nLe chiediamo il permesso di aggiungere il suo ORCID iD a questa sottomissione e di poter aggiungere questa sottomissione al suo profilo ORCID.<br>\nLe chiediamo di andare al suo profilo ufficiale ORCID e di autorizzare l''accesso seguendo le indicazioni che verranno fornite. <br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Collega il tuo ORCID iD o registrati adesso</a><br/>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">Maggiori informazioni su ORCID sono disponibili a questo indirizzo: {$journalName}</a><br/>\n<br>\nSe ha qualsiasi domanda o dubbio, la prego di contattarci.<br>\n<br>\n{$principalContactSignature}<br>\n'),
(474, 'ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'nl', '', 'Toegangsverzoek tot uw ORCID profiel', 'Beste {$recipientName},<br/>\n<br/>\nU bent auteur van het manuscript "{$submissionTitle}" dat werd ingediend voor {$journalName}.\n<br/>\n<br/>\nWilt u uw toestemming geven om uw ORCID ID toe te voegen aan deze inzending en de inzending toe te voegen aan uw ORCID profiel bij publicatie?<br/>\nKlik op de link naar de officiële ORCID website, meld u aan met uw gebruikersprofiel en authoriseer de toegang door de instructies te volgen.<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Registreer of koppel uw ORCID ID</a><br/>\n<br/>\n<br/>\n<a href="{$orcidAboutUrl}">Meer informatie over ORCID op {$journalName}</a><br/>\n<br>\nNeemt u alstublieft contact op als u vragen heeft.<br/>\n<br/>\n{$principalContactSignature}<br/>\n'),
(475, 'ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'ru', '', 'Запрос доступа к записи ORCID', '{$recipientName}!<br>\n<br>\nВы были указаны как автор материала «{$submissionTitle}», отправленного в «{$journalName}».\n<br>\n<br>\nПожалуйста, дайте нам возможность добавить ваш ORCID id к этому материалу, а также добавить материал в ваш профиль ORCID после публикации.<br>\nПерейдите по ссылке на официальном вебсайте ORCID, войдите в систему с вашей учетной записью и авторизуйте доступ, следуя инструкциям.<br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Создать или подключить ваш ORCID iD</a><br/>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">Подробнее об ORCID в «{$journalName}»</a><br/>\n<br>\nЕсли у Вас есть какие-либо вопросы, пожалуйста, свяжитесь со мной.<br>\n<br>\n{$principalContactSignature}<br>\n');
INSERT INTO `email_templates_default_data` VALUES
(476, 'ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'en', 'orcidRequestAuthorAuthorization', 'Requesting ORCID record access', 'Dear {$recipientName},<br>\n<br>\nYou have been listed as an author on the manuscript submission "{$submissionTitle}" to {$journalName}.\n<br>\n<br>\nPlease allow us to add your ORCID id to this submission and also to add the submission to your ORCID profile on publication.<br>\nVisit the link to the official ORCID website, login with your profile and authorize the access by following the instructions.<br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Register or Connect your ORCID iD</a><br/>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">More about ORCID at {$journalName}</a><br/>\n<br>\nIf you have any questions, please contact me.<br>\n<br>\n{$principalContactSignature}<br>\n'),
(477, 'MANUAL_PAYMENT_NOTIFICATION', 'de', 'Manuelle Zahlungsbenachrichtigung', 'Benachrichtigung über manuelle Zahlung', 'Eine manuelle Zahlung ist für die Zeitschrift {$journalName} und den/die Benutzer/in {$senderName} (Benutzer/innen-Name &quot;{$senderUsername}&quot;) angekündigt worden.<br />\n<br />\nGezahlt werden soll für &quot;{$paymentName}&quot;.<br />\nDie Kosten betragen {$paymentAmount} ({$paymentCurrencyCode}).<br />\n<br />\nDiese E-Mail wurde vom OJS-Plugin Manuelle Gebührenzahlung erzeugt.'),
(478, 'MANUAL_PAYMENT_NOTIFICATION', 'es', 'Notificación de pago manual', 'Notificación de pago manual', 'Se necesita procesar un pago manual para la revista {$journalName} y el usuario/a {$senderName} (username &quot;{$senderUsername}&quot;).<br />\n<br />\nEl elemento pagado es &quot;{$paymentName}&quot;.<br />\nEl precio es {$paymentAmount} ({$paymentCurrencyCode}).<br />\n<br />\nEste correo ha sido generado por el módulo de pago manual de Open Journal Systems.'),
(479, 'MANUAL_PAYMENT_NOTIFICATION', 'fr_CA', 'Avis de paiement manuel', 'Avis de paiement manuel', 'Un paiement manuel doit être traité pour la revue {$journalName} et l''utilisateur {$senderName} (nom d''utilisateur &quot;{$senderUsername}&quot;).<br />\n<br />\nL''élément facturé est &quot;{$paymentName}&quot;.<br />\nLe coût est de {$paymentAmount} ({$paymentCurrencyCode}).<br />\n<br />\nCe courriel a été généré par le plugiciel de paiement manuel du Open Journal Systems.'),
(480, 'MANUAL_PAYMENT_NOTIFICATION', 'it', 'Notifica di pagamento', 'Notifica di pagamento manuale', 'È necessario registrare un pagamento manuale per {$journalName}, utente {$senderName} (username &quot;{$senderUsername}&quot;).<br />\n<br />\nIl pagamento riguarda &quot;{$paymentName}&quot;.<br />\nIl costo è {$paymentAmount} ({$paymentCurrencyCode}).<br />\n<br />\nQuesta email è generata automaticamente dal plugin di pagamento manuale per Open Journal Systems.'),
(481, 'MANUAL_PAYMENT_NOTIFICATION', 'nl', '', 'Bericht van handmatige betaling', 'Er moet een handmatige betaling verwerkt worden voor tijdschrift {$journalName} en gebruiker {$senderName} (gebruikersnaam &quot;{$senderUsername}&quot;).<br />\n<br />\nEr wordt betaald voor &quot;{$paymentName}&quot;.<br />\nDe prijs is {$paymentAmount} ({$paymentCurrencyCode}).<br />\n<br />\nDeze e-mail is gegenereerd door de Handmatige betalingen plugin van Open Journal Systems.'),
(482, 'MANUAL_PAYMENT_NOTIFICATION', 'ru', 'Уведомить о вводе платежа вручную', 'Уведомление о платеже', 'Необходимо вручную обработать платеж для журнала «{$journalName}» и пользователя {$senderName} (имя пользователя «{$senderUsername}»).<br />\n<br />\nОплата вносится за «{$paymentName}».<br />\nСумма {$paymentAmount} ({$paymentCurrencyCode}).<br />\n<br />\nЭто письмо сгенерировано модулем «Ввод оплаты вручную» системы Open Journal Systems.'),
(483, 'MANUAL_PAYMENT_NOTIFICATION', 'en', 'Manual Payment Notify', 'Manual Payment Notification', 'A manual payment needs to be processed for the journal {$journalName} and the user {senderName} (username &quot;{$senderUsername}&quot;).<br />\n<br />\nThe item being paid for is &quot;{$paymentName}&quot;.<br />\nThe cost is {$paymentAmount} ({$paymentCurrencyCode}).<br />\n<br />\nThis email was generated by Open Journal Systems'' Manual Payment plugin.');

-- --------------------------------------------------------

--
-- Table structure for table `email_templates_settings`
--

CREATE TABLE `email_templates_settings` (
  `email_template_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `email_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`email_template_setting_id`),
  UNIQUE KEY `email_templates_settings_unique` (`email_id`,`locale`,`setting_name`),
  KEY `email_templates_settings_email_id` (`email_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about custom email templates, including localized properties such as the subject and body.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `event_log`
--

CREATE TABLE `event_log` (
  `log_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL COMMENT 'NULL if it''s system or automated event',
  `date_logged` datetime NOT NULL,
  `event_type` bigint(20) DEFAULT NULL,
  `message` text,
  `is_translated` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `event_log_user_id` (`user_id`),
  KEY `event_log_assoc` (`assoc_type`,`assoc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A log of all events related to an object like a submission.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `event_log_settings`
--

CREATE TABLE `event_log_settings` (
  `event_log_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `log_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`event_log_setting_id`),
  UNIQUE KEY `event_log_settings_unique` (`log_id`,`setting_name`,`locale`),
  KEY `event_log_settings_log_id` (`log_id`),
  KEY `event_log_settings_name_value` (`setting_name`(50),`setting_value`(150))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data about an event log entry. This data is commonly used to display information about an event to a user.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `failed_jobs`
--

CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A log of all failed jobs.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `files`
--

CREATE TABLE `files` (
  `file_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(255) NOT NULL,
  `mimetype` varchar(255) NOT NULL,
  PRIMARY KEY (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Records information in the database about files tracked by the system, linking them to the local filesystem.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `filters`
--

CREATE TABLE `filters` (
  `filter_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `filter_group_id` bigint(20) NOT NULL DEFAULT '0',
  `context_id` bigint(20) NOT NULL DEFAULT '0',
  `display_name` varchar(255) DEFAULT NULL,
  `class_name` varchar(255) DEFAULT NULL,
  `is_template` smallint(6) NOT NULL DEFAULT '0',
  `parent_filter_id` bigint(20) NOT NULL DEFAULT '0',
  `seq` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`filter_id`),
  KEY `filters_filter_group_id` (`filter_group_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Filters represent a transformation of a supported piece of data from one form to another, such as a PHP object into an XML document.' AUTO_INCREMENT=28 ;

--
-- Dumping data for table `filters`
--

INSERT INTO `filters` VALUES
(1, 1, 0, 'Crossref XML issue export', 'APP\\plugins\\generic\\crossref\\filter\\IssueCrossrefXmlFilter', 0, 0, 0),
(2, 2, 0, 'Crossref XML article export', 'APP\\plugins\\generic\\crossref\\filter\\ArticleCrossrefXmlFilter', 0, 0, 0),
(3, 3, 0, 'DataCite XML export', 'APP\\plugins\\generic\\datacite\\filter\\DataciteXmlFilter', 0, 0, 0),
(4, 4, 0, 'DataCite XML export', 'APP\\plugins\\generic\\datacite\\filter\\DataciteXmlFilter', 0, 0, 0),
(5, 5, 0, 'DataCite XML export', 'APP\\plugins\\generic\\datacite\\filter\\DataciteXmlFilter', 0, 0, 0),
(6, 6, 0, 'Extract metadata from a(n) Submission', 'APP\\plugins\\metadata\\dc11\\filter\\Dc11SchemaArticleAdapter', 0, 0, 0),
(7, 7, 0, 'DOAJ XML export', 'APP\\plugins\\importexport\\doaj\\filter\\DOAJXmlFilter', 0, 0, 0),
(8, 8, 0, 'DOAJ JSON export', 'APP\\plugins\\importexport\\doaj\\filter\\DOAJJsonFilter', 0, 0, 0),
(9, 9, 0, 'Native XML submission export', 'APP\\plugins\\importexport\\native\\filter\\ArticleNativeXmlFilter', 0, 0, 0),
(10, 10, 0, 'Native XML submission import', 'APP\\plugins\\importexport\\native\\filter\\NativeXmlArticleFilter', 0, 0, 0),
(11, 11, 0, 'Native XML issue export', 'APP\\plugins\\importexport\\native\\filter\\IssueNativeXmlFilter', 0, 0, 0),
(12, 12, 0, 'Native XML issue import', 'APP\\plugins\\importexport\\native\\filter\\NativeXmlIssueFilter', 0, 0, 0),
(13, 13, 0, 'Native XML issue galley export', 'APP\\plugins\\importexport\\native\\filter\\IssueGalleyNativeXmlFilter', 0, 0, 0),
(14, 14, 0, 'Native XML issue galley import', 'APP\\plugins\\importexport\\native\\filter\\NativeXmlIssueGalleyFilter', 0, 0, 0),
(15, 15, 0, 'Native XML author export', 'APP\\plugins\\importexport\\native\\filter\\AuthorNativeXmlFilter', 0, 0, 0),
(16, 16, 0, 'Native XML author import', 'APP\\plugins\\importexport\\native\\filter\\NativeXmlAuthorFilter', 0, 0, 0),
(17, 18, 0, 'Native XML submission file import', 'APP\\plugins\\importexport\\native\\filter\\NativeXmlArticleFileFilter', 0, 0, 0),
(18, 17, 0, 'Native XML submission file export', 'PKP\\plugins\\importexport\\native\\filter\\SubmissionFileNativeXmlFilter', 0, 0, 0),
(19, 19, 0, 'Native XML representation export', 'APP\\plugins\\importexport\\native\\filter\\ArticleGalleyNativeXmlFilter', 0, 0, 0),
(20, 20, 0, 'Native XML representation import', 'APP\\plugins\\importexport\\native\\filter\\NativeXmlArticleGalleyFilter', 0, 0, 0),
(21, 21, 0, 'Native XML Publication export', 'APP\\plugins\\importexport\\native\\filter\\PublicationNativeXmlFilter', 0, 0, 0),
(22, 22, 0, 'Native XML publication import', 'APP\\plugins\\importexport\\native\\filter\\NativeXmlPublicationFilter', 0, 0, 0),
(23, 23, 0, 'APP\\plugins\\importexport\\pubmed\\filter\\ArticlePubMedXmlFilter', 'APP\\plugins\\importexport\\pubmed\\filter\\ArticlePubMedXmlFilter', 0, 0, 0),
(24, 24, 0, 'User XML user export', 'PKP\\plugins\\importexport\\users\\filter\\PKPUserUserXmlFilter', 0, 0, 0),
(25, 25, 0, 'User XML user import', 'PKP\\plugins\\importexport\\users\\filter\\UserXmlPKPUserFilter', 0, 0, 0),
(26, 26, 0, 'Native XML user group export', 'PKP\\plugins\\importexport\\users\\filter\\UserGroupNativeXmlFilter', 0, 0, 0),
(27, 27, 0, 'Native XML user group import', 'PKP\\plugins\\importexport\\users\\filter\\NativeXmlUserGroupFilter', 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `filter_groups`
--

CREATE TABLE `filter_groups` (
  `filter_group_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `symbolic` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `input_type` varchar(255) DEFAULT NULL,
  `output_type` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`filter_group_id`),
  UNIQUE KEY `filter_groups_symbolic` (`symbolic`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Filter groups are used to organized filters into named sets, which can be retrieved by the application for invocation.' AUTO_INCREMENT=28 ;

--
-- Dumping data for table `filter_groups`
--

INSERT INTO `filter_groups` VALUES
(1, 'issue=>crossref-xml', 'plugins.importexport.crossref.displayName', 'plugins.importexport.crossref.description', 'class::classes.issue.Issue[]', 'xml::schema(https://www.crossref.org/schemas/crossref5.3.1.xsd)'),
(2, 'article=>crossref-xml', 'plugins.importexport.crossref.displayName', 'plugins.importexport.crossref.description', 'class::classes.submission.Submission[]', 'xml::schema(https://www.crossref.org/schemas/crossref5.3.1.xsd)'),
(3, 'issue=>datacite-xml', 'plugins.importexport.datacite.displayName', 'plugins.importexport.datacite.description', 'class::classes.issue.Issue', 'xml::schema(http://schema.datacite.org/meta/kernel-4/metadata.xsd)'),
(4, 'article=>datacite-xml', 'plugins.importexport.datacite.displayName', 'plugins.importexport.datacite.description', 'class::classes.submission.Submission', 'xml::schema(http://schema.datacite.org/meta/kernel-4/metadata.xsd)'),
(5, 'galley=>datacite-xml', 'plugins.importexport.datacite.displayName', 'plugins.importexport.datacite.description', 'class::lib.pkp.classes.galley.Galley', 'xml::schema(http://schema.datacite.org/meta/kernel-4/metadata.xsd)'),
(6, 'article=>dc11', 'plugins.metadata.dc11.articleAdapter.displayName', 'plugins.metadata.dc11.articleAdapter.description', 'class::classes.submission.Submission', 'metadata::APP\\plugins\\metadata\\dc11\\schema\\Dc11Schema(ARTICLE)'),
(7, 'article=>doaj-xml', 'plugins.importexport.doaj.displayName', 'plugins.importexport.doaj.description', 'class::classes.submission.Submission[]', 'xml::schema(plugins/importexport/doaj/doajArticles.xsd)'),
(8, 'article=>doaj-json', 'plugins.importexport.doaj.displayName', 'plugins.importexport.doaj.description', 'class::classes.submission.Submission', 'primitive::string'),
(9, 'article=>native-xml', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'class::classes.submission.Submission[]', 'xml::schema(plugins/importexport/native/native.xsd)'),
(10, 'native-xml=>article', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'xml::schema(plugins/importexport/native/native.xsd)', 'class::classes.submission.Submission[]'),
(11, 'issue=>native-xml', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'class::classes.issue.Issue[]', 'xml::schema(plugins/importexport/native/native.xsd)'),
(12, 'native-xml=>issue', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'xml::schema(plugins/importexport/native/native.xsd)', 'class::classes.issue.Issue[]'),
(13, 'issuegalley=>native-xml', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'class::classes.issue.IssueGalley[]', 'xml::schema(plugins/importexport/native/native.xsd)'),
(14, 'native-xml=>issuegalley', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'xml::schema(plugins/importexport/native/native.xsd)', 'class::classes.issue.IssueGalley[]'),
(15, 'author=>native-xml', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'class::classes.author.Author[]', 'xml::schema(plugins/importexport/native/native.xsd)'),
(16, 'native-xml=>author', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'xml::schema(plugins/importexport/native/native.xsd)', 'class::classes.author.Author[]'),
(17, 'SubmissionFile=>native-xml', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'class::lib.pkp.classes.submissionFile.SubmissionFile', 'xml::schema(plugins/importexport/native/native.xsd)'),
(18, 'native-xml=>SubmissionFile', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'xml::schema(plugins/importexport/native/native.xsd)', 'class::lib.pkp.classes.submissionFile.SubmissionFile[]'),
(19, 'article-galley=>native-xml', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'class::lib.pkp.classes.galley.Galley', 'xml::schema(plugins/importexport/native/native.xsd)'),
(20, 'native-xml=>ArticleGalley', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'xml::schema(plugins/importexport/native/native.xsd)', 'class::lib.pkp.classes.galley.Galley[]'),
(21, 'publication=>native-xml', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'class::classes.publication.Publication', 'xml::schema(plugins/importexport/native/native.xsd)'),
(22, 'native-xml=>Publication', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'xml::schema(plugins/importexport/native/native.xsd)', 'class::classes.publication.Publication[]'),
(23, 'article=>pubmed-xml', 'plugins.importexport.pubmed.displayName', 'plugins.importexport.pubmed.description', 'class::classes.submission.Submission[]', 'xml::dtd'),
(24, 'user=>user-xml', 'plugins.importexport.users.displayName', 'plugins.importexport.users.description', 'class::lib.pkp.classes.user.User[]', 'xml::schema(lib/pkp/plugins/importexport/users/pkp-users.xsd)'),
(25, 'user-xml=>user', 'plugins.importexport.users.displayName', 'plugins.importexport.users.description', 'xml::schema(lib/pkp/plugins/importexport/users/pkp-users.xsd)', 'class::classes.users.User[]'),
(26, 'usergroup=>user-xml', 'plugins.importexport.users.displayName', 'plugins.importexport.users.description', 'class::lib.pkp.classes.security.UserGroup[]', 'xml::schema(lib/pkp/plugins/importexport/users/pkp-users.xsd)'),
(27, 'user-xml=>usergroup', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'xml::schema(lib/pkp/plugins/importexport/users/pkp-users.xsd)', 'class::lib.pkp.classes.security.UserGroup[]');

-- --------------------------------------------------------

--
-- Table structure for table `filter_settings`
--

CREATE TABLE `filter_settings` (
  `filter_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `filter_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`filter_setting_id`),
  UNIQUE KEY `filter_settings_unique` (`filter_id`,`locale`,`setting_name`),
  KEY `filter_settings_id` (`filter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about filters, including localized content.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `genres`
--

CREATE TABLE `genres` (
  `genre_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `seq` bigint(20) NOT NULL,
  `enabled` smallint(6) NOT NULL DEFAULT '1',
  `category` bigint(20) NOT NULL DEFAULT '1',
  `dependent` smallint(6) NOT NULL DEFAULT '0',
  `supplementary` smallint(6) NOT NULL DEFAULT '0',
  `required` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Whether or not at least one file of this genre is required for a new submission.',
  `entry_key` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`genre_id`),
  KEY `genres_context_id` (`context_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The types of submission files configured for each context, such as Article Text, Data Set, Transcript, etc.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `genre_settings`
--

CREATE TABLE `genre_settings` (
  `genre_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `genre_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  PRIMARY KEY (`genre_setting_id`),
  UNIQUE KEY `genre_settings_unique` (`genre_id`,`locale`,`setting_name`),
  KEY `genre_settings_genre_id` (`genre_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about file genres, including localized properties such as the genre name.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `institutional_subscriptions`
--

CREATE TABLE `institutional_subscriptions` (
  `institutional_subscription_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `subscription_id` bigint(20) NOT NULL,
  `institution_id` bigint(20) NOT NULL,
  `mailing_address` varchar(255) DEFAULT NULL,
  `domain` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`institutional_subscription_id`),
  KEY `institutional_subscriptions_subscription_id` (`subscription_id`),
  KEY `institutional_subscriptions_institution_id` (`institution_id`),
  KEY `institutional_subscriptions_domain` (`domain`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A list of institutional subscriptions, linking a subscription with an institution.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `institutions`
--

CREATE TABLE `institutions` (
  `institution_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `ror` varchar(255) DEFAULT NULL COMMENT 'ROR (Research Organization Registry) ID',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`institution_id`),
  KEY `institutions_context_id` (`context_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Institutions for statistics and subscriptions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `institution_ip`
--

CREATE TABLE `institution_ip` (
  `institution_ip_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `institution_id` bigint(20) NOT NULL,
  `ip_string` varchar(40) NOT NULL,
  `ip_start` bigint(20) NOT NULL,
  `ip_end` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`institution_ip_id`),
  KEY `institution_ip_institution_id` (`institution_id`),
  KEY `institution_ip_start` (`ip_start`),
  KEY `institution_ip_end` (`ip_end`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Records IP address ranges and associates them with institutions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `institution_settings`
--

CREATE TABLE `institution_settings` (
  `institution_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `institution_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`institution_setting_id`),
  UNIQUE KEY `institution_settings_unique` (`institution_id`,`locale`,`setting_name`),
  KEY `institution_settings_institution_id` (`institution_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about institutions, including localized properties like names.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `issues`
--

CREATE TABLE `issues` (
  `issue_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `journal_id` bigint(20) NOT NULL,
  `volume` smallint(6) DEFAULT NULL,
  `number` varchar(40) DEFAULT NULL,
  `year` smallint(6) DEFAULT NULL,
  `published` smallint(6) NOT NULL DEFAULT '0',
  `date_published` datetime DEFAULT NULL,
  `date_notified` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `access_status` smallint(6) NOT NULL DEFAULT '1',
  `open_access_date` datetime DEFAULT NULL,
  `show_volume` smallint(6) NOT NULL DEFAULT '0',
  `show_number` smallint(6) NOT NULL DEFAULT '0',
  `show_year` smallint(6) NOT NULL DEFAULT '0',
  `show_title` smallint(6) NOT NULL DEFAULT '0',
  `style_file_name` varchar(90) DEFAULT NULL,
  `original_style_file_name` varchar(255) DEFAULT NULL,
  `url_path` varchar(64) DEFAULT NULL,
  `doi_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`issue_id`),
  KEY `issues_journal_id` (`journal_id`),
  KEY `issues_doi_id` (`doi_id`),
  KEY `issues_url_path` (`url_path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A list of all journal issues, with identifying information like year, number, volume, etc.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `issue_files`
--

CREATE TABLE `issue_files` (
  `file_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `issue_id` bigint(20) NOT NULL,
  `file_name` varchar(90) NOT NULL,
  `file_type` varchar(255) NOT NULL,
  `file_size` bigint(20) NOT NULL,
  `content_type` bigint(20) NOT NULL,
  `original_file_name` varchar(127) DEFAULT NULL,
  `date_uploaded` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  PRIMARY KEY (`file_id`),
  KEY `issue_files_issue_id` (`issue_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Relationships between issues and issue files, such as cover images.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `issue_galleys`
--

CREATE TABLE `issue_galleys` (
  `galley_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `locale` varchar(14) DEFAULT NULL,
  `issue_id` bigint(20) NOT NULL,
  `file_id` bigint(20) NOT NULL,
  `label` varchar(255) DEFAULT NULL,
  `seq` double(8,2) NOT NULL DEFAULT '0.00',
  `url_path` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`galley_id`),
  KEY `issue_galleys_issue_id` (`issue_id`),
  KEY `issue_galleys_file_id` (`file_id`),
  KEY `issue_galleys_url_path` (`url_path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Issue galleys are representations of the entire issue in a single file, such as a complete issue PDF.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `issue_galley_settings`
--

CREATE TABLE `issue_galley_settings` (
  `issue_galley_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `galley_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  PRIMARY KEY (`issue_galley_setting_id`),
  UNIQUE KEY `issue_galley_settings_unique` (`galley_id`,`locale`,`setting_name`),
  KEY `issue_galley_settings_galley_id` (`galley_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about issue galleys, including localized content such as labels.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `issue_settings`
--

CREATE TABLE `issue_settings` (
  `issue_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `issue_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`issue_setting_id`),
  UNIQUE KEY `issue_settings_unique` (`issue_id`,`locale`,`setting_name`),
  KEY `issue_settings_issue_id` (`issue_id`),
  KEY `issue_settings_name_value` (`setting_name`(50),`setting_value`(150))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about issues, including localized properties such as issue titles.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jobs`
--

CREATE TABLE `jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) NOT NULL,
  `payload` longtext NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_reserved_at_index` (`queue`,`reserved_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='All pending or in-progress jobs.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `job_batches`
--

CREATE TABLE `job_batches` (
  `id` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `total_jobs` int(11) NOT NULL,
  `pending_jobs` int(11) NOT NULL,
  `failed_jobs` int(11) NOT NULL,
  `failed_job_ids` text NOT NULL,
  `options` mediumtext,
  `cancelled_at` int(11) DEFAULT NULL,
  `created_at` int(11) NOT NULL,
  `finished_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Job batches allow jobs to be collected into groups for managed processing.';

-- --------------------------------------------------------

--
-- Table structure for table `journals`
--

CREATE TABLE `journals` (
  `journal_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `path` varchar(32) NOT NULL,
  `seq` double(8,2) NOT NULL DEFAULT '0.00' COMMENT 'Used to order lists of journals',
  `primary_locale` varchar(14) NOT NULL,
  `enabled` smallint(6) NOT NULL DEFAULT '1' COMMENT 'Controls whether or not the journal is considered "live" and will appear on the website. (Note that disabled journals may still be accessible, but only if the user knows the URL.)',
  `current_issue_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`journal_id`),
  UNIQUE KEY `journals_path` (`path`),
  KEY `journals_issue_id` (`current_issue_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A list of all journals in the installation of OJS.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `journal_settings`
--

CREATE TABLE `journal_settings` (
  `journal_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `journal_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`journal_setting_id`),
  UNIQUE KEY `journal_settings_unique` (`journal_id`,`locale`,`setting_name`),
  KEY `journal_settings_journal_id` (`journal_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about journals, including localized properties like policies.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `library_files`
--

CREATE TABLE `library_files` (
  `file_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `original_file_name` varchar(255) NOT NULL,
  `file_type` varchar(255) NOT NULL,
  `file_size` bigint(20) NOT NULL,
  `type` smallint(6) NOT NULL,
  `date_uploaded` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `submission_id` bigint(20) DEFAULT NULL,
  `public_access` smallint(6) DEFAULT '0',
  PRIMARY KEY (`file_id`),
  KEY `library_files_context_id` (`context_id`),
  KEY `library_files_submission_id` (`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Library files can be associated with the context (press/server/journal) or with individual submissions, and are typically forms, agreements, and other administrative documents that are not part of the scholarly content.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `library_file_settings`
--

CREATE TABLE `library_file_settings` (
  `library_file_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `file_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object|date)',
  PRIMARY KEY (`library_file_setting_id`),
  UNIQUE KEY `library_file_settings_unique` (`file_id`,`locale`,`setting_name`),
  KEY `library_file_settings_file_id` (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about library files, including localized content such as names.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_context`
--

CREATE TABLE `metrics_context` (
  `metrics_context_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `load_id` varchar(50) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `date` date NOT NULL,
  `metric` int(11) NOT NULL,
  PRIMARY KEY (`metrics_context_id`),
  KEY `metrics_context_load_id` (`load_id`),
  KEY `metrics_context_context_id` (`context_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Daily statistics for views of the homepage.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_counter_submission_daily`
--

CREATE TABLE `metrics_counter_submission_daily` (
  `metrics_counter_submission_daily_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `load_id` varchar(50) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `date` date NOT NULL,
  `metric_investigations` int(11) NOT NULL,
  `metric_investigations_unique` int(11) NOT NULL,
  `metric_requests` int(11) NOT NULL,
  `metric_requests_unique` int(11) NOT NULL,
  PRIMARY KEY (`metrics_counter_submission_daily_id`),
  UNIQUE KEY `msd_uc_load_id_context_id_submission_id_date` (`load_id`,`context_id`,`submission_id`,`date`),
  KEY `msd_load_id` (`load_id`),
  KEY `metrics_counter_submission_daily_context_id` (`context_id`),
  KEY `metrics_counter_submission_daily_submission_id` (`submission_id`),
  KEY `msd_context_id_submission_id` (`context_id`,`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Daily statistics matching the COUNTER R5 protocol for views and downloads of published submissions and galleys.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_counter_submission_institution_daily`
--

CREATE TABLE `metrics_counter_submission_institution_daily` (
  `metrics_counter_submission_institution_daily_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `load_id` varchar(50) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `institution_id` bigint(20) NOT NULL,
  `date` date NOT NULL,
  `metric_investigations` int(11) NOT NULL,
  `metric_investigations_unique` int(11) NOT NULL,
  `metric_requests` int(11) NOT NULL,
  `metric_requests_unique` int(11) NOT NULL,
  PRIMARY KEY (`metrics_counter_submission_institution_daily_id`),
  UNIQUE KEY `msid_uc_load_id_context_id_submission_id_institution_id_date` (`load_id`,`context_id`,`submission_id`,`institution_id`,`date`),
  KEY `msid_load_id` (`load_id`),
  KEY `metrics_counter_submission_institution_daily_context_id` (`context_id`),
  KEY `metrics_counter_submission_institution_daily_submission_id` (`submission_id`),
  KEY `metrics_counter_submission_institution_daily_institution_id` (`institution_id`),
  KEY `msid_context_id_submission_id` (`context_id`,`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Daily statistics matching the COUNTER R5 protocol for views and downloads from institutions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_counter_submission_institution_monthly`
--

CREATE TABLE `metrics_counter_submission_institution_monthly` (
  `metrics_counter_submission_institution_monthly_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `institution_id` bigint(20) NOT NULL,
  `month` int(11) NOT NULL,
  `metric_investigations` int(11) NOT NULL,
  `metric_investigations_unique` int(11) NOT NULL,
  `metric_requests` int(11) NOT NULL,
  `metric_requests_unique` int(11) NOT NULL,
  PRIMARY KEY (`metrics_counter_submission_institution_monthly_id`),
  UNIQUE KEY `msim_uc_context_id_submission_id_institution_id_month` (`context_id`,`submission_id`,`institution_id`,`month`),
  KEY `metrics_counter_submission_institution_monthly_context_id` (`context_id`),
  KEY `metrics_counter_submission_institution_monthly_submission_id` (`submission_id`),
  KEY `metrics_counter_submission_institution_monthly_institution_id` (`institution_id`),
  KEY `msim_context_id_submission_id` (`context_id`,`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Monthly statistics matching the COUNTER R5 protocol for views and downloads from institutions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_counter_submission_monthly`
--

CREATE TABLE `metrics_counter_submission_monthly` (
  `metrics_counter_submission_monthly_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `month` int(11) NOT NULL,
  `metric_investigations` int(11) NOT NULL,
  `metric_investigations_unique` int(11) NOT NULL,
  `metric_requests` int(11) NOT NULL,
  `metric_requests_unique` int(11) NOT NULL,
  PRIMARY KEY (`metrics_counter_submission_monthly_id`),
  UNIQUE KEY `msm_uc_context_id_submission_id_month` (`context_id`,`submission_id`,`month`),
  KEY `metrics_counter_submission_monthly_context_id` (`context_id`),
  KEY `metrics_counter_submission_monthly_submission_id` (`submission_id`),
  KEY `msm_context_id_submission_id` (`context_id`,`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Monthly statistics matching the COUNTER R5 protocol for views and downloads of published submissions and galleys.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_issue`
--

CREATE TABLE `metrics_issue` (
  `metrics_issue_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `load_id` varchar(50) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `issue_id` bigint(20) NOT NULL,
  `issue_galley_id` bigint(20) DEFAULT NULL,
  `date` date NOT NULL,
  `metric` int(11) NOT NULL,
  PRIMARY KEY (`metrics_issue_id`),
  KEY `metrics_issue_load_id` (`load_id`),
  KEY `metrics_issue_context_id` (`context_id`),
  KEY `metrics_issue_issue_id` (`issue_id`),
  KEY `metrics_issue_issue_galley_id` (`issue_galley_id`),
  KEY `metrics_issue_context_id_issue_id` (`context_id`,`issue_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Daily statistics for views and downloads of published issues.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_submission`
--

CREATE TABLE `metrics_submission` (
  `metrics_submission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `load_id` varchar(50) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `representation_id` bigint(20) DEFAULT NULL,
  `submission_file_id` bigint(20) unsigned DEFAULT NULL,
  `file_type` bigint(20) DEFAULT NULL,
  `assoc_type` bigint(20) NOT NULL,
  `date` date NOT NULL,
  `metric` int(11) NOT NULL,
  PRIMARY KEY (`metrics_submission_id`),
  KEY `ms_load_id` (`load_id`),
  KEY `metrics_submission_context_id` (`context_id`),
  KEY `metrics_submission_submission_id` (`submission_id`),
  KEY `metrics_submission_representation_id` (`representation_id`),
  KEY `metrics_submission_submission_file_id` (`submission_file_id`),
  KEY `ms_context_id_submission_id_assoc_type_file_type` (`context_id`,`submission_id`,`assoc_type`,`file_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Daily statistics for views and downloads of published submissions and galleys.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_submission_geo_daily`
--

CREATE TABLE `metrics_submission_geo_daily` (
  `metrics_submission_geo_daily_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `load_id` varchar(50) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `country` varchar(2) NOT NULL DEFAULT '',
  `region` varchar(3) NOT NULL DEFAULT '',
  `city` varchar(255) NOT NULL DEFAULT '',
  `date` date NOT NULL,
  `metric` int(11) NOT NULL,
  `metric_unique` int(11) NOT NULL,
  PRIMARY KEY (`metrics_submission_geo_daily_id`),
  UNIQUE KEY `msgd_uc_load_context_submission_c_r_c_date` (`load_id`,`context_id`,`submission_id`,`country`,`region`,`city`(80),`date`),
  KEY `msgd_load_id` (`load_id`),
  KEY `metrics_submission_geo_daily_context_id` (`context_id`),
  KEY `metrics_submission_geo_daily_submission_id` (`submission_id`),
  KEY `msgd_context_id_submission_id` (`context_id`,`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Daily statistics by country, region and city for views and downloads of published submissions and galleys.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_submission_geo_monthly`
--

CREATE TABLE `metrics_submission_geo_monthly` (
  `metrics_submission_geo_monthly_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `country` varchar(2) NOT NULL DEFAULT '',
  `region` varchar(3) NOT NULL DEFAULT '',
  `city` varchar(255) NOT NULL DEFAULT '',
  `month` int(11) NOT NULL,
  `metric` int(11) NOT NULL,
  `metric_unique` int(11) NOT NULL,
  PRIMARY KEY (`metrics_submission_geo_monthly_id`),
  UNIQUE KEY `msgm_uc_context_submission_c_r_c_month` (`context_id`,`submission_id`,`country`,`region`,`city`(80),`month`),
  KEY `metrics_submission_geo_monthly_context_id` (`context_id`),
  KEY `metrics_submission_geo_monthly_submission_id` (`submission_id`),
  KEY `msgm_context_id_submission_id` (`context_id`,`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Monthly statistics by country, region and city for views and downloads of published submissions and galleys.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `navigation_menus`
--

CREATE TABLE `navigation_menus` (
  `navigation_menu_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `area_name` varchar(255) DEFAULT '',
  `title` varchar(255) NOT NULL,
  PRIMARY KEY (`navigation_menu_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Navigation menus on the website are installed with the software as a default set, and can be customized.' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `navigation_menus`
--

INSERT INTO `navigation_menus` VALUES
(1, 0, 'user', 'User Navigation Menu');

-- --------------------------------------------------------

--
-- Table structure for table `navigation_menu_items`
--

CREATE TABLE `navigation_menu_items` (
  `navigation_menu_item_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `path` varchar(255) DEFAULT '',
  `type` varchar(255) DEFAULT '',
  PRIMARY KEY (`navigation_menu_item_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Navigation menu items are single elements within a navigation menu.' AUTO_INCREMENT=8 ;

--
-- Dumping data for table `navigation_menu_items`
--

INSERT INTO `navigation_menu_items` VALUES
(1, 0, NULL, 'NMI_TYPE_USER_REGISTER'),
(2, 0, NULL, 'NMI_TYPE_USER_LOGIN'),
(3, 0, NULL, 'NMI_TYPE_USER_DASHBOARD'),
(4, 0, NULL, 'NMI_TYPE_USER_DASHBOARD'),
(5, 0, NULL, 'NMI_TYPE_USER_PROFILE'),
(6, 0, NULL, 'NMI_TYPE_ADMINISTRATION'),
(7, 0, NULL, 'NMI_TYPE_USER_LOGOUT');

-- --------------------------------------------------------

--
-- Table structure for table `navigation_menu_item_assignments`
--

CREATE TABLE `navigation_menu_item_assignments` (
  `navigation_menu_item_assignment_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `navigation_menu_id` bigint(20) NOT NULL,
  `navigation_menu_item_id` bigint(20) NOT NULL,
  `parent_id` bigint(20) DEFAULT NULL,
  `seq` bigint(20) DEFAULT '0',
  PRIMARY KEY (`navigation_menu_item_assignment_id`),
  KEY `navigation_menu_item_assignments_navigation_menu_id` (`navigation_menu_id`),
  KEY `navigation_menu_item_assignments_navigation_menu_item_id` (`navigation_menu_item_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Links navigation menu items to navigation menus.' AUTO_INCREMENT=8 ;

--
-- Dumping data for table `navigation_menu_item_assignments`
--

INSERT INTO `navigation_menu_item_assignments` VALUES
(1, 1, 1, 0, 0),
(2, 1, 2, 0, 1),
(3, 1, 3, 0, 2),
(4, 1, 4, 3, 0),
(5, 1, 5, 3, 1),
(6, 1, 6, 3, 2),
(7, 1, 7, 3, 3);

-- --------------------------------------------------------

--
-- Table structure for table `navigation_menu_item_assignment_settings`
--

CREATE TABLE `navigation_menu_item_assignment_settings` (
  `navigation_menu_item_assignment_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `navigation_menu_item_assignment_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`navigation_menu_item_assignment_setting_id`),
  UNIQUE KEY `navigation_menu_item_assignment_settings_unique` (`navigation_menu_item_assignment_id`,`locale`,`setting_name`),
  KEY `navigation_menu_item_assignment_settings_n_m_i_a_id` (`navigation_menu_item_assignment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about navigation menu item assignments to navigation menus, including localized content.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `navigation_menu_item_settings`
--

CREATE TABLE `navigation_menu_item_settings` (
  `navigation_menu_item_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `navigation_menu_item_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` longtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`navigation_menu_item_setting_id`),
  UNIQUE KEY `navigation_menu_item_settings_unique` (`navigation_menu_item_id`,`locale`,`setting_name`),
  KEY `navigation_menu_item_settings_navigation_menu_item_id` (`navigation_menu_item_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='More data about navigation menu items, including localized content such as names.' AUTO_INCREMENT=8 ;

--
-- Dumping data for table `navigation_menu_item_settings`
--

INSERT INTO `navigation_menu_item_settings` VALUES
(1, 1, '', 'titleLocaleKey', 'navigation.register', 'string'),
(2, 2, '', 'titleLocaleKey', 'navigation.login', 'string'),
(3, 3, '', 'titleLocaleKey', '{$loggedInUsername}', 'string'),
(4, 4, '', 'titleLocaleKey', 'navigation.dashboard', 'string'),
(5, 5, '', 'titleLocaleKey', 'common.viewProfile', 'string'),
(6, 6, '', 'titleLocaleKey', 'navigation.admin', 'string'),
(7, 7, '', 'titleLocaleKey', 'user.logOut', 'string');

-- --------------------------------------------------------

--
-- Table structure for table `notes`
--

CREATE TABLE `notes` (
  `note_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `contents` text,
  PRIMARY KEY (`note_id`),
  KEY `notes_user_id` (`user_id`),
  KEY `notes_assoc` (`assoc_type`,`assoc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Notes allow users to annotate associated entities, such as submissions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `notifications`
--

CREATE TABLE `notifications` (
  `notification_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `level` bigint(20) NOT NULL,
  `type` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL,
  `date_read` datetime DEFAULT NULL,
  `assoc_type` bigint(20) DEFAULT NULL,
  `assoc_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`notification_id`),
  KEY `notifications_context_id` (`context_id`),
  KEY `notifications_user_id` (`user_id`),
  KEY `notifications_context_id_user_id` (`context_id`,`user_id`,`level`),
  KEY `notifications_context_id_level` (`context_id`,`level`),
  KEY `notifications_assoc` (`assoc_type`,`assoc_id`),
  KEY `notifications_user_id_level` (`user_id`,`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='User notifications created during certain operations.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `notification_settings`
--

CREATE TABLE `notification_settings` (
  `notification_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `notification_id` bigint(20) NOT NULL,
  `locale` varchar(14) DEFAULT NULL,
  `setting_name` varchar(64) NOT NULL,
  `setting_value` mediumtext NOT NULL,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  PRIMARY KEY (`notification_setting_id`),
  UNIQUE KEY `notification_settings_unique` (`notification_id`,`locale`,`setting_name`),
  KEY `notification_settings_notification_id` (`notification_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about notifications, including localized properties.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `notification_subscription_settings`
--

CREATE TABLE `notification_subscription_settings` (
  `setting_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `setting_name` varchar(64) NOT NULL,
  `setting_value` mediumtext NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `context` bigint(20) DEFAULT NULL,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  PRIMARY KEY (`setting_id`),
  KEY `notification_subscription_settings_user_id` (`user_id`),
  KEY `notification_subscription_settings_context` (`context`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Which email notifications a user has chosen to unsubscribe from.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oai_resumption_tokens`
--

CREATE TABLE `oai_resumption_tokens` (
  `oai_resumption_token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `token` varchar(32) NOT NULL,
  `expire` bigint(20) NOT NULL,
  `record_offset` int(11) NOT NULL,
  `params` text,
  PRIMARY KEY (`oai_resumption_token_id`),
  UNIQUE KEY `oai_resumption_tokens_unique` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='OAI resumption tokens are used to allow for pagination of large result sets into manageable pieces.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `plugin_settings`
--

CREATE TABLE `plugin_settings` (
  `plugin_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `plugin_name` varchar(80) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `setting_name` varchar(80) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  PRIMARY KEY (`plugin_setting_id`),
  UNIQUE KEY `plugin_settings_unique` (`plugin_name`,`context_id`,`setting_name`),
  KEY `plugin_settings_plugin_name` (`plugin_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='More data about plugins, including localized properties. This table is frequently used to store plugin-specific configuration.' AUTO_INCREMENT=10 ;

--
-- Dumping data for table `plugin_settings`
--

INSERT INTO `plugin_settings` VALUES
(1, 'acronplugin', 0, 'enabled', '1', 'bool'),
(2, 'acronplugin', 0, 'crontab', '[{"className":"PKP\\\\task\\\\ReviewReminder","frequency":{"hour":24},"args":[]},{"className":"PKP\\\\task\\\\StatisticsReport","frequency":{"day":"1"},"args":[]},{"className":"APP\\\\tasks\\\\SubscriptionExpiryReminder","frequency":{"day":"1"},"args":[]},{"className":"PKP\\\\task\\\\DepositDois","frequency":{"hour":24},"args":[]},{"className":"PKP\\\\task\\\\RemoveUnvalidatedExpiredUsers","frequency":{"day":"1"},"args":[]},{"className":"PKP\\\\task\\\\EditorialReminders","frequency":{"day":"1"},"args":[]},{"className":"PKP\\\\task\\\\UpdateIPGeoDB","frequency":{"day":"10"},"args":[]},{"className":"APP\\\\tasks\\\\UsageStatsLoader","frequency":{"hour":24},"args":[]},{"className":"PKP\\\\task\\\\ProcessQueueJobs","frequency":{"hour":24},"args":[]},{"className":"PKP\\\\task\\\\RemoveFailedJobs","frequency":{"day":"1"},"args":[]},{"className":"APP\\\\tasks\\\\OpenAccessNotification","frequency":{"hour":24},"args":[]}]', 'object'),
(3, 'defaultthemeplugin', 0, 'enabled', '1', 'bool'),
(4, 'tinymceplugin', 0, 'enabled', '1', 'bool'),
(5, 'usageeventplugin', 0, 'enabled', '1', 'bool'),
(6, 'developedbyblockplugin', 0, 'enabled', '0', 'bool'),
(7, 'developedbyblockplugin', 0, 'seq', '0', 'int'),
(8, 'languagetoggleblockplugin', 0, 'enabled', '1', 'bool'),
(9, 'languagetoggleblockplugin', 0, 'seq', '4', 'int');

-- --------------------------------------------------------

--
-- Table structure for table `publications`
--

CREATE TABLE `publications` (
  `publication_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `access_status` bigint(20) DEFAULT '0',
  `date_published` date DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `primary_contact_id` bigint(20) DEFAULT NULL,
  `section_id` bigint(20) DEFAULT NULL,
  `seq` double(8,2) NOT NULL DEFAULT '0.00',
  `submission_id` bigint(20) NOT NULL,
  `status` smallint(6) NOT NULL DEFAULT '1',
  `url_path` varchar(64) DEFAULT NULL,
  `version` bigint(20) DEFAULT NULL,
  `doi_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`publication_id`),
  KEY `publications_primary_contact_id` (`primary_contact_id`),
  KEY `publications_section_id` (`section_id`),
  KEY `publications_submission_id` (`submission_id`),
  KEY `publications_doi_id` (`doi_id`),
  KEY `publications_url_path` (`url_path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Each publication is one version of a submission.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `publication_categories`
--

CREATE TABLE `publication_categories` (
  `publication_category_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `publication_id` bigint(20) NOT NULL,
  `category_id` bigint(20) NOT NULL,
  PRIMARY KEY (`publication_category_id`),
  UNIQUE KEY `publication_categories_id` (`publication_id`,`category_id`),
  KEY `publication_categories_publication_id` (`publication_id`),
  KEY `publication_categories_category_id` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Associates publications (and thus submissions) with categories.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `publication_galleys`
--

CREATE TABLE `publication_galleys` (
  `galley_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `locale` varchar(14) DEFAULT NULL,
  `publication_id` bigint(20) NOT NULL,
  `label` varchar(255) DEFAULT NULL,
  `submission_file_id` bigint(20) unsigned DEFAULT NULL,
  `seq` double(8,2) NOT NULL DEFAULT '0.00',
  `remote_url` varchar(2047) DEFAULT NULL,
  `is_approved` smallint(6) NOT NULL DEFAULT '0',
  `url_path` varchar(64) DEFAULT NULL,
  `doi_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`galley_id`),
  KEY `publication_galleys_publication_id` (`publication_id`),
  KEY `publication_galleys_submission_file_id` (`submission_file_id`),
  KEY `publication_galleys_doi_id` (`doi_id`),
  KEY `publication_galleys_url_path` (`url_path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Publication galleys are representations of a publication in a specific format, e.g. a PDF.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `publication_galley_settings`
--

CREATE TABLE `publication_galley_settings` (
  `publication_galley_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `galley_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`publication_galley_setting_id`),
  UNIQUE KEY `publication_galley_settings_unique` (`galley_id`,`locale`,`setting_name`),
  KEY `publication_galley_settings_galley_id` (`galley_id`),
  KEY `publication_galley_settings_name_value` (`setting_name`(50),`setting_value`(150))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about publication galleys, including localized content such as labels.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `publication_settings`
--

CREATE TABLE `publication_settings` (
  `publication_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `publication_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`publication_setting_id`),
  UNIQUE KEY `publication_settings_unique` (`publication_id`,`locale`,`setting_name`),
  KEY `publication_settings_name_value` (`setting_name`(50),`setting_value`(150)),
  KEY `publication_settings_publication_id` (`publication_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about publications, including localized properties such as the title and abstract.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `queries`
--

CREATE TABLE `queries` (
  `query_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `stage_id` smallint(6) NOT NULL,
  `seq` double(8,2) NOT NULL DEFAULT '0.00',
  `date_posted` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `closed` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`query_id`),
  KEY `queries_assoc_id` (`assoc_type`,`assoc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Discussions, usually related to a submission, created by editors, authors and other editorial staff.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `query_participants`
--

CREATE TABLE `query_participants` (
  `query_participant_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `query_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  PRIMARY KEY (`query_participant_id`),
  UNIQUE KEY `query_participants_unique` (`query_id`,`user_id`),
  KEY `query_participants_query_id` (`query_id`),
  KEY `query_participants_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The users assigned to a discussion.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `queued_payments`
--

CREATE TABLE `queued_payments` (
  `queued_payment_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `date_created` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `expiry_date` date DEFAULT NULL,
  `payment_data` text,
  PRIMARY KEY (`queued_payment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Unfulfilled (queued) payments, i.e. payments that have not yet been completed via an online payment system.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_assignments`
--

CREATE TABLE `review_assignments` (
  `review_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `reviewer_id` bigint(20) NOT NULL,
  `competing_interests` text,
  `recommendation` smallint(6) DEFAULT NULL,
  `date_assigned` datetime DEFAULT NULL,
  `date_notified` datetime DEFAULT NULL,
  `date_confirmed` datetime DEFAULT NULL,
  `date_completed` datetime DEFAULT NULL,
  `date_acknowledged` datetime DEFAULT NULL,
  `date_due` datetime DEFAULT NULL,
  `date_response_due` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `reminder_was_automatic` smallint(6) NOT NULL DEFAULT '0',
  `declined` smallint(6) NOT NULL DEFAULT '0',
  `cancelled` smallint(6) NOT NULL DEFAULT '0',
  `date_rated` datetime DEFAULT NULL,
  `date_reminded` datetime DEFAULT NULL,
  `quality` smallint(6) DEFAULT NULL,
  `review_round_id` bigint(20) NOT NULL,
  `stage_id` smallint(6) NOT NULL,
  `review_method` smallint(6) NOT NULL DEFAULT '1',
  `round` smallint(6) NOT NULL DEFAULT '1',
  `step` smallint(6) NOT NULL DEFAULT '1',
  `review_form_id` bigint(20) DEFAULT NULL,
  `considered` smallint(6) DEFAULT NULL,
  `request_resent` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`review_id`),
  KEY `review_assignments_submission_id` (`submission_id`),
  KEY `review_assignments_reviewer_id` (`reviewer_id`),
  KEY `review_assignment_reviewer_round` (`review_round_id`,`reviewer_id`),
  KEY `review_assignments_form_id` (`review_form_id`),
  KEY `review_assignments_reviewer_review` (`reviewer_id`,`review_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data about peer review assignments for all submissions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_files`
--

CREATE TABLE `review_files` (
  `review_file_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `review_id` bigint(20) NOT NULL,
  `submission_file_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`review_file_id`),
  UNIQUE KEY `review_files_unique` (`review_id`,`submission_file_id`),
  KEY `review_files_review_id` (`review_id`),
  KEY `review_files_submission_file_id` (`submission_file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A list of the submission files made available to each assigned reviewer.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_forms`
--

CREATE TABLE `review_forms` (
  `review_form_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `seq` double(8,2) DEFAULT NULL,
  `is_active` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`review_form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Review forms provide custom templates for peer reviews with several types of questions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_form_elements`
--

CREATE TABLE `review_form_elements` (
  `review_form_element_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `review_form_id` bigint(20) NOT NULL,
  `seq` double(8,2) DEFAULT NULL,
  `element_type` bigint(20) DEFAULT NULL,
  `required` smallint(6) DEFAULT NULL,
  `included` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`review_form_element_id`),
  KEY `review_form_elements_review_form_id` (`review_form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Each review form element represents a single question on a review form.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_form_element_settings`
--

CREATE TABLE `review_form_element_settings` (
  `review_form_element_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `review_form_element_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`review_form_element_setting_id`),
  UNIQUE KEY `review_form_element_settings_unique` (`review_form_element_id`,`locale`,`setting_name`),
  KEY `review_form_element_settings_review_form_element_id` (`review_form_element_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about review form elements, including localized content such as question text.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_form_responses`
--

CREATE TABLE `review_form_responses` (
  `review_form_response_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `review_form_element_id` bigint(20) NOT NULL,
  `review_id` bigint(20) NOT NULL,
  `response_type` varchar(6) DEFAULT NULL,
  `response_value` text,
  PRIMARY KEY (`review_form_response_id`),
  KEY `review_form_responses_review_form_element_id` (`review_form_element_id`),
  KEY `review_form_responses_review_id` (`review_id`),
  KEY `review_form_responses_unique` (`review_form_element_id`,`review_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Each review form response records a reviewer''s answer to a review form element associated with a peer review.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_form_settings`
--

CREATE TABLE `review_form_settings` (
  `review_form_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `review_form_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`review_form_setting_id`),
  UNIQUE KEY `review_form_settings_unique` (`review_form_id`,`locale`,`setting_name`),
  KEY `review_form_settings_review_form_id` (`review_form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about review forms, including localized content such as names.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_rounds`
--

CREATE TABLE `review_rounds` (
  `review_round_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `stage_id` bigint(20) DEFAULT NULL,
  `round` smallint(6) NOT NULL,
  `review_revision` bigint(20) DEFAULT NULL,
  `status` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`review_round_id`),
  UNIQUE KEY `review_rounds_submission_id_stage_id_round_pkey` (`submission_id`,`stage_id`,`round`),
  KEY `review_rounds_submission_id` (`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Peer review assignments are organized into multiple rounds on a submission.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_round_files`
--

CREATE TABLE `review_round_files` (
  `review_round_file_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `review_round_id` bigint(20) NOT NULL,
  `stage_id` smallint(6) NOT NULL,
  `submission_file_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`review_round_file_id`),
  UNIQUE KEY `review_round_files_unique` (`submission_id`,`review_round_id`,`submission_file_id`),
  KEY `review_round_files_submission_id` (`submission_id`),
  KEY `review_round_files_review_round_id` (`review_round_id`),
  KEY `review_round_files_submission_file_id` (`submission_file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Records the files made available to reviewers for a round of reviews. These can be further customized on a per review basis with review_files.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `scheduled_tasks`
--

CREATE TABLE `scheduled_tasks` (
  `scheduled_task_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) NOT NULL,
  `last_run` datetime DEFAULT NULL,
  PRIMARY KEY (`scheduled_task_id`),
  UNIQUE KEY `scheduled_tasks_unique` (`class_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The last time each scheduled task was run.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sections`
--

CREATE TABLE `sections` (
  `section_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `journal_id` bigint(20) NOT NULL,
  `review_form_id` bigint(20) DEFAULT NULL,
  `seq` double(8,2) NOT NULL DEFAULT '0.00',
  `editor_restricted` smallint(6) NOT NULL DEFAULT '0',
  `meta_indexed` smallint(6) NOT NULL DEFAULT '0',
  `meta_reviewed` smallint(6) NOT NULL DEFAULT '1',
  `abstracts_not_required` smallint(6) NOT NULL DEFAULT '0',
  `hide_title` smallint(6) NOT NULL DEFAULT '0',
  `hide_author` smallint(6) NOT NULL DEFAULT '0',
  `is_inactive` smallint(6) NOT NULL DEFAULT '0',
  `abstract_word_count` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`section_id`),
  KEY `sections_journal_id` (`journal_id`),
  KEY `sections_review_form_id` (`review_form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A list of all sections into which submissions can be organized, forming the table of contents.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `section_settings`
--

CREATE TABLE `section_settings` (
  `section_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `section_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`section_setting_id`),
  UNIQUE KEY `section_settings_unique` (`section_id`,`locale`,`setting_name`),
  KEY `section_settings_section_id` (`section_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about sections, including localized properties like section titles.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sessions`
--

CREATE TABLE `sessions` (
  `session_id` varchar(128) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `ip_address` varchar(39) NOT NULL,
  `user_agent` varchar(255) DEFAULT NULL,
  `created` bigint(20) NOT NULL DEFAULT '0',
  `last_used` bigint(20) NOT NULL DEFAULT '0',
  `remember` smallint(6) NOT NULL DEFAULT '0',
  `data` text NOT NULL,
  `domain` varchar(255) DEFAULT NULL,
  UNIQUE KEY `sessions_pkey` (`session_id`),
  KEY `sessions_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Session data for logged-in users.';

-- --------------------------------------------------------

--
-- Table structure for table `site`
--

CREATE TABLE `site` (
  `site_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `redirect` bigint(20) NOT NULL DEFAULT '0' COMMENT 'If not 0, redirect to the specified journal/conference/... site.',
  `primary_locale` varchar(14) NOT NULL COMMENT 'Primary locale for the site.',
  `min_password_length` smallint(6) NOT NULL DEFAULT '6',
  `installed_locales` varchar(1024) NOT NULL DEFAULT 'en' COMMENT 'Locales for which support has been installed.',
  `supported_locales` varchar(1024) DEFAULT NULL COMMENT 'Locales supported by the site (for hosted journals/conferences/...).',
  `original_style_file_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`site_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='A singleton table describing basic information about the site.' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `site`
--

INSERT INTO `site` VALUES
(1, 0, '[[language]]', 6, '["de","es","fr_CA","it","nl","ru","en"]', '["de","es","fr_CA","it","nl","ru","en"]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `site_settings`
--

CREATE TABLE `site_settings` (
  `site_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `setting_name` varchar(255) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_value` mediumtext,
  PRIMARY KEY (`site_setting_id`),
  UNIQUE KEY `site_settings_unique` (`setting_name`,`locale`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='More data about the site, including localized properties such as its name.' AUTO_INCREMENT=17 ;

--
-- Dumping data for table `site_settings`
--

INSERT INTO `site_settings` VALUES
(1, 'contactEmail', '[[language]]', '[[admin_email]]'),
(2, 'contactName', 'de', 'Open Journal Systems'),
(3, 'contactName', 'es', 'Open Journal Systems'),
(4, 'contactName', 'fr_CA', 'Open Journal Systems'),
(5, 'contactName', 'it', 'Open Journal Systems'),
(6, 'contactName', 'nl', 'Open Journal Systems'),
(7, 'contactName', 'ru', 'Open Journal Systems'),
(8, 'contactName', 'en', 'Open Journal Systems'),
(9, 'compressStatsLogs', '', '0'),
(10, 'enableGeoUsageStats', '', 'disabled'),
(11, 'enableInstitutionUsageStats', '', '0'),
(12, 'keepDailyUsageStats', '', '0'),
(13, 'isSiteSushiPlatform', '', '0'),
(14, 'isSushiApiPublic', '', '1'),
(15, 'disableSharedReviewerStatistics', '', '0'),
(16, 'themePluginPath', '', 'default');

-- --------------------------------------------------------

--
-- Table structure for table `stage_assignments`
--

CREATE TABLE `stage_assignments` (
  `stage_assignment_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `user_group_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `date_assigned` datetime NOT NULL,
  `recommend_only` smallint(6) NOT NULL DEFAULT '0',
  `can_change_metadata` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`stage_assignment_id`),
  UNIQUE KEY `stage_assignment` (`submission_id`,`user_group_id`,`user_id`),
  KEY `stage_assignments_user_group_id` (`user_group_id`),
  KEY `stage_assignments_user_id` (`user_id`),
  KEY `stage_assignments_submission_id` (`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Who can access a submission while it is in the editorial workflow. Includes all editorial and author assignments. For reviewers, see review_assignments.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `static_pages`
--

CREATE TABLE `static_pages` (
  `static_page_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `path` varchar(255) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  PRIMARY KEY (`static_page_id`),
  KEY `static_pages_context_id` (`context_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `static_page_settings`
--

CREATE TABLE `static_page_settings` (
  `static_page_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `static_page_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` longtext,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  PRIMARY KEY (`static_page_setting_id`),
  KEY `static_page_settings_static_page_id` (`static_page_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `subeditor_submission_group`
--

CREATE TABLE `subeditor_submission_group` (
  `subeditor_submission_group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `assoc_type` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `user_group_id` bigint(20) NOT NULL,
  PRIMARY KEY (`subeditor_submission_group_id`),
  UNIQUE KEY `section_editors_unique` (`context_id`,`assoc_id`,`assoc_type`,`user_id`,`user_group_id`),
  KEY `subeditor_submission_group_context_id` (`context_id`),
  KEY `subeditor_submission_group_user_id` (`user_id`),
  KEY `subeditor_submission_group_user_group_id` (`user_group_id`),
  KEY `subeditor_submission_group_assoc_id` (`assoc_id`,`assoc_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Subeditor assignments to e.g. sections and categories' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `submissions`
--

CREATE TABLE `submissions` (
  `submission_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `current_publication_id` bigint(20) DEFAULT NULL,
  `date_last_activity` datetime DEFAULT NULL,
  `date_submitted` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `stage_id` bigint(20) NOT NULL DEFAULT '1',
  `locale` varchar(14) DEFAULT NULL,
  `status` smallint(6) NOT NULL DEFAULT '1',
  `submission_progress` varchar(50) NOT NULL DEFAULT 'start',
  `work_type` smallint(6) DEFAULT '0',
  PRIMARY KEY (`submission_id`),
  KEY `submissions_context_id` (`context_id`),
  KEY `submissions_publication_id` (`current_publication_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='All submissions submitted to the context, including incomplete, declined and unpublished submissions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `submission_comments`
--

CREATE TABLE `submission_comments` (
  `comment_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `comment_type` bigint(20) DEFAULT NULL,
  `role_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `author_id` bigint(20) NOT NULL,
  `comment_title` text NOT NULL,
  `comments` text,
  `date_posted` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `viewable` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`comment_id`),
  KEY `submission_comments_submission_id` (`submission_id`),
  KEY `submission_comments_author_id` (`author_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Comments on a submission, e.g. peer review comments' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `submission_files`
--

CREATE TABLE `submission_files` (
  `submission_file_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `file_id` bigint(20) unsigned NOT NULL,
  `source_submission_file_id` bigint(20) unsigned DEFAULT NULL,
  `genre_id` bigint(20) DEFAULT NULL,
  `file_stage` bigint(20) NOT NULL,
  `direct_sales_price` varchar(255) DEFAULT NULL,
  `sales_type` varchar(255) DEFAULT NULL,
  `viewable` smallint(6) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `uploader_user_id` bigint(20) DEFAULT NULL,
  `assoc_type` bigint(20) DEFAULT NULL,
  `assoc_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`submission_file_id`),
  KEY `submission_files_submission_id` (`submission_id`),
  KEY `submission_files_file_id` (`file_id`),
  KEY `submission_files_genre_id` (`genre_id`),
  KEY `submission_files_uploader_user_id` (`uploader_user_id`),
  KEY `submission_files_stage_assoc` (`file_stage`,`assoc_type`,`assoc_id`),
  KEY `submission_files_source_submission_file_id` (`source_submission_file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='All files associated with a submission, such as those uploaded during submission, as revisions, or by copyeditors or layout editors for production.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `submission_file_revisions`
--

CREATE TABLE `submission_file_revisions` (
  `revision_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_file_id` bigint(20) unsigned NOT NULL,
  `file_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`revision_id`),
  KEY `submission_file_revisions_submission_file_id` (`submission_file_id`),
  KEY `submission_file_revisions_file_id` (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revisions map submission_file entries to files on the data store.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `submission_file_settings`
--

CREATE TABLE `submission_file_settings` (
  `submission_file_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_file_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`submission_file_setting_id`),
  UNIQUE KEY `submission_file_settings_unique` (`submission_file_id`,`locale`,`setting_name`),
  KEY `submission_file_settings_submission_file_id` (`submission_file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Localized data about submission files like published metadata.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `submission_search_keyword_list`
--

CREATE TABLE `submission_search_keyword_list` (
  `keyword_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `keyword_text` varchar(60) NOT NULL,
  PRIMARY KEY (`keyword_id`),
  UNIQUE KEY `submission_search_keyword_text` (`keyword_text`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A list of all keywords used in the search index' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `submission_search_objects`
--

CREATE TABLE `submission_search_objects` (
  `object_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `type` int(11) NOT NULL COMMENT 'Type of item. E.g., abstract, fulltext, etc.',
  `assoc_id` bigint(20) DEFAULT NULL COMMENT 'Optional ID of an associated record (e.g., a file_id)',
  PRIMARY KEY (`object_id`),
  KEY `submission_search_objects_submission_id` (`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A list of all search objects indexed in the search index' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `submission_search_object_keywords`
--

CREATE TABLE `submission_search_object_keywords` (
  `submission_search_object_keyword_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `object_id` bigint(20) NOT NULL,
  `keyword_id` bigint(20) NOT NULL,
  `pos` int(11) NOT NULL COMMENT 'Word position of the keyword in the object.',
  PRIMARY KEY (`submission_search_object_keyword_id`),
  UNIQUE KEY `submission_search_object_keywords_unique` (`object_id`,`pos`),
  KEY `submission_search_object_keywords_object_id` (`object_id`),
  KEY `submission_search_object_keywords_keyword_id` (`keyword_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Relationships between search objects and keywords in the search index' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `submission_settings`
--

CREATE TABLE `submission_settings` (
  `submission_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`submission_setting_id`),
  UNIQUE KEY `submission_settings_unique` (`submission_id`,`locale`,`setting_name`),
  KEY `submission_settings_submission_id` (`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Localized data about submissions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `subscriptions`
--

CREATE TABLE `subscriptions` (
  `subscription_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `journal_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `type_id` bigint(20) NOT NULL,
  `date_start` date DEFAULT NULL,
  `date_end` datetime DEFAULT NULL,
  `status` smallint(6) NOT NULL DEFAULT '1',
  `membership` varchar(40) DEFAULT NULL,
  `reference_number` varchar(40) DEFAULT NULL,
  `notes` text,
  PRIMARY KEY (`subscription_id`),
  KEY `subscriptions_journal_id` (`journal_id`),
  KEY `subscriptions_user_id` (`user_id`),
  KEY `subscriptions_type_id` (`type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A list of subscriptions, both institutional and individual, for journals that use subscription-based publishing.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `subscription_types`
--

CREATE TABLE `subscription_types` (
  `type_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `journal_id` bigint(20) NOT NULL,
  `cost` double(8,2) NOT NULL,
  `currency_code_alpha` varchar(3) NOT NULL,
  `duration` smallint(6) DEFAULT NULL,
  `format` smallint(6) NOT NULL,
  `institutional` smallint(6) NOT NULL DEFAULT '0',
  `membership` smallint(6) NOT NULL DEFAULT '0',
  `disable_public_display` smallint(6) NOT NULL,
  `seq` double(8,2) NOT NULL,
  PRIMARY KEY (`type_id`),
  KEY `subscription_types_journal_id` (`journal_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Subscription types represent the kinds of subscriptions that a user or institution may have, such as an annual subscription or a discounted subscription.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `subscription_type_settings`
--

CREATE TABLE `subscription_type_settings` (
  `subscription_type_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`subscription_type_setting_id`),
  UNIQUE KEY `subscription_type_settings_unique` (`type_id`,`locale`,`setting_name`),
  KEY `subscription_type_settings_type_id` (`type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about subscription types, including localized properties such as names.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `temporary_files`
--

CREATE TABLE `temporary_files` (
  `file_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `file_name` varchar(90) NOT NULL,
  `file_type` varchar(255) DEFAULT NULL,
  `file_size` bigint(20) NOT NULL,
  `original_file_name` varchar(127) DEFAULT NULL,
  `date_uploaded` datetime NOT NULL,
  PRIMARY KEY (`file_id`),
  KEY `temporary_files_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Temporary files, e.g. where files are kept during an upload process before they are moved somewhere more appropriate.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `usage_stats_institution_temporary_records`
--

CREATE TABLE `usage_stats_institution_temporary_records` (
  `usage_stats_temp_institution_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `load_id` varchar(50) NOT NULL,
  `line_number` bigint(20) NOT NULL,
  `institution_id` bigint(20) NOT NULL,
  PRIMARY KEY (`usage_stats_temp_institution_id`),
  UNIQUE KEY `usitr_load_id_line_number_institution_id` (`load_id`,`line_number`,`institution_id`),
  KEY `usi_institution_id` (`institution_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Temporary stats for views and downloads from institutions based on visitor log records. Data in this table is provisional. See the metrics_* tables for compiled stats.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `usage_stats_total_temporary_records`
--

CREATE TABLE `usage_stats_total_temporary_records` (
  `usage_stats_temp_total_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL,
  `ip` varchar(64) NOT NULL,
  `user_agent` varchar(255) NOT NULL,
  `line_number` bigint(20) NOT NULL,
  `canonical_url` varchar(255) NOT NULL,
  `issue_id` bigint(20) DEFAULT NULL,
  `issue_galley_id` bigint(20) DEFAULT NULL,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) DEFAULT NULL,
  `representation_id` bigint(20) DEFAULT NULL,
  `submission_file_id` bigint(20) unsigned DEFAULT NULL,
  `assoc_type` bigint(20) NOT NULL,
  `file_type` smallint(6) DEFAULT NULL,
  `country` varchar(2) NOT NULL DEFAULT '',
  `region` varchar(3) NOT NULL DEFAULT '',
  `city` varchar(255) NOT NULL DEFAULT '',
  `load_id` varchar(50) NOT NULL,
  PRIMARY KEY (`usage_stats_temp_total_id`),
  KEY `usage_stats_total_temporary_records_issue_id` (`issue_id`),
  KEY `usage_stats_total_temporary_records_issue_galley_id` (`issue_galley_id`),
  KEY `usage_stats_total_temporary_records_context_id` (`context_id`),
  KEY `usage_stats_total_temporary_records_submission_id` (`submission_id`),
  KEY `usage_stats_total_temporary_records_representation_id` (`representation_id`),
  KEY `usage_stats_total_temporary_records_submission_file_id` (`submission_file_id`),
  KEY `ust_load_id_context_id_ip_ua_url` (`load_id`,`context_id`,`ip`,`user_agent`,`canonical_url`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Temporary stats totals based on visitor log records. Data in this table is provisional. See the metrics_* tables for compiled stats.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `usage_stats_unique_item_investigations_temporary_records`
--

CREATE TABLE `usage_stats_unique_item_investigations_temporary_records` (
  `usage_stats_temp_unique_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL,
  `ip` varchar(64) NOT NULL,
  `user_agent` varchar(255) NOT NULL,
  `line_number` bigint(20) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `representation_id` bigint(20) DEFAULT NULL,
  `submission_file_id` bigint(20) unsigned DEFAULT NULL,
  `assoc_type` bigint(20) NOT NULL,
  `file_type` smallint(6) DEFAULT NULL,
  `country` varchar(2) NOT NULL DEFAULT '',
  `region` varchar(3) NOT NULL DEFAULT '',
  `city` varchar(255) NOT NULL DEFAULT '',
  `load_id` varchar(50) NOT NULL,
  PRIMARY KEY (`usage_stats_temp_unique_item_id`),
  KEY `usii_context_id` (`context_id`),
  KEY `usii_submission_id` (`submission_id`),
  KEY `usii_representation_id` (`representation_id`),
  KEY `usii_submission_file_id` (`submission_file_id`),
  KEY `usii_load_id_context_id_ip_ua` (`load_id`,`context_id`,`ip`,`user_agent`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Temporary stats on unique downloads based on visitor log records. Data in this table is provisional. See the metrics_* tables for compiled stats.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `usage_stats_unique_item_requests_temporary_records`
--

CREATE TABLE `usage_stats_unique_item_requests_temporary_records` (
  `usage_stats_temp_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL,
  `ip` varchar(64) NOT NULL,
  `user_agent` varchar(255) NOT NULL,
  `line_number` bigint(20) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `representation_id` bigint(20) DEFAULT NULL,
  `submission_file_id` bigint(20) unsigned DEFAULT NULL,
  `assoc_type` bigint(20) NOT NULL,
  `file_type` smallint(6) DEFAULT NULL,
  `country` varchar(2) NOT NULL DEFAULT '',
  `region` varchar(3) NOT NULL DEFAULT '',
  `city` varchar(255) NOT NULL DEFAULT '',
  `load_id` varchar(50) NOT NULL,
  PRIMARY KEY (`usage_stats_temp_item_id`),
  KEY `usir_context_id` (`context_id`),
  KEY `usir_submission_id` (`submission_id`),
  KEY `usir_representation_id` (`representation_id`),
  KEY `usir_submission_file_id` (`submission_file_id`),
  KEY `usir_load_id_context_id_ip_ua` (`load_id`,`context_id`,`ip`,`user_agent`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Temporary stats on unique views based on visitor log records. Data in this table is provisional. See the metrics_* tables for compiled stats.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `user_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `username` varchar(32) NOT NULL,
  `password` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `url` varchar(2047) DEFAULT NULL,
  `phone` varchar(32) DEFAULT NULL,
  `mailing_address` varchar(255) DEFAULT NULL,
  `billing_address` varchar(255) DEFAULT NULL,
  `country` varchar(90) DEFAULT NULL,
  `locales` varchar(255) NOT NULL DEFAULT '[]',
  `gossip` text,
  `date_last_email` datetime DEFAULT NULL,
  `date_registered` datetime NOT NULL,
  `date_validated` datetime DEFAULT NULL,
  `date_last_login` datetime DEFAULT NULL,
  `must_change_password` smallint(6) DEFAULT NULL,
  `auth_id` bigint(20) DEFAULT NULL,
  `auth_str` varchar(255) DEFAULT NULL,
  `disabled` smallint(6) NOT NULL DEFAULT '0',
  `disabled_reason` text,
  `inline_help` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `users_username` (`username`),
  UNIQUE KEY `users_email` (`email`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='All registered users, including authentication data and profile data.' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `users`
--

INSERT INTO `users` VALUES
(1, '[[admin_username]]', '[[admin_pass]]', '[[admin_email]]', NULL, NULL, NULL, NULL, NULL, '[]', NULL, NULL, '[[regtime]]', NULL, NULL, NULL, NULL, NULL, 0, NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `user_groups`
--

CREATE TABLE `user_groups` (
  `user_group_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `role_id` bigint(20) NOT NULL,
  `is_default` smallint(6) NOT NULL DEFAULT '0',
  `show_title` smallint(6) NOT NULL DEFAULT '1',
  `permit_self_registration` smallint(6) NOT NULL DEFAULT '0',
  `permit_metadata_edit` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_group_id`),
  KEY `user_groups_user_group_id` (`user_group_id`),
  KEY `user_groups_context_id` (`context_id`),
  KEY `user_groups_role_id` (`role_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='All defined user roles in a context, such as Author, Reviewer, Section Editor and Journal Manager.' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `user_groups`
--

INSERT INTO `user_groups` VALUES
(1, 0, 1, 1, 1, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `user_group_settings`
--

CREATE TABLE `user_group_settings` (
  `user_group_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_group_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`user_group_setting_id`),
  UNIQUE KEY `user_group_settings_unique` (`user_group_id`,`locale`,`setting_name`),
  KEY `user_group_settings_user_group_id` (`user_group_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='More data about user groups, including localized properties such as the name.' AUTO_INCREMENT=8 ;

--
-- Dumping data for table `user_group_settings`
--

INSERT INTO `user_group_settings` VALUES
(1, 1, 'de', 'name', 'Website-Administrator/in'),
(2, 1, 'es', 'name', 'Administrador/a del sitio'),
(3, 1, 'fr_CA', 'name', 'Administrateur-trice du site'),
(4, 1, 'it', 'name', 'Amministratore'),
(5, 1, 'nl', 'name', 'Website beheerder'),
(6, 1, 'ru', 'name', 'Администратор сайта'),
(7, 1, 'en', 'name', 'Site Admin');

-- --------------------------------------------------------

--
-- Table structure for table `user_group_stage`
--

CREATE TABLE `user_group_stage` (
  `user_group_stage_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `user_group_id` bigint(20) NOT NULL,
  `stage_id` bigint(20) NOT NULL,
  PRIMARY KEY (`user_group_stage_id`),
  UNIQUE KEY `user_group_stage_unique` (`context_id`,`user_group_id`,`stage_id`),
  KEY `user_group_stage_context_id` (`context_id`),
  KEY `user_group_stage_user_group_id` (`user_group_id`),
  KEY `user_group_stage_stage_id` (`stage_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Which stages of the editorial workflow the user_groups can access.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_interests`
--

CREATE TABLE `user_interests` (
  `user_interest_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `controlled_vocab_entry_id` bigint(20) NOT NULL,
  PRIMARY KEY (`user_interest_id`),
  UNIQUE KEY `u_e_pkey` (`user_id`,`controlled_vocab_entry_id`),
  KEY `user_interests_user_id` (`user_id`),
  KEY `user_interests_controlled_vocab_entry_id` (`controlled_vocab_entry_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Associates users with user interests (which are stored in the controlled vocabulary tables).' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_settings`
--

CREATE TABLE `user_settings` (
  `user_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`user_setting_id`),
  UNIQUE KEY `user_settings_unique` (`user_id`,`locale`,`setting_name`),
  KEY `user_settings_user_id` (`user_id`),
  KEY `user_settings_locale_setting_name_index` (`setting_name`,`locale`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='More data about users, including localized properties like their name and affiliation.' AUTO_INCREMENT=3 ;

--
-- Dumping data for table `user_settings`
--

INSERT INTO `user_settings` VALUES
(1, 1, '[[language]]', 'familyName', '[[admin_username]]'),
(2, 1, '[[language]]', 'givenName', '[[admin_username]]');

-- --------------------------------------------------------

--
-- Table structure for table `user_user_groups`
--

CREATE TABLE `user_user_groups` (
  `user_user_group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_group_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  PRIMARY KEY (`user_user_group_id`),
  UNIQUE KEY `user_user_groups_unique` (`user_group_id`,`user_id`),
  KEY `user_user_groups_user_group_id` (`user_group_id`),
  KEY `user_user_groups_user_id` (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Maps users to their assigned user_groups.' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `user_user_groups`
--

INSERT INTO `user_user_groups` VALUES
(1, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `versions`
--

CREATE TABLE `versions` (
  `version_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `major` int(11) NOT NULL DEFAULT '0' COMMENT 'Major component of version number, e.g. the 2 in OJS 2.3.8-0',
  `minor` int(11) NOT NULL DEFAULT '0' COMMENT 'Minor component of version number, e.g. the 3 in OJS 2.3.8-0',
  `revision` int(11) NOT NULL DEFAULT '0' COMMENT 'Revision component of version number, e.g. the 8 in OJS 2.3.8-0',
  `build` int(11) NOT NULL DEFAULT '0' COMMENT 'Build component of version number, e.g. the 0 in OJS 2.3.8-0',
  `date_installed` datetime NOT NULL,
  `current` smallint(6) NOT NULL DEFAULT '0' COMMENT '1 iff the version entry being described is currently active. This permits the table to store past installation history for forensic purposes.',
  `product_type` varchar(30) DEFAULT NULL COMMENT 'Describes the type of product this row describes, e.g. "plugins.generic" (for a generic plugin) or "core" for the application itself',
  `product` varchar(30) DEFAULT NULL COMMENT 'Uniquely identifies the product this version row describes, e.g. "ojs2" for OJS 2.x, "languageToggle" for the language toggle block plugin, etc.',
  `product_class_name` varchar(80) DEFAULT NULL COMMENT 'Specifies the class name associated with this product, for plugins, or the empty string where not applicable.',
  `lazy_load` smallint(6) NOT NULL DEFAULT '0' COMMENT '1 iff the row describes a lazy-load plugin; 0 otherwise',
  `sitewide` smallint(6) NOT NULL DEFAULT '0' COMMENT '1 iff the row describes a site-wide plugin; 0 otherwise',
  PRIMARY KEY (`version_id`),
  UNIQUE KEY `versions_unique` (`product_type`,`product`,`major`,`minor`,`revision`,`build`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Describes the installation and upgrade version history for the application and all installed plugins.' AUTO_INCREMENT=46 ;

--
-- Dumping data for table `versions`
--

INSERT INTO `versions` VALUES
(1, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.metadata', 'dc11', '', 0, 0),
(2, 1, 0, 1, 0, '[[regtime]]', 1, 'plugins.blocks', 'browse', 'BrowseBlockPlugin', 1, 0),
(3, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.blocks', 'developedBy', 'DevelopedByBlockPlugin', 1, 0),
(4, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.blocks', 'information', 'InformationBlockPlugin', 1, 0),
(5, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.blocks', 'languageToggle', 'LanguageToggleBlockPlugin', 1, 0),
(6, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.blocks', 'makeSubmission', 'MakeSubmissionBlockPlugin', 1, 0),
(7, 1, 1, 0, 0, '[[regtime]]', 1, 'plugins.blocks', 'subscription', 'SubscriptionBlockPlugin', 1, 0),
(8, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.gateways', 'resolver', '', 0, 0),
(9, 1, 3, 0, 0, '[[regtime]]', 1, 'plugins.generic', 'acron', 'AcronPlugin', 1, 1),
(10, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.generic', 'announcementFeed', 'AnnouncementFeedPlugin', 1, 0),
(11, 0, 1, 0, 0, '[[regtime]]', 1, 'plugins.generic', 'citationStyleLanguage', 'CitationStyleLanguagePlugin', 1, 0),
(12, 3, 0, 0, 0, '[[regtime]]', 1, 'plugins.generic', 'crossref', '', 0, 0),
(13, 1, 2, 0, 0, '[[regtime]]', 1, 'plugins.generic', 'customBlockManager', 'CustomBlockManagerPlugin', 1, 0),
(14, 2, 0, 0, 0, '[[regtime]]', 1, 'plugins.generic', 'datacite', '', 0, 0),
(15, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.generic', 'driver', 'DRIVERPlugin', 1, 0),
(16, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.generic', 'dublinCoreMeta', 'DublinCoreMetaPlugin', 1, 0),
(17, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.generic', 'googleAnalytics', 'GoogleAnalyticsPlugin', 1, 0),
(18, 1, 1, 0, 0, '[[regtime]]', 1, 'plugins.generic', 'googleScholar', 'GoogleScholarPlugin', 1, 0),
(19, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.generic', 'htmlArticleGalley', 'HtmlArticleGalleyPlugin', 1, 0),
(20, 1, 0, 1, 0, '[[regtime]]', 1, 'plugins.generic', 'lensGalley', 'LensGalleyPlugin', 1, 0),
(21, 1, 3, 4, 8, '[[regtime]]', 1, 'plugins.generic', 'orcidProfile', 'OrcidProfilePlugin', 1, 0),
(22, 1, 0, 1, 0, '[[regtime]]', 1, 'plugins.generic', 'pdfJsViewer', 'PdfJsViewerPlugin', 1, 0),
(23, 1, 0, 0, 1, '[[regtime]]', 1, 'plugins.generic', 'recommendByAuthor', 'RecommendByAuthorPlugin', 1, 1),
(24, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.generic', 'recommendBySimilarity', 'RecommendBySimilarityPlugin', 1, 1),
(25, 1, 2, 0, 0, '[[regtime]]', 1, 'plugins.generic', 'staticPages', 'StaticPagesPlugin', 1, 0),
(26, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.generic', 'tinymce', 'TinyMCEPlugin', 1, 0),
(27, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.generic', 'usageEvent', '', 0, 0),
(28, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.generic', 'webFeed', 'WebFeedPlugin', 1, 0),
(29, 1, 1, 0, 0, '[[regtime]]', 1, 'plugins.importexport', 'doaj', '', 0, 0),
(30, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.importexport', 'native', '', 0, 0),
(31, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.importexport', 'pubmed', '', 0, 0),
(32, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.importexport', 'users', '', 0, 0),
(33, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.oaiMetadataFormats', 'dc', '', 0, 0),
(34, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.oaiMetadataFormats', 'marc', '', 0, 0),
(35, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.oaiMetadataFormats', 'marcxml', '', 0, 0),
(36, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.oaiMetadataFormats', 'rfc1807', '', 0, 0),
(37, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.paymethod', 'manual', '', 0, 0),
(38, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.paymethod', 'paypal', '', 0, 0),
(39, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.pubIds', 'urn', 'URNPubIdPlugin', 1, 0),
(40, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.reports', 'articles', '', 0, 0),
(41, 1, 1, 0, 0, '[[regtime]]', 1, 'plugins.reports', 'counterReport', '', 0, 0),
(42, 2, 0, 1, 0, '[[regtime]]', 1, 'plugins.reports', 'reviewReport', '', 0, 0),
(43, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.reports', 'subscriptions', '', 0, 0),
(44, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.themes', 'default', 'DefaultThemePlugin', 1, 0),
(45, 3, 4, 0, 9, '[[regtime]]', 1, 'core', 'ojs2', '', 0, 1);

--
-- Constraints for dumped tables
--

--
-- Constraints for table `access_keys`
--
ALTER TABLE `access_keys`
  ADD CONSTRAINT `access_keys_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `announcements`
--
ALTER TABLE `announcements`
  ADD CONSTRAINT `announcements_type_id_foreign` FOREIGN KEY (`type_id`) REFERENCES `announcement_types` (`type_id`) ON DELETE SET NULL;

--
-- Constraints for table `announcement_settings`
--
ALTER TABLE `announcement_settings`
  ADD CONSTRAINT `announcement_settings_announcement_id_foreign` FOREIGN KEY (`announcement_id`) REFERENCES `announcements` (`announcement_id`) ON DELETE CASCADE;

--
-- Constraints for table `announcement_types`
--
ALTER TABLE `announcement_types`
  ADD CONSTRAINT `announcement_types_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE;

--
-- Constraints for table `announcement_type_settings`
--
ALTER TABLE `announcement_type_settings`
  ADD CONSTRAINT `announcement_type_settings_type_id_foreign` FOREIGN KEY (`type_id`) REFERENCES `announcement_types` (`type_id`) ON DELETE CASCADE;

--
-- Constraints for table `authors`
--
ALTER TABLE `authors`
  ADD CONSTRAINT `authors_publication_id_foreign` FOREIGN KEY (`publication_id`) REFERENCES `publications` (`publication_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `authors_user_group_id_foreign` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`user_group_id`) ON DELETE CASCADE;

--
-- Constraints for table `author_settings`
--
ALTER TABLE `author_settings`
  ADD CONSTRAINT `author_settings_author_id` FOREIGN KEY (`author_id`) REFERENCES `authors` (`author_id`) ON DELETE CASCADE;

--
-- Constraints for table `categories`
--
ALTER TABLE `categories`
  ADD CONSTRAINT `categories_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `categories_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `categories` (`category_id`) ON DELETE SET NULL;

--
-- Constraints for table `category_settings`
--
ALTER TABLE `category_settings`
  ADD CONSTRAINT `category_settings_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`category_id`) ON DELETE CASCADE;

--
-- Constraints for table `citations`
--
ALTER TABLE `citations`
  ADD CONSTRAINT `citations_publication` FOREIGN KEY (`publication_id`) REFERENCES `publications` (`publication_id`) ON DELETE CASCADE;

--
-- Constraints for table `citation_settings`
--
ALTER TABLE `citation_settings`
  ADD CONSTRAINT `citation_settings_citation_id` FOREIGN KEY (`citation_id`) REFERENCES `citations` (`citation_id`) ON DELETE CASCADE;

--
-- Constraints for table `completed_payments`
--
ALTER TABLE `completed_payments`
  ADD CONSTRAINT `completed_payments_context_id` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `completed_payments_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE SET NULL;

--
-- Constraints for table `controlled_vocab_entries`
--
ALTER TABLE `controlled_vocab_entries`
  ADD CONSTRAINT `controlled_vocab_entries_controlled_vocab_id_foreign` FOREIGN KEY (`controlled_vocab_id`) REFERENCES `controlled_vocabs` (`controlled_vocab_id`) ON DELETE CASCADE;

--
-- Constraints for table `controlled_vocab_entry_settings`
--
ALTER TABLE `controlled_vocab_entry_settings`
  ADD CONSTRAINT `c_v_e_s_entry_id` FOREIGN KEY (`controlled_vocab_entry_id`) REFERENCES `controlled_vocab_entries` (`controlled_vocab_entry_id`) ON DELETE CASCADE;

--
-- Constraints for table `custom_issue_orders`
--
ALTER TABLE `custom_issue_orders`
  ADD CONSTRAINT `custom_issue_orders_issue_id` FOREIGN KEY (`issue_id`) REFERENCES `issues` (`issue_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `custom_issue_orders_journal_id` FOREIGN KEY (`journal_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE;

--
-- Constraints for table `custom_section_orders`
--
ALTER TABLE `custom_section_orders`
  ADD CONSTRAINT `custom_section_orders_issue_id` FOREIGN KEY (`issue_id`) REFERENCES `issues` (`issue_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `custom_section_orders_section_id` FOREIGN KEY (`section_id`) REFERENCES `sections` (`section_id`) ON DELETE CASCADE;

--
-- Constraints for table `data_object_tombstone_oai_set_objects`
--
ALTER TABLE `data_object_tombstone_oai_set_objects`
  ADD CONSTRAINT `data_object_tombstone_oai_set_objects_tombstone_id` FOREIGN KEY (`tombstone_id`) REFERENCES `data_object_tombstones` (`tombstone_id`) ON DELETE CASCADE;

--
-- Constraints for table `data_object_tombstone_settings`
--
ALTER TABLE `data_object_tombstone_settings`
  ADD CONSTRAINT `data_object_tombstone_settings_tombstone_id` FOREIGN KEY (`tombstone_id`) REFERENCES `data_object_tombstones` (`tombstone_id`) ON DELETE CASCADE;

--
-- Constraints for table `dois`
--
ALTER TABLE `dois`
  ADD CONSTRAINT `dois_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE;

--
-- Constraints for table `doi_settings`
--
ALTER TABLE `doi_settings`
  ADD CONSTRAINT `doi_settings_doi_id_foreign` FOREIGN KEY (`doi_id`) REFERENCES `dois` (`doi_id`) ON DELETE CASCADE;

--
-- Constraints for table `edit_decisions`
--
ALTER TABLE `edit_decisions`
  ADD CONSTRAINT `edit_decisions_editor_id` FOREIGN KEY (`editor_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `edit_decisions_review_round_id_foreign` FOREIGN KEY (`review_round_id`) REFERENCES `review_rounds` (`review_round_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `edit_decisions_submission_id` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `email_log_users`
--
ALTER TABLE `email_log_users`
  ADD CONSTRAINT `email_log_users_email_log_id_foreign` FOREIGN KEY (`email_log_id`) REFERENCES `email_log` (`log_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `email_log_users_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `email_templates`
--
ALTER TABLE `email_templates`
  ADD CONSTRAINT `email_templates_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE;

--
-- Constraints for table `email_templates_settings`
--
ALTER TABLE `email_templates_settings`
  ADD CONSTRAINT `email_templates_settings_email_id` FOREIGN KEY (`email_id`) REFERENCES `email_templates` (`email_id`) ON DELETE CASCADE;

--
-- Constraints for table `event_log`
--
ALTER TABLE `event_log`
  ADD CONSTRAINT `event_log_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `event_log_settings`
--
ALTER TABLE `event_log_settings`
  ADD CONSTRAINT `event_log_settings_log_id` FOREIGN KEY (`log_id`) REFERENCES `event_log` (`log_id`) ON DELETE CASCADE;

--
-- Constraints for table `filters`
--
ALTER TABLE `filters`
  ADD CONSTRAINT `filters_filter_group_id_foreign` FOREIGN KEY (`filter_group_id`) REFERENCES `filter_groups` (`filter_group_id`) ON DELETE CASCADE;

--
-- Constraints for table `filter_settings`
--
ALTER TABLE `filter_settings`
  ADD CONSTRAINT `filter_settings_filter_id_foreign` FOREIGN KEY (`filter_id`) REFERENCES `filters` (`filter_id`) ON DELETE CASCADE;

--
-- Constraints for table `genres`
--
ALTER TABLE `genres`
  ADD CONSTRAINT `genres_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE;

--
-- Constraints for table `genre_settings`
--
ALTER TABLE `genre_settings`
  ADD CONSTRAINT `genre_settings_genre_id_foreign` FOREIGN KEY (`genre_id`) REFERENCES `genres` (`genre_id`) ON DELETE CASCADE;

--
-- Constraints for table `institutional_subscriptions`
--
ALTER TABLE `institutional_subscriptions`
  ADD CONSTRAINT `institutional_subscriptions_institution_id_foreign` FOREIGN KEY (`institution_id`) REFERENCES `institutions` (`institution_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `institutional_subscriptions_subscription_id` FOREIGN KEY (`subscription_id`) REFERENCES `subscriptions` (`subscription_id`) ON DELETE CASCADE;

--
-- Constraints for table `institutions`
--
ALTER TABLE `institutions`
  ADD CONSTRAINT `institutions_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE;

--
-- Constraints for table `institution_ip`
--
ALTER TABLE `institution_ip`
  ADD CONSTRAINT `institution_ip_institution_id_foreign` FOREIGN KEY (`institution_id`) REFERENCES `institutions` (`institution_id`) ON DELETE CASCADE;

--
-- Constraints for table `institution_settings`
--
ALTER TABLE `institution_settings`
  ADD CONSTRAINT `institution_settings_institution_id_foreign` FOREIGN KEY (`institution_id`) REFERENCES `institutions` (`institution_id`) ON DELETE CASCADE;

--
-- Constraints for table `issues`
--
ALTER TABLE `issues`
  ADD CONSTRAINT `issues_doi_id_foreign` FOREIGN KEY (`doi_id`) REFERENCES `dois` (`doi_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `issues_journal_id` FOREIGN KEY (`journal_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE;

--
-- Constraints for table `issue_files`
--
ALTER TABLE `issue_files`
  ADD CONSTRAINT `issue_files_issue_id` FOREIGN KEY (`issue_id`) REFERENCES `issues` (`issue_id`) ON DELETE CASCADE;

--
-- Constraints for table `issue_galleys`
--
ALTER TABLE `issue_galleys`
  ADD CONSTRAINT `issue_galleys_file_id` FOREIGN KEY (`file_id`) REFERENCES `issue_files` (`file_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `issue_galleys_issue_id` FOREIGN KEY (`issue_id`) REFERENCES `issues` (`issue_id`) ON DELETE CASCADE;

--
-- Constraints for table `issue_galley_settings`
--
ALTER TABLE `issue_galley_settings`
  ADD CONSTRAINT `issue_galleys_settings_galley_id` FOREIGN KEY (`galley_id`) REFERENCES `issue_galleys` (`galley_id`) ON DELETE CASCADE;

--
-- Constraints for table `issue_settings`
--
ALTER TABLE `issue_settings`
  ADD CONSTRAINT `issue_settings_issue_id` FOREIGN KEY (`issue_id`) REFERENCES `issues` (`issue_id`) ON DELETE CASCADE;

--
-- Constraints for table `journals`
--
ALTER TABLE `journals`
  ADD CONSTRAINT `journals_current_issue_id_foreign` FOREIGN KEY (`current_issue_id`) REFERENCES `issues` (`issue_id`) ON DELETE SET NULL;

--
-- Constraints for table `journal_settings`
--
ALTER TABLE `journal_settings`
  ADD CONSTRAINT `journal_settings_journal_id` FOREIGN KEY (`journal_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE;

--
-- Constraints for table `library_files`
--
ALTER TABLE `library_files`
  ADD CONSTRAINT `library_files_context_id` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `library_files_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `library_file_settings`
--
ALTER TABLE `library_file_settings`
  ADD CONSTRAINT `library_file_settings_file_id_foreign` FOREIGN KEY (`file_id`) REFERENCES `library_files` (`file_id`) ON DELETE CASCADE;

--
-- Constraints for table `metrics_context`
--
ALTER TABLE `metrics_context`
  ADD CONSTRAINT `metrics_context_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE;

--
-- Constraints for table `metrics_counter_submission_daily`
--
ALTER TABLE `metrics_counter_submission_daily`
  ADD CONSTRAINT `msd_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `msd_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `metrics_counter_submission_institution_daily`
--
ALTER TABLE `metrics_counter_submission_institution_daily`
  ADD CONSTRAINT `msid_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `msid_institution_id_foreign` FOREIGN KEY (`institution_id`) REFERENCES `institutions` (`institution_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `msid_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `metrics_counter_submission_institution_monthly`
--
ALTER TABLE `metrics_counter_submission_institution_monthly`
  ADD CONSTRAINT `msim_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `msim_institution_id_foreign` FOREIGN KEY (`institution_id`) REFERENCES `institutions` (`institution_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `msim_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `metrics_counter_submission_monthly`
--
ALTER TABLE `metrics_counter_submission_monthly`
  ADD CONSTRAINT `msm_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `msm_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `metrics_issue`
--
ALTER TABLE `metrics_issue`
  ADD CONSTRAINT `metrics_issue_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `metrics_issue_issue_galley_id_foreign` FOREIGN KEY (`issue_galley_id`) REFERENCES `issue_galleys` (`galley_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `metrics_issue_issue_id_foreign` FOREIGN KEY (`issue_id`) REFERENCES `issues` (`issue_id`) ON DELETE CASCADE;

--
-- Constraints for table `metrics_submission`
--
ALTER TABLE `metrics_submission`
  ADD CONSTRAINT `metrics_submission_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `metrics_submission_representation_id_foreign` FOREIGN KEY (`representation_id`) REFERENCES `publication_galleys` (`galley_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `metrics_submission_submission_file_id_foreign` FOREIGN KEY (`submission_file_id`) REFERENCES `submission_files` (`submission_file_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `metrics_submission_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `metrics_submission_geo_daily`
--
ALTER TABLE `metrics_submission_geo_daily`
  ADD CONSTRAINT `msgd_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `msgd_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `metrics_submission_geo_monthly`
--
ALTER TABLE `metrics_submission_geo_monthly`
  ADD CONSTRAINT `msgm_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `msgm_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `navigation_menu_item_assignments`
--
ALTER TABLE `navigation_menu_item_assignments`
  ADD CONSTRAINT `navigation_menu_item_assignments_navigation_menu_id_foreign` FOREIGN KEY (`navigation_menu_id`) REFERENCES `navigation_menus` (`navigation_menu_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `navigation_menu_item_assignments_navigation_menu_item_id_foreign` FOREIGN KEY (`navigation_menu_item_id`) REFERENCES `navigation_menu_items` (`navigation_menu_item_id`) ON DELETE CASCADE;

--
-- Constraints for table `navigation_menu_item_assignment_settings`
--
ALTER TABLE `navigation_menu_item_assignment_settings`
  ADD CONSTRAINT `assignment_settings_navigation_menu_item_assignment_id` FOREIGN KEY (`navigation_menu_item_assignment_id`) REFERENCES `navigation_menu_item_assignments` (`navigation_menu_item_assignment_id`) ON DELETE CASCADE;

--
-- Constraints for table `navigation_menu_item_settings`
--
ALTER TABLE `navigation_menu_item_settings`
  ADD CONSTRAINT `navigation_menu_item_settings_navigation_menu_id` FOREIGN KEY (`navigation_menu_item_id`) REFERENCES `navigation_menu_items` (`navigation_menu_item_id`) ON DELETE CASCADE;

--
-- Constraints for table `notes`
--
ALTER TABLE `notes`
  ADD CONSTRAINT `notes_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `notifications`
--
ALTER TABLE `notifications`
  ADD CONSTRAINT `notifications_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `notifications_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `notification_settings`
--
ALTER TABLE `notification_settings`
  ADD CONSTRAINT `notification_settings_notification_id_foreign` FOREIGN KEY (`notification_id`) REFERENCES `notifications` (`notification_id`) ON DELETE CASCADE;

--
-- Constraints for table `notification_subscription_settings`
--
ALTER TABLE `notification_subscription_settings`
  ADD CONSTRAINT `notification_subscription_settings_context_foreign` FOREIGN KEY (`context`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `notification_subscription_settings_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `publications`
--
ALTER TABLE `publications`
  ADD CONSTRAINT `publications_doi_id_foreign` FOREIGN KEY (`doi_id`) REFERENCES `dois` (`doi_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `publications_primary_contact_id` FOREIGN KEY (`primary_contact_id`) REFERENCES `authors` (`author_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `publications_section_id` FOREIGN KEY (`section_id`) REFERENCES `sections` (`section_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `publications_submission_id` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `publication_categories`
--
ALTER TABLE `publication_categories`
  ADD CONSTRAINT `publication_categories_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`category_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `publication_categories_publication_id_foreign` FOREIGN KEY (`publication_id`) REFERENCES `publications` (`publication_id`) ON DELETE CASCADE;

--
-- Constraints for table `publication_galleys`
--
ALTER TABLE `publication_galleys`
  ADD CONSTRAINT `publication_galleys_doi_id_foreign` FOREIGN KEY (`doi_id`) REFERENCES `dois` (`doi_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `publication_galleys_publication_id` FOREIGN KEY (`publication_id`) REFERENCES `publications` (`publication_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `publication_galleys_submission_file_id_foreign` FOREIGN KEY (`submission_file_id`) REFERENCES `submission_files` (`submission_file_id`);

--
-- Constraints for table `publication_galley_settings`
--
ALTER TABLE `publication_galley_settings`
  ADD CONSTRAINT `publication_galley_settings_galley_id` FOREIGN KEY (`galley_id`) REFERENCES `publication_galleys` (`galley_id`) ON DELETE CASCADE;

--
-- Constraints for table `publication_settings`
--
ALTER TABLE `publication_settings`
  ADD CONSTRAINT `publication_settings_publication_id` FOREIGN KEY (`publication_id`) REFERENCES `publications` (`publication_id`) ON DELETE CASCADE;

--
-- Constraints for table `query_participants`
--
ALTER TABLE `query_participants`
  ADD CONSTRAINT `query_participants_query_id_foreign` FOREIGN KEY (`query_id`) REFERENCES `queries` (`query_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `query_participants_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `review_assignments`
--
ALTER TABLE `review_assignments`
  ADD CONSTRAINT `review_assignments_review_form_id_foreign` FOREIGN KEY (`review_form_id`) REFERENCES `review_forms` (`review_form_id`),
  ADD CONSTRAINT `review_assignments_review_round_id_foreign` FOREIGN KEY (`review_round_id`) REFERENCES `review_rounds` (`review_round_id`),
  ADD CONSTRAINT `review_assignments_reviewer_id_foreign` FOREIGN KEY (`reviewer_id`) REFERENCES `users` (`user_id`),
  ADD CONSTRAINT `review_assignments_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`);

--
-- Constraints for table `review_files`
--
ALTER TABLE `review_files`
  ADD CONSTRAINT `review_files_review_id_foreign` FOREIGN KEY (`review_id`) REFERENCES `review_assignments` (`review_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `review_files_submission_file_id_foreign` FOREIGN KEY (`submission_file_id`) REFERENCES `submission_files` (`submission_file_id`) ON DELETE CASCADE;

--
-- Constraints for table `review_form_elements`
--
ALTER TABLE `review_form_elements`
  ADD CONSTRAINT `review_form_elements_review_form_id` FOREIGN KEY (`review_form_id`) REFERENCES `review_forms` (`review_form_id`) ON DELETE CASCADE;

--
-- Constraints for table `review_form_element_settings`
--
ALTER TABLE `review_form_element_settings`
  ADD CONSTRAINT `review_form_element_settings_review_form_element_id` FOREIGN KEY (`review_form_element_id`) REFERENCES `review_form_elements` (`review_form_element_id`) ON DELETE CASCADE;

--
-- Constraints for table `review_form_responses`
--
ALTER TABLE `review_form_responses`
  ADD CONSTRAINT `review_form_responses_review_form_element_id_foreign` FOREIGN KEY (`review_form_element_id`) REFERENCES `review_form_elements` (`review_form_element_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `review_form_responses_review_id_foreign` FOREIGN KEY (`review_id`) REFERENCES `review_assignments` (`review_id`) ON DELETE CASCADE;

--
-- Constraints for table `review_form_settings`
--
ALTER TABLE `review_form_settings`
  ADD CONSTRAINT `review_form_settings_review_form_id` FOREIGN KEY (`review_form_id`) REFERENCES `review_forms` (`review_form_id`) ON DELETE CASCADE;

--
-- Constraints for table `review_rounds`
--
ALTER TABLE `review_rounds`
  ADD CONSTRAINT `review_rounds_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`);

--
-- Constraints for table `review_round_files`
--
ALTER TABLE `review_round_files`
  ADD CONSTRAINT `review_round_files_review_round_id_foreign` FOREIGN KEY (`review_round_id`) REFERENCES `review_rounds` (`review_round_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `review_round_files_submission_file_id_foreign` FOREIGN KEY (`submission_file_id`) REFERENCES `submission_files` (`submission_file_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `review_round_files_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `sections`
--
ALTER TABLE `sections`
  ADD CONSTRAINT `sections_journal_id` FOREIGN KEY (`journal_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `sections_review_form_id` FOREIGN KEY (`review_form_id`) REFERENCES `review_forms` (`review_form_id`) ON DELETE SET NULL;

--
-- Constraints for table `section_settings`
--
ALTER TABLE `section_settings`
  ADD CONSTRAINT `section_settings_section_id` FOREIGN KEY (`section_id`) REFERENCES `sections` (`section_id`) ON DELETE CASCADE;

--
-- Constraints for table `sessions`
--
ALTER TABLE `sessions`
  ADD CONSTRAINT `sessions_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `stage_assignments`
--
ALTER TABLE `stage_assignments`
  ADD CONSTRAINT `stage_assignments_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `stage_assignments_user_group_id` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`user_group_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `stage_assignments_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `static_pages`
--
ALTER TABLE `static_pages`
  ADD CONSTRAINT `static_pages_context_id` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE;

--
-- Constraints for table `static_page_settings`
--
ALTER TABLE `static_page_settings`
  ADD CONSTRAINT `static_page_settings_static_page_id` FOREIGN KEY (`static_page_id`) REFERENCES `static_pages` (`static_page_id`) ON DELETE CASCADE;

--
-- Constraints for table `subeditor_submission_group`
--
ALTER TABLE `subeditor_submission_group`
  ADD CONSTRAINT `section_editors_context_id` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `subeditor_submission_group_user_group_id_foreign` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`user_group_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `subeditor_submission_group_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `submissions`
--
ALTER TABLE `submissions`
  ADD CONSTRAINT `submissions_context_id` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `submissions_publication_id` FOREIGN KEY (`current_publication_id`) REFERENCES `publications` (`publication_id`) ON DELETE SET NULL;

--
-- Constraints for table `submission_comments`
--
ALTER TABLE `submission_comments`
  ADD CONSTRAINT `submission_comments_author_id_foreign` FOREIGN KEY (`author_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `submission_comments_submission_id` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `submission_files`
--
ALTER TABLE `submission_files`
  ADD CONSTRAINT `submission_files_file_id_foreign` FOREIGN KEY (`file_id`) REFERENCES `files` (`file_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `submission_files_genre_id_foreign` FOREIGN KEY (`genre_id`) REFERENCES `genres` (`genre_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `submission_files_source_submission_file_id_foreign` FOREIGN KEY (`source_submission_file_id`) REFERENCES `submission_files` (`submission_file_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `submission_files_submission_id` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `submission_files_uploader_user_id_foreign` FOREIGN KEY (`uploader_user_id`) REFERENCES `users` (`user_id`) ON DELETE SET NULL;

--
-- Constraints for table `submission_file_revisions`
--
ALTER TABLE `submission_file_revisions`
  ADD CONSTRAINT `submission_file_revisions_file_id_foreign` FOREIGN KEY (`file_id`) REFERENCES `files` (`file_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `submission_file_revisions_submission_file_id_foreign` FOREIGN KEY (`submission_file_id`) REFERENCES `submission_files` (`submission_file_id`) ON DELETE CASCADE;

--
-- Constraints for table `submission_file_settings`
--
ALTER TABLE `submission_file_settings`
  ADD CONSTRAINT `submission_file_settings_submission_file_id_foreign` FOREIGN KEY (`submission_file_id`) REFERENCES `submission_files` (`submission_file_id`) ON DELETE CASCADE;

--
-- Constraints for table `submission_search_objects`
--
ALTER TABLE `submission_search_objects`
  ADD CONSTRAINT `submission_search_object_submission` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `submission_search_object_keywords`
--
ALTER TABLE `submission_search_object_keywords`
  ADD CONSTRAINT `submission_search_object_keywords_keyword_id` FOREIGN KEY (`keyword_id`) REFERENCES `submission_search_keyword_list` (`keyword_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `submission_search_object_keywords_object_id_foreign` FOREIGN KEY (`object_id`) REFERENCES `submission_search_objects` (`object_id`) ON DELETE CASCADE;

--
-- Constraints for table `submission_settings`
--
ALTER TABLE `submission_settings`
  ADD CONSTRAINT `submission_settings_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `subscriptions`
--
ALTER TABLE `subscriptions`
  ADD CONSTRAINT `subscriptions_journal_id` FOREIGN KEY (`journal_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `subscriptions_type_id` FOREIGN KEY (`type_id`) REFERENCES `subscription_types` (`type_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `subscriptions_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `subscription_types`
--
ALTER TABLE `subscription_types`
  ADD CONSTRAINT `subscription_types_journal_id` FOREIGN KEY (`journal_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE;

--
-- Constraints for table `subscription_type_settings`
--
ALTER TABLE `subscription_type_settings`
  ADD CONSTRAINT `subscription_type_settings_type_id` FOREIGN KEY (`type_id`) REFERENCES `subscription_types` (`type_id`) ON DELETE CASCADE;

--
-- Constraints for table `temporary_files`
--
ALTER TABLE `temporary_files`
  ADD CONSTRAINT `temporary_files_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `usage_stats_institution_temporary_records`
--
ALTER TABLE `usage_stats_institution_temporary_records`
  ADD CONSTRAINT `usi_institution_id_foreign` FOREIGN KEY (`institution_id`) REFERENCES `institutions` (`institution_id`) ON DELETE CASCADE;

--
-- Constraints for table `usage_stats_total_temporary_records`
--
ALTER TABLE `usage_stats_total_temporary_records`
  ADD CONSTRAINT `ust_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `ust_issue_galley_id_foreign` FOREIGN KEY (`issue_galley_id`) REFERENCES `issue_galleys` (`galley_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `ust_issue_id_foreign` FOREIGN KEY (`issue_id`) REFERENCES `issues` (`issue_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `ust_representation_id_foreign` FOREIGN KEY (`representation_id`) REFERENCES `publication_galleys` (`galley_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `ust_submission_file_id_foreign` FOREIGN KEY (`submission_file_id`) REFERENCES `submission_files` (`submission_file_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `ust_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `usage_stats_unique_item_investigations_temporary_records`
--
ALTER TABLE `usage_stats_unique_item_investigations_temporary_records`
  ADD CONSTRAINT `usii_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `usii_representation_id_foreign` FOREIGN KEY (`representation_id`) REFERENCES `publication_galleys` (`galley_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `usii_submission_file_id_foreign` FOREIGN KEY (`submission_file_id`) REFERENCES `submission_files` (`submission_file_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `usii_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `usage_stats_unique_item_requests_temporary_records`
--
ALTER TABLE `usage_stats_unique_item_requests_temporary_records`
  ADD CONSTRAINT `usir_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `usir_representation_id_foreign` FOREIGN KEY (`representation_id`) REFERENCES `publication_galleys` (`galley_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `usir_submission_file_id_foreign` FOREIGN KEY (`submission_file_id`) REFERENCES `submission_files` (`submission_file_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `usir_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `user_group_settings`
--
ALTER TABLE `user_group_settings`
  ADD CONSTRAINT `user_group_settings_user_group_id_foreign` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`user_group_id`) ON DELETE CASCADE;

--
-- Constraints for table `user_group_stage`
--
ALTER TABLE `user_group_stage`
  ADD CONSTRAINT `user_group_stage_context_id` FOREIGN KEY (`context_id`) REFERENCES `journals` (`journal_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `user_group_stage_user_group_id` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`user_group_id`) ON DELETE CASCADE;

--
-- Constraints for table `user_interests`
--
ALTER TABLE `user_interests`
  ADD CONSTRAINT `user_interests_controlled_vocab_entry_id_foreign` FOREIGN KEY (`controlled_vocab_entry_id`) REFERENCES `controlled_vocab_entries` (`controlled_vocab_entry_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `user_interests_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `user_settings`
--
ALTER TABLE `user_settings`
  ADD CONSTRAINT `user_settings_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `user_user_groups`
--
ALTER TABLE `user_user_groups`
  ADD CONSTRAINT `user_user_groups_user_group_id_foreign` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`user_group_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `user_user_groups_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
