SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `ojs3501`
--


-- --------------------------------------------------------

--
-- Table structure for table `announcements`
--

CREATE TABLE `announcements` (
  `announcement_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` smallint(6) DEFAULT NULL,
  `assoc_id` bigint(20) DEFAULT NULL,
  `type_id` bigint(20) DEFAULT NULL,
  `date_expire` date DEFAULT NULL,
  `date_posted` datetime NOT NULL,
  PRIMARY KEY (`announcement_id`),
  KEY `announcements_type_id` (`type_id`),
  KEY `announcements_assoc` (`assoc_type`,`assoc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Announcements are messages that can be presented to users e.g. on the homepage.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `announcement_settings`
--

CREATE TABLE `announcement_settings` (
  `announcement_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `announcement_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`announcement_setting_id`),
  UNIQUE KEY `announcement_settings_unique` (`announcement_id`,`locale`,`setting_name`),
  KEY `announcement_settings_announcement_id` (`announcement_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about announcements, including localized properties like names and contents.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `announcement_types`
--

CREATE TABLE `announcement_types` (
  `type_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`type_id`),
  KEY `announcement_types_context_id` (`context_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Announcement types allow for announcements to optionally be categorized.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `announcement_type_settings`
--

CREATE TABLE `announcement_type_settings` (
  `announcement_type_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`announcement_type_setting_id`),
  UNIQUE KEY `announcement_type_settings_unique` (`type_id`,`locale`,`setting_name`),
  KEY `announcement_type_settings_type_id` (`type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about announcement types, including localized properties like their names.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `authors`
--

CREATE TABLE `authors` (
  `author_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `email` varchar(90) NOT NULL,
  `include_in_browse` smallint(6) NOT NULL DEFAULT '1',
  `publication_id` bigint(20) NOT NULL,
  `seq` double NOT NULL DEFAULT '0',
  `user_group_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`author_id`),
  KEY `authors_user_group_id` (`user_group_id`),
  KEY `authors_publication_id` (`publication_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The authors of a publication.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `author_affiliations`
--

CREATE TABLE `author_affiliations` (
  `author_affiliation_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `author_id` bigint(20) NOT NULL,
  `ror` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`author_affiliation_id`),
  KEY `author_affiliations_ror` (`ror`),
  KEY `author_affiliations_author_id_foreign` (`author_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Author affiliations' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `author_affiliation_settings`
--

CREATE TABLE `author_affiliation_settings` (
  `author_affiliation_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `author_affiliation_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`author_affiliation_setting_id`),
  UNIQUE KEY `author_affiliation_settings_unique` (`author_affiliation_id`,`locale`,`setting_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about author affiliations' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `author_settings`
--

CREATE TABLE `author_settings` (
  `author_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `author_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`author_setting_id`),
  UNIQUE KEY `author_settings_unique` (`author_id`,`locale`,`setting_name`),
  KEY `author_settings_author_id` (`author_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about authors, including localized properties such as their name and affiliation.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `categories`
--

CREATE TABLE `categories` (
  `category_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `parent_id` bigint(20) DEFAULT NULL,
  `seq` bigint(20) DEFAULT NULL,
  `path` varchar(255) NOT NULL,
  `image` text,
  PRIMARY KEY (`category_id`),
  UNIQUE KEY `category_path` (`context_id`,`path`),
  KEY `category_context_id` (`context_id`),
  KEY `category_context_parent_id` (`context_id`,`parent_id`),
  KEY `category_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Categories permit the organization of submissions into a heirarchical structure.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `category_settings`
--

CREATE TABLE `category_settings` (
  `category_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`category_setting_id`),
  UNIQUE KEY `category_settings_unique` (`category_id`,`locale`,`setting_name`),
  KEY `category_settings_category_id` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about categories, including localized properties such as names.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `citations`
--

CREATE TABLE `citations` (
  `citation_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `publication_id` bigint(20) NOT NULL,
  `raw_citation` text NOT NULL,
  `seq` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`citation_id`),
  UNIQUE KEY `citations_publication_seq` (`publication_id`,`seq`),
  KEY `citations_publication` (`publication_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A citation made by an associated publication.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `citation_settings`
--

CREATE TABLE `citation_settings` (
  `citation_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `citation_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) DEFAULT NULL,
  PRIMARY KEY (`citation_setting_id`),
  UNIQUE KEY `citation_settings_unique` (`citation_id`,`locale`,`setting_name`),
  KEY `citation_settings_citation_id` (`citation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Additional data about citations, including localized content.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `completed_payments`
--

CREATE TABLE `completed_payments` (
  `completed_payment_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `payment_type` bigint(20) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `assoc_id` bigint(20) DEFAULT NULL,
  `amount` decimal(8,2) unsigned NOT NULL,
  `currency_code_alpha` varchar(3) DEFAULT NULL,
  `payment_method_plugin_name` varchar(80) DEFAULT NULL,
  PRIMARY KEY (`completed_payment_id`),
  KEY `completed_payments_context_id` (`context_id`),
  KEY `completed_payments_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A list of completed (fulfilled) payments relating to a payment type such as a subscription payment.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `controlled_vocabs`
--

CREATE TABLE `controlled_vocabs` (
  `controlled_vocab_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `symbolic` varchar(64) NOT NULL,
  `assoc_type` bigint(20) NOT NULL DEFAULT '0',
  `assoc_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`controlled_vocab_id`),
  UNIQUE KEY `controlled_vocab_symbolic` (`symbolic`,`assoc_type`,`assoc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Every word or phrase used in a controlled vocabulary. Controlled vocabularies are used for submission metadata like keywords and subjects, reviewer interests, and wherever a similar dictionary of words or phrases is required. Each entry corresponds to a word or phrase like "cellular reproduction" and a type like "submissionKeyword".' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `controlled_vocab_entries`
--

CREATE TABLE `controlled_vocab_entries` (
  `controlled_vocab_entry_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `controlled_vocab_id` bigint(20) NOT NULL,
  `seq` double DEFAULT NULL,
  PRIMARY KEY (`controlled_vocab_entry_id`),
  KEY `controlled_vocab_entries_controlled_vocab_id` (`controlled_vocab_id`),
  KEY `controlled_vocab_entries_cv_id` (`controlled_vocab_id`,`seq`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The order that a word or phrase used in a controlled vocabulary should appear. For example, the order of keywords in a publication.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `controlled_vocab_entry_settings`
--

CREATE TABLE `controlled_vocab_entry_settings` (
  `controlled_vocab_entry_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `controlled_vocab_entry_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`controlled_vocab_entry_setting_id`),
  UNIQUE KEY `c_v_e_s_pkey` (`controlled_vocab_entry_id`,`locale`,`setting_name`),
  KEY `c_v_e_s_entry_id` (`controlled_vocab_entry_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about a controlled vocabulary entry, including localized properties such as the actual word or phrase.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `custom_issue_orders`
--

CREATE TABLE `custom_issue_orders` (
  `custom_issue_order_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `issue_id` bigint(20) NOT NULL,
  `journal_id` bigint(20) NOT NULL,
  `seq` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`custom_issue_order_id`),
  UNIQUE KEY `custom_issue_orders_unique` (`issue_id`),
  KEY `custom_issue_orders_issue_id` (`issue_id`),
  KEY `custom_issue_orders_journal_id` (`journal_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Ordering information for the issue list, when custom issue ordering is specified.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `custom_section_orders`
--

CREATE TABLE `custom_section_orders` (
  `custom_section_order_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `issue_id` bigint(20) NOT NULL,
  `section_id` bigint(20) NOT NULL,
  `seq` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`custom_section_order_id`),
  UNIQUE KEY `custom_section_orders_unique` (`issue_id`,`section_id`),
  KEY `custom_section_orders_issue_id` (`issue_id`),
  KEY `custom_section_orders_section_id` (`section_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Ordering information for sections within issues, when issue-specific section ordering is specified.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `data_object_tombstones`
--

CREATE TABLE `data_object_tombstones` (
  `tombstone_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `data_object_id` bigint(20) NOT NULL,
  `date_deleted` datetime NOT NULL,
  `set_spec` varchar(255) NOT NULL,
  `set_name` varchar(255) NOT NULL,
  `oai_identifier` varchar(255) NOT NULL,
  PRIMARY KEY (`tombstone_id`),
  KEY `data_object_tombstones_data_object_id` (`data_object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Entries for published data that has been removed. Usually used in the OAI endpoint.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `data_object_tombstone_oai_set_objects`
--

CREATE TABLE `data_object_tombstone_oai_set_objects` (
  `object_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `tombstone_id` bigint(20) NOT NULL,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  PRIMARY KEY (`object_id`),
  KEY `data_object_tombstone_oai_set_objects_tombstone_id` (`tombstone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Relationships between tombstones and other data that can be collected in OAI sets, e.g. sections.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `data_object_tombstone_settings`
--

CREATE TABLE `data_object_tombstone_settings` (
  `tombstone_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tombstone_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  PRIMARY KEY (`tombstone_setting_id`),
  UNIQUE KEY `data_object_tombstone_settings_unique` (`tombstone_id`,`locale`,`setting_name`),
  KEY `data_object_tombstone_settings_tombstone_id` (`tombstone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about data object tombstones, including localized content.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `dois`
--

CREATE TABLE `dois` (
  `doi_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `doi` varchar(255) NOT NULL,
  `status` smallint(6) NOT NULL DEFAULT '1',
  PRIMARY KEY (`doi_id`),
  KEY `dois_context_id` (`context_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores all DOIs used in the system.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `doi_settings`
--

CREATE TABLE `doi_settings` (
  `doi_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `doi_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`doi_setting_id`),
  UNIQUE KEY `doi_settings_unique` (`doi_id`,`locale`,`setting_name`),
  KEY `doi_settings_doi_id` (`doi_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about DOIs, including the registration agency.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `edit_decisions`
--

CREATE TABLE `edit_decisions` (
  `edit_decision_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `review_round_id` bigint(20) DEFAULT NULL,
  `stage_id` bigint(20) DEFAULT NULL,
  `round` smallint(6) DEFAULT NULL,
  `editor_id` bigint(20) NOT NULL,
  `decision` smallint(6) NOT NULL COMMENT 'A numeric constant indicating the decision that was taken. Possible values are listed in the Decision class.',
  `date_decided` datetime NOT NULL,
  PRIMARY KEY (`edit_decision_id`),
  KEY `edit_decisions_submission_id` (`submission_id`),
  KEY `edit_decisions_editor_id` (`editor_id`),
  KEY `edit_decisions_review_round_id` (`review_round_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Editorial decisions recorded on a submission, such as decisions to accept or decline the submission, as well as decisions to send for review, send to copyediting, request revisions, and more.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `email_log`
--

CREATE TABLE `email_log` (
  `log_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `sender_id` bigint(20) DEFAULT NULL,
  `date_sent` datetime NOT NULL,
  `event_type` bigint(20) DEFAULT NULL,
  `from_address` varchar(255) DEFAULT NULL,
  `recipients` text,
  `cc_recipients` text,
  `bcc_recipients` text,
  `subject` varchar(255) DEFAULT NULL,
  `body` text,
  PRIMARY KEY (`log_id`),
  KEY `email_log_sender_id` (`sender_id`),
  KEY `email_log_assoc` (`assoc_type`,`assoc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A record of email messages that are sent in relation to an associated entity, such as a submission.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `email_log_users`
--

CREATE TABLE `email_log_users` (
  `email_log_user_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `email_log_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  PRIMARY KEY (`email_log_user_id`),
  UNIQUE KEY `email_log_user_id` (`email_log_id`,`user_id`),
  KEY `email_log_users_email_log_id` (`email_log_id`),
  KEY `email_log_users_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A record of users associated with an email log entry.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `email_templates`
--

CREATE TABLE `email_templates` (
  `email_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `email_key` varchar(255) NOT NULL COMMENT 'Unique identifier for this email.',
  `context_id` bigint(20) NOT NULL,
  `alternate_to` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`email_id`),
  UNIQUE KEY `email_templates_email_key` (`email_key`,`context_id`),
  KEY `email_templates_context_id` (`context_id`),
  KEY `email_templates_alternate_to` (`alternate_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Custom email templates created by each context, and overrides of the default templates.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `email_templates_default_data`
--

CREATE TABLE `email_templates_default_data` (
  `email_templates_default_data_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `email_key` varchar(255) NOT NULL COMMENT 'Unique identifier for this email.',
  `locale` varchar(28) NOT NULL DEFAULT 'en',
  `name` varchar(255) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `body` text,
  PRIMARY KEY (`email_templates_default_data_id`),
  UNIQUE KEY `email_templates_default_data_unique` (`email_key`,`locale`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Default email templates created for every installed locale.' AUTO_INCREMENT=512 ;

--
-- Dumping data for table `email_templates_default_data`
--

INSERT INTO `email_templates_default_data` VALUES
(1, 'PASSWORD_RESET_CONFIRM', 'de', 'Bestätigung der Passwortzurücksetzung', 'Bestätigung der Passwortzurücksetzung', 'Wir wurden aufgefordert, Ihr Passwort für die Webseite {$siteTitle} neu zu setzen.<br />\n<br />\nFalls die Aufforderung nicht von Ihnen stammt, ignorieren Sie bitte diese E-Mail und Ihr Passwort bleibt unverändert. Falls Sie Ihr Passwort neu setzen möchten, klicken Sie bitte auf die folgende URL:<br />\n<br />\nMein Passwort neu setzen: {$passwordResetUrl}<br />\n<br />\n{$siteContactName}'),
(2, 'PASSWORD_RESET_CONFIRM', 'es', 'Confirmación de restablecimiento de contraseña', 'Confirmación de cambio de contraseña', 'Hemos recibido una petición para cambiar su contraseña en {$siteTitle}.<br />\n<br />\nSi no hizo usted esta petición ignore este correo-e y su contraseña no cambiará. Si desea cambiar su contraseña pinche en el enlace que le mostramos a continuación.<br />\n<br />\nCambiar mi contraseña: {$passwordResetUrl}<br />\n<br />\n{$siteContactName}'),
(3, 'PASSWORD_RESET_CONFIRM', 'fr_CA', 'Confirmation de la réinitialisation du mot de passe', 'Confirmation de la réinitialisation du mot de passe', 'Nous avons reçu une demande concernant la réinitialisation de votre mot de passe pour le site Web {$siteTitle}.<br />\n<br />\nSi vous n''avez pas fait cette demande, veuillez ne pas tenir compte du présent message, votre mot de passe restera le même. Si vous souhaitez réinitialiser votre mot de passe, cliquer sur l''URL ci-dessous.<br />\n<br />\nRéinitialisation de mon mot de passe : {$passwordResetUrl}<br />\n<br />\n{$siteContactName}'),
(4, 'PASSWORD_RESET_CONFIRM', 'it', '', 'Conferma di modifica della password', 'Abbiamo ricevuto una richiesta di modifica della password per {$siteTitle}.<br />\n<br />\nSe non ha inviato Lei la richiesta, ignori semplicemente questo messaggio e la password non sarà modificata. Se invece desidera generare una nuova password, clicchi sul link sottostante:<br />\n<br />\nReset della password: {$passwordResetUrl}<br />\n<br />\n{$siteContactName}'),
(5, 'PASSWORD_RESET_CONFIRM', 'nl', 'Bevestiging wachtwoord herstellen', 'Bevestiging wachtwoord herstellen', 'We hebben een verzoek van u ontvangen om uw wachtwoord voor de website {$siteTitle} te herstellen.<br />\n<br />\nAls u dat verzoek niet gedaan hebt, negeer dan deze e-mail en uw wachtwoord wordt niet veranderd. Als u uw wachtwoord wilt herstellen , klik dan op de url hieronder.<br />\n<br />\nHerstel mijn wachtwoord: {$passwordResetUrl}<br />\n<br />\n{$siteContactName}'),
(6, 'PASSWORD_RESET_CONFIRM', 'ru', 'Подтверждение сброса пароля', 'Подтверждение сброса пароля', 'Мы получили запрос на сброс Вашего пароля на сайте «{$siteTitle}».<br />\n<br />\nЕсли Вы не отправляли этот запрос, пожалуйста, проигнорируйте это письмо и Ваш пароль не будет изменен. Если Вы хотите сбросить свой пароль, то щелкните по ссылке ниже.<br />\n<br />\nСбросить мой пароль: {$passwordResetUrl}<br />\n<br />\n{$siteContactName}'),
(7, 'PASSWORD_RESET_CONFIRM', 'en', 'Password Reset Confirm', 'Password Reset Confirmation', 'We have received a request to reset your password for the {$siteTitle} web site.<br />\n<br />\nIf you did not make this request, please ignore this email and your password will not be changed. If you wish to reset your password, click on the below URL.<br />\n<br />\nReset my password: {$passwordResetUrl}<br />\n<br />\n{$siteContactName}'),
(8, 'USER_REGISTER', 'de', 'Benutzer/in angelegt', 'Registrierung bei der Zeitschrift', '{$recipientName}<br />\n<br />\nSie sind nun als neue/r Benutzer/in von {$journalName} registriert. Wir haben Ihren Benutzer/innennamen und Ihr Passwort in dieser Mail aufgeführt, beides wird für alle Arbeiten mit dieser Zeitschrift gebraucht. Sie können sich zu jedem Zeitpunkt als Benutzer/in der Zeitschrift austragen lassen, indem Sie mich kontaktieren.<br />\n<br />\nBenutzer/innenname: {$recipientUsername}<br />\nPasswort: {$password}<br />\n<br />\nVielen Dank <br />\n{$signature}'),
(9, 'USER_REGISTER', 'es', 'Usuario/a creado', 'Nuevo registro de usuaria/o', '{$recipientName}<br />\n<br />\nSe ha registrado con éxito como usuario/a en {$journalName}. En este correo se incluyen su nombre de usuario/a y contraseña, datos necesarios para realizar cualquier tarea relacionada con la revista a través de la página web. En cualquier momento puede solicitar que se le elimine de la lista de usuarios/as de la revista contactándome.<br />\n<br />\nNombre de usuario/a: {$recipientUsername}<br />\nContraseña: {$password}<br />\n<br />\nGracias,<br />\n{$signature}'),
(10, 'USER_REGISTER', 'fr_CA', 'Création de l''utilisateur-trice', 'Inscription à la revue', '{$recipientName},<br />\n<br />\nVous êtes désormais inscrit-e en tant qu''utilisateur-trice pour la revue {$journalName}. Votre nom d''utilisateur-trice et votre mot de passe figurent dans ce courriel, lesquels sont requis pour toute interaction avec la revue via son site Web. À n''importe quel moment, vous pouvez demander à être retiré-e de la liste des utilisateurs-trices de la revue en nous contactant.<br />\n<br />\nNom d''utilisateur-trice : {$recipientUsername}<br />\nMot de passe : {$password}<br />\n<br />\nMerci,<br />\n{$signature}'),
(11, 'USER_REGISTER', 'it', '', 'Registrazione nuovo utente', 'Gentile {$recipientName}<br />\n<br />\nGrazie per aver effettuato la registrazione a {$journalName}. Riportiamo qui di seguito le Sue credenziali, necessarie per l''accesso all''area riservata del sito web della rivista. Potrà richiedere in qualsiasi momento di essere rimosso dall''elenco degli utenti della rivista contattandoci via e-mail.<br />\n<br />\nNome utente: {$recipientUsername}<br />\nPassword: {$password}<br />\n<br />\nGrazie,<br />\n{$signature}'),
(12, 'USER_REGISTER', 'nl', 'Tijdschriftregistratie', 'Tijdschriftregistratie', '{$recipientName}<br />\n<br />\nU bent nu geregistreerd als gebruiker bij {$journalName}. We hebben uw gebruikersnaam en wachtwoord in deze e-mail opgenomen. U heeft die nodig om met het tijdschrift te werken. U kunt op ieder gewenst moment verwijderd worden van de lijst gebruikers van dit tijdschrift door contact met mij op te nemen<br />\n<br />\nGebruikersnaam: {$recipientUsername}<br />\nWachtwoord: {$password}<br />\n<br />\nDank u,<br />\n{$signature}'),
(13, 'USER_REGISTER', 'ru', 'Пользователь создан', 'Регистрация в журнале', 'Здравствуйте, {$recipientName}!<br />\n<br />\nТеперь Вы зарегистрированы как пользователь в журнале «{$journalName}». В этом письме мы указали Ваши имя пользователя и пароль, которые потребуются для работы с этим журналом через сайт. Вы в любой момент можете попросить, чтобы Вас удалили из списка пользователей журнала, для этого просто свяжитесь со мной.<br />\n<br />\nИмя пользователя: {$recipientUsername}<br />\nПароль: {$password}<br />\n<br />\nС уважением,<br />\n{$signature}'),
(14, 'USER_REGISTER', 'en', 'User Created', 'Journal Registration', '{$recipientName}<br />\n<br />\nYou have now been registered as a user with {$journalName}. We have included your username and password in this email, which are needed for all work with this journal through its website. At any point, you can ask to be removed from the journal''s list of users by contacting me.<br />\n<br />\nUsername: {$recipientUsername}<br />\nPassword: {$password}<br />\n<br />\nThank you,<br />\n{$signature}'),
(15, 'USER_VALIDATE_CONTEXT', 'de', 'E-Mail überprüfen (Zeitschrift Registrierung)', 'Account validieren', '{$recipientName}<br />\n<br />\nSie haben ein Benutzer/innenkonto bei {$journalName} angelegt, aber bevor Sie es benutzen können, müssen Sie Ihre E-Mail-Adresse bestätigen. Dazu folgen Sie bitte einfach dem folgenden Link:<br />\n<br />\n{$activateUrl}<br />\n<br />\nVielen Dank<br />\n{$journalSignature}'),
(16, 'USER_VALIDATE_CONTEXT', 'es', 'Validar correo electrónico (registro en la revista)', 'Valide su cuenta', 'Estimado/a {$recipientName}<br />\n<br />\nHa creado una cuenta de usuario/a en {$journalName}, pero antes de poder utilizarla debe validar su correo electrónico. Para ello, simplemente haga clic en el siguiente enlace:<br />\n<br />\n{$activateUrl}<br />\n<br />\nGracias,<br />\n{$journalSignature}'),
(17, 'USER_VALIDATE_CONTEXT', 'fr_CA', 'Validez l''adresse courriel (enregistrement de la revue)', 'Valider votre compte', '{$recipientName},<br />\n<br />\nVous avez créé un compte pour la revue {$journalName}. Pour pouvoir commencer à l''utiliser il nous faut d''abord valider votre adresse de courriel. Pour ce faire, vous n''avez qu''à suivre le lien ci-dessous :<br />\n<br />\n{$activateUrl}<br />\n<br />\nMerci,<br />\n{$journalSignature}'),
(18, 'USER_VALIDATE_CONTEXT', 'it', 'Confermare e-mail (registrazione di una rivista)', 'Convalida dell''account', 'Gentile {$recipientName}<br />\n<br />\nÈ stato creato un account per {$journalName}, ma prima di poter interagire sul sito web, è necessario validare il Suo indirizzo e-mail. Per fare ciò, clicchi semplicemente sul link sottostante:<br />\n<br />\n{$activateUrl}<br />\n<br />\nGrazie,<br />\n{$journalSignature}'),
(19, 'USER_VALIDATE_CONTEXT', 'nl', 'Valideer Email (tijdschriftregistratie)', 'Valideer uw account', '{$recipientName}<br />\n<br />\nU hebt een account aangemaakt bij {$journalName}. Voordat u dat kunt gebruiken moet u uw account valideren. U doet dat door de link hieronder te volgen:<br />\n<br />\n{$activateUrl}<br />\n<br />\nDank u,<br />\n{$journalSignature}'),
(20, 'USER_VALIDATE_CONTEXT', 'ru', 'Проверка адреса почты (регистрация в журнале)', 'Подтвердите свою учетную запись', 'Здравствуйте, {$recipientName}!<br />\n<br />\nВы создали учетную запись в журнале «{$journalName}», но перед тем как начать ее использовать, Вам нужно подтвердить свой адрес электронной почты. Чтобы сделать это, просто пройдите по ссылке ниже:<br />\n<br />\n{$activateUrl}<br />\n<br />\nС уважением,<br />\n{$journalSignature}'),
(21, 'USER_VALIDATE_CONTEXT', 'en', 'Validate Email (Journal Registration)', 'Validate Your Account', '{$recipientName}<br />\n<br />\nYou have created an account with {$journalName}, but before you can start using it, you need to validate your email account. To do this, simply follow the link below:<br />\n<br />\n{$activateUrl}<br />\n<br />\nThank you,<br />\n{$journalSignature}'),
(22, 'USER_VALIDATE_SITE', 'de', 'E-Mail überprüfen (Seite)', 'Account validieren', '{$recipientName}<br />\n<br />\nSie haben ein Benutzer/innenkonto bei {$siteTitle} angelegt, aber bevor Sie es benutzen können, müssen Sie Ihre E-Mail-Adresse bestätigen. Dazu folgen Sie bitte einfach dem folgenden Link:<br />\n<br />\n{$activateUrl}<br />\n<br />\nVielen Dank<br />\n{$siteSignature}'),
(23, 'USER_VALIDATE_SITE', 'es', 'Validar correo electrónico (Sitio)', 'Valide su cuenta', '{$recipientName}<br />\n<br />\nHa creado una cuenta en {$siteTitle}, pero antes de poder utilizarla, debe validar su email. Para hacerlo, simplemente haga clic en el siguiente enlace:<br />\n<br />\n{$activateUrl}<br />\n<br />\nGracias,<br />\n{$siteSignature}'),
(24, 'USER_VALIDATE_SITE', 'fr_CA', 'Valider le courriel (site)', 'Valider votre compte', '{$recipientName},<br />\n<br />\nVous avez créé un compte dans {$siteTitle}. Avant de pouvoir commencer à l''utiliser, il nous faut d''abord valider votre adresse de courriel. Pour ce faire, vous n''avez qu''à suivre le lien ci-dessous :<br />\n<br />\n{$activateUrl}<br />\n<br />\nMerci,<br />\n{$siteSignature}'),
(25, 'USER_VALIDATE_SITE', 'it', 'Convalidare l''e-mail (sito)', 'Conferma dell''account', 'Gentile {$recipientName}<br />\n<br />\nÈ necessario confermare l''indirizzo email associato al Suo nuovo account per la rivista {$siteTitle} cliccando sul link sottostante:<br />\n<br />\n{$activateUrl}<br />\n<br />\nGrazie e cordiali saluti,<br />\n{$siteSignature}'),
(26, 'USER_VALIDATE_SITE', 'nl', 'Valideer E-mail (Website)', 'Valideer uw account', '<p>Beste {$recipientName},</p>U heeft een account aangemaakt bij {$siteTitle}, maar voordat u het kunt gaan gebruiken, moet u uw e-mailadres valideren. Volg hiervoor de onderstaande link:<p>{$activateUrl},</p><p>Bedankt,</p>{$siteSignature}'),
(27, 'USER_VALIDATE_SITE', 'ru', 'Проверка адреса почты (сайт)', 'Подтвердите свою учетную запись', 'Здравствуйте, {$recipientName}!<br />\n<br />\nВы создали учетную запись на сайте «{$siteTitle}», но перед тем как начать её использовать, Вам нужно подтвердить адрес электронной почты. Чтобы сделать это, просто пройдите по ссылке ниже:<br />\n<br />\n{$activateUrl}<br />\n<br />\nС уважением,<br />\n{$siteSignature}'),
(28, 'USER_VALIDATE_SITE', 'en', 'Validate Email (Site)', 'Validate Your Account', '{$recipientName}<br />\n<br />\nYou have created an account with {$siteTitle}, but before you can start using it, you need to validate your email account. To do this, simply follow the link below:<br />\n<br />\n{$activateUrl}<br />\n<br />\nThank you,<br />\n{$siteSignature}'),
(29, 'REVIEWER_REGISTER', 'de', 'Gutachter/in registriert', 'Registrierung als Benutzer/in bei {$journalName}', '<p>Guten Tag {$recipientName}, </p><p>angesichts Ihrer Expertise haben wir uns erlaubt, Ihren Namen der Gutachter/innendatenbank von {$journalName} hinzuzufügen. Dies verpflichtet Sie zu nichts, ermöglicht uns aber, Sie um mögliche Gutachten für eine Einreichung zu bitten. Wenn Sie zu einem Gutachten eingeladen werden, werden Sie Titel und Abstract des Beitrags sehen können und werden stets selber entscheiden können, ob Sie der Einladung folgen oder nicht. Sie können zu jedem Zeitpunkt Ihren Namen von der Gutachter/innenliste entfernen lassen.</p><p>Wir senden Ihnen einen Benutzer/innennamen und ein Passwort, die Sie in allen Schritten der Zusammenarbeit mit der Zeitschrift über deren Website benötigen. Vielleicht möchten Sie z.B. Ihr Profil inkl. Ihrer Begutachtungsinteressen aktualisieren.</p><p>Benutzer/innenname: {$recipientUsername}<br />Passwort: {$password}</p><p>Vielen Dank</p>{$signature}'),
(30, 'REVIEWER_REGISTER', 'es', 'Registro de revisor/a', 'Registro como Revisor en {$journalName}', '<p>Estimado/a {$recipientName},</p><p>En vista de su experiencia, hemos registrado su nombre en la base de datos de revisores/as de {$journalName}. Esto no implica ningún compromiso por su parte, simplemente nos permite contactarle para una posible revisión de un trabajo. Cuando reciba una invitación para revisar podrá ver el título y el resumen del artículo en cuestión, y siempre tendrá la posibilidad de aceptar o rechazar la invitación. También puede pedirnos en cualquier momento que lo eliminemos de la lista de revisores/as.</p><p>Le enviamos el nombre de usuario/a y la contraseña, que le servirán para realizar cualquier tarea de la revista a través de su página web. Por ejemplo, puede actualizar su perfil e incluir sus intereses de revisión.</p><p>Nombre de usuario/a: {$recipientUsername}<br />Contraseña: {$password}</p><p>Gracias,</p>{$signature}'),
(31, 'REVIEWER_REGISTER', 'fr_CA', 'Inscription d''une évaluateur-trice', 'Inscription en tant qu''évaluateur-trice pour la revue {$journalName}', '<p>Bonjour {$recipientName},</p><p>Compte tenu de votre expertise, nous avons pris l''initiative d''inscrire votre nom dans la base de données des évaluateurs-trices de la revue {$journalName}. Cela ne vous engage d''aucune façon, mais nous permet simplement de solliciter vos services pour l''évaluation d''une soumission. Si vous êtes invité-e à effectuer une évaluation, vous recevrez le titre et le résumé de l''article en question, et serez toujours libre d''accepter ou de refuser une telle invitation. À tout moment, il vous est également possible de demander à ce que votre nom soit retiré de la liste des évaluateurs-trices.</p>\n<p>Nous vous acheminons un nom d''utilisateur-trice et un mot de passe, car tous deux sont requis pour tout échange avec la revue via son site Web. Vous pouvez, par exemple, si vous le souhaitez, effectuer la mise à jour de votre profil, y compris vos domaines d''intérêt en matière d''évaluation.</p>\n<p>Nom d''utilisateur-trice : {$recipientUsername}<br />\nMot de passe : {$password}</p>\n<p>Merci,</p>{$signature}'),
(32, 'REVIEWER_REGISTER', 'it', '', 'Registrazione come revisore per {$journalName}', '<p>Gentile {$recipientName},</p><p>Considerati i Suoi ambiti di competenza, vorremmo cortesemente registrare il Suo nominativo nell''elenco dei valutatori per {$journalName}. Ciò non implica nessun tipo di impegno da parte Sua, ma semplicemente ci consentirà di contattarLa, tramite il nostro sito web, per sottoporLe richieste di valutazione di proposte editoriali. In caso di richieste di valutazione, riceverà in primo luogo il titolo e il riassunto dei contributi e potrà, contestualmente, accettare o declinare l''invito alla revisione.</p><p>Troverà dunque qui di seguito il Suo nome utente e la Sua password, utili per tutte le interazioni con la rivista attraverso il sito web. Qualora fosse disponibile, le saremmo grati se volesse verificare le informazioni inserite e completare il profilo, compilando i campi suggeriti, tra cui anche le Sue aree tematiche di interesse.</p><p>Nome utente: {$recipientUsername}<br />Password: {$password}</p><p>Grazie,</p>{$signature}'),
(33, 'REVIEWER_REGISTER', 'nl', 'Registratie als Reviewer', 'Registratie als Reviewer bij {$journalName}', 'Met het oog op uw expertise hebben wij de vrijheid genomen om uw naam op te nemen in de lijst met reviewers van {$journalName}. Dit verplicht u tot niets maar geeft ons de mogelijkheid u te benaderen met het verzoek eventueel een inzending te reviewen. Bij de uitnodiging krijgt u de gelegenheid de titel en samenvatting van het stuk in kwestie te bekijken. U kunt de uitnodiging te allen tijde accepteren of weigeren. U kunt ook altijd vragen om uw naam van deze lijst te laten verwijderen.<br />\n<br />\nWe geven u een gebruikersnaam en wachtwoord, die gebruikt worden voor alle interacties met de website van het tijdschrift. Zo kunt u bijvoorbeeld uw profiel bijwerken, waaronder uw review-interesses.<br />\n<br />\nGebruikersnaam: {$recipientUsername}<br />\nWachtwoord: {$password}<br />\n<br />\nDank u,<br />\n{$signature}'),
(34, 'REVIEWER_REGISTER', 'ru', 'Регистрация рецензента', 'Регистрация в качестве рецензента в журнале «{$journalName}»', '<p>Здравствуйте, {$recipientName}!</p><p>Принимая во внимание Ваш опыт, мы взяли на себя смелость зарегистрировать Вас в базе данных потенциальных рецензентов для журнала «{$journalName}». Это не налагает на Вас никаких обязательств, а просто позволяет нам обращаться к Вам при поступлении в наш журнал материалов, рецензентом которых Вы могли бы стать. Получив предложение дать рецензию, Вы сможете увидеть название и аннотацию рукописи в запросе, и у Вас всегда будет возможность принять или отклонить это предложение. Вы также в любой момент можете попросить, чтобы мы удалили Ваше имя из этого списка рецензентов.</p><p>Мы высылаем Вам имя пользователя и пароль, которые используются при любом взаимодействии с нашим журналом через веб-сайт. Например, Вы можете откорректировать свои данные в профиле пользователя, указав интересующую Вас как рецензента тематику.</p><p>Имя пользователя: {$recipientUsername}<br /> Пароль: {$password}</p><p>С уважением,</p>{$signature}'),
(35, 'REVIEWER_REGISTER', 'en', 'Reviewer Register', 'Registration as Reviewer with {$journalName}', '<p>Dear {$recipientName},</p><p>In light of your expertise, we have registered your name in the reviewer database for {$journalName}. This does not entail any form of commitment on your part, but simply enables us to approach you with a submission to possibly review. On being invited to review, you will have an opportunity to see the title and abstract of the paper in question, and you''ll always be in a position to accept or decline the invitation. You can also ask at any point to have your name removed from this reviewer list.</p><p>We are providing you with a username and password, which is used in all interactions with the journal through its website. You may wish, for example, to update your profile, including your reviewing interests.</p><p>Username: {$recipientUsername}<br />Password: {$password}</p><p>Thank you,</p>{$signature}'),
(36, 'ISSUE_PUBLISH_NOTIFY', 'de', 'Ausgabe veröffentlicht Benachrichtigung', 'Gerade veröffentlicht: {$issueIdentification} von {$journalName}', '<p>Guten Tag {$recipientName},</p><p> wir freuen uns Ihnen mitteilen zu können, dass eine neue Ausgabe von {$journalName} veröffentlicht wurde: <a href="{$issueUrl}">{$issueIdentification}</a>. Wir laden Sie dazu ein, die Ausgabe zu lesen und mit Anderen Ihrer wissenschaftlichen Community zu teilen.</p><p>Vielen Dank an unsere Autor/innen, Gutachter/innen und Redakteur/innen für ihre wertvollen Beiträge - und natürlich an unsere Leser/innen für das anhaltende Interesse an unserer Arbeit.</p><div>{$issueToc}</div><p>Vielen Dank</p>{$signature}'),
(37, 'ISSUE_PUBLISH_NOTIFY', 'es', 'Notificación de número publicado', 'Nuevo número publicado: {$issueIdentification} en {$journalName}', '<p>Estimado/a {$recipientName},</p><p>Nos complace anunciar la publicación de <a href="{$issueUrl}">{$issueIdentification}</a> de {$journalName}. Le invitamos a leer y compartir este trabajo con su comunidad académica.</p><p>Damos las gracias a nuestros autores/as, revisores/as y editores/as por sus valiosas contribuciones, y a nuestros lectores/as por su constante interés.</p><div>{$issueToc}</div><p>Gracias,</p>{$signature}'),
(38, 'ISSUE_PUBLISH_NOTIFY', 'fr_CA', 'Notification de numéro paru', 'Parution du dernier numéro : {$issueIdentification} de la revue {$journalName}', '<p>Chers-ères lecteurs-trices,</p><p>La revue {$journalName} a le plaisir de vous annoncer la publication de son dernier numéro :  <a href="{$issueUrl}">{$issueIdentification}</a>. Nous vous invitons à consulter le sommaire, puis à visiter notre site Web pour y lire les articles qui vous intéressent. Nous remercions vivement nos auteurs-trices, réviseurs-es et rédacteurs-trices pour leurs précieuses contributions à cet ouvrage, ainsi que nos lecteurs-trices pour leur intérêt constant.</p><p>Cordialement,</p>{$signature}'),
(39, 'ISSUE_PUBLISH_NOTIFY', 'it', 'Notifica di numero pubblicato', 'Nuova pubblicazione: {$issueIdentification} per {$journalName}', '<p>Gentile {$recipientName},</p><p>Siamo lieti di comunicarLe che è stato pubblicato il nuovo <a href="{$issueUrl}">{$issueIdentification}</a> di {$journalName}.  La invitiamo gentilmente a consultare la pubblicazione e a condividerla con la Sua comunità di riferimento.</p><p>Siamo particolarmente grati agli autori, ai valutatori e ai curatori per i loro preziosi contributi, e ai nostri lettori per l''interesse nei confronti della nostra rivista.</p><p>Con i più cordiali saluti,</p>{$signature}'),
(40, 'ISSUE_PUBLISH_NOTIFY', 'nl', 'Nummer gepubliceerd notificatie', 'Nieuw nummer gepubliceerd: {$issueIdentification} van {$journalName}', 'Lezers:<br />\n<br />\n{$journalName} heeft zijn nieuwste nummer gepubliceerd op {$journalUrl}. We nodigen u uit om de inhoudsopgave te bekijken en de website te bezoeken voor het bekijken van de artikelen en andere interessante items.<br />\n<br />\nDank voor uw interesse in ons werk,<br />\n{$signature}'),
(41, 'ISSUE_PUBLISH_NOTIFY', 'ru', 'Уведомление о публикации выпуска', 'Только что опубликован: {$issueIdentification} журнала «{$journalName}»', '<p>Здравствуйте, {$recipientName}!</p><p>Журнал «{$journalName}» рад сообщить, что только что был опубликован наш последний выпуск <a href="{$issueUrl}">{$issueIdentification}</a>. Мы приглашаем вас ознакомиться с материалами выпуска и поделиться этой работой с вашим научным сообществом.</p><p>Благодарим наших авторов, рецензентов и редакторов за их неоценимый вклад, а наших читателей — за постоянный интерес к нашей работе.</p><div>{$issueToc}</div><p>С уважением,</p>{$signature}'),
(42, 'ISSUE_PUBLISH_NOTIFY', 'en', 'Issue Published Notify', 'Just published: {$issueIdentification} of {$journalName}', '<p>Dear {$recipientName},</p><p>We are pleased to announce the publication of <a href="{$issueUrl}">{$issueIdentification}</a> of {$journalName}.  We invite you to read and share this work with your scholarly community.</p><p>Many thanks to our authors, reviewers, and editors for their valuable contributions, and to our readers for your continued interest.</p><div>{$issueToc}</div><p>Thank you,</p>{$signature}'),
(43, 'SUBMISSION_ACK', 'de', 'Bestätigung der Einreichung', 'Ihre Einreichung für {$journalName}: Eingangsbestätigung', '<p>Sehr geehrte/r {$recipientName},</p><p>vielen Dank für die Einreichung Ihres Manuskripts &quot;{$submissionTitle}&quot; zur Veröffentlichung in {$journalName}. Ein Mitglied unseres Redaktionsteams wird sie sich bald ansehen. Sie erhalten eine E-Mail, wenn eine erste Entscheidung getroffen wurde, und wir können Sie auch für weitere Informationen kontaktieren.</p><p>Das Verwaltungssystem unserer Webzeitschrift erlaubt Ihnen, jederzeit den Lauf Ihres Beitrags im Redaktionsprozess zu beobachten. Sie loggen sich dazu einfach auf unserer Webseite ein:</p><p>URL des Manuskripts: {$submissionUrl}</p><p>Benutzer/innenname: {$recipientUsername}</p><p>Wenn Sie Fragen haben, kontaktieren Sie mich bitte über das <a href="{$authorSubmissionUrl}">Dashboard Ihrer Einreichung</a>.</p><p>Danke für Ihr Interesse an einer Veröffentlichung in unserer Zeitschrift {$journalName} .</p>{$journalSignature}'),
(44, 'SUBMISSION_ACK', 'es', 'Confirmación de envío', 'Gracias por su envío a {$journalName}', '<p>Estimado/a {$recipientName}:</p><p>Gracias por su envío a {$journalName}. Hemos recibido su original, {$submissionTitle}, y un miembro de nuestro equipo editorial lo revisará pronto. Le enviaremos un correo electrónico cuando se tome una decisión inicial, y podríamos contactarlo para darle más información.</p></p> Puede ver el envío y seguir su progreso a través del proceso editorial en el enlace siguiente:</p><p>URL del envío: {$authorSubmissionUrl}</p><p>Si se ha cerrado la sesión, puede volver a iniciarla con su nombre de usuario/a {$recipientUsername}.</p><p>Si tiene cualquier duda contacte con nosotros desde el <a href="{$authorSubmissionUrl}">panel de control del envío</a>.</p><p>Gracias por tener en cuenta {$journalName} como hogar para su trabajo.</p>{$journalSignature}'),
(45, 'SUBMISSION_ACK', 'fr_CA', 'Confirmation de soumission', 'Accusé de réception de la soumission à {$journalName}', '<p>{$recipientName},</p><p>Nous vous remercions d''avoir soumis le manuscrit intitulé « {$submissionTitle} » à la revue {$journalName}. Nous l''avons bien reçu et un membre de notre équipe éditorial le prendre en charge sous peu. Grâce à notre système de gestion en ligne, vous pourrez suivre votre soumission tout au long du processus d''édition en accédant au site Web de la revue :</p>\n<br />\nURL de la soumission : {$submissionUrl}<br />\nNom d''utilisateur-trice : {$recipientUsername}<br />\n<br />\nSi vous avez des questions, n''hésitez pas à communiquer avec nous. Nous vous remercions d''avoir pensé à notre revue pour la publication de vos travaux.<br />\n<br />\n{$journalSignature}'),
(46, 'SUBMISSION_ACK', 'it', '', 'Grazie per avere inviato il suo contributo a {$journalName}', 'Gentile {$recipientName},<br />\n<br />\nGrazie per aver inviato il suo contributo &quot;{$submissionTitle}&quot; alla testata  {$journalName}. Potrà il processo di revisione del suo manoscritto attraverso portale utilizzando la sua login al sito:<br />\n<br />\nURL della proposta: {$submissionUrl}<br />\nUsername: {$recipientUsername}<br />\n<br />\nPer qualsiasi domanda non esiti a contattarmi.<br />\nLa ringrazio per la preferenza espressa nei confronti di {$journalName}.<br />\n<br />\n{$journalSignature}'),
(47, 'SUBMISSION_ACK', 'nl', 'Bevestiging Inzending', 'Bedankt voor uw inzending aan {$journalName}', '<p>Beste {$recipientName},</p><p>Bedankt voor je inzending bij {$journalName}. We hebben je inzending, {$submissionTitle}, ontvangen en een lid van ons redactieteam zal het binnenkort bekijken. Je ontvangt een e-mail wanneer er een eerste beslissing is genomen, en we kunnen contact met je opnemen voor verdere informatie.</p><p>Je kunt je inzending bekijken en de voortgang ervan door de redactionele processen volgen op de volgende locatie:</p><p>Inzendings-URL: {$authorSubmissionUrl}</p><p>Als je bent uitgelogd, kun je opnieuw inloggen met de gebruikersnaam {$recipientUsername}.</p><p>Als je vragen hebt, neem dan contact met me op via je <a href="{$authorSubmissionUrl}">inzendingsdashboard</a>.</p><p>Bedankt voor het overwegen van {$journalName} als platform voor je werk.</p>{$journalSignature}'),
(48, 'SUBMISSION_ACK', 'ru', 'Подтверждение отправки', 'Благодарим за Ваш материал в журнал «{$journalName}»', '<p>Здравствуйте, {$recipientName}!</p><p>Благодарим Вас за отправку материала в «{$journalName}». Мы получили Ваш материал «{$submissionTitle}» и вскоре один из членов нашей редакции займётся его изучением. Вы получите письмо, когда первоначальное решение по материалу будет принято, мы также можем связаться с Вами для получения дополнительной информации.</p><p>Вы можете видеть свой материал и отслеживать его прохождение через редакционный процесс по следующей ссылке:</p><p>URL материала: {$authorSubmissionUrl}</p><p>Если Вы вышли из системы, Вы можете снова войти в нее с именем пользователя {$recipientUsername}.</p><p>Если у Вас возникнут какие-то вопросы, пожалуйста, свяжитесь со мной через <a href="{$authorSubmissionUrl}">страницу Вашего материала</a>.</p><p>Спасибо за выбор нашего журнала «{$journalName}» для публикации Вашей работы.</p>{$journalSignature}'),
(49, 'SUBMISSION_ACK', 'en', 'Submission Confirmation', 'Thank you for your submission to {$journalName}', '<p>Dear {$recipientName},</p><p>Thank you for your submission to {$journalName}. We have received your submission, "{$submissionTitle}", and a member of our editorial team will see it soon. You will be sent an email when an initial decision is made, and we may contact you for further information.</p><p>You can view your submission and track its progress through the editorial process at the following location:</p><p>Submission URL: {$authorSubmissionUrl}</p><p>If you have been logged out, you can login again with the username {$recipientUsername}.</p><p>If you have any questions, please contact me from your <a href="{$authorSubmissionUrl}">submission dashboard</a>.</p><p>Thank you for considering {$journalName} as a venue for your work.</p>{$journalSignature}'),
(50, 'SUBMISSION_ACK_NOT_USER', 'de', 'Bestätigung der Einreichung (andere Autor/innen)', 'Eingangsbestätigung', '<p>Sehr geehrte/r {$recipientName},</p><p>Sie wurden als Mitautor/in bei einer Einreichung bei {$KontextName} genannt. Der Verfasser/die Verfasserin, {$Einreichername}, hat die folgenden Angaben gemacht:</p><p>{$submissionTitle}<br>{$authorsWithAffiliation}</p><p>Wenn eine dieser Angaben nicht korrekt ist oder Sie nicht in diesem Beitrag genannt werden möchten, setzen Sie sich bitte mit mir in Verbindung.</p><p>Vielen Dank, dass Sie {$journalName} als Plattform für Ihre Arbeit in Betracht ziehen.</p><p>Mit freundlichen Grüßen,</p>{$journalSignature}'),
(51, 'SUBMISSION_ACK_NOT_USER', 'es', 'Confirmación del envío (otros autores/as)', 'Acuse de recibo del envío', 'Hola,<br />\n<br />\n{$submitterName} ha enviado el manuscrito &quot;{$submissionTitle}&quot; a {$journalName}. <br />\n<br />\nSi tiene cualquier pregunta no dude en contactarme. Le agradecemos que haya elegido esta revista para dar a conocer su obra.<br />\n<br />\n{$journalSignature}'),
(52, 'SUBMISSION_ACK_NOT_USER', 'fr_CA', 'Confirmation de soumission (autres auteur-es)', 'Accusé de réception de la soumission', '<p>Bonjour,</p><p>Le manuscrit intitulé , « {$submissionTitle} » , a été soumis par {$submitterName} à la revue {$journalName}.</p><p>Si vous avez des questions, n''hésitez pas à communiquer avec nous. Nous vous remercions d''avoir pensé à la revue {$journalName} pour la publication de vos travaux.</p><p>Cordialement,</p>{$journalSignature}'),
(53, 'SUBMISSION_ACK_NOT_USER', 'it', '', 'Conferma di ricezione della proposta', '<p>Gentilissimo {$recipientName}</p>\n<p>{$submitterName} ha aggiunto il suo nominativo in qualità di co-author del manoscritto "{$submissionTitle}" inviato per la pubblicazione alla rivista {$journalName}. </p>\n<p>questi sono i dettagli forniti: {$authorsWithAffiliation}</p>\n<p>Se non fossero corretti la prego di contattarci. Siamo a disposizione per qualsiasi chiarimento e la ringraziamo per la sua collaborazione.</p>\n<p>{$journalSignature}</p>'),
(54, 'SUBMISSION_ACK_NOT_USER', 'nl', 'Bevestiging Inzending (Overige Auteurs)', 'Bevestiging van inzending', '<p>Beste {$recipientName},</p><p>Je bent genoemd als medeauteur bij een inzending voor {$journalName}. De indiener, {$submitterName}, heeft de volgende details verstrekt:</p><p>{$submissionTitle}<br>{$authorsWithAffiliation}</p><p>Als een van deze details onjuist is, of als je niet genoemd wilt worden bij deze inzending, neem dan contact met me op.</p><p>Bedankt voor je overweging van {$journalName} als platform voor je werk.</p><p>Met vriendelijke groet,</p>{$journalSignature}'),
(55, 'SUBMISSION_ACK_NOT_USER', 'ru', 'Подтверждение отправки (другие авторы)', 'Подтверждение отправки', '<p>Здравствуйте, {$recipientName}!</p><p>Вы были указаны в качестве соавтора материала, направленного в журнал «{$journalName}». Отправитель, {$submitterName}, указал следующую информацию:</p><p>{$submissionTitle}<br>{$authorsWithAffiliation}</p><p>Если что-то в этой информации неправильно или Вы не хотите, чтобы Вас указывали в этом материале, пожалуйста, свяжитесь со мной.</p><p>Спасибо за выбор журнала «{$journalName}» для публикации Вашей работы.</p><p>С уважением,</p>{$journalSignature}'),
(56, 'SUBMISSION_ACK_NOT_USER', 'en', 'Submission Confirmation (Other Authors)', 'Submission confirmation', '<p>Dear {$recipientName},</p><p>You have been named as a co-author on a submission to {$journalName}. The submitter, {$submitterName}, provided the following details:</p><p>"{$submissionTitle}"<br>{$authorsWithAffiliation}</p><p>If any of these details are incorrect, or you do not wish to be named on this submission, please contact me.</p><p>Thank you for considering {$journalName} as a venue for your work.</p><p>Kind regards,</p>{$journalSignature}'),
(57, 'EDITOR_ASSIGN', 'de', 'Redakteur/in zugewiesen', 'Sie wurden als Redakteur/in von einer Einreichung bei {$journalName} zugewiesen', '<p>Sehr geehrte/r {$recipientName},</p><p>Die folgende Einreichung wurde Ihnen zur redaktionellen Bearbeitung zugewiesen. </p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Wenn Sie der Meinung sind, dass die Einreichung für die Zeitschrift {$journalName} relevant ist, leiten Sie die Einreichung bitte zur Begutachtung weiter, indem Sie "In die Begutachtung schicken" wählen und dann Gutachter zuweisen, indem Sie auf "Gutachter/in hinzufügen" klicken. </p><p>Wenn die Einreichung nicht für diese Zeitschrift geeignet ist, lehnen Sie die Einreichung bitte ab.</p><p>Danke im Voraus.</p><p>Mit freundlichen Grüßen,</p>{$journalSignature}'),
(58, 'EDITOR_ASSIGN', 'es', 'Editor/a asignado', 'Ha sido asignado como editor/a de un envío para {$journalName}', '<p>Estimado/a {$recipientName},</p><p>Se le ha asignado el siguiente envío para que coordine su proceso editorial.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Resumen</b></p>{$submissionAbstract}<p>Si le parece que el envío es relevante para {$journalName}, envíelo a la fase de revisión seleccionando "Enviar a revisión" y luego asigne revisores/as haciendo clic en "Añadir revisor/a".</p><p>Si el envío no es apropiado para esta revista, rechácelo.</p><p>Gracias de antemano.</p><p>Atentamente,</p>{$journalSignature}'),
(59, 'EDITOR_ASSIGN', 'fr_CA', 'Rédacteur-trice assigné', 'Vous avez été assigné.e en tant que rédacteur.trice d''une soumission de la revue {$journalName}', '<p>{$recipientName},</p><p>La soumission suivante vous a été assignée pour le suivi du processus éditorial.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Résumé</b></p>{$submissionAbstract}</p><p>Si vous jugez la soumission pertinente pour la revue {$journalName}, veuillez la transmettre à l''étape d''évaluation en sélectionnant "Envoyer en évaluation" et en désignant des évaluateur.trice.s en cliquant sur « Ajouter un.e évaluateur.trice ».</p><p>Si la soumission n''est pas appropriée pour cette revue, veuillez la décliner.</p><p>Je vous remercie d''avance.</p><p>Cordialement,</p>{$journalSignature}'),
(60, 'EDITOR_ASSIGN', 'it', '', 'Assegnazione di una proposta editoriale {$journalName}', '<p>Gentile {$recipientName},</p><p>La seguente proposta Le è stata assegnata per il processo editoriale:</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>ualora dovesse ritenere a proposta sia rilevante per {$journalName}, potrà inoltrarla alla fase di revisione selezionando "Invia alla revisione" e, successivamente, potrà assegnare i revisori utilizzando il tasto "Aggiungi revisore".</p><p>Se la proposta non dovesse essere a Suo giudizio appropriata per questa rivista, La preghiamo di rifiutarla.</p><p>Grazie in anticipo.</p><p>Cordiali saluti,</p>{$journalSignature}'),
(61, 'EDITOR_ASSIGN', 'nl', 'Redacteur toegewezen', 'Redactietaak', '{$recipientName}:<br />\n<br />\nDe inzending &quot;{$submissionTitle}&quot; voor {$journalName} is aan u toegewezen om in uw rol als sectieredacteur door het redactieproces te leiden.<br />\n<br />\nURL inzending: {$submissionUrl}<br />\nGebruikersnaam: {$recipientUsername}<br />\n<br />\nDank u, </p>{$journalSignature}'),
(62, 'EDITOR_ASSIGN', 'ru', 'Редактор назначен', 'Вы были назначены редактором материала в журнале «{$journalName}»', '<p>Здравствуйте, {$recipientName}!</p><p>Вам поручен контроль прохождения через редакционный процесс следующего материала:</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Аннотация</b></p>{$submissionAbstract}<p>Если Вы считаете, что данный материал соответствует тематике журнала «{$journalName}», пожалуйста, направьте его на этап рецензирования, выбрав «Отправить на рецензию», а затем назначив рецензентов, щелкнув на «Добавить рецензента».</p><p>Если материал не подходит для этого журнала, пожалуйста отклоните его.</p><p>Заранее благодарю.</p><p>С уважением,</p>{$journalSignature}'),
(63, 'EDITOR_ASSIGN', 'en', 'Editor Assigned', 'You have been assigned as an editor on a submission to {$journalName}', '<p>Dear {$recipientName},</p><p>The following submission has been assigned to you to see through the editorial process.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>If you find the submission to be relevant for {$journalName}, please forward the submission to the review stage by selecting "Send to Review" and then assign reviewers by clicking "Add Reviewer".</p><p>If the submission is not appropriate for this journal, please decline the submission.</p><p>Thank you in advance.</p><p>Kind regards,</p>{$journalSignature}'),
(64, 'REVIEW_CANCEL', 'de', 'Gutachter/in nicht mehr zugeordnet', 'Anfrage zur Begutachtung zurückgezogen', '<p>Sehr geehrte/r {$recipientName},</p><p>vor kurzem haben wir Sie gebeten, eine Einsendung an die Zeitschrift{$KontextName} zu begutachten. Wir haben uns entschlossen, die Bitte um Begutachtung der Einreichung {$submissionTitle} zu stornieren.</p><p>Wir entschuldigen uns für alle Unannehmlichkeiten, die Ihnen dadurch entstehen, und hoffen, dass wir Sie auch in Zukunft zur Unterstützung des Begutachtungsprozesses dieser Zeitschrift heranziehen können.</p><p>Wenn Sie irgendwelche Fragen haben, wenden Sie sich bitte an mich.</p>{$signature}'),
(65, 'REVIEW_CANCEL', 'es', 'Desasignar revisor/a', 'Petición de revisión cancelada', '<p>Estimado/a {$recipientName},</p><p>Recientemente, le pedimos que revisara una presentación para {$journalName}. Hemos decidido cancelar la solicitud para que revise el artículo, {$submissionTitle}.</p><p>Lamentamos cualquier inconveniente que esto pueda causarle y esperamos poder contar con su ayuda en el futuro para el proceso de revisión de esta revista.</p><p>Si tiene alguna pregunta, por favor contácteme.</p>{$signature}'),
(66, 'REVIEW_CANCEL', 'fr_CA', 'Évaluateur.trice non assigné.e', 'Annulation de la demande d''évaluation', '<p>Bonjour {$recipientName},</p><p>Nous avons décidé d''annuler notre demande concernant l''évaluation du manuscrit intitulé « {$submissionTitle} » pour la revue {$journalName}. Nous sommes désolés des inconvénients que cela pourrait vous causer et espérons que nous pourrons de nouveau faire appel à vous pour contribuer au processus de révision par les pairs de cette revue dans le futur.</p><p>Si vous avez des questions, n''hésitez pas à communiquer avec nous.</p>{$signature}'),
(67, 'REVIEW_CANCEL', 'it', 'Revisore non assegnato', 'Cancellazione della richiesta di revisione', '<p>Gentile {$recipientName},</p><p>Di recente Le abbiamo chiesto di esaminare una proposta per {$journalName}. Abbiamo tuttavia deciso di annullare tale la richiesta di revisione per il contributo {$submissionTitle}.</p><p>Ci scusiamo per l''inconveniente e speriamo di poterLa contattare in futuro per nuove occasioni di collaborazione.</p><p>Per ogni quesito o necessità, non esiti a contattarci. Grazie e cordiali saluti,</p>{$signature}'),
(68, 'REVIEW_CANCEL', 'nl', 'Reviewverzoek Intrekken', 'Reviewverzoek ingetrokken', '<p>Dear {$recipientName}:<br />\n<br />\nWe hebben besloten om ons verzoek aan u om de inzending &quot;{$submissionTitle}&quot; voor {$journalName}in te trekken. We verontschuldigen ons voor enig ongemak dat we daarmee veroorzaken en hopen dat we u in de toekomst mogen vragen om een bijdrage aan het reviewproces van dit tijdschrift.<br />\n<br />\nAls u nog vragen heeft, kunt u contact met mij opnemen.</p>{$signature}'),
(69, 'REVIEW_CANCEL', 'ru', 'Назначение рецензентом отменено', 'Запрос на рецензирование отменен', '<p>Здравствуйте, {$recipientName}!</p><p>Недавно мы просили Вас дать рецензию на материал, присланный в журнал «{$journalName}», и теперь решили отменить наш запрос на рецензирование Вами материала «{$submissionTitle}».</p><p>Мы приносим свои извинения за причиненное Вам беспокойство и надеемся, что в будущем мы сможем к Вам обратиться за помощью в рецензировании материалов для нашего журнала.</p><p>Если у Вас есть вопросы, пожалуйста, свяжитесь со мной.</p>{$signature}'),
(70, 'REVIEW_CANCEL', 'en', 'Reviewer Unassign', 'Request for Review Cancelled', '<p>Dear {$recipientName},</p><p>Recently, we asked you to review a submission to {$journalName}. We have decided to cancel the request for you to reivew the submission, {$submissionTitle}.</p><p>We apologize any inconvenience this may cause you and hope that we will be able to call on you to assist with this journal''s review process in the future.</p><p>If you have any questions, please contact me.</p>{$signature}'),
(71, 'REVIEW_REINSTATE', 'de', 'Gutachter/in wieder eingesetzt', 'Können Sie weiterhin einen Beitrag für {$journalName} begutachten?', '<p>Sehr geehrte/r {$recipientName},</p><p>wir haben vor kurzem unsere Anfrage an Sie, eine Einreichung, {$submissionTitle}, für die Zeitschrift {$journalName} zu begutachten, storniert. Wir haben diese Entscheidung rückgängig gemacht und hoffen, dass Sie immer noch in der Lage sind, die Begutachtung durchzuführen.</p><p>Wenn Sie in der Lage sind, bei der Begutachtung dieser Einreichung zu helfen, können Sie sich <a href="{$reviewAssignmentUrl}">bei der Zeitschrift anmelden</a>, um die Einreichung zu sehen, Begutachtungsdateien hochzuladen und Ihre Begutachtungsanfrage zu übermitteln.</p><p>Wenn Sie irgendwelche Fragen haben, kontaktieren Sie mich bitte.</p><p>Mit freundlichen Grüßen,</p>{$signature}'),
(72, 'REVIEW_REINSTATE', 'es', 'Restaurar revisor/a', '¿Aún puede hacer revisiones para {$journalName}?', '<p>Estimado {$recipientName},</p><p>Recientemente cancelamos nuestra solicitud para que revisara una presentación, {$submissionTitle}, para {$journalName}. Hemos revertido esa decisión y esperamos que todavía pueda llevar a cabo la revisión.</p><p>Si puede ayudar con la revisión de este artículo, puede <a href="{$reviewAssignmentUrl}">iniciar sesión en la revista</a> para ver la presentación, cargar archivos de revisión y enviar su solicitud de revisión.</p><p>Si tiene alguna pregunta, por favor contácteme.</p><p>Atentamente,</p>{$signature}'),
(73, 'REVIEW_REINSTATE', 'fr_CA', 'Évaluateur.trice réintégré.e', 'Êtes-vous encore en mesure d''évaluer des travaux pour la revue {$journalName} ?', '<p>{$recipientName},</p><p>Nous avons récemment annulé notre demande vous demandant d''évaluer la soumission, {$submissionTitle}, pour la revue {$journalName}. Nous sommes revenus sur cette décision et nous espérons que vous êtes toujours en mesure d''effectuer l''évaluation.</p><p>Si vous êtes en mesure d''aider au processus d''évaluation de cette revue, vous pouvez vous <a href="{$reviewAssignmentUrl}">connecter au site de la revue</a> pour voir la soumission, téléverser les fichiers d''évaluation ainsi que soumettre votre évaluation.</p><p>Si vous avez des questions, n''hésitez pas à communiquer avec moi,</p><p>Cordialement,</p>{$signature}');
INSERT INTO `email_templates_default_data` VALUES
(74, 'REVIEW_REINSTATE', 'it', 'Revisore reintegrato', 'È ancora disponibile per la revisione per {$journalName}?', '<p>Gentile {$recipientName},</p><p>La contattiamo perché avevamo di recente annullato la nostra richiesta di revisione per la proposta {$submissionTitle}, per {$journalName}. Tuttavia, abbiamo ora riveduto tale decisione e speriamo vivamente che Lei possa ancora effettuare la revisione.</p><p>Qualora possa contribuire alla revisione di questa proposta editoriale, potrà <a href="{$reviewAssignmentUrl}">effettuare l''accesso</a> per visualizzare la proposta, per caricare i file di revisione e per inviare le richieste.</p><p>Per ogni quesito, non esiti a contattarci.</p><p>Cordiali saluti,</p>{$signature}'),
(75, 'REVIEW_REINSTATE', 'nl', '', 'Herindienen beoordelingsverzoek', '<p>Dear {$recipientName}:<br />\n<br />\nWe willen graag ons beoordelingsverzoek over de inzending, &quot;{$submissionTitle},&quot; for {$journalName}, herindienen.<br />\n<br />\nVoor vragen kunt u contact met mij opnemen,</p>{$signature}'),
(76, 'REVIEW_REINSTATE', 'ru', 'Рецензент назначен заново', 'Можете ли Вы ещё отрецензировать кое-что для «{$journalName}»?', '<p>Здравствуйте, {$recipientName}!</p><p>Мы недавно отменили наш запрос на Вашу рецензию для материала «{$submissionTitle}» в журнал «{$journalName}». Сейчас мы изменили это решение и надеемся, что Вы ещё можете дать эту рецензию.</p><p>Если Вы можете помочь нашему журналу с процессом рецензирования данного материала, Вы можете <a href="{$reviewAssignmentUrl}">войти в систему</a>, чтобы просмотреть материал, загрузить файлы рецензии и отправить Вашу рецензию.</p><p>Если у Вас есть какие-то вопросы, пожалуйста, свяжитесь со мной.</p><p>С уважением,</p>{$signature}'),
(77, 'REVIEW_REINSTATE', 'en', 'Reviewer Reinstate', 'Can you still review something for {$journalName}?', '<p>Dear {$recipientName},</p><p>We recently cancelled our request for you to review a submission, {$submissionTitle}, for {$journalName}. We''ve reversed that decision and we hope that you are still able to conduct the review.</p><p>If you are able to assist with this submission''s review, you can <a href="{$reviewAssignmentUrl}">login to the journal</a> to view the submission, upload review files, and submit your review request.</p><p>If you have any questions, please contact me.</p><p>Kind regards,</p>{$signature}'),
(78, 'REVIEW_RESEND_REQUEST', 'de', 'Gutachtenanfrage erneut an Gutachter/in senden', 'Erneute Anfrage nach Ihrem Gutachten für {$journalName}', '<p>Sehr geehrte/r {$recipientName},</p><p>Kürzlich haben Sie unsere Bitte abgelehnt, eine Einreichung, {$submissionTitle}, für {$journalName} zu prüfen. Ich schreibe Ihnen, um zu erfahren, ob Sie die Prüfung doch noch durchführen können.</p><p>Wir wären Ihnen dankbar, wenn Sie diese Beurteilung vornehmen könnten, haben aber Verständnis dafür, wenn dies zum jetzigen Zeitpunkt nicht möglich ist. In jedem Fall bitten wir Sie, <a href="{$reviewAssignmentUrl}">die Anfrage</a> bis zum {$responseDueDate} anzunehmen oder abzulehnen, damit wir einen alternativen Gutachter oder eine alternative Gutachterin finden können.</p><p>Wenn Sie Fragen haben, wenden Sie sich bitte an mich.</p><p>Mit freundlichen Grüßen,</p>{$signature}'),
(79, 'REVIEW_RESEND_REQUEST', 'es', 'Reenviar la solicitud de revisión al revisor/a', 'Solicitando de nuevo su revisión para {$journalName}', ''),
(80, 'REVIEW_RESEND_REQUEST', 'fr_CA', 'Envoyer de nouveau la demande d''évaluation à l''évaluateur-trice', 'Demande d''évaluation réitérée pour {$journalName}', '<p>{$recipientName},</p><p>Vous avez décliné récemment notre invitation à évaluer la soumission, {$submissionTitle}, pour {$journalName}. Je vous écris afin de vous demander si vous accepteriez de reconsidérer votre décision et d''accepter de l''évaluer.</p><p>Nous vous en serions très reconnaissant, mais nous comprenons également que vous soyez dans l''impossibilité de le faire en ce moment. Quoi qu''il en soit, pouvez-vous s''il vous plait <a href="{$reviewAssignmentUrl}">accepter ou approuver notre demande</a> avant le {$responseDueDate}.</p><p>Si vous avez des questions, n''hésitez pas nous contacter.</p><p>Cordialement,</p>{$signature}'),
(81, 'REVIEW_RESEND_REQUEST', 'it', '', '', ''),
(82, 'REVIEW_RESEND_REQUEST', 'nl', '', 'Verzoek om je nieuwe beoordeling voor {$journalName}', '<p>Beste {$recipientName},</p><p>Onlangs heb je ons verzoek om een inzending, {$submissionTitle}, voor {$journalName} te beoordelen, afgewezen. Ik schrijf om te vragen of je toch in staat bent om de beoordeling uit te voeren.</p><p>We zouden je dankbaar zijn als je deze beoordeling kunt uitvoeren, maar we begrijpen het als dat op dit moment niet mogelijk is. Hoe dan ook, graag <a href="{$reviewAssignmentUrl}">accepteer of wijs het verzoek af</a> voor {$responseDueDate}, zodat we een alternatieve beoordelaar kunnen vinden.</p><p>Als je vragen hebt, neem dan contact met me op.</p><p>Met vriendelijke groet,</p>{$signature}'),
(83, 'REVIEW_RESEND_REQUEST', 'ru', 'Повторная отправка рецензенту запроса на рецензию', 'Повторный запрос Вашей рецензии для журнала «{$journalName}»', '<p>Здравствуйте, {$recipientName}!</p><p>Недавно Вы отклонили наш запрос на рецензирование материала «{$submissionTitle}» для журнала «{$journalName}». Я пишу Вам, чтобы узнать, может Вы всё-таки сможете провести рецензирование этого материала.</p><p>Мы будем благодарны, если Вы сможете дать эту рецензию, но также поймём, если Вы не сможете это сделать в данный момент. В любом случае, пожалуйста, <a href="{$reviewAssignmentUrl}">примите или отклоните запрос</a> до {$responseDueDate}, чтобы мы смогли найти другого рецензента.</p><p>Если у Вас есть какие-то вопросы, пожалуйста, свяжитесь со мной.</p><p>С уважением,</p>{$signature}'),
(84, 'REVIEW_RESEND_REQUEST', 'en', 'Resend Review Request to Reviewer', 'Requesting your review again for {$journalName}', '<p>Dear {$recipientName},</p><p>Recently, you declined our request to review a submission, "{$submissionTitle}", for {$journalName}. I''m writing to see if you are able to conduct the review after all.</p><p>We would be grateful if you''re able to perform this review, but we understand if that is not possible at this time. Either way, please <a href="{$reviewAssignmentUrl}">accept or decline the request</a> by {$responseDueDate}, so that we can find an alternate reviewer.</p><p>If you have any questions, please contact me.</p><p>Kind regards,</p>{$signature}'),
(85, 'REVIEW_REQUEST', 'de', 'Gutachtenanfrage', 'Einladung zur Begutachtung', '<p>Sehr geehrte/r {$recipientName},</p><p>Ich glaube, dass Sie ein hervorragender Gutachter für einen Beitrag bei der Zeitschrift {$journalName} sein könnten. Ich hoffe, dass Sie diese wichtige Aufgabe für uns übernehmen werden.</p><p>Wenn Sie in der Lage sind, diesen Beitrag zu begutachten, ist Ihre Begutachtung bis zum {$reviewDueDate} fällig. Sie können die Einreichung einsehen, Begutachtungsdateien hochladen und Ihre Begutachtung einreichen, indem Sie sich auf der Website der Zeitschrift anmelden und den Schritten unter dem unten stehenden Link folgen. </p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a></p><p><b>Abstract</b></p>{$submissionAbstract}<p>Ich erbitte die <a href="{$reviewAssignmentUrl}">Annahme oder Ablehnung</a> des Gutachtens bis <b>{$responseDueDate}</b>. </p><p>Gerne stehe ich Ihnen zur Verfügung, wenn Sie Fragen zur Einreichung oder zum Begutachtungsverfahren haben.</p><p>Danke, dass Sie diesen Anfrage berücksichtigen. Ihre Hilfe wird sehr geschätzt.</p><p>Mit freundlichen Grüßen,</p>{$signature}'),
(86, 'REVIEW_REQUEST', 'es', 'Solicitud de revisión', 'Invitación de revisión', '<p>Estimado/a {$recipientName},</p><p>Creemos que sería un excelente revisor/a para el envío a {$journalName}. El título y el resumen del envío se encuentran a continuación, espero que considere asumir esta tarea tan importante para nosotros.</p><p>Si puede revisar este envío, debería devolvernos su revisión antes del {$reviewDueDate}. Puede ver el envío, cargar los archivos de revisión y enviarnos su revisión iniciando sesión en el sitio de la revista y siguiendo los pasos del siguiente enlace.</p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a></p><p><b>Resumen</b></p>{$submissionAbstract}<p>Por favor, <a href="{$reviewAssignmentUrl}">acepte o rechace</a> la revisión antes del <b>{$responseDueDate}</b>.</p><p>Puede ponerse en contacto con nosotros si tiene alguna pregunta sobre el envío o el proceso de revisión.</p><p>Gracias por considerar esta solicitud. Apreciamos mucho su ayuda.</p><p>Atentamente,</p>{$signature}'),
(87, 'REVIEW_REQUEST', 'fr_CA', 'Demande d''évaluation', 'Demande d''évaluation d''un article', '<p>Bonjour {$recipientName},</p><p>Nous croyons que vous feriez un-e excellent-e évaluateur-trice pour le manuscrit intitulé « {$submissionTitle} » qui a été soumis à la revue {$journalName}. Vous trouverez un résumé de la soumission ci-dessous. Nous espérons que vous accepterez ce travail essentiel à la publication de la revue.</p><p>Veuillez accéder au site Web de la revue avant le {$responseDueDate} pour nous laisser savoir  <a href="{$reviewAssignmentUrl}">si vous acceptez de faire l''évaluation ou non</a>.</p><p>« {$submissionTitle} »</p><p>{$submissionAbstract}</p><p>La date d''échéance de l''évaluation a été fixée au {$reviewDueDate}.</p><p>Si vous n''avez pas de nom d''utilisateur-trice et de mot de passe pour le site Web de la revue, cliquez sur le lien ci-dessous pour réinitialiser votre mot de passe (lequel vous sera envoyé par courriel avec votre nom d''utilisateur-trice). {$passwordLostUrl}</p><p>URL de la soumission : {$reviewAssignmentUrl}</p><p>Nous vous remercions de l''attention que vous porterez à notre demande.</p>{$signature}'),
(88, 'REVIEW_REQUEST', 'it', '', 'Proposta di revisione', '<p>Gentile {$recipientName},</p><p>Ritengo che Lei sarebbe un eccellente revisore per una proposta editoriale che è stata sottoposta a {$journalName}. Il titolo e l''abstract della proposta sono riportati qui di seguito; spero che potrà prendere in considerazione l''idea di svolgere questo importante compito per noi.</p><p>In caso di Sua disponibilità, la scadenza per la revisione è fissata al {$reviewDueDate}. È possibile visualizzare la proposta, caricare i file di revisione e inviare la propria revisione accedendo al sito della rivista e seguendo i passaggi indicati nel link sottostante.</p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a></p><p><b>Abstract</b></p>{$submissionAbstract}<p>Per cortesia <a href="{$reviewAssignmentUrl}">accetti o declini</a> la proposta di revisione entro il <b>{$responseDueDate}</b>.</p><p>Non esiti a contattarci per qualsiasi domanda sull''invio o sul processo di revisione.</p><p>Grazie per aver preso in considerazione questa richiesta e per la preziosa collaborazione.</p><p>Cordiali saluti,</p>{$signature}'),
(89, 'REVIEW_REQUEST', 'nl', 'Artikel Review Verzoek', 'Artikel review verzoek', '{$recipientName}:<br />\n<br />\nIk geloof dat u een excellente reviewer zou zijn voor het manuscript &quot;{$submissionTitle}&quot; dat is ingestuurd bij {$journalName}. De samenvatting van de inzending staat hieronder. Ik hoop dat u wilt overwegen deze belangrijke taak voor ons uit te voeren.<br />\n<br />\nWilt u voor {$responseDueDate} inloggen op de website van het tijdschrift om aan te geven of u de review al of niet doet. Daar kunt u ook de inzending vinden en uw review en aanbeveling vastleggen. De website is {$journalUrl}<br />\n<br />\nHet review wordt verwacht op {$reviewDueDate}.<br />\n<br />\nAls u uw gebruikersnaam en het wachtwoord van de website van het tijdschrift niet heeft, kunt u deze link gebruiken voor het herstellen van uw wachtwoord (dat samen met uw gebruikersnaam in een e-mail naar u verstuurd wordt). {$passwordLostUrl}<br />\n<br />\nURL inzending: {$reviewAssignmentUrl}<br />\n<br />\nDank u voor het overwegen van dit verzoek.<br />\n<br />\n{$signature}<br />\n<br />\n<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}'),
(90, 'REVIEW_REQUEST', 'ru', 'Запрос на рецензию', 'Приглашение к рецензированию', '<p>Здравствуйте, {$recipientName}!</p><p>Я полагаю, что Вы могли бы быть прекрасным рецензентом для материала, который был направлен в журнал «{$journalName}». Название и аннотация статьи приведены ниже, и я надеюсь, что Вы возьметесь выполнить эту важную задачу для нас.</p><p>Если Вы можете дать рецензию, то её надо сделать к {$reviewDueDate}. Вы можете просмотреть материал, загрузить файлы рецензии и отправить Вашу рецензию, войдя в систему на сайте журнала и следуя шагам по ссылке ниже.</p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a></p><p><b>Аннотация</b></p>{$submissionAbstract}<p>Пожалуйста, <a href="{$reviewAssignmentUrl}">подтвердите Ваше согласие или откажитесь</a> от рецензирования до <b>{$responseDueDate}</b>.</p><p>Вы можете связаться со мной, если у Вас есть какие-то вопросы относительно материала или процесса рецензирования.</p><p>Благодарю Вас за рассмотрение этой просьбы. Мы высоко ценим вашу помощь.</p><p>С уважением,</p>{$signature}'),
(91, 'REVIEW_REQUEST', 'en', 'Review Request', 'Invitation to review', '<p>Dear {$recipientName},</p><p>I believe that you would serve as an excellent reviewer for a submission  to {$journalName}. The submission''s title and abstract are below, and I hope that you will consider undertaking this important task for us.</p><p>If you are able to review this submission, your review is due by {$reviewDueDate}. You can view the submission, upload review files, and submit your review by logging into the journal site and following the steps at the link below.</p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a></p><p><b>Abstract</b></p>{$submissionAbstract}<p>Please <a href="{$reviewAssignmentUrl}">accept or decline</a> the review by <b>{$responseDueDate}</b>.</p><p>You may contact me with any questions about the submission or the review process.</p><p>Thank you for considering this request. Your help is much appreciated.</p><p>Kind regards,</p>{$signature}'),
(92, 'REVIEW_REQUEST_SUBSEQUENT', 'de', 'Nachfolgende Gutachtenanfrage', 'Anfrage zur Begutachtung einer überarbeiteten Einreichung', '<p>Sehr geehrte/r {$recipientName},</p><p>Danke für Ihr Gutachten zu <a href="{$reviewAssignmentUrl}">{$submissionTitle}</a>. Die Autor/innen haben das Feedback der Gutachter/innen berücksichtigt und nun eine überarbeitete Version ihrer Arbeit eingereicht. Ich schreibe Ihnen, um Sie zu fragen, ob Sie eine zweite Begutachtungsrunde für diese Einreichung durchführen würden.</p><p>Wenn Sie in der Lage sind, diese Einreichung zu begutachten, ist Ihre Begutachtung bis {$reviewDueDate} fällig. Sie können <a href="{$reviewAssignmentUrl}">den Begutachtungsschritten folgen</a>, um die Einreichung anzusehen, Begutachtungsdateien hochzuladen und Ihre Begutachtungskommentare einzureichen. <p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a></p><p><b>Abstract</b></p>{$submissionAbstract}<p>Bitte <a href="{$reviewAssignmentUrl}">Annahme oder Ablehnung</a> des Gutachtens bis zum <b>{$responseDueDate}</b>. </p><p>Bei Fragen zur Einreichung oder zum Begutachtungsverfahren können Sie sich gerne an mich wenden.</p><p>Danke, dass Sie diesen Anfrage berücksichtigen. Ihre Hilfe wird sehr geschätzt.</p><p>Mit freundlichen Grüßen,</p>{$signature}'),
(93, 'REVIEW_REQUEST_SUBSEQUENT', 'es', 'Solicitud de revisión posterior', 'Solicitud para revisar un envío ya revisado', '<p>Estimado/a {$recipientName},</p><p>Le agradecemos su revisión de <a href="{$reviewAssignmentUrl}">{$submissionTitle}</a>. Los autores/as han tenido en cuenta los comentarios de los revisores/as y han enviado una versión revisada de su trabajo. Le escribo para preguntarle si podría realizar una segunda ronda de revisión por pares de este envío.</p><p>Si está disponible para revisar este envío, debería devolvernos su revisión antes del {$reviewDueDate}. Puede <a href="{$reviewAssignmentUrl}">seguir los pasos de revisión</a> para ver el envío, cargar archivos de revisión y enviar sus comentarios de revisión.</p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a></p><p><b>Resumen</b></p>{$submissionAbstract}<p>Por favor, <a href="{$reviewAssignmentUrl}">acepte o rechace</a> la revisión antes del <b>{$responseDueDate}</b>.</p><p>No dude en ponerse en contacto con nosotros si tiene alguna pregunta sobre el envío o el proceso de revisión.</p><p>Gracias por considerar esta solicitud. Apreciamos mucho su ayuda.</p><p>Atentamente,</p>{$signature}'),
(94, 'REVIEW_REQUEST_SUBSEQUENT', 'fr_CA', 'Demande d''évaluation (nouveau cycle)', 'Demande d''évaluation d''un article révisé', '<p>{$recipientName},</p><p>Nous vous remercions d''avoir effectué l''évaluation du manuscrit intitulé <a href="{$reviewAssignmentUrl}">{$submissionTitle}</a>.</p><p><br/>{$submissionAbstract}</p>\n<p>Suivant les commentaire de l''évaluation de la dernière version du manuscrit, l''auteur-trice a soumis une version révisée de son document. Nous apprécierions que vous évaluiez cette nouvelle version dans le cadre d''un second cycle d''évaluation.</p><p>Si vous êtes en mesure d''effectuer cette évaluation, veuillez vous authentifier sur la page de la revue avant le {$responseDueDate} pour y indiquer si vous participerez à cette évaluation ou non, ou encore pour accéder à la soumission et y enregistrer votre évaluation et vos recommandations. Le site Web est {$journalUrl}</p>\n<p>L''évaluation est due pour le {$reviewDueDate}.</p><p>Si vous n''avez pas vos nom d''utilisateur-trice et mot de passe pour le site de la revue, vous pouvez utiliser le lien suivant pour réinitialiser votre mot de passe (lequel vous sera envoyé par courriel avec votre nom d''utilisateur-trice). {$passwordLostUrl}</p><p>URL de la soumission : {$reviewAssignmentUrl}</p><p>Nous vous remercions de l''attention que vous porterez à notre demande.</p>{$signature}'),
(95, 'REVIEW_REQUEST_SUBSEQUENT', 'it', '', 'Richiesta di ulteriore revisione per una proposta già valutata', '<p>Gentile {$recipientName},</p><p>Grazie per la Sua cortese valutazione di <a href="{$reviewAssignmentUrl}">{$submissionTitle}</a>. A seguito delle considerazioni formulate, sono stati ricevuti riscontri e una nuova versione della proposta editoriale. Saremmo dunque grati se potesse effettuare una nuova e ulteriore valutazione per questa proposta editoriale.</p><p>In caso di disponibilità, Le saremmo grati se potesse comunicare la Sua valutazione entro il {$reviewDueDate}. Le ricordiamo che potrà accedere al <a href="{$reviewAssignmentUrl}">processo editoriale</a>per visualizzare la proposta, caricare nuovi file di revisione, e sottoporre i Suoi eventuali commenti.<p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a></p><p><b>Abstract</b></p>{$submissionAbstract}<p>La preghiamo dunque di <a href="{$reviewAssignmentUrl}">accettare o declinare</a> la revisione entro il <b>{$responseDueDate}</b>.</p><p>Per ogni esigenza o necessità, non esiti a contattarci.</p><p>Grazie infinite, e con i più cordiali saluti,</p>{$signature}'),
(96, 'REVIEW_REQUEST_SUBSEQUENT', 'nl', 'Verzoek tot reviewen van een artikel', 'Verzoek tot reviewen van een herzien artikel', '{$recipientName}:<br />\n<br />\nDit betreft het manuscript &quot;{$submissionTitle},&quot; dat wordt overwogen door {$journalName}.<br />\n<br />\nNa de review van een vorige versie van hun manuscript hebben de auteurs een gereviseerde versie ingestuurd. We zouden het waarderen als u wilt helpen die te evalueren.<br />\n<br />\nGelieve in te loggen op de website van het tijdschrift vóór {$responseDueDate} om aan te geven of u deze review wilt doen of niet, alsmede om toegang te krijgen tot de inzending en uw bevindingen en aanbeveling vast te leggen. De website is {$journalUrl}<br />\n<br />\nDe revieuw moet gereed zijn op {$reviewDueDate}.<br />\n<br />\nAls u uw gebruikersnaam en wachtwoord niet meer heeft, kunt u deze link gebruiken om uw wachtwoord terug te zetten (dat u met uw gebruikersnaam in een e-mail zult ontvangen). {$passwordLostUrl}<br />\n<br />\nURL van de inzending: {$reviewAssignmentUrl}<br />\n<br />\nHartelijk dank voor het overwegen van dit verzoek.<br />\n<br />\n{$signature}<br />\n<br />\n<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}'),
(97, 'REVIEW_REQUEST_SUBSEQUENT', 'ru', 'Запрос на повторную рецензию', 'Запрос на рецензирование исправленного материала', '<p>Здравствуйте, {$recipientName}!</p><p>Благодарю Вас за рецензирование материала <a href="{$reviewAssignmentUrl}">«{$submissionTitle}»</a>. Авторы ознакомились с отзывами рецензентов и прислали откорректированную версию их работы. В связи с этим хочу спросить Вас: сможете ли Вы принять участие во втором раунде рецензирования этого материала?</p><p>Если Вы сможете дать рецензию на этот материал, то её нужно прислать до {$reviewDueDate}. Вы можете <a href="{$reviewAssignmentUrl}">следовать шагам процесса рецензирования</a>, чтобы просмотреть материал, загрузить файлы рецензии и отправить Ваши комментарии по рецензии.<p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a></p><p><b>Аннотация</b></p>{$submissionAbstract}<p>Пожалуйста, <a href="{$reviewAssignmentUrl}">подтвердите Ваше согласие или откажитесь</a> от рецензирования до <b>{$responseDueDate}</b>.</p><p>Пожалуйста, свяжитесь со мной, если у Вас есть какие-то вопросы по материалу или процессу рецензирования.</p><p>Благодарю Вас за рассмотрение этой просьбы. Мы высоко ценим вашу помощь.</p><p>С уважением,</p>{$signature}'),
(98, 'REVIEW_REQUEST_SUBSEQUENT', 'en', 'Review Request Subsequent', 'Request to review a revised submission', '<p>Dear {$recipientName},</p><p>Thank you for your review of <a href="{$reviewAssignmentUrl}">{$submissionTitle}</a>. The authors have considered the reviewers'' feedback and have now submitted a revised version of their work. I''m writing to ask if you would conduct a second round of peer review for this submission.</p><p>If you are able to review this submission, your review is due by {$reviewDueDate}. You can <a href="{$reviewAssignmentUrl}">follow the review steps</a> to view the submission, upload review files, and submit your review comments.<p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a></p><p><b>Abstract</b></p>{$submissionAbstract}<p>Please <a href="{$reviewAssignmentUrl}">accept or decline</a> the review by <b>{$responseDueDate}</b>.</p><p>Please feel free to contact me with any questions about the submission or the review process.</p><p>Thank you for considering this request. Your help is much appreciated.</p><p>Kind regards,</p>{$signature}'),
(99, 'REVIEW_RESPONSE_OVERDUE_AUTO', 'de', 'Antwort auf eine Gutachtenanfrage fällig (Automatisiert)', 'Können Sie den Beitrag für uns begutachten?', '<p>Sehr geehrte/r {$recipientName},</p><p>Diese E-Mail ist eine automatische Erinnerung der Zeitschrift {$Kontextname} in Bezug auf unsere Aufforderung zur Begutachtung der Einreichung "{$submissionTitle}".</p><p>Sie erhalten diese E-Mail, weil wir noch keine Bestätigung von Ihnen erhalten haben, ob Sie in der Lage sind, diese Einreichung zu begutachen oder nicht. </p><p>Bitte teilen Sie uns mit, ob Sie in der Lage sind, diesen Beitrag zu prüfen, indem Sie unsere Software zur Verwaltung der Einreichungen verwenden, um diese Anfrage anzunehmen oder abzulehnen.</p><p>Wenn Sie in der Lage sind, diesen Beitrag zu prüfen, ist Ihr Gutachten bis zum {$reviewDueDate} fällig. Sie können die Begutachtungsschritte befolgen, um die Einreichung einzusehen, Begutachtungsdateien hochzuladen und Ihre Begutachtungskommentare zu übermitteln.</p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a></p><p><b>Abstract</b></p>{$submissionAbstract}<p>Bei Fragen zur Einreichung oder zum Begutachtungsprozess können Sie sich gerne an mich wenden.</p><p>Danke, dass Sie diese Anfrage berücksichtigen. Ihre Hilfe ist mir sehr willkommen.</p><p>Mit freundlichen Grüßen,</p>{$journalSignature}'),
(100, 'REVIEW_RESPONSE_OVERDUE_AUTO', 'es', 'Respuesta de revisión vencida (automática)', '¿Podrá llevar a cabo la revisión?', '<p>Estimado/a {$recipientName},</p><p>Este correo electrónico es un recordatorio automático de {$journalName} en relación con la solicitud de revisión del envío, "{$submissionTitle}."</p><p>El motivo de este mensaje es que aún no hemos recibido la confirmación de si podrá llevar a cabo la revisión de este envío.</p><p>Por favor, háganos saber su decisión mediante nuestro software de gestión de envíos aceptando o rechazando dicha solicitud.</p><p>Si está dispuesto a aceptar el encargo, su revisión debería estar lista el {$reviewDueDate}. Puede seguir los pasos de revisión para visualizar el envío, cargar archivos de revisión y enviar sus comentarios.</p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a></p><p><b>Resumen</b></p>{$submissionAbstract}<p>No dude en ponerse en contacto con nosotros si tiene cualquier pregunta acerca del envío o del proceso de revisión.</p><p>Gracias por tomar en consideración esta petición. Su ayuda es muy valiosa.</p><p>Saludos cordiales,</p>{$journalSignature}'),
(101, 'REVIEW_RESPONSE_OVERDUE_AUTO', 'fr_CA', 'Rappel automatique pour une invitation à évaluer', 'Seriez-vous en mesure d''évaluer ce manuscrit pour nous ?', '<p>Bonjour {$recipientName},</p><p>Ceci est un petit rappel concernant notre demande d''évaluation de « {$submissionTitle} » pour la revue {$journalName}. Puisque nous n''avons pas reçu, comme nous l''espérions, une réponse avant le {$responseDueDate}, ce courriel a été généré et envoyé automatiquement après l''échéance du délai.</p><p>Nous pensons que vous seriez un-e excellent-e évaluateur-trice pour le manuscrit. Vous trouverez un résumé de la soumission ci-dessous. Nous espérons que vous envisagerez d''entreprendre cette tâche essentielle à la publication de la revue.</p>\n<p>Veuillez vous authentifier sur la page de la revue pour y indiquer si vous participerez à cette évaluation ou non, ou encore pour accéder à la soumission et y enregistrer votre évaluation et vos recommandations. Le site Web est {$journalUrl}</p><p>L''évaluation est dû pour le {$reviewDueDate}.</p><p>Si vous n''avez pas vos nom d''utilisateur-trice et mot de passe pour le site de la revue, vous pouvez utiliser le lien suivant pour réinitialiser votre mot de passe (lequel vous sera envoyé par courriel avec votre nom d''utilisateur-trice). {$passwordLostUrl}</p><p>URL de la soumission : {$reviewAssignmentUrl}</p><p>Nous vous remercions de l''attention que vous porterez à notre demande.</p><p>« {$submissionTitle} »</p><p>{$submissionAbstract}</p>{$journalSignature}'),
(102, 'REVIEW_RESPONSE_OVERDUE_AUTO', 'it', '', 'Può effettuare una revisione per la nostra rivista?', '<p>Gentile {$recipientName},</p><p>Questa e-mail è un promemoria automatico da parte di {$journalName} in merito alla richiesta di revisione del contributo "{$submissionTitle}."</p><p>Riceve questa e-mail perché non abbiamo ancora raccolto una conferma da parte Sua che indichi se potrà essere in grado o meno di effettuare la revisione proposta .</p><p>La preghiamo di comunicarci la Sua eventuale disponibilità circa la possibilità di accettare o di rifiutare tale proposta utilizzando la nostra piattaforma editoriale.</p><p>Qualora fosse in grado di effettuare la revisione, la scadenza è fissata al {$reviewDueDate}. È possibile seguire le fasi di revisione per visualizzare il contributo, per caricare i file di revisione e per inviare i propri commenti di revisione.</p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a></p><p><b>Abstract</b></p>{$submissionAbstract}<p>Per ogni necessità, non esiti a contattarci.</p><p>Grazie per la preziosa collaborazione.</p><p>Con i più cordiali saluti,</p>{$journalSignature}'),
(103, 'REVIEW_RESPONSE_OVERDUE_AUTO', 'nl', 'Geautomatiseerde Review Herinnering', 'Verzoek om artikelbeoordeling', '{$recipientName}:<br />\nWe willen u vriendelijk herinneren aan ons verzoek voor een review van het manuscript &quot;{$submissionTitle},&quot; voor {$journalName}. We verwachtten uw antwoord voor {$responseDueDate}; dit bericht werd automatisch verstuurd na het verstrijken van die datum. \n<br />\nIk geloof dat u een excellente reviewer zou zijn voor het manuscript. De samenvatting van de inzending staat hieronder. Ik hoop dat u wilt overwegen deze belangrijke taak voor ons uit te voeren.<br />\n<br />\nWilt u inloggen op de website van het tijdschrift om aan te geven of u de review al of niet doet. Daar kunt u ook de inzending vinden en uw review en aanbeveling vastleggen. De website is {$journalUrl}<br />\n<br />\nHet review wordt verwacht op {$reviewDueDate}.<br />\n<br />\nAls u uw gebruikersnaam en het wachtwoord van de website van het tijdschrift niet heeft, kunt u deze link gebruiken voor het herstellen van uw wachtwoord (dat samen met uw gebruikersnaam in een e-mail naar u verstuurd wordt). {$passwordLostUrl}<br />\n<br />\nURL inzending: {$reviewAssignmentUrl}<br />\n<br />\nDank u voor het overwegen van dit verzoek.<br />\n<br />\n{$journalSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}'),
(104, 'REVIEW_RESPONSE_OVERDUE_AUTO', 'ru', 'Срок ответа на запрос рецензии прошёл (автоматическое)', 'Сможете ли Вы сделать рецензию этого материала для нас?', '<p>Здравствуйте, {$recipientName}!</p><p>Это письмо — автоматическое напоминание из журнала «{$journalName}» о нашем запросе Вашей рецензии на материал «{$submissionTitle}».</p><p>Вы получили это письмо, поскольку мы ещё не получили от Вас информации о том, что Вы сможете или не сможете сделать рецензию на этот материал.</p><p>Пожалуйста, воспользуйтесь нашей системой управления материалами, чтобы принять или отклонить этот запрос на рецензию и чтобы мы знали о Вашем решении.</p><p>Если Вы сможете дать рецензию на этот материал, то её нужно прислать до {$reviewDueDate}. Вы можете следовать шагам процесса рецензирования, чтобы просмотреть материал, загрузить файлы рецензии и отправить Ваши комментарии по рецензии.</p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a></p><p><b>Аннотация</b></p>{$submissionAbstract}<p>Пожалуйста, свяжитесь со мной, если у Вас есть какие-то вопросы по материалу или процессу рецензирования.</p><p>Благодарю Вас за рассмотрение этой просьбы. Мы высоко ценим вашу помощь.</p><p>С уважением,</p>{$journalSignature}'),
(105, 'REVIEW_RESPONSE_OVERDUE_AUTO', 'en', 'Review Response Overdue (Automated)', 'Will you be able to review this for us?', '<p>Dear {$recipientName},</p><p>This email is an automated reminder from {$journalName} in regards to our request for your review of the submission, "{$submissionTitle}."</p><p>You are receiving this email because we have not yet received a confirmation from you indicating whether or not you are able to undertake the review of this submission.</p><p>Please let us know whether or not you are able to undertake this review by using our submission management software to accept or decline this request.</p><p>If you are able to review this submission, your review is due by {$reviewDueDate}. You can follow the review steps to view the submission, upload review files, and submit your review comments.</p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a></p><p><b>Abstract</b></p>{$submissionAbstract}<p>Please feel free to contact me with any questions about the submission or the review process.</p><p>Thank you for considering this request. Your help is much appreciated.</p><p>Kind regards,</p>{$journalSignature}'),
(106, 'REVIEW_CONFIRM', 'de', 'Gutachten bestätigt', 'Überprüfung angenommen: {$reviewerName} hat den Überprüfungsauftrag angenommen für #{$submissionId} {$authorsShort} — {$submissionTitle}', '<p>Sehr geehrte/r {$recipientName},</p><p>{$reviewerName} hat die folgende Überprüfung akzeptiert:</p><p><a href="{$submissionUrl}">#{$submissionId} {$authorsShort} — {$submissionTitle}</a><br /><b>Gutachtenmethode:</b> {$reviewMethod}</p><p><b>Gutachten fällig am:</b> {$reviewDueDate}</p><p>Melden Sie sich an, um <a href="{$submissionUrl}">alle Gutachteraufgaben</a> für diese Einreichung zu sehen.</p><br><br>—<br>Dies ist eine automatische Nachricht von <a href="{$journalUrl}">{$journalName}</a>.'),
(107, 'REVIEW_CONFIRM', 'es', 'Confirmación de la revisión', 'Revisión aceptada: {$reviewerName} aceptó la asignación de revisión de #{$submissionId} {$authorsShort} — {$submissionTitle}', 'Editores/as:<br />\n<br />\nTengo la capacidad y deseo revisar el envío &quot;{$submissionTitle},&quot; para {$journalName}. Gracias por acordarse de mí, es mi intención tener la revisión completa en el plazo indicado: {$reviewDueDate}, a ser posible antes.<br />\n<br />\n{$senderName}'),
(108, 'REVIEW_CONFIRM', 'fr_CA', 'Évaluation confirmée', 'Acceptation d''évaluation', 'Rédacteurs-trices,<br />\n<br />\nJe suis en mesure d''évaluer la soumission intitulée « {$submissionTitle} » pour la revue {$journalName}. Je vous remercie d''avoir pensé à moi. Je devrais être en mesure de compléter l''évaluation pour la date du {$reviewDueDate}, voire avant.<br />\n<br />\n{$senderName}'),
(109, 'REVIEW_CONFIRM', 'it', '', 'Accettazione incarico di revisione', 'Gentile Editor,<br />\n<br />\nAccetto l''incarico di revisionare &quot;{$submissionTitle},&quot; per {$journalName}.<br />\nPenso di completare la revisione per la data che mi avete comunicato, {$reviewDueDate}, se non prima.<br />\n<br />\n{$senderName}'),
(110, 'REVIEW_CONFIRM', 'nl', 'Review mogelijk', 'Beoordeling geaccepteerd: {$reviewerName} heeft de beoordelingsopdracht geaccepteerd voor #{$submissionId} {$authorsShort} — {$submissionTitle}', '<p>Beste {$recipientName},</p><p>{$reviewerName} heeft de volgende beoordeling geaccepteerd:</p><p><a href="{$submissionUrl}">#{$submissionId} {$authorsShort} — {$submissionTitle}</a><br /><b>Type:</b> {$reviewMethod}</p><p><b>Beoordeling vereist voor:</b> {$reviewDueDate}</p><p>Log in om <a href="{$submissionUrl}">alle beoordelingsopdrachten van de beoordelaar</a> voor deze inzending te bekijken.</p><br><br>—<br>Dit is een geautomatiseerd bericht vanuit <a href="{$journalUrl}">{$journalName}</a>.'),
(111, 'REVIEW_CONFIRM', 'ru', 'Подтверждение рецензирования', 'Согласие на рецензию: {$reviewerName} принимает задание на рецензию для #{$submissionId} {$authorsShort} — «{$submissionTitle}»', '<p>Здравствуйте, {$recipientName}!</p><p>Рецензент {$reviewerName} дал согласие на следующую рецензию:</p><p><a href="{$submissionUrl}">#{$submissionId} {$authorsShort} — «{$submissionTitle}»</a><br /><b>Тип:</b> {$reviewMethod}</p><b>Срок отправки рецензии:</b> {$reviewDueDate}</p><p>Войдите в системк, чтобы <a href="{$submissionUrl}">просмотреть все задания на рецензию</a> для этого материала.</p><br><br>—<br>Это автоматическое сообщение, отправленное из журнала <a href="{$journalUrl}">«{$journalName}»</a>.'),
(112, 'REVIEW_CONFIRM', 'en', 'Review Confirm', 'Review accepted: {$reviewerName} accepted review assignment for #{$submissionId} {$authorsShort} — "{$submissionTitle}"', '<p>Dear {$recipientName},</p><p>{$reviewerName} has accepted the following review:</p><p><a href="{$submissionUrl}">#{$submissionId} {$authorsShort} — "{$submissionTitle}"</a><br /><b>Type:</b> {$reviewMethod}</p><p><b>Review Due:</b> {$reviewDueDate}</p><p>Login to <a href="{$submissionUrl}">view all reviewer assignments</a> for this submission.</p><br><br>—<br>This is an automated message from <a href="{$journalUrl}">{$journalName}</a>.'),
(113, 'REVIEW_DECLINE', 'de', 'Gutachten abgelehnt', 'Nicht in der Lage zu begutachten', 'Sehr geehrte Redakteure/innen:<br />\n<br />\nIch fürchte, dass ich die Einreichung "{$submissionTitle}" für die Zeitschrift {$journalName} zur Zeit nicht begutachten kann. Vielen Dank, dass Sie an mich gedacht haben. Sie können mich gerne ein anderes Mal kontaktieren.<br />\n<br />\n{$Absendername}'),
(114, 'REVIEW_DECLINE', 'es', 'Rechazo de la revisión', 'Rechazo la revisión', 'Editores/as:<br />\n<br />\nMe temo que en este momento no voy a poder revisar el envío &quot;{$submissionTitle},&quot; para {$journalName}. Gracias por pensar en mí, espero que vuelvan a contar conmigo en futuras ocasiones.<br />\n<br />\n{$senderName}'),
(115, 'REVIEW_DECLINE', 'fr_CA', 'Évaluation refusée', 'Refus d''évaluation', 'Rédacteurs-trices,<br />\n<br />\nPour le moment, il m''est impossible d''évaluer la soumission intitulée « {$submissionTitle} » pour la revue {$journalName}. Je vous remercie d''avoir pensé à moi. N''hésitez pas à communiquer avec moi pour un autre projet.<br />\n<br />\n{$senderName}'),
(116, 'REVIEW_DECLINE', 'it', '', 'Rifiuto dell''incarico di revisione', 'Gentili Editor,<br />\n<br />\nSono spiacente di comunicarVi che non posso attualmente accogliere la proposta di valutazione della proposta &quot;{$submissionTitle}&quot; per {$journalName}. Nella speranza di future occasioni di collaborazione, porgo cordiali saluti,<br />\n<br />\n{$senderName}'),
(117, 'REVIEW_DECLINE', 'nl', 'Review niet mogelijk', 'Review niet mogelijk', '{$recipientName}:<br />\n<br />\nIk ben bang dat ik op dit moment niet in staat ben om een review te doen van inzending &quot;{$submissionTitle}&quot; voor {$journalName}. Dank u dat u aan mij gedacht heeft en voel u vrij om op een ander moment een beroep op mij te doen.<br />\n<br />\n{$senderName}'),
(118, 'REVIEW_DECLINE', 'ru', 'Отказ от рецензирования', 'Не могу дать рецензию', 'Уважаемые редакторы!<br />\n<br />\nБоюсь, что в данный момент я не могу дать рецензию на материал «{$submissionTitle}» для журнала «{$journalName}». Благодарю вас, что обратились ко мне, в другой раз также не стесняйтесь, обращайтесь ко мне.<br />\n<br />\n{$senderName}'),
(119, 'REVIEW_DECLINE', 'en', 'Review Decline', 'Unable to Review', 'Editors:<br />\n<br />\nI am afraid that at this time I am unable to review the submission, &quot;{$submissionTitle},&quot; for {$journalName}. Thank you for thinking of me, and another time feel free to call on me.<br />\n<br />\n{$senderName}'),
(120, 'REVIEW_ACK', 'de', 'Gutachten erhalten', 'Eingangsbestätigung für Ihr Gutachten', '<p>Sehr geehrte/r {$recipientName},</p>\n<p>vielen Dank für Ihr Gutachten zum Beitrag &quot;{$submissionTitle}&quot; für die Zeitschrift {$journalName}. Ihre Stellungnahme ist eine wichtige Unterstützung für unsere Bemühungen um die Qualität der von uns veröffentlichten Arbeiten.</p>\n<p>Es war uns eine Freude, mit Ihnen als Gutachter/in für {$journalName} zusammenzuarbeiten, und wir hoffen, dass wir auch in Zukunft die Gelegenheit haben werden, mit Ihnen zusammenzuarbeiten.</p>\n<p>Mit freundlichen Grüßen,</p>\n<p>{$Unterschrift}</p>'),
(121, 'REVIEW_ACK', 'es', 'Agradecimiento por la revisión', 'Gracias por su revisión', '<p>Estimado/a {$recipientName},</p>\n<p>Gracias por completar la revisión del envío, {$submissionTitle}, para {$journalName}. Le agradecemos su tiempo y su pericia, que contribuyen a la calidad de las obras que publicamos.</p>\n<p>Ha sido un placer trabajar con usted como revisor/a para {$journalName}, y esperamos tener la oportunidad de seguir haciéndolo en el futuro.</p>\n<p>Saludos cordiales,</p>\n<p>{$signature}</p>'),
(122, 'REVIEW_ACK', 'fr_CA', 'Accusé de réception de l''évaluation', 'Accusé de réception de l''évaluation d''une soumission', '<p>{$recipientName},</p>\n<p>Nous vous remercions d''avoir évaluer la soumission, {$submissionTitle}, pour {$journalName}. Nous apprécions l''expertise et le temps que vous y avez consacrés et qui contribuent à la qualité des travaux que nous publions.</p>\n<p>Ce fut un plaisir de travailler avec vous et nous espérons avoir opportunité de le faire encore à l''avenir.</p>\n<p>Cordialement,</p>\n<p>{$signature}</p>'),
(123, 'REVIEW_ACK', 'it', '', 'Ringraziamenti per la revisione', 'Gentile {$recipientName}:<br />\n<br />\nGrazie per aver completato la revisione del manoscritto &quot;{$submissionTitle},&quot; per {$journalName}. Apprezziamo il tuo contributo nel mantenere alta la qualità della rivista.'),
(124, 'REVIEW_ACK', 'nl', 'Review Bevestiging', 'Bedankt voor uw recensie', '<p>Dear {$recipientName},</p>\n<p>Dank u voor het voltooien van uw beoordeling van de inzending, {$submissionTitle}, voor {$journalName}. We waarderen uw tijd en expertise in het bijdragen aan de kwaliteit van het werk dat we publiceren.</p>\n<p>Het was een genoegen om met u samen te werken als reviewer voor {$journalName}, en we hopen in de toekomst weer met u te kunnen samenwerken.</p>\n<p>Vriendelijke groeten,</p>\n<p>{$signature}</p>'),
(125, 'REVIEW_ACK', 'ru', 'Благодарность за рецензию', 'Благодарим за Вашу рецензию', '<p>Здравствуйте, {$recipientName}!</p>\n<p>Благодарю Вас за рецензирование материала «{$submissionTitle}» для журнала «{$journalName}». Мы ценим Ваш вклад, который способствует повышению качества публикуемых нами работ.</p>\n<p>Нам было очень приятно работать с Вами в качестве рецензента журнала «{$journalName}», и мы надеемся, что в будущем у нас еще будет возможность сотрудничать с Вами.</p>\n<p>С уважением,</p>\n<p>{$signature}</p>'),
(126, 'REVIEW_ACK', 'en', 'Review Acknowledgement', 'Thank you for your review', '<p>Dear {$recipientName},</p>\n<p>Thank you for completing your review of the submission, "{$submissionTitle}", for {$journalName}. We appreciate your time and expertise in contributing to the quality of the work that we publish.</p>\n<p>It has been a pleasure to work with you as a reviewer for {$journalName}, and we hope to have the opportunity to work with you again in the future.</p>\n<p>Kind regards,</p>\n<p>{$signature}</p>'),
(127, 'REVIEW_REMIND', 'de', 'Erinnerung an das Gutachten', 'Eine Erinnerung, Ihr Gutachten bitte abzuschließen', '<p>Sehr geehrte/r {$recipientName},</p><p>nur eine freundliche Erinnerung an unsere Bitte um Ihre Begutachtung der Einreichung "{$submissionTitle}" für die Zeitschrift {$journalName}. Wir haben erwartet, dass wir diese Begutachtung bis zum {$reviewDueDate} erhalten, und würden uns freuen, sie zu bekommen, sobald Sie in der Lage sind, sie vorzubereiten.</p><p>Sie können sich <a href="{$reviewAssignmentUrl}">bei der Zeitschrift anmelden</a> und den Begutachtungsschritten folgen, um die Einreichung zu sehen, Begutachtungsdateien hochzuladen und Ihre Begutachtungskommentare einzureichen.</p><p>Wenn Sie eine Verlängerung der Frist benötigen, kontaktieren Sie mich bitte. Ich freue mich darauf, von Ihnen zu hören.</p><p>Vielen Dank im Voraus und mit freundlichen Grüßen,</p>{$signature}'),
(128, 'REVIEW_REMIND', 'es', 'Recordatorio de la revisión', 'Recordatorio para que complete la revisión', '<p>Estimado/a {$recipientName},</p><p>Esto es solo un amable recordatorio de nuestra solicitud de revisión del artículo "{$submissionTitle}" para {$journalName}. Esperábamos recibir la revisión el {$reviewDueDate}, por lo que nos complacería recibirla tan pronto como sea posible.</p><p>Puede <a href="{$reviewAssignmentUrl}">iniciar sesión en la revista</a> y seguir los pasos de revisión para ver el artículo, cargar archivos de revisión y enviar sus comentarios.</p><p>Si necesita una prórroga en la fecha límite, póngase en contacto con nosotros. Espero tener noticias suyas pronto.</p><p>Muchas gracias y cordiales saludos,</p>{$signature}'),
(129, 'REVIEW_REMIND', 'fr_CA', 'Rappel d''évaluation', 'Un rappel pour vous demander de bien vouloir terminer votre évaluation', '<p>Bonjour {$recipientName},</p><p>Ceci est un petit rappel concernant notre demande d''évaluation de la soumission « {$submissionTitle} » pour la revue {$journalName}. Nous espérions recevoir votre évaluation avant le {$reviewDueDate}. Nous serions heureux de la recevoir dès que possible.</p><p>Vous pouvez vous <a href="{$reviewAssignmentUrl}">connecter au site de la revue</a> et suivre les étapes d''évaluation afin de consulter le texte, soumettre votre fichier d''évaluation ainsi que vos commentaires. </p><p>Si vous avez besoin de plus de temps, contactez moi. Je vous remercie.</p>\n<p>Cordialement</p>{$signature}'),
(130, 'REVIEW_REMIND', 'it', '', 'Promemoria per il completamento di una revisione', '<p>Gentile {$recipientName},</p><p>Ci permettiamo di sottoporre gentilmente alla Sua attenzione un promemoria relativo alla richiesta di revisione della proposta editoriale, "{$submissionTitle}," for {$journalName}. Avremmo necessità di ricevere la sua revisione entro il {$reviewDueDate} e saremmo lieti di conoscere la Sua opinione non appena potrà comunicarcela.</p><p>Le ricordiamo che può <a href="{$reviewAssignmentUrl}">effettuare l''accesso</a> e seguire la procedura di revisione per visualizzare la proposta, per caricare i file di revisione e per inviare i commenti di revisione.</p><p>Qualora necessitasse di una proroga, non esiti a contattarci</p><p>Grazie in anticipo per la preziosa collaborazione, e con i più cordiali saluti,</p>{$signature}'),
(131, 'REVIEW_REMIND', 'nl', 'Herinnering Reviewverzoek', 'Review herinnering', '{$recipientName}:<br /><br />We willen u vriendelijk herinneren aan ons verzoek om de inzending &quot;{$submissionTitle}&quot; voor {$journalName} te reviewen. We verwachtten uw review op {$reviewDueDate}. We stellen het zeer op prijs om de review te ontvangen zodra u in de gelegenheid bent om die uit te voeren.<br /><br />Als u de gebruikersnaam en het wachtwoord van de website van het tijdschrift niet heeft, kunt u deze link gebruiken voor het herstellen van uw wachtwoord (dat samen met uw gebruikersnaam in een e-mail naar u verstuurd wordt). {$passwordLostUrl}<br /><br />URL inzending: {$reviewAssignmentUrl}<br /><br />Wilt u uw beschikbaarheid voor het voltooien van deze voor het werk van het tijdschrift vitale taak bevestigen. Ik kijk uit naar uw reactie.<br /><br />{$signature}');
INSERT INTO `email_templates_default_data` VALUES
(132, 'REVIEW_REMIND', 'ru', 'Напоминание о рецензии', 'Напоминание о необходимости завершить рецензирование', '<p>Здравствуйте, {$recipientName}!</p><p>Это напоминание о нашем запросе Вашей рецензии на материал «{$submissionTitle}» для журнала «{$journalName}». Мы надеялись получить эту рецензию до {$reviewDueDate} и будем рады, если Вы как можно скорее ее подготовите.</p><p>Вы можете <a href="{$reviewAssignmentUrl}">войти в систему</a> и следовать шагам процесса рецензирования: просмотреть материал, загрузить файлы рецензии и отправить Ваши комментарии по рецензии.</p><p>Если Вам нужно продлить срок отправки рецензии, пожалуйста, свяжитесь со мной. Жду вашего ответа.</p><p>Заранее спасибо и с уважением,</p>{$signature}'),
(133, 'REVIEW_REMIND', 'en', 'Review Reminder', 'A reminder to please complete your review', '<p>Dear {$recipientName},</p><p>Just a gentle reminder of our request for your review of the submission, "{$submissionTitle}," for {$journalName}. We were expecting to have this review by {$reviewDueDate} and we would be pleased to receive it as soon as you are able to prepare it.</p><p>You can <a href="{$reviewAssignmentUrl}">login to the journal</a> and follow the review steps to view the submission, upload review files, and submit your review comments.</p><p>If you need an extension of the deadline, please contact me. I look forward to hearing from you.</p><p>Thank you in advance and kind regards,</p>{$signature}'),
(134, 'REVIEW_REMIND_AUTO', 'de', 'Erinnerung an das Gutachten (Automatisiert)', 'Eine Erinnerung, Ihr Gutachten bitte abzuschließen', '<p>Sehr geehrte/r {$recipientName}</p><p>Diese E-Mail ist eine automatische Erinnerung von {$journalName} in Bezug auf unsere Bitte um Ihre Begutachtung der Einreichung "{$submissionTitle}"</p><p>Wir haben Ihr Gutachten bis zum {$reviewDueDate} erwartet und würden uns freuen, es zu erhalten, sobald Sie es vorbereiten können. </p><p>Bitte <a href="{$reviewAssignmentUrl}">melden Sie sich bei der Zeitschrift an</a> und folgen Sie den Begutachtungsschritten, um die Einreichung einzusehen, die Begutachtungsdateien hochzuladen und Ihre Begutachtungskommentare abzugeben.</p><p>Wenn Sie eine Verlängerung der Frist benötigen, setzen Sie sich bitte mit mir in Verbindung. Ich freue mich darauf, von Ihnen zu hören.</p><p>Vielen Dank im Voraus und mit freundlichen Grüßen,</p>{$journalSignature}'),
(135, 'REVIEW_REMIND_AUTO', 'es', 'Recordatorio de revisión (automático)', 'Recordatorio para que complete su revisión', '<p>Estimado/a {$recipientName}:</p><p>Este correo electrónico es un recordatorio automático de {$journalName} en relación con nuestra solicitud de revisión del envío "{$submissionTitle}".</p><p>Esperábamos disponer de esta revisión el {$reviewDueDate} y nos complacería recibirla tan pronto como sea posible.</p><p>Por favor, <a href="{$reviewAssignmentUrl}">inicie sesión en la revista</a> y siga los pasos de revisión para ver el artículo, cargar archivos de revisión y enviar sus comentarios de revisión.</p><p>Si necesita una extensión de la fecha límite, póngase en contacto con nosotros. Espero tener noticias suyas pronto.</p><p>Muchas gracias y saludos cordiales,</p>{$journalSignature}'),
(136, 'REVIEW_REMIND_AUTO', 'fr_CA', 'Rappel automatique d''évaluation', 'Un rappel automatique pour vous demander de bien vouloir terminer votre évaluation', '<p>{$recipientName},</p><p>Ceci est un rappel automatisé concernant notre demande d''évaluation de la soumission « {$submissionTitle} » pour la revue {$journalName}. Puisque nous n''avons pas reçu, comme nous l''espérions, votre évaluation avant le {$reviewDueDate}, ce courriel a été généré et envoyé automatiquement après l''échéance du délai. Nous serions toutefois heureux de recevoir votre évaluation dès que possible.</p><p>S''il vous plait, <a href="{$reviewAssignmentUrl}">connectez-vous à la revue</a> et suivez les étapes d''évaluation afin de consulter le texte et soumettre votre fichier d''évaluation ainsi que vos commentaires.</p><p>Si vous avez besoin d''un délai supplémentaire, n''hésitez pas à me contacter.</p><p>Je vous remercie. <br/>Cordialement, </p>{$journalSignature}'),
(137, 'REVIEW_REMIND_AUTO', 'it', '', 'Promemoria per il completamento di una revisione', '<p>Gentile {$recipientName},</p><p>Questa e-mail è un promemoria automatico da parte di {$journalName} per la richiesta di revisione della proposta editoriale, "{$submissionTitle}".</p><p> Avremmo necessità di ricevere la sua revisione entro il {$reviewDueDate} e saremmo lieti di conoscere la Sua opinione non appena potrà comunicarcela.</p><p>Le ricordiamo che può <a href="{$reviewAssignmentUrl}">effettuare l''accesso</a> e seguire la procedura di revisione per visualizzare la proposta, per caricare i file di revisione e per inviare i commenti di revisione.</p><p>Qualora necessitasse di una proroga, non esiti a contattarci</p><p>Grazie in anticipo per la preziosa collaborazione, e con i più cordiali saluti,</p>{$journalSignature}'),
(138, 'REVIEW_REMIND_AUTO', 'nl', 'Herinnering Reviewverzoek (geautomatiseerd)', 'Geautomatiseerde review herinnering', '{$recipientName}:<br />\n<br />\nWe willen u vriendelijk herinneren aan ons verzoek om de inzending &quot;{$submissionTitle}&quot; voor {$journalName} te reviewen. We verwachtten uw review op {$reviewDueDate}. We stellen het zeer op prijs om de review te ontvangen zodra u in de gelegenheid bent om die uit te voeren.<br />\n<br />\nAls u de gebruikersnaam en het wachtwoord van de website van het tijdschrift niet heeft, kunt u deze link gebruiken voor het herstellen van uw wachtwoord (dat samen met uw gebruikersnaam in een e-mail naar u verstuurd wordt). {$passwordLostUrl}<br />\n<br />\nURL inzending: {$reviewAssignmentUrl}<br />\n<br />\nWilt u uw beschikbaarheid voor het voltooien van deze voor het werk van het tijdschrift vitale taak bevestigen. Ik kijk uit naar uw reactie.<br />\n<br />\n{$journalSignature}'),
(139, 'REVIEW_REMIND_AUTO', 'ru', 'Напоминание о рецензии (автоматическое)', 'Напоминание о необходимости завершить рецензирование', '<p>Здравствуйте, {$recipientName}!</p><p>Это письмо — автоматическое напоминание из журнала «{$journalName}» о нашем запросе Вашей рецензии на материал «{$submissionTitle}».</p><p>Мы ожидали получить Вашу рецензию до {$reviewDueDate} и мы будем рады получить её, если Вы как можно скорее ее подготовите.</p><p>Пожалуйста, <a href="{$reviewAssignmentUrl}">войдите в систему</a> и следуйте шагам процесса рецензирования, чтобы просмотреть материал, загрузить файлы рецензии и отправить Ваши комментарии по рецензии.</p><p>Если Вам нужно продлить срок отправки рецензии, пожалуйста, свяжитесь со мной. Жду вашего ответа.</p><p>Заранее спасибо и с уважением,</p>{$journalSignature}'),
(140, 'REVIEW_REMIND_AUTO', 'en', 'Review Reminder (Automated)', 'A reminder to please complete your review', '<p>Dear {$recipientName}:</p><p>This email is an automated reminder from {$journalName} in regards to our request for your review of the submission, "{$submissionTitle}."</p><p>We were expecting to have this review by {$reviewDueDate} and we would be pleased to receive it as soon as you are able to prepare it.</p><p>Please <a href="{$reviewAssignmentUrl}">login to the journal</a> and follow the review steps to view the submission, upload review files, and submit your review comments.</p><p>If you need an extension of the deadline, please contact me. I look forward to hearing from you.</p><p>Thank you in advance and kind regards,</p>{$journalSignature}'),
(141, 'REVIEW_COMPLETE', 'de', 'Gutachten abgeschlossen', 'Gutachten abgeschlossen: {$reviewerName} empfiehlt {$reviewRecommendation} für #{$submissionId} {$authorsShort} - {$submissionTitle}', '<p>Sehr geehrte/r {$recipientName},</p><p>{$reviewerName} hat die folgende Überprüfung abgeschlossen:</p><p><a href="{$submissionUrl}">#{$submissionId} {$authorsShort} — {$submissionTitle}</a><br /><b>Empfehlung:</b> {$reviewRecommendation}<br /><b>Gutachtenmethode:</b> {$reviewMethod}</p><p>Melden Sie sich an, um <a href="{$submissionUrl}">alle Dateien und Kommentare</a> dieses Gutachters/dieser Gutachterin zu sehen.</p>'),
(142, 'REVIEW_COMPLETE', 'es', 'Revisión finalizada', 'Revisión completada: {$reviewerName} recomienda {$reviewRecommendation} para #{$submissionId} {$authorsShort} — {$submissionTitle}', ''),
(143, 'REVIEW_COMPLETE', 'fr_CA', 'Évaluation terminée', 'Évaluation terminée: {$reviewerName} recommande {$reviewRecommendation} pour #{$submissionId} {$authorsShort} — {$submissionTitle}', '<p>{$recipientName},</p><p>{$reviewerName} a terminé son évaluation :</p><p><a href="{$submissionUrl}">#{$submissionId} {$authorsShort} — {$submissionTitle}</a><br /><b>Recommandation :</b> {$reviewRecommendation}<br /><b>Type :</b> {$reviewMethod}</p><p>Connectez-vous <a href="{$submissionUrl}">afin de consulter les commentaires</a> de l''évaluateur-trice.</p>'),
(144, 'REVIEW_COMPLETE', 'it', '', '', ''),
(145, 'REVIEW_COMPLETE', 'nl', 'Review Voltooid', 'Beoordeling voltooid: {$reviewerName} beveelt {$reviewRecommendation} aan voor #{$submissionId} {$authorsShort} — {$submissionTitle}', '<p>Beste {$recipientName},</p><p>{$reviewerName} heeft de volgende beoordeling voltooid:</p><p><a href="{$submissionUrl}">#{$submissionId} {$authorsShort} — {$submissionTitle}</a><br /><b>Aanbeveling:</b> {$reviewRecommendation}<br /><b>Type:</b> {$reviewMethod}</p><p>Log in om <a href="{$submissionUrl}">alle bestanden en opmerkingen</a> te bekijken die door deze beoordelaar zijn verstrekt.</p>'),
(146, 'REVIEW_COMPLETE', 'ru', 'Рецензия завершена', 'Рецензирование завершено: {$reviewerName} рекомендует {$reviewRecommendation} для #{$submissionId} {$authorsShort} — «{$submissionTitle}»', '<p>Здравствуйте, {$recipientName}!</p><p>Рецензент {$reviewerName} завершил следующую рецензию:</p><p><a href="{$submissionUrl}">#{$submissionId} {$authorsShort} — «{$submissionTitle}»</a><br /><b>Рекомендация:</b> {$reviewRecommendation}<br /><b>Тип:</b> {$reviewMethod}</p><p>Войдите в систему, чтобы <a href="{$submissionUrl}">просмотреть все файлы и комментарии</a>, предоставленные этим рецензентом.</p>'),
(147, 'REVIEW_COMPLETE', 'en', 'Review Completed', 'Review complete: {$reviewerName} recommends {$reviewRecommendation} for #{$submissionId} {$authorsShort} — "{$submissionTitle}"', '<p>Dear {$recipientName},</p><p>{$reviewerName} completed the following review:</p><p><a href="{$submissionUrl}">#{$submissionId} {$authorsShort} — "{$submissionTitle}"</a><br /><b>Recommendation:</b> {$reviewRecommendation}<br /><b>Type:</b> {$reviewMethod}</p><p>Login to <a href="{$submissionUrl}">view all files and comments</a> provided by this reviewer.</p>'),
(148, 'REVIEW_EDIT', 'de', 'Gutachten bearbeitet', 'Ihre Zuweisung für ein Gutachten für {$journalName} wurde geändert', '<p>Sehr geehrte/r {$recipientName},</p><p>Ein Redakteur/eine Redakteurin hat Änderungen an Ihrer Überprüfungsaufgabe für {$journalName} vorgenommen. Bitte überprüfen Sie die folgenden Details und lassen Sie uns wissen, wenn Sie Fragen haben.</p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a><br /><b>Gutachtenmethode:</b> {$reviewMethod}<br /><b>Annehmen oder Ablehnen bis:</b> {$responseDueDate}<br /><b>Gutachteneinreichung bis:</b> {$reviewDueDate}</p><p>Sie können sich jederzeit anmelden, um <a href="{$reviewAssignmentUrl}">diese Überprüfung abzuschließen</a>.</p>'),
(149, 'REVIEW_EDIT', 'es', 'Revisión editada', 'Se ha modificado su asignación de revisión para {$journalName}', ''),
(150, 'REVIEW_EDIT', 'fr_CA', '', '', '<p>{$recipientName},</p><p>Un-e rédacteur-trice a modifié l''assignation de votre évaluation pour {$journalName}. S''il vous plaît, consulter les détails ci-dessous et n''hésitez pas à nous contacter si vous avez des questions.</p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a><br /><b>Type :</b> {$reviewMethod}<br /><b>Accepté ou rejeté avant le :</b> {$responseDueDate}<br /><b>Évaluation soumise avant le :</b> {$reviewDueDate}</p><p>Vous pouvez vous connectez afin de <a href="{$reviewAssignmentUrl}">terminer cette évaluation</a>.</p>'),
(151, 'REVIEW_EDIT', 'it', '', '', ''),
(152, 'REVIEW_EDIT', 'nl', 'Review aangepast', 'Je beoordelingsopdracht is gewijzigd voor {$journalName}', '<p>Beste {$recipientName},</p><p>Een redacteur heeft wijzigingen aangebracht in je beoordelingsopdracht voor {$journalName}. Bekijk alsjeblieft de details hieronder en laat het ons weten als je vragen hebt.</p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a><br /><b>Type:</b> {$reviewMethod}<br /><b>Accepteer of Wijs Af Voor:</b> {$responseDueDate}<br /><b>Beoordeling Indienen Voor:</b> {$reviewDueDate}</p><p>Je kunt inloggen om <a href="{$reviewAssignmentUrl}">deze beoordeling te voltooien</a> op elk gewenst moment.</p>'),
(153, 'REVIEW_EDIT', 'ru', 'Рецензия отредактирована', 'Изменилось Ваше задание на рецензию для журнала «{$journalName}»', '<p>Здравствуйте, {$recipientName}!</p><p>Редактор изменил Ваше задание на рецензирование для журнала «{$journalName}». Пожалуйста, ознакомьтесь с приведенной ниже информацией и сообщите нам, если у Вас возникнут вопросы.</p><p><a href="{$reviewAssignmentUrl}">{$submissionTitle}</a><br /><b>Тип:</b> {$reviewMethod}<br /><b>Принять или отклонить до:</b> {$responseDueDate}<br /><b>Отправить рецензию до:</b> {$reviewDueDate}</p><p>Вы можете войти в систему, чтобы <a href="{$reviewAssignmentUrl}">выполнить эту рецензию</a> в любой момент.</p>'),
(154, 'REVIEW_EDIT', 'en', 'Review Edited', 'Your review assignment has been changed for {$journalName}', '<p>Dear {$recipientName},</p><p>An editor has made changes to your review assignment for {$journalName}. Please review the details below and let us know if you have any questions.</p><p><a href="{$reviewAssignmentUrl}">"{$submissionTitle}"</a><br /><b>Type:</b> {$reviewMethod}<br /><b>Accept or Decline By:</b> {$responseDueDate}<br /><b>Submit Review By:</b> {$reviewDueDate}</p><p>You can login to <a href="{$reviewAssignmentUrl}">complete this review</a> at any time.</p>'),
(155, 'EDITOR_DECISION_ACCEPT', 'de', 'Einreichung akzeptiert', 'Ihre Einreichung wurde bei {$journalName} angenommen', '<p>Sehr geehrte/r {$recipientName},</p><p>ich freue mich, Ihnen mitteilen zu können, dass wir beschlossen haben, Ihre Einreichung ohne weitere Überarbeitung zu akzeptieren. Nach sorgfältiger Prüfung haben wir festgestellt, dass Ihr Beitrag {$submissionTitle} unsere Erwartungen erfüllt oder sogar übertrifft. Wir freuen uns, Ihren Beitrag in {$journalName} zu veröffentlichen, und danken Ihnen, dass Sie unsere Zeitschrift als Ort für Ihre Arbeit gewählt haben.</p><p>Ihr Beitrag wird nun in einer zukünftigen Ausgabe von {$journalName} erscheinen, und Sie können ihn gerne in Ihre Liste der Veröffentlichungen aufnehmen. Wir erkennen die harte Arbeit an, die in jeder erfolgreichen Einreichung steckt, und wir möchten Ihnen dazu gratulieren, dass Sie dieses Stadium erreicht haben.</p><p>Ihre Einreichung wird nun redaktionell bearbeitet und formatiert, um sie für die Veröffentlichung vorzubereiten.</p><p>Sie werden in Kürze weitere Anweisungen erhalten.</p><p>Wenn Sie Fragen haben, kontaktieren Sie mich bitte über Ihr <a href="{$authorSubmissionUrl}">Einreichungs-Dashboard</a>.</p><p>Mit freundlichen Grüßen,</p>{$signature}'),
(156, 'EDITOR_DECISION_ACCEPT', 'es', 'Envío aceptado', 'Su envío a {$journalName} ha sido aceptado', '<p>Estimado/a {$recipientName},</p><p>Nos complace informarle de que hemos decidido aceptar su envío sin necesidad de realizar más revisiones. Tras una minuciosa revisión le confirmamos que su artículo "{$submissionTitle}" cumple o supera nuestras expectativas. Estamos entusiasmados por publicar su trabajo en {$journalName} y le agradecemos que haya elegido nuestra revista como hogar de su obra.</p><p>Su envío se publicará en un número futuro de {$journalName}, le invitamos a incluirlo en su lista de publicaciones. Reconocemos el arduo trabajo que conlleva cada envío exitoso, así que queremos felicitarlo por haber alcanzado esta fase.</p><p>Ahora su envío será sometido a edición y formateo para prepararlo para su publicación.</p><p>Pronto recibirá más instrucciones.</p><p>Si tiene alguna pregunta, póngase en contacto con nosotros a través del <a href="{$authorSubmissionUrl}">panel de envío</a>.</p><p>Atentamente,</p>{$signature}'),
(157, 'EDITOR_DECISION_ACCEPT', 'fr_CA', 'Soumission acceptée', 'Votre soumission a été acceptée dans la revue {$journalName}', '<p>Bonjour {$authors},</p><p>Nous avons pris une décision concernant votre soumission « {$submissionTitle} » à la revue {$journalName}.</p><p>Notre décision est d''accepter votre soumission.</p><p>Cordialement,</p>{$signature}'),
(158, 'EDITOR_DECISION_ACCEPT', 'it', '', 'La Sua proposta è stata accettata per la pubblicazione su {$journalName}', '<p>Gentile {$recipientName},</p><p>Siamo lieti di comunicarLe che la Sua proposta editoriale è stata ritenuta idonea alla pubblicazione senza necessità di ulteriori revisioni. Dopo attenta valutazione, abbiamo infatti rinvenuto che la Sua proposta, {$submissionTitle}, soddisfi pienamente le nostre aspettative. Siamo pertanto entusiasti di poter pubblicare il Suo lavoro su {$journalName} e La ringraziamo per aver scelto la nostra rivista come sede di pubblicazione.</p><p>Il contributo sarà dunque pubblicato in un futuro numero di {$journalName} e La preghiamo di considerare tale e-mail come conferma. Siamo consapevoli dell''impegnativo lavoro necessario ai fini di ogni proposta editoriale di successo e pertanto desideriamo complimentarci per aver ottenuto tale risultato .</p><p>Il Suo contributo sarà ora sottoposto a un processo di copy-editing e sarà formattato ai fini della pubblicazione.</p><p>Riceverà entro breve, a tal proposito, ulteriori indicazioni.</p><p>In caso di necessità o quesiti, non esiti a contattarci tramite la Sua area di<a href="{$authorSubmissionUrl}">gestione delle proposte</a>.</p><p>Con i più cordiali saluti,</p>{$signature}'),
(159, 'EDITOR_DECISION_ACCEPT', 'nl', 'Inzending Geaccepteerd', 'Redacteursbeslissing', '{$authors}:<br />\n<br />\nWe hebben een beslissing genomen over uw inzending voor {$journalName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nOnze beslissing is: Accepteer inzending'),
(160, 'EDITOR_DECISION_ACCEPT', 'ru', 'Материал принят', 'Ваш материал был принят в «{$journalName}»', '<p>Здравствуйте, {$recipientName}!</p><p> Хочу Вам с радостью сообщить, что мы решили принять Ваш материал без дополнительной доработки. После тщательного рецензирования мы полагаем, что Ваш материал «{$submissionTitle}» соответствует или превосходит наши ожидания. Мы с удовольствием опубликуем его в «{$journalName}» и благодарим Вас за выбор нашего журнала для публикации.</p><p>Ваш материал будет опубликован в одном из будущих выпусков журнала «{$journalName}» и Вы сможете включить его в список своих публикаций. Мы понимаем, что каждый успешный материал — это тяжелая работа, и хотим поздравить Вас с достижением этого этапа.</p><p>Далее Ваш материал пройдёт этапы литературного редактирования и вёрстки, чтобы подготовить его к публикации.</p><p>Вскоре Вы получите дальнейшие инструкции.</p><p>Если у Вас есть какие-то вопросы, пожалуйста, свяжитесь со мной через <a href="{$authorSubmissionUrl}">страницу Вашего материала</a>.</p><p>С уважением,</p>{$signature}'),
(161, 'EDITOR_DECISION_ACCEPT', 'en', 'Submission Accepted', 'Your submission has been accepted to {$journalName}', '<p>Dear {$recipientName},</p><p>I am pleased to inform you that we have decided to accept your submission without further revision. After careful review, we found your submission, {$submissionTitle}, to meet or exceed our expectations. We are excited to publish your piece in {$journalName} and we thank you for choosing our journal as a venue for your work.</p><p>Your submission is now forthcoming in a future issue of {$journalName} and you are welcome to include it in your list of publications. We recognize the hard work that goes into every successful submission and we want to congratulate you on reaching this stage.</p><p>Your submission will now undergo copy editing and formatting to prepare it for publication.</p><p>You will shortly receive further instructions.</p><p>If you have any questions, please contact me from your <a href="{$authorSubmissionUrl}">submission dashboard</a>.</p><p>Kind regards,</p>{$signature}'),
(162, 'EDITOR_DECISION_SEND_TO_EXTERNAL', 'de', 'Zur Begutachtung geschickt', 'Ihr Beitrag wurde zur Überprüfung gesendet', '<p>Sehr geehrte/r {$recipientName},</p><p>Ich freue mich, Ihnen mitzuteilen, dass ein Redakteur/eine Redakteurin Ihre Einreichung {$submissionTitle} begutachtet hat und beschlossen hat, sie zur Begutachtung zu schicken. Ein Redakteur/eine Redakteurin wird qualifizierte Gutachter/Gutachterinnen benennen, die ein Feedback zu Ihrer Einreichung geben werden.</p><p>{$reviewTypeDescription} Sie erhalten von uns eine Rückmeldung von den Gutachter/Gutachterinnen und Informationen über die nächsten Schritte.</p><p>Bitte beachten Sie, dass die Einsendung des Beitrags zur Begutachtung keine Garantie dafür ist, dass er veröffentlicht wird. Wir werden die Empfehlungen der Gutachter/innen berücksichtigen, bevor wir entscheiden, ob der Beitrag zur Veröffentlichung angenommen wird. Es kann sein, dass Sie aufgefordert werden, den Beitrag zu überarbeiten und auf die Kommentare der Gutachter/innen zu antworten, bevor eine endgültige Entscheidung getroffen wird.</p><p>Wenn Sie Fragen haben, wenden Sie sich bitte über das Dashboard Ihres Beitrags an mich.</p><p>{$signature}</p>'),
(163, 'EDITOR_DECISION_SEND_TO_EXTERNAL', 'es', 'Enviar a revisión', 'Su envío se ha enviado a revisión', '<p>Estimado/a {$recipientName},</p><p>Me complace anunciarle que un editor/a ha revisado su envío, {$submissionTitle}, y ha decidido remitirlo a evaluación por pares. El editor/a identificará a revisores/as cualificados que aportarán comentarios sobre su envío.</p><p>{$reviewTypeDescription} Le enviaremos dichos comentarios y la información acerca de los próximos pasos.</p><p>Tenga en cuenta que el hecho de enviar su artículo a evaluación por pares no garantiza que se acabe publicando. Consideraremos las recomendaciones de los revisores/as antes de decidir si aceptamos el envío para publicarse. Podríamos solicitarle que haga revisiones y responda a los comentarios de los revisores/as antes de tomar la decisión final.</p><p>Si tiene cualquier duda puede contactar con nosotros desde su panel de control del envío.</p><p>{$signature}</p>'),
(164, 'EDITOR_DECISION_SEND_TO_EXTERNAL', 'fr_CA', 'Envoyé à l''évaluation', 'Votre manuscrit a été envoyé en évaluation', '<p>{$recipientName},</p><p>Nous sommes heureux de vous annoncer qu''un-e redacteur-trice à évaluer votre manuscrit, {$submissionTitle}, et a décidé de l''envoyer en évaluation. Un-e redacteur-trice identifiera des évaluateurs-trices qui feront des commentaires sur votre manuscrit.</p><p>{$reviewTypeDescription} Nous vous ferons part de leurs commentaires et vous informerons des prochaines étapes par la suite.</p><p>S''il vous plait, prenez en considération que le fait d''envoyer votre manuscrit en évaluation ne garantit en rien le fait d''être publié. Nous prendrons en considération les recommandations des évaluateurs avant de décider de publier votre manuscrit.</p><p>Si vous avez des questions, vous pouvez nous contacter à partir de votre <a href="{$authorSubmissionUrl}">tableau de bord de soumission</a>.</p><p>{$signature}</p>'),
(165, 'EDITOR_DECISION_SEND_TO_EXTERNAL', 'it', '', 'Decisione dell''editor', 'Gentilissimo {$authors}:<br />\n<br />\nAbbiamo preso una decisione circa la tua proposta a {$journalName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nLa nostra decisione: invio a un revisore esterno<br />\n<br />\nSubmission URL: {$submissionUrl}'),
(166, 'EDITOR_DECISION_SEND_TO_EXTERNAL', 'nl', 'Verzonden naar Review', 'Redacteursbeslissing', '<p>Beste {$recipientName},</p>\n<p>Ik ben verheugd u mee te delen dat een redacteur uw inzending, {$submissionTitle}, heeft beoordeeld en heeft besloten deze naar peer review te sturen. Een redacteur zal gekwalificeerde beoordelaars identificeren die feedback zullen geven op uw inzending.</p>\n<p>{$reviewTypeDescription} U zult van ons horen met feedback van de beoordelaars en informatie over de volgende stappen.</p>\n<p>Houd er rekening mee dat het verzenden van de inzending naar peer review niet garandeert dat deze zal worden gepubliceerd. We zullen de aanbevelingen van de beoordelaars overwegen voordat we beslissen om de inzending te accepteren voor publicatie. Het kan zijn dat u gevraagd wordt om wijzigingen aan te brengen en te reageren op de opmerkingen van de beoordelaars voordat er een definitieve beslissing wordt genomen.</p>\n<p>Als u vragen heeft, neem dan contact met mij op via uw inzending dashboard.</p>\n<p>{$signature}</p>'),
(167, 'EDITOR_DECISION_SEND_TO_EXTERNAL', 'ru', 'Отправка на рецензию', 'Ваш материал был отправлен на рецензию', '<p>Здравствуйте, {$recipientName}!</p><p>Рады сообщить вам, что редактор рассмотрел Ваш материал «{$submissionTitle}» и решил отправить его на рецензирование. Редактор определит квалифицированных рецензентов, которые предоставят рецензии на Вашу работу.</p><p>{$reviewTypeDescription} Вы получите от нас сообщение с отзывами рецензентов и информацией о дальнейших шагах.</p><p>Обратите внимание, что отправка материала на рецензирование не гарантирует его публикацию. Мы рассмотрим рекомендации рецензентов, прежде чем примем решение о принятии материала к публикации. Вам может быть предложено внести изменения в матери ал и ответить на комментарии рецензентов, прежде чем будет принято окончательное решение.</p><p>Если у вас есть какие-либо вопросы, пожалуйста, свяжитесь со мной через страницу Вашего материала.</p><p>{$signature}</p>'),
(168, 'EDITOR_DECISION_SEND_TO_EXTERNAL', 'en', 'Sent to Review', 'Your submission has been sent for review', '<p>Dear {$recipientName},</p><p>I am pleased to inform you that an editor has reviewed your submission, "{$submissionTitle}", and has decided to send it for peer review. An editor will identify qualified reviewers who will provide feedback on your submission.</p><p>{$reviewTypeDescription} You will hear from us with feedback from the reviewers and information about the next steps.</p><p>Please note that sending the submission to peer review does not guarantee that it will be published. We will consider the reviewers'' recommendations before deciding to accept the submission for publication. You may be asked to make revisions and respond to the reviewers'' comments before a final decision is made.</p><p>If you have any questions, please contact me from your submission dashboard.</p><p>{$signature}</p>'),
(169, 'EDITOR_DECISION_SEND_TO_PRODUCTION', 'de', 'In die Produktion geschickt', 'Nächste Schritte zur Veröffentlichung Ihres Beitrags', '<p>Sehr geehrte/r {$recipientName},</p><p>ich schreibe Ihnen von {$journalName}, um Ihnen mitzuteilen, dass die Bearbeitung Ihrer Einreichung {$submissionTitle} abgeschlossen ist. Ihre Einreichung geht nun in die Produktionsphase über, in der die endgültigen Druckfahnen für die Veröffentlichung vorbereitet werden. Wir werden uns mit Ihnen in Verbindung setzen, wenn wir weitere Unterstützung benötigen.</p><p>Wenn Sie Fragen haben, kontaktieren Sie mich bitte über das <a href="{$authorSubmissionUrl}">Dashboard Ihrer Einreichung</a>.</p><p>Mit freundlichen Grüßen,</p>{$signature}'),
(170, 'EDITOR_DECISION_SEND_TO_PRODUCTION', 'es', 'Enviar a producción', 'Próximos pasos para publicar su envío', '<p>Estimado/a {$recipientName},</p><p>Le escribo de {$journalName} para informarle de que la edición de su envío, {$submissionTitle}, ha finalizado. Ahora su envío avanzará a la fase de producción, donde prepararemos las galeradas finales para su publicación. Nos pondremos en contacto con usted si necesitamos más ayuda.</p><p>Si tiene cualquier duda contacte con nosotros desde su <a href="{$authorSubmissionUrl}">panel de control del envío</a>.</p><p>Saludos cordiales,</p>{$signature}'),
(171, 'EDITOR_DECISION_SEND_TO_PRODUCTION', 'fr_CA', 'Envoyé en production', 'Décision du rédacteur', '<p>{$recipientName},</p><p>Je vous écris de la part de {$journalName} afin de vous confirmer que la révision de votre soumission, {$submissionTitle}, est terminée. Votre soumission sera envoyée à l''étape de production, nous procéderons à la mise en page avant publication. Nous vous contacterons au besoin.</p><p>Si vous avez des questions, vous pouvez nous rejoindre à partir du <a href="{$authorSubmissionUrl}">tableau de bord de votre soumission</a>.</p><p>Cordialement,</p>{$signature}'),
(172, 'EDITOR_DECISION_SEND_TO_PRODUCTION', 'it', '', 'Decisione dell''editor', 'Gentilissimo {$authors}:<br />\n<br />\nLa lavorazione editoriale della sua proposta, &quot;{$submissionTitle},&quot; è completa.  Ora viene preparata per l''uscita sulla rivista.<br />\n<br />\nURL proposta: {$submissionUrl}'),
(173, 'EDITOR_DECISION_SEND_TO_PRODUCTION', 'nl', 'Verzonden naar Productie', 'Volgende stappen voor het publiceren van uw inzending', '<p>Beste {$recipientName},</p>\n<p>Ik schrijf u namens {$journalName} om u te laten weten dat de bewerking van uw inzending, {$submissionTitle}, is voltooid. Uw inzending gaat nu naar de productiefase, waar de definitieve drukproeven zullen worden voorbereid voor publicatie. We nemen contact met u op als we verdere hulp nodig hebben.</p>\n<p>Als u vragen heeft, neem dan contact met mij op via uw <a href="{$authorSubmissionUrl}">inzending dashboard</a>.</p>\n<p>Met vriendelijke groet,</p>\n<p>{$signature}</p>'),
(174, 'EDITOR_DECISION_SEND_TO_PRODUCTION', 'ru', 'Отправка на подготовку к публикации', 'Следующие шаги для публикации Вашего материала', '<p>Здравствуйте, {$recipientName}!</p><p>Пишу Вам от имени журнала «{$journalName}» и хочу сообщить, что редактирование Вашего материала «{$submissionTitle}» завершено. Ваш материал далее переходит на этап публикации, где будут подготовлены финальные гранки Вашего материала. Мы свяжемся с Вами, если нам потребуется Ваша помощь.</p><p>Если у Вас есть какие-то вопросы, пожалуйста, свяжитесь со мной через <a href="{$authorSubmissionUrl}">страницу Вашего материала</a>.</p><p>С уважением,</p>{$signature}'),
(175, 'EDITOR_DECISION_SEND_TO_PRODUCTION', 'en', 'Sent to Production', 'Next steps for publishing your submission', '<p>Dear {$recipientName},</p><p>I am writing from {$journalName} to let you know that the editing of your submission, "{$submissionTitle}", is complete. Your submission will now advance to the production stage, where the final galleys will be prepared for publication. We will contact you if we need any further assistance.</p><p>If you have any questions, please contact me from your <a href="{$authorSubmissionUrl}">submission dashboard</a>.</p><p>Kind regards,</p>{$signature}'),
(176, 'EDITOR_DECISION_REVISIONS', 'de', 'Überarbeitungen angefordert', 'Ihr Beitrag wurde geprüft. Bitte reichen Sie Überarbeitungen ein', '<p>Sehr geehrte/r {$recipientName},</p><p>Ihre Einreichung {$submissionTitle} wurde begutachtet und wir möchten Sie auffordern, Überarbeitungen einzureichen, die auf die Kommentare der Gutachter/innen eingehen. Ein Redakteur/eine Redakteurin wird diese Überarbeitungen prüfen, und wenn sie die Bedenken hinreichend berücksichtigen, kann Ihr Beitrag zur Veröffentlichung angenommen werden.</p><p>Die Kommentare der Gutachter/innen sind am Ende dieser E-Mail enthalten. Bitte gehen Sie auf jeden Punkt in den Kommentaren der Reviewer ein und geben Sie an, welche Änderungen Sie vorgenommen haben. Wenn Sie einen der Kommentare für ungerechtfertigt oder unangemessen halten, erläutern Sie bitte Ihren Standpunkt.</p><p>Wenn Sie Ihre Überarbeitungen abgeschlossen haben, können Sie die überarbeiteten Dokumente zusammen mit Ihrer Antwort auf die Kommentare der Prüfer im <a href=„{$authorSubmissionUrl}“>Dashboard Ihrer Einreichung</a> hochladen. Wenn Sie abgemeldet waren, können Sie sich erneut mit dem Benutzernamen {$recipientUsername} anmelden.</p><p>Wenn Sie Fragen haben, kontaktieren Sie mich bitte über das <a href=„{$authorSubmissionUrl}“>Dashboard Ihrer Einreichung</a>.</p><p>Wir freuen uns auf Ihre überarbeitete Eingabe.</p><p>Mit freundlichen Grüßen,</p>{$signature}<hr><p>Die folgenden Kommentare wurden von den Gutachter/innen abgegeben.</p>{$allReviewerComments}'),
(177, 'EDITOR_DECISION_REVISIONS', 'es', 'Revisiones solicitadas', 'Su envío se ha revisado y le animamos a que tramite sus revisiones', '<p>Estimado/a {$recipientName},</p><p>Su envío {$submissionTitle} ha sido revisado y nos gustaría animarlo a que nos remita las revisiones que respondan a los comentarios de los revisores/as. Un editor/a examinará dichas revisiones y, si resuelven adecuadamente los problemas, su envío podrá ser aceptado para publicarse.</p><p>Los comentarios de los revisores/as se incluyen al final de este correo electrónico. Responda a cada uno de los punto de los comentarios de los revisores/as e identifique los cambios que haya hecho. Si considera que alguno de los comentarios de los revisores/as no está justificado o es inapropiado, explíquenos su punto de vista.</p><p>Cuando haya completado las revisiones puede cargar los documentos revisados, junto con la respuesta a los comentarios de los revisores/as, en su <a href="{$authorSubmissionUrl}">panel de control del envío</a>. Si ha cerrado la sesión puede volver a iniciarla con su nombre de usuario/a {$recipientUsername}.</p><p>Si tiene cualquier pregunta no dude en contactarnos desde su <a href="{$authorSubmissionUrl}">panel de control del envío</a>.</p><p>Quedamos a la espera de recibir su envío revisado.</p><p>Saludos cordiales,</p>{$signature}<hr><p>Se recibieron los siguientes comentarios de los revisores/as.</p>{$allReviewerComments}'),
(178, 'EDITOR_DECISION_REVISIONS', 'fr_CA', 'Révisions demandées', 'Décision du rédacteur', '{$authors},<br />\n<br />\nNous avons pris une décision concernant votre soumission « {$submissionTitle} » à la revue {$journalName}.<br />\n<br />\nNotre décision est de vous demander d''apporter des révisions à votre soumission.'),
(179, 'EDITOR_DECISION_REVISIONS', 'it', '', 'Decisione dell''editor', '&lt;![CDATA[{$authors}:<br />\n<br />\nAbbiamo raggiunto una decisione sulla Sua proposta a {$journalName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nLa nostra decisione: è necessaria ciclo di peer-review'),
(180, 'EDITOR_DECISION_REVISIONS', 'nl', 'Revisies Gevraagd', 'Uw inzending is beoordeeld en we moedigen u aan om herzieningen in te dienen', '<p>Beste {$recipientName},</p>\n<p>Uw inzending {$submissionTitle} is beoordeeld en we willen u aanmoedigen om herzieningen in te dienen die de opmerkingen van de beoordelaars adresseren. Een redacteur zal deze herzieningen bekijken en als ze de zorgen adequaat aanpakken, kan uw inzending worden geaccepteerd voor publicatie.</p>\n<p>De opmerkingen van de beoordelaars zijn onderaan deze e-mail opgenomen. Graag ontvangen wij uw reactie op elk punt in de opmerkingen van de beoordelaars en geef aan welke wijzigingen u heeft aangebracht. Als u van mening bent dat bepaalde opmerkingen van de beoordelaars ongegrond of ongepast zijn, licht dan alstublieft uw perspectief toe.</p>\n<p>Wanneer u uw herzieningen heeft voltooid, kunt u de herziene documenten samen met uw reactie op de opmerkingen van de beoordelaars uploaden via uw <a href="{$authorSubmissionUrl}">inzending dashboard</a>. Indien u bent uitgelogd, kunt u opnieuw inloggen met de gebruikersnaam {$recipientUsername}.</p>\n<p>Als u vragen heeft, neem dan contact met mij op via uw <a href="{$authorSubmissionUrl}">inzending dashboard</a>.</p>\n<p>Wij kijken uit naar ontvangst van uw herziene inzending.</p>\n<p>Met vriendelijke groet,</p>\n{$signature}<hr>\n<p>De volgende opmerkingen zijn ontvangen van de beoordelaars.</p>\n{$allReviewerComments}'),
(181, 'EDITOR_DECISION_REVISIONS', 'ru', 'Требуются изменения', 'Ваш материал был отрецензирован и мы предлагаем Вам прислать его откорректированную версию', '<p>Здравствуйте, {$recipientName}!</p><p>Ваш материал «{$submissionTitle}» был отрецензирован и мы хотели бы предложить Вам внести изменения, учитывающие замечания рецензентов. Редактор рассмотрит эти правки, и если они адекватно устранят замечания рецензентов, Ваша работа может быть принята к публикации.</p><p>Комментарии рецензентов приведены в конце этого письма. Пожалуйста, ответьте на каждый пункт замечаний рецензентов и укажите, какие изменения Вы внесли. Если Вы считаете какие-либо замечания рецензента необоснованными или неуместными, объясните свою точку зрения.</p><p>Когда Вы завершите внесение правок, загрузите изменённые документы вместе с ответами на замечания рецензентов на <a href="{$authorSubmissionUrl}"> странице Вашего материала</a>. Если Вы вышли из системы, Вы можете снова войти в нее с именем пользователя {$recipientUsername}.</p><p>Если у Вас есть какие-то вопросы, пожалуйста, свяжитесь со мной через <a href="{$authorSubmissionUrl}">страницу Вашего материала</a>.</p><p>Мы с нетерпением ждем получения Вашего доработанного материала.</p><p>С уважением,</p>{$signature}<hr><p>Следующие комментарии были получены от рецензентов.</p>{$allReviewerComments}'),
(182, 'EDITOR_DECISION_REVISIONS', 'en', 'Revisions Requested', 'Your submission has been reviewed and we encourage you to submit revisions', '<p>Dear {$recipientName},</p><p>Your submission "{$submissionTitle}" has been reviewed and we would like to encourage you to submit revisions that address the reviewers'' comments. An editor will review these revisions and if they address the concerns adequately, your submission may be accepted for publication.</p><p>The reviewers'' comments are included at the bottom of this email. Please respond to each point in the reviewers'' comments and identify what changes you have made. If you find any of the reviewer''s comments to be unjustified or inappropriate, please explain your perspective.</p><p>When you have completed your revisions, you can upload revised documents along with your response to the reviewers'' comments at your <a href="{$authorSubmissionUrl}">submission dashboard</a>. If you have been logged out, you can login again with the username {$recipientUsername}.</p><p>If you have any questions, please contact me from your <a href="{$authorSubmissionUrl}">submission dashboard</a>.</p><p>We look forward to receiving your revised submission.</p><p>Kind regards,</p>{$signature}<hr><p>The following comments were received from reviewers.</p>{$allReviewerComments}'),
(183, 'EDITOR_DECISION_RESUBMIT', 'de', 'Erneut für die Begutachtung vorlegen', 'Ihr Beitrag wurde geprüft - bitte überarbeiten Sie ihn und reichen Sie ihn erneut ein', '<p>Sehr geehrte/r {$recipientName},</p><p>Nach Durchsicht Ihrer Einreichung {$submissionTitle} haben die Gutachter/innen empfohlen, dass Ihre Einreichung in der vorliegenden Form nicht zur Veröffentlichung angenommen werden kann. Wir möchten Sie jedoch ermutigen, eine überarbeitete Version einzureichen, die auf die Kommentare der Gutachter/innen eingeht. Ihre überarbeitete Fassung wird von einem Redakteur/einer Redaktion geprüft und möglicherweise zu einer weiteren Begutachtungsrunde weitergeleitet.</p><p>Bitte beachten Sie, dass die erneute Einreichung Ihrer Arbeit keine Garantie dafür ist, dass sie angenommen wird.</p><p>Die Kommentare der Gutachter/innen sind am Ende dieser E-Mail enthalten. Bitte gehen Sie auf jeden Punkt ein und geben Sie an, welche Änderungen Sie vorgenommen haben. Wenn Sie einen der Kommentare für unangemessen halten, erläutern Sie bitte Ihren Standpunkt. Wenn Sie Fragen zu den Empfehlungen im Bericht haben, geben Sie diese bitte in Ihrer Antwort an.</p><p>Wenn Sie Ihre Überarbeitungen abgeschlossen haben, können Sie die überarbeiteten Dokumente zusammen mit Ihrer Antwort auf die Kommentare der Gutachter/innen im <a href="{$authorSubmissionUrl}">Dashboard Ihrer Einreichung</a> hochladen.Wenn Sie abgemeldet waren, können Sie sich erneut mit dem Benutzernamen {$recipientUsername} anmelden.</p><p>Wenn Sie Fragen haben, kontaktieren Sie mich bitte über das <a href=„{$authorSubmissionUrl}“>Dashboard Ihrer Einreichung</a>.</p><p>Wir freuen uns auf Ihre überarbeitete Eingabe.</p><p>Mit freundlichen Grüßen,</p>{$signature}<hr><p>Die folgenden Kommentare wurden von den Gutachter/innen abgegeben.</p>{$allReviewerComments}'),
(184, 'EDITOR_DECISION_RESUBMIT', 'es', 'Reenviar para revisión', 'Se ha revisado su envío. Por favor, revíselo y vuelva a enviarlo', '<p>Estimado/a {$recipientName},</p><p>Tras revisar su envío, {$submissionTitle}, los revisores/as han recomendado que no puede ser aceptado para publicarse en su estado actual. No obstante, nos gustaría animarle a que nos envíe una versión revisada que tenga en cuenta los comentarios de los revisores/as. Los cambios serán revisados por el editor/a y el artículo podría ser enviado a una nueva ronda de evaluación por pares.</p><p>Tenga en cuenta que el hecho de volver a enviar su artículo no garantiza que sea aceptado.</p><p>Los comentarios de los revisores/as se incluyen al final de este correo electrónico. Por favor, responda a cada punto e identifique los cambios que haga. Si considera inapropiado algún comentario de los revisores/as, explíquenos su punto de vista. Si tiene dudas acerca de las recomendaciones en su revisión, inclúyalas en su respuesta.</p><p>Cuando haya completado las revisiones puede cargar los documentos revisados, junto con la respuesta a los comentarios de los revisores/as, en su <a href="{$authorSubmissionUrl}">panel de control del envío</a>. Si ha cerrado la sesión puede volver a iniciarla con su nombre de usuario/a {$recipientUsername}.</p><p>Si tiene cualquier pregunta no dude en contactarnos desde su <a href="{$authorSubmissionUrl}">panel de control del envío</a>.</p><p>Quedamos a la espera de recibir su envío revisado.</p><p>Saludos cordiales,</p>{$signature}<hr><p>Se recibieron los siguientes comentarios de los revisores/as.</p>{$allReviewerComments}'),
(185, 'EDITOR_DECISION_RESUBMIT', 'fr_CA', 'Soumettez à nouveau pour évaluation', 'Décision du rédacteur', '{$authors},<br />\n<br />\nNous avons pris une décision concernant votre soumission « {$submissionTitle} » à la revue {$journalName}.<br />\n<br />\nNotre décision est de vous demander d''apporter des révisions à votre soumission et de la soumettre à nouveau.'),
(186, 'EDITOR_DECISION_RESUBMIT', 'it', '', 'Decisione dell''editor', '{$authors}:<br />\n<br />\nAbbiamo raggiunto una decisione riguardo alla Sua submission a {$journalName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nLa decisione è: mandarla di nuovo in revisione'),
(187, 'EDITOR_DECISION_RESUBMIT', 'nl', 'Opnieuw ter beoordeling indienen', 'Uw inzending is beoordeeld - gelieve deze te herzien en opnieuw in te dienen', '<p>Beste {$recipientName},</p>\n<p>Na het beoordelen van uw inzending, {$submissionTitle}, hebben de beoordelaars aanbevolen dat uw inzending in zijn huidige vorm niet kan worden geaccepteerd voor publicatie. Desondanks willen we u aanmoedigen om een herziene versie in te dienen die de opmerkingen van de beoordelaars adresseert. Uw herzieningen zullen worden beoordeeld door een redacteur en kunnen worden doorgestuurd voor een volgende ronde van peer review.</p>\n<p>Houd er rekening mee dat het opnieuw indienen van uw werk niet garandeert dat het zal worden geaccepteerd.</p>\n<p>De opmerkingen van de beoordelaars zijn onderaan deze e-mail opgenomen. Reageer alstublieft op elk punt en geef aan welke wijzigingen u heeft aangebracht. Als u van mening bent dat bepaalde opmerkingen van de beoordelaars ongepast zijn, licht dan alstublieft uw perspectief toe. Als u vragen heeft over de aanbevelingen in uw beoordeling, neem deze dan op in uw reactie.</p>\n<p>Wanneer u uw herzieningen heeft voltooid, kunt u de herziene documenten samen met uw reactie op de opmerkingen van de beoordelaars <a href="{$authorSubmissionUrl}">indienen via uw inzendingsdashboard</a>. Als u bent uitgelogd, kunt u opnieuw inloggen met de gebruikersnaam {$recipientUsername}.</p>\n<p>Als u vragen heeft, neem dan contact met mij op via uw <a href="{$authorSubmissionUrl}">inzendingsdashboard</a>.</p>\n<p>Wij kijken uit naar ontvangst van uw herziene inzending.</p>\n<p>Met vriendelijke groet,</p>\n{$signature}<hr>\n<p>De volgende opmerkingen zijn ontvangen van de beoordelaars.</p>\n{$allReviewerComments}');
INSERT INTO `email_templates_default_data` VALUES
(188, 'EDITOR_DECISION_RESUBMIT', 'ru', 'Повторная отправка на рецензирование', 'Ваш материал был отрецензирован — пожалуйста, переработайте его и отправьте заново', '<p>Здравствуйте, {$recipientName}!</p><p>Расссмотрев Ваш материал «{$submissionTitle}» рецензенты рекомендовали не принимать его к публикации в текущем виде. Однако, мы хотели бы предложить Вам представить переработанную версию, учитывающую замечания рецензентов. Ваши правки будут рассмотрены редактором и могут быть отправлены на повторное рецензирование.</p><p>Обратите внимание, что повторное представление Вашего материала не гарантирует, что он будет принят.</p><p>Комментарии рецензентов приведены в конце этого письма. Пожалуйста, ответьте на каждый пункт замечаний рецензентов и укажите, какие изменения Вы внесли. Если Вы считаете какие-либо замечания рецензента необоснованными или неуместными, объясните свою точку зрения. Если у вас есть вопросы по поводу рекомендаций, содержащихся в рецензиях, пожалуйста, включите их в свой ответ.</p><p>Когда Вы завершите внесение правок, загрузите изменённые документы вместе с ответами на замечания рецензентов на <a href="{$authorSubmissionUrl}"> странице Вашего материала</a>. Если Вы вышли из системы, Вы можете снова войти в нее с именем пользователя {$recipientUsername}.</p><p>Если у Вас есть какие-то вопросы, пожалуйста, свяжитесь со мной через <a href="{$authorSubmissionUrl}">страницу Вашего материала</a>.</p><p>Мы с нетерпением ждем получения Вашего переработанного материала.</p><p>С уважением,</p>{$signature}<hr><p>Следующие комментарии были получены от рецензентов.</p>{$allReviewerComments}'),
(189, 'EDITOR_DECISION_RESUBMIT', 'en', 'Resubmit for Review', 'Your submission has been reviewed - please revise and resubmit', '<p>Dear {$recipientName},</p><p>After reviewing your submission, "{$submissionTitle}", the reviewers have recommended that your submission cannot be accepted for publication in its current form. However, we would like to encourage you to submit a revised version that addresses the reviewers'' comments. Your revisions will be reviewed by an editor and may be sent out for another round of peer review.</p><p>Please note that resubmitting your work does not guarantee that it will be accepted.</p><p>The reviewers'' comments are included at the bottom of this email. Please respond to each point and identify what changes you have made. If you find any of the reviewer''s comments inappropriate, please explain your perspective. If you have questions about the recommendations in your review, please include these in your response.</p><p>When you have completed your revisions, you can upload revised documents along with your response to the reviewers'' comments <a href="{$authorSubmissionUrl}">at your submission dashboard</a>. If you have been logged out, you can login again with the username {$recipientUsername}.</p><p>If you have any questions, please contact me from your <a href="{$authorSubmissionUrl}">submission dashboard</a>.</p><p>We look forward to receiving your revised submission.</p><p>Kind regards,</p>{$signature}<hr><p>The following comments were received from reviewers.</p>{$allReviewerComments}'),
(190, 'EDITOR_DECISION_DECLINE', 'de', 'Einreichung abgelehnt', 'Entscheidung der Redaktion: Ihre Einreichung wurde abgelehnt', '<p>Sehr geehrte/ {$recipientName},</p><p>Wir freuen uns über Ihre Einreichung, können aber {$submissionTitle} auf Grund der Kommentare der Gutachter/innen nicht zur Veröffentlichung annehmen.</p><p>Die Kommentare der Gutachter/innen sind am Ende dieser E-Mail enthalten.</p><p>Vielen Dank für Ihre Einreichung bei {$journalName}. Obwohl es enttäuschend ist, wenn eine Einreichung abgelehnt wird, hoffe ich, dass Sie die Kommentare der Gutachter/innen als konstruktiv und hilfreich empfinden.</p><p>Es steht Ihnen nun frei, die Arbeit an anderer Stelle einzureichen, wenn Sie dies wünschen.</p><p>Mit freundlichen Grüßen,</p>{$signature}<hr><p>Die folgenden Kommentare wurden von den Gutachter/innen abgegeben.</p>{$allReviewerComments}'),
(191, 'EDITOR_DECISION_DECLINE', 'es', 'Envío rechazado', 'Se ha rechazado su envío', '<p>Estimado/a{$recipientName},</p><p>Aunque valoramos mucho la recepción de su envío, de acuerdo con los comentarios de los revisores/as no podemos aceptar {$submissionTitle} para publicarse.</p><p>Dichos comentarios se incluyen al final de este correo electrónico.</p><p>Gracias por su envío a {$journalName}. A pesar de que es decepcionante que se rechace el envío, esperamos que los comentarios de los revisores/as le resulten constructivos y útiles.</p><p>Ahora es libre de presentar el trabajo en otro sitio si así lo desea.</p><p>Saludos cordiales,</p>{$signature}<hr><p>Se recibieron los siguientes comentarios de los revisores.</p>{$allReviewerComments}'),
(192, 'EDITOR_DECISION_DECLINE', 'fr_CA', 'Soumission refusée', 'Décision du rédacteur', '{$authors}:<br />\n<br />\nNous avons pris une décision concernant votre soumission « {$submissionTitle} » à la revue {$journalName}.<br />\n<br />\nNotre décision est de refuser votre soumission.'),
(193, 'EDITOR_DECISION_DECLINE', 'it', '', 'Decisione dell''editor', '{$authors}:<br />\n<br />\nAbbiamo raggiunto una decisione riguardo alla Sua submission a {$journalName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nLa decisione è di non accettare la proposta'),
(194, 'EDITOR_DECISION_DECLINE', 'nl', 'Inzending Afgewezen', 'Uw inzending is afgewezen', '<p>Beste {$recipientName},</p>\n<p>Hoewel we uw inzending hebben ontvangen, kunnen we {$submissionTitle} niet accepteren voor publicatie op basis van de opmerkingen van de beoordelaars.</p>\n<p>De opmerkingen van de beoordelaars zijn onderaan deze e-mail opgenomen.</p>\n<p>Bedankt voor uw inzending aan {$journalName}. Hoewel het teleurstellend is dat uw inzending is afgewezen, hoop ik dat u de opmerkingen van de beoordelaars als constructief en nuttig beschouwt.</p>\n<p>U bent nu vrij om het werk elders in te dienen als u dat wenst.</p>\n<p>Met vriendelijke groet,</p>\n{$signature}<hr>\n<p>De volgende opmerkingen zijn ontvangen van de beoordelaars.</p>\n{$allReviewerComments}'),
(195, 'EDITOR_DECISION_DECLINE', 'ru', 'Материал отклонен', 'Ваш материал был отклонен', '<p>Здравствуйте, {$recipientName}!</p><p>Хотя мы ценим то, что Вы решили отправить нам свой материал для публикации, мы не можем принять «{$submissionTitle}» к публикации на основании замечаний рецензентов.</p><p>Комментарии рецензентов приведены в конце этого письма.</p><p>Благодарим Вас за подачу материала в журнал «{$journalName}». Хотя отклонение материала от публикации расстраивает, я надеюсь, что комментарии рецензентов будут для Вас конструктивными и полезными.</p><p>Вы можете отправить материал для публикации в другое место, если решите это сделать.</p><p>С уважением,</p>{$signature}<hr><p>Следующие комментарии были получены от рецензентов.</p>{$allReviewerComments}'),
(196, 'EDITOR_DECISION_DECLINE', 'en', 'Submission Declined', 'Your submission has been declined', '<p>Dear {$recipientName},</p><p>While we appreciate receiving your submission, we are unable to accept "{$submissionTitle}" for publication on the basis of the comments from reviewers.</p><p>The reviewers'' comments are included at the bottom of this email.</p><p>Thank you for submitting to {$journalName}. Although it is disappointing to have a submission declined, I hope you find the reviewers'' comments to be constructive and helpful.</p><p>You are now free to submit the work elsewhere if you choose to do so.</p><p>Kind regards,</p>{$signature}<hr><p>The following comments were received from reviewers.</p>{$allReviewerComments}'),
(197, 'EDITOR_DECISION_INITIAL_DECLINE', 'de', 'Einreichung abgelehnt (Vor dem Gutachten)', 'Entscheidung der Redaktion: Ihre Einreichung wurde abgelehnt', '<p>Sehr geehrte/r {$recipientName},</p><p>es tut mir leid, Ihnen mitzuteilen, dass die Redaktion nach Durchsicht Ihrer Einreichung {$submissionTitle} festgestellt hat, dass sie unsere Anforderungen für eine Veröffentlichung in {$journalName} nicht erfüllt.</p><p>Ich wünsche Ihnen viel Erfolg, wenn Sie erwägen, Ihre Arbeit anderswo einzureichen.</p><p>Mit freundlichen Grüßen,</p>{$signature}'),
(198, 'EDITOR_DECISION_INITIAL_DECLINE', 'es', 'Envío rechazado (antes de revisión)', 'Su envío ha sido rechazado', '<p>Estimado/a {$recipientName},</p><p>Lamento informarlo de que, tras la revisión de su artículo, {$submissionTitle}, el editor/a ha considerado que no cumple los requisitos de publicación en {$journalName}.</p><p>Le deseo mucha suerte si decide enviarlo a otro sitio.</p><p>Saludos cordiales,</p>{$signature}'),
(199, 'EDITOR_DECISION_INITIAL_DECLINE', 'fr_CA', 'Soumission refusée avant évaluation', 'Décision du rédacteur', '<p>{$recipientName},</p><p>Nous avons le regret de vous informer qu''après avoir évaluer votre manuscrit, {$submissionTitle}, le-la rédacteur-trice en a conclue qu''il ne rencontre pas les exigences nécessaires pour être publier dans {$journalName}.</p><p>Cordialement,</p>{$signature}'),
(200, 'EDITOR_DECISION_INITIAL_DECLINE', 'it', '', 'Decisione dell''editor', '\n			Gentilissimo {$authors}:<br />\n<br />\nAbbiamo preso una decisione in merito al suo manoscritto dal titolo &quot;{$submissionTitle}&quot; inviato a {$journalName} .<br />\n<br />\nCi rincresce informarla che non ci è possibile accettare il suo contributo'),
(201, 'EDITOR_DECISION_INITIAL_DECLINE', 'nl', 'Inzending Afgewezen (Pre-Review)', 'Uw inzending is afgewezen', '<p>Beste {$recipientName},</p>\n<p>Helaas moet ik u mededelen dat na beoordeling van uw inzending, {$submissionTitle}, de redacteur heeft vastgesteld dat deze niet voldoet aan onze publicatie-eisen voor {$journalName}.</p>\n<p>Ik wens u succes als u overweegt uw werk elders in te dienen.</p>\n<p>Met vriendelijke groet,</p>\n{$signature}'),
(202, 'EDITOR_DECISION_INITIAL_DECLINE', 'ru', 'Материал отклонен (до рецензирования)', 'Ваш материал был отклонен', '<p>Здравствуйте, {$recipientName}!</p><p> С сожалением вынужден Вам сообщить, что по результатам рецензирования Вашего материала «{$submissionTitle}» редактор принял решение, что он не соответствует нашим требованиям к публикации в журнале «{$journalName}».</p><p>Желаю Вам успеха, если Вы решите отправить Вашу работу в другой журнал.</p><p>С уважением,</p>{$signature}'),
(203, 'EDITOR_DECISION_INITIAL_DECLINE', 'en', 'Submission Declined (Pre-Review)', 'Your submission has been declined', '<p>Dear {$recipientName},</p><p>I’m sorry to inform you that, after reviewing your submission, "{$submissionTitle}", the editor has found that it does not meet our requirements for publication in {$journalName}.</p><p>I wish you success if you consider submitting your work elsewhere.</p><p>Kind regards,</p>{$signature}'),
(204, 'EDITOR_RECOMMENDATION', 'de', 'Empfehlung gegeben', 'Empfehlung der Redaktion', '<p>Sehr geehrte/r {$recipientName},</p><p>Nach Abwägung des Feedbacks der Gutachter/innen möchte ich folgende Empfehlung für die Einreichung {$submissionTitle} aussprechen .</p><p>Meine Empfehlung lautet: {$recommendation}.</p><p>Bitte besuchen Sie den <a href="{$submissionUrl}">Redaktionsworkflow</a> des Beitrags, um dieser Empfehlung nachzukommen.</p><p>Bitte zögern Sie nicht, mich bei Fragen zu kontaktieren.</p><p>Mit freundlichen Grüßen,</p><p>{$senderName}</p>'),
(205, 'EDITOR_RECOMMENDATION', 'es', 'Recomendación hecha', 'Recomendación del editor/a', '<p>Estimado/a{$recipientName},</p><p>Tras considerar los comentarios de los revisores/as, me gustaría emitir la siguiente recomendación en relación con su envío {$submissionTitle}.</p><p>Mi recomendación es: {$recommendation}.</p><p>Visite el <a href="{$submissionUrl}">flujo editorial</a> del envío para actuar sobre esta recomendación.</p><p>Si tiene alguna pregunta, no dude en ponerse en contacto conmigo.</p><p>Saludos cordiales,</p><p>{$senderName}</p>'),
(206, 'EDITOR_RECOMMENDATION', 'fr_CA', 'Recommandation émise', 'Recommandation du rédacteur', '<p>{$recipientName},</p><p>Ma recommandation concernant la soumission « {$submissionTitle} » à la revue {$journalName} est de : {$recommendation}</p><p>S''il vous plait, consulter la <a href="{$submissionUrl}">page de la soumission</a> afin de donner suite à cette recommandation.</p><p>Cordialement,</p><p>{$senderName}</p>'),
(207, 'EDITOR_RECOMMENDATION', 'it', '', 'Raccomandazione dell''editor', '{$editors}:<br />\n<br />\nLa raccomandazione riguardo la proposta &quot;{$submissionTitle}&quot;, giunta per  {$journalName}, è: {$recommendation}'),
(208, 'EDITOR_RECOMMENDATION', 'nl', 'Aanbeveling Gedaan', 'Redacteursaanbeveling', '<p>Beste {$recipientName},</p>\n<p>Na het overwegen van de feedback van de beoordelaars, wil ik graag de volgende aanbeveling doen met betrekking tot de inzending {$submissionTitle}.</p>\n<p>Mijn aanbeveling is: {$recommendation}.</p>\n<p>Bezoek alstublieft de <a href="{$submissionUrl}">redactionele workflow van de inzending</a> om actie te ondernemen op deze aanbeveling.</p>\n<p>Voel u vrij om contact met mij op te nemen als u vragen heeft.</p>\n<p>Met vriendelijke groet,</p>\n<p>{$senderName}</p>'),
(209, 'EDITOR_RECOMMENDATION', 'ru', 'Рекомендация сделана', 'Рекомендация редактора', '<p>Здравствуйте, {$recipientName}!</p><p>После рассмотрения рецензий, присланных рецензентами, я бы хотел дать следующую рекомендацию относительно материала «{$submissionTitle}».</p><p>Моя рекомендация: {$recommendation}.</p><p>Пожалуйста, зайдите на страницу <a href="{$submissionUrl}">«Редакционный процесс»</a> данного материала, чтобы выполнить действия, связанные с этой рекомендацией.</p><p>Если у вас есть вопросы, пожалуйста, свяжитесь со мной.</p><p>С уважением,</p><p>{$senderName}</p>'),
(210, 'EDITOR_RECOMMENDATION', 'en', 'Recommendation Made', 'Editor Recommendation', '<p>Dear {$recipientName},</p><p>After considering the reviewers'' feedback, I would like to make the following recommendation regarding the submission "{$submissionTitle}".</p><p>My recommendation is: {$recommendation}.</p><p>Please visit the submission''s <a href="{$submissionUrl}">editorial workflow</a> to act on this recommendation.</p><p>Please feel free to contact me with any questions.</p><p>Kind regards,</p><p>{$senderName}</p>'),
(211, 'EDITOR_DECISION_NOTIFY_OTHER_AUTHORS', 'de', 'Andere Autor/innen benachrichtigen', 'Ein Update zu Ihrer Einreichung', '<p>Die folgende E-Mail wurde an {$submittingAuthorName} von {$journalName} bezüglich {$submissionTitle} gesendet.</p>\n<p>Sie erhalten eine Kopie dieser Benachrichtigung, da Sie als Autor/in der Einreichung identifiziert sind. Alle Anweisungen in der folgenden Nachricht sind für den einreichenden Autor/die einreichende Autorin {$submittingAuthorName} bestimmt, und von Ihnen wird zu diesem Zeitpunkt keine Aktion verlangt.</p>\n\n{$messageToSubmittingAuthor}'),
(212, 'EDITOR_DECISION_NOTIFY_OTHER_AUTHORS', 'es', 'Notificar a los otros autores/as', 'Actualización acerca de su envío', '<p>El siguiente correo electrónico fue enviado a {$submittingAuthorName} desde {$journalName} en relación con {$submissionTitle}.</p>\n<p>El motivo por el que recibe una copia de esta notificación es porque está identificado como autor/a de este envío. Las instrucciones que figuran en el siguiente mensaje se dirigen al autor/a principal del envío, {$submittingAuthorName}, por lo que no se requiere ninguna acción suya en este momento.</p>\n\n{$messageToSubmittingAuthor}'),
(213, 'EDITOR_DECISION_NOTIFY_OTHER_AUTHORS', 'fr_CA', 'Envoyer une notification aux autres auteur-es', 'Mise à jour concernant votre soumission', '<p>Ce courriel a été envoyé à {$submittingAuthorName} par {$journalName} concernant {$submissionTitle}.</p>\n<p>Vous recevez une copie de cet avis car vous êtes identifié comme auteur-e de cette soumission. Toutes les instructions dans le message ci-dessous sont à l''intention de l''auteur-e de correspondance, {$submittingAuthorName}. </p><p>Aucune action n''est attendue de votre part.</p>\n\n{$messageToSubmittingAuthor}'),
(214, 'EDITOR_DECISION_NOTIFY_OTHER_AUTHORS', 'it', '', '', ''),
(215, 'EDITOR_DECISION_NOTIFY_OTHER_AUTHORS', 'nl', 'Andere Auteurs Inlichten', 'Een update over uw inzending', '<p>De volgende e-mail is verzonden naar {$submittingAuthorName} van {$journalName} betreffende {$submissionTitle}.</p>\n<p>U ontvangt een kopie van deze kennisgeving omdat u bent geïdentificeerd als een auteur van de inzending. Eventuele instructies in het onderstaande bericht zijn bedoeld voor de indienende auteur, {$submittingAuthorName}, en er is op dit moment geen actie van u vereist.</p>\n\n{$messageToSubmittingAuthor}'),
(216, 'EDITOR_DECISION_NOTIFY_OTHER_AUTHORS', 'ru', 'Уведомить других авторов', 'Обновление информации о Вашем материале', '<p>В адрес {$submittingAuthorName} от журнала «{$journalName}» было отправлено следующее письмо относительно материала «{$submissionTitle}».</p>\n<p>Вы получили копию этого уведомления, потому что Вы указаны как автор материала. Любые инструкции в сообщении ниже предназначены для автора-отправителя ({$submittingAuthorName}) и от вас сейчас не требуется никаких действий.</p> \n\n{$messageToSubmittingAuthor}'),
(217, 'EDITOR_DECISION_NOTIFY_OTHER_AUTHORS', 'en', 'Notify Other Authors', 'An update regarding your submission', '<p>The following email was sent to {$submittingAuthorName} from {$journalName} regarding "{$submissionTitle}".</p>\n<p>You are receiving a copy of this notification because you are identified as an author of the submission. Any instructions in the message below are intended for the submitting author, {$submittingAuthorName}, and no action is required of you at this time.</p>\n\n{$messageToSubmittingAuthor}'),
(218, 'EDITOR_DECISION_NOTIFY_REVIEWERS', 'de', 'Gutachter/innen über die Entscheidung benachrichtigen', 'Eingangsbestätigung für Ihr Gutachten', '<p>Sehr geehrte/r {$recipientName},</p>\n<p>Vielen Dank, dass Sie den Beitrag {$submissionTitle} für {$journalName} begutachtet haben. Wir wissen Ihre Zeit und Ihr Fachwissen zu schätzen, mit denen Sie zur Qualität der von uns veröffentlichten Arbeiten beitragen. Wir haben Ihre Kommentare mit den Autoren geteilt, zusammen mit den Kommentaren unserer anderen Gutachter und der Entscheidung der Redaktion.</p>\n<p>Auf der Grundlage des erhaltenen Feedbacks haben wir die Autoren über Folgendes informiert:</p>\n<p>{$decisionDescription}</p>\n<p>Ihre Empfehlung wurde zusammen mit den Empfehlungen der anderen Gutachter/innen geprüft, bevor eine Entscheidung getroffen wurde. Gelegentlich kann die Entscheidung des Herausgebers von der Empfehlung eines oder mehrerer Gutachter/innen abweichen. Die Redaktion wägt viele Faktoren ab und nimmt diese Entscheidungen nicht auf die leichte Schulter. Wir sind dankbar für das Fachwissen und die Vorschläge unserer Gutachter/innen.</p>\n<p>Es war uns eine Freude, mit Ihnen als Gutachter/in für {$journalName} zusammenzuarbeiten, und wir hoffen, dass wir auch in Zukunft die Gelegenheit haben werden, mit Ihnen zusammenzuarbeiten.</p>\n<p>Mit freundlichen Grüßen,</p>\n<p>{$Unterschrift}</p>'),
(219, 'EDITOR_DECISION_NOTIFY_REVIEWERS', 'es', 'Notificar a los revisores/as de la decisión', 'Gracias por su revisión', '<p>Estimado/a {$recipientName},</p>\n<p>Gracias por completar la revisión del envío, {$submissionTitle}, para {$journalName}. Le agradecemos su tiempo y su pericia, que contribuyen a la calidad de las obras que publicamos. Hemos compartido sus comentarios con los autores/as, junto con los comentarios de los otros revisores/as y la decisión editorial.</p>\n<p>A partir de los comentarios recibidos, hemos notificado a los autores/as lo siguiente:</p>\n<p>{$decisionDescription}</p>\n<p>Su recomendación, junto con la de otros revisores/as, se ha considerado antes de llegar a una decisión final. A veces, la decisión del editor/a puede diferir de la recomendación hecha por uno o más revisores/as. El editor/a tiene en cuenta muchos factores y no se toma estas decisiones a la ligera. Estamos muy agradecidos por la pericia y las sugerencias de nuestros revisores/as.</p>\n<p>Ha sido un placer trabajar con usted como revisor/a para {$journalName}, y esperamos tener la oportunidad de seguir haciéndolo en el futuro.</p>\n<p>Saludos cordiales,</p>\n<p>{$signature}</p>'),
(220, 'EDITOR_DECISION_NOTIFY_REVIEWERS', 'fr_CA', 'Notifier les évaluateurs-trices de la décision', 'Décision éditoriale suite à votre évaluation', '<p>{$recipientName},</p>\n<p>Nous vous remercions d''avoir complété votre évaluation de la soumission, {$submissionTitle}, pour {$journalName}. Nous vous sommes reconnaissant pour votre temps et votre expertise qui contribue à la qualité des travaux que nous publions. Nous avons partagé vos commentaires avec l''auteur-e, ainsi que ceux des autres évaluateurs-trices. </p>\n<p>En fonction des recommandations reçues, nous avons informé l''auteur-e de notre décision qui est la suivante: </p>\n<p>{$decisionDescription}</p>\n<p>Votre recommandation a été prise en considération conjointement avec celles des autres évaluateurs-trices avant d''en arriver à cette décision.</p>\n<p>Ce fut un plaisir de travailler avec vous à cette évaluation pour {$journalName}. Nous espérons avoir l''opportunité de renouveler cette expérience avec vous à l''avenir.</p>\n<p>Cordialement,</p>\n<p>{$signature}</p>'),
(221, 'EDITOR_DECISION_NOTIFY_REVIEWERS', 'it', '', '', ''),
(222, 'EDITOR_DECISION_NOTIFY_REVIEWERS', 'nl', 'Reviewers Inlichten over Beslissing', 'Bedankt voor uw recensie', '<p>Beste {$recipientName},</p>\n<p>Dank u voor het voltooien van uw beoordeling van de inzending, {$submissionTitle}, voor {$journalName}. We waarderen uw tijd en expertise in het bijdragen aan de kwaliteit van het werk dat we publiceren. We hebben uw opmerkingen gedeeld met de auteurs, samen met de opmerkingen van onze andere beoordelaars en het besluit van de redacteur.</p>\n<p>Op basis van de ontvangen feedback hebben we de auteurs het volgende laten weten:</p>\n<p>{$decisionDescription}</p>\n<p>Uw aanbeveling werd in overweging genomen naast de aanbevelingen van andere beoordelaars voordat er een beslissing werd genomen. Soms kan de beslissing van de redacteur afwijken van de aanbeveling van een of meer beoordelaars. De redacteur houdt rekening met veel factoren en neemt deze beslissingen niet lichtvaardig. We zijn dankbaar voor de expertise en suggesties van onze beoordelaars.</p>\n<p>Het was een genoegen om met u samen te werken als beoordelaar voor {$journalName}, en we hopen in de toekomst weer met u te kunnen samenwerken.</p>\n<p>Met vriendelijke groet,</p>\n<p>{$signature}</p>'),
(223, 'EDITOR_DECISION_NOTIFY_REVIEWERS', 'ru', 'Уведомить рецензентов о принятом решении', 'Благодарим за Вашу рецензию', '<p>Здравствуйте, {$recipientName}!</p>\n<p>Благодарю Вас за рецензирование материала «{$submissionTitle}» для журнала «{$journalName}». Мы ценим Ваш вклад, который способствует повышению качества публикуемых нами работ. Мы поделились Вашими замечаниями с авторами, а также замечаниями других рецензентов и решением редактора.</p>\n<p>На основании полученных рецензий мы уведомили авторов о следующем:</p>\n<p>{$decisionDescription}</p>\n<p>Ваши рекомендации были рассмотрены наряду с рекомендациями других рецензентов, прежде чем было принято такое решение. Иногда решение редактора может отличаться от рекомендации одного или нескольких рецензентов. Редактор учитывает множество факторов и принимает такие решения очень взвешенно. Мы благодарны нашим рецензентам за их опыт и предложения.</p>\n<p>Нам было очень приятно работать с Вами в качестве рецензента журнала «{$journalName}», и мы надеемся, что в будущем у нас еще будет возможность сотрудничать с Вами.</p>\n<p>С уважением,</p>\n<p>{$signature}</p>'),
(224, 'EDITOR_DECISION_NOTIFY_REVIEWERS', 'en', 'Notify Reviewers of Decision', 'Thank you for your review', '<p>Dear {$recipientName},</p>\n<p>Thank you for completing your review of the submission, "{$submissionTitle}", for {$journalName}. We appreciate your time and expertise in contributing to the quality of the work that we publish. We have shared your comments with the authors, along with our other reviewers'' comments and the editor''s decision.</p>\n<p>Based on the feedback we received, we have notified the authors of the following:</p>\n<p>{$decisionDescription}</p>\n<p>Your recommendation was considered alongside the recommendations of other reviewers before coming to a decision. Occasionally the editor''s decision may differ from the recommendation made by one or more reviewers. The editor considers many factors, and does not take these decisions lightly. We are grateful for our reviewers'' expertise and suggestions.</p>\n<p>It has been a pleasure to work with you as a reviewer for {$journalName}, and we hope to have the opportunity to work with you again in the future.</p>\n<p>Kind regards,</p>\n<p>{$signature}</p>'),
(225, 'EDITOR_DECISION_NEW_ROUND', 'de', 'Neue Gutachtenrunde gestartet', 'Ihr Beitrag wurde für eine weitere Begutachtungsrunde weitergeleitet', '<p>Sehr geehrte/r {$recipientName},</p>\n<p>Ihre überarbeitete Einreichung {$submissionTitle} wurde zu einer neuen Runde der Begutachtung geschickt. \nSie werden von uns eine Rückmeldung von den Gutachter/innen und Informationen über die nächsten Schritte erhalten.</p>\n<p>Wenn Sie Fragen haben, kontaktieren Sie mich bitte über das <a href="{$authorSubmissionUrl}">Dashboard Ihrer Einreichung</a>.</p>\n<p>Mit freundlichen Grüßen,</p>\n<p>{$signature}</p>\n'),
(226, 'EDITOR_DECISION_NEW_ROUND', 'es', 'Se inició una ronda de revisión nueva', 'Su envío se ha tramitado a otra ronda de revisión', '<p>Estimado/a {$recipientName},</p>\n<p>Su manuscrito revisado, {$submissionTitle}, se ha enviado a una ronda de evaluación por pares nueva.\nLe comunicaremos los comentarios de los revisores/as y la información sobre los próximos pasos.</p>\n<p>Si tiene cualquier pregunta puede contactar con nosotros desde el <a href="{$authorSubmissionUrl}">panel de control del envío</a>.</p>\n<p>Saludos cordiales,</p>\n<p>{$signature}</p>\n'),
(227, 'EDITOR_DECISION_NEW_ROUND', 'fr_CA', 'Un nouveau cycle d''évaluation a été lancé', 'Votre soumission fera l''objet d''un nouveau cycle d''évaluation', '<p>{$recipientName},</p>\n<p>Votre soumission révisée, {$submissionTitle}, fera l''objet d''un nouveau cycle d''évaluation par les pairs. \nNous vous contacterons afin de vous faire part des commentaires des évaluateurs et vous fournir des informations sur les prochaines étapes.</p>\n<p>Si vous avec des questions, vous pouvez nous contacter à partir de votre <a href="{$authorSubmissionUrl}">tableau de bord de soumission</a>.</p>\n<p>Cordialement,</p>\n<p>{$signature}</p>\n'),
(228, 'EDITOR_DECISION_NEW_ROUND', 'it', '', '', ''),
(229, 'EDITOR_DECISION_NEW_ROUND', 'nl', 'Nieuwe Reviewronde Gestart', 'Uw inzending is doorgestuurd voor een volgende ronde van beoordeling', '<p>Beste {$recipientName},</p>\n<p>Uw herziene inzending, {$submissionTitle}, is doorgestuurd voor een nieuwe ronde van peer review.</p>\n<p>U zult van ons horen met feedback van de beoordelaars en informatie over de volgende stappen.</p>\n<p>Als u vragen heeft, neem dan contact met mij op via uw <a href="{$authorSubmissionUrl}">inzending dashboard</a>.\n</p>\n<p>Met vriendelijke groet,</p>\n<p>{$signature}</p>\n'),
(230, 'EDITOR_DECISION_NEW_ROUND', 'ru', 'Начался новый раунд рецензирования', 'Ваш материал был отправлен на повторный раунд рецензирования', '<p>Здравствуйте, {$recipientName}!</p>\n<p>ВАш переработанный материал «{$submissionTitle}» был отправлен на новый раунд рецензирования. \nВы получите от нас отзывы рецензентов и информацию о дальнейших шагах.</p>\n<p>Если у Вас есть какие-то вопросы, пожалуйста, свяжитесь со мной через <a href="{$authorSubmissionUrl}">страницу Вашего материала</a>.</p>\n<p>С уважением,</p>\n<p>{$signature}</p>\n'),
(231, 'EDITOR_DECISION_NEW_ROUND', 'en', 'New Review Round Initiated', 'Your submission has been sent for another round of review', '<p>Dear {$recipientName},</p>\n<p>Your revised submission, "{$submissionTitle}", has been sent for a new round of peer review. \nYou will hear from us with feedback from the reviewers and information about the next steps.</p>\n<p>If you have any questions, please contact me from your <a href="{$authorSubmissionUrl}">submission dashboard</a>.</p>\n<p>Kind regards,</p>\n<p>{$signature}</p>\n'),
(232, 'EDITOR_DECISION_REVERT_DECLINE', 'de', 'Abgelehnte Einreichung wieder aufnehmen', 'Wir haben die Entscheidung, Ihre Einreichung abzulehnen, rückgängig gemacht', '<p>Sehr geehrte/r {$recipientName},</p>\n<p>Die Entscheidung, Ihre Einreichung {$submissionTitle} abzulehnen, wurde rückgängig gemacht. Ein Redakteur/eine Redakteurin wird die Überprüfungsrunde abschließen und Sie werden benachrichtigt, wenn eine Entscheidung getroffen ist.</p>\n<p>Gelegentlich wird die Entscheidung, eine Einreichung abzulehnen, versehentlich in unserem System gespeichert und muss dann rückgängig gemacht werden. Ich möchte mich für die Verwirrung entschuldigen, die dies verursacht haben könnte.</p>\n<p>Wir werden uns mit Ihnen in Verbindung setzen, wenn wir weitere Unterstützung benötigen.</p>\n<p>Wenn Sie Fragen haben, kontaktieren Sie mich bitte über das <a href="{$authorSubmissionUrl}">Dashboard Ihrer Einreichung</a>.</p>\n<p>Mit freundlichen Grüßen,</p>\n<p>{$signature}</p>\n'),
(233, 'EDITOR_DECISION_REVERT_DECLINE', 'es', 'Restaurar envío rechazado', 'Hemos revertido la decisión de rechazar su envío', '<p>Estimado/a {$recipientName},</p>\n<p>La decisión de rechazar su envío, {$submissionTitle}, se ha revertido.\nUn editor/a completará la ronda de revisión y, cuando se haya tomado una decisión, \nse le notificará.</p>\n<p>A veces se registra accidentalmente en nuestro sistema la decisión de rechazar un envío\ny esta acción debe ser revertida. Le pedimos disculpas por la confusión que esto le haya podido causar.</p>\n<p>Nos pondremos en contacto con usted si necesitamos más ayuda.</p>\n<p>Si tiene cualquier pregunta puede contactarnos desde el <a href="{$authorSubmissionUrl}">panel de control del envío</a>.</p>\n<p>Saludos cordiales,</p>\n<p>{$signature}</p>\n'),
(234, 'EDITOR_DECISION_REVERT_DECLINE', 'fr_CA', 'Rétablir une soumission refusée', 'Nous avons renversé la décision de rejeter votre soumission', '<p>{$recipientName},</p>\n<p>La décision de rejeter votre soumission, {$submissionTitle}, a été renversée. Un-e rédacteur-trice complétera le cycle d''évaluation et vous serez informé-e lorsqu''une décision éditoriale sera prise.</p>\n<p>Si vous avez des questions, vous pouvez nous contacter sur votre <a href="{$authorSubmissionUrl}">tableau de bord de soumissions</a>.</p>\n<p>Cordialement,</p>\n<p>{$signature}</p>\n'),
(235, 'EDITOR_DECISION_REVERT_DECLINE', 'it', '', '', ''),
(236, 'EDITOR_DECISION_REVERT_DECLINE', 'nl', 'Herstel Afgewezen Inzending', 'We hebben besloten om de afwijzing van uw inzending ongedaan te maken', '<p>Beste {$recipientName},</p>\n<p>De beslissing om uw inzending, {$submissionTitle}, af te wijzen is teruggedraaid.</p>\n<p>Een redacteur zal de ronde van beoordeling voltooien en u wordt op de hoogte gebracht wanneer er een beslissing is genomen.</p>\n<p>Soms wordt een beslissing om een inzending af te wijzen per ongeluk vastgelegd in ons systeem en moet deze worden teruggedraaid. Excuses voor eventuele verwarring die dit heeft veroorzaakt.</p>\n<p>We zullen contact met u opnemen als we verdere hulp nodig hebben.</p>\n<p>Als u vragen heeft, neem dan contact met mij op via uw <a href="{$authorSubmissionUrl}">inzending dashboard</a>.</p>\n<p>Met vriendelijke groet,</p>\n<p>{$signature}</p>\n'),
(237, 'EDITOR_DECISION_REVERT_DECLINE', 'ru', 'Восстановление отклонённый материал', 'Мы отменили решение отклонить Ваш материал', '<p>Здравствуйте, {$recipientName}!</p>\n<p>Решение отклонить Ваш материал «{$submissionTitle}» было отменено. \nРедактор проведёт раунд рецензирования, и вы получите уведомление \nо принятом решении.</p>\n<p>Иногда решение об отклонении материала может быть случайно записано \nв нашей системе и должно быть отменено. Приношу Вам свои извинения за ту путаницу, которую эта ситуация могла вызвать.</p>\n<p>Мы свяжемся с Вами, если нам понадобится дополнительная помощь.</p>\n<p>Если у Вас есть какие-то вопросы, пожалуйста, свяжитесь со мной через <a href="{$authorSubmissionUrl}">страницу Вашего материала</a>.</p>\n<p>С уважением,</p>\n<p>{$signature}</p>\n'),
(238, 'EDITOR_DECISION_REVERT_DECLINE', 'en', 'Reinstate Declined Submission', 'We have reversed the decision to decline your submission', '<p>Dear {$recipientName},</p>\n<p>The decision to decline your submission, "{$submissionTitle}", has been reversed. \nAn editor will complete the round of review and you will be notified when a \ndecision is made.</p>\n<p>Occasionally, a decision to decline a submission will be recorded accidentally in \nour system and must be reverted. I apologize for any confusion this may have caused.</p>\n<p>We will contact you if we need any further assistance.</p>\n<p>If you have any questions, please contact me from your <a href="{$authorSubmissionUrl}">submission dashboard</a>.</p>\n<p>Kind regards,</p>\n<p>{$signature}</p>\n'),
(239, 'EDITOR_DECISION_REVERT_INITIAL_DECLINE', 'de', 'Ohne Gutachten abgelehnte Einreichung wieder aufnehmen', 'Wir haben die Entscheidung, Ihre Einreichung abzulehnen, rückgängig gemacht', '<p>Sehr geehrte/r {$recipientName},</p><p>Die Entscheidung, Ihre Einreichung {$submissionTitle} abzulehnen, wurde rückgängig gemacht. Ein Redakteur/eine Redakteurin wird sich Ihre Einreichung genauer ansehen, bevor er entscheidet, ob er sie ablehnt oder zur Überprüfung zu schickt.</p><p>Gelegentlich wird die Entscheidung, eine Einreichung abzulehnen, versehentlich in unserem System gespeichert und muss dann rückgängig gemacht werden. Ich möchte mich für die Verwirrung entschuldigen, die dies verursacht haben könnte.</p><p>Wir werden uns mit Ihnen in Verbindung setzen, wenn wir weitere Unterstützung benötigen.</p><p>Wenn Sie Fragen haben, kontaktieren Sie mich bitte über das <a href="{$authorSubmissionUrl}">Dashboard Ihrer Einreichung</a>.</p><p>Mit freundlichen Grüßen,</p><p>{$signature}</p>\n'),
(240, 'EDITOR_DECISION_REVERT_INITIAL_DECLINE', 'es', 'Restaurar el envío rechazado sin revisión', 'Hemos revertido la decisión de rechazar su envío', '<p>Estimado/a {$recipientName},</p>\n<p>La decisión de rechazar su envío, {$submissionTitle}, se ha revertido. \nUn editor/a estudiará su propuesta antes de decidir si la rechaza \no la envía a revisión.</p>\n<p>A veces se registra accidentalmente en nuestro sistema la decisión de rechazar un envío\ny esta acción debe ser revertida. Le pedimos disculpas por la confusión que esto le haya podido causar.</p>\n<p>Nos pondremos en contacto con usted si necesitamos más ayuda.</p>\n<p>Si tiene cualquier pregunta puede contactarnos desde el <a href="{$authorSubmissionUrl}">panel de control del envío</a>.</p>\n<p>Saludos cordiales,</p>\n<p>{$signature}</p>\n'),
(241, 'EDITOR_DECISION_REVERT_INITIAL_DECLINE', 'fr_CA', 'Rétablir une soumission refusée sans évaluation', 'Nous avons renversé la décision de rejeter votre soumission', '<p>{$recipientName},</p>\n<p>La décision de rejeter votre soumission, {$submissionTitle}, a été renversée. Un-e rédacteur-trice consultera en détail votre soumission avant de décider de la rejeter ou de l''envoyer en évaluation.</p>\n<p>Si vous avez des questions, vous pouvez nous contacter à partir de votre <a href="{$authorSubmissionUrl}">tableau de bord de soumission</a>.</p>\n<p>Cordialement,</p>\n<p>{$signature}</p>\n'),
(242, 'EDITOR_DECISION_REVERT_INITIAL_DECLINE', 'it', '', '', ''),
(243, 'EDITOR_DECISION_REVERT_INITIAL_DECLINE', 'nl', 'Herstel Inzending Geweigerd zonder Review', 'We hebben besloten om de afwijzing van uw inzending ongedaan te maken', '<p>Beste {$recipientName},</p>\n<p>De beslissing om uw inzending, {$submissionTitle}, af te wijzen is teruggedraaid.</p>\n<p>Een redacteur zal uw inzending verder bekijken voordat besloten wordt of deze alsnog afgewezen wordt of doorgestuurd wordt voor beoordeling.</p>\n<p>Soms wordt een beslissing om een inzending af te wijzen per ongeluk vastgelegd in ons systeem en moet deze worden teruggedraaid. Excuses voor eventuele verwarring die dit heeft veroorzaakt.</p>\n<p>We zullen contact met u opnemen als we verdere hulp nodig hebben.</p>\n<p>Als u vragen heeft, neem dan contact met mij op via uw <a href="{$authorSubmissionUrl}">inzending dashboard</a>.</p>\n<p>Met vriendelijke groet,</p>\n<p>{$signature}</p>\n'),
(244, 'EDITOR_DECISION_REVERT_INITIAL_DECLINE', 'ru', 'Восстановить материал, отклонённый без рецензирования', 'Мы отменили решение отклонить Ваш материал', '<p>Здравствуйте, {$recipientName}!</p>\n<p>Решение отклонить Ваш материал «{$submissionTitle}» было отменено. \nРедактор дополнительно изучит Ваш материал, прежде чем решит отклонить \nматериал или отправить его на рецензирование.</p>\n<p>Иногда решение об отклонении материала может быть случайно записано \nв нашей системе и должно быть отменено. Приношу Вам свои извинения за ту путаницу, которую эта ситуация могла вызвать.</p>\n<p>Мы свяжемся с Вами, если нам понадобится дополнительная помощь.</p>\n<p>Если у Вас есть какие-то вопросы, пожалуйста, свяжитесь со мной через <a href="{$authorSubmissionUrl}">страницу Вашего материала</a>.</p>\n<p>С уважением,</p>\n<p>{$signature}</p>\n'),
(245, 'EDITOR_DECISION_REVERT_INITIAL_DECLINE', 'en', 'Reinstate Submission Declined Without Review', 'We have reversed the decision to decline your submission', '<p>Dear {$recipientName},</p>\n<p>The decision to decline your submission, "{$submissionTitle}", has been reversed. \nAn editor will look further at your submission before deciding whether to decline \nthe submission or send it for review.</p>\n<p>Occasionally, a decision to decline a submission will be recorded accidentally in \nour system and must be reverted. I apologize for any confusion this may have caused.</p>\n<p>We will contact you if we need any further assistance.</p>\n<p>If you have any questions, please contact me from your <a href="{$authorSubmissionUrl}">submission dashboard</a>.</p>\n<p>Kind regards,</p>\n<p>{$signature}</p>\n'),
(246, 'EDITOR_DECISION_SKIP_REVIEW', 'de', 'Einreichung angenommen (ohne Begutachtung)', 'Ihre Einreichung wurde in das Lektorat geschickt', '<p>Sehr geehrte/r {$recipientName},</p>\n<p>Ich freue mich, Ihnen mitteilen zu können, dass wir beschlossen haben, Ihre Einreichung ohne Peer Review anzunehmen. Wir sind der Meinung, dass Ihre Einreichung {$submissionTitle} unseren Erwartungen entspricht, und wir verlangen nicht, dass Arbeiten dieser Art einem Peer-Review unterzogen werden. Wir freuen uns, Ihren Beitrag in {$journalName} zu veröffentlichen und danken Ihnen, dass Sie unsere Zeitschrift für Ihre Arbeit gewählt haben.</p>\nIhr Beitrag wird nun in einer zukünftigen Ausgabe von {$journalName} veröffentlicht und Sie können ihn gerne in Ihre Publikationsliste aufnehmen. Wir wissen um die harte Arbeit, die hinter jeder erfolgreichen Einreichung steckt, und möchten Ihnen zu Ihren Bemühungen gratulieren.</p>>\n<p>Ihre Einreichung wird nun redaktionell bearbeitet und formatiert, um sie für die Veröffentlichung vorzubereiten. </p>\n<p>Sie werden in Kürze weitere Anweisungen erhalten.</p>\n<p>Wenn Sie Fragen haben, kontaktieren Sie mich bitte über Ihr <a href="{$authorSubmissionUrl}">Einreichungs-Dashboard</a>.</p>\n<p>Mit freundlichen Grüßen,</p>\n<p>{$signature}</p>\n'),
(247, 'EDITOR_DECISION_SKIP_REVIEW', 'es', 'Envío aceptado (sin revisión)', 'Su artículo se ha enviado a edición', '<p>Estimado/a {$recipientName},</p>\n<p>Me complace informarle de que hemos decidido aceptar su envío sin pasar por la fase de revisión por pares. Le confirmamos que su envío "{$submissionTitle}" cumple con nuestras expectativas, por lo que no necesitamos que este tipo de trabajo pase por la fase de revisión por pares. Estamos emocionados por publicar su trabajo en {$journalName} y le agradecemos que haya elegido nuestra revista como hogar de su trabajo.</p>\n<p>Su envío se publicará en un número futuro de {$journalName}, así que le invitamos a incluirlo en su lista de publicaciones. Reconocemos el arduo trabajo que implica cada envío exitoso y queremos felicitarle por sus esfuerzos.</p>\n<p>Ahora su envío pasará a edición y formateo para su posterior publicación. </p>\n<p>En breve recibirá más instrucciones.</p>\n<p>Si tiene alguna pregunta, póngase en contacto con nosotros a través de su <a href="{$authorSubmissionUrl}">panel de envíos</a>.</p>\n<p>Atentamente,</p>\n<p>{$signature}</p>\n'),
(248, 'EDITOR_DECISION_SKIP_REVIEW', 'fr_CA', 'Soumission acceptée (sans évaluation)', 'Votre soumission a été envoyée à la révision linguistique', '<p>{$recipientName},</p>\n<p>Nous avons le plaisir de vous informer que nous avons décidé d''accepter votre soumission sans processus d''évaluation par les pairs. Nous trouvons que votre soumission, {$submissionTitle}, répond à nos exigences et ne requerrons pas une évaluation par les pairs. Nous sommes enthousiastes à l''idée de publier votre texte dans la revue {$journalName} et voulons vous remercier d''avoir choisi notre revue pour diffuser vos travaux. </p>\nVotre texte sera publié dans un prochain numéro de la revue {$journalName} et vous pouvez l''inclure dès à présent dans votre liste de publications. Nous reconnaissons les efforts nécessaire à toute publication et vous en félicitons. </p>\n<p>Votre texte va faire l''objet d''une révision linguistique et être mise en page avant publication.</p>\n<p>Vous recevrez des instructions sous peu.</p>\n<p>Si vous avez des questions, n''hésitez pas à me contacter à partir de votre <a href="{$authorSubmissionUrl}">tableau de bord de soumission</a>.</p>\n<p>Cordialement,</p>\n<p>{$signature}</p>\n'),
(249, 'EDITOR_DECISION_SKIP_REVIEW', 'it', '', 'Il Suo contributo è stato assegnato per la fase di copy-editing', '<p>Gentile {$recipientName},</p>\n<p>Abbiamo il piacere di informarLa che il Suo contributo {$submissionTitle} è stato accettato senza necessità del processo di revisione fra pari. Siamo pertanto lieti di poter pubblicare il Suo contributo in {$journalName} e La ringraziamo per avere scelto la nostra rivista.</p>\n<p>Il contributo sarà dunque pubblicato in un futuro numero di {$journalName} e La preghiamo di considerare tale e-mail già valida come conferma in tal senso. Siamo consapevoli dell''impegnativo lavoro necessario ai fini di ogni proposta editoriale di successo e pertanto desideriamo complimentarci per aver ottenuto tale risultato .</p><p>Il Suo contributo sarà entro breve assegnato per il lavoro di copy-editing e di formazione ai fini della pubblicazione.</p><p>Riceverà entro breve, a tal proposito, ulteriori indicazioni.</p><p>In caso di necessità o quesiti, non esiti a contattarci tramite la Sua area di<a href="{$authorSubmissionUrl}">gestione delle proposte</a>.</p><p>Con i più cordiali saluti,</p>{$signature}\n'),
(250, 'EDITOR_DECISION_SKIP_REVIEW', 'nl', 'Inzending Geaccepteerd (Zonder Beoordeling)', 'Uw inzending is verzonden voor bureauredactie', '<p>Beste {$recipientName},</p>\n<p>Het doet mij genoegen u te kunnen meedelen dat we hebben besloten uw inzending zonder peer review te accepteren. We hebben vastgesteld dat uw inzending, {$submissionTitle}, aan onze verwachtingen voldoet, en we vereisen niet dat dit soort werk peer review ondergaat. We zijn verheugd om uw stuk te publiceren in {$journalName} en wij danken u dat u ons tijdschrift heeft gekozen als locatie voor uw werk.</p>\nUw inzending verschijnt nu in een toekomstige uitgave van {$journalName} en u bent van harte welkom om deze op te nemen in uw lijst met publicaties. We erkennen het harde werk dat in elke succesvolle inzending zit en we willen u feliciteren met uw inspanningen.</p>\n<p>Je inzending wordt nu gekopieerd en opgemaakt om deze klaar te maken voor publicatie. </p>\n<p>Je ontvangt binnenkort verdere instructies.</p>\n<p>Als u vragen heeft, kunt u contact met mij opnemen via uw <a href="{$authorSubmissionUrl}">inzendingsdashboard</a>.</p>\n<p>Vriendelijke groeten,</p>\n<p>{$signature}</p>\n');
INSERT INTO `email_templates_default_data` VALUES
(251, 'EDITOR_DECISION_SKIP_REVIEW', 'ru', 'Материал принят (без рецензирования)', 'Ваш материал отправлен на корректуру', '<p>Уважаемый {$recipientName}!</p>\n<p>Я рад сообщить Вам, что мы решили принять Ваш материал без рецензирования. Мы считаем, что материал {$submissionTitle} полностью соответствует требованиям нашего журнала и не нуждается в дополнительной экспертной оценке. Мы рады опубликовать Ваш материал в журнале {$journalName} и благодарим Вас за выбор нашего журнала для публикации результатов Ваших исследований.</p>\nВаша статья будет опубликована в ближайшем выпуске журнала {$journalName}, и Вы сможете включить её в Ваш список публикаций. Мы понимаем, какая серьёзная работа предшествует каждой научной публикации, и хотим поздравить Вас с её успешным завершением.</p>\n<p>Теперь Ваш материал будет отредактирован и отформатирован для подготовки к публикации. </p>\n<p>В ближайшее время Вы получите от меня дальнейшие инструкции.</p>\n<p>Если у Вас возникли вопросы, пожалуйста, свяжитесь со мной из Вашего <a href="{$authorSubmissionUrl}">аккаунта</a>.</p>\n<p>С уважением,</p>\n<p>{$signature}</p>\n'),
(252, 'EDITOR_DECISION_SKIP_REVIEW', 'en', 'Submission Accepted (Without Review)', 'Your submission has been sent for copyediting', '<p>Dear {$recipientName},</p>\n<p>I am pleased to inform you that we have decided to accept your submission without peer review. We found your submission, {$submissionTitle}, to meet our expectations, and we do not require that work of this type undergo peer review. We are excited to publish your piece in {$journalName} and we thank you for choosing our journal as a venue for your work.</p>\nYour submission is now forthcoming in a future issue of {$journalName} and you are welcome to include it in your list of publications. We recognize the hard work that goes into every successful submission and we want to congratulate you on your efforts.</p>\n<p>Your submission will now undergo copy editing and formatting to prepare it for publication. </p>\n<p>You will shortly receive further instructions.</p>\n<p>If you have any questions, please contact me from your <a href="{$authorSubmissionUrl}">submission dashboard</a>.</p>\n<p>Kind regards,</p>\n<p>{$signature}</p>\n'),
(253, 'EDITOR_DECISION_BACK_FROM_PRODUCTION', 'de', 'Einreichung wurde ins Lektorat zurückgeschickt', 'Ihr Beitrag wurde an das Lektorat zurückgeschickt', '<p>Sehr geehrte/r {$recipientName},</p><p>Ihre Einsendung {$submissionTitle} wurde an das Lektorat zurückgeschickt, wo sie weiter bearbeitet und formatiert wird, um sie zur Veröffentlichung vorzubereiten.</p><p>Es kann vorkommen, dass eine Einsendung in die Produktionsphase geht, bevor die endgültigen Druckfahnen für die Veröffentlichung vorbereitet sind. Ihre Einsendung ist noch nicht abgeschlossen. Für etwaige Unklarheiten bitte ich um Entschuldigung.</p><p>Wenn Sie Fragen haben, kontaktieren Sie mich bitte über das <a href="{$authorSubmissionUrl}">Dashboard Ihrer Einreichung</a>.</p><p>Wir werden uns mit Ihnen in Verbindung setzen, wenn wir weitere Unterstützung benötigen.</p><p>Mit freundlichen Grüßen,</p><p>{$signature}</p>'),
(254, 'EDITOR_DECISION_BACK_FROM_PRODUCTION', 'es', 'Se ha retornado el envío a Edición', 'Su envío se ha devuelto a edición', '<p>Estimado/a {$recipientName},</p><p>Su envío, {$submissionTitle}, se ha devuelto a la fase de edición, donde se someterá a una nueva corrección y formateo para prepararlo para su publicación.</p><p>A veces, un envío pasa a la fase de producción antes de estar listo para preparar las galeradas finales que se utilizarán para su publicación. Su envío aún está en preparación. Lamentamos cualquier confusión que le hayamos causado.</p><p>Si tiene cualquier duda puede contactarnos desde su <a href="{$authorSubmissionUrl}">panel de control del envío</a>.</p><p>Nos pondremos en contacto con usted si necesitamos más ayuda.</p><p>Saludos cordiales,</p><p>{$signature}</p>'),
(255, 'EDITOR_DECISION_BACK_FROM_PRODUCTION', 'fr_CA', 'Soumission renvoyée à la révision', 'Votre soumission a été renvoyée à l''étape de révision', '<p>{$recipientName},</p><p>Votre soumission, {$submissionTitle}, a été renvoyée à l''étape de révision, où nous procéderons à des révisions supplémentaires ainsi qu''à la mise en page en prévision de la publication.</p><p>Nous nous excusons pour la confusion que cette opération peut occasionner.</p><p>Si vous avez des questions, vous pouvez nous contacter à partir de votre <a href="{$authorSubmissionUrl}">tableau de bord de soumission</a>.</p><p>Cordialement,</p><p>{$signature}</p>'),
(256, 'EDITOR_DECISION_BACK_FROM_PRODUCTION', 'it', '', '', ''),
(257, 'EDITOR_DECISION_BACK_FROM_PRODUCTION', 'nl', 'Inzending teruggestuurd naar Copyediting', 'Je inzending is teruggestuurd voor het corrigeren van de tekst', '<p>Beste {$recipientName},</p><p>Je inzending, {$submissionTitle}, is teruggestuurd naar de tekstredactiefase, waar het verder zal worden geredigeerd en opgemaakt om het voor publicatie gereed te maken.</p><p>Soms wordt een inzending naar de productiefase gestuurd voordat het klaar is voor de definitieve proefdrukken voor publicatie. Jouw inzending komt er nog aan. Excuses voor eventuele verwarring.</p><p>Als je vragen hebt, neem dan contact met me op via je <a href="{$authorSubmissionUrl}">inzendingsdashboard</a>.</p><p>We zullen contact met je opnemen als we verdere assistentie nodig hebben.</p><p>Met vriendelijke groet,</p><p>{$signature}</p>'),
(258, 'EDITOR_DECISION_BACK_FROM_PRODUCTION', 'ru', 'Материал отправлен обратно на литературное редактирование', 'Ваш материал был возвращён на литературное редактирование', '<p>Здравствуйте, {$recipientName}!</p><p>Ваш материал «{$submissionTitle}» был возвращён на этап литературного редактирования, где он пройдёт дальнейшее литературное редактирование и форматирование для подготовки к публикации.</p><p>Иногда материалы отправляются на публикацию до того, как они будут готовы к тому, чтобы их финальные гранки прошли подготовку к публикации. Редактирование Вашего материала ещё не завершено, приношу Вам свои извинения за ту путаницу, которую эта ситуация могла вызвать.</p><p>Если у Вас есть какие-то вопросы, пожалуйста, свяжитесь со мной через <a href="{$authorSubmissionUrl}">страницу Вашего материала</a>.</p><p>Мы свяжемся с Вами, если нам понадобится дополнительная помощь.</p><p>С уважением,</p><p>{$signature}</p>'),
(259, 'EDITOR_DECISION_BACK_FROM_PRODUCTION', 'en', 'Submission Sent Back to Copyediting', 'Your submission has been sent back to copyediting', '<p>Dear {$recipientName},</p><p>Your submission, "{$submissionTitle}", has been sent back to the copyediting stage, where it will undergo further copyediting and formatting to prepare it for publication.</p><p>Occasionally, a submission is sent to the production stage before it is ready for the final galleys to be prepared for publication. Your submission is still forthcoming. I apologize for any confusion.</p><p>If you have any questions, please contact me from your <a href="{$authorSubmissionUrl}">submission dashboard</a>.</p><p>We will contact you if we need any further assistance.</p><p>Kind regards,</p><p>{$signature}</p>'),
(260, 'EDITOR_DECISION_BACK_FROM_COPYEDITING', 'de', 'Einreichung vom Lektorat aus zurückgeschickt', 'Ihr Beitrag wurde zur Überprüfung zurückgeschickt', '<p>Sehr geehrte/r {$recipientName},</p><p>ihr Beitrag {$submissionTitle} wurde zur Überprüfung zurückgeschickt. Er wird einer weiteren Überprüfung unterzogen, bevor er zur Veröffentlichung angenommen werden kann.</p><p>Gelegentlich wird eine Entscheidung über die Annahme einer Einreichung versehentlich in unserem System gespeichert und wir müssen sie zur Überprüfung zurückschicken. Ich bitte um Entschuldigung für jegliche Verwirrung, die dies verursacht hat. Wir werden uns bemühen, alle weiteren Überprüfungen schnell abzuschließen, damit Sie so schnell wie möglich eine endgültige Entscheidung erhalten.</p><p>Wir werden uns mit Ihnen in Verbindung setzen, wenn wir weitere Unterstützung benötigen.</p><p>Wenn Sie Fragen haben, kontaktieren Sie mich bitte über das <a href="{$authorSubmissionUrl}">Dashboard Ihrer Einreichung</a>.</p><p>Mit freundlichen Grüßen,</p><p>{$signature}</p>'),
(261, 'EDITOR_DECISION_BACK_FROM_COPYEDITING', 'es', 'Envío retornado desde Edición', 'Su envío se ha devuelto a revisión', '<p>Estimado/a {$recipientName},</p><p>Su envío, {$submissionTitle}, se ha devuelto a la fase de revisión, donde se someterá a una nueva revisión antes de ser aceptado para su publicación.</p><p>A veces, la decisión de aceptar un envío puede registrarse accidentalmente en el sistema y por ello debemos enviarlo de nuevo a revisión. Lamentamos cualquier confusión que le hayamos causado. Nos encargaremos de completar rápidamente cualquier otra revisión para darle la decisión final lo antes posible.</p><p>Nos pondremos en contacto con usted si necesitamos más ayuda.</p><p>Si tiene cualquier duda puede contactarnos desde su <a href="{$authorSubmissionUrl}">panel de control del envío</a>.</p><p>Saludos cordiales,</p><p>{$signature}</p>'),
(262, 'EDITOR_DECISION_BACK_FROM_COPYEDITING', 'fr_CA', 'Soumission renvoyée de l''étape de révision', 'Votre soumission a été renvoyée à l''étape d''évaluation.', '<p>{$recipientName},</p><p>Votre soumission, {$submissionTitle}, a été renvoyée à l''étape d''évaluation. Elle sera réévaluée avant de pouvoir être acceptée.</p><p>Il peut arriver qu''une décision d''accepter une soumission soit prise par erreur dans notre système et qu''elle doive être renvoyée à l''étape d''évaluation. Nous nous excusons cette la confusion. Nous allons faire en sorte de compléter le processus d''évaluation rapidement afin de vous communiquer notre décision finale le plus tôt possible.</p><p>Nous vous contacterons au besoin.</p><p>Si vous avez des questions, n''hésitez pas à nous contacter à partir de votre <a href="{$authorSubmissionUrl}">tableau de bord de soumission</a>.</p><p>Cordialement,</p><p>{$signature}</p>'),
(263, 'EDITOR_DECISION_BACK_FROM_COPYEDITING', 'it', '', '', ''),
(264, 'EDITOR_DECISION_BACK_FROM_COPYEDITING', 'nl', 'Inzending teruggestuurd van Copyediting', 'Je inzending is teruggezonden voor recensie', '<p>Beste {$recipientName},</p><p>Je inzending, {$submissionTitle}, is teruggestuurd naar de beoordelingsfase. Het zal verder worden beoordeeld voordat het kan worden geaccepteerd voor publicatie.</p><p>Soms wordt een beslissing om een inzending te accepteren per ongeluk in ons systeem geregistreerd en moeten we het terugsturen naar de beoordelingsfase. Mijn excuses voor de verwarring die dit heeft veroorzaakt. We zullen ons best doen om de verdere beoordeling snel af te ronden, zodat je zo snel mogelijk een definitieve beslissing krijgt.</p><p>We zullen contact met je opnemen als we verdere assistentie nodig hebben.</p><p>Als je vragen hebt, neem dan contact met me op via je <a href="{$authorSubmissionUrl}">inzendingsdashboard</a>.</p><p>Met vriendelijke groet,</p><p>{$signature}</p>'),
(265, 'EDITOR_DECISION_BACK_FROM_COPYEDITING', 'ru', 'Материал отправлен обратно после литературного редактирования', 'Ваш материал был возвращён на рецензирование', '<p>Здравствуйте, {$recipientName}!</p><p>Ваш материал «{$submissionTitle}» был возвращён на этап рецензирования. Он пройдёт дальнейшее рецензирование прежде чем будет принят к публикации.</p><p>Иногда решение о приёме материала может быть случайно записано в нашей системе и мы должны вернуть материал обратно на рецензирование. Приношу Вам свои извинения за ту путаницу, которую эта ситуация могла вызвать. Мы постараемся быстро завершить рецензирование, чтобы Вы получили окончательное решение как можно скорее.</p><p>Мы свяжемся с Вами, если нам понадобится дополнительная помощь.</p><p>Если у Вас есть какие-то вопросы, пожалуйста, свяжитесь со мной через <a href="{$authorSubmissionUrl}">страницу Вашего материала</a>.</p><p>С уважением,</p><p>{$signature}</p>'),
(266, 'EDITOR_DECISION_BACK_FROM_COPYEDITING', 'en', 'Submission Sent Back from Copyediting', 'Your submission has been sent back to review', '<p>Dear {$recipientName},</p><p>Your submission, "{$submissionTitle}", has been sent back to the review stage. It will undergo further review before it can be accepted for publication.</p><p>Occasionally, a decision to accept a submission will be recorded accidentally in our system and we must send it back to review. I apologize for any confusion this has caused. We will work to complete any further review quickly so that you have a final decision as soon as possible.</p><p>We will contact you if we need any further assistance.</p><p>If you have any questions, please contact me from your <a href="{$authorSubmissionUrl}">submission dashboard</a>.</p><p>Kind regards,</p><p>{$signature}</p>'),
(267, 'EDITOR_DECISION_CANCEL_REVIEW_ROUND', 'de', 'Gutachtenrunde abgebrochen', 'Eine Überprüfungsrunde für Ihren Beitrag wurde abgesagt', '<p>Sehr geehrte/r {$recipientName},</p><p>wir haben kürzlich eine neue Überprüfungsrunde für Ihre Einreichung {$submissionTitle} eröffnet. Wir schließen diese Überprüfungsrunde jetzt ab.</p><p>Es kann vorkommen, dass eine Entscheidung zur Eröffnung einer Überprüfungsrunde versehentlich in unserem System gespeichert wird und wir diese Überprüfungsrunde abbrechen müssen. Ich bitte um Entschuldigung für jegliche Verwirrung, die dies verursacht haben könnte.</p><p>Wir werden uns mit Ihnen in Verbindung setzen, wenn wir weitere Unterstützung benötigen.</p><p>Wenn Sie Fragen haben, kontaktieren Sie mich bitte über das <a href="{$authorSubmissionUrl}">Dashboard Ihrer Einreichung</a>.</p><p>Mit freundlichen Grüßen,</p><p>{$signature}</p>'),
(268, 'EDITOR_DECISION_CANCEL_REVIEW_ROUND', 'es', 'Ronda de revisión cancelada', 'Se ha cancelado una ronda de revisión de su envío', '<p>Estimado/a {$recipientName},</p><p>Hace poco iniciamos una ronda de revisión nueva para su envío, {$submissionTitle}. Ahora la vamos a cerrar.</p><p>A veces, la decisión de iniciar una ronda de revisión nueva puede registrarse accidentalmente en el sistema y por ello debemos cancelarla. Lamentamos cualquier confusión que le hayamos causado.</p><p>Nos pondremos en contacto con usted si necesitamos más ayuda.</p><p>Si tiene cualquier duda puede contactarnos desde su <a href="{$authorSubmissionUrl}">panel de control del envío</a>.</p><p>Saludos cordiales,</p><p>{$signature}</p>'),
(269, 'EDITOR_DECISION_CANCEL_REVIEW_ROUND', 'fr_CA', 'Cycle d''évaluation annulé', 'Un cycle d''évaluation de votre soumission a été annulé', '<p>{$recipientName},</p><p>Nous avions déclenché un nouveau cycle d''évaluation pour votre soumission, {$submissionTitle}. Nous fermons désormais ce cycle.</p><p>Nous nous excusons pour la confusion que cette action peut occasionner. </p><p>Nous vous contacterons si nous avons besoin d''une aide supplémentaire de votre part.</p><p>Si vous avez des questions, vous pouvez nous contacter à partir de votre <a href="{$authorSubmissionUrl}">tableau de bord de soumissions</a></p>.<p>Kind regards,</p><p>{$signature}</p>'),
(270, 'EDITOR_DECISION_CANCEL_REVIEW_ROUND', 'it', '', '', ''),
(271, 'EDITOR_DECISION_CANCEL_REVIEW_ROUND', 'nl', 'Reviewronde Geannuleerd', 'Een beoordelingsronde voor je inzending is geannuleerd', '<p>Beste {$recipientName},</p><p>We hebben onlangs een nieuwe beoordelingsronde geopend voor je inzending, {$submissionTitle}. We sluiten deze beoordelingsronde nu af.</p><p>Soms wordt een beslissing om een beoordelingsronde te openen per ongeluk in ons systeem geregistreerd en moeten we deze beoordelingsronde annuleren. Mijn excuses voor eventuele verwarring die dit heeft veroorzaakt.</p><p>We zullen contact met je opnemen als we verdere assistentie nodig hebben.</p><p>Als je vragen hebt, neem dan contact met me op via je <a href="{$authorSubmissionUrl}">inzendingsdashboard</a>.</p><p>Met vriendelijke groet,</p><p>{$signature}</p>'),
(272, 'EDITOR_DECISION_CANCEL_REVIEW_ROUND', 'ru', 'Раунд рецензирования отменен', 'Раунд рецензирования Вашего материала был отменен', '<p>Здравствуйте, {$recipientName}!</p><p>Недавно мы запустили новый раунд рецензирования для Вашего материала «{$submissionTitle}». Сейчас мы отменяем этот раунд рецензирования.</p><p>Иногда решение о начале раунда рецензирования может быть случайно записано в нашей системе и мы должны отменить этот раунд. Приношу Вам свои извинения за ту путаницу, которую эта ситуация могла вызвать.</p><p>Мы свяжемся с Вами, если нам понадобится дополнительная помощь.</p><p>Если у Вас есть какие-то вопросы, пожалуйста, свяжитесь со мной через <a href="{$authorSubmissionUrl}">страницу Вашего материала</a>.</p><p>С уважением,</p><p>{$signature}</p>'),
(273, 'EDITOR_DECISION_CANCEL_REVIEW_ROUND', 'en', 'Review Round Cancelled', 'A review round for your submission has been cancelled', '<p>Dear {$recipientName},</p><p>We recently opened a new review round for your submission, "{$submissionTitle}". We are closing this review round now.</p><p>Occasionally, a decision to open a round of review will be recorded accidentally in our system and we must cancel this review round. I apologize for any confusion this may have caused.</p><p>We will contact you if we need any further assistance.</p><p>If you have any questions, please contact me from your <a href="{$authorSubmissionUrl}">submission dashboard</a>.</p><p>Kind regards,</p><p>{$signature}</p>'),
(274, 'SUBSCRIPTION_NOTIFY', 'de', 'Abonnementbenachrichtigung', 'Benachrichtigung zu einem Abonnement', 'Sehr geehrte/r {$recipientName}<br />\n<br />\nSie sind jetzt als Abonnent/in in unserem Online-Zeitschriftenverwaltungssystem für {$journalName} mit dem folgenden Abonnement registriert:<br />\n<br />\n{$subscriptionType}<br />\n<br />\nUm auf Inhalte zuzugreifen, die nur für Abonnent/innen verfügbar sind, melden Sie sich einfach mit Ihrem Benutzernamen "{$recipientUsername}" am System an.<br />\n<br />\nSobald Sie sich im System angemeldet haben, können Sie Ihre Profildaten und Ihr Passwort jederzeit ändern.<br />\n<br />\nWenn Sie ein institutionelles Abonnement haben, brauchen sich die Benutzer/innen Ihrer Einrichtung nicht anzumelden, da Anfragen nach Abonnementinhalten automatisch vom System authentifiziert werden.<br />\n<br />\nWenn Sie Fragen haben, können Sie sich gerne an mich wenden.<br />\n<br />\n{$subscriptionSignature}'),
(275, 'SUBSCRIPTION_NOTIFY', 'es', 'Notificación de suscripción', 'Notificación de suscripción', '{$recipientName}:<br />\n<br />\nAcaba de registrarse como suscriptor/a en nuestro sistema de gestión de revistas online para la revista {$journalName}, a continuación le mostramos los datos de su suscripción:<br />\n<br />\n{$subscriptionType}<br />\n<br />\nPara acceder al contenido exclusivo para suscriptores/as, simplemente tiene que identificarse con su nombre de usuaria/o, &quot;{$recipientUsername}&quot;.<br />\n<br />\nUna vez se haya identificado en el sistema puede cambiar los detalles de su perfil y su contraseña en cualquier momento.<br />\n<br />\nTenga en cuenta que si se trata de una suscripción institucional no es necesario que los/as usuarios/as de su institución se identifiquen, ya que las peticiones de contenido bajo suscripción serán autentificadas automáticamente por el sistema.<br />\n<br />\nSi tiene cualquier pregunta no dude en contactar con nosotros/as.<br />\n<br />\n{$subscriptionSignature}'),
(276, 'SUBSCRIPTION_NOTIFY', 'fr_CA', 'Notification d''abonnement', 'Avis d''abonnement', '{$recipientName},<br />\n<br />\nVous êtes maintenant abonné-e à notre système de gestion de revue en ligne pour la revue {$journalName}, avec le type d''abonnement suivant  :<br />\n<br />\n{$subscriptionType}<br />\n<br />\nPour accéder au contenu destiné seulement aux abonnés, connectez-vous au système à l''aide de votre nom d''utilisateur-trice : {$recipientUsername}.<br />\n<br />\nUne fois connecté-e dans le système, vous pouvez, en tout temps, modifier les renseignements de votre profil et votre mot de passe.<br />\n<br />\nVeuillez prendre note que si vous disposez d''un abonnement institutionnel, les utilisateurs-trices n''ont pas à entrer de nom d''utilisateur-trice puisque le système authentifiera automatiquement les demandes.<br />\n<br />\nSi vous avez des questions, n''hésitez pas à communiquer avec nous.<br />\n<br />\n{$subscriptionSignature}'),
(277, 'SUBSCRIPTION_NOTIFY', 'it', 'Notifica di sottoscrizione', 'Notifica di sottoscrizione', 'Gentile {$recipientName}:<br />\n<br />\nLa Sua registrazione a {$journalName} è stata attivata con le seguenti caratteristiche:<br />\n<br />\n{$subscriptionType}<br />\n<br />\nPer accedere al contenuto riservato agli abbonati, effettui semplicemente l''accesso al sistema con il Suo username, &quot;{$recipientUsername}&quot;.<br />\n<br />\nUna volta effettuato l''accesso potrà modificare in ogni momento i dettagli del profilo e la password.<br />\n<br />\nGli utenti istituzionali vengono riconosciuti automaticamente dal sistema.<br />\n<br />\nPer qualsiasi domanda non esiti a contattarci.<br />\n<br />\nCordiali saluti, <br />{$subscriptionSignature}'),
(278, 'SUBSCRIPTION_NOTIFY', 'nl', 'Abonnementsnotificatie', 'Bevestiging abonnement', '{$recipientName}:<br />\n<br />\nU bent in ons online tijdschriftsysteem geregistreerd als abonnee van {$journalName} met het volgende abonnement:<br />\n<br />\n{$subscriptionType}<br />\n<br />\nOm toegang te krijgen tot de inhoud die is voorbehouden aan abonnees kunt u inloggen in het systeem met uw gebruikersnaam, &quot;{$recipientUsername}&quot;.<br />\n<br />\nEenmaal ingelogd op het systeem kunt u uw profielgegevens en wachtwoord op ieder gewenst moment veranderen.<br />\n<br />\nMerk op dat in het geval van een institutioneel abonnement gebruikers niet in hoeven te loggen, het systeem zal verzoeken automatisch authenticeren.<br />\n<br />\nAls vragen heeft, neemt u dan alstublieft contact met me op.<br />\n<br />\n{$subscriptionSignature}'),
(279, 'SUBSCRIPTION_NOTIFY', 'ru', 'Уведомление о подписке', 'Уведомление о подписке', 'Здравствуйте, {$recipientName}!<br />\n<br />\nВы теперь зарегистрированы в нашей онлайн-системе управления журналом как подписчик журнала «{$journalName}» со следующей подпиской:<br />\n<br />\n{$subscriptionType}<br />\n<br />\nЧтобы получить доступ к контенту, который доступен только для подписчиков, просто войдите на сайт журнала со своим именем пользователя «{$recipientUsername}».<br />\n<br />\nКак только Вы войдете в систему, Вы можете в любой момент изменить Ваш профиль пользователя и пароль.<br />\n<br />\nПожалуйста, обратите внимание, что если у Вас есть подписка на всю организацию, то пользователям Вашей организации не нужно будет входить в систему, так как запросы на контент, предоставляемый по подписке, автоматически будут аутентифицированы системой.<br />\n<br />\nЕсли у Вас есть какие-либо вопросы, пожалуйста, не стесняйтесь, связывайтесь со мной.<br />\n<br />\n{$subscriptionSignature}'),
(280, 'SUBSCRIPTION_NOTIFY', 'en', 'Subscription Notify', 'Subscription Notification', '{$recipientName}:<br />\n<br />\nYou have now been registered as a subscriber in our online journal management system for {$journalName}, with the following subscription:<br />\n<br />\n{$subscriptionType}<br />\n<br />\nTo access content that is available only to subscribers, simply log in to the system with your username, &quot;{$recipientUsername}&quot;.<br />\n<br />\nOnce you have logged in to the system you can change your profile details and password at any point.<br />\n<br />\nPlease note that if you have an institutional subscription, there is no need for users at your institution to log in, since requests for subscription content will be automatically authenticated by the system.<br />\n<br />\nIf you have any questions, please feel free to contact me.<br />\n<br />\n{$subscriptionSignature}'),
(281, 'OPEN_ACCESS_NOTIFY', 'de', 'Open Access Benachrichtigung', 'Frei zugänglich: {$issueIdentification} der Zeitschrift {$journalName} ist jetzt Open Access', '<p>Sehr geehrte/r {$recipientName},</p><p>wir freuen uns, Ihnen mitteilen zu können, dass <a href="{$issueUrl}">{$issueIdentification}</a> der Zeitschrift {$journalName} jetzt im Open Access verfügbar ist. Ein Abonnement ist nicht mehr erforderlich, um diese Ausgabe zu lesen.</p><p>Wir danken Ihnen für Ihr anhaltendes Interesse an unserer Arbeit.</p>{$journalSignature}'),
(282, 'OPEN_ACCESS_NOTIFY', 'es', 'Notificación de acceso abierto', 'Acceso libre: {$issueIdentification} de {$journalName} ahora está disponible en acceso abierto', '<p>Estimado/a {$recipientName},</p><p>Nos complace informarle de que <a href="{$issueUrl}">{$issueIdentification}</a> de {$journalName} ya está disponible en acceso abierto. Por lo tanto, ya no es necesaria una suscripción para leer este número.</p><p>Gracias por mantener el interés en nuestro trabajo.</p>{$journalSignature}'),
(283, 'OPEN_ACCESS_NOTIFY', 'fr_CA', 'Notification de diffusion en libre accès', 'Gratuitement accessible : le numéro {$issueIdentification} de la revue {$journalName} est maintenant en accès libre', '<p>Chers lecteurs et lectrices,</p><p>La revue {$journalName} vient de rendre disponible en libre accès le numéro suivant. Nous vous invitons à lire ici le sommaire puis visiter notre site Web ({$journalUrl}) pour lire les articles et autres textes qui pourraient vous intéresser.</p><p>Merci de votre intérêt continu pour notre travail.</p>{$journalSignature}'),
(284, 'OPEN_ACCESS_NOTIFY', 'it', 'Notifica di accesso aperto', 'Nuovo fascicolo ad accesso aperto: {$issueIdentification} di {$journalName}', '<p>Gentile {$recipientName},</p><p>Siamo lieti di informarLa che <a href="{$issueUrl}">{$issueIdentification}</a> di {$journalName} è ora disponibile in modalità ad accesso aperto.  Non è più richiesto alcun abbonamento per poter accedere a tale rivista.</p><p>Grazie per la sua cortese attenzione, e con i più cordiali saluti,</p>{$journalSignature}'),
(285, 'OPEN_ACCESS_NOTIFY', 'nl', 'Open Access Notificatie', 'Nummer nu Open Access', '<p>Beste {$recipientName},</p><p>We zijn blij u te kunnen informeren dat <a href=“{$issueUrl}”>{$issueIdentification}</a> van {$journalName} nu open access beschikbaar is. Een abonnement is niet langer vereist om dit nummer te lezen.</p><p>Bedankt voor uw voortdurende interesse in ons werk.</p>{$journalSignature}'),
(286, 'OPEN_ACCESS_NOTIFY', 'ru', 'Уведомление об открытом доступе', 'Читать бесплатно: {$issueIdentification} журнала «{$journalName}» теперь в открытом доступе', '<p>Здравствуйте, {$recipientName}!</p><p>Журнал «{$journalName}» рад сообщить, что выпуск <a href="{$issueUrl}">{$issueIdentification}</a> теперь находится в открытом доступе. Для чтения этого номера подписка больше не требуется.</p><p>Благодарю Вас за постоянный интерес к нашей работе,</p>{$journalSignature}'),
(287, 'OPEN_ACCESS_NOTIFY', 'en', 'Open Access Notify', 'Free to read: {$issueIdentification} of {$journalName} is now open access', '<p>Dear {$recipientName},</p><p>We are pleased to inform you that <a href="{$issueUrl}">{$issueIdentification}</a> of {$journalName} is now available under open access.  A subscription is no longer required to read this issue.</p><p>Thank you for your continuing interest in our work.</p>{$journalSignature}'),
(288, 'SUBSCRIPTION_BEFORE_EXPIRY', 'de', 'Abonnement läuft bald aus', 'Benachrichtigung über das Ablaufen eines Abonnements', 'Sehr geehrte/r {$recipientName}<br />\n<br />\nIhr Abonnement für {$journalName} läuft in Kürze ab.<br />\n<br />\n{$subscriptionType}<br />\nVerfallsdatum: {$expiryDate}<br />\n<br />\nUm sicherzustellen, dass Sie weiterhin Zugang zu dieser Zeitschrift haben, gehen Sie bitte auf die Website der Zeitschrift und verlängern Sie Ihr Abonnement. Sie können sich mit Ihrem Benutzernamen "{$recipientUsername}" in das System einloggen.<br />\n<br />\nWenn Sie Fragen haben, können Sie mich gerne kontaktieren.<br />\n<br />\n{$subscriptionSignature}'),
(289, 'SUBSCRIPTION_BEFORE_EXPIRY', 'es', 'La suscripción caduca pronto', 'Notificación de expiración de suscripción', '{$recipientName}:<br />\n<br />\n	Su suscripción a {$journalName} está a punto de caducar.<br />\n<br />\n	{$subscriptionType}<br />\n	Fecha de caducidad: {$expiryDate}<br />\n<br />\n	Para asegurarse de que continúa teniendo acceso a la revista, acceda a la página web de la revista y renueve su suscripción. Puede iniciar sesión en el sistema con su nombre de usuario/a, &quot;{$recipientUsername}&quot;.<br />\n<br />\n	Si tiene cualquier pregunta no dude en contactarme.<br />\n<br />\n	{$subscriptionSignature}'),
(290, 'SUBSCRIPTION_BEFORE_EXPIRY', 'fr_CA', 'L''abonnement arrive bientôt à échéance', 'Avis d''expiration de l''abonnement', '{$recipientName},<br />\n<br />\nVotre abonnement à la revue {$journalName} expirera bientôt.<br />\n<br />\n{$subscriptionType}<br />\nDate d''expiration : {$expiryDate}<br />\n<br />\nAfin d''assurer la continuité de votre accès à cette revue, nous vous invitons à aller sur le site Web de la revue et à renouveler votre abonnement. Vous pouvez vous y ouvrir une session avec votre nom d''utilisateur-trice, soit « {$recipientUsername} ».<br />\n<br />\nSi vous avez des questions, ne pas hésiter à communiquer avec nous.<br />\n<br />\n{$subscriptionSignature}'),
(291, 'SUBSCRIPTION_BEFORE_EXPIRY', 'it', 'L''abbonamento scade tra poco', 'Avviso di scadenza dell''abbonamento', 'Gentile {$recipientName}:<br />\n<br />\nIl suo abbonamento a {$journalName} sta per scadere.<br />\n<br />\n{$subscriptionType}<br />\nData di scadenza: {$expiryDate}<br />\n<br />\nPer continuare ad accedere a questa rivista, si rechi sul sito e rinnovi l''abbonamento. Per l''accesso utilizzi la sua username, &quot;{$recipientUsername}&quot;.<br />\n<br />\nPer qualsiasi domanda e ulteriore informazione, non esiti a contattarci.<br />\n<br />\n{$subscriptionSignature}'),
(292, 'SUBSCRIPTION_BEFORE_EXPIRY', 'nl', 'Abonnement verloopt binnenkort', 'Bericht van aflopen abonnement', '{$recipientName}:<br />\n<br />\nUw abonnement op {$journalName} verloopt binnenkort.<br />\n<br />\n{$subscriptionType}<br />\nAfloopdatum: {$expiryDate}<br />\n<br />\nOm de continuïteit van uw toegang tot het tijdschrift te verzekeren kunt u uw abonnement verlengen op de website van het tijdschrift. U kunt inloggen op de website van het tijdschrift met uw gebruikersnaam &quot;{$recipientUsername}&quot;.<br />\n<br />\nAarzel niet om contact met me op te nemen als u vragen heeft.<br />\n<br />\n{$subscriptionSignature}'),
(293, 'SUBSCRIPTION_BEFORE_EXPIRY', 'ru', 'Подписка скоро заканчивается', 'Уведомление об окончании срока подписки', 'Здравствуйте, {$recipientName}!<br />\n<br />\nВаша подписка на журнал «{$journalName}» истекает в ближайшее время.<br />\n<br />\n{$subscriptionType}<br />\nДата окончания подписки: {$expiryDate}<br />\n<br />\nЧтобы Ваш доступ к этому журналу не прерывался, пожалуйста, перейдите на сайт журнала и продлите Вашу подписку. Вы можете войти на сайт журнала со своим именем пользователя «{$recipientUsername}».<br />\n<br />\nЕсли у Вас есть какие-либо вопросы, пожалуйста, не стесняйтесь, связывайтесь со мной.<br />\n<br />\n{$subscriptionSignature}'),
(294, 'SUBSCRIPTION_BEFORE_EXPIRY', 'en', 'Subscription Expires Soon', 'Notice of Subscription Expiry', '{$recipientName}:<br />\n<br />\nYour {$journalName} subscription is about to expire.<br />\n<br />\n{$subscriptionType}<br />\nExpiry date: {$expiryDate}<br />\n<br />\nTo ensure the continuity of your access to this journal, please go to the journal website and renew your subscription. You are able to log in to the system with your username, &quot;{$recipientUsername}&quot;.<br />\n<br />\nIf you have any questions, please feel free to contact me.<br />\n<br />\n{$subscriptionSignature}'),
(295, 'SUBSCRIPTION_AFTER_EXPIRY', 'de', 'Abonnement abgelaufen', 'Abonnement abgelaufen', 'Sehr geehrte/r {$recipientName}<br />\n<br />\nIhr Abonnement für {$journalName} ist abgelaufen.<br />\n<br />\n{$subscriptionType}<br />\nVerfallsdatum: {$expiryDate}<br />\n<br />\nUm Ihr Abonnement zu erneuern, gehen Sie bitte auf die Website der Zeitschrift. Sie können sich mit Ihrem Benutzernamen "{$recipientUsername}" in das System einloggen.<br />\n<br />\nWenn Sie Fragen haben, können Sie mich gerne kontaktieren.<br />\n<br />\n{$subscriptionSignature}'),
(296, 'SUBSCRIPTION_AFTER_EXPIRY', 'es', 'Suscripción caducada', 'Subscripción expirada', '{$recipientName}:<br />\n<br />\n	Su suscripción a {$journalName} ha caducado.<br />\n<br />\n	{$subscriptionType}<br />\n	Fecha de caducidad: {$expiryDate}<br />\n<br />\n	Para renovar su suscripción acceda a la página web de la revista. Puede iniciar sesión en el sistema con su nombre de usuario/a, &quot;{$recipientUsername}&quot;.<br />\n<br />\n	Si tiene cualquier pregunta no dude en contactarme.<br />\n<br />\n	{$subscriptionSignature}'),
(297, 'SUBSCRIPTION_AFTER_EXPIRY', 'fr_CA', 'Abonnement échu', 'Abonnement expiré', '{$recipientName},<br />\n<br />\nVotre abonnement à la revue {$journalName} est expiré.<br />\n<br />\n{$subscriptionType}<br />\nDate d''expiration : {$expiryDate}<br />\n<br />\nPour renouveler votre abonnement, veuillez vous rendre sur le site Web de la revue. Vous pouvez y ouvrir une session en utilisant votre nom d''utilisateur-trice, soit « {$recipientUsername} ».<br />\n<br />\nSi vous avez des questions, n''hésitez pas à communiquer avec nous.<br />\n<br />\n{$subscriptionSignature}'),
(298, 'SUBSCRIPTION_AFTER_EXPIRY', 'it', 'Abbonamento scaduto', 'Abbonamento scaduto', 'Gentile {$recipientName}:<br />\n<br />\nIl suo abbonamento a {$journalName} è scaduto.<br />\n<br />\n{$subscriptionType}<br />\nData di scadenza: {$expiryDate}<br />\n<br />\nPer rinnovare l''abbonamento, si rechi sul nostro sito. Per l''accesso utilizzi la sua username, &quot;{$recipientUsername}&quot;.<br />\n<br />\nPer qualsiasi domanda e ulteriore informazione, non esiti a contattarmi.<br />\n<br />\n{$subscriptionSignature}'),
(299, 'SUBSCRIPTION_AFTER_EXPIRY', 'nl', 'Abonnement verlopen', 'Abonnement verlopen - laatste herinnering', '{$recipientName}:<br />\n<br />\nUw abonnement op {$journalName} is verlopen.<br />\n<br />\n{$subscriptionType}<br />\nAfloopdatum: {$expiryDate}<br />\n<br />\nOm uw abonnement te verlengen kunt u inloggen op de website van het tijdschrift met uw gebruikersnaam &quot;{$recipientUsername}&quot;.<br />\n<br />\nAarzel niet om contact met me op te nemen als u vragen heeft.<br />\n<br />\n{$subscriptionSignature}'),
(300, 'SUBSCRIPTION_AFTER_EXPIRY', 'ru', 'Подписка закончилась', 'уведомление об окончании срока подписки', 'Здравствуйте, {$recipientName}!<br />\n<br />\nЗакончилась Ваша подписка на «{$journalName}».<br />\n<br />\n{$subscriptionType}<br />\nДата окончания: {$expiryDate}<br />\n<br />\nДля возобновления подписки, пожалуйста зайдите на сайт журнала. Вы можете авторизоваться в системе с помощью вашего логина &quot;{$recipientUsername}&quot;.<br />\n<br />\nЕсли у Вас возникли вопросы, пожалуйста, свяжитесь со мной.<br />\n<br />\n{$subscriptionSignature}'),
(301, 'SUBSCRIPTION_AFTER_EXPIRY', 'en', 'Subscription Expired', 'Subscription Expired', '{$recipientName}:<br />\n<br />\nYour {$journalName} subscription has expired.<br />\n<br />\n{$subscriptionType}<br />\nExpiry date: {$expiryDate}<br />\n<br />\nTo renew your subscription, please go to the journal website. You are able to log in to the system with your username, &quot;{$recipientUsername}&quot;.<br />\n<br />\nIf you have any questions, please feel free to contact me.<br />\n<br />\n{$subscriptionSignature}'),
(302, 'SUBSCRIPTION_AFTER_EXPIRY_LAST', 'de', 'Zuletzt abgelaufenes Abbonement', 'Abonnement abgelaufen - Letzte Erinnerung', 'Sehr geehrte/r {{$recipientName}<br />\n<br />\nIhr Abonnement für {$journalName} ist abgelaufen.<br />\nBitte beachten Sie, dass dies die letzte Erinnerung ist, die Sie per E-Mail erhalten werden.<br />\n<br />\n{$subscriptionType}<br />\nVerfallsdatum: {$expiryDate}<br />\n<br />\nUm Ihr Abonnement zu verlängern, gehen Sie bitte auf die Website der Zeitschrift. Sie können sich mit Ihrem Benutzernamen "{$recipientUsername}" in das System einloggen.<br />\n<br />\nWenn Sie Fragen haben, können Sie mich gerne kontaktieren.<br />\n<br />\n{$subscriptionSignature}'),
(303, 'SUBSCRIPTION_AFTER_EXPIRY_LAST', 'es', 'Última suscripción caducada', 'Suscripción expirada - Último recordatorio', '{$recipientName}:<br />\n<br />\n	Su suscripción a {$journalName} ha caducado.<br />\n	Tenga en cuenta que este es el último correo que recibirá para recordárselo.<br />\n<br />\n	{$subscriptionType}<br />\n	Fecha de caducidad: {$expiryDate}<br />\n<br />\n	Para renovar su suscripción acceda a la página web de la revista. Puede iniciar sesión en el sistema con su nombre de usuario/a, &quot;{$recipientUsername}&quot;.<br />\n<br />\n	Si tiene cualquier pregunta no dude en contactarme.<br />\n<br />\n	{$subscriptionSignature}'),
(304, 'SUBSCRIPTION_AFTER_EXPIRY_LAST', 'fr_CA', 'Abonnement échu en dernier', 'Abonnement expiré - Dernier rappel', '<p>Bonjour {$recipientName},</p><p>Votre abonnement à la revue {$journalName} est expiré. Veuillez prendre note que ceci est le dernier rappel qui vous sera envoyé.</p><p>{$subscriptionType}</p>\n<p>Date d''expiration : {$expiryDate}</p><p>Pour renouveler votre abonnement, veuillez vous rendre sur le site Web de la revue. Vous pouvez y ouvrir une session avec votre nom d''utilisateur-trice, soit « {$recipientUsername} ».</p><p>Si vous avez des questions, ne hésitez pas à communiquer avec nous.</p>{$subscriptionSignature}'),
(305, 'SUBSCRIPTION_AFTER_EXPIRY_LAST', 'it', 'Abbonamento scaduto l''ultima volta', 'Abbonamento scaduto (ultimo avviso)', 'Gentile {$recipientName}:<br />\n<br />\nIl Suo abbonamento a {$journalName} è scaduto.<br />\nQuesto è l''ultimo promemoria che Le sarà inviato via e-mail.<br />\n<br />\n{$subscriptionType}<br />\nData di scadenza: {$expiryDate}<br />\n<br />\nPer rinnovare l''abbonamento visiti il sito della rivista. Per l''accesso utilizzi il suo username &quot;{$recipientUsername}&quot;.<br />\n<br />\nPer qualsiasi domanda e ulteriore informazione, non esiti a contattarci.<br />\n<br />\n{$subscriptionSignature}'),
(306, 'SUBSCRIPTION_AFTER_EXPIRY_LAST', 'nl', 'Abonnement is verlopen sinds', 'Abonnement verlopen - laatste herinnering', '{$recipientName}:<br />\n<br />\nUw abonnement op {$journalName} is verlopen.<br />\nDit is de laatste herinnering die naar u wordt verstuurd.<br />\n<br />\n{$subscriptionType}<br />\nAfloopdatum: {$expiryDate}<br />\n<br />\nOm uw abonnement te verlengen, kunt u naar de website van het tijdschrift gaan en inloggen met uw gebruikersnaam: &quot;{$recipientUsername}&quot;.<br />\n<br />\nAarzel niet om contact met mij op te nemen als u vragen heeft.<br />\n<br />\n{$subscriptionSignature}'),
(307, 'SUBSCRIPTION_AFTER_EXPIRY_LAST', 'ru', 'Подписка недавно закончилась', 'Срок подписки истек — последнее напоминание', 'Здравствуйте, {$recipientName}!<br />\n<br />\nСрок Вашей подписки на журнал «{$journalName}» истек.<br />\nПожалуйста, обратите внимание, что это — последнее напоминание, которое будет отправлено Вам электронной почтой.<br />\n<br />\n{$subscriptionType}<br />\nДата окончания подписки: {$expiryDate}<br />\n<br />\nДля продления Вашей подписки, пожалуйста, перейдите на сайт журнала. Вы можете войти на сайт журнала со своим именем пользователя «{$recipientUsername}».<br />\n<br />\nЕсли у Вас есть какие-либо вопросы, пожалуйста, не стесняйтесь, связывайтесь со мной.<br />\n<br />\n{$subscriptionSignature}'),
(308, 'SUBSCRIPTION_AFTER_EXPIRY_LAST', 'en', 'Subscription Expired Last', 'Subscription Expired - Final Reminder', '{$recipientName}:<br />\n<br />\nYour {$journalName} subscription has expired.<br />\nPlease note that this is the final reminder that will be emailed to you.<br />\n<br />\n{$subscriptionType}<br />\nExpiry date: {$expiryDate}<br />\n<br />\nTo renew your subscription, please go to the journal website. You are able to log in to the system with your username, &quot;{$recipientUsername}&quot;.<br />\n<br />\nIf you have any questions, please feel free to contact me.<br />\n<br />\n{$subscriptionSignature}'),
(309, 'SUBSCRIPTION_PURCHASE_INDL', 'de', 'Ein individuelles Abonnement kaufen', 'Abonnementkauf: Individuell', 'Ein individuelles Abonnement wurde online für {$journalName} mit den folgenden Details erworben.<br />\n<br />\nAbonnementtyp:<br />\n{$subscriptionType}<br />\n<br />\nBenutzer:<br />\n{$subscriberDetails}<br />\n<br />\nMitgliedschaftsinformationen (falls vorhanden):<br />\n{$membership}<br />\n<br />\nUm dieses Abonnement anzuzeigen oder zu bearbeiten, verwenden Sie bitte die folgende URL.<br />\n<br />\nAbonnement-URL: {$subscriptionUrl}<br />\n'),
(310, 'SUBSCRIPTION_PURCHASE_INDL', 'es', 'Adquirir suscripción individual', 'Compra de suscripción: Individual', 'Se ha adquirido en línea una suscripción individual para {$journalName} con los detalles siguientes:<br />\n<br />\nTipo de suscripción:<br />\n{$subscriptionType}<br />\n<br />\nUsuario/a:<br />\n{$subscriberDetails}<br />\n<br />\nInformación de membresía (si se proporciona):<br />\n{$membership}<br />\n<br />\nPara ver o editar esta suscripción, use la siguiente URL.<br />\n<br />\nURL de la suscripción: {$subscriptionUrl}<br />\n'),
(311, 'SUBSCRIPTION_PURCHASE_INDL', 'fr_CA', 'Acheter un abonnement individuel', 'Souscription à un abonnement individuel', 'Une souscription en ligne à un abonnement individuel pour la revue {$journalName} avec les renseignements suivants :<br />\n<br />\nType d''abonnement :<br />\n{$subscriptionType}<br />\n<br />\nUtilisateur-trice :<br />\n{$subscriberDetails}<br />\n<br />\nInformation d''adhésion (si fournie) :<br />\n{$membership}<br />\n<br />\nPour afficher ou modifier cet abonnement, veuillez utiliser l''URL suivante.<br />\n<br />\nURL d''abonnement : {$subscriptionUrl}<br/>\n'),
(312, 'SUBSCRIPTION_PURCHASE_INDL', 'it', 'Acquisto di un abbonamento individuale', 'Acquisto di un abbonamento individuale', 'Un abbonamento individuale è stato acquistato per {$journalName} con i seguenti dettagli.<br />\n<br />\nTipologia di abbonamento:<br />\n{$subscriptionType}<br />\n<br />\nUser:<br />\n{$subscriberDetails}<br />\n<br />\nInformazioni sulla sottoscrizione (se sono state fornite):<br />\n{$membership}<br />\n<br />\nPer visualizzare o modificare questo abbonamento, utilizzare il seguente URL.<br />\n<br />\nSubscription URL: {$subscriptionUrl}<br />\n'),
(313, 'SUBSCRIPTION_PURCHASE_INDL', 'nl', 'Koop individueel abonnement', 'Aankoop abonnement: individueel', 'Een individueel abonnement met de volgende details is online aangeschaft voor {$journalName}.<br />\n<br />\nAbonnementsoort:<br />\n{$subscriptionType}<br />\n<br />\nGebruiker:<br />\n{$subscriberDetails}<br />\n<br />\nLidmaatschapsinformatie (indien opgegeven):<br />\n{$membership}<br />\n<br />\nGebruik de volgende URL om dit abonnement te bekijken of te wijzigen.<br />\n<br />\nAbonnement URL: {$subscriptionUrl}<br />\n'),
(314, 'SUBSCRIPTION_PURCHASE_INDL', 'ru', 'Приобрести индивидуальную подписку', 'Покупка подписки: индивидуальная', 'На сайте была приобретена индивидуальная подписка на журнал «{$journalName}» со следующими деталями.<br />\n<br />\nТип подписки:<br />\n{$subscriptionType}<br />\n<br />\nПользователь:<br />\n{$subscriberDetails}<br />\n<br />\nИнформация о членстве (если указана):<br />\n{$membership}<br />\n<br />\nДля просмотра или редактирования этой подписки, пожалуйста, используйте следующий URL.<br />\n<br />\nURL подписки: {$subscriptionUrl}<br />\n'),
(315, 'SUBSCRIPTION_PURCHASE_INDL', 'en', 'Purchase Individual Subscription', 'Subscription Purchase: Individual', 'An individual subscription has been purchased online for {$journalName} with the following details.<br />\n<br />\nSubscription Type:<br />\n{$subscriptionType}<br />\n<br />\nUser:<br />\n{$subscriberDetails}<br />\n<br />\nMembership Information (if provided):<br />\n{$membership}<br />\n<br />\nTo view or edit this subscription, please use the following URL.<br />\n<br />\nSubscription URL: {$subscriptionUrl}<br />\n');
INSERT INTO `email_templates_default_data` VALUES
(316, 'SUBSCRIPTION_PURCHASE_INSTL', 'de', 'Ein institutionelles Abonnement kaufen', 'Abonnementkauf: Institutionell', 'Ein institutionelles Abonnement wurde online für {$journalName} mit den folgenden Details erworben. Um dieses Abonnement zu aktivieren, verwenden Sie bitte die bereitgestellte Abonnement-URL und setzen Sie den Abonnementstatus auf ''Aktiv''.<br />\n<br />\nAbonnementtyp:<br />\n{$subscriptionType}<br />\n<br />\nInstitution:<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nDomain (falls vorhanden):<br />\n{$domain}<br />\n<br />\nIP-Bereiche (falls angegeben):<br />\n{$ipRanges}<br />\n<br />\nKontaktperson:<br />\n{$subscriberDetails}<br />\n<br />\nMitgliedschaftsinformationen (falls vorhanden):<br />\n{$membership}<br />\n<br />\nUm dieses Abonnement anzuzeigen oder zu bearbeiten, verwenden Sie bitte die folgende URL.<br />\n<br />\nAbonnement-URL: {$subscriptionUrl}<br />\n'),
(317, 'SUBSCRIPTION_PURCHASE_INSTL', 'es', 'Adquirir suscripción institucional', 'Compra de suscripción: Institucional', 'Se ha adquirido en línea una suscripción institucional para {$journalName} con los siguientes detalles. Para activar la suscripción, use el enlace proporcionado y configure el estado de la suscripción como ''Activo''.<br />\n<br />\nTipo de suscripción:<br />\n{$subscriptionType}<br />\n<br />\nInstitución:<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nDominio (si se proporciona):<br />\n{$domain}<br />\n<br />\nRangos de IP (si se proporcionan):<br />\n{$ipRanges}<br />\n<br />\nPersona de contacto:<br />\n{$subscriberDetails}<br />\n<br />\nInformación de membresía (si se proporciona):<br />\n{$membership}<br />\n<br />\nPara ver o editar esta suscripción, use el siguiente enlace.<br />\n<br />\nEnlace de la suscripción: {$subscriptionUrl}<br />\n'),
(318, 'SUBSCRIPTION_PURCHASE_INSTL', 'fr_CA', 'Acheter un abonnement institutionnel', 'Souscription à un abonnement institutionnel', 'Souscription en ligne à un abonnement institutionnel pour la revue {$journalName} avec les renseignements suivants. Pour activer cet abonnement, veuillez utiliser l''URL d''abonnement fourni et fixer le statut de l''abonnement à « actif ».<br />\n<br />\nType d''abonnement :<br />\n{$subscriptionType}<br />\n<br />\nÉtablissement :<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nDomaine (si fourni) :<br />\n{$domain}<br />\n<br />\nPlage d''adresses IP (si fournie) :<br />\n{$ipRanges}<br />\n<br />\nPersonne-ressource :<br />\n{$subscriberDetails}<br />\n<br />\nRenseignements d''adhésion (si fournis) :<br />\n{$membership}<br />\n<br />\nPour afficher ou modifier cet abonnement, veuillez utiliser l''URL suivant :<br />\n<br />\nURL de l''abonnement : {$subscriptionUrl}<br />\n'),
(319, 'SUBSCRIPTION_PURCHASE_INSTL', 'it', 'Acquisto di un abbonamento istituzionale', 'Acquisto di un abbonamento istituzionale', 'È stato acquistato un abbonamento istituzionale a {$journalName} con i dettagli indicati sotto. Per attivare l''abbonamento, utilizzare il link fornito sotto e selezionare lo status ''Attivo'' per tale abbonamento.<br />\n<br />\nTipologia di abbonamento::<br />\n{$subscriptionType}<br />\n<br />\nInstituzione:<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nDominio (se indicato):<br />\n{$domain}<br />\n<br />\nIndirizzi IP (se indicati):<br />\n{$ipRanges}<br />\n<br />\nPersona di contatto:<br />\n{$subscriberDetails}<br />\n<br />\nTipologia di membership (se indicata):<br />\n{$membership}<br />\n<br />\nPer vedere o modificare i dettagli, andare alla pagina:<br />\n<br />\nSubscription URL: {$subscriptionUrl}<br />\n'),
(320, 'SUBSCRIPTION_PURCHASE_INSTL', 'nl', 'Koop instituutsabonnement', 'Aankoop abonnement: institutioneel', 'Er is online een institutioneel abonnement gekocht voor {$journalName} met de volgende details. Gebruik de abonnement-url om dit abonnement te activeren. Zet de status van het abonnement op ''Actief''.<br />\n<br />\nAbonnementsoort:<br />\n{$subscriptionType}<br />\n<br />\nInstituut:<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nDomein (indien opgegeven):<br />\n{$domain}<br />\n<br />\nIP reeksen (indien opgegeven):<br />\n{$ipRanges}<br />\n<br />\nContactpersoon:<br />\n{$subscriberDetails}<br />\n<br />\nLidmaatschapsinformatie (indien opgegeven):<br />\n{$membership}<br />\n<br />\nGebruik de volgende URL om het abonnement te bekijken of te bewerken.<br />\n<br />\nAbonnement URL: {$subscriptionUrl}<br />\n'),
(321, 'SUBSCRIPTION_PURCHASE_INSTL', 'ru', 'Приобрести подписку на организацию', 'Покупка подписки: на организацию', 'На сайте была приобретена для организации подписка на журнал «{$journalName}» со следующими деталями. Для активации подписки, пожалуйста, используйте приведенный URL подписки и установите статус подписки в «Активна».<br />\n<br />\nТип подписки:<br />\n{$subscriptionType}<br />\n<br />\nОрганизация:<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nДоменное имя (если указано):<br />\n{$domain}<br />\n<br />\nIP-диапазоны (если указаны):<br />\n{$ipRanges}<br />\n<br />\nКонтактное лицо:<br />\n{$subscriberDetails}<br />\n<br />\nИнформация о членстве (если указана):<br />\n{$membership}<br />\n<br />\nДля просмотра или редактирования этой подписки, пожалуйста, используйте следующий URL.<br />\n<br />\nURL подписки: {$subscriptionUrl}<br />\n'),
(322, 'SUBSCRIPTION_PURCHASE_INSTL', 'en', 'Purchase Institutional Subscription', 'Subscription Purchase: Institutional', 'An institutional subscription has been purchased online for {$journalName} with the following details. To activate this subscription, please use the provided Subscription URL and set the subscription status to ''Active''.<br />\n<br />\nSubscription Type:<br />\n{$subscriptionType}<br />\n<br />\nInstitution:<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nDomain (if provided):<br />\n{$domain}<br />\n<br />\nIP Ranges (if provided):<br />\n{$ipRanges}<br />\n<br />\nContact Person:<br />\n{$subscriberDetails}<br />\n<br />\nMembership Information (if provided):<br />\n{$membership}<br />\n<br />\nTo view or edit this subscription, please use the following URL.<br />\n<br />\nSubscription URL: {$subscriptionUrl}<br />\n'),
(323, 'SUBSCRIPTION_RENEW_INDL', 'de', 'Individuelles Abonnement erneuern', 'Abonnementerneuerung: Individuell', 'Ein individuelles Abonnement wurde online für {$journalName} mit den folgenden Details verlängert.<br />\n<br />\nAbonnementtyp:<br />\n{$subscriptionType}<br />\n<br />\nBenutzer:<br />\n{$subscriberDetails}<br />\n<br />\nMitgliedschaftsinformationen (falls vorhanden):<br />\n{$membership}<br />\n<br />\nUm dieses Abonnement anzuzeigen oder zu bearbeiten, verwenden Sie bitte die folgende URL.<br />\n<br />\nAbonnement-URL: {$subscriptionUrl}<br />\n'),
(324, 'SUBSCRIPTION_RENEW_INDL', 'es', 'Renovar suscripción individual', 'Renovación de suscripción: Individual', 'Una suscripción individual ha sido renovada en línea para {$journalName} con los siguientes detalles.<br />\n<br />\nTipo de suscripción:<br />\n{$subscriptionType}<br />\n<br />\nUsuario/a:<br />\n{$subscriberDetails}<br />\n<br />\nInformación de membresía (si se proporciona):<br />\n{$membership}<br />\n<br />\nPara ver o editar esta suscripción use la siguiente URL:<br />\n<br />\nURL para gestionar la suscripción: {$subscriptionUrl}<br />\n'),
(325, 'SUBSCRIPTION_RENEW_INDL', 'fr_CA', 'Renouveler l''abonnement individuel', 'Renouvellement d''abonnement individuel', 'Un abonnement individuel a été renouvelé en ligne pour la revue {$journalName} avec les renseignements suivants.<br />\n<br />\nType d''abonnement :<br />\n{$subscriptionType}<br />\n<br />\nUtilisateur-trice :<br />\n{$subscriberDetails}<br />\n<br />\nRenseignements d''adhésion (si fournis) :<br />\n{$membership}<br />\n<br />\nPour afficher ou modifier cet abonnement, veuillez utiliser l''URL suivant.<br />\n<br />\nURL de l''abonnement : {$subscriptionUrl}<br />\n'),
(326, 'SUBSCRIPTION_RENEW_INDL', 'it', 'Rinnovo dell''abbonamento individuale', 'Rinnovo dell''abbonamento individuale', 'È stato rinnovato un abbonamento individuale a {$journalName} con i seguenti dettagli.<br />\n<br />\nTipologia di abbonamento:<br />\n{$subscriptionType}<br />\n<br />\nUtente:<br />\n{$subscriberDetails}<br />\n<br />\nMembership (se indicata):<br />\n{$membership}<br />\n<br />\nPer vedere o modificare i dettagli dell''abbonamento, andare alla seguente pagina:<br />\n<br />\nSubscription URL: {$subscriptionUrl}<br />\n'),
(327, 'SUBSCRIPTION_RENEW_INDL', 'nl', 'Vernieuw individueel abonnement', 'Verlenging abonnement: individueel', 'Een individueel abonnement is met de volgende details online verlengd voor {$journalName}.<br />\n<br />\nAbonnementsoort:<br />\n{$subscriptionType}<br />\n<br />\nGebruiker:<br />\n{$subscriberDetails}<br />\n<br />\nLidmaatschapsinformatie (indien opgegeven):<br />\n{$membership}<br />\n<br />\nGebruik de volgende URL om het abonnement te bekijken of bewerken.<br />\n<br />\nAbonnement URL: {$subscriptionUrl}<br />\n'),
(328, 'SUBSCRIPTION_RENEW_INDL', 'ru', 'Продлить индивидуальную подписку', 'Продление подписки: индивидуальная', 'На сайте была продлена индивидуальная подписка на журнал «{$journalName}» со следующими деталями.<br />\n<br />\nТип подписки:<br />\n{$subscriptionType}<br />\n<br />\nПользователь:<br />\n{$subscriberDetails}<br />\n<br />\nИнформация о членстве (если указана):<br />\n{$membership}<br />\n<br />\nДля просмотра или редактирования этой подписки, пожалуйста, используйте следующий URL.<br />\n<br />\nURL подписки: {$subscriptionUrl}<br />\n'),
(329, 'SUBSCRIPTION_RENEW_INDL', 'en', 'Renew Individual Subscription', 'Subscription Renewal: Individual', 'An individual subscription has been renewed online for {$journalName} with the following details.<br />\n<br />\nSubscription Type:<br />\n{$subscriptionType}<br />\n<br />\nUser:<br />\n{$subscriberDetails}<br />\n<br />\nMembership Information (if provided):<br />\n{$membership}<br />\n<br />\nTo view or edit this subscription, please use the following URL.<br />\n<br />\nSubscription URL: {$subscriptionUrl}<br />\n'),
(330, 'SUBSCRIPTION_RENEW_INSTL', 'de', 'Institutionelles Abonnement erneuern', 'Abonnementerneuerung: Institutionell', 'Ein institutionelles Abonnement wurde online für {$journalName} mit den folgenden Angaben verlängert.<br />\n<br />\nAbonnementtyp:<br />\n{$subscriptionType}<br />\n<br />\nInstitution:<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nDomain (falls vorhanden):<br />\n{$domain}<br />\n<br />\nIP-Bereiche (falls angegeben):<br />\n{$ipRanges}<br />\n<br />\nKontaktperson:<br />\n{$subscriberDetails}<br />\n<br />\nMitgliedschaftsinformationen (falls vorhanden):<br />\n{$membership}<br />\n<br />\nUm dieses Abonnement anzuzeigen oder zu bearbeiten, verwenden Sie bitte die folgende URL.<br />\n<br />\nAbonnement-URL: {$subscriptionUrl}<br />\n'),
(331, 'SUBSCRIPTION_RENEW_INSTL', 'es', 'Renovar suscripción institucional', 'Renovación de suscripción: Institucional', 'Se ha renovado en línea una suscripción institucional para {$journalName} con los detalles siguientes.<br />\n<br />\nTipo de suscripción:<br />\n{$subscriptionType}<br />\n<br />\nInstitución:<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nDominio (si se proporciona):<br />\n{$domain}<br />\n<br />\nRangos IP (si se proporcionan):<br />\n{$ipRanges}<br />\n<br />\nPersona de contacto:<br />\n{$subscriberDetails}<br />\n<br />\nInformación de membresía (si se proporciona):<br />\n{$membership}<br />\n<br />\nPara ver o editar esta suscripción use la siguiente URL:<br />\n<br />\nURL para gestionar la suscripción: {$subscriptionUrl}<br />\n'),
(332, 'SUBSCRIPTION_RENEW_INSTL', 'fr_CA', 'Renouveler l''abonnement institutionnel', 'Renouvellement d''abonnement institutionnel', 'Un abonnement institutionnel a été renouvelé en ligne pour la revue {$journalName} avec les renseignements suivants.<br />\n<br />\nType d''abonnement :<br />\n{$subscriptionType}<br />\n<br />\nÉtablissement :<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nDomaine (si fourni) :<br />\n{$domain}<br />\n<br />\nPlage d''adresses IP (si fournie) :<br />\n{$ipRanges}<br />\n<br />\nPersonne-ressource :<br />\n{$subscriberDetails}<br />\n<br />\nRenseignements d''adhésion (si fournis) :<br />\n{$membership}<br />\n<br />\nPour afficher ou modifier cet abonnement, veuillez utiliser l''URL suivant.<br />\n<br />\nURL de l''abonnement : {$subscriptionUrl}<br />\n'),
(333, 'SUBSCRIPTION_RENEW_INSTL', 'it', 'Rinnovo dell''abbonamento istituzionale', 'Rinnovo dell''abbonamento istituzionale', 'È stato rinnovato online un abbonamento istituzionale a {$journalName} con i seguenti dettagli.<br />\n<br />\nTipologia di abbonamento:<br />\n{$subscriptionType}<br />\n<br />\nInstituzione:<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nDominio (se fornito):<br />\n{$domain}<br />\n<br />\nIndirizzi IP (se indicati):<br />\n{$ipRanges}<br />\n<br />\nPersona di contatto:<br />\n{$subscriberDetails}<br />\n<br />\nMembership (se indicata):<br />\n{$membership}<br />\n<br />\nPer vedere o modificare i dettagli, andare alla seguente pagina:<br />\n<br />\nSubscription URL: {$subscriptionUrl}<br />\n'),
(334, 'SUBSCRIPTION_RENEW_INSTL', 'nl', 'Vernieuw instituutsabonnement', 'Verlenging abonnement: institutioneel', 'Een institutioneell abonnement voor {$journalName} is met de volgende gegevens online verlengd.<br />\n<br />\nAbonnementsoort:<br />\n{$subscriptionType}<br />\n<br />\nInstituut:<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nDomein (indien opgegeven):<br />\n{$domain}<br />\n<br />\nIP reeksen (indien opgegeven):<br />\n{$ipRanges}<br />\n<br />\nContactpersoon:<br />\n{$subscriberDetails}<br />\n<br />\nLidmaatschapsinformatie (indien opgegeven):<br />\n{$membership}<br />\n<br />\nGebruik de volgende URL om dit abonnement te bekijken of bewerken.<br />\n<br />\nAbonnement URL: {$subscriptionUrl}<br />\n'),
(335, 'SUBSCRIPTION_RENEW_INSTL', 'ru', 'Продлить подписку на организацию', 'Продление подписки: на организацию', 'На сайте для организации была продлена подписка на журнал «{$journalName}» со следующими деталями.<br />\n<br />\nТип подписки:<br />\n{$subscriptionType}<br />\n<br />\nОрганизация:<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nДоменное имя (если указано):<br />\n{$domain}<br />\n<br />\nIP-диапазоны (если указаны):<br />\n{$ipRanges}<br />\n<br />\nКонтактное лицо:<br />\n{$subscriberDetails}<br />\n<br />\nИнформация о членстве (если указана):<br />\n{$membership}<br />\n<br />\nДля просмотра или редактирования этой подписки, пожалуйста, используйте следующий URL.<br />\n<br />\nURL подписки: {$subscriptionUrl}<br />\n'),
(336, 'SUBSCRIPTION_RENEW_INSTL', 'en', 'Renew Institutional Subscription', 'Subscription Renewal: Institutional', 'An institutional subscription has been renewed online for {$journalName} with the following details.<br />\n<br />\nSubscription Type:<br />\n{$subscriptionType}<br />\n<br />\nInstitution:<br />\n{$institutionName}<br />\n{$institutionMailingAddress}<br />\n<br />\nDomain (if provided):<br />\n{$domain}<br />\n<br />\nIP Ranges (if provided):<br />\n{$ipRanges}<br />\n<br />\nContact Person:<br />\n{$subscriberDetails}<br />\n<br />\nMembership Information (if provided):<br />\n{$membership}<br />\n<br />\nTo view or edit this subscription, please use the following URL.<br />\n<br />\nSubscription URL: {$subscriptionUrl}<br />\n'),
(337, 'REVISED_VERSION_NOTIFY', 'de', 'Benachrichtigung über eine überarbeitete Version', 'Überarbeitete Version hochgeladen', '<p>Liebe/r {$recipientName},</p><p>der Autor/die Autorin hat Überarbeitungen für die Einreichung <b>{$authorsShort} - {$submissionTitle}</b> hochgeladen. <p>Als zugewiesene/r Redakteur/in bitten wir Sie, sich einzuloggen und <a href="{$submissionUrl}">die Überarbeitungen</a> anzusehen und eine Entscheidung zu treffen, ob Sie die Einreichung annehmen, ablehnen oder zur weiteren Überprüfung weiterleiten möchten.</p><br><br>-<br>Dies ist eine automatische Nachricht von <a href="{$journalUrl}">{$journalName}</a>.'),
(338, 'REVISED_VERSION_NOTIFY', 'es', 'Notificación de versión revisada', 'Versión revisada cargada', '<p>Estimado/a {$recipientName},</p><p>El autor/a ha cargado revisiones para el envío, <b>{$authorsShort} — {$submissionTitle}</b>.</p><p>Como editor/a asignado, le solicitamos que inicie sesión, <a href="{$submissionUrl}">visualice las revisiones</a> y tome la decisión de aceptar, rechazar o remitir el envío a otra revisión.</p><br><br>—<br>Este es un mensaje automatizado de <a href="{$journalUrl}">{$journalName}</a>.'),
(339, 'REVISED_VERSION_NOTIFY', 'fr_CA', 'Notification de la version révisée', 'Version révisée téléversée', '<p>Bonjour {$recipientName},</p><p>Une version révisée de « {$submissionTitle} » a été téléversée par l''auteur-e {$submitterName}.</p><p>URL de la soumission : {$submissionUrl}</p>. <p>Ceci est un message automatique de <a href="{$journalUrl}">{$journalName}</a>.</p>'),
(340, 'REVISED_VERSION_NOTIFY', 'it', '', 'Caricamento della versione revisionata', '<p>Gentile {$recipientName},</p><p>L''autore ha caricato la revisione della sua proposta editoriale, <b>{$authorsShort} — {$submissionTitle}</b>. <p>In quanto editor assegnato, Le saremmo grati se potesse effettuare il login, <a href="{$submissionUrl}">visualizzare le revisioni</a> e infine decidere sull''accettazione, sul rifiuto, o sull''eventuale invio della proposta a ulteriori richieste di revisioni.</p><br><br>—<br>Questo è un messaggio automatico da <a href="{$journalUrl}">{$journalName}</a>.'),
(341, 'REVISED_VERSION_NOTIFY', 'nl', 'Bericht Herziene Versie', 'Herziene versie geladen', '{$recipientName}:<br />\n<br />\nEen herziene versie van &quot;{$submissionTitle}&quot; is geladen door de auteur {$submitterName}.<br />\n<br />\nURL van de inzending: {$submissionUrl}<br />\n<br />\n{$signature}'),
(342, 'REVISED_VERSION_NOTIFY', 'ru', 'Уведомление об измененной версии', 'Загружена исправленная версия', '<p>Здравствуйте, {$recipientName}!</p><p>Автор загрузил исправленную версию для материала <b>{$authorsShort} — «{$submissionTitle}»</b>. <p>Как назначенного редактора мы просим Вас войти в систему, <a href="{$submissionUrl}">просмотреть исправленную версию</a> и принять решение о приёме, отклонении или отправке материала на дальнейшее рецензирование.</p><br><br>—<br>Это автоматическое сообщение из журнала <a href="{$journalUrl}">«{$journalName}»</a>.'),
(343, 'REVISED_VERSION_NOTIFY', 'en', 'Revised Version Notification', 'Revised Version Uploaded', '<p>Dear {$recipientName},</p><p>The author has uploaded revisions for the submission, <b>{$authorsShort} — {$submissionTitle}</b>. <p>As an assigned editor, we ask that you login and <a href="{$submissionUrl}">view the revisions</a> and make a decision to accept, decline or send the submission for further review.</p><br><br>—<br>This is an automated message from <a href="{$journalUrl}">{$journalName}</a>.'),
(344, 'STATISTICS_REPORT_NOTIFICATION', 'de', 'Benachrichtigung über einen Statistikbericht', 'Redaktionelle Aktivitäten für {$month}, {$year}', '\nSehr geehrte/r {$recipientName} <br />\n<br />\nIhr Zeitschriftenbericht für {$month}, {$year} ist jetzt verfügbar. Ihre wichtigsten Statistiken für diesen Monat:<br />\n<ul>\n	<li>Neue Einreichungen diesen Monat: {$newSubmissions}</li>\n	<li>Abgelehnte Einreichungen diesen Monat: {$declinedSubmissions}</li>\n	<li>Angenommene Einsendungen in diesem Monat: {$acceptedSubmissions}</li>\n	<li>Gesamtanzahl der Einreichungen im System: {$totalSubmissions}</li>\n</ul>\nMelden Sie sich bei der Zeitschrift an, um detailliertere <a href="{$editorialStatsLink}">Redaktionstrends</a> und <a href="{$publicationStatsLink}">Statistiken zu veröffentlichten Artikeln</a> anzuzeigen. Eine vollständige Kopie der redaktionellen Trends für diesen Monat ist beigefügt.<br />\n<br />\nMit freundlichen Grüßen,<br />\n{$journalSignature}'),
(345, 'STATISTICS_REPORT_NOTIFICATION', 'es', 'Notificación de informe de estadísticas', 'Actividad editorial por {$month}, {$year}', '\n{$recipientName}, <br />\n<br />\nEl informe de estado de su revista de {$month}, {$year} ya está disponible. Las estadísticas clave de este mes son las siguientes.<br />\n<ul>\n	<li>Nuevos envíos este mes: {$newSubmissions}</li>\n	<li>Envíos rechazados este mes: {$declinedSubmissions}</li>\n	<li>Envíos aceptados este mes: {$acceptedSubmissions}</li>\n	<li>Envíos totales en el sistema: {$totalSubmissions}</li>\n</ul>\nInicie sesión en la revista para obtener más detalles sobre las <a href="{$editorialStatsLink}">tendencias editoriales</a> y las <a href="{$publicationStatsLink}">estadísticas de artículos publicados</a>. Se adjunta una copia completa del informe correspondiente a este mes .<br />\n<br />\nSaludos cordiales,<br />\n{$journalSignature}'),
(346, 'STATISTICS_REPORT_NOTIFICATION', 'fr_CA', 'Notification sur les rapports statistiques', 'Activité éditoriale pour {$month} {$year}', '\n{$recipientName}, <br />\n<br />\nLe rapport d''activité éditoriale de votre revue pour {$month} {$year} est maintenant disponible. Les principales statistiques pour ce mois sont affichées ci-dessous.<br />\n<ul>\n	<li> Nouvelles soumissions pour ce mois : {$newSubmissions} </li>\n	<li> Soumissions refusées pour ce mois : {$declinedSubmissions} </li>\n	<li> Soumissions acceptées pour ce mois : {$acceptedSubmissions} </li>\n	<li> Nombre total de soumissions dans la plateforme : {$totalSubmissions} </li>\n</ul>\nConnectez-vous au site de la revue pour voir davantage de <a href="{$editorialStatsLink}">tendances dans l''activité éditoriale</a> ainsi que des <a href="{$publicationStatsLink}">statistiques relatives aux articles publiés</a>. Le rapport complet des tendances de l''activité éditoriale de ce mois-ci est joint au présent envoi.<br />\n<br />\nCordialement,<br />\n{$journalSignature}'),
(347, 'STATISTICS_REPORT_NOTIFICATION', 'it', '', 'Attività editoriali per {$month}, {$year}', '\nGentile {$recipientName}, <br />\n<br />\nIl riepilogo della sua rivista per il mese di {$month}, {$year} è ora disponibile. Di seguito sono indicate le statistiche principali:<br />\n<ul>\n	<li>nuove proposte ricevute: {$newSubmissions}</li>\n	<li>proposte rifiutate: {$declinedSubmissions}</li>\n	<li>proposte accettate: {$acceptedSubmissions}</li>\n	<li>contributi totali presenti nel sistema: {$totalSubmissions}</li>\n</ul>\nAcceda al sito web per consultare maggiori dettagli relativi alle <a href="{$editorialStatsLink}">statistiche editoriali</a> e <a href="{$publicationStatsLink}">ai dati relativi ai contributi pubblicati</a>. Una copia completa del riepilogo mensile è inviata in allegato.<br />\n<br />\nCordiali saluti,<br />\n{$journalSignature}'),
(348, 'STATISTICS_REPORT_NOTIFICATION', 'nl', '', 'Redactionele activiteit voor {$month}, {$year}', '\n{$recipientName}, <br />\n<br />\nUw tijdschriftgezondheidsrapport voor {$month}, {$year} is nu beschikbaar. Hieronder vindt u uw belangrijkste statistieken voor deze maand.<br />\n<ul>\n	<li>Nieuwe inzendingen deze maand: {$newSubmissions}</li>\n	<li>Afgewezen inzendingen deze maand: {$declinedSubmissions}</li>\n	<li>Geaccepteerde inzendingen deze maand: {$acceptedSubmissions}</li>\n	<li>Totaal aantal inzendingen in het systeem: {$totalSubmissions}</li>\n</ul>\nLog in op het tijdschrift om meer gedetailleerde <a href="{$editorialStatsLink}">redactionele trends </a> and <a href="{$publicationStatsLink}">gepubliceerde artikelstatistieken</a> te bekijken . Een volledig exemplaar van de redactionele trends van deze maand is bijgevoegd.<br />\n<br />\nVriendelijke groet,<br />\n{$journalSignature}'),
(349, 'STATISTICS_REPORT_NOTIFICATION', 'ru', 'Уведомление о статистическом отчете', 'Активность журнала за {$month} {$year} года', '\nЗдравствуйте, {$recipientName}! <br />\n<br />\nОтчёт об активности журнала за {$month} {$year} года уже доступен. Ключевые статистические параметры этого месяца приведены ниже.<br />\n<ul>\n	<li>Новых материалов за месяц: {$newSubmissions}</li>\n	<li>Отклонено материалов за месяц: {$declinedSubmissions}</li>\n	<li>Принято материалов за месяц: {$acceptedSubmissions}</li>\n	<li>Общее число материалов в системе: {$totalSubmissions}</li>\n</ul>\nВойдите в систему, чтобы посмотреть более подробные отчёты о <a href="{$editorialStatsLink}">тенденциях редакции</a> и <a href="{$publicationStatsLink}">статистике опубликованных статей</a>. Полная копия отчёта о тенденциях редакции за данный месяц прилагается к письму.<br />\n<br />\nС уважением,<br />\n{$journalSignature}'),
(350, 'STATISTICS_REPORT_NOTIFICATION', 'en', 'Statistics Report Notification', 'Editorial activity for {$month}, {$year}', '\n{$recipientName}, <br />\n<br />\nYour journal health report for {$month}, {$year} is now available. Your key stats for this month are below.<br />\n<ul>\n	<li>New submissions this month: {$newSubmissions}</li>\n	<li>Declined submissions this month: {$declinedSubmissions}</li>\n	<li>Accepted submissions this month: {$acceptedSubmissions}</li>\n	<li>Total submissions in the system: {$totalSubmissions}</li>\n</ul>\nLogin to the journal to view more detailed <a href="{$editorialStatsLink}">editorial trends</a> and <a href="{$publicationStatsLink}">published article stats</a>. A full copy of this month''s editorial trends is attached.<br />\n<br />\nSincerely,<br />\n{$journalSignature}'),
(351, 'ANNOUNCEMENT', 'de', 'Neue Mitteilung', '{$announcementTitle}', '<b>{$announcementTitle}</b><br />\n<br />\n{$announcementSummary}<br />\n<br />\nBesuchen Sie unsere Website, um die <a href="{$announcementUrl}">vollständige Ankündigung</a> zu lesen.'),
(352, 'ANNOUNCEMENT', 'es', 'Nuevo aviso', '{$announcementTitle}', '<b>{$announcementTitle}</b><br />\n<br />\n{$announcementSummary}<br />\n<br />\nVisite nuestro site para leer el <a href="{$announcementUrl}">anuncio completo</a>.'),
(353, 'ANNOUNCEMENT', 'fr_CA', 'Nouvelle annonce', '{$announcementTitle}', '<b>{$announcementTitle}</b><br />\n<br />\n{$announcementSummary}<br />\n<br />\nVisiter notre site Web pour consulter <a href="{$announcementUrl}">l''annonce complète</a>.'),
(354, 'ANNOUNCEMENT', 'it', '', '{$announcementTitle}', '<b>{$announcementTitle}</b><br />\n<br />\n{$announcementSummary}<br />\n<br />\nVisiti il nostro sito per leggere <a href="{$announcementUrl}">l''informazione completa</a>.'),
(355, 'ANNOUNCEMENT', 'nl', 'Nieuw nieuwsbericht', '{$announcementTitle}', '<b>{$announcementTitle}</b><br />\n<br />\n{$announcementSummary}<br />\n<br />\nBezoek onze website om de <a href="{$announcementUrl}">volledige aankondiging</a> te lezen.'),
(356, 'ANNOUNCEMENT', 'ru', 'Новое объявление', '{$announcementTitle}', '<b>{$announcementTitle}</b><br />\n<br />\n{$announcementSummary}<br />\n<br />\nПосетите наш веб-сайт, чтобы прочитать <a href="{$announcementUrl}">объявление полностью</a>.'),
(357, 'ANNOUNCEMENT', 'en', 'New Announcement', '{$announcementTitle}', '<b>{$announcementTitle}</b><br />\n<br />\n{$announcementSummary}<br />\n<br />\nVisit our website to read the <a href="{$announcementUrl}">full announcement</a>.'),
(358, 'DISCUSSION_NOTIFICATION_SUBMISSION', 'de', 'Diskussion (Einreichung)', 'Eine Nachricht bezüglich {$journalName}', 'Bitte geben Sie Ihre Nachricht ein.'),
(359, 'DISCUSSION_NOTIFICATION_SUBMISSION', 'es', 'Discusión (envío)', 'Mensaje sobre {$journalName}', 'Introduzca su mensaje.'),
(360, 'DISCUSSION_NOTIFICATION_SUBMISSION', 'fr_CA', 'Discussion (soumission)', 'Un message à propos de la revue {$journalName}', 'Prière de saisir votre message.'),
(361, 'DISCUSSION_NOTIFICATION_SUBMISSION', 'it', '', 'Nuovo messaggio da: {$journalName}', 'Inserisci qui il testo del tuo messaggio.'),
(362, 'DISCUSSION_NOTIFICATION_SUBMISSION', 'nl', 'Discussie (Inzending)', 'Een bericht over {$journalName}', 'Voeg hier uw boodschap in.'),
(363, 'DISCUSSION_NOTIFICATION_SUBMISSION', 'ru', 'Обсуждение (Материал)', 'Сообщение о журнале «{$journalName}»', 'Пожалуйста, введите свое сообщение.'),
(364, 'DISCUSSION_NOTIFICATION_SUBMISSION', 'en', 'Discussion (Submission)', 'A message regarding {$journalName}', 'Please enter your message.'),
(365, 'DISCUSSION_NOTIFICATION_REVIEW', 'de', 'Diskussion (Begutachtung)', 'Eine Nachricht bezüglich {$journalName}', 'Bitte geben Sie Ihre Nachricht ein.'),
(366, 'DISCUSSION_NOTIFICATION_REVIEW', 'es', 'Discusión (revisión)', 'Mensaje sobre {$journalName}', 'Introduzca su mensaje.'),
(367, 'DISCUSSION_NOTIFICATION_REVIEW', 'fr_CA', 'Discussion (évaluation)', 'Un message à propos de la revue {$journalName}', 'Prière de saisir votre message.'),
(368, 'DISCUSSION_NOTIFICATION_REVIEW', 'it', '', 'Nuovo messaggio da: {$journalName}', 'Inserisci qui il testo del tuo messaggio.'),
(369, 'DISCUSSION_NOTIFICATION_REVIEW', 'nl', 'Discussie (Review)', 'Een bericht over {$journalName}', 'Voeg hier uw boodschap in.'),
(370, 'DISCUSSION_NOTIFICATION_REVIEW', 'ru', 'Обсуждение (Рецензирование)', 'Сообщение о журнале «{$journalName}»', 'Пожалуйста, введите свое сообщение.'),
(371, 'DISCUSSION_NOTIFICATION_REVIEW', 'en', 'Discussion (Review)', 'A message regarding {$journalName}', 'Please enter your message.'),
(372, 'DISCUSSION_NOTIFICATION_COPYEDITING', 'de', 'Diskussion (Lektorat)', 'Eine Nachricht bezüglich {$journalName}', 'Bitte geben Sie Ihre Nachricht ein.'),
(373, 'DISCUSSION_NOTIFICATION_COPYEDITING', 'es', 'Discusión (edición)', 'Mensaje sobre {$journalName}', 'Introduzca su mensaje.'),
(374, 'DISCUSSION_NOTIFICATION_COPYEDITING', 'fr_CA', 'Discussion (révision)', 'Un message à propos de la revue {$journalName}', 'Prière de saisir votre message.'),
(375, 'DISCUSSION_NOTIFICATION_COPYEDITING', 'it', '', 'Nuovo messaggio da: {$journalName}', 'Inserisci qui il testo del tuo messaggio.'),
(376, 'DISCUSSION_NOTIFICATION_COPYEDITING', 'nl', 'Discussie (Copyediting)', 'Een bericht over {$journalName}', 'Voeg hier uw boodschap in.'),
(377, 'DISCUSSION_NOTIFICATION_COPYEDITING', 'ru', 'Обсуждение (Литературное редактирование)', 'Сообщение о журнале «{$journalName}»', 'Пожалуйста, введите свое сообщение.'),
(378, 'DISCUSSION_NOTIFICATION_COPYEDITING', 'en', 'Discussion (Copyediting)', 'A message regarding {$journalName}', 'Please enter your message.'),
(379, 'DISCUSSION_NOTIFICATION_PRODUCTION', 'de', 'Diskussion (Produktion)', 'Eine Nachricht bezüglich {$journalName}', 'Bitte geben Sie Ihre Nachricht ein.'),
(380, 'DISCUSSION_NOTIFICATION_PRODUCTION', 'es', 'Discusión (producción)', 'Mensaje sobre {$journalName}', 'Introduzca su mensaje.'),
(381, 'DISCUSSION_NOTIFICATION_PRODUCTION', 'fr_CA', 'Discussion (production)', 'Un message à propos de la revue {$journalName}', 'Prière de saisir votre message.'),
(382, 'DISCUSSION_NOTIFICATION_PRODUCTION', 'it', '', 'Nuovo messaggio da: {$journalName}', 'Inserisci qui il testo del tuo messaggio.'),
(383, 'DISCUSSION_NOTIFICATION_PRODUCTION', 'nl', 'Discussie (Production)', 'Een bericht over {$journalName}', 'Voeg hier uw boodschap in.'),
(384, 'DISCUSSION_NOTIFICATION_PRODUCTION', 'ru', 'Обсуждение (Подготовка к публикации)', 'Сообщение о журнале «{$journalName}»', 'Пожалуйста, введите свое сообщение.'),
(385, 'DISCUSSION_NOTIFICATION_PRODUCTION', 'en', 'Discussion (Production)', 'A message regarding {$journalName}', 'Please enter your message.'),
(386, 'COPYEDIT_REQUEST', 'de', 'Lektorat anfragen', 'Einreichung {$submissionId} ist bereit für die Bearbeitung von {$contextAcronym}', '<p>Sehr geehrte/r {$recipientName},</p><p>Ein neuer Beitrag ist bereit für das Lektorat:</p><p><a href"{$submissionUrl}">{$submissionId} — {$submissionTitle}</a><br />{$journalName}</p><p>Bitte befolgen Sie diese Schritte, um diese Aufgabe zu erledigen:</p><ol><li>Klicken Sie auf die URL für die Einreichung unten.</li><li>Öffnen Sie alle Dateien, die unter Entwurfsdateien verfügbar sind, und bearbeiten Sie die Dateien. Benutzen Sie den Bereich Diskussionen zum Lektorat, wenn Sie mit dem/den Redakteur(en) oder Autor(en) Kontakt aufnehmen möchten.</li><li>Speichern Sie die bearbeitete(n) Datei(en) und laden Sie sie in das Bedienfeld Lektorierte Dateien hoch.</li><li>Benutzen Sie die Lektorats-Diskussionen, um den/die Redakteur/in zu benachrichtigen, dass alle Dateien vorbereitet wurden und der Produktionsprozess beginnen kann.</li></ol><p>Wenn Sie diese Arbeit zu diesem Zeitpunkt nicht übernehmen können oder Fragen haben, wenden Sie sich bitte an mich. Vielen Dank für Ihren Beitrag zu {$journalName}.</p><p>Mit freundlichen Grüßen,</p>{$signature}'),
(387, 'COPYEDIT_REQUEST', 'es', 'Solicitar corrección', 'El envío {$submissionId} está listo para ser corregido para {$contextAcronym}', '<p>Estimado/a{$recipientName},</p><p>Hay un envío nuevo listo para ser corregido:</p><p><a href"{$submissionUrl}">{$submissionId} — {$submissionTitle}</a><br />{$journalName}</p><p>Siga estos pasos para completar la tarea:</p><ol><li>Haga clic en la URL del envío que encontrará más abajo.</li><li>Abra todos los archivos disponibles en "Borradores finales" y haga la corrección. Utilice las "Discusiones de corrección" si necesita contactar con editores/as o autores/as.</li><li>Guarde los archivos corregidos y cárguelos en el panel "Corregido".</li><li>Utilice las "Discusiones de corrección" para notificar a los editores/as que los documentos están preparados y que el proceso de producción podría empezar.</li></ol><p>Si no puede llevar a cabo esta tarea en este momento, o si tiene cualquier duda, contacte conmigo por favor. Gracias por su contribución a {$journalName}.</p><p>Saludos cordiales,</p>{$signature}'),
(388, 'COPYEDIT_REQUEST', 'fr_CA', 'Demande de révision', 'Demande de révision d''une soumission', '{$recipientName},<br />\n<br />\nJ''aimerais que vous effectuiez la révision du manuscrit intitulé « {$submissionTitle} » pour la revue {$journalName} à l''aide des étapes suivantes.<br />\n1. Cliquer sur l''URL de la soumission ci-dessous.<br />\n2. Ouvrir le(s) fichier(s) disponible(s) sous Fichiers des ébauches finales et effectuer votre révision, tout en ajoutant des discussions sur la révision, le cas échéant.<br />\n3. Enregistrer le(s) fichier(s) révisé(s) et le(s) téléverser dans la section Version(s) révisée(s).<br />\n4. Informer le,la rédacteur-trice que tous les fichiers ont été révisés et que l''étape de production peut débuter.<br />\n<br />\nURL de la revue {$journalName} : {$journalUrl}<br />\nURL de la soumission : {$submissionUrl}<br />\nNom d''utilisateur-trice : {$recipientUsername}'),
(389, 'COPYEDIT_REQUEST', 'it', '', 'Assegnazione di copyediting', '{$recipientName}:<br />\n<br />\nTi chiedo di prendere in carico il copyediting del manoscritto &quot;{$submissionTitle}&quot; inviato alla testata {$journalName}.<br />\nIl documento si trova su sito web della rivista, insieme alle istruzioni per il copyediting.<br />\nSe non puoi prendere in carico il lavoro in questo periodo o hai qualche domanda, ti prego di contattarmi.<br />\n<br />\n{$journalName} URL: {$journalUrl}<br />\nURL Manoscritto: {$submissionUrl}<br />\nUsername: {$recipientUsername}<br />'),
(390, 'COPYEDIT_REQUEST', 'nl', '', 'De inzending {$submissionId} staat klaar om geredigeerd te worden voor {$contextAcronym}', '{$recipientName}:<br />\n<br />\nIk wil u vragen om de teksredactie uit te voeren voor artikel &quot;{$submissionTitle}&quot; voor {$journalName} door deze stappen te volgen.<br />\n1. Klik op de inzendings-URL hieronder.<br />\n2. Log in bij het tijdschrift en klik op het bestand dat verschijnt bij Stap 1.<br />\n3. Raadpleeg de tekstredactie-instructies die op de webpagina staan.<br />\n4. Open het gedownloade bestand en doe de tekstredactie. Voeg auteursvragen toe waar nodig.<br />\n5. Bewaar het bewerkte bestand en laad het bij stap 1 van Tekstredactie.<br />\n6. Stuur de GEREED e-mail naar de redacteur.<br />\n<br />\n{$journalName} URL: {$journalUrl}<br />\nURL inzending: {$submissionUrl}<br />\nGerbruikersnaam: {$recipientUsername}'),
(391, 'COPYEDIT_REQUEST', 'ru', 'Запрос на литературное редактирование', 'Материал «{$submissionId}» готов к литературному редактированию для «{$contextAcronym}»', '<p>Здравствуйте, {$recipientName}!</p><p>Новый материал готов к литературному редактированию:</p><p><a href"{$submissionUrl}">{$submissionId} — {$submissionTitle}</a><br />Журнал «{$journalName}»</p>Пожалуйста, выполните следующие шаги, что завершить эту задачу:</p><ol><li>Щелкните на URL материала ниже.</li><li>Откройте все файлы, доступные в панели «Черновики», и выполните их литературное редактирование. Используйте область «Обсуждения литературного редактирования», если Вам необходимо связаться с редактором или автором.</li><li>Сохраните отредактированные файлы и загрузите их в панель «Отредактированные».</li><li>Используйте «Обсуждения литературного редактирования», чтобы уведомить редактора о том, что все файлы были подготовлены и можно их запускать в производство.</li></ol><p>Если Вы не можете выполнить эту работу в данный момент или у Вас есть вопросы, пожалуйста, свяжитесь со мной. Спасибо за Ваш вклад в работу журнала «{$journalName}».</p><p>С уважением,</p>{$signature}'),
(392, 'COPYEDIT_REQUEST', 'en', 'Request Copyedit', 'Submission {$submissionId} is ready to be copyedited for {$contextAcronym}', '<p>Dear {$recipientName},</p><p>A new submission is ready to be copyedited:</p><p><a href"{$submissionUrl}">{$submissionId} — "{$submissionTitle}"</a><br />{$journalName}</p><p>Please follow these steps to complete this task:</p><ol><li>Click on the Submission URL below.</li><li>Open any files available under Draft Files and edit the files. Use the Copyediting Discussions area if you need to contact the editor(s) or author(s).</li><li>Save the copyedited file(s) and upload them to the Copyedited panel.</li><li>Use the Copyediting Discussions to notify the editor(s) that all files have been prepared, and that the Production process may begin.</li></ol><p>If you are unable to undertake this work at this time or have any questions, please contact me. Thank you for your contribution to {$journalName}.</p><p>Kind regards,</p>{$signature}'),
(393, 'EDITOR_ASSIGN_SUBMISSION', 'de', 'Redakteur/in zuweisen', 'Sie wurden als Redakteur/in von einer Einreichung bei {$journalName} zugewiesen', '<p>Sehr geehrte/r {$recipientName},</p><p>Die folgende Einreichung wurde Ihnen zur redaktionellen Bearbeitung zugewiesen. </p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Wenn Sie der Meinung sind, dass die Einreichung für die Zeitschrift {$journalName} relevant ist, leiten Sie die Einreichung bitte zur Begutachtung weiter, indem Sie "In die Begutachtung schicken" wählen und dann Gutachter zuweisen, indem Sie auf "Gutachter/in hinzufügen" klicken. </p><p>Wenn die Einreichung nicht für diese Zeitschrift geeignet ist, lehnen Sie die Einreichung bitte ab.</p><p>Danke im Voraus.</p><p>Mit freundlichen Grüßen,</p>{$journalSignature}'),
(394, 'EDITOR_ASSIGN_SUBMISSION', 'es', 'Asignar editor/a', 'Ha sido asignado como editor/a de un envío para {$journalName}', '<p>Estimado/a {$recipientName},</p><p>Se le ha asignado el siguiente envío para que coordine su proceso editorial.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Resumen</b></p>{$submissionAbstract}<p>Si le parece que el envío es relevante para {$journalName}, envíelo a la fase de revisión seleccionando "Enviar a revisión" y luego asigne revisores/as haciendo clic en "Añadir revisor/a".</p><p>Si el envío no es apropiado para esta revista, rechácelo.</p><p>Gracias de antemano.</p><p>Atentamente,</p>{$journalSignature}'),
(395, 'EDITOR_ASSIGN_SUBMISSION', 'fr_CA', 'Assigner un-e rédacteur-trice', 'Vous avez été assigné.e en tant que rédacteur.trice d''une soumission de la revue {$journalName}', '<p>{$recipientName},</p><p>La soumission suivante vous a été assignée pour le suivi du processus éditorial.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Résumé</b></p>{$submissionAbstract}</p><p>Si vous jugez la soumission pertinente pour la revue {$journalName}, veuillez la transmettre à l''étape d''évaluation en sélectionnant "Envoyer en évaluation" et en désignant des évaluateur.trice.s en cliquant sur « Ajouter un.e évaluateur.trice ».</p><p>Si la soumission n''est pas appropriée pour cette revue, veuillez la décliner.</p><p>Je vous remercie d''avance.</p><p>Cordialement,</p>{$journalSignature}'),
(396, 'EDITOR_ASSIGN_SUBMISSION', 'it', '', 'Assegnazione di una proposta editoriale {$journalName}', '<p>Gentile {$recipientName},</p><p>La seguente proposta Le è stata assegnata per il processo editoriale:</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>ualora dovesse ritenere a proposta sia rilevante per {$journalName}, potrà inoltrarla alla fase di revisione selezionando "Invia alla revisione" e, successivamente, potrà assegnare i revisori utilizzando il tasto "Aggiungi revisore".</p><p>Se la proposta non dovesse essere a Suo giudizio appropriata per questa rivista, La preghiamo di rifiutarla.</p><p>Grazie in anticipo.</p><p>Cordiali saluti,</p>{$journalSignature}'),
(397, 'EDITOR_ASSIGN_SUBMISSION', 'nl', 'Redacteur toekennen', 'Redactietaak', '{$recipientName}:<br />\n<br />\nDe inzending &quot;{$submissionTitle}&quot; voor {$journalName} is aan u toegewezen om in uw rol als sectieredacteur door het redactieproces te leiden.<br />\n<br />\nURL inzending: {$submissionUrl}<br />\nGebruikersnaam: {$recipientUsername}<br />\n<br />\nDank u, </p>{$journalSignature}'),
(398, 'EDITOR_ASSIGN_SUBMISSION', 'ru', 'Назначить редактора', 'Вы были назначены редактором материала в журнале «{$journalName}»', '<p>Здравствуйте, {$recipientName}!</p><p>Вам поручен контроль прохождения через редакционный процесс следующего материала:</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Аннотация</b></p>{$submissionAbstract}<p>Если Вы считаете, что данный материал соответствует тематике журнала «{$journalName}», пожалуйста, направьте его на этап рецензирования, выбрав «Отправить на рецензию», а затем назначив рецензентов, щелкнув на «Добавить рецензента».</p><p>Если материал не подходит для этого журнала, пожалуйста отклоните его.</p><p>Заранее благодарю.</p><p>С уважением,</p>{$journalSignature}'),
(399, 'EDITOR_ASSIGN_SUBMISSION', 'en', 'Assign Editor', 'You have been assigned as an editor on a submission to {$journalName}', '<p>Dear {$recipientName},</p><p>The following submission has been assigned to you to see through the editorial process.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>If you find the submission to be relevant for {$journalName}, please forward the submission to the review stage by selecting "Send to Review" and then assign reviewers by clicking "Add Reviewer".</p><p>If the submission is not appropriate for this journal, please decline the submission.</p><p>Thank you in advance.</p><p>Kind regards,</p>{$journalSignature}'),
(400, 'EDITOR_ASSIGN_REVIEW', 'de', 'Redakteur/in zuweisen', 'Sie wurden als Redakteur/in von einer Einreichung bei {$journalName} zugewiesen', '<p>Sehr geehrte/r {$recipientName},</p><p>Die folgende Einreichung wurde Ihnen zur Begutachtung zugewiesen.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Bitte melden Sie sich an, um <a href="{$submissionUrl}">die Einreichung einzusehen</a> und qualifizierte Gutachter/innen zuzuweisen. Sie können eine/n Gutachter/in zuweisen, indem Sie auf "Gutachter/in hinzufügen" klicken.</p><p>Danke im Voraus.</p><p>Mit freundlichen Grüßen,</p>{$signature}'),
(401, 'EDITOR_ASSIGN_REVIEW', 'es', 'Asignar editor/a', 'Ha sido asignado como editor/a de un envío para {$journalName}', '<p>Estimado/a {$recipientName},</p><p>Se le ha asignado el siguiente envío para que lo supervise durante el proceso de revisión por pares.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Resumen</b></p>{$submissionAbstract}<p>Inicie sesión para <a href="{$submissionUrl}">ver el envío</a> y asignar revisores/as cualificados. Puede asignar un revisor/a haciendo clic en "Añadir revisor/a".</p><p>Gracias de antemano.</p><p>Atentamente,</p>{$signature}'),
(402, 'EDITOR_ASSIGN_REVIEW', 'fr_CA', 'Assigner un-e rédacteur-trice', 'Vous avez été assigné.e en tant que rédacteur.trice d''une soumission de la revue {$journalName}', '<p>{$recipientName},</p><p>La soumission suivante vous a été assignée pour le processus d''évaluation par les pairs.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Résumé</b></p>{$submissionAbstract}<p>Veuillez vous connecter pour <a href="{$submissionUrl}">voir la soumission</a> et désigner des évaluateur.trice.s qualifié.es. Vous pouvez désigner un.e évaluateur.trice en cliquant sur « Ajouter un.e évaluateur.trice ».</p><p>Je vous remercie d''avance.</p><p>Cordialement,</p>{$signature}'),
(403, 'EDITOR_ASSIGN_REVIEW', 'it', '', 'Assegnazione di una proposta editoriale {$journalName}', '<p>Gentile {$recipientName},</p><p>La seguente proposta Le è stata assegnata per una supervisione del processo di revisione tra pari.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Effettui gentilmente il login per <a href="{$submissionUrl}">visualizzare la proposta</a> e per assegnare revisori qualificati. È possibile assegnare un revisore facendo clic su "Aggiungi revisore".</p><p>Grazie in anticipo.</p><p>Cordiali saluti,</p>{$signature}');
INSERT INTO `email_templates_default_data` VALUES
(404, 'EDITOR_ASSIGN_REVIEW', 'nl', 'Redacteur toekennen', 'Redactietaak', '<p>Beste{$recipientName},</p><p>De volgende inzending is aan u toegwezen voor begeleiding door het peer review process.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Log alstublieft in om <a href="{$submissionUrl}">de inzending te bekijken</a> en wijs geschikte reviewers toe. Reviewers kunnen toe gewezen door op "Voeg Reviewer Toe" te klikken.</p><p>Bij voorbaat dank.</p><p>Met vriendelijke groet,</p>{$signature}'),
(405, 'EDITOR_ASSIGN_REVIEW', 'ru', 'Назначить редактора', 'Вы были назначены редактором материала в журнале «{$journalName}»', '<p>Здравствуйте, {$recipientName}!</p><p>Вам поручен контроль прохождения через процесс рецензирования следующего материала.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Аннотация</b></p>{$submissionAbstract}<p>Пожалуйста, войдите в систему, чтобы <a href="{$submissionUrl}">просмотреть материал</a> и назначить квалифицированных рецензентов. Вы можете назначить рецензента, щелкнув на «Добавить рецензента».</p><p>Заранее благодарю.</p><p>С уважением,</p>{$signature}'),
(406, 'EDITOR_ASSIGN_REVIEW', 'en', 'Assign Editor', 'You have been assigned as an editor on a submission to {$journalName}', '<p>Dear {$recipientName},</p><p>The following submission has been assigned to you to see through the peer review process.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Please login to <a href="{$submissionUrl}">view the submission</a> and assign qualified reviewers. You can assign a reviewer by clicking "Add Reviewer".</p><p>Thank you in advance.</p><p>Kind regards,</p>{$signature}'),
(407, 'EDITOR_ASSIGN_PRODUCTION', 'de', 'Redakteur/in zuweisen', 'Sie wurden als Redakteur/in von einer Einreichung bei {$journalName} zugewiesen', '<p>Sehr geehrte/r {$recipientName},</p><p>Die folgende Einreichung wurde Ihnen für die Produktionsphase zugewiesen.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Bitte melden Sie sich an, um <a href="{$submissionUrl}">die Einreichung einzusehen</a>. Sobald die produktionsfertigen Dateien vorliegen, laden Sie sie unter <strong>Publikation > Fahnen</strong> hoch. Klicken Sie dann auf die Schaltfläche <strong>Zur Veröffentlichung vorsehen</strong>.</p><p>Vielen Dank im Voraus.</p><p>Mit freundlichen Grüßen,</p>{$signature}'),
(408, 'EDITOR_ASSIGN_PRODUCTION', 'es', 'Asignar editor/a', 'Ha sido asignado como editor/a de un envío para {$journalName}', '<p>Estimado/a {$recipientName},</p><p>Se le ha asignado el siguiente envío para que coordine su fase de producción.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Resumen</b></p>{$submissionAbstract}<p>Inicie sesión para <a href="{$submissionUrl}">ver el envío</a>. Cuando estén disponibles los archivos de producción cárguelos en la sección <strong>Publicación > Galeradas</strong>. Después programe el trabajo para su publicación haciendo clic en el botón <strong>Programar para publicación</strong>.</p><p>Gracias de antemano.</p><p>Atentamente,</p>{$signature}'),
(409, 'EDITOR_ASSIGN_PRODUCTION', 'fr_CA', 'Assigner un-e rédacteur-trice', 'Vous avez été assigné.e en tant que rédacteur.trice d''une soumission de la revue {$journalName}', '<p>{$recipientName},</p><p>La soumission suivante vous a été assignée pour suivre le processus de production.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Résumé</b></p>{$submissionAbstract}<p>Veuillez vous connecter pour <a href="{$submissionUrl}">afficher la soumission</a>. Une fois les fichiers prêts pour la production disponibles, les téléverser sous la section <strong>Publication &gt; Épreuves</strong>. Ensuite, planifier la publication en cliquant sur le bouton <strong>Planifier la publication</strong>.</p><p>Merci d''avance.</p><p>Cordialement,</p>{$signature}'),
(410, 'EDITOR_ASSIGN_PRODUCTION', 'it', '', 'Assegnazione di una proposta editoriale {$journalName}', '<p>Gentile {$recipientName},</p><p>La seguente proposta editoriale Le è stata assegnata per la fase di produzione</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Effettui gentilmente l''accesso per <a href="{$submissionUrl}">visualizzare la proposta</a>. Quando i file pronti per la produzione saranno disponibili, li carichi cortesemente nella sezione <strong>Pubblicazione > Gabbie</strong>. Quindi segnali il lavoro pronto la pubblicazione facendo clic sul pulsante <strong>Programma per la pubblicazione</strong>.</p><p>Grazie in anticipo.</p><p>Cordiali saluti,</p>{$signature}'),
(411, 'EDITOR_ASSIGN_PRODUCTION', 'nl', 'Redacteur toekennen', 'Redactietaak', '<p>Beste {$recipientName},</p><p>De volgende inzending is aan u toegewezen voor begeleiding door het productieprocess.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Log alstublieft in om <a href="{$submissionUrl}">de inzending te bekijken</a>. Wanneer de productiebestanden gereed zijn, kunt u ze uploaden via<strong>Publicatie> Drukproeven</strong> . Plan daarna het werk in voor publicatie via de <strong>Inplannen voor publicatie</strong> knop.</p><p>Bij voorbaat dank.</p><p>Met vriendelijke groet,</p>{$signature}'),
(412, 'EDITOR_ASSIGN_PRODUCTION', 'ru', 'Назначить редактора', 'Вы были назначены редактором материала в журнале «{$journalName}»', '<p>Здравствуйте, {$recipientName}!</p><p>Вам поручен контроль прохождения через процесс публикации следующего материала.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Аннотация</b></p>{$submissionAbstract}<p>Пожалуйста, войдите в систему, чтобы <a href="{$submissionUrl}">просмотреть материал</a>. Когда файлы для публикации будут готовы, загрузите их в раздел <strong>Публикация > Гранки</strong>. Затем запланируйте материал к публикации, нажав на кнопку <strong>«Запланировать для публикации»</strong>.</p><p>Заранее благодарю.</p><p>С уважением,</p>{$signature}'),
(413, 'EDITOR_ASSIGN_PRODUCTION', 'en', 'Assign Editor', 'You have been assigned as an editor on a submission to {$journalName}', '<p>Dear {$recipientName},</p><p>The following submission has been assigned to you to see through the production stage.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Please login to <a href="{$submissionUrl}">view the submission</a>. Once production-ready files are available, upload them under the <strong>Publication > Galleys</strong> section. Then schedule the work for publication by clicking the <strong>Schedule for Publication</strong> button.</p><p>Thank you in advance.</p><p>Kind regards,</p>{$signature}'),
(414, 'LAYOUT_REQUEST', 'de', 'Für die Produktion bereit', 'Die Einreichung {$submissionId} ist bereit für die Produktion bei {$contextAcronym}', '<p>Liebe/r {$recipientName},</p><p>eine neue Einreichung steht für die Layout-Bearbeitung bereit:</p><p><a href="{$submissionUrl}">{$submissionId} - {$submissionTitle}</a><br />{$journalName}</p><ol><li>Klicken Sie auf die obige Einreichungs-URL.</li><li>Laden Sie die produktionsfertigen Dateien herunter und verwenden Sie sie, um die Druckfahnen gemäß den Standards der Zeitschrift zu erstellen. </li><li>Laden Sie die Druckfahnen in den Publikationsbereich der Einreichung hoch.</li><li>Benutzen Sie die Produktionsdiskussionen, um der Redaktion mitzuteilen, dass die Druckfahnen fertig sind.</li></ol><p>Wenn Sie diese Arbeit zu diesem Zeitpunkt noch nicht erledigen können oder Fragen haben, wenden Sie sich bitte an mich. Vielen Dank für Ihren Beitrag zu dieser Zeitschrift.</p><p>Mit freundlichen Grüßen,</p>{$signature}'),
(415, 'LAYOUT_REQUEST', 'es', 'Listo para producción', 'El envío {$submissionId} está listo para producción en {$contextAcronym}', '<p>Estimado/a {$recipientName},</p><p>Un nuevo envío está listo para la maquetación:</p><p><a href="{$submissionUrl}">{$submissionId} — {$submissionTitle}</a><br />{$journalName}</p><ol><li>Haga clic en la URL anterior.</li><li>Descargue los archivos de producción y utilícelos para crear las galeradas de acuerdo con los estándares de la revista.</li><li>Cargue las galeradas en la sección de publicación del envío.</li><li>Use las discusiones de producción para notificar al editor/a que las galeradas están listas.</li></ol><p>Si no puede llevar a cabo este trabajo en este momento o tiene alguna pregunta, póngase en contacto con nosotros. Gracias por su contribución a esta revista.</p><p>Atentamente,</p>{$signature}'),
(416, 'LAYOUT_REQUEST', 'fr_CA', 'Prêt pour production', 'La soumission {$submissionId} est prête pour production à la revue {$contextAcronym}', '<p>Bonjour {$recipientName},</p><p>J''aimerais que vous prépariez les épreuves du manuscrit intitulé « {$submissionTitle} » pour la revue {$journalName} à l''aide des étapes suivantes.</p>\n<ol><li>Cliquer sur l''URL de la soumission ci-dessous.</li><li>Se connecter au site Web de la revue et utiliser les fichiers disponibles sous Fichiers prêts pour la production pour créer les épreuves en fonction des normes de la revue.</li><li>Téléverser les épreuves dans la section Épreuves.</li><li>Informer le-la rédacteur-trice, via une discussion sur la production, que les épreuves ont été téléversées et qu''elles sont prêtes.</li></ol><p>URL de la revue {$journalName} : {$journalUrl}</p><p>URL du manuscrit : {$submissionUrl}</p><p>Nom d''utilisateur-trice : {$recipientUsername}</p><p>Si vous ne pouvez pas effectuer ce travail pour le moment ou si vous avez des questions, veuillez communiquer avec moi. Je vous remercie de votre collaboration.</p>{$signature}'),
(417, 'LAYOUT_REQUEST', 'it', '', 'La proposta {$submissionId} è stata accettata da {$contextAcronym} ed è pronta per le bozze', '<p>Gentile {$recipientName},</p><p>Un nuovo contributo è pronto per l''impaginazione:</p><p><a href="{$submissionUrl}">{$submissionId} — {$submissionTitle}</a><br />{$journalName}</p><ol><li>Clicchi gentilmente sul link sopra riportato.</li><li>Scarichi i file di produzione e li usi per creare i file impaginati in accordo con gli standard della rivista.</li><li>Carichi i file nella sezione di Pubblicazione della proposta editoriale.</li><li>Usi la funzione di "Discussione" per poter notificare agli editor della rivista che i file sono pronti.</li></ol><p>Qualora non potesse assumere tale lavoro, o in caso di ulteriori esigenze, non esiti a contattarci. Grazie per la preziosa collaborazione</p><p>Cordiali saluti,</p>{$signature}'),
(418, 'LAYOUT_REQUEST', 'nl', 'Naar Productie', 'Verzoek aanmaken proeven', '{$recipientName}:<br />\n<br />\nDe proeven van inzending &quot;{$submissionTitle}&quot; bij {$journalName} kunnen aangemaakt worden door de volgende stappen te doorlopen.<br />\n1. Klik op de inzendings-URL hieronder.<br />\n2. Log in bij het tijdschrift en gebruik het Layout versie bestand om de proeven aan te maken conform de regels van het tijdschrift.<br />\n3. Stuur de GEREED e-mail naar de redacteur.<br />\n<br />\n{$journalName} URL: {$journalUrl}<br />\nURL inzending: {$submissionUrl}<br />\nGebruikersnaam: {$recipientUsername}<br />\n<br />\nAls u op dit moment niet in staat bent om dit werk te doen of als u vragen heeft, neem dan contact met me op.'),
(419, 'LAYOUT_REQUEST', 'ru', 'Готова для подготовки к публикации', 'Материал «{$submissionId}» готов к верстке в «{$contextAcronym}»', '<p>Здравствуйте, {$recipientName}!</p><p>Новый материал готов для верстки:</p><p><a href="{$submissionUrl}">{$submissionId} — {$submissionTitle}</a><br />{$journalName}</p><ol><li>Щелкните по URL материала выше.</li><li>Скачайте «Файлы для публикации» и используйте их для создания гранок в соответствии со стандартами журнала.</li><li>Загрузите гранки в раздел «Публикация» материала.</li><li>Используйте «Обсуждения публикации», чтобы уведомить редактора о готовности гранок.</li></ol><p>Если Вы не можете выполнить эту работу в данное время или у Вас есть какие-то вопросы, пожалуйста, свяжитесь со мной. Спасибо за Ваш вклад в наш журнал.</p><p>С уважением,</p>{$signature}'),
(420, 'LAYOUT_REQUEST', 'en', 'Ready for Production', 'Submission {$submissionId} is ready for production at {$contextAcronym}', '<p>Dear {$recipientName},</p><p>A new submission is ready for layout editing:</p><p><a href="{$submissionUrl}">{$submissionId} — {$submissionTitle}</a><br />{$journalName}</p><ol><li>Click on the Submission URL above.</li><li>Download the Production Ready files and use them to create the galleys according to the journal''s standards.</li><li>Upload the galleys to the Publication section of the submission.</li><li>Use the  Production Discussions to notify the editor that the galleys are ready.</li></ol><p>If you are unable to undertake this work at this time or have any questions, please contact me. Thank you for your contribution to this journal.</p><p>Kind regards,</p>{$signature}'),
(421, 'LAYOUT_COMPLETE', 'de', 'Fahnen vollständig', 'Fahnen vollständig', '<p>Sehr geehrte/r {$recipientName},</p><p>die Druckfahnen für die folgende Einreichung wurden nun vorbereitet und sind bereit für die endgültige Überprüfung.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$journalName}</p><p>Wenn Sie Fragen haben, kontaktieren Sie mich bitte.</p><p>Mit freundlichen Grüßen,</p><p>{$signature}</p>'),
(422, 'LAYOUT_COMPLETE', 'es', 'Galeradas completas', 'Galeradas completadas', '<p>Estimado/a {$recipientName},</p><p>Le informamos que las galeradas del siguiente envío ya han sido preparadas y están listas para su revisión final.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$journalName}</p><p>Si tiene alguna pregunta, póngase en contacto con nosotros.</p><p>Atentamente,</p><p>{$signature}</p>'),
(423, 'LAYOUT_COMPLETE', 'fr_CA', 'Épreuves complétées', 'Mise en page des épreuves terminée', '<p>Bonjour {$recipientName},</p><p>Les épreuves du manuscrit intitulé « <a href="{$submissionUrl}">{$submissionTitle}</a> » pour la revue {$journalName} sont maintenant prêtes pour la relecture.</p><p>Si vous avez des questions, n''hésitez pas à communiquer avec moi.</p><p>{$signature}</p>'),
(424, 'LAYOUT_COMPLETE', 'it', 'Gabbia completa', 'Bozze complete', '<p>Gentile {$recipientName},</p><p>La presente per comunicarLe che Le bozze del seguente contributo sono state preparate e sono ora pronte per la revisione finale.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$journalName}</p><p>Per ogni quesito o necessità, non esiti a contattarci.</p><p>Cordiali saluti,</p><p>{$signature}</p>'),
(425, 'LAYOUT_COMPLETE', 'nl', 'Drukproeven compleet', 'Proeven gereed', '{$recipientName}:<br />\n<br />\nDe proeven voor manuscript &quot;{$submissionTitle}&quot; voor {$journalName} zijn gereed voor proeflezen.<br />\n<br />\nNeemt u alstublieft contact met me op als u vragen heeft.<br />\n<br />\n{$senderName}'),
(426, 'LAYOUT_COMPLETE', 'ru', 'Гранки готовы', 'Гранки сделаны', '<p>Здравствуйте, {$recipientName}!</p><p>Гранки для следующего материала уже свёрстаны и готовы для финальной вычитки.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$journalName}</p><p>Если у Вас есть какие-либо вопросы, пожалуйста, свяжитесь со мной.</p><p>С уважением,</p><p>{$signature}</p>'),
(427, 'LAYOUT_COMPLETE', 'en', 'Galleys Complete', 'Galleys Complete', '<p>Dear {$recipientName},</p><p>Galleys have now been prepared for the following submission and are ready for final review.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$journalName}</p><p>If you have any questions, please contact me.</p><p>Kind regards,</p><p>{$signature}</p>'),
(428, 'VERSION_CREATED', 'de', 'Version erstellt', 'Eine neue Version wurde für {$submissionTitle} erstellt', '<p>Sehr geehrte/r {$recipientName}, </p><p>dies ist eine automatische Nachricht, die Sie darüber informiert, dass eine neue Version Ihres Beitrags {$submissionTitle} erstellt wurde. Sie können diese Version in Ihrem Dashboard für die Einreichung unter folgendem Link einsehen:</p><p><a href="{$submissionUrl}">{$submissionTitle}</a></p><hr><p>Dies ist eine automatische E-Mail, gesendet von <a href="{$journalUrl}">{$journalName}</a>.</p>'),
(429, 'VERSION_CREATED', 'es', 'Versión creada', 'Se ha creado una versión nueva de {$submissionTitle}', ''),
(430, 'VERSION_CREATED', 'fr_CA', 'Version créée', 'Une nouvelle version a été créée pour {$submissionTitle}', '<p>{$recipientName}, </p><p>Ceci est un courriel automatique de <a href="{$journalUrl}">{$journalName}</a> pour vous informer qu''une nouvelle version de votre soumission, {$submissionTitle}, a été créée. Vous pouvez consulter cette version à partir de votre tableau de bord de soumission:</p><p><a href="{$submissionUrl}">{$submissionTitle}</a></p><hr>'),
(431, 'VERSION_CREATED', 'it', '', '', ''),
(432, 'VERSION_CREATED', 'nl', '', 'Een nieuwe versie is aangemaakt voor {$submissionTitle}', '<p>Beste {$recipientName},</p><p>Dit is een geautomatiseerd bericht om je te informeren dat er een nieuwe versie van je inzending, {$submissionTitle}, is aangemaakt. Je kunt deze versie bekijken vanuit je inzendingsdashboard via de volgende link:</p><p><a href="{$submissionUrl}">{$submissionTitle}</a></p><hr><p>Dit is een automatische e-mail verzonden vanuit <a href="{$journalUrl}">{$journalName}</a>.</p>'),
(433, 'VERSION_CREATED', 'ru', 'Версия создана', 'Была создана новая версия материала для «{$submissionTitle}»', '<p>Здравствуйте, {$recipientName}!</p><p>Это автоматическое сообщение, информирующее Вас о том, что была создана новая версия Вашего материала «{$submissionTitle}». Вы можете просмотреть эту версию на странице Вашего материала по следующей ссылке:</p><p><a href="{$submissionUrl}">{$submissionTitle}</a></p><hr><p>Это автоматическое письмо, отправленное из журнала <a href="{$journalUrl}">«{$journalName}»</a>.</p>'),
(434, 'VERSION_CREATED', 'en', 'Version Created', 'A new version was created for "{$submissionTitle}"', '<p>Dear {$recipientName}, </p><p>This is an automated message to inform you that a new version of your submission, "{$submissionTitle}", was created. You can view this version from your submission dashboard at the following link:</p><p><a href="{$submissionUrl}">"{$submissionTitle}"</a></p><hr><p>This is an automatic email sent from <a href="{$journalUrl}">{$journalName}</a>.</p>'),
(435, 'EDITORIAL_REMINDER', 'de', 'Redaktionserinnerung', 'Ausstehende redaktionelle Aufgaben für {$journalName}', '<p>Sehr geehrte/r {$recipientName},</p><p>Sie sind derzeit {$numberOfSubmissions} Einreichung(en) zugewiesen in <a href="{$journalUrl}">{$journalName}</a>. Die folgenden Einsendungen <b>warten auf Ihre Antwort</b></p>{$outstandingTasks}<p>Sehen Sie alle Ihre Aufgaben an in Ihrem <a href="{$submissionsUrl}">Dashboard der Einreichungen</a>.</p><p>Wenn Sie Fragen zu Ihren Aufgaben haben, wenden Sie sich bitte an {$contactName} unter {$contactEmail}.</p>'),
(436, 'EDITORIAL_REMINDER', 'es', 'Recordatorio editorial', 'Tareas editoriales pendientes de {$journalName}', '<p>Estimado/a {$recipientName},</p><p>Actualmente tiene asignado(s) {$numberOfSubmissions} envío(s) en <a href="{$journalUrl}">{$journalName}</a>. Los envíos siguientes están <b>esperando su respuesta</b>.</p>{$outstandingTasks}<p>Puede ver todas sus tareas en su <a href="{$submissionsUrl}">panel de control del envío</a>.</p><p>Si tiene cualquier duda acerca de sus asignaciones contacte con {$contactName} en {$contactEmail}.</p>'),
(437, 'EDITORIAL_REMINDER', 'fr_CA', 'Rappel éditorial', 'Tâches éditoriales en attente pour {$journalName}', '<p>$recipientName}, </p><p>Vous êtes présentement assigné-e à {$numberOfSubmissions} soumissions dans <a href="{$journalUrl}">{$journalName}</a>. Des actions sont <b>attendues de votre part pour ces soumissions</b>.</p>{$outstandingTasks}<p>Vous pouvez consulter toutes vos soumissions dans votre <a href="{$submissionsUrl}">tableau de bord des soumissions</a>.</p><p>Si vous avez des questions, contactez {$contactName} par courriel à l’adresse: {$contactEmail}. </p>'),
(438, 'EDITORIAL_REMINDER', 'it', '', '', ''),
(439, 'EDITORIAL_REMINDER', 'nl', 'Redactionele Herinnering', 'Uitstaande redactionele taken voor {$journalName}', '<p>Beste {$recipientName},</p><p>Op dit moment ben je toegewezen aan {$numberOfSubmissions} inzendingen in <a href="{$journalUrl}">{$journalName}</a>. De volgende inzendingen wachten op <b>jouw reactie</b>.</p>{$outstandingTasks}<p>Bekijk al je toewijzingen in je <a href="{$submissionsUrl}">inzendingsdashboard</a>.</p><p>Als je vragen hebt over je toewijzingen, neem dan contact op met {$contactName} via {$contactEmail}.</p>'),
(440, 'EDITORIAL_REMINDER', 'ru', 'Напоминание редакции', 'Невыполненные редакционные задания в журнале «{$journalName}»', '<p>Здравствуйте, {$recipientName}!</p><p>В настоящее время в журнале <a href="{$journalUrl}">{$journalName}</a> Вам назначено материалов: {$numberOfSubmissions}. Следующие материалы <b>ждут Вашего ответа</b>.</p>{$outstandingTasks}<p>Просмтотреть все назначенные материалы Вы можете на <a href="{$submissionsUrl}">странице материалов</a>.</p><p>Если у Вас есть какие-то вопросы по назначенным материалам, пожалуйста напишите по адресу {$contactEmail} ({$contactName}).</p>'),
(441, 'EDITORIAL_REMINDER', 'en', 'Editorial Reminder', 'Outstanding editorial tasks for {$journalName}', '<p>Dear {$recipientName},</p><p>You are currently assigned to {$numberOfSubmissions} submissions in <a href="{$journalUrl}">{$journalName}</a>. The following submissions are <b>waiting for your response</b>.</p>{$outstandingTasks}<p>View all of your assignments in your <a href="{$submissionsUrl}">submission dashboard</a>.</p><p>If you have any questions about your assignments, please contact {$contactName} at {$contactEmail}.</p>'),
(442, 'SUBMISSION_SAVED_FOR_LATER', 'de', 'Einreichung für später gespeichert', 'Setzen Sie Ihre Einreichung bei {$journalName} fort', '<p>Sehr geehrte/r {$recipientName},</p><p>Die Angaben zu Ihrem Beitrag sind in unserem System gespeichert, aber noch nicht zur Prüfung eingereicht worden. Sie können jederzeit zurückkehren, um Ihre Einreichung zu vervollständigen, indem Sie dem unten stehenden Link folgen.</p><p><a href="{$submissionWizardUrl}">{$authorsShort} — {$submissionTitle}</a></p><hr><p>Dies ist eine automatische E-Mail von <a href="{$journalUrl}">{$journalName}</a>.</p>'),
(443, 'SUBMISSION_SAVED_FOR_LATER', 'es', 'Se guardó el envío para más adelante', 'Continuar su envío a {$journalName}', ''),
(444, 'SUBMISSION_SAVED_FOR_LATER', 'fr_CA', 'Soumission incomplète sauvegardée', 'Reprendre votre soumission à {$journalName}', '<p>{$recipientName},</p><p>Les détails de votre soumission ont été enregistrés, mais vous ne l''avez pas encore finalisée. Vous pouvez le faire en cliquant sur le lien ci-dessous: </p><p><a href="{$submissionWizardUrl}">{$authorsShort} — {$submissionTitle}</a></p><hr><p>Ceci est un message automatique de <a href="{$journalUrl}">{$journalName}</a>.</p>'),
(445, 'SUBMISSION_SAVED_FOR_LATER', 'it', '', '', ''),
(446, 'SUBMISSION_SAVED_FOR_LATER', 'nl', 'Inzending bewaard voor later', 'Ga door met je inzending aan {$journalName}', '<p>Beste {$recipientName},</p><p>Je inzending details zijn opgeslagen in ons systeem, maar het is nog niet ingediend ter overweging. Je kunt op elk moment terugkeren om je inzending te voltooien door de onderstaande link te volgen.</p><p><a href="{$submissionWizardUrl}">{$authorsShort} — {$submissionTitle}</a></p><hr><p>Dit is een geautomatiseerde e-mail vanuit <a href="{$journalUrl}">{$journalName}</a>.</p>'),
(447, 'SUBMISSION_SAVED_FOR_LATER', 'ru', 'Материал сохранен на будущее', 'Завершите отправку материала в журнал «{$journalName}»', '<p>Здравствуйте, {$recipientName}!</p><p>Данные о Вашем материале были сохранены в нашей системе, но он еще не был отправлен на рассмотрение. Вы можете в любое время вернуться в систему для завершения отправки материала, перейдя по ссылке ниже.</p><p><a href="{$submissionWizardUrl}">{$authorsShort} — «{$submissionTitle}»</a></p><hr><p>Это автоматическое письмо, отправленное из журнала <a href="{$journalUrl}">«{$journalName}»</a>.</p>'),
(448, 'SUBMISSION_SAVED_FOR_LATER', 'en', 'Submission Saved for Later', 'Resume your submission to {$journalName}', '<p>Dear {$recipientName},</p><p>Your submission details have been saved in our system, but it has not yet been submitted for consideration. You can return to complete your submission at any time by following the link below.</p><p><a href="{$submissionWizardUrl}">{$authorsShort} — "{$submissionTitle}"</a></p><hr><p>This is an automated email from <a href="{$journalUrl}">{$journalName}</a>.</p>'),
(449, 'SUBMISSION_NEEDS_EDITOR', 'de', 'Einreichung benötigt Redakteur/in', 'Einer neuen Einreichung muss ein Redakteur/eine Redakteurin zugewiesen werden: {$submissionTitle}', '<p>Sehr geehrte/r {$recipientName},</p><p>Der folgende Beitrag wurde eingereicht und es wurde kein/e Redakteur/in zugewiesen.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Bitte weisen Sie eine/n Redakteur/in zu, der für die Einreichung verantwortlich sein wird, indem Sie auf den Titel oben klicken, und dann eine/n Redakteur/in unter der Rubrik Teilnehmer zuweisen.</p><hr><p>Dies ist eine automatische E-Mail von <a href="{$journalUrl}">{$journalName}</a>.</p>'),
(450, 'SUBMISSION_NEEDS_EDITOR', 'es', 'El envío necesita un editor/a', 'Un envío nuevo necesita que le asignen un editor/a: {$submissionTitle}', ''),
(451, 'SUBMISSION_NEEDS_EDITOR', 'fr_CA', 'Soumission en attente de rédacteur-trice', 'Un-e rédacteur-trice doit être assigné-e à la nouvelle soumission : {$submissionTitle}', '<p>{$recipientName},</p><p>La soumission suivante a été soumise et aucun-e rédacteur-trice ne lui est assigné-e.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>S''il vous plait, assignez un-e rédacteur-trice qui sera responsable de la soumission. </p><hr><p>Ceci est un courriel automatique de <a href="{$journalUrl}">{$journalName}</a>.</p>'),
(452, 'SUBMISSION_NEEDS_EDITOR', 'it', '', '', ''),
(453, 'SUBMISSION_NEEDS_EDITOR', 'nl', 'Inzending Redacteur Nodig', 'Er moet een redacteur worden toegewezen aan een nieuwe inzending: {$submissionTitle}', '<p>Beste {$recipientName},</p><p>De volgende inzending is ingediend en er is nog geen redacteur toegewezen.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Samenvatting</b></p>{$submissionAbstract}<p>Wijs alsjeblieft een redacteur toe die verantwoordelijk zal zijn voor de inzending door op de titel hierboven te klikken en een redacteur toe te wijzen onder de sectie Deelnemers.</p><hr><p>Dit is een geautomatiseerde e-mail vanuit <a href="{$journalUrl}">{$journalName}</a>.</p>'),
(454, 'SUBMISSION_NEEDS_EDITOR', 'ru', 'Материалу нужен редактор', 'Новому материалу необходимо назначить редактора: «{$submissionTitle}»', '<p>Здравствуйте, {$recipientName}!</p><p>Следующий материал поступил в журнал, но редактор ему не назначен.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Аннотация</b></p>{$submissionAbstract}<p>Пожалуйста, назначьте редактора, который будет отвечать за материал, нажав на название материала выше и назначив редактора в разделе «Участники».</p><hr><p>Это автоматическое письмо, отправленное из журнала <a href="{$journalUrl}">«{$journalName}»</a>.</p>'),
(455, 'SUBMISSION_NEEDS_EDITOR', 'en', 'Submission Needs Editor', 'A new submission needs an editor to be assigned: "{$submissionTitle}"', '<p>Dear {$recipientName},</p><p>The following submission has been submitted and there is no editor assigned.</p><p><a href="{$submissionUrl}">"{$submissionTitle}"</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Please assign an editor who will be responsible for the submission by clicking the title above and assigning an editor under the Participants section.</p><hr><p>This is an automated email from <a href="{$journalUrl}">{$journalName}</a>.</p>'),
(456, 'PAYMENT_REQUEST_NOTIFICATION', 'de', 'Zahlungsanfrage', 'Benachrichtigung über eine Zahlungsanforderung', '<p>Sehr geehrte/r {$recipientName},</p><p>herzlichen Glückwunsch zur Annahme Ihrer Einreichung {$submissionTitle} bei {$journalName}. Nachdem Ihre Einreichung angenommen wurde, möchten wir Sie nun um die Zahlung der Veröffentlichungsgebühr bitten.</p><p>Diese Gebühr deckt die Produktionskosten für die Veröffentlichung Ihrer Einreichung. Um die Zahlung vorzunehmen, besuchen Sie bitte <a href="{$queuedPaymentUrl}">{$queuedPaymentUrl}</a>.</p><p>Wenn Sie Fragen haben, lesen Sie bitte unsere <a href="{$submissionGuidelinesUrl}">Einreichungsrichtlinien</a>.</p>'),
(457, 'PAYMENT_REQUEST_NOTIFICATION', 'es', 'Solicitud de pago', 'Notificación de solicitud de pago', '<p>Estimado/a {$recipientName},</p><p>Le felicitamos por la aceptación de su envío, {$submissionTitle}, en {$journalName}. Ahora que ha sido aceptado, nos gustaría solicitarle el pago de la tasa de publicación.</p><p>Esta tasa cubre los costes de producción para su publicación. Para realizar el pago, visite <a href="{$queuedPaymentUrl}">{$queuedPaymentUrl}</a>.</p><p>Si tiene alguna pregunta consulte nuestras <a href="{$submissionGuidelinesUrl}">directrices de envío</a>.</p>'),
(458, 'PAYMENT_REQUEST_NOTIFICATION', 'fr_CA', 'Demande de paiement', 'Avis de demande de paiement', '<p>Bonjour {$recipientName},</p><p>Félicitations pour l''acceptation de votre texte, {$submissionTitle}, dans {$journalName}. Maintenant que votre texte a été accepté, il est nécessaire de payer les frais de publication afin de compléter le processus.</p><p>Ces frais couvrent les coûts de production permettant d''assurer la publication de votre texte. Pour effectuer le paiement, rendez-vous sur <a href="{$queuedPaymentUrl}">{$queuedPaymentUrl}</a>.</p><p> Si vous avez des questions, référez-vous à nos <a href="{$submissionGuidelinesUrl}">directives de soumissions</a>.</p>'),
(459, 'PAYMENT_REQUEST_NOTIFICATION', 'it', 'Richiesta di pagamento', 'Notifica di richiesta di pagamento', '<p>Gentile {$recipientName},</p><p>Congratulazioni per l''accettazione della Sua proposta, {$submissionTitle}, a {$journalName}. Ora che la proposta è stata accettata, vorremmo domandare se potesse procedere al pagamento delle tariffe di pubblicazione. </p><p>Questa tariffa copre i costi di produzione necessari per il raggiungimento della pubblicazione. Al fine di poter effettuare il pagamento, visiti la seguente pagina <a href="{$queuedPaymentUrl}">{$queuedPaymentUrl}</a>.</p><p>Per ulteriori informazioni, visiti le nostre <a href="{$submissionGuidelinesUrl}">linee guide per le proposte editoriali</a>.</p>'),
(460, 'PAYMENT_REQUEST_NOTIFICATION', 'nl', 'Betalingsverzoek', 'Betalingsverzoeknotificatie', '<p>Beste {$recipientName},</p><p>Gefeliciteerd met de acceptatie van uw inzending, {$submissionTitle}, aan {$journalName}. Nu uw inzending is geaccepteerd, willen wij u verzoeken om betaling van de publicatiekosten.</p><p>Deze vergoeding dekt de productiekosten voor het publiceren van uw inzending. Om de betaling uit te voeren, gaat u naar <a href="{$queuedPaymentUrl}">{$queuedPaymentUrl}</a>.</p><p>Als u vragen heeft, raadpleegt u onze <a href="{$ submissionGuidelinesUrl}">Inzendingsrichtlijnen</a></p>'),
(461, 'PAYMENT_REQUEST_NOTIFICATION', 'ru', 'Запрос на оплату', 'Уведомление о необходимости оплаты', '<p>Здравствуйте, {$recipientName}!</p><p>Поздравляем с принятием Вашего материала «{$submissionTitle}» к публикации в журнале «{$journalName}». Теперь, когда Ваш материал принят, мы хотели бы попросить вас оплатить взнос за публикацию.</p><p>Эта сумма покрывает производственные расходы, связанные с подготовкой вашего материала к публикации. Чтобы произвести оплату, пожалуйста посетите <a href="{$queuedPaymentUrl}">{$queuedPaymentUrl}</a>.</p><p>Если у вас есть вопросы, пожалуйста, ознакомьтесь с нашим <a href="{$submissionGuidelinesUrl}">Руководством по подаче материалов</a></p>'),
(462, 'PAYMENT_REQUEST_NOTIFICATION', 'en', 'Payment Request', 'Payment Request Notification', '<p>Dear {$recipientName},</p><p>Congratulations on the acceptance of your submission, {$submissionTitle}, to {$journalName}. Now that your submission has been accepted, we would like to request payment of the publication fee.</p><p>This fee covers the production costs of bringing your submission to publication. To make the payment, please visit <a href="{$queuedPaymentUrl}">{$queuedPaymentUrl}</a>.</p><p>If you have any questions, please see our <a href="{$submissionGuidelinesUrl}">Submission Guidelines</a></p>'),
(463, 'CHANGE_EMAIL', 'de', '', '', ''),
(464, 'CHANGE_EMAIL', 'es', 'Cambiar la dirección de correo electrónico de invitación', '', ''),
(465, 'CHANGE_EMAIL', 'fr_CA', 'Changer l''adresse courriel d''invitation', '', ''),
(466, 'CHANGE_EMAIL', 'it', '', '', ''),
(467, 'CHANGE_EMAIL', 'nl', '', 'Bevestig het account contact bij wijzigingsverzoek E-mail', ''),
(468, 'CHANGE_EMAIL', 'ru', '', '', ''),
(469, 'CHANGE_EMAIL', 'en', 'Change Email Address Invitation', 'Confirm account contact email change request', '<p>Dear {$recipientName},</p><p>You are receiving this email because someone has requested a change of your email to {$newEmail}.</p><p>If you have made this request please <a href="{$acceptInvitationUrl}">confirm</a> the email change.</p><p>You can always <a href="{$declineInvitationUrl}">reject</a> this email change.</p><p>Please feel free to contact me with any questions about the submission or the review process.</p><p>Kind regards,</p>{$siteContactName}'),
(470, 'ORCID_COLLECT_AUTHOR_ID', 'de', '', 'ORCID Zugriff erbeten', 'Liebe/r {$recipientName},<br/>\n<br/>\nSie sind als Autor/in eines eingereichten Beitrags bei der Zeitschrift {$journalName} benannt worden.<br/>\nUm Ihre Autor/innenschaft zu bestätigen, geben Sie bitte Ihre ORCID iD für diese Einreichung an, indem Sie den unten angegebenen Link aufrufen.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>ORCID iD anlegen oder verknüpfen</a><br/>\n<br/>\n<a href="{$orcidAboutUrl}">Mehr Informationen zu ORCID</a><br/>\n<br/>\nWenn Sie Fragen dazu haben, antworten Sie einfach auf diese E-Mail.<br/>\n<br/>\n{$principalContactSignature}<br/>\n'),
(471, 'ORCID_COLLECT_AUTHOR_ID', 'es', 'orcidCollectAuthorId', 'ORCID de envío', 'Estimado/a {$recipientName},\n<br/>\nSe le ha añadido como coautor/a de un artículo para {$journalName}. <br/>\nPara confirmar su autoría, añada su identificador ORCID a este envío mediante el siguiente enlace.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Registrar o conectar su identificador ORCID</a><br/>\n<br/>\n<br>\n<a href="{$orcidAboutUrl}">Puede encontrar más información sobre ORCID en {$journalName}</a><br/>\n<br/>\nSi tiene cualquier pregunta no dude en contactarme.<br/>\n<br/>\n{$principalContactSignature}<br/>\n'),
(472, 'ORCID_COLLECT_AUTHOR_ID', 'fr_CA', 'orcidCollectAuthorId', 'Soumission ORCID', '{$recipientName},<br/>\n<br/>\nVous avez été inscrit ou inscrite en tant qu''auteur ou auteure pour un manuscrit soumis à {$journalName}.<br/>\nPour confirmer votre statut d''auteur ou d''auteure, veuillez ajouter votre identifiant ORCID à cette soumission en cliquant sur le lien ci-dessous.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="icône identifiant ORCID" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Se connecter avec votre identifiant ORCID ou s''inscrire</a><br/>\n<br/>\n<br/>\n<a href="{$orcidAboutUrl}">Plus de renseignements sur votre identifiant ORCID dans {$journalName}</a><br/>\n<br/>\nSi vous avez des questions, veuillez communiquer avec nous.<br/>\n<br/>\n{$principalContactSignature}<br/>\n'),
(473, 'ORCID_COLLECT_AUTHOR_ID', 'it', '', 'Le chiediamo di inserire l''ORCID', 'Gentile {$recipientName},<br/>\n<br/>Il suo nominativo è stato inserito come co-autore di un manoscritto inviato per la pubblicazione a {$journalName}.<br/>\nPer confermare la sua partecipazione quale autore, le chiediamo di aggiungere il suo ORCID iD alla sottomissione utilizzando il link sottostante. <br/>\n<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Register or connect your ORCID iD</a><br/>\n<br/>\n<br>\n<a href="{$orcidAboutUrl}">Maggiori informazioni in merito ad ORCID sono disponibili al sito {$journalName}</a><br/>\n<br/>\nPer qualsiasi ulteriore chiarimento, la prego di contattarci.<br/>\n<br/>\n{$principalContactSignature}<br/>\n'),
(474, 'ORCID_COLLECT_AUTHOR_ID', 'nl', '', 'ORCID van uw inzending', 'Beste {$recipientName},<br/>\n<br/>\nU bent auteur van een inzending voor {$journalName}.<br/> \nWilt u bevestigen dat u co-auteur bent door uw ORCID id toe te voegen via volgende link?<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Registreer of koppel uw ORCID ID</a><br/>\n<br/>\n<br/>\n<a href="{$orcidAboutUrl}">Meer informatie over ORCID op {$journalName}</a><br/>\n<br/>\nNeemt u alstublieft contact op als u vragen heeft.<br/>\n<br/>\n{$principalContactSignature}<br/>\n'),
(475, 'ORCID_COLLECT_AUTHOR_ID', 'ru', '', 'ORCID материала', '{$recipientName}!<br/>\n<br/>\nВы были указаны как автор материала, отправленного в «{$journalName}».<br/>\nЧтобы подтвердить свое авторство, пожалуйста, добавьте свой идентификатор ORCID к этому материалу, перейдя по приведенной ниже ссылке.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Создать или подключить ваш ORCID iD</a><br/>\n<br/>\n<br>\n<a href="{$orcidAboutUrl}">Дополнительная информация об ORCID в «{$journalName}»</a><br/>\n<br/>\nЕсли у Вас есть какие-либо вопросы, пожалуйста, свяжитесь со мной.<br/>\n<br/>\n{$principalContactSignature}<br/>\n'),
(476, 'ORCID_COLLECT_AUTHOR_ID', 'en', 'orcidCollectAuthorId', 'Submission ORCID', 'Dear {$recipientName},<br/>\n<br/>\nYou have been listed as an author on a manuscript submission to {$journalName}.<br/>\nTo confirm your authorship, please add your ORCID id to this submission by visiting the link provided below.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Register or connect your ORCID iD</a><br/>\n<br/>\n<br>\n<a href="{$orcidAboutUrl}">More information about ORCID at {$journalName}</a><br/>\n<br/>\nIf you have any questions, please contact me.<br/>\n<br/>\n{$principalContactSignature}<br/>\n'),
(477, 'ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'de', '', 'ORCID Zugriff erbeten', 'Liebe/r {$recipientName},<br>\n<br>\nSie sind als Autor/in des eingereichten Beitrags "{$submissionTitle}" bei der Zeitschrift {$journalName} benannt worden.<br>\n<br>\nBitte gestatten Sie uns Ihre ORCID iD, falls vorhanden, zu diesem Beitrag hinzuzufügen, sowie ihr ORCID-Profil bei Veröffentlichung des Beitrags zu aktualisieren.<br>\nDazu folgen Sie dem unten stehenden Link zur offiziellen ORCID-Seite, melden sich mit Ihren Daten an und authorisieren den Zugriff, indem\nSie den Anweisungen auf der Seite folgen.<br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>ORCID id anlegen oder verknüpfen</a><br/>\n<br>\n<a href="{$orcidAboutUrl}">Mehr Informationen zu ORCID</a><br />\n<br>\nWenn Sie Fragen dazu haben, antworten Sie einfach auf diese E-Mail.<br>\n<br>\n{$principalContactSignature}<br>\n'),
(478, 'ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'es', 'orcidRequestAuthorAuthorization', 'Solicitando acceso de registro ORCID', 'Estimado/a {$recipientName},<br>\n<br>\nUsted ha sido incluido como autor en la presentación del manuscrito "{$submissionTitle}" a {$journalName}.\n<br>\n<br>\nPermítanos agregar su identificación ORCID a este envío y también agregar el mismo a su perfil ORCID en la publicación.<br>\nVisite el enlace al sitio web oficial de ORCID, inicie sesión con su perfil y autorice el acceso siguiendo las instrucciones.<br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Registre o conecte su ORCID iD</a><br/>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">Más acerca de ORCID en{$journalName}</a><br/>\n<br>\nSi tiene alguna pregunta, por favor póngase en contacto conmigo.<br>\n<br>\n{$principalContactSignature}<br>\n'),
(479, 'ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'fr_CA', 'orcidRequestAuthorAuthorization', 'Demande d''accès au dossier ORCID', '{$recipientName},<br/>\n<br/>\nVous avez été inscrit ou inscrite en tant qu''auteur ou auteure pour le manuscrit « {$submissionTitle} » soumis à {$journalName}.\n<br/>\n<br/>\nVeuillez nous autoriser à ajouter votre identifiant ORCID à cette soumission et à ajouter également la soumission à votre dossier ORCID suite à sa publication.\n<br/>\nSuivre le lien vers le site officiel ORCID, vous connecter avec votre profil et autoriser l''accès en suivant les instructions.<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="icône identifiant ORCID" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Se connecter avec votre identifiant ORCID ou s''inscrire</a><br/>\n<br/>\n<br/>\n<a href="{$orcidAboutUrl}">Plus de renseignements sur votre identifiant ORCID dans {$journalName}</a><br/>\n<br/>\nSi vous avez des questions, veuillez communiquer avec nous.<br/>\n<br/>\n{$principalContactSignature}<br/>\n'),
(480, 'ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'it', '', 'Richiesta di accesso al record ORCID', 'Gentile {$recipientName},<br>\n<br>\nIl suo nominativo è stato aggiunto come co-autore nel manoscritto "{$submissionTitle}" sottoposto per la pubblicazione a {$journalName}.\n<br>\n<br>\nLe chiediamo il permesso di aggiungere il suo ORCID iD a questa sottomissione e di poter aggiungere questa sottomissione al suo profilo ORCID.<br>\nLe chiediamo di andare al suo profilo ufficiale ORCID e di autorizzare l''accesso seguendo le indicazioni che verranno fornite. <br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Collega il tuo ORCID iD o registrati adesso</a><br/>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">Maggiori informazioni su ORCID sono disponibili a questo indirizzo: {$journalName}</a><br/>\n<br>\nSe ha qualsiasi domanda o dubbio, la prego di contattarci.<br>\n<br>\n{$principalContactSignature}<br>\n'),
(481, 'ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'nl', '', 'Toegangsverzoek tot uw ORCID profiel', 'Beste {$recipientName},<br/>\n<br/>\nU bent auteur van het manuscript "{$submissionTitle}" dat werd ingediend voor {$journalName}.\n<br/>\n<br/>\nWilt u uw toestemming geven om uw ORCID ID toe te voegen aan deze inzending en de inzending toe te voegen aan uw ORCID profiel bij publicatie?<br/>\nKlik op de link naar de officiële ORCID website, meld u aan met uw gebruikersprofiel en authoriseer de toegang door de instructies te volgen.<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Registreer of koppel uw ORCID ID</a><br/>\n<br/>\n<br/>\n<a href="{$orcidAboutUrl}">Meer informatie over ORCID op {$journalName}</a><br/>\n<br>\nNeemt u alstublieft contact op als u vragen heeft.<br/>\n<br/>\n{$principalContactSignature}<br/>\n');
INSERT INTO `email_templates_default_data` VALUES
(482, 'ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'ru', '', 'Запрос доступа к записи ORCID', '{$recipientName}!<br>\n<br>\nВы были указаны как автор материала «{$submissionTitle}», отправленного в «{$journalName}».\n<br>\n<br>\nПожалуйста, дайте нам возможность добавить ваш ORCID id к этому материалу, а также добавить материал в ваш профиль ORCID после публикации.<br>\nПерейдите по ссылке на официальном вебсайте ORCID, войдите в систему с вашей учетной записью и авторизуйте доступ, следуя инструкциям.<br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Создать или подключить ваш ORCID iD</a><br/>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">Подробнее об ORCID в «{$journalName}»</a><br/>\n<br>\nЕсли у Вас есть какие-либо вопросы, пожалуйста, свяжитесь со мной.<br>\n<br>\n{$principalContactSignature}<br>\n'),
(483, 'ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'en', 'orcidRequestAuthorAuthorization', 'Requesting ORCID record access', 'Dear {$recipientName},<br>\n<br>\nYou have been listed as an author on the manuscript submission "{$submissionTitle}" to {$journalName}.\n<br>\n<br>\nPlease allow us to add your ORCID id to this submission and also to add the submission to your ORCID profile on publication.<br>\nVisit the link to the official ORCID website, login with your profile and authorize the access by following the instructions.<br>\n<br>\n<a href="{$authorOrcidUrl}" style="display: inline-flex; align-items: center; background-color: white; text-align: center; padding: 10px 20px; text-decoration: none; border-radius: 5px; border: 2px solid #d7d4d4;"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Register or Connect your ORCID iD</a><br/>\n<br>\n<br>\nClick here to verify your account with ORCID: <a href="{$authorOrcidUrl}">{$authorOrcidUrl}.</a>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">More about ORCID at {$journalName}</a><br/>\n<br>\n<br>\nIf you have any questions, please contact me.<br>\n<br>\n{$principalContactSignature}<br>\n'),
(484, 'USER_ROLE_ASSIGNMENT_INVITATION', 'de', '', '', ''),
(485, 'USER_ROLE_ASSIGNMENT_INVITATION', 'es', '', '', ''),
(486, 'USER_ROLE_ASSIGNMENT_INVITATION', 'fr_CA', '', '', ''),
(487, 'USER_ROLE_ASSIGNMENT_INVITATION', 'it', '', '', ''),
(488, 'USER_ROLE_ASSIGNMENT_INVITATION', 'nl', '', '', ''),
(489, 'USER_ROLE_ASSIGNMENT_INVITATION', 'ru', '', '', ''),
(490, 'USER_ROLE_ASSIGNMENT_INVITATION', 'en', 'User Invited to Role Notification', 'You are invited to new roles', '<div class=''email-container''>    <div class=''email-header''>        <h2>Invitation to New Role</h2>    </div>    <div class=''email-content''>        <p>Dear {$recipientName},</p>        <p>In light of your expertise, you have been invited by {$inviterName} to take on new roles at {$journalName}</p>        <p>At {$journalName}, we value your privacy. As such, we have taken steps to ensure that we are fully GDPR compliant. These steps include you being accountable to enter your own data and choosing who can see what information. For additional information on how we handled your data, please refer to our Privacy Policy.</p>        <div>{$existingRoles}</div>        <div>{$rolesAdded}</div>        <p>On accepting the invite, you will be redirected to {$journalName}.</p>        <p>Feel free to contact me with any questions about the process.</p>        <p><a href=''{$acceptUrl}'' class=''btn btn-accept''>Accept Invitation</a></p>        <p><a href=''{$declineUrl}'' class=''btn btn-decline''>Decline Invitation</a></p>        <p>Kind regards,</p>        <p>{$journalName}</p>    </div></div><style>{$emailTemplateStyle}</style>'),
(491, 'USER_ROLE_END', 'de', '', '', ''),
(492, 'USER_ROLE_END', 'es', '', '', ''),
(493, 'USER_ROLE_END', 'fr_CA', '', '', ''),
(494, 'USER_ROLE_END', 'it', '', '', ''),
(495, 'USER_ROLE_END', 'nl', '', '', ''),
(496, 'USER_ROLE_END', 'ru', '', '', ''),
(497, 'USER_ROLE_END', 'en', 'User Role Ended Notification', 'You have been removed from a role', '<div class=''email-container''>    <div class=''email-header''>        <h2>Removed from a Role</h2>    </div>    <div class=''email-content''>        <p>Dear {$recipientName},</p>        <p>Thank you very much for your participation in the role of {$roleRemoved} at {$journalName}.</p>        <p>This is a notice to let you know that you have been removed from the following role at {$journalName}: <b>{$roleRemoved}</b>.</p>        <p>Your account with {$journalName} is still active and any other roles you previously held are still active.</p>        <p>Feel free to contact me with any questions about the process.</p>        <p>Kind regards,</p>        <p>{$journalName}</p>    </div></div><style>{$emailTemplateStyle}</style>'),
(498, 'ORCID_REQUEST_UPDATE_SCOPE', 'de', '', '', ''),
(499, 'ORCID_REQUEST_UPDATE_SCOPE', 'es', '', '', ''),
(500, 'ORCID_REQUEST_UPDATE_SCOPE', 'fr_CA', '', '', ''),
(501, 'ORCID_REQUEST_UPDATE_SCOPE', 'it', '', '', ''),
(502, 'ORCID_REQUEST_UPDATE_SCOPE', 'nl', '', '', ''),
(503, 'ORCID_REQUEST_UPDATE_SCOPE', 'ru', '', '', ''),
(504, 'ORCID_REQUEST_UPDATE_SCOPE', 'en', 'orcidRequestUpdateScope', 'Requesting updated ORCID record access', 'Dear {$recipientName},<br>\n<br>\nYou are listed as a contributor (author or reviewer) on the manuscript submission "{$submissionTitle}" to {$journalName}.\n<br>\n<br>\nYou have previously authorized {$journalName} to list your ORCID id on the site, and we require updateded permissions to add your contribution to your ORCID profile.<br>\nVisit the link to the official ORCID website, login with your profile and authorize the access by following the instructions.<br>\n<br>\n<a href="{$authorOrcidUrl}" style="display: inline-flex; align-items: center; background-color: white; text-align: center; padding: 10px 20px; text-decoration: none; border-radius: 5px; border: 2px solid #d7d4d4;"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Register or Connect your ORCID iD</a><br/>\n<br>\n<br>\nClick here to update your account with ORCID: <a href="{$authorOrcidUrl}">{$authorOrcidUrl}.</a>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">More about ORCID at {$journalName}</a><br/>\n<br>\n<br>\nIf you have any questions, please contact me.<br>\n<br>\n{$principalContactSignature}<br>\n'),
(505, 'MANUAL_PAYMENT_NOTIFICATION', 'de', 'Manuelle Zahlungsbenachrichtigung', 'Benachrichtigung über manuelle Zahlung', 'Eine manuelle Zahlung ist für die Zeitschrift {$journalName} und den/die Benutzer/in {$senderName} (Benutzer/innen-Name &quot;{$senderUsername}&quot;) angekündigt worden.<br />\n<br />\nGezahlt werden soll für &quot;{$paymentName}&quot;.<br />\nDie Kosten betragen {$paymentAmount} ({$paymentCurrencyCode}).<br />\n<br />\nDiese E-Mail wurde vom OJS-Plugin Manuelle Gebührenzahlung erzeugt.'),
(506, 'MANUAL_PAYMENT_NOTIFICATION', 'es', 'Notificación de pago manual', 'Notificación de pago manual', 'Se necesita procesar un pago manual para la revista {$journalName} y el usuario/a {$senderName} (username &quot;{$senderUsername}&quot;).<br />\n<br />\nEl elemento pagado es &quot;{$paymentName}&quot;.<br />\nEl precio es {$paymentAmount} ({$paymentCurrencyCode}).<br />\n<br />\nEste correo ha sido generado por el módulo de pago manual de Open Journal Systems.'),
(507, 'MANUAL_PAYMENT_NOTIFICATION', 'fr_CA', 'Avis de paiement manuel', 'Avis de paiement manuel', 'Un paiement manuel doit être traité pour la revue {$journalName} et l''utilisateur {$senderName} (nom d''utilisateur &quot;{$senderUsername}&quot;).<br />\n<br />\nL''élément facturé est &quot;{$paymentName}&quot;.<br />\nLe coût est de {$paymentAmount} ({$paymentCurrencyCode}).<br />\n<br />\nCe courriel a été généré par le plugiciel de paiement manuel du Open Journal Systems.'),
(508, 'MANUAL_PAYMENT_NOTIFICATION', 'it', 'Notifica di pagamento', 'Notifica di pagamento manuale', 'È necessario registrare un pagamento manuale per {$journalName}, utente {$senderName} (username &quot;{$senderUsername}&quot;).<br />\n<br />\nIl pagamento riguarda &quot;{$paymentName}&quot;.<br />\nIl costo è {$paymentAmount} ({$paymentCurrencyCode}).<br />\n<br />\nQuesta email è generata automaticamente dal plugin di pagamento manuale per Open Journal Systems.'),
(509, 'MANUAL_PAYMENT_NOTIFICATION', 'nl', '', 'Bericht van handmatige betaling', 'Er moet een handmatige betaling verwerkt worden voor tijdschrift {$journalName} en gebruiker {$senderName} (gebruikersnaam &quot;{$senderUsername}&quot;).<br />\n<br />\nEr wordt betaald voor &quot;{$paymentName}&quot;.<br />\nDe prijs is {$paymentAmount} ({$paymentCurrencyCode}).<br />\n<br />\nDeze e-mail is gegenereerd door de Handmatige betalingen plugin van Open Journal Systems.'),
(510, 'MANUAL_PAYMENT_NOTIFICATION', 'ru', 'Уведомить о вводе платежа вручную', 'Уведомление о платеже', 'Необходимо вручную обработать платеж для журнала «{$journalName}» и пользователя {$senderName} (имя пользователя «{$senderUsername}»).<br />\n<br />\nОплата вносится за «{$paymentName}».<br />\nСумма {$paymentAmount} ({$paymentCurrencyCode}).<br />\n<br />\nЭто письмо сгенерировано модулем «Ввод оплаты вручную» системы Open Journal Systems.'),
(511, 'MANUAL_PAYMENT_NOTIFICATION', 'en', 'Manual Payment Notify', 'Manual Payment Notification', 'A manual payment needs to be processed for the journal {$journalName} and the user &quot;{$senderUsername}&quot;.<br />\n<br />\nThe item being paid for is &quot;{$paymentName}&quot;.<br />\nThe cost is {$paymentAmount} ({$paymentCurrencyCode}).<br />\n<br />\nThis email was generated by Open Journal Systems'' Manual Payment plugin.');

-- --------------------------------------------------------

--
-- Table structure for table `email_templates_settings`
--

CREATE TABLE `email_templates_settings` (
  `email_template_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `email_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`email_template_setting_id`),
  UNIQUE KEY `email_templates_settings_unique` (`email_id`,`locale`,`setting_name`),
  KEY `email_templates_settings_email_id` (`email_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about custom email templates, including localized properties such as the subject and body.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `event_log`
--

CREATE TABLE `event_log` (
  `log_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL COMMENT 'NULL if it''s system or automated event',
  `date_logged` datetime NOT NULL,
  `event_type` bigint(20) DEFAULT NULL,
  `message` text,
  `is_translated` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `event_log_user_id` (`user_id`),
  KEY `event_log_assoc` (`assoc_type`,`assoc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A log of all events related to an object like a submission.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `event_log_settings`
--

CREATE TABLE `event_log_settings` (
  `event_log_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `log_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`event_log_setting_id`),
  UNIQUE KEY `event_log_settings_unique` (`log_id`,`setting_name`,`locale`),
  KEY `event_log_settings_log_id` (`log_id`),
  KEY `event_log_settings_name_value` (`setting_name`(50),`setting_value`(150))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data about an event log entry. This data is commonly used to display information about an event to a user.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `failed_jobs`
--

CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A log of all failed jobs.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `files`
--

CREATE TABLE `files` (
  `file_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(255) NOT NULL,
  `mimetype` varchar(255) NOT NULL,
  PRIMARY KEY (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Records information in the database about files tracked by the system, linking them to the local filesystem.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `filters`
--

CREATE TABLE `filters` (
  `filter_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `filter_group_id` bigint(20) NOT NULL,
  `context_id` bigint(20) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `class_name` varchar(255) DEFAULT NULL,
  `is_template` smallint(6) NOT NULL DEFAULT '0',
  `parent_filter_id` bigint(20) DEFAULT NULL,
  `seq` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`filter_id`),
  KEY `filters_filter_group_id` (`filter_group_id`),
  KEY `filters_context_id` (`context_id`),
  KEY `filters_parent_filter_id` (`parent_filter_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Filters represent a transformation of a supported piece of data from one form to another, such as a PHP object into an XML document.' AUTO_INCREMENT=28 ;

--
-- Dumping data for table `filters`
--

INSERT INTO `filters` VALUES
(1, 1, NULL, 'DataCite XML export', 'APP\\plugins\\generic\\datacite\\filter\\DataciteXmlFilter', 0, NULL, 0),
(2, 2, NULL, 'DataCite XML export', 'APP\\plugins\\generic\\datacite\\filter\\DataciteXmlFilter', 0, NULL, 0),
(3, 3, NULL, 'DataCite XML export', 'APP\\plugins\\generic\\datacite\\filter\\DataciteXmlFilter', 0, NULL, 0),
(4, 4, NULL, 'Crossref XML issue export', 'APP\\plugins\\generic\\crossref\\filter\\IssueCrossrefXmlFilter', 0, NULL, 0),
(5, 5, NULL, 'Crossref XML article export', 'APP\\plugins\\generic\\crossref\\filter\\ArticleCrossrefXmlFilter', 0, NULL, 0),
(6, 6, NULL, 'Extract metadata from a(n) Submission', 'APP\\plugins\\metadata\\dc11\\filter\\Dc11SchemaArticleAdapter', 0, NULL, 0),
(7, 7, NULL, 'APP\\plugins\\importexport\\pubmed\\filter\\ArticlePubMedXmlFilter', 'APP\\plugins\\importexport\\pubmed\\filter\\ArticlePubMedXmlFilter', 0, NULL, 0),
(8, 8, NULL, 'DOAJ XML export', 'APP\\plugins\\importexport\\doaj\\filter\\DOAJXmlFilter', 0, NULL, 0),
(9, 9, NULL, 'DOAJ JSON export', 'APP\\plugins\\importexport\\doaj\\filter\\DOAJJsonFilter', 0, NULL, 0),
(10, 10, NULL, 'User XML user export', 'PKP\\plugins\\importexport\\users\\filter\\PKPUserUserXmlFilter', 0, NULL, 0),
(11, 11, NULL, 'User XML user import', 'PKP\\plugins\\importexport\\users\\filter\\UserXmlPKPUserFilter', 0, NULL, 0),
(12, 12, NULL, 'Native XML user group export', 'PKP\\plugins\\importexport\\users\\filter\\UserGroupNativeXmlFilter', 0, NULL, 0),
(13, 13, NULL, 'Native XML user group import', 'PKP\\plugins\\importexport\\users\\filter\\NativeXmlUserGroupFilter', 0, NULL, 0),
(14, 14, NULL, 'Native XML submission export', 'APP\\plugins\\importexport\\native\\filter\\ArticleNativeXmlFilter', 0, NULL, 0),
(15, 15, NULL, 'Native XML submission import', 'APP\\plugins\\importexport\\native\\filter\\NativeXmlArticleFilter', 0, NULL, 0),
(16, 16, NULL, 'Native XML issue export', 'APP\\plugins\\importexport\\native\\filter\\IssueNativeXmlFilter', 0, NULL, 0),
(17, 17, NULL, 'Native XML issue import', 'APP\\plugins\\importexport\\native\\filter\\NativeXmlIssueFilter', 0, NULL, 0),
(18, 18, NULL, 'Native XML issue galley export', 'APP\\plugins\\importexport\\native\\filter\\IssueGalleyNativeXmlFilter', 0, NULL, 0),
(19, 19, NULL, 'Native XML issue galley import', 'APP\\plugins\\importexport\\native\\filter\\NativeXmlIssueGalleyFilter', 0, NULL, 0),
(20, 20, NULL, 'Native XML author export', 'APP\\plugins\\importexport\\native\\filter\\AuthorNativeXmlFilter', 0, NULL, 0),
(21, 21, NULL, 'Native XML author import', 'APP\\plugins\\importexport\\native\\filter\\NativeXmlAuthorFilter', 0, NULL, 0),
(22, 23, NULL, 'Native XML submission file import', 'APP\\plugins\\importexport\\native\\filter\\NativeXmlArticleFileFilter', 0, NULL, 0),
(23, 22, NULL, 'Native XML submission file export', 'PKP\\plugins\\importexport\\native\\filter\\SubmissionFileNativeXmlFilter', 0, NULL, 0),
(24, 24, NULL, 'Native XML representation export', 'APP\\plugins\\importexport\\native\\filter\\ArticleGalleyNativeXmlFilter', 0, NULL, 0),
(25, 25, NULL, 'Native XML representation import', 'APP\\plugins\\importexport\\native\\filter\\NativeXmlArticleGalleyFilter', 0, NULL, 0),
(26, 26, NULL, 'Native XML Publication export', 'APP\\plugins\\importexport\\native\\filter\\PublicationNativeXmlFilter', 0, NULL, 0),
(27, 27, NULL, 'Native XML publication import', 'APP\\plugins\\importexport\\native\\filter\\NativeXmlPublicationFilter', 0, NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `filter_groups`
--

CREATE TABLE `filter_groups` (
  `filter_group_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `symbolic` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `input_type` varchar(255) DEFAULT NULL,
  `output_type` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`filter_group_id`),
  UNIQUE KEY `filter_groups_symbolic` (`symbolic`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Filter groups are used to organized filters into named sets, which can be retrieved by the application for invocation.' AUTO_INCREMENT=28 ;

--
-- Dumping data for table `filter_groups`
--

INSERT INTO `filter_groups` VALUES
(1, 'issue=>datacite-xml', 'plugins.importexport.datacite.displayName', 'plugins.importexport.datacite.description', 'class::classes.issue.Issue', 'xml::schema(http://schema.datacite.org/meta/kernel-4/metadata.xsd)'),
(2, 'article=>datacite-xml', 'plugins.importexport.datacite.displayName', 'plugins.importexport.datacite.description', 'class::classes.submission.Submission', 'xml::schema(http://schema.datacite.org/meta/kernel-4/metadata.xsd)'),
(3, 'galley=>datacite-xml', 'plugins.importexport.datacite.displayName', 'plugins.importexport.datacite.description', 'class::lib.pkp.classes.galley.Galley', 'xml::schema(http://schema.datacite.org/meta/kernel-4/metadata.xsd)'),
(4, 'issue=>crossref-xml', 'plugins.importexport.crossref.displayName', 'plugins.importexport.crossref.description', 'class::classes.issue.Issue[]', 'xml::schema(https://www.crossref.org/schemas/crossref5.4.0.xsd)'),
(5, 'article=>crossref-xml', 'plugins.importexport.crossref.displayName', 'plugins.importexport.crossref.description', 'class::classes.submission.Submission[]', 'xml::schema(https://www.crossref.org/schemas/crossref5.4.0.xsd)'),
(6, 'article=>dc11', 'plugins.metadata.dc11.articleAdapter.displayName', 'plugins.metadata.dc11.articleAdapter.description', 'class::classes.submission.Submission', 'metadata::APP\\plugins\\metadata\\dc11\\schema\\Dc11Schema(ARTICLE)'),
(7, 'article=>pubmed-xml', 'plugins.importexport.pubmed.displayName', 'plugins.importexport.pubmed.description', 'class::classes.submission.Submission[]', 'xml::dtd'),
(8, 'article=>doaj-xml', 'plugins.importexport.doaj.displayName', 'plugins.importexport.doaj.description', 'class::classes.submission.Submission[]', 'xml::schema(plugins/importexport/doaj/doajArticles.xsd)'),
(9, 'article=>doaj-json', 'plugins.importexport.doaj.displayName', 'plugins.importexport.doaj.description', 'class::classes.submission.Submission', 'primitive::string'),
(10, 'user=>user-xml', 'plugins.importexport.users.displayName', 'plugins.importexport.users.description', 'class::PKP\\user\\User[]', 'xml::schema(lib/pkp/plugins/importexport/users/pkp-users.xsd)'),
(11, 'user-xml=>user', 'plugins.importexport.users.displayName', 'plugins.importexport.users.description', 'xml::schema(lib/pkp/plugins/importexport/users/pkp-users.xsd)', 'class::PKP\\user\\User[]'),
(12, 'usergroup=>user-xml', 'plugins.importexport.users.displayName', 'plugins.importexport.users.description', 'class::PKP\\userGroup\\UserGroup[]', 'xml::schema(lib/pkp/plugins/importexport/users/pkp-users.xsd)'),
(13, 'user-xml=>usergroup', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'xml::schema(lib/pkp/plugins/importexport/users/pkp-users.xsd)', 'class::PKP\\userGroup\\UserGroup[]'),
(14, 'article=>native-xml', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'class::classes.submission.Submission[]', 'xml::schema(plugins/importexport/native/native.xsd)'),
(15, 'native-xml=>article', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'xml::schema(plugins/importexport/native/native.xsd)', 'class::classes.submission.Submission[]'),
(16, 'issue=>native-xml', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'class::classes.issue.Issue[]', 'xml::schema(plugins/importexport/native/native.xsd)'),
(17, 'native-xml=>issue', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'xml::schema(plugins/importexport/native/native.xsd)', 'class::classes.issue.Issue[]'),
(18, 'issuegalley=>native-xml', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'class::classes.issue.IssueGalley[]', 'xml::schema(plugins/importexport/native/native.xsd)'),
(19, 'native-xml=>issuegalley', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'xml::schema(plugins/importexport/native/native.xsd)', 'class::classes.issue.IssueGalley[]'),
(20, 'author=>native-xml', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'class::classes.author.Author[]', 'xml::schema(plugins/importexport/native/native.xsd)'),
(21, 'native-xml=>author', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'xml::schema(plugins/importexport/native/native.xsd)', 'class::classes.author.Author[]'),
(22, 'SubmissionFile=>native-xml', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'class::lib.pkp.classes.submissionFile.SubmissionFile', 'xml::schema(plugins/importexport/native/native.xsd)'),
(23, 'native-xml=>SubmissionFile', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'xml::schema(plugins/importexport/native/native.xsd)', 'class::lib.pkp.classes.submissionFile.SubmissionFile[]'),
(24, 'article-galley=>native-xml', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'class::lib.pkp.classes.galley.Galley', 'xml::schema(plugins/importexport/native/native.xsd)'),
(25, 'native-xml=>ArticleGalley', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'xml::schema(plugins/importexport/native/native.xsd)', 'class::lib.pkp.classes.galley.Galley[]'),
(26, 'publication=>native-xml', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'class::classes.publication.Publication', 'xml::schema(plugins/importexport/native/native.xsd)'),
(27, 'native-xml=>Publication', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'xml::schema(plugins/importexport/native/native.xsd)', 'class::classes.publication.Publication[]');

-- --------------------------------------------------------

--
-- Table structure for table `filter_settings`
--

CREATE TABLE `filter_settings` (
  `filter_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `filter_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`filter_setting_id`),
  UNIQUE KEY `filter_settings_unique` (`filter_id`,`locale`,`setting_name`),
  KEY `filter_settings_id` (`filter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about filters, including localized content.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `genres`
--

CREATE TABLE `genres` (
  `genre_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `seq` bigint(20) NOT NULL,
  `enabled` smallint(6) NOT NULL DEFAULT '1',
  `category` bigint(20) NOT NULL DEFAULT '1',
  `dependent` smallint(6) NOT NULL DEFAULT '0',
  `supplementary` smallint(6) NOT NULL DEFAULT '0',
  `required` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Whether or not at least one file of this genre is required for a new submission.',
  `entry_key` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`genre_id`),
  KEY `genres_context_id` (`context_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The types of submission files configured for each context, such as Article Text, Data Set, Transcript, etc.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `genre_settings`
--

CREATE TABLE `genre_settings` (
  `genre_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `genre_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  PRIMARY KEY (`genre_setting_id`),
  UNIQUE KEY `genre_settings_unique` (`genre_id`,`locale`,`setting_name`),
  KEY `genre_settings_genre_id` (`genre_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about file genres, including localized properties such as the genre name.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `highlights`
--

CREATE TABLE `highlights` (
  `highlight_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) DEFAULT NULL,
  `sequence` bigint(20) NOT NULL,
  `url` varchar(2047) NOT NULL,
  PRIMARY KEY (`highlight_id`),
  KEY `highlights_context_id` (`context_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Highlights are featured items that can be presented to users, for example on the homepage.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `highlight_settings`
--

CREATE TABLE `highlight_settings` (
  `highlight_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `highlight_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`highlight_setting_id`),
  UNIQUE KEY `highlight_settings_unique` (`highlight_id`,`locale`,`setting_name`),
  KEY `highlight_settings_highlight_id` (`highlight_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about highlights, including localized properties like title and description.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `institutional_subscriptions`
--

CREATE TABLE `institutional_subscriptions` (
  `institutional_subscription_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `subscription_id` bigint(20) NOT NULL,
  `institution_id` bigint(20) NOT NULL,
  `mailing_address` varchar(255) DEFAULT NULL,
  `domain` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`institutional_subscription_id`),
  KEY `institutional_subscriptions_subscription_id` (`subscription_id`),
  KEY `institutional_subscriptions_institution_id` (`institution_id`),
  KEY `institutional_subscriptions_domain` (`domain`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A list of institutional subscriptions, linking a subscription with an institution.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `institutions`
--

CREATE TABLE `institutions` (
  `institution_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `ror` varchar(255) DEFAULT NULL COMMENT 'ROR (Research Organization Registry) ID',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`institution_id`),
  KEY `institutions_context_id` (`context_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Institutions for statistics and subscriptions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `institution_ip`
--

CREATE TABLE `institution_ip` (
  `institution_ip_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `institution_id` bigint(20) NOT NULL,
  `ip_string` varchar(40) NOT NULL,
  `ip_start` bigint(20) NOT NULL,
  `ip_end` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`institution_ip_id`),
  KEY `institution_ip_institution_id` (`institution_id`),
  KEY `institution_ip_start` (`ip_start`),
  KEY `institution_ip_end` (`ip_end`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Records IP address ranges and associates them with institutions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `institution_settings`
--

CREATE TABLE `institution_settings` (
  `institution_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `institution_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`institution_setting_id`),
  UNIQUE KEY `institution_settings_unique` (`institution_id`,`locale`,`setting_name`),
  KEY `institution_settings_institution_id` (`institution_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about institutions, including localized properties like names.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `invitations`
--

CREATE TABLE `invitations` (
  `invitation_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `key_hash` varchar(255) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `inviter_id` bigint(20) DEFAULT NULL,
  `expiry_date` datetime DEFAULT NULL,
  `payload` json DEFAULT NULL,
  `status` enum('INITIALIZED','PENDING','ACCEPTED','DECLINED','CANCELLED') NOT NULL,
  `email` varchar(255) DEFAULT NULL COMMENT 'When present, the email address of the invitation recipient; when null, user_id must be set and the email can be fetched from the users table.',
  `context_id` bigint(20) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`invitation_id`),
  KEY `invitations_user_id` (`user_id`),
  KEY `invitations_inviter_id` (`inviter_id`),
  KEY `invitations_context_id` (`context_id`),
  KEY `invitations_status_context_id_user_id_type_index` (`status`,`context_id`,`user_id`,`type`),
  KEY `invitations_expiry_date_index` (`expiry_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Invitations are sent to request a person (by email) to allow them to accept or reject an operation or position, such as a board membership or a submission peer review.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `issues`
--

CREATE TABLE `issues` (
  `issue_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `journal_id` bigint(20) NOT NULL,
  `volume` smallint(6) DEFAULT NULL,
  `number` varchar(40) DEFAULT NULL,
  `year` smallint(6) DEFAULT NULL,
  `published` smallint(6) NOT NULL DEFAULT '0',
  `date_published` datetime DEFAULT NULL,
  `date_notified` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `access_status` smallint(6) NOT NULL DEFAULT '1',
  `open_access_date` datetime DEFAULT NULL,
  `show_volume` smallint(6) NOT NULL DEFAULT '0',
  `show_number` smallint(6) NOT NULL DEFAULT '0',
  `show_year` smallint(6) NOT NULL DEFAULT '0',
  `show_title` smallint(6) NOT NULL DEFAULT '0',
  `style_file_name` varchar(90) DEFAULT NULL,
  `original_style_file_name` varchar(255) DEFAULT NULL,
  `url_path` varchar(64) DEFAULT NULL,
  `doi_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`issue_id`),
  KEY `issues_journal_id` (`journal_id`),
  KEY `issues_doi_id` (`doi_id`),
  KEY `issues_url_path` (`url_path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A list of all journal issues, with identifying information like year, number, volume, etc.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `issue_files`
--

CREATE TABLE `issue_files` (
  `file_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `issue_id` bigint(20) NOT NULL,
  `file_name` varchar(90) NOT NULL,
  `file_type` varchar(255) NOT NULL,
  `file_size` bigint(20) NOT NULL,
  `content_type` bigint(20) NOT NULL,
  `original_file_name` varchar(127) DEFAULT NULL,
  `date_uploaded` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  PRIMARY KEY (`file_id`),
  KEY `issue_files_issue_id` (`issue_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Relationships between issues and issue files, such as cover images.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `issue_galleys`
--

CREATE TABLE `issue_galleys` (
  `galley_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `locale` varchar(28) DEFAULT NULL,
  `issue_id` bigint(20) NOT NULL,
  `file_id` bigint(20) NOT NULL,
  `label` varchar(255) DEFAULT NULL,
  `seq` double NOT NULL DEFAULT '0',
  `url_path` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`galley_id`),
  KEY `issue_galleys_issue_id` (`issue_id`),
  KEY `issue_galleys_file_id` (`file_id`),
  KEY `issue_galleys_url_path` (`url_path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Issue galleys are representations of the entire issue in a single file, such as a complete issue PDF.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `issue_galley_settings`
--

CREATE TABLE `issue_galley_settings` (
  `issue_galley_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `galley_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  PRIMARY KEY (`issue_galley_setting_id`),
  UNIQUE KEY `issue_galley_settings_unique` (`galley_id`,`locale`,`setting_name`),
  KEY `issue_galley_settings_galley_id` (`galley_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about issue galleys, including localized content such as labels.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `issue_settings`
--

CREATE TABLE `issue_settings` (
  `issue_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `issue_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`issue_setting_id`),
  UNIQUE KEY `issue_settings_unique` (`issue_id`,`locale`,`setting_name`),
  KEY `issue_settings_issue_id` (`issue_id`),
  KEY `issue_settings_name_value` (`setting_name`(50),`setting_value`(150))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about issues, including localized properties such as issue titles.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jobs`
--

CREATE TABLE `jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) NOT NULL,
  `payload` longtext NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_reserved_at_index` (`queue`,`reserved_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='All pending or in-progress jobs.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `job_batches`
--

CREATE TABLE `job_batches` (
  `id` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `total_jobs` int(11) NOT NULL,
  `pending_jobs` int(11) NOT NULL,
  `failed_jobs` int(11) NOT NULL,
  `failed_job_ids` text NOT NULL,
  `options` mediumtext,
  `cancelled_at` int(11) DEFAULT NULL,
  `created_at` int(11) NOT NULL,
  `finished_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Job batches allow jobs to be collected into groups for managed processing.';

-- --------------------------------------------------------

--
-- Table structure for table `journals`
--

CREATE TABLE `journals` (
  `journal_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `path` varchar(32) NOT NULL,
  `seq` double NOT NULL DEFAULT '0' COMMENT 'Used to order lists of journals',
  `primary_locale` varchar(28) NOT NULL,
  `enabled` smallint(6) NOT NULL DEFAULT '1' COMMENT 'Controls whether or not the journal is considered "live" and will appear on the website. (Note that disabled journals may still be accessible, but only if the user knows the URL.)',
  `current_issue_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`journal_id`),
  UNIQUE KEY `journals_path` (`path`),
  KEY `journals_issue_id` (`current_issue_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A list of all journals in the installation of OJS.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `journal_settings`
--

CREATE TABLE `journal_settings` (
  `journal_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `journal_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`journal_setting_id`),
  UNIQUE KEY `journal_settings_unique` (`journal_id`,`locale`,`setting_name`),
  KEY `journal_settings_journal_id` (`journal_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about journals, including localized properties like policies.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `library_files`
--

CREATE TABLE `library_files` (
  `file_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `original_file_name` varchar(255) NOT NULL,
  `file_type` varchar(255) NOT NULL,
  `file_size` bigint(20) NOT NULL,
  `type` smallint(6) NOT NULL,
  `date_uploaded` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `submission_id` bigint(20) DEFAULT NULL,
  `public_access` smallint(6) DEFAULT '0',
  PRIMARY KEY (`file_id`),
  KEY `library_files_context_id` (`context_id`),
  KEY `library_files_submission_id` (`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Library files can be associated with the context (press/server/journal) or with individual submissions, and are typically forms, agreements, and other administrative documents that are not part of the scholarly content.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `library_file_settings`
--

CREATE TABLE `library_file_settings` (
  `library_file_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `file_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object|date)',
  PRIMARY KEY (`library_file_setting_id`),
  UNIQUE KEY `library_file_settings_unique` (`file_id`,`locale`,`setting_name`),
  KEY `library_file_settings_file_id` (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about library files, including localized content such as names.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_context`
--

CREATE TABLE `metrics_context` (
  `metrics_context_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `load_id` varchar(50) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `date` date NOT NULL,
  `metric` int(11) NOT NULL,
  PRIMARY KEY (`metrics_context_id`),
  KEY `metrics_context_load_id` (`load_id`),
  KEY `metrics_context_context_id` (`context_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Daily statistics for views of the homepage.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_counter_submission_daily`
--

CREATE TABLE `metrics_counter_submission_daily` (
  `metrics_counter_submission_daily_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `load_id` varchar(50) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `date` date NOT NULL,
  `metric_investigations` int(11) NOT NULL,
  `metric_investigations_unique` int(11) NOT NULL,
  `metric_requests` int(11) NOT NULL,
  `metric_requests_unique` int(11) NOT NULL,
  PRIMARY KEY (`metrics_counter_submission_daily_id`),
  UNIQUE KEY `msd_uc_load_id_context_id_submission_id_date` (`load_id`,`context_id`,`submission_id`,`date`),
  KEY `msd_load_id` (`load_id`),
  KEY `metrics_counter_submission_daily_context_id` (`context_id`),
  KEY `metrics_counter_submission_daily_submission_id` (`submission_id`),
  KEY `msd_context_id_submission_id` (`context_id`,`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Daily statistics matching the COUNTER R5 protocol for views and downloads of published submissions and galleys.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_counter_submission_institution_daily`
--

CREATE TABLE `metrics_counter_submission_institution_daily` (
  `metrics_counter_submission_institution_daily_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `load_id` varchar(50) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `institution_id` bigint(20) NOT NULL,
  `date` date NOT NULL,
  `metric_investigations` int(11) NOT NULL,
  `metric_investigations_unique` int(11) NOT NULL,
  `metric_requests` int(11) NOT NULL,
  `metric_requests_unique` int(11) NOT NULL,
  PRIMARY KEY (`metrics_counter_submission_institution_daily_id`),
  UNIQUE KEY `msid_uc_load_id_context_id_submission_id_institution_id_date` (`load_id`,`context_id`,`submission_id`,`institution_id`,`date`),
  KEY `msid_load_id` (`load_id`),
  KEY `metrics_counter_submission_institution_daily_context_id` (`context_id`),
  KEY `metrics_counter_submission_institution_daily_submission_id` (`submission_id`),
  KEY `metrics_counter_submission_institution_daily_institution_id` (`institution_id`),
  KEY `msid_context_id_submission_id` (`context_id`,`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Daily statistics matching the COUNTER R5 protocol for views and downloads from institutions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_counter_submission_institution_monthly`
--

CREATE TABLE `metrics_counter_submission_institution_monthly` (
  `metrics_counter_submission_institution_monthly_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `institution_id` bigint(20) NOT NULL,
  `month` int(11) NOT NULL,
  `metric_investigations` int(11) NOT NULL,
  `metric_investigations_unique` int(11) NOT NULL,
  `metric_requests` int(11) NOT NULL,
  `metric_requests_unique` int(11) NOT NULL,
  PRIMARY KEY (`metrics_counter_submission_institution_monthly_id`),
  UNIQUE KEY `msim_uc_context_id_submission_id_institution_id_month` (`context_id`,`submission_id`,`institution_id`,`month`),
  KEY `metrics_counter_submission_institution_monthly_context_id` (`context_id`),
  KEY `metrics_counter_submission_institution_monthly_submission_id` (`submission_id`),
  KEY `metrics_counter_submission_institution_monthly_institution_id` (`institution_id`),
  KEY `msim_context_id_submission_id` (`context_id`,`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Monthly statistics matching the COUNTER R5 protocol for views and downloads from institutions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_counter_submission_monthly`
--

CREATE TABLE `metrics_counter_submission_monthly` (
  `metrics_counter_submission_monthly_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `month` int(11) NOT NULL,
  `metric_investigations` int(11) NOT NULL,
  `metric_investigations_unique` int(11) NOT NULL,
  `metric_requests` int(11) NOT NULL,
  `metric_requests_unique` int(11) NOT NULL,
  PRIMARY KEY (`metrics_counter_submission_monthly_id`),
  UNIQUE KEY `msm_uc_context_id_submission_id_month` (`context_id`,`submission_id`,`month`),
  KEY `metrics_counter_submission_monthly_context_id` (`context_id`),
  KEY `metrics_counter_submission_monthly_submission_id` (`submission_id`),
  KEY `msm_context_id_submission_id` (`context_id`,`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Monthly statistics matching the COUNTER R5 protocol for views and downloads of published submissions and galleys.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_issue`
--

CREATE TABLE `metrics_issue` (
  `metrics_issue_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `load_id` varchar(50) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `issue_id` bigint(20) NOT NULL,
  `issue_galley_id` bigint(20) DEFAULT NULL,
  `date` date NOT NULL,
  `metric` int(11) NOT NULL,
  PRIMARY KEY (`metrics_issue_id`),
  KEY `metrics_issue_load_id` (`load_id`),
  KEY `metrics_issue_context_id` (`context_id`),
  KEY `metrics_issue_issue_id` (`issue_id`),
  KEY `metrics_issue_issue_galley_id` (`issue_galley_id`),
  KEY `metrics_issue_context_id_issue_id` (`context_id`,`issue_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Daily statistics for views and downloads of published issues.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_submission`
--

CREATE TABLE `metrics_submission` (
  `metrics_submission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `load_id` varchar(50) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `representation_id` bigint(20) DEFAULT NULL,
  `submission_file_id` bigint(20) unsigned DEFAULT NULL,
  `file_type` bigint(20) DEFAULT NULL,
  `assoc_type` bigint(20) NOT NULL,
  `date` date NOT NULL,
  `metric` int(11) NOT NULL,
  PRIMARY KEY (`metrics_submission_id`),
  KEY `ms_load_id` (`load_id`),
  KEY `metrics_submission_context_id` (`context_id`),
  KEY `metrics_submission_submission_id` (`submission_id`),
  KEY `metrics_submission_representation_id` (`representation_id`),
  KEY `metrics_submission_submission_file_id` (`submission_file_id`),
  KEY `ms_context_id_submission_id_assoc_type_file_type` (`context_id`,`submission_id`,`assoc_type`,`file_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Daily statistics for views and downloads of published submissions and galleys.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_submission_geo_daily`
--

CREATE TABLE `metrics_submission_geo_daily` (
  `metrics_submission_geo_daily_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `load_id` varchar(50) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `country` varchar(2) NOT NULL DEFAULT '',
  `region` varchar(3) NOT NULL DEFAULT '',
  `city` varchar(255) NOT NULL DEFAULT '',
  `date` date NOT NULL,
  `metric` int(11) NOT NULL,
  `metric_unique` int(11) NOT NULL,
  PRIMARY KEY (`metrics_submission_geo_daily_id`),
  UNIQUE KEY `msgd_uc_load_context_submission_c_r_c_date` (`load_id`,`context_id`,`submission_id`,`country`,`region`,`city`(80),`date`),
  KEY `msgd_load_id` (`load_id`),
  KEY `metrics_submission_geo_daily_context_id` (`context_id`),
  KEY `metrics_submission_geo_daily_submission_id` (`submission_id`),
  KEY `msgd_context_id_submission_id` (`context_id`,`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Daily statistics by country, region and city for views and downloads of published submissions and galleys.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_submission_geo_monthly`
--

CREATE TABLE `metrics_submission_geo_monthly` (
  `metrics_submission_geo_monthly_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `country` varchar(2) NOT NULL DEFAULT '',
  `region` varchar(3) NOT NULL DEFAULT '',
  `city` varchar(255) NOT NULL DEFAULT '',
  `month` int(11) NOT NULL,
  `metric` int(11) NOT NULL,
  `metric_unique` int(11) NOT NULL,
  PRIMARY KEY (`metrics_submission_geo_monthly_id`),
  UNIQUE KEY `msgm_uc_context_submission_c_r_c_month` (`context_id`,`submission_id`,`country`,`region`,`city`(80),`month`),
  KEY `metrics_submission_geo_monthly_context_id` (`context_id`),
  KEY `metrics_submission_geo_monthly_submission_id` (`submission_id`),
  KEY `msgm_context_id_submission_id` (`context_id`,`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Monthly statistics by country, region and city for views and downloads of published submissions and galleys.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `navigation_menus`
--

CREATE TABLE `navigation_menus` (
  `navigation_menu_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) DEFAULT NULL,
  `area_name` varchar(255) DEFAULT '',
  `title` varchar(255) NOT NULL,
  PRIMARY KEY (`navigation_menu_id`),
  KEY `navigation_menus_context_id` (`context_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Navigation menus on the website are installed with the software as a default set, and can be customized.' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `navigation_menus`
--

INSERT INTO `navigation_menus` VALUES
(1, NULL, 'user', 'User Navigation Menu');

-- --------------------------------------------------------

--
-- Table structure for table `navigation_menu_items`
--

CREATE TABLE `navigation_menu_items` (
  `navigation_menu_item_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) DEFAULT NULL,
  `path` varchar(255) DEFAULT '',
  `type` varchar(255) DEFAULT '',
  PRIMARY KEY (`navigation_menu_item_id`),
  KEY `navigation_menu_items_context_id` (`context_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Navigation menu items are single elements within a navigation menu.' AUTO_INCREMENT=8 ;

--
-- Dumping data for table `navigation_menu_items`
--

INSERT INTO `navigation_menu_items` VALUES
(1, NULL, NULL, 'NMI_TYPE_USER_REGISTER'),
(2, NULL, NULL, 'NMI_TYPE_USER_LOGIN'),
(3, NULL, NULL, 'NMI_TYPE_USER_DASHBOARD'),
(4, NULL, NULL, 'NMI_TYPE_USER_DASHBOARD'),
(5, NULL, NULL, 'NMI_TYPE_USER_PROFILE'),
(6, NULL, NULL, 'NMI_TYPE_ADMINISTRATION'),
(7, NULL, NULL, 'NMI_TYPE_USER_LOGOUT');

-- --------------------------------------------------------

--
-- Table structure for table `navigation_menu_item_assignments`
--

CREATE TABLE `navigation_menu_item_assignments` (
  `navigation_menu_item_assignment_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `navigation_menu_id` bigint(20) NOT NULL,
  `navigation_menu_item_id` bigint(20) NOT NULL,
  `parent_id` bigint(20) DEFAULT NULL,
  `seq` bigint(20) DEFAULT '0',
  PRIMARY KEY (`navigation_menu_item_assignment_id`),
  KEY `navigation_menu_item_assignments_navigation_menu_id` (`navigation_menu_id`),
  KEY `navigation_menu_item_assignments_navigation_menu_item_id` (`navigation_menu_item_id`),
  KEY `navigation_menu_item_assignments_parent_id` (`parent_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Links navigation menu items to navigation menus.' AUTO_INCREMENT=8 ;

--
-- Dumping data for table `navigation_menu_item_assignments`
--

INSERT INTO `navigation_menu_item_assignments` VALUES
(1, 1, 1, NULL, 0),
(2, 1, 2, NULL, 1),
(3, 1, 3, NULL, 2),
(4, 1, 4, 3, 0),
(5, 1, 5, 3, 1),
(6, 1, 6, 3, 2),
(7, 1, 7, 3, 3);

-- --------------------------------------------------------

--
-- Table structure for table `navigation_menu_item_assignment_settings`
--

CREATE TABLE `navigation_menu_item_assignment_settings` (
  `navigation_menu_item_assignment_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `navigation_menu_item_assignment_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`navigation_menu_item_assignment_setting_id`),
  UNIQUE KEY `navigation_menu_item_assignment_settings_unique` (`navigation_menu_item_assignment_id`,`locale`,`setting_name`),
  KEY `navigation_menu_item_assignment_settings_n_m_i_a_id` (`navigation_menu_item_assignment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about navigation menu item assignments to navigation menus, including localized content.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `navigation_menu_item_settings`
--

CREATE TABLE `navigation_menu_item_settings` (
  `navigation_menu_item_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `navigation_menu_item_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` longtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`navigation_menu_item_setting_id`),
  UNIQUE KEY `navigation_menu_item_settings_unique` (`navigation_menu_item_id`,`locale`,`setting_name`),
  KEY `navigation_menu_item_settings_navigation_menu_item_id` (`navigation_menu_item_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='More data about navigation menu items, including localized content such as names.' AUTO_INCREMENT=8 ;

--
-- Dumping data for table `navigation_menu_item_settings`
--

INSERT INTO `navigation_menu_item_settings` VALUES
(1, 1, '', 'titleLocaleKey', 'navigation.register', 'string'),
(2, 2, '', 'titleLocaleKey', 'navigation.login', 'string'),
(3, 3, '', 'titleLocaleKey', '{$loggedInUsername}', 'string'),
(4, 4, '', 'titleLocaleKey', 'navigation.dashboard', 'string'),
(5, 5, '', 'titleLocaleKey', 'common.viewProfile', 'string'),
(6, 6, '', 'titleLocaleKey', 'navigation.admin', 'string'),
(7, 7, '', 'titleLocaleKey', 'user.logOut', 'string');

-- --------------------------------------------------------

--
-- Table structure for table `notes`
--

CREATE TABLE `notes` (
  `note_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `contents` text,
  PRIMARY KEY (`note_id`),
  KEY `notes_user_id` (`user_id`),
  KEY `notes_assoc` (`assoc_type`,`assoc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Notes allow users to annotate associated entities, such as submissions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `notifications`
--

CREATE TABLE `notifications` (
  `notification_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `level` bigint(20) NOT NULL,
  `type` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL,
  `date_read` datetime DEFAULT NULL,
  `assoc_type` bigint(20) DEFAULT NULL,
  `assoc_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`notification_id`),
  KEY `notifications_context_id` (`context_id`),
  KEY `notifications_user_id` (`user_id`),
  KEY `notifications_context_id_user_id` (`context_id`,`user_id`,`level`),
  KEY `notifications_context_id_level` (`context_id`,`level`),
  KEY `notifications_assoc` (`assoc_type`,`assoc_id`),
  KEY `notifications_user_id_level` (`user_id`,`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='User notifications created during certain operations.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `notification_settings`
--

CREATE TABLE `notification_settings` (
  `notification_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `notification_id` bigint(20) NOT NULL,
  `locale` varchar(28) DEFAULT NULL,
  `setting_name` varchar(64) NOT NULL,
  `setting_value` mediumtext NOT NULL,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  PRIMARY KEY (`notification_setting_id`),
  UNIQUE KEY `notification_settings_unique` (`notification_id`,`locale`,`setting_name`),
  KEY `notification_settings_notification_id` (`notification_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about notifications, including localized properties.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `notification_subscription_settings`
--

CREATE TABLE `notification_subscription_settings` (
  `setting_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `setting_name` varchar(64) NOT NULL,
  `setting_value` mediumtext NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `context_id` bigint(20) DEFAULT NULL,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  PRIMARY KEY (`setting_id`),
  KEY `notification_subscription_settings_user_id` (`user_id`),
  KEY `notification_subscription_settings_context` (`context_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Which email notifications a user has chosen to unsubscribe from.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oai_resumption_tokens`
--

CREATE TABLE `oai_resumption_tokens` (
  `oai_resumption_token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `token` varchar(32) NOT NULL,
  `expire` bigint(20) NOT NULL,
  `record_offset` int(11) NOT NULL,
  `params` text,
  PRIMARY KEY (`oai_resumption_token_id`),
  UNIQUE KEY `oai_resumption_tokens_unique` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='OAI resumption tokens are used to allow for pagination of large result sets into manageable pieces.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `plugin_settings`
--

CREATE TABLE `plugin_settings` (
  `plugin_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `plugin_name` varchar(80) NOT NULL,
  `context_id` bigint(20) DEFAULT NULL,
  `setting_name` varchar(80) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  PRIMARY KEY (`plugin_setting_id`),
  UNIQUE KEY `plugin_settings_unique` (`plugin_name`,`context_id`,`setting_name`),
  KEY `plugin_settings_context_id` (`context_id`),
  KEY `plugin_settings_plugin_name` (`plugin_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='More data about plugins, including localized properties. This table is frequently used to store plugin-specific configuration.' AUTO_INCREMENT=8 ;

--
-- Dumping data for table `plugin_settings`
--

INSERT INTO `plugin_settings` VALUES
(1, 'defaultthemeplugin', NULL, 'enabled', '1', 'bool'),
(2, 'tinymceplugin', NULL, 'enabled', '1', 'bool'),
(3, 'usageeventplugin', NULL, 'enabled', '1', 'bool'),
(4, 'developedbyblockplugin', NULL, 'enabled', '0', 'bool'),
(5, 'developedbyblockplugin', NULL, 'seq', '0', 'int'),
(6, 'languagetoggleblockplugin', NULL, 'enabled', '1', 'bool'),
(7, 'languagetoggleblockplugin', NULL, 'seq', '4', 'int');

-- --------------------------------------------------------

--
-- Table structure for table `publications`
--

CREATE TABLE `publications` (
  `publication_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `access_status` bigint(20) DEFAULT '0',
  `date_published` date DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `primary_contact_id` bigint(20) DEFAULT NULL,
  `section_id` bigint(20) DEFAULT NULL,
  `seq` double NOT NULL DEFAULT '0',
  `submission_id` bigint(20) NOT NULL,
  `status` smallint(6) NOT NULL DEFAULT '1',
  `url_path` varchar(64) DEFAULT NULL,
  `version` bigint(20) DEFAULT NULL,
  `doi_id` bigint(20) DEFAULT NULL,
  `issue_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`publication_id`),
  KEY `publications_primary_contact_id` (`primary_contact_id`),
  KEY `publications_section_id` (`section_id`),
  KEY `publications_submission_id` (`submission_id`),
  KEY `publications_doi_id` (`doi_id`),
  KEY `publications_issue_id_index` (`issue_id`),
  KEY `publications_url_path` (`url_path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Each publication is one version of a submission.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `publication_categories`
--

CREATE TABLE `publication_categories` (
  `publication_category_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `publication_id` bigint(20) NOT NULL,
  `category_id` bigint(20) NOT NULL,
  PRIMARY KEY (`publication_category_id`),
  UNIQUE KEY `publication_categories_id` (`publication_id`,`category_id`),
  KEY `publication_categories_publication_id` (`publication_id`),
  KEY `publication_categories_category_id` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Associates publications (and thus submissions) with categories.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `publication_galleys`
--

CREATE TABLE `publication_galleys` (
  `galley_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `locale` varchar(28) DEFAULT NULL,
  `publication_id` bigint(20) NOT NULL,
  `label` varchar(255) DEFAULT NULL,
  `submission_file_id` bigint(20) unsigned DEFAULT NULL,
  `seq` double NOT NULL DEFAULT '0',
  `remote_url` varchar(2047) DEFAULT NULL,
  `is_approved` smallint(6) NOT NULL DEFAULT '0',
  `url_path` varchar(64) DEFAULT NULL,
  `doi_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`galley_id`),
  KEY `publication_galleys_publication_id` (`publication_id`),
  KEY `publication_galleys_submission_file_id` (`submission_file_id`),
  KEY `publication_galleys_doi_id` (`doi_id`),
  KEY `publication_galleys_url_path` (`url_path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Publication galleys are representations of a publication in a specific format, e.g. a PDF.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `publication_galley_settings`
--

CREATE TABLE `publication_galley_settings` (
  `publication_galley_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `galley_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`publication_galley_setting_id`),
  UNIQUE KEY `publication_galley_settings_unique` (`galley_id`,`locale`,`setting_name`),
  KEY `publication_galley_settings_galley_id` (`galley_id`),
  KEY `publication_galley_settings_name_value` (`setting_name`(50),`setting_value`(150))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about publication galleys, including localized content such as labels.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `publication_settings`
--

CREATE TABLE `publication_settings` (
  `publication_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `publication_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`publication_setting_id`),
  UNIQUE KEY `publication_settings_unique` (`publication_id`,`locale`,`setting_name`),
  KEY `publication_settings_name_value` (`setting_name`(50),`setting_value`(150)),
  KEY `publication_settings_publication_id` (`publication_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about publications, including localized properties such as the title and abstract.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `queries`
--

CREATE TABLE `queries` (
  `query_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `stage_id` smallint(6) NOT NULL,
  `seq` double NOT NULL DEFAULT '0',
  `date_posted` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `closed` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`query_id`),
  KEY `queries_assoc_id` (`assoc_type`,`assoc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Discussions, usually related to a submission, created by editors, authors and other editorial staff.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `query_participants`
--

CREATE TABLE `query_participants` (
  `query_participant_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `query_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  PRIMARY KEY (`query_participant_id`),
  UNIQUE KEY `query_participants_unique` (`query_id`,`user_id`),
  KEY `query_participants_query_id` (`query_id`),
  KEY `query_participants_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The users assigned to a discussion.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `queued_payments`
--

CREATE TABLE `queued_payments` (
  `queued_payment_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `date_created` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `expiry_date` date DEFAULT NULL,
  `payment_data` text,
  PRIMARY KEY (`queued_payment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Unfulfilled (queued) payments, i.e. payments that have not yet been completed via an online payment system.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `reviewer_suggestions`
--

CREATE TABLE `reviewer_suggestions` (
  `reviewer_suggestion_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `suggesting_user_id` bigint(20) DEFAULT NULL COMMENT 'The user/author who has made the suggestion',
  `submission_id` bigint(20) NOT NULL COMMENT 'Submission at which the suggestion was made',
  `email` varchar(255) NOT NULL COMMENT 'Suggested reviewer email address',
  `orcid_id` varchar(255) DEFAULT NULL COMMENT 'Suggested reviewer optional Orcid Id',
  `approved_at` timestamp NULL DEFAULT NULL COMMENT 'If and when the suggestion approved to add/invite suggested_reviewer',
  `approver_id` bigint(20) DEFAULT NULL COMMENT 'The user who has approved the suggestion',
  `reviewer_id` bigint(20) DEFAULT NULL COMMENT 'The reviewer who has been added/invited through this suggestion',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`reviewer_suggestion_id`),
  KEY `reviewer_suggestions_suggesting_user_id` (`suggesting_user_id`),
  KEY `reviewer_suggestions_submission_id` (`submission_id`),
  KEY `reviewer_suggestions_approver_id_foreign` (`approver_id`),
  KEY `reviewer_suggestions_reviewer_id_foreign` (`reviewer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Author suggested reviewers at the submission time' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `reviewer_suggestion_settings`
--

CREATE TABLE `reviewer_suggestion_settings` (
  `reviewer_suggestion_id` bigint(20) NOT NULL COMMENT 'The foreign key mapping of this setting to reviewer_suggestions table',
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  UNIQUE KEY `reviewer_suggestion_settings_unique` (`reviewer_suggestion_id`,`locale`,`setting_name`),
  KEY `reviewer_suggestion_settings_reviewer_suggestion_id` (`reviewer_suggestion_id`),
  KEY `reviewer_suggestion_settings_locale_setting_name_index` (`setting_name`,`locale`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Reviewer suggestion settings table to contain multilingual or extra information';

-- --------------------------------------------------------

--
-- Table structure for table `review_assignments`
--

CREATE TABLE `review_assignments` (
  `review_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `reviewer_id` bigint(20) NOT NULL,
  `competing_interests` text,
  `recommendation` smallint(6) DEFAULT NULL,
  `date_assigned` datetime DEFAULT NULL,
  `date_notified` datetime DEFAULT NULL,
  `date_confirmed` datetime DEFAULT NULL,
  `date_completed` datetime DEFAULT NULL,
  `date_considered` datetime DEFAULT NULL,
  `date_acknowledged` datetime DEFAULT NULL,
  `date_due` datetime DEFAULT NULL,
  `date_response_due` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `reminder_was_automatic` smallint(6) NOT NULL DEFAULT '0',
  `declined` smallint(6) NOT NULL DEFAULT '0',
  `cancelled` smallint(6) NOT NULL DEFAULT '0',
  `date_cancelled` datetime DEFAULT NULL,
  `date_rated` datetime DEFAULT NULL,
  `date_reminded` datetime DEFAULT NULL,
  `quality` smallint(6) DEFAULT NULL,
  `review_round_id` bigint(20) NOT NULL,
  `stage_id` smallint(6) NOT NULL,
  `review_method` smallint(6) NOT NULL DEFAULT '1',
  `round` smallint(6) NOT NULL DEFAULT '1',
  `step` smallint(6) NOT NULL DEFAULT '1',
  `review_form_id` bigint(20) DEFAULT NULL,
  `considered` smallint(6) DEFAULT NULL,
  `request_resent` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`review_id`),
  KEY `review_assignments_submission_id` (`submission_id`),
  KEY `review_assignments_reviewer_id` (`reviewer_id`),
  KEY `review_assignment_reviewer_round` (`review_round_id`,`reviewer_id`),
  KEY `review_assignments_form_id` (`review_form_id`),
  KEY `review_assignments_reviewer_review` (`reviewer_id`,`review_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data about peer review assignments for all submissions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_assignment_settings`
--

CREATE TABLE `review_assignment_settings` (
  `review_assignment_settings_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary key.',
  `review_id` bigint(20) NOT NULL COMMENT 'Foreign key referencing record in review_assignments table',
  `locale` varchar(28) DEFAULT NULL COMMENT 'Locale key.',
  `setting_name` varchar(255) NOT NULL COMMENT 'Name of settings record.',
  `setting_value` mediumtext COMMENT 'Settings value.',
  PRIMARY KEY (`review_assignment_settings_id`),
  UNIQUE KEY `review_assignment_settings_unique` (`review_id`,`locale`,`setting_name`),
  KEY `review_assignment_settings_review_id` (`review_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_files`
--

CREATE TABLE `review_files` (
  `review_file_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `review_id` bigint(20) NOT NULL,
  `submission_file_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`review_file_id`),
  UNIQUE KEY `review_files_unique` (`review_id`,`submission_file_id`),
  KEY `review_files_review_id` (`review_id`),
  KEY `review_files_submission_file_id` (`submission_file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A list of the submission files made available to each assigned reviewer.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_forms`
--

CREATE TABLE `review_forms` (
  `review_form_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `seq` double DEFAULT NULL,
  `is_active` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`review_form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Review forms provide custom templates for peer reviews with several types of questions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_form_elements`
--

CREATE TABLE `review_form_elements` (
  `review_form_element_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `review_form_id` bigint(20) NOT NULL,
  `seq` double DEFAULT NULL,
  `element_type` bigint(20) DEFAULT NULL,
  `required` smallint(6) DEFAULT NULL,
  `included` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`review_form_element_id`),
  KEY `review_form_elements_review_form_id` (`review_form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Each review form element represents a single question on a review form.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_form_element_settings`
--

CREATE TABLE `review_form_element_settings` (
  `review_form_element_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `review_form_element_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`review_form_element_setting_id`),
  UNIQUE KEY `review_form_element_settings_unique` (`review_form_element_id`,`locale`,`setting_name`),
  KEY `review_form_element_settings_review_form_element_id` (`review_form_element_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about review form elements, including localized content such as question text.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_form_responses`
--

CREATE TABLE `review_form_responses` (
  `review_form_response_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `review_form_element_id` bigint(20) NOT NULL,
  `review_id` bigint(20) NOT NULL,
  `response_type` varchar(6) DEFAULT NULL,
  `response_value` text,
  PRIMARY KEY (`review_form_response_id`),
  KEY `review_form_responses_review_form_element_id` (`review_form_element_id`),
  KEY `review_form_responses_review_id` (`review_id`),
  KEY `review_form_responses_unique` (`review_form_element_id`,`review_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Each review form response records a reviewer''s answer to a review form element associated with a peer review.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_form_settings`
--

CREATE TABLE `review_form_settings` (
  `review_form_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `review_form_id` bigint(20) NOT NULL,
  `locale` varchar(28) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`review_form_setting_id`),
  UNIQUE KEY `review_form_settings_unique` (`review_form_id`,`locale`,`setting_name`),
  KEY `review_form_settings_review_form_id` (`review_form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about review forms, including localized content such as names.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_rounds`
--

CREATE TABLE `review_rounds` (
  `review_round_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `stage_id` bigint(20) DEFAULT NULL,
  `round` smallint(6) NOT NULL,
  `review_revision` bigint(20) DEFAULT NULL,
  `status` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`review_round_id`),
  UNIQUE KEY `review_rounds_submission_id_stage_id_round_pkey` (`submission_id`,`stage_id`,`round`),
  KEY `review_rounds_submission_id` (`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Peer review assignments are organized into multiple rounds on a submission.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_round_files`
--

CREATE TABLE `review_round_files` (
  `review_round_file_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `review_round_id` bigint(20) NOT NULL,
  `stage_id` smallint(6) NOT NULL,
  `submission_file_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`review_round_file_id`),
  UNIQUE KEY `review_round_files_unique` (`submission_id`,`review_round_id`,`submission_file_id`),
  KEY `review_round_files_submission_id` (`submission_id`),
  KEY `review_round_files_review_round_id` (`review_round_id`),
  KEY `review_round_files_submission_file_id` (`submission_file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Records the files made available to reviewers for a round of reviews. These can be further customized on a per review basis with review_files.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rors`
--

CREATE TABLE `rors` (
  `ror_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ror` varchar(255) NOT NULL,
  `display_locale` varchar(28) NOT NULL,
  `is_active` smallint(6) NOT NULL DEFAULT '1',
  `search_phrase` mediumtext,
  PRIMARY KEY (`ror_id`),
  UNIQUE KEY `rors_unique` (`ror`),
  KEY `rors_display_locale` (`display_locale`),
  KEY `rors_is_active` (`is_active`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Ror registry dataset cache' AUTO_INCREMENT=117038 ;

--
-- Dumping data for table `rors`
--

INSERT INTO `rors` VALUES
(1, 'https://ror.org/0002pcv65', 'en', 1, 'https://ror.org/0002pcv65 National University of Río Cuarto Universidad Nacional de Río Cuarto'),
(2, 'https://ror.org/0003ewr82', 'no_lang_code', 1, 'https://ror.org/0003ewr82 Bundelkhand University'),
(3, 'https://ror.org/0004gzs06', 'en', 1, 'https://ror.org/0004gzs06 Hokuyukai Neurology Hospital 医療法人北祐会 北祐会神経内科病院'),
(4, 'https://ror.org/0006swh35', 'en', 1, 'https://ror.org/0006swh35 First Affiliated Hospital of Xiamen University 厦门大学附属第一医院'),
(5, 'https://ror.org/000849h34', 'en', 1, 'https://ror.org/000849h34 Liverpool Heart and Chest Hospital'),
(6, 'https://ror.org/0008s4w86', 'en', 1, 'https://ror.org/0008s4w86 Piedmont Atlanta Hospital'),
(7, 'https://ror.org/000917t60', 'en', 1, 'https://ror.org/000917t60 Autonomous University of San Luis Potosí Universidad Autónoma de San Luis Potosí'),
(8, 'https://ror.org/000a2sx58', 'en', 1, 'https://ror.org/000a2sx58 Centre for European Policy Studies'),
(9, 'https://ror.org/000bvba82', 'no_lang_code', 1, 'https://ror.org/000bvba82 Biomarker Technologies (China) 百迈客生物科技'),
(10, 'https://ror.org/000bxzc63', 'en', 1, 'https://ror.org/000bxzc63 Max Planck Institute for Medical Research Max-Planck-Institut für Medizinische Forschung'),
(11, 'https://ror.org/000c39f30', 'en', 1, 'https://ror.org/000c39f30 Al Ain Hospital مستشفى العين'),
(12, 'https://ror.org/000ezn412', 'en', 1, 'https://ror.org/000ezn412 Sawai Man Singh Hospital'),
(13, 'https://ror.org/000f32327', 'en', 1, 'https://ror.org/000f32327 Saint Vincent Hospital'),
(14, 'https://ror.org/000fvwg06', 'en', 1, 'https://ror.org/000fvwg06 Queen Sirikit National Institute of Child Health'),
(15, 'https://ror.org/000jd8a09', 'no_lang_code', 1, 'https://ror.org/000jd8a09 Mafraq Hospital مستشفى المفرق'),
(16, 'https://ror.org/000kb2a90', 'en', 1, 'https://ror.org/000kb2a90 Mymensingh Medical College Hospital ময়মনসিংহ মেডিকেল কলেজ'),
(17, 'https://ror.org/000ke5995', 'en', 1, 'https://ror.org/000ke5995 Western Galilee Hospital'),
(18, 'https://ror.org/000p7hm12', 'en', 1, 'https://ror.org/000p7hm12 National Skin Centre'),
(19, 'https://ror.org/000pfrh90', 'en', 1, 'https://ror.org/000pfrh90 Baptist Hospital of Miami'),
(20, 'https://ror.org/000qzf213', 'en', 1, 'https://ror.org/000qzf213 Korea University of Science and Technology 과학기술연합대학원대학교'),
(21, 'https://ror.org/000rgm762', 'en', 1, 'https://ror.org/000rgm762 VA Connecticut Healthcare System'),
(22, 'https://ror.org/000rs7940', 'fr', 1, 'https://ror.org/000rs7940 Hôpital de la Providence'),
(23, 'https://ror.org/000rxe202', 'no_lang_code', 1, 'https://ror.org/000rxe202 Medical Decision Logic'),
(24, 'https://ror.org/000tm9s39', 'fr', 1, 'https://ror.org/000tm9s39 Centre Hospitalier Saint-Charles'),
(25, 'https://ror.org/000tqtb97', 'no_lang_code', 1, 'https://ror.org/000tqtb97 Rafik Hariri University Hospital مستشفى رفيق الحريري الجامعي‎‎'),
(26, 'https://ror.org/000vg5909', 'en', 1, 'https://ror.org/000vg5909 Health & Medical Publishing Group'),
(27, 'https://ror.org/000vjzq57', 'en', 1, 'https://ror.org/000vjzq57 Memphis VA Medical Center'),
(28, 'https://ror.org/000vvpv33', 'en', 1, 'https://ror.org/000vvpv33 Social Insurance Yokohama Central Hospital 横浜中央病院'),
(29, 'https://ror.org/000w57b95', 'en', 1, 'https://ror.org/000w57b95 Institute of Public Health Instituti i Shëndetit Publik'),
(30, 'https://ror.org/000yct867', 'en', 1, 'https://ror.org/000yct867 Bridgeport Hospital'),
(31, 'https://ror.org/000ywep40', 'en', 1, 'https://ror.org/000ywep40 NHS Tayside'),
(32, 'https://ror.org/000zamq06', 'en', 1, 'https://ror.org/000zamq06 Franklin W. Olin College of Engineering'),
(33, 'https://ror.org/0011azt19', 'en', 1, 'https://ror.org/0011azt19 Saint Agnes Hospital'),
(34, 'https://ror.org/0011qv509', 'en', 1, 'https://ror.org/0011qv509 University of Tennessee Health Science Center'),
(35, 'https://ror.org/0015hpp74', 'en', 1, 'https://ror.org/0015hpp74 Hannah Research Foundation'),
(36, 'https://ror.org/0015hye09', 'no_lang_code', 1, 'https://ror.org/0015hye09 Tokyo Metropolitan Ohtsuka Hospital 東京都立大塚病院'),
(37, 'https://ror.org/0015r4831', 'en', 1, 'https://ror.org/0015r4831 Government Medical College Bhavnagar'),
(38, 'https://ror.org/00184ca40', 'no_lang_code', 1, 'https://ror.org/00184ca40 Ballard Power Systems (Canada)'),
(39, 'https://ror.org/00186jw56', 'en', 1, 'https://ror.org/00186jw56 Northwestern Health Sciences University'),
(40, 'https://ror.org/00186nd07', 'en', 1, 'https://ror.org/00186nd07 Gajara Raja Medical College'),
(41, 'https://ror.org/00190t495', 'en', 1, 'https://ror.org/00190t495 National Center for Complementary and Integrative Health'),
(42, 'https://ror.org/001b4cb05', 'en', 1, 'https://ror.org/001b4cb05 National University of Trujillo Universidad Nacional de Trujillo'),
(43, 'https://ror.org/001be0c19', 'en', 1, 'https://ror.org/001be0c19 Centennial Medical Center'),
(44, 'https://ror.org/001c9fg13', 'ro', 1, 'https://ror.org/001c9fg13 Unitatea Executiva Pentru Finantarea Invatamantului Superior Si A Cercetarii Stiintifice Universitare'),
(45, 'https://ror.org/001c9gn96', 'en', 1, 'https://ror.org/001c9gn96 University of Science and Arts of Oklahoma'),
(46, 'https://ror.org/001g7jx32', 'en', 1, 'https://ror.org/001g7jx32 New Britain General Hospital'),
(47, 'https://ror.org/001hsnn10', 'en', 1, 'https://ror.org/001hsnn10 Medical Technology and Practice Patterns Institute'),
(48, 'https://ror.org/001hv0k59', 'en', 1, 'https://ror.org/001hv0k59 Toyota Technological Institute 豊田工業大学'),
(49, 'https://ror.org/001hz0050', 'en', 1, 'https://ror.org/001hz0050 Capital Regional District'),
(50, 'https://ror.org/001m5qg34', 'en', 1, 'https://ror.org/001m5qg34 Darent Valley Hospital'),
(51, 'https://ror.org/001rzdq81', 'no_lang_code', 1, 'https://ror.org/001rzdq81 State of The Art'),
(52, 'https://ror.org/001v19997', 'tr', 1, 'https://ror.org/001v19997 Eskişehir Osmangazi Üniversitesi Tıp Fakültesi Hastanesi'),
(53, 'https://ror.org/001v2ey71', 'en', 1, 'https://ror.org/001v2ey71 The Fourth People''s Hospital'),
(54, 'https://ror.org/001wpa366', 'fr', 1, 'https://ror.org/001wpa366 HIA du Val-de-Grâce à Paris, Hôpital d''instruction des armées du Val-de-Grâce'),
(55, 'https://ror.org/001x4vz59', 'en', 1, 'https://ror.org/001x4vz59 St Mary''s Hospital'),
(56, 'https://ror.org/001xq1j98', 'en', 1, 'https://ror.org/001xq1j98 Covenant Health'),
(57, 'https://ror.org/001yjqf23', 'en', 1, 'https://ror.org/001yjqf23 Kuang Tien General Hospital 光田綜合醫院'),
(58, 'https://ror.org/001zf8v27', 'en', 1, 'https://ror.org/001zf8v27 Institute for Interdisciplinary Studies of Austrian Universities'),
(59, 'https://ror.org/0020hse07', 'en', 1, 'https://ror.org/0020hse07 Aberdeen Maternity Hospital'),
(60, 'https://ror.org/0020x6414', 'en', 1, 'https://ror.org/0020x6414 Hunter Medical Research Institute'),
(61, 'https://ror.org/0022b3c04', 'en', 1, 'https://ror.org/0022b3c04 Nottingham City Hospital'),
(62, 'https://ror.org/00243c192', 'en', 1, 'https://ror.org/00243c192 Monroe Community Hospital'),
(63, 'https://ror.org/0024aa414', 'en', 1, 'https://ror.org/0024aa414 National Institute of Public Health 国立保健医療科学院'),
(64, 'https://ror.org/0024qhz65', 'en', 1, 'https://ror.org/0024qhz65 Bir Hospital बीर अस्पताल'),
(65, 'https://ror.org/0025e3007', 'no_lang_code', 1, 'https://ror.org/0025e3007 TIBCO Software (United States)'),
(66, 'https://ror.org/0025g8755', 'en', 1, 'https://ror.org/0025g8755 Luigi Sacco Hospital Ospedale Luigi Sacco'),
(67, 'https://ror.org/0026m8b31', 'it', 1, 'https://ror.org/0026m8b31 Ospedale San Paolo'),
(68, 'https://ror.org/00274we69', 'no_lang_code', 1, 'https://ror.org/00274we69 Himchan Hospital 부평 힘찬병원'),
(69, 'https://ror.org/0028g5429', 'en', 1, 'https://ror.org/0028g5429 Community Medical Center'),
(70, 'https://ror.org/0029a9d62', 'en', 1, 'https://ror.org/0029a9d62 California Pacific University'),
(71, 'https://ror.org/0029f7m05', 'en', 1, 'https://ror.org/0029f7m05 Geological Society of America'),
(72, 'https://ror.org/0029n1t76', 'en', 1, 'https://ror.org/0029n1t76 Southern Taiwan University of Science and Technology'),
(73, 'https://ror.org/002bjfj29', 'de', 1, 'https://ror.org/002bjfj29 München Klinik Schwabing'),
(74, 'https://ror.org/002f2sy95', 'en', 1, 'https://ror.org/002f2sy95 Avila University'),
(75, 'https://ror.org/002g9dc27', 'en', 1, 'https://ror.org/002g9dc27 Inoue Hospital 井上病院'),
(76, 'https://ror.org/002gmks55', 'pt', 1, 'https://ror.org/002gmks55 Instituto Superior de Educação e Trabalho'),
(77, 'https://ror.org/002hsbm82', 'en', 1, 'https://ror.org/002hsbm82 Tufts Medical Center'),
(78, 'https://ror.org/002k8gm39', 'en', 1, 'https://ror.org/002k8gm39 Vikram University विक्रम विश्वविद्यालय'),
(79, 'https://ror.org/002ksg449', 'en', 1, 'https://ror.org/002ksg449 Mary Crowley Cancer Research Center'),
(80, 'https://ror.org/002nav185', 'en', 1, 'https://ror.org/002nav185 Seoul Medical Center 서울 의료원'),
(81, 'https://ror.org/002q1t780', 'en', 1, 'https://ror.org/002q1t780 Henrietta Egleston Hospital for Children'),
(82, 'https://ror.org/002rw7y37', 'no_lang_code', 1, 'https://ror.org/002rw7y37 Aoyama Gakuin University 青山学院大学'),
(83, 'https://ror.org/002tz8e96', 'en', 1, 'https://ror.org/002tz8e96 Shaikh Zayed Hospital'),
(84, 'https://ror.org/002x0mf51', 'tr', 1, 'https://ror.org/002x0mf51 Mareşal Çakmak Askeri Hastanesi'),
(85, 'https://ror.org/002yfn631', 'en', 1, 'https://ror.org/002yfn631 Kuakini Medical Center'),
(86, 'https://ror.org/002zf4a56', 'en', 1, 'https://ror.org/002zf4a56 Waikato Hospital'),
(87, 'https://ror.org/002ztb251', 'en', 1, 'https://ror.org/002ztb251 Ganesh Shankar Vidyarthi Memorial Medical College गणेश शंकर विद्यार्थी मेमोरियल मेडिकल कॉलेज'),
(88, 'https://ror.org/0030d2559', 'en', 1, 'https://ror.org/0030d2559 Escola Médico-Cirúrgica de Goa Goa Medical College'),
(89, 'https://ror.org/0031afh91', 'en', 1, 'https://ror.org/0031afh91 Henan Provincial Institute of Occupational Health 职业健康河南省研究所'),
(90, 'https://ror.org/0031nsg68', 'en', 1, 'https://ror.org/0031nsg68 Hankyong National University 한경대학교'),
(91, 'https://ror.org/0032p1p15', 'en', 1, 'https://ror.org/0032p1p15 Chubu National Hospital 中部国立病院'),
(92, 'https://ror.org/00337p258', 'no_lang_code', 1, 'https://ror.org/00337p258 Koshien University 甲子園大学'),
(93, 'https://ror.org/00372qc85', 'en', 1, 'https://ror.org/00372qc85 National Institute of Biomedical Imaging and Bioengineering'),
(94, 'https://ror.org/0037yf233', 'en', 1, 'https://ror.org/0037yf233 Exploratorium'),
(95, 'https://ror.org/0038gz437', 'en', 1, 'https://ror.org/0038gz437 Newman University'),
(96, 'https://ror.org/0038nst28', 'no_lang_code', 1, 'https://ror.org/0038nst28 Kwangju Christian Hospital 광주기독병원'),
(97, 'https://ror.org/003ammk23', 'en', 1, 'https://ror.org/003ammk23 Walsh University'),
(98, 'https://ror.org/003dzgw21', 'fr', 1, 'https://ror.org/003dzgw21 Centre Technique Des Industries De La Fonderie'),
(99, 'https://ror.org/003g7k569', 'no_lang_code', 1, 'https://ror.org/003g7k569 Litron Laboratories (United States)'),
(100, 'https://ror.org/003hhqx84', 'it', 1, 'https://ror.org/003hhqx84 Ospedale Antonio Cardarelli'),
(101, 'https://ror.org/003hjp881', 'pt', 1, 'https://ror.org/003hjp881 Hospital Madre Teresa'),
(102, 'https://ror.org/003j5cv40', 'en', 1, 'https://ror.org/003j5cv40 Haskins Laboratories'),
(103, 'https://ror.org/003k75717', 'en', 1, 'https://ror.org/003k75717 Advocate Health Care'),
(104, 'https://ror.org/003m0tv02', 'en', 1, 'https://ror.org/003m0tv02 Michigan Public Health Institute'),
(105, 'https://ror.org/003mte806', 'pt', 1, 'https://ror.org/003mte806 Instituto Superior de Administração e Línguas'),
(106, 'https://ror.org/003ncyx50', 'no_lang_code', 1, 'https://ror.org/003ncyx50 Lourdes Hospital'),
(107, 'https://ror.org/003nj8h62', 'en', 1, 'https://ror.org/003nj8h62 L-Isptar San Luqa St. Luke''s Hospital'),
(108, 'https://ror.org/003nvpm64', 'en', 1, 'https://ror.org/003nvpm64 Christchurch Hospital'),
(109, 'https://ror.org/003rmx748', 'en', 1, 'https://ror.org/003rmx748 Holy Spirit Northside Private Hospital'),
(110, 'https://ror.org/003sav189', 'de', 1, 'https://ror.org/003sav189 Institute for Information Technology Oldenburger Institut für Informatik'),
(111, 'https://ror.org/003sav965', 'en', 1, 'https://ror.org/003sav965 Tianjin Medical University General Hospital 天津医科大学总医院'),
(112, 'https://ror.org/003sphj24', 'en', 1, 'https://ror.org/003sphj24 Soroka Medical Center'),
(113, 'https://ror.org/003sqpd76', 'en', 1, 'https://ror.org/003sqpd76 Agruicultural Research Institute'),
(114, 'https://ror.org/003sw8164', 'en', 1, 'https://ror.org/003sw8164 Inland Hospital Sykehuset Innlandet'),
(115, 'https://ror.org/003t0xc83', 'en', 1, 'https://ror.org/003t0xc83 Glenbrook Hospital'),
(116, 'https://ror.org/003vfy751', 'fr', 1, 'https://ror.org/003vfy751 University of Burundi Université du Burundi'),
(117, 'https://ror.org/003vkcj31', 'en', 1, 'https://ror.org/003vkcj31 University of Teacher Education Fukuoka 福岡教育大学'),
(118, 'https://ror.org/003x8tf04', 'no_lang_code', 1, 'https://ror.org/003x8tf04 Profilarbed (Luxembourg)'),
(119, 'https://ror.org/003zecf96', 'es', 1, 'https://ror.org/003zecf96 Hospital San Agustin'),
(120, 'https://ror.org/004106086', 'en', 1, 'https://ror.org/004106086 Sendai Red Cross Hospital 仙台赤十字病院'),
(121, 'https://ror.org/00414dg76', 'en', 1, 'https://ror.org/00414dg76 Rady Children''s Hospital-San Diego'),
(122, 'https://ror.org/0041bpv82', 'en', 1, 'https://ror.org/0041bpv82 Hospital Sultanah Aminah Sultanah Aminah Hospital'),
(123, 'https://ror.org/004350h06', 'en', 1, 'https://ror.org/004350h06 Saint Vincent Hospital'),
(124, 'https://ror.org/00458wv14', 'en', 1, 'https://ror.org/00458wv14 Tianjin Beichen Hospital'),
(125, 'https://ror.org/0046mja08', 'en', 1, 'https://ror.org/0046mja08 An-Najah National University جامعة النجاح الوطنية'),
(126, 'https://ror.org/0048myj07', 'it', 1, 'https://ror.org/0048myj07 Ospedale del Ceppo'),
(127, 'https://ror.org/0049erg63', 'en', 1, 'https://ror.org/0049erg63 Kookmin University 국민대학교'),
(128, 'https://ror.org/004a7s815', 'sv', 1, 'https://ror.org/004a7s815 Blekingesjukhuset'),
(129, 'https://ror.org/004cj7n30', 'en', 1, 'https://ror.org/004cj7n30 King''s Cross Hospital'),
(130, 'https://ror.org/004dwfr15', 'en', 1, 'https://ror.org/004dwfr15 Kursk State Medical University Курский государственный медицинский университет'),
(131, 'https://ror.org/004fmj330', 'no_lang_code', 1, 'https://ror.org/004fmj330 Technical Resources International (United States)'),
(132, 'https://ror.org/004gqpt18', 'de', 1, 'https://ror.org/004gqpt18 Landeskrankenhaus Feldkirch'),
(133, 'https://ror.org/004jktf35', 'en', 1, 'https://ror.org/004jktf35 Swedish Medical Center'),
(134, 'https://ror.org/004kyan19', 'en', 1, 'https://ror.org/004kyan19 Maricopa County Community College District'),
(135, 'https://ror.org/004nhy279', 'en', 1, 'https://ror.org/004nhy279 Barnet Hospital'),
(136, 'https://ror.org/004q6ee74', 'no_lang_code', 1, 'https://ror.org/004q6ee74 Technical Research Associates (United States)'),
(137, 'https://ror.org/004qj2391', 'es', 1, 'https://ror.org/004qj2391 Hospital General De Segovia'),
(138, 'https://ror.org/004rs4477', 'en', 1, 'https://ror.org/004rs4477 Masonic Medical Research Laboratory'),
(139, 'https://ror.org/004srrf86', 'en', 1, 'https://ror.org/004srrf86 Abilene Christian University Universidad Cristiana de Abilene'),
(140, 'https://ror.org/004sxt390', 'en', 1, 'https://ror.org/004sxt390 North Park University'),
(141, 'https://ror.org/004t34t94', 'no_lang_code', 1, 'https://ror.org/004t34t94 Tsuchiura Kyodo General Hospital 総合病院 土浦協同病院'),
(142, 'https://ror.org/004we6052', 'en', 1, 'https://ror.org/004we6052 Holy Family Hospital'),
(143, 'https://ror.org/0050r1b65', 'en', 1, 'https://ror.org/0050r1b65 Third Affiliated Hospital of Southern Medical University 南方医科大学第三附属医院'),
(144, 'https://ror.org/0050ra204', 'it', 1, 'https://ror.org/0050ra204 Centro Studi Sui Sistemi Di Trasporto Spa'),
(145, 'https://ror.org/00514rc81', 'en', 1, 'https://ror.org/00514rc81 Royal Hallamshire Hospital'),
(146, 'https://ror.org/00520ze08', 'en', 1, 'https://ror.org/00520ze08 South Carolina State University'),
(147, 'https://ror.org/0055d0g64', 'en', 1, 'https://ror.org/0055d0g64 Academia de la Fuerza Aérea de los Estados Unidos United States Air Force Academy'),
(148, 'https://ror.org/0057da036', 'en', 1, 'https://ror.org/0057da036 Mercy San Juan Medical Center'),
(149, 'https://ror.org/0057s8s52', 'en', 1, 'https://ror.org/0057s8s52 John D. Dingell VA Medical Center'),
(150, 'https://ror.org/00582g326', 'en', 1, 'https://ror.org/00582g326 Indian Institute of Technology Roorkee भारतीय प्रौद्योगिकी संस्थान रुड़की இந்திய தொழில்நுட்பக் கழகம் ரூர்க்கி ఇండియన్ ఇన్స్టిట్యూట్ ఆఫ్ టెక్నాలజీ రూర్కీ ഇന്ത്യൻ ഇൻസ്റ്റിറ്റ്യൂട്ട് ഓഫ് ടെക്നോളജി റൂർക്കി'),
(151, 'https://ror.org/005927371', 'en', 1, 'https://ror.org/005927371 Ching Kuo Institute of Management and Health 經國管理暨健康學院'),
(152, 'https://ror.org/0059h1f24', 'en', 1, 'https://ror.org/0059h1f24 Prefectural University of Hiroshima 県立広島大学'),
(153, 'https://ror.org/0059hys23', 'fr', 1, 'https://ror.org/0059hys23 Hôpital Farhat Hached'),
(154, 'https://ror.org/005b2mc68', 'no_lang_code', 1, 'https://ror.org/005b2mc68 NEC (United Kingdom)'),
(155, 'https://ror.org/005bty106', 'en', 1, 'https://ror.org/005bty106 Eulji University 을지대학교'),
(156, 'https://ror.org/005ezrx44', 'en', 1, 'https://ror.org/005ezrx44 South-West State University Юго-Западный государственный университет'),
(157, 'https://ror.org/005fgpm31', 'en', 1, 'https://ror.org/005fgpm31 Dayanand Medical College & Hospital'),
(158, 'https://ror.org/005gkfa10', 'en', 1, 'https://ror.org/005gkfa10 National Changhua University of Education 國立彰化師範大學'),
(159, 'https://ror.org/005h65c20', 'en', 1, 'https://ror.org/005h65c20 Metropolitan Hospital Center'),
(160, 'https://ror.org/005h6qd35', 'en', 1, 'https://ror.org/005h6qd35 Government Medical College'),
(161, 'https://ror.org/005qv5373', 'en', 1, 'https://ror.org/005qv5373 Wakayama Medical University 和歌山県立医科大学'),
(162, 'https://ror.org/005qzv038', 'en', 1, 'https://ror.org/005qzv038 Munson Medical Center'),
(163, 'https://ror.org/005r9p256', 'en', 1, 'https://ror.org/005r9p256 Royal Derby Hospital'),
(164, 'https://ror.org/005s69p38', 'it', 1, 'https://ror.org/005s69p38 Azienda Ospedaliera Ospedale San Carlo Borromeo'),
(165, 'https://ror.org/005t72d47', 'en', 1, 'https://ror.org/005t72d47 Antrim Area Hospital'),
(166, 'https://ror.org/005tw0h26', 'en', 1, 'https://ror.org/005tw0h26 University Clinical Center of Kosovo'),
(167, 'https://ror.org/005w9jb47', 'en', 1, 'https://ror.org/005w9jb47 Lawrence University Universidad Lawrence'),
(168, 'https://ror.org/005wpyn57', 'en', 1, 'https://ror.org/005wpyn57 Children''s Hospital Mansoura University'),
(169, 'https://ror.org/005yg7304', 'no_lang_code', 1, 'https://ror.org/005yg7304 STAR Analytical Services'),
(170, 'https://ror.org/005ywsr52', 'en', 1, 'https://ror.org/005ywsr52 Friends University'),
(171, 'https://ror.org/005zah758', 'en', 1, 'https://ror.org/005zah758 Southern Nazarene University'),
(172, 'https://ror.org/0060t0j89', 'en', 1, 'https://ror.org/0060t0j89 Biblioteca Nacional de Medicina United States National Library of Medicine'),
(173, 'https://ror.org/0065kgn45', 'en', 1, 'https://ror.org/0065kgn45 Center for Studying Health System Change'),
(174, 'https://ror.org/0065mvt73', 'es', 1, 'https://ror.org/0065mvt73 Hospital Costa del Sol'),
(175, 'https://ror.org/006776986', 'no_lang_code', 1, 'https://ror.org/006776986 Wonkwang University 원광대학교'),
(176, 'https://ror.org/0067dx910', 'en', 1, 'https://ror.org/0067dx910 Missouri Baptist Medical Center'),
(177, 'https://ror.org/00682eh61', 'en', 1, 'https://ror.org/00682eh61 Detroit Receiving Hospital'),
(178, 'https://ror.org/0069p7h69', 'en', 1, 'https://ror.org/0069p7h69 Tokushima Breast Care Clinic とくしまブレストケアクリニック'),
(179, 'https://ror.org/006bvjm48', 'en', 1, 'https://ror.org/006bvjm48 Hengyang Normal University'),
(180, 'https://ror.org/006c1jc70', 'en', 1, 'https://ror.org/006c1jc70 UK Material Technology Research Institute'),
(181, 'https://ror.org/006c6a937', 'no_lang_code', 1, 'https://ror.org/006c6a937 Intelligent Hearing Systems (United States)'),
(182, 'https://ror.org/006cvnv84', 'en', 1, 'https://ror.org/006cvnv84 Social Science Research Council'),
(183, 'https://ror.org/006f92m60', 'en', 1, 'https://ror.org/006f92m60 Duchess of Kent Children''s Hospital 大口環根德公爵夫人兒童醫院'),
(184, 'https://ror.org/006g42111', 'en', 1, 'https://ror.org/006g42111 Birmingham–Southern College'),
(185, 'https://ror.org/006gdh317', 'en', 1, 'https://ror.org/006gdh317 Meijo Hospital 名城病院'),
(186, 'https://ror.org/006gvnw06', 'en', 1, 'https://ror.org/006gvnw06 North Dakota Department of Health'),
(187, 'https://ror.org/006j1e620', 'en', 1, 'https://ror.org/006j1e620 Georgia Department of Human Services'),
(188, 'https://ror.org/006jjmw19', 'en', 1, 'https://ror.org/006jjmw19 Hospital de la Universidad de Colorado University of Colorado Hospital'),
(189, 'https://ror.org/006jxzx88', 'en', 1, 'https://ror.org/006jxzx88 Bond University'),
(190, 'https://ror.org/006k2kk72', 'en', 1, 'https://ror.org/006k2kk72 Düsseldorf University Hospital Universitätsklinikum Düsseldorf'),
(191, 'https://ror.org/006kce638', 'es', 1, 'https://ror.org/006kce638 Instituto Tecnológico del Calzado y Conexas'),
(192, 'https://ror.org/006nc8n95', 'pt', 1, 'https://ror.org/006nc8n95 Mackenzie Presbyterian University Universidade Presbiteriana Mackenzie'),
(193, 'https://ror.org/006pw7k84', 'en', 1, 'https://ror.org/006pw7k84 Ambrose Alli University Yunifásítì Ambrose Alli'),
(194, 'https://ror.org/006qqk144', 'no_lang_code', 1, 'https://ror.org/006qqk144 Fukui Prefectural Hospital 福井県立病院'),
(195, 'https://ror.org/006qssd78', 'pt', 1, 'https://ror.org/006qssd78 Universidade do Sul de Santa Catarina'),
(196, 'https://ror.org/006rhxn50', 'no_lang_code', 1, 'https://ror.org/006rhxn50 FORCE Technology (Denmark)'),
(197, 'https://ror.org/006t60p65', 'en', 1, 'https://ror.org/006t60p65 LeTourneau University'),
(198, 'https://ror.org/006x15235', 'en', 1, 'https://ror.org/006x15235 Instituto Nacional de Engenharia, Tecnologia e Inovação National Institute of Engineering, Technology and Innovation'),
(199, 'https://ror.org/006x9gw30', 'no_lang_code', 1, 'https://ror.org/006x9gw30 Koronis Biomedical Technologies (United States)'),
(200, 'https://ror.org/006xsx833', 'nl', 1, 'https://ror.org/006xsx833 Geneeskundige en Gezondheidsdienst'),
(201, 'https://ror.org/006xyf785', 'en', 1, 'https://ror.org/006xyf785 James A. Haley Veterans'' Hospital'),
(202, 'https://ror.org/006y27614', 'en', 1, 'https://ror.org/006y27614 Keesler Medical Center'),
(203, 'https://ror.org/006yqdy38', 'en', 1, 'https://ror.org/006yqdy38 Min Sheng General Hospital 敏盛綜合醫院'),
(204, 'https://ror.org/0070ga397', 'en', 1, 'https://ror.org/0070ga397 John F. Kennedy Medical Center'),
(205, 'https://ror.org/0071a2k97', 'en', 1, 'https://ror.org/0071a2k97 Queen Elizabeth II Medical Centre'),
(206, 'https://ror.org/00756eb27', 'no_lang_code', 1, 'https://ror.org/00756eb27 Barlow Scientific'),
(207, 'https://ror.org/0077fnc39', 'en', 1, 'https://ror.org/0077fnc39 Greater Baltimore Medical Center'),
(208, 'https://ror.org/0077pzv34', 'en', 1, 'https://ror.org/0077pzv34 Manitoba Health'),
(209, 'https://ror.org/0077tm911', 'en', 1, 'https://ror.org/0077tm911 Iowa Department of Human Services'),
(210, 'https://ror.org/007b9cn27', 'en', 1, 'https://ror.org/007b9cn27 National Polytechnic University of Armenia Հայաստանի ազգային պոլիտեխնիկական համալսարան'),
(211, 'https://ror.org/007dga614', 'en', 1, 'https://ror.org/007dga614 Bloomsburg University'),
(212, 'https://ror.org/007e71662', 'en', 1, 'https://ror.org/007e71662 Miyagi Children''s Hospital 宮城県立こども病院'),
(213, 'https://ror.org/007evha27', 'en', 1, 'https://ror.org/007evha27 Cooper Medical School of Rowan University'),
(214, 'https://ror.org/007f1da21', 'en', 1, 'https://ror.org/007f1da21 University of Baghdad جامعة بغداد'),
(215, 'https://ror.org/007fenw03', 'en', 1, 'https://ror.org/007fenw03 Government Medical College ഗവൺമെന്റ് മെഡിക്കൽ കോളേജ്, തിരുവനന്തപുരം'),
(216, 'https://ror.org/007fyq698', 'en', 1, 'https://ror.org/007fyq698 VA Salt Lake City Healthcare System'),
(217, 'https://ror.org/007h1g065', 'en', 1, 'https://ror.org/007h1g065 Universidad de Tampa University of Tampa'),
(218, 'https://ror.org/007hzv648', 'fr', 1, 'https://ror.org/007hzv648 Hôpital Saint Lazare'),
(219, 'https://ror.org/007jxr441', 'en', 1, 'https://ror.org/007jxr441 Society For Developmental Biology'),
(220, 'https://ror.org/007n03h88', 'en', 1, 'https://ror.org/007n03h88 Purdue Research Foundation'),
(221, 'https://ror.org/007sp7t15', 'en', 1, 'https://ror.org/007sp7t15 INTEGRIS Baptist Medical Center'),
(222, 'https://ror.org/007tn5k56', 'en', 1, 'https://ror.org/007tn5k56 Seton Hall University'),
(223, 'https://ror.org/007vcvm35', 'en', 1, 'https://ror.org/007vcvm35 North Karelia Central Hospital Pohjois-Karjalan Sairaanhoito- Ja Sosiaalipalvelujen Kuntayhtymä'),
(224, 'https://ror.org/007x9se63', 'en', 1, 'https://ror.org/007x9se63 Center for Devices and Radiological Health'),
(225, 'https://ror.org/007xad319', 'en', 1, 'https://ror.org/007xad319 Gezondheidsraad The Health Council of the Netherlands'),
(226, 'https://ror.org/007xcwj53', 'de', 1, 'https://ror.org/007xcwj53 Klinikum Klagenfurt'),
(227, 'https://ror.org/0080acb59', 'en', 1, 'https://ror.org/0080acb59 John Radcliffe Hospital'),
(228, 'https://ror.org/00839we02', 'en', 1, 'https://ror.org/00839we02 Acadia University'),
(229, 'https://ror.org/0084g8g60', 'tr', 1, 'https://ror.org/0084g8g60 Bayındır Hastanesi'),
(230, 'https://ror.org/0084te143', 'fr', 1, 'https://ror.org/0084te143 Centre Hospitalier Universitaire de Besançon'),
(231, 'https://ror.org/0086ms749', 'en', 1, 'https://ror.org/0086ms749 Arnold Palmer Hospital for Children'),
(232, 'https://ror.org/0086rpr26', 'en', 1, 'https://ror.org/0086rpr26 University of Sargodha'),
(233, 'https://ror.org/008a4de11', 'en', 1, 'https://ror.org/008a4de11 Manhattan Eye, Ear and Throat Hospital'),
(234, 'https://ror.org/008c4hs90', 'no_lang_code', 1, 'https://ror.org/008c4hs90 Niigata Prefectural Shibata Hospital 新潟県立新発田病院'),
(235, 'https://ror.org/008dmmd16', 'fr', 1, 'https://ror.org/008dmmd16 Hôpital Ophtalmique Jules-Gonin'),
(236, 'https://ror.org/008encc97', 'en', 1, 'https://ror.org/008encc97 East–West Center'),
(237, 'https://ror.org/008hybe55', 'en', 1, 'https://ror.org/008hybe55 JILA, Joint Institute for Laboratory Astrophysics'),
(238, 'https://ror.org/008j59125', 'en', 1, 'https://ror.org/008j59125 Aintree University Hospital'),
(239, 'https://ror.org/008jvv944', 'fr', 1, 'https://ror.org/008jvv944 Héma-Québec'),
(240, 'https://ror.org/008ms5s18', 'en', 1, 'https://ror.org/008ms5s18 Lamar University'),
(241, 'https://ror.org/008p85724', 'en', 1, 'https://ror.org/008p85724 Guangdong Province Stomatological Hospital 广东省口腔医院'),
(242, 'https://ror.org/008pwh115', 'en', 1, 'https://ror.org/008pwh115 Florida Memorial University'),
(243, 'https://ror.org/008r2d260', 'en', 1, 'https://ror.org/008r2d260 Louisiana State University Hospital'),
(244, 'https://ror.org/008rqvc37', 'en', 1, 'https://ror.org/008rqvc37 Lata Medical Research Foundation'),
(245, 'https://ror.org/008wtrs16', 'pt', 1, 'https://ror.org/008wtrs16 Instituto Superior de Ciências Educativas'),
(246, 'https://ror.org/008x57b05', 'en', 1, 'https://ror.org/008x57b05 Universiteit Antwerpen University of Antwerp Universität Antwerpen Université d''Anvers'),
(247, 'https://ror.org/008x85y42', 'no_lang_code', 1, 'https://ror.org/008x85y42 Hospital Bqyhallh بیمارستان بقیةالله'),
(248, 'https://ror.org/008xr7e22', 'en', 1, 'https://ror.org/008xr7e22 Mercy Health System'),
(249, 'https://ror.org/008zj0x80', 'en', 1, 'https://ror.org/008zj0x80 Hackensack University Medical Center'),
(250, 'https://ror.org/0091mqf26', 'en', 1, 'https://ror.org/0091mqf26 Oita Medical Center 国立病院機構 大分医療センタ'),
(251, 'https://ror.org/0092qhe76', 'no_lang_code', 1, 'https://ror.org/0092qhe76 Sanaria'),
(252, 'https://ror.org/0093xcb35', 'en', 1, 'https://ror.org/0093xcb35 Ashikaga Red Cross Hospital 足利赤十字病院'),
(253, 'https://ror.org/00944ve71', 'en', 1, 'https://ror.org/00944ve71 National Central University'),
(254, 'https://ror.org/00947s692', 'en', 1, 'https://ror.org/00947s692 Kurashiki Central Hospital 倉敷中央病院'),
(255, 'https://ror.org/00952fj37', 'en', 1, 'https://ror.org/00952fj37 Jinnah Postgraduate Medical Center'),
(256, 'https://ror.org/009543z50', 'en', 1, 'https://ror.org/009543z50 Northwestern Memorial Hospital'),
(257, 'https://ror.org/0098kke80', 'no_lang_code', 1, 'https://ror.org/0098kke80 Rakuten (Japan) 楽天株式会社'),
(258, 'https://ror.org/0099kc363', 'en', 1, 'https://ror.org/0099kc363 Sardar Patel Medical College'),
(259, 'https://ror.org/009afvb77', 'en', 1, 'https://ror.org/009afvb77 Provincial Laboratory of Public Health'),
(260, 'https://ror.org/009at8f10', 'fr', 1, 'https://ror.org/009at8f10 Hôpital Laveran'),
(261, 'https://ror.org/009c06z12', 'en', 1, 'https://ror.org/009c06z12 Intermountain Medical Center'),
(262, 'https://ror.org/009djsq06', 'en', 1, 'https://ror.org/009djsq06 King Abdulaziz Medical City مدينة الملك عبد العزيز الطبية للحرس الوطني'),
(263, 'https://ror.org/009e5cd49', 'en', 1, 'https://ror.org/009e5cd49 Sun Moon University 선문대학교'),
(264, 'https://ror.org/009ek3139', 'en', 1, 'https://ror.org/009ek3139 Falun Hospital'),
(265, 'https://ror.org/009erh992', 'en', 1, 'https://ror.org/009erh992 Sharp Rees-Stealy Medical Group'),
(266, 'https://ror.org/009fhc817', 'pl', 1, 'https://ror.org/009fhc817 Szpital im Tadeusza Marciniaka'),
(267, 'https://ror.org/009fnyh39', 'en', 1, 'https://ror.org/009fnyh39 Malabar Institute of Medical Sciences'),
(268, 'https://ror.org/009gqrs30', 'pt', 1, 'https://ror.org/009gqrs30 Hospital Moinhos de Vento'),
(269, 'https://ror.org/009hj8759', 'en', 1, 'https://ror.org/009hj8759 Grady Memorial Hospital'),
(270, 'https://ror.org/009k7c907', 'en', 1, 'https://ror.org/009k7c907 Northern Health'),
(271, 'https://ror.org/009nscf91', 'fr', 1, 'https://ror.org/009nscf91 Centre Hospitalier Universitaire Mohammed VI'),
(272, 'https://ror.org/009p4eg54', 'en', 1, 'https://ror.org/009p4eg54 Tilka Manjhi Bhagalpur University तिलका मांझी भागलपुर विश्वविद्यालय'),
(273, 'https://ror.org/009q6vg88', 'no_lang_code', 1, 'https://ror.org/009q6vg88 Virogenomics BioDevelopment (United States)'),
(274, 'https://ror.org/009qqcw96', 'en', 1, 'https://ror.org/009qqcw96 Lehigh Valley Hospital Muhlenberg'),
(275, 'https://ror.org/009raxq57', 'en', 1, 'https://ror.org/009raxq57 Mercy Medical Center'),
(276, 'https://ror.org/009rt9f88', 'en', 1, 'https://ror.org/009rt9f88 Inova Loudoun Hospital'),
(277, 'https://ror.org/009sa0g06', 'en', 1, 'https://ror.org/009sa0g06 Royal Liverpool and Broadgreen University Hospital NHS Trust'),
(278, 'https://ror.org/009szpe27', 'en', 1, 'https://ror.org/009szpe27 Armed Forces Health Surveillance Center'),
(279, 'https://ror.org/009vheq40', 'en', 1, 'https://ror.org/009vheq40 Churchill Hospital'),
(280, 'https://ror.org/009x1kj44', 'pl', 1, 'https://ror.org/009x1kj44 University Children’s Hospital Uniwersytecki Szpital Dziecięcy'),
(281, 'https://ror.org/009z5t729', 'en', 1, 'https://ror.org/009z5t729 Cook Children''s Medical Center'),
(282, 'https://ror.org/00a0jsq62', 'en', 1, 'https://ror.org/00a0jsq62 London School of Hygiene & Tropical Medicine'),
(283, 'https://ror.org/00a0pt066', 'en', 1, 'https://ror.org/00a0pt066 MultiCare Good Samaritan Hospital'),
(284, 'https://ror.org/00a3dqw47', 'en', 1, 'https://ror.org/00a3dqw47 Eastern State Hospital'),
(285, 'https://ror.org/00a43vs85', 'en', 1, 'https://ror.org/00a43vs85 Ya''an Polytechnic College 雅安职业技术学院'),
(286, 'https://ror.org/00a53nq42', 'en', 1, 'https://ror.org/00a53nq42 Cancer Hospital of Shantou University Medical College 汕头大学医学院附属肿瘤医院'),
(287, 'https://ror.org/00a858n67', 'en', 1, 'https://ror.org/00a858n67 Royal United Hospital'),
(288, 'https://ror.org/00a8tg325', 'en', 1, 'https://ror.org/00a8tg325 Korea Institute of Radiological and Medical Sciences 한국 방사선 과학 연구소'),
(289, 'https://ror.org/00a98yf63', 'en', 1, 'https://ror.org/00a98yf63 Second Affiliated Hospital of Guangzhou Medical University 广州医科大学附属第二医院'),
(290, 'https://ror.org/00a99v816', 'no_lang_code', 1, 'https://ror.org/00a99v816'),
(291, 'https://ror.org/00ac5y077', 'pt', 1, 'https://ror.org/00ac5y077 Instituto Superior Autónomo de Estudos Politécnicos'),
(292, 'https://ror.org/00adjy062', 'no_lang_code', 1, 'https://ror.org/00adjy062 Performance Plants (Canada)'),
(293, 'https://ror.org/00ae33288', 'en', 1, 'https://ror.org/00ae33288 London Metropolitan University'),
(294, 'https://ror.org/00af3sa43', 'en', 1, 'https://ror.org/00af3sa43 Isfahan University of Technology دانشگاه صنعتی اصفهان'),
(295, 'https://ror.org/00aff0y51', 'tr', 1, 'https://ror.org/00aff0y51 Dr. Behçet Uz Çocuk Hastalıkları Hastanesi'),
(296, 'https://ror.org/00afgv297', 'es', 1, 'https://ror.org/00afgv297 Hospital General San Juan de Dios'),
(297, 'https://ror.org/00aft1q37', 'en', 1, 'https://ror.org/00aft1q37 Sejong University 세종대학교'),
(298, 'https://ror.org/00agkba13', 'en', 1, 'https://ror.org/00agkba13 Martha Jefferson Hospital'),
(299, 'https://ror.org/00agrkd75', 'en', 1, 'https://ror.org/00agrkd75 Computing Research Association'),
(300, 'https://ror.org/00ajg8537', 'tr', 1, 'https://ror.org/00ajg8537 Gaziantep Onkoloji Hastanesi'),
(301, 'https://ror.org/00ajykz30', 'en', 1, 'https://ror.org/00ajykz30 UK Water Industry Research'),
(302, 'https://ror.org/00akdyv48', 'en', 1, 'https://ror.org/00akdyv48 Centre médical de kettering Kettering Medical Center'),
(303, 'https://ror.org/00apdsa62', 'en', 1, 'https://ror.org/00apdsa62 Privolzhsky Research Medical University Приволжский исследовательский медицинский университет'),
(304, 'https://ror.org/00aqz1698', 'en', 1, 'https://ror.org/00aqz1698 Milwaukee Public Museum'),
(305, 'https://ror.org/00aqz8k66', 'en', 1, 'https://ror.org/00aqz8k66 Florida Hospital Cancer Institute'),
(306, 'https://ror.org/00asaax56', 'en', 1, 'https://ror.org/00asaax56 Accreditation Council for Graduate Medical Education'),
(307, 'https://ror.org/00av3hs56', 'en', 1, 'https://ror.org/00av3hs56 Chubu Rosai Hospital 中部ろうさい病院'),
(308, 'https://ror.org/00av5yz18', 'en', 1, 'https://ror.org/00av5yz18 Health and Safety Executive'),
(309, 'https://ror.org/00awd9g61', 'en', 1, 'https://ror.org/00awd9g61 The Graduate Center, CUNY'),
(310, 'https://ror.org/00azwtc53', 'no_lang_code', 1, 'https://ror.org/00azwtc53 Swedish Nuclear Fuel and Waste Management (Sweden)'),
(311, 'https://ror.org/00b0m1444', 'en', 1, 'https://ror.org/00b0m1444 Loewenstein Hospital Rehabilitation Center'),
(312, 'https://ror.org/00b4emx12', 'en', 1, 'https://ror.org/00b4emx12 North Shore Medical Center'),
(313, 'https://ror.org/00b4wat71', 'en', 1, 'https://ror.org/00b4wat71 Shadyside Hospital'),
(314, 'https://ror.org/00b7yvh50', 'en', 1, 'https://ror.org/00b7yvh50 Prefectural University of Kumamoto 熊本県立大学'),
(315, 'https://ror.org/00b7zsw47', 'de', 1, 'https://ror.org/00b7zsw47 Klinik Schillerhöhe'),
(316, 'https://ror.org/00baajx12', 'en', 1, 'https://ror.org/00baajx12 Rood and Riddle Equine Hospital'),
(317, 'https://ror.org/00baak391', 'en', 1, 'https://ror.org/00baak391 National Human Genome Research Institute'),
(318, 'https://ror.org/00bb01z14', 'en', 1, 'https://ror.org/00bb01z14 Vladivostok State Medical University Тихоокеанский государственный медицинский университет'),
(319, 'https://ror.org/00bbeqy02', 'en', 1, 'https://ror.org/00bbeqy02 Guru Angad Dev Veterinary and Animal Sciences University ਗੁਰੂ ਅੰਗਦ ਦੇਵ ਵੈਟਨਰੀ ਅਤੇ ਐਨੀਮਲ ਸਾਇੰਸਜ਼ ਯੂਨੀਵਰਸਿਟੀ'),
(320, 'https://ror.org/00bjck208', 'en', 1, 'https://ror.org/00bjck208 Glasgow Royal Infirmary'),
(321, 'https://ror.org/00bkxry42', 'en', 1, 'https://ror.org/00bkxry42 Fraunhofer Institut für Mikrotechnik und Mikrosysteme Fraunhofer Institute for Microengineering and Microsystems'),
(322, 'https://ror.org/00bmv4102', 'nl', 1, 'https://ror.org/00bmv4102 Emma Children’s Hospital Emma Kinderziekenhuis'),
(323, 'https://ror.org/00bmzhb16', 'en', 1, 'https://ror.org/00bmzhb16 Gembloux Agro-Bio Tech'),
(324, 'https://ror.org/00bpn0984', 'it', 1, 'https://ror.org/00bpn0984 Ospedale San Paolo'),
(325, 'https://ror.org/00bq4rw46', 'es', 1, 'https://ror.org/00bq4rw46 Hospital Italiano de Buenos Aires'),
(326, 'https://ror.org/00bq8v746', 'no_lang_code', 1, 'https://ror.org/00bq8v746 Aomori Prefectural Central Hospital 青森県立中央病院'),
(327, 'https://ror.org/00bs3zm56', 'no_lang_code', 1, 'https://ror.org/00bs3zm56 Nagasaki Municipal Hospital 長崎みなとメディカルセンター市民病院'),
(328, 'https://ror.org/00bsyjc58', 'en', 1, 'https://ror.org/00bsyjc58 Kanchi Mamunivar Centre for Post Graduate Studies'),
(329, 'https://ror.org/00btty905', 'en', 1, 'https://ror.org/00btty905 Ireland Army Community Hospital'),
(330, 'https://ror.org/00bwhj131', 'en', 1, 'https://ror.org/00bwhj131 Newark Beth Israel Medical Center'),
(331, 'https://ror.org/00bx6dj65', 'en', 1, 'https://ror.org/00bx6dj65 Hosei University 法政大学'),
(332, 'https://ror.org/00bx71042', 'en', 1, 'https://ror.org/00bx71042 Coombe Women & Infants University Hospital Ospidéal Ollscoile Ban agus Naíonán an Chúim'),
(333, 'https://ror.org/00bxj7497', 'en', 1, 'https://ror.org/00bxj7497 Vidant Medical Center'),
(334, 'https://ror.org/00bxsm637', 'no_lang_code', 1, 'https://ror.org/00bxsm637 MTU Aero Engines (Germany)'),
(335, 'https://ror.org/00byr8j11', 'en', 1, 'https://ror.org/00byr8j11 National Science Teachers Association'),
(336, 'https://ror.org/00bz3ax41', 'en', 1, 'https://ror.org/00bz3ax41 University of Dubuque Université de dubuque'),
(337, 'https://ror.org/00bz6qm80', 'en', 1, 'https://ror.org/00bz6qm80 Dillard University'),
(338, 'https://ror.org/00c01js51', 'en', 1, 'https://ror.org/00c01js51 The Ohio State University Wexner Medical Center'),
(339, 'https://ror.org/00c051916', 'fr', 1, 'https://ror.org/00c051916 Centre Technique des Industries Mécaniques Technical Centre for Mechanical Industry'),
(340, 'https://ror.org/00c099g34', 'en', 1, 'https://ror.org/00c099g34 First People''s Hospital of Yunnan Province 云南省第一人民医院'),
(341, 'https://ror.org/00c879s84', 'en', 1, 'https://ror.org/00c879s84 Groote Schuur Hospital'),
(342, 'https://ror.org/00c8t7d47', 'tr', 1, 'https://ror.org/00c8t7d47 Gülhane Askerî Tıp Akademisi'),
(343, 'https://ror.org/00c8v4891', 'en', 1, 'https://ror.org/00c8v4891 Long Island Jewish Medical Center'),
(344, 'https://ror.org/00c9syb98', 'en', 1, 'https://ror.org/00c9syb98 Merlin Park University Hospital'),
(345, 'https://ror.org/00cb9nn43', 'en', 1, 'https://ror.org/00cb9nn43 American Dental Association'),
(346, 'https://ror.org/00cb9w016', 'en', 1, 'https://ror.org/00cb9w016 Ain Shams University جامعة عين شمس'),
(347, 'https://ror.org/00ccec020', 'pt', 1, 'https://ror.org/00ccec020 Universidade do Oeste Paulista University of Western São Paulo'),
(348, 'https://ror.org/00cckeg37', 'en', 1, 'https://ror.org/00cckeg37 Southern Polytechnic State University'),
(349, 'https://ror.org/00cd86r95', 'en', 1, 'https://ror.org/00cd86r95 Frontier Medical College فرنٹیئر میڈیکل کالج'),
(350, 'https://ror.org/00cd9s024', 'en', 1, 'https://ror.org/00cd9s024 Shanghai Children''s Medical Center 上海儿童医学中心'),
(351, 'https://ror.org/00cdwy346', 'en', 1, 'https://ror.org/00cdwy346 Freeman Hospital'),
(352, 'https://ror.org/00cdz3124', 'es', 1, 'https://ror.org/00cdz3124 Hospital General Universitario Santa María del Rosell'),
(353, 'https://ror.org/00ceh2v36', 'en', 1, 'https://ror.org/00ceh2v36 Hiratsuka City Hospital 平塚市民病院'),
(354, 'https://ror.org/00cfdk448', 'en', 1, 'https://ror.org/00cfdk448 Royal Cornwall Hospital'),
(355, 'https://ror.org/00cfm3y81', 'es', 1, 'https://ror.org/00cfm3y81 Hospital General Universitario Morales Meseguer'),
(356, 'https://ror.org/00cgjx575', 'en', 1, 'https://ror.org/00cgjx575 TRTech'),
(357, 'https://ror.org/00chbca67', 'en', 1, 'https://ror.org/00chbca67 Bhabha Atomic Research Center Hospital'),
(358, 'https://ror.org/00chfja07', 'en', 1, 'https://ror.org/00chfja07 Seoul National University of Science and Technology 서울과학기술대학교'),
(359, 'https://ror.org/00chxjy07', 'en', 1, 'https://ror.org/00chxjy07 Fundação Conservatório Regional de Gaia Gaia Regional Conservatory Foundation'),
(360, 'https://ror.org/00cmfmh53', 'it', 1, 'https://ror.org/00cmfmh53 Azienda Ospedaliera G.Rummo'),
(361, 'https://ror.org/00cmk4n56', 'it', 1, 'https://ror.org/00cmk4n56 Krankenhaus Bozen Ospedale di Bolzano'),
(362, 'https://ror.org/00cr15z55', 'en', 1, 'https://ror.org/00cr15z55 St. Elizabeth''s Medical Center'),
(363, 'https://ror.org/00cr96696', 'en', 1, 'https://ror.org/00cr96696 Center for Clinical Research and Prevention Center for Klinisk Forskning og Forebyggelse'),
(364, 'https://ror.org/00ctk8b26', 'en', 1, 'https://ror.org/00ctk8b26 Bristol City Council'),
(365, 'https://ror.org/00cwrhn79', 'en', 1, 'https://ror.org/00cwrhn79 Saint Vincent''s Catholic Medical Center'),
(366, 'https://ror.org/00d0r9b26', 'hu', 1, 'https://ror.org/00d0r9b26 Heim Pál Gyermekkórház Pál Heim Children''s Hospital'),
(367, 'https://ror.org/00d0zag42', 'no_lang_code', 1, 'https://ror.org/00d0zag42 Wooridul Hospital 우리들 병원'),
(368, 'https://ror.org/00d264c35', 'en', 1, 'https://ror.org/00d264c35 Frederiksberg Hospital'),
(369, 'https://ror.org/00d80zx46', 'en', 1, 'https://ror.org/00d80zx46 Chang Gung University'),
(370, 'https://ror.org/00d973h41', 'en', 1, 'https://ror.org/00d973h41 Södertörn University Södertörns högskola'),
(371, 'https://ror.org/00d9qf519', 'en', 1, 'https://ror.org/00d9qf519 Topiwala National Medical College & BYL Nair Charitable Hospital'),
(372, 'https://ror.org/00dc7s858', 'en', 1, 'https://ror.org/00dc7s858 Jiangxi Agricultural University 江西农业大学'),
(373, 'https://ror.org/00ded8656', 'en', 1, 'https://ror.org/00ded8656 Pine Rest Christian Mental Health Services'),
(374, 'https://ror.org/00dfape04', 'en', 1, 'https://ror.org/00dfape04 Good Moonhwa Hospital 좋은문화병원'),
(375, 'https://ror.org/00dpx3e98', 'en', 1, 'https://ror.org/00dpx3e98 American Meteorological Society'),
(376, 'https://ror.org/00dr1cn74', 'en', 1, 'https://ror.org/00dr1cn74 Hangzhou Center for Disease Control and Prevention 杭州市疾病预防控制中心'),
(377, 'https://ror.org/00dr54257', 'en', 1, 'https://ror.org/00dr54257 Alcorn State University'),
(378, 'https://ror.org/00drynx17', 'en', 1, 'https://ror.org/00drynx17 Fukuoka Institute of Health and Environmental Sciences 福岡県保健環境研究所'),
(379, 'https://ror.org/00dt08z19', 'en', 1, 'https://ror.org/00dt08z19 Argyll and Bute Hospital'),
(380, 'https://ror.org/00dv9aw81', 'no_lang_code', 1, 'https://ror.org/00dv9aw81 Experimental Pathology Laboratories'),
(381, 'https://ror.org/00dwz8y55', 'en', 1, 'https://ror.org/00dwz8y55 Sheppard Pratt Health System'),
(382, 'https://ror.org/00e16h982', 'en', 1, 'https://ror.org/00e16h982 Osun State University'),
(383, 'https://ror.org/00e49gy82', 'en', 1, 'https://ror.org/00e49gy82 China University of Political Science and Law 中国政法大学'),
(384, 'https://ror.org/00e4zxr41', 'en', 1, 'https://ror.org/00e4zxr41 Ross University School of Veterinary Medicine'),
(385, 'https://ror.org/00e7ez509', 'no_lang_code', 1, 'https://ror.org/00e7ez509 Daegu Fatima Hospital 대구파티마병원'),
(386, 'https://ror.org/00e7taa66', 'en', 1, 'https://ror.org/00e7taa66 Ingalls Memorial Hospital'),
(387, 'https://ror.org/00e7vmq69', 'en', 1, 'https://ror.org/00e7vmq69 Polytechnic University of the Philippines'),
(388, 'https://ror.org/00e9xa106', 'en', 1, 'https://ror.org/00e9xa106 University of Maine at Machias'),
(389, 'https://ror.org/00eekd641', 'en', 1, 'https://ror.org/00eekd641 Robert Wood Johnson University Hospital'),
(390, 'https://ror.org/00eg8ch54', 'en', 1, 'https://ror.org/00eg8ch54 Hebrew Hospital'),
(391, 'https://ror.org/00egdv862', 'no_lang_code', 1, 'https://ror.org/00egdv862 Hongik University 홍익대학교'),
(392, 'https://ror.org/00eh7f421', 'no_lang_code', 1, 'https://ror.org/00eh7f421 E-Da Hospital'),
(393, 'https://ror.org/00ek9j693', 'en', 1, 'https://ror.org/00ek9j693 Bloodworks Northwest'),
(394, 'https://ror.org/00em04n91', 'en', 1, 'https://ror.org/00em04n91 Moscow State University of Civil Engineering Московский Государственный Строительный Университет'),
(395, 'https://ror.org/00emz0366', 'no_lang_code', 1, 'https://ror.org/00emz0366 Woosuk University 우석대학교'),
(396, 'https://ror.org/00en92979', 'en', 1, 'https://ror.org/00en92979 Kaohsiung Municipal Kai-Syuan Psychiatric Hospital'),
(397, 'https://ror.org/00enq8e33', 'en', 1, 'https://ror.org/00enq8e33 Aurelia Hospital'),
(398, 'https://ror.org/00envkz24', 'en', 1, 'https://ror.org/00envkz24 Greenlane Clinical Centre'),
(399, 'https://ror.org/00ep78v21', 'en', 1, 'https://ror.org/00ep78v21 Advocate Good Samaritan Hospital'),
(400, 'https://ror.org/00ey54k21', 'pt', 1, 'https://ror.org/00ey54k21 Universidade de Ribeirão Preto University of Ribeirão Preto'),
(401, 'https://ror.org/00eyk9919', 'en', 1, 'https://ror.org/00eyk9919 Holy Family Hospital ہولی فیملی ہسپتال'),
(402, 'https://ror.org/00eysw063', 'en', 1, 'https://ror.org/00eysw063 Liverpool Women''s Hospital'),
(403, 'https://ror.org/00f1xkb20', 'no_lang_code', 1, 'https://ror.org/00f1xkb20 Robosoft (France)'),
(404, 'https://ror.org/00f200z37', 'en', 1, 'https://ror.org/00f200z37 Chonnam National University Hospital'),
(405, 'https://ror.org/00f2gwr16', 'en', 1, 'https://ror.org/00f2gwr16 Lankenau Medical Center'),
(406, 'https://ror.org/00f2txz25', 'no_lang_code', 1, 'https://ror.org/00f2txz25 Kitasato University 北里大学'),
(407, 'https://ror.org/00f2ymb10', 'en', 1, 'https://ror.org/00f2ymb10 Chesapeake Research Consortium'),
(408, 'https://ror.org/00f2z7n96', 'en', 1, 'https://ror.org/00f2z7n96 RAND Corporation'),
(409, 'https://ror.org/00f4kgf41', 'en', 1, 'https://ror.org/00f4kgf41 Gaziantep Children''s Hospital Gaziantep Çocuk Hastanesi'),
(410, 'https://ror.org/00f93yb19', 'en', 1, 'https://ror.org/00f93yb19 McKay Dee Hospital'),
(411, 'https://ror.org/00f9c2f73', 'en', 1, 'https://ror.org/00f9c2f73 GF Jooste Hospital'),
(412, 'https://ror.org/00fb7mg36', 'no_lang_code', 1, 'https://ror.org/00fb7mg36 San-ikukai Hospital 賛育会病院'),
(413, 'https://ror.org/00fbafs03', 'no_lang_code', 1, 'https://ror.org/00fbafs03 MBN Nanomaterialia (Italy)'),
(414, 'https://ror.org/00fc19b96', 'en', 1, 'https://ror.org/00fc19b96 Aomori Rosai Hospital 青森労災病院'),
(415, 'https://ror.org/00fd4q681', 'en', 1, 'https://ror.org/00fd4q681 Krishna Institute of Medical Sciences'),
(416, 'https://ror.org/00fd9sj13', 'en', 1, 'https://ror.org/00fd9sj13 Daegu Catholic University Medical Center 대구가톨릭대학교병원 모바일'),
(417, 'https://ror.org/00ff4bt20', 'en', 1, 'https://ror.org/00ff4bt20 Arcadia University'),
(418, 'https://ror.org/00fg98b82', 'en', 1, 'https://ror.org/00fg98b82 Kaiser Permanente San Diego Medical Center'),
(419, 'https://ror.org/00fgdyv87', 'no_lang_code', 1, 'https://ror.org/00fgdyv87 Hindu Rao Hospital'),
(420, 'https://ror.org/00fh72m39', 'en', 1, 'https://ror.org/00fh72m39 Vladimir State University for the Humanities Владимирский государственный гуманитарный университет'),
(421, 'https://ror.org/00fj3a809', 'en', 1, 'https://ror.org/00fj3a809 Good Samaritan Regional Medical Center'),
(422, 'https://ror.org/00fjv1g65', 'en', 1, 'https://ror.org/00fjv1g65 Kunming Children''s Hospital 昆明市儿童医院'),
(423, 'https://ror.org/00fk0yb75', 'en', 1, 'https://ror.org/00fk0yb75 Plastic Surgery Hospital'),
(424, 'https://ror.org/00fpw9a48', 'no_lang_code', 1, 'https://ror.org/00fpw9a48 Hamburg Ship Model Basin Hamburgische Schiffbau-Versuchsanstalt (Germany)'),
(425, 'https://ror.org/00fq5ev96', 'en', 1, 'https://ror.org/00fq5ev96 John B. Pierce Laboratory'),
(426, 'https://ror.org/00fqdfs68', 'en', 1, 'https://ror.org/00fqdfs68 Kuopio University Hospital'),
(427, 'https://ror.org/00fqdgv63', 'en', 1, 'https://ror.org/00fqdgv63 Lankenau Heart Institute'),
(428, 'https://ror.org/00fqtfz78', 'en', 1, 'https://ror.org/00fqtfz78 Beebe Healthcare'),
(429, 'https://ror.org/00ft41876', 'en', 1, 'https://ror.org/00ft41876 Marion duPont Scott Equine Medical Center'),
(430, 'https://ror.org/00ftebr67', 'en', 1, 'https://ror.org/00ftebr67 Wesley Medical Center');
INSERT INTO `rors` VALUES
(431, 'https://ror.org/00fthae95', 'en', 1, 'https://ror.org/00fthae95 Daping Hospital 第三军医大学大坪医院'),
(432, 'https://ror.org/00ftwze80', 'en', 1, 'https://ror.org/00ftwze80 University Dental Hospital on Cardiff University'),
(433, 'https://ror.org/00fv61j67', 'en', 1, 'https://ror.org/00fv61j67 MRC Laboratory for Molecular Cell Biology'),
(434, 'https://ror.org/00fvyjk73', 'en', 1, 'https://ror.org/00fvyjk73 Colby College'),
(435, 'https://ror.org/00fwdyt59', 'en', 1, 'https://ror.org/00fwdyt59 George Washington University Hospital'),
(436, 'https://ror.org/00fwhaq79', 'en', 1, 'https://ror.org/00fwhaq79 Lee University'),
(437, 'https://ror.org/00fxgea47', 'no_lang_code', 1, 'https://ror.org/00fxgea47 Novartis (China) 北京诺华制药有限公司'),
(438, 'https://ror.org/00fz8k419', 'de', 1, 'https://ror.org/00fz8k419 HFR Freiburg Kantonsspital'),
(439, 'https://ror.org/00g1rc256', 'en', 1, 'https://ror.org/00g1rc256 Central DuPage Hospital'),
(440, 'https://ror.org/00g3pqv36', 'en', 1, 'https://ror.org/00g3pqv36 First Affiliated Hospital of Jiangxi Medical College'),
(441, 'https://ror.org/00g578s43', 'no_lang_code', 1, 'https://ror.org/00g578s43 Oregon Center For Applied Science (United States)'),
(442, 'https://ror.org/00g58cv73', 'en', 1, 'https://ror.org/00g58cv73 Chowan University'),
(443, 'https://ror.org/00g651r29', 'en', 1, 'https://ror.org/00g651r29 Maimonides Medical Center'),
(444, 'https://ror.org/00g6ka752', 'en', 1, 'https://ror.org/00g6ka752 Ferdowsi University of Mashhad دانشگاه فردوسی مشهد'),
(445, 'https://ror.org/00g972x47', 'en', 1, 'https://ror.org/00g972x47 Usmanu Danfodiyo University Teaching Hospital, Sokoto'),
(446, 'https://ror.org/00g9xaj16', 'en', 1, 'https://ror.org/00g9xaj16 Saint Agnes Medical Center'),
(447, 'https://ror.org/00gahk913', 'en', 1, 'https://ror.org/00gahk913 Sendai Nishitaga National Hospital 国立病院機構仙台西多賀病院'),
(448, 'https://ror.org/00gbcc509', 'en', 1, 'https://ror.org/00gbcc509 Gyeongsang National University Hospital'),
(449, 'https://ror.org/00gdcs242', 'en', 1, 'https://ror.org/00gdcs242 MESA Hospital Mesa Hastanesi'),
(450, 'https://ror.org/00gdxq105', 'en', 1, 'https://ror.org/00gdxq105 Vermont Department of Mental Health'),
(451, 'https://ror.org/00gffbx54', 'fr', 1, 'https://ror.org/00gffbx54 Hôpital La Rabta المستشفى الجامعي الرابطة'),
(452, 'https://ror.org/00ghjek97', 'en', 1, 'https://ror.org/00ghjek97 Orel State University named after I.S. Turgenev Орловский государственный университет имени И. С. Тургенева'),
(453, 'https://ror.org/00gjahp83', 'en', 1, 'https://ror.org/00gjahp83 Midwestern Regional Medical Center'),
(454, 'https://ror.org/00gkd5869', 'en', 1, 'https://ror.org/00gkd5869 Lagos University Teaching Hospital'),
(455, 'https://ror.org/00gr1q288', 'en', 1, 'https://ror.org/00gr1q288 Tokai University Hachioji Hospital 東海大学医学部付属八王子病院'),
(456, 'https://ror.org/00gs85y70', 'en', 1, 'https://ror.org/00gs85y70 Bellin Memorial Hospital'),
(457, 'https://ror.org/00gtcbp88', 'pt', 1, 'https://ror.org/00gtcbp88 Universidade de Pernambuco University of Pernambuco'),
(458, 'https://ror.org/00gv7aj90', 'es', 1, 'https://ror.org/00gv7aj90 Hospital Barros Luco-Trudeau'),
(459, 'https://ror.org/00gvw6327', 'en', 1, 'https://ror.org/00gvw6327 King George''s Medical University छत्रपति शाहूजी महाराज आयुर्विज्ञान विश्वविद्यालय'),
(460, 'https://ror.org/00gw6hy83', 'en', 1, 'https://ror.org/00gw6hy83 Rotherham General Hospital'),
(461, 'https://ror.org/00h04da97', 'en', 1, 'https://ror.org/00h04da97 McNeese State University'),
(462, 'https://ror.org/00h1apf46', 'fr', 1, 'https://ror.org/00h1apf46 Centre Hospitalier Universitaire de Yopougon'),
(463, 'https://ror.org/00h2bj464', 'en', 1, 'https://ror.org/00h2bj464 Deaconess Hospital'),
(464, 'https://ror.org/00h55v928', 'en', 1, 'https://ror.org/00h55v928 Helwan University جامعة حلوان'),
(465, 'https://ror.org/00h7y2d26', 'no_lang_code', 1, 'https://ror.org/00h7y2d26 Sensimetrics Corporation'),
(466, 'https://ror.org/00h85x510', 'no_lang_code', 1, 'https://ror.org/00h85x510 Tembec'),
(467, 'https://ror.org/00h974d79', 'pt', 1, 'https://ror.org/00h974d79 Instituto de Estudos Superiores Financeiros e Fiscais'),
(468, 'https://ror.org/00hb4yd20', 'en', 1, 'https://ror.org/00hb4yd20 MGMA Health Care Consulting Group'),
(469, 'https://ror.org/00hbq5j06', 'no_lang_code', 1, 'https://ror.org/00hbq5j06 Ecogenomics (Japan)'),
(470, 'https://ror.org/00hby5j36', 'pt', 1, 'https://ror.org/00hby5j36 Hospital Felício Rocho'),
(471, 'https://ror.org/00hdf8e67', 'en', 1, 'https://ror.org/00hdf8e67 Jawaharlal Nehru Medical College'),
(472, 'https://ror.org/00hfbva78', 'en', 1, 'https://ror.org/00hfbva78 General Hospital of Guangzhou Military Command 广州军区广州总医院'),
(473, 'https://ror.org/00hhkn466', 'en', 1, 'https://ror.org/00hhkn466 Japan Society for the Promotion of Science 日本学術振興会'),
(474, 'https://ror.org/00hhwej14', 'en', 1, 'https://ror.org/00hhwej14 Royal Hampshire County Hospital'),
(475, 'https://ror.org/00hm23551', 'no_lang_code', 1, 'https://ror.org/00hm23551 Nishinomiya Municipal Central Hospital 西宮市立中央病院'),
(476, 'https://ror.org/00hm9kt34', 'sv', 1, 'https://ror.org/00hm9kt34 Danderyds sjukhus'),
(477, 'https://ror.org/00hmeez77', 'en', 1, 'https://ror.org/00hmeez77 Barzilai Medical Center'),
(478, 'https://ror.org/00hn92440', 'en', 1, 'https://ror.org/00hn92440 Broomfield Hospital'),
(479, 'https://ror.org/00hnyb151', 'no_lang_code', 1, 'https://ror.org/00hnyb151 Luna Innovations (United States)'),
(480, 'https://ror.org/00hp6as40', 'en', 1, 'https://ror.org/00hp6as40 Mammoth Hospital'),
(481, 'https://ror.org/00hpnj894', 'es', 1, 'https://ror.org/00hpnj894 Hospital Clínico Universitario de Valencia'),
(482, 'https://ror.org/00hpqmv06', 'en', 1, 'https://ror.org/00hpqmv06 Ministry of Health'),
(483, 'https://ror.org/00hqkan37', 'en', 1, 'https://ror.org/00hqkan37 Lebanese American University الجامعة اللبنانية الأمريكية'),
(484, 'https://ror.org/00hswnf74', 'no_lang_code', 1, 'https://ror.org/00hswnf74 Shizuoka City Shimizu Hospital 静岡市立清水病院'),
(485, 'https://ror.org/00htwgm11', 'en', 1, 'https://ror.org/00htwgm11 National University of Salta Universidad Nacional de Salta'),
(486, 'https://ror.org/00hw84d70', 'en', 1, 'https://ror.org/00hw84d70 Baba Memorial Hospital 社会医療法人ペガサス 馬場記念病院'),
(487, 'https://ror.org/00hwsxp30', 'tr', 1, 'https://ror.org/00hwsxp30 Ankara Fizik Tedavi ve Rehabilitasyon Eğitim ve Araştırma Hastanesi'),
(488, 'https://ror.org/00hx9k210', 'en', 1, 'https://ror.org/00hx9k210 Sasebo City General Hospital 佐世保市総合医療センター'),
(489, 'https://ror.org/00hysg385', 'en', 1, 'https://ror.org/00hysg385 Sinai Grace Hospital'),
(490, 'https://ror.org/00j0b8v53', 'en', 1, 'https://ror.org/00j0b8v53 Regional Medical Research Center क्षेत्रीय आयुर्विगिनं अनुसंधान केंद्र'),
(491, 'https://ror.org/00j0z5m32', 'en', 1, 'https://ror.org/00j0z5m32 Alabama Department of Public Health'),
(492, 'https://ror.org/00j2n4x83', 'en', 1, 'https://ror.org/00j2n4x83 Narayana Dental College and Hospital'),
(493, 'https://ror.org/00j2wht38', 'en', 1, 'https://ror.org/00j2wht38 Virginia Department of Health'),
(494, 'https://ror.org/00j4k1h63', 'en', 1, 'https://ror.org/00j4k1h63 National Institute of Environmental Health Sciences'),
(495, 'https://ror.org/00j4pe902', 'en', 1, 'https://ror.org/00j4pe902 Maharaja Krishna Chandra Gajapati Medical College and Hospital'),
(496, 'https://ror.org/00j4pze04', 'es', 1, 'https://ror.org/00j4pze04 Hospital de Basurto'),
(497, 'https://ror.org/00j6r8583', 'en', 1, 'https://ror.org/00j6r8583 Swami Keshwanand Rajasthan Agricultural University'),
(498, 'https://ror.org/00j899309', 'no_lang_code', 1, 'https://ror.org/00j899309 Inflexxion (United States)'),
(499, 'https://ror.org/00j8ram51', 'en', 1, 'https://ror.org/00j8ram51 Cambridge Military Hospital'),
(500, 'https://ror.org/00j8xcs04', 'en', 1, 'https://ror.org/00j8xcs04 Sir Sayajirao General Hospital Medical College'),
(501, 'https://ror.org/00j9c2840', 'en', 1, 'https://ror.org/00j9c2840 Oslo University Hospital'),
(502, 'https://ror.org/00j9f7w81', 'es', 1, 'https://ror.org/00j9f7w81 Hospital Terrassa'),
(503, 'https://ror.org/00jbkk316', 'en', 1, 'https://ror.org/00jbkk316 Buffalo VA Medical Center'),
(504, 'https://ror.org/00jc57298', 'en', 1, 'https://ror.org/00jc57298 Central Baptist Hospital'),
(505, 'https://ror.org/00jffx511', 'en', 1, 'https://ror.org/00jffx511 PRIST University'),
(506, 'https://ror.org/00jh2w590', 'en', 1, 'https://ror.org/00jh2w590 New Mexico Department of Health'),
(507, 'https://ror.org/00jhae347', 'no_lang_code', 1, 'https://ror.org/00jhae347 Medical Protective'),
(508, 'https://ror.org/00jhyq802', 'en', 1, 'https://ror.org/00jhyq802 Regent University'),
(509, 'https://ror.org/00jjeh629', 'en', 1, 'https://ror.org/00jjeh629 Harvard–MIT Division of Health Sciences and Technology'),
(510, 'https://ror.org/00jjvav84', 'en', 1, 'https://ror.org/00jjvav84 The Hamner Institutes for Health Sciences'),
(511, 'https://ror.org/00jk4qh27', 'no_lang_code', 1, 'https://ror.org/00jk4qh27 TECO'),
(512, 'https://ror.org/00jkkm943', 'pt', 1, 'https://ror.org/00jkkm943 Instituto Superior Manuel Teixeira Gomes'),
(513, 'https://ror.org/00jpae132', 'en', 1, 'https://ror.org/00jpae132 Hillingdon Hospital'),
(514, 'https://ror.org/00jpq0w62', 'fr', 1, 'https://ror.org/00jpq0w62 Centre Hospitalier Universitaire de Tours'),
(515, 'https://ror.org/00jq51013', 'en', 1, 'https://ror.org/00jq51013 Cardinal Glennon Children’s Medical Center'),
(516, 'https://ror.org/00jv89z46', 'en', 1, 'https://ror.org/00jv89z46 Louisiana Board of Regents'),
(517, 'https://ror.org/00jw56w10', 'nl', 1, 'https://ror.org/00jw56w10 Slingeland Ziekenhuis'),
(518, 'https://ror.org/00jy2zq62', 'en', 1, 'https://ror.org/00jy2zq62 Gifu Prefectural Tajimi Hospital 岐阜県立多治見病院'),
(519, 'https://ror.org/00jy5cn48', 'en', 1, 'https://ror.org/00jy5cn48 Meitan General Hospital 煤炭总医院'),
(520, 'https://ror.org/00jy9e726', 'en', 1, 'https://ror.org/00jy9e726 Capital University'),
(521, 'https://ror.org/00jyx0v10', 'en', 1, 'https://ror.org/00jyx0v10 Alfred I. duPont Hospital for Children'),
(522, 'https://ror.org/00jzexr10', 'en', 1, 'https://ror.org/00jzexr10 Astrakhan State Technical University Астраханский государственный технический университет'),
(523, 'https://ror.org/00k1crd82', 'en', 1, 'https://ror.org/00k1crd82 Museum of Science'),
(524, 'https://ror.org/00k1xr956', 'en', 1, 'https://ror.org/00k1xr956 Grady Health System'),
(525, 'https://ror.org/00k27zs44', 'no_lang_code', 1, 'https://ror.org/00k27zs44 Oxford Biomedical Research'),
(526, 'https://ror.org/00k49k182', 'es', 1, 'https://ror.org/00k49k182 Hospital Virgen de la Luz'),
(527, 'https://ror.org/00k57ac30', 'pt', 1, 'https://ror.org/00k57ac30 Instituto Superior de Novas Profissões'),
(528, 'https://ror.org/00k5m1279', 'en', 1, 'https://ror.org/00k5m1279 West Virginia University at Parkersburg'),
(529, 'https://ror.org/00k5vcj72', 'en', 1, 'https://ror.org/00k5vcj72 Molde Hospital Molde sjukehus'),
(530, 'https://ror.org/00k7r7f88', 'en', 1, 'https://ror.org/00k7r7f88 Xuan Wu Hospital of the Capital Medical University 北京市老年病医疗研究中心'),
(531, 'https://ror.org/00k7zpp15', 'en', 1, 'https://ror.org/00k7zpp15 California Animal Hospital'),
(532, 'https://ror.org/00k8adf88', 'en', 1, 'https://ror.org/00k8adf88 Ahmedabad Civil Hospital'),
(533, 'https://ror.org/00k8kp236', 'en', 1, 'https://ror.org/00k8kp236 Applied Technology Council'),
(534, 'https://ror.org/00k9e1m49', 'en', 1, 'https://ror.org/00k9e1m49 Sri Devaraj Urs Medical College'),
(535, 'https://ror.org/00kays408', 'pt', 1, 'https://ror.org/00kays408 Universidade Gama Filho, University Gama Filho'),
(536, 'https://ror.org/00kde4z41', 'pt', 1, 'https://ror.org/00kde4z41 Lutheran University of Brazil Universidad Luterana de Brasil Universidade Luterana do Brasil'),
(537, 'https://ror.org/00kfr4659', 'en', 1, 'https://ror.org/00kfr4659 Mito Red Cross Hospital 水戸赤十字病院'),
(538, 'https://ror.org/00kg66g91', 'en', 1, 'https://ror.org/00kg66g91 Women & Children''s Hospital of Buffalo'),
(539, 'https://ror.org/00kgerq53', 'en', 1, 'https://ror.org/00kgerq53 Hawaii Department of Health'),
(540, 'https://ror.org/00khh5r84', 'en', 1, 'https://ror.org/00khh5r84 Tokyo Gakugei University 東京学芸大学'),
(541, 'https://ror.org/00kmzgn35', 'en', 1, 'https://ror.org/00kmzgn35 Hawke''s Bay Hospital'),
(542, 'https://ror.org/00kmzyw28', 'tr', 1, 'https://ror.org/00kmzyw28 Ankara Atatürk Eğitim ve Araştırma Hastanesi'),
(543, 'https://ror.org/00kne5276', 'no_lang_code', 1, 'https://ror.org/00kne5276 Hektoen Institute'),
(544, 'https://ror.org/00knyd990', 'en', 1, 'https://ror.org/00knyd990 UK Intelligent Systems Research Institute'),
(545, 'https://ror.org/00krab219', 'en', 1, 'https://ror.org/00krab219 Nippon Medical School 日本医科大学'),
(546, 'https://ror.org/00ktqrd38', 'en', 1, 'https://ror.org/00ktqrd38 Kyoto Prefectural University 京都府立大学'),
(547, 'https://ror.org/00kv9pj15', 'no_lang_code', 1, 'https://ror.org/00kv9pj15 BT Group (United Kingdom)'),
(548, 'https://ror.org/00kx7fe64', 'en', 1, 'https://ror.org/00kx7fe64 Fukui Red Cross Hospital 福井赤十字病院'),
(549, 'https://ror.org/00ky3az31', 'en', 1, 'https://ror.org/00ky3az31 VA Puget Sound Health Care System'),
(550, 'https://ror.org/00kym4953', 'no_lang_code', 1, 'https://ror.org/00kym4953 Gemite Group'),
(551, 'https://ror.org/00kzych23', 'en', 1, 'https://ror.org/00kzych23 Nippon Sport Science University 日本体育大学'),
(552, 'https://ror.org/00m1n2078', 'no_lang_code', 1, 'https://ror.org/00m1n2078 CAE (Canada)'),
(553, 'https://ror.org/00m2ag473', 'en', 1, 'https://ror.org/00m2ag473 Archbold Biological Station'),
(554, 'https://ror.org/00m2etp60', 'en', 1, 'https://ror.org/00m2etp60 Holy Family Hospital Nazareth'),
(555, 'https://ror.org/00m4gxn44', 'en', 1, 'https://ror.org/00m4gxn44 Government Medical College'),
(556, 'https://ror.org/00m4rwq02', 'en', 1, 'https://ror.org/00m4rwq02 Christopher Newport University'),
(557, 'https://ror.org/00m5fzs56', 'en', 1, 'https://ror.org/00m5fzs56 Maebashi Red Cross Hospital 前橋赤十字病院'),
(558, 'https://ror.org/00m72p590', 'en', 1, 'https://ror.org/00m72p590 Saint Joseph''s Hospital'),
(559, 'https://ror.org/00m72wv30', 'en', 1, 'https://ror.org/00m72wv30 St. Joseph''s Hospital and Medical Center'),
(560, 'https://ror.org/00m8prc86', 'no_lang_code', 1, 'https://ror.org/00m8prc86 Deutsche Telekom (Germany) German Telecom'),
(561, 'https://ror.org/00m8tc820', 'en', 1, 'https://ror.org/00m8tc820 Kanazawa Medical Center 金沢医療センター'),
(562, 'https://ror.org/00m9c2804', 'en', 1, 'https://ror.org/00m9c2804 Philadelphia College of Osteopathic Medicine'),
(563, 'https://ror.org/00m9ydx43', 'en', 1, 'https://ror.org/00m9ydx43 National Hospital Organization Mito Medical Center 国立病院機構水戸医療センター'),
(564, 'https://ror.org/00mbaq869', 'en', 1, 'https://ror.org/00mbaq869 Timescape Surveys'),
(565, 'https://ror.org/00mbhee72', 'en', 1, 'https://ror.org/00mbhee72 University Medical Center of Princeton'),
(566, 'https://ror.org/00mbsbt95', 'it', 1, 'https://ror.org/00mbsbt95 Ospedale San Giovanni Bellinzona'),
(567, 'https://ror.org/00mc5wj35', 'en', 1, 'https://ror.org/00mc5wj35 Mudanjiang Medical University 牡丹江医学院'),
(568, 'https://ror.org/00mc91w09', 'it', 1, 'https://ror.org/00mc91w09 Ospedale Cisanello'),
(569, 'https://ror.org/00mch1v74', 'en', 1, 'https://ror.org/00mch1v74 John Muir Medical Center'),
(570, 'https://ror.org/00mczdx43', 'en', 1, 'https://ror.org/00mczdx43 National University of San Luis Universidad Nacional de San Luis'),
(571, 'https://ror.org/00md77g41', 'it', 1, 'https://ror.org/00md77g41 Casa Sollievo della Sofferenza Home for Relief of the Suffering'),
(572, 'https://ror.org/00menq219', 'en', 1, 'https://ror.org/00menq219 Naruto University of Education 鳴門教育大学'),
(573, 'https://ror.org/00meyvj69', 'en', 1, 'https://ror.org/00meyvj69 St. Lawrence River Institute of Environmental Sciences'),
(574, 'https://ror.org/00mj4n083', 'en', 1, 'https://ror.org/00mj4n083 St. Francis Hospital'),
(575, 'https://ror.org/00mj9k629', 'en', 1, 'https://ror.org/00mj9k629 Children''s Hospital Colorado'),
(576, 'https://ror.org/00mjaaf25', 'en', 1, 'https://ror.org/00mjaaf25 National School of Public Health'),
(577, 'https://ror.org/00mjawt10', 'en', 1, 'https://ror.org/00mjawt10 National Sun Yat-sen University'),
(578, 'https://ror.org/00mmq5f59', 'en', 1, 'https://ror.org/00mmq5f59 Mahatma Phule Krishi Vidyapeeth'),
(579, 'https://ror.org/00mns7k70', 'en', 1, 'https://ror.org/00mns7k70 Savannah State University Université d''État de Savannah'),
(580, 'https://ror.org/00mrhvv69', 'en', 1, 'https://ror.org/00mrhvv69 Kementerian Kesihatan Singapura Ministry of Health சிங்கப்பூர் சுகாதார அமைச்சகம் 新加坡卫生部'),
(581, 'https://ror.org/00mrw8k38', 'en', 1, 'https://ror.org/00mrw8k38 Ramkhamhaeng University มหาวิทยาลัยรามคำแหง'),
(582, 'https://ror.org/00mtrzx11', 'es', 1, 'https://ror.org/00mtrzx11 Hospital Nacional Cayetano Heredia'),
(583, 'https://ror.org/00mvp1q86', 'en', 1, 'https://ror.org/00mvp1q86 Hemwati Nandan Bahuguna Garhwal University गढ़वाल विश्वविद्यालय'),
(584, 'https://ror.org/00mwdv335', 'en', 1, 'https://ror.org/00mwdv335 Académie new-yorkaise de médecine New York Academy of Medicine'),
(585, 'https://ror.org/00mwhaw71', 'en', 1, 'https://ror.org/00mwhaw71 Mae Fah Luang University มหาวิทยาลัยแม่ฟ้าหลวง'),
(586, 'https://ror.org/00mynj496', 'no_lang_code', 1, 'https://ror.org/00mynj496 Glazer Medical Solutions (United States)'),
(587, 'https://ror.org/00mz0c648', 'en', 1, 'https://ror.org/00mz0c648 Boise VA Medical Center'),
(588, 'https://ror.org/00n14a494', 'en', 1, 'https://ror.org/00n14a494 Korea Polar Research Institute 극지연구소'),
(589, 'https://ror.org/00n1w4965', 'en', 1, 'https://ror.org/00n1w4965 MedStar Union Memorial Hospital'),
(590, 'https://ror.org/00n2w1t65', 'en', 1, 'https://ror.org/00n2w1t65 Presbyterian Hospital'),
(591, 'https://ror.org/00n3e1d98', 'en', 1, 'https://ror.org/00n3e1d98 Takasaki University of Health and Welfare 高崎健康福祉大学'),
(592, 'https://ror.org/00n5htd36', 'en', 1, 'https://ror.org/00n5htd36 Westmar University'),
(593, 'https://ror.org/00n8yb347', 'en', 1, 'https://ror.org/00n8yb347 Bệnh viện Chợ Rẫy Cho Ray Hospital'),
(594, 'https://ror.org/00n9v4y14', 'en', 1, 'https://ror.org/00n9v4y14 Good Samaritan Hospital'),
(595, 'https://ror.org/00nas2c56', 'no_lang_code', 1, 'https://ror.org/00nas2c56 Ericsson (Canada)'),
(596, 'https://ror.org/00nebyg34', 'en', 1, 'https://ror.org/00nebyg34 Central Maine Medical Center'),
(597, 'https://ror.org/00nf20x22', 'en', 1, 'https://ror.org/00nf20x22 Indira Gandhi Medical College and Research Institute'),
(598, 'https://ror.org/00ng6k310', 'en', 1, 'https://ror.org/00ng6k310 Chapel Allerton Hospital'),
(599, 'https://ror.org/00ngrq502', 'en', 1, 'https://ror.org/00ngrq502 Arak University دانشگاه اراک'),
(600, 'https://ror.org/00nh9x179', 'en', 1, 'https://ror.org/00nh9x179 St Bartholomew''s Hospital'),
(601, 'https://ror.org/00njz5525', 'en', 1, 'https://ror.org/00njz5525 Juravinski Hospital'),
(602, 'https://ror.org/00nk17n43', 'en', 1, 'https://ror.org/00nk17n43 University of Maine at Presque Isle'),
(603, 'https://ror.org/00nm7k655', 'en', 1, 'https://ror.org/00nm7k655 James Paget University Hospital'),
(604, 'https://ror.org/00nmnnk78', 'en', 1, 'https://ror.org/00nmnnk78 University Medical Center of El Paso'),
(605, 'https://ror.org/00nqxe643', 'en', 1, 'https://ror.org/00nqxe643 Cama and Albless Hospital'),
(606, 'https://ror.org/00nr17z89', 'en', 1, 'https://ror.org/00nr17z89 VA Palo Alto Health Care System'),
(607, 'https://ror.org/00nrgkr20', 'it', 1, 'https://ror.org/00nrgkr20 Cattinara Hospital Ospedale di Cattinara'),
(608, 'https://ror.org/00nrtez23', 'it', 1, 'https://ror.org/00nrtez23 Azienda Ospedaliero Universitaria San Giovanni Battista'),
(609, 'https://ror.org/00ns3e792', 'en', 1, 'https://ror.org/00ns3e792 King Edward Memorial Hospital'),
(610, 'https://ror.org/00nsz0a92', 'en', 1, 'https://ror.org/00nsz0a92 Omaha VA Medical Center'),
(611, 'https://ror.org/00nthx533', 'en', 1, 'https://ror.org/00nthx533 Geological Survey of India भारतीय भूवैज्ञानिक सर्वेक्षण'),
(612, 'https://ror.org/00nvxt968', 'de', 1, 'https://ror.org/00nvxt968 Universitätsklinikum des Saarlandes'),
(613, 'https://ror.org/00nwc4v84', 'tr', 1, 'https://ror.org/00nwc4v84 İstanbul Eğitim ve Araştırma Hastanesi'),
(614, 'https://ror.org/00nx6aa03', 'en', 1, 'https://ror.org/00nx6aa03 Mater Research'),
(615, 'https://ror.org/00nxna028', 'en', 1, 'https://ror.org/00nxna028 HR Wallingford'),
(616, 'https://ror.org/00nyr7p12', 'en', 1, 'https://ror.org/00nyr7p12 Gauhati Medical College and Hospital গৌহাটী চিকিৎসা মহাবিদ্যালয়'),
(617, 'https://ror.org/00nyxxr91', 'en', 1, 'https://ror.org/00nyxxr91 Peking University Cancer Hospital 北京大学肿瘤医院'),
(618, 'https://ror.org/00nz9t738', 'en', 1, 'https://ror.org/00nz9t738 Ferrarotto Hospital'),
(619, 'https://ror.org/00nzje529', 'en', 1, 'https://ror.org/00nzje529 Antioch University New England'),
(620, 'https://ror.org/00p2tmy87', 'pt', 1, 'https://ror.org/00p2tmy87 Instituto Superior de Espinho'),
(621, 'https://ror.org/00p2x3741', 'en', 1, 'https://ror.org/00p2x3741 Southend Hospital'),
(622, 'https://ror.org/00p82hn55', 'en', 1, 'https://ror.org/00p82hn55 Salus University'),
(623, 'https://ror.org/00p8b0t20', 'en', 1, 'https://ror.org/00p8b0t20 Belarusian State Medical University Беларускі дзяржаўны медыцынскі ўніверсітэт Белорусский государственный медицинский университет'),
(624, 'https://ror.org/00p8xqj61', 'en', 1, 'https://ror.org/00p8xqj61 Karpov Institute of Physical Chemistry Акционерное общество Ордена Трудового Красного Знамени научно-исследовательский физико-химический институт имени Л.Я. Карпова'),
(625, 'https://ror.org/00p9h0053', 'en', 1, 'https://ror.org/00p9h0053 Natural History Museum of Los Angeles County'),
(626, 'https://ror.org/00paq4p43', 'en', 1, 'https://ror.org/00paq4p43 Bay Pines VA Healthcare System'),
(627, 'https://ror.org/00pb8h375', 'en', 1, 'https://ror.org/00pb8h375 Bauman Moscow State Technical University Московский государственный технический университет имени Н. Э. Баумана'),
(628, 'https://ror.org/00pbh0a34', 'en', 1, 'https://ror.org/00pbh0a34 British Museum Yr Amgueddfa Brydeinig'),
(629, 'https://ror.org/00pcrz470', 'en', 1, 'https://ror.org/00pcrz470 Chengdu University of Traditional Chinese Medicine 成都中医药大学'),
(630, 'https://ror.org/00pczg388', 'en', 1, 'https://ror.org/00pczg388 Sinclair Community College'),
(631, 'https://ror.org/00pefnv05', 'en', 1, 'https://ror.org/00pefnv05 Museum of Heilongjiang Province 黑龙江省博物馆'),
(632, 'https://ror.org/00pf0g237', 'no_lang_code', 1, 'https://ror.org/00pf0g237 Theragen'),
(633, 'https://ror.org/00pg98t08', 'en', 1, 'https://ror.org/00pg98t08 Francis Marion University'),
(634, 'https://ror.org/00pg9d188', 'en', 1, 'https://ror.org/00pg9d188 Al Noor Hospitals'),
(635, 'https://ror.org/00pk1yr39', 'en', 1, 'https://ror.org/00pk1yr39 Sørlandet Hospital Arendal Sørlandet Sykehus HF'),
(636, 'https://ror.org/00pmcf502', 'no_lang_code', 1, 'https://ror.org/00pmcf502 Talisman Energy'),
(637, 'https://ror.org/00prpaj09', 'no_lang_code', 1, 'https://ror.org/00prpaj09 Alion Science and Technology (United States)'),
(638, 'https://ror.org/00pw0pp06', 'en', 1, 'https://ror.org/00pw0pp06 Graz University Hospital Univ. Klinikum Graz'),
(639, 'https://ror.org/00q09pe49', 'en', 1, 'https://ror.org/00q09pe49 National Taiwan University of Science and Technology'),
(640, 'https://ror.org/00q38e504', 'no_lang_code', 1, 'https://ror.org/00q38e504 Lerdsin Hospital โรงพยาบาลเลิดสิน'),
(641, 'https://ror.org/00q5txg88', 'en', 1, 'https://ror.org/00q5txg88 Plains Health Centre'),
(642, 'https://ror.org/00q6w3x44', 'en', 1, 'https://ror.org/00q6w3x44 Ellis Hospital'),
(643, 'https://ror.org/00q6wbs64', 'no_lang_code', 1, 'https://ror.org/00q6wbs64 Tianjin Huanhu Hospital 天津市环湖医院'),
(644, 'https://ror.org/00q75av54', 'en', 1, 'https://ror.org/00q75av54 South Tyneside District Hospital'),
(645, 'https://ror.org/00qctrq52', 'en', 1, 'https://ror.org/00qctrq52 Manipal College of Medical Sciences'),
(646, 'https://ror.org/00qdkc036', 'no_lang_code', 1, 'https://ror.org/00qdkc036 Hoshigaoka Medical Center 星ヶ丘医療センター'),
(647, 'https://ror.org/00qdsfq65', 'en', 1, 'https://ror.org/00qdsfq65 Korea National Institute of Health'),
(648, 'https://ror.org/00qexeh70', 'en', 1, 'https://ror.org/00qexeh70 Middlesex Hospital'),
(649, 'https://ror.org/00qezxe61', 'no_lang_code', 1, 'https://ror.org/00qezxe61 Ikeda Municipal Hospital 池田市立病院'),
(650, 'https://ror.org/00qfq7b40', 'no_lang_code', 1, 'https://ror.org/00qfq7b40 PerkinElmer Biosignal'),
(651, 'https://ror.org/00qhe6a56', 'no_lang_code', 1, 'https://ror.org/00qhe6a56 Miltenyi Biotec (Germany)'),
(652, 'https://ror.org/00qkhxq50', 'en', 1, 'https://ror.org/00qkhxq50 Jessa Hospital Jessa Ziekenhuis'),
(653, 'https://ror.org/00qm2vr07', 'en', 1, 'https://ror.org/00qm2vr07 Nakamura Gakuen University 中村学園大学'),
(654, 'https://ror.org/00qmnd673', 'en', 1, 'https://ror.org/00qmnd673 Kindai University Hospital 近畿大学医学部 附属病院'),
(655, 'https://ror.org/00qp1n828', 'en', 1, 'https://ror.org/00qp1n828 King George Hospital'),
(656, 'https://ror.org/00qpv3w06', 'en', 1, 'https://ror.org/00qpv3w06 Amref Health Africa'),
(657, 'https://ror.org/00qt4k071', 'it', 1, 'https://ror.org/00qt4k071 Ospedale San Filippo Neri'),
(658, 'https://ror.org/00qt5ka73', 'no_lang_code', 1, 'https://ror.org/00qt5ka73 Arttic (France)'),
(659, 'https://ror.org/00qvx5329', 'en', 1, 'https://ror.org/00qvx5329 Doheny Eye Institute'),
(660, 'https://ror.org/00qwj7906', 'no_lang_code', 1, 'https://ror.org/00qwj7906 EA Technology'),
(661, 'https://ror.org/00qwnam72', 'en', 1, 'https://ror.org/00qwnam72 Chiba Institute of Technology 千葉工業大学'),
(662, 'https://ror.org/00qz24g20', 'en', 1, 'https://ror.org/00qz24g20 University of North Carolina Health Care'),
(663, 'https://ror.org/00qzd4032', 'no_lang_code', 1, 'https://ror.org/00qzd4032 Quality Biological'),
(664, 'https://ror.org/00r1hxj45', 'en', 1, 'https://ror.org/00r1hxj45 Noor Eye Hospital بیمارستان چشم‌پزشکی نور'),
(665, 'https://ror.org/00r2gde63', 'en', 1, 'https://ror.org/00r2gde63 Ascamm Technologic Center Centro Tecnológico Ascamm'),
(666, 'https://ror.org/00r59hk87', 'en', 1, 'https://ror.org/00r59hk87 North Kansas City Hospital'),
(667, 'https://ror.org/00r5kgd36', 'en', 1, 'https://ror.org/00r5kgd36 Nenagh Hospital Ospidéal an Aonaigh'),
(668, 'https://ror.org/00r5mr697', 'en', 1, 'https://ror.org/00r5mr697 Western New Mexico University'),
(669, 'https://ror.org/00r66pz14', 'en', 1, 'https://ror.org/00r66pz14 Natural England'),
(670, 'https://ror.org/00r67fz39', 'en', 1, 'https://ror.org/00r67fz39 Second Affiliated Hospital of Chongqing Medical University'),
(671, 'https://ror.org/00r9g7t11', 'en', 1, 'https://ror.org/00r9g7t11 Oregon University System'),
(672, 'https://ror.org/00ra1fg11', 'en', 1, 'https://ror.org/00ra1fg11 Pennsylvania Department of Health'),
(673, 'https://ror.org/00rey4c89', 'no_lang_code', 1, 'https://ror.org/00rey4c89 General Electric (Canada)'),
(674, 'https://ror.org/00rgv0036', 'en', 1, 'https://ror.org/00rgv0036 Cameron University'),
(675, 'https://ror.org/00rh8m666', 'en', 1, 'https://ror.org/00rh8m666 Institute For Defense Analyses Instituto de Análisis de la Defensa'),
(676, 'https://ror.org/00rkxs190', 'no_lang_code', 1, 'https://ror.org/00rkxs190 TDA Research (United States)'),
(677, 'https://ror.org/00rm3wf49', 'en', 1, 'https://ror.org/00rm3wf49 Lilavati Hospital & Research Centre'),
(678, 'https://ror.org/00rpfyx16', 'en', 1, 'https://ror.org/00rpfyx16 Belvidere Hospital'),
(679, 'https://ror.org/00rsqg119', 'en', 1, 'https://ror.org/00rsqg119 King Edward VII Hospital'),
(680, 'https://ror.org/00rt1d436', 'en', 1, 'https://ror.org/00rt1d436 American Psychological Association'),
(681, 'https://ror.org/00rws8x56', 'en', 1, 'https://ror.org/00rws8x56 Gimpo Airport Wooridul Spine Hospital 서울우리들병원'),
(682, 'https://ror.org/00rz5xc38', 'en', 1, 'https://ror.org/00rz5xc38 Mississippi Valley State University'),
(683, 'https://ror.org/00rzeqe23', 'en', 1, 'https://ror.org/00rzeqe23 Institut postgraduálního vzdělávání ve zdravotnictví Institute for Postgraduate Medical Education'),
(684, 'https://ror.org/00s31qp90', 'en', 1, 'https://ror.org/00s31qp90 Operation PAR'),
(685, 'https://ror.org/00s4vhs88', 'es', 1, 'https://ror.org/00s4vhs88 Doctor Negrín University Hospital Hospital Universitario de Gran Canaria Doctor Negrín'),
(686, 'https://ror.org/00s58vq35', 'en', 1, 'https://ror.org/00s58vq35 Instituto Superior Bissaya Barreto'),
(687, 'https://ror.org/00s5x0w83', 'es', 1, 'https://ror.org/00s5x0w83 Almirante Nef Naval Hospital Hospital Naval Almirante Nef'),
(688, 'https://ror.org/00s7qjp35', 'pt', 1, 'https://ror.org/00s7qjp35 Universidade Vale do Rio Verde'),
(689, 'https://ror.org/00s9dpb54', 'en', 1, 'https://ror.org/00s9dpb54 Myongji University 명지대학교'),
(690, 'https://ror.org/00sbqe313', 'en', 1, 'https://ror.org/00sbqe313 Sacred Heart Medical Center'),
(691, 'https://ror.org/00se0qr64', 'en', 1, 'https://ror.org/00se0qr64 Summit Oaks Hospital'),
(692, 'https://ror.org/00sf92s91', 'en', 1, 'https://ror.org/00sf92s91 Lehigh Valley Health Network'),
(693, 'https://ror.org/00sge8677', 'en', 1, 'https://ror.org/00sge8677 BRAC University ব্র্যাক ইউনিভার্সিটি'),
(694, 'https://ror.org/00sh4ma05', 'en', 1, 'https://ror.org/00sh4ma05 Southwestern Oregon Community College'),
(695, 'https://ror.org/00shmxd32', 'en', 1, 'https://ror.org/00shmxd32 PBMA''s H.V. Desai Eye Hospital'),
(696, 'https://ror.org/00skrw306', 'en', 1, 'https://ror.org/00skrw306 Colorado Department of Human Services'),
(697, 'https://ror.org/00skwgg83', 'en', 1, 'https://ror.org/00skwgg83 Fukuoka Women''s University 福岡女子大学'),
(698, 'https://ror.org/00sm8k518', 'it', 1, 'https://ror.org/00sm8k518 Azienda Ospedaliera Universitaria Integrata Verona'),
(699, 'https://ror.org/00smwky98', 'no_lang_code', 1, 'https://ror.org/00smwky98 Tokushima Bunri University 徳島文理大学'),
(700, 'https://ror.org/00snwj435', 'en', 1, 'https://ror.org/00snwj435 Shriners Hospitals for Children - Portland'),
(701, 'https://ror.org/00spnmn10', 'no_lang_code', 1, 'https://ror.org/00spnmn10 Whalen Biomedical'),
(702, 'https://ror.org/00spys463', 'en', 1, 'https://ror.org/00spys463 Los Angeles Medical Center'),
(703, 'https://ror.org/00sqp6g97', 'fr', 1, 'https://ror.org/00sqp6g97 Centre hospitalier Emile Roux'),
(704, 'https://ror.org/00swp5c87', 'en', 1, 'https://ror.org/00swp5c87 Gynuity Health Projects'),
(705, 'https://ror.org/00swtwf35', 'en', 1, 'https://ror.org/00swtwf35 Chest Diseases Hospital المستشفى الصدري'),
(706, 'https://ror.org/00swv7d52', 'en', 1, 'https://ror.org/00swv7d52 Penn Presbyterian Medical Center'),
(707, 'https://ror.org/00sxe0e68', 'en', 1, 'https://ror.org/00sxe0e68 Harper University Hospital'),
(708, 'https://ror.org/00t0h7472', 'pt', 1, 'https://ror.org/00t0h7472 Escola Superior de Educadores de Infância Maria Ulrich'),
(709, 'https://ror.org/00t0n9020', 'en', 1, 'https://ror.org/00t0n9020 Kaplan Medical Center מרכז רפואי קפלן'),
(710, 'https://ror.org/00t1xpx62', 'fr', 1, 'https://ror.org/00t1xpx62 Hôpital Kirchberg'),
(711, 'https://ror.org/00t2n7611', 'da', 1, 'https://ror.org/00t2n7611 Roskilde Hospital Roskilde Sygehus'),
(712, 'https://ror.org/00t30ch44', 'en', 1, 'https://ror.org/00t30ch44 Midwestern State University Université d''État du midwest'),
(713, 'https://ror.org/00t3s0v26', 'en', 1, 'https://ror.org/00t3s0v26 Lok Nayak Jai Prakash Narayan Hospital'),
(714, 'https://ror.org/00t47w971', 'en', 1, 'https://ror.org/00t47w971 Clayton State University'),
(715, 'https://ror.org/00t60zh31', 'en', 1, 'https://ror.org/00t60zh31 Kaiser Permanente'),
(716, 'https://ror.org/00t61fh47', 'en', 1, 'https://ror.org/00t61fh47 Ijinkai Takeda General Hospital 武田総合病院は'),
(717, 'https://ror.org/00t9hhv14', 'en', 1, 'https://ror.org/00t9hhv14 University of South Carolina Upstate'),
(718, 'https://ror.org/00tapj019', 'en', 1, 'https://ror.org/00tapj019 Asociación de Universidades Americanas Association des universités américaines Association of American Universities'),
(719, 'https://ror.org/00tb6zr84', 'en', 1, 'https://ror.org/00tb6zr84 American School Health Association'),
(720, 'https://ror.org/00tcmr651', 'en', 1, 'https://ror.org/00tcmr651 Kathmandu Medical College Teaching Hospital'),
(721, 'https://ror.org/00tdzhd41', 'es', 1, 'https://ror.org/00tdzhd41 Hospital Fernández'),
(722, 'https://ror.org/00te55z70', 'fi', 1, 'https://ror.org/00te55z70 Mikkelin keskussairaala'),
(723, 'https://ror.org/00tfedq56', 'en', 1, 'https://ror.org/00tfedq56 Center for Medical, Agricultural and Veterinary Entomology'),
(724, 'https://ror.org/00tg1yh20', 'no_lang_code', 1, 'https://ror.org/00tg1yh20 Aetna (United States)'),
(725, 'https://ror.org/00tjv0s33', 'en', 1, 'https://ror.org/00tjv0s33 Keimyung University 계명대학교'),
(726, 'https://ror.org/00tkrd758', 'en', 1, 'https://ror.org/00tkrd758 Gartnavel General Hospital'),
(727, 'https://ror.org/00tnppw48', 'en', 1, 'https://ror.org/00tnppw48 Adran yr Amgylchedd, Bwyd a Materion Gwledig Department for Environment Food and Rural Affairs'),
(728, 'https://ror.org/00tq7xg10', 'en', 1, 'https://ror.org/00tq7xg10 Suzuka University of Medical Science 鈴鹿医療科学大学'),
(729, 'https://ror.org/00trhvv58', 'en', 1, 'https://ror.org/00trhvv58 Shriners Hospitals for Children - Greenville'),
(730, 'https://ror.org/00tt53p64', 'en', 1, 'https://ror.org/00tt53p64 SRC'),
(731, 'https://ror.org/00tta1k37', 'en', 1, 'https://ror.org/00tta1k37 Folktandvården Västra Götaland Public Dental Service Västra Götaland'),
(732, 'https://ror.org/00tw3jy02', 'en', 1, 'https://ror.org/00tw3jy02 MRC Laboratory of Molecular Biology'),
(733, 'https://ror.org/00tze5d69', 'en', 1, 'https://ror.org/00tze5d69 Teikyo University Hospital 帝京大学医学部附属病院'),
(734, 'https://ror.org/00tzmb306', 'en', 1, 'https://ror.org/00tzmb306 Danish Maritime Institute'),
(735, 'https://ror.org/00v3ak792', 'en', 1, 'https://ror.org/00v3ak792 Universidad de Dallas University of Dallas Université de Dallas'),
(736, 'https://ror.org/00v4dac24', 'en', 1, 'https://ror.org/00v4dac24 Leeds Teaching Hospitals NHS Trust'),
(737, 'https://ror.org/00v5h4y49', 'en', 1, 'https://ror.org/00v5h4y49 Derriford Hospital'),
(738, 'https://ror.org/00v6af077', 'en', 1, 'https://ror.org/00v6af077 Calvary Hospital'),
(739, 'https://ror.org/00v6s9648', 'en', 1, 'https://ror.org/00v6s9648 University of Worcester'),
(740, 'https://ror.org/00v81k483', 'en', 1, 'https://ror.org/00v81k483 Mokpo National University 목포대학교'),
(741, 'https://ror.org/00v8fdc16', 'en', 1, 'https://ror.org/00v8fdc16 Autonomous University of Queretaro Universidad Autónoma de Querétaro'),
(742, 'https://ror.org/00var5q80', 'en', 1, 'https://ror.org/00var5q80 American Geophysical Union'),
(743, 'https://ror.org/00vbnvy39', 'en', 1, 'https://ror.org/00vbnvy39 Montgomery General Hospital'),
(744, 'https://ror.org/00vcyhn10', 'pt', 1, 'https://ror.org/00vcyhn10 Catholic University of Santos Universidade Católica de Santos'),
(745, 'https://ror.org/00vdhsr35', 'en', 1, 'https://ror.org/00vdhsr35 Marywood University'),
(746, 'https://ror.org/00vhhbt37', 'en', 1, 'https://ror.org/00vhhbt37 Howard Payne University'),
(747, 'https://ror.org/00vhr7p75', 'en', 1, 'https://ror.org/00vhr7p75 Battle Hospital'),
(748, 'https://ror.org/00vjb5165', 'en', 1, 'https://ror.org/00vjb5165 Ministry of Health'),
(749, 'https://ror.org/00vkrxq08', 'en', 1, 'https://ror.org/00vkrxq08 University Malaya Medical Centre'),
(750, 'https://ror.org/00vmdr162', 'en', 1, 'https://ror.org/00vmdr162 Kyoritsu Women''s University 共立女子大学'),
(751, 'https://ror.org/00vmr1p37', 'en', 1, 'https://ror.org/00vmr1p37 Seacroft Hospital'),
(752, 'https://ror.org/00vpv1x26', 'en', 1, 'https://ror.org/00vpv1x26 Tokyo Medical University Hachioji Medical Center 東京医科大学八王子医療センター'),
(753, 'https://ror.org/00vpw9h05', 'en', 1, 'https://ror.org/00vpw9h05 Honolulu Community College'),
(754, 'https://ror.org/00vqhxg21', 'no_lang_code', 1, 'https://ror.org/00vqhxg21 SMEC (Australia)'),
(755, 'https://ror.org/00vv7qz60', 'no_lang_code', 1, 'https://ror.org/00vv7qz60 Fukuoka Hospital 福岡病院'),
(756, 'https://ror.org/00vvvt117', 'en', 1, 'https://ror.org/00vvvt117 Sookmyung Women''s University 숙명여자대학교'),
(757, 'https://ror.org/00vx2w009', 'en', 1, 'https://ror.org/00vx2w009 Lapin keskussairaala Lapland Central Hospital'),
(758, 'https://ror.org/00vxe3x87', 'de', 1, 'https://ror.org/00vxe3x87 Sternwarte Stuttgart, Stuttgart Observatory'),
(759, 'https://ror.org/00vyyx863', 'en', 1, 'https://ror.org/00vyyx863 Eastern Health'),
(760, 'https://ror.org/00vznbp60', 'no_lang_code', 1, 'https://ror.org/00vznbp60 Alpha Universe'),
(761, 'https://ror.org/00vzw9736', 'no_lang_code', 1, 'https://ror.org/00vzw9736 Kariya Toyota General Hospital 刈谷豊田総合病院'),
(762, 'https://ror.org/00vzzhs86', 'no_lang_code', 1, 'https://ror.org/00vzzhs86 Sir Hurkisondas Nurrotumdas Medical Research Society'),
(763, 'https://ror.org/00w1fsg08', 'en', 1, 'https://ror.org/00w1fsg08 Hyogo Prefectural Awaji Medical Center 兵庫県立淡路医療センター'),
(764, 'https://ror.org/00w6bqp33', 'en', 1, 'https://ror.org/00w6bqp33 National University of Health Sciences'),
(765, 'https://ror.org/00w6r1881', 'en', 1, 'https://ror.org/00w6r1881 Institute of Nanostructured Materials Istituto per lo Studio dei Materiali Nanostrutturati'),
(766, 'https://ror.org/00w7dj406', 'en', 1, 'https://ror.org/00w7dj406 American Society of Health-System Pharmacists'),
(767, 'https://ror.org/00w7vnc45', 'en', 1, 'https://ror.org/00w7vnc45 America''s Health Insurance Plans'),
(768, 'https://ror.org/00w81q081', 'fr', 1, 'https://ror.org/00w81q081 Hôpital Albert Calmette'),
(769, 'https://ror.org/00w93dg44', 'en', 1, 'https://ror.org/00w93dg44 Na Homolce Hospital Nemocnice Na Homolce'),
(770, 'https://ror.org/00watgv28', 'en', 1, 'https://ror.org/00watgv28 College of Saint Benedict and Saint John''s University Collège de saint benedict et université de saint jean'),
(771, 'https://ror.org/00wbzw723', 'en', 1, 'https://ror.org/00wbzw723 University of Washington Medical Center'),
(772, 'https://ror.org/00wc07928', 'en', 1, 'https://ror.org/00wc07928 University of Lomé Université de Lomé'),
(773, 'https://ror.org/00we60833', 'en', 1, 'https://ror.org/00we60833 Women''s & Children''s Health Research Institute'),
(774, 'https://ror.org/00wejpz79', 'en', 1, 'https://ror.org/00wejpz79 Hyogo University of Teacher Education 兵庫教育大学'),
(775, 'https://ror.org/00wemg618', 'en', 1, 'https://ror.org/00wemg618 Youjiang Medical College for Nationalities 右江民族医学院'),
(776, 'https://ror.org/00wfvh315', 'en', 1, 'https://ror.org/00wfvh315 Charles Sturt University'),
(777, 'https://ror.org/00wfvxt55', 'en', 1, 'https://ror.org/00wfvxt55 Minnesota Department of Human Services'),
(778, 'https://ror.org/00wg2b048', 'en', 1, 'https://ror.org/00wg2b048 Royal University Hospital'),
(779, 'https://ror.org/00whfdj78', 'no_lang_code', 1, 'https://ror.org/00whfdj78 BioTek (United States)'),
(780, 'https://ror.org/00wk9vd23', 'en', 1, 'https://ror.org/00wk9vd23 Regionshospitalet Skive Skive Hospital'),
(781, 'https://ror.org/00wkhef66', 'en', 1, 'https://ror.org/00wkhef66 Reinier de Graaf Hospital'),
(782, 'https://ror.org/00wksha49', 'en', 1, 'https://ror.org/00wksha49 National Institute of Biological Sciences, Beijing 北京生命科学研究所'),
(783, 'https://ror.org/00wm07d60', 'en', 1, 'https://ror.org/00wm07d60 Van Andel Institute'),
(784, 'https://ror.org/00wmm6v75', 'en', 1, 'https://ror.org/00wmm6v75 American University of Beirut Medical Center'),
(785, 'https://ror.org/00wn7d965', 'en', 1, 'https://ror.org/00wn7d965 University of Virginia Health System'),
(786, 'https://ror.org/00wpte173', 'en', 1, 'https://ror.org/00wpte173 Grey Nuns Community Hospital'),
(787, 'https://ror.org/00wr13y59', 'en', 1, 'https://ror.org/00wr13y59 Lutheran Medical Center'),
(788, 'https://ror.org/00wspbn44', 'en', 1, 'https://ror.org/00wspbn44 Canterbury Health Laboratories'),
(789, 'https://ror.org/00wt7xg39', 'no_lang_code', 1, 'https://ror.org/00wt7xg39 Westat (United States)'),
(790, 'https://ror.org/00wtgx181', 'en', 1, 'https://ror.org/00wtgx181 Highland Hospital'),
(791, 'https://ror.org/00wtq7t14', 'en', 1, 'https://ror.org/00wtq7t14 Governors State University'),
(792, 'https://ror.org/00wygsf57', 'en', 1, 'https://ror.org/00wygsf57 Dongseo University 동서대학교'),
(793, 'https://ror.org/00wys9y90', 'en', 1, 'https://ror.org/00wys9y90 Herlev Hospital'),
(794, 'https://ror.org/00wyx7h61', 'en', 1, 'https://ror.org/00wyx7h61 Royal Alexandra Hospital'),
(795, 'https://ror.org/00wzdr059', 'en', 1, 'https://ror.org/00wzdr059 St. Paul''s Hospital'),
(796, 'https://ror.org/00wzt9y79', 'en', 1, 'https://ror.org/00wzt9y79 Ohio Cancer Research Associates'),
(797, 'https://ror.org/00x396v48', 'en', 1, 'https://ror.org/00x396v48 Mendota Mental Health Institute'),
(798, 'https://ror.org/00x3rpv59', 'en', 1, 'https://ror.org/00x3rpv59 Tomsk State Pedagogical University Томский государственный педагогический университет'),
(799, 'https://ror.org/00x5b2p37', 'en', 1, 'https://ror.org/00x5b2p37 Carroll College'),
(800, 'https://ror.org/00x8ccz20', 'en', 1, 'https://ror.org/00x8ccz20 University of Wisconsin–La Crosse Université du Wisconsin–La Crosse'),
(801, 'https://ror.org/00xb4cb83', 'en', 1, 'https://ror.org/00xb4cb83 Southern Arizona VA Health Care System'),
(802, 'https://ror.org/00xdn8y92', 'en', 1, 'https://ror.org/00xdn8y92 Punjabi University पंजाबी विश्वविद्यालय ਪੰਜਾਬੀ ਯੂਨੀਵਰਸਿਟੀ'),
(803, 'https://ror.org/00xhz2q61', 'en', 1, 'https://ror.org/00xhz2q61 Seoul Veterans Hospital'),
(804, 'https://ror.org/00xmkp704', 'en', 1, 'https://ror.org/00xmkp704 Ghent University Hospital Universitair Ziekenhuis Gent'),
(805, 'https://ror.org/00xmn3c34', 'en', 1, 'https://ror.org/00xmn3c34 Monmouth Medical Center'),
(806, 'https://ror.org/00xmzb398', 'pt', 1, 'https://ror.org/00xmzb398 Hospital Alemão Oswaldo Cruz'),
(807, 'https://ror.org/00xnmcq32', 'en', 1, 'https://ror.org/00xnmcq32 Grey''s Hospital'),
(808, 'https://ror.org/00xpcm295', 'en', 1, 'https://ror.org/00xpcm295 Wyoming State Department of Health'),
(809, 'https://ror.org/00xwgyp12', 'pt', 1, 'https://ror.org/00xwgyp12 Federal Rural University of Rio de Janeiro Universidade Federal Rural do Rio de Janeiro'),
(810, 'https://ror.org/00xyeez13', 'en', 1, 'https://ror.org/00xyeez13 Kunming University of Science and Technology 昆明理工大学'),
(811, 'https://ror.org/00xz7ma09', 'fr', 1, 'https://ror.org/00xz7ma09 Hôpital régional'),
(812, 'https://ror.org/00xznf773', 'en', 1, 'https://ror.org/00xznf773 Auburn Community Hospital'),
(813, 'https://ror.org/00y1kmp77', 'en', 1, 'https://ror.org/00y1kmp77 NIMTS Hospital'),
(814, 'https://ror.org/00y64dx33', 'en', 1, 'https://ror.org/00y64dx33 Monroe Carell Jr. Children''s Hospital'),
(815, 'https://ror.org/00y6akb91', 'no_lang_code', 1, 'https://ror.org/00y6akb91 Revolution Analytics (United States)'),
(816, 'https://ror.org/00ydm0027', 'en', 1, 'https://ror.org/00ydm0027 University of Maine at Farmington'),
(817, 'https://ror.org/00yeama42', 'no_lang_code', 1, 'https://ror.org/00yeama42 Compact Membrane Systems (United States)'),
(818, 'https://ror.org/00yep6g06', 'en', 1, 'https://ror.org/00yep6g06 Kaiser Foundation Hospital'),
(819, 'https://ror.org/00yesn553', 'en', 1, 'https://ror.org/00yesn553 Iranian Institute for Health Sciences Research'),
(820, 'https://ror.org/00yeysh84', 'en', 1, 'https://ror.org/00yeysh84 Lake Superior State University Université d''État du lac supérieur'),
(821, 'https://ror.org/00yghrj63', 'en', 1, 'https://ror.org/00yghrj63 Hendrix College'),
(822, 'https://ror.org/00ygzyy93', 'en', 1, 'https://ror.org/00ygzyy93 Independent University of Moscow Независимый Московский университет'),
(823, 'https://ror.org/00yhnba62', 'en', 1, 'https://ror.org/00yhnba62 Qatar University Universidad de Catar جامعة قطر'),
(824, 'https://ror.org/00yj3jn96', 'en', 1, 'https://ror.org/00yj3jn96 Hunterdon Medical Center'),
(825, 'https://ror.org/00ykktm91', 'pt', 1, 'https://ror.org/00ykktm91 Instituto Superior de Línguas e Administração'),
(826, 'https://ror.org/00ym4dr28', 'pt', 1, 'https://ror.org/00ym4dr28 Hospital Militar Principal'),
(827, 'https://ror.org/00yp6m473', 'en', 1, 'https://ror.org/00yp6m473 Udmurt State University Удмуртский государственный университет'),
(828, 'https://ror.org/00ys1hz88', 'en', 1, 'https://ror.org/00ys1hz88 Nagaoka University of Technology 長岡技術科学大学'),
(829, 'https://ror.org/00ysvbp68', 'en', 1, 'https://ror.org/00ysvbp68 Institute of Post Graduate Medical Education and Research'),
(830, 'https://ror.org/00yw5v481', 'en', 1, 'https://ror.org/00yw5v481 Prince George''s Community College'),
(831, 'https://ror.org/00yx91b22', 'en', 1, 'https://ror.org/00yx91b22 Barnsley Hospital NHS Foundation Trust'),
(832, 'https://ror.org/00yyp2526', 'en', 1, 'https://ror.org/00yyp2526 Silsoe Research Institute'),
(833, 'https://ror.org/00z0drp11', 'no_lang_code', 1, 'https://ror.org/00z0drp11 Agnico Eagle (Canada)'),
(834, 'https://ror.org/00z0ne711', 'en', 1, 'https://ror.org/00z0ne711 Saint Francis Hospital'),
(835, 'https://ror.org/00z0xmg52', 'it', 1, 'https://ror.org/00z0xmg52 Ospedale Santa Maria alle Scotte Santa Maria alle Scotte Hospital'),
(836, 'https://ror.org/00z1vyk43', 'en', 1, 'https://ror.org/00z1vyk43 King Fahd Armed Forces Hospital مستشفى الملك فهد للقوات المسلحة'),
(837, 'https://ror.org/00z28d984', 'it', 1, 'https://ror.org/00z28d984 Azienda ospedaliera "Bianchi-Melacrino-Morelli"'),
(838, 'https://ror.org/00z2qhk53', 'en', 1, 'https://ror.org/00z2qhk53 University of Wisconsin–Superior Université du Wisconsin–Superior'),
(839, 'https://ror.org/00z769k62', 'pt', 1, 'https://ror.org/00z769k62 Hospital de Faro EPE'),
(840, 'https://ror.org/00z847107', 'pt', 1, 'https://ror.org/00z847107 Escola Superior de Educação de Torres Novas'),
(841, 'https://ror.org/00z9qkg54', 'en', 1, 'https://ror.org/00z9qkg54 Highland Hospital'),
(842, 'https://ror.org/00z9zsj19', 'en', 1, 'https://ror.org/00z9zsj19 Butler Hospital'),
(843, 'https://ror.org/00zat6v61', 'en', 1, 'https://ror.org/00zat6v61 Guangzhou Medical University 广州医科大学'),
(844, 'https://ror.org/00zb26x20', 'en', 1, 'https://ror.org/00zb26x20 Ural State University of Economics Уральский государственный экономический университет'),
(845, 'https://ror.org/00zbht122', 'es', 1, 'https://ror.org/00zbht122 Hospital Xeral Calde'),
(846, 'https://ror.org/00zc7y345', 'pt', 1, 'https://ror.org/00zc7y345 Hospital de São José'),
(847, 'https://ror.org/00zcy2665', 'en', 1, 'https://ror.org/00zcy2665 Vestfold University College'),
(848, 'https://ror.org/00zdnkx70', 'en', 1, 'https://ror.org/00zdnkx70 National Tsing Hua University'),
(849, 'https://ror.org/00zfzef50', 'en', 1, 'https://ror.org/00zfzef50 National Development and Research Institutes'),
(850, 'https://ror.org/00zhvdn11', 'en', 1, 'https://ror.org/00zhvdn11 Tunghai University 東海大學'),
(851, 'https://ror.org/00zjtek40', 'tr', 1, 'https://ror.org/00zjtek40 Dicle Üniversitesi Hastaneleri'),
(852, 'https://ror.org/00znqwq11', 'en', 1, 'https://ror.org/00znqwq11 VA San Diego Healthcare System'),
(853, 'https://ror.org/00zpz3d35', 'en', 1, 'https://ror.org/00zpz3d35 Nevill Hall Hospital'),
(854, 'https://ror.org/00zq17821', 'en', 1, 'https://ror.org/00zq17821 General Hospital of Athens G. Genimatas'),
(855, 'https://ror.org/00zrn3e14', 'es', 1, 'https://ror.org/00zrn3e14 Hospital del Salvador'),
(856, 'https://ror.org/00zszzj16', 'en', 1, 'https://ror.org/00zszzj16 Al Amal Hospital Jeddah'),
(857, 'https://ror.org/00ztyx381', 'en', 1, 'https://ror.org/00ztyx381 Latrobe Regional Hospital'),
(858, 'https://ror.org/00zydn239', 'tr', 1, 'https://ror.org/00zydn239 Adana Numune Eğitim ve Araştırma Hastanesi'),
(859, 'https://ror.org/00zyk6d86', 'es', 1, 'https://ror.org/00zyk6d86 Hospital Alto Deba'),
(860, 'https://ror.org/00zz54311', 'en', 1, 'https://ror.org/00zz54311 Australian Centre for Sexual Health'),
(861, 'https://ror.org/00zzcmy73', 'en', 1, 'https://ror.org/00zzcmy73 Hellenic Red Cross Ελληνικός Ερυθρός Σταυρός'),
(862, 'https://ror.org/0101aa973', 'en', 1, 'https://ror.org/0101aa973 Hollywood Private Hospital'),
(863, 'https://ror.org/0103a0295', 'no_lang_code', 1, 'https://ror.org/0103a0295 Teleflex (Canada)'),
(864, 'https://ror.org/0103dxn66', 'no_lang_code', 1, 'https://ror.org/0103dxn66 Shanghai Changzheng Hospital');
INSERT INTO `rors` VALUES
(865, 'https://ror.org/0103jbm17', 'en', 1, 'https://ror.org/0103jbm17 Golden Jubilee National Hospital'),
(866, 'https://ror.org/010567a58', 'fr', 1, 'https://ror.org/010567a58 Centre Hospitalier Universitaire Amiens-Picardie'),
(867, 'https://ror.org/01056ge55', 'en', 1, 'https://ror.org/01056ge55 Canisius College'),
(868, 'https://ror.org/0105k4695', 'no_lang_code', 1, 'https://ror.org/0105k4695 Novogene Bioinformatics Institute'),
(869, 'https://ror.org/0107t3e14', 'en', 1, 'https://ror.org/0107t3e14 Akron Children''s Hospital'),
(870, 'https://ror.org/010826a91', 'en', 1, 'https://ror.org/010826a91 Shanghai Ninth People''s Hospital 上海第九人民医院'),
(871, 'https://ror.org/0108e1t34', 'en', 1, 'https://ror.org/0108e1t34 Applied Research and Communications Fund'),
(872, 'https://ror.org/0108gdg43', 'en', 1, 'https://ror.org/0108gdg43 Sri Ramachandra Institute of Higher Education and Research श्री रामचंद्र मेडिकल कालिज एवं अनुसंधान संस्थान சிறீ இராமச்சந்திரா மருத்துவக் கல்லூரி மற்றும் ஆய்வுக் கழகம்'),
(873, 'https://ror.org/010acrp16', 'en', 1, 'https://ror.org/010acrp16 University of West Alabama'),
(874, 'https://ror.org/010bdq555', 'en', 1, 'https://ror.org/010bdq555 Michigan Health Council'),
(875, 'https://ror.org/010bsbc18', 'pt', 1, 'https://ror.org/010bsbc18 Hospital Prof. Dr. Fernando Fonseca'),
(876, 'https://ror.org/010bv4c75', 'no_lang_code', 1, 'https://ror.org/010bv4c75 Tsukuba Memorial Hospital 筑波記念病院'),
(877, 'https://ror.org/010d4kb47', 'it', 1, 'https://ror.org/010d4kb47 Ospedale Sant''Anna'),
(878, 'https://ror.org/010ezwq65', 'no_lang_code', 1, 'https://ror.org/010ezwq65 Praxis (United States)'),
(879, 'https://ror.org/010gbda42', 'en', 1, 'https://ror.org/010gbda42 Government Medical College and Hospital'),
(880, 'https://ror.org/010gckf65', 'en', 1, 'https://ror.org/010gckf65 Sikkim Manipal University'),
(881, 'https://ror.org/010gpfc02', 'no', 1, 'https://ror.org/010gpfc02 Bærum Sykehus'),
(882, 'https://ror.org/010h7bv12', 'no_lang_code', 1, 'https://ror.org/010h7bv12 Integrated Plant Genetics (United States)'),
(883, 'https://ror.org/010hq5p48', 'it', 1, 'https://ror.org/010hq5p48 Ospedale Sacro Cuore Don Calabria'),
(884, 'https://ror.org/010jskt71', 'en', 1, 'https://ror.org/010jskt71 Embry–Riddle Aeronautical University'),
(885, 'https://ror.org/010jx2260', 'en', 1, 'https://ror.org/010jx2260 National Institute of Agricultural Botany'),
(886, 'https://ror.org/010kthv55', 'no_lang_code', 1, 'https://ror.org/010kthv55 Nakadōri General Hospital 中通総合病院'),
(887, 'https://ror.org/010md9d18', 'en', 1, 'https://ror.org/010md9d18 Oklahoma City VA Medical Center'),
(888, 'https://ror.org/010n41y16', 'en', 1, 'https://ror.org/010n41y16 Southeast Missouri State University'),
(889, 'https://ror.org/010njnb56', 'en', 1, 'https://ror.org/010njnb56 Craig Hospital'),
(890, 'https://ror.org/010ns0q29', 'en', 1, 'https://ror.org/010ns0q29 North Memorial Medical Center'),
(891, 'https://ror.org/010q6ek40', 'tr', 1, 'https://ror.org/010q6ek40 Haseki Eğitim ve Araştırma Hastanesi'),
(892, 'https://ror.org/010s72f83', 'en', 1, 'https://ror.org/010s72f83 South Infirmary Victoria University Hospital'),
(893, 'https://ror.org/010tb3a87', 'en', 1, 'https://ror.org/010tb3a87 Nagatomi Neurosurgical Hospital 永冨脳神経外科病院'),
(894, 'https://ror.org/010tmdc88', 'it', 1, 'https://ror.org/010tmdc88 Ospedale Maggiore Carlo Alberto Pizzardi'),
(895, 'https://ror.org/010wh8q62', 'en', 1, 'https://ror.org/010wh8q62 Raja Isteri Pengiran Anak Saleha Hospital'),
(896, 'https://ror.org/010zy0m59', 'en', 1, 'https://ror.org/010zy0m59 Kemerovo State Medical Academy Кемеровская государственная медицинская академия'),
(897, 'https://ror.org/0112eam10', 'en', 1, 'https://ror.org/0112eam10 Canadian Institute for Health Information'),
(898, 'https://ror.org/0112t7451', 'en', 1, 'https://ror.org/0112t7451 Presidio Ospedaliero San Salvatore - Pesaro San Salvatore Hospital'),
(899, 'https://ror.org/0116mdr21', 'en', 1, 'https://ror.org/0116mdr21 Graduate Hospital'),
(900, 'https://ror.org/0119j8n26', 'no_lang_code', 1, 'https://ror.org/0119j8n26 Glsynthesis'),
(901, 'https://ror.org/011ac6r71', 'en', 1, 'https://ror.org/011ac6r71 Glanrhyd Hospital'),
(902, 'https://ror.org/011apjk30', 'fr', 1, 'https://ror.org/011apjk30 Centre Hospitalier Universitaire Brugmann'),
(903, 'https://ror.org/011as4z76', 'fr', 1, 'https://ror.org/011as4z76 Centre Hospitalier Jean-Rostand'),
(904, 'https://ror.org/011bdtx65', 'en', 1, 'https://ror.org/011bdtx65 Cheng Shiu University'),
(905, 'https://ror.org/011ezgm44', 'en', 1, 'https://ror.org/011ezgm44 Dowling College'),
(906, 'https://ror.org/011fkz177', 'en', 1, 'https://ror.org/011fkz177 St. Luke''s Hospital'),
(907, 'https://ror.org/011hn1c89', 'en', 1, 'https://ror.org/011hn1c89 National Hospital of Sri Lanka'),
(908, 'https://ror.org/011hz4254', 'en', 1, 'https://ror.org/011hz4254 CRUK/MRC Oxford Institute for Radiation Oncology'),
(909, 'https://ror.org/011jgwj89', 'en', 1, 'https://ror.org/011jgwj89 Iranian Academy of Medical Sciences فرهنگستان علوم پزشکی جمهوری اسلامی ایران‎‎'),
(910, 'https://ror.org/011mkef94', 'en', 1, 'https://ror.org/011mkef94 Kaiser Permanente Walnut Creek Medical Center'),
(911, 'https://ror.org/011p8xd65', 'en', 1, 'https://ror.org/011p8xd65 Prince Philip Dental Hospital 菲臘牙科醫院'),
(912, 'https://ror.org/011qwff60', 'en', 1, 'https://ror.org/011qwff60 Riverview Medical Center'),
(913, 'https://ror.org/011r34n61', 'en', 1, 'https://ror.org/011r34n61 Indira Gandhi Government Medical College & Hospital इंदिरा गांधी शासकीय वैद्यकीय महाविद्यालय व रुग्णालय'),
(914, 'https://ror.org/011r8ce56', 'en', 1, 'https://ror.org/011r8ce56 Linyi People''s Hospital 临沂市人民医院'),
(915, 'https://ror.org/011t2cn48', 'en', 1, 'https://ror.org/011t2cn48 St. Luke''s-Roosevelt Hospital Center'),
(916, 'https://ror.org/011tm7n37', 'no_lang_code', 1, 'https://ror.org/011tm7n37 Panasonic (Japan) パナソニック'),
(917, 'https://ror.org/011tz3351', 'en', 1, 'https://ror.org/011tz3351 Queens Hospital Center'),
(918, 'https://ror.org/011x7hd11', 'de', 1, 'https://ror.org/011x7hd11 München Klinik Bogenhausen'),
(919, 'https://ror.org/011xca688', 'en', 1, 'https://ror.org/011xca688 Himeji Dokkyo University 姫路獨協大学'),
(920, 'https://ror.org/011xhcs96', 'en', 1, 'https://ror.org/011xhcs96 Affiliated Hospital of Xuzhou Medical College'),
(921, 'https://ror.org/011ygts35', 'en', 1, 'https://ror.org/011ygts35 University Clinic of Traumatology'),
(922, 'https://ror.org/0120mb525', 'nl', 1, 'https://ror.org/0120mb525 Spaarne Ziekenhuis'),
(923, 'https://ror.org/0120w8n36', 'en', 1, 'https://ror.org/0120w8n36 Muhlenberg Regional Medical Center'),
(924, 'https://ror.org/01233dh94', 'en', 1, 'https://ror.org/01233dh94 Prince Philip Hospital'),
(925, 'https://ror.org/01244fm76', 'en', 1, 'https://ror.org/01244fm76 University of Tennessee at Martin'),
(926, 'https://ror.org/0124e9159', 'sv', 1, 'https://ror.org/0124e9159 Hallands sjukhus Kungsbacka'),
(927, 'https://ror.org/0125csy75', 'de', 1, 'https://ror.org/0125csy75 Klinikum Region Hannover'),
(928, 'https://ror.org/0127ytz78', 'en', 1, 'https://ror.org/0127ytz78 Anqing Normal University 安庆师范学院'),
(929, 'https://ror.org/012ae7p27', 'no_lang_code', 1, 'https://ror.org/012ae7p27 Italtel (Italy)'),
(930, 'https://ror.org/012bh1w56', 'fr', 1, 'https://ror.org/012bh1w56 Hôpital 20 Août'),
(931, 'https://ror.org/012bk6h61', 'da', 1, 'https://ror.org/012bk6h61 Medicinsk-historisk Museum i Næstved'),
(932, 'https://ror.org/012dxyr07', 'en', 1, 'https://ror.org/012dxyr07 University of Agriculture in Krakow Uniwersytet Rolniczy im. Hugona Kołłątaja w Krakowie'),
(933, 'https://ror.org/012eghd53', 'en', 1, 'https://ror.org/012eghd53 Rotorua Hospital'),
(934, 'https://ror.org/012gg9483', 'pt', 1, 'https://ror.org/012gg9483 Universidade Cidade de São Paulo'),
(935, 'https://ror.org/012habm93', 'pt', 1, 'https://ror.org/012habm93 Hospital de Egas Moniz'),
(936, 'https://ror.org/012nfex57', 'no_lang_code', 1, 'https://ror.org/012nfex57 Rakuwakai Otowa Hospital 洛和会音羽病院'),
(937, 'https://ror.org/012nkbb42', 'en', 1, 'https://ror.org/012nkbb42 St Vincent''s Health'),
(938, 'https://ror.org/012p63287', 'en', 1, 'https://ror.org/012p63287 Rijksuniversiteit Groningen University of Groningen'),
(939, 'https://ror.org/012qr1y49', 'en', 1, 'https://ror.org/012qr1y49 Ministry of Health وزارة الصحة'),
(940, 'https://ror.org/012r5qt14', 'en', 1, 'https://ror.org/012r5qt14 Manitoba Pork Council'),
(941, 'https://ror.org/012vbac09', 'en', 1, 'https://ror.org/012vbac09 Doctors Medical Center'),
(942, 'https://ror.org/012wm7481', 'no_lang_code', 1, 'https://ror.org/012wm7481 Huadong Hospital 复旦大学附属华东医院'),
(943, 'https://ror.org/012yc3523', 'no_lang_code', 1, 'https://ror.org/012yc3523 COM DEV International'),
(944, 'https://ror.org/012zkqp76', 'en', 1, 'https://ror.org/012zkqp76 Delaware Division of Public Health'),
(945, 'https://ror.org/0133j5m54', 'en', 1, 'https://ror.org/0133j5m54 Skellefteå Hospital Skellefteå Lasarett'),
(946, 'https://ror.org/0137gef36', 'no_lang_code', 1, 'https://ror.org/0137gef36 Yogi Vemana University யோகி வேமனா பல்கலைக்கழகம் యోగి వేమన విశ్వవిద్యాలయం'),
(947, 'https://ror.org/01381hr71', 'no_lang_code', 1, 'https://ror.org/01381hr71 Golder Associates (Canada)'),
(948, 'https://ror.org/0138ysz16', 'en', 1, 'https://ror.org/0138ysz16 Gifu Municipal Hospital 岐阜市民病院'),
(949, 'https://ror.org/013e0zm98', 'en', 1, 'https://ror.org/013e0zm98 Beijing Technology and Business University 北京工商大学'),
(950, 'https://ror.org/013e4n276', 'en', 1, 'https://ror.org/013e4n276 Beijing Tongren Hospital 首都医科大学附属北京同仁医院'),
(951, 'https://ror.org/013e76m06', 'no_lang_code', 1, 'https://ror.org/013e76m06 Kangbuk Samsung Hospital 강북삼성병원'),
(952, 'https://ror.org/013e81n30', 'en', 1, 'https://ror.org/013e81n30 University of Alberta Hospital'),
(953, 'https://ror.org/013ennz48', 'en', 1, 'https://ror.org/013ennz48 Lesley University'),
(954, 'https://ror.org/013habd96', 'en', 1, 'https://ror.org/013habd96 Twin Cities Public Television'),
(955, 'https://ror.org/013pk4y14', 'en', 1, 'https://ror.org/013pk4y14 Kazan State Medical University Казанский государственный медицинский университет'),
(956, 'https://ror.org/013pz1582', 'en', 1, 'https://ror.org/013pz1582 Lewis & Clark College'),
(957, 'https://ror.org/013q2cj53', 'en', 1, 'https://ror.org/013q2cj53 Universeum'),
(958, 'https://ror.org/013qdbe28', 'tr', 1, 'https://ror.org/013qdbe28 Ankara Numune Eğitim ve Araştırma Hastanesi'),
(959, 'https://ror.org/013qhbw17', 'fr', 1, 'https://ror.org/013qhbw17 Hôpital Mongi Slim'),
(960, 'https://ror.org/013s4zk47', 'en', 1, 'https://ror.org/013s4zk47 Hiroshima General Hospital 広島総合病院'),
(961, 'https://ror.org/013sgak22', 'en', 1, 'https://ror.org/013sgak22 Northwest Community Hospital'),
(962, 'https://ror.org/013vyke20', 'en', 1, 'https://ror.org/013vyke20 Environment Agency Austria Umweltbundesamt'),
(963, 'https://ror.org/013vzz882', 'en', 1, 'https://ror.org/013vzz882 Indraprastha Apollo Hospitals'),
(964, 'https://ror.org/013wvjj62', 'en', 1, 'https://ror.org/013wvjj62 Yokohama Welfare Service Association'),
(965, 'https://ror.org/013x5cp73', 'en', 1, 'https://ror.org/013x5cp73 Johns Hopkins All Children''s Hospital'),
(966, 'https://ror.org/013zjb662', 'en', 1, 'https://ror.org/013zjb662 National University of Kaohsiung'),
(967, 'https://ror.org/01435q086', 'es', 1, 'https://ror.org/01435q086 Hospital Universitario Fundación Alcorcón'),
(968, 'https://ror.org/014405c23', 'pt', 1, 'https://ror.org/014405c23 Hospital do Espírito Santo'),
(969, 'https://ror.org/0149j8908', 'pt', 1, 'https://ror.org/0149j8908 Universidade Santa Úrsula'),
(970, 'https://ror.org/014f77s28', 'en', 1, 'https://ror.org/014f77s28 Cheng Hsin General Hospital'),
(971, 'https://ror.org/014fz7968', 'en', 1, 'https://ror.org/014fz7968 Sojo University 崇城大学'),
(972, 'https://ror.org/014gqa478', 'en', 1, 'https://ror.org/014gqa478 University Health Care System'),
(973, 'https://ror.org/014haym76', 'no_lang_code', 1, 'https://ror.org/014haym76 Fukuoka Tokushukai Hospital 福岡徳洲会病院'),
(974, 'https://ror.org/014mgn481', 'no_lang_code', 1, 'https://ror.org/014mgn481 Maizuru Municipal Hospital 市立舞鶴市民病院'),
(975, 'https://ror.org/014n7rf11', 'en', 1, 'https://ror.org/014n7rf11 Moscow State Aviation Technological University Российский государственный технологический университет имени К. Э. Циолковского'),
(976, 'https://ror.org/014nx0w70', 'es', 1, 'https://ror.org/014nx0w70 Hospital Universitario Austral'),
(977, 'https://ror.org/014tckg45', 'en', 1, 'https://ror.org/014tckg45 Crichton Royal Hospital'),
(978, 'https://ror.org/014ttpa29', 'en', 1, 'https://ror.org/014ttpa29 Bangour Village Hospital'),
(979, 'https://ror.org/014v12a39', 'es', 1, 'https://ror.org/014v12a39 Health Research Institute of the Hospital Clínico San Carlos Instituto de Investigación Sanitaria del Hospital Clínico San Carlos'),
(980, 'https://ror.org/014v2t028', 'en', 1, 'https://ror.org/014v2t028 Shandong Pingyi Tianyu Museum of Natural History 山东省天宇自然博物馆'),
(981, 'https://ror.org/014wfj781', 'en', 1, 'https://ror.org/014wfj781 Jacksonville State University Université d''État de jacksonville'),
(982, 'https://ror.org/014x8q810', 'de', 1, 'https://ror.org/014x8q810 Centre for Solar Energy and Hydrogen Research Baden-Württemberg Zentrum für Sonnenenergie- und Wasserstoff-Forschung Baden-Württemberg'),
(983, 'https://ror.org/014xqzt56', 'no_lang_code', 1, 'https://ror.org/014xqzt56 Boramae Medical Center 보라매 병원'),
(984, 'https://ror.org/01509dj67', 'en', 1, 'https://ror.org/01509dj67 MedStar Franklin Square Medical Center'),
(985, 'https://ror.org/0150ewf57', 'en', 1, 'https://ror.org/0150ewf57 Dhaka Medical College and Hospital ঢাকা মেডিকেল কলেজ'),
(986, 'https://ror.org/015178j52', 'en', 1, 'https://ror.org/015178j52 Wested'),
(987, 'https://ror.org/0152bt112', 'en', 1, 'https://ror.org/0152bt112 Health Sciences and Nutrition'),
(988, 'https://ror.org/0152hn881', 'en', 1, 'https://ror.org/0152hn881 Tianjin Medical University Cancer Institute and Hospital 天津医科大学肿瘤医院'),
(989, 'https://ror.org/0152ray34', 'no_lang_code', 1, 'https://ror.org/0152ray34 Maharat Nakhon Ratchasima Hospital โรงพยาบาลมหาราชนครราชสีมา'),
(990, 'https://ror.org/015566d55', 'en', 1, 'https://ror.org/015566d55 University of Azad Jammu and Kashmir'),
(991, 'https://ror.org/015803449', 'en', 1, 'https://ror.org/015803449 South London and Maudsley NHS Foundation Trust'),
(992, 'https://ror.org/0159cmf83', 'en', 1, 'https://ror.org/0159cmf83 St Peter''s Hospital'),
(993, 'https://ror.org/015a1ak54', 'en', 1, 'https://ror.org/015a1ak54 York College, City University of New York'),
(994, 'https://ror.org/015a6df35', 'no_lang_code', 1, 'https://ror.org/015a6df35 En Chu Kong Hospital 行天宮醫療志業醫療財團法人恩主公醫院'),
(995, 'https://ror.org/015b6az38', 'en', 1, 'https://ror.org/015b6az38 Mackay Memorial Hospital 馬偕紀念醫院'),
(996, 'https://ror.org/015dyrs73', 'en', 1, 'https://ror.org/015dyrs73 Queen Elizabeth Hospital'),
(997, 'https://ror.org/015e6tf70', 'en', 1, 'https://ror.org/015e6tf70 Madonna Rehabilitation Hospital'),
(998, 'https://ror.org/015h2da09', 'en', 1, 'https://ror.org/015h2da09 Boston Public Health Commission'),
(999, 'https://ror.org/015j35893', 'en', 1, 'https://ror.org/015j35893 English Heritage'),
(1000, 'https://ror.org/015nmh932', 'no_lang_code', 1, 'https://ror.org/015nmh932 Kai Research (United States)'),
(1001, 'https://ror.org/015nth639', 'en', 1, 'https://ror.org/015nth639 MRC Cancer Unit'),
(1002, 'https://ror.org/015nymp25', 'en', 1, 'https://ror.org/015nymp25 Edith Nourse Rogers Memorial Veterans Hospital'),
(1003, 'https://ror.org/015qjqf64', 'en', 1, 'https://ror.org/015qjqf64 Stiftung Tierärztliche Hochschule Hannover University of Veterinary Medicine Hannover, Foundation'),
(1004, 'https://ror.org/015qmyq14', 'en', 1, 'https://ror.org/015qmyq14 Catholic University of Health and Allied Sciences'),
(1005, 'https://ror.org/015rc4h95', 'en', 1, 'https://ror.org/015rc4h95 Hamanomachi Hospital 浜の町病院'),
(1006, 'https://ror.org/015tmw922', 'en', 1, 'https://ror.org/015tmw922 Providence Portland Medical Center'),
(1007, 'https://ror.org/015v9d997', 'en', 1, 'https://ror.org/015v9d997 Jeonju University 전주대학교'),
(1008, 'https://ror.org/015yzft41', 'pt', 1, 'https://ror.org/015yzft41 Instituto Superior Politécnico do Oeste'),
(1009, 'https://ror.org/01600wh70', 'en', 1, 'https://ror.org/01600wh70 University of Toledo Medical Center'),
(1010, 'https://ror.org/01605g366', 'en', 1, 'https://ror.org/01605g366 Kyoto City Hospital 京都市立病院'),
(1011, 'https://ror.org/01616f936', 'en', 1, 'https://ror.org/01616f936 Jefferson College of Health Sciences'),
(1012, 'https://ror.org/0163qhr63', 'en', 1, 'https://ror.org/0163qhr63 Hanusch Hospital Hanusch-Krankenhaus'),
(1013, 'https://ror.org/0166mge61', 'es', 1, 'https://ror.org/0166mge61 Hospital San Juan de Dios'),
(1014, 'https://ror.org/01673gn35', 'en', 1, 'https://ror.org/01673gn35 Affiliated Hospital of North Sichuan Medical College 川北医学院附属医院'),
(1015, 'https://ror.org/0167c0661', 'no_lang_code', 1, 'https://ror.org/0167c0661 Exodus (Greece)'),
(1016, 'https://ror.org/01683nj06', 'en', 1, 'https://ror.org/01683nj06 Mangla Hospital and Research Center'),
(1017, 'https://ror.org/01692sz90', 'no_lang_code', 1, 'https://ror.org/01692sz90 Juntendo University 順天堂大学'),
(1018, 'https://ror.org/0169n7f49', 'en', 1, 'https://ror.org/0169n7f49 251 Γενικό Νοσοκομείο Αεροπορίας Hellenic Airforce General Hospital'),
(1019, 'https://ror.org/016a0n751', 'en', 1, 'https://ror.org/016a0n751 Azerbaijan Medical University Azərbaycan Tibb Universiteti Азербайджанский медицинский университет'),
(1020, 'https://ror.org/016bbv872', 'en', 1, 'https://ror.org/016bbv872 Hahnemann University Hospital'),
(1021, 'https://ror.org/016c9ds94', 'en', 1, 'https://ror.org/016c9ds94 Kanagawa Prefectural Institute of Public Health 神奈川県衛生研究所'),
(1022, 'https://ror.org/016dxxy13', 'en', 1, 'https://ror.org/016dxxy13 Ministry of Health กระทรวงสาธารณสุข'),
(1023, 'https://ror.org/016jc2h42', 'en', 1, 'https://ror.org/016jc2h42 Sint Lucas Andreas Hospital Sint Lucas Andreas Ziekenhuis'),
(1024, 'https://ror.org/016je1253', 'en', 1, 'https://ror.org/016je1253 Government Medical College'),
(1025, 'https://ror.org/016m8pd54', 'en', 1, 'https://ror.org/016m8pd54 Morgan Stanley Children''s Hospital'),
(1026, 'https://ror.org/016nh4b93', 'en', 1, 'https://ror.org/016nh4b93 Mercy Children''s Hospital'),
(1027, 'https://ror.org/016qd7r37', 'es', 1, 'https://ror.org/016qd7r37 Hospital Universitario de Maracaibo'),
(1028, 'https://ror.org/016tyxe19', 'en', 1, 'https://ror.org/016tyxe19 New Mexico Highlands University'),
(1029, 'https://ror.org/016v1bv58', 'es', 1, 'https://ror.org/016v1bv58 Hospital Clínico de la Universidad Católica'),
(1030, 'https://ror.org/016yv6y68', 'en', 1, 'https://ror.org/016yv6y68 Dakota State University'),
(1031, 'https://ror.org/016zre027', 'en', 1, 'https://ror.org/016zre027 University of Ontario Institute of Technology'),
(1032, 'https://ror.org/01703db54', 'en', 1, 'https://ror.org/01703db54 National Institute of Advanced Industrial Science and Technology 産業技術総合研究所'),
(1033, 'https://ror.org/0171atz91', 'no_lang_code', 1, 'https://ror.org/0171atz91 Iogen Corporation'),
(1034, 'https://ror.org/01735bk60', 'sv', 1, 'https://ror.org/01735bk60 Göteborgs barnsjukhus'),
(1035, 'https://ror.org/017383496', 'en', 1, 'https://ror.org/017383496 Aultman Hospital'),
(1036, 'https://ror.org/0176arq92', 'en', 1, 'https://ror.org/0176arq92 Milwaukee VA Medical Center'),
(1037, 'https://ror.org/0176jt031', 'en', 1, 'https://ror.org/0176jt031 Huston–Tillotson University'),
(1038, 'https://ror.org/0176wfg98', 'en', 1, 'https://ror.org/0176wfg98 Gleneagles Hospital'),
(1039, 'https://ror.org/0176x9269', 'no_lang_code', 1, 'https://ror.org/0176x9269 Hatyai Hospital โรงพยาบาลหาดใหญ่'),
(1040, 'https://ror.org/0176yjw32', 'pt', 1, 'https://ror.org/0176yjw32 Federal University of Minas Gerais Universidade Federal de Minas Gerais Université fédérale du minas gerais'),
(1041, 'https://ror.org/01786mp71', 'en', 1, 'https://ror.org/01786mp71 Institute of Agrobiological Sciences 生物機能利用研究部門'),
(1042, 'https://ror.org/017b7j426', 'no_lang_code', 1, 'https://ror.org/017b7j426 Altera (United States)'),
(1043, 'https://ror.org/017c6at71', 'en', 1, 'https://ror.org/017c6at71 University of North Carolina at Asheville'),
(1044, 'https://ror.org/017c9f638', 'en', 1, 'https://ror.org/017c9f638 Burwood Hospital'),
(1045, 'https://ror.org/017dm4063', 'en', 1, 'https://ror.org/017dm4063 Departamento de Salud Pública del Condado de Los Ángeles Los Angeles County Department of Public Health'),
(1046, 'https://ror.org/017g36q02', 'en', 1, 'https://ror.org/017g36q02 Municipality of Amaroussion'),
(1047, 'https://ror.org/017h1mj21', 'en', 1, 'https://ror.org/017h1mj21 Kaiser Permanente Hayward Medical Center'),
(1048, 'https://ror.org/017hkng22', 'en', 1, 'https://ror.org/017hkng22 Ehime University 愛媛大学'),
(1049, 'https://ror.org/017j2n938', 'en', 1, 'https://ror.org/017j2n938 Kobe Central Hospital 神戸中央病院'),
(1050, 'https://ror.org/017kgtg39', 'en', 1, 'https://ror.org/017kgtg39 Fukuoka Children''s Hospital and Medical Center for Infectious Diseases 福岡市立こども病院'),
(1051, 'https://ror.org/017m05e51', 'en', 1, 'https://ror.org/017m05e51 Health Policy Alternatives, Inc.'),
(1052, 'https://ror.org/017ph0934', 'en', 1, 'https://ror.org/017ph0934 Ulusal ve Uluslararası Ekonomi Üniversitesi University of National and World Economy Университет за национално и световно стопанство'),
(1053, 'https://ror.org/017pz3h73', 'en', 1, 'https://ror.org/017pz3h73 Urban Institute'),
(1054, 'https://ror.org/017q2rt66', 'en', 1, 'https://ror.org/017q2rt66 Mercy University Hospital'),
(1055, 'https://ror.org/017t1dh18', 'fr', 1, 'https://ror.org/017t1dh18 Hôpital Max Fourestier'),
(1056, 'https://ror.org/017vgxg86', 'no_lang_code', 1, 'https://ror.org/017vgxg86 Ford (Germany)'),
(1057, 'https://ror.org/017wcm924', 'en', 1, 'https://ror.org/017wcm924 University System of Georgia'),
(1058, 'https://ror.org/017xnm587', 'en', 1, 'https://ror.org/017xnm587 Soongsil University 숭실대학교'),
(1059, 'https://ror.org/017ztfb41', 'en', 1, 'https://ror.org/017ztfb41 San Francisco Department of Public Health'),
(1060, 'https://ror.org/01818mf51', 'no_lang_code', 1, 'https://ror.org/01818mf51 Messerschmitt-Bölkow-Blohm (Germany)'),
(1061, 'https://ror.org/018224621', 'en', 1, 'https://ror.org/018224621 American Academy of Arts and Sciences'),
(1062, 'https://ror.org/018224j82', 'en', 1, 'https://ror.org/018224j82 Buena Vista University'),
(1063, 'https://ror.org/0183m5185', 'en', 1, 'https://ror.org/0183m5185 Wonkwang University Medical Center 원광대학교병원'),
(1064, 'https://ror.org/0184gbk60', 'en', 1, 'https://ror.org/0184gbk60 Steinbeis Foundation Steinbeis-Stiftung'),
(1065, 'https://ror.org/0184p1881', 'en', 1, 'https://ror.org/0184p1881 Nevada Department of Health and Human Services'),
(1066, 'https://ror.org/0187t0j49', 'en', 1, 'https://ror.org/0187t0j49 John Hunter Hospital'),
(1067, 'https://ror.org/018dx8725', 'en', 1, 'https://ror.org/018dx8725 Sparrow Hospital'),
(1068, 'https://ror.org/018k7fz65', 'en', 1, 'https://ror.org/018k7fz65 Ministry of Health ក្រសួងសុខាភិបាល'),
(1069, 'https://ror.org/018mgzn65', 'en', 1, 'https://ror.org/018mgzn65 Baylor Medical Center at Garland'),
(1070, 'https://ror.org/018pq0b08', 'no_lang_code', 1, 'https://ror.org/018pq0b08 Niigata Prefectural Central Hospital 新潟県立中央病院'),
(1071, 'https://ror.org/018s10n18', 'en', 1, 'https://ror.org/018s10n18 Jewish Hospital'),
(1072, 'https://ror.org/018s6xs98', 'en', 1, 'https://ror.org/018s6xs98 International Cooperative Administrative Support Services'),
(1073, 'https://ror.org/018txrr13', 'en', 1, 'https://ror.org/018txrr13 VA Ann Arbor Healthcare System'),
(1074, 'https://ror.org/018vqfn69', 'en', 1, 'https://ror.org/018vqfn69 Matsunami General Hospital 松波病院'),
(1075, 'https://ror.org/0190kj665', 'es', 1, 'https://ror.org/0190kj665 Hospital General de Granollers'),
(1076, 'https://ror.org/0193sb042', 'en', 1, 'https://ror.org/0193sb042 Henry Ford Hospital Hôpital henry ford'),
(1077, 'https://ror.org/0195twz09', 'en', 1, 'https://ror.org/0195twz09 St. Luke''s Episcopal Hospital'),
(1078, 'https://ror.org/019621n74', 'en', 1, 'https://ror.org/019621n74 Public Health Institute'),
(1079, 'https://ror.org/019641589', 'en', 1, 'https://ror.org/019641589 Inje University Haeundae Paik Hospital 인제 대학교 해운대 백병원'),
(1080, 'https://ror.org/019br0e98', 'no_lang_code', 1, 'https://ror.org/019br0e98 Metabolic Solutions'),
(1081, 'https://ror.org/019bxes45', 'en', 1, 'https://ror.org/019bxes45 University Dental Hospital of Manchester'),
(1082, 'https://ror.org/019bz1656', 'en', 1, 'https://ror.org/019bz1656 Clinical Center University of Sarajevo'),
(1083, 'https://ror.org/019e4d354', 'en', 1, 'https://ror.org/019e4d354 Government Medical College ਸਰਕਾਰੀ ਮੈਡੀਕਲ ਕਾਲਜ'),
(1084, 'https://ror.org/019e4dr88', 'en', 1, 'https://ror.org/019e4dr88 Erie County Medical Center'),
(1085, 'https://ror.org/019f36t97', 'en', 1, 'https://ror.org/019f36t97 Royal Berkshire Hospital'),
(1086, 'https://ror.org/019hb9542', 'en', 1, 'https://ror.org/019hb9542 St Helier Hospital'),
(1087, 'https://ror.org/019ja9e37', 'no_lang_code', 1, 'https://ror.org/019ja9e37 Atomic Energy (Canada) Énergie atomique du Canada'),
(1088, 'https://ror.org/019k4jq75', 'en', 1, 'https://ror.org/019k4jq75 Brooklyn College College de Brooklyn de la Universidad de la Ciudad de Nueva York'),
(1089, 'https://ror.org/019kgqr73', 'en', 1, 'https://ror.org/019kgqr73 The University of Texas at Arlington Université du Texas à Arlington'),
(1090, 'https://ror.org/019krky16', 'en', 1, 'https://ror.org/019krky16 Medical Group Management Association'),
(1091, 'https://ror.org/019my5047', 'en', 1, 'https://ror.org/019my5047 Royal London Hospital'),
(1092, 'https://ror.org/019myg640', 'de', 1, 'https://ror.org/019myg640 Krankenanstalt Rudolfstiftung der Stadt Wien'),
(1093, 'https://ror.org/019rjbt98', 'en', 1, 'https://ror.org/019rjbt98 Colorado Department of Public Health and Environment'),
(1094, 'https://ror.org/019s1t671', 'en', 1, 'https://ror.org/019s1t671 Montgomery County Department of Health and Human Services'),
(1095, 'https://ror.org/019tq3436', 'en', 1, 'https://ror.org/019tq3436 Far Eastern Memorial Hospital'),
(1096, 'https://ror.org/019tstz42', 'sv', 1, 'https://ror.org/019tstz42 Ersta sjukhus'),
(1097, 'https://ror.org/019wt1929', 'en', 1, 'https://ror.org/019wt1929 Sheffield Hallam University'),
(1098, 'https://ror.org/019x0cx75', 'no_lang_code', 1, 'https://ror.org/019x0cx75 Science and Engineering Services (United States)'),
(1099, 'https://ror.org/019z71f50', 'en', 1, 'https://ror.org/019z71f50 National Taipei University of Nursing and Health Science 國立臺北護理健康大學'),
(1100, 'https://ror.org/019z9dk17', 'en', 1, 'https://ror.org/019z9dk17 Mount Elizabeth Hospital மவுண்ட் எலிசபெத் மருத்துவமனை'),
(1101, 'https://ror.org/019zp2770', 'en', 1, 'https://ror.org/019zp2770 Upstate University Hospital'),
(1102, 'https://ror.org/01a0h9c53', 'no_lang_code', 1, 'https://ror.org/01a0h9c53 Kingston Process Metallurgy (Canada)'),
(1103, 'https://ror.org/01a1mbs69', 'en', 1, 'https://ror.org/01a1mbs69 Princess of Wales Hospital'),
(1104, 'https://ror.org/01a1x1d92', 'no_lang_code', 1, 'https://ror.org/01a1x1d92 Ruttonjee Hospital 律敦治醫院'),
(1105, 'https://ror.org/01a3mef16', 'en', 1, 'https://ror.org/01a3mef16 Pondicherry University पॉन्डिचेरी विश्वविद्यालय புதுவைப் பல்கலைக்கழகம் పాండిచ్చేరి విశ్వవిద్యాలయం പോണ്ടിച്ചേരി സർവകലാശാല'),
(1106, 'https://ror.org/01a3zyd02', 'it', 1, 'https://ror.org/01a3zyd02 Ospedale Regionale di Locarno'),
(1107, 'https://ror.org/01a423692', 'no_lang_code', 1, 'https://ror.org/01a423692 Aastrom Biosciences (United States)'),
(1108, 'https://ror.org/01a4bac78', 'en', 1, 'https://ror.org/01a4bac78 Cantox Health Sciences International'),
(1109, 'https://ror.org/01a4d6k20', 'en', 1, 'https://ror.org/01a4d6k20 Jawaharlal Nehru Medical College'),
(1110, 'https://ror.org/01a4gqp27', 'en', 1, 'https://ror.org/01a4gqp27 Harry S. Truman Memorial Veterans'' Hospital'),
(1111, 'https://ror.org/01a6tsm75', 'en', 1, 'https://ror.org/01a6tsm75 Hillel Yaffe Medical Center'),
(1112, 'https://ror.org/01adsjd47', 'no_lang_code', 1, 'https://ror.org/01adsjd47 Seonam University'),
(1113, 'https://ror.org/01aeq1t78', 'en', 1, 'https://ror.org/01aeq1t78 Shriners Hospitals for Children - Cincinnati'),
(1114, 'https://ror.org/01agth861', 'en', 1, 'https://ror.org/01agth861 American Association of Physics Teachers'),
(1115, 'https://ror.org/01akfrh45', 'no_lang_code', 1, 'https://ror.org/01akfrh45 Farwaniya Hospital مستشفى الفروانية'),
(1116, 'https://ror.org/01ans1m53', 'no_lang_code', 1, 'https://ror.org/01ans1m53 SomaGenics (United States)'),
(1117, 'https://ror.org/01apd5369', 'en', 1, 'https://ror.org/01apd5369 John Paul II Hospital Krakowski Szpital Specjalistyczny im. Jana Pawła II'),
(1118, 'https://ror.org/01apvbh93', 'en', 1, 'https://ror.org/01apvbh93 Akademiska sjukhuset Uppsala University Hospital'),
(1119, 'https://ror.org/01ar9e455', 'en', 1, 'https://ror.org/01ar9e455 The Aerospace Corporation'),
(1120, 'https://ror.org/01aryec24', 'en', 1, 'https://ror.org/01aryec24 Southeastern Oklahoma State University'),
(1121, 'https://ror.org/01as10d06', 'en', 1, 'https://ror.org/01as10d06 Harrisburg Hospital'),
(1122, 'https://ror.org/01atr9m08', 'no_lang_code', 1, 'https://ror.org/01atr9m08 Biotex (United States)'),
(1123, 'https://ror.org/01atwky19', 'en', 1, 'https://ror.org/01atwky19 North Oaks Health System'),
(1124, 'https://ror.org/01aw2gs83', 'en', 1, 'https://ror.org/01aw2gs83 Nagasaki Kawatana Medical Center 国立病院機構長崎川棚医療センター'),
(1125, 'https://ror.org/01ayg2409', 'no_lang_code', 1, 'https://ror.org/01ayg2409 Juniata College'),
(1126, 'https://ror.org/01ayqmq97', 'en', 1, 'https://ror.org/01ayqmq97 Rajendra Hospital'),
(1127, 'https://ror.org/01azs0t89', 'es', 1, 'https://ror.org/01azs0t89 Hospital Carmen y Severo Ochoa'),
(1128, 'https://ror.org/01b1c8m98', 'en', 1, 'https://ror.org/01b1c8m98 Ministry of Health وزارة الصحة'),
(1129, 'https://ror.org/01b1r6152', 'en', 1, 'https://ror.org/01b1r6152 Kowloon Hospital 九龍醫院'),
(1130, 'https://ror.org/01b2c5015', 'es', 1, 'https://ror.org/01b2c5015 Hospital Sierrallana'),
(1131, 'https://ror.org/01b2wv937', 'en', 1, 'https://ror.org/01b2wv937 New York State Office of Mental Health'),
(1132, 'https://ror.org/01b330649', 'no_lang_code', 1, 'https://ror.org/01b330649 Nova Research Company (United States)'),
(1133, 'https://ror.org/01b3dvp57', 'en', 1, 'https://ror.org/01b3dvp57 Garvan Institute of Medical Research'),
(1134, 'https://ror.org/01b5d7p48', 'no_lang_code', 1, 'https://ror.org/01b5d7p48 Schlumberger (France)'),
(1135, 'https://ror.org/01b6d9h22', 'hr', 1, 'https://ror.org/01b6d9h22 Klinička bolnica Merkur'),
(1136, 'https://ror.org/01b78mz79', 'pt', 1, 'https://ror.org/01b78mz79 Federal University of Santa Maria Universidad Federal de Santa María Universidade Federal de Santa Maria'),
(1137, 'https://ror.org/01b8f4h92', 'no_lang_code', 1, 'https://ror.org/01b8f4h92 Athens Technology Center (Greece)'),
(1138, 'https://ror.org/01b8kcc49', 'en', 1, 'https://ror.org/01b8kcc49 National Cheng Kung University'),
(1139, 'https://ror.org/01banz567', 'en', 1, 'https://ror.org/01banz567 Kyushu University of Health and Welfare 九州保健福祉大学'),
(1140, 'https://ror.org/01bbs6821', 'en', 1, 'https://ror.org/01bbs6821 Fisk University Universidad de Fisk'),
(1141, 'https://ror.org/01bbyhp53', 'en', 1, 'https://ror.org/01bbyhp53 Basingstoke and North Hampshire Hospital'),
(1142, 'https://ror.org/01bchmt70', 'fr', 1, 'https://ror.org/01bchmt70 Centre Hospitalier d''Orsay'),
(1143, 'https://ror.org/01bcp3a67', 'en', 1, 'https://ror.org/01bcp3a67 Benenden Hospital'),
(1144, 'https://ror.org/01bdr6121', 'en', 1, 'https://ror.org/01bdr6121 University of Guilan دانشگاه گیلان'),
(1145, 'https://ror.org/01bgafn72', 'no_lang_code', 1, 'https://ror.org/01bgafn72 Hamad General Hospital'),
(1146, 'https://ror.org/01bgds823', 'en', 1, 'https://ror.org/01bgds823 Affiliated Hospital of Chengde Medical College 承德医学院附属医院'),
(1147, 'https://ror.org/01bhkfn26', 'en', 1, 'https://ror.org/01bhkfn26 Southern Command Hospital'),
(1148, 'https://ror.org/01bk73674', 'en', 1, 'https://ror.org/01bk73674 Chengdu Military General Hospital 中国人民解放军成都军区总医院'),
(1149, 'https://ror.org/01bkdwe73', 'pt', 1, 'https://ror.org/01bkdwe73 Hospital Heliópolis'),
(1150, 'https://ror.org/01bmj6z20', 'en', 1, 'https://ror.org/01bmj6z20 Maesot General Hospital โรงพยาบาลแม่สอด'),
(1151, 'https://ror.org/01bn4rh74', 'en', 1, 'https://ror.org/01bn4rh74 Heritage Valley Beaver'),
(1152, 'https://ror.org/01bnyxq20', 'es', 1, 'https://ror.org/01bnyxq20 Hospital Ramos Mejía'),
(1153, 'https://ror.org/01bry7z39', 'en', 1, 'https://ror.org/01bry7z39 Northwest Nazarene University'),
(1154, 'https://ror.org/01bt82v32', 'en', 1, 'https://ror.org/01bt82v32 Northern Light Mercy Hospital'),
(1155, 'https://ror.org/01bthtp68', 'no_lang_code', 1, 'https://ror.org/01bthtp68 Corixa Corporation'),
(1156, 'https://ror.org/01btjc831', 'it', 1, 'https://ror.org/01btjc831 Ospedale San Giacomo Apostolo'),
(1157, 'https://ror.org/01bvmk374', 'no_lang_code', 1, 'https://ror.org/01bvmk374 GIUNTI Intenational Division (Italy)'),
(1158, 'https://ror.org/01bw9xe44', 'en', 1, 'https://ror.org/01bw9xe44 Academy of Georgofili Accademia dei Georgofili'),
(1159, 'https://ror.org/01bx8ja67', 'no_lang_code', 1, 'https://ror.org/01bx8ja67 Maharaja Sayajirao University of Baroda મહારાજા સયાજીરાવ વિશ્વવિદ્યાલય மகாராஜா சாயாஜிராவ் பல்கலைக்கழகம்'),
(1160, 'https://ror.org/01by1qv45', 'en', 1, 'https://ror.org/01by1qv45 Santa Casa Hospital'),
(1161, 'https://ror.org/01byf4846', 'es', 1, 'https://ror.org/01byf4846 Fundación Hospital de Jove'),
(1162, 'https://ror.org/01bywqg69', 'no_lang_code', 1, 'https://ror.org/01bywqg69 Automotive Fuel Cell Cooperation (Canada)'),
(1163, 'https://ror.org/01bzpky79', 'en', 1, 'https://ror.org/01bzpky79 Ajou University Hospital 아주 대학교 병원'),
(1164, 'https://ror.org/01c2dee93', 'en', 1, 'https://ror.org/01c2dee93 Baystate Franklin Medical Center'),
(1165, 'https://ror.org/01c2wzp81', 'tr', 1, 'https://ror.org/01c2wzp81 Dr Lütfi Kırdar Kartal Eğitim ve Araştırma Hastanesi'),
(1166, 'https://ror.org/01c3hyk82', 'en', 1, 'https://ror.org/01c3hyk82 Shih Chien University'),
(1167, 'https://ror.org/01c524129', 'en', 1, 'https://ror.org/01c524129 King Fahd Military Medical Complex'),
(1168, 'https://ror.org/01c5cqy87', 'en', 1, 'https://ror.org/01c5cqy87 General Hospital of Serres Γενικό Νοσοκομείο Σερρών'),
(1169, 'https://ror.org/01c5j0443', 'fr', 1, 'https://ror.org/01c5j0443 Institut d''Économie Rurale'),
(1170, 'https://ror.org/01c74sd89', 'no_lang_code', 1, 'https://ror.org/01c74sd89 STMicroelectronics (France)'),
(1171, 'https://ror.org/01c804c94', 'no_lang_code', 1, 'https://ror.org/01c804c94 First Point Scientific'),
(1172, 'https://ror.org/01cb0kd74', 'en', 1, 'https://ror.org/01cb0kd74 Royal Hospital for Children'),
(1173, 'https://ror.org/01cgbsh11', 'en', 1, 'https://ror.org/01cgbsh11 Hutt Hospital'),
(1174, 'https://ror.org/01ch4qb51', 'en', 1, 'https://ror.org/01ch4qb51 Mercy Hospital for Women'),
(1175, 'https://ror.org/01cjd8n57', 'no_lang_code', 1, 'https://ror.org/01cjd8n57 Nagasaki Rousai Hospital 長崎労災病院'),
(1176, 'https://ror.org/01ckz8750', 'no_lang_code', 1, 'https://ror.org/01ckz8750 Lickenbrock'),
(1177, 'https://ror.org/01cmpkr67', 'no_lang_code', 1, 'https://ror.org/01cmpkr67 Materials Modification (United States)'),
(1178, 'https://ror.org/01cpcy908', 'en', 1, 'https://ror.org/01cpcy908 McLaren Regional Medical Center'),
(1179, 'https://ror.org/01cqcrc47', 'en', 1, 'https://ror.org/01cqcrc47 Rangsit University มหาวิทยาลัยรังสิต'),
(1180, 'https://ror.org/01cqmqj90', 'en', 1, 'https://ror.org/01cqmqj90 Hadassah Medical Center مركز هداسا الطبي'),
(1181, 'https://ror.org/01cqx0m58', 'en', 1, 'https://ror.org/01cqx0m58 Centro Italiano Ricerche Aerospaziali Italian Aerospace Research Centre'),
(1182, 'https://ror.org/01cqxk816', 'en', 1, 'https://ror.org/01cqxk816 University of West Georgia'),
(1183, 'https://ror.org/01ctb0h41', 'en', 1, 'https://ror.org/01ctb0h41 Triangle Coalition For Science and Technology Education'),
(1184, 'https://ror.org/01cv0eh48', 'en', 1, 'https://ror.org/01cv0eh48 Royal Belfast Hospital for Sick Children'),
(1185, 'https://ror.org/01cw77n16', 'en', 1, 'https://ror.org/01cw77n16 Fairfield Infectious Diseases Hospital'),
(1186, 'https://ror.org/01cwbae71', 'en', 1, 'https://ror.org/01cwbae71 Hannam University 한남대학교'),
(1187, 'https://ror.org/01cx2sj34', 'pl', 1, 'https://ror.org/01cx2sj34 Centrum Medyczne Kształcenia Podyplomowego'),
(1188, 'https://ror.org/01cyv3m84', 'en', 1, 'https://ror.org/01cyv3m84 Ospedale di Santa Maria Nuova Santa Maria Nuova Hospital'),
(1189, 'https://ror.org/01czx1v82', 'en', 1, 'https://ror.org/01czx1v82 Huzhou Central Hospital 湖州市中心医院'),
(1190, 'https://ror.org/01d00rw04', 'en', 1, 'https://ror.org/01d00rw04 KPC Medical College and Hospital কেপিসি মেডিকাল কলেজ ও কে এস রায় টিবি হাসপাতাল'),
(1191, 'https://ror.org/01d012874', 'es', 1, 'https://ror.org/01d012874 Clínica La Luz, Hospital La Luz'),
(1192, 'https://ror.org/01d261e32', 'en', 1, 'https://ror.org/01d261e32 Furness General Hospital'),
(1193, 'https://ror.org/01d2e9e05', 'en', 1, 'https://ror.org/01d2e9e05 Maternity and Children''s Hospital'),
(1194, 'https://ror.org/01d2sy711', 'no_lang_code', 1, 'https://ror.org/01d2sy711 E-One Moli Energy (Canada)'),
(1195, 'https://ror.org/01d3gh658', 'en', 1, 'https://ror.org/01d3gh658 Centraal Militair Hospitaal Central Military Hospital'),
(1196, 'https://ror.org/01d59nd22', 'en', 1, 'https://ror.org/01d59nd22 Federal Ministry of Health وزارة الصحة الإتحادية'),
(1197, 'https://ror.org/01d692d57', 'en', 1, 'https://ror.org/01d692d57 University of Sindh سندھ یونیورسٹی'),
(1198, 'https://ror.org/01d86hn60', 'it', 1, 'https://ror.org/01d86hn60 Ospedale San Carlo'),
(1199, 'https://ror.org/01d9cs377', 'en', 1, 'https://ror.org/01d9cs377 University Health System'),
(1200, 'https://ror.org/01dcrt245', 'en', 1, 'https://ror.org/01dcrt245 Dubai Health Authority هيئة الصحة بدبي'),
(1201, 'https://ror.org/01defpn95', 'en', 1, 'https://ror.org/01defpn95 Sathyabama Institute of Science and Technology சத்யபாமா ப‌ல்கலைக்கழகம் సత్యభామ విశ్వవిద్యాలయం'),
(1202, 'https://ror.org/01df9ep43', 'en', 1, 'https://ror.org/01df9ep43 Era''s Lucknow Medical College and Hospital'),
(1203, 'https://ror.org/01dgc8k02', 'it', 1, 'https://ror.org/01dgc8k02 Ospedale Cristo Re'),
(1204, 'https://ror.org/01dgn5344', 'en', 1, 'https://ror.org/01dgn5344 Rider University Universidad Rider Université de rider'),
(1205, 'https://ror.org/01djnr762', 'no_lang_code', 1, 'https://ror.org/01djnr762 Dalsa Corporation'),
(1206, 'https://ror.org/01dk3f134', 'no_lang_code', 1, 'https://ror.org/01dk3f134 Tokyo Metropolitan Bokutoh Hospital 東京都立墨東病院'),
(1207, 'https://ror.org/01dk7q852', 'no_lang_code', 1, 'https://ror.org/01dk7q852 Cardiovascular Center Hokkaido Ohno Hospital 心臓血管センター北海道大野病院'),
(1208, 'https://ror.org/01dkn0c77', 'pt', 1, 'https://ror.org/01dkn0c77 Hospital Santa Izabel'),
(1209, 'https://ror.org/01dkvrg87', 'en', 1, 'https://ror.org/01dkvrg87 Sabbatsberg Hospital Sabbatsbergs Sjukhus'),
(1210, 'https://ror.org/01dm04760', 'en', 1, 'https://ror.org/01dm04760 Lexington VA Health Care System'),
(1211, 'https://ror.org/01dm18990', 'en', 1, 'https://ror.org/01dm18990 Lakeshore Hospital'),
(1212, 'https://ror.org/01dmyj570', 'en', 1, 'https://ror.org/01dmyj570 Shriners Hospitals for Children - Northern California'),
(1213, 'https://ror.org/01dpw6893', 'en', 1, 'https://ror.org/01dpw6893 Scripps Memorial Hospital'),
(1214, 'https://ror.org/01dqhdd78', 'en', 1, 'https://ror.org/01dqhdd78 Clatterbridge Hospital Ysbyty Clattebridge'),
(1215, 'https://ror.org/01dspcb60', 'en', 1, 'https://ror.org/01dspcb60 Jiangxi Provincial People''s Hospital 江西省人民医院'),
(1216, 'https://ror.org/01dsw4m23', 'en', 1, 'https://ror.org/01dsw4m23 Repatriation General Hospital'),
(1217, 'https://ror.org/01dsy9055', 'en', 1, 'https://ror.org/01dsy9055 University Hospital Ayr'),
(1218, 'https://ror.org/01dszvc69', 'en', 1, 'https://ror.org/01dszvc69 Sapporo Azabu Neurosurgical Hospital 札幌麻生脳神経外科病院'),
(1219, 'https://ror.org/01dxm2p72', 'no_lang_code', 1, 'https://ror.org/01dxm2p72 Saipem (Italy) Società Anonima Italiana Perforazioni E Montaggi'),
(1220, 'https://ror.org/01dzpsy49', 'en', 1, 'https://ror.org/01dzpsy49 Nara City Hospital 市立奈良病院'),
(1221, 'https://ror.org/01e2avb80', 'en', 1, 'https://ror.org/01e2avb80 Prince George''s Hospital Center'),
(1222, 'https://ror.org/01e320272', 'fr', 1, 'https://ror.org/01e320272 Hôpital Saint-Philibert'),
(1223, 'https://ror.org/01e4pq116', 'fr', 1, 'https://ror.org/01e4pq116 Hôpital Saint Charles'),
(1224, 'https://ror.org/01e4pq504', 'en', 1, 'https://ror.org/01e4pq504 Portland Community College'),
(1225, 'https://ror.org/01e4z3q24', 'en', 1, 'https://ror.org/01e4z3q24 Priest Hospital โรงพยาบาลสงฆ์'),
(1226, 'https://ror.org/01e5t7e46', 'no_lang_code', 1, 'https://ror.org/01e5t7e46 Nanomaterials Research (United States)'),
(1227, 'https://ror.org/01e87ch81', 'en', 1, 'https://ror.org/01e87ch81 Oregon Museum of Science and Industry'),
(1228, 'https://ror.org/01ec7xj20', 'en', 1, 'https://ror.org/01ec7xj20 Jaswant Rai Speciality Hospital'),
(1229, 'https://ror.org/01ecnnp60', 'en', 1, 'https://ror.org/01ecnnp60 Jackson State University Université d''État de Jackson'),
(1230, 'https://ror.org/01eedy375', 'en', 1, 'https://ror.org/01eedy375 Alabama State University'),
(1231, 'https://ror.org/01eeehv22', 'no_lang_code', 1, 'https://ror.org/01eeehv22 Bell Helicopter Textron (Canada)'),
(1232, 'https://ror.org/01eff5662', 'en', 1, 'https://ror.org/01eff5662 Beijing Chao-Yang Hospital 北京朝阳医院'),
(1233, 'https://ror.org/01efrfk30', 'en', 1, 'https://ror.org/01efrfk30 Stetson University'),
(1234, 'https://ror.org/01egdsz94', 'en', 1, 'https://ror.org/01egdsz94 Baptist Health System'),
(1235, 'https://ror.org/01egmr022', 'no_lang_code', 1, 'https://ror.org/01egmr022 Nantong Tumor Hospital 南通市肿瘤医院'),
(1236, 'https://ror.org/01ej92a17', 'en', 1, 'https://ror.org/01ej92a17 Sandviken Hospital Sandviken sykehus'),
(1237, 'https://ror.org/01ejxf797', 'en', 1, 'https://ror.org/01ejxf797 Mohamed I University Université Mohammed Ier جامعة محمد الأول'),
(1238, 'https://ror.org/01ek0ym72', 'pl', 1, 'https://ror.org/01ek0ym72 4. Wojskowy Szpital Kliniczny z Polikliniką'),
(1239, 'https://ror.org/01ekg2j77', 'en', 1, 'https://ror.org/01ekg2j77 Blood Systems Research Institute'),
(1240, 'https://ror.org/01eksj726', 'en', 1, 'https://ror.org/01eksj726 Konyang University Hospital 한양 대학교 병원'),
(1241, 'https://ror.org/01emnh554', 'no_lang_code', 1, 'https://ror.org/01emnh554 Saga-Ken Medical Centre Koseikan 佐賀県医療センター好生館'),
(1242, 'https://ror.org/01emtgd92', 'en', 1, 'https://ror.org/01emtgd92 Mansfield University'),
(1243, 'https://ror.org/01emxrg90', 'pt', 1, 'https://ror.org/01emxrg90 Hospital Pedro Hispano'),
(1244, 'https://ror.org/01eq8c489', 'en', 1, 'https://ror.org/01eq8c489 Lady Reading Hospital'),
(1245, 'https://ror.org/01eqjmz45', 'en', 1, 'https://ror.org/01eqjmz45 Hokko Memorial Hospital 北光記念病院'),
(1246, 'https://ror.org/01es3w453', 'no_lang_code', 1, 'https://ror.org/01es3w453 Northwest Media (United States)'),
(1247, 'https://ror.org/01espdw89', 'en', 1, 'https://ror.org/01espdw89 Beijing Chest Hospital'),
(1248, 'https://ror.org/01ev5nj79', 'es', 1, 'https://ror.org/01ev5nj79 Hospital Médica Sur'),
(1249, 'https://ror.org/01ev6gy70', 'en', 1, 'https://ror.org/01ev6gy70 Escola Naval Portuguese Naval School'),
(1250, 'https://ror.org/01evb6z23', 'en', 1, 'https://ror.org/01evb6z23 King University'),
(1251, 'https://ror.org/01ew49p77', 'en', 1, 'https://ror.org/01ew49p77 Malcom Randall VA Medical Center'),
(1252, 'https://ror.org/01eyb5f38', 'en', 1, 'https://ror.org/01eyb5f38 Kern Medical Center'),
(1253, 'https://ror.org/01f4y0525', 'en', 1, 'https://ror.org/01f4y0525 College of Medical Sciences'),
(1254, 'https://ror.org/01f97j659', 'en', 1, 'https://ror.org/01f97j659 Anyang Academy of Agricultural Sciences 安阳市农业科学院'),
(1255, 'https://ror.org/01fbdn283', 'en', 1, 'https://ror.org/01fbdn283 Magee-Womens Hospital'),
(1256, 'https://ror.org/01fbz6h17', 'en', 1, 'https://ror.org/01fbz6h17 Denver Health Medical Center'),
(1257, 'https://ror.org/01fd8g905', 'en', 1, 'https://ror.org/01fd8g905 University of Montevallo'),
(1258, 'https://ror.org/01fkbmk11', 'en', 1, 'https://ror.org/01fkbmk11 Maritime Research Institute Netherlands'),
(1259, 'https://ror.org/01fksx040', 'en', 1, 'https://ror.org/01fksx040 Gaustad Hospital Gaustad Sykehus'),
(1260, 'https://ror.org/01fm87m50', 'en', 1, 'https://ror.org/01fm87m50 Rambam Health Care Campus רמב"ם - הקריה הרפואית לבריאות האדם‎ مشفى رمبام'),
(1261, 'https://ror.org/01fmz4h16', 'no_lang_code', 1, 'https://ror.org/01fmz4h16 Hirosakiaiseikai Hospital 弘前愛成会病院'),
(1262, 'https://ror.org/01fpnj063', 'en', 1, 'https://ror.org/01fpnj063 Catholic University of Korea 가톨릭대학교'),
(1263, 'https://ror.org/01fv1ds98', 'no_lang_code', 1, 'https://ror.org/01fv1ds98 Yuan Ze University'),
(1264, 'https://ror.org/01fvf0d84', 'en', 1, 'https://ror.org/01fvf0d84 Tajen University'),
(1265, 'https://ror.org/01fvnb423', 'en', 1, 'https://ror.org/01fvnb423 Presbyterian Medical Center 예수병원'),
(1266, 'https://ror.org/01fxd7077', 'en', 1, 'https://ror.org/01fxd7077 Center for Health Care Law'),
(1267, 'https://ror.org/01fxdkm29', 'en', 1, 'https://ror.org/01fxdkm29 Doshisha University 同志社大学'),
(1268, 'https://ror.org/01fzm0693', 'en', 1, 'https://ror.org/01fzm0693 Abbott Northwestern Hospital'),
(1269, 'https://ror.org/01g171x08', 'en', 1, 'https://ror.org/01g171x08 Alice Ho Miu Ling Nethersole Hospital 雅麗氏何妙齡那打素醫院'),
(1270, 'https://ror.org/01g246z62', 'en', 1, 'https://ror.org/01g246z62 International Union of Railways Union internationale des chemins de fer'),
(1271, 'https://ror.org/01g2xkw11', 'pt', 1, 'https://ror.org/01g2xkw11 Instituto Superior de Gestão e Administração de Santarém'),
(1272, 'https://ror.org/01g312x22', 'no_lang_code', 1, 'https://ror.org/01g312x22 BG Group (United Kingdom)'),
(1273, 'https://ror.org/01g3pwn65', 'en', 1, 'https://ror.org/01g3pwn65 Mississippi Department of Mental Health'),
(1274, 'https://ror.org/01g63ab19', 'en', 1, 'https://ror.org/01g63ab19 Northside Hospital'),
(1275, 'https://ror.org/01g67by91', 'en', 1, 'https://ror.org/01g67by91 Mercer University Health Sciences Center'),
(1276, 'https://ror.org/01gaptw32', 'es', 1, 'https://ror.org/01gaptw32 Hospital de Hellín'),
(1277, 'https://ror.org/01gcc9p15', 'en', 1, 'https://ror.org/01gcc9p15 Saint John''s Health Center'),
(1278, 'https://ror.org/01gd3da15', 'no_lang_code', 1, 'https://ror.org/01gd3da15 Stantec (Canada)'),
(1279, 'https://ror.org/01gezbc84', 'en', 1, 'https://ror.org/01gezbc84 Japanese Red Cross Medical Center 日本赤十字社医療センター'),
(1280, 'https://ror.org/01ggyr403', 'en', 1, 'https://ror.org/01ggyr403 Canadian Foundation for Healthcare Improvement'),
(1281, 'https://ror.org/01ghsr491', 'no_lang_code', 1, 'https://ror.org/01ghsr491 Trevigen'),
(1282, 'https://ror.org/01gqe3t73', 'no_lang_code', 1, 'https://ror.org/01gqe3t73 Sangji University 상지대학교'),
(1283, 'https://ror.org/01grdhw06', 'en', 1, 'https://ror.org/01grdhw06 Center for Tuberculosis Control of Guangdong Province 广东省结核病控制'),
(1284, 'https://ror.org/01grq2104', 'en', 1, 'https://ror.org/01grq2104 Torrey Pines Institute For Molecular Studies'),
(1285, 'https://ror.org/01gst4g14', 'en', 1, 'https://ror.org/01gst4g14 New York City Department of Health and Mental Hygiene'),
(1286, 'https://ror.org/01gt7sg63', 'pt', 1, 'https://ror.org/01gt7sg63 Universidade de Taubaté University of Taubaté');
INSERT INTO `rors` VALUES
(1287, 'https://ror.org/01gvfxs59', 'en', 1, 'https://ror.org/01gvfxs59 National Sagamihara Hospital 国立病院機構相模原病院'),
(1288, 'https://ror.org/01gxs7p86', 'en', 1, 'https://ror.org/01gxs7p86 Christiana Hospital'),
(1289, 'https://ror.org/01gynte55', 'en', 1, 'https://ror.org/01gynte55 Sharp Memorial Hospital'),
(1290, 'https://ror.org/01gzkdv90', 'en', 1, 'https://ror.org/01gzkdv90 Kun Shan University'),
(1291, 'https://ror.org/01h0x7c18', 'en', 1, 'https://ror.org/01h0x7c18 PBR Laboratories'),
(1292, 'https://ror.org/01h22ap11', 'en', 1, 'https://ror.org/01h22ap11 Penn State Milton S. Hershey Medical Center'),
(1293, 'https://ror.org/01h29af62', 'no_lang_code', 1, 'https://ror.org/01h29af62 Spartan Bioscience (Canada)'),
(1294, 'https://ror.org/01h2hg078', 'en', 1, 'https://ror.org/01h2hg078 Birjand University of Medical Sciences دانشگاه علوم پزشکی بیرجند'),
(1295, 'https://ror.org/01h2jcs31', 'en', 1, 'https://ror.org/01h2jcs31 Jewish Hospital'),
(1296, 'https://ror.org/01h4hqc60', 'en', 1, 'https://ror.org/01h4hqc60 Transylvania University'),
(1297, 'https://ror.org/01h6pd645', 'no_lang_code', 1, 'https://ror.org/01h6pd645 SurModics (United States)'),
(1298, 'https://ror.org/01h89k731', 'no_lang_code', 1, 'https://ror.org/01h89k731 TXT e-solutions (Italy)'),
(1299, 'https://ror.org/01h9xtf29', 'no_lang_code', 1, 'https://ror.org/01h9xtf29 Friday Systems (United States)'),
(1300, 'https://ror.org/01h9y0t02', 'en', 1, 'https://ror.org/01h9y0t02 Mount Sinai Hospital'),
(1301, 'https://ror.org/01ha5h612', 'en', 1, 'https://ror.org/01ha5h612 Princess Margaret Rose Orthopaedic Hospital'),
(1302, 'https://ror.org/01ha6bm93', 'no_lang_code', 1, 'https://ror.org/01ha6bm93 Progenra (United States)'),
(1303, 'https://ror.org/01hcyya48', 'en', 1, 'https://ror.org/01hcyya48 Cincinnati Children''s Hospital Medical Center'),
(1304, 'https://ror.org/01hhasq22', 'cs', 1, 'https://ror.org/01hhasq22 Výzkumný Ústav Zdraví Dítěte'),
(1305, 'https://ror.org/01hhczc28', 'en', 1, 'https://ror.org/01hhczc28 University of Benin Teaching Hospital'),
(1306, 'https://ror.org/01hkncq81', 'en', 1, 'https://ror.org/01hkncq81 Hiroshima City Asa Citizens Hospital 広島市立安佐市民病院'),
(1307, 'https://ror.org/01hs43g67', 'en', 1, 'https://ror.org/01hs43g67 Mississippi University for Women'),
(1308, 'https://ror.org/01hssm416', 'en', 1, 'https://ror.org/01hssm416 St John''s Hospital'),
(1309, 'https://ror.org/01hsw0492', 'en', 1, 'https://ror.org/01hsw0492 Gesellschaft für Chemische Technik und Biotechnologie Society for Chemical Engineering and Biotechnology'),
(1310, 'https://ror.org/01hy1ab69', 'en', 1, 'https://ror.org/01hy1ab69 Michigan Surgical Hospital'),
(1311, 'https://ror.org/01hy4qx27', 'en', 1, 'https://ror.org/01hy4qx27 University of Minnesota, Duluth'),
(1312, 'https://ror.org/01hyxtd05', 'no_lang_code', 1, 'https://ror.org/01hyxtd05 Neova Technologies Inc.'),
(1313, 'https://ror.org/01hzdv945', 'en', 1, 'https://ror.org/01hzdv945 Chaudhary Charan Singh University चौधरी चरण सिंह विश्वविद्यालय சௌதரி சரண் சிங் பல்கலைக்கழகம்'),
(1314, 'https://ror.org/01j0n2h15', 'en', 1, 'https://ror.org/01j0n2h15 Universidad de Phoenix University of Phoenix Université de phoenix'),
(1315, 'https://ror.org/01j0qa041', 'it', 1, 'https://ror.org/01j0qa041 Ospedali Riuniti di Ancona'),
(1316, 'https://ror.org/01j17xg39', 'en', 1, 'https://ror.org/01j17xg39 New York Hospital Queens'),
(1317, 'https://ror.org/01j25h453', 'en', 1, 'https://ror.org/01j25h453 Kelowna General Hospital'),
(1318, 'https://ror.org/01j6t9363', 'fr', 1, 'https://ror.org/01j6t9363 Hôpital Razi de La Manouba مستشفئ الرازي'),
(1319, 'https://ror.org/01j780996', 'de', 1, 'https://ror.org/01j780996 Leopoldina Krankenhaus Schweinfurt'),
(1320, 'https://ror.org/01j7azy31', 'tr', 1, 'https://ror.org/01j7azy31 Dr Sami Ulus Çocuk Sağlığı ve Hastalıkları Eğitim ve Araştırma Hastanesi'),
(1321, 'https://ror.org/01j8kmv80', 'en', 1, 'https://ror.org/01j8kmv80 Golmud People''s Hospital 格尔木市人民医院'),
(1322, 'https://ror.org/01ja5zt45', 'en', 1, 'https://ror.org/01ja5zt45 District of Columbia Department of Health'),
(1323, 'https://ror.org/01jaaym28', 'en', 1, 'https://ror.org/01jaaym28 Shimane University 島根大学'),
(1324, 'https://ror.org/01jckan13', 'en', 1, 'https://ror.org/01jckan13 Kin-ikyo Chuo Hospital 勤医協中央病院'),
(1325, 'https://ror.org/01jdekv92', 'en', 1, 'https://ror.org/01jdekv92 Berkeley Geochronology Center'),
(1326, 'https://ror.org/01je6q363', 'fr', 1, 'https://ror.org/01je6q363 Centre Technique Industriel De La Construction Metallique'),
(1327, 'https://ror.org/01jfr3w16', 'en', 1, 'https://ror.org/01jfr3w16 Pacific Institute For Research and Evaluation'),
(1328, 'https://ror.org/01jg3a168', 'en', 1, 'https://ror.org/01jg3a168 Gosford Hospital'),
(1329, 'https://ror.org/01jh1mm11', 'en', 1, 'https://ror.org/01jh1mm11 Istanbul Florence Nightingale Hospital İstanbul Florence Nightingale Hastanesi'),
(1330, 'https://ror.org/01jhgy173', 'en', 1, 'https://ror.org/01jhgy173 Kishiwada City Hospital 市立岸和田市民病院'),
(1331, 'https://ror.org/01jhsfg10', 'pt', 1, 'https://ror.org/01jhsfg10 Hospital de Dona Estefânia'),
(1332, 'https://ror.org/01jj26143', 'it', 1, 'https://ror.org/01jj26143 Hospital of the Holy Spirit Ospedale di Santo Spirito, Ospedale di Santo Spirito in Sassia'),
(1333, 'https://ror.org/01jj2sr90', 'en', 1, 'https://ror.org/01jj2sr90 Broward Health Medical Center'),
(1334, 'https://ror.org/01jjm6w53', 'en', 1, 'https://ror.org/01jjm6w53 Banner Desert Medical Center'),
(1335, 'https://ror.org/01jk32r56', 'no_lang_code', 1, 'https://ror.org/01jk32r56 Sirehna'),
(1336, 'https://ror.org/01jk6xr82', 'en', 1, 'https://ror.org/01jk6xr82 Rochester General Hospital'),
(1337, 'https://ror.org/01jm17996', 'en', 1, 'https://ror.org/01jm17996 Mission Heritage Medical Group'),
(1338, 'https://ror.org/01jm19r53', 'no_lang_code', 1, 'https://ror.org/01jm19r53 TuTech Innovation (Germany)'),
(1339, 'https://ror.org/01jmd7f74', 'en', 1, 'https://ror.org/01jmd7f74 Chuvash State University Чувашский государственный университет имени И. Н. Ульянова'),
(1340, 'https://ror.org/01jmsem62', 'es', 1, 'https://ror.org/01jmsem62 Hospital General Universitario de Elche'),
(1341, 'https://ror.org/01jn2rz36', 'fr', 1, 'https://ror.org/01jn2rz36 Hôpital de Jolimont'),
(1342, 'https://ror.org/01jpkw634', 'en', 1, 'https://ror.org/01jpkw634 Centro de Estudios Ambientales del Mediterráneo Mediterranean Center for Environmental Studies'),
(1343, 'https://ror.org/01jqz8f37', 'en', 1, 'https://ror.org/01jqz8f37 Wayne Memorial Health System'),
(1344, 'https://ror.org/01jtn9895', 'no_lang_code', 1, 'https://ror.org/01jtn9895 Osaka Ohtani University 大阪大谷大学'),
(1345, 'https://ror.org/01k05jx47', 'en', 1, 'https://ror.org/01k05jx47 Mercy Catholic Medical Center'),
(1346, 'https://ror.org/01k18gj34', 'en', 1, 'https://ror.org/01k18gj34 Ashworth College'),
(1347, 'https://ror.org/01k1azd31', 'no_lang_code', 1, 'https://ror.org/01k1azd31 Kumamotorosaibyoin 熊本労災病院'),
(1348, 'https://ror.org/01k1ea759', 'no_lang_code', 1, 'https://ror.org/01k1ea759 AUG Signals (Canada)'),
(1349, 'https://ror.org/01k22c722', 'en', 1, 'https://ror.org/01k22c722 Dr. V. M. Government Medical College डॉ. वैशंपायन स्मृती शासकीय वैद्यकीय महाविद्यालय'),
(1350, 'https://ror.org/01k5k4m02', 'en', 1, 'https://ror.org/01k5k4m02 Jan Evangelista Purkyně Military Medical Academy'),
(1351, 'https://ror.org/01k6vxj52', 'en', 1, 'https://ror.org/01k6vxj52 Omsk State University Омский государственный университет имени Ф. М. Достоевского'),
(1352, 'https://ror.org/01k7a6660', 'en', 1, 'https://ror.org/01k7a6660 Hennepin County Medical Center'),
(1353, 'https://ror.org/01k8ej563', 'en', 1, 'https://ror.org/01k8ej563 Keio University Hospital 慶應義塾大学病院'),
(1354, 'https://ror.org/01kbw1w05', 'no_lang_code', 1, 'https://ror.org/01kbw1w05 Infinite Biomedical Technologies (United States)'),
(1355, 'https://ror.org/01kc65v41', 'it', 1, 'https://ror.org/01kc65v41 Fondazione "Ugo Bordoni" Ugo Bordoni Foundation'),
(1356, 'https://ror.org/01kcq3761', 'en', 1, 'https://ror.org/01kcq3761 Kent Hospital'),
(1357, 'https://ror.org/01kdnph40', 'es', 1, 'https://ror.org/01kdnph40 Hospital La Paloma'),
(1358, 'https://ror.org/01kdvym37', 'de', 1, 'https://ror.org/01kdvym37 Battelle-Institut ev'),
(1359, 'https://ror.org/01kgs1r94', 'no_lang_code', 1, 'https://ror.org/01kgs1r94 Electrical Geodesics (United States)'),
(1360, 'https://ror.org/01kq6mv68', 'en', 1, 'https://ror.org/01kq6mv68 Second Affiliated Hospital of Kunming Medical College 昆明医科大学第二附属医院'),
(1361, 'https://ror.org/01kq6ye20', 'en', 1, 'https://ror.org/01kq6ye20 Sansum Diabetes Research Institute'),
(1362, 'https://ror.org/01kqjm533', 'en', 1, 'https://ror.org/01kqjm533 Kurihama Medical and Addiction Center 久里浜医療センター'),
(1363, 'https://ror.org/01kr7aq59', 'en', 1, 'https://ror.org/01kr7aq59 Rivers State University'),
(1364, 'https://ror.org/01krywm46', 'en', 1, 'https://ror.org/01krywm46 University of Virginia Children''s Hospital'),
(1365, 'https://ror.org/01ks0bt75', 'en', 1, 'https://ror.org/01ks0bt75 Seoul National University Children''s Hospital 서울대학교어린이병원'),
(1366, 'https://ror.org/01kta7d96', 'en', 1, 'https://ror.org/01kta7d96 McLean Hospital'),
(1367, 'https://ror.org/01kvp0178', 'no_lang_code', 1, 'https://ror.org/01kvp0178 Ontario Power Generation'),
(1368, 'https://ror.org/01kvtm035', 'en', 1, 'https://ror.org/01kvtm035 South Australia Pathology'),
(1369, 'https://ror.org/01kw6jz33', 'no_lang_code', 1, 'https://ror.org/01kw6jz33 BGI Group (Japan)'),
(1370, 'https://ror.org/01kxqsy59', 'no_lang_code', 1, 'https://ror.org/01kxqsy59 Atos (Spain)'),
(1371, 'https://ror.org/01ky2n109', 'pt', 1, 'https://ror.org/01ky2n109 Hospital Federal dos Servidores do Estado'),
(1372, 'https://ror.org/01kzgyz42', 'en', 1, 'https://ror.org/01kzgyz42 Qiqihar Medical University 齐齐哈尔医学院'),
(1373, 'https://ror.org/01m006041', 'en', 1, 'https://ror.org/01m006041 Thiel College'),
(1374, 'https://ror.org/01m1gv240', 'en', 1, 'https://ror.org/01m1gv240 King Fahad Specialist Hospital مستشفى الملك فهد التخصصي'),
(1375, 'https://ror.org/01m1pv723', 'en', 1, 'https://ror.org/01m1pv723 Hôpitaux universitaires de Genève University Hospital of Geneva'),
(1376, 'https://ror.org/01m1v6377', 'en', 1, 'https://ror.org/01m1v6377 Association Of Atlantic Universities'),
(1377, 'https://ror.org/01m32d953', 'en', 1, 'https://ror.org/01m32d953 Copernicus Memorial Hospital'),
(1378, 'https://ror.org/01m46xf39', 'en', 1, 'https://ror.org/01m46xf39 All India Institute of Hygiene and Public Health अखिल भारतीय स्वास्थ्य र्विज्ञान एवं जन स्वास्थ्य संस्थान'),
(1379, 'https://ror.org/01m484026', 'no_lang_code', 1, 'https://ror.org/01m484026 Smithers Pira'),
(1380, 'https://ror.org/01m7mrx20', 'es', 1, 'https://ror.org/01m7mrx20 Hospital Central Dr. Ignacio Morones Prieto'),
(1381, 'https://ror.org/01mfrg562', 'en', 1, 'https://ror.org/01mfrg562 Dauphin Island Sea Lab'),
(1382, 'https://ror.org/01mh1c318', 'en', 1, 'https://ror.org/01mh1c318 Federation of American Societies for Experimental Biology'),
(1383, 'https://ror.org/01mhbkr88', 'en', 1, 'https://ror.org/01mhbkr88 St Martha''s Regional Hospital'),
(1384, 'https://ror.org/01mpngw81', 'en', 1, 'https://ror.org/01mpngw81 Government Kilpauk Medical College கீழ்பாக்கம் மருத்துவக் கல்லூரி'),
(1385, 'https://ror.org/01mqsmm97', 'es', 1, 'https://ror.org/01mqsmm97 Hospital Regional Universitario de Málaga'),
(1386, 'https://ror.org/01mqvjv41', 'pt', 1, 'https://ror.org/01mqvjv41 Federal University of Mato Grosso Universidade Federal de Mato Grosso'),
(1387, 'https://ror.org/01msdga41', 'no_lang_code', 1, 'https://ror.org/01msdga41 Dornier Flugzeugwerke (Germany)'),
(1388, 'https://ror.org/01mtpwn71', 'no_lang_code', 1, 'https://ror.org/01mtpwn71 Adan Hospital مستشفى العدان'),
(1389, 'https://ror.org/01mvmmg68', 'en', 1, 'https://ror.org/01mvmmg68 San Jacinto Methodist Hospital'),
(1390, 'https://ror.org/01mxpdw03', 'en', 1, 'https://ror.org/01mxpdw03 First Affiliated Hospital of Guangzhou University of Chinese Medicine'),
(1391, 'https://ror.org/01myv2z03', 'en', 1, 'https://ror.org/01myv2z03 Nayoro City General Hospital 名寄市立総合病院'),
(1392, 'https://ror.org/01myv5196', 'en', 1, 'https://ror.org/01myv5196 Sivas Devlet Hastanesi Sivas State Hospital'),
(1393, 'https://ror.org/01mz9wf40', 'en', 1, 'https://ror.org/01mz9wf40 Chu Shang Show Chwan Hospital'),
(1394, 'https://ror.org/01n1j0f20', 'fr', 1, 'https://ror.org/01n1j0f20 Hôpital Aristide Le Dantec'),
(1395, 'https://ror.org/01n260e81', 'en', 1, 'https://ror.org/01n260e81 Rancho Santa Ana Botanic Garden'),
(1396, 'https://ror.org/01n2xwm51', 'en', 1, 'https://ror.org/01n2xwm51 Meyer Children''s Hospital Ospedale Pediatrico Meyer'),
(1397, 'https://ror.org/01n67jr26', 'en', 1, 'https://ror.org/01n67jr26 Forest Department Sarawak'),
(1398, 'https://ror.org/01n70p029', 'en', 1, 'https://ror.org/01n70p029 Birmingham and Midland Eye Centre'),
(1399, 'https://ror.org/01n85qf05', 'pt', 1, 'https://ror.org/01n85qf05 Escola Superior de Enfermagem S. Francisco das Misericórdias'),
(1400, 'https://ror.org/01na5rp93', 'no_lang_code', 1, 'https://ror.org/01na5rp93 Bioqual'),
(1401, 'https://ror.org/01ncx3917', 'en', 1, 'https://ror.org/01ncx3917 Rosie Hospital'),
(1402, 'https://ror.org/01nf63x62', 'en', 1, 'https://ror.org/01nf63x62 Institute of Global Environment and Society'),
(1403, 'https://ror.org/01ng1yh19', 'en', 1, 'https://ror.org/01ng1yh19 Charlie Norwood VA Medical Center'),
(1404, 'https://ror.org/01nhcyg40', 'no_lang_code', 1, 'https://ror.org/01nhcyg40 Nagoya Ekisaikai Hospital 名古屋掖済会病院'),
(1405, 'https://ror.org/01nhrc260', 'en', 1, 'https://ror.org/01nhrc260 Froedtert Hospital'),
(1406, 'https://ror.org/01nhzsw25', 'fr', 1, 'https://ror.org/01nhzsw25 Hydro-Québec'),
(1407, 'https://ror.org/01nj4ek07', 'en', 1, 'https://ror.org/01nj4ek07 Hinchingbrooke Hospital'),
(1408, 'https://ror.org/01nj8sa76', 'en', 1, 'https://ror.org/01nj8sa76 Royal Alexandra Hospital'),
(1409, 'https://ror.org/01nn35n25', 'en', 1, 'https://ror.org/01nn35n25 Institute of Accelerating Systems and Applications Ινστιτούτο Επιταχυντικών Συστημάτων και Εφαρμογών'),
(1410, 'https://ror.org/01npf0s58', 'en', 1, 'https://ror.org/01npf0s58 National Ilan University 國立宜蘭大學'),
(1411, 'https://ror.org/01nph4h53', 'no_lang_code', 1, 'https://ror.org/01nph4h53 Aerodyne Research'),
(1412, 'https://ror.org/01nr6fy72', 'en', 1, 'https://ror.org/01nr6fy72 Ljubljana University Medical Centre'),
(1413, 'https://ror.org/01nthrq77', 'es', 1, 'https://ror.org/01nthrq77 Instituto Tecnologico Del Embalaje, Transporte Y Logistica'),
(1414, 'https://ror.org/01nwsvf80', 'en', 1, 'https://ror.org/01nwsvf80 Shiga Medical Center for Children 子供のための滋賀医療センター'),
(1415, 'https://ror.org/01nxjpd08', 'en', 1, 'https://ror.org/01nxjpd08 Vladimir State University Федеральное государственное бюджетное образовательное учреждение высшего образования Владимирский государственный университет имени Александра Григорьевича и Николая Григорьевича Столетовых'),
(1416, 'https://ror.org/01nxv5c88', 'en', 1, 'https://ror.org/01nxv5c88 Second Affiliated Hospital of Nanchang University 南昌大学第二附属医院'),
(1417, 'https://ror.org/01nyv7k26', 'en', 1, 'https://ror.org/01nyv7k26 Oita University 大分大学'),
(1418, 'https://ror.org/01nzrqm94', 'en', 1, 'https://ror.org/01nzrqm94 Breach Candy Hospital'),
(1419, 'https://ror.org/01p01k535', 'en', 1, 'https://ror.org/01p01k535 Taoyuan Armed Forces General Hospital 桃园武装部队总医院'),
(1420, 'https://ror.org/01p0ttv97', 'en', 1, 'https://ror.org/01p0ttv97 Dickinson State University'),
(1421, 'https://ror.org/01p2t4k13', 'en', 1, 'https://ror.org/01p2t4k13 Heilongjiang Center for Tuberculosis Control and Prevention'),
(1422, 'https://ror.org/01p37he69', 'en', 1, 'https://ror.org/01p37he69 Kansas Wesleyan University'),
(1423, 'https://ror.org/01p3tpn79', 'es', 1, 'https://ror.org/01p3tpn79 Hospital Universitari Arnau de Vilanova'),
(1424, 'https://ror.org/01p7j6t08', 'en', 1, 'https://ror.org/01p7j6t08 Mississippi College'),
(1425, 'https://ror.org/01p830915', 'en', 1, 'https://ror.org/01p830915 Morriston Hospital Ysbyty Treforus'),
(1426, 'https://ror.org/01p8da469', 'it', 1, 'https://ror.org/01p8da469 Ospedale Amedeo di Savoia'),
(1427, 'https://ror.org/01papkj44', 'en', 1, 'https://ror.org/01papkj44 University of Tabriz دانشگاه تبریز'),
(1428, 'https://ror.org/01pd66220', 'en', 1, 'https://ror.org/01pd66220 302 Military Hospital of China 中国人民解放军第302医院'),
(1429, 'https://ror.org/01phhgk62', 'en', 1, 'https://ror.org/01phhgk62 Boca Raton Regional Hospital'),
(1430, 'https://ror.org/01phydj90', 'en', 1, 'https://ror.org/01phydj90 Akdeniz University Hospital Akdeniz Üniversitesi Hastanesi'),
(1431, 'https://ror.org/01pj4nt72', 'en', 1, 'https://ror.org/01pj4nt72 Nordland Hospital'),
(1432, 'https://ror.org/01pjjvq50', 'en', 1, 'https://ror.org/01pjjvq50 Eastbourne District General Hospital'),
(1433, 'https://ror.org/01pm59m24', 'en', 1, 'https://ror.org/01pm59m24 Akashi Municipal City Hospital 明石市立市民病院'),
(1434, 'https://ror.org/01pp15642', 'en', 1, 'https://ror.org/01pp15642 South Nassau Communities Hospital'),
(1435, 'https://ror.org/01ppcnz44', 'tr', 1, 'https://ror.org/01ppcnz44 Antalya Eğitim ve Araştırma Hastanesi'),
(1436, 'https://ror.org/01praqa56', 'en', 1, 'https://ror.org/01praqa56 National Institute of Occupational Health'),
(1437, 'https://ror.org/01ps4ag81', 'no_lang_code', 1, 'https://ror.org/01ps4ag81 Fountain Biopharma (Taiwan)'),
(1438, 'https://ror.org/01pvgz545', 'no_lang_code', 1, 'https://ror.org/01pvgz545 Ishikiriseiki Hospital 石切生喜病院'),
(1439, 'https://ror.org/01px48m89', 'en', 1, 'https://ror.org/01px48m89 Bentley University'),
(1440, 'https://ror.org/01px77p81', 'en', 1, 'https://ror.org/01px77p81 Sun Yat-sen Memorial Hospital'),
(1441, 'https://ror.org/01pxg9d10', 'en', 1, 'https://ror.org/01pxg9d10 Meyer Children''s Hospital'),
(1442, 'https://ror.org/01pxhdc49', 'en', 1, 'https://ror.org/01pxhdc49 Miyazaki Prefectural Hospital 宮崎県立病院'),
(1443, 'https://ror.org/01pym8r61', 'en', 1, 'https://ror.org/01pym8r61 Centre for Research in Medical Entomology'),
(1444, 'https://ror.org/01pzf6r50', 'en', 1, 'https://ror.org/01pzf6r50 Inje University Busan Paik Hospital'),
(1445, 'https://ror.org/01pzjt917', 'eu', 1, 'https://ror.org/01pzjt917 Hospital Txagorritxu'),
(1446, 'https://ror.org/01q046q46', 'fr', 1, 'https://ror.org/01q046q46 Hôpital Pierre Wertheimer'),
(1447, 'https://ror.org/01q11am17', 'en', 1, 'https://ror.org/01q11am17 Roper Hospital'),
(1448, 'https://ror.org/01q1jaw52', 'en', 1, 'https://ror.org/01q1jaw52 AHEPA University Hospital Πανεπιστημιακό Νοσοκομείο ΑΧΕΠΑ'),
(1449, 'https://ror.org/01q1y4t48', 'en', 1, 'https://ror.org/01q1y4t48 Virginia Tech - Wake Forest University School of Biomedical Engineering & Sciences'),
(1450, 'https://ror.org/01q2nz307', 'en', 1, 'https://ror.org/01q2nz307 Baystate Medical Center'),
(1451, 'https://ror.org/01q2y2d42', 'en', 1, 'https://ror.org/01q2y2d42 Departamento de Salud y Servicios Sociales de los Estados Unidos Département de la santé et des services sociaux des États-unis State of Maine Department of Health and Human Services'),
(1452, 'https://ror.org/01q4pk532', 'no_lang_code', 1, 'https://ror.org/01q4pk532 Hydro One (Canada)'),
(1453, 'https://ror.org/01q6b3f33', 'no_lang_code', 1, 'https://ror.org/01q6b3f33 Al Omooma Hospital'),
(1454, 'https://ror.org/01q6hrg49', 'it', 1, 'https://ror.org/01q6hrg49 Ospedale Garibaldi'),
(1455, 'https://ror.org/01q750e89', 'nl', 1, 'https://ror.org/01q750e89 Elkerliek Ziekenhuis'),
(1456, 'https://ror.org/01q8f6705', 'no_lang_code', 1, 'https://ror.org/01q8f6705 BASF (Germany)'),
(1457, 'https://ror.org/01q9r1072', 'en', 1, 'https://ror.org/01q9r1072 Boys Town National Research Hospital'),
(1458, 'https://ror.org/01qbebb31', 'en', 1, 'https://ror.org/01qbebb31 Papworth Hospital NHS Foundation Trust'),
(1459, 'https://ror.org/01qc48765', 'en', 1, 'https://ror.org/01qc48765 Association of Academic Health Centers'),
(1460, 'https://ror.org/01qcxb695', 'no_lang_code', 1, 'https://ror.org/01qcxb695 Mahosot Hospital'),
(1461, 'https://ror.org/01qd3xc93', 'en', 1, 'https://ror.org/01qd3xc93 Fondazione Mario Negri Sud Mario Negri Sud Foundation'),
(1462, 'https://ror.org/01qdp7m73', 'en', 1, 'https://ror.org/01qdp7m73 Bryn Mawr Rehabilitation Hospital'),
(1463, 'https://ror.org/01qe4gr33', 'en', 1, 'https://ror.org/01qe4gr33 Family and Social Services Administration'),
(1464, 'https://ror.org/01qe7f394', 'en', 1, 'https://ror.org/01qe7f394 Ministerio de Salud de Chile Ministry of Health'),
(1465, 'https://ror.org/01qemgb02', 'en', 1, 'https://ror.org/01qemgb02 Manipal Teaching Hospital मणिपाल टीचिंग हस्पिटल'),
(1466, 'https://ror.org/01qh26a66', 'en', 1, 'https://ror.org/01qh26a66 Sichuan Academy of Medical Sciences & Sichuan Provincial People''s Hospital 四川省中医药科学院'),
(1467, 'https://ror.org/01qh83x04', 'sv', 1, 'https://ror.org/01qh83x04 Västmanlands sjukhus Västerås'),
(1468, 'https://ror.org/01qn0gc28', 'en', 1, 'https://ror.org/01qn0gc28 Yuri Gagarin State Technical University of Saratov Саратовский государственный технический университет имени Ю. А. Гагарина'),
(1469, 'https://ror.org/01qqxvf96', 'es', 1, 'https://ror.org/01qqxvf96 Hospital Español'),
(1470, 'https://ror.org/01qr3vg91', 'en', 1, 'https://ror.org/01qr3vg91 Regional Medical Research Centre'),
(1471, 'https://ror.org/01qr5a671', 'en', 1, 'https://ror.org/01qr5a671 Tohoku Fukushi University 東北福祉大学'),
(1472, 'https://ror.org/01qt0gj86', 'lt', 1, 'https://ror.org/01qt0gj86 Lietuvos Bioetikos Komitetas Lithuanian Bioethics Committee'),
(1473, 'https://ror.org/01qtc5416', 'en', 1, 'https://ror.org/01qtc5416 Federal Office of Public Health'),
(1474, 'https://ror.org/01qtnxn83', 'en', 1, 'https://ror.org/01qtnxn83 Technical University of Nova Scotia'),
(1475, 'https://ror.org/01qv3ba61', 'en', 1, 'https://ror.org/01qv3ba61 University of Port Harcourt Teaching Hospital'),
(1476, 'https://ror.org/01qv3p587', 'no_lang_code', 1, 'https://ror.org/01qv3p587 Universal Stabilization Technologies'),
(1477, 'https://ror.org/01qww1p93', 'en', 1, 'https://ror.org/01qww1p93 Dominican University'),
(1478, 'https://ror.org/01qyd4k24', 'en', 1, 'https://ror.org/01qyd4k24 Hoseo University 호서대학교'),
(1479, 'https://ror.org/01qz7fr76', 'en', 1, 'https://ror.org/01qz7fr76 Brighton and Sussex Medical School'),
(1480, 'https://ror.org/01r024a98', 'en', 1, 'https://ror.org/01r024a98 Chung-Ang University 중앙대학교'),
(1481, 'https://ror.org/01r05t925', 'tr', 1, 'https://ror.org/01r05t925 Ankara Onkoloji Eğitim ve Araştırma Hastanesi'),
(1482, 'https://ror.org/01r0bpx56', 'no_lang_code', 1, 'https://ror.org/01r0bpx56 Hiratsuka Kyosai Hospital 平塚共済病院'),
(1483, 'https://ror.org/01r2n9849', 'en', 1, 'https://ror.org/01r2n9849 Saint John''s Hospital'),
(1484, 'https://ror.org/01r3kd649', 'tr', 1, 'https://ror.org/01r3kd649 S.B. Keçiören Eğitim ve Araştırma Hastanesi'),
(1485, 'https://ror.org/01r4bn552', 'en', 1, 'https://ror.org/01r4bn552 Institut von karman de dynamique des fluides Von Karman Institut für Strömungsmechanik Von Karman Institute for Fluid Dynamics'),
(1486, 'https://ror.org/01r89q997', 'en', 1, 'https://ror.org/01r89q997 Royal Victoria Regional Health Centre'),
(1487, 'https://ror.org/01r8fpq52', 'en', 1, 'https://ror.org/01r8fpq52 Niigata City General Hospital 新潟市民病院'),
(1488, 'https://ror.org/01r9be524', 'en', 1, 'https://ror.org/01r9be524 Bristol Hospital'),
(1489, 'https://ror.org/01r9ea713', 'en', 1, 'https://ror.org/01r9ea713 Blackpool Victoria Hospital'),
(1490, 'https://ror.org/01rabm487', 'pt', 1, 'https://ror.org/01rabm487 Hospital Nossa Senhora das Graças'),
(1491, 'https://ror.org/01rahby95', 'en', 1, 'https://ror.org/01rahby95 Department of Human Services'),
(1492, 'https://ror.org/01rb2ev69', 'no_lang_code', 1, 'https://ror.org/01rb2ev69 Inspiralia'),
(1493, 'https://ror.org/01rb2st83', 'sk', 1, 'https://ror.org/01rb2st83 Univerzitná Nemocnica Louisa Pasteura'),
(1494, 'https://ror.org/01rb4vv49', 'en', 1, 'https://ror.org/01rb4vv49 Shariati Hospital بیمارستان شریعتی'),
(1495, 'https://ror.org/01rdjpj45', 'en', 1, 'https://ror.org/01rdjpj45 M. P. Shah Medical College શ્રી એમપી શાહ સરકારી મેડિકલ કોલેજ'),
(1496, 'https://ror.org/01rdvwx15', 'en', 1, 'https://ror.org/01rdvwx15 Lee Memorial Hospital'),
(1497, 'https://ror.org/01rf07780', 'es', 1, 'https://ror.org/01rf07780 Hospital Provincial de Conxo'),
(1498, 'https://ror.org/01rf1rj96', 'en', 1, 'https://ror.org/01rf1rj96 Kangwon National University Hospital 강원대학교병원'),
(1499, 'https://ror.org/01rm42p40', 'en', 1, 'https://ror.org/01rm42p40 University of Alabama at Birmingham Hospital'),
(1500, 'https://ror.org/01rrd4612', 'no_lang_code', 1, 'https://ror.org/01rrd4612 Hiroshima Prefectural Hospital 県立広島病院'),
(1501, 'https://ror.org/01rs0ht88', 'en', 1, 'https://ror.org/01rs0ht88 Ministry of Health and Medical Education'),
(1502, 'https://ror.org/01rsda187', 'en', 1, 'https://ror.org/01rsda187 Mitate Hospital 見立病院'),
(1503, 'https://ror.org/01rvf6k07', 'en', 1, 'https://ror.org/01rvf6k07 Military Hospital'),
(1504, 'https://ror.org/01rwkhb30', 'en', 1, 'https://ror.org/01rwkhb30 Korea Institute of Materials Science'),
(1505, 'https://ror.org/01rws6r75', 'en', 1, 'https://ror.org/01rws6r75 Ahvaz Jundishapur University of Medical Sciences دانشگاه علوم پزشکی جندی‌شاپور اهواز'),
(1506, 'https://ror.org/01rx63s97', 'pt', 1, 'https://ror.org/01rx63s97 Guarulhos University'),
(1507, 'https://ror.org/01rxfrp27', 'en', 1, 'https://ror.org/01rxfrp27 La Trobe University'),
(1508, 'https://ror.org/01ry6tw68', 'no_lang_code', 1, 'https://ror.org/01ry6tw68 Balance Technology Consulting'),
(1509, 'https://ror.org/01rzm0s68', 'en', 1, 'https://ror.org/01rzm0s68 Sentara Rockingham Memorial Hospital Medical Center'),
(1510, 'https://ror.org/01s0phq15', 'en', 1, 'https://ror.org/01s0phq15 Inverclyde Royal Hospital'),
(1511, 'https://ror.org/01s434164', 'en', 1, 'https://ror.org/01s434164 Nathan Kline Institute for Psychiatric Research'),
(1512, 'https://ror.org/01s4cx283', 'no_lang_code', 1, 'https://ror.org/01s4cx283 Shizuoka Saiseikai General Hospital 静岡済生会総合病院'),
(1513, 'https://ror.org/01s5axj25', 'en', 1, 'https://ror.org/01s5axj25 Lunenfeld-Tanenbaum Research Institute'),
(1514, 'https://ror.org/01s5dt366', 'en', 1, 'https://ror.org/01s5dt366 University Hospital of Larissa'),
(1515, 'https://ror.org/01s5r6w32', 'en', 1, 'https://ror.org/01s5r6w32 Central Arkansas Veterans Healthcare System'),
(1516, 'https://ror.org/01s7jxc19', 'en', 1, 'https://ror.org/01s7jxc19 Miyagi University of Education 宮城教育大学'),
(1517, 'https://ror.org/01s7w1z60', 'fr', 1, 'https://ror.org/01s7w1z60 Hotel Dieu Hospital'),
(1518, 'https://ror.org/01s7y5e82', 'en', 1, 'https://ror.org/01s7y5e82 Ivan Franko Nemzeti Egyetem Lviv Lviv University Uniwersytet Lwowski Львовский национальный университет имени Ивана Франко Львівський національний університет імені Івана Франка'),
(1519, 'https://ror.org/01s8xxq04', 'en', 1, 'https://ror.org/01s8xxq04 Eastern Oregon University'),
(1520, 'https://ror.org/01s9rzk09', 'en', 1, 'https://ror.org/01s9rzk09 Kushiro Rosai Hospital 釧路ろうさい病院'),
(1521, 'https://ror.org/01sgn8034', 'en', 1, 'https://ror.org/01sgn8034 Trinitas Regional Medical Center'),
(1522, 'https://ror.org/01shhkn05', 'en', 1, 'https://ror.org/01shhkn05 East Orange VA Medical Center'),
(1523, 'https://ror.org/01ska0k70', 'en', 1, 'https://ror.org/01ska0k70 Millard Fillmore Suburban Hospital'),
(1524, 'https://ror.org/01skxn174', 'en', 1, 'https://ror.org/01skxn174 Lower Manhattan Hospital'),
(1525, 'https://ror.org/01sm4s887', 'en', 1, 'https://ror.org/01sm4s887 Bundesinstitut für gesundheitlichen Verbraucherschutz und Veterinärmedizin Federal Institute for Health Protection of Consumers and Veterinary Medicine'),
(1526, 'https://ror.org/01smmxq73', 'en', 1, 'https://ror.org/01smmxq73 Doctors Hospital'),
(1527, 'https://ror.org/01smpj292', 'en', 1, 'https://ror.org/01smpj292 Arizona Department of Health Services'),
(1528, 'https://ror.org/01sps7q28', 'en', 1, 'https://ror.org/01sps7q28 The University of Texas Health Science Center at Tyler'),
(1529, 'https://ror.org/01sxtx626', 'en', 1, 'https://ror.org/01sxtx626 Ministry of Health Міністерство охорони здоров''я України'),
(1530, 'https://ror.org/01sytk573', 'en', 1, 'https://ror.org/01sytk573 National Science Museum'),
(1531, 'https://ror.org/01t0n3b84', 'it', 1, 'https://ror.org/01t0n3b84 Consorzio Pisa Ricerche'),
(1532, 'https://ror.org/01t33qq42', 'en', 1, 'https://ror.org/01t33qq42 Arkansas Children''s Hospital'),
(1533, 'https://ror.org/01t3emk15', 'en', 1, 'https://ror.org/01t3emk15 Central Chest Institute of Thailand'),
(1534, 'https://ror.org/01t409e13', 'en', 1, 'https://ror.org/01t409e13 Regional Hospital Holstebro'),
(1535, 'https://ror.org/01t54q348', 'en', 1, 'https://ror.org/01t54q348 Grantham Hospital 葛量洪醫院'),
(1536, 'https://ror.org/01t5yh786', 'en', 1, 'https://ror.org/01t5yh786 Hôpital Universitaire Des Enfants Reine Fabiola Queen Fabiola Children''s University Hospital'),
(1537, 'https://ror.org/01t69y763', 'en', 1, 'https://ror.org/01t69y763 St. Luke''s Hospital'),
(1538, 'https://ror.org/01t6fdj11', 'en', 1, 'https://ror.org/01t6fdj11 Mary Free Bed Rehabilitation Hospital'),
(1539, 'https://ror.org/01t6tyq74', 'en', 1, 'https://ror.org/01t6tyq74 Consortium of Universities for Research in Earthquake Engineering'),
(1540, 'https://ror.org/01t817z14', 'en', 1, 'https://ror.org/01t817z14 University of Houston - Clear Lake'),
(1541, 'https://ror.org/01t8svj65', 'en', 1, 'https://ror.org/01t8svj65 University of California San Francisco Medical Center'),
(1542, 'https://ror.org/01tcy5w98', 'no_lang_code', 1, 'https://ror.org/01tcy5w98 Aurum Institute'),
(1543, 'https://ror.org/01tek4f86', 'hu', 1, 'https://ror.org/01tek4f86 Bács-Kiskun Megyei Kórház'),
(1544, 'https://ror.org/01thhk923', 'en', 1, 'https://ror.org/01thhk923 Dongshin University 동신대학교'),
(1545, 'https://ror.org/01thzqc78', 'pt', 1, 'https://ror.org/01thzqc78 Universidade Sagrado Coração'),
(1546, 'https://ror.org/01tj58m37', 'en', 1, 'https://ror.org/01tj58m37 Montana State University Billings'),
(1547, 'https://ror.org/01tqqny90', 'en', 1, 'https://ror.org/01tqqny90 Nagasaki International University 長崎国際大学'),
(1548, 'https://ror.org/01ttqjq76', 'en', 1, 'https://ror.org/01ttqjq76 North Wales Hospital'),
(1549, 'https://ror.org/01v00e311', 'en', 1, 'https://ror.org/01v00e311 Hayashi Eye Hospital'),
(1550, 'https://ror.org/01v0xk274', 'pt', 1, 'https://ror.org/01v0xk274 Universidade Ibirapuera'),
(1551, 'https://ror.org/01v16x378', 'en', 1, 'https://ror.org/01v16x378 Command Hospital'),
(1552, 'https://ror.org/01v27vf29', 'en', 1, 'https://ror.org/01v27vf29 Children''s Medical Center'),
(1553, 'https://ror.org/01v49sd11', 'en', 1, 'https://ror.org/01v49sd11 Saint Louis University Hospital'),
(1554, 'https://ror.org/01v4pc162', 'en', 1, 'https://ror.org/01v4pc162 National Board of Health and Welfare'),
(1555, 'https://ror.org/01v5y3463', 'en', 1, 'https://ror.org/01v5y3463 Autonomous University of Campeche Universidad Autónoma de Campeche'),
(1556, 'https://ror.org/01v62m802', 'en', 1, 'https://ror.org/01v62m802 Siena College'),
(1557, 'https://ror.org/01v6gr187', 'no_lang_code', 1, 'https://ror.org/01v6gr187 Semex'),
(1558, 'https://ror.org/01v7y5b55', 'en', 1, 'https://ror.org/01v7y5b55 Korea Maritime and Ocean University 한국해양대학교'),
(1559, 'https://ror.org/01v8mb410', 'en', 1, 'https://ror.org/01v8mb410 National Sanyo Hospital 国立病院機構山口宇部医療センター'),
(1560, 'https://ror.org/01v95tx09', 'en', 1, 'https://ror.org/01v95tx09 Shriners Hospitals for Children - Galveston'),
(1561, 'https://ror.org/01v9g9c07', 'en', 1, 'https://ror.org/01v9g9c07 Mie University Hospital 三重大学病院'),
(1562, 'https://ror.org/01va7e105', 'en', 1, 'https://ror.org/01va7e105 Ibis Reproductive Health'),
(1563, 'https://ror.org/01vbmek33', 'en', 1, 'https://ror.org/01vbmek33 Kyung Hee University Medical Center'),
(1564, 'https://ror.org/01vj9qy35', 'en', 1, 'https://ror.org/01vj9qy35 Christian Medical College'),
(1565, 'https://ror.org/01vjd7j86', 'en', 1, 'https://ror.org/01vjd7j86 Federalni Zavod za geologiju The Federal Institute for Geology'),
(1566, 'https://ror.org/01vjtf564', 'en', 1, 'https://ror.org/01vjtf564 Rabin Medical Center'),
(1567, 'https://ror.org/01vk45p32', 'en', 1, 'https://ror.org/01vk45p32 Eiju General Hospital 永寿総合病院'),
(1568, 'https://ror.org/01vka3a64', 'en', 1, 'https://ror.org/01vka3a64 CARE Hospitals'),
(1569, 'https://ror.org/01vqqz948', 'fr', 1, 'https://ror.org/01vqqz948 Hopital Universitaire Hedi Chaker المستشفى الجامعي بصفاقس'),
(1570, 'https://ror.org/01vr7z878', 'en', 1, 'https://ror.org/01vr7z878 Khyber Medical College'),
(1571, 'https://ror.org/01vtn3k88', 'es', 1, 'https://ror.org/01vtn3k88 Hospital Pablo Tobon Uribe'),
(1572, 'https://ror.org/01vv03303', 'en', 1, 'https://ror.org/01vv03303 King Abdul Aziz University Hospital'),
(1573, 'https://ror.org/01vx7zt03', 'en', 1, 'https://ror.org/01vx7zt03 Addington Hospital'),
(1574, 'https://ror.org/01vzp6a32', 'en', 1, 'https://ror.org/01vzp6a32 Korle Bu Teaching Hospital'),
(1575, 'https://ror.org/01w0d5g70', 'en', 1, 'https://ror.org/01w0d5g70 University of Missouri–Kansas City'),
(1576, 'https://ror.org/01w1pbe36', 'en', 1, 'https://ror.org/01w1pbe36 University of Maryland Global Campus'),
(1577, 'https://ror.org/01w3ec513', 'en', 1, 'https://ror.org/01w3ec513 Arnot Ogden Medical Center'),
(1578, 'https://ror.org/01w3xx622', 'en', 1, 'https://ror.org/01w3xx622 Lanzhou Army General Hospital 陆军总院'),
(1579, 'https://ror.org/01w502745', 'nl', 1, 'https://ror.org/01w502745 Slotervaartziekenhuis'),
(1580, 'https://ror.org/01w5s1t11', 'en', 1, 'https://ror.org/01w5s1t11 Buffalo Medical Group'),
(1581, 'https://ror.org/01w62yz22', 'en', 1, 'https://ror.org/01w62yz22 Advanced Institute of Convergence Technology 차세대융합기술연구원'),
(1582, 'https://ror.org/01w6vdf77', 'en', 1, 'https://ror.org/01w6vdf77 Gorgan University of Agricultural Sciences and Natural Resources دانشگاه علوم کشاورزی و منابع طبیعی گرگان'),
(1583, 'https://ror.org/01w6wtk13', 'en', 1, 'https://ror.org/01w6wtk13 Shizuoka University 静岡大学'),
(1584, 'https://ror.org/01w756144', 'en', 1, 'https://ror.org/01w756144 Meriter Hospital'),
(1585, 'https://ror.org/01w8whh21', 'en', 1, 'https://ror.org/01w8whh21 University of Oklahoma Medical Center'),
(1586, 'https://ror.org/01wc5x922', 'en', 1, 'https://ror.org/01wc5x922 Providence Sacred Heart Medical Center'),
(1587, 'https://ror.org/01wcey047', 'en', 1, 'https://ror.org/01wcey047 Joseph Eye Hospital'),
(1588, 'https://ror.org/01wdckv42', 'en', 1, 'https://ror.org/01wdckv42 Bayfront Medical Center'),
(1589, 'https://ror.org/01wddqe20', 'en', 1, 'https://ror.org/01wddqe20 The Alfred Hospital'),
(1590, 'https://ror.org/01wf0xv67', 'en', 1, 'https://ror.org/01wf0xv67 Eastern Command Hospital'),
(1591, 'https://ror.org/01wgych27', 'en', 1, 'https://ror.org/01wgych27 Kaiser Permanente Riverside Medical Center'),
(1592, 'https://ror.org/01whq8m38', 'en', 1, 'https://ror.org/01whq8m38 Mokwon University 목원대학교'),
(1593, 'https://ror.org/01wjz9118', 'en', 1, 'https://ror.org/01wjz9118 Nizam''s Institute of Medical Sciences'),
(1594, 'https://ror.org/01wmj1g45', 'en', 1, 'https://ror.org/01wmj1g45 Atlanta University Center'),
(1595, 'https://ror.org/01wpkc438', 'en', 1, 'https://ror.org/01wpkc438 Canadian Foundation For The International Space University'),
(1596, 'https://ror.org/01wpqwr25', 'en', 1, 'https://ror.org/01wpqwr25 Lemuel Shattuck Hospital'),
(1597, 'https://ror.org/01wqrpc44', 'en', 1, 'https://ror.org/01wqrpc44 Kyushu Sangyo University 九州産業大学'),
(1598, 'https://ror.org/01wrc0z23', 'en', 1, 'https://ror.org/01wrc0z23 Jersey City Medical Center'),
(1599, 'https://ror.org/01wv1aw46', 'en', 1, 'https://ror.org/01wv1aw46 BongSeng Memorial Hospital 봉생병원입니다'),
(1600, 'https://ror.org/01wx86652', 'en', 1, 'https://ror.org/01wx86652 Astley Ainslie Hospital'),
(1601, 'https://ror.org/01wxddc07', 'en', 1, 'https://ror.org/01wxddc07 Katsushika Medical Center 葛飾医療センタ'),
(1602, 'https://ror.org/01x18vk56', 'no_lang_code', 1, 'https://ror.org/01x18vk56 Sir Ganga Ram Hospital'),
(1603, 'https://ror.org/01x21tj82', 'no_lang_code', 1, 'https://ror.org/01x21tj82 Microsoft (Netherlands)'),
(1604, 'https://ror.org/01x24z140', 'en', 1, 'https://ror.org/01x24z140 Annamalai University अन्नामलाई विश्वविद्यालय ਅੰਨਾਮਲਾਈ ਯੂਨੀਵਰਸਿਟੀ அண்ணாமலைப் பல்கலைக்கழகம் അണ്ണാമലൈ സർവകലാശാല'),
(1605, 'https://ror.org/01x2t4526', 'en', 1, 'https://ror.org/01x2t4526 Lee Memorial Health System'),
(1606, 'https://ror.org/01x3f1613', 'en', 1, 'https://ror.org/01x3f1613 Driscoll Children''s Hospital'),
(1607, 'https://ror.org/01x3jjv63', 'en', 1, 'https://ror.org/01x3jjv63 Uzhhorod National University Użhorodzki Uniwersytet Narodowy Ужгородский национальный университет Ужгородський національний університет'),
(1608, 'https://ror.org/01x4whx42', 'en', 1, 'https://ror.org/01x4whx42 Sangmyung University 상명대학교'),
(1609, 'https://ror.org/01x5yfk91', 'en', 1, 'https://ror.org/01x5yfk91 HealthONE Spalding Rehabilitation Hospital'),
(1610, 'https://ror.org/01x66cn47', 'it', 1, 'https://ror.org/01x66cn47 Ospedale di Santa Maria dei Battuti'),
(1611, 'https://ror.org/01x69an44', 'en', 1, 'https://ror.org/01x69an44 Children''s & Women''s Health Centre of British Columbia'),
(1612, 'https://ror.org/01x8yyz38', 'en', 1, 'https://ror.org/01x8yyz38 Etelä-Karjalan keskussairaala South Karelia Central Hospital'),
(1613, 'https://ror.org/01x9g5g52', 'no_lang_code', 1, 'https://ror.org/01x9g5g52 Ension'),
(1614, 'https://ror.org/01xapny78', 'en', 1, 'https://ror.org/01xapny78 Cabrini Medical Center'),
(1615, 'https://ror.org/01xar8k65', 'en', 1, 'https://ror.org/01xar8k65 Flower Hospital'),
(1616, 'https://ror.org/01xb3t395', 'en', 1, 'https://ror.org/01xb3t395 Summa Akron City Hospital'),
(1617, 'https://ror.org/01xd4z152', 'en', 1, 'https://ror.org/01xd4z152 Southwest Washington Medical Center'),
(1618, 'https://ror.org/01xdjhe59', 'en', 1, 'https://ror.org/01xdjhe59 Iwata City Hospital 磐田市立総合病院'),
(1619, 'https://ror.org/01xereq81', 'en', 1, 'https://ror.org/01xereq81 Jamaica Hospital'),
(1620, 'https://ror.org/01xf83457', 'it', 1, 'https://ror.org/01xf83457 Azienda Ospedaliera San Gerardo'),
(1621, 'https://ror.org/01xg9pd38', 'en', 1, 'https://ror.org/01xg9pd38 Fitzgerald Health Education Associates'),
(1622, 'https://ror.org/01xhmje49', 'en', 1, 'https://ror.org/01xhmje49 Birmingham Dental Hospital'),
(1623, 'https://ror.org/01xjqrm90', 'en', 1, 'https://ror.org/01xjqrm90 Umm al-Qura University جامعة أم القرى'),
(1624, 'https://ror.org/01xkmcr24', 'de', 1, 'https://ror.org/01xkmcr24 Universitäts-Augenklinik Bonn'),
(1625, 'https://ror.org/01xkzjp97', 'en', 1, 'https://ror.org/01xkzjp97 Health Promotion Board 新加坡保健促进局'),
(1626, 'https://ror.org/01xm3qq33', 'de', 1, 'https://ror.org/01xm3qq33 Schulthess-Klinik'),
(1627, 'https://ror.org/01xm4tt59', 'en', 1, 'https://ror.org/01xm4tt59 Woodruff Health Sciences Center'),
(1628, 'https://ror.org/01xn4ac42', 'en', 1, 'https://ror.org/01xn4ac42 Brandon Regional Health Authority'),
(1629, 'https://ror.org/01xngwb59', 'en', 1, 'https://ror.org/01xngwb59 Fortis Escorts Hospital'),
(1630, 'https://ror.org/01xnhkz22', 'en', 1, 'https://ror.org/01xnhkz22 Scarborough General Hospital'),
(1631, 'https://ror.org/01xnwqx93', 'en', 1, 'https://ror.org/01xnwqx93 University Hospital Bonn Universitätsklinikum Bonn'),
(1632, 'https://ror.org/01xpt7p88', 'en', 1, 'https://ror.org/01xpt7p88 Menninger Clinic'),
(1633, 'https://ror.org/01xq02v66', 'en', 1, 'https://ror.org/01xq02v66 Hasbro Children''s Hospital'),
(1634, 'https://ror.org/01xqed412', 'en', 1, 'https://ror.org/01xqed412 Haywood Community Hospital'),
(1635, 'https://ror.org/01xrazc29', 'en', 1, 'https://ror.org/01xrazc29 Jaipur National University'),
(1636, 'https://ror.org/01xrnpj63', 'no_lang_code', 1, 'https://ror.org/01xrnpj63 Sahara Hospital'),
(1637, 'https://ror.org/01xrsrd14', 'en', 1, 'https://ror.org/01xrsrd14 Meenakshi Mission Hospital and Research Centre'),
(1638, 'https://ror.org/01xtjs520', 'fr', 1, 'https://ror.org/01xtjs520 Institut Laue-Langevin'),
(1639, 'https://ror.org/01xtpc441', 'en', 1, 'https://ror.org/01xtpc441 Northport VA Medical Center'),
(1640, 'https://ror.org/01xv1nn60', 'en', 1, 'https://ror.org/01xv1nn60 Taibah University جامعة طيبة'),
(1641, 'https://ror.org/01xvcf081', 'en', 1, 'https://ror.org/01xvcf081 New York Blood Center'),
(1642, 'https://ror.org/01xxd6b82', 'en', 1, 'https://ror.org/01xxd6b82 Kosair Children''s Hospital'),
(1643, 'https://ror.org/01y3zfr79', 'en', 1, 'https://ror.org/01y3zfr79 National Institute of Nursing Research'),
(1644, 'https://ror.org/01y4xm534', 'en', 1, 'https://ror.org/01y4xm534 Islamic Azad University, Karaj, Karaj Islamic Azad University دانشگاه آزاد اسلامی واحد کرج'),
(1645, 'https://ror.org/01y8xtk20', 'en', 1, 'https://ror.org/01y8xtk20 Southwestern Oklahoma State University'),
(1646, 'https://ror.org/01y8zn427', 'en', 1, 'https://ror.org/01y8zn427 Chittagong Medical College চট্টগ্রাম মেডিকেল কলেজ'),
(1647, 'https://ror.org/01y946378', 'en', 1, 'https://ror.org/01y946378 Hospital Umum Sarawak Sarawak General Hospital'),
(1648, 'https://ror.org/01yav5t22', 'en', 1, 'https://ror.org/01yav5t22 Conference Board Math Sciences'),
(1649, 'https://ror.org/01ybfxd46', 'en', 1, 'https://ror.org/01ybfxd46 University Hospital Complex Of Vigo'),
(1650, 'https://ror.org/01ybj8n97', 'en', 1, 'https://ror.org/01ybj8n97 Dundee Dental Hospital'),
(1651, 'https://ror.org/01ycr6b80', 'en', 1, 'https://ror.org/01ycr6b80 Royal Liverpool University Hospital'),
(1652, 'https://ror.org/01yedz573', 'en', 1, 'https://ror.org/01yedz573 Kunming General Hospital of Chengdu Military Command 成都军区昆明总医院'),
(1653, 'https://ror.org/01yft1b10', 'en', 1, 'https://ror.org/01yft1b10 Catalyst Health Economics Consultants Ltd'),
(1654, 'https://ror.org/01yhc9w15', 'en', 1, 'https://ror.org/01yhc9w15 Sherman Hospital'),
(1655, 'https://ror.org/01yjy8p80', 'en', 1, 'https://ror.org/01yjy8p80 National University of Luján Universidad Nacional de Luján'),
(1656, 'https://ror.org/01yjyvb35', 'en', 1, 'https://ror.org/01yjyvb35 Bemidji State University'),
(1657, 'https://ror.org/01ym47j46', 'en', 1, 'https://ror.org/01ym47j46 Fulbourn Hospital'),
(1658, 'https://ror.org/01yn28w07', 'no_lang_code', 1, 'https://ror.org/01yn28w07 General Hospital of Ioannina G. Hatzikosta Γενικό Νοσοκομείο Ιωαννίνων "Γ. Χατζηκώστα"'),
(1659, 'https://ror.org/01yp8kc21', 'es', 1, 'https://ror.org/01yp8kc21 Hospital San Pedro de Alcántara'),
(1660, 'https://ror.org/01ypwfg63', 'no_lang_code', 1, 'https://ror.org/01ypwfg63 Ecofys (Netherlands)'),
(1661, 'https://ror.org/01yqewm58', 'en', 1, 'https://ror.org/01yqewm58 Kuban State University Кубанский государственный университет'),
(1662, 'https://ror.org/01ysgtb61', 'en', 1, 'https://ror.org/01ysgtb61 Baqiyatallah University of Medical Sciences دانشگاه علوم پزشکی بقیةالله'),
(1663, 'https://ror.org/01yth7f19', 'no_lang_code', 1, 'https://ror.org/01yth7f19 Kudanzaka Hospital 九段坂病院'),
(1664, 'https://ror.org/01yvj7247', 'en', 1, 'https://ror.org/01yvj7247 Bnai Zion Medical Center מרכז רפואי בני ציון'),
(1665, 'https://ror.org/01ywpxj09', 'en', 1, 'https://ror.org/01ywpxj09 Queen Victoria Hospital'),
(1666, 'https://ror.org/01yxj7x74', 'en', 1, 'https://ror.org/01yxj7x74 University Clinic of Pulmonary and Allergic Diseases Golnik'),
(1667, 'https://ror.org/01yytng49', 'en', 1, 'https://ror.org/01yytng49 Kanagawa Rehabilitation Hospital 神奈川リハビリテーション病院'),
(1668, 'https://ror.org/01yyxv878', 'en', 1, 'https://ror.org/01yyxv878 Wingate University'),
(1669, 'https://ror.org/01yzgg311', 'es', 1, 'https://ror.org/01yzgg311 Hospital Central de la Cruz Roja San José y Santa Adela'),
(1670, 'https://ror.org/01yzz0f51', 'en', 1, 'https://ror.org/01yzz0f51 Chung Hua University'),
(1671, 'https://ror.org/01z07eq06', 'en', 1, 'https://ror.org/01z07eq06 Hubei Polytechnic University 湖北理工学院'),
(1672, 'https://ror.org/01z1dtf94', 'en', 1, 'https://ror.org/01z1dtf94 Shriners Hospitals for Children - Canada'),
(1673, 'https://ror.org/01z3j3n30', 'en', 1, 'https://ror.org/01z3j3n30 Schneider Children''s Medical Center'),
(1674, 'https://ror.org/01z4nnt86', 'en', 1, 'https://ror.org/01z4nnt86 Seoul National University Hospital 서울대학교병원'),
(1675, 'https://ror.org/01z719741', 'en', 1, 'https://ror.org/01z719741 Scripps Clinic Medical Group'),
(1676, 'https://ror.org/01z7mq587', 'tr', 1, 'https://ror.org/01z7mq587 Diyarbakır Askeri Hastanesi'),
(1677, 'https://ror.org/01z83rb65', 'fr', 1, 'https://ror.org/01z83rb65 Adi Valor'),
(1678, 'https://ror.org/01z8t1s57', 'en', 1, 'https://ror.org/01z8t1s57 International Center for Public Health'),
(1679, 'https://ror.org/01z9vrt66', 'en', 1, 'https://ror.org/01z9vrt66 Okazaki City Hospital 岡崎市民病院'),
(1680, 'https://ror.org/01za8fg18', 'en', 1, 'https://ror.org/01za8fg18 Lagos State University Yunifásítì Ìpínlẹ̀ Èkó'),
(1681, 'https://ror.org/01zbeej63', 'fi', 1, 'https://ror.org/01zbeej63 Keski-Satakunnan Terveydenhuollon kuntayhtymä'),
(1682, 'https://ror.org/01zbhpb91', 'en', 1, 'https://ror.org/01zbhpb91 Meenakshi Ammal Dental College and Hospital'),
(1683, 'https://ror.org/01zbzxe52', 'en', 1, 'https://ror.org/01zbzxe52 Royal South Hants Hospital'),
(1684, 'https://ror.org/01zc7k534', 'no_lang_code', 1, 'https://ror.org/01zc7k534 Koga Hospital 古賀病院'),
(1685, 'https://ror.org/01zd7yk57', 'en', 1, 'https://ror.org/01zd7yk57 Louisville VA Medical Center'),
(1686, 'https://ror.org/01zjsmf32', 'en', 1, 'https://ror.org/01zjsmf32 Government Rajaji Hospital'),
(1687, 'https://ror.org/01zjvhn75', 'en', 1, 'https://ror.org/01zjvhn75 National Taiwan Sport University'),
(1688, 'https://ror.org/01zkyz108', 'en', 1, 'https://ror.org/01zkyz108 Hospital Monte Sinaí Mount Sinai Hospital'),
(1689, 'https://ror.org/01zmw6f28', 'it', 1, 'https://ror.org/01zmw6f28 Ospedale Santa Maria Annunziata'),
(1690, 'https://ror.org/01znbfh26', 'fi', 1, 'https://ror.org/01znbfh26 Forssan Seudun Terveydenhuollon Kuntayhtymä'),
(1691, 'https://ror.org/01zp13r18', 'en', 1, 'https://ror.org/01zp13r18 Research Medical Center'),
(1692, 'https://ror.org/01zqccq48', 'en', 1, 'https://ror.org/01zqccq48 Daegu University 대구대학교'),
(1693, 'https://ror.org/01zqcg218', 'en', 1, 'https://ror.org/01zqcg218 Kyung Hee University 경희대학교'),
(1694, 'https://ror.org/01zqztb27', 'no_lang_code', 1, 'https://ror.org/01zqztb27 Caritas Medical Centre 明愛醫院'),
(1695, 'https://ror.org/01zr6qe45', 'en', 1, 'https://ror.org/01zr6qe45 Colorado Center For Hospice and Palliative Care'),
(1696, 'https://ror.org/01zt9a375', 'en', 1, 'https://ror.org/01zt9a375 Chosun University 조선대학교'),
(1697, 'https://ror.org/01zvqw119', 'en', 1, 'https://ror.org/01zvqw119 Auckland University of Technology'),
(1698, 'https://ror.org/01zx16v02', 'en', 1, 'https://ror.org/01zx16v02 Athens State University Université d''État d''athens'),
(1699, 'https://ror.org/01zx5ww52', 'en', 1, 'https://ror.org/01zx5ww52 Inje University Ilsan Paik Hospital 인제 대학교 일산 백병원'),
(1700, 'https://ror.org/01zxdeg39', 'en', 1, 'https://ror.org/01zxdeg39 Harvard Pilgrim Health Care'),
(1701, 'https://ror.org/01zy11s57', 'en', 1, 'https://ror.org/01zy11s57 North Tyneside General Hospital'),
(1702, 'https://ror.org/01zy69h55', 'en', 1, 'https://ror.org/01zy69h55 401 General Military Hospital of Athens 401 Γενικό Στρατιωτικό Νοσοκομείο Αθηνών'),
(1703, 'https://ror.org/01zyevp23', 'en', 1, 'https://ror.org/01zyevp23 Musgrave Park Hospital'),
(1704, 'https://ror.org/020268t49', 'de', 1, 'https://ror.org/020268t49 Papiertechnische Stiftung'),
(1705, 'https://ror.org/0203evn05', 'en', 1, 'https://ror.org/0203evn05 Federation of American Hospitals'),
(1706, 'https://ror.org/02049v059', 'hr', 1, 'https://ror.org/02049v059 Opća bolnica Karlovac'),
(1707, 'https://ror.org/0204pdj19', 'en', 1, 'https://ror.org/0204pdj19 Institute For European Environmental Policy'),
(1708, 'https://ror.org/0209dk158', 'en', 1, 'https://ror.org/0209dk158 Lowell Observatory');
INSERT INTO `rors` VALUES
(1709, 'https://ror.org/020afzk37', 'no_lang_code', 1, 'https://ror.org/020afzk37 Mirus Bio (United States)'),
(1710, 'https://ror.org/020b6jb08', 'en', 1, 'https://ror.org/020b6jb08 Canadian Mathematical Society'),
(1711, 'https://ror.org/020cmsc29', 'en', 1, 'https://ror.org/020cmsc29 Rajendra Memorial Research Institute of Medical Sciences'),
(1712, 'https://ror.org/020gwz349', 'no_lang_code', 1, 'https://ror.org/020gwz349 Herzog Hospital בית חולים הרצוג'),
(1713, 'https://ror.org/020hchp05', 'en', 1, 'https://ror.org/020hchp05 Integrated Laboratory Systems, Inc.'),
(1714, 'https://ror.org/020jbrt22', 'en', 1, 'https://ror.org/020jbrt22 Tbilisi State Medical University Թբիլիսիի պետական բժշկական համալսարան თბილისის სახელმწიფო სამედიცინო უნივერსიტეტი'),
(1715, 'https://ror.org/020jkns84', 'en', 1, 'https://ror.org/020jkns84 Foundation University Medical College'),
(1716, 'https://ror.org/020k76687', 'no_lang_code', 1, 'https://ror.org/020k76687 Autonomous Operator of Parisian Transports Régie Autonome des Transports Parisiens (France)'),
(1717, 'https://ror.org/020k7fn51', 'no_lang_code', 1, 'https://ror.org/020k7fn51 Information Management Services'),
(1718, 'https://ror.org/020m4km16', 'en', 1, 'https://ror.org/020m4km16 Bexar County Medical Examiner''s Office'),
(1719, 'https://ror.org/020nckd56', 'pt', 1, 'https://ror.org/020nckd56 Instituto Superior de Ciências da Administração'),
(1720, 'https://ror.org/020q46z35', 'en', 1, 'https://ror.org/020q46z35 University of Bangui Université de Bangui'),
(1721, 'https://ror.org/020qgp237', 'no_lang_code', 1, 'https://ror.org/020qgp237 DuPont (Canada)'),
(1722, 'https://ror.org/020rayx20', 'tr', 1, 'https://ror.org/020rayx20 Konya Eğitim ve Araştırma Hastanesi'),
(1723, 'https://ror.org/020rmtx45', 'no_lang_code', 1, 'https://ror.org/020rmtx45 Envirogen (United States)'),
(1724, 'https://ror.org/020rvjj03', 'en', 1, 'https://ror.org/020rvjj03 Satakunta Central Hospital'),
(1725, 'https://ror.org/020rzx487', 'en', 1, 'https://ror.org/020rzx487 Sheba Medical Center'),
(1726, 'https://ror.org/020sa1s57', 'en', 1, 'https://ror.org/020sa1s57 Aomori University of Health and Welfare 青森県立保健大学'),
(1727, 'https://ror.org/020vmqv16', 'en', 1, 'https://ror.org/020vmqv16 Roosevelt University'),
(1728, 'https://ror.org/020wf1g18', 'en', 1, 'https://ror.org/020wf1g18 Huron Hospital'),
(1729, 'https://ror.org/0213f0637', 'it', 1, 'https://ror.org/0213f0637 Azienda Ospedaliero Universitaria Ospedali Riuniti'),
(1730, 'https://ror.org/0217hb928', 'en', 1, 'https://ror.org/0217hb928 Middlebury College'),
(1731, 'https://ror.org/02182hd81', 'pt', 1, 'https://ror.org/02182hd81 Escola do Serviço de Saúde Militar'),
(1732, 'https://ror.org/021959v84', 'fr', 1, 'https://ror.org/021959v84 Hôpital Saint-André'),
(1733, 'https://ror.org/0219djn76', 'en', 1, 'https://ror.org/0219djn76 Rush Children''s Hospital'),
(1734, 'https://ror.org/0219m2k96', 'en', 1, 'https://ror.org/0219m2k96 Decision Research'),
(1735, 'https://ror.org/0219xsk19', 'fr', 1, 'https://ror.org/0219xsk19 Hôpital Saint Joseph'),
(1736, 'https://ror.org/021a7pw18', 'en', 1, 'https://ror.org/021a7pw18 New York City College of Technology'),
(1737, 'https://ror.org/021aj5d10', 'en', 1, 'https://ror.org/021aj5d10 Dr. R. Ahmed Dental College and Hospital ডাঃ আর আহমেদ ডেন্টাল কলেজ ও হাসপাতাল'),
(1738, 'https://ror.org/021bj7008', 'no_lang_code', 1, 'https://ror.org/021bj7008 Meitetsu Hospital 名鉄病院'),
(1739, 'https://ror.org/021dmtc66', 'en', 1, 'https://ror.org/021dmtc66 Regional Hospital Horsens Regionshospitalet Horsens'),
(1740, 'https://ror.org/021e5j056', 'en', 1, 'https://ror.org/021e5j056 Kuwait University جامعة الكويت'),
(1741, 'https://ror.org/021jxzw96', 'it', 1, 'https://ror.org/021jxzw96 Azienda Ospedaliera S.Giuseppe Moscati'),
(1742, 'https://ror.org/021kgjd57', 'en', 1, 'https://ror.org/021kgjd57 Long Beach Memorial Medical Center'),
(1743, 'https://ror.org/021m54z79', 'no_lang_code', 1, 'https://ror.org/021m54z79 Takara (Japan) 宝ホールディングス株式会社'),
(1744, 'https://ror.org/021nb2v44', 'en', 1, 'https://ror.org/021nb2v44 Medical College and Hospital, Kolkata कलकत्ता मेडिकल कॉलेज কলকাতা মেডিক্যাল কলেজ ও হাসপাতাল'),
(1745, 'https://ror.org/021qvjc46', 'no_lang_code', 1, 'https://ror.org/021qvjc46 Physical Sciences (United States)'),
(1746, 'https://ror.org/021rvrs67', 'ca', 1, 'https://ror.org/021rvrs67 Hospital Sant Pau i Santa Tecla'),
(1747, 'https://ror.org/021wsw395', 'fr', 1, 'https://ror.org/021wsw395 Hôpital Fontmaure'),
(1748, 'https://ror.org/021wvan87', 'no_lang_code', 1, 'https://ror.org/021wvan87 Qi2'),
(1749, 'https://ror.org/021x6km63', 'en', 1, 'https://ror.org/021x6km63 Kirwan Health Campus'),
(1750, 'https://ror.org/021zm6p18', 'en', 1, 'https://ror.org/021zm6p18 Norfolk and Norwich University Hospital'),
(1751, 'https://ror.org/022261z88', 'en', 1, 'https://ror.org/022261z88 Evans Army Community Hospital'),
(1752, 'https://ror.org/022296476', 'en', 1, 'https://ror.org/022296476 National Kyushu Medical Center 国立病院機構 九州医療センター'),
(1753, 'https://ror.org/0222am037', 'it', 1, 'https://ror.org/0222am037 Ospedaliero Sirai'),
(1754, 'https://ror.org/0222df516', 'en', 1, 'https://ror.org/0222df516 Probity Medical Research'),
(1755, 'https://ror.org/0222p1e69', 'en', 1, 'https://ror.org/0222p1e69 Eugene Applebaum College of Pharmacy and Health Sciences'),
(1756, 'https://ror.org/0223apb60', 'en', 1, 'https://ror.org/0223apb60 Mahatma Gandhi Memorial Medical College'),
(1757, 'https://ror.org/0226env10', 'no_lang_code', 1, 'https://ror.org/0226env10 Sociometrics Corporation'),
(1758, 'https://ror.org/0228w5t68', 'en', 1, 'https://ror.org/0228w5t68 KK Women''s and Children''s Hospital'),
(1759, 'https://ror.org/0229c7854', 'en', 1, 'https://ror.org/0229c7854 Massachusetts Mental Health Center'),
(1760, 'https://ror.org/022a11m05', 'no_lang_code', 1, 'https://ror.org/022a11m05 Iwaki Kyoritsu General Hospital いわき共立総合病院'),
(1761, 'https://ror.org/022arq532', 'en', 1, 'https://ror.org/022arq532 Prince of Wales Hospital'),
(1762, 'https://ror.org/022d5qt08', 'de', 1, 'https://ror.org/022d5qt08 Bundesforschungsinstitut für Kulturpflanzen, Julius Kühn-Institut Federal Research Centre for Cultivated Plants'),
(1763, 'https://ror.org/022ekqa73', 'en', 1, 'https://ror.org/022ekqa73 National Animal Husbandry Service 全国畜牧总站'),
(1764, 'https://ror.org/022em3k58', 'en', 1, 'https://ror.org/022em3k58 De Duve Instituut L''Institut de Duve de Duve Institute'),
(1765, 'https://ror.org/022gnbj15', 'en', 1, 'https://ror.org/022gnbj15 Louisiana State University System'),
(1766, 'https://ror.org/022h0tq76', 'en', 1, 'https://ror.org/022h0tq76 Kanagawa Children''s Medical Center 神奈川県立こども医療センター'),
(1767, 'https://ror.org/022j3nr24', 'en', 1, 'https://ror.org/022j3nr24 Hospital central de Kamuzu Kamuzu Central Hospital'),
(1768, 'https://ror.org/022jeg055', 'en', 1, 'https://ror.org/022jeg055 Dallas Diabetes Research Center'),
(1769, 'https://ror.org/022k36x48', 'no_lang_code', 1, 'https://ror.org/022k36x48 Taylor Wimpey (United Kingdom)'),
(1770, 'https://ror.org/022k8bt28', 'en', 1, 'https://ror.org/022k8bt28 Nishi Eye Hospital 西眼科病院'),
(1771, 'https://ror.org/022mjvt30', 'en', 1, 'https://ror.org/022mjvt30 Japanese Red Cross Fukuoka Hospital 福岡赤十字病院'),
(1772, 'https://ror.org/022mtcz62', 'en', 1, 'https://ror.org/022mtcz62 Melbourne Centre for Nanofabrication'),
(1773, 'https://ror.org/022qy2d08', 'en', 1, 'https://ror.org/022qy2d08 Brenau University'),
(1774, 'https://ror.org/022rkxt86', 'no_lang_code', 1, 'https://ror.org/022rkxt86 Trojan Technologies (Canada)'),
(1775, 'https://ror.org/022swbj46', 'en', 1, 'https://ror.org/022swbj46 National Brain Research Centre राष्ट्रीय मस्तिष्क अनुसंधान केंद्र, मानेसर, हरियाणा'),
(1776, 'https://ror.org/022v32y85', 'en', 1, 'https://ror.org/022v32y85 Andreas Sygros Hospital Ανδρέας Συγγρός Νοσοκομείο'),
(1777, 'https://ror.org/022vd9g66', 'fr', 1, 'https://ror.org/022vd9g66 Hôpital Orthopédique de la Suisse Romande'),
(1778, 'https://ror.org/022wqqf69', 'es', 1, 'https://ror.org/022wqqf69 Centre for Technical Research and Studies Centro de Estudios e Investigaciones Técnicas de Gipuzkoa'),
(1779, 'https://ror.org/022xmez67', 'no_lang_code', 1, 'https://ror.org/022xmez67 Microbiotix (United States)'),
(1780, 'https://ror.org/022yckc24', 'pt', 1, 'https://ror.org/022yckc24 Hospital Universitário Evangélico de Curitiba'),
(1781, 'https://ror.org/022yvqh08', 'en', 1, 'https://ror.org/022yvqh08 University College Hospital, Ibadan'),
(1782, 'https://ror.org/0230h1q47', 'en', 1, 'https://ror.org/0230h1q47 King Fahd Hospital of the University مستشفى جامعة الملك فيصل'),
(1783, 'https://ror.org/0231d2y50', 'en', 1, 'https://ror.org/0231d2y50 Lenox Hill Hospital'),
(1784, 'https://ror.org/0231m7n15', 'en', 1, 'https://ror.org/0231m7n15 Lake Regional Hospital'),
(1785, 'https://ror.org/023733d09', 'es', 1, 'https://ror.org/023733d09 Hospital de l''Esperança'),
(1786, 'https://ror.org/02378jc90', 'en', 1, 'https://ror.org/02378jc90 Raja Ramanna Centre for Advanced Technology राजा रामण्णा अत्याधुनिक तंत्रज्ञान केंद्र राजा रामन्ना प्रगत प्रौद्योगिकी केन्द्र രാജാ രാമണ്ണ സെന്റർ ഫോർ അഡ്വാൻസ്ഡ് ടെക്നോളജി'),
(1787, 'https://ror.org/0238gtq84', 'en', 1, 'https://ror.org/0238gtq84 Rajavithi Hospital'),
(1788, 'https://ror.org/0238gz740', 'en', 1, 'https://ror.org/0238gz740 Institute for Theoretical and Experimental Physics Институт теоретической и экспериментальной физики'),
(1789, 'https://ror.org/023bq8521', 'en', 1, 'https://ror.org/023bq8521 Saint Petersburg State Electrotechnical University Санкт-Петербургский государственный электротехнический университет'),
(1790, 'https://ror.org/023cara48', 'en', 1, 'https://ror.org/023cara48 Center for Epidemiology and Animal Health'),
(1791, 'https://ror.org/023cbtv31', 'en', 1, 'https://ror.org/023cbtv31 Madrid Health Service Servicio Madrileño de Salud'),
(1792, 'https://ror.org/023cpc062', 'no_lang_code', 1, 'https://ror.org/023cpc062 DNA Link (South Korea)'),
(1793, 'https://ror.org/023dma244', 'en', 1, 'https://ror.org/023dma244 Colchester Hospital'),
(1794, 'https://ror.org/023e6jq80', 'en', 1, 'https://ror.org/023e6jq80 Güven Hastanesi Güven Hospital'),
(1795, 'https://ror.org/023fgmp71', 'en', 1, 'https://ror.org/023fgmp71 East Georgia State College'),
(1796, 'https://ror.org/023gt0394', 'en', 1, 'https://ror.org/023gt0394 St Richard''s Hospital'),
(1797, 'https://ror.org/023hj8v22', 'en', 1, 'https://ror.org/023hj8v22 Memorial Hospital'),
(1798, 'https://ror.org/023kfg220', 'en', 1, 'https://ror.org/023kfg220 National Institute for Agro-Environmental Sciences 農業環境変動研究センター'),
(1799, 'https://ror.org/023m35461', 'en', 1, 'https://ror.org/023m35461 Istanbul Bilim University İstanbul Bilim Üniversitesi'),
(1800, 'https://ror.org/023pqj155', 'es', 1, 'https://ror.org/023pqj155 Hospital Santiago Apostol'),
(1801, 'https://ror.org/023q4bk22', 'en', 1, 'https://ror.org/023q4bk22 Central Queensland University'),
(1802, 'https://ror.org/023r6xh67', 'en', 1, 'https://ror.org/023r6xh67 Ignatius Hospital Sint Ignatiusziekenhuis'),
(1803, 'https://ror.org/023wqmm33', 'en', 1, 'https://ror.org/023wqmm33 DeKalb Medical Center'),
(1804, 'https://ror.org/023z51242', 'en', 1, 'https://ror.org/023z51242 Enterprise Ireland'),
(1805, 'https://ror.org/023znxa73', 'en', 1, 'https://ror.org/023znxa73 St Petersburg University Санкт-Петербургский государственный университет'),
(1806, 'https://ror.org/02405mj67', 'en', 1, 'https://ror.org/02405mj67 Belfast City Hospital'),
(1807, 'https://ror.org/02408be69', 'en', 1, 'https://ror.org/02408be69 National Center of Hygiene Medical Ecology and Nutrition'),
(1808, 'https://ror.org/0240cjw65', 'fr', 1, 'https://ror.org/0240cjw65 Polyclinique de Bordeaux-Tondu'),
(1809, 'https://ror.org/0241b8f19', 'en', 1, 'https://ror.org/0241b8f19 Gomal University جامعہ گومل'),
(1810, 'https://ror.org/0241gfe92', 'en', 1, 'https://ror.org/0241gfe92 University of Minnesota, Waseca'),
(1811, 'https://ror.org/0242qs713', 'en', 1, 'https://ror.org/0242qs713 Birmingham VA Medical Center'),
(1812, 'https://ror.org/02436cs38', 'no_lang_code', 1, 'https://ror.org/02436cs38 Unilever (Netherlands)'),
(1813, 'https://ror.org/0243t3259', 'en', 1, 'https://ror.org/0243t3259 Militair Hospitaal Koningin Astrid Queen Astrid Military Hospital'),
(1814, 'https://ror.org/0248gc218', 'en', 1, 'https://ror.org/0248gc218 Adler Planetarium'),
(1815, 'https://ror.org/0249v7n71', 'en', 1, 'https://ror.org/0249v7n71 Institute for Computer Science and Control Magyar Tudományos Akadémia Számítástechnikai és Automatizálási Kutatóintézete'),
(1816, 'https://ror.org/024amfv85', 'en', 1, 'https://ror.org/024amfv85 Federal Agency for Health and Social Development Федеральное агентство по здравоохранению и социальному развитию'),
(1817, 'https://ror.org/024bsrp32', 'en', 1, 'https://ror.org/024bsrp32 Casa Colina Centers for Rehabilitation'),
(1818, 'https://ror.org/024c2fq17', 'en', 1, 'https://ror.org/024c2fq17 Sharif University of Technology دانشگاه صنعتی شریف'),
(1819, 'https://ror.org/024cn3w16', 'fr', 1, 'https://ror.org/024cn3w16 Centre Hospitalier Philippe Pinel'),
(1820, 'https://ror.org/024daed65', 'no_lang_code', 1, 'https://ror.org/024daed65 Social and Scientific Systems (United States)'),
(1821, 'https://ror.org/024esvk12', 'en', 1, 'https://ror.org/024esvk12 Saint Barnabas Medical Center'),
(1822, 'https://ror.org/024eyyq66', 'en', 1, 'https://ror.org/024eyyq66 Armed Forces Hospital'),
(1823, 'https://ror.org/024pgmp43', 'hu', 1, 'https://ror.org/024pgmp43 St. John''s Hospital Szent János Kórház'),
(1824, 'https://ror.org/024q5j973', 'en', 1, 'https://ror.org/024q5j973 Hacettepe University Hospital'),
(1825, 'https://ror.org/024ran220', 'en', 1, 'https://ror.org/024ran220 Kansai Rosai Hospital 関西ろうさい病院'),
(1826, 'https://ror.org/024xs2z82', 'no_lang_code', 1, 'https://ror.org/024xs2z82 ArcelorMittal (France)'),
(1827, 'https://ror.org/024xyyq03', 'en', 1, 'https://ror.org/024xyyq03 Nashville VA Medical Center'),
(1828, 'https://ror.org/024yc3q36', 'en', 1, 'https://ror.org/024yc3q36 Tottori University 鳥取大学'),
(1829, 'https://ror.org/024zq6d87', 'en', 1, 'https://ror.org/024zq6d87 Sisters of Mercy Health System'),
(1830, 'https://ror.org/025020z88', 'en', 1, 'https://ror.org/025020z88 Hunan Cancer Hospital'),
(1831, 'https://ror.org/0250jpt55', 'en', 1, 'https://ror.org/0250jpt55 Saurashtra University'),
(1832, 'https://ror.org/0252jr437', 'no_lang_code', 1, 'https://ror.org/0252jr437 Starks Associates'),
(1833, 'https://ror.org/02550n020', 'en', 1, 'https://ror.org/02550n020 European Synchrotron Radiation Facility'),
(1834, 'https://ror.org/02558wk32', 'en', 1, 'https://ror.org/02558wk32 Islamic Azad University, Arak دانشگاه آزاد اسلامی واحد اراک'),
(1835, 'https://ror.org/025714n80', 'es', 1, 'https://ror.org/025714n80 Hospital de Galdakao'),
(1836, 'https://ror.org/025821s54', 'en', 1, 'https://ror.org/025821s54 University Hospital Coventry'),
(1837, 'https://ror.org/0258b0610', 'en', 1, 'https://ror.org/0258b0610 Kansas Department of Health and Environment'),
(1838, 'https://ror.org/0258h0g75', 'en', 1, 'https://ror.org/0258h0g75 Rajendra Institute of Medical Sciences'),
(1839, 'https://ror.org/0259e4473', 'en', 1, 'https://ror.org/0259e4473 The Military General Hospital of Beijing PLA 中国人民解放军空军总医院'),
(1840, 'https://ror.org/025bm0k33', 'no_lang_code', 1, 'https://ror.org/025bm0k33 Kawasaki Municipal Hospital 川崎市立川崎病院'),
(1841, 'https://ror.org/025chrz76', 'en', 1, 'https://ror.org/025chrz76 Marshfield Clinic'),
(1842, 'https://ror.org/025fyfd20', 'en', 1, 'https://ror.org/025fyfd20 Children''s Hospital of Zhejiang University'),
(1843, 'https://ror.org/025h1m602', 'no_lang_code', 1, 'https://ror.org/025h1m602 Konkuk University 건국대학교'),
(1844, 'https://ror.org/025kav035', 'en', 1, 'https://ror.org/025kav035 Ripon College'),
(1845, 'https://ror.org/025kb2624', 'en', 1, 'https://ror.org/025kb2624 Ho Chi Minh City Medicine and Pharmacy University Trường Đại học Y Dược Thành phố Hồ Chí Minh Université de pharmacie et médecine d''hô-chi-minh-ville'),
(1846, 'https://ror.org/025n13r50', 'en', 1, 'https://ror.org/025n13r50 Adelphi University'),
(1847, 'https://ror.org/025nszc09', 'no_lang_code', 1, 'https://ror.org/025nszc09 Canadian Natural Resources'),
(1848, 'https://ror.org/025ny1854', 'en', 1, 'https://ror.org/025ny1854 George Eliot Hospital'),
(1849, 'https://ror.org/025q7sd17', 'es', 1, 'https://ror.org/025q7sd17 Hospital General Dr. Manuel Gea Gonzalez'),
(1850, 'https://ror.org/025sdjb25', 'fr', 1, 'https://ror.org/025sdjb25 Centre Hospitalier et Universitaire de Brazzaville'),
(1851, 'https://ror.org/025sthg37', 'en', 1, 'https://ror.org/025sthg37 Queen Elizabeth Central Hospital'),
(1852, 'https://ror.org/025wfj672', 'en', 1, 'https://ror.org/025wfj672 MRC Unit the Gambia'),
(1853, 'https://ror.org/025xmgt30', 'en', 1, 'https://ror.org/025xmgt30 Oregon Social Learning Center'),
(1854, 'https://ror.org/025z8ah66', 'en', 1, 'https://ror.org/025z8ah66 Public Health Ontario Santé publique Ontario'),
(1855, 'https://ror.org/0260bkf37', 'no_lang_code', 1, 'https://ror.org/0260bkf37 NuroRestore (United States)'),
(1856, 'https://ror.org/0261g6j35', 'en', 1, 'https://ror.org/0261g6j35 Chaudhary Charan Singh Haryana Agricultural University चौधरी चरण सिंह हरियाणा कृषि विश्वविद्यालय சௌதரி சரண் சிங் அரியானா வேளாண்மை பல்கலைக்கழகம்'),
(1857, 'https://ror.org/0262qgk29', 'en', 1, 'https://ror.org/0262qgk29 National Research Mordovia State University Мордовский государственный университет имени Н. П. Огарёва'),
(1858, 'https://ror.org/026452768', 'no_lang_code', 1, 'https://ror.org/026452768 PTV Group (Germany)'),
(1859, 'https://ror.org/026492508', 'en', 1, 'https://ror.org/026492508 Spalding University'),
(1860, 'https://ror.org/0264d9934', 'en', 1, 'https://ror.org/0264d9934 Royal Aberdeen Children''s Hospital'),
(1861, 'https://ror.org/0267zkr58', 'no_lang_code', 1, 'https://ror.org/0267zkr58 Safdarjang Hospital'),
(1862, 'https://ror.org/0269fmf70', 'en', 1, 'https://ror.org/0269fmf70 St. Mary''s Hospital'),
(1863, 'https://ror.org/026as0d42', 'es', 1, 'https://ror.org/026as0d42 Hospital Angeles Pedregal'),
(1864, 'https://ror.org/026b7da27', 'en', 1, 'https://ror.org/026b7da27 Government Medical College'),
(1865, 'https://ror.org/026dp0v66', 'en', 1, 'https://ror.org/026dp0v66 Union for International Cancer Control Union internationale contre le cancer'),
(1866, 'https://ror.org/026dr4n55', 'en', 1, 'https://ror.org/026dr4n55 Federal Medical Centre'),
(1867, 'https://ror.org/026e9yy16', 'en', 1, 'https://ror.org/026e9yy16 Affiliated Hospital of Qingdao University'),
(1868, 'https://ror.org/026gtm069', 'en', 1, 'https://ror.org/026gtm069 Maryknoll Medical Center 메리놀병원'),
(1869, 'https://ror.org/026mnhe80', 'en', 1, 'https://ror.org/026mnhe80 Chongqing Academy of Animal Science 重庆市畜牧科学院'),
(1870, 'https://ror.org/026n33e29', 'en', 1, 'https://ror.org/026n33e29 Cohen Children''s Medical Center'),
(1871, 'https://ror.org/026p6d134', 'en', 1, 'https://ror.org/026p6d134 Memorial Health University Medical Center'),
(1872, 'https://ror.org/026qp7597', 'tr', 1, 'https://ror.org/026qp7597 Zekai Tahir Burak Kadın Sağlığı Eğitim ve Araştırma Hastanesi'),
(1873, 'https://ror.org/026r1ac43', 'no_lang_code', 1, 'https://ror.org/026r1ac43 Fukuyama City Hospital 福山市民病院'),
(1874, 'https://ror.org/026s99n34', 'en', 1, 'https://ror.org/026s99n34 West Virginia State Department of Health and Human Resources'),
(1875, 'https://ror.org/026tktq31', 'en', 1, 'https://ror.org/026tktq31 Solapur University सोलापूर विद्यापीठ'),
(1876, 'https://ror.org/026vvkz19', 'en', 1, 'https://ror.org/026vvkz19 National Interuniversity Consortium for the Physical Sciences of Matter'),
(1877, 'https://ror.org/026xdcm93', 'en', 1, 'https://ror.org/026xdcm93 Royal Cornwall Hospital Trust'),
(1878, 'https://ror.org/02722hp10', 'no_lang_code', 1, 'https://ror.org/02722hp10 Assaf Harofeh Medical Center'),
(1879, 'https://ror.org/027487t94', 'en', 1, 'https://ror.org/027487t94 Aurora University'),
(1880, 'https://ror.org/0277g6a74', 'en', 1, 'https://ror.org/0277g6a74 Douglass Hanly Moir Pathology'),
(1881, 'https://ror.org/0277n1841', 'en', 1, 'https://ror.org/0277n1841 University of Tennessee Medical Center'),
(1882, 'https://ror.org/027970q43', 'no_lang_code', 1, 'https://ror.org/027970q43 Emergent BioSolutions (United States)'),
(1883, 'https://ror.org/02797hn66', 'en', 1, 'https://ror.org/02797hn66 Dr. Ram Manohar Lohia Avadh University डॉ राम मनोहर लोहिया अवध विश्वविद्यालय'),
(1884, 'https://ror.org/027b0sp52', 'no_lang_code', 1, 'https://ror.org/027b0sp52 Kema International (Netherlands)'),
(1885, 'https://ror.org/027dft319', 'en', 1, 'https://ror.org/027dft319 Bethesda Hospital East'),
(1886, 'https://ror.org/027evcf19', 'tr', 1, 'https://ror.org/027evcf19 Özel Ortadoğu 19 Mayıs Hastanesi'),
(1887, 'https://ror.org/027f9rb06', 'en', 1, 'https://ror.org/027f9rb06 Shimonoseki City Hospital 下関市立市民病院'),
(1888, 'https://ror.org/027fvqp63', 'no_lang_code', 1, 'https://ror.org/027fvqp63 Emmes (United States)'),
(1889, 'https://ror.org/027j9rp38', 'en', 1, 'https://ror.org/027j9rp38 Inje University Sanggye Paik Hospital'),
(1890, 'https://ror.org/027mjht27', 'de', 1, 'https://ror.org/027mjht27 Institut Universitaire Kurt Bösch'),
(1891, 'https://ror.org/027nene90', 'no_lang_code', 1, 'https://ror.org/027nene90 Sugiyama Jogakuen University 椙山女学園大学'),
(1892, 'https://ror.org/027nk1z82', 'no_lang_code', 1, 'https://ror.org/027nk1z82 INRAD (United States)'),
(1893, 'https://ror.org/027pqks09', 'no_lang_code', 1, 'https://ror.org/027pqks09 S&N (Germany)'),
(1894, 'https://ror.org/027q9k466', 'en', 1, 'https://ror.org/027q9k466 Alexandra Hospital'),
(1895, 'https://ror.org/027rkpb34', 'en', 1, 'https://ror.org/027rkpb34 Salford Royal Hospital'),
(1896, 'https://ror.org/027rt1g28', 'no_lang_code', 1, 'https://ror.org/027rt1g28 Radiation Monitoring Devices (United States)'),
(1897, 'https://ror.org/027ry4q41', 'en', 1, 'https://ror.org/027ry4q41 Miller Children''s & Women''s Hospital'),
(1898, 'https://ror.org/027t58004', 'en', 1, 'https://ror.org/027t58004 Eastern Maine Medical Center'),
(1899, 'https://ror.org/027tvqf96', 'no_lang_code', 1, 'https://ror.org/027tvqf96 CAS Software (Germany)'),
(1900, 'https://ror.org/027v86y62', 'en', 1, 'https://ror.org/027v86y62 El Paso County Public Health'),
(1901, 'https://ror.org/027wyhf03', 'hr', 1, 'https://ror.org/027wyhf03 Klinički Bolnički Centar Rijeka'),
(1902, 'https://ror.org/027x3m696', 'en', 1, 'https://ror.org/027x3m696 Mother Teresa Hospital Qendra Spitalore Universitare Nene Tereza'),
(1903, 'https://ror.org/027xnsa83', 'no_lang_code', 1, 'https://ror.org/027xnsa83 Prapokklao Hospital โรงพยาบาลพระปกเกล้า'),
(1904, 'https://ror.org/027zf7h57', 'en', 1, 'https://ror.org/027zf7h57 Pusan National University Hospital'),
(1905, 'https://ror.org/02827ca86', 'en', 1, 'https://ror.org/02827ca86 Prince of Wales Hospital'),
(1906, 'https://ror.org/0282m7c06', 'no_lang_code', 1, 'https://ror.org/0282m7c06 University of Banja Luka Univerzitet u Banja Luci Универзитет у Бањој Луци'),
(1907, 'https://ror.org/0282qcz50', 'en', 1, 'https://ror.org/0282qcz50 Children''s Hospital of Orange County'),
(1908, 'https://ror.org/02834m470', 'en', 1, 'https://ror.org/02834m470 Chia Nan University of Pharmacy and Science'),
(1909, 'https://ror.org/0283k4z65', 'en', 1, 'https://ror.org/0283k4z65 Anne Arundel Medical Center'),
(1910, 'https://ror.org/02843s885', 'en', 1, 'https://ror.org/02843s885 Behavioral Tech Research, Inc.'),
(1911, 'https://ror.org/0284e2q78', 'en', 1, 'https://ror.org/0284e2q78 American Red Cross Croix-rouge américaine Cruz Roja Americana'),
(1912, 'https://ror.org/0284gmm72', 'fr', 1, 'https://ror.org/0284gmm72 Cité Internationale Universitaire de Paris'),
(1913, 'https://ror.org/0285m5c69', 'nl', 1, 'https://ror.org/0285m5c69 De Wever-Ziekenhuis'),
(1914, 'https://ror.org/0285prp25', 'en', 1, 'https://ror.org/0285prp25 NTT Medical Center NTT東日本関東病院'),
(1915, 'https://ror.org/0286g6711', 'en', 1, 'https://ror.org/0286g6711 Shaoguan University 韶关学院'),
(1916, 'https://ror.org/0287e5797', 'no_lang_code', 1, 'https://ror.org/0287e5797 Siemens (United Kingdom)'),
(1917, 'https://ror.org/0287vk548', 'no_lang_code', 1, 'https://ror.org/0287vk548 Sequella (United States)'),
(1918, 'https://ror.org/0288jxv49', 'en', 1, 'https://ror.org/0288jxv49 Institute of Development Studies'),
(1919, 'https://ror.org/028d75n58', 'es', 1, 'https://ror.org/028d75n58 Hospital El Bierzo'),
(1920, 'https://ror.org/028f19s63', 'en', 1, 'https://ror.org/028f19s63 Dairy Farmers Of Canada'),
(1921, 'https://ror.org/028gzjv13', 'en', 1, 'https://ror.org/028gzjv13 Kaiser Permanente Center for Health Research'),
(1922, 'https://ror.org/028hv5492', 'en', 1, 'https://ror.org/028hv5492 University Hospital Leipzig Universitätsklinikum Leipzig'),
(1923, 'https://ror.org/028jc0449', 'en', 1, 'https://ror.org/028jc0449 Austrian Research Promotion Agency Österreichische Forschungsförderungsgesellschaft'),
(1924, 'https://ror.org/028jh2126', 'en', 1, 'https://ror.org/028jh2126 Al al-Bayt University جامعة آل البيت'),
(1925, 'https://ror.org/028jmfg90', 'it', 1, 'https://ror.org/028jmfg90 Ospedale Koelliker'),
(1926, 'https://ror.org/028jrgj19', 'en', 1, 'https://ror.org/028jrgj19 Multnomah County Health Department'),
(1927, 'https://ror.org/028nq5192', 'en', 1, 'https://ror.org/028nq5192 Affiliated Hospital of Jiangxi College of TCM 江西中医学院附属医院'),
(1928, 'https://ror.org/028rvnd71', 'en', 1, 'https://ror.org/028rvnd71 Temple University Hospital'),
(1929, 'https://ror.org/028sv9734', 'no_lang_code', 1, 'https://ror.org/028sv9734 PotashCorp (Canada)'),
(1930, 'https://ror.org/028v4fg64', 'no_lang_code', 1, 'https://ror.org/028v4fg64 Vattenfall (Sweden)'),
(1931, 'https://ror.org/028vv3s82', 'en', 1, 'https://ror.org/028vv3s82 East Surrey Hospital'),
(1932, 'https://ror.org/028vxwa22', 'en', 1, 'https://ror.org/028vxwa22 Kyoto Prefectural University of Medicine 京都府立医科大学'),
(1933, 'https://ror.org/028xtgx62', 'en', 1, 'https://ror.org/028xtgx62 Albert Schweitzer Hospital Hôpital albert-schweitzer'),
(1934, 'https://ror.org/02917wp91', 'en', 1, 'https://ror.org/02917wp91 Hospital of the University of Pennsylvania'),
(1935, 'https://ror.org/0291hsm26', 'en', 1, 'https://ror.org/0291hsm26 Asahikawa City Hospital 市立旭川病院'),
(1936, 'https://ror.org/0292hc709', 'en', 1, 'https://ror.org/0292hc709 University of Santo Tomas Hospital'),
(1937, 'https://ror.org/0293qmt12', 'en', 1, 'https://ror.org/0293qmt12 NC Department of Health and Human Services'),
(1938, 'https://ror.org/02944xg79', 'en', 1, 'https://ror.org/02944xg79 Laconia Women''s Health Center'),
(1939, 'https://ror.org/02952et24', 'en', 1, 'https://ror.org/02952et24 St. Barnabas Hospital'),
(1940, 'https://ror.org/0296jvb66', 'no_lang_code', 1, 'https://ror.org/0296jvb66 WNET (United States)'),
(1941, 'https://ror.org/0299dqs22', 'en', 1, 'https://ror.org/0299dqs22 JA Toride Medical Center JAとりで総合医療センター'),
(1942, 'https://ror.org/0299ptp31', 'en', 1, 'https://ror.org/0299ptp31 Kaiser Permanente San Rafael Medical Center'),
(1943, 'https://ror.org/029bp0k25', 'en', 1, 'https://ror.org/029bp0k25 University of Central Arkansas'),
(1944, 'https://ror.org/029cz3039', 'en', 1, 'https://ror.org/029cz3039 Kijabe Hospital'),
(1945, 'https://ror.org/029dttz57', 'en', 1, 'https://ror.org/029dttz57 Resurrection Medical Center'),
(1946, 'https://ror.org/029es6637', 'en', 1, 'https://ror.org/029es6637 Alaska Native Tribal Health Consortium'),
(1947, 'https://ror.org/029f8s748', 'en', 1, 'https://ror.org/029f8s748 Canadian Science Centre for Human and Animal Health'),
(1948, 'https://ror.org/029gksw03', 'en', 1, 'https://ror.org/029gksw03 Semnan University دانشگاه سمنان'),
(1949, 'https://ror.org/029gprt07', 'en', 1, 'https://ror.org/029gprt07 Dunedin Public Hospital'),
(1950, 'https://ror.org/029gr6k74', 'en', 1, 'https://ror.org/029gr6k74 Medical Society of Delaware'),
(1951, 'https://ror.org/029hept94', 'en', 1, 'https://ror.org/029hept94 Alexandra Hospital'),
(1952, 'https://ror.org/029hzjx43', 'en', 1, 'https://ror.org/029hzjx43 Rappaport Family Institute for Research in the Medical Sciences'),
(1953, 'https://ror.org/029jj9438', 'en', 1, 'https://ror.org/029jj9438 Troy University'),
(1954, 'https://ror.org/029njb796', 'en', 1, 'https://ror.org/029njb796 Perm State University Пермский государственный университет'),
(1955, 'https://ror.org/029nzwk08', 'en', 1, 'https://ror.org/029nzwk08 Levanger Hospital Sykehuset Levanger'),
(1956, 'https://ror.org/029rx2040', 'en', 1, 'https://ror.org/029rx2040 Federal Medical Centre'),
(1957, 'https://ror.org/029s9j634', 'en', 1, 'https://ror.org/029s9j634 Cairns Hospital'),
(1958, 'https://ror.org/029t2gr02', 'no_lang_code', 1, 'https://ror.org/029t2gr02 Xenon Pharmaceuticals (Canada)'),
(1959, 'https://ror.org/029tkqm80', 'en', 1, 'https://ror.org/029tkqm80 St. Vincent''s University Hospital'),
(1960, 'https://ror.org/029tn5b56', 'en', 1, 'https://ror.org/029tn5b56 Regina General Hospital'),
(1961, 'https://ror.org/029wb5j17', 'en', 1, 'https://ror.org/029wb5j17 Our Lady of the Lake University'),
(1962, 'https://ror.org/029wq9x81', 'en', 1, 'https://ror.org/029wq9x81 Sichuan Cancer Hospital 四川省肿瘤研究所'),
(1963, 'https://ror.org/029x6kq07', 'en', 1, 'https://ror.org/029x6kq07 Regina Qu''Appelle Health Region'),
(1964, 'https://ror.org/02a1et264', 'en', 1, 'https://ror.org/02a1et264 Blackburn College'),
(1965, 'https://ror.org/02a2vbq68', 'en', 1, 'https://ror.org/02a2vbq68 Nagoya Memorial Hospital 名古屋記念病院'),
(1966, 'https://ror.org/02a37xs76', 'en', 1, 'https://ror.org/02a37xs76 Health Services Academy'),
(1967, 'https://ror.org/02a5q3y73', 'es', 1, 'https://ror.org/02a5q3y73 Hospital Universitario HM Madrid'),
(1968, 'https://ror.org/02a6g3h39', 'en', 1, 'https://ror.org/02a6g3h39 Hawler Medical University جامعة هولير الطبية'),
(1969, 'https://ror.org/02a7yfb86', 'pt', 1, 'https://ror.org/02a7yfb86 Pontifícia Universidade Católica de Goiás Université pontificale catholique de goiás'),
(1970, 'https://ror.org/02aa8kj12', 'en', 1, 'https://ror.org/02aa8kj12 The People''s Hospital of Guangxi Zhuang Autonomous Region 广西壮族自治区人民医院'),
(1971, 'https://ror.org/02ab2dg68', 'en', 1, 'https://ror.org/02ab2dg68 Singleton Hospital Ysbyty Singleton'),
(1972, 'https://ror.org/02adcah05', 'no_lang_code', 1, 'https://ror.org/02adcah05 Doty Scientific (United States)'),
(1973, 'https://ror.org/02adg5v98', 'en', 1, 'https://ror.org/02adg5v98 Nagoya City University Hospital 名古屋市立大学病院'),
(1974, 'https://ror.org/02aea0q64', 'pt', 1, 'https://ror.org/02aea0q64 IADE Superior de Marketing e Publicidade'),
(1975, 'https://ror.org/02af4h012', 'en', 1, 'https://ror.org/02af4h012 Jadavpur University Université jadavpur यादवपुर विश्वविद्यालय যাদবপুর বিশ্ববিদ্যালয় ਜਾਦਵਪੁਰ ਯੂਨੀਵਰਸਿਟੀ જાદવપુર યુનિવર્સિટી జాదవ్ పూర్ విశ్వవిద్యాలయం ಜಾದವ್ ಪುರ ವಿಶ್ವವಿದ್ಯಾಲಯ'),
(1976, 'https://ror.org/02afbf040', 'en', 1, 'https://ror.org/02afbf040 Karachi Medical and Dental College'),
(1977, 'https://ror.org/02ahxbh87', 'en', 1, 'https://ror.org/02ahxbh87 Biomedical Primate Research Centre'),
(1978, 'https://ror.org/02ajrkx50', 'en', 1, 'https://ror.org/02ajrkx50 St. Luke''s Hospital'),
(1979, 'https://ror.org/02aknh966', 'en', 1, 'https://ror.org/02aknh966 Emory University Hospital Midtown'),
(1980, 'https://ror.org/02amggm23', 'en', 1, 'https://ror.org/02amggm23 Trimbos Institute Trimbos instituut'),
(1981, 'https://ror.org/02ap76n24', 'en', 1, 'https://ror.org/02ap76n24 Egyptian Universities Network شبكة الجامعات المصرية'),
(1982, 'https://ror.org/02as1sh25', 'no_lang_code', 1, 'https://ror.org/02as1sh25 Dassault Aviation (France)'),
(1983, 'https://ror.org/02aseym49', 'en', 1, 'https://ror.org/02aseym49 Australian Centre for Disease Preparedness'),
(1984, 'https://ror.org/02atdvd89', 'en', 1, 'https://ror.org/02atdvd89 Sarasota Memorial Hospital'),
(1985, 'https://ror.org/02atpex25', 'es', 1, 'https://ror.org/02atpex25 Hospital Rio Carrion'),
(1986, 'https://ror.org/02ax13658', 'no_lang_code', 1, 'https://ror.org/02ax13658 Barkatullah University'),
(1987, 'https://ror.org/02azxx136', 'en', 1, 'https://ror.org/02azxx136 University of Health Sciences Vientiane ມະຫາວິທະຍາໄລ ວິທະຍາສາດ ສຸຂະພາບ'),
(1988, 'https://ror.org/02b48z609', 'en', 1, 'https://ror.org/02b48z609 University Cancer Center Hamburg Universitäres Cancer Center Hamburg'),
(1989, 'https://ror.org/02b50zn53', 'en', 1, 'https://ror.org/02b50zn53 Université de wilberforce Wilberforce University'),
(1990, 'https://ror.org/02b68mf79', 'it', 1, 'https://ror.org/02b68mf79 Ospedale Santa Maria'),
(1991, 'https://ror.org/02b72da46', 'en', 1, 'https://ror.org/02b72da46 Abbasi Shaheed Hospital عباسی شهيد ہسپتال'),
(1992, 'https://ror.org/02b730m35', 'pt', 1, 'https://ror.org/02b730m35 Instituto Superior de Ciências da Informação e da Administração'),
(1993, 'https://ror.org/02b8m7s43', 'en', 1, 'https://ror.org/02b8m7s43 American Anthropological Association'),
(1994, 'https://ror.org/02bcf5b42', 'no_lang_code', 1, 'https://ror.org/02bcf5b42 Foxconn (Japan)'),
(1995, 'https://ror.org/02beve479', 'en', 1, 'https://ror.org/02beve479 La Salle University Universidad de la Salle Université la Salle'),
(1996, 'https://ror.org/02bfqd210', 'en', 1, 'https://ror.org/02bfqd210 Regions Hospital'),
(1997, 'https://ror.org/02bg8cb41', 'en', 1, 'https://ror.org/02bg8cb41 Alaska Native Medical Center'),
(1998, 'https://ror.org/02bhk3j29', 'es', 1, 'https://ror.org/02bhk3j29 Hospital Virgen de la Concha'),
(1999, 'https://ror.org/02bn0ev09', 'en', 1, 'https://ror.org/02bn0ev09 River Oaks Hospital'),
(2000, 'https://ror.org/02bn97g32', 'en', 1, 'https://ror.org/02bn97g32 National Defense Medical Center'),
(2001, 'https://ror.org/02bnz8785', 'en', 1, 'https://ror.org/02bnz8785 First Affiliated Hospital of Shantou University Medical College 汕头大学医学院第一附属医院'),
(2002, 'https://ror.org/02bqrry13', 'en', 1, 'https://ror.org/02bqrry13 Jerry L. Pettis Memorial VA Medical Center'),
(2003, 'https://ror.org/02bs0cv29', 'en', 1, 'https://ror.org/02bs0cv29 Oklahoma City University'),
(2004, 'https://ror.org/02bste653', 'it', 1, 'https://ror.org/02bste653 Ospedale “M. Bufalini” di Cesena'),
(2005, 'https://ror.org/02bwjrg36', 'en', 1, 'https://ror.org/02bwjrg36 Academia Nacional Superior de Orquestra'),
(2006, 'https://ror.org/02bxrp522', 'en', 1, 'https://ror.org/02bxrp522 Knoxville College'),
(2007, 'https://ror.org/02byvdx91', 'en', 1, 'https://ror.org/02byvdx91 Kobe Rosai Hospital 神戸労災病院'),
(2008, 'https://ror.org/02byvsq24', 'en', 1, 'https://ror.org/02byvsq24 Community Regional Medical Center'),
(2009, 'https://ror.org/02bz74262', 'no_lang_code', 1, 'https://ror.org/02bz74262 Hiram College'),
(2010, 'https://ror.org/02bz7vk34', 'en', 1, 'https://ror.org/02bz7vk34 Kaiser Permanente Redwood City Medical Center'),
(2011, 'https://ror.org/02bzkv281', 'en', 1, 'https://ror.org/02bzkv281 Chengde Medical University 承德医学院'),
(2012, 'https://ror.org/02c1c4p76', 'en', 1, 'https://ror.org/02c1c4p76 Magee Rehabilitation Hospital'),
(2013, 'https://ror.org/02c1pgm26', 'en', 1, 'https://ror.org/02c1pgm26 Royal Inland Hospital'),
(2014, 'https://ror.org/02c2f8975', 'en', 1, 'https://ror.org/02c2f8975 University of Ulsan 울산대학교'),
(2015, 'https://ror.org/02c8hpe74', 'en', 1, 'https://ror.org/02c8hpe74 James J. Peters VA Medical Center'),
(2016, 'https://ror.org/02c8npj93', 'en', 1, 'https://ror.org/02c8npj93 General-Maternity District Hospital Helena Venizelou Περιφερειακό Γενικό Νοσοκομείο - Μαιευτήριο - "ΕΛΕΝΑ ΒΕΝΙΖΕΛΟΥ"'),
(2017, 'https://ror.org/02c97ng92', 'no_lang_code', 1, 'https://ror.org/02c97ng92 ArcelorMittal (Canada)'),
(2018, 'https://ror.org/02caez234', 'en', 1, 'https://ror.org/02caez234 Fuzhou Dermatosis Prevention Hospital 福州市皮肤病防治院'),
(2019, 'https://ror.org/02cbk9w51', 'es', 1, 'https://ror.org/02cbk9w51 Hospital Nacional Dos de Mayo'),
(2020, 'https://ror.org/02cc58y38', 'fr', 1, 'https://ror.org/02cc58y38 Hôpital Debrousse'),
(2021, 'https://ror.org/02ccwf677', 'no_lang_code', 1, 'https://ror.org/02ccwf677 Proportional Technologies'),
(2022, 'https://ror.org/02cetwy62', 'en', 1, 'https://ror.org/02cetwy62 Prince Charles Hospital'),
(2023, 'https://ror.org/02cevbn07', 'en', 1, 'https://ror.org/02cevbn07 Mississippi State Medical Association'),
(2024, 'https://ror.org/02cg59151', 'pt', 1, 'https://ror.org/02cg59151 Hospital Pulido Valente'),
(2025, 'https://ror.org/02cjhb354', 'it', 1, 'https://ror.org/02cjhb354 Azienda Ospedaliera Santa Maria Degli Angeli'),
(2026, 'https://ror.org/02ckh3s34', 'da', 1, 'https://ror.org/02ckh3s34 Herning Regional Hospital Regionshospitalet Herning'),
(2027, 'https://ror.org/02cm2rk35', 'en', 1, 'https://ror.org/02cm2rk35 Raritan Bay Medical Center'),
(2028, 'https://ror.org/02cpwdj94', 'en', 1, 'https://ror.org/02cpwdj94 Kerala Institute of Medical Sciences'),
(2029, 'https://ror.org/02cpzy455', 'en', 1, 'https://ror.org/02cpzy455 424 General Military Hospital 424 Γενικό Στρατιωτικό Νοσοκομείο Θεσσαλονίκης'),
(2030, 'https://ror.org/02cq7de70', 'en', 1, 'https://ror.org/02cq7de70 Counties Manukau District Health Board'),
(2031, 'https://ror.org/02cqgeg62', 'no_lang_code', 1, 'https://ror.org/02cqgeg62 INRA Transfert (France)'),
(2032, 'https://ror.org/02cqyyd50', 'en', 1, 'https://ror.org/02cqyyd50 Nottingham General Hospital'),
(2033, 'https://ror.org/02crz6e12', 'en', 1, 'https://ror.org/02crz6e12 Singapore Eye Research Institute'),
(2034, 'https://ror.org/02csf4f34', 'en', 1, 'https://ror.org/02csf4f34 Busan Medical Center 부산의료원'),
(2035, 'https://ror.org/02ct12k14', 'no_lang_code', 1, 'https://ror.org/02ct12k14 Network Rail'),
(2036, 'https://ror.org/02ct41q97', 'en', 1, 'https://ror.org/02ct41q97 John Brown University'),
(2037, 'https://ror.org/02cv4ah81', 'en', 1, 'https://ror.org/02cv4ah81 Ishikawa Prefectural Central Hospital 石川県立中央病院'),
(2038, 'https://ror.org/02cy9a842', 'en', 1, 'https://ror.org/02cy9a842 Carmel Medical Center'),
(2039, 'https://ror.org/02d07gm56', 'en', 1, 'https://ror.org/02d07gm56 SUNY Korea 한국뉴욕주립대학교'),
(2040, 'https://ror.org/02d09a271', 'pt', 1, 'https://ror.org/02d09a271 Positive University Universidade Positivo'),
(2041, 'https://ror.org/02d0kps43', 'de', 1, 'https://ror.org/02d0kps43 UMIT - Private Universität für Gesundheitswissenschaften, Medizinische Informatik und Technik'),
(2042, 'https://ror.org/02d0tyt78', 'en', 1, 'https://ror.org/02d0tyt78 Silpakorn University มหาวิทยาลัยศิลปากร'),
(2043, 'https://ror.org/02d1ved90', 'tr', 1, 'https://ror.org/02d1ved90 Dokuz Eylül Üniversitesi Hastanesi'),
(2044, 'https://ror.org/02d3bpj67', 'no_lang_code', 1, 'https://ror.org/02d3bpj67 Medical Physics Consultants'),
(2045, 'https://ror.org/02d3k5845', 'en', 1, 'https://ror.org/02d3k5845 St Francis Medical Center'),
(2046, 'https://ror.org/02d439m40', 'en', 1, 'https://ror.org/02d439m40 University Mental Health Research Institute'),
(2047, 'https://ror.org/02d57ed54', 'en', 1, 'https://ror.org/02d57ed54 Sarojini Naidu Medical College सरोजिनी नायडू चिकित्सा महाविद्यालय'),
(2048, 'https://ror.org/02d71t021', 'it', 1, 'https://ror.org/02d71t021 Consorzio Milano Ricerche'),
(2049, 'https://ror.org/02d9k9g58', 'en', 1, 'https://ror.org/02d9k9g58 University of South Carolina Aiken'),
(2050, 'https://ror.org/02dc47z81', 'pt', 1, 'https://ror.org/02dc47z81 Hospital São Teotónio'),
(2051, 'https://ror.org/02dcp1550', 'en', 1, 'https://ror.org/02dcp1550 Central Texas Veterans Health Care System'),
(2052, 'https://ror.org/02df8t483', 'no_lang_code', 1, 'https://ror.org/02df8t483 Bridgepoint (United Kingdom)'),
(2053, 'https://ror.org/02dgbcj80', 'en', 1, 'https://ror.org/02dgbcj80 Southwest Baptist University'),
(2054, 'https://ror.org/02dgmb809', 'no_lang_code', 1, 'https://ror.org/02dgmb809 Numerical Mechanics Applications International (Belgium)'),
(2055, 'https://ror.org/02dktng58', 'en', 1, 'https://ror.org/02dktng58 Institute for Scientific Analysis'),
(2056, 'https://ror.org/02dmc4h32', 'en', 1, 'https://ror.org/02dmc4h32 Providence St. Vincent Medical Center'),
(2057, 'https://ror.org/02dpa2319', 'en', 1, 'https://ror.org/02dpa2319 Cornwall Regional Hospital'),
(2058, 'https://ror.org/02dqqj223', 'en', 1, 'https://ror.org/02dqqj223 East Kent Hospitals University NHS Foundation Trust'),
(2059, 'https://ror.org/02dr19631', 'en', 1, 'https://ror.org/02dr19631 Medical Radiological Research Center Медицинский радиологический научный центр'),
(2060, 'https://ror.org/02dvs1389', 'en', 1, 'https://ror.org/02dvs1389 Laiko General Hospital of Athens'),
(2061, 'https://ror.org/02e0bfh77', 'no_lang_code', 1, 'https://ror.org/02e0bfh77 Bio Chem Analysis Corporation (United States)'),
(2062, 'https://ror.org/02e16g702', 'en', 1, 'https://ror.org/02e16g702 Hokkaido University 北海道大学'),
(2063, 'https://ror.org/02e1cpg76', 'en', 1, 'https://ror.org/02e1cpg76 Hauptman-Woodward Medical Research Institute'),
(2064, 'https://ror.org/02e1t6r96', 'en', 1, 'https://ror.org/02e1t6r96 Maryland Department of Health'),
(2065, 'https://ror.org/02e22bh87', 'en', 1, 'https://ror.org/02e22bh87 Western Infirmary'),
(2066, 'https://ror.org/02e2dtd78', 'en', 1, 'https://ror.org/02e2dtd78 Calcutta National Medical College and Hospital কলিকাতা জাতীয় আয়ুর্বিজ্ঞান বিদ্যামন্দির జాతీయ వైద్య కళాశాల'),
(2067, 'https://ror.org/02e3mzq40', 'en', 1, 'https://ror.org/02e3mzq40 Middlesex London Health Unit'),
(2068, 'https://ror.org/02e5pan03', 'en', 1, 'https://ror.org/02e5pan03 Charlton Memorial Hospital'),
(2069, 'https://ror.org/02e8hzf44', 'en', 1, 'https://ror.org/02e8hzf44 Helsinki University Hospital'),
(2070, 'https://ror.org/02e9zc863', 'en', 1, 'https://ror.org/02e9zc863 Kwangwoon University 광운대학교'),
(2071, 'https://ror.org/02eb0rk31', 'en', 1, 'https://ror.org/02eb0rk31 Association for the Advancement of Artificial Intelligence'),
(2072, 'https://ror.org/02egdz393', 'en', 1, 'https://ror.org/02egdz393 Rocky Mountain University of Health Professions'),
(2073, 'https://ror.org/02ejsvn42', 'en', 1, 'https://ror.org/02ejsvn42 Comité Européen de Normalisation European Committee for Standardization'),
(2074, 'https://ror.org/02emy8e21', 'en', 1, 'https://ror.org/02emy8e21 Kings County Hospital Center'),
(2075, 'https://ror.org/02eqchk86', 'en', 1, 'https://ror.org/02eqchk86 Daejeon University 대전대학교'),
(2076, 'https://ror.org/02erhaz63', 'en', 1, 'https://ror.org/02erhaz63 Lanzhou University Second Hospital'),
(2077, 'https://ror.org/02etexs15', 'en', 1, 'https://ror.org/02etexs15 Children''s Hospital of New Orleans'),
(2078, 'https://ror.org/02evem426', 'pt', 1, 'https://ror.org/02evem426 Escola Superior de Enfermagem de Santa Maria'),
(2079, 'https://ror.org/02ew45630', 'en', 1, 'https://ror.org/02ew45630 Apollo Hospitals'),
(2080, 'https://ror.org/02eyff421', 'en', 1, 'https://ror.org/02eyff421 Ministry of Health'),
(2081, 'https://ror.org/02eypkr92', 'en', 1, 'https://ror.org/02eypkr92 Northwest Hospital and Medical Center'),
(2082, 'https://ror.org/02f2vsx71', 'no_lang_code', 1, 'https://ror.org/02f2vsx71 Hungkuang University'),
(2083, 'https://ror.org/02f30ff69', 'es', 1, 'https://ror.org/02f30ff69 Hospital General Universitario de Ciudad Real'),
(2084, 'https://ror.org/02f38b560', 'pt', 1, 'https://ror.org/02f38b560 Hospital São Rafael'),
(2085, 'https://ror.org/02f3b8e29', 'en', 1, 'https://ror.org/02f3b8e29 Alexandra Hospital 亚历山大医院'),
(2086, 'https://ror.org/02f4tsf92', 'en', 1, 'https://ror.org/02f4tsf92 MRC Centre for Reproductive Health'),
(2087, 'https://ror.org/02f6ghw27', 'fr', 1, 'https://ror.org/02f6ghw27 Hôpital Charles-Nicolle'),
(2088, 'https://ror.org/02f9avj37', 'en', 1, 'https://ror.org/02f9avj37 Hanyang University Guri Hospital 한양대학교구리병원'),
(2089, 'https://ror.org/02f9det96', 'en', 1, 'https://ror.org/02f9det96 University of Hildesheim Universität Hildesheim'),
(2090, 'https://ror.org/02fjqfr36', 'en', 1, 'https://ror.org/02fjqfr36 Wildlife Conservation Society Indonesia'),
(2091, 'https://ror.org/02fjy3w42', 'en', 1, 'https://ror.org/02fjy3w42 Ivanovo State University of Chemistry and Technology Ивановский государственный химико-технологический университет'),
(2092, 'https://ror.org/02fkdpc07', 'fi', 1, 'https://ror.org/02fkdpc07 Kanta-Hämeen Keskussairaala'),
(2093, 'https://ror.org/02fmkev06', 'en', 1, 'https://ror.org/02fmkev06 Building Research Establishment'),
(2094, 'https://ror.org/02fnpv153', 'en', 1, 'https://ror.org/02fnpv153 American Association For Cancer Research'),
(2095, 'https://ror.org/02fppms28', 'en', 1, 'https://ror.org/02fppms28 Missouri Department of Mental Health'),
(2096, 'https://ror.org/02fsmcz03', 'en', 1, 'https://ror.org/02fsmcz03 First Teaching Hospital of Tianjin University of Traditional Chinese Medicine 中国传统医药的天津大学第一附属医院'),
(2097, 'https://ror.org/02fsxgh46', 'fr', 1, 'https://ror.org/02fsxgh46 Hôpital l''Archet'),
(2098, 'https://ror.org/02fv78a45', 'en', 1, 'https://ror.org/02fv78a45 Mother Teresa Women''s University அன்னை தெரசா மகளிர் பல்கலைக்கழகம்'),
(2099, 'https://ror.org/02fv7x872', 'en', 1, 'https://ror.org/02fv7x872 Deenanath Mangeshkar Hospital and Research Center दीनानाथ मंगेशकर रुग्णालय'),
(2100, 'https://ror.org/02fv8hj62', 'es', 1, 'https://ror.org/02fv8hj62 Tecnalia'),
(2101, 'https://ror.org/02fvvnh95', 'en', 1, 'https://ror.org/02fvvnh95 Spenshult Hospital'),
(2102, 'https://ror.org/02fw4cc98', 'en', 1, 'https://ror.org/02fw4cc98 Canadian Agency for Drugs and Technologies in Health'),
(2103, 'https://ror.org/02fw9q305', 'en', 1, 'https://ror.org/02fw9q305 Norwich University of the Arts'),
(2104, 'https://ror.org/02fwb6r86', 'no_lang_code', 1, 'https://ror.org/02fwb6r86 Intelligent Automation (United States)'),
(2105, 'https://ror.org/02fxsj090', 'en', 1, 'https://ror.org/02fxsj090 Kaiser Permanente San Francisco Medical Center'),
(2106, 'https://ror.org/02fyxjb45', 'en', 1, 'https://ror.org/02fyxjb45 Sri Krishnadevaraya University శ్రీ కృష్ణదేవరాయ విశ్వవిద్యాలయము'),
(2107, 'https://ror.org/02fze0e77', 'en', 1, 'https://ror.org/02fze0e77 Star General Hospital 星総合病院'),
(2108, 'https://ror.org/02fzxed89', 'en', 1, 'https://ror.org/02fzxed89 American Statistical Association'),
(2109, 'https://ror.org/02g01ht84', 'en', 1, 'https://ror.org/02g01ht84 First Affiliated Hospital of Kunming Medical University'),
(2110, 'https://ror.org/02g02rq35', 'en', 1, 'https://ror.org/02g02rq35 Centers for Medicare and Medicaid Services'),
(2111, 'https://ror.org/02g1bg244', 'en', 1, 'https://ror.org/02g1bg244 Cheongju St. Mary''s Hospital 청주 성모 병원'),
(2112, 'https://ror.org/02g2pz956', 'en', 1, 'https://ror.org/02g2pz956 Amager Hospital'),
(2113, 'https://ror.org/02g397b52', 'en', 1, 'https://ror.org/02g397b52 Shriners Hospitals for Children - Boston'),
(2114, 'https://ror.org/02g48bh60', 'en', 1, 'https://ror.org/02g48bh60 Chris Hani Baragwanath Hospital'),
(2115, 'https://ror.org/02g6d4t03', 'de', 1, 'https://ror.org/02g6d4t03 Gesellschaft Fur Mathematik Und Datenverarbeitung'),
(2116, 'https://ror.org/02g8ene02', 'en', 1, 'https://ror.org/02g8ene02 Federal Medical Centre'),
(2117, 'https://ror.org/02gaqn537', 'en', 1, 'https://ror.org/02gaqn537 Royal Cornhill Hospital'),
(2118, 'https://ror.org/02gar4w80', 'en', 1, 'https://ror.org/02gar4w80 University Library in Bratislava Univerzitná knižnica v Bratislave'),
(2119, 'https://ror.org/02gcp3110', 'en', 1, 'https://ror.org/02gcp3110 Charing Cross Hospital'),
(2120, 'https://ror.org/02ge60j37', 'en', 1, 'https://ror.org/02ge60j37 Scott & White Memorial Hospital'),
(2121, 'https://ror.org/02gen2282', 'pt', 1, 'https://ror.org/02gen2282 Federal University from Jequitinhonha and Mucuri''s Valleys Universidade Federal dos Vales do Jequitinhonha e Mucuri');
INSERT INTO `rors` VALUES
(2122, 'https://ror.org/02gj19t78', 'en', 1, 'https://ror.org/02gj19t78 Humber River Regional Hospital'),
(2123, 'https://ror.org/02gj58768', 'en', 1, 'https://ror.org/02gj58768 Apollo Gleneagles Hospitals'),
(2124, 'https://ror.org/02gjsze31', 'en', 1, 'https://ror.org/02gjsze31 St. Luke''s Magic Valley Medical Center'),
(2125, 'https://ror.org/02gpdzc63', 'no_lang_code', 1, 'https://ror.org/02gpdzc63 Labor (Italy)'),
(2126, 'https://ror.org/02grymn95', 'en', 1, 'https://ror.org/02grymn95 University of Arkansas – Fort Smith'),
(2127, 'https://ror.org/02gw4vz38', 'en', 1, 'https://ror.org/02gw4vz38 Missouri Institute of Mental Health'),
(2128, 'https://ror.org/02gxymm77', 'en', 1, 'https://ror.org/02gxymm77 Nakamura Memorial Hospital 中村記念病院'),
(2129, 'https://ror.org/02gy6qp39', 'en', 1, 'https://ror.org/02gy6qp39 Allegheny General Hospital'),
(2130, 'https://ror.org/02gzbg991', 'en', 1, 'https://ror.org/02gzbg991 Seattle Pacific University'),
(2131, 'https://ror.org/02gzfb532', 'en', 1, 'https://ror.org/02gzfb532 Taipei City Hospital 臺北市政府'),
(2132, 'https://ror.org/02gzhbc75', 'en', 1, 'https://ror.org/02gzhbc75 Matsudo City Hospital 松戸市立病院'),
(2133, 'https://ror.org/02h1b1x27', 'en', 1, 'https://ror.org/02h1b1x27 Universidad de Los Andes University of the Andes'),
(2134, 'https://ror.org/02h1scg40', 'en', 1, 'https://ror.org/02h1scg40 Maternal and Child Health Care Hospital of Bao''an 宝安区妇幼保健院'),
(2135, 'https://ror.org/02h2j1586', 'en', 1, 'https://ror.org/02h2j1586 Beijing Anzhen Hospital 北京市心肺血管疾病研究所'),
(2136, 'https://ror.org/02h2qwk37', 'en', 1, 'https://ror.org/02h2qwk37 St Vincent Medical Center'),
(2137, 'https://ror.org/02h63je06', 'en', 1, 'https://ror.org/02h63je06 Quality Education for Minorities Network'),
(2138, 'https://ror.org/02h6j4611', 'en', 1, 'https://ror.org/02h6j4611 Princess Margaret Hospital'),
(2139, 'https://ror.org/02h7s7a86', 'en', 1, 'https://ror.org/02h7s7a86 Allen University'),
(2140, 'https://ror.org/02h8a1848', 'en', 1, 'https://ror.org/02h8a1848 Ningxia Medical University 宁夏医科大学'),
(2141, 'https://ror.org/02h905004', 'en', 1, 'https://ror.org/02h905004 Christiana Care Health System'),
(2142, 'https://ror.org/02ha38c24', 'en', 1, 'https://ror.org/02ha38c24 San Joaquin General Hospital'),
(2143, 'https://ror.org/02hbhxa68', 'no_lang_code', 1, 'https://ror.org/02hbhxa68 Airbus (United Kingdom)'),
(2144, 'https://ror.org/02hbrab76', 'es', 1, 'https://ror.org/02hbrab76 Hospital de Clínicas "José de San Martín", Hospital de Clínicas José de San Martín'),
(2145, 'https://ror.org/02he2nc27', 'en', 1, 'https://ror.org/02he2nc27 National Research Tomsk State University Национа́льный иссле́довательский То́мский госуда́рственный университе́т'),
(2146, 'https://ror.org/02hfws565', 'en', 1, 'https://ror.org/02hfws565 Northwick Park Institute for Medical Research'),
(2147, 'https://ror.org/02hjc7j46', 'en', 1, 'https://ror.org/02hjc7j46 Oogziekenhuis Rotterdam Rotterdam Eye Hospital'),
(2148, 'https://ror.org/02hm3sf87', 'no_lang_code', 1, 'https://ror.org/02hm3sf87 European Institute For Research and Strategic Studies In Telecommunications'),
(2149, 'https://ror.org/02hngyx35', 'en', 1, 'https://ror.org/02hngyx35 Rocky Mountain Hospital for Children'),
(2150, 'https://ror.org/02hp4jd32', 'en', 1, 'https://ror.org/02hp4jd32 Summa Barberton Hospital'),
(2151, 'https://ror.org/02hpatg29', 'en', 1, 'https://ror.org/02hpatg29 Fukuoka University Tsukushi Hospital 福岡大学筑紫病院'),
(2152, 'https://ror.org/02hsexy86', 'en', 1, 'https://ror.org/02hsexy86 Riverside Methodist Hospital'),
(2153, 'https://ror.org/02hsneh43', 'en', 1, 'https://ror.org/02hsneh43 Shizuoka City Hospital 静岡市立静岡病院'),
(2154, 'https://ror.org/02hsq0e05', 'no_lang_code', 1, 'https://ror.org/02hsq0e05 EIC Laboratories'),
(2155, 'https://ror.org/02hvsf428', 'nl', 1, 'https://ror.org/02hvsf428 Ziekenhuis Bethesda'),
(2156, 'https://ror.org/02hw5fp67', 'en', 1, 'https://ror.org/02hw5fp67 National Institute for Environmental Studies 国立環境研究所'),
(2157, 'https://ror.org/02hxrag63', 'en', 1, 'https://ror.org/02hxrag63 Memorial Medical Center'),
(2158, 'https://ror.org/02hxrrn62', 'en', 1, 'https://ror.org/02hxrrn62 Interbalkan Medical Center Ιατρικό Διαβαλκανικό Κέντρο'),
(2159, 'https://ror.org/02hy2mb20', 'no_lang_code', 1, 'https://ror.org/02hy2mb20 De Gezondheidsdienst voor Dieren'),
(2160, 'https://ror.org/02hyxwa22', 'en', 1, 'https://ror.org/02hyxwa22 Center for Urban Population Health'),
(2161, 'https://ror.org/02j3enb93', 'no_lang_code', 1, 'https://ror.org/02j3enb93 ArcelorMittal (Spain)'),
(2162, 'https://ror.org/02j3zn476', 'en', 1, 'https://ror.org/02j3zn476 Grand River Hospital'),
(2163, 'https://ror.org/02j4j5k41', 'en', 1, 'https://ror.org/02j4j5k41 John Muir Health'),
(2164, 'https://ror.org/02j7h9426', 'no_lang_code', 1, 'https://ror.org/02j7h9426 Komagino Hospital 駒木野病院'),
(2165, 'https://ror.org/02j8pe645', 'en', 1, 'https://ror.org/02j8pe645 National Academy of Sciences of Belarus Национальная академия наук Беларуси Нацыянальная акадэмія навук Беларусі'),
(2166, 'https://ror.org/02jagkr09', 'en', 1, 'https://ror.org/02jagkr09 Gulbarga University गुलबर्गा विश्वविद्यालय குல்பர்கா பல்கலைக்கழகம் గుల్బర్గా విశ్వవిద్యాలయం ಗುಲ್ಬರ್ಗಾ ವಿಶ್ವವಿದ್ಯಾಲಯ'),
(2167, 'https://ror.org/02jb3jv25', 'en', 1, 'https://ror.org/02jb3jv25 Yuanpei University 元培醫事科技大學'),
(2168, 'https://ror.org/02jb7ng92', 'en', 1, 'https://ror.org/02jb7ng92 Moorgreen Hospital'),
(2169, 'https://ror.org/02jbvhm37', 'en', 1, 'https://ror.org/02jbvhm37 Southeastern Universities Research Association'),
(2170, 'https://ror.org/02jbzrw51', 'en', 1, 'https://ror.org/02jbzrw51 Gallup Indian Medical Center'),
(2171, 'https://ror.org/02jed3n25', 'en', 1, 'https://ror.org/02jed3n25 Sacred Heart Hospital'),
(2172, 'https://ror.org/02jeykk09', 'en', 1, 'https://ror.org/02jeykk09 Imam Khomeini International University دانشگاه بین‌المللی امام خمینی'),
(2173, 'https://ror.org/02jj7t426', 'en', 1, 'https://ror.org/02jj7t426 Dade County Medical Examiner Department'),
(2174, 'https://ror.org/02jj9nh46', 'no_lang_code', 1, 'https://ror.org/02jj9nh46 Artron Bioresearch (Canada)'),
(2175, 'https://ror.org/02jk5qe80', 'en', 1, 'https://ror.org/02jk5qe80 Aalborg Universitetshospital Aalborg University Hospital'),
(2176, 'https://ror.org/02jmkw435', 'en', 1, 'https://ror.org/02jmkw435 Saratov State Medical University Саратовский государственный медицинский университет'),
(2177, 'https://ror.org/02jn27q49', 'en', 1, 'https://ror.org/02jn27q49 Riverview Psychiatric Center'),
(2178, 'https://ror.org/02jqapy19', 'en', 1, 'https://ror.org/02jqapy19 Qingdao Municipal Hospital'),
(2179, 'https://ror.org/02jqn4a25', 'en', 1, 'https://ror.org/02jqn4a25 Ursinus College'),
(2180, 'https://ror.org/02jqtg033', 'en', 1, 'https://ror.org/02jqtg033 Institute for Energy Technology'),
(2181, 'https://ror.org/02jr6tp70', 'en', 1, 'https://ror.org/02jr6tp70 Azienda Ospedaliera Universitaria Federico II Federico II University Hospital'),
(2182, 'https://ror.org/02js37d36', 'en', 1, 'https://ror.org/02js37d36 IBM Research - Zurich'),
(2183, 'https://ror.org/02jv06474', 'en', 1, 'https://ror.org/02jv06474 Hanseo University'),
(2184, 'https://ror.org/02jvh3a15', 'en', 1, 'https://ror.org/02jvh3a15 Diakonhjemmet Hospital'),
(2185, 'https://ror.org/02jw82j47', 'en', 1, 'https://ror.org/02jw82j47 Kaiser Permanente Fontana Medical Center'),
(2186, 'https://ror.org/02jwg2f21', 'en', 1, 'https://ror.org/02jwg2f21 Hammerfest Hospital Hammerfest Sykehus'),
(2187, 'https://ror.org/02jwvs344', 'en', 1, 'https://ror.org/02jwvs344 Port Moresby General Hospital'),
(2188, 'https://ror.org/02jww9n06', 'en', 1, 'https://ror.org/02jww9n06 Matsuyama Red Cross Hospital 松山赤十字病院'),
(2189, 'https://ror.org/02jxw8995', 'no_lang_code', 1, 'https://ror.org/02jxw8995 Goroka Base Hospital'),
(2190, 'https://ror.org/02jy1hx10', 'en', 1, 'https://ror.org/02jy1hx10 Makati Medical Center'),
(2191, 'https://ror.org/02jygs973', 'en', 1, 'https://ror.org/02jygs973 Changes in Health Care Financing & Organization'),
(2192, 'https://ror.org/02jz99c72', 'en', 1, 'https://ror.org/02jz99c72 Atlantic Health System'),
(2193, 'https://ror.org/02jzt8c33', 'en', 1, 'https://ror.org/02jzt8c33 Children''s Hospital of Winnipeg'),
(2194, 'https://ror.org/02k0t9a94', 'no_lang_code', 1, 'https://ror.org/02k0t9a94 Sankara Nethralaya'),
(2195, 'https://ror.org/02k2v9264', 'es', 1, 'https://ror.org/02k2v9264 Hospital Luis Calvo Mackenna'),
(2196, 'https://ror.org/02k46bn27', 'en', 1, 'https://ror.org/02k46bn27 Pfeiffer University'),
(2197, 'https://ror.org/02k4h0b10', 'en', 1, 'https://ror.org/02k4h0b10 Rajshahi Medical College রাজশাহী মেডিকেল কলেজ'),
(2198, 'https://ror.org/02k4w3g59', 'en', 1, 'https://ror.org/02k4w3g59 Helen Hayes Hospital'),
(2199, 'https://ror.org/02k57ty04', 'de', 1, 'https://ror.org/02k57ty04 Klinikum Lüneburg'),
(2200, 'https://ror.org/02k61s246', 'en', 1, 'https://ror.org/02k61s246 American Society for Cell Biology'),
(2201, 'https://ror.org/02k72jz38', 'no_lang_code', 1, 'https://ror.org/02k72jz38 TagCyx Biotechnologies (Japan)'),
(2202, 'https://ror.org/02k9jrs03', 'en', 1, 'https://ror.org/02k9jrs03 University Children’s Hospital Bern Universitätskinderklinik Bern'),
(2203, 'https://ror.org/02kckde25', 'en', 1, 'https://ror.org/02kckde25 Earl K. Long Medical Center'),
(2204, 'https://ror.org/02kcpr174', 'en', 1, 'https://ror.org/02kcpr174 MRC Human Immunology Unit'),
(2205, 'https://ror.org/02ke5vh78', 'en', 1, 'https://ror.org/02ke5vh78 Tianjin Central Hospital of Gynecology Obstetrics 天津市中心妇产科医院'),
(2206, 'https://ror.org/02kexp407', 'en', 1, 'https://ror.org/02kexp407 Miami Valley Hospital'),
(2207, 'https://ror.org/02kf0fj54', 'no_lang_code', 1, 'https://ror.org/02kf0fj54 AnyGen (South Korea)'),
(2208, 'https://ror.org/02kg81z20', 'en', 1, 'https://ror.org/02kg81z20 Universidad de La Verne University of La Verne'),
(2209, 'https://ror.org/02khfkr46', 'en', 1, 'https://ror.org/02khfkr46 Institute of Electron Technology'),
(2210, 'https://ror.org/02khzxe16', 'pt', 1, 'https://ror.org/02khzxe16 Instituto Superior de Comunicação Empresarial'),
(2211, 'https://ror.org/02kjq0603', 'en', 1, 'https://ror.org/02kjq0603 American Bar Foundation'),
(2212, 'https://ror.org/02kk6xv61', 'en', 1, 'https://ror.org/02kk6xv61 Creative England'),
(2213, 'https://ror.org/02kk9ec90', 'en', 1, 'https://ror.org/02kk9ec90 Organization For Tropical Studies'),
(2214, 'https://ror.org/02kswma64', 'it', 1, 'https://ror.org/02kswma64 Istituto Nazionale per la Fisica della Materia'),
(2215, 'https://ror.org/02kta5139', 'es', 1, 'https://ror.org/02kta5139 Metropolitan Autonomous University Universidad Autónoma Metropolitana'),
(2216, 'https://ror.org/02kwcpg86', 'en', 1, 'https://ror.org/02kwcpg86 Karlstad Central Hospital'),
(2217, 'https://ror.org/02kxeh053', 'no_lang_code', 1, 'https://ror.org/02kxeh053 Veria General Hospital Γενικό Νοσοκομείο Ημαθίας'),
(2218, 'https://ror.org/02kyckx55', 'en', 1, 'https://ror.org/02kyckx55 University of Akron'),
(2219, 'https://ror.org/02kzxd152', 'en', 1, 'https://ror.org/02kzxd152 Medical University Plovdiv Medizinischen Universität Plovdiv Медицински университет - Пловдив'),
(2220, 'https://ror.org/02m0p4y77', 'de', 1, 'https://ror.org/02m0p4y77 Klinikum Südstadt Rostock'),
(2221, 'https://ror.org/02m11x738', 'en', 1, 'https://ror.org/02m11x738 Furtwangen University Hochschule Furtwangen'),
(2222, 'https://ror.org/02m1efx83', 'no_lang_code', 1, 'https://ror.org/02m1efx83 Taconic (United States)'),
(2223, 'https://ror.org/02m2znm35', 'en', 1, 'https://ror.org/02m2znm35 Soliman Fakeeh Hospital الدكتور سليمان فقية'),
(2224, 'https://ror.org/02m4p8096', 'en', 1, 'https://ror.org/02m4p8096 Hochschule Kempten Kempten University of Applied Sciences'),
(2225, 'https://ror.org/02m5e3762', 'no_lang_code', 1, 'https://ror.org/02m5e3762 Dr. Balabhai Nanavati Hospital'),
(2226, 'https://ror.org/02m82p074', 'no_lang_code', 1, 'https://ror.org/02m82p074 Suez Canal University Université du Canal de Suez جامعة قناة السويس'),
(2227, 'https://ror.org/02m9pj861', 'pt', 1, 'https://ror.org/02m9pj861 Hospital de Santo António'),
(2228, 'https://ror.org/02maedm12', 'en', 1, 'https://ror.org/02maedm12 Rawalpindi Medical University'),
(2229, 'https://ror.org/02mb9s657', 'en', 1, 'https://ror.org/02mb9s657 Hampden–Sydney College'),
(2230, 'https://ror.org/02mby1820', 'it', 1, 'https://ror.org/02mby1820 Azienda USL di Bologna'),
(2231, 'https://ror.org/02me73n88', 'en', 1, 'https://ror.org/02me73n88 Tribhuvan University Teaching Hospital'),
(2232, 'https://ror.org/02mek6v69', 'fr', 1, 'https://ror.org/02mek6v69 Hôpital Bonnet'),
(2233, 'https://ror.org/02mfapa96', 'en', 1, 'https://ror.org/02mfapa96 Acharya Nagarjuna University ఆచార్య నాగార్జున విశ్వవిద్యాలయం'),
(2234, 'https://ror.org/02mg9y350', 'en', 1, 'https://ror.org/02mg9y350 Winona Medical Cosmetic Center 薇诺娜皮肤医疗美容中心'),
(2235, 'https://ror.org/02mp2av58', 'en', 1, 'https://ror.org/02mp2av58 Universidad de Hawái en Hilo University of Hawaii at Hilo Université d''hawaï à hilo'),
(2236, 'https://ror.org/02mrcx295', 'no_lang_code', 1, 'https://ror.org/02mrcx295 Creare (United States)'),
(2237, 'https://ror.org/02mssnc42', 'no_lang_code', 1, 'https://ror.org/02mssnc42 Nagano Municipal Hospital 長野市民病院'),
(2238, 'https://ror.org/02mtbrk18', 'en', 1, 'https://ror.org/02mtbrk18 Immaculata University'),
(2239, 'https://ror.org/02mvsxw13', 'en', 1, 'https://ror.org/02mvsxw13 Kobe City Nishi-Kobe Medical Center 神戸市立西神戸医療センター'),
(2240, 'https://ror.org/02mx8nz45', 'en', 1, 'https://ror.org/02mx8nz45 Bradley Hospital'),
(2241, 'https://ror.org/02mxfm070', 'en', 1, 'https://ror.org/02mxfm070 St Joseph''s Hospital Health Center'),
(2242, 'https://ror.org/02my3bx32', 'en', 1, 'https://ror.org/02my3bx32 Hubei University of Chinese Medicine 湖北中医药大学'),
(2243, 'https://ror.org/02myg6142', 'en', 1, 'https://ror.org/02myg6142 Maryville University'),
(2244, 'https://ror.org/02n10g966', 'en', 1, 'https://ror.org/02n10g966 Long Beach Animal Hospital'),
(2245, 'https://ror.org/02n1cyj49', 'en', 1, 'https://ror.org/02n1cyj49 AdventHealth Orlando'),
(2246, 'https://ror.org/02n22cc74', 'en', 1, 'https://ror.org/02n22cc74 Koshigaya Municipal Hospital 越谷市立病院'),
(2247, 'https://ror.org/02n2ava60', 'en', 1, 'https://ror.org/02n2ava60 University of New England'),
(2248, 'https://ror.org/02n5cs023', 'en', 1, 'https://ror.org/02n5cs023 Elizabeth City State University'),
(2249, 'https://ror.org/02n73hp60', 'en', 1, 'https://ror.org/02n73hp60 Victoria General Hospital'),
(2250, 'https://ror.org/02nbyhf94', 'no_lang_code', 1, 'https://ror.org/02nbyhf94 Coanda Research and Development Corporation (Canada)'),
(2251, 'https://ror.org/02nckwn80', 'en', 1, 'https://ror.org/02nckwn80 Cheyney University of Pennsylvania Universidad de Cheyney de Pensilvania Université cheyney de pennsylvanie'),
(2252, 'https://ror.org/02ndk3y82', 'en', 1, 'https://ror.org/02ndk3y82 Children''s Medical Center'),
(2253, 'https://ror.org/02nh10f55', 'en', 1, 'https://ror.org/02nh10f55 Evanston Hospital'),
(2254, 'https://ror.org/02npavb70', 'en', 1, 'https://ror.org/02npavb70 Shimane Prefectural Institute of Public Health and Environmental Sciences 島根県保健環境科学研究所'),
(2255, 'https://ror.org/02npppw10', 'no_lang_code', 1, 'https://ror.org/02npppw10 BMT Group (United Kingdom)'),
(2256, 'https://ror.org/02nqy8390', 'en', 1, 'https://ror.org/02nqy8390 Letterman Army Medical Center'),
(2257, 'https://ror.org/02nr3fr97', 'en', 1, 'https://ror.org/02nr3fr97 Center for Biologics Evaluation and Research'),
(2258, 'https://ror.org/02nren818', 'en', 1, 'https://ror.org/02nren818 Chestnut Hill Hospital'),
(2259, 'https://ror.org/02ntgty32', 'en', 1, 'https://ror.org/02ntgty32 Flygtekniska försöksanstalten National Aeronautical Research Institute'),
(2260, 'https://ror.org/02nvt4474', 'es', 1, 'https://ror.org/02nvt4474 Institute for Clinical Efectiveness and Health Policy Instituto de Efectividad Clínica y Sanitaria'),
(2261, 'https://ror.org/02nx5r318', 'en', 1, 'https://ror.org/02nx5r318 College of New Jersey'),
(2262, 'https://ror.org/02nycs597', 'en', 1, 'https://ror.org/02nycs597 Funabashi Municipal Medical Center 船橋市立医療センター'),
(2263, 'https://ror.org/02nyfes25', 'en', 1, 'https://ror.org/02nyfes25 Science Museum of Minnesota'),
(2264, 'https://ror.org/02nzaav06', 'es', 1, 'https://ror.org/02nzaav06 Hospital Luis Vernaza'),
(2265, 'https://ror.org/02p23ar50', 'en', 1, 'https://ror.org/02p23ar50 Kent and Canterbury Hospital'),
(2266, 'https://ror.org/02p47pe37', 'de', 1, 'https://ror.org/02p47pe37 Kaiser-Franz-Josef-Spital'),
(2267, 'https://ror.org/02p599b54', 'en', 1, 'https://ror.org/02p599b54 Treatment Research Institute'),
(2268, 'https://ror.org/02p620w18', 'en', 1, 'https://ror.org/02p620w18 Blood Center of Zhejiang Province 浙江省血液中心'),
(2269, 'https://ror.org/02p6pjw94', 'en', 1, 'https://ror.org/02p6pjw94 Moncton Hospital'),
(2270, 'https://ror.org/02p71fr67', 'en', 1, 'https://ror.org/02p71fr67 Monilek Hospital and Research Center'),
(2271, 'https://ror.org/02p72h367', 'en', 1, 'https://ror.org/02p72h367 University of Cincinnati Medical Center'),
(2272, 'https://ror.org/02p74z057', 'en', 1, 'https://ror.org/02p74z057 K S Hegde Medical Academy'),
(2273, 'https://ror.org/02p9e5v87', 'en', 1, 'https://ror.org/02p9e5v87 Concord Hospital'),
(2274, 'https://ror.org/02paek818', 'en', 1, 'https://ror.org/02paek818 Hutzel Women''s Hospital'),
(2275, 'https://ror.org/02pagex14', 'en', 1, 'https://ror.org/02pagex14 Archimedes Foundation'),
(2276, 'https://ror.org/02pb4g840', 'tr', 1, 'https://ror.org/02pb4g840 Bahriye Merkez Hastanesi, Kasımpaşa Asker Hastanesi'),
(2277, 'https://ror.org/02pb9wz46', 'fr', 1, 'https://ror.org/02pb9wz46 Hôpital Léon Bérard'),
(2278, 'https://ror.org/02pes1a77', 'de', 1, 'https://ror.org/02pes1a77 Krankenhaus der Elisabethinen'),
(2279, 'https://ror.org/02pf50490', 'no_lang_code', 1, 'https://ror.org/02pf50490 Immunomedics (United States)'),
(2280, 'https://ror.org/02pfhv998', 'no_lang_code', 1, 'https://ror.org/02pfhv998 Nongwoo Bio (South Korea)'),
(2281, 'https://ror.org/02pfqts47', 'es', 1, 'https://ror.org/02pfqts47 Hospital Casa de Salud'),
(2282, 'https://ror.org/02pg0e883', 'en', 1, 'https://ror.org/02pg0e883 University of Aizu 会津大学'),
(2283, 'https://ror.org/02pgvzy25', 'en', 1, 'https://ror.org/02pgvzy25 Ming Chuan University'),
(2284, 'https://ror.org/02phevt59', 'en', 1, 'https://ror.org/02phevt59 Fraunhofer Institute for Wind Energy Systems Fraunhofer-Institut für Windenergiesysteme'),
(2285, 'https://ror.org/02pk13h45', 'en', 1, 'https://ror.org/02pk13h45 St George Hospital'),
(2286, 'https://ror.org/02pkd6e53', 'no_lang_code', 1, 'https://ror.org/02pkd6e53 Deschutes Research'),
(2287, 'https://ror.org/02pp7xn25', 'en', 1, 'https://ror.org/02pp7xn25 Punjab Government Dental College and Hospital'),
(2288, 'https://ror.org/02ptw3r05', 'es', 1, 'https://ror.org/02ptw3r05 Hospital Universitario Son Dureta'),
(2289, 'https://ror.org/02pyp8h55', 'en', 1, 'https://ror.org/02pyp8h55 Lions Gate Hospital'),
(2290, 'https://ror.org/02q0qx558', 'en', 1, 'https://ror.org/02q0qx558 Health Resources Unlimited'),
(2291, 'https://ror.org/02q1nnh04', 'en', 1, 'https://ror.org/02q1nnh04 St. Cloud VA Health Care System'),
(2292, 'https://ror.org/02q291e51', 'no_lang_code', 1, 'https://ror.org/02q291e51 Suncor Energy (Canada)'),
(2293, 'https://ror.org/02q2dn726', 'no_lang_code', 1, 'https://ror.org/02q2dn726 Sinte Gleska University'),
(2294, 'https://ror.org/02q2rtn50', 'no_lang_code', 1, 'https://ror.org/02q2rtn50 Tangam Gaming Inc'),
(2295, 'https://ror.org/02q3bak66', 'en', 1, 'https://ror.org/02q3bak66 Buckinghamshire New University Prifysgol Newydd Swydd Buckingham'),
(2296, 'https://ror.org/02q404g62', 'en', 1, 'https://ror.org/02q404g62 Kaiser Permanente Sacramento Medical Center'),
(2297, 'https://ror.org/02q5gkg61', 'en', 1, 'https://ror.org/02q5gkg61 Henderson State University Université d''État henderson'),
(2298, 'https://ror.org/02q8h2f47', 'fr', 1, 'https://ror.org/02q8h2f47 Institut Technologique Forêt Cellulose Bois-Construction Ameublement'),
(2299, 'https://ror.org/02q8vys74', 'en', 1, 'https://ror.org/02q8vys74 American Institute of Physics'),
(2300, 'https://ror.org/02q97rh88', 'en', 1, 'https://ror.org/02q97rh88 Shotley Bridge Hospital'),
(2301, 'https://ror.org/02qb5a654', 'en', 1, 'https://ror.org/02qb5a654 Somerset Medical Center'),
(2302, 'https://ror.org/02qdbgx97', 'en', 1, 'https://ror.org/02qdbgx97 Geisinger Health System'),
(2303, 'https://ror.org/02qeh3c90', 'en', 1, 'https://ror.org/02qeh3c90 University of Louisiana at Monroe Université de Louisiane à Monroe'),
(2304, 'https://ror.org/02qeysd40', 'en', 1, 'https://ror.org/02qeysd40 Tacoma Community College'),
(2305, 'https://ror.org/02qgq9x54', 'en', 1, 'https://ror.org/02qgq9x54 Sardar Patel Post Graduate Institute of Dental and Medical Sciences'),
(2306, 'https://ror.org/02qnsw591', 'en', 1, 'https://ror.org/02qnsw591 Centre for European Economic Research Zentrum für Europäische Wirtschaftsforschung'),
(2307, 'https://ror.org/02qp2hh41', 'en', 1, 'https://ror.org/02qp2hh41 Walden University'),
(2308, 'https://ror.org/02qqemj91', 'en', 1, 'https://ror.org/02qqemj91 Jaipur Golden Hospital'),
(2309, 'https://ror.org/02qsqdv65', 'no_lang_code', 1, 'https://ror.org/02qsqdv65 Alstom (United Kingdom)'),
(2310, 'https://ror.org/02qv90y91', 'en', 1, 'https://ror.org/02qv90y91 Nagasaki Medical Center 長崎医療センター'),
(2311, 'https://ror.org/02qvqb543', 'no_lang_code', 1, 'https://ror.org/02qvqb543 Aretaeio Hospital'),
(2312, 'https://ror.org/02qx1ae98', 'en', 1, 'https://ror.org/02qx1ae98 First Affiliated Hospital of Xinjiang Medical University 新疆医科大学第一附属医院'),
(2313, 'https://ror.org/02r247g67', 'en', 1, 'https://ror.org/02r247g67 People''s Hospital of Xinjiang Uygur Autonomous Region 新疆维吾尔自治区人民医院'),
(2314, 'https://ror.org/02r2pcs39', 'en', 1, 'https://ror.org/02r2pcs39 Polyclinic Medical Center'),
(2315, 'https://ror.org/02r2tq059', 'en', 1, 'https://ror.org/02r2tq059 Saraswati Dental College and Hospital'),
(2316, 'https://ror.org/02r3xg590', 'en', 1, 'https://ror.org/02r3xg590 Kaiser Permanente Vallejo Medical Center'),
(2317, 'https://ror.org/02r4khx44', 'en', 1, 'https://ror.org/02r4khx44 King Hussein Medical Center مدينة الحسين الطبية'),
(2318, 'https://ror.org/02r581p42', 'pt', 1, 'https://ror.org/02r581p42 Hospital de Santa Cruz'),
(2319, 'https://ror.org/02r5cmz65', 'en', 1, 'https://ror.org/02r5cmz65 Babol University of Medical Sciences دانشگاه علوم پزشکی بابل'),
(2320, 'https://ror.org/02ra1fm11', 'no_lang_code', 1, 'https://ror.org/02ra1fm11 Thermal Technologies (United States)'),
(2321, 'https://ror.org/02retg991', 'en', 1, 'https://ror.org/02retg991 University of Jammu जम्मू विश्वविद्यालय'),
(2322, 'https://ror.org/02rfs1804', 'no_lang_code', 1, 'https://ror.org/02rfs1804 Shimada Municipal Hospital 島田市民病院'),
(2323, 'https://ror.org/02rg6ka44', 'en', 1, 'https://ror.org/02rg6ka44 Southwest Bahia State University Universidad Estatal del Sudoeste de Bahía Universidade Estadual do Sudoeste da Bahia'),
(2324, 'https://ror.org/02rg9ze43', 'en', 1, 'https://ror.org/02rg9ze43 Madonna University Université madonna'),
(2325, 'https://ror.org/02rhp5f96', 'en', 1, 'https://ror.org/02rhp5f96 Mulago Hospital'),
(2326, 'https://ror.org/02rjrn566', 'en', 1, 'https://ror.org/02rjrn566 Nishtar Medical College and Hospital'),
(2327, 'https://ror.org/02rn1w290', 'en', 1, 'https://ror.org/02rn1w290 Princess Mary Maternity Hospital'),
(2328, 'https://ror.org/02rn83489', 'en', 1, 'https://ror.org/02rn83489 Corniche Hospital مستشفى الكورنيش للأمومة'),
(2329, 'https://ror.org/02rnep118', 'en', 1, 'https://ror.org/02rnep118 Queen''s Hospital'),
(2330, 'https://ror.org/02rrbpf42', 'en', 1, 'https://ror.org/02rrbpf42 King Edward Medical University کنگ ایڈورڈ میڈیکل یونیورسٹی'),
(2331, 'https://ror.org/02rsjqy82', 'en', 1, 'https://ror.org/02rsjqy82 Point Loma Nazarene University'),
(2332, 'https://ror.org/02rsydb28', 'en', 1, 'https://ror.org/02rsydb28 Misericordia Community Hospital'),
(2333, 'https://ror.org/02rw2zs46', 'en', 1, 'https://ror.org/02rw2zs46 Bai Jerbai Wadia Hospital for Children'),
(2334, 'https://ror.org/02s0xcm55', 'it', 1, 'https://ror.org/02s0xcm55 Agency for the Promotion of European Research Agenzia per la Promozione della Ricerca Europea'),
(2335, 'https://ror.org/02s1hvj37', 'en', 1, 'https://ror.org/02s1hvj37 Indiana University South Bend'),
(2336, 'https://ror.org/02s280t43', 'en', 1, 'https://ror.org/02s280t43 New Hanover Regional Medical Center'),
(2337, 'https://ror.org/02s3d7j94', 'en', 1, 'https://ror.org/02s3d7j94 Chang Jung Christian University'),
(2338, 'https://ror.org/02s3xyj47', 'en', 1, 'https://ror.org/02s3xyj47 Qatif Central Hospital مستشفى القطيف المركزي'),
(2339, 'https://ror.org/02s4j2a36', 'en', 1, 'https://ror.org/02s4j2a36 Conquest Hospital'),
(2340, 'https://ror.org/02s4xaf90', 'en', 1, 'https://ror.org/02s4xaf90 Calgary General Hospital'),
(2341, 'https://ror.org/02s5yma07', 'en', 1, 'https://ror.org/02s5yma07 Himachal Pradesh University'),
(2342, 'https://ror.org/02s6h0431', 'it', 1, 'https://ror.org/02s6h0431 Circolo Hospital and Macchi Foundation Ospedale di Circolo e Fondazione Macchi'),
(2343, 'https://ror.org/02s6w8y22', 'en', 1, 'https://ror.org/02s6w8y22 University of Bamako Université de Bamako'),
(2344, 'https://ror.org/02s7c9e98', 'en', 1, 'https://ror.org/02s7c9e98 Fourth Affiliated Hospital of Harbin Medical University 哈尔滨医科大学第四附属医院'),
(2345, 'https://ror.org/02s7et124', 'it', 1, 'https://ror.org/02s7et124 Azienda Ospedaliera Universitaria Senese'),
(2346, 'https://ror.org/02s7fkk92', 'es', 1, 'https://ror.org/02s7fkk92 Hospital Arnau de Vilanova'),
(2347, 'https://ror.org/02s7hnh67', 'en', 1, 'https://ror.org/02s7hnh67 Thammasat University Hospital โรงพยาบาลธรรมศาสตร์เฉลิมพระเกียรติ'),
(2348, 'https://ror.org/02s8jk784', 'en', 1, 'https://ror.org/02s8jk784 PVS Memorial Hospital'),
(2349, 'https://ror.org/02s8znz42', 'fr', 1, 'https://ror.org/02s8znz42 Centre Hospitalier de Mulhouse'),
(2350, 'https://ror.org/02sb3pg33', 'en', 1, 'https://ror.org/02sb3pg33 Kaleida Health'),
(2351, 'https://ror.org/02sc91t34', 'en', 1, 'https://ror.org/02sc91t34 American Association of Geographers'),
(2352, 'https://ror.org/02sehzp52', 'en', 1, 'https://ror.org/02sehzp52 Belarusian State University of Informatics and Radioelectronics Беларускі дзяржаўны ўніверсітэт інфарматыкі і радыёэлектронікі Белорусский государственный университет информатики и радиоэлектроники'),
(2353, 'https://ror.org/02sjnfb25', 'en', 1, 'https://ror.org/02sjnfb25 Versiti Blood Center of Wisconsin'),
(2354, 'https://ror.org/02smkcg51', 'tr', 1, 'https://ror.org/02smkcg51 Bakırköy Dr.Sadi Konuk Eğitim ve Araştırma Hastanesi'),
(2355, 'https://ror.org/02smq5q54', 'en', 1, 'https://ror.org/02smq5q54 Birmingham City Hospital'),
(2356, 'https://ror.org/02smsax08', 'pt', 1, 'https://ror.org/02smsax08 Hospital Nossa Senhora da Conceição'),
(2357, 'https://ror.org/02sn5gb64', 'en', 1, 'https://ror.org/02sn5gb64 Toyota Technological Institute at Chicago'),
(2358, 'https://ror.org/02snf5j61', 'en', 1, 'https://ror.org/02snf5j61 University Hospital, Newark'),
(2359, 'https://ror.org/02sp1z620', 'en', 1, 'https://ror.org/02sp1z620 Burke Medical Research Institute'),
(2360, 'https://ror.org/02sp8x745', 'en', 1, 'https://ror.org/02sp8x745 Royal Jubilee Hospital'),
(2361, 'https://ror.org/02srrbc50', 'en', 1, 'https://ror.org/02srrbc50 Erzurum Bölge Eğitim ve Araştırma Hastanesi Erzurum Regional Training and Research Hospital'),
(2362, 'https://ror.org/02srt1z47', 'en', 1, 'https://ror.org/02srt1z47 Kansai Electric Power Hospital 関西電力病院'),
(2363, 'https://ror.org/02ss35t63', 'en', 1, 'https://ror.org/02ss35t63 Emerson Hospital'),
(2364, 'https://ror.org/02ssjh827', 'en', 1, 'https://ror.org/02ssjh827 Hôpital National de Niamey National Hospital Niamey'),
(2365, 'https://ror.org/02sttfr93', 'en', 1, 'https://ror.org/02sttfr93 Kyushu Central Hospital of the Mutual Aid Association of Public School Teachers 公立学校共済組合 九州中央病院'),
(2366, 'https://ror.org/02sxmkm79', 'en', 1, 'https://ror.org/02sxmkm79 Mercy Hospital'),
(2367, 'https://ror.org/02sxy6c22', 'no_lang_code', 1, 'https://ror.org/02sxy6c22 Daehang Hospital 대항병원'),
(2368, 'https://ror.org/02syg0q74', 'en', 1, 'https://ror.org/02syg0q74 Hirosaki University 弘前大学'),
(2369, 'https://ror.org/02sz71d65', 'en', 1, 'https://ror.org/02sz71d65 Methodist Hospital'),
(2370, 'https://ror.org/02t0qr014', 'en', 1, 'https://ror.org/02t0qr014 Universidad de Carolina del Norte en Wilmington University of North Carolina Wilmington Université de wilmington'),
(2371, 'https://ror.org/02t36bt26', 'en', 1, 'https://ror.org/02t36bt26 Regional Institute of Medical Sciences'),
(2372, 'https://ror.org/02t3sfp68', 'en', 1, 'https://ror.org/02t3sfp68 Sejong General Hospital 세종 병원'),
(2373, 'https://ror.org/02t4f0726', 'no_lang_code', 1, 'https://ror.org/02t4f0726 Radikal Therapeutics'),
(2374, 'https://ror.org/02t5j9303', 'en', 1, 'https://ror.org/02t5j9303 Lakehead Psychiatric Hospital'),
(2375, 'https://ror.org/02t69m177', 'no_lang_code', 1, 'https://ror.org/02t69m177 Adipogen (South Korea)'),
(2376, 'https://ror.org/02t96cy48', 'it', 1, 'https://ror.org/02t96cy48 Azienda Ospedaliera S.Maria'),
(2377, 'https://ror.org/02tbz8k15', 'no_lang_code', 1, 'https://ror.org/02tbz8k15 University Research Co (United States)'),
(2378, 'https://ror.org/02tc32w13', 'en', 1, 'https://ror.org/02tc32w13 Cumann Ollscoileanna Éireann Irish Universities Association'),
(2379, 'https://ror.org/02tcape08', 'en', 1, 'https://ror.org/02tcape08 Xinjiang Academy of Animal Science 新疆维吾尔自治区畜牧科学院'),
(2380, 'https://ror.org/02tdhvw55', 'tr', 1, 'https://ror.org/02tdhvw55 Fırat Üniversitesi Hastanesi'),
(2381, 'https://ror.org/02tdmfk69', 'en', 1, 'https://ror.org/02tdmfk69 Belfast Health and Social Care Trust'),
(2382, 'https://ror.org/02teamz63', 'en', 1, 'https://ror.org/02teamz63 La Rabida Children''s Hospital'),
(2383, 'https://ror.org/02tj04e91', 'en', 1, 'https://ror.org/02tj04e91 Sydney Children''s Hospital'),
(2384, 'https://ror.org/02tpgw303', 'en', 1, 'https://ror.org/02tpgw303 Institute for Systems Biology'),
(2385, 'https://ror.org/02tsanh21', 'en', 1, 'https://ror.org/02tsanh21 National Cancer Center'),
(2386, 'https://ror.org/02tse0z86', 'en', 1, 'https://ror.org/02tse0z86 Bryn Mawr Hospital'),
(2387, 'https://ror.org/02tt4fr50', 'no_lang_code', 1, 'https://ror.org/02tt4fr50 Kanto Central Hospital 公立学校共済組合関東中央病院'),
(2388, 'https://ror.org/02tvcev59', 'en', 1, 'https://ror.org/02tvcev59 La Nueva Escuela New School'),
(2389, 'https://ror.org/02tvg0w73', 'en', 1, 'https://ror.org/02tvg0w73 Riverside Research Institute'),
(2390, 'https://ror.org/02tvhd105', 'es', 1, 'https://ror.org/02tvhd105 Clemente Álvarez Emergency Hospital Hospital de Emergencias Dr. Clemente Álvarez'),
(2391, 'https://ror.org/02tvvs825', 'en', 1, 'https://ror.org/02tvvs825 Robinson Memorial Hospital'),
(2392, 'https://ror.org/02twt6343', 'fr', 1, 'https://ror.org/02twt6343 Hôpital Louis-H Lafontaine'),
(2393, 'https://ror.org/02v3sdn51', 'en', 1, 'https://ror.org/02v3sdn51 MRC/CSO Social and Public Health Sciences Unit'),
(2394, 'https://ror.org/02v3txv81', 'en', 1, 'https://ror.org/02v3txv81 Portland VA Medical Center'),
(2395, 'https://ror.org/02v5mzt02', 'en', 1, 'https://ror.org/02v5mzt02 St David''s Medical Center'),
(2396, 'https://ror.org/02v6ptf51', 'no_lang_code', 1, 'https://ror.org/02v6ptf51 Khoula Hospital مستشفى خولة'),
(2397, 'https://ror.org/02v7qv571', 'en', 1, 'https://ror.org/02v7qv571 Santa Clara Valley Medical Center'),
(2398, 'https://ror.org/02v8rz176', 'no_lang_code', 1, 'https://ror.org/02v8rz176 Guru Teg Bahadur Hospital'),
(2399, 'https://ror.org/02v8yp068', 'no_lang_code', 1, 'https://ror.org/02v8yp068 Konyang University 건양대학교'),
(2400, 'https://ror.org/02vaqnn82', 'en', 1, 'https://ror.org/02vaqnn82 Madras Medical Mission'),
(2401, 'https://ror.org/02vb7sj25', 'en', 1, 'https://ror.org/02vb7sj25 Geneva College'),
(2402, 'https://ror.org/02vbxt202', 'no_lang_code', 1, 'https://ror.org/02vbxt202 ThyssenKrupp (Germany)'),
(2403, 'https://ror.org/02vdn8424', 'en', 1, 'https://ror.org/02vdn8424 Administration of Occupational Safety and Health Vinnueftirlitið'),
(2404, 'https://ror.org/02vej5573', 'no_lang_code', 1, 'https://ror.org/02vej5573 Estácio (Brazil)'),
(2405, 'https://ror.org/02verss31', 'en', 1, 'https://ror.org/02verss31 Chang Gung Memorial Hospital'),
(2406, 'https://ror.org/02vfy4r65', 'en', 1, 'https://ror.org/02vfy4r65 Charleston Area Medical Center'),
(2407, 'https://ror.org/02vgb0r89', 'en', 1, 'https://ror.org/02vgb0r89 Kinki Central Hospital 近畿中央病院'),
(2408, 'https://ror.org/02vgs9327', 'en', 1, 'https://ror.org/02vgs9327 Kumamoto University Hospital 熊本大学医学部附属病院'),
(2409, 'https://ror.org/02vj1vm13', 'en', 1, 'https://ror.org/02vj1vm13 Zhangzhou Normal University 闽南师范大学'),
(2410, 'https://ror.org/02vjsj444', 'en', 1, 'https://ror.org/02vjsj444 Fort Sanders Regional Medical Center'),
(2411, 'https://ror.org/02vn11j58', 'en', 1, 'https://ror.org/02vn11j58 Ulyanovsk State University Ульяновский государственный университет'),
(2412, 'https://ror.org/02vn5as77', 'nl', 1, 'https://ror.org/02vn5as77 Streekziekenhuis Koningin Beatrix'),
(2413, 'https://ror.org/02vnyaz83', 'en', 1, 'https://ror.org/02vnyaz83 Mills Peninsula Health Services'),
(2414, 'https://ror.org/02vqh3346', 'en', 1, 'https://ror.org/02vqh3346 James Cook University Hospital'),
(2415, 'https://ror.org/02vt4z508', 'en', 1, 'https://ror.org/02vt4z508 Jen-Ai Hospital 仁愛醫療財團法人'),
(2416, 'https://ror.org/02vtd2q19', 'es', 1, 'https://ror.org/02vtd2q19 Hospital Universitario Reina Sofía Reina Sofia Hospital'),
(2417, 'https://ror.org/02vtstx21', 'en', 1, 'https://ror.org/02vtstx21 Allen Hospital'),
(2418, 'https://ror.org/02vvj6403', 'en', 1, 'https://ror.org/02vvj6403 Smolensk University for Humanities Смоленский гуманитарный университет'),
(2419, 'https://ror.org/02vwnat91', 'en', 1, 'https://ror.org/02vwnat91 London South Bank University'),
(2420, 'https://ror.org/02vxh6479', 'no_lang_code', 1, 'https://ror.org/02vxh6479 Fortis Hospital'),
(2421, 'https://ror.org/02vzyrj94', 'en', 1, 'https://ror.org/02vzyrj94 Fairview Southdale Hospital'),
(2422, 'https://ror.org/02w043707', 'en', 1, 'https://ror.org/02w043707 University of Aden جامعة عدن'),
(2423, 'https://ror.org/02w1g0f30', 'en', 1, 'https://ror.org/02w1g0f30 Bashkir State Medical University Башкирский государственный медицинский университет'),
(2424, 'https://ror.org/02w2vzn61', 'en', 1, 'https://ror.org/02w2vzn61 Ruchill Hospital'),
(2425, 'https://ror.org/02w35z347', 'fr', 1, 'https://ror.org/02w35z347 Hôpital Gui de Chauliac'),
(2426, 'https://ror.org/02w3g4478', 'en', 1, 'https://ror.org/02w3g4478 Keller Army Community Hospital'),
(2427, 'https://ror.org/02w3gk008', 'en', 1, 'https://ror.org/02w3gk008 Silla University 신라대학교'),
(2428, 'https://ror.org/02w4p5q74', 'en', 1, 'https://ror.org/02w4p5q74 Assam Medical College অসম চিকিৎসা মহাবিদ্যালয়'),
(2429, 'https://ror.org/02w5pxz31', 'en', 1, 'https://ror.org/02w5pxz31 Assiut University Hospitals'),
(2430, 'https://ror.org/02w7k5y22', 'en', 1, 'https://ror.org/02w7k5y22 Datta Meghe Institute of Medical Sciences'),
(2431, 'https://ror.org/02w7x5c08', 'en', 1, 'https://ror.org/02w7x5c08 Royal Surrey County Hospital'),
(2432, 'https://ror.org/02w8sz675', 'en', 1, 'https://ror.org/02w8sz675 Shriners Hospitals for Children - Tampa'),
(2433, 'https://ror.org/02w8ws377', 'en', 1, 'https://ror.org/02w8ws377 Chung Yuan Christian University'),
(2434, 'https://ror.org/02wa2wd05', 'en', 1, 'https://ror.org/02wa2wd05 Lagos State University Teaching Hospital'),
(2435, 'https://ror.org/02wc1yz29', 'en', 1, 'https://ror.org/02wc1yz29 Eye & ENT Hospital of Fudan University'),
(2436, 'https://ror.org/02wcweb64', 'en', 1, 'https://ror.org/02wcweb64 Larkin Community Hospital'),
(2437, 'https://ror.org/02wdkng16', 'en', 1, 'https://ror.org/02wdkng16 Catholic Health Association of the United States'),
(2438, 'https://ror.org/02wdp5k87', 'no_lang_code', 1, 'https://ror.org/02wdp5k87 Keskuslaboratorio'),
(2439, 'https://ror.org/02wdwsb32', 'no_lang_code', 1, 'https://ror.org/02wdwsb32 GenVec'),
(2440, 'https://ror.org/02wf9yg07', 'en', 1, 'https://ror.org/02wf9yg07 Chidicon Medical Center'),
(2441, 'https://ror.org/02wg4pk78', 'no_lang_code', 1, 'https://ror.org/02wg4pk78 Produits forestiers Résolu Resolute Forest Products (Canada)'),
(2442, 'https://ror.org/02wgfsz09', 'en', 1, 'https://ror.org/02wgfsz09 Grant Medical Center'),
(2443, 'https://ror.org/02wjcw796', 'en', 1, 'https://ror.org/02wjcw796 Miyake Eye Hospital 眼科三宅病院'),
(2444, 'https://ror.org/02wk1td69', 'pt', 1, 'https://ror.org/02wk1td69 Fundacao Universitaria Jose Bonifacio'),
(2445, 'https://ror.org/02wkcrp04', 'en', 1, 'https://ror.org/02wkcrp04 Mazandaran University of Medical Sciences دانشگاه علوم پزشکی مازندران'),
(2446, 'https://ror.org/02wnfwq15', 'es', 1, 'https://ror.org/02wnfwq15 Hospital General Yagüe'),
(2447, 'https://ror.org/02wnxgj78', 'en', 1, 'https://ror.org/02wnxgj78 Chungbuk National University 충북대학교'),
(2448, 'https://ror.org/02wtdvm35', 'en', 1, 'https://ror.org/02wtdvm35 Saskatchewan Health Authority'),
(2449, 'https://ror.org/02wxcj895', 'en', 1, 'https://ror.org/02wxcj895 Chesterfield Royal Hospital'),
(2450, 'https://ror.org/02wxzt832', 'no_lang_code', 1, 'https://ror.org/02wxzt832 Echelon Biosciences'),
(2451, 'https://ror.org/02x0hgx61', 'fr', 1, 'https://ror.org/02x0hgx61 Hôpital Militaire Moulay Ismail'),
(2452, 'https://ror.org/02x0wmd77', 'en', 1, 'https://ror.org/02x0wmd77 St. John’s Health Sciences Centre'),
(2453, 'https://ror.org/02x1txb82', 'no_lang_code', 1, 'https://ror.org/02x1txb82 Hafez Hospital بیمارستان حافظ'),
(2454, 'https://ror.org/02x1vjk79', 'pt', 1, 'https://ror.org/02x1vjk79 Pontifical Catholic University of Paraná Pontificia Universidad Católica de Paraná Pontifícia Universidade Católica do Paraná Université pontificale catholique du paraná'),
(2455, 'https://ror.org/02x2aj034', 'en', 1, 'https://ror.org/02x2aj034 Millersville University'),
(2456, 'https://ror.org/02x2kaq51', 'en', 1, 'https://ror.org/02x2kaq51 Florida Medical Entomology Laboratory'),
(2457, 'https://ror.org/02x3erj71', 'no_lang_code', 1, 'https://ror.org/02x3erj71 Personal Improvement Computer Systems'),
(2458, 'https://ror.org/02x3hmg72', 'en', 1, 'https://ror.org/02x3hmg72 Sawai ManSingh Medical College and Hospital'),
(2459, 'https://ror.org/02x3skf39', 'en', 1, 'https://ror.org/02x3skf39 Bridgewater State University Université d''État de bridgewater'),
(2460, 'https://ror.org/02x4pnt63', 'pt', 1, 'https://ror.org/02x4pnt63 Hospital Geral de Bonsucesso'),
(2461, 'https://ror.org/02x581406', 'fr', 1, 'https://ror.org/02x581406 Hôpital Pellegrin'),
(2462, 'https://ror.org/02x73b849', 'en', 1, 'https://ror.org/02x73b849 University of Electro-Communications 電気通信大学'),
(2463, 'https://ror.org/02x91aj62', 'en', 1, 'https://ror.org/02x91aj62 Peter the Great St. Petersburg Polytechnic University Санкт-Петербургский политехнический университет Петра Великого'),
(2464, 'https://ror.org/02xa5mk57', 'en', 1, 'https://ror.org/02xa5mk57 Brooklyn Hospital Center'),
(2465, 'https://ror.org/02xag2b27', 'en', 1, 'https://ror.org/02xag2b27 Eastern New Mexico University'),
(2466, 'https://ror.org/02xesw687', 'en', 1, 'https://ror.org/02xesw687 North Manchester General Hospital'),
(2467, 'https://ror.org/02xf0fd83', 'en', 1, 'https://ror.org/02xf0fd83 JSS Medical College and Hospital'),
(2468, 'https://ror.org/02xf7p935', 'en', 1, 'https://ror.org/02xf7p935 Incheon National University 인천대학교'),
(2469, 'https://ror.org/02xgzjz11', 'en', 1, 'https://ror.org/02xgzjz11 Hanil General Hospital 한전병원'),
(2470, 'https://ror.org/02xh9x144', 'en', 1, 'https://ror.org/02xh9x144 University of Prince Edward Island Université de l''Île-du-prince-Édouard'),
(2471, 'https://ror.org/02xj89f04', 'pt', 1, 'https://ror.org/02xj89f04 Universidade Veiga de Almeida'),
(2472, 'https://ror.org/02xkmx604', 'en', 1, 'https://ror.org/02xkmx604 Kosin University Gospel Hospital 고신대학교 복음병원'),
(2473, 'https://ror.org/02xkx3e48', 'en', 1, 'https://ror.org/02xkx3e48 Queen Mary Hospital 瑪麗醫院'),
(2474, 'https://ror.org/02xmq6r77', 'en', 1, 'https://ror.org/02xmq6r77 Kibi International University 吉備国際大学'),
(2475, 'https://ror.org/02xpn4676', 'no_lang_code', 1, 'https://ror.org/02xpn4676 Micronet (United States)'),
(2476, 'https://ror.org/02xtpdq88', 'es', 1, 'https://ror.org/02xtpdq88 Hospital Clínico de la Universidad de Chile'),
(2477, 'https://ror.org/02xvk2686', 'en', 1, 'https://ror.org/02xvk2686 Muhimbili National Hospital'),
(2478, 'https://ror.org/02xxgh713', 'en', 1, 'https://ror.org/02xxgh713 Sisters of Charity Hospital'),
(2479, 'https://ror.org/02xyqwh78', 'no_lang_code', 1, 'https://ror.org/02xyqwh78 FEV (Germany)'),
(2480, 'https://ror.org/02xz2v383', 'en', 1, 'https://ror.org/02xz2v383 National Council of Teachers of Mathematics'),
(2481, 'https://ror.org/02y005z64', 'no_lang_code', 1, 'https://ror.org/02y005z64 Hokkaido hospital 北海道病院'),
(2482, 'https://ror.org/02y041669', 'en', 1, 'https://ror.org/02y041669 Gannon University'),
(2483, 'https://ror.org/02y070a55', 'en', 1, 'https://ror.org/02y070a55 Jackson Memorial Hospital'),
(2484, 'https://ror.org/02y0es528', 'en', 1, 'https://ror.org/02y0es528 George Eliot Hospital NHS Trust'),
(2485, 'https://ror.org/02y0wc381', 'en', 1, 'https://ror.org/02y0wc381 Pravara Institute of Medical Sciences'),
(2486, 'https://ror.org/02y0x4c78', 'en', 1, 'https://ror.org/02y0x4c78 General Leonard Wood Army Community Hospital'),
(2487, 'https://ror.org/02y2htg06', 'en', 1, 'https://ror.org/02y2htg06 Chi Mei Medical Center'),
(2488, 'https://ror.org/02y4qch95', 'en', 1, 'https://ror.org/02y4qch95 Lovelace Medical Center'),
(2489, 'https://ror.org/02y5qtc81', 'pt', 1, 'https://ror.org/02y5qtc81 Hospital Infantil Joana de Gusmão'),
(2490, 'https://ror.org/02y9g2b52', 'en', 1, 'https://ror.org/02y9g2b52 Morehouse College'),
(2491, 'https://ror.org/02y9nww90', 'en', 1, 'https://ror.org/02y9nww90 Chuo Kikuu cha Nairobi University of Nairobi'),
(2492, 'https://ror.org/02y9x6z24', 'pt', 1, 'https://ror.org/02y9x6z24 Hospital de São Bernardo'),
(2493, 'https://ror.org/02y9xvd02', 'en', 1, 'https://ror.org/02y9xvd02 Shenyang Medical College 沈阳医学院'),
(2494, 'https://ror.org/02ya5qg51', 'no_lang_code', 1, 'https://ror.org/02ya5qg51 Electrosonics Medical'),
(2495, 'https://ror.org/02yacz525', 'en', 1, 'https://ror.org/02yacz525 Dongzhimen Hospital Affiliated to Beijing University of Chinese Medicine 北京中医药大学东直门医院'),
(2496, 'https://ror.org/02ybb5327', 'es', 1, 'https://ror.org/02ybb5327 Universidad Nacional Experimental Francisco de Miranda'),
(2497, 'https://ror.org/02ybkn114', 'en', 1, 'https://ror.org/02ybkn114 Health Sciences Authority Penguasa Sains Kesihatan'),
(2498, 'https://ror.org/02ybzrf68', 'en', 1, 'https://ror.org/02ybzrf68 Civil Hospital Karachi'),
(2499, 'https://ror.org/02ycvrx49', 'en', 1, 'https://ror.org/02ycvrx49 Program for Appropriate Technology in Health'),
(2500, 'https://ror.org/02ye8a398', 'en', 1, 'https://ror.org/02ye8a398 Keystone Symposia On Molecular and Cellular Biology'),
(2501, 'https://ror.org/02yf2ch17', 'en', 1, 'https://ror.org/02yf2ch17 Carroll University'),
(2502, 'https://ror.org/02yfanq70', 'en', 1, 'https://ror.org/02yfanq70 International Vaccine Institute'),
(2503, 'https://ror.org/02yhdjx59', 'en', 1, 'https://ror.org/02yhdjx59 Interfaith Medical Center'),
(2504, 'https://ror.org/02yj55q56', 'en', 1, 'https://ror.org/02yj55q56 Kunsan National University 군산대학교'),
(2505, 'https://ror.org/02yjksy18', 'en', 1, 'https://ror.org/02yjksy18 Princess Anne Hospital'),
(2506, 'https://ror.org/02yjrq169', 'en', 1, 'https://ror.org/02yjrq169 Savannah Technical College'),
(2507, 'https://ror.org/02ynb0474', 'en', 1, 'https://ror.org/02ynb0474 Razi University دانشگاه رازی'),
(2508, 'https://ror.org/02yq6my61', 'en', 1, 'https://ror.org/02yq6my61 Oklahoma Department of Mental Health and Substance Abuse Services'),
(2509, 'https://ror.org/02ysppy04', 'tr', 1, 'https://ror.org/02ysppy04 Kayseri Eğitim ve Araştırma Hastanesi'),
(2510, 'https://ror.org/02yvd4j36', 'en', 1, 'https://ror.org/02yvd4j36 Bundesamt für Strahlenschutz Federal Office for Radiation Protection'),
(2511, 'https://ror.org/02yw7q747', 'en', 1, 'https://ror.org/02yw7q747 Palmetto Health Richland'),
(2512, 'https://ror.org/02yx0mh38', 'en', 1, 'https://ror.org/02yx0mh38 University of Miami Hospital'),
(2513, 'https://ror.org/02yx11005', 'en', 1, 'https://ror.org/02yx11005 Borders General Hospital'),
(2514, 'https://ror.org/02yxyvn23', 'en', 1, 'https://ror.org/02yxyvn23 Mercy Medical Center North Iowa'),
(2515, 'https://ror.org/02yyjwk88', 'no_lang_code', 1, 'https://ror.org/02yyjwk88 Kyowa-kako (Japan)'),
(2516, 'https://ror.org/02yyv4c82', 'no_lang_code', 1, 'https://ror.org/02yyv4c82 Spire Corporation (United States)'),
(2517, 'https://ror.org/02z125451', 'en', 1, 'https://ror.org/02z125451 Zhongshan Hospital of Xiamen University 厦门大学附属中山医院'),
(2518, 'https://ror.org/02z2d6373', 'en', 1, 'https://ror.org/02z2d6373 Yunnan Academy of Agricultural Sciences 云南省农业科学院'),
(2519, 'https://ror.org/02z310y44', 'en', 1, 'https://ror.org/02z310y44 Wheeling Jesuit University'),
(2520, 'https://ror.org/02z58ft15', 'en', 1, 'https://ror.org/02z58ft15 University of Charleston Université de Charleston'),
(2521, 'https://ror.org/02z5bnb65', 'en', 1, 'https://ror.org/02z5bnb65 College of Idaho'),
(2522, 'https://ror.org/02z7dnx86', 'en', 1, 'https://ror.org/02z7dnx86 Japanese Red Cross Katsushika Maternity Hospital 日本赤十字社葛飾マタニティ病院'),
(2523, 'https://ror.org/02z7qcb63', 'tr', 1, 'https://ror.org/02z7qcb63 Izmir Bozyaka Eğitim ve Araştırma Hastanesi'),
(2524, 'https://ror.org/02z8mgx68', 'en', 1, 'https://ror.org/02z8mgx68 Exempla Saint Joseph Hospital'),
(2525, 'https://ror.org/02z8t9146', 'en', 1, 'https://ror.org/02z8t9146 Mayo General Hospital'),
(2526, 'https://ror.org/02z9d3e27', 'en', 1, 'https://ror.org/02z9d3e27 Dr. Mohan''s Diabetes Specialities Centre'),
(2527, 'https://ror.org/02z9g9j20', 'en', 1, 'https://ror.org/02z9g9j20 BJC HealthCare'),
(2528, 'https://ror.org/02z9t1k38', 'es', 1, 'https://ror.org/02z9t1k38 Universidad Anáhuac'),
(2529, 'https://ror.org/02zc6c986', 'en', 1, 'https://ror.org/02zc6c986 Bethlem Royal Hospital'),
(2530, 'https://ror.org/02zc85170', 'en', 1, 'https://ror.org/02zc85170 Babol Noshirvani University of Technology دانشگاه صنعتی نوشیروانی بابل'),
(2531, 'https://ror.org/02ze5w302', 'en', 1, 'https://ror.org/02ze5w302 Tufts Children''s Hospital'),
(2532, 'https://ror.org/02zfrea47', 'en', 1, 'https://ror.org/02zfrea47 Nacionalni Inštitut za Javno Zdravje National Institute of Public Health'),
(2533, 'https://ror.org/02zg49d29', 'en', 1, 'https://ror.org/02zg49d29 Leicester General Hospital'),
(2534, 'https://ror.org/02zg69r60', 'en', 1, 'https://ror.org/02zg69r60 Vancouver General Hospital'),
(2535, 'https://ror.org/02zh77j65', 'en', 1, 'https://ror.org/02zh77j65 National Registry of Emergency Medical Technicians'),
(2536, 'https://ror.org/02zha5019', 'en', 1, 'https://ror.org/02zha5019 Beijing Museum of Natural History 北京自然博物馆'),
(2537, 'https://ror.org/02zme4e72', 'no_lang_code', 1, 'https://ror.org/02zme4e72 JEOL (Japan) 日本電子'),
(2538, 'https://ror.org/02zn9x324', 'no_lang_code', 1, 'https://ror.org/02zn9x324 INTRASOFT International (Luxembourg)'),
(2539, 'https://ror.org/02zpc2253', 'it', 1, 'https://ror.org/02zpc2253 Ospedale Santa Maria della Misericordia di Udine'),
(2540, 'https://ror.org/02zrvx577', 'en', 1, 'https://ror.org/02zrvx577 University of Bahr El-Ghazal'),
(2541, 'https://ror.org/02zvkba47', 'en', 1, 'https://ror.org/02zvkba47 National University of Comahue Universidad Nacional del Comahue'),
(2542, 'https://ror.org/02zwb6n98', 'en', 1, 'https://ror.org/02zwb6n98 Hamad Medical Corporation'),
(2543, 'https://ror.org/02zwxrr04', 'en', 1, 'https://ror.org/02zwxrr04 Sharp Grossmont Hospital'),
(2544, 'https://ror.org/02zwyfg51', 'en', 1, 'https://ror.org/02zwyfg51 Virginia Union University'),
(2545, 'https://ror.org/02zy72z44', 'no_lang_code', 1, 'https://ror.org/02zy72z44 Profectus Biosciences (United States)'),
(2546, 'https://ror.org/02zzw8g45', 'en', 1, 'https://ror.org/02zzw8g45 Mayo Clinic Health System'),
(2547, 'https://ror.org/0300pwe30', 'it', 1, 'https://ror.org/0300pwe30 Ospedale San Giovanni Bosco');
INSERT INTO `rors` VALUES
(2548, 'https://ror.org/0300yd604', 'pt', 1, 'https://ror.org/0300yd604 Bahian School of Medicine and Public Health Escola Bahiana de Medicina e Saúde Pública'),
(2549, 'https://ror.org/03025ga79', 'en', 1, 'https://ror.org/03025ga79 AC Camargo Hospital'),
(2550, 'https://ror.org/03032jm09', 'en', 1, 'https://ror.org/03032jm09 Levine Children''s Hospital'),
(2551, 'https://ror.org/0303y7a51', 'en', 1, 'https://ror.org/0303y7a51 Durban University of Technology Inyuvesi yasethekwini yezobuchwepheshe'),
(2552, 'https://ror.org/03044am22', 'en', 1, 'https://ror.org/03044am22 Harrogate District Hospital'),
(2553, 'https://ror.org/0304t8e63', 'pt', 1, 'https://ror.org/0304t8e63 Instituto Superior de Serviço Social do Porto'),
(2554, 'https://ror.org/0305ndp35', 'no_lang_code', 1, 'https://ror.org/0305ndp35 MatTek Corporation (United States)'),
(2555, 'https://ror.org/0306jgh11', 'en', 1, 'https://ror.org/0306jgh11 Association of Commonwealth Universities'),
(2556, 'https://ror.org/0306r8m89', 'no_lang_code', 1, 'https://ror.org/0306r8m89 Enerkem (Canada)'),
(2557, 'https://ror.org/0307h0f23', 'en', 1, 'https://ror.org/0307h0f23 Higher Institute of Police Sciences and Homeland Security Instituto Superior de Ciências Policiais e Segurança Interna'),
(2558, 'https://ror.org/030b05n70', 'no_lang_code', 1, 'https://ror.org/030b05n70 123 Certification (Canada)'),
(2559, 'https://ror.org/030d91z44', 'en', 1, 'https://ror.org/030d91z44 Royal Oldham Hospital'),
(2560, 'https://ror.org/030e09f60', 'en', 1, 'https://ror.org/030e09f60 First Affiliated Hospital of Fujian Medical University 福建医科大学附属第一医院'),
(2561, 'https://ror.org/030g3hg75', 'en', 1, 'https://ror.org/030g3hg75 Lankenau Institute for Medical Research'),
(2562, 'https://ror.org/030j6qm79', 'en', 1, 'https://ror.org/030j6qm79 Northwick Park Hospital'),
(2563, 'https://ror.org/030jhb479', 'en', 1, 'https://ror.org/030jhb479 Yunnan Nationalities University 云南民族大学'),
(2564, 'https://ror.org/030kaa114', 'en', 1, 'https://ror.org/030kaa114 Alessandro Manzoni Hospital Ospedale Alessandro Manzoni'),
(2565, 'https://ror.org/030m18266', 'en', 1, 'https://ror.org/030m18266 Tatung University 大同大學'),
(2566, 'https://ror.org/030ma0n95', 'en', 1, 'https://ror.org/030ma0n95 Ralph H. Johnson VA Medical Center'),
(2567, 'https://ror.org/030mbcp39', 'en', 1, 'https://ror.org/030mbcp39 Robert Jones and Agnes Hunt Orthopaedic Hospital'),
(2568, 'https://ror.org/030p45079', 'no_lang_code', 1, 'https://ror.org/030p45079 Cleveland Medical Devices'),
(2569, 'https://ror.org/030pk6463', 'no_lang_code', 1, 'https://ror.org/030pk6463 Univax (United States)'),
(2570, 'https://ror.org/030pydv62', 'en', 1, 'https://ror.org/030pydv62 Norfolk State University Université d''État de norfolk'),
(2571, 'https://ror.org/030rm3988', 'en', 1, 'https://ror.org/030rm3988 National Police Hospital 국립경찰병원'),
(2572, 'https://ror.org/030s54078', 'en', 1, 'https://ror.org/030s54078 University of the Philippines Los Baños'),
(2573, 'https://ror.org/030sc3x20', 'en', 1, 'https://ror.org/030sc3x20 First Affiliated Hospital of GuangXi Medical University'),
(2574, 'https://ror.org/030tcms06', 'en', 1, 'https://ror.org/030tcms06 Rocky Mountain Biological Laboratory'),
(2575, 'https://ror.org/030vg1t69', 'en', 1, 'https://ror.org/030vg1t69 Misr International University جامعة مصر الدولية'),
(2576, 'https://ror.org/030wyr187', 'en', 1, 'https://ror.org/030wyr187 Finnish Institute of Occupational Health'),
(2577, 'https://ror.org/0312m2266', 'en', 1, 'https://ror.org/0312m2266 University Hospital of Heraklion'),
(2578, 'https://ror.org/0313f3w77', 'en', 1, 'https://ror.org/0313f3w77 Başkent University Hospital'),
(2579, 'https://ror.org/0315ea826', 'en', 1, 'https://ror.org/0315ea826 Children''s Hospital Agia Sophia'),
(2580, 'https://ror.org/031699d98', 'en', 1, 'https://ror.org/031699d98 Payame Noor University دانشگاه پیام نور'),
(2581, 'https://ror.org/0317ekv86', 'en', 1, 'https://ror.org/0317ekv86 University of Bahrain جامعة البحرين'),
(2582, 'https://ror.org/0317prg89', 'no_lang_code', 1, 'https://ror.org/0317prg89 Bastyr University'),
(2583, 'https://ror.org/03181bn25', 'en', 1, 'https://ror.org/03181bn25 City College of San Francisco'),
(2584, 'https://ror.org/031b7yx83', 'no_lang_code', 1, 'https://ror.org/031b7yx83 Lucigen Corporation'),
(2585, 'https://ror.org/031bsb921', 'en', 1, 'https://ror.org/031bsb921 University of Mannheim Universität Mannheim'),
(2586, 'https://ror.org/031e6xm45', 'es', 1, 'https://ror.org/031e6xm45 Universidad del Norte'),
(2587, 'https://ror.org/031f8kt38', 'es', 1, 'https://ror.org/031f8kt38 Autonomous University of Hidalgo State Universidad Autónoma del Estado de Hidalgo'),
(2588, 'https://ror.org/031g2ej16', 'no_lang_code', 1, 'https://ror.org/031g2ej16 Dow Chemical (Canada)'),
(2589, 'https://ror.org/031hmx230', 'en', 1, 'https://ror.org/031hmx230 Tokyo Medical University Ibaraki Medical Center 東京医科大学茨城医療センター'),
(2590, 'https://ror.org/031m0eg77', 'en', 1, 'https://ror.org/031m0eg77 Chung Hwa University of Medical Technology 中華醫事科技大學'),
(2591, 'https://ror.org/031maes79', 'en', 1, 'https://ror.org/031maes79 Second Affiliated Hospital of Chengdu University of Traditional Chinese 成都中医药大学'),
(2592, 'https://ror.org/031nbgr73', 'en', 1, 'https://ror.org/031nbgr73 Bedford Hospital NHS Trust'),
(2593, 'https://ror.org/031pw0y55', 'en', 1, 'https://ror.org/031pw0y55 Dakota Wesleyan University'),
(2594, 'https://ror.org/031sxg258', 'no_lang_code', 1, 'https://ror.org/031sxg258 Boehringer Ingelheim (Canada)'),
(2595, 'https://ror.org/031w3f751', 'en', 1, 'https://ror.org/031w3f751 Tulane Medical Center'),
(2596, 'https://ror.org/031wwqy14', 'en', 1, 'https://ror.org/031wwqy14 Sound Shore Medical Center'),
(2597, 'https://ror.org/031xyzp67', 'en', 1, 'https://ror.org/031xyzp67 Social Security Children''s Hospital'),
(2598, 'https://ror.org/031z68d90', 'fr', 1, 'https://ror.org/031z68d90 Institut Universitaire de Gériatrie de Montréal'),
(2599, 'https://ror.org/031zc8d88', 'en', 1, 'https://ror.org/031zc8d88 City Hospital'),
(2600, 'https://ror.org/0320rar10', 'en', 1, 'https://ror.org/0320rar10 MRIGlobal'),
(2601, 'https://ror.org/0321tdt28', 'it', 1, 'https://ror.org/0321tdt28 Ospedale San Giovanni Antica Sede'),
(2602, 'https://ror.org/032298f51', 'it', 1, 'https://ror.org/032298f51 Azienda Ospedaliera Sant''Andrea'),
(2603, 'https://ror.org/0322mf940', 'en', 1, 'https://ror.org/0322mf940 Spartanburg Regional Medical Center'),
(2604, 'https://ror.org/0322p7317', 'en', 1, 'https://ror.org/0322p7317 Kitakyushu Municipal Medical Center 北九州市立医療センター'),
(2605, 'https://ror.org/03237y496', 'en', 1, 'https://ror.org/03237y496 Ahmadu Bello University Teaching Hospital'),
(2606, 'https://ror.org/0327f3359', 'en', 1, 'https://ror.org/0327f3359 Anhui Agricultural University 安徽农业大学'),
(2607, 'https://ror.org/032af5232', 'no_lang_code', 1, 'https://ror.org/032af5232 Gweru Provincial Hospital'),
(2608, 'https://ror.org/032cjfs80', 'en', 1, 'https://ror.org/032cjfs80 Mind Research Network'),
(2609, 'https://ror.org/032d59j24', 'en', 1, 'https://ror.org/032d59j24 Hospital Tan Tock Seng Tan Tock Seng Hospital மருத்துவமனையில்ல் 陈笃生医院'),
(2610, 'https://ror.org/032fk0x53', 'en', 1, 'https://ror.org/032fk0x53 Urmia University دانشگاه ارومیه'),
(2611, 'https://ror.org/032kmqj66', 'en', 1, 'https://ror.org/032kmqj66 Kettering General Hospital'),
(2612, 'https://ror.org/032knn732', 'en', 1, 'https://ror.org/032knn732 Mayville State University'),
(2613, 'https://ror.org/032kth403', 'en', 1, 'https://ror.org/032kth403 Rani Durgavati University'),
(2614, 'https://ror.org/032m4kp77', 'en', 1, 'https://ror.org/032m4kp77 Iowa Department of Public Health'),
(2615, 'https://ror.org/032nh7f71', 'en', 1, 'https://ror.org/032nh7f71 RTI Health Solutions'),
(2616, 'https://ror.org/032p0xe91', 'no', 1, 'https://ror.org/032p0xe91 Privatsykehuset Haugesund'),
(2617, 'https://ror.org/032ppma22', 'en', 1, 'https://ror.org/032ppma22 American Academy of Orthopaedic Surgeons'),
(2618, 'https://ror.org/032q2fe98', 'en', 1, 'https://ror.org/032q2fe98 Michigan State Medical Society'),
(2619, 'https://ror.org/032qfz281', 'en', 1, 'https://ror.org/032qfz281 Kaiser Permanente South San Francisco Medical Center'),
(2620, 'https://ror.org/032x22645', 'en', 1, 'https://ror.org/032x22645 Zhongshan Hospital 中山医院'),
(2621, 'https://ror.org/032xf8h46', 'en', 1, 'https://ror.org/032xf8h46 Kyonggi University 경기대학교'),
(2622, 'https://ror.org/032y5zj91', 'en', 1, 'https://ror.org/032y5zj91 Military Medical Academy Военномедицинска академия'),
(2623, 'https://ror.org/032zc6m47', 'en', 1, 'https://ror.org/032zc6m47 Bronson Methodist Hospital'),
(2624, 'https://ror.org/0331pzy82', 'no_lang_code', 1, 'https://ror.org/0331pzy82 Miyata Eye Hospital 宮田眼科病院'),
(2625, 'https://ror.org/033212v26', 'no_lang_code', 1, 'https://ror.org/033212v26 McPhee Research (United States)'),
(2626, 'https://ror.org/0336f9q30', 'no_lang_code', 1, 'https://ror.org/0336f9q30 Suez (Canada)'),
(2627, 'https://ror.org/03378k036', 'pt', 1, 'https://ror.org/03378k036 Institute of Higher Studies of Fafe Instituto de Estudos Superiores de Fafe LDA'),
(2628, 'https://ror.org/03384k835', 'en', 1, 'https://ror.org/03384k835 Tokushima Red Cross Hospital 徳島赤十字病院'),
(2629, 'https://ror.org/033dfb770', 'en', 1, 'https://ror.org/033dfb770 Fukuyama Cardiovascular Hospital 福山循環器病院'),
(2630, 'https://ror.org/033gfa640', 'en', 1, 'https://ror.org/033gfa640 Royal Hospital Haslar'),
(2631, 'https://ror.org/033kc7n58', 'no_lang_code', 1, 'https://ror.org/033kc7n58 Creusot-Loire Entreprises (France)'),
(2632, 'https://ror.org/033t8gt11', 'en', 1, 'https://ror.org/033t8gt11 University of Forestry Лесотехнически университет'),
(2633, 'https://ror.org/033tc5r37', 'en', 1, 'https://ror.org/033tc5r37 Institute of Dermatology & Venereology of the Yunnan Province'),
(2634, 'https://ror.org/033vjpd42', 'en', 1, 'https://ror.org/033vjpd42 Belmont University'),
(2635, 'https://ror.org/033vryh36', 'es', 1, 'https://ror.org/033vryh36 Tekniker'),
(2636, 'https://ror.org/033xwx807', 'it', 1, 'https://ror.org/033xwx807 Policlinico Universitario di Catania'),
(2637, 'https://ror.org/0340t0585', 'en', 1, 'https://ror.org/0340t0585 General Hospital of Shenyang Military Region 中国人民解放军沈阳军区总医院'),
(2638, 'https://ror.org/0340wst14', 'en', 1, 'https://ror.org/0340wst14 Changzhi Medical College 长治医学院'),
(2639, 'https://ror.org/0346ycw92', 'no_lang_code', 1, 'https://ror.org/0346ycw92 Saiseikai Central Hospital 東京都済生会中央病院'),
(2640, 'https://ror.org/034adnw64', 'en', 1, 'https://ror.org/034adnw64 Durham VA Medical Center'),
(2641, 'https://ror.org/034c1gc25', 'en', 1, 'https://ror.org/034c1gc25 Maine Medical Center'),
(2642, 'https://ror.org/034c6s521', 'en', 1, 'https://ror.org/034c6s521 Amarillo VA Health Care System'),
(2643, 'https://ror.org/034dczg46', 'en', 1, 'https://ror.org/034dczg46 Chandka Medical College'),
(2644, 'https://ror.org/034de1n65', 'en', 1, 'https://ror.org/034de1n65 Utah Department of Health'),
(2645, 'https://ror.org/034f0sr31', 'no_lang_code', 1, 'https://ror.org/034f0sr31 NuvOx Pharma (United States)'),
(2646, 'https://ror.org/034fmtr90', 'en', 1, 'https://ror.org/034fmtr90 Empirica. Gesellschaft für Kommunikations- und Technologieforschung empirica - Communication and Technology Research'),
(2647, 'https://ror.org/034pdr896', 'en', 1, 'https://ror.org/034pdr896 Dallas VA Medical Center'),
(2648, 'https://ror.org/034t5cp02', 'en', 1, 'https://ror.org/034t5cp02 North Carolina Division of Public Health'),
(2649, 'https://ror.org/034w83t88', 'tr', 1, 'https://ror.org/034w83t88 Özel Trakya Hastanesi'),
(2650, 'https://ror.org/034xj0q80', 'en', 1, 'https://ror.org/034xj0q80 Orenburg State Medical Academy Оренбургский государственный медицинский университет'),
(2651, 'https://ror.org/034zcbh25', 'tr', 1, 'https://ror.org/034zcbh25 Ergani Devlet Hastanesi'),
(2652, 'https://ror.org/0351yd374', 'en', 1, 'https://ror.org/0351yd374 Shinkyo Hospital'),
(2653, 'https://ror.org/0353kya20', 'pt', 1, 'https://ror.org/0353kya20 Hospital Curry Cabral'),
(2654, 'https://ror.org/0353q6p88', 'en', 1, 'https://ror.org/0353q6p88 Sydney South West Area Health Service'),
(2655, 'https://ror.org/0354m4207', 'no_lang_code', 1, 'https://ror.org/0354m4207 Kinexus Bioinformatics Corporation (Canada)'),
(2656, 'https://ror.org/0356c4a29', 'en', 1, 'https://ror.org/0356c4a29 Läkemedelsverket Medical Products Agency'),
(2657, 'https://ror.org/0357r2107', 'en', 1, 'https://ror.org/0357r2107 Ministry of Health'),
(2658, 'https://ror.org/035a72598', 'en', 1, 'https://ror.org/035a72598 Lincoln Medical Center'),
(2659, 'https://ror.org/035dmz332', 'en', 1, 'https://ror.org/035dmz332 World Health Organization - Australia'),
(2660, 'https://ror.org/035gy9016', 'no_lang_code', 1, 'https://ror.org/035gy9016 Tecnatom (Spain)'),
(2661, 'https://ror.org/035j0tq82', 'no_lang_code', 1, 'https://ror.org/035j0tq82 Orange (France)'),
(2662, 'https://ror.org/035j3m047', 'en', 1, 'https://ror.org/035j3m047 New York Hall of Science'),
(2663, 'https://ror.org/035khf156', 'en', 1, 'https://ror.org/035khf156 Hyogo Social Welfare Corporation 兵庫県立リハビリテーション中央病院'),
(2664, 'https://ror.org/035mqap40', 'no_lang_code', 1, 'https://ror.org/035mqap40 Membrane Technology & Research (United States)'),
(2665, 'https://ror.org/035n3nf68', 'en', 1, 'https://ror.org/035n3nf68 Security Forces Hospital'),
(2666, 'https://ror.org/035p1zc77', 'en', 1, 'https://ror.org/035p1zc77 St John of Jerusalem Eye Hospital Group'),
(2667, 'https://ror.org/035r7hb75', 'en', 1, 'https://ror.org/035r7hb75 Keimyung University Dongsan Medical Center 계명대학교 동산의료원'),
(2668, 'https://ror.org/035rhx828', 'en', 1, 'https://ror.org/035rhx828 Kunming University 昆明学院'),
(2669, 'https://ror.org/035t17984', 'en', 1, 'https://ror.org/035t17984 Beijing Jishuitan Hospital 北京市创伤骨科研究所'),
(2670, 'https://ror.org/035vb3h42', 'en', 1, 'https://ror.org/035vb3h42 Kinderspital Zürich University Children''s Hospital Zurich'),
(2671, 'https://ror.org/035xbsb93', 'en', 1, 'https://ror.org/035xbsb93 Al-Sabah Hospital'),
(2672, 'https://ror.org/035xhk118', 'en', 1, 'https://ror.org/035xhk118 Audie L. Murphy Memorial VA Hospital'),
(2673, 'https://ror.org/035y9xj66', 'en', 1, 'https://ror.org/035y9xj66 Consortium For Mathematics & Its Applications'),
(2674, 'https://ror.org/035z2ew45', 'en', 1, 'https://ror.org/035z2ew45 Eastern Illinois University Université de l''illinois de l''est'),
(2675, 'https://ror.org/035z6xf33', 'en', 1, 'https://ror.org/035z6xf33 Oklahoma Medical Research Foundation'),
(2676, 'https://ror.org/0360cq027', 'en', 1, 'https://ror.org/0360cq027 LDS Hospital'),
(2677, 'https://ror.org/0362za439', 'en', 1, 'https://ror.org/0362za439 Ministry of Health'),
(2678, 'https://ror.org/03645mz20', 'nl', 1, 'https://ror.org/03645mz20 Stichting Technasium'),
(2679, 'https://ror.org/0364a8z71', 'tr', 1, 'https://ror.org/0364a8z71 Denizli Devlet Hastanesi Denizli State Hospital'),
(2680, 'https://ror.org/03661z977', 'no_lang_code', 1, 'https://ror.org/03661z977 HEF Groupe (France)'),
(2681, 'https://ror.org/0367gm239', 'en', 1, 'https://ror.org/0367gm239 Eulji University Hospital 을지대학교병원'),
(2682, 'https://ror.org/0367njg58', 'en', 1, 'https://ror.org/0367njg58 East Central University'),
(2683, 'https://ror.org/0367sye10', 'nl', 1, 'https://ror.org/0367sye10 Atrium Medisch Centrum Parkstad'),
(2684, 'https://ror.org/0368s4g32', 'en', 1, 'https://ror.org/0368s4g32 China Medical University Hospital'),
(2685, 'https://ror.org/0369pvp92', 'no_lang_code', 1, 'https://ror.org/0369pvp92 Nanchang Hangkong University 南昌航空大学'),
(2686, 'https://ror.org/0369st156', 'en', 1, 'https://ror.org/0369st156 Slippery Rock University'),
(2687, 'https://ror.org/036a0e562', 'en', 1, 'https://ror.org/036a0e562 Baltimore VA Medical Center'),
(2688, 'https://ror.org/036c27j91', 'en', 1, 'https://ror.org/036c27j91 Washington University Medical Center'),
(2689, 'https://ror.org/036c3t778', 'en', 1, 'https://ror.org/036c3t778 Niigata Prefectural Museum of History 新潟県立歴史博物館'),
(2690, 'https://ror.org/036dess41', 'pt', 1, 'https://ror.org/036dess41 Hospital do Desterro'),
(2691, 'https://ror.org/036dkm174', 'es', 1, 'https://ror.org/036dkm174 Hospital Santa Caterina'),
(2692, 'https://ror.org/036mbxj57', 'en', 1, 'https://ror.org/036mbxj57 Banff Mineral Springs Hospital'),
(2693, 'https://ror.org/036njfn21', 'en', 1, 'https://ror.org/036njfn21 Ministry of Health'),
(2694, 'https://ror.org/036nxkh98', 'en', 1, 'https://ror.org/036nxkh98 Carilion Roanoke Memorial Hospital'),
(2695, 'https://ror.org/036qtaj98', 'en', 1, 'https://ror.org/036qtaj98 Greenwich Hospital'),
(2696, 'https://ror.org/036s9kg65', 'en', 1, 'https://ror.org/036s9kg65 Monash Medical Centre'),
(2697, 'https://ror.org/036sak533', 'en', 1, 'https://ror.org/036sak533 Southern Arkansas University'),
(2698, 'https://ror.org/036sdak78', 'en', 1, 'https://ror.org/036sdak78 Educational Commission for Foreign Medical Graduates'),
(2699, 'https://ror.org/036wxg427', 'no_lang_code', 1, 'https://ror.org/036wxg427 Jordan Hospital مستشفى الأردن'),
(2700, 'https://ror.org/036yvre49', 'en', 1, 'https://ror.org/036yvre49 Kemerovo State University Кемеровский государственный университет'),
(2701, 'https://ror.org/03720tm64', 'pt', 1, 'https://ror.org/03720tm64 Fundação Ricardo do Espírito Santo Silva'),
(2702, 'https://ror.org/0372t5741', 'en', 1, 'https://ror.org/0372t5741 Gifu Pharmaceutical University 岐阜薬科大学'),
(2703, 'https://ror.org/0373nm262', 'en', 1, 'https://ror.org/0373nm262 Kongju National University 공주대학교'),
(2704, 'https://ror.org/03763ep67', 'en', 1, 'https://ror.org/03763ep67 Children''s Hospital of Pittsburgh'),
(2705, 'https://ror.org/0376mc966', 'en', 1, 'https://ror.org/0376mc966 Haskell Indian Nations University'),
(2706, 'https://ror.org/0376myh60', 'pt', 1, 'https://ror.org/0376myh60 Catholic University of Pelotas Universidade Católica de Pelotas'),
(2707, 'https://ror.org/0376vhj74', 'en', 1, 'https://ror.org/0376vhj74 Lewis University'),
(2708, 'https://ror.org/037767x92', 'en', 1, 'https://ror.org/037767x92 Himeji Medical Center 独立行政法人 国立病院機構 姫路医療センター'),
(2709, 'https://ror.org/037a76178', 'en', 1, 'https://ror.org/037a76178 Handa City Hospital 半田市立半田病院'),
(2710, 'https://ror.org/037d0vf92', 'en', 1, 'https://ror.org/037d0vf92 Nizhny Novgorod State Technical University Нижегородский государственный технический университет'),
(2711, 'https://ror.org/037dvnz29', 'en', 1, 'https://ror.org/037dvnz29 Shriners Hospitals for Children - Houston'),
(2712, 'https://ror.org/037f4ry86', 'en', 1, 'https://ror.org/037f4ry86 Regional West Medical Center'),
(2713, 'https://ror.org/037m3rm63', 'en', 1, 'https://ror.org/037m3rm63 Japanese Red Cross Asahikawa Hospital 旭川赤十字病院'),
(2714, 'https://ror.org/037m6e306', 'no_lang_code', 1, 'https://ror.org/037m6e306 Pera (United Kingdom)'),
(2715, 'https://ror.org/037mpqg03', 'no_lang_code', 1, 'https://ror.org/037mpqg03 Xstrata (United Kingdom)'),
(2716, 'https://ror.org/037nakk48', 'no_lang_code', 1, 'https://ror.org/037nakk48 Pinnacle Technology'),
(2717, 'https://ror.org/037pmhh38', 'no_lang_code', 1, 'https://ror.org/037pmhh38 Physical Optics Corporation'),
(2718, 'https://ror.org/037r57b62', 'en', 1, 'https://ror.org/037r57b62 Buddhist Tzu Chi General Hospital'),
(2719, 'https://ror.org/037rt4a55', 'en', 1, 'https://ror.org/037rt4a55 National Academy of Agricultural Science 국립농업과학원'),
(2720, 'https://ror.org/037s3ck33', 'en', 1, 'https://ror.org/037s3ck33 Shatin Hospital 沙田醫院'),
(2721, 'https://ror.org/037s71n47', 'en', 1, 'https://ror.org/037s71n47 Imelda Hospital Imelda ziekenhuis'),
(2722, 'https://ror.org/037v8w471', 'en', 1, 'https://ror.org/037v8w471 Memorial Hermann Institute for Rehabilitation and Research Foundation'),
(2723, 'https://ror.org/037wegn60', 'en', 1, 'https://ror.org/037wegn60 University of the District of Columbia Université du district de columbia'),
(2724, 'https://ror.org/037wq4b75', 'de', 1, 'https://ror.org/037wq4b75 Klinikum Ludwigshafen'),
(2725, 'https://ror.org/037y5zq83', 'en', 1, 'https://ror.org/037y5zq83 Kolding Hospital'),
(2726, 'https://ror.org/037ybm139', 'en', 1, 'https://ror.org/037ybm139 Baptist Medical Center Jacksonville'),
(2727, 'https://ror.org/037ze7373', 'tr', 1, 'https://ror.org/037ze7373 Etlik Zübeyde Hanım Kadın Hastalıkları Eğitim ve Araştırma Hastanesi'),
(2728, 'https://ror.org/0380w8h49', 'en', 1, 'https://ror.org/0380w8h49 Ealing Hospital NHS Trust'),
(2729, 'https://ror.org/038152964', 'es', 1, 'https://ror.org/038152964 Hospital Riotinto'),
(2730, 'https://ror.org/0382k6j58', 'en', 1, 'https://ror.org/0382k6j58 Nambu University'),
(2731, 'https://ror.org/0382m3r69', 'en', 1, 'https://ror.org/0382m3r69 Dr Gray''s Hospital'),
(2732, 'https://ror.org/038321296', 'en', 1, 'https://ror.org/038321296 Gladstone Institutes'),
(2733, 'https://ror.org/0384ghs60', 'en', 1, 'https://ror.org/0384ghs60 National Center for Drug Screening 国家新药筛选中心'),
(2734, 'https://ror.org/0389fv189', 'en', 1, 'https://ror.org/0389fv189 Guangxi Maternal and Child Health Hospital 广西妇幼保健院'),
(2735, 'https://ror.org/0389pw608', 'en', 1, 'https://ror.org/0389pw608 Center for High Pressure Science and Technology Advanced Research 北京高压科学研究中心'),
(2736, 'https://ror.org/0389pzc90', 'en', 1, 'https://ror.org/0389pzc90 Altai State Technical University Алтайский государственный технический университет имени И. И. Ползунова'),
(2737, 'https://ror.org/038bgk418', 'en', 1, 'https://ror.org/038bgk418 Okayama Prefectural University 岡山県立大学'),
(2738, 'https://ror.org/038c3w259', 'en', 1, 'https://ror.org/038c3w259 Kunming Medical University 昆明医科大学'),
(2739, 'https://ror.org/038c5sp60', 'en', 1, 'https://ror.org/038c5sp60 Poudre Valley Hospital'),
(2740, 'https://ror.org/038ckz871', 'no_lang_code', 1, 'https://ror.org/038ckz871 Kaneka (Japan) 株式会社カネカ'),
(2741, 'https://ror.org/038cpkc46', 'en', 1, 'https://ror.org/038cpkc46 Northrop University'),
(2742, 'https://ror.org/038d10y34', 'en', 1, 'https://ror.org/038d10y34 National Wildlife Health Center'),
(2743, 'https://ror.org/038e9x269', 'no_lang_code', 1, 'https://ror.org/038e9x269 Kumaun University कुमाऊँ विश्वविद्यालय குமாவுன் பல்கலைக்கழகம்'),
(2744, 'https://ror.org/038estk42', 'en', 1, 'https://ror.org/038estk42 Shinmatsudo Central General Hospital 新松戸中央総合病院'),
(2745, 'https://ror.org/038fqcc39', 'en', 1, 'https://ror.org/038fqcc39 UPMC Hamot'),
(2746, 'https://ror.org/038fwcw54', 'en', 1, 'https://ror.org/038fwcw54 National Satellite Ocean Application Service 国家卫星海洋应用中心'),
(2747, 'https://ror.org/038h97h67', 'tr', 1, 'https://ror.org/038h97h67 Izmir Tepecik Eğitim ve Araştırma Hastanesi'),
(2748, 'https://ror.org/038j9sn30', 'en', 1, 'https://ror.org/038j9sn30 Shanghai Institute of Hypertension'),
(2749, 'https://ror.org/038jxf238', 'en', 1, 'https://ror.org/038jxf238 Natividad Medical Center'),
(2750, 'https://ror.org/038mfx688', 'en', 1, 'https://ror.org/038mfx688 National Academy of Sciences'),
(2751, 'https://ror.org/038mzt421', 'no_lang_code', 1, 'https://ror.org/038mzt421 Nerviano Medical Sciences'),
(2752, 'https://ror.org/038nb9c73', 'en', 1, 'https://ror.org/038nb9c73 Olivet Nazarene University'),
(2753, 'https://ror.org/038qbqz41', 'en', 1, 'https://ror.org/038qbqz41 Lovelace Respiratory Research Institute'),
(2754, 'https://ror.org/038rhxb62', 'no_lang_code', 1, 'https://ror.org/038rhxb62 IM Systems (United States)'),
(2755, 'https://ror.org/038v5dr76', 'en', 1, 'https://ror.org/038v5dr76 Rapid City Regional Hospital'),
(2756, 'https://ror.org/038vg5g56', 'en', 1, 'https://ror.org/038vg5g56 Delaware County Memorial Hospital'),
(2757, 'https://ror.org/038x2fh14', 'en', 1, 'https://ror.org/038x2fh14 Charles R. Drew University of Medicine and Science'),
(2758, 'https://ror.org/038ygd080', 'en', 1, 'https://ror.org/038ygd080 Inner Mongolia Medical College Hospital 内蒙古医科大学附属医院'),
(2759, 'https://ror.org/038yw9848', 'en', 1, 'https://ror.org/038yw9848 Kaiser Permanente Santa Clara Medical Center'),
(2760, 'https://ror.org/038zf2n28', 'en', 1, 'https://ror.org/038zf2n28 Youngstown State University'),
(2761, 'https://ror.org/0393ghj09', 'no_lang_code', 1, 'https://ror.org/0393ghj09 Habib hospital Thameur'),
(2762, 'https://ror.org/03950pc16', 'en', 1, 'https://ror.org/03950pc16 Allergy and Asthma Medical Group and Research Center'),
(2763, 'https://ror.org/03964hc96', 'en', 1, 'https://ror.org/03964hc96 Borgess Medical Center'),
(2764, 'https://ror.org/0396v4y86', 'fr', 1, 'https://ror.org/0396v4y86 Hôpital Louis Pradel'),
(2765, 'https://ror.org/039713658', 'en', 1, 'https://ror.org/039713658 First Affiliated Hospital of Chinese PLA General Hospital 中国人民解放军总医院第一附属医院'),
(2766, 'https://ror.org/0397tsa92', 'en', 1, 'https://ror.org/0397tsa92 Clark Atlanta University'),
(2767, 'https://ror.org/0398yj006', 'es', 1, 'https://ror.org/0398yj006 Hospital Muñiz, Hospital de Infecciosas “Dr. Francisco Javier Muñiz"'),
(2768, 'https://ror.org/039ajs610', 'no_lang_code', 1, 'https://ror.org/039ajs610 Weyerhauser (Canada)'),
(2769, 'https://ror.org/039bxh911', 'it', 1, 'https://ror.org/039bxh911 Ospedale Infermi di Rimini'),
(2770, 'https://ror.org/039c6rk82', 'en', 1, 'https://ror.org/039c6rk82 Ninewells Hospital'),
(2771, 'https://ror.org/039cbw303', 'no_lang_code', 1, 'https://ror.org/039cbw303 Dhaka Shishu Hospital'),
(2772, 'https://ror.org/039dmez53', 'en', 1, 'https://ror.org/039dmez53 LeMoyne–Owen College'),
(2773, 'https://ror.org/039efr729', 'pt', 1, 'https://ror.org/039efr729 Instituto Português de Administração de Marketing'),
(2774, 'https://ror.org/039evc422', 'en', 1, 'https://ror.org/039evc422 Municipal Institute for Medical Research'),
(2775, 'https://ror.org/039f7g519', 'en', 1, 'https://ror.org/039f7g519 Springfield Technical Community College'),
(2776, 'https://ror.org/039h3vh71', 'en', 1, 'https://ror.org/039h3vh71 Capital and Coast District Health Board'),
(2777, 'https://ror.org/039mhfq69', 'en', 1, 'https://ror.org/039mhfq69 Bangkok Hospital โรงพยาบาลกรุงเทพ'),
(2778, 'https://ror.org/039nw9e11', 'en', 1, 'https://ror.org/039nw9e11 Third Affiliated Hospital of Zhengzhou University 郑州大学第三附属医院'),
(2779, 'https://ror.org/039p7ck60', 'en', 1, 'https://ror.org/039p7ck60 Dongduk Women''s University 동덕여자대학교'),
(2780, 'https://ror.org/039q00p63', 'en', 1, 'https://ror.org/039q00p63 Edward Francis Small Teaching Hospital'),
(2781, 'https://ror.org/039ryp971', 'en', 1, 'https://ror.org/039ryp971 Grodno State Medical University Гродзенскі дзяржаўны медыцынскі універсітэт Гродненский государственный медицинский университет'),
(2782, 'https://ror.org/039se3q37', 'en', 1, 'https://ror.org/039se3q37 County Hospital'),
(2783, 'https://ror.org/039thcs93', 'en', 1, 'https://ror.org/039thcs93 Sri Venkateswara Institute of Medical Sciences'),
(2784, 'https://ror.org/039tm4h11', 'en', 1, 'https://ror.org/039tm4h11 Sree Balaji Dental College and Hospital'),
(2785, 'https://ror.org/039tzxh97', 'en', 1, 'https://ror.org/039tzxh97 Queen Elizabeth the Queen Mother Hospital'),
(2786, 'https://ror.org/039xw7n32', 'en', 1, 'https://ror.org/039xw7n32 Istituto Universitario di Studi Europei University Institute of European Studies'),
(2787, 'https://ror.org/039ygjf22', 'en', 1, 'https://ror.org/039ygjf22 Jikei University School of Medicine 東京慈恵会医科大学'),
(2788, 'https://ror.org/039zd5s34', 'en', 1, 'https://ror.org/039zd5s34 Integral University Université intégrale de lucknow इंटीग्रल विश्वविद्यालय'),
(2789, 'https://ror.org/03a1gte98', 'en', 1, 'https://ror.org/03a1gte98 Agence spatiale canadienne Canadian Space Agency'),
(2790, 'https://ror.org/03a1rt493', 'en', 1, 'https://ror.org/03a1rt493 Kätilöopisto Maternity Hospital'),
(2791, 'https://ror.org/03a23ch04', 'en', 1, 'https://ror.org/03a23ch04 Health Protection Surveillance Centre Lárionad Faire um Chosaint Sláinte'),
(2792, 'https://ror.org/03a3qwm26', 'en', 1, 'https://ror.org/03a3qwm26 Augustana University'),
(2793, 'https://ror.org/03a4vma36', 'en', 1, 'https://ror.org/03a4vma36 Queensborough Community College, CUNY'),
(2794, 'https://ror.org/03a6a0a65', 'pt', 1, 'https://ror.org/03a6a0a65 Universidade do Oeste de Santa Catarina'),
(2795, 'https://ror.org/03a6zw892', 'en', 1, 'https://ror.org/03a6zw892 Lurie Children''s Hospital'),
(2796, 'https://ror.org/03a8gac78', 'es', 1, 'https://ror.org/03a8gac78 Hospital Del Mar'),
(2797, 'https://ror.org/03aam9155', 'en', 1, 'https://ror.org/03aam9155 KLE University'),
(2798, 'https://ror.org/03ac64295', 'en', 1, 'https://ror.org/03ac64295 American Society For Engineering Education'),
(2799, 'https://ror.org/03acrxj66', 'en', 1, 'https://ror.org/03acrxj66 North Memorial Health Care'),
(2800, 'https://ror.org/03ag59v15', 'pt', 1, 'https://ror.org/03ag59v15 Universidade Estadual de Ciências da Saúde de Alagoas'),
(2801, 'https://ror.org/03ag5ed62', 'no_lang_code', 1, 'https://ror.org/03ag5ed62 Allied Technology (United States)'),
(2802, 'https://ror.org/03am3jt82', 'sv', 1, 'https://ror.org/03am3jt82 Helsingborgs lasarett'),
(2803, 'https://ror.org/03andr831', 'en', 1, 'https://ror.org/03andr831 Christian Brothers University'),
(2804, 'https://ror.org/03ap6wx93', 'en', 1, 'https://ror.org/03ap6wx93 Queen''s Medical Centre'),
(2805, 'https://ror.org/03apjks92', 'en', 1, 'https://ror.org/03apjks92 Martin Luther King, Jr. Multi-Service Ambulatory Care Center'),
(2806, 'https://ror.org/03atxgt72', 'en', 1, 'https://ror.org/03atxgt72 Coney Island Hospital'),
(2807, 'https://ror.org/03aw5sn18', 'en', 1, 'https://ror.org/03aw5sn18 University of California San Diego Medical Center'),
(2808, 'https://ror.org/03awtex73', 'no_lang_code', 1, 'https://ror.org/03awtex73 Arup Group (United States)'),
(2809, 'https://ror.org/03ay8b853', 'en', 1, 'https://ror.org/03ay8b853 Police General Hospital โรงพยาบาลตำรวจ'),
(2810, 'https://ror.org/03ayf0c60', 'en', 1, 'https://ror.org/03ayf0c60 Kagawa Nutrition University 女子栄養大学'),
(2811, 'https://ror.org/03aypnd11', 'en', 1, 'https://ror.org/03aypnd11 Ayub Medical College'),
(2812, 'https://ror.org/03b2b5383', 'en', 1, 'https://ror.org/03b2b5383 Diana Princess of Wales Hospital'),
(2813, 'https://ror.org/03b353k89', 'en', 1, 'https://ror.org/03b353k89 Saint Michael''s College'),
(2814, 'https://ror.org/03b3qq257', 'es', 1, 'https://ror.org/03b3qq257 Hospital Padre Hurtado'),
(2815, 'https://ror.org/03b48gv34', 'en', 1, 'https://ror.org/03b48gv34 University of Mary Washington Université de mary washington'),
(2816, 'https://ror.org/03b5q4637', 'en', 1, 'https://ror.org/03b5q4637 Educational Testing Service'),
(2817, 'https://ror.org/03b6sp482', 'en', 1, 'https://ror.org/03b6sp482 Southern University System'),
(2818, 'https://ror.org/03b705z14', 'es', 1, 'https://ror.org/03b705z14 Hospital Vargas'),
(2819, 'https://ror.org/03b7nc883', 'en', 1, 'https://ror.org/03b7nc883 Colmery-O''Neil VA Medical Center'),
(2820, 'https://ror.org/03b982x90', 'en', 1, 'https://ror.org/03b982x90 Post Graduate Medical Institute'),
(2821, 'https://ror.org/03bag5a72', 'en', 1, 'https://ror.org/03bag5a72 Ladoke Akintola University of Technology Teaching Hospital'),
(2822, 'https://ror.org/03bahkk91', 'en', 1, 'https://ror.org/03bahkk91 Arkansas Tech University'),
(2823, 'https://ror.org/03bfp2076', 'en', 1, 'https://ror.org/03bfp2076 Beckman Laser Institute and Medical Clinic'),
(2824, 'https://ror.org/03bg2rq25', 'en', 1, 'https://ror.org/03bg2rq25 American Public Health Association'),
(2825, 'https://ror.org/03bj8zh59', 'no_lang_code', 1, 'https://ror.org/03bj8zh59 Tata Steel (United Kingdom)'),
(2826, 'https://ror.org/03bpc5f92', 'en', 1, 'https://ror.org/03bpc5f92 Institute for Medical Research'),
(2827, 'https://ror.org/03bq2c460', 'no_lang_code', 1, 'https://ror.org/03bq2c460 Barrick Gold (Canada)'),
(2828, 'https://ror.org/03bqt8z64', 'no_lang_code', 1, 'https://ror.org/03bqt8z64 National Institute of Technology'),
(2829, 'https://ror.org/03bs2yy11', 'en', 1, 'https://ror.org/03bs2yy11 Queen Victoria Hospital NHS Foundation Trust'),
(2830, 'https://ror.org/03btpnr35', 'en', 1, 'https://ror.org/03btpnr35 Shaukat Khanum Memorial Cancer Hospital and Research Center شوکت خانم یادگاری سرطان شفاخانہ اور مرکز تحقیق'),
(2831, 'https://ror.org/03bvvnt49', 'en', 1, 'https://ror.org/03bvvnt49 National Taiwan Ocean University'),
(2832, 'https://ror.org/03bvx5w91', 'it', 1, 'https://ror.org/03bvx5w91 Fondazione Eni Enrico Mattei'),
(2833, 'https://ror.org/03bwf4y78', 'sk', 1, 'https://ror.org/03bwf4y78 Slovak National Library Slovenska Narodna Kniznica, Slovenská národná knižnica'),
(2834, 'https://ror.org/03bwzch55', 'en', 1, 'https://ror.org/03bwzch55 Kyushu Dental University 九州歯科大学'),
(2835, 'https://ror.org/03bx60s49', 'en', 1, 'https://ror.org/03bx60s49 Cancer Prevention Institute of California'),
(2836, 'https://ror.org/03by16w37', 'en', 1, 'https://ror.org/03by16w37 Chonbuk National University Hospital'),
(2837, 'https://ror.org/03byx8t68', 'en', 1, 'https://ror.org/03byx8t68 Clarke University'),
(2838, 'https://ror.org/03bzbh797', 'en', 1, 'https://ror.org/03bzbh797 UPMC Montefiore'),
(2839, 'https://ror.org/03bzz8q98', 'en', 1, 'https://ror.org/03bzz8q98 175th Hospital of People''s Liberation Army 解放军第175医院'),
(2840, 'https://ror.org/03c23hy31', 'no_lang_code', 1, 'https://ror.org/03c23hy31 One Cell Systems (United States)'),
(2841, 'https://ror.org/03c266r37', 'en', 1, 'https://ror.org/03c266r37 Gifu Prefectural General Medical Center 岐阜県総合医療センター'),
(2842, 'https://ror.org/03c3d1v10', 'en', 1, 'https://ror.org/03c3d1v10 General University Hospital of Patras'),
(2843, 'https://ror.org/03c622h45', 'en', 1, 'https://ror.org/03c622h45 National Academy for State Health Policy'),
(2844, 'https://ror.org/03c648b36', 'en', 1, 'https://ror.org/03c648b36 Ehime Prefectural Central Hospital 愛媛県立中央病院'),
(2845, 'https://ror.org/03c7caz94', 'en', 1, 'https://ror.org/03c7caz94 Sri Aurobindo Institute of Medical Sciences'),
(2846, 'https://ror.org/03c8c9n80', 'en', 1, 'https://ror.org/03c8c9n80 Cathay General Hospital'),
(2847, 'https://ror.org/03c8ed890', 'en', 1, 'https://ror.org/03c8ed890 Sewickley Valley Hospital'),
(2848, 'https://ror.org/03c8vvr84', 'en', 1, 'https://ror.org/03c8vvr84 University of Western States'),
(2849, 'https://ror.org/03ca99543', 'tr', 1, 'https://ror.org/03ca99543 SSK İhtisas Hastanesi'),
(2850, 'https://ror.org/03cbwf726', 'en', 1, 'https://ror.org/03cbwf726 Lakeland Regional Medical Center'),
(2851, 'https://ror.org/03cc0mm23', 'en', 1, 'https://ror.org/03cc0mm23 Nassau University Medical Center'),
(2852, 'https://ror.org/03cf9xg09', 'en', 1, 'https://ror.org/03cf9xg09 California Institute for Medical Research'),
(2853, 'https://ror.org/03cfvmk82', 'en', 1, 'https://ror.org/03cfvmk82 VA Sierra Nevada Health Care System'),
(2854, 'https://ror.org/03cfz7739', 'no_lang_code', 1, 'https://ror.org/03cfz7739 Kawasaki Hospital 川崎病院'),
(2855, 'https://ror.org/03chkg278', 'en', 1, 'https://ror.org/03chkg278 Coe College'),
(2856, 'https://ror.org/03chnr738', 'en', 1, 'https://ror.org/03chnr738 Hope College'),
(2857, 'https://ror.org/03cht9689', 'en', 1, 'https://ror.org/03cht9689 Royal Hospital'),
(2858, 'https://ror.org/03cjj7d58', 'pt', 1, 'https://ror.org/03cjj7d58 Hospital Municipal Souza Aguiar'),
(2859, 'https://ror.org/03cngf009', 'en', 1, 'https://ror.org/03cngf009 Craigavon Area Hospital'),
(2860, 'https://ror.org/03cqd3e64', 'en', 1, 'https://ror.org/03cqd3e64 Connecticut Department of Public Health'),
(2861, 'https://ror.org/03cqsth74', 'en', 1, 'https://ror.org/03cqsth74 Muhlenberg College'),
(2862, 'https://ror.org/03cxsty68', 'pt', 1, 'https://ror.org/03cxsty68 Universidade Estadual do Centro-Oeste'),
(2863, 'https://ror.org/03cyvdv85', 'en', 1, 'https://ror.org/03cyvdv85 First Affiliated Hospital of Wenzhou Medical University'),
(2864, 'https://ror.org/03d0z1f54', 'no_lang_code', 1, 'https://ror.org/03d0z1f54 Electrosynthesis Company (United States)'),
(2865, 'https://ror.org/03d1v2g75', 'no_lang_code', 1, 'https://ror.org/03d1v2g75 Epoch Biosciences (United States)'),
(2866, 'https://ror.org/03d1wq758', 'en', 1, 'https://ror.org/03d1wq758 Maine Medical Center Research Institute'),
(2867, 'https://ror.org/03d4d3711', 'en', 1, 'https://ror.org/03d4d3711 Central Taiwan University of Science and Technology'),
(2868, 'https://ror.org/03d532p87', 'fr', 1, 'https://ror.org/03d532p87 Hôpital Xavier Arnozan'),
(2869, 'https://ror.org/03d58dr58', 'en', 1, 'https://ror.org/03d58dr58 National Neuroscience Institute'),
(2870, 'https://ror.org/03d5pp684', 'pt', 1, 'https://ror.org/03d5pp684 Escola Superior de Enfermagem de São José de Cluny'),
(2871, 'https://ror.org/03d6dzy78', 'en', 1, 'https://ror.org/03d6dzy78 Karnataka Institute of Medical Sciences ಕರ್ನಾಟಕ ವೈದ್ಯಕೀಯ ವಿಜ್ಞಾನ ಸಂಸ್ಥೆ'),
(2872, 'https://ror.org/03d7m4a98', 'no_lang_code', 1, 'https://ror.org/03d7m4a98 Ross Video (Canada)'),
(2873, 'https://ror.org/03d8mqt26', 'en', 1, 'https://ror.org/03d8mqt26 Princess Royal University Hospital'),
(2874, 'https://ror.org/03davap66', 'en', 1, 'https://ror.org/03davap66 Illinois State Museum'),
(2875, 'https://ror.org/03db3by08', 'en', 1, 'https://ror.org/03db3by08 Northeast Radio Observatory Corporation'),
(2876, 'https://ror.org/03dcdys28', 'en', 1, 'https://ror.org/03dcdys28 Alaska Department of Health and Social Services'),
(2877, 'https://ror.org/03ddsp339', 'no_lang_code', 1, 'https://ror.org/03ddsp339 Pyrogenesis (Canada)'),
(2878, 'https://ror.org/03ddz1316', 'en', 1, 'https://ror.org/03ddz1316 Anhui Provincial Center for Disease Control and Prevention 安徽省疾病预防控制中心'),
(2879, 'https://ror.org/03dhz7247', 'en', 1, 'https://ror.org/03dhz7247 Research Centre for Medical Genetics'),
(2880, 'https://ror.org/03djvm380', 'it', 1, 'https://ror.org/03djvm380 Ospedale Generale Regionale Francesco Miulli'),
(2881, 'https://ror.org/03dke3h47', 'en', 1, 'https://ror.org/03dke3h47 Association of Science-Technology Centers'),
(2882, 'https://ror.org/03dkpj951', 'en', 1, 'https://ror.org/03dkpj951 East Jefferson General Hospital'),
(2883, 'https://ror.org/03dkyhy49', 'no_lang_code', 1, 'https://ror.org/03dkyhy49 Artann Laboratories, Inc.'),
(2884, 'https://ror.org/03dm1pq74', 'en', 1, 'https://ror.org/03dm1pq74 Grant Medical College and Sir Jamshedjee Jeejeebhoy Group of Hospitals'),
(2885, 'https://ror.org/03dm2se39', 'en', 1, 'https://ror.org/03dm2se39 Christ Hospital'),
(2886, 'https://ror.org/03dnktm38', 'no_lang_code', 1, 'https://ror.org/03dnktm38 Scimar Engineering Ltd'),
(2887, 'https://ror.org/03dqzan26', 'en', 1, 'https://ror.org/03dqzan26 Salem University'),
(2888, 'https://ror.org/03dsc8d33', 'no_lang_code', 1, 'https://ror.org/03dsc8d33 Systems, Applications & Products in Data Processing (Germany)'),
(2889, 'https://ror.org/03dsgss45', 'ca', 1, 'https://ror.org/03dsgss45 Hospital Mare de Déu de la Mercè'),
(2890, 'https://ror.org/03dwvx056', 'tr', 1, 'https://ror.org/03dwvx056 Elazig Education and Research Hospital Elazığ Eğitim ve Araştırma Hastanesi'),
(2891, 'https://ror.org/03dwx1z96', 'en', 1, 'https://ror.org/03dwx1z96 Maulana Azad Medical College மௌலானா ஆசாத் மருத்துவக் கல்லூரி'),
(2892, 'https://ror.org/03dwxvb85', 'no_lang_code', 1, 'https://ror.org/03dwxvb85 Jamia Hamdard'),
(2893, 'https://ror.org/03dx46b94', 'en', 1, 'https://ror.org/03dx46b94 Royal National Orthopaedic Hospital NHS Trust'),
(2894, 'https://ror.org/03e05fb06', 'en', 1, 'https://ror.org/03e05fb06 DSO National Laboratories'),
(2895, 'https://ror.org/03e1ayz78', 'en', 1, 'https://ror.org/03e1ayz78 University of Minnesota Medical Center'),
(2896, 'https://ror.org/03e1xkn26', 'en', 1, 'https://ror.org/03e1xkn26 Florida Department of Health'),
(2897, 'https://ror.org/03e269852', 'en', 1, 'https://ror.org/03e269852 Donetsk State University of Management Донецкий государственный университет управления Донецький державний університет управління'),
(2898, 'https://ror.org/03e2qe334', 'no_lang_code', 1, 'https://ror.org/03e2qe334 Naresuan University มหาวิทยาลัยนเรศวร'),
(2899, 'https://ror.org/03e36d037', 'es', 1, 'https://ror.org/03e36d037 ABC Medical Center Centro Médico ABC'),
(2900, 'https://ror.org/03e4nh963', 'en', 1, 'https://ror.org/03e4nh963 Federal Medical Centre'),
(2901, 'https://ror.org/03e8ncw23', 'en', 1, 'https://ror.org/03e8ncw23 Gunma Prefectural Institute of Public Health and Environmental Sciences 群馬県衛生環境研究所'),
(2902, 'https://ror.org/03e8s1d88', 'en', 1, 'https://ror.org/03e8s1d88 Potsdam Institute for Climate Impact Research Potsdam-Institut für Klimafolgenforschung'),
(2903, 'https://ror.org/03eaw8c11', 'en', 1, 'https://ror.org/03eaw8c11 Bethesda North Hospital'),
(2904, 'https://ror.org/03ebg0v16', 'en', 1, 'https://ror.org/03ebg0v16 Boys Town'),
(2905, 'https://ror.org/03edafd86', 'en', 1, 'https://ror.org/03edafd86 Bogomolets National Medical University Narodowy Medyczny Uniwersytet im. O.Bohomolca Национальный медицинский университет имени А. А. Богомольца Національний медичний університет імені Олександра Богомольця'),
(2906, 'https://ror.org/03edth057', 'en', 1, 'https://ror.org/03edth057 Teikyo University Chiba Medical Center 帝京大学ちば総合医療センター'),
(2907, 'https://ror.org/03efxpx82', 'it', 1, 'https://ror.org/03efxpx82 A. O. Ordine Mauriziano di Torino'),
(2908, 'https://ror.org/03ej8bw49', 'en', 1, 'https://ror.org/03ej8bw49 Shanghai Changning Mental Health Center 长宁区精神卫生中心'),
(2909, 'https://ror.org/03ej9xm26', 'pt', 1, 'https://ror.org/03ej9xm26 Hospital de Clínicas Universidade Federal do Paraná'),
(2910, 'https://ror.org/03eksqx74', 'en', 1, 'https://ror.org/03eksqx74 Winthrop-University Hospital'),
(2911, 'https://ror.org/03ekzka28', 'en', 1, 'https://ror.org/03ekzka28 Antioch University'),
(2912, 'https://ror.org/03enmdz06', 'en', 1, 'https://ror.org/03enmdz06 California State University, Fresno Université d''État de Californie à Fresno'),
(2913, 'https://ror.org/03ephvw84', 'en', 1, 'https://ror.org/03ephvw84 Dronning Ingrids Hospital Queen Ingrid''s Hospital'),
(2914, 'https://ror.org/03er5cb38', 'en', 1, 'https://ror.org/03er5cb38 Moisio Hospital Moision Sairaala'),
(2915, 'https://ror.org/03et1qs84', 'en', 1, 'https://ror.org/03et1qs84 Centre médical universitaire de loma linda Loma Linda University Medical Center'),
(2916, 'https://ror.org/03ew6dd87', 'en', 1, 'https://ror.org/03ew6dd87 East Tennessee Children''s Hospital'),
(2917, 'https://ror.org/03exgrk66', 'en', 1, 'https://ror.org/03exgrk66 Ewha Womans University Medical Center 이화여자대학교 목동병원'),
(2918, 'https://ror.org/03exj3651', 'en', 1, 'https://ror.org/03exj3651 Littlemore Hospital'),
(2919, 'https://ror.org/03ezzqh77', 'en', 1, 'https://ror.org/03ezzqh77 Iwate Biotechnology Research Center 財団法人 岩手生物工学研究センター'),
(2920, 'https://ror.org/03f1ecr94', 'en', 1, 'https://ror.org/03f1ecr94 Saint Thomas Midtown Hospital'),
(2921, 'https://ror.org/03f27y887', 'es', 1, 'https://ror.org/03f27y887 National University of Asuncion Universidad Nacional de Asunción'),
(2922, 'https://ror.org/03f3jde70', 'en', 1, 'https://ror.org/03f3jde70 Jaamacada Ummada Soomaaliyeed Somali National University Università nazionale somala'),
(2923, 'https://ror.org/03f8drh85', 'no_lang_code', 1, 'https://ror.org/03f8drh85 Haibara General Hospital 榛原総合病院'),
(2924, 'https://ror.org/03f91xw18', 'en', 1, 'https://ror.org/03f91xw18 Museum of the Earth'),
(2925, 'https://ror.org/03f94es11', 'pt', 1, 'https://ror.org/03f94es11 Instituto Superior Dom Afonso III'),
(2926, 'https://ror.org/03fa2nf38', 'en', 1, 'https://ror.org/03fa2nf38 Methodist University'),
(2927, 'https://ror.org/03fakbf87', 'en', 1, 'https://ror.org/03fakbf87 Colorado Permanente Medical Group'),
(2928, 'https://ror.org/03fbkqs26', 'no_lang_code', 1, 'https://ror.org/03fbkqs26 Bombardier (Canada)'),
(2929, 'https://ror.org/03fcpsq87', 'en', 1, 'https://ror.org/03fcpsq87 Providence University 靜宜大學'),
(2930, 'https://ror.org/03feyt230', 'en', 1, 'https://ror.org/03feyt230 Tougaloo College'),
(2931, 'https://ror.org/03ff06b47', 'en', 1, 'https://ror.org/03ff06b47 Hardin–Simmons University'),
(2932, 'https://ror.org/03ffc6g28', 'en', 1, 'https://ror.org/03ffc6g28 Kagawa National Children''s Hospital 国立病院機構香川小児病院'),
(2933, 'https://ror.org/03fgkzb55', 'en', 1, 'https://ror.org/03fgkzb55 Novant Health Presbyterian Medical Center'),
(2934, 'https://ror.org/03fh7t044', 'en', 1, 'https://ror.org/03fh7t044 University of Benghazi جامعة بنغازي'),
(2935, 'https://ror.org/03fhjvs31', 'en', 1, 'https://ror.org/03fhjvs31 Center for Molecular Medicine and Immunology'),
(2936, 'https://ror.org/03fkc8c64', 'en', 1, 'https://ror.org/03fkc8c64 University of the West Indies'),
(2937, 'https://ror.org/03fng6237', 'en', 1, 'https://ror.org/03fng6237 Black Hills State University'),
(2938, 'https://ror.org/03fpqn433', 'es', 1, 'https://ror.org/03fpqn433 Hospital Juan Ramón Jiménez'),
(2939, 'https://ror.org/03fr85h91', 'en', 1, 'https://ror.org/03fr85h91 University of Uyo Teaching Hospital'),
(2940, 'https://ror.org/03fs4aq04', 'en', 1, 'https://ror.org/03fs4aq04 Institute of Fundamental Technological Research Instytut Podstawowych Problemów Techniki'),
(2941, 'https://ror.org/03ftky336', 'en', 1, 'https://ror.org/03ftky336 Saitama International Medical Center 埼玉医科大学国際医療センター'),
(2942, 'https://ror.org/03fvp2v86', 'en', 1, 'https://ror.org/03fvp2v86 Lokmanya Tilak Municipal General Hospital and Lokmanya Tilak Municipal Medical College'),
(2943, 'https://ror.org/03fvyqb23', 'en', 1, 'https://ror.org/03fvyqb23 Baptist Health Louisville'),
(2944, 'https://ror.org/03fwxcd28', 'en', 1, 'https://ror.org/03fwxcd28 Sentara Norfolk General Hospital'),
(2945, 'https://ror.org/03fz4ce66', 'en', 1, 'https://ror.org/03fz4ce66 Shanghai Institute of Hematology 上海血液学研究所'),
(2946, 'https://ror.org/03fz57f90', 'hu', 1, 'https://ror.org/03fz57f90 Markusovszky Egyetemi Oktatókórház'),
(2947, 'https://ror.org/03fzyry86', 'es', 1, 'https://ror.org/03fzyry86 Hospital Universitari Sagrat Cor'),
(2948, 'https://ror.org/03g1nep17', 'no_lang_code', 1, 'https://ror.org/03g1nep17 3M (Canada)'),
(2949, 'https://ror.org/03g35dg18', 'en', 1, 'https://ror.org/03g35dg18 Delaware State University'),
(2950, 'https://ror.org/03g4hym73', 'en', 1, 'https://ror.org/03g4hym73 University of Birjand دانشگاه بیرجند'),
(2951, 'https://ror.org/03g8yqb46', 'fi', 1, 'https://ror.org/03g8yqb46 Keski-Pohjanmaan keskussairaala'),
(2952, 'https://ror.org/03gb7n667', 'en', 1, 'https://ror.org/03gb7n667 University General Hospital Attikon ΠΑΝΕΠΙΣΤΗΜΙΑΚΟ ΓΕΝΙΚΟ ΝΟΣΟΚΟΜΕΙΟ "ΑΤΤΙΚΟΝ"'),
(2953, 'https://ror.org/03gbbyk68', 'en', 1, 'https://ror.org/03gbbyk68 Holmes Regional Medical Center'),
(2954, 'https://ror.org/03gd1jf50', 'en', 1, 'https://ror.org/03gd1jf50 Shaikh Khalifa Medical City مدينة الشيخ خليفة الطبية'),
(2955, 'https://ror.org/03gd3wz76', 'en', 1, 'https://ror.org/03gd3wz76 Sher-i-Kashmir Institute of Medical Sciences شیرِ کشمیر انسٹیچیوٹ آف میڈیکل سائنسز'),
(2956, 'https://ror.org/03gd6ja31', 'en', 1, 'https://ror.org/03gd6ja31 Al-Ameen Medical College'),
(2957, 'https://ror.org/03gfmry48', 'en', 1, 'https://ror.org/03gfmry48 Sheppard and Enoch Pratt Hospital'),
(2958, 'https://ror.org/03gfs5c49', 'en', 1, 'https://ror.org/03gfs5c49 Nordic School of Public Health'),
(2959, 'https://ror.org/03gjyng84', 'no_lang_code', 1, 'https://ror.org/03gjyng84 Sierra Wireless (Canada)'),
(2960, 'https://ror.org/03gk81f96', 'en', 1, 'https://ror.org/03gk81f96 Kaohsiung Medical University'),
(2961, 'https://ror.org/03gke3141', 'en', 1, 'https://ror.org/03gke3141 World Technology Evaluation Center'),
(2962, 'https://ror.org/03gpsj088', 'en', 1, 'https://ror.org/03gpsj088 Jacobs Institute of Women''s Health'),
(2963, 'https://ror.org/03grgv984', 'en', 1, 'https://ror.org/03grgv984 University Centre of Legal Medicine'),
(2964, 'https://ror.org/03grprm46', 'en', 1, 'https://ror.org/03grprm46 Clinical Emergency Hospital Bucharest Spitalul Clinic de Urgenta Bucuresti'),
(2965, 'https://ror.org/03gtdcg60', 'en', 1, 'https://ror.org/03gtdcg60 Diego Portales University Universidad Diego Portales'),
(2966, 'https://ror.org/03gvpk069', 'no_lang_code', 1, 'https://ror.org/03gvpk069 Edendale Hospital'),
(2967, 'https://ror.org/03gzyz068', 'it', 1, 'https://ror.org/03gzyz068 Ospedale Annunziata di Cosenza'),
(2968, 'https://ror.org/03h1jr755', 'en', 1, 'https://ror.org/03h1jr755 Argerich Hospital'),
(2969, 'https://ror.org/03h2ajh11', 'en', 1, 'https://ror.org/03h2ajh11 Saint Francis Hospital & Medical Center'),
(2970, 'https://ror.org/03h2bh287', 'en', 1, 'https://ror.org/03h2bh287 Oxford University Hospitals NHS Trust');
INSERT INTO `rors` VALUES
(2971, 'https://ror.org/03h2c3g63', 'no_lang_code', 1, 'https://ror.org/03h2c3g63 Matériaux Blanchet'),
(2972, 'https://ror.org/03h3yrx93', 'es', 1, 'https://ror.org/03h3yrx93 Hospital Pediátrico Moctezuma'),
(2973, 'https://ror.org/03h4fx826', 'en', 1, 'https://ror.org/03h4fx826 Lehigh Valley Hospital'),
(2974, 'https://ror.org/03h5v7z82', 'en', 1, 'https://ror.org/03h5v7z82 Connolly Hospital Blanchardstown Ospidéal Uí Chonghaile, Baile Bhlainséir'),
(2975, 'https://ror.org/03hamhx47', 'en', 1, 'https://ror.org/03hamhx47 Universidad de Massachusetts Lowell University of Massachusetts Lowell'),
(2976, 'https://ror.org/03haqmz43', 'fr', 1, 'https://ror.org/03haqmz43 Université Félix Houphouët-Boigny'),
(2977, 'https://ror.org/03hbd7c15', 'no_lang_code', 1, 'https://ror.org/03hbd7c15 Therapeutics Systems Research Laboratories (United States)'),
(2978, 'https://ror.org/03hj7dq77', 'it', 1, 'https://ror.org/03hj7dq77 Ospedale Sandro Pertini'),
(2979, 'https://ror.org/03hkffh19', 'en', 1, 'https://ror.org/03hkffh19 Legacy Emanuel Medical Center'),
(2980, 'https://ror.org/03hqrv489', 'no_lang_code', 1, 'https://ror.org/03hqrv489 Advanced Liquid Logic'),
(2981, 'https://ror.org/03hrxmf69', 'en', 1, 'https://ror.org/03hrxmf69 Newton Wellesley Hospital'),
(2982, 'https://ror.org/03hvxkc45', 'en', 1, 'https://ror.org/03hvxkc45 Bibra International'),
(2983, 'https://ror.org/03hwe2705', 'en', 1, 'https://ror.org/03hwe2705 UCSF Benioff Children''s Hospital'),
(2984, 'https://ror.org/03hwmxn85', 'en', 1, 'https://ror.org/03hwmxn85 Harvard Vanguard Medical Associates'),
(2985, 'https://ror.org/03j05zz84', 'en', 1, 'https://ror.org/03j05zz84 Philadelphia VA Medical Center'),
(2986, 'https://ror.org/03j2sb517', 'en', 1, 'https://ror.org/03j2sb517 Slade Hospital'),
(2987, 'https://ror.org/03j2vsq41', 'en', 1, 'https://ror.org/03j2vsq41 Beijing Great Wall Hospital 北京市长城医院'),
(2988, 'https://ror.org/03j3q5a83', 'en', 1, 'https://ror.org/03j3q5a83 Magellan Health'),
(2989, 'https://ror.org/03j42gp22', 'en', 1, 'https://ror.org/03j42gp22 University HealthSystem Consortium'),
(2990, 'https://ror.org/03j4rdg62', 'en', 1, 'https://ror.org/03j4rdg62 Mater Mothers'' Hospital'),
(2991, 'https://ror.org/03j53f755', 'en', 1, 'https://ror.org/03j53f755 ''''Καραμανδάνειο'''' Γενικό Νοσοκομείο Παίδων Πατρών General Hospital Pediatric Karamandanio'),
(2992, 'https://ror.org/03j554d90', 'en', 1, 'https://ror.org/03j554d90 M.S. Ramaiah Medical College'),
(2993, 'https://ror.org/03j6rvb05', 'fr', 1, 'https://ror.org/03j6rvb05 Hôpital Ambroise-Paré'),
(2994, 'https://ror.org/03j78my65', 'en', 1, 'https://ror.org/03j78my65 Kaiser Foundation Hospital'),
(2995, 'https://ror.org/03j7khn53', 'en', 1, 'https://ror.org/03j7khn53 Shizuoka Red Cross Hospital 静岡赤十字病院'),
(2996, 'https://ror.org/03j808814', 'no_lang_code', 1, 'https://ror.org/03j808814 Hokkaido Central Hospital 北海道中央病院'),
(2997, 'https://ror.org/03j9npf54', 'en', 1, 'https://ror.org/03j9npf54 Geisinger Medical Center'),
(2998, 'https://ror.org/03ja1ak26', 'en', 1, 'https://ror.org/03ja1ak26 MedStar Georgetown University Hospital'),
(2999, 'https://ror.org/03ja8fa88', 'en', 1, 'https://ror.org/03ja8fa88 Doctors Hospital'),
(3000, 'https://ror.org/03jachw67', 'en', 1, 'https://ror.org/03jachw67 Elliot Hospital'),
(3001, 'https://ror.org/03jayhg97', 'no_lang_code', 1, 'https://ror.org/03jayhg97 Milad Hospital بیمارستان میلاد'),
(3002, 'https://ror.org/03jb9b006', 'en', 1, 'https://ror.org/03jb9b006 Dwight D. Eisenhower VA Medical Center'),
(3003, 'https://ror.org/03jckbw05', 'en', 1, 'https://ror.org/03jckbw05 First Affiliated Hospital of Chengdu Medical College 成都医学院第一附属医院'),
(3004, 'https://ror.org/03jcxa214', 'en', 1, 'https://ror.org/03jcxa214 National Maternity Hospital'),
(3005, 'https://ror.org/03jd3cd78', 'en', 1, 'https://ror.org/03jd3cd78 Kobe Children''s Hospital 兵庫県立こども病院'),
(3006, 'https://ror.org/03jd4q354', 'it', 1, 'https://ror.org/03jd4q354 Ospedale G.B. Morgagni - L.Pierantoni'),
(3007, 'https://ror.org/03je4r797', 'en', 1, 'https://ror.org/03je4r797 Luodong Poh-Ai Hospital 羅東博愛醫院'),
(3008, 'https://ror.org/03jeg4p28', 'en', 1, 'https://ror.org/03jeg4p28 Cone Health'),
(3009, 'https://ror.org/03jfzsd28', 'en', 1, 'https://ror.org/03jfzsd28 Shigei Medical Research Institute 重井医学研究所'),
(3010, 'https://ror.org/03jg32m15', 'en', 1, 'https://ror.org/03jg32m15 Dorothea Dix Hospital'),
(3011, 'https://ror.org/03jgh1p68', 'en', 1, 'https://ror.org/03jgh1p68 Abington Memorial Hospital'),
(3012, 'https://ror.org/03jh5a977', 'en', 1, 'https://ror.org/03jh5a977 Center for Information Technology'),
(3013, 'https://ror.org/03jhnpw59', 'en', 1, 'https://ror.org/03jhnpw59 Museum Of Northern Arizona'),
(3014, 'https://ror.org/03jmdp146', 'en', 1, 'https://ror.org/03jmdp146 Motilal Nehru Medical College'),
(3015, 'https://ror.org/03jmfdf59', 'en', 1, 'https://ror.org/03jmfdf59 Agency for Healthcare Research and Quality'),
(3016, 'https://ror.org/03jpekd50', 'en', 1, 'https://ror.org/03jpekd50 Guangdong General Hospital 广东省老年医学研究所'),
(3017, 'https://ror.org/03jpj9789', 'en', 1, 'https://ror.org/03jpj9789 Glan Clwyd Hospital Ysbyty Glan Clwyd'),
(3018, 'https://ror.org/03jpkw355', 'pt', 1, 'https://ror.org/03jpkw355 Instituto de Soldadura e Qualidade'),
(3019, 'https://ror.org/03jpm9j23', 'pt', 1, 'https://ror.org/03jpm9j23 Hospital da Luz'),
(3020, 'https://ror.org/03jrn4k58', 'no_lang_code', 1, 'https://ror.org/03jrn4k58 GlaxoSmithKline (China)'),
(3021, 'https://ror.org/03js6zg56', 'en', 1, 'https://ror.org/03js6zg56 University of Agricultural Sciences, Bangalore'),
(3022, 'https://ror.org/03jss6s30', 'pt', 1, 'https://ror.org/03jss6s30 Dr. Euryclides Hospital de Jesus Zerbini'),
(3023, 'https://ror.org/03jt4wj37', 'de', 1, 'https://ror.org/03jt4wj37 Universitätskliniken Salzburg'),
(3024, 'https://ror.org/03jv28t80', 'no_lang_code', 1, 'https://ror.org/03jv28t80 Lynntech (United States)'),
(3025, 'https://ror.org/03jv45898', 'no_lang_code', 1, 'https://ror.org/03jv45898 Aphios Corporation'),
(3026, 'https://ror.org/03jyr9x65', 'en', 1, 'https://ror.org/03jyr9x65 The Open University of Japan 放送大学'),
(3027, 'https://ror.org/03k1gyh28', 'no_lang_code', 1, 'https://ror.org/03k1gyh28 SNC-Lavalin (Canada)'),
(3028, 'https://ror.org/03k25vb36', 'en', 1, 'https://ror.org/03k25vb36 Indiana State Department of Education'),
(3029, 'https://ror.org/03k3bq214', 'en', 1, 'https://ror.org/03k3bq214 National Center of Biomedical Analysis 国家生物医学分析中心'),
(3030, 'https://ror.org/03k6ngg59', 'en', 1, 'https://ror.org/03k6ngg59 Friarage Hospital'),
(3031, 'https://ror.org/03k793y62', 'en', 1, 'https://ror.org/03k793y62 Agricultural University of Tirana Universiteti Bujqësor i Tiranës Γεωπονικό πανεπιστήμιο Τιράνων'),
(3032, 'https://ror.org/03k8anr87', 'en', 1, 'https://ror.org/03k8anr87 Health South Rehabilitation Hospital'),
(3033, 'https://ror.org/03ka27b61', 'en', 1, 'https://ror.org/03ka27b61 West Bengal University of Animal and Fishery Sciences पश्चिम बंगाल मत्स्य एवं पशुपालन विज्ञान विश्वविद्यालय পশ্চিমবঙ্গ প্রাণী ও মৎস্যবিজ্ঞান বিশ্ববিদ্যালয়'),
(3034, 'https://ror.org/03kcsjh25', 'en', 1, 'https://ror.org/03kcsjh25 National Institute of Statistical Sciences'),
(3035, 'https://ror.org/03kcxpp45', 'en', 1, 'https://ror.org/03kcxpp45 Iwakuni Medical Center 岩国医療センター'),
(3036, 'https://ror.org/03ke6tv85', 'en', 1, 'https://ror.org/03ke6tv85 University of Southern Maine'),
(3037, 'https://ror.org/03ke9vf24', 'en', 1, 'https://ror.org/03ke9vf24 Al-Arab Medical University جامعة العرب الطبية'),
(3038, 'https://ror.org/03khjyh83', 'en', 1, 'https://ror.org/03khjyh83 Genome Research Foundation'),
(3039, 'https://ror.org/03kkr2s40', 'en', 1, 'https://ror.org/03kkr2s40 Pondicherry Institute of Medical Sciences'),
(3040, 'https://ror.org/03kmrjq19', 'en', 1, 'https://ror.org/03kmrjq19 Departamento de Salud y Servicios para las Personas Mayores del Estado de Nueva Jersey New Jersey Department of Health'),
(3041, 'https://ror.org/03kpa7r53', 'en', 1, 'https://ror.org/03kpa7r53 Herttoniemi Hospital'),
(3042, 'https://ror.org/03kpvby98', 'en', 1, 'https://ror.org/03kpvby98 MRC Unit for Lifelong Health and Ageing'),
(3043, 'https://ror.org/03ks67450', 'en', 1, 'https://ror.org/03ks67450 Inova Alexandria Hospital'),
(3044, 'https://ror.org/03kv7mk61', 'no_lang_code', 1, 'https://ror.org/03kv7mk61 MPC Computers (United States)'),
(3045, 'https://ror.org/03kw9gc02', 'en', 1, 'https://ror.org/03kw9gc02 Aligarh Muslim University Université musulmane d''aligarh جامعہ علی گڑھ अलीगढ़ मुस्लिम विश्वविद्यालय আলিগড় মুসলিম বিশ্ববিদ্যালয় ਅਲੀਗੜ ਮੁਸਲਿਮ ਯੂਨੀਵਰਸਿਟੀ அலிகார் முஸ்லிம் பல்கலைக்கழகம் అలీఘర్ ముస్లిం విశ్వవిద్యాలయం ಅಲಿಘರ್ ಮುಸ್ಲಿಮ್ ವಿಶ್ವವಿದ್ಯಾಲಯ അലിഗഢ് മുസ്ലിം സർവകലാശാല'),
(3046, 'https://ror.org/03kzpyr73', 'en', 1, 'https://ror.org/03kzpyr73 MedStar Good Samaritan Hospital'),
(3047, 'https://ror.org/03m04df46', 'en', 1, 'https://ror.org/03m04df46 University Hospital Magdeburg Universitätsklinikum Magdeburg'),
(3048, 'https://ror.org/03m2nqg26', 'fr', 1, 'https://ror.org/03m2nqg26 Centre Hospitalier Universitaire Hassan II'),
(3049, 'https://ror.org/03m5bv793', 'en', 1, 'https://ror.org/03m5bv793 Marianjoy Rehabilitation Hospital'),
(3050, 'https://ror.org/03m6tev69', 'en', 1, 'https://ror.org/03m6tev69 Morristown Medical Center'),
(3051, 'https://ror.org/03m7azy07', 'en', 1, 'https://ror.org/03m7azy07 Nebraska Department of Health and Human Services'),
(3052, 'https://ror.org/03m908832', 'en', 1, 'https://ror.org/03m908832 Lehman College'),
(3053, 'https://ror.org/03m964n84', 'en', 1, 'https://ror.org/03m964n84 Aichi University of Education 愛知教育大学'),
(3054, 'https://ror.org/03max4q92', 'tr', 1, 'https://ror.org/03max4q92 Izmir Atatürk Eğitim ve Araştırma Hastanesi'),
(3055, 'https://ror.org/03mbq3y29', 'en', 1, 'https://ror.org/03mbq3y29 Lahey Hospital and Medical Center'),
(3056, 'https://ror.org/03mccxv57', 'en', 1, 'https://ror.org/03mccxv57 Derbyshire Children''s Hospital'),
(3057, 'https://ror.org/03mdzf107', 'en', 1, 'https://ror.org/03mdzf107 Amala Institute of Medical Sciences അമല ഇൻസ്റ്റിട്ട്യൂട്ട് ഓഫ് മെഡിക്കൽ സയൻസസ്'),
(3058, 'https://ror.org/03mehsr39', 'en', 1, 'https://ror.org/03mehsr39 Hokushin General Hospital 北信総合病院'),
(3059, 'https://ror.org/03mfyz684', 'en', 1, 'https://ror.org/03mfyz684 King County Medical Examiner''s Office'),
(3060, 'https://ror.org/03mh75s52', 'en', 1, 'https://ror.org/03mh75s52 Hangzhou Red Cross Hospital 杭州市红十字会医院'),
(3061, 'https://ror.org/03mjtdk61', 'en', 1, 'https://ror.org/03mjtdk61 Mater Health Services'),
(3062, 'https://ror.org/03mmk1j33', 'no_lang_code', 1, 'https://ror.org/03mmk1j33 Blackberry (Canada)'),
(3063, 'https://ror.org/03mnm0t94', 'en', 1, 'https://ror.org/03mnm0t94 University of Wisconsin–Eau Claire Université du Wisconsin à Eau Claire'),
(3064, 'https://ror.org/03mnxwj46', 'en', 1, 'https://ror.org/03mnxwj46 Metropolitan State University of Denver'),
(3065, 'https://ror.org/03mpekj96', 'en', 1, 'https://ror.org/03mpekj96 MSPCA-Angell'),
(3066, 'https://ror.org/03msdae35', 'en', 1, 'https://ror.org/03msdae35 Minnesota State University Moorhead Université d''État du minnesota'),
(3067, 'https://ror.org/03mstc592', 'en', 1, 'https://ror.org/03mstc592 European Molecular Biology Laboratory Europäisches Laboratorium für Molekularbiologie'),
(3068, 'https://ror.org/03mt09h51', 'en', 1, 'https://ror.org/03mt09h51 Lyndon Baines Johnson Hospital'),
(3069, 'https://ror.org/03mt12903', 'es', 1, 'https://ror.org/03mt12903 Hospital San Juan de Dios'),
(3070, 'https://ror.org/03mtnpp42', 'it', 1, 'https://ror.org/03mtnpp42 Ospedale Cannizzaro'),
(3071, 'https://ror.org/03mv07c21', 'no_lang_code', 1, 'https://ror.org/03mv07c21 Arthur D. Little (Czechia)'),
(3072, 'https://ror.org/03mv9x076', 'en', 1, 'https://ror.org/03mv9x076 HCI International Medical Centre'),
(3073, 'https://ror.org/03mwa7s65', 'en', 1, 'https://ror.org/03mwa7s65 Ministry of Health Labour and Welfare 厚生労働省'),
(3074, 'https://ror.org/03mwnnn55', 'en', 1, 'https://ror.org/03mwnnn55 Charleston Southern University'),
(3075, 'https://ror.org/03mx23f83', 'es', 1, 'https://ror.org/03mx23f83 Hospital Montecelo'),
(3076, 'https://ror.org/03n0fp725', 'en', 1, 'https://ror.org/03n0fp725 Children''s Hospital at Montefiore'),
(3077, 'https://ror.org/03n0nnh89', 'ms', 1, 'https://ror.org/03n0nnh89 Hospital Kuala Lumpur'),
(3078, 'https://ror.org/03n20pp93', 'en', 1, 'https://ror.org/03n20pp93 Awadhesh Pratap Singh University अवधेश प्रताप सिंह विश्वविद्यालय'),
(3079, 'https://ror.org/03n2ay196', 'en', 1, 'https://ror.org/03n2ay196 South Texas Veterans Health Care System'),
(3080, 'https://ror.org/03n34rg04', 'en', 1, 'https://ror.org/03n34rg04 Elmhurst Hospital Center'),
(3081, 'https://ror.org/03n35e656', 'no_lang_code', 1, 'https://ror.org/03n35e656 Shuguang Hospital'),
(3082, 'https://ror.org/03n3pz732', 'en', 1, 'https://ror.org/03n3pz732 Medwin Hospital'),
(3083, 'https://ror.org/03n5gdd09', 'en', 1, 'https://ror.org/03n5gdd09 Anhui Provincial Hospital'),
(3084, 'https://ror.org/03n60ms07', 'it', 1, 'https://ror.org/03n60ms07 Ospedale G.F. Ingrassia'),
(3085, 'https://ror.org/03n6cf849', 'no_lang_code', 1, 'https://ror.org/03n6cf849 Ricerca sul Sistema Energetico (Italy)'),
(3086, 'https://ror.org/03n6vs369', 'fr', 1, 'https://ror.org/03n6vs369 Hôpital Avicenne'),
(3087, 'https://ror.org/03n85hy63', 'es', 1, 'https://ror.org/03n85hy63 Hospital Militar Dr. Carlos Arvelo'),
(3088, 'https://ror.org/03na8p459', 'no_lang_code', 1, 'https://ror.org/03na8p459 Yokohama Rosai Hospital 横浜労災病院'),
(3089, 'https://ror.org/03navsr28', 'fr', 1, 'https://ror.org/03navsr28 Hôpital Mère-Enfant'),
(3090, 'https://ror.org/03nc3zw41', 'en', 1, 'https://ror.org/03nc3zw41 Matsue Red Cross Hospital 松江赤十字病院'),
(3091, 'https://ror.org/03ncj7n33', 'no_lang_code', 1, 'https://ror.org/03ncj7n33 Jordanian Universities Network (Jordan)'),
(3092, 'https://ror.org/03ndmsg87', 'no_lang_code', 1, 'https://ror.org/03ndmsg87 Charles River Laboratories (United States)'),
(3093, 'https://ror.org/03ne66j56', 'en', 1, 'https://ror.org/03ne66j56 Flushing Hospital Medical Center'),
(3094, 'https://ror.org/03nj2kd75', 'en', 1, 'https://ror.org/03nj2kd75 Houston Health and Human Services Department'),
(3095, 'https://ror.org/03np13864', 'en', 1, 'https://ror.org/03np13864 Universidad de Trinidad y Tobago University of Trinidad and Tobago'),
(3096, 'https://ror.org/03npxtg86', 'en', 1, 'https://ror.org/03npxtg86 Queen Elizabeth Hospital'),
(3097, 'https://ror.org/03nr55d93', 'en', 1, 'https://ror.org/03nr55d93 North West Armed Forces Hospital مستشفى القوات المسلحة بالشمالية'),
(3098, 'https://ror.org/03nrgvp52', 'en', 1, 'https://ror.org/03nrgvp52 Centinela Hospital Medical Center'),
(3099, 'https://ror.org/03nscjy42', 'no_lang_code', 1, 'https://ror.org/03nscjy42 General Electric (Denmark)'),
(3100, 'https://ror.org/03nteze27', 'en', 1, 'https://ror.org/03nteze27 National Taiwan University Hospital'),
(3101, 'https://ror.org/03nvpm562', 'en', 1, 'https://ror.org/03nvpm562 Shimane University Hospital 島根大学病院'),
(3102, 'https://ror.org/03nw9hs25', 'en', 1, 'https://ror.org/03nw9hs25 Alberta Hospital Edmonton'),
(3103, 'https://ror.org/03nysxh02', 'no_lang_code', 1, 'https://ror.org/03nysxh02 NovoMedix (United States)'),
(3104, 'https://ror.org/03nzegx43', 'es', 1, 'https://ror.org/03nzegx43 Cruces University Hospital Hospital de Cruces'),
(3105, 'https://ror.org/03nzj6y61', 'en', 1, 'https://ror.org/03nzj6y61 Health Net'),
(3106, 'https://ror.org/03p09n514', 'no_lang_code', 1, 'https://ror.org/03p09n514 Danya International, Inc.'),
(3107, 'https://ror.org/03p30f964', 'en', 1, 'https://ror.org/03p30f964 Lincoln County Hospital'),
(3108, 'https://ror.org/03p43tq86', 'ms', 1, 'https://ror.org/03p43tq86 Hospital Selayang'),
(3109, 'https://ror.org/03panb555', 'en', 1, 'https://ror.org/03panb555 Lanzhou University of Technology 兰州理工大学'),
(3110, 'https://ror.org/03pdc2j75', 'tr', 1, 'https://ror.org/03pdc2j75 Haydarpaşa Numune Eğitim ve Araştırma Hastanesi'),
(3111, 'https://ror.org/03pfmgq50', 'en', 1, 'https://ror.org/03pfmgq50 Fooyin University'),
(3112, 'https://ror.org/03pjj1n42', 'en', 1, 'https://ror.org/03pjj1n42 Dhahran Health Center'),
(3113, 'https://ror.org/03pm2yz25', 'en', 1, 'https://ror.org/03pm2yz25 Kumamoto Health Science University 熊本保健科学大学'),
(3114, 'https://ror.org/03pmd4250', 'no_lang_code', 1, 'https://ror.org/03pmd4250 Shinko Hospital 神鋼記念病院'),
(3115, 'https://ror.org/03pq6f684', 'en', 1, 'https://ror.org/03pq6f684 Asian Institute of Gastroenterology'),
(3116, 'https://ror.org/03pshcc38', 'en', 1, 'https://ror.org/03pshcc38 Halton General Hospital'),
(3117, 'https://ror.org/03psk2k71', 'sl', 1, 'https://ror.org/03psk2k71 Splošna Bolnišnica Celje'),
(3118, 'https://ror.org/03pskkc12', 'en', 1, 'https://ror.org/03pskkc12 National Academy of Medical Sciences'),
(3119, 'https://ror.org/03pw3x387', 'no_lang_code', 1, 'https://ror.org/03pw3x387 Gangneung Asan Hospital'),
(3120, 'https://ror.org/03pwcc270', 'en', 1, 'https://ror.org/03pwcc270 Auburn University System'),
(3121, 'https://ror.org/03px4ez74', 'en', 1, 'https://ror.org/03px4ez74 Zoological Society of London'),
(3122, 'https://ror.org/03pz1p187', 'en', 1, 'https://ror.org/03pz1p187 Alberta Health'),
(3123, 'https://ror.org/03pz7fw94', 'it', 1, 'https://ror.org/03pz7fw94 Azienda Sanitaria Ospedaliera S.Croce e Carle Cuneo'),
(3124, 'https://ror.org/03pzgk858', 'en', 1, 'https://ror.org/03pzgk858 Hospital South West Jutland Sydvestjysk Sygehus'),
(3125, 'https://ror.org/03q01be91', 'en', 1, 'https://ror.org/03q01be91 Fujieda Municipal General Hospital 藤枝市立総合病院'),
(3126, 'https://ror.org/03q0mrg27', 'es', 1, 'https://ror.org/03q0mrg27 Hospital Can Misses'),
(3127, 'https://ror.org/03q1gvb68', 'no_lang_code', 1, 'https://ror.org/03q1gvb68 Neoleukin Therapeutics (Canada)'),
(3128, 'https://ror.org/03q21mh05', 'en', 1, 'https://ror.org/03q21mh05 Cairo University Université du Caire جامعة القاهرة'),
(3129, 'https://ror.org/03q3gmk48', 'en', 1, 'https://ror.org/03q3gmk48 MedStar National Rehabilitation Hospital'),
(3130, 'https://ror.org/03q3s7962', 'en', 1, 'https://ror.org/03q3s7962 Huizhou University 惠州学院'),
(3131, 'https://ror.org/03q45zd70', 'en', 1, 'https://ror.org/03q45zd70 South Dakota Foundation for Medical Care'),
(3132, 'https://ror.org/03q4p1y48', 'en', 1, 'https://ror.org/03q4p1y48 Haga Hospital HagaZiekenhuis'),
(3133, 'https://ror.org/03q7y2p06', 'en', 1, 'https://ror.org/03q7y2p06 Ibaraki Prefectural Central Hospital 茨城県立中央病院'),
(3134, 'https://ror.org/03qaqdm58', 'sv', 1, 'https://ror.org/03qaqdm58 Capio Lundby Sjukhus'),
(3135, 'https://ror.org/03qg42k57', 'no_lang_code', 1, 'https://ror.org/03qg42k57 Ishinomaki Senshu University 石巻専修大学'),
(3136, 'https://ror.org/03qgg3111', 'es', 1, 'https://ror.org/03qgg3111 Universidad Centroccidental Lisandro Alvarado'),
(3137, 'https://ror.org/03qjk6p58', 'en', 1, 'https://ror.org/03qjk6p58 Dayton VA Medical Center'),
(3138, 'https://ror.org/03qqbe534', 'en', 1, 'https://ror.org/03qqbe534 Korea National University of Transportation 한국교통대학교'),
(3139, 'https://ror.org/03qrkhd32', 'en', 1, 'https://ror.org/03qrkhd32 Heilongjiang Provincial Hospital 黑龙江省医院'),
(3140, 'https://ror.org/03qrrp624', 'en', 1, 'https://ror.org/03qrrp624 Hirosaki National Hospital 国立病院機構弘前病院'),
(3141, 'https://ror.org/03qv5tx95', 'no_lang_code', 1, 'https://ror.org/03qv5tx95 Hygeia Hospital Υγεία'),
(3142, 'https://ror.org/03qvtpc38', 'en', 1, 'https://ror.org/03qvtpc38 Dong-A University 동아대학교'),
(3143, 'https://ror.org/03qwghy04', 'en', 1, 'https://ror.org/03qwghy04 Duran i Reynals Hospital'),
(3144, 'https://ror.org/03qxkp346', 'pt', 1, 'https://ror.org/03qxkp346 Hospital of St. Francis Xavier'),
(3145, 'https://ror.org/03qyxqf94', 'en', 1, 'https://ror.org/03qyxqf94 Little Company of Mary Hospital'),
(3146, 'https://ror.org/03qz9vy49', 'no_lang_code', 1, 'https://ror.org/03qz9vy49 Photon Imaging (United States)'),
(3147, 'https://ror.org/03r1zz567', 'en', 1, 'https://ror.org/03r1zz567 Idaho Department of Health and Welfare'),
(3148, 'https://ror.org/03r24vd05', 'en', 1, 'https://ror.org/03r24vd05 Robert Morris University Universidad Robert Morris'),
(3149, 'https://ror.org/03r30hs79', 'de', 1, 'https://ror.org/03r30hs79 Israelitisches Krankenhaus'),
(3150, 'https://ror.org/03r419717', 'en', 1, 'https://ror.org/03r419717 Kementerian Kesehatan Ministry of Health'),
(3151, 'https://ror.org/03r56rv89', 'en', 1, 'https://ror.org/03r56rv89 King Edward VIII Hospital'),
(3152, 'https://ror.org/03r5mk904', 'pt', 1, 'https://ror.org/03r5mk904 Hospital Sírio-Libanês Syrian-Lebanese Hospital'),
(3153, 'https://ror.org/03r6k1a05', 'en', 1, 'https://ror.org/03r6k1a05 Institute of Occupational Medicine'),
(3154, 'https://ror.org/03r6qg857', 'en', 1, 'https://ror.org/03r6qg857 Cambridge Hospital'),
(3155, 'https://ror.org/03r776098', 'en', 1, 'https://ror.org/03r776098 Saint Alphonsus Regional Medical Center'),
(3156, 'https://ror.org/03r781319', 'en', 1, 'https://ror.org/03r781319 Bronovo Hospital Bronovo Ziekenhuis'),
(3157, 'https://ror.org/03r7eh333', 'en', 1, 'https://ror.org/03r7eh333 Tulane Lakeside Hospital'),
(3158, 'https://ror.org/03rbn9086', 'en', 1, 'https://ror.org/03rbn9086 Monmouth College'),
(3159, 'https://ror.org/03rfbyn37', 'en', 1, 'https://ror.org/03rfbyn37 Northampton General Hospital'),
(3160, 'https://ror.org/03rhyss57', 'en', 1, 'https://ror.org/03rhyss57 Day General Hospital بیمارستان دی'),
(3161, 'https://ror.org/03rj2a342', 'en', 1, 'https://ror.org/03rj2a342 Good Samaritan Hospital'),
(3162, 'https://ror.org/03rjt0z37', 'en', 1, 'https://ror.org/03rjt0z37 German University in Cairo الجامعة الألمانية بالقاهرة'),
(3163, 'https://ror.org/03rmwy138', 'en', 1, 'https://ror.org/03rmwy138 Children''s Hospital Zagreb Klinika za Djecje bolesti Zagreb'),
(3164, 'https://ror.org/03rppv730', 'en', 1, 'https://ror.org/03rppv730 Aga Khan University Hospital Nairobi'),
(3165, 'https://ror.org/03rq2h425', 'no_lang_code', 1, 'https://ror.org/03rq2h425 Shimane Prefectural Central Hospital 島根県立中央病院'),
(3166, 'https://ror.org/03rq50d77', 'en', 1, 'https://ror.org/03rq50d77 Royal Victoria Hospital'),
(3167, 'https://ror.org/03rqm8n56', 'en', 1, 'https://ror.org/03rqm8n56 Ivanovo State University Ивановский государственный университет'),
(3168, 'https://ror.org/03rr7q548', 'en', 1, 'https://ror.org/03rr7q548 Armstrong Atlantic State University'),
(3169, 'https://ror.org/03rtgjq94', 'en', 1, 'https://ror.org/03rtgjq94 University of South Carolina System'),
(3170, 'https://ror.org/03rx7qt61', 'en', 1, 'https://ror.org/03rx7qt61 Maryland State Medical Society'),
(3171, 'https://ror.org/03rx9r010', 'en', 1, 'https://ror.org/03rx9r010 Carraway Methodist Medical Center'),
(3172, 'https://ror.org/03s18mw09', 'it', 1, 'https://ror.org/03s18mw09 Ospedale L. Bonomo'),
(3173, 'https://ror.org/03s2fmv96', 'en', 1, 'https://ror.org/03s2fmv96 Lancaster General Hospital'),
(3174, 'https://ror.org/03s2gs602', 'en', 1, 'https://ror.org/03s2gs602 Kawasaki University of Medical Welfare 川崎医療福祉大学'),
(3175, 'https://ror.org/03s32c292', 'en', 1, 'https://ror.org/03s32c292 Queen Elizabeth II Hospital'),
(3176, 'https://ror.org/03s33gc98', 'it', 1, 'https://ror.org/03s33gc98 Ospedale Bassini'),
(3177, 'https://ror.org/03s3dhf22', 'en', 1, 'https://ror.org/03s3dhf22 Centre hospitalier de St- Mary St Mary''s Hospital'),
(3178, 'https://ror.org/03s5q0090', 'en', 1, 'https://ror.org/03s5q0090 Asan Medical Center 서울아산병원'),
(3179, 'https://ror.org/03s5r4e84', 'en', 1, 'https://ror.org/03s5r4e84 VA NY Harbor Healthcare System'),
(3180, 'https://ror.org/03s8txj32', 'en', 1, 'https://ror.org/03s8txj32 Second Affiliated Hospital of Harbin Medical University'),
(3181, 'https://ror.org/03s9ada67', 'en', 1, 'https://ror.org/03s9ada67 HealthPartners'),
(3182, 'https://ror.org/03s9jrm13', 'no_lang_code', 1, 'https://ror.org/03s9jrm13 Kwong Wah Hospital 廣華醫院'),
(3183, 'https://ror.org/03sbc8x80', 'fr', 1, 'https://ror.org/03sbc8x80 Centre Hospitalier Universitaire Ibn Rochd'),
(3184, 'https://ror.org/03sbhge02', 'en', 1, 'https://ror.org/03sbhge02 Hallym University 한림대학교'),
(3185, 'https://ror.org/03sc99320', 'en', 1, 'https://ror.org/03sc99320 Hitachi General Hospital 日立総合病院'),
(3186, 'https://ror.org/03scbek41', 'en', 1, 'https://ror.org/03scbek41 Royal Orthopaedic Hospital'),
(3187, 'https://ror.org/03se9eg94', 'pt', 1, 'https://ror.org/03se9eg94 Hospital das Clínicas da Faculdade de Medicina da Universidade de São Paulo University of São Paulo Faculty of Medicine Clinics Hospital'),
(3188, 'https://ror.org/03sf6p593', 'en', 1, 'https://ror.org/03sf6p593 Showa Women''s University 昭和女子大学'),
(3189, 'https://ror.org/03sfkwk85', 'en', 1, 'https://ror.org/03sfkwk85 Rockefeller Foundation'),
(3190, 'https://ror.org/03sfybe47', 'en', 1, 'https://ror.org/03sfybe47 BC Cancer Agency'),
(3191, 'https://ror.org/03shav252', 'en', 1, 'https://ror.org/03shav252 Kazan State Technological University Казанский национальный исследовательский технологический университет'),
(3192, 'https://ror.org/03sjjqm13', 'en', 1, 'https://ror.org/03sjjqm13 Inouye Eye Hospital 井上眼科病院'),
(3193, 'https://ror.org/03sn6yr77', 'en', 1, 'https://ror.org/03sn6yr77 Point Blue Conservation Science'),
(3194, 'https://ror.org/03snrmr61', 'en', 1, 'https://ror.org/03snrmr61 Genesys Regional Medical Center'),
(3195, 'https://ror.org/03ss88z23', 'en', 1, 'https://ror.org/03ss88z23 Kagoshima University 鹿児島大学'),
(3196, 'https://ror.org/03sswts20', 'en', 1, 'https://ror.org/03sswts20 University of Mobile Université de mobile'),
(3197, 'https://ror.org/03ssyyt85', 'en', 1, 'https://ror.org/03ssyyt85 Ottawa County Health Department'),
(3198, 'https://ror.org/03sz8rb35', 'es', 1, 'https://ror.org/03sz8rb35 Hospital General Universitario De Valencia'),
(3199, 'https://ror.org/03t0zwh35', 'en', 1, 'https://ror.org/03t0zwh35 International Women''s Health Coalition'),
(3200, 'https://ror.org/03t1yn780', 'en', 1, 'https://ror.org/03t1yn780 First Affiliated Hospital of Anhui Medical University'),
(3201, 'https://ror.org/03t3q6164', 'en', 1, 'https://ror.org/03t3q6164 Rancho Los Amigos National Rehabilitation Center'),
(3202, 'https://ror.org/03t3qg659', 'en', 1, 'https://ror.org/03t3qg659 Substance Abuse and Mental Health Services Administration'),
(3203, 'https://ror.org/03t40cz74', 'no_lang_code', 1, 'https://ror.org/03t40cz74 Hypres (United States)'),
(3204, 'https://ror.org/03t4gtw27', 'ro', 1, 'https://ror.org/03t4gtw27 Spitalul Clinic de Urgenta Sfantul Ioan'),
(3205, 'https://ror.org/03t78za89', 'en', 1, 'https://ror.org/03t78za89 Regional Medical Center'),
(3206, 'https://ror.org/03t7m8092', 'en', 1, 'https://ror.org/03t7m8092 Public Health Foundation Enterprises'),
(3207, 'https://ror.org/03t8gvx47', 'en', 1, 'https://ror.org/03t8gvx47 Rampton Hospital'),
(3208, 'https://ror.org/03tatzf36', 'en', 1, 'https://ror.org/03tatzf36 Shandong Eye Institute & Hospital 山东省眼科研究所青岛与医院'),
(3209, 'https://ror.org/03tbh6y23', 'en', 1, 'https://ror.org/03tbh6y23 University of the Philippines Diliman'),
(3210, 'https://ror.org/03tds6380', 'en', 1, 'https://ror.org/03tds6380 Ohio Department of Mental Health & Addiction Services'),
(3211, 'https://ror.org/03teaad16', 'en', 1, 'https://ror.org/03teaad16 Rex Hospital'),
(3212, 'https://ror.org/03tf96d34', 'it', 1, 'https://ror.org/03tf96d34 Azienda Ospedaliera Universitaria Policlinico "G. Martino"'),
(3213, 'https://ror.org/03tfy3c27', 'es', 1, 'https://ror.org/03tfy3c27 Hospital Vega Baja'),
(3214, 'https://ror.org/03tg0z446', 'en', 1, 'https://ror.org/03tg0z446 Odisha University of Agriculture and Technology उडिसा कृषि एवं प्रौद्योगिकी विश्वविद्यालय'),
(3215, 'https://ror.org/03thhhv76', 'en', 1, 'https://ror.org/03thhhv76 American Type Culture Collection'),
(3216, 'https://ror.org/03thzz813', 'en', 1, 'https://ror.org/03thzz813 Meikai University 明海大学'),
(3217, 'https://ror.org/03tkfgy13', 'en', 1, 'https://ror.org/03tkfgy13 Simanogleio-Amalia Fleming General Hospital Σισμανόγλειο-Αμαλία Φλέμινγκ Γενικό Νοσοκομείο'),
(3218, 'https://ror.org/03tktyg33', 'en', 1, 'https://ror.org/03tktyg33 Western Oklahoma State College'),
(3219, 'https://ror.org/03tn5ee41', 'en', 1, 'https://ror.org/03tn5ee41 Benha University Université de Banha جامعة بنها'),
(3220, 'https://ror.org/03tp0ty93', 'en', 1, 'https://ror.org/03tp0ty93 Geha Mental Health Center המרכז לבריאות הנפש גהה'),
(3221, 'https://ror.org/03tqnz817', 'en', 1, 'https://ror.org/03tqnz817 Sachs'' Children and Youth Hospital'),
(3222, 'https://ror.org/03tr4r126', 'en', 1, 'https://ror.org/03tr4r126 Narayan Medical College and Hospital'),
(3223, 'https://ror.org/03tth1e03', 'en', 1, 'https://ror.org/03tth1e03 University of Life Sciences in Poznań Uniwersytet Przyrodniczy w Poznaniu'),
(3224, 'https://ror.org/03tv0az53', 'en', 1, 'https://ror.org/03tv0az53 Fairfield General Hospital'),
(3225, 'https://ror.org/03ty5px05', 'en', 1, 'https://ror.org/03ty5px05 Hunan Entry-Exit Inspection and Quarantine Bureau'),
(3226, 'https://ror.org/03ty7jy62', 'en', 1, 'https://ror.org/03ty7jy62 Alexian Brothers Medical Center'),
(3227, 'https://ror.org/03v188q73', 'en', 1, 'https://ror.org/03v188q73 Earthquake Engineering Research Institute'),
(3228, 'https://ror.org/03v4m1x12', 'en', 1, 'https://ror.org/03v4m1x12 Damghan University دانشگاه دامغان'),
(3229, 'https://ror.org/03v6t2982', 'en', 1, 'https://ror.org/03v6t2982 Moses Taylor Hospital'),
(3230, 'https://ror.org/03v7hnv07', 'no_lang_code', 1, 'https://ror.org/03v7hnv07 Metaxa Hospital'),
(3231, 'https://ror.org/03v85ar63', 'en', 1, 'https://ror.org/03v85ar63 Central University Hospital of Asturias'),
(3232, 'https://ror.org/03v8v5y65', 'it', 1, 'https://ror.org/03v8v5y65 Consorzio Interuniversitario Nazionale per l''Informatica National Interuniversity Consortium for Informatics'),
(3233, 'https://ror.org/03vaer060', 'en', 1, 'https://ror.org/03vaer060 MRC University of Glasgow Centre for Virus Research'),
(3234, 'https://ror.org/03vamsh08', 'en', 1, 'https://ror.org/03vamsh08 County Durham and Darlington NHS Foundation Trust'),
(3235, 'https://ror.org/03vb4dm14', 'en', 1, 'https://ror.org/03vb4dm14 Texas A&M University at Qatar جامعة تكساس أي اند إم'),
(3236, 'https://ror.org/03vc5bf16', 'en', 1, 'https://ror.org/03vc5bf16 Cappagh National Orthopaedic Hospital'),
(3237, 'https://ror.org/03vc89b25', 'en', 1, 'https://ror.org/03vc89b25 Osaka Bio Headquarters'),
(3238, 'https://ror.org/03vd2y814', 'en', 1, 'https://ror.org/03vd2y814 Kitasato University Medical Center 北里大学メディカルセンター'),
(3239, 'https://ror.org/03vdj0f87', 'en', 1, 'https://ror.org/03vdj0f87 AtlantiCare'),
(3240, 'https://ror.org/03vf51s41', 'hr', 1, 'https://ror.org/03vf51s41 Klinički bolnički centar Osijek'),
(3241, 'https://ror.org/03vgdd632', 'no_lang_code', 1, 'https://ror.org/03vgdd632 Ichor Medical Systems (United States)'),
(3242, 'https://ror.org/03vgqy581', 'no_lang_code', 1, 'https://ror.org/03vgqy581 Asahikawa University 旭川大学'),
(3243, 'https://ror.org/03vj41343', 'en', 1, 'https://ror.org/03vj41343 San Francicso Brain Research Institute & SAM Technology'),
(3244, 'https://ror.org/03vj98x35', 'en', 1, 'https://ror.org/03vj98x35 Beijing Dao Pei Hospital 北京道培医院'),
(3245, 'https://ror.org/03vjkf643', 'en', 1, 'https://ror.org/03vjkf643 Shanghai Tenth People''s Hospital 上海第十人民医院'),
(3246, 'https://ror.org/03vkkz907', 'en', 1, 'https://ror.org/03vkkz907 Batra Hospital and Medical Research Centre'),
(3247, 'https://ror.org/03vmdsx94', 'en', 1, 'https://ror.org/03vmdsx94 Nagara Medical Center 国立病院機構長良医療センター'),
(3248, 'https://ror.org/03vn2ff22', 'en', 1, 'https://ror.org/03vn2ff22 Missouri Western State University'),
(3249, 'https://ror.org/03vnftm46', 'no_lang_code', 1, 'https://ror.org/03vnftm46 Maxwell Sensors'),
(3250, 'https://ror.org/03vnj0h28', 'en', 1, 'https://ror.org/03vnj0h28 Duke Children''s Hospital & Health Center'),
(3251, 'https://ror.org/03vnshb93', 'en', 1, 'https://ror.org/03vnshb93 Transport for London'),
(3252, 'https://ror.org/03vpd6e34', 'en', 1, 'https://ror.org/03vpd6e34 Hayatabad Medical Complex'),
(3253, 'https://ror.org/03vt2s541', 'en', 1, 'https://ror.org/03vt2s541 Ministry of Health and Social Welfare'),
(3254, 'https://ror.org/03vw2zn10', 'fr', 1, 'https://ror.org/03vw2zn10 Hôpital Saint-Vincent-de-Paul'),
(3255, 'https://ror.org/03vwxd822', 'no_lang_code', 1, 'https://ror.org/03vwxd822 Chugoku Rosai Hospital 中国労災病院'),
(3256, 'https://ror.org/03vz8ns51', 'en', 1, 'https://ror.org/03vz8ns51 Ziauddin University'),
(3257, 'https://ror.org/03vzbgh69', 'en', 1, 'https://ror.org/03vzbgh69 University Medical Center Freiburg Universitätsklinikum Freiburg'),
(3258, 'https://ror.org/03vzfth13', 'en', 1, 'https://ror.org/03vzfth13 Hospital for Special Care'),
(3259, 'https://ror.org/03vzpaf33', 'en', 1, 'https://ror.org/03vzpaf33 Einstein Medical Center Philadelphia'),
(3260, 'https://ror.org/03w0k0x36', 'en', 1, 'https://ror.org/03w0k0x36 Beijing Sport University 北京体育大学'),
(3261, 'https://ror.org/03w0kj141', 'en', 1, 'https://ror.org/03w0kj141 Army Medical College'),
(3262, 'https://ror.org/03w11wq45', 'es', 1, 'https://ror.org/03w11wq45 El Hospital General de Agudos Carlos G. Durand'),
(3263, 'https://ror.org/03w1tbe79', 'no_lang_code', 1, 'https://ror.org/03w1tbe79 Molecular GPS Technologies (United States)'),
(3264, 'https://ror.org/03w37n116', 'en', 1, 'https://ror.org/03w37n116 Alta Bates Summit Medical Center'),
(3265, 'https://ror.org/03w44ff23', 'en', 1, 'https://ror.org/03w44ff23 Brigham and Women''s Faulkner Hospital'),
(3266, 'https://ror.org/03w5gm511', 'en', 1, 'https://ror.org/03w5gm511 Adventist University of Health Sciences'),
(3267, 'https://ror.org/03w5j8p12', 'en', 1, 'https://ror.org/03w5j8p12 Rega Institute for Medical Research'),
(3268, 'https://ror.org/03w6p2n94', 'en', 1, 'https://ror.org/03w6p2n94 Bendigo Health'),
(3269, 'https://ror.org/03w8m2977', 'no_lang_code', 1, 'https://ror.org/03w8m2977 Yibin University'),
(3270, 'https://ror.org/03w94w157', 'en', 1, 'https://ror.org/03w94w157 Mater Private Hospital'),
(3271, 'https://ror.org/03w9cdv26', 'no_lang_code', 1, 'https://ror.org/03w9cdv26 Maichin Dom Университетска акушеро-гинекологична болница “Майчин дом”'),
(3272, 'https://ror.org/03wc8tg09', 'en', 1, 'https://ror.org/03wc8tg09 Jessop Hospital'),
(3273, 'https://ror.org/03wckff62', 'no_lang_code', 1, 'https://ror.org/03wckff62 Southwest Sciences (United States)'),
(3274, 'https://ror.org/03wed5r38', 'en', 1, 'https://ror.org/03wed5r38 Eginition Hospital'),
(3275, 'https://ror.org/03wff9w51', 'en', 1, 'https://ror.org/03wff9w51 Sema Hastanesi Sema Hospital'),
(3276, 'https://ror.org/03wg58p93', 'en', 1, 'https://ror.org/03wg58p93 Hamilton Medical Center'),
(3277, 'https://ror.org/03wgfnb71', 'no_lang_code', 1, 'https://ror.org/03wgfnb71 Barron Associates (United States)'),
(3278, 'https://ror.org/03wgqqb38', 'no_lang_code', 1, 'https://ror.org/03wgqqb38 Beijing HuiLongGuan Hospital 北京回龙观医院'),
(3279, 'https://ror.org/03wgsss62', 'no_lang_code', 1, 'https://ror.org/03wgsss62 Aciéries Réunies de Burbach-Eich-Dudelange Arbed (Luxembourg) Vereinigte Stahlhütten Burbach-Eich-Düdelingen'),
(3280, 'https://ror.org/03wkg3b53', 'en', 1, 'https://ror.org/03wkg3b53 National Eye Institute'),
(3281, 'https://ror.org/03wkrdj07', 'no_lang_code', 1, 'https://ror.org/03wkrdj07 Anandaban Hospital'),
(3282, 'https://ror.org/03wn09h25', 'no_lang_code', 1, 'https://ror.org/03wn09h25 Novelis (Canada)'),
(3283, 'https://ror.org/03wq4px44', 'en', 1, 'https://ror.org/03wq4px44 North Medical Center 京都府立医科大学附属北部医療センター'),
(3284, 'https://ror.org/03wwnw466', 'en', 1, 'https://ror.org/03wwnw466 Milpark Hospital'),
(3285, 'https://ror.org/03wzyp716', 'en', 1, 'https://ror.org/03wzyp716 Mount Carmel Health'),
(3286, 'https://ror.org/03x0d4x24', 'en', 1, 'https://ror.org/03x0d4x24 Pacific Northwest Diabetes Research Institute'),
(3287, 'https://ror.org/03x1jna21', 'en', 1, 'https://ror.org/03x1jna21 Central China Normal University 华中师范大学'),
(3288, 'https://ror.org/03x295n29', 'no_lang_code', 1, 'https://ror.org/03x295n29 Sant Parmanand Hospital'),
(3289, 'https://ror.org/03x516a66', 'en', 1, 'https://ror.org/03x516a66 Bundesanstalt für Materialforschung und -prüfung Federal Institute For Materials Research and Testing'),
(3290, 'https://ror.org/03x8jdc94', 'en', 1, 'https://ror.org/03x8jdc94 Lady Hardinge Medical College'),
(3291, 'https://ror.org/03xbkmz44', 'en', 1, 'https://ror.org/03xbkmz44 Athens Naval & Veterans Hospital Ναυτικό Νοσοκομείο Αθηνών'),
(3292, 'https://ror.org/03xg1f311', 'en', 1, 'https://ror.org/03xg1f311 Kansai University 関西大学'),
(3293, 'https://ror.org/03xgh2v50', 'en', 1, 'https://ror.org/03xgh2v50 Toyama Prefectural University 富山県立大学'),
(3294, 'https://ror.org/03xh40058', 'en', 1, 'https://ror.org/03xh40058 Ministry of Health وزارة الصحة'),
(3295, 'https://ror.org/03xhrps63', 'en', 1, 'https://ror.org/03xhrps63 Central State University'),
(3296, 'https://ror.org/03xhwyc44', 'en', 1, 'https://ror.org/03xhwyc44 Chongqing Emergency Medical Center 重庆市急救医疗中心'),
(3297, 'https://ror.org/03xjacd83', 'en', 1, 'https://ror.org/03xjacd83 Cleveland Clinic'),
(3298, 'https://ror.org/03xms6995', 'en', 1, 'https://ror.org/03xms6995 Central Police University'),
(3299, 'https://ror.org/03xmsh521', 'en', 1, 'https://ror.org/03xmsh521 Bombay Hospital'),
(3300, 'https://ror.org/03xp4dz54', 'en', 1, 'https://ror.org/03xp4dz54 Nebraska Wesleyan University'),
(3301, 'https://ror.org/03xrts777', 'en', 1, 'https://ror.org/03xrts777 Shizuoka Medical Center 静岡医療センター'),
(3302, 'https://ror.org/03xvpaf72', 'en', 1, 'https://ror.org/03xvpaf72 Wakasa History and Folklore Museum 福井県立 若狭歴史博物館'),
(3303, 'https://ror.org/03xww6m08', 'en', 1, 'https://ror.org/03xww6m08 Nicolae Testemițanu State University of Medicine and Pharmacy Universitatea de Medicină și Farmacie Nicolae Testemițanu din Chișinău Государственный университет медицины и фармакологии имени Николая Тестемицяну'),
(3304, 'https://ror.org/03xz3hj66', 'no_lang_code', 1, 'https://ror.org/03xz3hj66 Shonan Kamakura General Hospital 湘南鎌倉総合病院'),
(3305, 'https://ror.org/03y1rev40', 'en', 1, 'https://ror.org/03y1rev40 Hyvinkää Hospital'),
(3306, 'https://ror.org/03y2evj08', 'tr', 1, 'https://ror.org/03y2evj08 Göztepe Şafak Hastanesi'),
(3307, 'https://ror.org/03y4myd35', 'en', 1, 'https://ror.org/03y4myd35 Infectious Disease Research Institute'),
(3308, 'https://ror.org/03yb8aa18', 'it', 1, 'https://ror.org/03yb8aa18 Ospedale Santa Maria della Misericordia di Rovigo'),
(3309, 'https://ror.org/03ycmew18', 'en', 1, 'https://ror.org/03ycmew18 Matsushita Memorial Hospital 松下記念病院'),
(3310, 'https://ror.org/03ydkyb10', 'en', 1, 'https://ror.org/03ydkyb10 Sistema Universitario de Wisconsin University of Wisconsin System Université du Wisconsin'),
(3311, 'https://ror.org/03ydmxb41', 'es', 1, 'https://ror.org/03ydmxb41 Hospital Alemán'),
(3312, 'https://ror.org/03yegf956', 'en', 1, 'https://ror.org/03yegf956 Alice Springs Hospital'),
(3313, 'https://ror.org/03yemaq40', 'en', 1, 'https://ror.org/03yemaq40 University of Findlay'),
(3314, 'https://ror.org/03yjk2s16', 'fr', 1, 'https://ror.org/03yjk2s16 Centre Hospitalier National Universitaire de Fann'),
(3315, 'https://ror.org/03yjkej49', 'en', 1, 'https://ror.org/03yjkej49 Center for Interuniversity Research and Analysis on Organizations'),
(3316, 'https://ror.org/03yk5k102', 'en', 1, 'https://ror.org/03yk5k102 Institute of Child Health'),
(3317, 'https://ror.org/03ynt1573', 'no_lang_code', 1, 'https://ror.org/03ynt1573 Ansaldo (Italy)'),
(3318, 'https://ror.org/03ypbx660', 'no_lang_code', 1, 'https://ror.org/03ypbx660 Renji Hospital 上海交通大学医学院附属仁济医院'),
(3319, 'https://ror.org/03ysk5e42', 'en', 1, 'https://ror.org/03ysk5e42 University of Suwon 수원대학교'),
(3320, 'https://ror.org/03ysstz10', 'en', 1, 'https://ror.org/03ysstz10 Electronics and Telecommunications Research Institute 한국전자통신연구원'),
(3321, 'https://ror.org/03yt4qx74', 'en', 1, 'https://ror.org/03yt4qx74 Kasumigaura Medical Center 霞ヶ浦医療センター'),
(3322, 'https://ror.org/03yvcww04', 'en', 1, 'https://ror.org/03yvcww04 North Shore Hospital'),
(3323, 'https://ror.org/03ywwzv91', 'no_lang_code', 1, 'https://ror.org/03ywwzv91 3C Institute'),
(3324, 'https://ror.org/03yz7v531', 'en', 1, 'https://ror.org/03yz7v531 Mysore Medical College'),
(3325, 'https://ror.org/03yzzaw34', 'it', 1, 'https://ror.org/03yzzaw34 Ospedale Regina Apostolorum'),
(3326, 'https://ror.org/03z0bdc81', 'no_lang_code', 1, 'https://ror.org/03z0bdc81 Bundang Jesaeng Hospital 분당제생병원'),
(3327, 'https://ror.org/03z27es23', 'en', 1, 'https://ror.org/03z27es23 Universidad Mayor de San Simón University of San Simón'),
(3328, 'https://ror.org/03z2mza16', 'en', 1, 'https://ror.org/03z2mza16 Dewsbury and District Hospital'),
(3329, 'https://ror.org/03z4rrt03', 'de', 1, 'https://ror.org/03z4rrt03 Lindenhofspital'),
(3330, 'https://ror.org/03z6cqs20', 'es', 1, 'https://ror.org/03z6cqs20 Hospital Materno-Infantil'),
(3331, 'https://ror.org/03z8sn326', 'en', 1, 'https://ror.org/03z8sn326 Women & Infants Hospital of Rhode Island'),
(3332, 'https://ror.org/03z8x2j90', 'en', 1, 'https://ror.org/03z8x2j90 Frenchay Hospital'),
(3333, 'https://ror.org/03zayce58', 'en', 1, 'https://ror.org/03zayce58 Princess Margaret Cancer Centre'),
(3334, 'https://ror.org/03zeamg24', 'no_lang_code', 1, 'https://ror.org/03zeamg24 Kobe Asahi Hospital 神戸朝日病院'),
(3335, 'https://ror.org/03zeek684', 'it', 1, 'https://ror.org/03zeek684 Consorzio Universitario In Ingegneria Della Qualita'),
(3336, 'https://ror.org/03zeg3732', 'en', 1, 'https://ror.org/03zeg3732 Horton General Hospital'),
(3337, 'https://ror.org/03zgmap36', 'en', 1, 'https://ror.org/03zgmap36 Easton Hospital'),
(3338, 'https://ror.org/03zhhr656', 'en', 1, 'https://ror.org/03zhhr656 Kyoto University of Education 京都教育大学'),
(3339, 'https://ror.org/03zhk7994', 'en', 1, 'https://ror.org/03zhk7994 London Chest Hospital'),
(3340, 'https://ror.org/03zjj0p70', 'en', 1, 'https://ror.org/03zjj0p70 Population Council'),
(3341, 'https://ror.org/03zkja782', 'en', 1, 'https://ror.org/03zkja782 Luton and Dunstable University Hospital NHS Foundation Trust'),
(3342, 'https://ror.org/03zms7281', 'en', 1, 'https://ror.org/03zms7281 Good Samaritan Hospital'),
(3343, 'https://ror.org/03zn9xk79', 'en', 1, 'https://ror.org/03zn9xk79 University Teaching Hospital'),
(3344, 'https://ror.org/03zpnb459', 'no_lang_code', 1, 'https://ror.org/03zpnb459 Bikur Cholim Hospital'),
(3345, 'https://ror.org/03zq81960', 'en', 1, 'https://ror.org/03zq81960 Hôpital général de kingston Kingston General Hospital'),
(3346, 'https://ror.org/03zrwm897', 'en', 1, 'https://ror.org/03zrwm897 Technical University of Varna Технически университет - Варна'),
(3347, 'https://ror.org/03zsbd109', 'en', 1, 'https://ror.org/03zsbd109 Hanwa Memorial Hospital 阪和記念病院'),
(3348, 'https://ror.org/03zsjhd07', 'en', 1, 'https://ror.org/03zsjhd07 University of Arkansas at Pine Bluff Université de l''arkansas à pine bluff'),
(3349, 'https://ror.org/03zstcc67', 'en', 1, 'https://ror.org/03zstcc67 Randolph–Macon College'),
(3350, 'https://ror.org/03zvd4s03', 'en', 1, 'https://ror.org/03zvd4s03 WellStar Kennestone Hospital'),
(3351, 'https://ror.org/03zwf0j41', 'en', 1, 'https://ror.org/03zwf0j41 Macclesfield District General Hospital'),
(3352, 'https://ror.org/03zww1h73', 'en', 1, 'https://ror.org/03zww1h73 University Hospital of Ioannina'),
(3353, 'https://ror.org/03zx0nf33', 'en', 1, 'https://ror.org/03zx0nf33 AcademyHealth'),
(3354, 'https://ror.org/03zzj3f20', 'en', 1, 'https://ror.org/03zzj3f20 Fields Institute for Research in Mathematical Sciences'),
(3355, 'https://ror.org/03zzjb946', 'en', 1, 'https://ror.org/03zzjb946 Nishinomiya Kyoritsu Neurosurgical Hospital 西宮協立脳神経外科病院'),
(3356, 'https://ror.org/03zzvtn22', 'de', 1, 'https://ror.org/03zzvtn22 Klinikum im Friedrichshain'),
(3357, 'https://ror.org/03zzyap02', 'en', 1, 'https://ror.org/03zzyap02 Tohoku Medical Megabank Organization 東北メディカル・メガバンク機構'),
(3358, 'https://ror.org/03zzzks34', 'en', 1, 'https://ror.org/03zzzks34 Liverpool Hospital'),
(3359, 'https://ror.org/0402ejh63', 'en', 1, 'https://ror.org/0402ejh63 La Jolla Institute For Molecular Medicine'),
(3360, 'https://ror.org/0403w5x31', 'en', 1, 'https://ror.org/0403w5x31 Guglielmo da Saliceto Hospital'),
(3361, 'https://ror.org/04043k259', 'en', 1, 'https://ror.org/04043k259 Austral University Universidad Austral'),
(3362, 'https://ror.org/0404efv41', 'en', 1, 'https://ror.org/0404efv41 Mercy Medical Center'),
(3363, 'https://ror.org/0405qn567', 'no_lang_code', 1, 'https://ror.org/0405qn567 Nerima General Hospital 練馬総合病院'),
(3364, 'https://ror.org/0405thq08', 'en', 1, 'https://ror.org/0405thq08 Saint Ambrose University Université saint ambroise'),
(3365, 'https://ror.org/0408b4j80', 'en', 1, 'https://ror.org/0408b4j80 B.J. Medical College'),
(3366, 'https://ror.org/0408cp281', 'en', 1, 'https://ror.org/0408cp281 Delaware Department of Health and Social Services'),
(3367, 'https://ror.org/0409zd934', 'en', 1, 'https://ror.org/0409zd934 Universidad de Cartagena University of Cartagena'),
(3368, 'https://ror.org/040bb8882', 'pt', 1, 'https://ror.org/040bb8882 Hospital de São Marcos'),
(3369, 'https://ror.org/040cn9093', 'en', 1, 'https://ror.org/040cn9093 Community Health Network'),
(3370, 'https://ror.org/040cnym54', 'en', 1, 'https://ror.org/040cnym54 Pennington Biomedical Research Center'),
(3371, 'https://ror.org/040cxgs87', 'no_lang_code', 1, 'https://ror.org/040cxgs87 Starlab Barcelona Sl'),
(3372, 'https://ror.org/040d1yx23', 'no_lang_code', 1, 'https://ror.org/040d1yx23 Senvion SE (Germany)'),
(3373, 'https://ror.org/040epzy68', 'en', 1, 'https://ror.org/040epzy68 Istanbul Memorial Hospital'),
(3374, 'https://ror.org/040evg982', 'en', 1, 'https://ror.org/040evg982 Santobono Children''s Hospital'),
(3375, 'https://ror.org/040f7tw31', 'no_lang_code', 1, 'https://ror.org/040f7tw31 Inuyama Chuo Hospital 犬山中央病院'),
(3376, 'https://ror.org/040hwr020', 'en', 1, 'https://ror.org/040hwr020 Borough of Manhattan Community College'),
(3377, 'https://ror.org/040jhkj51', 'fr', 1, 'https://ror.org/040jhkj51 Centre Hospitalier de Saint Jean de Dieu'),
(3378, 'https://ror.org/040jk5g10', 'en', 1, 'https://ror.org/040jk5g10 Samuel Merritt University'),
(3379, 'https://ror.org/040m2wv49', 'en', 1, 'https://ror.org/040m2wv49 Skaraborg Hospital Skaraborgs Sjukhus'),
(3380, 'https://ror.org/040m56689', 'hu', 1, 'https://ror.org/040m56689 Baranya Megyei Kórház'),
(3381, 'https://ror.org/040nggs60', 'en', 1, 'https://ror.org/040nggs60 West China Medical Center of Sichuan University 四川大学华西医学中心'),
(3382, 'https://ror.org/040qhpb54', 'en', 1, 'https://ror.org/040qhpb54 Aomori University 青森大学'),
(3383, 'https://ror.org/040qrra89', 'en', 1, 'https://ror.org/040qrra89 G.V. (Sonny) Montgomery VA Medical Center'),
(3384, 'https://ror.org/040qxz868', 'no_lang_code', 1, 'https://ror.org/040qxz868 Chhatrapati Shahu Ji Maharaj University छत्रपति शाहूजी महाराज विश्वविद्यालय சத்ரபதி ஷாகுஜி மகராஜ் பல்கலைக்கழகம்'),
(3385, 'https://ror.org/040r8fr65', 'en', 1, 'https://ror.org/040r8fr65 Aarhus University Hospital Skejby Sygehus'),
(3386, 'https://ror.org/040vfm237', 'en', 1, 'https://ror.org/040vfm237 North West Regional Hospital'),
(3387, 'https://ror.org/040vwpm13', 'en', 1, 'https://ror.org/040vwpm13 University of Houston System'),
(3388, 'https://ror.org/040yv4379', 'fi', 1, 'https://ror.org/040yv4379 Kainuun keskussairaala'),
(3389, 'https://ror.org/0411njj18', 'en', 1, 'https://ror.org/0411njj18 Ragas Dental College & Hospital'),
(3390, 'https://ror.org/04133ks15', 'en', 1, 'https://ror.org/04133ks15 Ecpi University'),
(3391, 'https://ror.org/0416des07', 'es', 1, 'https://ror.org/0416des07 Hospital Universitario Lucus Augusti'),
(3392, 'https://ror.org/0416m3683', 'de', 1, 'https://ror.org/0416m3683 Institut für Rundfunktechnik'),
(3393, 'https://ror.org/0417sdw47', 'en', 1, 'https://ror.org/0417sdw47 Korea Basic Science Institute'),
(3394, 'https://ror.org/0418a3v02', 'en', 1, 'https://ror.org/0418a3v02 Setsunan University 摂南大学'),
(3395, 'https://ror.org/0419bgt07', 'en', 1, 'https://ror.org/0419bgt07 University of Florida Health Science Center');
INSERT INTO `rors` VALUES
(3396, 'https://ror.org/0419nfc77', 'en', 1, 'https://ror.org/0419nfc77 China Three Gorges University 三峡大学'),
(3397, 'https://ror.org/041b40q78', 'no_lang_code', 1, 'https://ror.org/041b40q78 Olympus (Australia)'),
(3398, 'https://ror.org/041bf1s37', 'no_lang_code', 1, 'https://ror.org/041bf1s37 Kanto Gakuin University 関東学院大学'),
(3399, 'https://ror.org/041e85345', 'en', 1, 'https://ror.org/041e85345 Bhumibol Adulyadej Hospital โรงพยาบาลภูมิพลอดุลยเดช'),
(3400, 'https://ror.org/041f0qb31', 'en', 1, 'https://ror.org/041f0qb31 University Hospital Crosshouse'),
(3401, 'https://ror.org/041hae580', 'en', 1, 'https://ror.org/041hae580 Countess of Chester Hospital'),
(3402, 'https://ror.org/041jw5813', 'en', 1, 'https://ror.org/041jw5813 University of San Carlos'),
(3403, 'https://ror.org/041jyhr41', 'en', 1, 'https://ror.org/041jyhr41 Selly Oak Hospital'),
(3404, 'https://ror.org/041m0cc93', 'en', 1, 'https://ror.org/041m0cc93 Providence VA Medical Center'),
(3405, 'https://ror.org/041mbwk52', 'no_lang_code', 1, 'https://ror.org/041mbwk52 Fisher Bioservices (United States)'),
(3406, 'https://ror.org/041tn5e09', 'no_lang_code', 1, 'https://ror.org/041tn5e09 Shinrakuen Hospital 信楽園病院'),
(3407, 'https://ror.org/041wfjw90', 'en', 1, 'https://ror.org/041wfjw90 LungenClinic Grosshansdorf'),
(3408, 'https://ror.org/04204gr61', 'en', 1, 'https://ror.org/04204gr61 Universidad de La Habana University of Havana'),
(3409, 'https://ror.org/04219vz71', 'en', 1, 'https://ror.org/04219vz71 Silver Cross Hospital'),
(3410, 'https://ror.org/0422nk691', 'no_lang_code', 1, 'https://ror.org/0422nk691 Fukujuji Hospital 複十字病院'),
(3411, 'https://ror.org/0422q5a32', 'en', 1, 'https://ror.org/0422q5a32 Scripps Whittier Diabetes Institute'),
(3412, 'https://ror.org/04253q669', 'en', 1, 'https://ror.org/04253q669 Medical City Children''s Hospital'),
(3413, 'https://ror.org/0425pcn39', 'no_lang_code', 1, 'https://ror.org/0425pcn39 NeuroComp Systems (United States)'),
(3414, 'https://ror.org/0427fee43', 'en', 1, 'https://ror.org/0427fee43 Maharani Laxmi Bai Medical College'),
(3415, 'https://ror.org/0429d0v34', 'en', 1, 'https://ror.org/0429d0v34 China Animal Health and Epidemiology Center 中国动物卫生与流行病学中心'),
(3416, 'https://ror.org/042asnw05', 'en', 1, 'https://ror.org/042asnw05 Castle Hill Hospital'),
(3417, 'https://ror.org/042awg277', 'en', 1, 'https://ror.org/042awg277 MCNC Research and Development Institute'),
(3418, 'https://ror.org/042bbge36', 'en', 1, 'https://ror.org/042bbge36 Nova Southeastern University Universidad de Nova Southeastern'),
(3419, 'https://ror.org/042bdnm87', 'no_lang_code', 1, 'https://ror.org/042bdnm87 Svenskt Stål (Finland) Swedish Steel'),
(3420, 'https://ror.org/042bhxs14', 'en', 1, 'https://ror.org/042bhxs14 Burdwan Medical College & Hospital'),
(3421, 'https://ror.org/042ck3w97', 'en', 1, 'https://ror.org/042ck3w97 Hyogo Ion Beam Medical Center 兵庫県立粒子線医療センター'),
(3422, 'https://ror.org/042ckra75', 'en', 1, 'https://ror.org/042ckra75 Research Foundation For Mental Hygiene'),
(3423, 'https://ror.org/042e7c302', 'fr', 1, 'https://ror.org/042e7c302 Multitel'),
(3424, 'https://ror.org/042fv2404', 'en', 1, 'https://ror.org/042fv2404 Musgrove Park Hospital'),
(3425, 'https://ror.org/042jtt364', 'en', 1, 'https://ror.org/042jtt364 Air Force General Hospital PLA'),
(3426, 'https://ror.org/042mrsz23', 'en', 1, 'https://ror.org/042mrsz23 Bangabandhu Sheikh Mujib Medical University বঙ্গবন্ধু শেখ মুজিব মেডিকেল বিশ্ববিদ্যালয়'),
(3427, 'https://ror.org/042q8va29', 'no_lang_code', 1, 'https://ror.org/042q8va29 Sidenor (Greece) ΣΙΔΕΝΟΡ'),
(3428, 'https://ror.org/042qjjy86', 'en', 1, 'https://ror.org/042qjjy86 Ministry of Health ကျန်းမာရေးဝန်ကြီးဌာန'),
(3429, 'https://ror.org/042rz6s74', 'en', 1, 'https://ror.org/042rz6s74 Nissan Tamagawa Hospital 日産厚生会 玉川病院'),
(3430, 'https://ror.org/042thbm45', 'en', 1, 'https://ror.org/042thbm45 Manly Hospital'),
(3431, 'https://ror.org/042vq9b25', 'pt', 1, 'https://ror.org/042vq9b25 Instituto Superior de Educação e Ciências'),
(3432, 'https://ror.org/042vvex07', 'en', 1, 'https://ror.org/042vvex07 Jos University Teaching Hospital'),
(3433, 'https://ror.org/042x68w22', 'pt', 1, 'https://ror.org/042x68w22 Escola Superior de Enfermagem Dr. José Timóteo Montalvão Machado'),
(3434, 'https://ror.org/042z7qa37', 'en', 1, 'https://ror.org/042z7qa37 McKendree University'),
(3435, 'https://ror.org/043071f54', 'en', 1, 'https://ror.org/043071f54 University of Roehampton'),
(3436, 'https://ror.org/0431v1017', 'fr', 1, 'https://ror.org/0431v1017 Hôpital Riviera-Chablais'),
(3437, 'https://ror.org/0431x1p15', 'en', 1, 'https://ror.org/0431x1p15 Gunma Children''s Medical Center 群馬県立小児医療センター'),
(3438, 'https://ror.org/0432p8t34', 'en', 1, 'https://ror.org/0432p8t34 Guangdong Academy of Medical Sciences'),
(3439, 'https://ror.org/04330ze25', 'en', 1, 'https://ror.org/04330ze25 Ashford Hospital'),
(3440, 'https://ror.org/0433abe34', 'en', 1, 'https://ror.org/0433abe34 K.N.Toosi University of Technology دانشگاه صنعتی خواجه نصیرالدین طوسی'),
(3441, 'https://ror.org/0433kqc49', 'en', 1, 'https://ror.org/0433kqc49 Pukyong National University 부경대학교'),
(3442, 'https://ror.org/04353mq94', 'en', 1, 'https://ror.org/04353mq94 Chungnam National University Hospital'),
(3443, 'https://ror.org/043889z90', 'en', 1, 'https://ror.org/043889z90 The General Hospital of Heraklion "Venizeleio-Pananio" Γενικό Νοσοκομείο Ηρακλείου "Βενιζέλειο - Πανάνειο"'),
(3444, 'https://ror.org/043brc084', 'en', 1, 'https://ror.org/043brc084 Kuo General Hospital 郭综合医院'),
(3445, 'https://ror.org/043ckch24', 'en', 1, 'https://ror.org/043ckch24 Rehabilitation Hospital of Indiana'),
(3446, 'https://ror.org/043dm5251', 'no_lang_code', 1, 'https://ror.org/043dm5251 Microfab Technologies (United States)'),
(3447, 'https://ror.org/043e04s74', 'en', 1, 'https://ror.org/043e04s74 Civil Aerospace Medical Institute'),
(3448, 'https://ror.org/043ek5g31', 'en', 1, 'https://ror.org/043ek5g31 Henan Cancer Hospital 河南省肿瘤医院'),
(3449, 'https://ror.org/043eknq26', 'en', 1, 'https://ror.org/043eknq26 General Hospital of Nikea Γενικό Νοσοκομείο Νίκαιας'),
(3450, 'https://ror.org/043h2w593', 'en', 1, 'https://ror.org/043h2w593 Akita Red Cross Hospital 秋田赤十字病院'),
(3451, 'https://ror.org/043j9bc42', 'en', 1, 'https://ror.org/043j9bc42 Royal National Orthopaedic Hospital'),
(3452, 'https://ror.org/043jqrs76', 'en', 1, 'https://ror.org/043jqrs76 Sunchon National University 순천대학교'),
(3453, 'https://ror.org/043m85342', 'en', 1, 'https://ror.org/043m85342 Hospital Povisa Povisa Hospital'),
(3454, 'https://ror.org/043mrw780', 'en', 1, 'https://ror.org/043mrw780 Institute For Community Research'),
(3455, 'https://ror.org/043mzjj67', 'en', 1, 'https://ror.org/043mzjj67 Beaumont Hospital'),
(3456, 'https://ror.org/043p8z282', 'en', 1, 'https://ror.org/043p8z282 JR Tokyo General Hospital JR東京総合病院'),
(3457, 'https://ror.org/043ppnw54', 'it', 1, 'https://ror.org/043ppnw54 Ospedale San Donato'),
(3458, 'https://ror.org/043qmbk61', 'en', 1, 'https://ror.org/043qmbk61 Arbor Research Collaborative for Health'),
(3459, 'https://ror.org/043rjaw23', 'no_lang_code', 1, 'https://ror.org/043rjaw23 Profactor (Austria)'),
(3460, 'https://ror.org/043sbvg03', 'en', 1, 'https://ror.org/043sbvg03 Eastern Hepatobiliary Surgery Hospital 东方肝胆外科医院'),
(3461, 'https://ror.org/043xhwq03', 'en', 1, 'https://ror.org/043xhwq03 Carney Hospital'),
(3462, 'https://ror.org/043yd1m08', 'en', 1, 'https://ror.org/043yd1m08 The Evergreen State College'),
(3463, 'https://ror.org/043yy3r57', 'en', 1, 'https://ror.org/043yy3r57 Central India Institute of Medical Sciences'),
(3464, 'https://ror.org/043z88g18', 'fr', 1, 'https://ror.org/043z88g18 Hôpital Sahloul'),
(3465, 'https://ror.org/043zcrg65', 'en', 1, 'https://ror.org/043zcrg65 Birmingham Accident Hospital'),
(3466, 'https://ror.org/0441cbj57', 'en', 1, 'https://ror.org/0441cbj57 National University of Life and Environmental Sciences of Ukraine Национальный университет биоресурсов и природопользования Національний університет біоресурсів і природокористування України'),
(3467, 'https://ror.org/0443jbw36', 'en', 1, 'https://ror.org/0443jbw36 Bucheon St. Mary''s Hospital'),
(3468, 'https://ror.org/0445ctr76', 'fr', 1, 'https://ror.org/0445ctr76 Hôpital des Diaconesses'),
(3469, 'https://ror.org/0446vnd56', 'en', 1, 'https://ror.org/0446vnd56 Western Kentucky University'),
(3470, 'https://ror.org/0446zdv37', 'en', 1, 'https://ror.org/0446zdv37 Oklahoma Panhandle State University'),
(3471, 'https://ror.org/0447kww10', 'en', 1, 'https://ror.org/0447kww10 University of Miyazaki 宮崎大学'),
(3472, 'https://ror.org/0449kf092', 'en', 1, 'https://ror.org/0449kf092 Prairie View A&M University'),
(3473, 'https://ror.org/044a5dk27', 'en', 1, 'https://ror.org/044a5dk27 Universidad del Verbo Encarnado University of the Incarnate Word Université du verbe incarné'),
(3474, 'https://ror.org/044ed7z69', 'en', 1, 'https://ror.org/044ed7z69 Ministry of Health and Child Welfare'),
(3475, 'https://ror.org/044em4v11', 'en', 1, 'https://ror.org/044em4v11 Tennessee Department of Mental Health and Substance Abuse Services'),
(3476, 'https://ror.org/044f69t13', 'en', 1, 'https://ror.org/044f69t13 Ministry of Natural Resources and Wildlife Ministère de l''Énergie et des Ressources naturelles'),
(3477, 'https://ror.org/044fz2011', 'en', 1, 'https://ror.org/044fz2011 Rhode Island Department of Behavioral Healthcare, Developmental Disabilities and Hospitals'),
(3478, 'https://ror.org/044hb6b32', 'fr', 1, 'https://ror.org/044hb6b32 Hôpital des Enfants'),
(3479, 'https://ror.org/044kjp413', 'en', 1, 'https://ror.org/044kjp413 Severance Hospital 세브란스 병원'),
(3480, 'https://ror.org/044kkfr75', 'sv', 1, 'https://ror.org/044kkfr75 AlbaNova'),
(3481, 'https://ror.org/044p01n12', 'en', 1, 'https://ror.org/044p01n12 Vidant Health'),
(3482, 'https://ror.org/044pc0j16', 'no_lang_code', 1, 'https://ror.org/044pc0j16 Mycologics'),
(3483, 'https://ror.org/044pcn091', 'en', 1, 'https://ror.org/044pcn091 University of Mississippi Medical Center'),
(3484, 'https://ror.org/044pfy487', 'en', 1, 'https://ror.org/044pfy487 Georgia Southwestern State University'),
(3485, 'https://ror.org/044prn184', 'en', 1, 'https://ror.org/044prn184 Holy Family Hospital'),
(3486, 'https://ror.org/044r07286', 'en', 1, 'https://ror.org/044r07286 Ouachita Baptist University'),
(3487, 'https://ror.org/044r51149', 'en', 1, 'https://ror.org/044r51149 Hanoi School Of Public Health Trường Đại học Y tế công cộng'),
(3488, 'https://ror.org/044s9gr80', 'en', 1, 'https://ror.org/044s9gr80 Japanese Red Cross Society, Japan 日本赤十字社'),
(3489, 'https://ror.org/044sjfg03', 'en', 1, 'https://ror.org/044sjfg03 Frere Hospital'),
(3490, 'https://ror.org/044t1gs69', 'es', 1, 'https://ror.org/044t1gs69 Centro de Alta Resolución San Millán'),
(3491, 'https://ror.org/044v7v886', 'en', 1, 'https://ror.org/044v7v886 Advocate Children''s Hospital'),
(3492, 'https://ror.org/044vy1d05', 'en', 1, 'https://ror.org/044vy1d05 Tokushima University 徳島大学'),
(3493, 'https://ror.org/044wvm991', 'no_lang_code', 1, 'https://ror.org/044wvm991 Laniado Hospital'),
(3494, 'https://ror.org/044ww3909', 'en', 1, 'https://ror.org/044ww3909 Boone Hospital Center'),
(3495, 'https://ror.org/044xe8f87', 'en', 1, 'https://ror.org/044xe8f87 Queen Mary''s Hospital Sidcup'),
(3496, 'https://ror.org/044ycg712', 'it', 1, 'https://ror.org/044ycg712 Ospedale dei Bambini Vittore Buzzi'),
(3497, 'https://ror.org/04509n826', 'en', 1, 'https://ror.org/04509n826 Uganda Virus Research Institute'),
(3498, 'https://ror.org/0454vek02', 'no_lang_code', 1, 'https://ror.org/0454vek02 National Society of French Railways Société Nationale des Chemins de Fer Français (France)'),
(3499, 'https://ror.org/04551r843', 'en', 1, 'https://ror.org/04551r843 Ministry of Health'),
(3500, 'https://ror.org/0457avm18', 'en', 1, 'https://ror.org/0457avm18 Bishop Auckland Hospital'),
(3501, 'https://ror.org/0457edg47', 'no_lang_code', 1, 'https://ror.org/0457edg47 HREM Research (Japan) 有限会社 HREM'),
(3502, 'https://ror.org/0457yg222', 'en', 1, 'https://ror.org/0457yg222 Acıbadem Kadıköy Hospital Kadıköy Hastanesi'),
(3503, 'https://ror.org/0457zbj98', 'en', 1, 'https://ror.org/0457zbj98 University of Oklahoma Health Sciences Center'),
(3504, 'https://ror.org/04580ts27', 'en', 1, 'https://ror.org/04580ts27 Geisinger Wyoming Valley Medical Center'),
(3505, 'https://ror.org/045ae7j03', 'pt', 1, 'https://ror.org/045ae7j03 Universidade São Francisco University of San Francisco'),
(3506, 'https://ror.org/045cqy185', 'en', 1, 'https://ror.org/045cqy185 Mamata Medical College'),
(3507, 'https://ror.org/045czjy48', 'en', 1, 'https://ror.org/045czjy48 Cape Fear Valley Medical Center'),
(3508, 'https://ror.org/045d4f586', 'tr', 1, 'https://ror.org/045d4f586 Ulucanlar Göz Eğitim ve Araştırma Hastanesi'),
(3509, 'https://ror.org/045dgap26', 'en', 1, 'https://ror.org/045dgap26 Iowa Methodist Medical Center'),
(3510, 'https://ror.org/045exnh37', 'no_lang_code', 1, 'https://ror.org/045exnh37 Portiuncula Hospital'),
(3511, 'https://ror.org/045g3sx57', 'en', 1, 'https://ror.org/045g3sx57 Armed Forces Capital Hospital 國軍首都病院 국군수도병원'),
(3512, 'https://ror.org/045gmmg53', 'de', 1, 'https://ror.org/045gmmg53 Max Rubner Institut'),
(3513, 'https://ror.org/045h96a50', 'en', 1, 'https://ror.org/045h96a50 Cooperative Research Centre for Polymers'),
(3514, 'https://ror.org/045kb1d14', 'en', 1, 'https://ror.org/045kb1d14 Kyoto Medical Center 京都医療センター'),
(3515, 'https://ror.org/045kfbt16', 'no_lang_code', 1, 'https://ror.org/045kfbt16 Dibrugarh University ডিব্রুগড় বিশ্ববিদ্যালয়'),
(3516, 'https://ror.org/045m9y072', 'en', 1, 'https://ror.org/045m9y072 Moses H Cone Memorial Hospital'),
(3517, 'https://ror.org/045nawc23', 'nl', 1, 'https://ror.org/045nawc23 Tergooi'),
(3518, 'https://ror.org/045nemn19', 'en', 1, 'https://ror.org/045nemn19 Ubon Ratchathani University มหาวิทยาลัยอุบลราชธานี'),
(3519, 'https://ror.org/045r80n66', 'en', 1, 'https://ror.org/045r80n66 Cincinnati VA Medical Center'),
(3520, 'https://ror.org/045r8zm03', 'en', 1, 'https://ror.org/045r8zm03 American Sociological Association'),
(3521, 'https://ror.org/045rcvm30', 'en', 1, 'https://ror.org/045rcvm30 Kentucky Cabinet For Health and Family Services'),
(3522, 'https://ror.org/045rd3583', 'no_lang_code', 1, 'https://ror.org/045rd3583 Koto Hospital 江東病院'),
(3523, 'https://ror.org/045s3rx57', 'en', 1, 'https://ror.org/045s3rx57 Bedford Hospital'),
(3524, 'https://ror.org/045v7ay82', 'en', 1, 'https://ror.org/045v7ay82 Chicago Department of Public Health'),
(3525, 'https://ror.org/045vatr18', 'en', 1, 'https://ror.org/045vatr18 University of Ilorin Teaching Hospital'),
(3526, 'https://ror.org/045wr3278', 'en', 1, 'https://ror.org/045wr3278 Daegu Haany University 대구한의대학교'),
(3527, 'https://ror.org/045x76g34', 'en', 1, 'https://ror.org/045x76g34 McMurry University'),
(3528, 'https://ror.org/045xjv649', 'en', 1, 'https://ror.org/045xjv649 Netaji Subhash Chandra Bose Medical College'),
(3529, 'https://ror.org/0460a5x58', 'en', 1, 'https://ror.org/0460a5x58 Eugenides Hospital ΕΥΓΕΝΙΔΕΙΟ ΘΕΡΑΠΕΥΤΗΡΙΟ'),
(3530, 'https://ror.org/0460fxw51', 'en', 1, 'https://ror.org/0460fxw51 Sacred Heart Hospital'),
(3531, 'https://ror.org/0460s9920', 'en', 1, 'https://ror.org/0460s9920 Kyoto first Red Cross hospital 京都第一赤十字病院'),
(3532, 'https://ror.org/0461cvh40', 'en', 1, 'https://ror.org/0461cvh40 Gangneung–Wonju National University 강릉원주대학교'),
(3533, 'https://ror.org/0463dsf87', 'no_lang_code', 1, 'https://ror.org/0463dsf87 G. Papanikolaou General Hospital'),
(3534, 'https://ror.org/046410650', 'en', 1, 'https://ror.org/046410650 Muskingum University'),
(3535, 'https://ror.org/04661b187', 'en', 1, 'https://ror.org/04661b187 Beppu Medical Center 別府医療センター'),
(3536, 'https://ror.org/0466c1b11', 'en', 1, 'https://ror.org/0466c1b11 Kobe City Medical Center West Hospital 神戸市立医療センター西市民病院'),
(3537, 'https://ror.org/0467j3j44', 'it', 1, 'https://ror.org/0467j3j44 Ospedale di Belcolle'),
(3538, 'https://ror.org/046865y68', 'no_lang_code', 1, 'https://ror.org/046865y68 Hanyang University 한양대학교'),
(3539, 'https://ror.org/046a9q865', 'en', 1, 'https://ror.org/046a9q865 Space Science Institute'),
(3540, 'https://ror.org/046a9t092', 'es', 1, 'https://ror.org/046a9t092 Hospital de Niños de la Santísima Trinidad'),
(3541, 'https://ror.org/046aym564', 'en', 1, 'https://ror.org/046aym564 Lock Haven University'),
(3542, 'https://ror.org/046bk9643', 'en', 1, 'https://ror.org/046bk9643 Government Medical College, Amritsar ਸਰਕਾਰੀ ਮੈਡੀਕਲ ਕਾਲਜ'),
(3543, 'https://ror.org/046c18a90', 'en', 1, 'https://ror.org/046c18a90 Guangzhou Medical University Cancer Hospital 广州医科大学附属肿瘤医院'),
(3544, 'https://ror.org/046db5297', 'en', 1, 'https://ror.org/046db5297 Sioux Valley Hospital'),
(3545, 'https://ror.org/046e0q987', 'en', 1, 'https://ror.org/046e0q987 St Lawrence Hospital'),
(3546, 'https://ror.org/046ekqm80', 'en', 1, 'https://ror.org/046ekqm80 Kentucky Community and Technical College System'),
(3547, 'https://ror.org/046fa4y88', 'en', 1, 'https://ror.org/046fa4y88 The Heart Research Institute'),
(3548, 'https://ror.org/046fm7598', 'en', 1, 'https://ror.org/046fm7598 Gunma University 群馬大学'),
(3549, 'https://ror.org/046gme853', 'en', 1, 'https://ror.org/046gme853 Dandenong Hospital'),
(3550, 'https://ror.org/046h7rx26', 'en', 1, 'https://ror.org/046h7rx26 Tri-Service General Hospital Songshan Branch'),
(3551, 'https://ror.org/046jyn221', 'en', 1, 'https://ror.org/046jyn221 Mayo Hospital'),
(3552, 'https://ror.org/046kb4y45', 'en', 1, 'https://ror.org/046kb4y45 University of Virginia Medical Center'),
(3553, 'https://ror.org/046taf492', 'en', 1, 'https://ror.org/046taf492 St Mary''s Hospital'),
(3554, 'https://ror.org/046vare28', 'de', 1, 'https://ror.org/046vare28 St. Josef-Hospital'),
(3555, 'https://ror.org/046vje122', 'en', 1, 'https://ror.org/046vje122 MRC Biostatistics Unit'),
(3556, 'https://ror.org/046w0kr18', 'it', 1, 'https://ror.org/046w0kr18 Azienda Ospedaliera Ospedale Civile di Legnano'),
(3557, 'https://ror.org/046wwv897', 'es', 1, 'https://ror.org/046wwv897 Hospital Virgen del Camino'),
(3558, 'https://ror.org/046x15q93', 'en', 1, 'https://ror.org/046x15q93 The 309th Hospital of Chinese People''s Liberation Army 中国人民解放军第三〇九医院'),
(3559, 'https://ror.org/046yr0268', 'en', 1, 'https://ror.org/046yr0268 Heartland Regional Medical Center'),
(3560, 'https://ror.org/046yvwt23', 'fr', 1, 'https://ror.org/046yvwt23 Hôpital Principal de Dakar'),
(3561, 'https://ror.org/0470b8t84', 'en', 1, 'https://ror.org/0470b8t84 Capella University'),
(3562, 'https://ror.org/0470men05', 'en', 1, 'https://ror.org/0470men05 Tainan Municipal Hospital 台南市立醫院'),
(3563, 'https://ror.org/04718hx42', 'no_lang_code', 1, 'https://ror.org/04718hx42 Srinakharinwirot University มหาวิทยาลัยศรีนครินทรวิโรฒ'),
(3564, 'https://ror.org/04748z305', 'en', 1, 'https://ror.org/04748z305 Taurida National V.I. Vernadsky University Tawrijski Uniwersytet Narodowy im. Władimira Wiernadskiego Таврический национальный университет имени В. И. Вернадского Таврійський національний університет імені В. І. Вернадського'),
(3565, 'https://ror.org/0475w6974', 'no_lang_code', 1, 'https://ror.org/0475w6974 Kinjo Gakuin University 金城学院大学'),
(3566, 'https://ror.org/04760qd13', 'tr', 1, 'https://ror.org/04760qd13 GATA Haydarpaşa Eğitim Hastanesi'),
(3567, 'https://ror.org/0478ng049', 'en', 1, 'https://ror.org/0478ng049 Roger Williams Medical Center'),
(3568, 'https://ror.org/047asq971', 'en', 1, 'https://ror.org/047asq971 Medical Research Institute of New Zealand'),
(3569, 'https://ror.org/047b5av97', 'nl', 1, 'https://ror.org/047b5av97 Juliana Kinderziekenhuis'),
(3570, 'https://ror.org/047g72407', 'en', 1, 'https://ror.org/047g72407 Eastern Nazarene College'),
(3571, 'https://ror.org/047hsck20', 'en', 1, 'https://ror.org/047hsck20 Hesperia Hospital'),
(3572, 'https://ror.org/047hxsy31', 'en', 1, 'https://ror.org/047hxsy31 Kaiser Permanente Anaheim Medical Center'),
(3573, 'https://ror.org/047k06737', 'en', 1, 'https://ror.org/047k06737 South Dakota Department of Health'),
(3574, 'https://ror.org/047k2at48', 'en', 1, 'https://ror.org/047k2at48 Al-Azhar University – Gaza جامعة الأزهر في غزة'),
(3575, 'https://ror.org/047krn550', 'es', 1, 'https://ror.org/047krn550 Hospital César Milstein'),
(3576, 'https://ror.org/047n0b268', 'en', 1, 'https://ror.org/047n0b268 Aichi Prefectural University 愛知県立大学'),
(3577, 'https://ror.org/047qrb368', 'en', 1, 'https://ror.org/047qrb368 South Carolina State Governor''s Office'),
(3578, 'https://ror.org/047sehh14', 'en', 1, 'https://ror.org/047sehh14 Himeji Red Cross Hospital 姫路赤十字病院'),
(3579, 'https://ror.org/047tjmd17', 'en', 1, 'https://ror.org/047tjmd17 Coastal Area Health Education Center'),
(3580, 'https://ror.org/047v2cv91', 'en', 1, 'https://ror.org/047v2cv91 Maidstone Hospital'),
(3581, 'https://ror.org/047vb2x72', 'no_lang_code', 1, 'https://ror.org/047vb2x72 MATIMOP'),
(3582, 'https://ror.org/047x96110', 'en', 1, 'https://ror.org/047x96110 Johannesburg Hospital'),
(3583, 'https://ror.org/047xgg150', 'tr', 1, 'https://ror.org/047xgg150 Malatya Devlet Hastanesi'),
(3584, 'https://ror.org/047yk3s18', 'en', 1, 'https://ror.org/047yk3s18 Catholic University of America Universidad Católica de América Université catholique d''amérique'),
(3585, 'https://ror.org/047ypwv36', 'en', 1, 'https://ror.org/047ypwv36 Baghdad Medical City مدينة الطب'),
(3586, 'https://ror.org/047z4n946', 'en', 1, 'https://ror.org/047z4n946 Semiconductor Research Corporation'),
(3587, 'https://ror.org/04838xh83', 'es', 1, 'https://ror.org/04838xh83 Empresarios Agrupados'),
(3588, 'https://ror.org/0483mr804', 'en', 1, 'https://ror.org/0483mr804 Carolinas Medical Center'),
(3589, 'https://ror.org/0484pjq71', 'en', 1, 'https://ror.org/0484pjq71 Box Hill Hospital'),
(3590, 'https://ror.org/0488ndr53', 'en', 1, 'https://ror.org/0488ndr53 Hairmyres Hospital'),
(3591, 'https://ror.org/0489f6q08', 'en', 1, 'https://ror.org/0489f6q08 Cardiff and Vale University Health Board'),
(3592, 'https://ror.org/048a96r61', 'en', 1, 'https://ror.org/048a96r61 Glenfield Hospital'),
(3593, 'https://ror.org/048d1b238', 'en', 1, 'https://ror.org/048d1b238 Miami Children''s Hospital'),
(3594, 'https://ror.org/048drzm61', 'en', 1, 'https://ror.org/048drzm61 Frostburg State University Université d''État de frostburg'),
(3595, 'https://ror.org/048f17730', 'en', 1, 'https://ror.org/048f17730 Health Research and Educational Trust'),
(3596, 'https://ror.org/048h7jv87', 'fr', 1, 'https://ror.org/048h7jv87 Centre Hospitalier Universitaire de Cocody'),
(3597, 'https://ror.org/048hj2019', 'en', 1, 'https://ror.org/048hj2019 Joseph Brant Hospital'),
(3598, 'https://ror.org/048j5n646', 'en', 1, 'https://ror.org/048j5n646 National Aerospace University – Kharkiv Aviation Institute Национальный аэрокосмический университет имени Н. Е. Жуковского Національний аерокосмічний університет імені М. Є. Жуковського Харківський авіаційний інститут'),
(3599, 'https://ror.org/048jkwt53', 'en', 1, 'https://ror.org/048jkwt53 American Health Information Management Association'),
(3600, 'https://ror.org/048nj0621', 'en', 1, 'https://ror.org/048nj0621 Fulton County Medical Examiner''s Office'),
(3601, 'https://ror.org/048vjc278', 'en', 1, 'https://ror.org/048vjc278 AdventHealth Celebration'),
(3602, 'https://ror.org/048xpjb02', 'en', 1, 'https://ror.org/048xpjb02 National Association of County and City Health Officials'),
(3603, 'https://ror.org/048zq6v82', 'en', 1, 'https://ror.org/048zq6v82 Children''s Research Hospital 小児研究病院'),
(3604, 'https://ror.org/04929s478', 'en', 1, 'https://ror.org/04929s478 NewYork–Presbyterian Brooklyn Methodist Hospital'),
(3605, 'https://ror.org/0493bmq37', 'no_lang_code', 1, 'https://ror.org/0493bmq37 Fujifilm (Japan) 富士フイルム株式会社'),
(3606, 'https://ror.org/0493caa98', 'no_lang_code', 1, 'https://ror.org/0493caa98 Lallemand (Canada)'),
(3607, 'https://ror.org/0493hgw16', 'en', 1, 'https://ror.org/0493hgw16 National Institute on Minority Health and Health Disparities'),
(3608, 'https://ror.org/0493tt883', 'en', 1, 'https://ror.org/0493tt883 Carl T. Hayden Veterans Affairs Medical Center'),
(3609, 'https://ror.org/0494reh34', 'en', 1, 'https://ror.org/0494reh34 Millsaps College'),
(3610, 'https://ror.org/0495efn48', 'en', 1, 'https://ror.org/0495efn48 Guangxi University for Nationalities 广西民族大学'),
(3611, 'https://ror.org/0495vrm88', 'es', 1, 'https://ror.org/0495vrm88 Hospital Municipal de Badalona'),
(3612, 'https://ror.org/04983z422', 'en', 1, 'https://ror.org/04983z422 Taishan Medical University 泰山医学院'),
(3613, 'https://ror.org/049840423', 'en', 1, 'https://ror.org/049840423 Ministry of Health Министерство здравоохранения Республики Беларусь'),
(3614, 'https://ror.org/049aadf12', 'en', 1, 'https://ror.org/049aadf12 Bezmialem Foundation University Medical Faculty Hospital Bezmiâlem Vakıf Üniversitesi Tıp Fakültesi Hastanesi'),
(3615, 'https://ror.org/049ams583', 'en', 1, 'https://ror.org/049ams583 Northwestern State University Université d''État northwestern'),
(3616, 'https://ror.org/049bdss47', 'en', 1, 'https://ror.org/049bdss47 Joanneum Research Joanneum Research Forschungsgesellschaft mbH'),
(3617, 'https://ror.org/049cbmb74', 'en', 1, 'https://ror.org/049cbmb74 Children''s Hospital of Wisconsin'),
(3618, 'https://ror.org/049dkqr57', 'en', 1, 'https://ror.org/049dkqr57 Ningxia Medical University General Hospital 宁夏医科大学总医院'),
(3619, 'https://ror.org/049hmfa48', 'en', 1, 'https://ror.org/049hmfa48 Henry Mayo Newhall Memorial Hospital'),
(3620, 'https://ror.org/049mpkx27', 'en', 1, 'https://ror.org/049mpkx27 Shriners Hospitals for Children - St. Louis'),
(3621, 'https://ror.org/049pcfs17', 'en', 1, 'https://ror.org/049pcfs17 Indira Gandhi Institute of Medical Sciences'),
(3622, 'https://ror.org/049peqw80', 'en', 1, 'https://ror.org/049peqw80 San Francisco VA Medical Center'),
(3623, 'https://ror.org/049pfb863', 'en', 1, 'https://ror.org/049pfb863 Kent State University Université d''État de kent'),
(3624, 'https://ror.org/049q0vg17', 'en', 1, 'https://ror.org/049q0vg17 Anqing City Hospital'),
(3625, 'https://ror.org/049v7zy31', 'en', 1, 'https://ror.org/049v7zy31 Chiba Rosai Hospital 千葉労災病院'),
(3626, 'https://ror.org/049w1th24', 'en', 1, 'https://ror.org/049w1th24 Doernbecher Children''s Hospital'),
(3627, 'https://ror.org/049wjac82', 'en', 1, 'https://ror.org/049wjac82 Cooper University Hospital'),
(3628, 'https://ror.org/049x01c36', 'en', 1, 'https://ror.org/049x01c36 Shaw University'),
(3629, 'https://ror.org/049xx5c95', 'en', 1, 'https://ror.org/049xx5c95 Sultan Qaboos University Hospital مستشفى جامعة السلطان قابوس'),
(3630, 'https://ror.org/049yc0897', 'en', 1, 'https://ror.org/049yc0897 Winston-Salem State University'),
(3631, 'https://ror.org/049yfnz48', 'en', 1, 'https://ror.org/049yfnz48 Houston Medical Center'),
(3632, 'https://ror.org/049yjqb12', 'en', 1, 'https://ror.org/049yjqb12 Communications and Information Technology Ontario'),
(3633, 'https://ror.org/049zedh07', 'en', 1, 'https://ror.org/049zedh07 Robert Jones and Agnes Hunt Orthopaedic Hospital NHS Trust'),
(3634, 'https://ror.org/049zrh188', 'en', 1, 'https://ror.org/049zrh188 Shanghai Sixth People''s Hospital 上海市第六人民医院'),
(3635, 'https://ror.org/049ztct72', 'en', 1, 'https://ror.org/049ztct72 Medical University Pleven Медицински университет - Плевен'),
(3636, 'https://ror.org/04a105t20', 'en', 1, 'https://ror.org/04a105t20 St. Mary''s Hospital'),
(3637, 'https://ror.org/04a20gb33', 'en', 1, 'https://ror.org/04a20gb33 Hispanic Health Council'),
(3638, 'https://ror.org/04a22qz44', 'en', 1, 'https://ror.org/04a22qz44 Seton Medical Center'),
(3639, 'https://ror.org/04a3akw68', 'no_lang_code', 1, 'https://ror.org/04a3akw68 Airbus (Germany)'),
(3640, 'https://ror.org/04a5hr295', 'es', 1, 'https://ror.org/04a5hr295 Complejo Hospitalario Universitario de Albacete Hospital General Universitario de Albacete'),
(3641, 'https://ror.org/04a6gpn58', 'pt', 1, 'https://ror.org/04a6gpn58 Centro Universitário São Camilo'),
(3642, 'https://ror.org/04aa89262', 'en', 1, 'https://ror.org/04aa89262 Radiolabs'),
(3643, 'https://ror.org/04aaa2n62', 'en', 1, 'https://ror.org/04aaa2n62 Andrews University Universidad Andrews'),
(3644, 'https://ror.org/04aaeds92', 'no_lang_code', 1, 'https://ror.org/04aaeds92 Israel Aerospace Industries (Israel)'),
(3645, 'https://ror.org/04abjq359', 'es', 1, 'https://ror.org/04abjq359 Hospital Ruber Internacional'),
(3646, 'https://ror.org/04abkkn33', 'pt', 1, 'https://ror.org/04abkkn33 Hospital Santo António dos Capuchos'),
(3647, 'https://ror.org/04aj4sh46', 'en', 1, 'https://ror.org/04aj4sh46 Brookings Institution Institución Brookings'),
(3648, 'https://ror.org/04am5a125', 'en', 1, 'https://ror.org/04am5a125 Mount Vernon Hospital'),
(3649, 'https://ror.org/04anjm411', 'en', 1, 'https://ror.org/04anjm411 Instituto Superior D. Dinis'),
(3650, 'https://ror.org/04ap0ew90', 'no_lang_code', 1, 'https://ror.org/04ap0ew90 Hlabisa Hospital'),
(3651, 'https://ror.org/04ar23e02', 'en', 1, 'https://ror.org/04ar23e02 Kingston Hospital'),
(3652, 'https://ror.org/04arkmn57', 'en', 1, 'https://ror.org/04arkmn57 University of Defence Univerzita Obrany'),
(3653, 'https://ror.org/04at0zw32', 'en', 1, 'https://ror.org/04at0zw32 Jichi Medical University Hospital 自治医科大学附属病院'),
(3654, 'https://ror.org/04aw32z04', 'en', 1, 'https://ror.org/04aw32z04 Poriya Medical Center בית חולים ברוך פדה'),
(3655, 'https://ror.org/04ayype77', 'en', 1, 'https://ror.org/04ayype77 Wolfson Medical Center מרכז רפואי וולפסון'),
(3656, 'https://ror.org/04azbjn80', 'en', 1, 'https://ror.org/04azbjn80 Guangdong University of Technology 广东工业大学'),
(3657, 'https://ror.org/04aznd361', 'en', 1, 'https://ror.org/04aznd361 Government Medical College கோழிக்கோடு மருத்துவக் கல்லூரி ഗവൺമെന്റ് മെഡിക്കൽ കോളേജ്, കോഴിക്കോട്'),
(3658, 'https://ror.org/04b0jw528', 'en', 1, 'https://ror.org/04b0jw528 Imakiire General Hospital 公益財団法人昭和会 今給黎総合病院'),
(3659, 'https://ror.org/04b0ry431', 'es', 1, 'https://ror.org/04b0ry431 Hospital General de Elda'),
(3660, 'https://ror.org/04b2fhx54', 'en', 1, 'https://ror.org/04b2fhx54 Seoul Women''s University 서울여자대학교'),
(3661, 'https://ror.org/04b2pvs09', 'en', 1, 'https://ror.org/04b2pvs09 Rashid Hospital مستشفى راشد'),
(3662, 'https://ror.org/04b3jmc64', 'en', 1, 'https://ror.org/04b3jmc64 Social Sciences Innovations'),
(3663, 'https://ror.org/04b4hfb84', 'en', 1, 'https://ror.org/04b4hfb84 Green Pastures Hospital and Rehabilitation Centre'),
(3664, 'https://ror.org/04b787h29', 'en', 1, 'https://ror.org/04b787h29 Santa Barbara Cottage Hospital'),
(3665, 'https://ror.org/04b7w1811', 'en', 1, 'https://ror.org/04b7w1811 Yamaguchi Prefectural University 山口県立大学'),
(3666, 'https://ror.org/04b8y3f13', 'no_lang_code', 1, 'https://ror.org/04b8y3f13 Alexandrovska Hospital университетска болница „Александровска'),
(3667, 'https://ror.org/04ba73c73', 'no_lang_code', 1, 'https://ror.org/04ba73c73 MC3 (United States)'),
(3668, 'https://ror.org/04bcdt432', 'pt', 1, 'https://ror.org/04bcdt432 European University of Lisbon Universidade Europeia'),
(3669, 'https://ror.org/04bf33n91', 'en', 1, 'https://ror.org/04bf33n91 University of Balochistan جامعہ بلوچستان'),
(3670, 'https://ror.org/04bg1hy68', 'en', 1, 'https://ror.org/04bg1hy68 Saint Thomas West Hospital'),
(3671, 'https://ror.org/04bgfm609', 'en', 1, 'https://ror.org/04bgfm609 Stowers Institute for Medical Research'),
(3672, 'https://ror.org/04bgfrg80', 'en', 1, 'https://ror.org/04bgfrg80 Ministry of Public Health Ministère de la Santé Publique du Cameroun'),
(3673, 'https://ror.org/04bghze60', 'tr', 1, 'https://ror.org/04bghze60 Dışkapı Yıldırım Beyazıt Eğitim ve Araştırma Hastanesi'),
(3674, 'https://ror.org/04bm03037', 'en', 1, 'https://ror.org/04bm03037 Genesis Medical Center'),
(3675, 'https://ror.org/04bmgpj29', 'en', 1, 'https://ror.org/04bmgpj29 Walsall Manor Hospital'),
(3676, 'https://ror.org/04bnbsh26', 'no_lang_code', 1, 'https://ror.org/04bnbsh26 Pingtung Christian Hospital 屏東基督教醫院'),
(3677, 'https://ror.org/04bpf7m84', 'pt', 1, 'https://ror.org/04bpf7m84 Escola Superior de Saúde Ribeiro Sanches'),
(3678, 'https://ror.org/04bqfk210', 'en', 1, 'https://ror.org/04bqfk210 Commonwealth Medical College'),
(3679, 'https://ror.org/04bt00m07', 'en', 1, 'https://ror.org/04bt00m07 Mercy General Hospital'),
(3680, 'https://ror.org/04c07bj87', 'en', 1, 'https://ror.org/04c07bj87 Institute of Mental Health'),
(3681, 'https://ror.org/04c0a2j77', 'en', 1, 'https://ror.org/04c0a2j77 Memorial Hospital of Rhode Island'),
(3682, 'https://ror.org/04c0sqe08', 'en', 1, 'https://ror.org/04c0sqe08 Truckee Meadows Community College'),
(3683, 'https://ror.org/04c1d9r22', 'en', 1, 'https://ror.org/04c1d9r22 Services Institute of Medical Sciences سروسز انسٹیٹوٹ آف میڈیکل سائنسز ਸੈਰਵਿਸਜ਼ ਇੰਸਟਿਟਿਊਟ ਆਫ਼ ਮੈਡੀਕਲ ਸਾਈਨਸਜ਼'),
(3684, 'https://ror.org/04c1dx793', 'en', 1, 'https://ror.org/04c1dx793 PSG Institute of Medical Sciences & Research'),
(3685, 'https://ror.org/04c1s4764', 'es', 1, 'https://ror.org/04c1s4764 Hospital Monte Naranco'),
(3686, 'https://ror.org/04c6bry31', 'en', 1, 'https://ror.org/04c6bry31 St. James''s Hospital'),
(3687, 'https://ror.org/04can6445', 'no_lang_code', 1, 'https://ror.org/04can6445 P2D Bioscience (United States)'),
(3688, 'https://ror.org/04cb32210', 'en', 1, 'https://ror.org/04cb32210 Scottish Rite Hospital'),
(3689, 'https://ror.org/04cb4je22', 'en', 1, 'https://ror.org/04cb4je22 Ca'' Foncello Hospital'),
(3690, 'https://ror.org/04cbm7s05', 'es', 1, 'https://ror.org/04cbm7s05 Hospital Universitario Insular de Gran Canaria'),
(3691, 'https://ror.org/04cd75h10', 'en', 1, 'https://ror.org/04cd75h10 Iwate University 岩手大学'),
(3692, 'https://ror.org/04cdn2797', 'en', 1, 'https://ror.org/04cdn2797 Banaras Hindu University Université hindoue de bénarès काशी हिन्दू विश् वविद्यालय কাশী হিন্দু বিশ্ববিদ্যালয় બનારસ હિંદુ યુનિવર્સિટી பனாரசு இந்து பல்கலைக்கழகம் బెనారస్ హిందూ విశ్వవిద్యాలయం ಬನಾರಸ್ ಹಿಂದೂ ವಿಶ್ವವಿದ್ಯಾನಿಲಯ ബനാറസ് ഹിന്ദു യൂണിവേഴ്സിറ്റി'),
(3693, 'https://ror.org/04cepy814', 'es', 1, 'https://ror.org/04cepy814 Hospital Juárez de México'),
(3694, 'https://ror.org/04cewr321', 'en', 1, 'https://ror.org/04cewr321 University of Vermont Medical Center'),
(3695, 'https://ror.org/04cf4ba49', 'da', 1, 'https://ror.org/04cf4ba49 Holbæk Sygehus'),
(3696, 'https://ror.org/04cfbdf66', 'no_lang_code', 1, 'https://ror.org/04cfbdf66 Shanghai GenomePilot Technology (China) 上海佰真生物科技有限公司'),
(3697, 'https://ror.org/04cg70g73', 'en', 1, 'https://ror.org/04cg70g73 Atmospheric and Environmental Research'),
(3698, 'https://ror.org/04cjdzt83', 'en', 1, 'https://ror.org/04cjdzt83 King Abdulaziz Hospital مستشفى الملك عبدالعزي'),
(3699, 'https://ror.org/04cjgh922', 'no_lang_code', 1, 'https://ror.org/04cjgh922 Honeywell (Canada)'),
(3700, 'https://ror.org/04ckgfr29', 'en', 1, 'https://ror.org/04ckgfr29 Sri Manakula Vinayagar Medical College and Hospital'),
(3701, 'https://ror.org/04ckvpk15', 'fr', 1, 'https://ror.org/04ckvpk15 Hôpital Laennec'),
(3702, 'https://ror.org/04cnfrn26', 'en', 1, 'https://ror.org/04cnfrn26 University of the Arts London'),
(3703, 'https://ror.org/04cpf2p55', 'en', 1, 'https://ror.org/04cpf2p55 Bess Kaiser Hospital'),
(3704, 'https://ror.org/04cqs5j56', 'en', 1, 'https://ror.org/04cqs5j56 Southern Illinois University Edwardsville'),
(3705, 'https://ror.org/04crdae34', 'en', 1, 'https://ror.org/04crdae34 Mahatma Gandhi Institute of Medical Sciences महात्मा गांधी वैद्यकीय संस्था'),
(3706, 'https://ror.org/04cs55d24', 'no_lang_code', 1, 'https://ror.org/04cs55d24 Charoenkrung Pracharak Hospital โรงพยาบาลเจริญกรุงประชารักษ์'),
(3707, 'https://ror.org/04ctp9859', 'it', 1, 'https://ror.org/04ctp9859 Ospedale Maria Vittoria'),
(3708, 'https://ror.org/04cwap208', 'en', 1, 'https://ror.org/04cwap208 Inner Mongolia University for Nationalities'),
(3709, 'https://ror.org/04cxm4j25', 'en', 1, 'https://ror.org/04cxm4j25 Australian Catholic University'),
(3710, 'https://ror.org/04cy4z909', 'es', 1, 'https://ror.org/04cy4z909 Hospital de Mataró'),
(3711, 'https://ror.org/04cyk2a69', 'en', 1, 'https://ror.org/04cyk2a69 General de Jesus College'),
(3712, 'https://ror.org/04czxss33', 'en', 1, 'https://ror.org/04czxss33 Dubai Hospital مستشفى دبـــي'),
(3713, 'https://ror.org/04d0szq68', 'en', 1, 'https://ror.org/04d0szq68 Shaare Zedek Medical Center מרכז רפואי שערי צדק'),
(3714, 'https://ror.org/04d45ra64', 'fr', 1, 'https://ror.org/04d45ra64 Hôpital du Hasenrain'),
(3715, 'https://ror.org/04d4dxm04', 'fr', 1, 'https://ror.org/04d4dxm04 Société de Mathématiques Appliquées et de Sciences Humaines'),
(3716, 'https://ror.org/04d52ej85', 'en', 1, 'https://ror.org/04d52ej85 Lawrence Technological University Université technologique lawrence'),
(3717, 'https://ror.org/04d5k5771', 'en', 1, 'https://ror.org/04d5k5771 European Institute for Energy Research Europäisches Institut für Energieforschung'),
(3718, 'https://ror.org/04d5w7479', 'en', 1, 'https://ror.org/04d5w7479 Aurora Health Care'),
(3719, 'https://ror.org/04d6eav07', 'en', 1, 'https://ror.org/04d6eav07 Red Cross War Memorial Children''s Hospital'),
(3720, 'https://ror.org/04d7e4m76', 'en', 1, 'https://ror.org/04d7e4m76 I-Shou University'),
(3721, 'https://ror.org/04d7es448', 'it', 1, 'https://ror.org/04d7es448 Azienda Ospedaliera Universitaria "San Martino", Ospedale Policlinico San Martino'),
(3722, 'https://ror.org/04d7ez939', 'en', 1, 'https://ror.org/04d7ez939 VA Eastern Colorado Health Care System'),
(3723, 'https://ror.org/04d8ymc03', 'en', 1, 'https://ror.org/04d8ymc03 Doai Memorial Hospital 同愛記念病院'),
(3724, 'https://ror.org/04d9g9604', 'en', 1, 'https://ror.org/04d9g9604 Sankt Hans Hospital'),
(3725, 'https://ror.org/04dc8es52', 'de', 1, 'https://ror.org/04dc8es52 Klinik Donaustauf'),
(3726, 'https://ror.org/04dd5bw95', 'en', 1, 'https://ror.org/04dd5bw95 Fujisawa City Hospital 藤沢市民病院'),
(3727, 'https://ror.org/04df9p911', 'no_lang_code', 1, 'https://ror.org/04df9p911 Biorem Technologies (Canada)'),
(3728, 'https://ror.org/04dhg0348', 'en', 1, 'https://ror.org/04dhg0348 Heidelberg Repatriation Hospital'),
(3729, 'https://ror.org/04djj4v98', 'es', 1, 'https://ror.org/04djj4v98 Buenos Aires British Hospital Hospital Británico de Buenos Aires'),
(3730, 'https://ror.org/04dm1cm79', 'de', 1, 'https://ror.org/04dm1cm79 Universitätsmedizin Rostock'),
(3731, 'https://ror.org/04dms0022', 'fr', 1, 'https://ror.org/04dms0022 Hôpital de la Tour'),
(3732, 'https://ror.org/04dngzj56', 'en', 1, 'https://ror.org/04dngzj56 American University of Armenia Հայաստանի ամերիկյան համալսարան'),
(3733, 'https://ror.org/04dns5t03', 'en', 1, 'https://ror.org/04dns5t03 Brighton General Hospital'),
(3734, 'https://ror.org/04dnsc767', 'en', 1, 'https://ror.org/04dnsc767 Burke Rehabilitation Hospital'),
(3735, 'https://ror.org/04dp43p74', 'en', 1, 'https://ror.org/04dp43p74 Hangang Sacred Heart Hospital 한강 성심 병원'),
(3736, 'https://ror.org/04drvxt59', 'en', 1, 'https://ror.org/04drvxt59 Beth Israel Deaconess Medical Center'),
(3737, 'https://ror.org/04ds03q08', 'no_lang_code', 1, 'https://ror.org/04ds03q08 Mita Hospital 国際医療福祉大学三田病院'),
(3738, 'https://ror.org/04dt6a039', 'en', 1, 'https://ror.org/04dt6a039 Military Medical Academy Војномедицинска академија'),
(3739, 'https://ror.org/04dw1bf40', 'en', 1, 'https://ror.org/04dw1bf40 Mount Desert Island Biological Laboratory'),
(3740, 'https://ror.org/04dwjqq87', 'en', 1, 'https://ror.org/04dwjqq87 Tanglewood Research'),
(3741, 'https://ror.org/04dx82x73', 'en', 1, 'https://ror.org/04dx82x73 Nanning Normal University 南宁师范大学'),
(3742, 'https://ror.org/04dzhx486', 'en', 1, 'https://ror.org/04dzhx486 Exeter Hospital'),
(3743, 'https://ror.org/04dzpzw79', 'en', 1, 'https://ror.org/04dzpzw79 National Health Promotion Associates'),
(3744, 'https://ror.org/04dzvew28', 'en', 1, 'https://ror.org/04dzvew28 Hackensack University Medical Center Mountainside'),
(3745, 'https://ror.org/04dzvks42', 'en', 1, 'https://ror.org/04dzvks42 XinHua Hospital 上海交通大学医学院附属新华医院'),
(3746, 'https://ror.org/04e0j1059', 'en', 1, 'https://ror.org/04e0j1059 Bethune-Cookman University'),
(3747, 'https://ror.org/04e1w6923', 'fr', 1, 'https://ror.org/04e1w6923 Hôpital d''Hautepierre'),
(3748, 'https://ror.org/04e2jep17', 'en', 1, 'https://ror.org/04e2jep17 Croydon University Hospital'),
(3749, 'https://ror.org/04e2x2229', 'en', 1, 'https://ror.org/04e2x2229 Lala Lajpat Rai Memorial Medical College'),
(3750, 'https://ror.org/04e4abg78', 'no_lang_code', 1, 'https://ror.org/04e4abg78 Nantan General Hospital 公立南丹病院'),
(3751, 'https://ror.org/04e5j7m81', 'en', 1, 'https://ror.org/04e5j7m81 American Society of Mechanical Engineers'),
(3752, 'https://ror.org/04e79zk25', 'en', 1, 'https://ror.org/04e79zk25 Institute for Medical Informatics and Biostatistics'),
(3753, 'https://ror.org/04e7bpp71', 'no_lang_code', 1, 'https://ror.org/04e7bpp71 King Fahad Hospital Hufūf'),
(3754, 'https://ror.org/04e857469', 'it', 1, 'https://ror.org/04e857469 Ospedale Regina Margherita Regina Margherita hospital'),
(3755, 'https://ror.org/04e8jbs38', 'en', 1, 'https://ror.org/04e8jbs38 Helmut Schmidt University Helmut-Schmidt-Universität'),
(3756, 'https://ror.org/04e8mq383', 'en', 1, 'https://ror.org/04e8mq383 Hyogo Prefectural Amagasaki General Medical Center 兵庫県立尼崎総合医療センター'),
(3757, 'https://ror.org/04edns687', 'en', 1, 'https://ror.org/04edns687 Northeastern Illinois University'),
(3758, 'https://ror.org/04ejkkg63', 'en', 1, 'https://ror.org/04ejkkg63 Ecologic Institute'),
(3759, 'https://ror.org/04epb4p87', 'en', 1, 'https://ror.org/04epb4p87 Zhejiang Chinese Medical University 浙江中医药大学'),
(3760, 'https://ror.org/04esata81', 'en', 1, 'https://ror.org/04esata81 European Science Foundation'),
(3761, 'https://ror.org/04esb6v42', 'en', 1, 'https://ror.org/04esb6v42 Imam Hossein University دانشگاه امام حسین'),
(3762, 'https://ror.org/04esegk75', 'en', 1, 'https://ror.org/04esegk75 Allina Health'),
(3763, 'https://ror.org/04esvpn06', 'en', 1, 'https://ror.org/04esvpn06 Université d''État de virginie Virginia State University'),
(3764, 'https://ror.org/04etaja30', 'no_lang_code', 1, 'https://ror.org/04etaja30 Beijing YouAn Hospital 北京佑安医院'),
(3765, 'https://ror.org/04evcxq23', 'it', 1, 'https://ror.org/04evcxq23 Consorzio Nazionale Interuniversitario per i Trasporti e la Logistica'),
(3766, 'https://ror.org/04evw4v13', 'pt', 1, 'https://ror.org/04evw4v13 Instituto Superior de Paços de Brandão'),
(3767, 'https://ror.org/04ezg6d83', 'en', 1, 'https://ror.org/04ezg6d83 Toyohashi University of Technology 豊橋技術科学大学'),
(3768, 'https://ror.org/04f3vmh71', 'tr', 1, 'https://ror.org/04f3vmh71 Medeniyet Üniversitesi Göztepe Eğitim ve Araştırma Hastanesi'),
(3769, 'https://ror.org/04f4syj68', 'it', 1, 'https://ror.org/04f4syj68 Polo Universitario Città di Prato'),
(3770, 'https://ror.org/04f558b63', 'pt', 1, 'https://ror.org/04f558b63 Centro Universitário Filadélfia'),
(3771, 'https://ror.org/04f6p2t28', 'en', 1, 'https://ror.org/04f6p2t28 Hospital Labbafinejad بیمارستان لبافی‌نژ'),
(3772, 'https://ror.org/04f761z39', 'pt', 1, 'https://ror.org/04f761z39 Instituto Superior da Maia'),
(3773, 'https://ror.org/04f812k67', 'en', 1, 'https://ror.org/04f812k67 Palo Alto University'),
(3774, 'https://ror.org/04f86t017', 'es', 1, 'https://ror.org/04f86t017 Hospital de Especialidades'),
(3775, 'https://ror.org/04f8gc808', 'no_lang_code', 1, 'https://ror.org/04f8gc808 Ganga Hospital'),
(3776, 'https://ror.org/04f90ax67', 'en', 1, 'https://ror.org/04f90ax67 Ministry of Health and Population وزارة الصحة - الصفحة الرئيسية'),
(3777, 'https://ror.org/04faw9m73', 'sv', 1, 'https://ror.org/04faw9m73 Hallands sjukhus Halmstad'),
(3778, 'https://ror.org/04fbnx371', 'en', 1, 'https://ror.org/04fbnx371 West Virginia University Hospitals'),
(3779, 'https://ror.org/04fc1dc24', 'en', 1, 'https://ror.org/04fc1dc24 Dorset County Hospital'),
(3780, 'https://ror.org/04fdkjq44', 'en', 1, 'https://ror.org/04fdkjq44 Methodist University Hospital'),
(3781, 'https://ror.org/04fkbqt11', 'ro', 1, 'https://ror.org/04fkbqt11 Hospital Colentina Spitalul Clinic Colentina'),
(3782, 'https://ror.org/04fp78s33', 'en', 1, 'https://ror.org/04fp78s33 Hunter Holmes McGuire VA Medical Center'),
(3783, 'https://ror.org/04fp9fm22', 'en', 1, 'https://ror.org/04fp9fm22 National University Hospital'),
(3784, 'https://ror.org/04fpj6846', 'en', 1, 'https://ror.org/04fpj6846 Iowa Medical Society'),
(3785, 'https://ror.org/04frzv033', 'en', 1, 'https://ror.org/04frzv033 Institute of Medical Biology'),
(3786, 'https://ror.org/04fs4yy09', 'en', 1, 'https://ror.org/04fs4yy09 Lakewood Regional Medical Center'),
(3787, 'https://ror.org/04fv66053', 'en', 1, 'https://ror.org/04fv66053 American Health Care Association'),
(3788, 'https://ror.org/04fw3kw37', 'en', 1, 'https://ror.org/04fw3kw37 Shri Maharaja Hari Singh Hospital'),
(3789, 'https://ror.org/04fwa4t58', 'en', 1, 'https://ror.org/04fwa4t58 Harefield Hospital'),
(3790, 'https://ror.org/04fwyqr44', 'en', 1, 'https://ror.org/04fwyqr44 International Goodwill Hospital 国際親善総合病院'),
(3791, 'https://ror.org/04fxknd68', 'en', 1, 'https://ror.org/04fxknd68 Catholic University of Daegu 대구가톨릭대학교'),
(3792, 'https://ror.org/04fyasj17', 'en', 1, 'https://ror.org/04fyasj17 Nagoya Central Hospital 名古屋セントラル病院'),
(3793, 'https://ror.org/04fybn584', 'en', 1, 'https://ror.org/04fybn584 Universidad del Cauca University of Cauca'),
(3794, 'https://ror.org/04fz99q08', 'en', 1, 'https://ror.org/04fz99q08 Minami Wakayama Medical Center 国立病院機構南和歌山医療センタ'),
(3795, 'https://ror.org/04g0bt697', 'en', 1, 'https://ror.org/04g0bt697 MultiCare Health System'),
(3796, 'https://ror.org/04g27v387', 'ca', 1, 'https://ror.org/04g27v387 Hospital Universitari de Girona Doctor Josep Trueta Residencia Sanitaria de la Seguridad Social de Gerona'),
(3797, 'https://ror.org/04g2hhm55', 'en', 1, 'https://ror.org/04g2hhm55 Birmingham General Hospital'),
(3798, 'https://ror.org/04g33m791', 'en', 1, 'https://ror.org/04g33m791 Norrköping Hospital'),
(3799, 'https://ror.org/04g3dn724', 'en', 1, 'https://ror.org/04g3dn724 Massachusetts Eye and Ear Infirmary'),
(3800, 'https://ror.org/04g3stk86', 'sv', 1, 'https://ror.org/04g3stk86 Länssjukhuset i Kalmar'),
(3801, 'https://ror.org/04g3z9997', 'en', 1, 'https://ror.org/04g3z9997 Kanchi Kamakoti CHILDS Trust Hospital'),
(3802, 'https://ror.org/04g43x563', 'en', 1, 'https://ror.org/04g43x563 Minnesota Department of Health'),
(3803, 'https://ror.org/04g525b43', 'en', 1, 'https://ror.org/04g525b43 First Pavlov State Medical University of St. Petersburg Первый Санкт-Петербургский государственный медицинский университет имени академика И. П. Павлова'),
(3804, 'https://ror.org/04g7tnd56', 'en', 1, 'https://ror.org/04g7tnd56 North Maharashtra University उत्तर महाराष्ट्र विश्वविद्यालय'),
(3805, 'https://ror.org/04g8hwy69', 'en', 1, 'https://ror.org/04g8hwy69 Holy Cross Hospital'),
(3806, 'https://ror.org/04g9xj393', 'en', 1, 'https://ror.org/04g9xj393 Legacy Health'),
(3807, 'https://ror.org/04gbhgc79', 'en', 1, 'https://ror.org/04gbhgc79 Hôpital Général de Montréal Montreal General Hospital'),
(3808, 'https://ror.org/04gd4wn47', 'en', 1, 'https://ror.org/04gd4wn47 Arabian Gulf University جامعة الخليج العربي دانشگاه خلیج عربی'),
(3809, 'https://ror.org/04gfeaw48', 'en', 1, 'https://ror.org/04gfeaw48 Southern Utah University'),
(3810, 'https://ror.org/04gh26240', 'en', 1, 'https://ror.org/04gh26240 Mount Gould Hospital'),
(3811, 'https://ror.org/04ghtpd15', 'en', 1, 'https://ror.org/04ghtpd15 Institute of Child Health ινστιτούτο υγείας του παιδιού');
INSERT INTO `rors` VALUES
(3812, 'https://ror.org/04gjkkf30', 'en', 1, 'https://ror.org/04gjkkf30 Banner Sun Health Research Institute'),
(3813, 'https://ror.org/04gknbs13', 'en', 1, 'https://ror.org/04gknbs13 National Chiayi University 國立嘉義大學'),
(3814, 'https://ror.org/04gmtmm57', 'no_lang_code', 1, 'https://ror.org/04gmtmm57 Misgav Ladach מִשְׂגָּב לַדָּךְ'),
(3815, 'https://ror.org/04gnvnd68', 'en', 1, 'https://ror.org/04gnvnd68 AnMed Health Medical Center'),
(3816, 'https://ror.org/04gpcyk21', 'en', 1, 'https://ror.org/04gpcyk21 Japan Women''s University 日本女子大学'),
(3817, 'https://ror.org/04gpfvy81', 'nl', 1, 'https://ror.org/04gpfvy81 Elisabeth-TweeSteden Ziekenhuis'),
(3818, 'https://ror.org/04gqx4x78', 'it', 1, 'https://ror.org/04gqx4x78 Campus Bio-Medico University Università Campus Bio-Medico'),
(3819, 'https://ror.org/04gr4mh63', 'en', 1, 'https://ror.org/04gr4mh63 Chung-Ang University Hospital 중앙대학교의료원'),
(3820, 'https://ror.org/04grcvp20', 'no_lang_code', 1, 'https://ror.org/04grcvp20 Ingenieria Y Economia Del Transporte'),
(3821, 'https://ror.org/04gs6xd08', 'en', 1, 'https://ror.org/04gs6xd08 Sjællands universitetshospital, Køge Zealand University Hospital Køge'),
(3822, 'https://ror.org/04gt4je81', 'sv', 1, 'https://ror.org/04gt4je81 Lasarettet i Motala'),
(3823, 'https://ror.org/04gw05r18', 'fr', 1, 'https://ror.org/04gw05r18 Centre Hospitalier Victor Dupouy'),
(3824, 'https://ror.org/04gzbav43', 'en', 1, 'https://ror.org/04gzbav43 Amirkabir University of Technology دانشگاه صنعتی امیرکبیر'),
(3825, 'https://ror.org/04h08p482', 'no_lang_code', 1, 'https://ror.org/04h08p482 Rolls-Royce (United Kingdom)'),
(3826, 'https://ror.org/04h3ct388', 'en', 1, 'https://ror.org/04h3ct388 Imo State University Teaching Hospital'),
(3827, 'https://ror.org/04h687w28', 'no_lang_code', 1, 'https://ror.org/04h687w28 Khalili Hospital بیمارستان خلیلی'),
(3828, 'https://ror.org/04h74qb21', 'en', 1, 'https://ror.org/04h74qb21 Pilgrim Hospital'),
(3829, 'https://ror.org/04h7nbn38', 'en', 1, 'https://ror.org/04h7nbn38 Canberra Hospital'),
(3830, 'https://ror.org/04h8jph19', 'en', 1, 'https://ror.org/04h8jph19 Soon Chun Hyang University Cheonan Hospital 순천향대학교 천안병원'),
(3831, 'https://ror.org/04hahwc19', 'en', 1, 'https://ror.org/04hahwc19 Meiji University of Integrative Medicine 明治国際医療大学'),
(3832, 'https://ror.org/04hbpw172', 'en', 1, 'https://ror.org/04hbpw172 Punjab Medical College'),
(3833, 'https://ror.org/04hcg0q34', 'en', 1, 'https://ror.org/04hcg0q34 Alameda Health System'),
(3834, 'https://ror.org/04hgm3062', 'en', 1, 'https://ror.org/04hgm3062 Iowa City VA Health Care System'),
(3835, 'https://ror.org/04hjf5k52', 'no_lang_code', 1, 'https://ror.org/04hjf5k52 Pivotal Labs'),
(3836, 'https://ror.org/04hjn8p44', 'en', 1, 'https://ror.org/04hjn8p44 Staten Island University Hospital'),
(3837, 'https://ror.org/04hk86037', 'en', 1, 'https://ror.org/04hk86037 Universidad de Matanzas "Camilo Cienfuegos" University of Matanzas, University of Matanzas "Camilo Cienfuegos"'),
(3838, 'https://ror.org/04hnqrf16', 'en', 1, 'https://ror.org/04hnqrf16 National Center of Public Health and Analyses Национален център по обществено здраве и анализи'),
(3839, 'https://ror.org/04hnrs676', 'pt', 1, 'https://ror.org/04hnrs676 Universidade de Mogi das Cruzes University of Mogi das Cruzes'),
(3840, 'https://ror.org/04hp86393', 'no_lang_code', 1, 'https://ror.org/04hp86393 National Grid (United Kingdom)'),
(3841, 'https://ror.org/04hsvgn43', 'en', 1, 'https://ror.org/04hsvgn43 Rangaraya Medical College'),
(3842, 'https://ror.org/04hym7e04', 'en', 1, 'https://ror.org/04hym7e04 Al-Quds University אוניברסיטת אל-קודס جامعة القدس'),
(3843, 'https://ror.org/04hzm4679', 'en', 1, 'https://ror.org/04hzm4679 National Institute for Occupational Health'),
(3844, 'https://ror.org/04hzs7842', 'fr', 1, 'https://ror.org/04hzs7842 Centre Hospitalier Edmond Garcin'),
(3845, 'https://ror.org/04hzsfs96', 'en', 1, 'https://ror.org/04hzsfs96 Hôpital adventiste porter Porter Adventist Hospital'),
(3846, 'https://ror.org/04j0szy54', 'fr', 1, 'https://ror.org/04j0szy54 Hôpital Boucicaut'),
(3847, 'https://ror.org/04j19h351', 'en', 1, 'https://ror.org/04j19h351 Chase Farm Hospital'),
(3848, 'https://ror.org/04j1w0q97', 'en', 1, 'https://ror.org/04j1w0q97 Islamic University ইসলামী বিশ্ববিদ্যালয়'),
(3849, 'https://ror.org/04j2cfe69', 'en', 1, 'https://ror.org/04j2cfe69 Tianjin Medical University Eye Hospital'),
(3850, 'https://ror.org/04j339g17', 'en', 1, 'https://ror.org/04j339g17 Tokyo Teishin Hospital 東京逓信病院'),
(3851, 'https://ror.org/04j36h363', 'en', 1, 'https://ror.org/04j36h363 Children''s Hospital & Medical Center'),
(3852, 'https://ror.org/04j3vr751', 'en', 1, 'https://ror.org/04j3vr751 Hunan University of Technology'),
(3853, 'https://ror.org/04j572391', 'en', 1, 'https://ror.org/04j572391 University Park Pathology Associates'),
(3854, 'https://ror.org/04j6ay666', 'en', 1, 'https://ror.org/04j6ay666 Akashi Medical Center 明石医療センター'),
(3855, 'https://ror.org/04j6dw954', 'en', 1, 'https://ror.org/04j6dw954 Have Dreams'),
(3856, 'https://ror.org/04j71m034', 'en', 1, 'https://ror.org/04j71m034 Saint Francis Health System'),
(3857, 'https://ror.org/04j7rhg40', 'no_lang_code', 1, 'https://ror.org/04j7rhg40 Prime Focus World'),
(3858, 'https://ror.org/04j9bvy88', 'en', 1, 'https://ror.org/04j9bvy88 BG University Hospital Bergmannsheil Bochum BG Universitätsklinikum Bergmannsheil Bochum'),
(3859, 'https://ror.org/04jc0r179', 'no_lang_code', 1, 'https://ror.org/04jc0r179 UK Coal'),
(3860, 'https://ror.org/04jca3284', 'es', 1, 'https://ror.org/04jca3284 Hospital Metropolitano'),
(3861, 'https://ror.org/04jdq2t93', 'en', 1, 'https://ror.org/04jdq2t93 Aaron Diamond AIDS Research Center'),
(3862, 'https://ror.org/04je6yw13', 'en', 1, 'https://ror.org/04je6yw13 Cheikh Anta Diop University Université Cheikh Anta Diop'),
(3863, 'https://ror.org/04jer6b34', 'en', 1, 'https://ror.org/04jer6b34 Washington State Board of Education'),
(3864, 'https://ror.org/04jfnqt61', 'no_lang_code', 1, 'https://ror.org/04jfnqt61 Western Forest Products'),
(3865, 'https://ror.org/04jjn8965', 'en', 1, 'https://ror.org/04jjn8965 Simpson College'),
(3866, 'https://ror.org/04jkbnw46', 'en', 1, 'https://ror.org/04jkbnw46 Center for Infectious Disease Research'),
(3867, 'https://ror.org/04jkk6t02', 'no_lang_code', 1, 'https://ror.org/04jkk6t02 IQuum (United States)'),
(3868, 'https://ror.org/04jq4p608', 'pt', 1, 'https://ror.org/04jq4p608 Hospital Garcia de Orta'),
(3869, 'https://ror.org/04jq72f57', 'en', 1, 'https://ror.org/04jq72f57 Royal Darwin Hospital'),
(3870, 'https://ror.org/04jqj7p05', 'no_lang_code', 1, 'https://ror.org/04jqj7p05 Hitotsubashi University 一橋大学'),
(3871, 'https://ror.org/04js17g72', 'en', 1, 'https://ror.org/04js17g72 Ifakara Health Institute'),
(3872, 'https://ror.org/04jwmdy30', 'no_lang_code', 1, 'https://ror.org/04jwmdy30 XMG Studio (Canada)'),
(3873, 'https://ror.org/04jx7r642', 'no_lang_code', 1, 'https://ror.org/04jx7r642 Process Research Ortech (Canada)'),
(3874, 'https://ror.org/04jxcef68', 'en', 1, 'https://ror.org/04jxcef68 Royal Edinburgh Hospital'),
(3875, 'https://ror.org/04jy8zw69', 'en', 1, 'https://ror.org/04jy8zw69 Yehuda Abarbanel Mental Health Center אברבנאל - המרכז לבריאות הנפש'),
(3876, 'https://ror.org/04jyxq429', 'en', 1, 'https://ror.org/04jyxq429 Center for Research and Telecommunication Experimentation for Networked Communities'),
(3877, 'https://ror.org/04jztag35', 'en', 1, 'https://ror.org/04jztag35 Peking Union Medical College Hospital 北京协和医院'),
(3878, 'https://ror.org/04k093t90', 'en', 1, 'https://ror.org/04k093t90 Chaudhary Sarwan Kumar Himachal Pradesh Krishi Vishvavidyalaya'),
(3879, 'https://ror.org/04k0yqc48', 'en', 1, 'https://ror.org/04k0yqc48 Buskerud University College'),
(3880, 'https://ror.org/04k1cm432', 'en', 1, 'https://ror.org/04k1cm432 Saint Luke''s Hospital'),
(3881, 'https://ror.org/04k1f6611', 'en', 1, 'https://ror.org/04k1f6611 Maccabi Health Care Services מכבי שירותי בריאות‎'),
(3882, 'https://ror.org/04k26n974', 'pt', 1, 'https://ror.org/04k26n974 Instituto Superior Politécnico Gaya'),
(3883, 'https://ror.org/04k3jt835', 'en', 1, 'https://ror.org/04k3jt835 Ronald Reagan UCLA Medical Center'),
(3884, 'https://ror.org/04k4h9k07', 'en', 1, 'https://ror.org/04k4h9k07 Scripps Mercy Hospital'),
(3885, 'https://ror.org/04k6zqn86', 'en', 1, 'https://ror.org/04k6zqn86 Beijing Hua Xin Hospital 北京华信医院'),
(3886, 'https://ror.org/04k820v98', 'en', 1, 'https://ror.org/04k820v98 Saudi Aramco Medical Services Organization'),
(3887, 'https://ror.org/04k8zab17', 'en', 1, 'https://ror.org/04k8zab17 Alliant International University'),
(3888, 'https://ror.org/04kbvfy96', 'es', 1, 'https://ror.org/04kbvfy96 Hospital de Sagunto'),
(3889, 'https://ror.org/04kg3w865', 'no_lang_code', 1, 'https://ror.org/04kg3w865 Phylonix (United States)'),
(3890, 'https://ror.org/04kgg1090', 'en', 1, 'https://ror.org/04kgg1090 Pusan National University Yangsan Hospital 양산부산대학교병원'),
(3891, 'https://ror.org/04kgqpx54', 'no_lang_code', 1, 'https://ror.org/04kgqpx54 Voestalpine (Austria)'),
(3892, 'https://ror.org/04kjpp702', 'en', 1, 'https://ror.org/04kjpp702 Kaiser Permanente Santa Rosa Medical Center'),
(3893, 'https://ror.org/04kk13p96', 'en', 1, 'https://ror.org/04kk13p96 Reading Hospital'),
(3894, 'https://ror.org/04knhza04', 'en', 1, 'https://ror.org/04knhza04 KCMC Kilimanjaro Christian Medical Centre'),
(3895, 'https://ror.org/04kt0yt69', 'tr', 1, 'https://ror.org/04kt0yt69 Etimesgut Asker Hastanesi'),
(3896, 'https://ror.org/04kte4472', 'no_lang_code', 1, 'https://ror.org/04kte4472 Materials and Electrochemical Research (United States)'),
(3897, 'https://ror.org/04kvh1910', 'en', 1, 'https://ror.org/04kvh1910 Resurrection Health Care'),
(3898, 'https://ror.org/04ky9dq80', 'no_lang_code', 1, 'https://ror.org/04ky9dq80 Vaexjoe Energi Ab'),
(3899, 'https://ror.org/04ky9n739', 'no_lang_code', 1, 'https://ror.org/04ky9n739 Beijing Chuiyangliu Hospital 北京市垂杨柳医院'),
(3900, 'https://ror.org/04kzbp858', 'no_lang_code', 1, 'https://ror.org/04kzbp858 Agropur cooperative'),
(3901, 'https://ror.org/04m0kdq23', 'it', 1, 'https://ror.org/04m0kdq23 Ospedale Sant''Anna'),
(3902, 'https://ror.org/04m2hyg08', 'en', 1, 'https://ror.org/04m2hyg08 Maryland Science Center'),
(3903, 'https://ror.org/04m3xd186', 'pt', 1, 'https://ror.org/04m3xd186 Centro Universitário de Belo Horizonte, Centro Universitário de belo Horizonte'),
(3904, 'https://ror.org/04m61mj84', 'fr', 1, 'https://ror.org/04m61mj84 Centre Hospitalier Universitaire Henri-Mondor'),
(3905, 'https://ror.org/04m88de33', 'en', 1, 'https://ror.org/04m88de33 Froedtert Menomonee Falls Hospital'),
(3906, 'https://ror.org/04m8b1e20', 'en', 1, 'https://ror.org/04m8b1e20 Georgian Court University'),
(3907, 'https://ror.org/04m8bh175', 'no_lang_code', 1, 'https://ror.org/04m8bh175 Advanced Fuel Research (United States)'),
(3908, 'https://ror.org/04m8z4n60', 'en', 1, 'https://ror.org/04m8z4n60 Harris Health System'),
(3909, 'https://ror.org/04mat8m15', 'fi', 1, 'https://ror.org/04mat8m15 Reumasäätiön sairaala'),
(3910, 'https://ror.org/04mc30s43', 'no_lang_code', 1, 'https://ror.org/04mc30s43 Olivieri Foods'),
(3911, 'https://ror.org/04mc4md34', 'tr', 1, 'https://ror.org/04mc4md34 Rize Devlet Hastanesi'),
(3912, 'https://ror.org/04mc82d47', 'en', 1, 'https://ror.org/04mc82d47 Scientific Committee On Oceanic Research'),
(3913, 'https://ror.org/04mdycw91', 'no_lang_code', 1, 'https://ror.org/04mdycw91 Eurofins (France)'),
(3914, 'https://ror.org/04mf6js28', 'en', 1, 'https://ror.org/04mf6js28 Credit Valley Hospital'),
(3915, 'https://ror.org/04mgjym08', 'en', 1, 'https://ror.org/04mgjym08 Institute of Occupational Medicine and Environmental Health Instytut Medycyny Pracy i Zdrowia Środowiskowego'),
(3916, 'https://ror.org/04mh52z70', 'en', 1, 'https://ror.org/04mh52z70 Observatorio Astrofísico Smithsonian Smithsonian Astrophysical Observatory'),
(3917, 'https://ror.org/04mhx6838', 'en', 1, 'https://ror.org/04mhx6838 National Institute on Deafness and Other Communication Disorders'),
(3918, 'https://ror.org/04mkpd147', 'es', 1, 'https://ror.org/04mkpd147 Red Universitaria Nacional'),
(3919, 'https://ror.org/04mm17p39', 'en', 1, 'https://ror.org/04mm17p39 Novant Health Forsyth Medical Center'),
(3920, 'https://ror.org/04mpzkf73', 'en', 1, 'https://ror.org/04mpzkf73 Winthrop University'),
(3921, 'https://ror.org/04mqy3p58', 'pt', 1, 'https://ror.org/04mqy3p58 Instituto de Engenharia de Sistemas e Computadores Investigação e Desenvolvimento'),
(3922, 'https://ror.org/04mrdd905', 'en', 1, 'https://ror.org/04mrdd905 University of Wisconsin American Family Children''s Hospital'),
(3923, 'https://ror.org/04mszwh44', 'en', 1, 'https://ror.org/04mszwh44 Gerontological Society of America'),
(3924, 'https://ror.org/04mwdyf26', 'en', 1, 'https://ror.org/04mwdyf26 Al-Makassed Islamic Charitable Society Hospital'),
(3925, 'https://ror.org/04mx3cr06', 'en', 1, 'https://ror.org/04mx3cr06 Leighton Hospital'),
(3926, 'https://ror.org/04mxrtj31', 'en', 1, 'https://ror.org/04mxrtj31 Mater Children''s Hospital'),
(3927, 'https://ror.org/04my10541', 'en', 1, 'https://ror.org/04my10541 Centre of Advanced Studies'),
(3928, 'https://ror.org/04n4dcv16', 'en', 1, 'https://ror.org/04n4dcv16 Ardabil University of Medical Sciences دانشگاه علوم پزشکی اردبیل'),
(3929, 'https://ror.org/04n4f3r80', 'en', 1, 'https://ror.org/04n4f3r80 Military Hospital of Tunis'),
(3930, 'https://ror.org/04n76mm80', 'en', 1, 'https://ror.org/04n76mm80 Hanyang University Seoul Hospital'),
(3931, 'https://ror.org/04n9z8z70', 'en', 1, 'https://ror.org/04n9z8z70 New Mexico VA Health Care System'),
(3932, 'https://ror.org/04nbe0v26', 'en', 1, 'https://ror.org/04nbe0v26 Institute of Studies for the Integration of Systems l’Istituto di Studi per l’Integrazione dei Sistemi'),
(3933, 'https://ror.org/04nc9r025', 'en', 1, 'https://ror.org/04nc9r025 Colonial War Memorial Hospital'),
(3934, 'https://ror.org/04nctyb57', 'en', 1, 'https://ror.org/04nctyb57 Sharp Mary Birch Hospital for Women & Newborns'),
(3935, 'https://ror.org/04ned8342', 'en', 1, 'https://ror.org/04ned8342 Saint Michael''s Medical Center'),
(3936, 'https://ror.org/04nfc4n06', 'en', 1, 'https://ror.org/04nfc4n06 Franciscan Hospital for Children'),
(3937, 'https://ror.org/04ngpga37', 'en', 1, 'https://ror.org/04ngpga37 Park University'),
(3938, 'https://ror.org/04ngv0f69', 'en', 1, 'https://ror.org/04ngv0f69 Buffalo General Medical Center'),
(3939, 'https://ror.org/04nj3w743', 'en', 1, 'https://ror.org/04nj3w743 German Kazakh University Kazakhstan-Nemis Universitet'),
(3940, 'https://ror.org/04nn0sh76', 'en', 1, 'https://ror.org/04nn0sh76 Mogilev State University of Food Technologies Магілёўскі дзяржаўны ўніверсітэт харчавання'),
(3941, 'https://ror.org/04npk0q16', 'en', 1, 'https://ror.org/04npk0q16 Animal Health Trust'),
(3942, 'https://ror.org/04npss011', 'en', 1, 'https://ror.org/04npss011 Gandhi Medical College गांधी चिकित्सा महाविद्यालय, भोपाल గాంధీ వైద్య కళాశాల'),
(3943, 'https://ror.org/04npwsp41', 'en', 1, 'https://ror.org/04npwsp41 Coriell Institute For Medical Research'),
(3944, 'https://ror.org/04npy5k94', 'no_lang_code', 1, 'https://ror.org/04npy5k94 Intracom Telecom (Greece)'),
(3945, 'https://ror.org/04nqv0v23', 'en', 1, 'https://ror.org/04nqv0v23 Lynn University'),
(3946, 'https://ror.org/04nr0c858', 'es', 1, 'https://ror.org/04nr0c858 Hospital Vozandes'),
(3947, 'https://ror.org/04nrjxa63', 'en', 1, 'https://ror.org/04nrjxa63 Shanghai Agrobiological Gene Center 上海市农业生物基因中心'),
(3948, 'https://ror.org/04nrs5002', 'en', 1, 'https://ror.org/04nrs5002 Helen Joseph Hospital'),
(3949, 'https://ror.org/04nt8b154', 'en', 1, 'https://ror.org/04nt8b154 Fukuoka University 福岡大学'),
(3950, 'https://ror.org/04ntyjt11', 'en', 1, 'https://ror.org/04ntyjt11 Yeungnam University Medical Center 영남대학교병원'),
(3951, 'https://ror.org/04nwm7739', 'en', 1, 'https://ror.org/04nwm7739 Oklahoma Baptist University'),
(3952, 'https://ror.org/04nyf1f54', 'en', 1, 'https://ror.org/04nyf1f54 Shanghai Center For Bioinformation Technology 上海生物信息技术研究中心'),
(3953, 'https://ror.org/04nzv4p86', 'it', 1, 'https://ror.org/04nzv4p86 Ospedale San Luigi Gonzaga'),
(3954, 'https://ror.org/04p405e02', 'en', 1, 'https://ror.org/04p405e02 Biblioteca del Congreso de Estados Unidos Bibliothèque du Congrès Library of Congress'),
(3955, 'https://ror.org/04p7nde68', 'en', 1, 'https://ror.org/04p7nde68 Hakodate Central General Hospital 函館中央病院'),
(3956, 'https://ror.org/04pag4b70', 'fr', 1, 'https://ror.org/04pag4b70 Hôpital Jean-Verdier'),
(3957, 'https://ror.org/04pc7j325', 'en', 1, 'https://ror.org/04pc7j325 Meir Medical Center מרכז רפואי מאיר'),
(3958, 'https://ror.org/04pcmf738', 'en', 1, 'https://ror.org/04pcmf738 Kempegowda Institute of Medical Sciences ಕೆಂಪೇಗೌಡ ವೈದ್ಯಕೀಯ ವಿಜ್ಞಾನ ಸಂಸ್ಥೆ'),
(3959, 'https://ror.org/04pd9b824', 'no_lang_code', 1, 'https://ror.org/04pd9b824 Doosan (United Kingdom)'),
(3960, 'https://ror.org/04pf12f40', 'en', 1, 'https://ror.org/04pf12f40 Louisiana State University at Eunice Université d''État de louisiane à eunice'),
(3961, 'https://ror.org/04pf1fm38', 'en', 1, 'https://ror.org/04pf1fm38 Seirei Social Welfare Community'),
(3962, 'https://ror.org/04pne0d08', 'en', 1, 'https://ror.org/04pne0d08 Norton Medical Centre'),
(3963, 'https://ror.org/04pqpfz42', 'en', 1, 'https://ror.org/04pqpfz42 National Medical Center'),
(3964, 'https://ror.org/04pr9pz75', 'it', 1, 'https://ror.org/04pr9pz75 Azienda Ospedaliera San Giovanni Addolorata San Giovanni Addolorata Hospital'),
(3965, 'https://ror.org/04ptbrd12', 'en', 1, 'https://ror.org/04ptbrd12 Guilan University of Medical Sciences دانشگاه علوم پزشکی گیلان'),
(3966, 'https://ror.org/04pwc8466', 'en', 1, 'https://ror.org/04pwc8466 Johns Hopkins Bayview Medical Center'),
(3967, 'https://ror.org/04py1g812', 'en', 1, 'https://ror.org/04py1g812 Jiangsu Province Hospital 江苏省人民医院'),
(3968, 'https://ror.org/04pyb7y63', 'en', 1, 'https://ror.org/04pyb7y63 Fondazione Internazionale per la Ricerca Sulla Combustione International Flame Research Foundation'),
(3969, 'https://ror.org/04pyrxz13', 'en', 1, 'https://ror.org/04pyrxz13 Southern California University of Health Sciences'),
(3970, 'https://ror.org/04pysv427', 'en', 1, 'https://ror.org/04pysv427 Lady Ridgeway Hospital for Children லேடி ரிட்ஜ்வே வைத்தியசாலையில் රිජ්වේ ආර්යා ළමා රෝහල'),
(3971, 'https://ror.org/04q48ey07', 'en', 1, 'https://ror.org/04q48ey07 National Institute of General Medical Sciences'),
(3972, 'https://ror.org/04q9tew83', 'en', 1, 'https://ror.org/04q9tew83 Henry M. Jackson Foundation'),
(3973, 'https://ror.org/04qbdwc31', 'en', 1, 'https://ror.org/04qbdwc31 Southport and Formby District General Hospital'),
(3974, 'https://ror.org/04qcftj32', 'en', 1, 'https://ror.org/04qcftj32 UK Health and Environment Research Institute'),
(3975, 'https://ror.org/04qdwp261', 'es', 1, 'https://ror.org/04qdwp261 Hospital Clinico San Borja Arriaran, Hospital San Borja Arriarán'),
(3976, 'https://ror.org/04qesyg82', 'en', 1, 'https://ror.org/04qesyg82 Medical Education Institute'),
(3977, 'https://ror.org/04qgcgz06', 'en', 1, 'https://ror.org/04qgcgz06 University Hospital of North Durham'),
(3978, 'https://ror.org/04qj1gz53', 'de', 1, 'https://ror.org/04qj1gz53 Lukaskrankenhaus'),
(3979, 'https://ror.org/04qjnvx31', 'en', 1, 'https://ror.org/04qjnvx31 Brentwood Biomedical Research Institute'),
(3980, 'https://ror.org/04qk4yf71', 'en', 1, 'https://ror.org/04qk4yf71 Conemaugh Memorial Medical Center'),
(3981, 'https://ror.org/04qkq2m54', 'en', 1, 'https://ror.org/04qkq2m54 National Yunlin University of Science and Technology'),
(3982, 'https://ror.org/04qkymg17', 'no_lang_code', 1, 'https://ror.org/04qkymg17 Assuta Medical Center אסותא מרכזים רפואיים'),
(3983, 'https://ror.org/04qm8ac48', 'en', 1, 'https://ror.org/04qm8ac48 Philadelphia Department of Public Health'),
(3984, 'https://ror.org/04qma4821', 'pt', 1, 'https://ror.org/04qma4821 Hospital Pró-Cardíaco'),
(3985, 'https://ror.org/04qmkfe11', 'en', 1, 'https://ror.org/04qmkfe11 VA St. Louis Health Care System'),
(3986, 'https://ror.org/04qn0xg47', 'en', 1, 'https://ror.org/04qn0xg47 Kyungpook National University Hospital 경북대학교병원'),
(3987, 'https://ror.org/04qpegs24', 'en', 1, 'https://ror.org/04qpegs24 Resources For The Future'),
(3988, 'https://ror.org/04qs81248', 'en', 1, 'https://ror.org/04qs81248 Russells Hall Hospital'),
(3989, 'https://ror.org/04qvdf239', 'tr', 1, 'https://ror.org/04qvdf239 Bozok Universitesi Bozok University'),
(3990, 'https://ror.org/04qwmjc96', 'no_lang_code', 1, 'https://ror.org/04qwmjc96 BASF (Canada)'),
(3991, 'https://ror.org/04qx1zg28', 'en', 1, 'https://ror.org/04qx1zg28 Redeemer University College'),
(3992, 'https://ror.org/04r0kzx48', 'en', 1, 'https://ror.org/04r0kzx48 Baker University'),
(3993, 'https://ror.org/04r17y386', 'en', 1, 'https://ror.org/04r17y386 Danish Health and Medicines Authority, National Board of Health Sundhedsstyrelsen'),
(3994, 'https://ror.org/04r1x2k35', 'en', 1, 'https://ror.org/04r1x2k35 FH Kufstein University of Applied Sciences Kufstein'),
(3995, 'https://ror.org/04r33pf22', 'en', 1, 'https://ror.org/04r33pf22 Guy''s Hospital'),
(3996, 'https://ror.org/04r5ess67', 'en', 1, 'https://ror.org/04r5ess67 Sleep and Human Health Institute'),
(3997, 'https://ror.org/04r69jb93', 'en', 1, 'https://ror.org/04r69jb93 Kokushikan University 国士舘大学'),
(3998, 'https://ror.org/04r9qdk92', 'tr', 1, 'https://ror.org/04r9qdk92 Kudret Eye Hospital Kudret Göz Hastanesi'),
(3999, 'https://ror.org/04rha3g10', 'en', 1, 'https://ror.org/04rha3g10 Queen Alexandra Hospital'),
(4000, 'https://ror.org/04rhdtb47', 'en', 1, 'https://ror.org/04rhdtb47 Obstetrics and Gynecology Hospital of Fudan University 复旦大学附属妇产科医院'),
(4001, 'https://ror.org/04rj5w171', 'en', 1, 'https://ror.org/04rj5w171 Olabisi Onabanjo University Teaching Hospital'),
(4002, 'https://ror.org/04rmz8121', 'en', 1, 'https://ror.org/04rmz8121 Isra University'),
(4003, 'https://ror.org/04rqpth59', 'en', 1, 'https://ror.org/04rqpth59 Boston Biomedical Research Institute'),
(4004, 'https://ror.org/04rr42t68', 'nl', 1, 'https://ror.org/04rr42t68 Jeroen Bosch Ziekenhuis'),
(4005, 'https://ror.org/04rsexf17', 'no_lang_code', 1, 'https://ror.org/04rsexf17 Stemcell Technologies'),
(4006, 'https://ror.org/04rssyw40', 'en', 1, 'https://ror.org/04rssyw40 Universitatea de Științe Agronomice și Medicină Veterinară din București University of Agronomic Sciences and Veterinary Medicine of Bucharest'),
(4007, 'https://ror.org/04rvm9c15', 'en', 1, 'https://ror.org/04rvm9c15 Southland Hospital'),
(4008, 'https://ror.org/04rvms649', 'es', 1, 'https://ror.org/04rvms649 Hospital Nuestra Señora de Alarcos'),
(4009, 'https://ror.org/04rx0dh54', 'en', 1, 'https://ror.org/04rx0dh54 Sansum Medical Clinic'),
(4010, 'https://ror.org/04rxn4y96', 'no_lang_code', 1, 'https://ror.org/04rxn4y96 Cell and Tissue Systems (United States)'),
(4011, 'https://ror.org/04s2yen12', 'en', 1, 'https://ror.org/04s2yen12 Letterkenny University Hospital Ospidéal Ginearálta Leitir Ceanainn'),
(4012, 'https://ror.org/04s36qm86', 'en', 1, 'https://ror.org/04s36qm86 Chelyabinsk State University Челябинский государственный университет'),
(4013, 'https://ror.org/04s4j9e43', 'en', 1, 'https://ror.org/04s4j9e43 Omar Bongo University Université Omar Bongo'),
(4014, 'https://ror.org/04s5n7912', 'en', 1, 'https://ror.org/04s5n7912 Science Research Laboratory'),
(4015, 'https://ror.org/04s7f5535', 'no_lang_code', 1, 'https://ror.org/04s7f5535 Beta Technology Limited'),
(4016, 'https://ror.org/04s8a8w57', 'en', 1, 'https://ror.org/04s8a8w57 University Hospital of the West Indies'),
(4017, 'https://ror.org/04s9hft57', 'en', 1, 'https://ror.org/04s9hft57 Quaid-i-Azam University جامعہ قائداعظم'),
(4018, 'https://ror.org/04saq4y86', 'en', 1, 'https://ror.org/04saq4y86 Indira Gandhi Institute of Child Health'),
(4019, 'https://ror.org/04sb8a726', 'no_lang_code', 1, 'https://ror.org/04sb8a726 Hôpital Antoine-Béclère'),
(4020, 'https://ror.org/04sbcrt14', 'en', 1, 'https://ror.org/04sbcrt14 Bhavnagar University'),
(4021, 'https://ror.org/04scbtr44', 'es', 1, 'https://ror.org/04scbtr44 Hospital Universitario de Fuenlabrada'),
(4022, 'https://ror.org/04scfb908', 'en', 1, 'https://ror.org/04scfb908 Alfred Health'),
(4023, 'https://ror.org/04sexa105', 'en', 1, 'https://ror.org/04sexa105 Qazvin University of Medical Sciences دانشگاه علوم پزشكي و خدمات درماني قزوین'),
(4024, 'https://ror.org/04sfmcd28', 'fr', 1, 'https://ror.org/04sfmcd28 Centre Hospitalier Universitaire Pointe-à-Pitre'),
(4025, 'https://ror.org/04sgkca59', 'en', 1, 'https://ror.org/04sgkca59 Funabashi Central Hospital 船橋中央病院'),
(4026, 'https://ror.org/04sgy9050', 'pt', 1, 'https://ror.org/04sgy9050 Hospital Santa Marcelina'),
(4027, 'https://ror.org/04sh9kd82', 'en', 1, 'https://ror.org/04sh9kd82 Starship Children''s Health'),
(4028, 'https://ror.org/04shepe48', 'en', 1, 'https://ror.org/04shepe48 Chinese Culture University 中國文化大學'),
(4029, 'https://ror.org/04sheqe49', 'en', 1, 'https://ror.org/04sheqe49 Daisy Hill Hospital Otharlann Chnoc na Nóiníní'),
(4030, 'https://ror.org/04skjvf92', 'pt', 1, 'https://ror.org/04skjvf92 Hospital da Restauração'),
(4031, 'https://ror.org/04skph061', 'en', 1, 'https://ror.org/04skph061 Hospital de la Universidad de Nuevo México University of New Mexico Hospital'),
(4032, 'https://ror.org/04sq8k219', 'en', 1, 'https://ror.org/04sq8k219 University of Louisville Hospital'),
(4033, 'https://ror.org/04sr36h49', 'no_lang_code', 1, 'https://ror.org/04sr36h49 Seeders (South Korea)'),
(4034, 'https://ror.org/04ss1bw11', 'en', 1, 'https://ror.org/04ss1bw11 Tzu Chi University 慈濟大學'),
(4035, 'https://ror.org/04ssfah06', 'es', 1, 'https://ror.org/04ssfah06 Hospital Virgen de los Lirios'),
(4036, 'https://ror.org/04svdmv30', 'fr', 1, 'https://ror.org/04svdmv30 The Association of the European Rail Industry, Union des Industries Ferroviaires Européennes'),
(4037, 'https://ror.org/04sx7v519', 'fr', 1, 'https://ror.org/04sx7v519 Hôtel-Dieu de Lyon'),
(4038, 'https://ror.org/04sxj4848', 'en', 1, 'https://ror.org/04sxj4848 Sarah Lawrence College'),
(4039, 'https://ror.org/04sz7qx51', 'fr', 1, 'https://ror.org/04sz7qx51 Centre Hospitalier Universitaire de Rabat-Salé'),
(4040, 'https://ror.org/04sze3c15', 'en', 1, 'https://ror.org/04sze3c15 Yonsei University Health System'),
(4041, 'https://ror.org/04szr1369', 'en', 1, 'https://ror.org/04szr1369 Guangzhou Chest Hospital 广州市胸科医院'),
(4042, 'https://ror.org/04t23pb41', 'fr', 1, 'https://ror.org/04t23pb41 Hôpital Civil de Charleroi'),
(4043, 'https://ror.org/04t41ec74', 'en', 1, 'https://ror.org/04t41ec74 Father Muller Medical College Hospital फादर म्युलर मेडिकल कॉलेज பாதர் முல்லெர் மெடிக்கல் காலேஜ் ఫాదర్ ముల్లెర్ మెడికల్ కాలేజ్ ಫಾದೆರ್ ಮುಲ್ಲರ್ ಮೆಡಿಕಲ್ ಕಾಳಜ್ ഫാദർ മുള്ളെർ മെഡിക്കൽ കോളേജ്'),
(4044, 'https://ror.org/04t4jzh38', 'en', 1, 'https://ror.org/04t4jzh38 Notre Dame Seishin University ノートルダム清心女子大学'),
(4045, 'https://ror.org/04t6r6d34', 'en', 1, 'https://ror.org/04t6r6d34 International Space University'),
(4046, 'https://ror.org/04t6zb108', 'en', 1, 'https://ror.org/04t6zb108 University Hospitals Geneva Medical Center'),
(4047, 'https://ror.org/04t77r183', 'es', 1, 'https://ror.org/04t77r183 Hospital Ludovica Hospital de Niños Superiora Sor María Ludovica'),
(4048, 'https://ror.org/04tavf782', 'en', 1, 'https://ror.org/04tavf782 Beijing Computational Science Research Center 北京计算科学研究中心'),
(4049, 'https://ror.org/04tbm0m52', 'en', 1, 'https://ror.org/04tbm0m52 Pinderfields Hospital'),
(4050, 'https://ror.org/04tf4g123', 'en', 1, 'https://ror.org/04tf4g123 Sichuan Provincial Academy of Natural Resource Sciences 四川省自然资源科学院'),
(4051, 'https://ror.org/04tft4718', 'no_lang_code', 1, 'https://ror.org/04tft4718 Tamkang University 淡江大學'),
(4052, 'https://ror.org/04tm3k558', 'en', 1, 'https://ror.org/04tm3k558 Third Affiliated Hospital of Sun Yat-sen University'),
(4053, 'https://ror.org/04tpqnr72', 'en', 1, 'https://ror.org/04tpqnr72 Harold Wood Hospital'),
(4054, 'https://ror.org/04tprjr04', 'en', 1, 'https://ror.org/04tprjr04 Nippon Steel Yawata Memorial Hospital 製鉄記念八幡病院'),
(4055, 'https://ror.org/04tqcn816', 'en', 1, 'https://ror.org/04tqcn816 Health Sciences University of Hokkaido 北海道医療大学'),
(4056, 'https://ror.org/04tr09862', 'en', 1, 'https://ror.org/04tr09862 Sequoia Hospital'),
(4057, 'https://ror.org/04ts4qa58', 'en', 1, 'https://ror.org/04ts4qa58 Changwon National University 창원대학교'),
(4058, 'https://ror.org/04ttjf776', 'en', 1, 'https://ror.org/04ttjf776 RMIT University'),
(4059, 'https://ror.org/04twccc71', 'en', 1, 'https://ror.org/04twccc71 National United University'),
(4060, 'https://ror.org/04tzy5g14', 'en', 1, 'https://ror.org/04tzy5g14 Missouri Botanical Garden'),
(4061, 'https://ror.org/04v00sg98', 'en', 1, 'https://ror.org/04v00sg98 VA Boston Healthcare System'),
(4062, 'https://ror.org/04v0wnx78', 'tr', 1, 'https://ror.org/04v0wnx78 Dr. Siyami Ersek Göğüs Kalp Ve Damar Cerrahisi Eğitim Ve Araştırma Hastanesi'),
(4063, 'https://ror.org/04v1j8c44', 'no_lang_code', 1, 'https://ror.org/04v1j8c44 Advanced Bioscience Laboratories (United States)'),
(4064, 'https://ror.org/04v3sec91', 'en', 1, 'https://ror.org/04v3sec91 Saint Mary''s University of Minnesota'),
(4065, 'https://ror.org/04v403p80', 'en', 1, 'https://ror.org/04v403p80 Consorzio Interuniversitario Risonanze Magnetiche di Metallo Proteine Interuniversity Consortium for Magnetic Resonance'),
(4066, 'https://ror.org/04v91tb50', 'es', 1, 'https://ror.org/04v91tb50 Complejo Hospitalario Torrecárdenas'),
(4067, 'https://ror.org/04v98kq37', 'no_lang_code', 1, 'https://ror.org/04v98kq37 Renault (France)'),
(4068, 'https://ror.org/04va7bx33', 'en', 1, 'https://ror.org/04va7bx33 Killingbeck'),
(4069, 'https://ror.org/04vcan916', 'en', 1, 'https://ror.org/04vcan916 Lev Hasharon Hospital מרכז רפואי לבריאות הנפש לב השרון'),
(4070, 'https://ror.org/04vccmr34', 'nl', 1, 'https://ror.org/04vccmr34 Medisch Centrum Alkmaar'),
(4071, 'https://ror.org/04vcxwm16', 'en', 1, 'https://ror.org/04vcxwm16 Mission Hospital'),
(4072, 'https://ror.org/04vdpck27', 'en', 1, 'https://ror.org/04vdpck27 Catholic University of the Maule Universidad Católica del Maule'),
(4073, 'https://ror.org/04vfsmv21', 'en', 1, 'https://ror.org/04vfsmv21 National Institutes of Health Clinical Center'),
(4074, 'https://ror.org/04vfyfx73', 'no_lang_code', 1, 'https://ror.org/04vfyfx73 Teer Coatings (United Kingdom)'),
(4075, 'https://ror.org/04vgkzj18', 'en', 1, 'https://ror.org/04vgkzj18 Ibaraki Prefectural University of Health Sciences 茨城県立医療大学'),
(4076, 'https://ror.org/04vhsg885', 'en', 1, 'https://ror.org/04vhsg885 Allama Iqbal Medical College علامہ اقبال میڈیکل کالج'),
(4077, 'https://ror.org/04vnz0695', 'no_lang_code', 1, 'https://ror.org/04vnz0695 Asahikawa Kosei Hospital 旭川厚生病院'),
(4078, 'https://ror.org/04vq5kb54', 'en', 1, 'https://ror.org/04vq5kb54 UCLA Medical Center'),
(4079, 'https://ror.org/04vqzd428', 'en', 1, 'https://ror.org/04vqzd428 Social Insurance Saitama Chuo Hospital 埼玉メディカルセンター'),
(4080, 'https://ror.org/04vrsb288', 'en', 1, 'https://ror.org/04vrsb288 Far Eastern State Medical University Дальневосточный государственный медицинский университет'),
(4081, 'https://ror.org/04vt4a111', 'en', 1, 'https://ror.org/04vt4a111 Behavioral Health Research Center of the Southwest'),
(4082, 'https://ror.org/04vtx5s55', 'en', 1, 'https://ror.org/04vtx5s55 University of Malawi'),
(4083, 'https://ror.org/04vxr4k74', 'no_lang_code', 1, 'https://ror.org/04vxr4k74 Sahmyook University 삼육대학교'),
(4084, 'https://ror.org/04vy5s568', 'en', 1, 'https://ror.org/04vy5s568 La Universidad del Zulia University of Zulia'),
(4085, 'https://ror.org/04w1m5n60', 'fr', 1, 'https://ror.org/04w1m5n60 Hôtel-Dieu de France'),
(4086, 'https://ror.org/04w3ve464', 'no_lang_code', 1, 'https://ror.org/04w3ve464 Kyoto Katsura Hospital 京都桂病院'),
(4087, 'https://ror.org/04w40b524', 'en', 1, 'https://ror.org/04w40b524 Abderrahmane Mami Hospital'),
(4088, 'https://ror.org/04wa91k02', 'en', 1, 'https://ror.org/04wa91k02 Kuban State Medical University Кубанский государственный медицинский университет'),
(4089, 'https://ror.org/04waphv22', 'en', 1, 'https://ror.org/04waphv22 Tamil Nadu Veterinary and Animal Sciences University தமிழ்நாடு கால்நடை மருத்துவ அறிவியல் பல்கலைக்கழகம்'),
(4090, 'https://ror.org/04wbhy398', 'pl', 1, 'https://ror.org/04wbhy398 Wojewódzki Szpital Zespolony'),
(4091, 'https://ror.org/04wbsx459', 'en', 1, 'https://ror.org/04wbsx459 Nambour General Hospital'),
(4092, 'https://ror.org/04wc5jk96', 'en', 1, 'https://ror.org/04wc5jk96 Hôpital de Montréal pour enfants Montreal Children''s Hospital'),
(4093, 'https://ror.org/04wd10e19', 'en', 1, 'https://ror.org/04wd10e19 Andong National University 안동대학교'),
(4094, 'https://ror.org/04wd31514', 'no_lang_code', 1, 'https://ror.org/04wd31514 CFD Research Corporation (United States)'),
(4095, 'https://ror.org/04whfy367', 'en', 1, 'https://ror.org/04whfy367 Memorial Hospital of South Bend'),
(4096, 'https://ror.org/04wm83d45', 'en', 1, 'https://ror.org/04wm83d45 Selma University'),
(4097, 'https://ror.org/04wmhsz10', 'en', 1, 'https://ror.org/04wmhsz10 Sandwell General Hospital'),
(4098, 'https://ror.org/04wn28048', 'en', 1, 'https://ror.org/04wn28048 University of Tulsa Université de tulsa'),
(4099, 'https://ror.org/04wngnd82', 'en', 1, 'https://ror.org/04wngnd82 University Heights Center'),
(4100, 'https://ror.org/04wnwd012', 'en', 1, 'https://ror.org/04wnwd012 Education Development Center'),
(4101, 'https://ror.org/04wpkfc35', 'fr', 1, 'https://ror.org/04wpkfc35 Hôpital d''Instruction des Armées Sainte-Anne'),
(4102, 'https://ror.org/04wpmby09', 'en', 1, 'https://ror.org/04wpmby09 Memorial Regional Hospital'),
(4103, 'https://ror.org/04wprr919', 'en', 1, 'https://ror.org/04wprr919 Athens Eye Hospital Οφθαλμολογικό Νοσοκομείο Αθηνών'),
(4104, 'https://ror.org/04wrfcw61', 'en', 1, 'https://ror.org/04wrfcw61 Sanford USD Medical Center'),
(4105, 'https://ror.org/04ws1n245', 'en', 1, 'https://ror.org/04ws1n245 King Fahad Hospital Jeddah مستشفى الملك فهد بجدة'),
(4106, 'https://ror.org/04ws6z706', 'en', 1, 'https://ror.org/04ws6z706 Saint Xavier University'),
(4107, 'https://ror.org/04wvkky61', 'en', 1, 'https://ror.org/04wvkky61 Southern General Hospital'),
(4108, 'https://ror.org/04wwbpd10', 'no_lang_code', 1, 'https://ror.org/04wwbpd10 Biomedware (United States)'),
(4109, 'https://ror.org/04wwg3z97', 'no_lang_code', 1, 'https://ror.org/04wwg3z97 Dammam Central Hospital مستشفى الدمام المركزي'),
(4110, 'https://ror.org/04x0k0m51', 'en', 1, 'https://ror.org/04x0k0m51 Seokyeong University 서경대학교'),
(4111, 'https://ror.org/04x0r0b44', 'en', 1, 'https://ror.org/04x0r0b44 Connecticut Department of Mental Health and Addiction Services'),
(4112, 'https://ror.org/04x16j349', 'no_lang_code', 1, 'https://ror.org/04x16j349 Invotek'),
(4113, 'https://ror.org/04x16yc34', 'no_lang_code', 1, 'https://ror.org/04x16yc34 Al Nahdha Hospital مستشفى النهضة'),
(4114, 'https://ror.org/04x1ptk36', 'en', 1, 'https://ror.org/04x1ptk36 Ibis Reproductive Health'),
(4115, 'https://ror.org/04x1z3t86', 'en', 1, 'https://ror.org/04x1z3t86 Mercy St. Vincent Medical Center'),
(4116, 'https://ror.org/04x27ad97', 'en', 1, 'https://ror.org/04x27ad97 Baby Memorial Hospital'),
(4117, 'https://ror.org/04x495f64', 'en', 1, 'https://ror.org/04x495f64 Rainbow Babies & Children''s Hospital'),
(4118, 'https://ror.org/04x6tqs25', 'no_lang_code', 1, 'https://ror.org/04x6tqs25 Nova Chemicals (Canada)'),
(4119, 'https://ror.org/04x744g62', 'en', 1, 'https://ror.org/04x744g62 Shin Kong WHS Memorial Hospital'),
(4120, 'https://ror.org/04xbrv698', 'en', 1, 'https://ror.org/04xbrv698 Institut für Mobil- und Satellitenfunktechnik Institute for Mobile and Satellite Communication Technology'),
(4121, 'https://ror.org/04xdbp773', 'no_lang_code', 1, 'https://ror.org/04xdbp773 Academic Edge'),
(4122, 'https://ror.org/04xfhjr27', 'en', 1, 'https://ror.org/04xfhjr27 Great Western Hospital'),
(4123, 'https://ror.org/04xfsbk97', 'en', 1, 'https://ror.org/04xfsbk97 Shenzhen Third People’s Hospital 深圳市第三人民医院'),
(4124, 'https://ror.org/04xhnr923', 'no_lang_code', 1, 'https://ror.org/04xhnr923 Hyogo Prefectural Nishinomiya Hospital 兵庫県立西宮病院'),
(4125, 'https://ror.org/04xnzxv25', 'en', 1, 'https://ror.org/04xnzxv25 Khyber Teaching Hospital'),
(4126, 'https://ror.org/04xpmtk39', 'en', 1, 'https://ror.org/04xpmtk39 Southern Hills Medical Center'),
(4127, 'https://ror.org/04xraxn18', 'en', 1, 'https://ror.org/04xraxn18 Fondazione Telethon Telethon Foundation'),
(4128, 'https://ror.org/04xsjmh40', 'en', 1, 'https://ror.org/04xsjmh40 American Society for Microbiology'),
(4129, 'https://ror.org/04xtpk854', 'en', 1, 'https://ror.org/04xtpk854 Manchester Royal Eye Hospital'),
(4130, 'https://ror.org/04xv01a59', 'en', 1, 'https://ror.org/04xv01a59 The Pirbright Institute'),
(4131, 'https://ror.org/04xv63e47', 'en', 1, 'https://ror.org/04xv63e47 Sin-Lau Christian Hospital'),
(4132, 'https://ror.org/04xvkcm66', 'no_lang_code', 1, 'https://ror.org/04xvkcm66 Apption'),
(4133, 'https://ror.org/04xz2c768', 'en', 1, 'https://ror.org/04xz2c768 R. K. Khan Hospital'),
(4134, 'https://ror.org/04xze1462', 'no_lang_code', 1, 'https://ror.org/04xze1462 Nokia (Belgium)'),
(4135, 'https://ror.org/04xzj3x20', 'en', 1, 'https://ror.org/04xzj3x20 LAC+USC Medical Center'),
(4136, 'https://ror.org/04y28m257', 'no_lang_code', 1, 'https://ror.org/04y28m257 SOLINET'),
(4137, 'https://ror.org/04y2gp806', 'en', 1, 'https://ror.org/04y2gp806 King Fahad Central Hospital مستشفى الملك فهد المركزي بجازان'),
(4138, 'https://ror.org/04y2hdd14', 'no_lang_code', 1, 'https://ror.org/04y2hdd14 Amiri Hospital المستشفى الأميري'),
(4139, 'https://ror.org/04y3ze847', 'en', 1, 'https://ror.org/04y3ze847 Ospidéal na hOllscoile, Luimneach University Hospital Limerick'),
(4140, 'https://ror.org/04y6m3r89', 'en', 1, 'https://ror.org/04y6m3r89 Arkansas State Department of Human Services'),
(4141, 'https://ror.org/04y71bh49', 'en', 1, 'https://ror.org/04y71bh49 Southern University at Shreveport'),
(4142, 'https://ror.org/04y908s98', 'en', 1, 'https://ror.org/04y908s98 Government Medical College'),
(4143, 'https://ror.org/04yajdn66', 'en', 1, 'https://ror.org/04yajdn66 Wuhan Medical Center for Women and Children'),
(4144, 'https://ror.org/04yb7hq57', 'en', 1, 'https://ror.org/04yb7hq57 Stavropol State Medical University Ставропольский государственный медицинский университет'),
(4145, 'https://ror.org/04ycpbx82', 'en', 1, 'https://ror.org/04ycpbx82 Prifysgol Westminster University of Westminster'),
(4146, 'https://ror.org/04yd6pw26', 'en', 1, 'https://ror.org/04yd6pw26 Cape Cod Hospital'),
(4147, 'https://ror.org/04yj19304', 'en', 1, 'https://ror.org/04yj19304 California Baptist University'),
(4148, 'https://ror.org/04ymee833', 'en', 1, 'https://ror.org/04ymee833 Central Institute for the Deaf'),
(4149, 'https://ror.org/04ymr6s03', 'en', 1, 'https://ror.org/04ymr6s03 Launceston General Hospital'),
(4150, 'https://ror.org/04yrw5x43', 'it', 1, 'https://ror.org/04yrw5x43 Ospedale di Livorno'),
(4151, 'https://ror.org/04ytrbh65', 'en', 1, 'https://ror.org/04ytrbh65 Osaka University of Health and Sport Sciences 大阪体育大学'),
(4152, 'https://ror.org/04ywg3445', 'no_lang_code', 1, 'https://ror.org/04ywg3445 New England Biolabs (United States)'),
(4153, 'https://ror.org/04yxtqc27', 'en', 1, 'https://ror.org/04yxtqc27 Caroline Chisholm Centre for Health Ethics'),
(4154, 'https://ror.org/04yy7zb66', 'en', 1, 'https://ror.org/04yy7zb66 Centre for Mental Health'),
(4155, 'https://ror.org/04yyp8h20', 'no_lang_code', 1, 'https://ror.org/04yyp8h20 Pilkington (United Kingdom)'),
(4156, 'https://ror.org/04z18y971', 'no_lang_code', 1, 'https://ror.org/04z18y971 Jennerex Biotherapeutics (Canada)'),
(4157, 'https://ror.org/04z1c5686', 'no_lang_code', 1, 'https://ror.org/04z1c5686 Encana (Canada)'),
(4158, 'https://ror.org/04z4j3y75', 'fr', 1, 'https://ror.org/04z4j3y75 Institut Sénégalais de Recherches Agricoles'),
(4159, 'https://ror.org/04z5vy146', 'en', 1, 'https://ror.org/04z5vy146 Carlo Forlanini Hospital'),
(4160, 'https://ror.org/04z61sd03', 'en', 1, 'https://ror.org/04z61sd03 Alder Hey Children''s Hospital'),
(4161, 'https://ror.org/04z7fc725', 'en', 1, 'https://ror.org/04z7fc725 St.John''s Medical College Hospital'),
(4162, 'https://ror.org/04z89xx32', 'en', 1, 'https://ror.org/04z89xx32 Atlanta VA Medical Center'),
(4163, 'https://ror.org/04z9w5078', 'no_lang_code', 1, 'https://ror.org/04z9w5078 Xerox (Canada)'),
(4164, 'https://ror.org/04z9zma62', 'en', 1, 'https://ror.org/04z9zma62 American Hospital Association'),
(4165, 'https://ror.org/04zah8g26', 'no_lang_code', 1, 'https://ror.org/04zah8g26 Pouliadis Associates Corporation'),
(4166, 'https://ror.org/04zap7912', 'en', 1, 'https://ror.org/04zap7912 Yunnan University of Traditional Chinese Medicine 云南中医药大学'),
(4167, 'https://ror.org/04zb59n70', 'en', 1, 'https://ror.org/04zb59n70 Leibniz Institute for Solid State and Materials Research Leibniz-Institut für Festkörper- und Werkstoffforschung Dresden'),
(4168, 'https://ror.org/04zbgcp34', 'no_lang_code', 1, 'https://ror.org/04zbgcp34 Kantar Health (United States)'),
(4169, 'https://ror.org/04zbkyt39', 'en', 1, 'https://ror.org/04zbkyt39 National Hispanic University'),
(4170, 'https://ror.org/04zfmcq84', 'en', 1, 'https://ror.org/04zfmcq84 Children''s Mercy Hospital'),
(4171, 'https://ror.org/04zgkpa58', 'en', 1, 'https://ror.org/04zgkpa58 Health Protection Scotland'),
(4172, 'https://ror.org/04zgvbn76', 'en', 1, 'https://ror.org/04zgvbn76 Guthrie Hospice'),
(4173, 'https://ror.org/04zgvy449', 'no_lang_code', 1, 'https://ror.org/04zgvy449 PSA Peugeot Citroën (France)'),
(4174, 'https://ror.org/04zhhva53', 'en', 1, 'https://ror.org/04zhhva53 Thomas Jefferson University Hospital'),
(4175, 'https://ror.org/04zjvnp94', 'en', 1, 'https://ror.org/04zjvnp94 Clalit Health Services שירותי בריאות כללית'),
(4176, 'https://ror.org/04zkctn64', 'en', 1, 'https://ror.org/04zkctn64 University Hospital of Alexandroupolis'),
(4177, 'https://ror.org/04zmppn46', 'en', 1, 'https://ror.org/04zmppn46 Public Health Solutions'),
(4178, 'https://ror.org/04zn42r77', 'en', 1, 'https://ror.org/04zn42r77 Shahid Bahonar University of Kerman دانشگاه شهید باهنر کرمان'),
(4179, 'https://ror.org/04zn9qp70', 'en', 1, 'https://ror.org/04zn9qp70 Pennsylvania Department of Human Services'),
(4180, 'https://ror.org/04zpy9a42', 'en', 1, 'https://ror.org/04zpy9a42 Nil Ratan Sircar Medical College and Hospital नील रतन सरकार मेडिकल कॉलेज र अस्पताल'),
(4181, 'https://ror.org/04zsytt76', 'en', 1, 'https://ror.org/04zsytt76 Wise & Munro Learning Research'),
(4182, 'https://ror.org/04ztdzs79', 'en', 1, 'https://ror.org/04ztdzs79 Fenway Health'),
(4183, 'https://ror.org/04zx3rq17', 'en', 1, 'https://ror.org/04zx3rq17 National Cheng Kung University Hospital'),
(4184, 'https://ror.org/04zy7mm10', 'en', 1, 'https://ror.org/04zy7mm10 Canadian Dairy Network'),
(4185, 'https://ror.org/04zyews33', 'no_lang_code', 1, 'https://ror.org/04zyews33 Baylis Medical (Canada)'),
(4186, 'https://ror.org/04zygv656', 'en', 1, 'https://ror.org/04zygv656 Airedale General Hospital'),
(4187, 'https://ror.org/04zyja509', 'pt', 1, 'https://ror.org/04zyja509 Universidade de Franca'),
(4188, 'https://ror.org/04zz3m093', 'en', 1, 'https://ror.org/04zz3m093 KIST Medical College'),
(4189, 'https://ror.org/04zzqmk94', 'en', 1, 'https://ror.org/04zzqmk94 Kintampo Health Research Centre'),
(4190, 'https://ror.org/050113w36', 'en', 1, 'https://ror.org/050113w36 SRM Institute of Science and Technology திரு. இராமசாமி நினைவுப் பல்கலைக்கழகம்'),
(4191, 'https://ror.org/05031qk94', 'en', 1, 'https://ror.org/05031qk94 Taipei Medical University'),
(4192, 'https://ror.org/0504y0m80', 'en', 1, 'https://ror.org/0504y0m80 Polyclinic General Hospital'),
(4193, 'https://ror.org/05087r129', 'en', 1, 'https://ror.org/05087r129 Hizen Psychiatric Center 肥前精神医療センター'),
(4194, 'https://ror.org/0509tgg56', 'no_lang_code', 1, 'https://ror.org/0509tgg56 Airbus (Spain)'),
(4195, 'https://ror.org/050adm910', 'no_lang_code', 1, 'https://ror.org/050adm910 Chiba Hokusou Hospital 日本医科大学千葉北総病院'),
(4196, 'https://ror.org/050b05p79', 'en', 1, 'https://ror.org/050b05p79 Sriram Chandra Bhanja Medical College Hospital ଶ୍ରୀରାମ ଚନ୍ଦ୍ର ଭଞ୍ଜ ଭେଷଜ ମହାବିଦ୍ୟାଳୟ'),
(4197, 'https://ror.org/050b31k83', 'en', 1, 'https://ror.org/050b31k83 Hunter New England Local Health District'),
(4198, 'https://ror.org/050batv17', 'en', 1, 'https://ror.org/050batv17 Mater Hospital'),
(4199, 'https://ror.org/050bd8661', 'en', 1, 'https://ror.org/050bd8661 Royal Surrey NHS Foundation Trust'),
(4200, 'https://ror.org/050c9qp51', 'en', 1, 'https://ror.org/050c9qp51 Massachusetts Department of Public Health'),
(4201, 'https://ror.org/050cwzy61', 'en', 1, 'https://ror.org/050cwzy61 St Mary''s Hospital'),
(4202, 'https://ror.org/050fz5z96', 'en', 1, 'https://ror.org/050fz5z96 Washington DC VA Medical Center'),
(4203, 'https://ror.org/050hwd209', 'en', 1, 'https://ror.org/050hwd209 Hokkaido Institute of Public Health 北海道立衛生研究所'),
(4204, 'https://ror.org/050j2vm64', 'en', 1, 'https://ror.org/050j2vm64 Bangalore University Université de bangalore बंगलौर विश्वविद्यालय बंगळुरू विद्यापीठ பெங்களூர்ப் பல்கலைக்கழகம் బెంగుళూరు విశ్వవిద్యాలయం ಬೆಂಗಳೂರು ವಿಶ್ವವಿದ್ಯಾಲಯ'),
(4205, 'https://ror.org/050jqep38', 'nl', 1, 'https://ror.org/050jqep38 Altrecht GGZ'),
(4206, 'https://ror.org/050k2da37', 'en', 1, 'https://ror.org/050k2da37 Global Medical Imaging'),
(4207, 'https://ror.org/050mdr969', 'en', 1, 'https://ror.org/050mdr969 Kansas City VA Medical Center'),
(4208, 'https://ror.org/050nkg722', 'en', 1, 'https://ror.org/050nkg722 Oita University Hospital 大分大学医学部附属病院'),
(4209, 'https://ror.org/050pqs331', 'en', 1, 'https://ror.org/050pqs331 MRC Human Nutrition Research'),
(4210, 'https://ror.org/050qew682', 'no_lang_code', 1, 'https://ror.org/050qew682 Bolder Biotechnology, Inc.'),
(4211, 'https://ror.org/050qpjf10', 'en', 1, 'https://ror.org/050qpjf10 Botsford Hospital'),
(4212, 'https://ror.org/050rkhq40', 'en', 1, 'https://ror.org/050rkhq40 Jacksonville University Universidad de Jacksonville Université de jacksonville'),
(4213, 'https://ror.org/050th9p79', 'en', 1, 'https://ror.org/050th9p79 Scunthorpe General Hospital'),
(4214, 'https://ror.org/050w2g362', 'no_lang_code', 1, 'https://ror.org/050w2g362 Inovamais'),
(4215, 'https://ror.org/050wjeh45', 'en', 1, 'https://ror.org/050wjeh45 Eisenhower Medical Center'),
(4216, 'https://ror.org/050y0ba80', 'no_lang_code', 1, 'https://ror.org/050y0ba80 D''Appolonia (Italy)'),
(4217, 'https://ror.org/050ztxn78', 'en', 1, 'https://ror.org/050ztxn78 Madras Medical College மதராசு மருத்துவக் கல்லூரி మద్రాస్ వైద్య కళాశాల'),
(4218, 'https://ror.org/050zvc738', 'en', 1, 'https://ror.org/050zvc738 Agia Olga Hospital ΚΩΝΣΤΑΝΤΟΠΟΥΛΕΙΟ ΓΕΝΙΚΟ ΝΟΣΟΚΟΜΕΙΟ ΝΕΑΣ ΙΩΝΙΑΣ'),
(4219, 'https://ror.org/0511k4970', 'en', 1, 'https://ror.org/0511k4970 Children''s Hospital أطفال مستشفى تونس'),
(4220, 'https://ror.org/0511th722', 'fr', 1, 'https://ror.org/0511th722 Hôpital Albert-Chenevier'),
(4221, 'https://ror.org/0511yej17', 'en', 1, 'https://ror.org/0511yej17 Dartmouth Institute for Health Policy and Clinical Practice'),
(4222, 'https://ror.org/0511zqc76', 'en', 1, 'https://ror.org/0511zqc76 Chuo Kikuu cha Tumaini Tumaini University'),
(4223, 'https://ror.org/0512xad50', 'en', 1, 'https://ror.org/0512xad50 American Academy of Pediatrics'),
(4224, 'https://ror.org/0513nfd47', 'en', 1, 'https://ror.org/0513nfd47 Kootenai Medical Center'),
(4225, 'https://ror.org/051525m98', 'en', 1, 'https://ror.org/051525m98 Mercy Medical Center'),
(4226, 'https://ror.org/0516ah480', 'en', 1, 'https://ror.org/0516ah480 The Graduate University for Advanced Studies, SOKENDAI 総合研究大学院大学'),
(4227, 'https://ror.org/051a97h21', 'no_lang_code', 1, 'https://ror.org/051a97h21 National Nuclear Corporation (United Kingdom)'),
(4228, 'https://ror.org/051b68e86', 'en', 1, 'https://ror.org/051b68e86 Frankston Hospital'),
(4229, 'https://ror.org/051b9c228', 'it', 1, 'https://ror.org/051b9c228 Ospedale Martini');
INSERT INTO `rors` VALUES
(4230, 'https://ror.org/051c2ew73', 'es', 1, 'https://ror.org/051c2ew73 Hospital General de La Rioja'),
(4231, 'https://ror.org/051cp7s36', 'en', 1, 'https://ror.org/051cp7s36 Fatima Jinnah Medical University فاطمہ جناح میڈیکل کالج'),
(4232, 'https://ror.org/051dzw862', 'en', 1, 'https://ror.org/051dzw862 Gentofte Hospital'),
(4233, 'https://ror.org/051fpt583', 'it', 1, 'https://ror.org/051fpt583 Ospedale Buccheri la Ferla Fatebenefratelli'),
(4234, 'https://ror.org/051hvcm98', 'en', 1, 'https://ror.org/051hvcm98 Jiangsu Normal University 江苏师范大学'),
(4235, 'https://ror.org/051j7cj03', 'en', 1, 'https://ror.org/051j7cj03 Minot State University Université d''État de minot'),
(4236, 'https://ror.org/051j8zv27', 'no_lang_code', 1, 'https://ror.org/051j8zv27 Osaka Kyoiku University 大阪教育大学'),
(4237, 'https://ror.org/051mda743', 'en', 1, 'https://ror.org/051mda743 Garrahan Hospital'),
(4238, 'https://ror.org/051mn8706', 'en', 1, 'https://ror.org/051mn8706 Tumor Hospital of Guangxi Medical University 广西医科大学肿瘤医院'),
(4239, 'https://ror.org/051qv3667', 'no_lang_code', 1, 'https://ror.org/051qv3667 Applus+ IDIADA (Spain) Institut d''Investigació Aplicada de l''Automòbil'),
(4240, 'https://ror.org/051s3e988', 'fr', 1, 'https://ror.org/051s3e988 Hôpital Universitaire Dupuytren'),
(4241, 'https://ror.org/051sezk39', 'no_lang_code', 1, 'https://ror.org/051sezk39 Micralyne'),
(4242, 'https://ror.org/051smbs96', 'en', 1, 'https://ror.org/051smbs96 The University of Texas of the Permian Basin'),
(4243, 'https://ror.org/051wnqr14', 'en', 1, 'https://ror.org/051wnqr14 Department of Defence'),
(4244, 'https://ror.org/051xgzg37', 'en', 1, 'https://ror.org/051xgzg37 Stockholm Environment Institute'),
(4245, 'https://ror.org/0520j5d52', 'no_lang_code', 1, 'https://ror.org/0520j5d52 Peptidream (Japan) ペプチドリーム'),
(4246, 'https://ror.org/0522w3m69', 'no_lang_code', 1, 'https://ror.org/0522w3m69 Sinhgad Dental College and Hospital'),
(4247, 'https://ror.org/0524j1g61', 'en', 1, 'https://ror.org/0524j1g61 Stoke Mandeville Hospital Ysbyty Stoke Mandeville'),
(4248, 'https://ror.org/052578691', 'en', 1, 'https://ror.org/052578691 MRC Epidemiology Unit'),
(4249, 'https://ror.org/0525h8d02', 'en', 1, 'https://ror.org/0525h8d02 New Mexico Regional Federal Medical Center'),
(4250, 'https://ror.org/0525j6d32', 'en', 1, 'https://ror.org/0525j6d32 Nishijin Hospital 西陣病院'),
(4251, 'https://ror.org/05275vm15', 'en', 1, 'https://ror.org/05275vm15 Gelre Hospitals Gelre Ziekenhuizen'),
(4252, 'https://ror.org/05278be16', 'es', 1, 'https://ror.org/05278be16 Hospital del Niño'),
(4253, 'https://ror.org/0527gjc91', 'en', 1, 'https://ror.org/0527gjc91 Temple Street Children''s University Hospital'),
(4254, 'https://ror.org/052963a64', 'en', 1, 'https://ror.org/052963a64 Ohio Northern University'),
(4255, 'https://ror.org/052dmyg58', 'en', 1, 'https://ror.org/052dmyg58 Greenville Memorial Hospital'),
(4256, 'https://ror.org/052fdp564', 'no_lang_code', 1, 'https://ror.org/052fdp564 Enel (Italy)'),
(4257, 'https://ror.org/052g5ww90', 'fr', 1, 'https://ror.org/052g5ww90 Hopital Universitaire Habib Bourguiba'),
(4258, 'https://ror.org/052jt6v75', 'pl', 1, 'https://ror.org/052jt6v75 Wojewódzki Szpital Zespolony im. Jędrzeja Śniadeckiego'),
(4259, 'https://ror.org/052k2q138', 'en', 1, 'https://ror.org/052k2q138 Shodair Children''s Hospital'),
(4260, 'https://ror.org/052qqbc08', 'en', 1, 'https://ror.org/052qqbc08 Michael E. DeBakey VA Medical Center'),
(4261, 'https://ror.org/052ra0j05', 'en', 1, 'https://ror.org/052ra0j05 Sinai Hospital'),
(4262, 'https://ror.org/052vjje65', 'en', 1, 'https://ror.org/052vjje65 Royal Manchester Children''s Hospital'),
(4263, 'https://ror.org/052vn2478', 'en', 1, 'https://ror.org/052vn2478 Liaocheng People''s Hospital 聊城市人民医院'),
(4264, 'https://ror.org/052w06y65', 'no_lang_code', 1, 'https://ror.org/052w06y65 Jaslok Hospital'),
(4265, 'https://ror.org/052w2jw50', 'fr', 1, 'https://ror.org/052w2jw50 Hôpital Saint-Jacques'),
(4266, 'https://ror.org/052wqwf92', 'en', 1, 'https://ror.org/052wqwf92 Shuto General Hospital 周東総合病院'),
(4267, 'https://ror.org/052zr0n46', 'en', 1, 'https://ror.org/052zr0n46 Institute for Medical Research and Occupational Health'),
(4268, 'https://ror.org/0531xck41', 'en', 1, 'https://ror.org/0531xck41 Southeastern Louisiana University Universidad del Sudeste de Luisiana'),
(4269, 'https://ror.org/05328fn02', 'en', 1, 'https://ror.org/05328fn02 Hermanos Ameijeiras Hospital Hospital Clínico Quirúrgico "Hermanos Ameijeiras"'),
(4270, 'https://ror.org/0532h0d08', 'en', 1, 'https://ror.org/0532h0d08 Deaconess Hospital'),
(4271, 'https://ror.org/0534awx66', 'en', 1, 'https://ror.org/0534awx66 Guangzhou Eighth People''s Hospital 广州市第八人民医院'),
(4272, 'https://ror.org/0534dba08', 'en', 1, 'https://ror.org/0534dba08 Tamil University தமிழ்ப் பல்கலைக்கழகம், தஞ்சாவூர் തമിഴ് സർവകലാശാല'),
(4273, 'https://ror.org/05359he25', 'no_lang_code', 1, 'https://ror.org/05359he25 Ibn Sina Hospital مستشفى ابن سينا'),
(4274, 'https://ror.org/0535c1v66', 'en', 1, 'https://ror.org/0535c1v66 Assam University असम विश्वविद्यालय আসাম বিশ্ববিদ্যালয়'),
(4275, 'https://ror.org/0535cbe18', 'en', 1, 'https://ror.org/0535cbe18 Kanazawa Medical University 金沢医科大学'),
(4276, 'https://ror.org/05362x394', 'en', 1, 'https://ror.org/05362x394 MRC Toxicology Unit'),
(4277, 'https://ror.org/053658081', 'en', 1, 'https://ror.org/053658081 Mitsubishi Kyoto Hospital 三菱京都病院'),
(4278, 'https://ror.org/05368pf49', 'en', 1, 'https://ror.org/05368pf49 Institute of the Pupils of the Army Instituto dos Pupilos do Exército'),
(4279, 'https://ror.org/05388sw24', 'en', 1, 'https://ror.org/05388sw24 University of South Alabama Medical Center'),
(4280, 'https://ror.org/053bqv655', 'no_lang_code', 1, 'https://ror.org/053bqv655 STMicroelectronics (Italy)'),
(4281, 'https://ror.org/053c75a48', 'en', 1, 'https://ror.org/053c75a48 East Texas Medical Center'),
(4282, 'https://ror.org/053d3tv41', 'en', 1, 'https://ror.org/053d3tv41 International University of Health and Welfare 国際医療福祉大学'),
(4283, 'https://ror.org/053d97e59', 'en', 1, 'https://ror.org/053d97e59 Kyung Hee University East-West Neo Medical Center 경희대학교 동서신의학병원 - 협진진료센터'),
(4284, 'https://ror.org/053darw66', 'en', 1, 'https://ror.org/053darw66 Martha-Maria Hospital'),
(4285, 'https://ror.org/053dkp921', 'en', 1, 'https://ror.org/053dkp921 Los Alamos Medical Center'),
(4286, 'https://ror.org/053exzj86', 'en', 1, 'https://ror.org/053exzj86 Miriam Hospital'),
(4287, 'https://ror.org/053eyjs84', 'en', 1, 'https://ror.org/053eyjs84 Princess Royal Maternity Hospital'),
(4288, 'https://ror.org/053fh2363', 'en', 1, 'https://ror.org/053fh2363 Benedictine University'),
(4289, 'https://ror.org/053fp5c05', 'en', 1, 'https://ror.org/053fp5c05 Ewha Womans University 이화여자대학교'),
(4290, 'https://ror.org/053fx7g25', 'en', 1, 'https://ror.org/053fx7g25 Royal Bolton Hospital'),
(4291, 'https://ror.org/053fzma23', 'en', 1, 'https://ror.org/053fzma23 Sichuan University of Science and Engineering 四川理工学院'),
(4292, 'https://ror.org/053gjjp11', 'tr', 1, 'https://ror.org/053gjjp11 Pamukkale Üniversitesi Hastaneleri'),
(4293, 'https://ror.org/053hkmn05', 'en', 1, 'https://ror.org/053hkmn05 Primary Children''s Hospital'),
(4294, 'https://ror.org/053kccs63', 'en', 1, 'https://ror.org/053kccs63 Osaka Dental University 大阪歯科大学'),
(4295, 'https://ror.org/053mxw461', 'en', 1, 'https://ror.org/053mxw461 Sevastopol National Technical University Севастопольский национальный технический университет Севастопольський національний технічний університет'),
(4296, 'https://ror.org/053ny5136', 'no_lang_code', 1, 'https://ror.org/053ny5136 Fujitsu (United Kingdom)'),
(4297, 'https://ror.org/053sj8m08', 'en', 1, 'https://ror.org/053sj8m08 Kenyatta National Hospital'),
(4298, 'https://ror.org/053v1pf86', 'no_lang_code', 1, 'https://ror.org/053v1pf86 Biomedical Development Corporation'),
(4299, 'https://ror.org/053vhdz56', 'en', 1, 'https://ror.org/053vhdz56 Ospedale di Santa Maria Nuova Santa Maria Nuova Hospital'),
(4300, 'https://ror.org/053vynf43', 'en', 1, 'https://ror.org/053vynf43 King Khaled Hospital مستشفى الملك خالد'),
(4301, 'https://ror.org/053xhbr86', 'en', 1, 'https://ror.org/053xhbr86 Ryhov Hospital Jönköping'),
(4302, 'https://ror.org/0540c8n94', 'no_lang_code', 1, 'https://ror.org/0540c8n94 Soka Municipal Hospital 草加市立病院'),
(4303, 'https://ror.org/05422jd13', 'en', 1, 'https://ror.org/05422jd13 University Children''s Hospital, Belgrade Univerzitetska dečja klinika u Beogradu'),
(4304, 'https://ror.org/0542q3127', 'en', 1, 'https://ror.org/0542q3127 Lviv Polytechnic National University Politechnika Lwowska Национальный университет «Львовская политехника» Національний університет «Львівська політехніка»'),
(4305, 'https://ror.org/054652k97', 'en', 1, 'https://ror.org/054652k97 Public Health – Seattle & King County'),
(4306, 'https://ror.org/0546wew42', 'en', 1, 'https://ror.org/0546wew42 New Jersey City University'),
(4307, 'https://ror.org/054876c03', 'tr', 1, 'https://ror.org/054876c03 Ankara Atatürk Göğüs Hastalıkları Ve Göğüs Cerrahisi Eğitim Ve Araştırma Hastanesi'),
(4308, 'https://ror.org/0549ak978', 'en', 1, 'https://ror.org/0549ak978 Gifu Red Cross Hospital 岐阜赤十字病院'),
(4309, 'https://ror.org/054bptx32', 'fr', 1, 'https://ror.org/054bptx32 Hôpital Maison Blanche'),
(4310, 'https://ror.org/054dq5m81', 'no_lang_code', 1, 'https://ror.org/054dq5m81 Universal Hi-Tech Development'),
(4311, 'https://ror.org/054e9ag92', 'en', 1, 'https://ror.org/054e9ag92 Chang Gung Children''s Hospital'),
(4312, 'https://ror.org/054ekwz94', 'en', 1, 'https://ror.org/054ekwz94 Queen Margaret Hospital'),
(4313, 'https://ror.org/054ezs277', 'en', 1, 'https://ror.org/054ezs277 Framingham Union Hospital'),
(4314, 'https://ror.org/054gzqw08', 'en', 1, 'https://ror.org/054gzqw08 Central Connecticut State University Universidad Estatal de Connecticut Central'),
(4315, 'https://ror.org/054kr1687', 'en', 1, 'https://ror.org/054kr1687 Holy Cross Hospital'),
(4316, 'https://ror.org/054nax084', 'en', 1, 'https://ror.org/054nax084 Clinical Centre of Kragujevac Клинички центар Крагујевац'),
(4317, 'https://ror.org/054p2n359', 'en', 1, 'https://ror.org/054p2n359 Arkansas Department of Health'),
(4318, 'https://ror.org/054qnke07', 'en', 1, 'https://ror.org/054qnke07 Ningbo No.6 Hospital 宁波市第六医院'),
(4319, 'https://ror.org/054zbmd26', 'en', 1, 'https://ror.org/054zbmd26 Hera General Hospital'),
(4320, 'https://ror.org/054zv1w86', 'no_lang_code', 1, 'https://ror.org/054zv1w86 Glencore (Switzerland)'),
(4321, 'https://ror.org/05529q263', 'en', 1, 'https://ror.org/05529q263 Chungbuk National University Hospital'),
(4322, 'https://ror.org/055546q82', 'en', 1, 'https://ror.org/055546q82 Bộ Y tế (Việt Nam) Ministry of Health'),
(4323, 'https://ror.org/05564r514', 'en', 1, 'https://ror.org/05564r514 Association of European Renewable Energy Research Centres'),
(4324, 'https://ror.org/05586rd65', 'nl', 1, 'https://ror.org/05586rd65 Kiwa'),
(4325, 'https://ror.org/055aebe25', 'no_lang_code', 1, 'https://ror.org/055aebe25 CRE Group (United States)'),
(4326, 'https://ror.org/055awd420', 'fr', 1, 'https://ror.org/055awd420 Hôpital de Sion'),
(4327, 'https://ror.org/055bpw879', 'en', 1, 'https://ror.org/055bpw879 MRC Cognition and Brain Sciences Unit'),
(4328, 'https://ror.org/055d6gv91', 'en', 1, 'https://ror.org/055d6gv91 Middlemore Hospital'),
(4329, 'https://ror.org/055epge17', 'en', 1, 'https://ror.org/055epge17 Arkansas Foundation for Medical Care'),
(4330, 'https://ror.org/055f7t516', 'en', 1, 'https://ror.org/055f7t516 National Research University Higher School of Economics Высшая школа экономики Юғары иҡтисад мәктәбе'),
(4331, 'https://ror.org/055fgjp51', 'no_lang_code', 1, 'https://ror.org/055fgjp51 Nimbus Landscape Materials (United States)'),
(4332, 'https://ror.org/055gkcy74', 'en', 1, 'https://ror.org/055gkcy74 Union Hospital'),
(4333, 'https://ror.org/055gq1960', 'no_lang_code', 1, 'https://ror.org/055gq1960 Ada Technologies (United States)'),
(4334, 'https://ror.org/055hhmc29', 'en', 1, 'https://ror.org/055hhmc29 Oregon Department of Human Services'),
(4335, 'https://ror.org/055k2e754', 'en', 1, 'https://ror.org/055k2e754 Baltimore County Department of Health'),
(4336, 'https://ror.org/055m2tx54', 'en', 1, 'https://ror.org/055m2tx54 North Eastern Hill University نارتھ ایسٹ ہل یونیورسٹی'),
(4337, 'https://ror.org/055mfda29', 'en', 1, 'https://ror.org/055mfda29 Earth and Space Research'),
(4338, 'https://ror.org/055mfza47', 'en', 1, 'https://ror.org/055mfza47 Saint Peter''s University Hospital'),
(4339, 'https://ror.org/055p2yz63', 'es', 1, 'https://ror.org/055p2yz63 Hospital General Universitario de Albacete'),
(4340, 'https://ror.org/055redd10', 'it', 1, 'https://ror.org/055redd10 Azienda Ospedaliera di Desio e Vimercate'),
(4341, 'https://ror.org/055vbxf86', 'en', 1, 'https://ror.org/055vbxf86 Addenbrooke''s Hospital'),
(4342, 'https://ror.org/055xb4311', 'en', 1, 'https://ror.org/055xb4311 Austrian Agency for Health and Food Safety Österreichische Agentur für Gesundheit und Ernährungssicherheit'),
(4343, 'https://ror.org/055y34y19', 'en', 1, 'https://ror.org/055y34y19 Rose Medical Center'),
(4344, 'https://ror.org/055ysan77', 'no_lang_code', 1, 'https://ror.org/055ysan77 Klein Buendel (United States)'),
(4345, 'https://ror.org/055zmrh94', 'en', 1, 'https://ror.org/055zmrh94 John Innes Centre'),
(4346, 'https://ror.org/0560hqd63', 'it', 1, 'https://ror.org/0560hqd63 Ospedale Monaldi'),
(4347, 'https://ror.org/0560xr487', 'en', 1, 'https://ror.org/0560xr487 DR. B.R.A. Institute Rotary Cancer Hospital'),
(4348, 'https://ror.org/056221z03', 'en', 1, 'https://ror.org/056221z03 Centre Hospitalier Universitaire de Treichville University Hospital Medical Center at Treichville'),
(4349, 'https://ror.org/0566w5t03', 'en', 1, 'https://ror.org/0566w5t03 United States Office of Personnel Management'),
(4350, 'https://ror.org/0567p6j84', 'en', 1, 'https://ror.org/0567p6j84 Stanley Medical College இசுடான்லி மருத்துவக் கல்லூரி'),
(4351, 'https://ror.org/0567w8j84', 'en', 1, 'https://ror.org/0567w8j84 Bowie State University'),
(4352, 'https://ror.org/0569bbe51', 'en', 1, 'https://ror.org/0569bbe51 Connecticut Mental Health Center'),
(4353, 'https://ror.org/056a2fb24', 'no_lang_code', 1, 'https://ror.org/056a2fb24 Nanoprobes (United States)'),
(4354, 'https://ror.org/056cn0e37', 'en', 1, 'https://ror.org/056cn0e37 Seoul St. Mary''s Hospital'),
(4355, 'https://ror.org/056d7mp27', 'no_lang_code', 1, 'https://ror.org/056d7mp27 Applied Biological Materials (Canada)'),
(4356, 'https://ror.org/056dkgp19', 'en', 1, 'https://ror.org/056dkgp19 Health Forecasting'),
(4357, 'https://ror.org/056ep7w45', 'en', 1, 'https://ror.org/056ep7w45 Siksha O Anusandhan University'),
(4358, 'https://ror.org/056mx1477', 'en', 1, 'https://ror.org/056mx1477 Children''s Hospital at Dartmouth Hitchcock'),
(4359, 'https://ror.org/056nn5n22', 'en', 1, 'https://ror.org/056nn5n22 Aurora Sinai Medical Center'),
(4360, 'https://ror.org/056p2ex35', 'en', 1, 'https://ror.org/056p2ex35 Asir Central Hospital مستشفى عسير المركزي'),
(4361, 'https://ror.org/056pbvy42', 'it', 1, 'https://ror.org/056pbvy42 Ospedale di Monfalcone'),
(4362, 'https://ror.org/056pg9759', 'en', 1, 'https://ror.org/056pg9759 SSM Health Care'),
(4363, 'https://ror.org/056phcb82', 'en', 1, 'https://ror.org/056phcb82 The Keystone Center'),
(4364, 'https://ror.org/056q45h83', 'es', 1, 'https://ror.org/056q45h83 Hospital Doctor Hernán Henríquez Aravena'),
(4365, 'https://ror.org/056r5vk88', 'en', 1, 'https://ror.org/056r5vk88 Penza State University Пензенский государственный университет'),
(4366, 'https://ror.org/056rage58', 'en', 1, 'https://ror.org/056rage58 Indira Gandhi Medical College'),
(4367, 'https://ror.org/056rp9e47', 'en', 1, 'https://ror.org/056rp9e47 Metropolitan State University'),
(4368, 'https://ror.org/056rz0f32', 'no_lang_code', 1, 'https://ror.org/056rz0f32 Virtually Better'),
(4369, 'https://ror.org/056sm7z81', 'en', 1, 'https://ror.org/056sm7z81 Council of Chief State School Officers'),
(4370, 'https://ror.org/056t4gr41', 'no_lang_code', 1, 'https://ror.org/056t4gr41 Morinomiya Hospital もりのみや ほｓぴたｌ'),
(4371, 'https://ror.org/056t5qz59', 'no_lang_code', 1, 'https://ror.org/056t5qz59 Fortis Hospital'),
(4372, 'https://ror.org/056tb3809', 'de', 1, 'https://ror.org/056tb3809 Kantonsspital Aarau'),
(4373, 'https://ror.org/056v1sx90', 'en', 1, 'https://ror.org/056v1sx90 Nicosia General Hospital'),
(4374, 'https://ror.org/056wg8a82', 'en', 1, 'https://ror.org/056wg8a82 Le Bonheur Children''s Hospital'),
(4375, 'https://ror.org/056y2f070', 'no_lang_code', 1, 'https://ror.org/056y2f070 Agios Andreas Hospital Γενικό Νοσοκομείο Πατρών'),
(4376, 'https://ror.org/056yje678', 'fr', 1, 'https://ror.org/056yje678 Hôpital Mustapha Pacha'),
(4377, 'https://ror.org/056zv5g90', 'en', 1, 'https://ror.org/056zv5g90 Jinnah University for Women جناح یونیورسٹی برائے خواتین'),
(4378, 'https://ror.org/05735fh94', 'en', 1, 'https://ror.org/05735fh94 Gujarat Ayurved University गुजरात आयुर्वेद विश्वविद्यालय ગુજરાત આયુર્વેદ યુનિવર્સિટી'),
(4379, 'https://ror.org/0573hvw69', 'tr', 1, 'https://ror.org/0573hvw69 Farabi Hastanesi'),
(4380, 'https://ror.org/0573ts924', 'en', 1, 'https://ror.org/0573ts924 Princess Royal Hospital'),
(4381, 'https://ror.org/0574j1p50', 'ro', 1, 'https://ror.org/0574j1p50 Spitalul Clinic de Recuperare'),
(4382, 'https://ror.org/05757k612', 'en', 1, 'https://ror.org/05757k612 Sree Chitra Thirunal Institute for Medical Sciences and Technology'),
(4383, 'https://ror.org/0576bwz31', 'no_lang_code', 1, 'https://ror.org/0576bwz31 Aizawa Hospital 相澤病院'),
(4384, 'https://ror.org/05783y657', 'en', 1, 'https://ror.org/05783y657 Smith-Kettlewell Eye Research Institute'),
(4385, 'https://ror.org/057anza51', 'en', 1, 'https://ror.org/057anza51 Metropolitan University of Educational Sciences Universidad Metropolitana de Ciencias de la Educación'),
(4386, 'https://ror.org/057ays557', 'no_lang_code', 1, 'https://ror.org/057ays557 Kestrel Corporation'),
(4387, 'https://ror.org/057b2d479', 'pt', 1, 'https://ror.org/057b2d479 Hospital Maria Pia'),
(4388, 'https://ror.org/057cm0m66', 'en', 1, 'https://ror.org/057cm0m66 Sismanoglio General Hospital Γενικό Νοσοκομείο Σισμανόγλειο'),
(4389, 'https://ror.org/057d2v504', 'en', 1, 'https://ror.org/057d2v504 Kohat University of Science and Technology'),
(4390, 'https://ror.org/057e34m22', 'en', 1, 'https://ror.org/057e34m22 University of Massachusetts Donahue Institute'),
(4391, 'https://ror.org/057edve92', 'en', 1, 'https://ror.org/057edve92 Tokyo Yamate Medical Center 東京山手メディカルセンター'),
(4392, 'https://ror.org/057ft1y03', 'no_lang_code', 1, 'https://ror.org/057ft1y03 Kochi Municipal Central Hospital 高知県立中央病院'),
(4393, 'https://ror.org/057jp7h82', 'en', 1, 'https://ror.org/057jp7h82 IIT Research Institute'),
(4394, 'https://ror.org/057n8mx64', 'en', 1, 'https://ror.org/057n8mx64 Ministry of Health وزارة الصحة'),
(4395, 'https://ror.org/057nqxc22', 'en', 1, 'https://ror.org/057nqxc22 West Virginia Wesleyan College'),
(4396, 'https://ror.org/057p7h461', 'en', 1, 'https://ror.org/057p7h461 Affiliated Hospital of Guangdong Medical College Hospital'),
(4397, 'https://ror.org/057pdzy92', 'es', 1, 'https://ror.org/057pdzy92 Hospital del Trabajador'),
(4398, 'https://ror.org/057q4rt57', 'en', 1, 'https://ror.org/057q4rt57 Hospital for Sick Children'),
(4399, 'https://ror.org/057s4cx47', 'no_lang_code', 1, 'https://ror.org/057s4cx47 Katsumata Hospital 勝又病院'),
(4400, 'https://ror.org/057seh071', 'en', 1, 'https://ror.org/057seh071 Franklin Institute'),
(4401, 'https://ror.org/057v2pg43', 'fr', 1, 'https://ror.org/057v2pg43 Hôpital Saint-Michel'),
(4402, 'https://ror.org/057vt8c33', 'fr', 1, 'https://ror.org/057vt8c33 Hôpital Paule de Viguier'),
(4403, 'https://ror.org/057vy9683', 'en', 1, 'https://ror.org/057vy9683 Hamamatsu University 浜松大学'),
(4404, 'https://ror.org/057wh9709', 'fr', 1, 'https://ror.org/057wh9709 Centre hospitalier Robert-Ballanger'),
(4405, 'https://ror.org/057xx1h21', 'en', 1, 'https://ror.org/057xx1h21 Association Médicale Canadienne Canadian Medical Association'),
(4406, 'https://ror.org/057y6sk36', 'en', 1, 'https://ror.org/057y6sk36 National Institute of Biomedical Genomics'),
(4407, 'https://ror.org/057z0pt68', 'en', 1, 'https://ror.org/057z0pt68 Kansas Department for Children and Families'),
(4408, 'https://ror.org/05819fq78', 'en', 1, 'https://ror.org/05819fq78 Punjab Institute of Medical Sciences'),
(4409, 'https://ror.org/0582gcw47', 'en', 1, 'https://ror.org/0582gcw47 Medical Research Institute'),
(4410, 'https://ror.org/05831wz16', 'en', 1, 'https://ror.org/05831wz16 Republic of Palau Ministry of Health'),
(4411, 'https://ror.org/0583jne22', 'en', 1, 'https://ror.org/0583jne22 Northwest Research Associates'),
(4412, 'https://ror.org/0584fj407', 'en', 1, 'https://ror.org/0584fj407 University of North Alabama'),
(4413, 'https://ror.org/0586a5g03', 'no_lang_code', 1, 'https://ror.org/0586a5g03 Clinical Tools, Inc.'),
(4414, 'https://ror.org/0586bt104', 'en', 1, 'https://ror.org/0586bt104 Southport and Ormskirk Hospital NHS Trust'),
(4415, 'https://ror.org/0587whv30', 'no_lang_code', 1, 'https://ror.org/0587whv30 Nexeon (United Kingdom)'),
(4416, 'https://ror.org/0589bxs97', 'en', 1, 'https://ror.org/0589bxs97 McGill University and Génome Québec Innovation Centre'),
(4417, 'https://ror.org/058c4h389', 'no_lang_code', 1, 'https://ror.org/058c4h389 Atom Sciences'),
(4418, 'https://ror.org/058fy8f68', 'en', 1, 'https://ror.org/058fy8f68 Govind Ballabh Pant Hospital'),
(4419, 'https://ror.org/058hnhf91', 'en', 1, 'https://ror.org/058hnhf91 Oral Roberts University'),
(4420, 'https://ror.org/058hsp657', 'en', 1, 'https://ror.org/058hsp657 Hospital of Lithuanian University of Health Sciences Kaunas Clinics Lietuvos sveikatos mokslų universiteto ligoninė Kauno klinikos'),
(4421, 'https://ror.org/058kbr222', 'no_lang_code', 1, 'https://ror.org/058kbr222 Qurient (South Korea)'),
(4422, 'https://ror.org/058ms9w43', 'en', 1, 'https://ror.org/058ms9w43 Fujian Provincial Cancer Hospital 福建省肿瘤医院'),
(4423, 'https://ror.org/058p1kn93', 'en', 1, 'https://ror.org/058p1kn93 VA Long Beach Healthcare System'),
(4424, 'https://ror.org/058pdbn81', 'no_lang_code', 1, 'https://ror.org/058pdbn81 Dankook University 단국대학교'),
(4425, 'https://ror.org/058peea52', 'en', 1, 'https://ror.org/058peea52 Sharp Cabrillo Hospital'),
(4426, 'https://ror.org/058prbp42', 'en', 1, 'https://ror.org/058prbp42 Shaikh Zayed Postgraduate Medical Institute شیخ زید پوسٹ گریجویٹ میڈیکل انسٹی ٹیوٹ'),
(4427, 'https://ror.org/058q6m856', 'en', 1, 'https://ror.org/058q6m856 Medical Trust Hospital'),
(4428, 'https://ror.org/058qp7v13', 'en', 1, 'https://ror.org/058qp7v13 BGS Global Hospital'),
(4429, 'https://ror.org/058rkm744', 'en', 1, 'https://ror.org/058rkm744 Niabi Zoological Society'),
(4430, 'https://ror.org/058rxv392', 'en', 1, 'https://ror.org/058rxv392 University Hospital of North Tees'),
(4431, 'https://ror.org/058s20p71', 'en', 1, 'https://ror.org/058s20p71 Public Health Foundation of India భారత ప్రజారోగ్య సమాఖ్య'),
(4432, 'https://ror.org/058s98e36', 'en', 1, 'https://ror.org/058s98e36 Promotion of Operational Links With Integrated Services'),
(4433, 'https://ror.org/058td2q88', 'fr', 1, 'https://ror.org/058td2q88 Hôpital Foch'),
(4434, 'https://ror.org/058w59113', 'en', 1, 'https://ror.org/058w59113 Des Moines University Université de des moines'),
(4435, 'https://ror.org/058x7dy48', 'en', 1, 'https://ror.org/058x7dy48 Royal United Hospital Bath NHS Trust'),
(4436, 'https://ror.org/058xqe166', 'en', 1, 'https://ror.org/058xqe166 Kingston Hospital NHS Trust'),
(4437, 'https://ror.org/058ydcm32', 'en', 1, 'https://ror.org/058ydcm32 Kaiser Foundation Hospital'),
(4438, 'https://ror.org/058yxq906', 'en', 1, 'https://ror.org/058yxq906 Nikko Memorial Hospital 日鋼記念病院'),
(4439, 'https://ror.org/0595gz585', 'en', 1, 'https://ror.org/0595gz585 University of Gondar'),
(4440, 'https://ror.org/0596qfc35', 'en', 1, 'https://ror.org/0596qfc35 Kaweah Delta Health Care District'),
(4441, 'https://ror.org/0599zba67', 'tr', 1, 'https://ror.org/0599zba67 Kent Hastanesi Kent Hospital'),
(4442, 'https://ror.org/059c3mv67', 'en', 1, 'https://ror.org/059c3mv67 Cambridge Health Alliance'),
(4443, 'https://ror.org/059cjpv64', 'en', 1, 'https://ror.org/059cjpv64 Second Affiliated Hospital of Zhejiang University'),
(4444, 'https://ror.org/059dkdx38', 'en', 1, 'https://ror.org/059dkdx38 National Taiwan Normal University'),
(4445, 'https://ror.org/059dqb057', 'en', 1, 'https://ror.org/059dqb057 American Chemical Society'),
(4446, 'https://ror.org/059ebsr57', 'es', 1, 'https://ror.org/059ebsr57 Hospital Universitario de San Vicente Fundación'),
(4447, 'https://ror.org/059ex7y15', 'en', 1, 'https://ror.org/059ex7y15 Instytut Centrum Zdrowia Matki Polki w Łodzi Polish Mother’s Memorial Hospital Research Institute'),
(4448, 'https://ror.org/059f2k568', 'en', 1, 'https://ror.org/059f2k568 Ministry of Health'),
(4449, 'https://ror.org/059g69b28', 'en', 1, 'https://ror.org/059g69b28 Dong-Eui University 동의대학교'),
(4450, 'https://ror.org/059h1d250', 'en', 1, 'https://ror.org/059h1d250 Muljibhai Patel Urological Hospital'),
(4451, 'https://ror.org/059jq5127', 'en', 1, 'https://ror.org/059jq5127 Harborview Medical Center'),
(4452, 'https://ror.org/059kfmf89', 'fr', 1, 'https://ror.org/059kfmf89 Centre hospitalier régional de la Citadelle'),
(4453, 'https://ror.org/059qg2m13', 'en', 1, 'https://ror.org/059qg2m13 Japan Agency for Marine-Earth Science and Technology 海洋研究開発機構'),
(4454, 'https://ror.org/059w0gb06', 'en', 1, 'https://ror.org/059w0gb06 Karakalpak State University'),
(4455, 'https://ror.org/059wef195', 'en', 1, 'https://ror.org/059wef195 Nishi Niigata Chuo National Hospital 国立病院機構西新潟中央病院'),
(4456, 'https://ror.org/059x21724', 'en', 1, 'https://ror.org/059x21724 University of Yamanashi 山梨大学'),
(4457, 'https://ror.org/059x9n677', 'no_lang_code', 1, 'https://ror.org/059x9n677 Eulji General Hospital 을지대학교병원'),
(4458, 'https://ror.org/059xepj08', 'en', 1, 'https://ror.org/059xepj08 Akron General Medical Center'),
(4459, 'https://ror.org/059xmmg10', 'en', 1, 'https://ror.org/059xmmg10 Eastern Mennonite University'),
(4460, 'https://ror.org/059xnz004', 'en', 1, 'https://ror.org/059xnz004 Christ Hospital'),
(4461, 'https://ror.org/059y9v737', 'en', 1, 'https://ror.org/059y9v737 Central College'),
(4462, 'https://ror.org/05a01hn31', 'en', 1, 'https://ror.org/05a01hn31 Mater Dei Hospital'),
(4463, 'https://ror.org/05a064c11', 'no_lang_code', 1, 'https://ror.org/05a064c11 Caisson Laboratories (United States)'),
(4464, 'https://ror.org/05a15z872', 'en', 1, 'https://ror.org/05a15z872 Samsung Medical Center'),
(4465, 'https://ror.org/05a2agx14', 'en', 1, 'https://ror.org/05a2agx14 Crouse Hospital'),
(4466, 'https://ror.org/05a3efx98', 'no_lang_code', 1, 'https://ror.org/05a3efx98 Metropolitan Hospital'),
(4467, 'https://ror.org/05a3jmv43', 'no_lang_code', 1, 'https://ror.org/05a3jmv43 Format International Ltd'),
(4468, 'https://ror.org/05a79ds67', 'no_lang_code', 1, 'https://ror.org/05a79ds67 Bhatia Hospital'),
(4469, 'https://ror.org/05a7hcs31', 'en', 1, 'https://ror.org/05a7hcs31 Providence Health & Services Oregon and Southwest Washington'),
(4470, 'https://ror.org/05a90fj07', 'en', 1, 'https://ror.org/05a90fj07 Ealing Hospital'),
(4471, 'https://ror.org/05aczzj13', 'en', 1, 'https://ror.org/05aczzj13 Shumei University 秀明大学'),
(4472, 'https://ror.org/05aem0d44', 'en', 1, 'https://ror.org/05aem0d44 Francis Hospital Franziskus Hospital Bielefeld'),
(4473, 'https://ror.org/05aeshm06', 'en', 1, 'https://ror.org/05aeshm06 Governador Celso Ramos Hospital'),
(4474, 'https://ror.org/05afnhv08', 'en', 1, 'https://ror.org/05afnhv08 Sapporo National Hospital 国立病院機構北海道がんセンター'),
(4475, 'https://ror.org/05ahq3q81', 'en', 1, 'https://ror.org/05ahq3q81 Amersham Hospital'),
(4476, 'https://ror.org/05ajyt645', 'en', 1, 'https://ror.org/05ajyt645 Japanese Red Cross Society Wakayama Medical Center 日本赤十字社和歌山医療センター'),
(4477, 'https://ror.org/05am5g719', 'en', 1, 'https://ror.org/05am5g719 St Mark''s Hospital'),
(4478, 'https://ror.org/05apdps44', 'en', 1, 'https://ror.org/05apdps44 Raigmore Hospital'),
(4479, 'https://ror.org/05aqcx827', 'en', 1, 'https://ror.org/05aqcx827 Ayrshire Central Hospital'),
(4480, 'https://ror.org/05arfhc56', 'en', 1, 'https://ror.org/05arfhc56 University of Rajasthan Université du rajasthan राजस्थान विश्वविद्यालय ਰਾਜਸਥਾਨ ਯੂਨੀਵਰਸਿਟੀ'),
(4481, 'https://ror.org/05atemp08', 'en', 1, 'https://ror.org/05atemp08 MedStar Health'),
(4482, 'https://ror.org/05atz9219', 'en', 1, 'https://ror.org/05atz9219 East Stroudsburg University Université de pennsylvanie d''east stroudsburg'),
(4483, 'https://ror.org/05av4b478', 'en', 1, 'https://ror.org/05av4b478 Sri Dharmasthala Manjunatheshwara College of Dental Sciences & Hospital'),
(4484, 'https://ror.org/05ayf4d73', 'en', 1, 'https://ror.org/05ayf4d73 Southlake Regional Health Center'),
(4485, 'https://ror.org/05aykvr94', 'de', 1, 'https://ror.org/05aykvr94 Augusta Krankenhaus'),
(4486, 'https://ror.org/05azzyk65', 'en', 1, 'https://ror.org/05azzyk65 Piedmont Athens Regional'),
(4487, 'https://ror.org/05b01nv96', 'en', 1, 'https://ror.org/05b01nv96 Subang Jaya Medical Centre'),
(4488, 'https://ror.org/05b0gpy83', 'en', 1, 'https://ror.org/05b0gpy83 Center for Forensic Mental Health, Chiba University 千葉大学 社会精神保健研究センター'),
(4489, 'https://ror.org/05b45bk66', 'en', 1, 'https://ror.org/05b45bk66 Regional Environmental Center for Central and Eastern Europe'),
(4490, 'https://ror.org/05b6ypc36', 'no_lang_code', 1, 'https://ror.org/05b6ypc36 Volvo (Sweden) Volvokoncernen'),
(4491, 'https://ror.org/05b81av32', 'en', 1, 'https://ror.org/05b81av32 Luton and Dunstable Hospital'),
(4492, 'https://ror.org/05b8yvg40', 'en', 1, 'https://ror.org/05b8yvg40 Barnsley Hospital'),
(4493, 'https://ror.org/05bd2wa15', 'en', 1, 'https://ror.org/05bd2wa15 Shanghai Mental Health Center 上海市精神卫生中心'),
(4494, 'https://ror.org/05bhd7f62', 'en', 1, 'https://ror.org/05bhd7f62 458th Hospital PLA 中国人民解放军第四五八'),
(4495, 'https://ror.org/05bjm5v11', 'no_lang_code', 1, 'https://ror.org/05bjm5v11 Sibtech (United States)'),
(4496, 'https://ror.org/05bpnne23', 'en', 1, 'https://ror.org/05bpnne23 MetroWest Medical Center'),
(4497, 'https://ror.org/05bq1qp94', 'en', 1, 'https://ror.org/05bq1qp94 Forrest General Hospital'),
(4498, 'https://ror.org/05brmpx55', 'en', 1, 'https://ror.org/05brmpx55 John F. Kennedy Medical Center'),
(4499, 'https://ror.org/05bt0cf40', 'tr', 1, 'https://ror.org/05bt0cf40 Okmeydanı Eğitim ve Araştırma Hastanesi'),
(4500, 'https://ror.org/05btaka91', 'no_lang_code', 1, 'https://ror.org/05btaka91 University of Veterinary Medicine in Košice Univerzita veterinárskeho lekárstva a farmácie v Košiciach'),
(4501, 'https://ror.org/05bx1gz93', 'en', 1, 'https://ror.org/05bx1gz93 Utsunomiya University 宇都宮大学'),
(4502, 'https://ror.org/05bxb3784', 'no_lang_code', 1, 'https://ror.org/05bxb3784 Academia Sinica 中央研究院'),
(4503, 'https://ror.org/05by5hm18', 'en', 1, 'https://ror.org/05by5hm18 California State Polytechnic University Universidad Estatal Politécnica de California, Pomona Université d''État polytechnique de californie à pomona'),
(4504, 'https://ror.org/05bz1tw26', 'pt', 1, 'https://ror.org/05bz1tw26 Hospital de Santa Maria'),
(4505, 'https://ror.org/05c06ww48', 'no_lang_code', 1, 'https://ror.org/05c06ww48 Anjo Kosei Hospital 安城更生病院'),
(4506, 'https://ror.org/05c2p1f98', 'hi', 1, 'https://ror.org/05c2p1f98 Devi Ahilya Vishwavidyalaya, देवि अहिल्या विश्वविद्यालय'),
(4507, 'https://ror.org/05c3wfp46', 'en', 1, 'https://ror.org/05c3wfp46 Governor''s Institutes of Vermont'),
(4508, 'https://ror.org/05c4nx247', 'en', 1, 'https://ror.org/05c4nx247 B.C. Women''s Hospital & Health Centre'),
(4509, 'https://ror.org/05c5js686', 'en', 1, 'https://ror.org/05c5js686 Ashland University'),
(4510, 'https://ror.org/05c8e3213', 'no_lang_code', 1, 'https://ror.org/05c8e3213 Saiseikai Fukuoka General Hospital 済生会福岡総合病院'),
(4511, 'https://ror.org/05cetba26', 'en', 1, 'https://ror.org/05cetba26 Edward Hospital'),
(4512, 'https://ror.org/05cggb038', 'no_lang_code', 1, 'https://ror.org/05cggb038 Teck (Canada)'),
(4513, 'https://ror.org/05cqhmv85', 'en', 1, 'https://ror.org/05cqhmv85 SangStat Medical Corporation'),
(4514, 'https://ror.org/05crbcr45', 'en', 1, 'https://ror.org/05crbcr45 Tokyo University of Agriculture 東京農業大学'),
(4515, 'https://ror.org/05crs8s98', 'en', 1, 'https://ror.org/05crs8s98 Periyar University பெரியார் பல்கலைக்கழகம்'),
(4516, 'https://ror.org/05csdwp88', 'en', 1, 'https://ror.org/05csdwp88 Greenslopes Private Hospital'),
(4517, 'https://ror.org/05ct0ag17', 'en', 1, 'https://ror.org/05ct0ag17 Banner Estrella Medical Center'),
(4518, 'https://ror.org/05ct3pv92', 'no_lang_code', 1, 'https://ror.org/05ct3pv92 Lanxess (Canada)'),
(4519, 'https://ror.org/05cvd2j85', 'pt', 1, 'https://ror.org/05cvd2j85 Hospital de Santa Marta'),
(4520, 'https://ror.org/05cwpz219', 'en', 1, 'https://ror.org/05cwpz219 Riverview Hospital'),
(4521, 'https://ror.org/05cx69s52', 'en', 1, 'https://ror.org/05cx69s52 Command Hospital Air Force'),
(4522, 'https://ror.org/05cz6df97', 'en', 1, 'https://ror.org/05cz6df97 Alabama Department of Mental Health'),
(4523, 'https://ror.org/05d2xpa49', 'en', 1, 'https://ror.org/05d2xpa49 First Hospital of Lanzhou University'),
(4524, 'https://ror.org/05d503a40', 'en', 1, 'https://ror.org/05d503a40 Iwate Prefectural Kamaishi Hospital'),
(4525, 'https://ror.org/05d576879', 'en', 1, 'https://ror.org/05d576879 Southmead Hospital'),
(4526, 'https://ror.org/05d5vvz89', 'en', 1, 'https://ror.org/05d5vvz89 First Affiliated Hospital of Jinan University 暨南大学附属第一医院'),
(4527, 'https://ror.org/05d5yjx85', 'es', 1, 'https://ror.org/05d5yjx85 Hospital Militar de Santiago'),
(4528, 'https://ror.org/05d6v2h63', 'fr', 1, 'https://ror.org/05d6v2h63 Hôpital Manchester'),
(4529, 'https://ror.org/05d871a36', 'en', 1, 'https://ror.org/05d871a36 Saifee Hospital'),
(4530, 'https://ror.org/05d9dtr71', 'en', 1, 'https://ror.org/05d9dtr71 Changhua Christian Hospital'),
(4531, 'https://ror.org/05d9wmt54', 'no_lang_code', 1, 'https://ror.org/05d9wmt54 Mpilo Central Hospital'),
(4532, 'https://ror.org/05db3sk67', 'en', 1, 'https://ror.org/05db3sk67 New Jewish Home'),
(4533, 'https://ror.org/05dbe0q91', 'en', 1, 'https://ror.org/05dbe0q91 Warren Spring Laboratory'),
(4534, 'https://ror.org/05dd3wr66', 'en', 1, 'https://ror.org/05dd3wr66 Huntsman Marine Science Centre'),
(4535, 'https://ror.org/05deks119', 'en', 1, 'https://ror.org/05deks119 Mount Sinai Hospital'),
(4536, 'https://ror.org/05dfcz246', 'en', 1, 'https://ror.org/05dfcz246 Tianjin University of Traditional Chinese Medicine 天津中医药大学'),
(4537, 'https://ror.org/05dfdta49', 'en', 1, 'https://ror.org/05dfdta49 Aultman Health Foundation'),
(4538, 'https://ror.org/05dfzd836', 'es', 1, 'https://ror.org/05dfzd836 Hospital Universitario Infanta Sofía'),
(4539, 'https://ror.org/05dhw1e18', 'no_lang_code', 1, 'https://ror.org/05dhw1e18 Kinan Hospital'),
(4540, 'https://ror.org/05dkqa017', 'en', 1, 'https://ror.org/05dkqa017 Hochschule Kaiserslautern University of Applied Sciences Kaiserslautern'),
(4541, 'https://ror.org/05dm4ck87', 'en', 1, 'https://ror.org/05dm4ck87 Emory University Hospital'),
(4542, 'https://ror.org/05dm6kv37', 'en', 1, 'https://ror.org/05dm6kv37 Institute of Child and Mother Health'),
(4543, 'https://ror.org/05dna8580', 'de', 1, 'https://ror.org/05dna8580 VDI/VDE Innovation + Technik'),
(4544, 'https://ror.org/05dp7wz77', 'en', 1, 'https://ror.org/05dp7wz77 Creative Health Care Management'),
(4545, 'https://ror.org/05drcjw53', 'en', 1, 'https://ror.org/05drcjw53 Pai Chai University 배재대학교'),
(4546, 'https://ror.org/05dsgrz38', 'en', 1, 'https://ror.org/05dsgrz38 Hawaii Permanente Medical Group'),
(4547, 'https://ror.org/05dt3h538', 'en', 1, 'https://ror.org/05dt3h538 Hollins University'),
(4548, 'https://ror.org/05dtqka83', 'hu', 1, 'https://ror.org/05dtqka83 Békés Megyei Központi Kórház'),
(4549, 'https://ror.org/05dxmex87', 'en', 1, 'https://ror.org/05dxmex87 Minnesota Medical Association'),
(4550, 'https://ror.org/05dzhka64', 'en', 1, 'https://ror.org/05dzhka64 Dr. Agarwal''s Eye Hospital'),
(4551, 'https://ror.org/05dzsmt79', 'no', 1, 'https://ror.org/05dzsmt79 Helse Førde'),
(4552, 'https://ror.org/05e1xz016', 'en', 1, 'https://ror.org/05e1xz016 Shalvata Mental Health Center המרכז לבריאות הנפש שלוותה'),
(4553, 'https://ror.org/05e247w35', 'en', 1, 'https://ror.org/05e247w35 Morristown Hamblen Hospital Foundation'),
(4554, 'https://ror.org/05e272m53', 'en', 1, 'https://ror.org/05e272m53 Munroe Regional Medical Center'),
(4555, 'https://ror.org/05e3rkh95', 'en', 1, 'https://ror.org/05e3rkh95 Sweet Briar College'),
(4556, 'https://ror.org/05e8jge82', 'en', 1, 'https://ror.org/05e8jge82 Auckland City Hospital'),
(4557, 'https://ror.org/05eb9pt23', 'en', 1, 'https://ror.org/05eb9pt23 Methodist Dallas Medical Center'),
(4558, 'https://ror.org/05ecec111', 'en', 1, 'https://ror.org/05ecec111 Bạch Mai Hospital Bệnh viện Bạch Mai'),
(4559, 'https://ror.org/05echw708', 'en', 1, 'https://ror.org/05echw708 Archbishop Makarios III Hospital'),
(4560, 'https://ror.org/05ed8xr15', 'fr', 1, 'https://ror.org/05ed8xr15 Centre Hospitalier Saint-Denis'),
(4561, 'https://ror.org/05ee2qy47', 'en', 1, 'https://ror.org/05ee2qy47 Queen Elizabeth Hospital'),
(4562, 'https://ror.org/05eer8g02', 'en', 1, 'https://ror.org/05eer8g02 Jimma University'),
(4563, 'https://ror.org/05eewjw07', 'no_lang_code', 1, 'https://ror.org/05eewjw07 Bellbrook Labs (United States)'),
(4564, 'https://ror.org/05ef11p71', 'en', 1, 'https://ror.org/05ef11p71 Grochowski Hospital'),
(4565, 'https://ror.org/05efbh861', 'en', 1, 'https://ror.org/05efbh861 Prince Charles Hospital'),
(4566, 'https://ror.org/05efsr055', 'en', 1, 'https://ror.org/05efsr055 Estonian Interuniversity Population Research Centre'),
(4567, 'https://ror.org/05ehe6278', 'no_lang_code', 1, 'https://ror.org/05ehe6278 Cameco (Canada)'),
(4568, 'https://ror.org/05ejbda19', 'en', 1, 'https://ror.org/05ejbda19 Kyoto Women''s University 京都女子大学'),
(4569, 'https://ror.org/05ejygc42', 'en', 1, 'https://ror.org/05ejygc42 Foundation for Advancement of International Medical Education and Research'),
(4570, 'https://ror.org/05ekwbr88', 'en', 1, 'https://ror.org/05ekwbr88 Chicago State University Université d''État de chicago'),
(4571, 'https://ror.org/05en5nh73', 'en', 1, 'https://ror.org/05en5nh73 University of Seoul 서울시립대학교'),
(4572, 'https://ror.org/05epcpp46', 'en', 1, 'https://ror.org/05epcpp46 Asahi University 朝日大学'),
(4573, 'https://ror.org/05eq01d13', 'en', 1, 'https://ror.org/05eq01d13 Gold Coast Hospital'),
(4574, 'https://ror.org/05eq41471', 'en', 1, 'https://ror.org/05eq41471 Veterans Health Administration'),
(4575, 'https://ror.org/05eq86m59', 'en', 1, 'https://ror.org/05eq86m59 Lander University'),
(4576, 'https://ror.org/05eqt7s39', 'en', 1, 'https://ror.org/05eqt7s39 Athens Information Technology'),
(4577, 'https://ror.org/05eqxpf83', 'en', 1, 'https://ror.org/05eqxpf83 Soonchunhyang University Hospital'),
(4578, 'https://ror.org/05eqycp84', 'en', 1, 'https://ror.org/05eqycp84 Cheng Ching Hospital 澄清湖医院'),
(4579, 'https://ror.org/05et9pf90', 'en', 1, 'https://ror.org/05et9pf90 B.P. Koirala Institute of Health Sciences विपी कोइराला स्वास्थ्य विज्ञान प्रतिष्ठान'),
(4580, 'https://ror.org/05ewdm369', 'en', 1, 'https://ror.org/05ewdm369 Secretariat of the Pacific Community'),
(4581, 'https://ror.org/05exmrf24', 'en', 1, 'https://ror.org/05exmrf24 Coppin State University'),
(4582, 'https://ror.org/05f2xwq77', 'en', 1, 'https://ror.org/05f2xwq77 Charles Clifford Dental Hospital'),
(4583, 'https://ror.org/05f4fpj37', 'hr', 1, 'https://ror.org/05f4fpj37 Klinika za psihijatriju Vrapče'),
(4584, 'https://ror.org/05faw8a11', 'en', 1, 'https://ror.org/05faw8a11 Shaughnessy Hospital'),
(4585, 'https://ror.org/05fb8h434', 'pt', 1, 'https://ror.org/05fb8h434 Instituto Superior de Administração e Gestão'),
(4586, 'https://ror.org/05fccw142', 'it', 1, 'https://ror.org/05fccw142 Ospedale San Pietro Fatebenefratelli'),
(4587, 'https://ror.org/05fcfqq67', 'en', 1, 'https://ror.org/05fcfqq67 Oregon National Primate Research Center'),
(4588, 'https://ror.org/05fcrn131', 'en', 1, 'https://ror.org/05fcrn131 University Hospital Llandough'),
(4589, 'https://ror.org/05fde5z47', 'en', 1, 'https://ror.org/05fde5z47 Hampton University Université de hampton'),
(4590, 'https://ror.org/05fe2n505', 'en', 1, 'https://ror.org/05fe2n505 Royal Sussex County Hospital'),
(4591, 'https://ror.org/05fhtd457', 'es', 1, 'https://ror.org/05fhtd457 Hospital Central Militar'),
(4592, 'https://ror.org/05fk0de79', 'en', 1, 'https://ror.org/05fk0de79 Bassett Medical Center'),
(4593, 'https://ror.org/05fkq4848', 'fr', 1, 'https://ror.org/05fkq4848 Hôpital Civil, Strasbourg'),
(4594, 'https://ror.org/05fmwts39', 'tr', 1, 'https://ror.org/05fmwts39 Şişli Etfal Eğitim ve Araştırma Hastanesi'),
(4595, 'https://ror.org/05fnpxf31', 'en', 1, 'https://ror.org/05fnpxf31 Holy Name Medical Center'),
(4596, 'https://ror.org/05fscjm95', 'en', 1, 'https://ror.org/05fscjm95 Jorvi Hospital Jorvin sairaala'),
(4597, 'https://ror.org/05fwyj602', 'en', 1, 'https://ror.org/05fwyj602 St. Jerome''s University'),
(4598, 'https://ror.org/05fx5mz56', 'en', 1, 'https://ror.org/05fx5mz56 University of Nigeria Teaching Hospital'),
(4599, 'https://ror.org/05fyf7995', 'en', 1, 'https://ror.org/05fyf7995 R. G. Kar Medical College and Hospital'),
(4600, 'https://ror.org/05fz2yc38', 'it', 1, 'https://ror.org/05fz2yc38 Ospedale Bellaria, Ospedale Bellaria "Carlo Alberto Pizzardi"'),
(4601, 'https://ror.org/05g1mag11', 'en', 1, 'https://ror.org/05g1mag11 Hebei Normal University of Science and Technology 河北科技师范学院'),
(4602, 'https://ror.org/05g2amy04', 'en', 1, 'https://ror.org/05g2amy04 Acıbadem Adana Hospital'),
(4603, 'https://ror.org/05g2gkn28', 'en', 1, 'https://ror.org/05g2gkn28 Minoh City Hospital 箕面市立病院'),
(4604, 'https://ror.org/05g3m5c29', 'en', 1, 'https://ror.org/05g3m5c29 Asanogawa General Hospital 浅ノ川総合病院'),
(4605, 'https://ror.org/05g44an34', 'en', 1, 'https://ror.org/05g44an34 Long Beach City College'),
(4606, 'https://ror.org/05g4mtv59', 'no_lang_code', 1, 'https://ror.org/05g4mtv59 Hewlett-Packard (United Kingdom)'),
(4607, 'https://ror.org/05g5v7496', 'en', 1, 'https://ror.org/05g5v7496 Burnley General Teaching Hospital'),
(4608, 'https://ror.org/05g6w6j42', 'en', 1, 'https://ror.org/05g6w6j42 Armed Forces Medical College ആംഡ് ഫോഴ്സസ് മെഡിക്കൽ കോളേജ്'),
(4609, 'https://ror.org/05g91z486', 'no_lang_code', 1, 'https://ror.org/05g91z486 Organ Technologies (Japan) オーガンテクノロジーズ'),
(4610, 'https://ror.org/05gba0366', 'en', 1, 'https://ror.org/05gba0366 Russian University of Transport Российский университет транспорта'),
(4611, 'https://ror.org/05gbdc474', 'no_lang_code', 1, 'https://ror.org/05gbdc474 Sotiria General Hospital'),
(4612, 'https://ror.org/05gbwr869', 'en', 1, 'https://ror.org/05gbwr869 First Affiliated Hospital of Nanchang University 南昌大学第一附属医院'),
(4613, 'https://ror.org/05gcxpk23', 'en', 1, 'https://ror.org/05gcxpk23 Dong-A University Hospital 동아대학교의료원'),
(4614, 'https://ror.org/05gehxw18', 'en', 1, 'https://ror.org/05gehxw18 Detroit Medical Center'),
(4615, 'https://ror.org/05gf6dk22', 'pt', 1, 'https://ror.org/05gf6dk22 Base Hospital Hospital de Base'),
(4616, 'https://ror.org/05gfebp73', 'en', 1, 'https://ror.org/05gfebp73 CSI Holdsworth Memorial Hospital'),
(4617, 'https://ror.org/05gg4qm19', 'en', 1, 'https://ror.org/05gg4qm19 Yamagata University Hospital 山形大学医学部附属病院'),
(4618, 'https://ror.org/05gh0na70', 'en', 1, 'https://ror.org/05gh0na70 Jinnah Medical & Dental College'),
(4619, 'https://ror.org/05gh5ar80', 'en', 1, 'https://ror.org/05gh5ar80 Gloucestershire Royal Hospital'),
(4620, 'https://ror.org/05gn4hz56', 'no_lang_code', 1, 'https://ror.org/05gn4hz56 Kishiwada Tokushukai Hospital 岸和田徳洲会病院'),
(4621, 'https://ror.org/05gn84d31', 'es', 1, 'https://ror.org/05gn84d31 Hospital de León'),
(4622, 'https://ror.org/05gnna589', 'it', 1, 'https://ror.org/05gnna589 Consorzio Nazionale Interuniversitario per la Nanoelettronica Interuniversity Consortium for Nanoelectronics'),
(4623, 'https://ror.org/05gpmx630', 'no_lang_code', 1, 'https://ror.org/05gpmx630 ShinKokura Hospital 新小倉病院'),
(4624, 'https://ror.org/05gqcbq50', 'en', 1, 'https://ror.org/05gqcbq50 Aspen Center For Physics Centre pour la physique d''aspen'),
(4625, 'https://ror.org/05gr5bv62', 'no_lang_code', 1, 'https://ror.org/05gr5bv62 Vala Sciences (United States)'),
(4626, 'https://ror.org/05gx19t11', 'en', 1, 'https://ror.org/05gx19t11 Evergreen Health Medical Center'),
(4627, 'https://ror.org/05gzcpj23', 'pt', 1, 'https://ror.org/05gzcpj23 Escola Superior de Saúde do Alcoitão'),
(4628, 'https://ror.org/05h0f1d70', 'en', 1, 'https://ror.org/05h0f1d70 C. S. Mott Children''s Hospital'),
(4629, 'https://ror.org/05h29d328', 'en', 1, 'https://ror.org/05h29d328 Saint Francis Memorial Hospital'),
(4630, 'https://ror.org/05h450y11', 'no_lang_code', 1, 'https://ror.org/05h450y11 Talaria (United States)'),
(4631, 'https://ror.org/05h4zj272', 'en', 1, 'https://ror.org/05h4zj272 Harbor–UCLA Medical Center'),
(4632, 'https://ror.org/05h7pem82', 'no_lang_code', 1, 'https://ror.org/05h7pem82 Bugando Medical Centre'),
(4633, 'https://ror.org/05h8pvh61', 'fr', 1, 'https://ror.org/05h8pvh61 Hôpital Broussais'),
(4634, 'https://ror.org/05h9pgm95', 'en', 1, 'https://ror.org/05h9pgm95 Kyungsung University 경성대학교'),
(4635, 'https://ror.org/05hbrxp80', 'en', 1, 'https://ror.org/05hbrxp80 Agricultural Research Organization מנהל המחקר החקלאי - מרכז וולקני'),
(4636, 'https://ror.org/05hh8d621', 'no_lang_code', 1, 'https://ror.org/05hh8d621 IBM (United States)'),
(4637, 'https://ror.org/05hm0vv72', 'en', 1, 'https://ror.org/05hm0vv72 Shahjalal University of Science and Technology শাহজালাল বিজ্ঞান ও প্রযুক্তি বিশ্ববিদ্যালয়'),
(4638, 'https://ror.org/05hm6ny55', 'en', 1, 'https://ror.org/05hm6ny55 Good Samaritan Hospital'),
(4639, 'https://ror.org/05hmwx760', 'en', 1, 'https://ror.org/05hmwx760 Poultry Industry Council'),
(4640, 'https://ror.org/05hn3aw08', 'en', 1, 'https://ror.org/05hn3aw08 Lincoln University - Missouri'),
(4641, 'https://ror.org/05hnb4n85', 'en', 1, 'https://ror.org/05hnb4n85 Jeju National University 제주대학교'),
(4642, 'https://ror.org/05hpt6x15', 'en', 1, 'https://ror.org/05hpt6x15 Riverside Regional Medical Center'),
(4643, 'https://ror.org/05hrczs03', 'en', 1, 'https://ror.org/05hrczs03 American Association of University Women'),
(4644, 'https://ror.org/05hrg0j24', 'en', 1, 'https://ror.org/05hrg0j24 Lister Hospital'),
(4645, 'https://ror.org/05hs5r386', 'en', 1, 'https://ror.org/05hs5r386 Mathematical Sciences Research Institute'),
(4646, 'https://ror.org/05hs7nx69', 'en', 1, 'https://ror.org/05hs7nx69 Social Insurance Futase Hospital 社会保険 二瀬病院'),
(4647, 'https://ror.org/05htjfp05', 'en', 1, 'https://ror.org/05htjfp05 Loma Linda University Children''s Hospital'),
(4648, 'https://ror.org/05hwn6x82', 'en', 1, 'https://ror.org/05hwn6x82 Spring Branch Medical Center'),
(4649, 'https://ror.org/05hzgxd58', 'pt', 1, 'https://ror.org/05hzgxd58 Universidade de Uberaba'),
(4650, 'https://ror.org/05j0w0e76', 'en', 1, 'https://ror.org/05j0w0e76 American Association For The Advancement of Science Asociación Estadounidense para el Avance de la Ciencia Association américaine pour l''avancement de la science'),
(4651, 'https://ror.org/05j1gs298', 'en', 1, 'https://ror.org/05j1gs298 Erasmus Hospital Erasmus Ziekenhuis Hôpital Érasme'),
(4652, 'https://ror.org/05j37e495', 'en', 1, 'https://ror.org/05j37e495 South Western Sydney Local Health District'),
(4653, 'https://ror.org/05j4p5w63', 'en', 1, 'https://ror.org/05j4p5w63 MetroHealth Medical Center'),
(4654, 'https://ror.org/05j5y0r89', 'en', 1, 'https://ror.org/05j5y0r89 Sir Paul Boffa Hospital'),
(4655, 'https://ror.org/05j752d14', 'en', 1, 'https://ror.org/05j752d14 McLaughlin Research Institute'),
(4656, 'https://ror.org/05j7rz205', 'en', 1, 'https://ror.org/05j7rz205 Halifax Health Medical Center'),
(4657, 'https://ror.org/05j82jr52', 'en', 1, 'https://ror.org/05j82jr52 Gaylord Hospital'),
(4658, 'https://ror.org/05j8hg602', 'en', 1, 'https://ror.org/05j8hg602 American Physical Society Société américaine de physique'),
(4659, 'https://ror.org/05j8naw58', 'en', 1, 'https://ror.org/05j8naw58 Sinai Health System');
INSERT INTO `rors` VALUES
(4660, 'https://ror.org/05j91v252', 'en', 1, 'https://ror.org/05j91v252 Oregon Research Institute'),
(4661, 'https://ror.org/05japer20', 'en', 1, 'https://ror.org/05japer20 Wilson College'),
(4662, 'https://ror.org/05jb57h29', 'en', 1, 'https://ror.org/05jb57h29 Hatanpaan Sairaala Hatanpää Hospital'),
(4663, 'https://ror.org/05jbt9m15', 'en', 1, 'https://ror.org/05jbt9m15 Universidad de Arkansas University of Arkansas at Fayetteville Université de l''arkansas'),
(4664, 'https://ror.org/05jbvqr49', 'no_lang_code', 1, 'https://ror.org/05jbvqr49 Gastops (Canada)'),
(4665, 'https://ror.org/05jc5ee02', 'en', 1, 'https://ror.org/05jc5ee02 University of Minnesota Children''s Hospital'),
(4666, 'https://ror.org/05jd2pj53', 'en', 1, 'https://ror.org/05jd2pj53 King Chulalongkorn Memorial Hospital โรงพยาบาลจุฬาลงกรณ์'),
(4667, 'https://ror.org/05jeza980', 'no_lang_code', 1, 'https://ror.org/05jeza980 Rolls-Royce (Germany)'),
(4668, 'https://ror.org/05jfq2w07', 'en', 1, 'https://ror.org/05jfq2w07 Scottish Universities Environmental Research Centre'),
(4669, 'https://ror.org/05jg8yp15', 'en', 1, 'https://ror.org/05jg8yp15 Hammersmith Hospital'),
(4670, 'https://ror.org/05jhpk184', 'en', 1, 'https://ror.org/05jhpk184 Memorial Hospital'),
(4671, 'https://ror.org/05jk51a88', 'en', 1, 'https://ror.org/05jk51a88 Nihon University 日本大学'),
(4672, 'https://ror.org/05jr18655', 'en', 1, 'https://ror.org/05jr18655 Self-Defense Forces Central Hospital 自衛隊中央病院'),
(4673, 'https://ror.org/05jr1e079', 'no_lang_code', 1, 'https://ror.org/05jr1e079 Advanced Medical Electronics (United States)'),
(4674, 'https://ror.org/05jse4442', 'it', 1, 'https://ror.org/05jse4442 Ospedale Santa Corona'),
(4675, 'https://ror.org/05jt1df44', 'en', 1, 'https://ror.org/05jt1df44 Milton Keynes Hospital'),
(4676, 'https://ror.org/05jtcqr88', 'no_lang_code', 1, 'https://ror.org/05jtcqr88 Thermo Fisher Scientific (China)'),
(4677, 'https://ror.org/05jv5t769', 'en', 1, 'https://ror.org/05jv5t769 Eltron Research'),
(4678, 'https://ror.org/05jvra197', 'no_lang_code', 1, 'https://ror.org/05jvra197 JA Shizuoka Koseiren ENSHU hospital じゃ しずおか こせいれん えんしゅ ほｓぴたｌ'),
(4679, 'https://ror.org/05jwhyp78', 'en', 1, 'https://ror.org/05jwhyp78 Good Samaritan Hospital Medical Center'),
(4680, 'https://ror.org/05jxj5k51', 'no_lang_code', 1, 'https://ror.org/05jxj5k51 Eesti Innovatsiooni Instituut'),
(4681, 'https://ror.org/05jyavm62', 'en', 1, 'https://ror.org/05jyavm62 Henrico Doctors'' Hospital'),
(4682, 'https://ror.org/05jyrng31', 'en', 1, 'https://ror.org/05jyrng31 McMaster University Medical Centre'),
(4683, 'https://ror.org/05jytgw54', 'en', 1, 'https://ror.org/05jytgw54 Gay Men''s Health Crisis'),
(4684, 'https://ror.org/05k07p323', 'en', 1, 'https://ror.org/05k07p323 Texas Health Dallas'),
(4685, 'https://ror.org/05k4mr860', 'en', 1, 'https://ror.org/05k4mr860 Saint John Regional Hospital'),
(4686, 'https://ror.org/05k71ja87', 'en', 1, 'https://ror.org/05k71ja87 Statistics Canada Statistique Canada'),
(4687, 'https://ror.org/05k7z2b58', 'en', 1, 'https://ror.org/05k7z2b58 Shriners Hospitals for Children Medical Center - Lexington'),
(4688, 'https://ror.org/05k87vq12', 'no_lang_code', 1, 'https://ror.org/05k87vq12 Microsoft Research (United Kingdom)'),
(4689, 'https://ror.org/05k8nw239', 'no_lang_code', 1, 'https://ror.org/05k8nw239 Western Research Company, Inc.'),
(4690, 'https://ror.org/05k8pq072', 'pt', 1, 'https://ror.org/05k8pq072 Universidade Cruzeiro do Sul'),
(4691, 'https://ror.org/05k9bck94', 'en', 1, 'https://ror.org/05k9bck94 Marietta Memorial Hospital'),
(4692, 'https://ror.org/05kcb8115', 'it', 1, 'https://ror.org/05kcb8115 Consorzio Interuniversitario Per L''Ottimizzazione E La Ricerca Operativa'),
(4693, 'https://ror.org/05kdz4d87', 'en', 1, 'https://ror.org/05kdz4d87 NHS Greater Glasgow and Clyde'),
(4694, 'https://ror.org/05ked8481', 'en', 1, 'https://ror.org/05ked8481 University of South Carolina Beaufort'),
(4695, 'https://ror.org/05kfvx519', 'fr', 1, 'https://ror.org/05kfvx519 Hôpital Albert Michallon'),
(4696, 'https://ror.org/05kjeqc29', 'no_lang_code', 1, 'https://ror.org/05kjeqc29 Jahra Hospital مستشفى الجهراء'),
(4697, 'https://ror.org/05kn6fr85', 'en', 1, 'https://ror.org/05kn6fr85 Government Medical College शासकीय वैद्यकीय महाविद्यालय व रुग्णालय, औरंगाबाद'),
(4698, 'https://ror.org/05kpx1157', 'en', 1, 'https://ror.org/05kpx1157 Royal Preston Hospital'),
(4699, 'https://ror.org/05kr7zx86', 'en', 1, 'https://ror.org/05kr7zx86 Georgia College & State University'),
(4700, 'https://ror.org/05ks08368', 'en', 1, 'https://ror.org/05ks08368 Komfo Anokye Teaching Hospital'),
(4701, 'https://ror.org/05ktv1y25', 'en', 1, 'https://ror.org/05ktv1y25 William Woods University'),
(4702, 'https://ror.org/05kwh9e63', 'no_lang_code', 1, 'https://ror.org/05kwh9e63 Adenosine Therapeutics (United States)'),
(4703, 'https://ror.org/05kwhtp56', 'es', 1, 'https://ror.org/05kwhtp56 Hospital Perpetuo Socorro'),
(4704, 'https://ror.org/05kx1ke03', 'en', 1, 'https://ror.org/05kx1ke03 Narayana Health'),
(4705, 'https://ror.org/05kxrms28', 'hu', 1, 'https://ror.org/05kxrms28 Bajcsy-Zsilinszky Kórház és Rendelőintézet'),
(4706, 'https://ror.org/05kz7bw59', 'en', 1, 'https://ror.org/05kz7bw59 Kwai Chung Hospital 葵涌醫院'),
(4707, 'https://ror.org/05kzadn81', 'en', 1, 'https://ror.org/05kzadn81 Nara Advanced Teachers College for Women, Nara Women''s University 奈良女子大学'),
(4708, 'https://ror.org/05kzbz291', 'no_lang_code', 1, 'https://ror.org/05kzbz291 Nagoya Kyouritsu Hospital 名古屋共立病院'),
(4709, 'https://ror.org/05kzjxq56', 'en', 1, 'https://ror.org/05kzjxq56 Chonnam National University 전남대학교'),
(4710, 'https://ror.org/05m34fq04', 'no_lang_code', 1, 'https://ror.org/05m34fq04 Motorola (France)'),
(4711, 'https://ror.org/05m3qrs33', 'en', 1, 'https://ror.org/05m3qrs33 Ipswich Hospital'),
(4712, 'https://ror.org/05m4bwg25', 'no_lang_code', 1, 'https://ror.org/05m4bwg25 Shinonoi General Hospital 篠ノ井総合病院'),
(4713, 'https://ror.org/05m4t4820', 'en', 1, 'https://ror.org/05m4t4820 Makassed General Hospital'),
(4714, 'https://ror.org/05m5pc269', 'en', 1, 'https://ror.org/05m5pc269 Nepal Medical College Teaching Hospital नेपाल मेडिकल कलेज'),
(4715, 'https://ror.org/05m5z4f19', 'en', 1, 'https://ror.org/05m5z4f19 Steel Construction Institute'),
(4716, 'https://ror.org/05m64xs77', 'en', 1, 'https://ror.org/05m64xs77 Monklands Hospital'),
(4717, 'https://ror.org/05m6e7d23', 'it', 1, 'https://ror.org/05m6e7d23 Ospedale San Giuseppe'),
(4718, 'https://ror.org/05m7vf540', 'en', 1, 'https://ror.org/05m7vf540 Capital District Health Authority'),
(4719, 'https://ror.org/05m7zw681', 'no_lang_code', 1, 'https://ror.org/05m7zw681 Rio Tinto (United Kingdom)'),
(4720, 'https://ror.org/05m8d2x46', 'en', 1, 'https://ror.org/05m8d2x46 North Shore University Hospital'),
(4721, 'https://ror.org/05ma4gw77', 'en', 1, 'https://ror.org/05ma4gw77 Universidad del Pacífico University of the Pacific Université du pacifique'),
(4722, 'https://ror.org/05maved80', 'en', 1, 'https://ror.org/05maved80 Northwest Missouri State University'),
(4723, 'https://ror.org/05mdb5j94', 'en', 1, 'https://ror.org/05mdb5j94 MedStar Harbor Hospital'),
(4724, 'https://ror.org/05megpp22', 'pt', 1, 'https://ror.org/05megpp22 Hospital Geral de Fortaleza'),
(4725, 'https://ror.org/05meqs994', 'no_lang_code', 1, 'https://ror.org/05meqs994 Innovation Research and Training'),
(4726, 'https://ror.org/05mg61p80', 'en', 1, 'https://ror.org/05mg61p80 Englewood Hospital and Medical Center'),
(4727, 'https://ror.org/05mgn5w61', 'no_lang_code', 1, 'https://ror.org/05mgn5w61 Hiraka General Hospital 平鹿総合病院'),
(4728, 'https://ror.org/05mhswc23', 'en', 1, 'https://ror.org/05mhswc23 Kushiro City General Hospital 市立釧路総合病院'),
(4729, 'https://ror.org/05mj6fy81', 'en', 1, 'https://ror.org/05mj6fy81 Universidad de Houston-Downtown University of Houston - Downtown'),
(4730, 'https://ror.org/05mm0yv21', 'en', 1, 'https://ror.org/05mm0yv21 Nizhny Novgorod State Pedagogical University Нижегородский государственный технический университет им. Р. Е. Алексеева'),
(4731, 'https://ror.org/05mmga691', 'fi', 1, 'https://ror.org/05mmga691 Kymenlaakson keskussairaala'),
(4732, 'https://ror.org/05mnb6484', 'en', 1, 'https://ror.org/05mnb6484 Grambling State University Université d''État de grambling'),
(4733, 'https://ror.org/05mpt6s70', 'no_lang_code', 1, 'https://ror.org/05mpt6s70 Applica Sprl'),
(4734, 'https://ror.org/05mqksr19', 'en', 1, 'https://ror.org/05mqksr19 Catawba Valley Medical Center'),
(4735, 'https://ror.org/05mryn396', 'no_lang_code', 1, 'https://ror.org/05mryn396 Manipal Hospital'),
(4736, 'https://ror.org/05mshxb09', 'en', 1, 'https://ror.org/05mshxb09 Sheffield Children''s Hospital'),
(4737, 'https://ror.org/05msy3z48', 'en', 1, 'https://ror.org/05msy3z48 Legacy Good Samaritan Medical Center'),
(4738, 'https://ror.org/05mw4gk09', 'en', 1, 'https://ror.org/05mw4gk09 Rebecca Sieff Hospital'),
(4739, 'https://ror.org/05myvb614', 'en', 1, 'https://ror.org/05myvb614 Miami VA Healthcare System'),
(4740, 'https://ror.org/05mzkvr65', 'en', 1, 'https://ror.org/05mzkvr65 Skokie Hospital'),
(4741, 'https://ror.org/05n0m7p40', 'fr', 1, 'https://ror.org/05n0m7p40 Hôpital El Ayachi'),
(4742, 'https://ror.org/05n0wgt02', 'en', 1, 'https://ror.org/05n0wgt02 King Faisal Specialist Hospital & Research Centre مستشفى الملك فيصل التخصصي'),
(4743, 'https://ror.org/05n13be63', 'en', 1, 'https://ror.org/05n13be63 Children''s Hospital of Fudan University'),
(4744, 'https://ror.org/05n56ba96', 'en', 1, 'https://ror.org/05n56ba96 Latifa Hospital'),
(4745, 'https://ror.org/05n5d3f06', 'en', 1, 'https://ror.org/05n5d3f06 Nagahama City Hospital 長浜市病院'),
(4746, 'https://ror.org/05n5drh21', 'en', 1, 'https://ror.org/05n5drh21 George E. Wahlen Department of VA Medical Center'),
(4747, 'https://ror.org/05n7t4h40', 'en', 1, 'https://ror.org/05n7t4h40 Henry Dunant Hospital'),
(4748, 'https://ror.org/05n8n9378', 'en', 1, 'https://ror.org/05n8n9378 Eduardo Mondlane University Universidade Eduardo Mondlane'),
(4749, 'https://ror.org/05n8v4z84', 'en', 1, 'https://ror.org/05n8v4z84 Milwaukee County Medical Complex'),
(4750, 'https://ror.org/05n952b74', 'en', 1, 'https://ror.org/05n952b74 North Mississippi Medical Center'),
(4751, 'https://ror.org/05n9fs062', 'no_lang_code', 1, 'https://ror.org/05n9fs062 Ghaem Hospital بیمارستان قائم'),
(4752, 'https://ror.org/05na1sz60', 'en', 1, 'https://ror.org/05na1sz60 Mercy Medical Center'),
(4753, 'https://ror.org/05nakwy60', 'en', 1, 'https://ror.org/05nakwy60 Ideta Eye Hospital 出田眼科病院'),
(4754, 'https://ror.org/05nbsaj33', 'en', 1, 'https://ror.org/05nbsaj33 Bhopal Memorial Hospital & Research Centre'),
(4755, 'https://ror.org/05ncvf986', 'en', 1, 'https://ror.org/05ncvf986 Sam Higginbottom Institute of Agriculture सैम हिग्गिनबॉटम कृषि, प्रौद्योगिकी एवं विज्ञान संस्थान അലഹബാദ് അഗ്രികൾച്ചറൽ ഇൻസ്റ്റിറ്റ്യൂട്ട്'),
(4756, 'https://ror.org/05ndpad60', 'en', 1, 'https://ror.org/05ndpad60 University of Sioux Falls'),
(4757, 'https://ror.org/05ne3s142', 'en', 1, 'https://ror.org/05ne3s142 Saint Petersburg Academic University Санкт-Петербургский академический университет — научно-образовательный центр нанотехнологий'),
(4758, 'https://ror.org/05ne4t757', 'en', 1, 'https://ror.org/05ne4t757 Kent and Sussex Hospital'),
(4759, 'https://ror.org/05nfzf209', 'es', 1, 'https://ror.org/05nfzf209 Hospital Universitario Infanta Leonor'),
(4760, 'https://ror.org/05ngnkr69', 'no_lang_code', 1, 'https://ror.org/05ngnkr69 Ambergen (United States)'),
(4761, 'https://ror.org/05nhkt138', 'tr', 1, 'https://ror.org/05nhkt138 Bursa Yuksek Ihtisas Egitim Ve Arastirma Hastanesi'),
(4762, 'https://ror.org/05nkffb74', 'en', 1, 'https://ror.org/05nkffb74 Mubarak Al Kabeer Hospital'),
(4763, 'https://ror.org/05nmfef18', 'en', 1, 'https://ror.org/05nmfef18 Hoag Memorial Hospital Presbyterian'),
(4764, 'https://ror.org/05nmzkr23', 'en', 1, 'https://ror.org/05nmzkr23 Bankura Sammilani Medical College বাঁকুড়া সম্মিলনী মেডিক্যাল কলেজ'),
(4765, 'https://ror.org/05npsb488', 'en', 1, 'https://ror.org/05npsb488 Foundation for Medical Research'),
(4766, 'https://ror.org/05nrhca20', 'en', 1, 'https://ror.org/05nrhca20 West Australian Sleep Disorders Research Institute'),
(4767, 'https://ror.org/05ns8wm63', 'no_lang_code', 1, 'https://ror.org/05ns8wm63 Abratech Corporation'),
(4768, 'https://ror.org/05nsbhw27', 'en', 1, 'https://ror.org/05nsbhw27 Centre hospitalier pour enfants de l''est de l''Ontario Children''s Hospital of Eastern Ontario'),
(4769, 'https://ror.org/05nter171', 'en', 1, 'https://ror.org/05nter171 Avera Health'),
(4770, 'https://ror.org/05nv2rz39', 'en', 1, 'https://ror.org/05nv2rz39 University of Eswatini'),
(4771, 'https://ror.org/05nvmzs58', 'pt', 1, 'https://ror.org/05nvmzs58 Universidade de Santo Amaro'),
(4772, 'https://ror.org/05nx0xs09', 'en', 1, 'https://ror.org/05nx0xs09 Baoji University of Arts and Sciences 宝鸡文理学院'),
(4773, 'https://ror.org/05nyenj39', 'de', 1, 'https://ror.org/05nyenj39 Asklepios Hospital Barmbek Asklepios Klinik Barmbek'),
(4774, 'https://ror.org/05nygae07', 'pl', 1, 'https://ror.org/05nygae07 Okręgowy Szpital Kolejowy'),
(4775, 'https://ror.org/05nz57427', 'en', 1, 'https://ror.org/05nz57427 Cardinal Stritch University'),
(4776, 'https://ror.org/05nzesv70', 'en', 1, 'https://ror.org/05nzesv70 Royal Glamorgan Hospital'),
(4777, 'https://ror.org/05p1frt18', 'en', 1, 'https://ror.org/05p1frt18 Glostrup Hospital'),
(4778, 'https://ror.org/05p1phv38', 'en', 1, 'https://ror.org/05p1phv38 Huntington Medical Research Institutes'),
(4779, 'https://ror.org/05p21z194', 'it', 1, 'https://ror.org/05p21z194 Azienda Ospedaliera Universitaria Policlinico "Paolo Giaccone" di Palermo'),
(4780, 'https://ror.org/05p38yh32', 'en', 1, 'https://ror.org/05p38yh32 Hubei Cancer Hospital 湖北省肿瘤医院'),
(4781, 'https://ror.org/05p48p517', 'en', 1, 'https://ror.org/05p48p517 Northern California Institute for Research and Education'),
(4782, 'https://ror.org/05p4f7w60', 'en', 1, 'https://ror.org/05p4f7w60 University of the West Indies'),
(4783, 'https://ror.org/05p89st11', 'en', 1, 'https://ror.org/05p89st11 American Geosciences Institute'),
(4784, 'https://ror.org/05pcyqv21', 'no_lang_code', 1, 'https://ror.org/05pcyqv21 Petro-Canada'),
(4785, 'https://ror.org/05peke140', 'es', 1, 'https://ror.org/05peke140 Hospital Virgen del Puerto'),
(4786, 'https://ror.org/05pet2p92', 'no_lang_code', 1, 'https://ror.org/05pet2p92 Nishida Hospital 西田病院'),
(4787, 'https://ror.org/05pfdp204', 'en', 1, 'https://ror.org/05pfdp204 Crozer-Keystone Health System'),
(4788, 'https://ror.org/05pgywt51', 'en', 1, 'https://ror.org/05pgywt51 Queen Elizabeth Hospital'),
(4789, 'https://ror.org/05ph11m41', 'en', 1, 'https://ror.org/05ph11m41 CTO Hospital Ospedale Centro Traumatologico Ortopedico'),
(4790, 'https://ror.org/05pkzpg75', 'en', 1, 'https://ror.org/05pkzpg75 Ningbo First Hospital 宁波市第一医院'),
(4791, 'https://ror.org/05pp39346', 'en', 1, 'https://ror.org/05pp39346 Haifa Medical Center'),
(4792, 'https://ror.org/05prep819', 'en', 1, 'https://ror.org/05prep819 National Hsinchu University of Education'),
(4793, 'https://ror.org/05pvryz52', 'no_lang_code', 1, 'https://ror.org/05pvryz52 IQ Solutions'),
(4794, 'https://ror.org/05pwfyy15', 'en', 1, 'https://ror.org/05pwfyy15 National Centre for Research and Development'),
(4795, 'https://ror.org/05pwsw714', 'en', 1, 'https://ror.org/05pwsw714 Hangzhou First People''s Hospital 杭州市第一人民医院'),
(4796, 'https://ror.org/05py5qd41', 'en', 1, 'https://ror.org/05py5qd41 Lebanon Valley College'),
(4797, 'https://ror.org/05q2e1368', 'no_lang_code', 1, 'https://ror.org/05q2e1368 ISA Associate'),
(4798, 'https://ror.org/05q4veh78', 'no_lang_code', 1, 'https://ror.org/05q4veh78 Evangelismos Hospital'),
(4799, 'https://ror.org/05q60vz69', 'en', 1, 'https://ror.org/05q60vz69 South African Medical Research Council'),
(4800, 'https://ror.org/05q6tgt32', 'en', 1, 'https://ror.org/05q6tgt32 Kennedy Krieger Institute'),
(4801, 'https://ror.org/05q7jp496', 'en', 1, 'https://ror.org/05q7jp496 South African Institute for Medical Research'),
(4802, 'https://ror.org/05q87sg56', 'en', 1, 'https://ror.org/05q87sg56 Saint Joseph''s University Universidad de San José Université saint-joseph de philadelphie'),
(4803, 'https://ror.org/05q8e6988', 'en', 1, 'https://ror.org/05q8e6988 Southern University at New Orleans'),
(4804, 'https://ror.org/05q8mwj81', 'en', 1, 'https://ror.org/05q8mwj81 Hamilton General Hospital'),
(4805, 'https://ror.org/05q9t1y70', 'no_lang_code', 1, 'https://ror.org/05q9t1y70 Siga Technologies (United States)'),
(4806, 'https://ror.org/05qapqt30', 'en', 1, 'https://ror.org/05qapqt30 Montana Department of Public Health and Human Services'),
(4807, 'https://ror.org/05qcjn862', 'en', 1, 'https://ror.org/05qcjn862 Greenbrier Valley Medical Center'),
(4808, 'https://ror.org/05qderh61', 'en', 1, 'https://ror.org/05qderh61 University of Calabar Yunifásítì ìlú Calabar'),
(4809, 'https://ror.org/05qe0pv23', 'no_lang_code', 1, 'https://ror.org/05qe0pv23 Kashiwa Municipal Hospital 柏市立柏病院'),
(4810, 'https://ror.org/05qfq7p37', 'en', 1, 'https://ror.org/05qfq7p37 Sint Clara Ziekenhuis St Clara Hospital'),
(4811, 'https://ror.org/05qj9p026', 'en', 1, 'https://ror.org/05qj9p026 Lu''an First People''s Hospital'),
(4812, 'https://ror.org/05qk3dq04', 'en', 1, 'https://ror.org/05qk3dq04 Malta Council for Science and Technology'),
(4813, 'https://ror.org/05qkf9y72', 'en', 1, 'https://ror.org/05qkf9y72 Government General Hospital'),
(4814, 'https://ror.org/05qkm6m65', 'no_lang_code', 1, 'https://ror.org/05qkm6m65 Engi-Mat (United States)'),
(4815, 'https://ror.org/05qkp7h42', 'en', 1, 'https://ror.org/05qkp7h42 Five Branches University'),
(4816, 'https://ror.org/05qmezx22', 'no_lang_code', 1, 'https://ror.org/05qmezx22 Guelph Chemical Labs'),
(4817, 'https://ror.org/05qmk4a18', 'en', 1, 'https://ror.org/05qmk4a18 Bangalore Medical College and Research Institute ಬೆಂಗಳೂರು ವೈದ್ಯಕೀಯ ವಿದ್ಯಾಲಯ'),
(4818, 'https://ror.org/05qpen692', 'en', 1, 'https://ror.org/05qpen692 California Lutheran University'),
(4819, 'https://ror.org/05qtccm96', 'ga', 1, 'https://ror.org/05qtccm96 Forbairt'),
(4820, 'https://ror.org/05qx0rg92', 'no_lang_code', 1, 'https://ror.org/05qx0rg92 HealthMark Multimedia'),
(4821, 'https://ror.org/05qye4525', 'en', 1, 'https://ror.org/05qye4525 Mercy Hospital'),
(4822, 'https://ror.org/05qz2jt34', 'de', 1, 'https://ror.org/05qz2jt34 Bundeswehrkrankenhaus'),
(4823, 'https://ror.org/05r3hm325', 'it', 1, 'https://ror.org/05r3hm325 Azienda Ospedaliera Carlo Poma'),
(4824, 'https://ror.org/05r409z22', 'en', 1, 'https://ror.org/05r409z22 Northern General Hospital'),
(4825, 'https://ror.org/05r5k8873', 'en', 1, 'https://ror.org/05r5k8873'),
(4826, 'https://ror.org/05r6ndz30', 'en', 1, 'https://ror.org/05r6ndz30 Physicians for a National Health Program'),
(4827, 'https://ror.org/05raceh98', 'no_lang_code', 1, 'https://ror.org/05raceh98 Shirasagi Hospital 白鷺病院'),
(4828, 'https://ror.org/05rad4t93', 'en', 1, 'https://ror.org/05rad4t93 Gordon Research Conferences'),
(4829, 'https://ror.org/05rbwvc13', 'en', 1, 'https://ror.org/05rbwvc13 Queen Elizabeth Hospital'),
(4830, 'https://ror.org/05re2b915', 'en', 1, 'https://ror.org/05re2b915 European Road Transport Telematics Implementation Co-Ordination'),
(4831, 'https://ror.org/05rejmm18', 'no_lang_code', 1, 'https://ror.org/05rejmm18 DELL (United States)'),
(4832, 'https://ror.org/05rfek682', 'en', 1, 'https://ror.org/05rfek682 Kaiser Permanente Oakland Medical Center'),
(4833, 'https://ror.org/05rfh1r09', 'en', 1, 'https://ror.org/05rfh1r09 Aquatic Animal Health Research Laboratory'),
(4834, 'https://ror.org/05rkz5e28', 'no_lang_code', 1, 'https://ror.org/05rkz5e28 Toranomon Hospital 虎の門病院'),
(4835, 'https://ror.org/05rm13h81', 'ms', 1, 'https://ror.org/05rm13h81 Hospital Tengku Ampuan Afzan'),
(4836, 'https://ror.org/05rmxkq05', 'en', 1, 'https://ror.org/05rmxkq05 Dominican Hospital'),
(4837, 'https://ror.org/05rq9gz82', 'en', 1, 'https://ror.org/05rq9gz82 303 Hospital of People''s Liberation Army 中国人民解放军303医院'),
(4838, 'https://ror.org/05rsbck92', 'no_lang_code', 1, 'https://ror.org/05rsbck92 Kitano Hospital 北野病院'),
(4839, 'https://ror.org/05rtdxx03', 'en', 1, 'https://ror.org/05rtdxx03 CHA Gangnam Medical Center'),
(4840, 'https://ror.org/05rtvan68', 'en', 1, 'https://ror.org/05rtvan68 Royal University of Phnom Penh សាកលវិទ្យាល័យភូមិន្ទភ្នំពេញ'),
(4841, 'https://ror.org/05rvey468', 'en', 1, 'https://ror.org/05rvey468 Oglethorpe University'),
(4842, 'https://ror.org/05rw9t746', 'en', 1, 'https://ror.org/05rw9t746 IBM Research - Haifa'),
(4843, 'https://ror.org/05ry42w04', 'en', 1, 'https://ror.org/05ry42w04 MedStar Washington Hospital Center'),
(4844, 'https://ror.org/05ryv0s68', 'en', 1, 'https://ror.org/05ryv0s68 Euresearch Association'),
(4845, 'https://ror.org/05rz49z56', 'en', 1, 'https://ror.org/05rz49z56 Smt. N.H.L. Municipal Medical College શ્રીમતી. એનએચએલ મ્યુનિસિપલ મેડિકલ કોલેજ'),
(4846, 'https://ror.org/05rzmnp25', 'en', 1, 'https://ror.org/05rzmnp25 University of the Ryukyus University Hospital 琉球大学医学部附属病院'),
(4847, 'https://ror.org/05s004555', 'en', 1, 'https://ror.org/05s004555 Favaloro University Universidad Favaloro'),
(4848, 'https://ror.org/05s0ee237', 'en', 1, 'https://ror.org/05s0ee237 Morton Plant Hospital'),
(4849, 'https://ror.org/05s3h8004', 'es', 1, 'https://ror.org/05s3h8004 Hospital Universitario Severo Ochoa'),
(4850, 'https://ror.org/05s74hd65', 'en', 1, 'https://ror.org/05s74hd65 Oakwood University'),
(4851, 'https://ror.org/05s7s9x02', 'no_lang_code', 1, 'https://ror.org/05s7s9x02 Lucideon (United Kingdom)'),
(4852, 'https://ror.org/05s9f4d27', 'en', 1, 'https://ror.org/05s9f4d27 University of Wisconsin–Parkside Université du Wisconsin–Parkside'),
(4853, 'https://ror.org/05sb0dh40', 'en', 1, 'https://ror.org/05sb0dh40 Aishin Memorial Hospital 愛心メモリアル病院'),
(4854, 'https://ror.org/05sc3m345', 'en', 1, 'https://ror.org/05sc3m345 Hungarian Institute of Occupational Health Országos Munkahigiénés és Foglalkozásegészségügyi Intézet'),
(4855, 'https://ror.org/05sep9w93', 'es', 1, 'https://ror.org/05sep9w93 Instituto Tecnológico de Aragón'),
(4856, 'https://ror.org/05sgcwh30', 'fr', 1, 'https://ror.org/05sgcwh30 Ministère des Transports'),
(4857, 'https://ror.org/05sgxk616', 'en', 1, 'https://ror.org/05sgxk616 Doctors Medical Center'),
(4858, 'https://ror.org/05shfp710', 'en', 1, 'https://ror.org/05shfp710 Evangel University'),
(4859, 'https://ror.org/05sj7yp62', 'en', 1, 'https://ror.org/05sj7yp62 Universidad de Carabobo University of Carabobo'),
(4860, 'https://ror.org/05sk0a617', 'en', 1, 'https://ror.org/05sk0a617 Association of Schools of Allied Health Professions'),
(4861, 'https://ror.org/05skj8r52', 'en', 1, 'https://ror.org/05skj8r52 Rutland Regional Medical Center'),
(4862, 'https://ror.org/05sn8t512', 'en', 1, 'https://ror.org/05sn8t512 Hospital Authority 醫院管理局'),
(4863, 'https://ror.org/05sqd3t97', 'en', 1, 'https://ror.org/05sqd3t97 Sistema universitario estatal de Florida State University System of Florida'),
(4864, 'https://ror.org/05sv6pg41', 'en', 1, 'https://ror.org/05sv6pg41 University of Wisconsin–Stevens Point Université du Wisconsin–Stevens Point'),
(4865, 'https://ror.org/05sy5w128', 'en', 1, 'https://ror.org/05sy5w128 Kumamoto Medical Center 熊本医療センター'),
(4866, 'https://ror.org/05t3n1398', 'en', 1, 'https://ror.org/05t3n1398 Natural Resources Institute'),
(4867, 'https://ror.org/05t4vgv93', 'no_lang_code', 1, 'https://ror.org/05t4vgv93 Rotunda Hospital'),
(4868, 'https://ror.org/05t65ke24', 'en', 1, 'https://ror.org/05t65ke24 Sophiahemmet Hospital Sophiahemmet Sjukhus'),
(4869, 'https://ror.org/05t6gpm70', 'en', 1, 'https://ror.org/05t6gpm70 University of California Davis Medical Center'),
(4870, 'https://ror.org/05t70xh16', 'en', 1, 'https://ror.org/05t70xh16 Kyoto Sangyo University 京都産業大学'),
(4871, 'https://ror.org/05t7jxa31', 'en', 1, 'https://ror.org/05t7jxa31 Institute for Cancer Prevention'),
(4872, 'https://ror.org/05t8kxz54', 'en', 1, 'https://ror.org/05t8kxz54 Saddleback Memorial Medical Center'),
(4873, 'https://ror.org/05t9mkx39', 'en', 1, 'https://ror.org/05t9mkx39 Touro University Nevada Université touro du nevada'),
(4874, 'https://ror.org/05tby3y60', 'en', 1, 'https://ror.org/05tby3y60 Judge Baker Children''s Center'),
(4875, 'https://ror.org/05tc07s46', 'en', 1, 'https://ror.org/05tc07s46 Matsuyama University 松山大学'),
(4876, 'https://ror.org/05tdbce05', 'en', 1, 'https://ror.org/05tdbce05 Biological Sciences Curriculum Study'),
(4877, 'https://ror.org/05te51w08', 'es', 1, 'https://ror.org/05te51w08 Hospital General de Niños Ricardo Gutierrez'),
(4878, 'https://ror.org/05tkvpg69', 'es', 1, 'https://ror.org/05tkvpg69 Centro Agronomico Tropical de Investigacion y Ensenanza Catie'),
(4879, 'https://ror.org/05tmv0d13', 'en', 1, 'https://ror.org/05tmv0d13 American Society of Civil Engineers'),
(4880, 'https://ror.org/05tn05n57', 'en', 1, 'https://ror.org/05tn05n57 Hanyang University Medical Center 한양대학교병원 응급실'),
(4881, 'https://ror.org/05tnvgk65', 'en', 1, 'https://ror.org/05tnvgk65 Northern State Medical University Северный государственный медицинский университет'),
(4882, 'https://ror.org/05tqne909', 'no_lang_code', 1, 'https://ror.org/05tqne909 (주)인실리코젠 Insilicogen (South Korea)'),
(4883, 'https://ror.org/05tqtd486', 'en', 1, 'https://ror.org/05tqtd486 Canterbury District Health Board'),
(4884, 'https://ror.org/05ts0bd12', 'en', 1, 'https://ror.org/05ts0bd12 VA Northern California Health Care System'),
(4885, 'https://ror.org/05tta9908', 'de', 1, 'https://ror.org/05tta9908 Children''s Hospital in Eastern Switzerland Ostschweizer Kinderspital'),
(4886, 'https://ror.org/05twvab73', 'en', 1, 'https://ror.org/05twvab73 Jehangir Hospital'),
(4887, 'https://ror.org/05txhk819', 'es', 1, 'https://ror.org/05txhk819 Hospital General de Agudos Dr. TEODORO ALVAREZ'),
(4888, 'https://ror.org/05txkk980', 'es', 1, 'https://ror.org/05txkk980 Hospital Universitario Infanta Cristina'),
(4889, 'https://ror.org/05txvbe22', 'en', 1, 'https://ror.org/05txvbe22 Federal Teaching Hospital Abakaliki'),
(4890, 'https://ror.org/05tzr3y75', 'en', 1, 'https://ror.org/05tzr3y75 Kassala University جامعة كسلا'),
(4891, 'https://ror.org/05v0qpv28', 'en', 1, 'https://ror.org/05v0qpv28 Dankook University Hospital 단국대학교의과대학부속병원'),
(4892, 'https://ror.org/05v1y0t93', 'en', 1, 'https://ror.org/05v1y0t93 China Jiliang University'),
(4893, 'https://ror.org/05v4bdf81', 'en', 1, 'https://ror.org/05v4bdf81 Southampton Hospital'),
(4894, 'https://ror.org/05v4pjq26', 'en', 1, 'https://ror.org/05v4pjq26 Mahatma Gandhi Medical College and Research Institute'),
(4895, 'https://ror.org/05v4pwe63', 'en', 1, 'https://ror.org/05v4pwe63 Canniesburn Hospital'),
(4896, 'https://ror.org/05v558c44', 'it', 1, 'https://ror.org/05v558c44 Azienda Ospedaliera Fatebenefratelli e Oftalmico'),
(4897, 'https://ror.org/05v55dh34', 'en', 1, 'https://ror.org/05v55dh34 Memorial Hospital'),
(4898, 'https://ror.org/05v58y004', 'en', 1, 'https://ror.org/05v58y004 Shaoxing People''s Hospital 绍兴市人民医院'),
(4899, 'https://ror.org/05v5wwy67', 'en', 1, 'https://ror.org/05v5wwy67 Hippocration General Hospital Γενικό Νοσοκομείο Αθηνών Ιπποκράτειο'),
(4900, 'https://ror.org/05v6r7450', 'en', 1, 'https://ror.org/05v6r7450 Shanghai Skin Disease Hospital 上海皮肤病医院长宁区门诊部'),
(4901, 'https://ror.org/05v7axt97', 'no_lang_code', 1, 'https://ror.org/05v7axt97 Resodyn Corporation (United States)'),
(4902, 'https://ror.org/05v7bbe50', 'tr', 1, 'https://ror.org/05v7bbe50 Fatih Sultan Mehmet Eğitim Ve Araştırma Hastanesi'),
(4903, 'https://ror.org/05v7jp327', 'en', 1, 'https://ror.org/05v7jp327 Atlanta Medical Center'),
(4904, 'https://ror.org/05v7v1303', 'no_lang_code', 1, 'https://ror.org/05v7v1303 IRIS Educational Media'),
(4905, 'https://ror.org/05v823t63', 'en', 1, 'https://ror.org/05v823t63 South Essex Partnership University Foundation NHS Trust'),
(4906, 'https://ror.org/05va5gy74', 'en', 1, 'https://ror.org/05va5gy74 Royal National Hospital for Rheumatic Diseases'),
(4907, 'https://ror.org/05vc4qy60', 'nl', 1, 'https://ror.org/05vc4qy60 Rijnland Ziekenhuis'),
(4908, 'https://ror.org/05vchgv90', 'no_lang_code', 1, 'https://ror.org/05vchgv90 Kouseiren Takaoka Hospital 厚生連高岡病院'),
(4909, 'https://ror.org/05vczwc13', 'en', 1, 'https://ror.org/05vczwc13 Deaconess Hospital'),
(4910, 'https://ror.org/05vf56z40', 'en', 1, 'https://ror.org/05vf56z40 University of Tehran دانشگاه تهران'),
(4911, 'https://ror.org/05vgmh969', 'pl', 1, 'https://ror.org/05vgmh969 Szpital Uniwersytecki w Krakowie'),
(4912, 'https://ror.org/05vhczg54', 'en', 1, 'https://ror.org/05vhczg54 Feng Chia University'),
(4913, 'https://ror.org/05vn3ca78', 'en', 1, 'https://ror.org/05vn3ca78 National Chung Hsing University'),
(4914, 'https://ror.org/05vp5x049', 'en', 1, 'https://ror.org/05vp5x049 Children''s Hospital of Richmond at VCU'),
(4915, 'https://ror.org/05vtzqy31', 'en', 1, 'https://ror.org/05vtzqy31 Deaconess Hospital'),
(4916, 'https://ror.org/05vvzn852', 'en', 1, 'https://ror.org/05vvzn852 University of Kentucky HealthCare'),
(4917, 'https://ror.org/05vxnmp88', 'en', 1, 'https://ror.org/05vxnmp88 Cheil General Hospital and Women''s Healthcare Center'),
(4918, 'https://ror.org/05vy1kj95', 'en', 1, 'https://ror.org/05vy1kj95 American Mathematical Society Sociedad Estadounidense de Matemática'),
(4919, 'https://ror.org/05vy2sc54', 'en', 1, 'https://ror.org/05vy2sc54 First Affiliated Hospital of Harbin Medical University'),
(4920, 'https://ror.org/05vz28418', 'en', 1, 'https://ror.org/05vz28418 Southern Illinois University System Université de l''illinois du sud'),
(4921, 'https://ror.org/05vzbfc95', 'en', 1, 'https://ror.org/05vzbfc95 Yeditepe University Hospital Yeditepe Üniversitesi Hastanesi'),
(4922, 'https://ror.org/05vzqzh92', 'en', 1, 'https://ror.org/05vzqzh92 University of Minnesota Morris Université du minnesota à morris'),
(4923, 'https://ror.org/05w0p9h92', 'en', 1, 'https://ror.org/05w0p9h92 Shenandoah University'),
(4924, 'https://ror.org/05w1yqq10', 'en', 1, 'https://ror.org/05w1yqq10 Israel Defense Forces Medical Corps'),
(4925, 'https://ror.org/05w3e4z48', 'en', 1, 'https://ror.org/05w3e4z48 New Cross Hospital'),
(4926, 'https://ror.org/05w6fx554', 'ro', 1, 'https://ror.org/05w6fx554 Institutul Clinic Fundeni'),
(4927, 'https://ror.org/05w6g2m14', 'en', 1, 'https://ror.org/05w6g2m14 Government Medical College'),
(4928, 'https://ror.org/05wbx0564', 'en', 1, 'https://ror.org/05wbx0564 Chonburi Hospital โรงพยาบาลชลบุรี'),
(4929, 'https://ror.org/05wc95s05', 'en', 1, 'https://ror.org/05wc95s05 Khoo Teck Puat Hospital'),
(4930, 'https://ror.org/05wcbg446', 'en', 1, 'https://ror.org/05wcbg446 Sveučilišna klinička bolnica Mostar University Clinical Hospital Mostar'),
(4931, 'https://ror.org/05wd11c32', 'en', 1, 'https://ror.org/05wd11c32 Research Corporation of The University of Hawaii'),
(4932, 'https://ror.org/05wd86d64', 'it', 1, 'https://ror.org/05wd86d64 Ospedale San Bortolo'),
(4933, 'https://ror.org/05we5gj17', 'en', 1, 'https://ror.org/05we5gj17 Inje University Seoul Paik Hospital 인제대학교백병원'),
(4934, 'https://ror.org/05weahn72', 'en', 1, 'https://ror.org/05weahn72 Sri Venkateswara University جامعہ سری وینکٹیشورا श्री वेंकटेश्वर विश्वविद्यालय சிறீ வெங்கடேசுவரா பல்கலைக்கழகம் శ్రీ వేంకటేశ్వర విశ్వవిద్యాలయం'),
(4935, 'https://ror.org/05wf8v135', 'en', 1, 'https://ror.org/05wf8v135 Bronglais General Hospital'),
(4936, 'https://ror.org/05wfna922', 'tr', 1, 'https://ror.org/05wfna922 American Hospital Amerikan Hastanesi'),
(4937, 'https://ror.org/05wjv2104', 'en', 1, 'https://ror.org/05wjv2104 University Hospital Innsbruck'),
(4938, 'https://ror.org/05wnp6x23', 'en', 1, 'https://ror.org/05wnp6x23 Goa Dental College and Hospital'),
(4939, 'https://ror.org/05wqbqy84', 'en', 1, 'https://ror.org/05wqbqy84 Aminu Kano Teaching Hospital'),
(4940, 'https://ror.org/05wqhv079', 'en', 1, 'https://ror.org/05wqhv079 Mater Adult Hospital'),
(4941, 'https://ror.org/05wr49d48', 'en', 1, 'https://ror.org/05wr49d48 Wakayama University 和歌山大学'),
(4942, 'https://ror.org/05wrpbp17', 'en', 1, 'https://ror.org/05wrpbp17 Andalusian School of Public Health Escuela Andaluza de Salud Pública'),
(4943, 'https://ror.org/05wstbs93', 'en', 1, 'https://ror.org/05wstbs93 Obihiro National Hospital 国立病院機構帯広病院'),
(4944, 'https://ror.org/05wtx0016', 'no_lang_code', 1, 'https://ror.org/05wtx0016 Canon (Canada)'),
(4945, 'https://ror.org/05wvk1430', 'en', 1, 'https://ror.org/05wvk1430 Municipal Hirakata City Hospital 市立枚方市民病院'),
(4946, 'https://ror.org/05wyncb52', 'en', 1, 'https://ror.org/05wyncb52 Kings Mill Hospital'),
(4947, 'https://ror.org/05wyq9e07', 'en', 1, 'https://ror.org/05wyq9e07 Stony Brook University Hospital'),
(4948, 'https://ror.org/05x0h7m97', 'en', 1, 'https://ror.org/05x0h7m97 Ratchaburi Hospital โรงพยาบาลราชบุรี'),
(4949, 'https://ror.org/05x0kmy47', 'no_lang_code', 1, 'https://ror.org/05x0kmy47 Shaanxi Yulin Energy Group'),
(4950, 'https://ror.org/05x14am29', 'en', 1, 'https://ror.org/05x14am29 Escola Superior Gallaecia Gallaecia Higher School'),
(4951, 'https://ror.org/05x2sza30', 'en', 1, 'https://ror.org/05x2sza30 Higashi Nagoya National Hospital 国立病院機構東名古屋病院'),
(4952, 'https://ror.org/05x3tad86', 'no_lang_code', 1, 'https://ror.org/05x3tad86 Inotek Pharmaceuticals (United States)'),
(4953, 'https://ror.org/05x3tq720', 'en', 1, 'https://ror.org/05x3tq720 Mennonite Christian Hospital 門諾醫院'),
(4954, 'https://ror.org/05x57ne79', 'en', 1, 'https://ror.org/05x57ne79 Calderdale Royal Hospital'),
(4955, 'https://ror.org/05x5g2972', 'en', 1, 'https://ror.org/05x5g2972 Crittenton Hospital Medical Center'),
(4956, 'https://ror.org/05x6qnc69', 'en', 1, 'https://ror.org/05x6qnc69 Lebanese University Université Libanaise الجامعة اللبنانية'),
(4957, 'https://ror.org/05x6qqf62', 'es', 1, 'https://ror.org/05x6qqf62 Hospital Valle del Nalón'),
(4958, 'https://ror.org/05x8jna23', 'fr', 1, 'https://ror.org/05x8jna23 Hôpital de La Grave'),
(4959, 'https://ror.org/05xanxb38', 'en', 1, 'https://ror.org/05xanxb38 Govt. Dental College & Hospital'),
(4960, 'https://ror.org/05xaz0w84', 'en', 1, 'https://ror.org/05xaz0w84 Odessa National Polytechnic University Одесский национальный политехнический университет Одеський національний політехнічний університет'),
(4961, 'https://ror.org/05xc56p63', 'en', 1, 'https://ror.org/05xc56p63 Royal Alexandra Children''s Hospital'),
(4962, 'https://ror.org/05xcx0k58', 'en', 1, 'https://ror.org/05xcx0k58 Aga Khan University Hospital'),
(4963, 'https://ror.org/05xcyt367', 'en', 1, 'https://ror.org/05xcyt367 Loyola University Medical Center'),
(4964, 'https://ror.org/05xdd0k85', 'en', 1, 'https://ror.org/05xdd0k85 Cheltenham General Hospital'),
(4965, 'https://ror.org/05xdxc763', 'en', 1, 'https://ror.org/05xdxc763 Advocate Children''s Hospital'),
(4966, 'https://ror.org/05xeczx11', 'no_lang_code', 1, 'https://ror.org/05xeczx11 Curtiss-Wright (Canada)'),
(4967, 'https://ror.org/05xf34x41', 'en', 1, 'https://ror.org/05xf34x41 South Carolina State Department of Mental Health'),
(4968, 'https://ror.org/05xh7ac43', 'en', 1, 'https://ror.org/05xh7ac43 Kettering General Hospital NHS Trust'),
(4969, 'https://ror.org/05xh86w23', 'en', 1, 'https://ror.org/05xh86w23 Gastroenterology Medical Center and Hospital'),
(4970, 'https://ror.org/05xhkqs13', 'en', 1, 'https://ror.org/05xhkqs13 North Bengal Medical College and Hospital নর্থবেঙ্গল মেডিক্যাল কলেজ'),
(4971, 'https://ror.org/05xhpce34', 'en', 1, 'https://ror.org/05xhpce34 St Göran''s Children''s Hospital'),
(4972, 'https://ror.org/05xjxp170', 'en', 1, 'https://ror.org/05xjxp170 Lovelace Health System'),
(4973, 'https://ror.org/05xmvmv34', 'es', 1, 'https://ror.org/05xmvmv34 Centro Sociosanitario Nuestra Señora del Pino'),
(4974, 'https://ror.org/05xn9jy83', 'en', 1, 'https://ror.org/05xn9jy83 University of Arkansas at Monticello'),
(4975, 'https://ror.org/05xrsn753', 'en', 1, 'https://ror.org/05xrsn753 Choithram Hospital and Research Centre'),
(4976, 'https://ror.org/05xswp225', 'en', 1, 'https://ror.org/05xswp225 Khulna Medical College খুলনা মেডিকেল কলেজ'),
(4977, 'https://ror.org/05xszy717', 'en', 1, 'https://ror.org/05xszy717 National Defense Academy of Japan 防衛大学校'),
(4978, 'https://ror.org/05xtj6g89', 'en', 1, 'https://ror.org/05xtj6g89 Baptist Memorial Hospital'),
(4979, 'https://ror.org/05xtmzc93', 'en', 1, 'https://ror.org/05xtmzc93 Baptist Medical Center Beaches'),
(4980, 'https://ror.org/05xv0p989', 'tr', 1, 'https://ror.org/05xv0p989 Ege Üniversitesi Tıp Fakültesi Hastanesi'),
(4981, 'https://ror.org/05xwc2w62', 'pt', 1, 'https://ror.org/05xwc2w62 Escola Superior de Educação de Almeida Garrett'),
(4982, 'https://ror.org/05xxmnm27', 'en', 1, 'https://ror.org/05xxmnm27 Altnagelvin Area Hospital'),
(4983, 'https://ror.org/05xysjr32', 'en', 1, 'https://ror.org/05xysjr32 Kessler Institute for Rehabilitation'),
(4984, 'https://ror.org/05y06tg49', 'en', 1, 'https://ror.org/05y06tg49 October 6 University جامعة السادس من أكتوبر'),
(4985, 'https://ror.org/05y26ar20', 'pt', 1, 'https://ror.org/05y26ar20 Universidade Regional do Cariri'),
(4986, 'https://ror.org/05y33vv83', 'es', 1, 'https://ror.org/05y33vv83 Universidad del Desarrollo'),
(4987, 'https://ror.org/05y50nr98', 'en', 1, 'https://ror.org/05y50nr98 Suffolk University Universidad de Suffolk'),
(4988, 'https://ror.org/05y5qmm69', 'en', 1, 'https://ror.org/05y5qmm69 Heritage University'),
(4989, 'https://ror.org/05y7e6905', 'no_lang_code', 1, 'https://ror.org/05y7e6905 Sahmyook Medical Center 삼육의료원서울병원'),
(4990, 'https://ror.org/05y8s3144', 'no_lang_code', 1, 'https://ror.org/05y8s3144 TPL (United States)'),
(4991, 'https://ror.org/05y999856', 'pt', 1, 'https://ror.org/05y999856 Hospital Mãe de Deus'),
(4992, 'https://ror.org/05ybvz010', 'en', 1, 'https://ror.org/05ybvz010 Mater Dei Hospital'),
(4993, 'https://ror.org/05yc6p159', 'en', 1, 'https://ror.org/05yc6p159 Yeungnam University 영남대학교'),
(4994, 'https://ror.org/05ydecq02', 'en', 1, 'https://ror.org/05ydecq02 Urho Kaleva Kekkonen Institute'),
(4995, 'https://ror.org/05ydxj072', 'en', 1, 'https://ror.org/05ydxj072 Hallym University Medical Center 한림대학교의료원'),
(4996, 'https://ror.org/05yevkn97', 'en', 1, 'https://ror.org/05yevkn97 Sendai Kousei Hospital 仙台厚生病院'),
(4997, 'https://ror.org/05yjz6y13', 'en', 1, 'https://ror.org/05yjz6y13 University Medical Center Rizk Hospital'),
(4998, 'https://ror.org/05yjze111', 'en', 1, 'https://ror.org/05yjze111 Unity Hospital'),
(4999, 'https://ror.org/05ym42410', 'en', 1, 'https://ror.org/05ym42410 Gansu Agricultural University 甘肃农业大学'),
(5000, 'https://ror.org/05ymyxj51', 'en', 1, 'https://ror.org/05ymyxj51 Royal Columbian Hospital'),
(5001, 'https://ror.org/0002vhf72', 'no_lang_code', 1, 'https://ror.org/0002vhf72 Galenea (United States)'),
(5002, 'https://ror.org/0003zy991', 'en', 1, 'https://ror.org/0003zy991 York Hospital'),
(5003, 'https://ror.org/0004bx792', 'no_lang_code', 1, 'https://ror.org/0004bx792 SignalChem (Canada)'),
(5004, 'https://ror.org/0004ysa08', 'en', 1, 'https://ror.org/0004ysa08 Centre for innovative process engineering'),
(5005, 'https://ror.org/0006jev58', 'no_lang_code', 1, 'https://ror.org/0006jev58 Alpha Technologies (Canada)'),
(5006, 'https://ror.org/0006n3612', 'en', 1, 'https://ror.org/0006n3612 Oak Crest Institute of Science'),
(5007, 'https://ror.org/0007tes83', 'no_lang_code', 1, 'https://ror.org/0007tes83 Tominaga hospital 富永病院'),
(5008, 'https://ror.org/0008kdt06', 'en', 1, 'https://ror.org/0008kdt06 Hearthstone Alzheimer Care'),
(5009, 'https://ror.org/00096h502', 'en', 1, 'https://ror.org/00096h502 Native American Cancer Research'),
(5010, 'https://ror.org/000a1cz07', 'no_lang_code', 1, 'https://ror.org/000a1cz07 Fianium (United Kingdom)'),
(5011, 'https://ror.org/000apqb71', 'en', 1, 'https://ror.org/000apqb71 Philadelphia Fire Department'),
(5012, 'https://ror.org/000cxfw53', 'no_lang_code', 1, 'https://ror.org/000cxfw53 Aradigm (United States)'),
(5013, 'https://ror.org/000czbn37', 'no_lang_code', 1, 'https://ror.org/000czbn37 iProgen Biotech (Canada)'),
(5014, 'https://ror.org/000dhg681', 'no_lang_code', 1, 'https://ror.org/000dhg681 Stratonics (United States)'),
(5015, 'https://ror.org/000dzg547', 'no_lang_code', 1, 'https://ror.org/000dzg547 Scientific Solutions (United States)'),
(5016, 'https://ror.org/000e3j968', 'tr', 1, 'https://ror.org/000e3j968 Türkiye Yüksek İhtisas Hastanesi'),
(5017, 'https://ror.org/000ep5m48', 'es', 1, 'https://ror.org/000ep5m48 Instituto de Salud Pública de Navarra'),
(5018, 'https://ror.org/000fmbj50', 'en', 1, 'https://ror.org/000fmbj50 California Rural Indian Health Board'),
(5019, 'https://ror.org/000g90y93', 'en', 1, 'https://ror.org/000g90y93 Fresno Unified School District'),
(5020, 'https://ror.org/000jqak13', 'no_lang_code', 1, 'https://ror.org/000jqak13 ECBio (Portugal)'),
(5021, 'https://ror.org/000qjjz95', 'en', 1, 'https://ror.org/000qjjz95 Park Centre for Mental Health'),
(5022, 'https://ror.org/000smmv87', 'no_lang_code', 1, 'https://ror.org/000smmv87 Morinaga Institute of Biological Science'),
(5023, 'https://ror.org/000vy8681', 'en', 1, 'https://ror.org/000vy8681 National Institute of Agricultural Science and Technology'),
(5024, 'https://ror.org/000x99506', 'no_lang_code', 1, 'https://ror.org/000x99506 Biodynamic Research Corporation (United States)'),
(5025, 'https://ror.org/000z4wj31', 'en', 1, 'https://ror.org/000z4wj31 Center for Naval Analyses'),
(5026, 'https://ror.org/000zk0m89', 'no_lang_code', 1, 'https://ror.org/000zk0m89 Nanoco Technologies (United Kingdom)'),
(5027, 'https://ror.org/000znb612', 'no_lang_code', 1, 'https://ror.org/000znb612 Banca Rìoghail na h-Alba Royal Bank of Scotland (United Kingdom)'),
(5028, 'https://ror.org/001040h60', 'en', 1, 'https://ror.org/001040h60 American Indian Center'),
(5029, 'https://ror.org/00109m582', 'en', 1, 'https://ror.org/00109m582 Community Connections'),
(5030, 'https://ror.org/0010c1z81', 'de', 1, 'https://ror.org/0010c1z81 Deutsche Klinik für Diagnostik'),
(5031, 'https://ror.org/0010ry587', 'no_lang_code', 1, 'https://ror.org/0010ry587 Ultra Electronics (Canada)'),
(5032, 'https://ror.org/0011v4420', 'en', 1, 'https://ror.org/0011v4420 Zübeyde Hanim Maternity Hospital'),
(5033, 'https://ror.org/0012w1115', 'no_lang_code', 1, 'https://ror.org/0012w1115 EcoMetrix'),
(5034, 'https://ror.org/0014wkh93', 'no_lang_code', 1, 'https://ror.org/0014wkh93 Tucker-Davis Technologies (United States)'),
(5035, 'https://ror.org/0015wff52', 'no_lang_code', 1, 'https://ror.org/0015wff52 Implant Sciences (United States)'),
(5036, 'https://ror.org/0015zns27', 'no_lang_code', 1, 'https://ror.org/0015zns27 KCTS 9 (United States)'),
(5037, 'https://ror.org/0016w2w54', 'en', 1, 'https://ror.org/0016w2w54 Des Moines Area Community College'),
(5038, 'https://ror.org/0016z8240', 'no_lang_code', 1, 'https://ror.org/0016z8240 Liminal BioSciences (Canada)'),
(5039, 'https://ror.org/00174r125', 'en', 1, 'https://ror.org/00174r125 Foundation for Blood Research'),
(5040, 'https://ror.org/001cbt815', 'en', 1, 'https://ror.org/001cbt815 Mt. Hood Community College'),
(5041, 'https://ror.org/001dsq926', 'no_lang_code', 1, 'https://ror.org/001dsq926 DeltaMetrics (United States)'),
(5042, 'https://ror.org/001dw2225', 'en', 1, 'https://ror.org/001dw2225 Central Aerohydrodynamic Institute Центральный аэрогидродинамический институт имени профессора Н.Е. Жуковского'),
(5043, 'https://ror.org/001fvka94', 'no_lang_code', 1, 'https://ror.org/001fvka94 Wilson Wolf Manufacturing (United States)'),
(5044, 'https://ror.org/001kbwb95', 'no_lang_code', 1, 'https://ror.org/001kbwb95 Decision Demographics (United States)'),
(5045, 'https://ror.org/001m3hq40', 'en', 1, 'https://ror.org/001m3hq40 Communication Matters'),
(5046, 'https://ror.org/001s05659', 'en', 1, 'https://ror.org/001s05659 Blood Transfusion Centre of Slovenia'),
(5047, 'https://ror.org/001s4dh65', 'no_lang_code', 1, 'https://ror.org/001s4dh65 Cambridge Scientific (United States)'),
(5048, 'https://ror.org/001tmkc70', 'no_lang_code', 1, 'https://ror.org/001tmkc70 Ivoclar Vivadent (Liechtenstein)'),
(5049, 'https://ror.org/001yedb91', 'no_lang_code', 1, 'https://ror.org/001yedb91 Actelion (Switzerland)'),
(5050, 'https://ror.org/001ykb961', 'en', 1, 'https://ror.org/001ykb961 National Evolutionary Synthesis Center'),
(5051, 'https://ror.org/00226bs07', 'no_lang_code', 1, 'https://ror.org/00226bs07 Scarab Genomics (United States)'),
(5052, 'https://ror.org/002298757', 'no_lang_code', 1, 'https://ror.org/002298757 Allozyne (United States)'),
(5053, 'https://ror.org/0023asr12', 'en', 1, 'https://ror.org/0023asr12 Singapore Science Park Taman Sains Singapura 新加坡科学园'),
(5054, 'https://ror.org/0024cws33', 'en', 1, 'https://ror.org/0024cws33 Food Research Institute'),
(5055, 'https://ror.org/0024cyb77', 'no_lang_code', 1, 'https://ror.org/0024cyb77 Stottler Henke Associates (United States)'),
(5056, 'https://ror.org/002573656', 'no_lang_code', 1, 'https://ror.org/002573656 NeurAxon (Canada)'),
(5057, 'https://ror.org/0027jd641', 'no_lang_code', 1, 'https://ror.org/0027jd641 Cell Culture Company (United States)'),
(5058, 'https://ror.org/0028z3k74', 'en', 1, 'https://ror.org/0028z3k74 Orange County Research Center'),
(5059, 'https://ror.org/002bnpr17', 'pt', 1, 'https://ror.org/002bnpr17 Fundação de Medicina Tropical'),
(5060, 'https://ror.org/002cajb45', 'no_lang_code', 1, 'https://ror.org/002cajb45 Carterra (United States)'),
(5061, 'https://ror.org/002feag21', 'en', 1, 'https://ror.org/002feag21 Bostwick Laboratories'),
(5062, 'https://ror.org/002j9jj25', 'en', 1, 'https://ror.org/002j9jj25 Harrisburg Area Community College'),
(5063, 'https://ror.org/002k3wk88', 'en', 1, 'https://ror.org/002k3wk88 National Medical Products Administration'),
(5064, 'https://ror.org/002kdhq94', 'no_lang_code', 1, 'https://ror.org/002kdhq94 Online Technologies (United States)'),
(5065, 'https://ror.org/002m5c441', 'no_lang_code', 1, 'https://ror.org/002m5c441 Xention (United Kingdom)'),
(5066, 'https://ror.org/002mbwb34', 'en', 1, 'https://ror.org/002mbwb34 Passaic County Community College'),
(5067, 'https://ror.org/002nf6q61', 'en', 1, 'https://ror.org/002nf6q61 Bandim Health Project Projecto de Saúde Bandim'),
(5068, 'https://ror.org/002t6g510', 'en', 1, 'https://ror.org/002t6g510 Dick Young Productions'),
(5069, 'https://ror.org/002vjkr06', 'en', 1, 'https://ror.org/002vjkr06 Pima Prevention Partnership'),
(5070, 'https://ror.org/002xn3f27', 'no_lang_code', 1, 'https://ror.org/002xn3f27 SciberQuest (United States)'),
(5071, 'https://ror.org/002y1bq07', 'en', 1, 'https://ror.org/002y1bq07 Madison Area Technical College'),
(5072, 'https://ror.org/002yzpx87', 'no_lang_code', 1, 'https://ror.org/002yzpx87 BASF (United States)'),
(5073, 'https://ror.org/0033n4009', 'no_lang_code', 1, 'https://ror.org/0033n4009 ABB (Sweden)'),
(5074, 'https://ror.org/0034k3d56', 'en', 1, 'https://ror.org/0034k3d56 Department of Community and Human Services'),
(5075, 'https://ror.org/0038zh709', 'it', 1, 'https://ror.org/0038zh709 Consorzio per Valutazioni Biologiche e Farmacologiche'),
(5076, 'https://ror.org/0039ss191', 'no_lang_code', 1, 'https://ror.org/0039ss191 Altravax (United States)'),
(5077, 'https://ror.org/003a79y48', 'en', 1, 'https://ror.org/003a79y48 Perm State Medical Academy Пермский государственный медицинский университет'),
(5078, 'https://ror.org/003ck6433', 'en', 1, 'https://ror.org/003ck6433 National Microelectronics Institute'),
(5079, 'https://ror.org/003dqcp70', 'no_lang_code', 1, 'https://ror.org/003dqcp70 Fujirebio (Belgium)'),
(5080, 'https://ror.org/003fgzm76', 'en', 1, 'https://ror.org/003fgzm76 Mount Carmel College of Nursing'),
(5081, 'https://ror.org/003frhn24', 'en', 1, 'https://ror.org/003frhn24 Amarillo College'),
(5082, 'https://ror.org/003fzn994', 'no_lang_code', 1, 'https://ror.org/003fzn994 TMO Renewables (United Kingdom)'),
(5083, 'https://ror.org/003g0xf19', 'en', 1, 'https://ror.org/003g0xf19 VA New Jersey Health Care System'),
(5084, 'https://ror.org/003hr6w03', 'en', 1, 'https://ror.org/003hr6w03 MotherToBaby'),
(5085, 'https://ror.org/003jsdw96', 'en', 1, 'https://ror.org/003jsdw96 Macedonian Academy of Sciences and Arts'),
(5086, 'https://ror.org/003jtsa97', 'en', 1, 'https://ror.org/003jtsa97 St. Joseph''s Hospital'),
(5087, 'https://ror.org/003kv9x13', 'en', 1, 'https://ror.org/003kv9x13 Health & Safety Laboratory'),
(5088, 'https://ror.org/003mpgw14', 'en', 1, 'https://ror.org/003mpgw14 St. Elisabeth Hospital'),
(5089, 'https://ror.org/003nnep52', 'pt', 1, 'https://ror.org/003nnep52 Irmandade da Santa Casa de Misericórdia de São Paulo');
INSERT INTO `rors` VALUES
(5090, 'https://ror.org/003pdcw24', 'no_lang_code', 1, 'https://ror.org/003pdcw24 Vestas (Denmark)'),
(5091, 'https://ror.org/003qr7703', 'en', 1, 'https://ror.org/003qr7703 Peijaksen sairaala Peijas Hospital'),
(5092, 'https://ror.org/003tra577', 'en', 1, 'https://ror.org/003tra577 Arizona Office of the Governor'),
(5093, 'https://ror.org/0042e5975', 'it', 1, 'https://ror.org/0042e5975 Istituto Nanoscienze'),
(5094, 'https://ror.org/00485s352', 'no_lang_code', 1, 'https://ror.org/00485s352 Danaher (United Kingdom)'),
(5095, 'https://ror.org/004a2wv92', 'en', 1, 'https://ror.org/004a2wv92 National Institute of Dental and Craniofacial Research'),
(5096, 'https://ror.org/004aekm03', 'en', 1, 'https://ror.org/004aekm03 South Carolina HIV/AIDS Council'),
(5097, 'https://ror.org/004amc442', 'en', 1, 'https://ror.org/004amc442 Orthopaedic Center'),
(5098, 'https://ror.org/004cah429', 'no_lang_code', 1, 'https://ror.org/004cah429 Toyama Prefectural Central Hospital 富山県立中央病院'),
(5099, 'https://ror.org/004ej3g52', 'en', 1, 'https://ror.org/004ej3g52 National Defense Medical College Hospital 防衛医科大学校病院'),
(5100, 'https://ror.org/004ejmg69', 'no_lang_code', 1, 'https://ror.org/004ejmg69 Aerpio Pharmaceuticals (United States)'),
(5101, 'https://ror.org/004es3518', 'no_lang_code', 1, 'https://ror.org/004es3518 Red Hill Studios'),
(5102, 'https://ror.org/004g7tk16', 'en', 1, 'https://ror.org/004g7tk16 Canadian Fitness and Lifestyle Research Institute'),
(5103, 'https://ror.org/004gw9825', 'en', 1, 'https://ror.org/004gw9825 Southeast Community College'),
(5104, 'https://ror.org/004hfxk38', 'no_lang_code', 1, 'https://ror.org/004hfxk38 Theageneio General Hospital'),
(5105, 'https://ror.org/004hxna20', 'en', 1, 'https://ror.org/004hxna20 Overlake Hospital Medical Center'),
(5106, 'https://ror.org/004m2d892', 'no_lang_code', 1, 'https://ror.org/004m2d892 Impact Assessment'),
(5107, 'https://ror.org/004n9sm55', 'en', 1, 'https://ror.org/004n9sm55 New England Center for Children'),
(5108, 'https://ror.org/004pk7083', 'en', 1, 'https://ror.org/004pk7083 Cedars-Sinai Kerlan-Jobe Institute'),
(5109, 'https://ror.org/004q7z165', 'en', 1, 'https://ror.org/004q7z165 New York College of Podiatric Medicine'),
(5110, 'https://ror.org/004s94c80', 'pt', 1, 'https://ror.org/004s94c80 Biocant'),
(5111, 'https://ror.org/004v7xm28', 'no_lang_code', 1, 'https://ror.org/004v7xm28 Modellium (Canada)'),
(5112, 'https://ror.org/004vn8r55', 'es', 1, 'https://ror.org/004vn8r55 Centro Médico Nacional La Raza'),
(5113, 'https://ror.org/004wdnc96', 'no_lang_code', 1, 'https://ror.org/004wdnc96 Siloam Biosciences (United States)'),
(5114, 'https://ror.org/004wh0w58', 'en', 1, 'https://ror.org/004wh0w58 Guthrie Foundation'),
(5115, 'https://ror.org/004x58208', 'en', 1, 'https://ror.org/004x58208 St. John Medical Center'),
(5116, 'https://ror.org/004xj7429', 'no_lang_code', 1, 'https://ror.org/004xj7429 Ingenza (United Kingdom)'),
(5117, 'https://ror.org/004zcwt94', 'no_lang_code', 1, 'https://ror.org/004zcwt94 Universal Sensors (United States)'),
(5118, 'https://ror.org/004zwen25', 'no_lang_code', 1, 'https://ror.org/004zwen25 Intelligent Optical Systems (United States)'),
(5119, 'https://ror.org/0050g6f93', 'en', 1, 'https://ror.org/0050g6f93 KKR Tohoku Kosai Hospital 東北公済病院'),
(5120, 'https://ror.org/005296895', 'en', 1, 'https://ror.org/005296895 BOOMHealth'),
(5121, 'https://ror.org/0053ctp29', 'it', 1, 'https://ror.org/0053ctp29 Ospedale Maggiore'),
(5122, 'https://ror.org/0056qeq43', 'no_lang_code', 1, 'https://ror.org/0056qeq43 Toyonaka Municipal Hospital 市立豊中病院'),
(5123, 'https://ror.org/0056x7z10', 'en', 1, 'https://ror.org/0056x7z10 Philander Smith College'),
(5124, 'https://ror.org/0057tdk10', 'no_lang_code', 1, 'https://ror.org/0057tdk10 La Jolla Science Applications (United States)'),
(5125, 'https://ror.org/0059mbq09', 'no_lang_code', 1, 'https://ror.org/0059mbq09 Integrity Testing Laboratory (Canada)'),
(5126, 'https://ror.org/005avv954', 'en', 1, 'https://ror.org/005avv954 Shea Ear Clinic'),
(5127, 'https://ror.org/005df7g82', 'en', 1, 'https://ror.org/005df7g82 Saudi Center for Organ Transplantation'),
(5128, 'https://ror.org/005dyph89', 'en', 1, 'https://ror.org/005dyph89 Hawaii Agriculture Research Center'),
(5129, 'https://ror.org/005e2bj09', 'en', 1, 'https://ror.org/005e2bj09 St.Petersburg V.M.Bekhterev Psychoneurological Research Institute Санкт-Петербургский научно-исследовательский психоневрологический институт им. В.М. Бехтерева'),
(5130, 'https://ror.org/005f8zs60', 'no_lang_code', 1, 'https://ror.org/005f8zs60 Nanoptics (United States)'),
(5131, 'https://ror.org/005fx5296', 'en', 1, 'https://ror.org/005fx5296 Austen Riggs Center'),
(5132, 'https://ror.org/005j1v069', 'en', 1, 'https://ror.org/005j1v069 Pathfinder International'),
(5133, 'https://ror.org/005k4dn45', 'en', 1, 'https://ror.org/005k4dn45 University of Arkansas Medical Center'),
(5134, 'https://ror.org/005kew443', 'no_lang_code', 1, 'https://ror.org/005kew443 GC Image (United States)'),
(5135, 'https://ror.org/005kxm139', 'no_lang_code', 1, 'https://ror.org/005kxm139 Bridge12 Technologies (United States)'),
(5136, 'https://ror.org/005m2at17', 'en', 1, 'https://ror.org/005m2at17 Harvard Affiliated Emergency Medicine Residency'),
(5137, 'https://ror.org/005nrbr06', 'no_lang_code', 1, 'https://ror.org/005nrbr06 Phrixus Pharmaceuticals (United States)'),
(5138, 'https://ror.org/005pxtk56', 'no_lang_code', 1, 'https://ror.org/005pxtk56 Cabezon Group (United States)'),
(5139, 'https://ror.org/005qf7j34', 'en', 1, 'https://ror.org/005qf7j34 Harlem United'),
(5140, 'https://ror.org/005t0ps98', 'fr', 1, 'https://ror.org/005t0ps98 Institut Arnault Tzanck'),
(5141, 'https://ror.org/005tjs461', 'en', 1, 'https://ror.org/005tjs461 American Association for the Study of Liver Diseases'),
(5142, 'https://ror.org/005yt8w56', 'no_lang_code', 1, 'https://ror.org/005yt8w56 Opotek (United States) Opotek Incorporation'),
(5143, 'https://ror.org/0060hwx87', 'no_lang_code', 1, 'https://ror.org/0060hwx87 Alliance Pharmaceutical (United States)'),
(5144, 'https://ror.org/0062dz060', 'en', 1, 'https://ror.org/0062dz060 Norwich Research Park'),
(5145, 'https://ror.org/00655dk85', 'en', 1, 'https://ror.org/00655dk85 Glasgow Life'),
(5146, 'https://ror.org/0068vzv72', 'no_lang_code', 1, 'https://ror.org/0068vzv72 National Instruments (United Kingdom)'),
(5147, 'https://ror.org/0069kqw53', 'en', 1, 'https://ror.org/0069kqw53 Environmental Research Institute of Michigan'),
(5148, 'https://ror.org/006d11e04', 'no_lang_code', 1, 'https://ror.o