<!DOCTYPE html>
<html lang="<?php echo get_html_lang(); ?>">
<head>
    <meta charset="utf-8">
    <?php if ($author = option('author')): ?>
    <meta name="author" content="<?php echo $author; ?>" />
    <?php endif; ?>
    <?php if ($copyright = option('copyright')): ?>
    <meta name="copyright" content="<?php echo $copyright; ?>" />
    <?php endif; ?>
    <?php if ($description = option('description')): ?>
    <meta name="description" content="<?php echo $description; ?>" />
    <?php endif; ?>
    <?php
    if (isset($title)) {
        $titleParts[] = strip_formatting($title);
    }
    $titleParts[] = option('site_title');
    ?>
    <title><?php echo implode(' &middot; ', $titleParts); ?></title>

    <?php echo auto_discovery_link_tags(); ?>

    <!-- Plugin Stuff -->
    <?php fire_plugin_hook('public_head', ['view' => $this]); ?>

    <!-- Stylesheets -->
    <?php
    queue_css_file('style');
    echo head_css();
    ?>

    <!-- JavaScripts -->
    <?php echo head_js(); ?>
</head>

<?php echo body_tag(['id' => @$bodyid, 'class' => @$bodyclass]); ?>
    <a href="#content" id="skipnav"><?php echo __('Skip to main content'); ?></a>
    <?php fire_plugin_hook('public_body', ['view' => $this]); ?>
    <div id="wrap">

        <header role="banner">

            <?php fire_plugin_hook('public_header', ['view' => $this]); ?>

            <?php echo theme_header_image(); ?>

            <div id="search-container" role="search">
                <?php echo search_form(); ?>
            </div><!-- end search -->

            <div id="site-title"><?php echo link_to_home_page(theme_logo()); ?></div>
            
            <nav id="top-nav" role="navigation">
                <?php echo public_nav_main(); ?>
            </nav>

        </header>
        
        <article id="content" role="main">
        
            <?php fire_plugin_hook('public_content_top', ['view' => $this]); ?>
