# Editorial Workflow

1. Introduction
2. [Managing Submission Details](editorial-workflow#manage-submission-details)
3. [Participants](editorial-workflow#participants)
4. [Editorial Actions](editorial-workflow#editorial-actions)

The editorial workflow allows you to usher a submission from initial evaluation through peer review, copyediting and production, where the item is prepared for publication.

Each tab on the workflow page provides you with the information, tools and discussion panels you'll need to complete the tasks for that stage. You can [add participants](editorial-workflow#participants) to help you. And when your ready, you'll be presented with a range of [editorial actions](editorial-workflow#editorial-actions) appropriate to each stage.

## <a name="manage-submission-details"></a>Managing Submission Details

Submission details appear at the top of the page. In this area, you'll also find tools to help you manage the submission's metadata and editorial history. The data attached to the submission from these tools persists across all stages.

### <a name="catalog-entry"></a>Catalog Entry

List a submission in your catalog and manage key data about the submission, including the Title and Abstract, assigned categories and series, and any metadata that's been enabled by the administrator.

The **Monograph** tab covers the metadata that is used for indexing your content in discovery services like Google Scholar. And the **Catalog** tab will allow you to enter sales and marketing information.

When you're ready to display a submission in your catalog, visit **Catalog Entry > Catalog** and check the box labeled *Add this book to the public catalog*.

Once you've [added publication formats](editorial-workflow/production), you'll see new tabs for each format which will allow you to enter format-specific metadata.

### <a name="editorial-history"></a>Editorial History

Add notes for record-keeping and view a log of all events associated with this submission. Only editorial and administrative staff have access to the Editorial History.

### <a name="submission-library"></a>Submission Library

A quick-access repository for any files that you'd like to track along with the submission. This is useful for files that aren't specific to any stage, such as signed contracts, marketing files or guidelines you'd like to share with copyeditors or other assistants.

You can quickly add files from your [Press Library](settings#workflow-press-library) by clicking on **View Document Library**.

## <a name="participants"></a>Participants

On the right of each stage of the workflow, you'll find a list of users who have access to this stage. You can add editorial assistants, copyeditors, layout editors or other users you'd like to have access to the current stage.

*When you add a user, that user will have access to any stages allowed by their user role*. For example, an Editor added to the Participants grid will have access to every stage. But a Copyeditor will only have access to the Copyediting stage.

*You won't need to add Reviewers to the Participants panel.* Once you get to the [review stages](editorial-workflow/review), you'll be able to manage the reviewers in a more convenient panel.

## <a name="editorial-actions"></a> Editorial Actions

At the top right of each stage of the workflow, you'll see the editorial actions available to you. These decisions change with each stage. But in most cases, they complete the current stage and forward the submission onto the next stage.

Read the help guide for each stage to learn more about the editorial actions.
