# Workflow Settings

1. [Submission](workflow-settings#submission)
1. [Review](workflow-settings#review)
1. [Press Library](workflow-settings#publisher)
1. [Emails](workflow-settings#emails)

Configure all aspects of the [Editorial Workflow](../editorial-workflow), including file management, submission guidelines and requirements, peer review deadlines and guidelines, email notifications and much more.

## <a name="submission"></a>Submission

Set submission requirements, provide author guidelines, configure your submission file types and more.

### Disable Submissions
If you want to disable submissions for the whole journal you can check the box here. Or to disable submissions in a specific series, click the **Press series** link.

### Metadata

Decide which types of metadata, such as keywords and references, your press will support.

You can also determine whether or not the author should be required to provide each type of metadata during submission, or whether this information should be added by editors.

### Components

Your publication files may consist of a number of components, including a book-length manuscript or a chapter-length manuscript, as well as illustrations, glossary, index and more.

When authors and editors upload files to a submission, they will be asked to identify the component of this file.

The Components tab provides a list of common components by default. You are encouraged to add or edit components to suit the particular needs of your press.

Delete those that aren't appropriate for your press. This will reduce the options faced by authors struggling through their first submission.

### Checklist

Provide authors with a checklist of tasks they should complete before making their submission. This is a good place to indicate requirements for referencing, font size, line spacing, document format and more.

### Author Guidelines

Provide any additional guidelines that are not adequately covered in the submission checklist and provide a copyright statement to inform submitting authors of their rights.

## <a name="review"></a>Review

Set all of your review policies and procedures, including deadlines, notifications, reviewer guidelines and more.

### Default Review Mode

Choose the review mode that should be used by default. An editor will be able to choose another type when needed, but will usually use the default.

### Restrict File Access

By default, a reviewer will be able to view submission files before deciding whether or not to review it. Check this box if you would like them to accept a review assignment before viewing the files.

### Internal and External Review Guidelines

Provide reviewers with criteria for judging a submission's suitability for publication in the journal, which may include instructions for preparing an effective and helpful review. Reviewers will have an opportunity to provide comments intended for the author and editor, as well as separate comments only for the editor.

Many presses prefer to pass a submission through an internal review before being sent for external review. You may tailor your instructions to each group of reviewers.

### Competing Interests

Reviewers will be asked to confirm that they comply with the competing interests disclosure policy you specify below.

### Review Forms

If you'd like to request specific information from reviewers, you can build forms here. An editor will be able to select a form when assigning a reviewer, and the reviewer will be asked to complete that form when they are submitting their review.

## <a name="publisher"></a>Press Library

The Press Library provides a file repository for storing and quickly sharing common files, such as writing guidelines, author contracts and release forms, and marketing materials.

Items that are stored in the Press Library can be quickly retrieved and added into a [Submission Library](editorial-workflow#submission-library) to be shared with authors or assistants.

## <a name="emails"></a>Emails

OMP sends a number of emails during various stages of the [Editorial Workflow](editorial-workflow), as well as other actions such as registration and submission acknowledgement.

The settings in this section allow you to tailor the common header and signature that accompany those emails, as well as update the email defaults for each type of email that's sent out.

You can view more about one of the emails in the list by clicking the dropdown arrow on the right.

Click **Filters** to filter templates by sender, recipient, workflow stage, and whether the template is enabled.

*If you want to restore an email template to it's default, use the __Reset__ button to restore the default message. This button is only available for email templates that have been modified.*
