SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `ops3409`
--
-- --------------------------------------------------------

--
-- Table structure for table `access_keys`
--

CREATE TABLE `access_keys` (
  `access_key_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context` varchar(40) NOT NULL,
  `key_hash` varchar(40) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `assoc_id` bigint(20) DEFAULT NULL,
  `expiry_date` datetime NOT NULL,
  PRIMARY KEY (`access_key_id`),
  KEY `access_keys_user_id` (`user_id`),
  KEY `access_keys_hash` (`key_hash`,`user_id`,`context`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Access keys are used to provide pseudo-login functionality for security-minimal tasks. Passkeys can be emailed directly to users, who can use them for a limited time in lieu of standard username and password.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `announcements`
--

CREATE TABLE `announcements` (
  `announcement_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` smallint(6) DEFAULT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `type_id` bigint(20) DEFAULT NULL,
  `date_expire` date DEFAULT NULL,
  `date_posted` datetime NOT NULL,
  PRIMARY KEY (`announcement_id`),
  KEY `announcements_type_id` (`type_id`),
  KEY `announcements_assoc` (`assoc_type`,`assoc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Announcements are messages that can be presented to users e.g. on the homepage.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `announcement_settings`
--

CREATE TABLE `announcement_settings` (
  `announcement_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `announcement_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`announcement_setting_id`),
  UNIQUE KEY `announcement_settings_unique` (`announcement_id`,`locale`,`setting_name`),
  KEY `announcement_settings_announcement_id` (`announcement_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about announcements, including localized properties like names and contents.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `announcement_types`
--

CREATE TABLE `announcement_types` (
  `type_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  PRIMARY KEY (`type_id`),
  KEY `announcement_types_context_id` (`context_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Announcement types allow for announcements to optionally be categorized.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `announcement_type_settings`
--

CREATE TABLE `announcement_type_settings` (
  `announcement_type_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`announcement_type_setting_id`),
  UNIQUE KEY `announcement_type_settings_unique` (`type_id`,`locale`,`setting_name`),
  KEY `announcement_type_settings_type_id` (`type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about announcement types, including localized properties like their names.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `authors`
--

CREATE TABLE `authors` (
  `author_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `email` varchar(90) NOT NULL,
  `include_in_browse` smallint(6) NOT NULL DEFAULT '1',
  `publication_id` bigint(20) NOT NULL,
  `seq` double(8,2) NOT NULL DEFAULT '0.00',
  `user_group_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`author_id`),
  KEY `authors_user_group_id` (`user_group_id`),
  KEY `authors_publication_id` (`publication_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The authors of a publication.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `author_settings`
--

CREATE TABLE `author_settings` (
  `author_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `author_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`author_setting_id`),
  UNIQUE KEY `author_settings_unique` (`author_id`,`locale`,`setting_name`),
  KEY `author_settings_author_id` (`author_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about authors, including localized properties such as their name and affiliation.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `categories`
--

CREATE TABLE `categories` (
  `category_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `parent_id` bigint(20) DEFAULT NULL,
  `seq` bigint(20) DEFAULT NULL,
  `path` varchar(255) NOT NULL,
  `image` text,
  PRIMARY KEY (`category_id`),
  UNIQUE KEY `category_path` (`context_id`,`path`),
  KEY `category_context_id` (`context_id`),
  KEY `category_context_parent_id` (`context_id`,`parent_id`),
  KEY `category_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Categories permit the organization of submissions into a heirarchical structure.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `category_settings`
--

CREATE TABLE `category_settings` (
  `category_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`category_setting_id`),
  UNIQUE KEY `category_settings_unique` (`category_id`,`locale`,`setting_name`),
  KEY `category_settings_category_id` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about categories, including localized properties such as names.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `citations`
--

CREATE TABLE `citations` (
  `citation_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `publication_id` bigint(20) NOT NULL,
  `raw_citation` text NOT NULL,
  `seq` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`citation_id`),
  UNIQUE KEY `citations_publication_seq` (`publication_id`,`seq`),
  KEY `citations_publication` (`publication_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A citation made by an associated publication.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `citation_settings`
--

CREATE TABLE `citation_settings` (
  `citation_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `citation_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`citation_setting_id`),
  UNIQUE KEY `citation_settings_unique` (`citation_id`,`locale`,`setting_name`),
  KEY `citation_settings_citation_id` (`citation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Additional data about citations, including localized content.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `controlled_vocabs`
--

CREATE TABLE `controlled_vocabs` (
  `controlled_vocab_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `symbolic` varchar(64) NOT NULL,
  `assoc_type` bigint(20) NOT NULL DEFAULT '0',
  `assoc_id` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`controlled_vocab_id`),
  UNIQUE KEY `controlled_vocab_symbolic` (`symbolic`,`assoc_type`,`assoc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Every word or phrase used in a controlled vocabulary. Controlled vocabularies are used for submission metadata like keywords and subjects, reviewer interests, and wherever a similar dictionary of words or phrases is required. Each entry corresponds to a word or phrase like "cellular reproduction" and a type like "submissionKeyword".' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `controlled_vocab_entries`
--

CREATE TABLE `controlled_vocab_entries` (
  `controlled_vocab_entry_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `controlled_vocab_id` bigint(20) NOT NULL,
  `seq` double(8,2) DEFAULT NULL,
  PRIMARY KEY (`controlled_vocab_entry_id`),
  KEY `controlled_vocab_entries_controlled_vocab_id` (`controlled_vocab_id`),
  KEY `controlled_vocab_entries_cv_id` (`controlled_vocab_id`,`seq`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The order that a word or phrase used in a controlled vocabulary should appear. For example, the order of keywords in a publication.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `controlled_vocab_entry_settings`
--

CREATE TABLE `controlled_vocab_entry_settings` (
  `controlled_vocab_entry_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `controlled_vocab_entry_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`controlled_vocab_entry_setting_id`),
  UNIQUE KEY `c_v_e_s_pkey` (`controlled_vocab_entry_id`,`locale`,`setting_name`),
  KEY `c_v_e_s_entry_id` (`controlled_vocab_entry_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about a controlled vocabulary entry, including localized properties such as the actual word or phrase.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `data_object_tombstones`
--

CREATE TABLE `data_object_tombstones` (
  `tombstone_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `data_object_id` bigint(20) NOT NULL,
  `date_deleted` datetime NOT NULL,
  `set_spec` varchar(255) NOT NULL,
  `set_name` varchar(255) NOT NULL,
  `oai_identifier` varchar(255) NOT NULL,
  PRIMARY KEY (`tombstone_id`),
  KEY `data_object_tombstones_data_object_id` (`data_object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Entries for published data that has been removed. Usually used in the OAI endpoint.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `data_object_tombstone_oai_set_objects`
--

CREATE TABLE `data_object_tombstone_oai_set_objects` (
  `object_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `tombstone_id` bigint(20) NOT NULL,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  PRIMARY KEY (`object_id`),
  KEY `data_object_tombstone_oai_set_objects_tombstone_id` (`tombstone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Relationships between tombstones and other data that can be collected in OAI sets, e.g. sections.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `data_object_tombstone_settings`
--

CREATE TABLE `data_object_tombstone_settings` (
  `tombstone_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tombstone_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  PRIMARY KEY (`tombstone_setting_id`),
  UNIQUE KEY `data_object_tombstone_settings_unique` (`tombstone_id`,`locale`,`setting_name`),
  KEY `data_object_tombstone_settings_tombstone_id` (`tombstone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about data object tombstones, including localized content.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `dois`
--

CREATE TABLE `dois` (
  `doi_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `doi` varchar(255) NOT NULL,
  `status` smallint(6) NOT NULL DEFAULT '1',
  PRIMARY KEY (`doi_id`),
  KEY `dois_context_id` (`context_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores all DOIs used in the system.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `doi_settings`
--

CREATE TABLE `doi_settings` (
  `doi_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `doi_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`doi_setting_id`),
  UNIQUE KEY `doi_settings_unique` (`doi_id`,`locale`,`setting_name`),
  KEY `doi_settings_doi_id` (`doi_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about DOIs, including the registration agency.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `edit_decisions`
--

CREATE TABLE `edit_decisions` (
  `edit_decision_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `review_round_id` bigint(20) DEFAULT NULL,
  `stage_id` bigint(20) DEFAULT NULL,
  `round` smallint(6) DEFAULT NULL,
  `editor_id` bigint(20) NOT NULL,
  `decision` smallint(6) NOT NULL COMMENT 'A numeric constant indicating the decision that was taken. Possible values are listed in the Decision class.',
  `date_decided` datetime NOT NULL,
  PRIMARY KEY (`edit_decision_id`),
  KEY `edit_decisions_submission_id` (`submission_id`),
  KEY `edit_decisions_editor_id` (`editor_id`),
  KEY `edit_decisions_review_round_id` (`review_round_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Editorial decisions recorded on a submission, such as decisions to accept or decline the submission, as well as decisions to send for review, send to copyediting, request revisions, and more.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `email_log`
--

CREATE TABLE `email_log` (
  `log_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `sender_id` bigint(20) NOT NULL,
  `date_sent` datetime NOT NULL,
  `event_type` bigint(20) DEFAULT NULL,
  `from_address` varchar(255) DEFAULT NULL,
  `recipients` text,
  `cc_recipients` text,
  `bcc_recipients` text,
  `subject` varchar(255) DEFAULT NULL,
  `body` text,
  PRIMARY KEY (`log_id`),
  KEY `email_log_assoc` (`assoc_type`,`assoc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A record of email messages that are sent in relation to an associated entity, such as a submission.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `email_log_users`
--

CREATE TABLE `email_log_users` (
  `email_log_user_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `email_log_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  PRIMARY KEY (`email_log_user_id`),
  UNIQUE KEY `email_log_user_id` (`email_log_id`,`user_id`),
  KEY `email_log_users_email_log_id` (`email_log_id`),
  KEY `email_log_users_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A record of users associated with an email log entry.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `email_templates`
--

CREATE TABLE `email_templates` (
  `email_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `email_key` varchar(255) NOT NULL COMMENT 'Unique identifier for this email.',
  `context_id` bigint(20) NOT NULL,
  `alternate_to` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`email_id`),
  UNIQUE KEY `email_templates_email_key` (`email_key`,`context_id`),
  KEY `email_templates_context_id` (`context_id`),
  KEY `email_templates_alternate_to` (`alternate_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Custom email templates created by each context, and overrides of the default templates.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `email_templates_default_data`
--

CREATE TABLE `email_templates_default_data` (
  `email_templates_default_data_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `email_key` varchar(255) NOT NULL COMMENT 'Unique identifier for this email.',
  `locale` varchar(14) NOT NULL DEFAULT 'en',
  `name` varchar(255) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `body` text,
  PRIMARY KEY (`email_templates_default_data_id`),
  UNIQUE KEY `email_templates_default_data_unique` (`email_key`,`locale`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Default email templates created for every installed locale.' AUTO_INCREMENT=162 ;

--
-- Dumping data for table `email_templates_default_data`
--

INSERT INTO `email_templates_default_data` VALUES
(1, 'PASSWORD_RESET_CONFIRM', 'es', 'Confirmación de restablecimiento de contraseña', 'Confirmación de restablecimiento de contraseña', 'Hemos recibido una solicitud para restablecer su contraseña para el sitio web {$siteTitle}. <br />\n<br />\nSi no realizó esta solicitud, ignore este correo electrónico y su contraseña no se cambiará. Si desea restablecer su contraseña, haga clic en la siguiente URL. <br />\n<br />\nRestablecer mi contraseña: {$passwordResetUrl} <br />\n<br />\n{$siteContactName}'),
(2, 'PASSWORD_RESET_CONFIRM', 'fi', 'Vahvista salasanan vaihtaminen', '', ''),
(3, 'PASSWORD_RESET_CONFIRM', 'fr_CA', 'Confirmation de la réinitialisation du mot de passe', 'Confirmation de la réinitialisation du mot de passe', 'Nous avons reçu une demande concernant la réinitialisation de votre mot de passe pour le site Web {$siteTitle}.<br />\n<br />\nSi vous n''avez pas fait cette demande, veuillez ne pas tenir compte du présent message, votre mot de passe restera le même. Si vous souhaitez réinitialiser votre mot de passe, cliquer sur l''URL ci-dessous.<br />\n<br />\nRéinitialisation de mon mot de passe : {$passwordResetUrl}<br />\n<br />\n{$siteContactName}'),
(4, 'PASSWORD_RESET_CONFIRM', 'mk', 'Потврди за ресетирање на лозинката', 'Потврда за ресетирање на лозинка', 'Добивме барање за ресетирање на вашата лозинка за веб-страницата {$siteTitle}. <br />\n<br />\nАко не сте го побарале ова барање, игнорирајте ја оваа е-пошта и лозинката нема да се смени. Ако сакате да ја ресетирате вашата лозинка, кликнете на подолу URL. <br />\n<br />\nРесетирај ја мојата лозинка: {$passwordResetUrl} <br />\n<br />\n{$siteContactName}'),
(5, 'PASSWORD_RESET_CONFIRM', 'nb', '', '', ''),
(6, 'PASSWORD_RESET_CONFIRM', 'pt_BR', 'Confirmar redefinição de Senha', 'Confirmação de Redefinição de Senha', 'Recebemos uma solicitação para redefinir sua senha para o site {$siteTitle}.<br />\n<br />\nSe você não fez esta solicitação, ignore este e-mail e sua senha não será alterada. Se você deseja redefinir sua senha, clique na URL abaixo.<br />\n<br />\nRedefina minha senha: {$passwordResetUrl}<br />\n<br />\n{$siteContactName}'),
(7, 'PASSWORD_RESET_CONFIRM', 'en', 'Password Reset Confirm', 'Password Reset Confirmation', 'We have received a request to reset your password for the {$siteTitle} web site.<br />\n<br />\nIf you did not make this request, please ignore this email and your password will not be changed. If you wish to reset your password, click on the below URL.<br />\n<br />\nReset my password: {$passwordResetUrl}<br />\n<br />\n{$siteContactName}'),
(8, 'USER_REGISTER', 'es', 'Usuario/a creado', 'Registro en el servidor', '{$recipientName} <br />\n<br />\nAhora ha sido registrado como usuario con {$serverName}. Hemos incluido su nombre de usuario y contraseña en este correo electrónico, que son necesarios para todo el trabajo con este servidor a través de su sitio web. En cualquier momento, puede solicitar que lo eliminen de la lista de usuarios del servidor poniéndose en contacto conmigo. <br />\n<br />\nNombre de usuario: {$recipientUsername} <br />\nContraseña: {$password} <br />\n<br />\nGracias <br />\n{$signature}'),
(9, 'USER_REGISTER', 'fi', 'Käyttäjä luotu', '', ''),
(10, 'USER_REGISTER', 'fr_CA', 'Création de l''utilisateur-trice', 'Inscription au serveur', '{$recipientName},<br />\n<br />\nVous êtes désormais inscrit-e en tant qu''utilisateur-trice pour {$serverName}. Votre nom d''utilisateur-trice et votre mot de passe figurent dans ce courriel, lesquels sont requis pour toute interaction avec le serveur via son site Web. À n''importe quel moment, vous pouvez demander à être retiré-e de la liste des utilisateurs-trices du serveur en nous contactant.<br />\n<br />\nNom d''utilisateur-trice : {$recipientUsername}<br />\nMot de passe : {$password}<br />\n<br />\nMerci,<br />\n{$signature}'),
(11, 'USER_REGISTER', 'mk', 'Создаден корисник', 'Регистрација на сервер', '{$recipientName} <br />\n<br />\nСега сте регистрирани како корисник со {$serverName}. Ние ги вклучивме вашето корисничко име и лозинка во оваа е-пошта, кои се потребни за целата работа со овој сервер преку неговата веб-страница. Во кој било момент, можете да побарате да бидете отстранети од списокот на корисници на серверот, контактирајќи ме. <br />\n<br />\nКорисничко име: {$recipientUsername} <br />\nЛозинка: {$password} <br />\n<br />\nВи благодариме, <br />\n{$signature}'),
(12, 'USER_REGISTER', 'nb', '', '', ''),
(13, 'USER_REGISTER', 'pt_BR', 'Usuário Criado', 'Registro do servidor', '{$recipientName}<br />\n<br />\nVocê já foi registrado como usuário com o nome {$serverName}. Incluímos seu nome de usuário e senha neste e-mail, necessários para todo o trabalho neste servidor por meio de seu site. A qualquer momento, você pode pedir para ser removido da lista de usuários do servidor entrando em contato comigo.<br />\n<br />\nNome de usuário: {$recipientUsername}<br />\nSenha: {$password}<br />\n<br />\nObrigado,<br />\n{$signature}'),
(14, 'USER_REGISTER', 'en', 'User Created', 'Server Registration', '{$recipientName}<br />\n<br />\nYou have now been registered as a user with {$serverName}. We have included your username and password in this email, which are needed for all work with this server through its website. At any point, you can ask to be removed from the server''s list of users by contacting me.<br />\n<br />\nUsername: {$recipientUsername}<br />\nPassword: {$password}<br />\n<br />\nThank you,<br />\n{$signature}'),
(15, 'USER_VALIDATE_CONTEXT', 'es', '', 'Valide su cuenta', '{$recipientName} <br />\n<br />\nHa creado una cuenta con {$serverName}, pero antes de poder comenzar a usarla, debe validar su cuenta de correo electrónico. Para hacer esto, simplemente siga el siguiente enlace: <br />\n<br />\n{$enableUrl} <br />\n<br />\nGracias <br />\n{$serverSignature}'),
(16, 'USER_VALIDATE_CONTEXT', 'fi', '', '', ''),
(17, 'USER_VALIDATE_CONTEXT', 'fr_CA', '', 'Valider votre compte', '{$recipientName},<br />\n<br />\nVous avez créé un compte avec {$serverName}. Pour pouvoir commencer à l''utiliser vous devez d''abord valider votre compte de courriel. Pour ce faire, vous n''avez qu''à suivre le lien ci-dessous :<br />\n<br />\n{$activateUrl}<br />\n<br />\nMerci,<br />\n{$serverSignature}'),
(18, 'USER_VALIDATE_CONTEXT', 'mk', 'Потврдете емаил (регистрација на серверот)', 'Потврдете ја вашата сметка', '{$recipientName} <br />\n<br />\nСоздадовте сметка со {$serverName}, но пред да започнете да ја користите, треба да ја потврдите вашата е-пошта. За да го направите ова, едноставно следете ја врската подолу: <br />\n<br />\n{$activateUrl} <br />\n<br />\nВи благодариме, <br />\n{$serverSignature}'),
(19, 'USER_VALIDATE_CONTEXT', 'nb', '', '', ''),
(20, 'USER_VALIDATE_CONTEXT', 'pt_BR', 'Validar e-mail (registro do servidor)', 'Valide Sua Conta', '{$recipientName}<br />\n<br />\nVocê criou uma conta com {$serverName}, mas antes de começar a usá-lo, você precisa validar sua conta de e-mail. Para fazer isso, basta seguir o link abaixo:<br />\n<br />\n{$activateUrl}<br />\n<br />\nObrigado,<br />\n{$serverSignature}'),
(21, 'USER_VALIDATE_CONTEXT', 'en', 'Validate Email (Server Registration)', 'Validate Your Account', '{$recipientName}<br />\n<br />\nYou have created an account with {$serverName}, but before you can start using it, you need to validate your email account. To do this, simply follow the link below:<br />\n<br />\n{$activateUrl}<br />\n<br />\nThank you,<br />\n{$serverSignature}'),
(22, 'USER_VALIDATE_SITE', 'es', 'Validar correo electrónico (Sitio)', '', ''),
(23, 'USER_VALIDATE_SITE', 'fi', 'Vahvista sähköposti (sivusto)', '', ''),
(24, 'USER_VALIDATE_SITE', 'fr_CA', 'Valider le courriel (site)', '', ''),
(25, 'USER_VALIDATE_SITE', 'mk', 'Потврди емаил (Сајт)', 'Потврдете го вашиот профил', '{$recipientName}<br />\n<br />\nСоздадовте профил со {$siteTitle},Но пред да почнете да го користите, треба да го потврдите вашиот емаил профил. За да го сторите тоа, едноставно следете го линкот подолу:<br />\n<br />\n{$activateUrl}<br />\n<br />\nВи благодариме,<br />\n{$siteSignature}'),
(26, 'USER_VALIDATE_SITE', 'nb', '', '', ''),
(27, 'USER_VALIDATE_SITE', 'pt_BR', 'Validar e-mail (site)', 'Valide a sua conta', '{$recipientName}<br />\n<br />\nVocê criou uma conta com {$siteTitle}, mas antes de começar a usá-la, você precisa validar sua conta de e-mail. Para fazer isso, basta acessar o link abaixo: <br />\n<br />\n{$activateUrl} <br />\n<br />\nObrigado, <br />\n{$siteSignature}'),
(28, 'USER_VALIDATE_SITE', 'en', 'Validate Email (Site)', 'Validate Your Account', '{$recipientName}<br />\n<br />\nYou have created an account with {$siteTitle}, but before you can start using it, you need to validate your email account. To do this, simply follow the link below:<br />\n<br />\n{$activateUrl}<br />\n<br />\nThank you,<br />\n{$siteSignature}'),
(29, 'SUBMISSION_ACK', 'es', 'Confirmación de envío', 'Gracias por su envío a {$serverName}', '<p>Estimado/a {$recipientName}:</p><p>Gracias por su envío a {$serverName}. Hemos recibido su original, {$submissionTitle}, y un miembro de nuestro equipo editorial lo revisará pronto. Le enviaremos un correo electrónico cuando se tome una decisión inicial, y podríamos contactarlo para darle más información.</p></p> Puede ver el envío y seguir su progreso a través del proceso editorial en el enlace siguiente:</p><p>URL del envío: {$authorSubmissionUrl}</p><p>Si se ha cerrado la sesión, puede volver a iniciarla con su nombre de usuario/a {$recipientUsername}.</p><p>Si tiene cualquier duda contacte con nosotros desde el <a href="{$authorSubmissionUrl}">panel de control del envío</a>.</p><p>Gracias por tener en cuenta {$serverName} como hogar para su trabajo.</p>{$serverSignature}'),
(30, 'SUBMISSION_ACK', 'fi', 'Käsikirjoituksen vastaanottaminen', 'Kiitos käsikirjoituksesta - {$serverName}', '<p>Hyvä {$recipientName},</p><p>Kiitos käsikirjoituksen lähettämisestä. Olemme vastaanottaneet käsikirjoituksenne {$submissionTitle}, ja toimituksemme jäsen näkee sen pian. Saatte sähköpostia, kun alustava päätös on tehty, ja saatamme ottaa teihin yhteyttä saadaksemme lisätietoja.</p><p>Voitte seurata käsikirjoituksen etenemistä toimitusprosessissa kirjautumalla verkkosivustollemme:</p><p>Käsikirjoituksen URL: {$authorSubmissionUrl}</p><p>Jos olette kirjautuneet ulos, voitte kirjautua uudelleen käyttäjätunnuksella {$recipientUsername}.</p><p>Jos teillä on kysyttävää, otattehan yhteyttä minuun <a href="{$authorSubmissionUrl}">aloittamalla keskustelun käsikirjoituksenne yhteydessä</a>.</p><p>{$serverName} haluaa kiittää, että valitsitte meidät työnne julkaisuun.</p>{$serverSignature}'),
(31, 'SUBMISSION_ACK', 'fr_CA', 'Confirmation de soumission', 'Accusé de réception de la soumission à {$serverName}', '<p>{$recipientName},</p><p>Nous vous remercions d''avoir soumis le manuscrit intitulé « {$submissionTitle} » à la revue {$serverName}. Nous l''avons bien reçu et un membre de notre équipe éditorial le prendre en charge sous peu. Grâce à notre système de gestion en ligne, vous pourrez suivre votre soumission tout au long du processus d''édition en accédant au site Web de la revue :</p>\n<br />\nURL de la soumission : {$submissionUrl}<br />\nNom d''utilisateur-trice : {$recipientUsername}<br />\n<br />\nSi vous avez des questions, n''hésitez pas à communiquer avec nous. Nous vous remercions d''avoir pensé à notre revue pour la publication de vos travaux.<br />\n<br />\n{$serverSignature}'),
(32, 'SUBMISSION_ACK', 'mk', 'Потврда за поднесување (Во очекување на модерирање)', 'Благодариме за вашиот поднесок во {$serverName}', '<p>Драг {$recipientName},</p><p>Ви благодариме за Вашиот поднесок во{$serverName}.Го добивме Вашиот препринт,{$submissionTitle}, и модераторот ќе го погледне наскоро. Откако модераторот ќе го прегледа Вашиот поднесок, ќе го објави вашиот препринт или ќе Ве контактира.</p><p>Можете да го видите Вашиот поднесок и да го следите неговиот напредок преку уредувачкиот процес на следнава локација:</p><p>Поднесок URL: {$authorSubmissionUrl}</p><p>Ако сте одлогирани,можете повторно да се логирате со Вашето корисничко име{$recipientUsername}.</p><p>Ако имате било какви прашања, Ве молиме контактирајте не преку Вашиот <a href="{$authorSubmissionUrl}">работна табла за поднесоци</a>.</p><p>Ви благодариме за имајќи ја во предвид {$serverName} како место за Вашата работа.</p>{$serverSignature}'),
(33, 'SUBMISSION_ACK', 'nb', 'Bekreftelse på innlevering', 'Vi har mottatt innleveringen din', '{$recipientName}:<br />\n<br />\nTakk for at du har sendt inn «{$submissionTitle}» til {$serverName}. Du kan følge innleveringen gjennom den redaksjonelle prosessen ved å logge deg inn på tidsskriftets nettsted:<br />\n<br />\nInnleveringens URL: {$submissionUrl}<br />\nBrukernavn: {$recipientUsername}<br />\n<br />\nTa kontakt med meg om du har spørsmål. Takk for at du velger tidsskriftet vårt som kanal for å publisere arbeidet ditt.<br />\n<br />\n{$serverSignature}'),
(34, 'SUBMISSION_ACK', 'pt_BR', 'Reconhecimento da Submissão (Moderação Pendente)', 'Obrigado pela sua submissão para {$serverName}', '<p>Prezado(a) {$recipientName},</p><p>obrigado por submeter para {$serverName}. Recebemos seu preprint, {$submissionTitle}, e um moderador a verá em breve. Depois que o moderador revisar sua submissão, ele publicará seu preprint ou entrará em contato com você.</p><p>Você pode visualizar sua submissão e acompanhar seu progresso por meio do processo editorial no seguinte local:</p><p>URL da submisão: {$authorSubmissionUrl}</p><p>Se você foi desconectado, pode fazer login novamente com o nome de usuário {$recipientUsername}.</p><p>Se você tiver alguma dúvida, entre em contato comigo pelo seu <a href="{$authorSubmissionUrl}">painel de submissão</a>.</p><p>Obrigado por considerar {$serverName} como um local para o seu trabalho.</p>{$serverSignature}'),
(35, 'SUBMISSION_ACK', 'en', 'Submission Acknowledgement (Pending Moderation)', 'Thank you for your submission to {$serverName}', '<p>Dear {$recipientName},</p><p>Thank you for your submission to {$serverName}. We have received your preprint, {$submissionTitle}, and a moderator  will see it soon. Once the moderator has reviewed your submission, they will post your preprint or contact you.</p><p>You can view your submission and track its progress through the editorial process at the following location:</p><p>Submission URL: {$authorSubmissionUrl}</p><p>If you have been logged out, you can login again with the username {$recipientUsername}.</p><p>If you have any questions, please contact me from your <a href="{$authorSubmissionUrl}">submission dashboard</a>.</p><p>Thank you for considering {$serverName} as a venue for your work.</p>{$serverSignature}'),
(36, 'POSTED_ACK', 'es', '', '', ''),
(37, 'POSTED_ACK', 'fi', '', '', ''),
(38, 'POSTED_ACK', 'fr_CA', '', '', ''),
(39, 'POSTED_ACK', 'mk', 'Објавено признание', 'Објавено признание од предпечаток', '{$recipientName}: <br />\n<br />\nВашиот препечаток, &quot;{$submissionTitle}&quot; е објавен на Интернет на {$serverName}. <br />\n<br />\nURL на препечатокот: {$submissionUrl}<br />\n<br />\nДоколку имате било какви прашања, Ве молам да ме контактирате.<br />\n<br />\n{$signature}'),
(40, 'POSTED_ACK', 'nb', '', '', ''),
(41, 'POSTED_ACK', 'pt_BR', 'Reconhecimento Postado', 'Aviso de postagem de preprint', '{$recipientName}: <br />\n<br />\nSeu preprint, &quot;{$submissionTitle}&quot; foi publicado online em {$serverName}. <br />\n<br />\nURL do preprint: {$submissionUrl} <br />\n<br />\nSe você tiver alguma dúvida, entre em contato comigo. <br />\n<br />\n{$signature}'),
(42, 'POSTED_ACK', 'en', 'Posted Acknowledgement', 'Preprint Posted Acknowledgement', '{$recipientName}:<br />\n<br />\nYour preprint, &quot;{$submissionTitle}&quot; has been posted online on {$serverName}.<br />\n<br />\nPreprint URL: {$submissionUrl}<br />\n<br />\nIf you have any questions, please contact me.<br />\n<br />\n{$signature}'),
(43, 'POSTED_NEW_VERSION_ACK', 'es', '', '', ''),
(44, 'POSTED_NEW_VERSION_ACK', 'fi', '', '', ''),
(45, 'POSTED_NEW_VERSION_ACK', 'fr_CA', '', '', ''),
(46, 'POSTED_NEW_VERSION_ACK', 'mk', 'Објавена нова верзија', 'Потврда за објавување нова верзија', '<p>Драг {$recipientName},</p><p>Ви благодариме за објавувањето на нова верзија на Вашиот препринт во {$serverName}.Новата верзија сега е<a href="{$submissionPublishedUrl}">достапна</a>.</p><p>Ако имате било какви прашања, Ве молиме контактирајте не.</p>{$signature}'),
(47, 'POSTED_NEW_VERSION_ACK', 'nb', '', '', ''),
(48, 'POSTED_NEW_VERSION_ACK', 'pt_BR', 'Nova Versão Postada', 'Notificação de Nova Versão Postada', '<p>Prezado(a) {$recipientName},</p><p>Obrigado por postar uma nova versão de seu preprint em {$serverName}. A nova versão agora está <a href="{$submissionPublishedUrl}">disponível</a>.</p><p>Se você tiver alguma dúvida, entre em contato comigo.</p>{$signature}'),
(49, 'POSTED_NEW_VERSION_ACK', 'en', 'New Version Posted', 'New Version Posted Acknowledgement', '<p>Dear {$recipientName},</p><p>Thank you for posting a new version of your preprint to {$serverName}. The new version is now <a href="{$submissionPublishedUrl}">available</a>.</p><p>If you have any questions, please contact me.</p>{$signature}'),
(50, 'SUBMISSION_ACK_CAN_POST', 'es', '', 'Gracias por su envío a {$serverName}', ''),
(51, 'SUBMISSION_ACK_CAN_POST', 'fi', '', 'Kiitos käsikirjoituksesta - {$serverName}', ''),
(52, 'SUBMISSION_ACK_CAN_POST', 'fr_CA', '', 'Accusé de réception de la soumission à {$serverName}', ''),
(53, 'SUBMISSION_ACK_CAN_POST', 'mk', 'Потврда за поднесување (не е потребна модерација)', 'Благодариме за вашиот поднесок во {$serverName}', '<p>Драг {$recipientName},</p><p>Ви благодариме за Вашиот поднесок во {$serverName}. Ова е автоматска порака со која Ве информираме дека го добивме Вашиот препринт {$submissionTitle}. Како доверлив автор, не се потребни мерки на претпазливост, Ве покануваме да <a href="{$authorSubmissionUrl}">го објавите Вашиот препринт</a>штом ќе бидете подготвени. </p><p>Ако се одлогиравте, можете повторно да се логирате со Вашето корисничко име{$recipientUsername}.</p><p>Ви благодариме имајќи го во предвид {$serverName} како место за Вашата работа.</p>{$serverSignature}'),
(54, 'SUBMISSION_ACK_CAN_POST', 'nb', '', 'Vi har mottatt innleveringen din', ''),
(55, 'SUBMISSION_ACK_CAN_POST', 'pt_BR', 'Reconhecimento de Submissão (Sem Moderação Necessária)', 'Obrigado pela sua submissão para {$serverName}', '<p>Prezado(a) {$recipientName},</p><p>Você foi nomeado(a) coautor(a) de um preprint enviado para {$serverName}. O remetente, {$submitterName}, forneceu os seguintes detalhes:</p><p>{$submissionTitle}<br>{$authorsWithAffiliation}</p><p>Se algum desses detalhes estiver incorreto ou você não deseja ser nomeado nesta submissão, por favor contacte-me.</p><p>Obrigado por considerar este servidor como um local para o seu trabalho.</p><p>Atenciosamente,</p>{$serverSignature}'),
(56, 'SUBMISSION_ACK_CAN_POST', 'en', 'Submission Acknowledgement (No Moderation Required)', 'Thank you for your submission to {$serverName}', '<p>Dear {$recipientName},</p><p>Thank you for your submission to {$serverName}. This is an automated message to let you know that we have received your preprint, {$submissionTitle}. As a trusted author, no moderation is required, so we invite you to <a href="{$authorSubmissionUrl}">post your preprint</a> as soon as you are ready.</p><p>If you have been logged out, you can login again with the username {$recipientUsername}.</p><p>Thank you for considering {$serverName} as a venue for your work.</p>{$serverSignature}'),
(57, 'SUBMISSION_ACK_NOT_USER', 'es', 'Confirmación del envío (otros autores/as)', 'Acuse de recibo del envío', 'Hola,<br />\n<br />\n{$submitterName} ha enviado el manuscrito &quot;{$submissionTitle}&quot; a {$serverName}. <br />\n<br />\nSi tiene cualquier pregunta no dude en contactarme. Le agradecemos que haya elegido esta revista para dar a conocer su obra.<br />\n<br />\n{$serverSignature}'),
(58, 'SUBMISSION_ACK_NOT_USER', 'fi', 'Käsikirjoituksen vastaanottaminen (muut kirjoittajat)', 'Käsikirjoituksesi on vastaanotettu', 'Hei,<br />\n<br />\n{$submitterName} on lähettänyt julkaisuumme {$serverName} käsikirjoituksen &quot;{$submissionTitle}&quot;.<br />\n<br />\nJos teillä on kysyttävää, otattehan yhteyttä minuun. Kiitos, että valitsitte tämän julkaisun työllenne.<br />\n<br />\n{$serverSignature}'),
(59, 'SUBMISSION_ACK_NOT_USER', 'fr_CA', 'Confirmation de soumission (autres auteur-es)', 'Accusé de réception de la soumission', 'Bonjour,<br />\n<br />\nLe manuscrit intitulé , « {$submissionTitle} » , a été soumis par {$submitterName} à {$serverName}.<br />\n<br />\nSi vous avez des questions, n''hésitez pas à communiquer avec nous. Nous vous remercions d''avoir pensé à {$serverName} pour la publication de vos travaux.<br />\n<br />\n{$serverSignature}'),
(60, 'SUBMISSION_ACK_NOT_USER', 'mk', 'Потврда за поднесување (Други автори)', 'Потврда за поднесување', '<p>Драг {$recipientName},</p><p>Вие сте назначени како ко-автор на препринтот поднесен во {$serverName}. Поднесувачот,{$submitterName}, ги обезбеди следниве податоци:</p><p>{$submissionTitle}<br>{$authorsWithAffiliation}</p><p>Ако било кој од овие податоци се неточни, или не би сакале да бидат во овој препринт, Ве молиме контактирајте ме.</p><p>Ви благодариме што го имате во предвид овој сервер како место за Вашата работа.</p><p>Топли поздрави,</p>{$serverSignature}'),
(61, 'SUBMISSION_ACK_NOT_USER', 'nb', '', 'Bekreftelse på innlevering', '<p>Kjære {$recipientName}</p><p>Du er angitt som medforfatter på et manuskript innsendt til {$serverName}. Innsenderen, {$submitterName}, har oppgitt følgende information:</p><p>{$submissionTitle}<br>{$authorsWithAffiliation}</p><p>Hvis noen av disse opplysningene er feil, eller du ikke ønsker å være angitt som medforfatter på dette manuskript, vær vennlig å kontakte mig.</p><p>Takk for at du vurderer dette tidsskrift til for arbeidet ditt.</p><p>Med vennlig hilsen</p>{$serverSignature}'),
(62, 'SUBMISSION_ACK_NOT_USER', 'pt_BR', 'Confirmação de Submissão (Outros Autores)', 'Confirmação da submissão', 'Olá, <br/>\n<br/>\n{$submitterName} submeteu o manuscrito, &quot;{$submissionTitle}&quot; para {$serverName}. <br />\n<br />\nEm caso de dúvida, entre em contato comigo. Obrigado por considerar este servidor como local de envio de sua pesquisa.<br />\n<br />\n{$serverSignature}'),
(63, 'SUBMISSION_ACK_NOT_USER', 'en', 'Submission Confirmation (Other Authors)', 'Submission Acknowledgement', '<p>Dear {$recipientName},</p><p>You have been named as a co-author on a preprint submitted to {$serverName}. The submitter, {$submitterName}, provided the following details:</p><p>{$submissionTitle}<br>{$authorsWithAffiliation}</p><p>If any of these details are incorrect, or you do not wish to be named on this preprint, please contact me.</p><p>Thank you for considering this server as a venue for your work.</p><p>Kind regards,</p>{$serverSignature}'),
(64, 'EDITOR_ASSIGN', 'es', 'Editor/a asignado', '', ''),
(65, 'EDITOR_ASSIGN', 'fi', 'Toimittaja osoitettu', '', ''),
(66, 'EDITOR_ASSIGN', 'fr_CA', 'Rédacteur-trice assigné', '', ''),
(67, 'EDITOR_ASSIGN', 'mk', 'Доделен уредник', 'Доделување модератор', '<p>Драг{$recipientName},</p><p>Следниов препринт ви е доделен Вам да го проследите низ процесот на проверка во вашата улога како модератор.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Абстракт</b></p>{$submissionAbstract}<p>Ве молиме логирајте се во <a href="{$submissionUrl}">погледнете го препринтот</a>. Користете го Одделот за дискусии за да го контактирате авторот доколку имате било какви прашања.Ве молиме објавете го препринтот кога ќе сметате дека ги исполнува сите барања.</p><p>Ви благодариме однапред.</p><p>Топли поздрави,</p>{$serverSignature}'),
(68, 'EDITOR_ASSIGN', 'nb', '', '', ''),
(69, 'EDITOR_ASSIGN', 'pt_BR', 'Editor Atribuído', 'Atribuição de moderador', '{$recipientName}:<br />\n<br />\nA submissão, &quot;{$submissionTitle},&quot; a {$serverName} foi atribuídod a você para acompanhar o fluxo editorial, conforme sua função de moderador.<br />\n<br />\nSubmission URL: {$submissionUrl}<br />\nNome de usuário: {$recipientUsername}<br />\n<br />\nObrigado.'),
(70, 'EDITOR_ASSIGN', 'en', 'Editor Assigned', 'You have been assigned as a moderator on a submission to {$serverName}', '<p>Dear {$recipientName},</p><p>The following preprint has been assigned to you to see through the screening process in your role as Moderator.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Please login to <a href="{$submissionUrl}">view the preprint</a>. Use the Discussions section to contact the author if you have any questions. Please post the preprint once you are satisfied that it meets all requirements.</p><p>Thank you in advance.</p><p>Kind regards,</p>{$serverSignature}'),
(71, 'EDITOR_DECISION_ACCEPT', 'es', 'Envío aceptado', '', ''),
(72, 'EDITOR_DECISION_ACCEPT', 'fi', 'Käsikirjoitus hyväksytty', '', ''),
(73, 'EDITOR_DECISION_ACCEPT', 'fr_CA', 'Soumission acceptée', '', ''),
(74, 'EDITOR_DECISION_ACCEPT', 'mk', 'Поднесокот е прифатен', 'Одлука на модераторот', '<p>Драг {$recipientName},</p><p>Радосни сме да Ве информираме дека модераторот одлучи да го прифати Вашиот поднесок во{$serverName}. Вашиот поднесок, {$submissionTitle}, ги исполнува сите барања за предпечатење објавени во{$serverName} и Ви благодариме што го одбравте нашиот сервер како место за Вашата работа.</p><p>За било какви прашања, Ве молиме контактирајте ме од Вашиот<a href="{$authorSubmissionUrl}">работна табла за поднесоци</a>.</p><p>Топли поздрави,</p>{$signature}'),
(75, 'EDITOR_DECISION_ACCEPT', 'nb', '', '', ''),
(76, 'EDITOR_DECISION_ACCEPT', 'pt_BR', 'Submissão Aceita', 'Decisão do moderador', '{$authors}:<br />\n<br />\nNós tomamos uma decisão no que diz respeito a sua submissão {$serverName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nNossa decisão é: Aceitar a Submissão'),
(77, 'EDITOR_DECISION_ACCEPT', 'en', 'Submission Accepted', 'Your submission has passed moderation at {$serverName}', '<p>Dear {$recipientName},</p><p>I am pleased to inform you that a moderator has decided to accept your preprint at {$serverName}. We found your submission, {$submissionTitle}, to meet the requirements for preprints posted to {$serverName} and thank you for choosing our server as a venue for your work.</p><p>If you have any questions, please contact me from your <a href="{$authorSubmissionUrl}">submission dashboard</a>.</p><p>Kind regards,</p>{$signature}'),
(78, 'EDITOR_DECISION_INITIAL_DECLINE', 'es', 'Envío rechazado (antes de revisión)', 'Su envío ha sido rechazado', '<p>Estimado/a {$recipientName},</p><p>Lamento informarlo de que, tras la revisión de su artículo, {$submissionTitle}, el editor/a ha considerado que no cumple los requisitos de publicación en {$serverName}.</p><p>Le deseo mucha suerte si decide enviarlo a otro sitio.</p><p>Saludos cordiales,</p>{$signature}'),
(79, 'EDITOR_DECISION_INITIAL_DECLINE', 'fi', 'Käsikirjoitus hylätty (ennen arviointia)', 'Toimittajan päätös', '\n			Hyvä {$authors},<br />\n<br />\nOlemme tehneet päätöksen julkaisuun {$serverName} lähettämäänne käsikirjoitusta &quot;{$submissionTitle}&quot; koskien.<br />\n<br />\nPäätöksemme on: Käsikirjoitus on hylätty'),
(80, 'EDITOR_DECISION_INITIAL_DECLINE', 'fr_CA', 'Soumission refusée avant évaluation', 'Décision du rédacteur', '<p>{$recipientName},</p><p>Nous avons le regret de vous informer qu''après avoir évaluer votre manuscrit, {$submissionTitle}, le-la rédacteur-trice en a conclue qu''il ne rencontre pas les exigences nécessaires pour être publier dans {$serverName}.</p><p>Cordialement,</p>{$signature}'),
(81, 'EDITOR_DECISION_INITIAL_DECLINE', 'mk', 'Подесокот е одбиен', 'Вашиот поднесок е одбиен', '<p>Почитуван {$recipientName},</p><p>Жал ми е што ве информирам дека, по прегледот на вашиот поднесок, {$submissionTitle}, уредникот откри дека не ги исполнува нашите барања за објавување во { $contextName}.</p><p>Ви посакувам успех ако размислувате да ја испратите вашата работа на друго место.</p><p>Со почит,</p>{$signature}'),
(82, 'EDITOR_DECISION_INITIAL_DECLINE', 'nb', '', 'Redaktørens beslutning', '\n			{$authors}:<br />\n<br />\nVi har tatt en beslutning angående innleveringen din, «{$submissionTitle}», som du sendte inn til {$serverName}.<br />\n<br />\nVår beslutning er: Manuskriptet avvises'),
(83, 'EDITOR_DECISION_INITIAL_DECLINE', 'pt_BR', 'Submissão recusada', 'Sua submissão foi recusada', '<p>Prezado(a) {$recipientName},</p><p>Lamento informar que, após analisar sua submissão, {$submissionTitle}, o editor descobriu que ela não atende aos nossos requisitos para publicação em {$serverName}.</p><p>Desejo sucesso se você considerar enviar seu trabalho para outro lugar.</p><p>Atenciosamente,</p>{$signature}'),
(84, 'EDITOR_DECISION_INITIAL_DECLINE', 'en', 'Submission Declined', 'Your submission has been declined', '<p>Dear {$recipientName},</p><p>I’m sorry to inform you that, after reviewing your submission, {$submissionTitle}, the editor has found that it does not meet our requirements for publication in {$serverName}.</p><p>I wish you success if you consider submitting your work elsewhere.</p><p>Kind regards,</p>{$signature}'),
(85, 'EDITOR_DECISION_REVERT_INITIAL_DECLINE', 'es', 'Restaurar el envío rechazado sin revisión', 'Hemos revertido la decisión de rechazar su envío', '<p>Estimado/a {$recipientName},</p>\n<p>La decisión de rechazar su envío, {$submissionTitle}, se ha revertido. \nUn editor/a estudiará su propuesta antes de decidir si la rechaza \no la envía a revisión.</p>\n<p>A veces se registra accidentalmente en nuestro sistema la decisión de rechazar un envío\ny esta acción debe ser revertida. Le pedimos disculpas por la confusión que esto le haya podido causar.</p>\n<p>Nos pondremos en contacto con usted si necesitamos más ayuda.</p>\n<p>Si tiene cualquier pregunta puede contactarnos desde el <a href="{$authorSubmissionUrl}">panel de control del envío</a>.</p>\n<p>Saludos cordiales,</p>\n<p>{$signature}</p>\n'),
(86, 'EDITOR_DECISION_REVERT_INITIAL_DECLINE', 'fi', 'Palauta ennen arviointia hylätty käsikirjoitus', '', ''),
(87, 'EDITOR_DECISION_REVERT_INITIAL_DECLINE', 'fr_CA', 'Rétablir une soumission refusée sans évaluation', 'Nous avons renversé la décision de rejeter votre soumission', '<p>{$recipientName},</p>\n<p>La décision de rejeter votre soumission, {$submissionTitle}, a été renversée. Un-e modérateur-trice évaluera votre soumission dans les détails afin de décider si votre soumission sera rejetée ou pourra être envoyée en évaluation.</p>\n<p>Si vous avez des questions, vous pouvez nous contacter sur votre <a href="{$authorSubmissionUrl}">tableau de bord de soumissions</a>.</p>\n<p>Cordialement,</p>\n<p>{$signature}</p>\n'),
(88, 'EDITOR_DECISION_REVERT_INITIAL_DECLINE', 'mk', 'Враќање по одбивањето на поднесокот без рецензија', 'Ја сменивме одлуката да го одбиеме вашето поднесување', '<p>Драг {$recipientName},</p>\n<p>Одлуката да се одбие Вашиот поднесок, {$submissionTitle}, е поништена. \nМодераторот ќе го разгледа вашиот поднесок пред да одлучи дали да го одбие\n или објави поднесокот.</p>\n<p>Понекогаш, одлуката да се одбие поднесокот ќе биде забележана случајно во\n нашиот систем и мора да биде поништена. Се извинуваме за било каква забуна.</p>\n<p>Ќе Ве контактираме ако има потреба од било каква натамошна помош.</p>\n<p>Ако имате било какви прашања, Ве молиме контактирајте ме од Вашиот <a href="{$authorSubmissionUrl}">работна табла за поднесоци</a>.</p>\n<p>Топли поздрави,</p>\n<p>{$signature}</p>\n'),
(89, 'EDITOR_DECISION_REVERT_INITIAL_DECLINE', 'nb', '', '', '<p>Kjære {$recipientName},</p> \n<p>Beslutningen om å avvise din innlevering, {$submissionTitle}, har blitt omgjort. En redaktør vil se nærmere på din innlevering før han eller hun bestemmer om innleveringen skal avslås eller sendes til fagfellevurdering.</p> \n<p>Av og til blir en beslutning om å avslå en innlevering registrert ved en feil i vårt system og må rettes opp. Jeg beklager for eventuell forvirring dette kan ha forårsaket.</p> \n<p>Vi vil kontakte deg hvis vi trenger ytterligere assistanse.</p> \n<p>Hvis du har noen spørsmål, vennligst kontakt meg via <a href="{$authorSubmissionUrl}">innleveringsdashboardet</a>.</p>\n<p>Med vennlig hilsen,</p>\n<p>{$signature}</p>\n'),
(90, 'EDITOR_DECISION_REVERT_INITIAL_DECLINE', 'pt_BR', 'Reintegrar submissão recusada sem Avaliação', 'Revertemos a decisão de rejeitar sua submissão', '<p>Prezado(a) {$recipientName},</p>\n<p>A decisão de recusar sua submissão, {$submissionTitle}, foi revertida.\nUm moderador examinará mais detalhadamente sua submissão antes de decidir se deve recusar\nou postar a submissão.</p>\n<p>Ocasionalmente, uma decisão de recusar uma submissão será acidentalmente registrada em\nnosso sistema e deve ser revertida. Peço desculpas por qualquer confusão que isso possa ter causado.</p>\n<p>Entraremos em contato se precisarmos de mais assistência.</p>\n<p>Se você tiver alguma dúvida, entre em contato comigo em seu <a href="{$authorSubmissionUrl}">painel de submissão</a>.</p>\n<p>Atenciosamente,</p>\n<p>{$assinatura}</p>\n'),
(91, 'EDITOR_DECISION_REVERT_INITIAL_DECLINE', 'en', 'Reinstate Submission Declined Without Review', 'We have reversed the decision to decline your submission', '<p>Dear {$recipientName},</p>\n<p>The decision to decline your submission, {$submissionTitle}, has been reversed. \nA moderator will look further at your submission before deciding whether to decline \nor post the submission.</p>\n<p>Occasionally, a decision to decline a submission will be recorded accidentally in \nour system and must be reverted. I apologize for any confusion this may have caused.</p>\n<p>We will contact you if we need any further assistance.</p>\n<p>If you have any questions, please contact me from your <a href="{$authorSubmissionUrl}">submission dashboard</a>.</p>\n<p>Kind regards,</p>\n<p>{$signature}</p>\n'),
(92, 'EDITOR_DECISION_NOTIFY_OTHER_AUTHORS', 'es', 'Notificar a los otros autores/as', 'Actualización acerca de su envío', '<p>El siguiente correo electrónico fue enviado a {$submittingAuthorName} desde {$serverName} en relación con {$submissionTitle}.</p>\n<p>El motivo por el que recibe una copia de esta notificación es porque está identificado como autor/a de este envío. Las instrucciones que figuran en el siguiente mensaje se dirigen al autor/a principal del envío, {$submittingAuthorName}, por lo que no se requiere ninguna acción suya en este momento.</p>\n\n{$messageToSubmittingAuthor}'),
(93, 'EDITOR_DECISION_NOTIFY_OTHER_AUTHORS', 'fi', 'Ilmoita muille kirjoittajille', '', ''),
(94, 'EDITOR_DECISION_NOTIFY_OTHER_AUTHORS', 'fr_CA', 'Envoyer une notification aux autres auteur-es', 'Mise à jour concernant votre soumission', '<p>Ce courriel a été envoyé à {$submittingAuthorName} par {$serverName} concernant {$submissionTitle}.</p>\n<p>Vous recevez une copie de cet avis car vous êtes identifié comme auteur-e de cette soumission. Toutes les instructions dans le message ci-dessous sont à l''intention de l''auteur-e de correspondance, {$submittingAuthorName}. </p><p>Aucune action n''est attendue de votre part.</p>\n\n{$messageToSubmittingAuthor}'),
(95, 'EDITOR_DECISION_NOTIFY_OTHER_AUTHORS', 'mk', 'Известете ги другите автори', 'Обновување на вашиот поднесок', '<p>Следната е-пошта е испратена до {$submittingAuthorName} од {$serverName} во врска со {$submissionTitle}.</p>\n<p>Добивате копија од ова известување бидејќи сте идентификувани како автор на поднесокот. Сите инструкции во пораката подолу се наменети за авторот што поднесува, {$submittingAuthorName}, и во моментов не се бара никаква акција од вас.</p>\n\n{$messageToSubmittingAuthor}'),
(96, 'EDITOR_DECISION_NOTIFY_OTHER_AUTHORS', 'nb', '', 'En oppdatering angående din innlevering', '<p>Følgende e-post ble sendt til {$submittingAuthorName} fra {$journalName} angående {$submissionTitle}.</p>\n<p>Du mottar en kopi fordi du er blitt oppgitt som forfatter av denne innleveringen. Instruksjonene i e-posten er tiltenkt korresponderende forfatter, {$submittingAuthorName}, og du trenger ikke foreta deg noe på nåværende tidspunkt.</p>\n\n{$messageToSubmittingAuthor}'),
(97, 'EDITOR_DECISION_NOTIFY_OTHER_AUTHORS', 'pt_BR', 'Notificar outros autores', 'Uma atualização sobre sua submissão', '<p>O seguinte e-mail foi enviado para {$submitingAuthorName} de {$serverName} sobre {$submissionTitle}.</p>\n<p>Você está recebendo uma cópia desta notificação porque foi identificado como autor da submissão. Todas as instruções na mensagem abaixo são destinadas ao autor responsável pela submissão, {$subposingAuthorName}, e nenhuma ação é necessária de sua parte neste momento.</p>\n\n{$messageToSubmitatingAutor}'),
(98, 'EDITOR_DECISION_NOTIFY_OTHER_AUTHORS', 'en', 'Notify Other Authors', 'An update regarding your submission', '<p>The following email was sent to {$submittingAuthorName} from {$serverName} regarding {$submissionTitle}.</p>\n<p>You are receiving a copy of this notification because you are identified as an author of the submission. Any instructions in the message below are intended for the submitting author, {$submittingAuthorName}, and no action is required of you at this time.</p>\n\n{$messageToSubmittingAuthor}'),
(99, 'STATISTICS_REPORT_NOTIFICATION', 'es', 'Notificación de informe de estadísticas', '', ''),
(100, 'STATISTICS_REPORT_NOTIFICATION', 'fi', 'Ilmoitus toimitustyötä koskevasta raportista', '', ''),
(101, 'STATISTICS_REPORT_NOTIFICATION', 'fr_CA', 'Notification sur les rapports statistiques', '', ''),
(102, 'STATISTICS_REPORT_NOTIFICATION', 'mk', 'Известување за извештај за статистика', 'Активност на серверот на отпечатоци за {$month}, {$year}', '\n{$recipientName}, <br />\n<br />\nВашиот здравствен извештај за отпечатоци за {$month}, {$year} е достапен сега. Вашите клучни статистички податоци за овој месец се подолу.<br />\n<ul>\n	<li>Нови поднесоци овој месец: {$newSubmissions}</li>\n	<li>Одбиени поднесоци овој месец: {$declinedSubmissions}</li>\n	<li>Прифатени поднесоци овој месец: {$acceptedSubmissions}</li>\n	<li>Вкупно поднесоци на системот: {$totalSubmissions}</li>\n</ul>\nНајавете се на серверот со отпечатоци за да ги прегледате подеталните <a href="{$editorialStatsLink}">трендови</a> и <a href="{$publicationStatsLink}">објавените статистички податоци за отпечатоците</a>. Прикачена е целосна копија на трендовите за овој месец.<br />\n<br />\nСрдечен поздрав,<br />\n{$serverSignature}'),
(103, 'STATISTICS_REPORT_NOTIFICATION', 'nb', '', '', ''),
(104, 'STATISTICS_REPORT_NOTIFICATION', 'pt_BR', 'Notificação do Relatório de Estatísticas', 'Atividade do servidor de pré-impressão para {$mês}, {$ano}', '\n{$recipientName}, <br />\n<br />\nSeu relatório de saúde pré-impresso para {$month}, {$year} está disponível agora. Sua chave de estatística para este mês estão abaixo.<br />\n<ul>\n	<li>Novas inscrições este mês: {$newSubmissions}</li>\n	<li>Inscrições recusadas este mês: {$declinedSubmissions}</li>\n	<li>Inscrições aceitas este mês: {$acceptedSubmissions}</li>\n	<li>Total de inscrições no sistema: {$totalSubmissions}</li>\n</ul>\nFaça login no servidor de pré-impressão para ver mais detalhes <a href="{$editorialStatsLink}">trends</a> and <a href="{$publicationStatsLink}">estatística de pré-impressões postadas</a>. Uma cópia completa  das maiores tendências deste mês está em anexo.<br />\n<br />\nSinceramente,<br />\n{$serverSignature}'),
(105, 'STATISTICS_REPORT_NOTIFICATION', 'en', 'Statistics Report Notification', 'Preprint Server activity for {$month}, {$year}', '\n{$recipientName}, <br />\n<br />\nYour preprint health report for {$month}, {$year} is now available. Your key stats for this month are below.<br />\n<ul>\n	<li>New submissions this month: {$newSubmissions}</li>\n	<li>Declined submissions this month: {$declinedSubmissions}</li>\n	<li>Accepted submissions this month: {$acceptedSubmissions}</li>\n	<li>Total submissions in the system: {$totalSubmissions}</li>\n</ul>\nLogin to the the preprint server to view more detailed <a href="{$editorialStatsLink}">trends</a> and <a href="{$publicationStatsLink}">posted preprint stats</a>. A full copy of this month''s trends is attached.<br />\n<br />\nSincerely,<br />\n{$serverSignature}'),
(106, 'ANNOUNCEMENT', 'es', 'Nuevo aviso', '', ''),
(107, 'ANNOUNCEMENT', 'fi', 'Uusi julkinen ilmoitus', '', ''),
(108, 'ANNOUNCEMENT', 'fr_CA', 'Nouvelle annonce', '', ''),
(109, 'ANNOUNCEMENT', 'mk', 'Ново соопштение', '{$announcementTitle}', '<b>{$announcementTitle}</b><br />\n<br />\n{$announcementSummary}<br />\n<br />\nПосетете ја нашата веб-страна за да го прочитате <a href="{$announcementUrl}">целосното известување</a>.'),
(110, 'ANNOUNCEMENT', 'nb', '', '', ''),
(111, 'ANNOUNCEMENT', 'pt_BR', 'Novo Comunicado', '{$announcementTitle}', '<b>{$announcementTitle}</b><br />\n<br />\n{$announcementSummary}<br />\n<br />\nVisite nosso site para ler o <a href="{$announcementUrl}">anúncio completo</a>.'),
(112, 'ANNOUNCEMENT', 'en', 'New Announcement', '{$announcementTitle}', '<b>{$announcementTitle}</b><br />\n<br />\n{$announcementSummary}<br />\n<br />\nVisit our website to read the <a href="{$announcementUrl}">full announcement</a>.'),
(113, 'DISCUSSION_NOTIFICATION_PRODUCTION', 'es', 'Discusión (producción)', 'Mensaje sobre {$serverName}', 'Introduzca su mensaje.'),
(114, 'DISCUSSION_NOTIFICATION_PRODUCTION', 'fi', 'Keskustelu (tuotanto)', 'Viesti julkaisua {$serverName} koskien', 'Kirjoita viesti.'),
(115, 'DISCUSSION_NOTIFICATION_PRODUCTION', 'fr_CA', 'Discussion (production)', 'Un message à propos de la revue {$serverName}', 'Prière de saisir votre message.'),
(116, 'DISCUSSION_NOTIFICATION_PRODUCTION', 'mk', 'Дискусија (Обработка)', 'Порака во врска со {$serverName}', 'Ве молиме внесете ја вашата порака.'),
(117, 'DISCUSSION_NOTIFICATION_PRODUCTION', 'nb', '', 'En beskjed angående {$serverName}', 'Skriv inn beskjeden din her.'),
(118, 'DISCUSSION_NOTIFICATION_PRODUCTION', 'pt_BR', 'Discussão da Editoração', 'Uma mensagem sobre {$serverName}', 'Insira a sua mensagem por gentileza.'),
(119, 'DISCUSSION_NOTIFICATION_PRODUCTION', 'en', 'Discussion (Production)', 'A message regarding {$serverName}', 'Please enter your message.'),
(120, 'EDITOR_ASSIGN_PRODUCTION', 'es', 'Editor/a asignado', '', ''),
(121, 'EDITOR_ASSIGN_PRODUCTION', 'fi', 'Toimittaja osoitettu', '', ''),
(122, 'EDITOR_ASSIGN_PRODUCTION', 'fr_CA', 'Rédacteur-trice assigné', '', ''),
(123, 'EDITOR_ASSIGN_PRODUCTION', 'mk', 'Доделен уредник', 'Доделување модератор', '<p>Драг{$recipientName},</p><p>Следниов препринт ви е доделен Вам да го проследите низ процесот на проверка во вашата улога како модератор.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Абстракт</b></p>{$submissionAbstract}<p>Ве молиме логирајте се во <a href="{$submissionUrl}">погледнете го препринтот</a>. Користете го Одделот за дискусии за да го контактирате авторот доколку имате било какви прашања.Ве молиме објавете го препринтот кога ќе сметате дека ги исполнува сите барања.</p><p>Ви благодариме однапред.</p><p>Топли поздрави,</p>{$serverSignature}'),
(124, 'EDITOR_ASSIGN_PRODUCTION', 'nb', '', '', ''),
(125, 'EDITOR_ASSIGN_PRODUCTION', 'pt_BR', 'Editor Atribuído', 'Atribuição de moderador', '{$recipientName}:<br />\n<br />\nA submissão, &quot;{$submissionTitle},&quot; a {$serverName} foi atribuídod a você para acompanhar o fluxo editorial, conforme sua função de moderador.<br />\n<br />\nSubmission URL: {$submissionUrl}<br />\nNome de usuário: {$recipientUsername}<br />\n<br />\nObrigado.'),
(126, 'EDITOR_ASSIGN_PRODUCTION', 'en', 'Editor Assigned', 'You have been assigned as a moderator on a submission to {$serverName}', '<p>Dear {$recipientName},</p><p>The following preprint has been assigned to you to see through the screening process in your role as Moderator.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Please login to <a href="{$submissionUrl}">view the preprint</a>. Use the Discussions section to contact the author if you have any questions. Please post the preprint once you are satisfied that it meets all requirements.</p><p>Thank you in advance.</p><p>Kind regards,</p>{$serverSignature}'),
(127, 'VERSION_CREATED', 'es', 'Versión creada', 'Se ha creado una versión nueva de {$submissionTitle}', '');
INSERT INTO `email_templates_default_data` VALUES
(128, 'VERSION_CREATED', 'fi', 'Uusi versio luotu', '', ''),
(129, 'VERSION_CREATED', 'fr_CA', 'Version créée', 'Une nouvelle version a été créée pour {$submissionTitle}', '<p>{$recipientName}, </p><p>Ceci est un courriel automatique de <a href="{$serverUrl}">{$serverName}</a> pour vous informer qu''une nouvelle version de votre soumission, {$submissionTitle}, a été créée. Vous pouvez consulter cette version à partir de votre tableau de bord de soumission:</p><p><a href="{$submissionUrl}">{$submissionTitle}</a></p><hr>'),
(130, 'VERSION_CREATED', 'mk', 'Создадена верзија', 'Креирана е нова верзија за {$submissionTitle}', '<p>Почитуван {$recipientName}, </p><p>Ова е автоматизирана порака за да ве информира дека е создадена нова верзија на вашиот поднесок, {$submissionTitle}. Оваа верзија може да ја погледнете од контролната табла за поднесување на следната врска:</p><p><a href="{$submissionUrl}">{$submissionTitle}</a></p><hr><p> Ова е автоматска е-пошта испратена од <a href="{$serverUrl}">{$serverName}</a>.</p>'),
(131, 'VERSION_CREATED', 'nb', '', 'En ny versjon ble opprettet for {$submissionTitle}', '<p>{$recipientName},</p><p>Dette er en automatisk melding for å informere deg om at en ny versjon av din innlevering, {$submissionTitle}, ble opprettet. Du kan se denne versjonen fra ditt innleveringsdashboard på følgende lenke:</p><p><a href="{$submissionUrl}">{$submissionTitle}</a></p><hr><p>Dette er en automatisk e-post sendt fra <a href="{$serverUrl}">{$serverName}</a>.</p>'),
(132, 'VERSION_CREATED', 'pt_BR', 'Versão Criada', 'Uma nova versão foi criada para {$submissionTitle}', '<p>Prezado(a) {$recipientName}, </p><p>Esta é uma mensagem automática para informar que uma nova versão da sua submissão, {$submissionTitle}, foi criada. Você pode visualizar esta versão no painel da submissão no seguinte link:</p><p><a href="{$submissionUrl}">{$submissionTitle}</a></p><hr><p> Este é um e-mail automático enviado de <a href="{$serverUrl}">{$serverName}</a>.</p>'),
(133, 'VERSION_CREATED', 'en', 'Version Created', 'A new version was created for {$submissionTitle}', '<p>Dear {$recipientName}, </p><p>This is an automated message to inform you that a new version of your submission, {$submissionTitle}, was created. You can view this version from your submission dashboard at the following link:</p><p><a href="{$submissionUrl}">{$submissionTitle}</a></p><hr><p>This is an automatic email sent from <a href="{$serverUrl}">{$serverName}</a>.</p>'),
(134, 'SUBMISSION_SAVED_FOR_LATER', 'es', 'Se guardó el envío para más adelante', 'Continuar su envío a {$serverName}', ''),
(135, 'SUBMISSION_SAVED_FOR_LATER', 'fi', 'Käsikirjoitus tallennettu myöhempää täydentämistä varten', '', ''),
(136, 'SUBMISSION_SAVED_FOR_LATER', 'fr_CA', 'Soumission incomplète sauvegardée', 'Reprendre votre soumission à {$serverName}', '<p>{$recipientName},</p><p>Les détails de votre soumission ont été enregistrés, mais vous ne l''avez pas encore finalisée. Vous pouvez le faire en cliquant sur le lien ci-dessous: </p><p><a href="{$submissionWizardUrl}">{$authorsShort} — {$submissionTitle}</a></p><hr><p>Ceci est un message automatique de <a href="{$serverUrl}">{$serverName}</a>.</p>'),
(137, 'SUBMISSION_SAVED_FOR_LATER', 'mk', 'Поднесокот е зачуван за подоцна', 'Продолжи со поднесување на {$serverName}', '<p>Почитуван {$recipientName},</p><p>Деталите за вашето поднесување се зачувани во нашиот систем, но сè уште не е поднесен на разгледување. Може да се вратите за да го комплетирате вашето поднесување во секое време, следејќи ја врската подолу.</p><p><a href="{$submissionWizardUrl}">{$authorsShort} — {$submissionTitle}</a></p ><hr><p>Ова е автоматизирана е-пошта од <a href="{$serverUrl}">{$serverName}</a>.</p>'),
(138, 'SUBMISSION_SAVED_FOR_LATER', 'nb', '', '', ''),
(139, 'SUBMISSION_SAVED_FOR_LATER', 'pt_BR', 'Submissão salva para mais tarde', 'Retome sua submissão para {$serverName}', '<p>Prezado(a) {$recipientName},</p><p>Os detalhes da sua submissão foram salvos em nosso sistema, mas ainda não foram submetidos para consideração. Você pode retornar para concluir sua submissão a qualquer momento seguindo o link abaixo.</p><p><a href="{$submissionWizardUrl}">{$authorsShort} — {$submissionTitle}</a></p ><hr><p>Este é um e-mail automático de <a href="{$serverUrl}">{$serverName}</a>.</p>'),
(140, 'SUBMISSION_SAVED_FOR_LATER', 'en', 'Submission Saved for Later', 'Resume your submission to {$serverName}', '<p>Dear {$recipientName},</p><p>Your submission details have been saved in our system, but it has not yet been submitted for consideration. You can return to complete your submission at any time by following the link below.</p><p><a href="{$submissionWizardUrl}">{$authorsShort} — {$submissionTitle}</a></p><hr><p>This is an automated email from <a href="{$serverUrl}">{$serverName}</a>.</p>'),
(141, 'SUBMISSION_NEEDS_EDITOR', 'es', 'El envío necesita un editor/a', 'Un envío nuevo necesita que le asignen un editor/a: {$submissionTitle}', ''),
(142, 'SUBMISSION_NEEDS_EDITOR', 'fi', 'Käsikirjoitukselle tarvitaan toimittaja', '', ''),
(143, 'SUBMISSION_NEEDS_EDITOR', 'fr_CA', 'Soumission en attente de rédacteur-trice', 'Un-e rédacteur-trice doit être assigné-e à la nouvelle soumission : {$submissionTitle}', '<p>{$recipientName},</p><p>La soumission suivante a été soumise et aucun-e rédacteur-trice ne lui est assigné-e.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>S''il vous plait, assignez un-e rédacteur-trice qui sera responsable de la soumission. </p><hr><p>Ceci est un courriel automatique de <a href="{$serverUrl}">{$serverName}</a>.</p>'),
(144, 'SUBMISSION_NEEDS_EDITOR', 'mk', 'Потребен е уредник за поднесокот', 'Треба да се назначи уредник за новиот поднесок: {$submissionTitle}', '<p>Почитуван {$recipientName},</p><p>Следниот поднесок е испратен и нема доделен уредник.</p><p><a href="{$submissionUrl}">{$submissionTitle. }</a><br />{$authors}</p><p><b>Апстракт</b></p>{$submissionAbstract}<p>Ве молиме доделете уредник кој ќе биде одговорен за поднесувањето со кликнување на насловот погоре и доделување уредник во делот Учесници.</p><hr><p>Ова е автоматизирана е-пошта од <a href="{$serverUrl}">{$serverName}</a>. </p>'),
(145, 'SUBMISSION_NEEDS_EDITOR', 'nb', '', '', ''),
(146, 'SUBMISSION_NEEDS_EDITOR', 'pt_BR', 'Editor de Necessidades de Submissão', 'Uma nova submissão precisa que um editor seja designado: {$submissionTitle}', '<p>Prezado(a) {$recipientName},</p><p>A submissão a seguir foi enviada e não há editor designado.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Resumo</b></p>{$submissionAbstract}<p>Por favor, designe um editor que será responsável pela submissão clicando no título acima e designando um editor na seção Participantes.</p><hr><p>Este é um e-mail automático de <a href="{$serverUrl}">{$serverName}</a>. </p>'),
(147, 'SUBMISSION_NEEDS_EDITOR', 'en', 'Submission Needs Editor', 'A new submission needs an editor to be assigned: {$submissionTitle}', '<p>Dear {$recipientName},</p><p>The following submission has been submitted and there is no editor assigned.</p><p><a href="{$submissionUrl}">{$submissionTitle}</a><br />{$authors}</p><p><b>Abstract</b></p>{$submissionAbstract}<p>Please assign an editor who will be responsible for the submission by clicking the title above and assigning an editor under the Participants section.</p><hr><p>This is an automated email from <a href="{$serverUrl}">{$serverName}</a>.</p>'),
(148, 'ORCID_COLLECT_AUTHOR_ID', 'es', 'orcidCollectAuthorId', 'ORCID de envío', 'Estimado/a {$recipientName},\n<br/>\nSe le ha añadido como coautor/a de un artículo para {$serverName}. <br/>\nPara confirmar su autoría, añada su identificador ORCID a este envío mediante el siguiente enlace.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Registrar o conectar su identificador ORCID</a><br/>\n<br/>\n<br>\n<a href="{$orcidAboutUrl}">Puede encontrar más información sobre ORCID en {$serverName}</a><br/>\n<br/>\nSi tiene cualquier pregunta no dude en contactarme.<br/>\n<br/>\n{$principalContactSignature}<br/>\n'),
(149, 'ORCID_COLLECT_AUTHOR_ID', 'fi', '', 'Käsikirjoituksen ORCID-tunnisteet', 'Arvoisa {$recipientName},<br/>\n<br/>\nTeidät mainitaan yhtenä kirjoittajana käsikirjoituksessa "{$submissionTitle}", joka on lähetetty julkaisuun {$serverName}.<br/>\n<br/>\nVarmistaaksesi tekijyytesi, ole hyvä ja lisää ORCID-tunnisteesi käsikirjoitukseen vierailemalla alla olevassa linkissä ja seuraamalla ohjeita.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Rekisteröi tai yhdistä ORCID</a><br/>\n<br/>\n<br/>\n<a href="{$orcidAboutUrl}">Lisätietoja ORCID-tunnisteista julkaisussa {$serverName}</a><br/>\n<br/>\nMikäli teillä on jotain kysymyksiä, olkaa yhteydessä.<br/>\n<br/>\n{$principalContactSignature}<br/>\n'),
(150, 'ORCID_COLLECT_AUTHOR_ID', 'fr_CA', 'orcidCollectAuthorId', 'Soumission ORCID', '{$recipientName},<br/>\n<br/>\nVous avez été inscrit ou inscrite en tant qu''auteur ou auteure pour un manuscrit soumis à {$serverName}.<br/>\nPour confirmer votre statut d''auteur ou d''auteure, veuillez ajouter votre identifiant ORCID à cette soumission en cliquant sur le lien ci-dessous.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="icône identifiant ORCID" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Se connecter avec votre identifiant ORCID ou s''inscrire</a><br/>\n<br/>\n<br/>\n<a href="{$orcidAboutUrl}">Plus de renseignements sur votre identifiant ORCID dans {$serverName}</a><br/>\n<br/>\nSi vous avez des questions, veuillez communiquer avec nous.<br/>\n<br/>\n{$principalContactSignature}<br/>\n'),
(151, 'ORCID_COLLECT_AUTHOR_ID', 'mk', 'Авторски orcidCollectAuthorId', 'Испраќање на ORCID', 'Почитуван {$recipientName},<br/>\n<br/>\nВие сте наведени како автор на поднесен ракопис до {$serverName}.<br/>\nЗа да го потврдите вашето авторство, додадете го вашиот ID на ORCID на овој поднесок со посета на врската дадена подолу. <br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Регистрирај се или поврзете го вашиот ORCID iD </a> <br />\n<br/>\n<br>\n<a href="{$orcidAboutUrl}"> Повеќе информации за ORCID на {$textName} </a> <br/>\n<br/>\nАко имате какви било прашања, контактирајте ме. <br/>\n<br/>\n{$principalContactSignature} <br/>\n'),
(152, 'ORCID_COLLECT_AUTHOR_ID', 'nb', '', 'ORCID for innlevering', 'Kjære {$recipientName}, <br />\n<br />\nDu er oppført som forfatter på en manusinnlevering til {$serverName}. <br />\nFor å bekrefte forfatterskapet ditt, vennligst legg til ORCID-ID-en din i denne innleveringen ved å gå til lenken nedenfor. <br />\n<br />\n<a href="{$authorOrcidUrl}"> <img id = "orcid-id-logo" src = "https://orcid.org/sites/default/files/images/orcid_16x16.png" width = ''16 '' height = ''16 ''alt = "ORCID iD icon" style = "display: block; margin: 0 .5em 0 0; padding: 0; float: left;" /> Registrer eller koble ORCID iD </a> <br />\n<br />\n<br />\n<a href="{$orcidAboutUrl}"> Mer informasjon om ORCID på {$serverName} </a> <br />\n<br />\nTa gjerne kontakt hvis du har spørsmål. <br />\n<br />\n{$principalContactSignature} <br />\n'),
(153, 'ORCID_COLLECT_AUTHOR_ID', 'pt_BR', 'orcidCollectAuthorId', 'ORCID da submissão', 'Prezado(a) {$recipientName},<br>\n<br>\nVocê foi listada(o) como um coautor(a) em uma submissão de manuscrito "{$submissionTitle}" para {$serverName}.<br/>\nPara confirmar sua autoria, por favor, adicione sua id ORCID a esta submissão, visitando o link fornecido abaixo.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Registre ou conecte seu ORCID iD</a><br/>\n<br/>\n<br>\n<a href="{$orcidAboutUrl}">Mais informações sobre o ORCID em {$serverName}</a><br/>\n<br/>\nSe você tiver quaisquer dúvidas, por favor entre em contato comigo.<br/>\n<br/>\n{$principalContactSignature}<br/>\n'),
(154, 'ORCID_COLLECT_AUTHOR_ID', 'en', 'orcidCollectAuthorId', 'Submission ORCID', 'Dear {$recipientName},<br/>\n<br/>\nYou have been listed as an author on a manuscript submission to {$serverName}.<br/>\nTo confirm your authorship, please add your ORCID id to this submission by visiting the link provided below.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Register or connect your ORCID iD</a><br/>\n<br/>\n<br>\n<a href="{$orcidAboutUrl}">More information about ORCID at {$serverName}</a><br/>\n<br/>\nIf you have any questions, please contact me.<br/>\n<br/>\n{$principalContactSignature}<br/>\n'),
(155, 'ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'es', 'orcidRequestAuthorAuthorization', 'Solicitando acceso de registro ORCID', 'Estimado/a {$recipientName},<br>\n<br>\nUsted ha sido incluido como autor en la presentación del manuscrito "{$submissionTitle}" a {$serverName}.\n<br>\n<br>\nPermítanos agregar su identificación ORCID a este envío y también agregar el mismo a su perfil ORCID en la publicación.<br>\nVisite el enlace al sitio web oficial de ORCID, inicie sesión con su perfil y autorice el acceso siguiendo las instrucciones.<br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Registre o conecte su ORCID iD</a><br/>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">Más acerca de ORCID en{$serverName}</a><br/>\n<br>\nSi tiene alguna pregunta, por favor póngase en contacto conmigo.<br>\n<br>\n{$principalContactSignature}<br>\n'),
(156, 'ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'fi', '', 'ORCID-pääsyn pyyntö', 'Dear {$recipientName},<br>\n<br/>\nTeidät mainitaan yhtenä kirjoittajana käsikirjoituksessa "{$submissionTitle}", joka on lähetetty julkaisuun {$serverName}.<br/>\n<br/>\nVarmistaaksesi tekijyytesi, ole hyvä ja lisää ORCID-tunnisteesi käsikirjoitukseen vierailemalla alla olevassa linkissä ja seuraamalla ohjeita. Artikkelin julkaisun jälkeen sitä koskevat tiedot voidaan liittää ORCID-tiliisi, jos olet antanut siihen luvan.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Rekisteröi tai yhdistä ORCID</a><br/>\n<br/>\n<br/>\n<a href="{$orcidAboutUrl}">Lisätietoja ORCID-tunnisteista julkaisussa {$serverName}</a><br/>\n<br/>\nMikäli teillä on jotain kysymyksiä, olkaa yhteydessä.<br/>\n<br/>\n{$principalContactSignature}<br/>\n'),
(157, 'ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'fr_CA', 'orcidRequestAuthorAuthorization', 'Demande d''accès au dossier ORCID', '{$recipientName},<br/>\n<br/>\nVous avez été inscrit ou inscrite en tant qu''auteur ou auteure pour le manuscrit « {$submissionTitle} » soumis à {$serverName}.\n<br/>\n<br/>\nVeuillez nous autoriser à ajouter votre identifiant ORCID à cette soumission et à ajouter également la soumission à votre dossier ORCID suite à sa publication.\n<br/>\nSuivre le lien vers le site officiel ORCID, vous connecter avec votre profil et autoriser l''accès en suivant les instructions.<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="icône identifiant ORCID" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Se connecter avec votre identifiant ORCID ou s''inscrire</a><br/>\n<br/>\n<br/>\n<a href="{$orcidAboutUrl}">Plus de renseignements sur votre identifiant ORCID dans {$serverName}</a><br/>\n<br/>\nSi vous avez des questions, veuillez communiquer avec nous.<br/>\n<br/>\n{$principalContactSignature}<br/>\n'),
(158, 'ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'mk', 'Авторизација orcidRequestAuthorAuthorization', 'Барање пристап до запис ORCID', 'Почитуван {$ authorName}, <br>\n<br>\nВие сте наведени како автор на поднесувањето на ракописот „{$submissionTitle}“ до {$serverName}.\n<br>\n<br>\nВе молиме, дозволете ни да го додадеме вашиот ID на ORCID на овој поднесок и да го додадеме поднесувањето на вашиот ORCID профил на објавувањето. <br>\nПосетете ја врската до официјалната веб-страница на ORCID, најавете се со вашиот профил и овластете го пристапот следејќи ги упатствата. <br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://info.orcid.org/sites/default/files/images/orcid_wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Регистрирај се или Поврзи го ORCID iD </a> <br />\n<br>\n<br>\n<a href="{$orcidAboutUrl}"> Повеќе за ORCID на {$textName} </a> <br/>\n<br>\nАко имате какви било прашања, контактирајте ме. <br>\n<br>\n{$principalContactSignature} <br>\n'),
(159, 'ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'nb', '', 'Forespørsel om tilgang til ORCID', 'Kjære {$recipientName}, <br />\n<br />\nDu er oppført som forfatter på manusinnleveringen "{$submissionTitle}" til {$serverName}. <br />\nFor å bekrefte forfatterskapet ditt, vennligst legg til ORCID-ID-en din i denne innleveringen ved å gå til lenken nedenfor. <br />\n<br />\n<a href="{$authorOrcidUrl}"> <img id = "orcid-id-logo" src = "https://orcid.org/sites/default/files/images/orcid_16x16.png" width = ''16 '' height = ''16 ''alt = "ORCID iD icon" style = "display: block; margin: 0 .5em 0 0; padding: 0; float: left;" /> Registrer eller koble ORCID iD </a> <br />\n<br />\n<br />\n<a href="{$orcidAboutUrl}"> Mer informasjon om ORCID på {$serverName} </a> <br />\n<br />\nTa gjerne kontakt hvis du har spørsmål. <br />\n<br />\n{$principalContactSignature} <br />\n'),
(160, 'ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'pt_BR', 'orcidRequestAuthorAuthorization', 'Solicitando acesso ao registro ORCID', 'Prezado(a) {$recipientName}, <br>\n<br>\nVocê foi listado como autor na submissão do manuscrito "{$submissionTitle}" para {$serverName}.\n<br>\n<br>\nPermita-nos adicionar seu ID do ORCID a essa submissão e também adicioná-lo ao seu perfil do ORCID na publicação. <br>\nVisite o link para o site oficial do ORCID, faça o login com seu perfil e autorize o acesso seguindo as instruções. <br>\n<a href="{$authorOrcidUrl}"> <img id ="orcid-id-logo" src = "https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width = ''16 '' height = ''16 '' alt = "Ícone ORCID iD" style = "display: block; margin: 0 .5em 0 0; padding: 0; float: left;" /> Registre ou conecte seu ORCID ID </a> <br/>\n<br>\n<br>\n<a href="{$orcidAboutUrl}"> Mais sobre o ORCID em {$serverName} </a> <br/>\n<br>\nSe você tiver alguma dúvida, entre em contato comigo. <br>\n<br>\n{$principalContactSignature} <br>\n'),
(161, 'ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'en', 'orcidRequestAuthorAuthorization', 'Requesting ORCID record access', 'Dear {$recipientName},<br>\n<br>\nYou have been listed as an author on the manuscript submission "{$submissionTitle}" to {$serverName}.\n<br>\n<br>\nPlease allow us to add your ORCID id to this submission and also to add the submission to your ORCID profile on publication.<br>\nVisit the link to the official ORCID website, login with your profile and authorize the access by following the instructions.<br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://info.orcid.org/wp-content/uploads/2020/12/ORCIDiD_icon16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Register or Connect your ORCID iD</a><br/>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">More about ORCID at {$serverName}</a><br/>\n<br>\nIf you have any questions, please contact me.<br>\n<br>\n{$principalContactSignature}<br>\n');

-- --------------------------------------------------------

--
-- Table structure for table `email_templates_settings`
--

CREATE TABLE `email_templates_settings` (
  `email_template_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `email_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`email_template_setting_id`),
  UNIQUE KEY `email_templates_settings_unique` (`email_id`,`locale`,`setting_name`),
  KEY `email_templates_settings_email_id` (`email_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about custom email templates, including localized properties such as the subject and body.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `event_log`
--

CREATE TABLE `event_log` (
  `log_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL COMMENT 'NULL if it''s system or automated event',
  `date_logged` datetime NOT NULL,
  `event_type` bigint(20) DEFAULT NULL,
  `message` text,
  `is_translated` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `event_log_user_id` (`user_id`),
  KEY `event_log_assoc` (`assoc_type`,`assoc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A log of all events related to an object like a submission.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `event_log_settings`
--

CREATE TABLE `event_log_settings` (
  `event_log_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `log_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`event_log_setting_id`),
  UNIQUE KEY `event_log_settings_unique` (`log_id`,`setting_name`,`locale`),
  KEY `event_log_settings_log_id` (`log_id`),
  KEY `event_log_settings_name_value` (`setting_name`(50),`setting_value`(150))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data about an event log entry. This data is commonly used to display information about an event to a user.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `failed_jobs`
--

CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A log of all failed jobs.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `files`
--

CREATE TABLE `files` (
  `file_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(255) NOT NULL,
  `mimetype` varchar(255) NOT NULL,
  PRIMARY KEY (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Records information in the database about files tracked by the system, linking them to the local filesystem.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `filters`
--

CREATE TABLE `filters` (
  `filter_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `filter_group_id` bigint(20) NOT NULL DEFAULT '0',
  `context_id` bigint(20) NOT NULL DEFAULT '0',
  `display_name` varchar(255) DEFAULT NULL,
  `class_name` varchar(255) DEFAULT NULL,
  `is_template` smallint(6) NOT NULL DEFAULT '0',
  `parent_filter_id` bigint(20) NOT NULL DEFAULT '0',
  `seq` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`filter_id`),
  KEY `filters_filter_group_id` (`filter_group_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Filters represent a transformation of a supported piece of data from one form to another, such as a PHP object into an XML document.' AUTO_INCREMENT=13 ;

--
-- Dumping data for table `filters`
--

INSERT INTO `filters` VALUES
(1, 1, 0, 'Crossref XML preprint export', 'APP\\plugins\\generic\\crossref\\filter\\PreprintCrossrefXmlFilter', 0, 0, 0),
(2, 2, 0, 'Extract metadata from a(n) Submission', 'APP\\plugins\\metadata\\dc11\\filter\\Dc11SchemaPreprintAdapter', 0, 0, 0),
(3, 3, 0, 'Native XML submission export', 'APP\\plugins\\importexport\\native\\filter\\PreprintNativeXmlFilter', 0, 0, 0),
(4, 4, 0, 'Native XML submission import', 'APP\\plugins\\importexport\\native\\filter\\NativeXmlPreprintFilter', 0, 0, 0),
(5, 5, 0, 'Native XML author export', 'APP\\plugins\\importexport\\native\\filter\\AuthorNativeXmlFilter', 0, 0, 0),
(6, 6, 0, 'Native XML author import', 'APP\\plugins\\importexport\\native\\filter\\NativeXmlAuthorFilter', 0, 0, 0),
(7, 8, 0, 'Native XML submission file import', 'APP\\plugins\\importexport\\native\\filter\\NativeXmlPreprintFileFilter', 0, 0, 0),
(8, 7, 0, 'Native XML submission file export', 'PKP\\plugins\\importexport\\native\\filter\\SubmissionFileNativeXmlFilter', 0, 0, 0),
(9, 9, 0, 'Native XML representation export', 'APP\\plugins\\importexport\\native\\filter\\PreprintGalleyNativeXmlFilter', 0, 0, 0),
(10, 10, 0, 'Native XML representation import', 'APP\\plugins\\importexport\\native\\filter\\NativeXmlPreprintGalleyFilter', 0, 0, 0),
(11, 11, 0, 'Native XML Publication export', 'APP\\plugins\\importexport\\native\\filter\\PublicationNativeXmlFilter', 0, 0, 0),
(12, 12, 0, 'Native XML publication import', 'APP\\plugins\\importexport\\native\\filter\\NativeXmlPublicationFilter', 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `filter_groups`
--

CREATE TABLE `filter_groups` (
  `filter_group_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `symbolic` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `input_type` varchar(255) DEFAULT NULL,
  `output_type` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`filter_group_id`),
  UNIQUE KEY `filter_groups_symbolic` (`symbolic`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Filter groups are used to organized filters into named sets, which can be retrieved by the application for invocation.' AUTO_INCREMENT=13 ;

--
-- Dumping data for table `filter_groups`
--

INSERT INTO `filter_groups` VALUES
(1, 'preprint=>crossref-xml', 'plugins.importexport.crossref.displayName', 'plugins.importexport.crossref.description', 'class::classes.submission.Submission[]', 'xml::schema(https://www.crossref.org/schemas/crossref5.3.1.xsd)'),
(2, 'preprint=>dc11', 'plugins.metadata.dc11.preprintAdapter.displayName', 'plugins.metadata.dc11.preprintAdapter.description', 'class::classes.submission.Submission', 'metadata::APP\\plugins\\metadata\\dc11\\schema\\Dc11Schema(PREPRINT)'),
(3, 'preprint=>native-xml', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'class::classes.submission.Submission[]', 'xml::schema(plugins/importexport/native/native.xsd)'),
(4, 'native-xml=>preprint', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'xml::schema(plugins/importexport/native/native.xsd)', 'class::classes.submission.Submission[]'),
(5, 'author=>native-xml', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'class::classes.author.Author[]', 'xml::schema(plugins/importexport/native/native.xsd)'),
(6, 'native-xml=>author', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'xml::schema(plugins/importexport/native/native.xsd)', 'class::classes.author.Author[]'),
(7, 'SubmissionFile=>native-xml', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'class::lib.pkp.classes.submissionFile.SubmissionFile', 'xml::schema(plugins/importexport/native/native.xsd)'),
(8, 'native-xml=>SubmissionFile', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'xml::schema(plugins/importexport/native/native.xsd)', 'class::lib.pkp.classes.submissionFile.SubmissionFile[]'),
(9, 'preprint-galley=>native-xml', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'class::lib.pkp.classes.galley.Galley', 'xml::schema(plugins/importexport/native/native.xsd)'),
(10, 'native-xml=>PreprintGalley', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'xml::schema(plugins/importexport/native/native.xsd)', 'class::lib.pkp.classes.galley.Galley[]'),
(11, 'publication=>native-xml', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'class::classes.publication.Publication', 'xml::schema(plugins/importexport/native/native.xsd)'),
(12, 'native-xml=>Publication', 'plugins.importexport.native.displayName', 'plugins.importexport.native.description', 'xml::schema(plugins/importexport/native/native.xsd)', 'class::classes.publication.Publication[]');

-- --------------------------------------------------------

--
-- Table structure for table `filter_settings`
--

CREATE TABLE `filter_settings` (
  `filter_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `filter_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`filter_setting_id`),
  UNIQUE KEY `filter_settings_unique` (`filter_id`,`locale`,`setting_name`),
  KEY `filter_settings_id` (`filter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about filters, including localized content.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `genres`
--

CREATE TABLE `genres` (
  `genre_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `seq` bigint(20) NOT NULL,
  `enabled` smallint(6) NOT NULL DEFAULT '1',
  `category` bigint(20) NOT NULL DEFAULT '1',
  `dependent` smallint(6) NOT NULL DEFAULT '0',
  `supplementary` smallint(6) NOT NULL DEFAULT '0',
  `required` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Whether or not at least one file of this genre is required for a new submission.',
  `entry_key` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`genre_id`),
  KEY `genres_context_id` (`context_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The types of submission files configured for each context, such as Article Text, Data Set, Transcript, etc.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `genre_settings`
--

CREATE TABLE `genre_settings` (
  `genre_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `genre_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  PRIMARY KEY (`genre_setting_id`),
  UNIQUE KEY `genre_settings_unique` (`genre_id`,`locale`,`setting_name`),
  KEY `genre_settings_genre_id` (`genre_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about file genres, including localized properties such as the genre name.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `institutions`
--

CREATE TABLE `institutions` (
  `institution_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `ror` varchar(255) DEFAULT NULL COMMENT 'ROR (Research Organization Registry) ID',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`institution_id`),
  KEY `institutions_context_id` (`context_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Institutions for statistics and subscriptions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `institution_ip`
--

CREATE TABLE `institution_ip` (
  `institution_ip_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `institution_id` bigint(20) NOT NULL,
  `ip_string` varchar(40) NOT NULL,
  `ip_start` bigint(20) NOT NULL,
  `ip_end` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`institution_ip_id`),
  KEY `institution_ip_institution_id` (`institution_id`),
  KEY `institution_ip_start` (`ip_start`),
  KEY `institution_ip_end` (`ip_end`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Records IP address ranges and associates them with institutions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `institution_settings`
--

CREATE TABLE `institution_settings` (
  `institution_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `institution_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`institution_setting_id`),
  UNIQUE KEY `institution_settings_unique` (`institution_id`,`locale`,`setting_name`),
  KEY `institution_settings_institution_id` (`institution_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about institutions, including localized properties like names.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jobs`
--

CREATE TABLE `jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) NOT NULL,
  `payload` longtext NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_reserved_at_index` (`queue`,`reserved_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='All pending or in-progress jobs.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `job_batches`
--

CREATE TABLE `job_batches` (
  `id` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `total_jobs` int(11) NOT NULL,
  `pending_jobs` int(11) NOT NULL,
  `failed_jobs` int(11) NOT NULL,
  `failed_job_ids` text NOT NULL,
  `options` mediumtext,
  `cancelled_at` int(11) DEFAULT NULL,
  `created_at` int(11) NOT NULL,
  `finished_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Job batches allow jobs to be collected into groups for managed processing.';

-- --------------------------------------------------------

--
-- Table structure for table `library_files`
--

CREATE TABLE `library_files` (
  `file_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `original_file_name` varchar(255) NOT NULL,
  `file_type` varchar(255) NOT NULL,
  `file_size` bigint(20) NOT NULL,
  `type` smallint(6) NOT NULL,
  `date_uploaded` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `submission_id` bigint(20) DEFAULT NULL,
  `public_access` smallint(6) DEFAULT '0',
  PRIMARY KEY (`file_id`),
  KEY `library_files_context_id` (`context_id`),
  KEY `library_files_submission_id` (`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Library files can be associated with the context (press/server/journal) or with individual submissions, and are typically forms, agreements, and other administrative documents that are not part of the scholarly content.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `library_file_settings`
--

CREATE TABLE `library_file_settings` (
  `library_file_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `file_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object|date)',
  PRIMARY KEY (`library_file_setting_id`),
  UNIQUE KEY `library_file_settings_unique` (`file_id`,`locale`,`setting_name`),
  KEY `library_file_settings_file_id` (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about library files, including localized content such as names.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_context`
--

CREATE TABLE `metrics_context` (
  `metrics_context_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `load_id` varchar(50) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `date` date NOT NULL,
  `metric` int(11) NOT NULL,
  PRIMARY KEY (`metrics_context_id`),
  KEY `metrics_context_load_id` (`load_id`),
  KEY `metrics_context_context_id` (`context_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Daily statistics for views of the homepage.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_counter_submission_daily`
--

CREATE TABLE `metrics_counter_submission_daily` (
  `metrics_counter_submission_daily_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `load_id` varchar(50) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `date` date NOT NULL,
  `metric_investigations` int(11) NOT NULL,
  `metric_investigations_unique` int(11) NOT NULL,
  `metric_requests` int(11) NOT NULL,
  `metric_requests_unique` int(11) NOT NULL,
  PRIMARY KEY (`metrics_counter_submission_daily_id`),
  UNIQUE KEY `msd_uc_load_id_context_id_submission_id_date` (`load_id`,`context_id`,`submission_id`,`date`),
  KEY `msd_load_id` (`load_id`),
  KEY `metrics_counter_submission_daily_context_id` (`context_id`),
  KEY `metrics_counter_submission_daily_submission_id` (`submission_id`),
  KEY `msd_context_id_submission_id` (`context_id`,`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Daily statistics matching the COUNTER R5 protocol for views and downloads of published submissions and galleys.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_counter_submission_institution_daily`
--

CREATE TABLE `metrics_counter_submission_institution_daily` (
  `metrics_counter_submission_institution_daily_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `load_id` varchar(50) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `institution_id` bigint(20) NOT NULL,
  `date` date NOT NULL,
  `metric_investigations` int(11) NOT NULL,
  `metric_investigations_unique` int(11) NOT NULL,
  `metric_requests` int(11) NOT NULL,
  `metric_requests_unique` int(11) NOT NULL,
  PRIMARY KEY (`metrics_counter_submission_institution_daily_id`),
  UNIQUE KEY `msid_uc_load_id_context_id_submission_id_institution_id_date` (`load_id`,`context_id`,`submission_id`,`institution_id`,`date`),
  KEY `msid_load_id` (`load_id`),
  KEY `msid_context_id` (`context_id`),
  KEY `msid_submission_id` (`submission_id`),
  KEY `msid_institution_id` (`institution_id`),
  KEY `msid_context_id_submission_id` (`context_id`,`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Daily statistics matching the COUNTER R5 protocol for views and downloads from institutions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_counter_submission_institution_monthly`
--

CREATE TABLE `metrics_counter_submission_institution_monthly` (
  `metrics_counter_submission_institution_monthly_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `institution_id` bigint(20) NOT NULL,
  `month` int(11) NOT NULL,
  `metric_investigations` int(11) NOT NULL,
  `metric_investigations_unique` int(11) NOT NULL,
  `metric_requests` int(11) NOT NULL,
  `metric_requests_unique` int(11) NOT NULL,
  PRIMARY KEY (`metrics_counter_submission_institution_monthly_id`),
  UNIQUE KEY `msim_uc_context_id_submission_id_institution_id_month` (`context_id`,`submission_id`,`institution_id`,`month`),
  KEY `msim_context_id` (`context_id`),
  KEY `msim_submission_id` (`submission_id`),
  KEY `msim_institution_id` (`institution_id`),
  KEY `msim_context_id_submission_id` (`context_id`,`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Monthly statistics matching the COUNTER R5 protocol for views and downloads from institutions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_counter_submission_monthly`
--

CREATE TABLE `metrics_counter_submission_monthly` (
  `metrics_counter_submission_monthly_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `month` int(11) NOT NULL,
  `metric_investigations` int(11) NOT NULL,
  `metric_investigations_unique` int(11) NOT NULL,
  `metric_requests` int(11) NOT NULL,
  `metric_requests_unique` int(11) NOT NULL,
  PRIMARY KEY (`metrics_counter_submission_monthly_id`),
  UNIQUE KEY `msm_uc_context_id_submission_id_month` (`context_id`,`submission_id`,`month`),
  KEY `metrics_counter_submission_monthly_context_id` (`context_id`),
  KEY `metrics_counter_submission_monthly_submission_id` (`submission_id`),
  KEY `msm_context_id_submission_id` (`context_id`,`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Monthly statistics matching the COUNTER R5 protocol for views and downloads of published submissions and galleys.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_submission`
--

CREATE TABLE `metrics_submission` (
  `metrics_submission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `load_id` varchar(50) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `representation_id` bigint(20) DEFAULT NULL,
  `submission_file_id` bigint(20) unsigned DEFAULT NULL,
  `file_type` bigint(20) DEFAULT NULL,
  `assoc_type` bigint(20) NOT NULL,
  `date` date NOT NULL,
  `metric` int(11) NOT NULL,
  PRIMARY KEY (`metrics_submission_id`),
  KEY `ms_load_id` (`load_id`),
  KEY `metrics_submission_context_id` (`context_id`),
  KEY `metrics_submission_submission_id` (`submission_id`),
  KEY `metrics_submission_representation_id` (`representation_id`),
  KEY `metrics_submission_submission_file_id` (`submission_file_id`),
  KEY `ms_context_id_submission_id_assoc_type_file_type` (`context_id`,`submission_id`,`assoc_type`,`file_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Daily statistics for views and downloads of published submissions and galleys.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_submission_geo_daily`
--

CREATE TABLE `metrics_submission_geo_daily` (
  `metrics_submission_geo_daily_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `load_id` varchar(50) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `country` varchar(2) NOT NULL DEFAULT '',
  `region` varchar(3) NOT NULL DEFAULT '',
  `city` varchar(255) NOT NULL DEFAULT '',
  `date` date NOT NULL,
  `metric` int(11) NOT NULL,
  `metric_unique` int(11) NOT NULL,
  PRIMARY KEY (`metrics_submission_geo_daily_id`),
  UNIQUE KEY `msgd_uc_load_context_submission_c_r_c_date` (`load_id`,`context_id`,`submission_id`,`country`,`region`,`city`(80),`date`),
  KEY `msgd_load_id` (`load_id`),
  KEY `msgd_context_id` (`context_id`),
  KEY `msgd_submission_id` (`submission_id`),
  KEY `msgd_context_id_submission_id` (`context_id`,`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Daily statistics by country, region and city for views and downloads of published submissions and galleys.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `metrics_submission_geo_monthly`
--

CREATE TABLE `metrics_submission_geo_monthly` (
  `metrics_submission_geo_monthly_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `country` varchar(2) NOT NULL DEFAULT '',
  `region` varchar(3) NOT NULL DEFAULT '',
  `city` varchar(255) NOT NULL DEFAULT '',
  `month` int(11) NOT NULL,
  `metric` int(11) NOT NULL,
  `metric_unique` int(11) NOT NULL,
  PRIMARY KEY (`metrics_submission_geo_monthly_id`),
  UNIQUE KEY `msgm_uc_context_submission_c_r_c_month` (`context_id`,`submission_id`,`country`,`region`,`city`(80),`month`),
  KEY `msgm_context_id` (`context_id`),
  KEY `msgm_submission_id` (`submission_id`),
  KEY `msgm_context_id_submission_id` (`context_id`,`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Monthly statistics by country, region and city for views and downloads of published submissions and galleys.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `navigation_menus`
--

CREATE TABLE `navigation_menus` (
  `navigation_menu_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `area_name` varchar(255) DEFAULT '',
  `title` varchar(255) NOT NULL,
  PRIMARY KEY (`navigation_menu_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Navigation menus on the website are installed with the software as a default set, and can be customized.' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `navigation_menus`
--

INSERT INTO `navigation_menus` VALUES
(1, 0, 'user', 'User Navigation Menu');

-- --------------------------------------------------------

--
-- Table structure for table `navigation_menu_items`
--

CREATE TABLE `navigation_menu_items` (
  `navigation_menu_item_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `path` varchar(255) DEFAULT '',
  `type` varchar(255) DEFAULT '',
  PRIMARY KEY (`navigation_menu_item_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Navigation menu items are single elements within a navigation menu.' AUTO_INCREMENT=8 ;

--
-- Dumping data for table `navigation_menu_items`
--

INSERT INTO `navigation_menu_items` VALUES
(1, 0, NULL, 'NMI_TYPE_USER_REGISTER'),
(2, 0, NULL, 'NMI_TYPE_USER_LOGIN'),
(3, 0, NULL, 'NMI_TYPE_USER_DASHBOARD'),
(4, 0, NULL, 'NMI_TYPE_USER_DASHBOARD'),
(5, 0, NULL, 'NMI_TYPE_USER_PROFILE'),
(6, 0, NULL, 'NMI_TYPE_ADMINISTRATION'),
(7, 0, NULL, 'NMI_TYPE_USER_LOGOUT');

-- --------------------------------------------------------

--
-- Table structure for table `navigation_menu_item_assignments`
--

CREATE TABLE `navigation_menu_item_assignments` (
  `navigation_menu_item_assignment_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `navigation_menu_id` bigint(20) NOT NULL,
  `navigation_menu_item_id` bigint(20) NOT NULL,
  `parent_id` bigint(20) DEFAULT NULL,
  `seq` bigint(20) DEFAULT '0',
  PRIMARY KEY (`navigation_menu_item_assignment_id`),
  KEY `navigation_menu_item_assignments_navigation_menu_id` (`navigation_menu_id`),
  KEY `navigation_menu_item_assignments_navigation_menu_item_id` (`navigation_menu_item_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Links navigation menu items to navigation menus.' AUTO_INCREMENT=8 ;

--
-- Dumping data for table `navigation_menu_item_assignments`
--

INSERT INTO `navigation_menu_item_assignments` VALUES
(1, 1, 1, 0, 0),
(2, 1, 2, 0, 1),
(3, 1, 3, 0, 2),
(4, 1, 4, 3, 0),
(5, 1, 5, 3, 1),
(6, 1, 6, 3, 2),
(7, 1, 7, 3, 3);

-- --------------------------------------------------------

--
-- Table structure for table `navigation_menu_item_assignment_settings`
--

CREATE TABLE `navigation_menu_item_assignment_settings` (
  `navigation_menu_item_assignment_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `navigation_menu_item_assignment_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`navigation_menu_item_assignment_setting_id`),
  UNIQUE KEY `navigation_menu_item_assignment_settings_unique` (`navigation_menu_item_assignment_id`,`locale`,`setting_name`),
  KEY `navigation_menu_item_assignment_settings_n_m_i_a_id` (`navigation_menu_item_assignment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about navigation menu item assignments to navigation menus, including localized content.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `navigation_menu_item_settings`
--

CREATE TABLE `navigation_menu_item_settings` (
  `navigation_menu_item_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `navigation_menu_item_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` longtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`navigation_menu_item_setting_id`),
  UNIQUE KEY `navigation_menu_item_settings_unique` (`navigation_menu_item_id`,`locale`,`setting_name`),
  KEY `navigation_menu_item_settings_navigation_menu_item_id` (`navigation_menu_item_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='More data about navigation menu items, including localized content such as names.' AUTO_INCREMENT=8 ;

--
-- Dumping data for table `navigation_menu_item_settings`
--

INSERT INTO `navigation_menu_item_settings` VALUES
(1, 1, '', 'titleLocaleKey', 'navigation.register', 'string'),
(2, 2, '', 'titleLocaleKey', 'navigation.login', 'string'),
(3, 3, '', 'titleLocaleKey', '{$loggedInUsername}', 'string'),
(4, 4, '', 'titleLocaleKey', 'navigation.dashboard', 'string'),
(5, 5, '', 'titleLocaleKey', 'common.viewProfile', 'string'),
(6, 6, '', 'titleLocaleKey', 'navigation.admin', 'string'),
(7, 7, '', 'titleLocaleKey', 'user.logOut', 'string');

-- --------------------------------------------------------

--
-- Table structure for table `notes`
--

CREATE TABLE `notes` (
  `note_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `contents` text,
  PRIMARY KEY (`note_id`),
  KEY `notes_user_id` (`user_id`),
  KEY `notes_assoc` (`assoc_type`,`assoc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Notes allow users to annotate associated entities, such as submissions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `notifications`
--

CREATE TABLE `notifications` (
  `notification_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `level` bigint(20) NOT NULL,
  `type` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL,
  `date_read` datetime DEFAULT NULL,
  `assoc_type` bigint(20) DEFAULT NULL,
  `assoc_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`notification_id`),
  KEY `notifications_context_id` (`context_id`),
  KEY `notifications_user_id` (`user_id`),
  KEY `notifications_context_id_user_id` (`context_id`,`user_id`,`level`),
  KEY `notifications_context_id_level` (`context_id`,`level`),
  KEY `notifications_assoc` (`assoc_type`,`assoc_id`),
  KEY `notifications_user_id_level` (`user_id`,`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='User notifications created during certain operations.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `notification_settings`
--

CREATE TABLE `notification_settings` (
  `notification_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `notification_id` bigint(20) NOT NULL,
  `locale` varchar(14) DEFAULT NULL,
  `setting_name` varchar(64) NOT NULL,
  `setting_value` mediumtext NOT NULL,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  PRIMARY KEY (`notification_setting_id`),
  UNIQUE KEY `notification_settings_unique` (`notification_id`,`locale`,`setting_name`),
  KEY `notification_settings_notification_id` (`notification_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about notifications, including localized properties.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `notification_subscription_settings`
--

CREATE TABLE `notification_subscription_settings` (
  `setting_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `setting_name` varchar(64) NOT NULL,
  `setting_value` mediumtext NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `context` bigint(20) DEFAULT NULL,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  PRIMARY KEY (`setting_id`),
  KEY `notification_subscription_settings_user_id` (`user_id`),
  KEY `notification_subscription_settings_context` (`context`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Which email notifications a user has chosen to unsubscribe from.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oai_resumption_tokens`
--

CREATE TABLE `oai_resumption_tokens` (
  `oai_resumption_token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `token` varchar(32) NOT NULL,
  `expire` bigint(20) NOT NULL,
  `record_offset` int(11) NOT NULL,
  `params` text,
  PRIMARY KEY (`oai_resumption_token_id`),
  UNIQUE KEY `oai_resumption_tokens_unique` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='OAI resumption tokens are used to allow for pagination of large result sets into manageable pieces.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `plugin_settings`
--

CREATE TABLE `plugin_settings` (
  `plugin_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `plugin_name` varchar(80) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `setting_name` varchar(80) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  PRIMARY KEY (`plugin_setting_id`),
  UNIQUE KEY `plugin_settings_unique` (`plugin_name`,`context_id`,`setting_name`),
  KEY `plugin_settings_plugin_name` (`plugin_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='More data about plugins, including localized properties. This table is frequently used to store plugin-specific configuration.' AUTO_INCREMENT=10 ;

--
-- Dumping data for table `plugin_settings`
--

INSERT INTO `plugin_settings` VALUES
(1, 'defaultthemeplugin', 0, 'enabled', '1', 'bool'),
(2, 'acronplugin', 0, 'enabled', '1', 'bool'),
(3, 'acronplugin', 0, 'crontab', '[{"className":"PKP\\\\task\\\\StatisticsReport","frequency":{"day":"1"},"args":[]},{"className":"PKP\\\\task\\\\RemoveUnvalidatedExpiredUsers","frequency":{"day":"1"},"args":[]},{"className":"PKP\\\\task\\\\UpdateIPGeoDB","frequency":{"day":"10"},"args":[]},{"className":"APP\\\\tasks\\\\UsageStatsLoader","frequency":{"hour":24},"args":[]},{"className":"PKP\\\\task\\\\ProcessQueueJobs","frequency":{"hour":24},"args":[]},{"className":"PKP\\\\task\\\\RemoveFailedJobs","frequency":{"day":"1"},"args":[]}]', 'object'),
(4, 'tinymceplugin', 0, 'enabled', '1', 'bool'),
(5, 'usageeventplugin', 0, 'enabled', '1', 'bool'),
(6, 'languagetoggleblockplugin', 0, 'enabled', '1', 'bool'),
(7, 'languagetoggleblockplugin', 0, 'seq', '4', 'int'),
(8, 'developedbyblockplugin', 0, 'enabled', '0', 'bool'),
(9, 'developedbyblockplugin', 0, 'seq', '0', 'int');

-- --------------------------------------------------------

--
-- Table structure for table `publications`
--

CREATE TABLE `publications` (
  `publication_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `access_status` bigint(20) DEFAULT '0',
  `date_published` date DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `primary_contact_id` bigint(20) DEFAULT NULL,
  `section_id` bigint(20) DEFAULT NULL,
  `submission_id` bigint(20) NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  `url_path` varchar(64) DEFAULT NULL,
  `version` bigint(20) DEFAULT NULL,
  `doi_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`publication_id`),
  KEY `publications_author_id` (`primary_contact_id`),
  KEY `publications_section_id` (`section_id`),
  KEY `publications_submission_id` (`submission_id`),
  KEY `publications_url_path` (`url_path`),
  KEY `publications_doi_id` (`doi_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Each publication is one version of a submission.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `publication_categories`
--

CREATE TABLE `publication_categories` (
  `publication_category_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `publication_id` bigint(20) NOT NULL,
  `category_id` bigint(20) NOT NULL,
  PRIMARY KEY (`publication_category_id`),
  UNIQUE KEY `publication_categories_id` (`publication_id`,`category_id`),
  KEY `publication_categories_publication_id` (`publication_id`),
  KEY `publication_categories_category_id` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Associates publications (and thus submissions) with categories.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `publication_galleys`
--

CREATE TABLE `publication_galleys` (
  `galley_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `locale` varchar(14) DEFAULT NULL,
  `publication_id` bigint(20) NOT NULL,
  `label` varchar(255) DEFAULT NULL,
  `submission_file_id` bigint(20) unsigned DEFAULT NULL,
  `seq` double(8,2) NOT NULL DEFAULT '0.00',
  `remote_url` varchar(2047) DEFAULT NULL,
  `is_approved` tinyint(4) NOT NULL DEFAULT '0',
  `url_path` varchar(64) DEFAULT NULL,
  `doi_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`galley_id`),
  KEY `publication_galleys_publication_id` (`publication_id`),
  KEY `publication_galleys_submission_file_id` (`submission_file_id`),
  KEY `publication_galleys_url_path` (`url_path`),
  KEY `publication_galleys_doi_id` (`doi_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Publication galleys are representations of publications in a particular format, such as a PDF file.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `publication_galley_settings`
--

CREATE TABLE `publication_galley_settings` (
  `publication_galley_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `galley_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` text,
  PRIMARY KEY (`publication_galley_setting_id`),
  UNIQUE KEY `publication_galley_settings_unique` (`galley_id`,`locale`,`setting_name`),
  KEY `publication_galley_settings_galley_id` (`galley_id`),
  KEY `publication_galley_settings_name_value` (`setting_name`(50),`setting_value`(150))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about publication galleys, including localized properties such as labels.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `publication_settings`
--

CREATE TABLE `publication_settings` (
  `publication_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `publication_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`publication_setting_id`),
  UNIQUE KEY `publication_settings_unique` (`publication_id`,`locale`,`setting_name`),
  KEY `publication_settings_name_value` (`setting_name`(50),`setting_value`(150))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about publications, including localized properties such as the title and abstract.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `queries`
--

CREATE TABLE `queries` (
  `query_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `stage_id` smallint(6) NOT NULL,
  `seq` double(8,2) NOT NULL DEFAULT '0.00',
  `date_posted` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `closed` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`query_id`),
  KEY `queries_assoc_id` (`assoc_type`,`assoc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Discussions, usually related to a submission, created by editors, authors and other editorial staff.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `query_participants`
--

CREATE TABLE `query_participants` (
  `query_participant_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `query_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  PRIMARY KEY (`query_participant_id`),
  UNIQUE KEY `query_participants_unique` (`query_id`,`user_id`),
  KEY `query_participants_query_id` (`query_id`),
  KEY `query_participants_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The users assigned to a discussion.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_assignments`
--

CREATE TABLE `review_assignments` (
  `review_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `reviewer_id` bigint(20) NOT NULL,
  `competing_interests` text,
  `recommendation` smallint(6) DEFAULT NULL,
  `date_assigned` datetime DEFAULT NULL,
  `date_notified` datetime DEFAULT NULL,
  `date_confirmed` datetime DEFAULT NULL,
  `date_completed` datetime DEFAULT NULL,
  `date_acknowledged` datetime DEFAULT NULL,
  `date_due` datetime DEFAULT NULL,
  `date_response_due` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `reminder_was_automatic` smallint(6) NOT NULL DEFAULT '0',
  `declined` smallint(6) NOT NULL DEFAULT '0',
  `cancelled` smallint(6) NOT NULL DEFAULT '0',
  `date_rated` datetime DEFAULT NULL,
  `date_reminded` datetime DEFAULT NULL,
  `quality` smallint(6) DEFAULT NULL,
  `review_round_id` bigint(20) NOT NULL,
  `stage_id` smallint(6) NOT NULL,
  `review_method` smallint(6) NOT NULL DEFAULT '1',
  `round` smallint(6) NOT NULL DEFAULT '1',
  `step` smallint(6) NOT NULL DEFAULT '1',
  `review_form_id` bigint(20) DEFAULT NULL,
  `considered` smallint(6) DEFAULT NULL,
  `request_resent` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`review_id`),
  KEY `review_assignments_submission_id` (`submission_id`),
  KEY `review_assignments_reviewer_id` (`reviewer_id`),
  KEY `review_assignment_reviewer_round` (`review_round_id`,`reviewer_id`),
  KEY `review_assignments_form_id` (`review_form_id`),
  KEY `review_assignments_reviewer_review` (`reviewer_id`,`review_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data about peer review assignments for all submissions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_files`
--

CREATE TABLE `review_files` (
  `review_file_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `review_id` bigint(20) NOT NULL,
  `submission_file_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`review_file_id`),
  UNIQUE KEY `review_files_unique` (`review_id`,`submission_file_id`),
  KEY `review_files_review_id` (`review_id`),
  KEY `review_files_submission_file_id` (`submission_file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A list of the submission files made available to each assigned reviewer.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_forms`
--

CREATE TABLE `review_forms` (
  `review_form_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `seq` double(8,2) DEFAULT NULL,
  `is_active` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`review_form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Review forms provide custom templates for peer reviews with several types of questions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_form_elements`
--

CREATE TABLE `review_form_elements` (
  `review_form_element_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `review_form_id` bigint(20) NOT NULL,
  `seq` double(8,2) DEFAULT NULL,
  `element_type` bigint(20) DEFAULT NULL,
  `required` smallint(6) DEFAULT NULL,
  `included` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`review_form_element_id`),
  KEY `review_form_elements_review_form_id` (`review_form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Each review form element represents a single question on a review form.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_form_element_settings`
--

CREATE TABLE `review_form_element_settings` (
  `review_form_element_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `review_form_element_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`review_form_element_setting_id`),
  UNIQUE KEY `review_form_element_settings_unique` (`review_form_element_id`,`locale`,`setting_name`),
  KEY `review_form_element_settings_review_form_element_id` (`review_form_element_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about review form elements, including localized content such as question text.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_form_responses`
--

CREATE TABLE `review_form_responses` (
  `review_form_response_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `review_form_element_id` bigint(20) NOT NULL,
  `review_id` bigint(20) NOT NULL,
  `response_type` varchar(6) DEFAULT NULL,
  `response_value` text,
  PRIMARY KEY (`review_form_response_id`),
  KEY `review_form_responses_review_form_element_id` (`review_form_element_id`),
  KEY `review_form_responses_review_id` (`review_id`),
  KEY `review_form_responses_unique` (`review_form_element_id`,`review_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Each review form response records a reviewer''s answer to a review form element associated with a peer review.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_form_settings`
--

CREATE TABLE `review_form_settings` (
  `review_form_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `review_form_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  `setting_type` varchar(6) NOT NULL,
  PRIMARY KEY (`review_form_setting_id`),
  UNIQUE KEY `review_form_settings_unique` (`review_form_id`,`locale`,`setting_name`),
  KEY `review_form_settings_review_form_id` (`review_form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about review forms, including localized content such as names.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_rounds`
--

CREATE TABLE `review_rounds` (
  `review_round_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `stage_id` bigint(20) DEFAULT NULL,
  `round` smallint(6) NOT NULL,
  `review_revision` bigint(20) DEFAULT NULL,
  `status` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`review_round_id`),
  UNIQUE KEY `review_rounds_submission_id_stage_id_round_pkey` (`submission_id`,`stage_id`,`round`),
  KEY `review_rounds_submission_id` (`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Peer review assignments are organized into multiple rounds on a submission.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `review_round_files`
--

CREATE TABLE `review_round_files` (
  `review_round_file_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `review_round_id` bigint(20) NOT NULL,
  `stage_id` smallint(6) NOT NULL,
  `submission_file_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`review_round_file_id`),
  UNIQUE KEY `review_round_files_unique` (`submission_id`,`review_round_id`,`submission_file_id`),
  KEY `review_round_files_submission_id` (`submission_id`),
  KEY `review_round_files_review_round_id` (`review_round_id`),
  KEY `review_round_files_submission_file_id` (`submission_file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Records the files made available to reviewers for a round of reviews. These can be further customized on a per review basis with review_files.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `scheduled_tasks`
--

CREATE TABLE `scheduled_tasks` (
  `scheduled_task_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) NOT NULL,
  `last_run` datetime DEFAULT NULL,
  PRIMARY KEY (`scheduled_task_id`),
  UNIQUE KEY `scheduled_tasks_unique` (`class_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The last time each scheduled task was run.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sections`
--

CREATE TABLE `sections` (
  `section_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `server_id` bigint(20) NOT NULL,
  `review_form_id` bigint(20) DEFAULT NULL,
  `seq` double(8,2) NOT NULL DEFAULT '0.00',
  `editor_restricted` tinyint(4) NOT NULL DEFAULT '0',
  `meta_indexed` tinyint(4) NOT NULL DEFAULT '0',
  `meta_reviewed` tinyint(4) NOT NULL DEFAULT '1',
  `abstracts_not_required` tinyint(4) NOT NULL DEFAULT '0',
  `hide_title` tinyint(4) NOT NULL DEFAULT '0',
  `hide_author` tinyint(4) NOT NULL DEFAULT '0',
  `is_inactive` tinyint(4) NOT NULL DEFAULT '0',
  `abstract_word_count` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`section_id`),
  KEY `sections_server_id` (`server_id`),
  KEY `sections_review_form_id` (`review_form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Submissions can be organized into sections, which determine the front-end presentation and provide options for selective harvesting in the OAI-PMH interface.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `section_settings`
--

CREATE TABLE `section_settings` (
  `section_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `section_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` text,
  PRIMARY KEY (`section_setting_id`),
  UNIQUE KEY `section_settings_unique` (`section_id`,`locale`,`setting_name`),
  KEY `section_settings_section_id` (`section_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about sections, including localized properties such as section titles.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `servers`
--

CREATE TABLE `servers` (
  `server_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `path` varchar(32) NOT NULL,
  `seq` double(8,2) NOT NULL DEFAULT '0.00' COMMENT 'Used to order lists of servers',
  `primary_locale` varchar(14) NOT NULL,
  `enabled` tinyint(4) NOT NULL DEFAULT '1' COMMENT 'Controls whether or not the server is considered "live" and will appear on the website. (Note that disabled servers may still be accessible, but only if the user knows the URL.)',
  PRIMARY KEY (`server_id`),
  UNIQUE KEY `servers_path` (`path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A list of preprint servers managed by the installation.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `server_settings`
--

CREATE TABLE `server_settings` (
  `server_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `server_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` text,
  PRIMARY KEY (`server_setting_id`),
  UNIQUE KEY `server_settings_unique` (`server_id`,`locale`,`setting_name`),
  KEY `server_settings_server_id` (`server_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='More data about server settings, including localized properties such as policies.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sessions`
--

CREATE TABLE `sessions` (
  `session_id` varchar(128) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `ip_address` varchar(39) NOT NULL,
  `user_agent` varchar(255) DEFAULT NULL,
  `created` bigint(20) NOT NULL DEFAULT '0',
  `last_used` bigint(20) NOT NULL DEFAULT '0',
  `remember` smallint(6) NOT NULL DEFAULT '0',
  `data` text NOT NULL,
  `domain` varchar(255) DEFAULT NULL,
  UNIQUE KEY `sessions_pkey` (`session_id`),
  KEY `sessions_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Session data for logged-in users.';

-- --------------------------------------------------------

--
-- Table structure for table `site`
--

CREATE TABLE `site` (
  `site_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `redirect` bigint(20) NOT NULL DEFAULT '0' COMMENT 'If not 0, redirect to the specified journal/conference/... site.',
  `primary_locale` varchar(14) NOT NULL COMMENT 'Primary locale for the site.',
  `min_password_length` smallint(6) NOT NULL DEFAULT '6',
  `installed_locales` varchar(1024) NOT NULL DEFAULT 'en' COMMENT 'Locales for which support has been installed.',
  `supported_locales` varchar(1024) DEFAULT NULL COMMENT 'Locales supported by the site (for hosted journals/conferences/...).',
  `original_style_file_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`site_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='A singleton table describing basic information about the site.' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `site`
--

INSERT INTO `site` VALUES
(1, 0, '[[language]]', 6, '["es","fi","fr_CA","mk","nb","pt_BR","en"]', '["es","fi","fr_CA","mk","nb","pt_BR","en"]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `site_settings`
--

CREATE TABLE `site_settings` (
  `site_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `setting_name` varchar(255) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_value` mediumtext,
  PRIMARY KEY (`site_setting_id`),
  UNIQUE KEY `site_settings_unique` (`setting_name`,`locale`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='More data about the site, including localized properties such as its name.' AUTO_INCREMENT=17 ;

--
-- Dumping data for table `site_settings`
--

INSERT INTO `site_settings` VALUES
(1, 'contactEmail', '[[language]]', '[[admin_email]]'),
(2, 'contactName', 'es', 'Open Preprint Systems'),
(3, 'contactName', 'fi', 'Open Preprint Systems'),
(4, 'contactName', 'fr_CA', 'Open Preprint Systems'),
(5, 'contactName', 'mk', 'Отвори системи за печатење'),
(6, 'contactName', 'nb', '##common.software##'),
(7, 'contactName', 'pt_BR', 'Open Preprint Systems'),
(8, 'contactName', 'en', 'Open Preprint Systems'),
(9, 'compressStatsLogs', '', '0'),
(10, 'enableGeoUsageStats', '', 'disabled'),
(11, 'enableInstitutionUsageStats', '', '0'),
(12, 'keepDailyUsageStats', '', '0'),
(13, 'isSiteSushiPlatform', '', '0'),
(14, 'isSushiApiPublic', '', '1'),
(15, 'disableSharedReviewerStatistics', '', '0'),
(16, 'themePluginPath', '', 'default');

-- --------------------------------------------------------

--
-- Table structure for table `stage_assignments`
--

CREATE TABLE `stage_assignments` (
  `stage_assignment_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `user_group_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `date_assigned` datetime NOT NULL,
  `recommend_only` smallint(6) NOT NULL DEFAULT '0',
  `can_change_metadata` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`stage_assignment_id`),
  UNIQUE KEY `stage_assignment` (`submission_id`,`user_group_id`,`user_id`),
  KEY `stage_assignments_user_group_id` (`user_group_id`),
  KEY `stage_assignments_user_id` (`user_id`),
  KEY `stage_assignments_submission_id` (`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Who can access a submission while it is in the editorial workflow. Includes all editorial and author assignments. For reviewers, see review_assignments.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `subeditor_submission_group`
--

CREATE TABLE `subeditor_submission_group` (
  `subeditor_submission_group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `assoc_type` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `user_group_id` bigint(20) NOT NULL,
  PRIMARY KEY (`subeditor_submission_group_id`),
  UNIQUE KEY `section_editors_unique` (`context_id`,`assoc_id`,`assoc_type`,`user_id`,`user_group_id`),
  KEY `subeditor_submission_group_context_id` (`context_id`),
  KEY `subeditor_submission_group_user_id` (`user_id`),
  KEY `subeditor_submission_group_user_group_id` (`user_group_id`),
  KEY `subeditor_submission_group_assoc_id` (`assoc_id`,`assoc_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Subeditor assignments to e.g. sections and categories' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `submissions`
--

CREATE TABLE `submissions` (
  `submission_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `current_publication_id` bigint(20) DEFAULT NULL,
  `date_last_activity` datetime DEFAULT NULL,
  `date_submitted` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `stage_id` bigint(20) NOT NULL DEFAULT '5',
  `locale` varchar(14) DEFAULT NULL,
  `status` smallint(6) NOT NULL DEFAULT '1',
  `submission_progress` varchar(50) NOT NULL DEFAULT 'start',
  `work_type` smallint(6) DEFAULT '0',
  PRIMARY KEY (`submission_id`),
  KEY `submissions_context_id` (`context_id`),
  KEY `submissions_current_publication_id` (`current_publication_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='All submissions submitted to the context, including incomplete, declined and unpublished submissions.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `submission_comments`
--

CREATE TABLE `submission_comments` (
  `comment_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `comment_type` bigint(20) DEFAULT NULL,
  `role_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `author_id` bigint(20) NOT NULL,
  `comment_title` text NOT NULL,
  `comments` text,
  `date_posted` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `viewable` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`comment_id`),
  KEY `submission_comments_submission_id` (`submission_id`),
  KEY `submission_comments_author_id` (`author_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Comments on a submission, e.g. peer review comments' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `submission_files`
--

CREATE TABLE `submission_files` (
  `submission_file_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `file_id` bigint(20) unsigned NOT NULL,
  `source_submission_file_id` bigint(20) unsigned DEFAULT NULL,
  `genre_id` bigint(20) DEFAULT NULL,
  `file_stage` bigint(20) NOT NULL,
  `direct_sales_price` varchar(255) DEFAULT NULL,
  `sales_type` varchar(255) DEFAULT NULL,
  `viewable` smallint(6) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `uploader_user_id` bigint(20) DEFAULT NULL,
  `assoc_type` bigint(20) DEFAULT NULL,
  `assoc_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`submission_file_id`),
  KEY `submission_files_submission_id` (`submission_id`),
  KEY `submission_files_file_id` (`file_id`),
  KEY `submission_files_genre_id` (`genre_id`),
  KEY `submission_files_uploader_user_id` (`uploader_user_id`),
  KEY `submission_files_stage_assoc` (`file_stage`,`assoc_type`,`assoc_id`),
  KEY `submission_files_source_submission_file_id` (`source_submission_file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='All files associated with a submission, such as those uploaded during submission, as revisions, or by copyeditors or layout editors for production.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `submission_file_revisions`
--

CREATE TABLE `submission_file_revisions` (
  `revision_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_file_id` bigint(20) unsigned NOT NULL,
  `file_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`revision_id`),
  KEY `submission_file_revisions_submission_file_id` (`submission_file_id`),
  KEY `submission_file_revisions_file_id` (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revisions map submission_file entries to files on the data store.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `submission_file_settings`
--

CREATE TABLE `submission_file_settings` (
  `submission_file_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_file_id` bigint(20) unsigned NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`submission_file_setting_id`),
  UNIQUE KEY `submission_file_settings_unique` (`submission_file_id`,`locale`,`setting_name`),
  KEY `submission_file_settings_submission_file_id` (`submission_file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Localized data about submission files like published metadata.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `submission_search_keyword_list`
--

CREATE TABLE `submission_search_keyword_list` (
  `keyword_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `keyword_text` varchar(60) NOT NULL,
  PRIMARY KEY (`keyword_id`),
  UNIQUE KEY `submission_search_keyword_text` (`keyword_text`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A list of all keywords used in the search index' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `submission_search_objects`
--

CREATE TABLE `submission_search_objects` (
  `object_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `type` int(11) NOT NULL COMMENT 'Type of item. E.g., abstract, fulltext, etc.',
  `assoc_id` bigint(20) DEFAULT NULL COMMENT 'Optional ID of an associated record (e.g., a file_id)',
  PRIMARY KEY (`object_id`),
  KEY `submission_search_objects_submission_id` (`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A list of all search objects indexed in the search index' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `submission_search_object_keywords`
--

CREATE TABLE `submission_search_object_keywords` (
  `submission_search_object_keyword_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `object_id` bigint(20) NOT NULL,
  `keyword_id` bigint(20) NOT NULL,
  `pos` int(11) NOT NULL COMMENT 'Word position of the keyword in the object.',
  PRIMARY KEY (`submission_search_object_keyword_id`),
  UNIQUE KEY `submission_search_object_keywords_unique` (`object_id`,`pos`),
  KEY `submission_search_object_keywords_object_id` (`object_id`),
  KEY `submission_search_object_keywords_keyword_id` (`keyword_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Relationships between search objects and keywords in the search index' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `submission_settings`
--

CREATE TABLE `submission_settings` (
  `submission_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`submission_setting_id`),
  UNIQUE KEY `submission_settings_unique` (`submission_id`,`locale`,`setting_name`),
  KEY `submission_settings_submission_id` (`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Localized data about submissions' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `temporary_files`
--

CREATE TABLE `temporary_files` (
  `file_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `file_name` varchar(90) NOT NULL,
  `file_type` varchar(255) DEFAULT NULL,
  `file_size` bigint(20) NOT NULL,
  `original_file_name` varchar(127) DEFAULT NULL,
  `date_uploaded` datetime NOT NULL,
  PRIMARY KEY (`file_id`),
  KEY `temporary_files_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Temporary files, e.g. where files are kept during an upload process before they are moved somewhere more appropriate.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `usage_stats_institution_temporary_records`
--

CREATE TABLE `usage_stats_institution_temporary_records` (
  `usage_stats_temp_institution_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `load_id` varchar(50) NOT NULL,
  `line_number` bigint(20) NOT NULL,
  `institution_id` bigint(20) NOT NULL,
  PRIMARY KEY (`usage_stats_temp_institution_id`),
  UNIQUE KEY `usitr_load_id_line_number_institution_id` (`load_id`,`line_number`,`institution_id`),
  KEY `usi_institution_id` (`institution_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Temporary stats for views and downloads from institutions based on visitor log records. Data in this table is provisional. See the metrics_* tables for compiled stats.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `usage_stats_total_temporary_records`
--

CREATE TABLE `usage_stats_total_temporary_records` (
  `usage_stats_temp_total_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL,
  `ip` varchar(64) NOT NULL,
  `user_agent` varchar(255) NOT NULL,
  `line_number` bigint(20) NOT NULL,
  `canonical_url` varchar(255) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) DEFAULT NULL,
  `representation_id` bigint(20) DEFAULT NULL,
  `submission_file_id` bigint(20) unsigned DEFAULT NULL,
  `assoc_type` bigint(20) NOT NULL,
  `file_type` smallint(6) DEFAULT NULL,
  `country` varchar(2) NOT NULL DEFAULT '',
  `region` varchar(3) NOT NULL DEFAULT '',
  `city` varchar(255) NOT NULL DEFAULT '',
  `load_id` varchar(50) NOT NULL,
  PRIMARY KEY (`usage_stats_temp_total_id`),
  KEY `ust_context_id` (`context_id`),
  KEY `ust_submission_id` (`submission_id`),
  KEY `ust_representation_id` (`representation_id`),
  KEY `ust_submission_file_id` (`submission_file_id`),
  KEY `ust_load_id_context_id_ip_ua_url` (`load_id`,`context_id`,`ip`,`user_agent`,`canonical_url`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Temporary stats totals based on visitor log records. Data in this table is provisional. See the metrics_* tables for compiled stats.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `usage_stats_unique_item_investigations_temporary_records`
--

CREATE TABLE `usage_stats_unique_item_investigations_temporary_records` (
  `usage_stats_temp_unique_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL,
  `ip` varchar(64) NOT NULL,
  `user_agent` varchar(255) NOT NULL,
  `line_number` bigint(20) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `representation_id` bigint(20) DEFAULT NULL,
  `submission_file_id` bigint(20) unsigned DEFAULT NULL,
  `assoc_type` bigint(20) NOT NULL,
  `file_type` smallint(6) DEFAULT NULL,
  `country` varchar(2) NOT NULL DEFAULT '',
  `region` varchar(3) NOT NULL DEFAULT '',
  `city` varchar(255) NOT NULL DEFAULT '',
  `load_id` varchar(50) NOT NULL,
  PRIMARY KEY (`usage_stats_temp_unique_item_id`),
  KEY `usii_context_id` (`context_id`),
  KEY `usii_submission_id` (`submission_id`),
  KEY `usii_representation_id` (`representation_id`),
  KEY `usii_submission_file_id` (`submission_file_id`),
  KEY `usii_load_id_context_id_ip_ua` (`load_id`,`context_id`,`ip`,`user_agent`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Temporary stats on unique downloads based on visitor log records. Data in this table is provisional. See the metrics_* tables for compiled stats.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `usage_stats_unique_item_requests_temporary_records`
--

CREATE TABLE `usage_stats_unique_item_requests_temporary_records` (
  `usage_stats_temp_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL,
  `ip` varchar(64) NOT NULL,
  `user_agent` varchar(255) NOT NULL,
  `line_number` bigint(20) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `submission_id` bigint(20) NOT NULL,
  `representation_id` bigint(20) DEFAULT NULL,
  `submission_file_id` bigint(20) unsigned DEFAULT NULL,
  `assoc_type` bigint(20) NOT NULL,
  `file_type` smallint(6) DEFAULT NULL,
  `country` varchar(2) NOT NULL DEFAULT '',
  `region` varchar(3) NOT NULL DEFAULT '',
  `city` varchar(255) NOT NULL DEFAULT '',
  `load_id` varchar(50) NOT NULL,
  PRIMARY KEY (`usage_stats_temp_item_id`),
  KEY `usir_context_id` (`context_id`),
  KEY `usir_submission_id` (`submission_id`),
  KEY `usir_representation_id` (`representation_id`),
  KEY `usir_submission_file_id` (`submission_file_id`),
  KEY `usir_load_id_context_id_ip_ua` (`load_id`,`context_id`,`ip`,`user_agent`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Temporary stats on unique views based on visitor log records. Data in this table is provisional. See the metrics_* tables for compiled stats.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `user_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `username` varchar(32) NOT NULL,
  `password` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `url` varchar(2047) DEFAULT NULL,
  `phone` varchar(32) DEFAULT NULL,
  `mailing_address` varchar(255) DEFAULT NULL,
  `billing_address` varchar(255) DEFAULT NULL,
  `country` varchar(90) DEFAULT NULL,
  `locales` varchar(255) NOT NULL DEFAULT '[]',
  `gossip` text,
  `date_last_email` datetime DEFAULT NULL,
  `date_registered` datetime NOT NULL,
  `date_validated` datetime DEFAULT NULL,
  `date_last_login` datetime DEFAULT NULL,
  `must_change_password` smallint(6) DEFAULT NULL,
  `auth_id` bigint(20) DEFAULT NULL,
  `auth_str` varchar(255) DEFAULT NULL,
  `disabled` smallint(6) NOT NULL DEFAULT '0',
  `disabled_reason` text,
  `inline_help` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `users_username` (`username`),
  UNIQUE KEY `users_email` (`email`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='All registered users, including authentication data and profile data.' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `users`
--

INSERT INTO `users` VALUES
(1, '[[admin_username]]', '[[admin_pass]]', '[[admin_email]]', NULL, NULL, NULL, NULL, NULL, '[]', NULL, NULL, '[[regtime]]', NULL, NULL, NULL, NULL, NULL, 0, NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `user_groups`
--

CREATE TABLE `user_groups` (
  `user_group_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `role_id` bigint(20) NOT NULL,
  `is_default` smallint(6) NOT NULL DEFAULT '0',
  `show_title` smallint(6) NOT NULL DEFAULT '1',
  `permit_self_registration` smallint(6) NOT NULL DEFAULT '0',
  `permit_metadata_edit` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_group_id`),
  KEY `user_groups_user_group_id` (`user_group_id`),
  KEY `user_groups_context_id` (`context_id`),
  KEY `user_groups_role_id` (`role_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='All defined user roles in a context, such as Author, Reviewer, Section Editor and Journal Manager.' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `user_groups`
--

INSERT INTO `user_groups` VALUES
(1, 0, 1, 1, 1, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `user_group_settings`
--

CREATE TABLE `user_group_settings` (
  `user_group_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_group_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`user_group_setting_id`),
  UNIQUE KEY `user_group_settings_unique` (`user_group_id`,`locale`,`setting_name`),
  KEY `user_group_settings_user_group_id` (`user_group_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='More data about user groups, including localized properties such as the name.' AUTO_INCREMENT=8 ;

--
-- Dumping data for table `user_group_settings`
--

INSERT INTO `user_group_settings` VALUES
(1, 1, 'es', 'name', 'Administrador/a del sitio'),
(2, 1, 'fi', 'name', 'Sivuston ylläpitäjä'),
(3, 1, 'fr_CA', 'name', 'Administrateur-trice du site'),
(4, 1, 'mk', 'name', 'Администратор на сајтот'),
(5, 1, 'nb', 'name', 'Administrator'),
(6, 1, 'pt_BR', 'name', 'Administrador do site'),
(7, 1, 'en', 'name', 'Site Admin');

-- --------------------------------------------------------

--
-- Table structure for table `user_group_stage`
--

CREATE TABLE `user_group_stage` (
  `user_group_stage_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `user_group_id` bigint(20) NOT NULL,
  `stage_id` bigint(20) NOT NULL,
  PRIMARY KEY (`user_group_stage_id`),
  UNIQUE KEY `user_group_stage_unique` (`context_id`,`user_group_id`,`stage_id`),
  KEY `user_group_stage_context_id` (`context_id`),
  KEY `user_group_stage_user_group_id` (`user_group_id`),
  KEY `user_group_stage_stage_id` (`stage_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Which stages of the editorial workflow the user_groups can access.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_interests`
--

CREATE TABLE `user_interests` (
  `user_interest_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `controlled_vocab_entry_id` bigint(20) NOT NULL,
  PRIMARY KEY (`user_interest_id`),
  UNIQUE KEY `u_e_pkey` (`user_id`,`controlled_vocab_entry_id`),
  KEY `user_interests_user_id` (`user_id`),
  KEY `user_interests_controlled_vocab_entry_id` (`controlled_vocab_entry_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Associates users with user interests (which are stored in the controlled vocabulary tables).' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_settings`
--

CREATE TABLE `user_settings` (
  `user_setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` mediumtext,
  PRIMARY KEY (`user_setting_id`),
  UNIQUE KEY `user_settings_unique` (`user_id`,`locale`,`setting_name`),
  KEY `user_settings_user_id` (`user_id`),
  KEY `user_settings_locale_setting_name_index` (`setting_name`,`locale`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='More data about users, including localized properties like their name and affiliation.' AUTO_INCREMENT=3 ;

--
-- Dumping data for table `user_settings`
--

INSERT INTO `user_settings` VALUES
(1, 1, '[[language]]', 'familyName', '[[admin_username]]'),
(2, 1, '[[language]]', 'givenName', '[[admin_username]]');

-- --------------------------------------------------------

--
-- Table structure for table `user_user_groups`
--

CREATE TABLE `user_user_groups` (
  `user_user_group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_group_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  PRIMARY KEY (`user_user_group_id`),
  UNIQUE KEY `user_user_groups_unique` (`user_group_id`,`user_id`),
  KEY `user_user_groups_user_group_id` (`user_group_id`),
  KEY `user_user_groups_user_id` (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Maps users to their assigned user_groups.' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `user_user_groups`
--

INSERT INTO `user_user_groups` VALUES
(1, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `versions`
--

CREATE TABLE `versions` (
  `version_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `major` int(11) NOT NULL DEFAULT '0' COMMENT 'Major component of version number, e.g. the 2 in OJS 2.3.8-0',
  `minor` int(11) NOT NULL DEFAULT '0' COMMENT 'Minor component of version number, e.g. the 3 in OJS 2.3.8-0',
  `revision` int(11) NOT NULL DEFAULT '0' COMMENT 'Revision component of version number, e.g. the 8 in OJS 2.3.8-0',
  `build` int(11) NOT NULL DEFAULT '0' COMMENT 'Build component of version number, e.g. the 0 in OJS 2.3.8-0',
  `date_installed` datetime NOT NULL,
  `current` smallint(6) NOT NULL DEFAULT '0' COMMENT '1 iff the version entry being described is currently active. This permits the table to store past installation history for forensic purposes.',
  `product_type` varchar(30) DEFAULT NULL COMMENT 'Describes the type of product this row describes, e.g. "plugins.generic" (for a generic plugin) or "core" for the application itself',
  `product` varchar(30) DEFAULT NULL COMMENT 'Uniquely identifies the product this version row describes, e.g. "ojs2" for OJS 2.x, "languageToggle" for the language toggle block plugin, etc.',
  `product_class_name` varchar(80) DEFAULT NULL COMMENT 'Specifies the class name associated with this product, for plugins, or the empty string where not applicable.',
  `lazy_load` smallint(6) NOT NULL DEFAULT '0' COMMENT '1 iff the row describes a lazy-load plugin; 0 otherwise',
  `sitewide` smallint(6) NOT NULL DEFAULT '0' COMMENT '1 iff the row describes a site-wide plugin; 0 otherwise',
  PRIMARY KEY (`version_id`),
  UNIQUE KEY `versions_unique` (`product_type`,`product`,`major`,`minor`,`revision`,`build`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Describes the installation and upgrade version history for the application and all installed plugins.' AUTO_INCREMENT=20 ;

--
-- Dumping data for table `versions`
--

INSERT INTO `versions` VALUES
(1, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.metadata', 'dc11', '', 0, 0),
(2, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.blocks', 'languageToggle', 'LanguageToggleBlockPlugin', 1, 0),
(3, 1, 0, 1, 0, '[[regtime]]', 1, 'plugins.blocks', 'browse', 'BrowseBlockPlugin', 1, 0),
(4, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.blocks', 'developedBy', 'DevelopedByBlockPlugin', 1, 0),
(5, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.generic', 'webFeed', 'WebFeedPlugin', 1, 0),
(6, 0, 1, 0, 0, '[[regtime]]', 1, 'plugins.generic', 'citationStyleLanguage', 'CitationStyleLanguagePlugin', 1, 0),
(7, 1, 0, 1, 0, '[[regtime]]', 1, 'plugins.generic', 'pdfJsViewer', 'PdfJsViewerPlugin', 1, 0),
(8, 1, 3, 0, 0, '[[regtime]]', 1, 'plugins.generic', 'acron', 'AcronPlugin', 1, 1),
(9, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.generic', 'tinymce', 'TinyMCEPlugin', 1, 0),
(10, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.generic', 'googleAnalytics', 'GoogleAnalyticsPlugin', 1, 0),
(11, 1, 3, 4, 8, '[[regtime]]', 1, 'plugins.generic', 'orcidProfile', 'OrcidProfilePlugin', 1, 0),
(12, 1, 1, 0, 0, '[[regtime]]', 1, 'plugins.generic', 'googleScholar', 'GoogleScholarPlugin', 1, 0),
(13, 1, 2, 0, 0, '[[regtime]]', 1, 'plugins.generic', 'customBlockManager', 'CustomBlockManagerPlugin', 1, 0),
(14, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.generic', 'usageEvent', '', 0, 0),
(15, 2, 2, 0, 0, '[[regtime]]', 1, 'plugins.generic', 'crossref', '', 0, 0),
(16, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.importexport', 'native', '', 0, 0),
(17, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.oaiMetadataFormats', 'dc', '', 0, 0),
(18, 1, 0, 0, 0, '[[regtime]]', 1, 'plugins.themes', 'default', 'DefaultThemePlugin', 1, 0),
(19, 3, 4, 0, 9, '[[regtime]]', 1, 'core', 'ops', '', 0, 1);

--
-- Constraints for dumped tables
--

--
-- Constraints for table `access_keys`
--
ALTER TABLE `access_keys`
  ADD CONSTRAINT `access_keys_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `announcements`
--
ALTER TABLE `announcements`
  ADD CONSTRAINT `announcements_type_id_foreign` FOREIGN KEY (`type_id`) REFERENCES `announcement_types` (`type_id`) ON DELETE SET NULL;

--
-- Constraints for table `announcement_settings`
--
ALTER TABLE `announcement_settings`
  ADD CONSTRAINT `announcement_settings_announcement_id_foreign` FOREIGN KEY (`announcement_id`) REFERENCES `announcements` (`announcement_id`) ON DELETE CASCADE;

--
-- Constraints for table `announcement_types`
--
ALTER TABLE `announcement_types`
  ADD CONSTRAINT `announcement_types_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `servers` (`server_id`) ON DELETE CASCADE;

--
-- Constraints for table `announcement_type_settings`
--
ALTER TABLE `announcement_type_settings`
  ADD CONSTRAINT `announcement_type_settings_type_id_foreign` FOREIGN KEY (`type_id`) REFERENCES `announcement_types` (`type_id`) ON DELETE CASCADE;

--
-- Constraints for table `authors`
--
ALTER TABLE `authors`
  ADD CONSTRAINT `authors_publication_id` FOREIGN KEY (`publication_id`) REFERENCES `publications` (`publication_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `authors_user_group_id_foreign` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`user_group_id`) ON DELETE CASCADE;

--
-- Constraints for table `author_settings`
--
ALTER TABLE `author_settings`
  ADD CONSTRAINT `author_settings_author_id` FOREIGN KEY (`author_id`) REFERENCES `authors` (`author_id`) ON DELETE CASCADE;

--
-- Constraints for table `categories`
--
ALTER TABLE `categories`
  ADD CONSTRAINT `categories_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `servers` (`server_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `categories_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `categories` (`category_id`) ON DELETE SET NULL;

--
-- Constraints for table `category_settings`
--
ALTER TABLE `category_settings`
  ADD CONSTRAINT `category_settings_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`category_id`) ON DELETE CASCADE;

--
-- Constraints for table `citations`
--
ALTER TABLE `citations`
  ADD CONSTRAINT `citations_publication` FOREIGN KEY (`publication_id`) REFERENCES `publications` (`publication_id`) ON DELETE CASCADE;

--
-- Constraints for table `citation_settings`
--
ALTER TABLE `citation_settings`
  ADD CONSTRAINT `citation_settings_citation_id` FOREIGN KEY (`citation_id`) REFERENCES `citations` (`citation_id`) ON DELETE CASCADE;

--
-- Constraints for table `controlled_vocab_entries`
--
ALTER TABLE `controlled_vocab_entries`
  ADD CONSTRAINT `controlled_vocab_entries_controlled_vocab_id_foreign` FOREIGN KEY (`controlled_vocab_id`) REFERENCES `controlled_vocabs` (`controlled_vocab_id`) ON DELETE CASCADE;

--
-- Constraints for table `controlled_vocab_entry_settings`
--
ALTER TABLE `controlled_vocab_entry_settings`
  ADD CONSTRAINT `c_v_e_s_entry_id` FOREIGN KEY (`controlled_vocab_entry_id`) REFERENCES `controlled_vocab_entries` (`controlled_vocab_entry_id`) ON DELETE CASCADE;

--
-- Constraints for table `data_object_tombstone_oai_set_objects`
--
ALTER TABLE `data_object_tombstone_oai_set_objects`
  ADD CONSTRAINT `data_object_tombstone_oai_set_objects_tombstone_id` FOREIGN KEY (`tombstone_id`) REFERENCES `data_object_tombstones` (`tombstone_id`) ON DELETE CASCADE;

--
-- Constraints for table `data_object_tombstone_settings`
--
ALTER TABLE `data_object_tombstone_settings`
  ADD CONSTRAINT `data_object_tombstone_settings_tombstone_id` FOREIGN KEY (`tombstone_id`) REFERENCES `data_object_tombstones` (`tombstone_id`) ON DELETE CASCADE;

--
-- Constraints for table `dois`
--
ALTER TABLE `dois`
  ADD CONSTRAINT `dois_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `servers` (`server_id`) ON DELETE CASCADE;

--
-- Constraints for table `doi_settings`
--
ALTER TABLE `doi_settings`
  ADD CONSTRAINT `doi_settings_doi_id_foreign` FOREIGN KEY (`doi_id`) REFERENCES `dois` (`doi_id`) ON DELETE CASCADE;

--
-- Constraints for table `edit_decisions`
--
ALTER TABLE `edit_decisions`
  ADD CONSTRAINT `edit_decisions_editor_id` FOREIGN KEY (`editor_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `edit_decisions_review_round_id_foreign` FOREIGN KEY (`review_round_id`) REFERENCES `review_rounds` (`review_round_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `edit_decisions_submission_id` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `email_log_users`
--
ALTER TABLE `email_log_users`
  ADD CONSTRAINT `email_log_users_email_log_id_foreign` FOREIGN KEY (`email_log_id`) REFERENCES `email_log` (`log_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `email_log_users_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `email_templates`
--
ALTER TABLE `email_templates`
  ADD CONSTRAINT `email_templates_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `servers` (`server_id`) ON DELETE CASCADE;

--
-- Constraints for table `email_templates_settings`
--
ALTER TABLE `email_templates_settings`
  ADD CONSTRAINT `email_templates_settings_email_id` FOREIGN KEY (`email_id`) REFERENCES `email_templates` (`email_id`) ON DELETE CASCADE;

--
-- Constraints for table `event_log`
--
ALTER TABLE `event_log`
  ADD CONSTRAINT `event_log_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `event_log_settings`
--
ALTER TABLE `event_log_settings`
  ADD CONSTRAINT `event_log_settings_log_id` FOREIGN KEY (`log_id`) REFERENCES `event_log` (`log_id`) ON DELETE CASCADE;

--
-- Constraints for table `filters`
--
ALTER TABLE `filters`
  ADD CONSTRAINT `filters_filter_group_id_foreign` FOREIGN KEY (`filter_group_id`) REFERENCES `filter_groups` (`filter_group_id`) ON DELETE CASCADE;

--
-- Constraints for table `filter_settings`
--
ALTER TABLE `filter_settings`
  ADD CONSTRAINT `filter_settings_filter_id_foreign` FOREIGN KEY (`filter_id`) REFERENCES `filters` (`filter_id`) ON DELETE CASCADE;

--
-- Constraints for table `genres`
--
ALTER TABLE `genres`
  ADD CONSTRAINT `genres_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `servers` (`server_id`) ON DELETE CASCADE;

--
-- Constraints for table `genre_settings`
--
ALTER TABLE `genre_settings`
  ADD CONSTRAINT `genre_settings_genre_id_foreign` FOREIGN KEY (`genre_id`) REFERENCES `genres` (`genre_id`) ON DELETE CASCADE;

--
-- Constraints for table `institutions`
--
ALTER TABLE `institutions`
  ADD CONSTRAINT `institutions_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `servers` (`server_id`) ON DELETE CASCADE;

--
-- Constraints for table `institution_ip`
--
ALTER TABLE `institution_ip`
  ADD CONSTRAINT `institution_ip_institution_id_foreign` FOREIGN KEY (`institution_id`) REFERENCES `institutions` (`institution_id`) ON DELETE CASCADE;

--
-- Constraints for table `institution_settings`
--
ALTER TABLE `institution_settings`
  ADD CONSTRAINT `institution_settings_institution_id_foreign` FOREIGN KEY (`institution_id`) REFERENCES `institutions` (`institution_id`) ON DELETE CASCADE;

--
-- Constraints for table `library_files`
--
ALTER TABLE `library_files`
  ADD CONSTRAINT `library_files_context_id` FOREIGN KEY (`context_id`) REFERENCES `servers` (`server_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `library_files_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `library_file_settings`
--
ALTER TABLE `library_file_settings`
  ADD CONSTRAINT `library_file_settings_file_id_foreign` FOREIGN KEY (`file_id`) REFERENCES `library_files` (`file_id`) ON DELETE CASCADE;

--
-- Constraints for table `metrics_context`
--
ALTER TABLE `metrics_context`
  ADD CONSTRAINT `metrics_context_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `servers` (`server_id`) ON DELETE CASCADE;

--
-- Constraints for table `metrics_counter_submission_daily`
--
ALTER TABLE `metrics_counter_submission_daily`
  ADD CONSTRAINT `msd_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `servers` (`server_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `msd_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `metrics_counter_submission_institution_daily`
--
ALTER TABLE `metrics_counter_submission_institution_daily`
  ADD CONSTRAINT `msid_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `servers` (`server_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `msid_institution_id_foreign` FOREIGN KEY (`institution_id`) REFERENCES `institutions` (`institution_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `msid_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `metrics_counter_submission_institution_monthly`
--
ALTER TABLE `metrics_counter_submission_institution_monthly`
  ADD CONSTRAINT `msim_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `servers` (`server_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `msim_institution_id_foreign` FOREIGN KEY (`institution_id`) REFERENCES `institutions` (`institution_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `msim_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `metrics_counter_submission_monthly`
--
ALTER TABLE `metrics_counter_submission_monthly`
  ADD CONSTRAINT `msm_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `servers` (`server_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `msm_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `metrics_submission`
--
ALTER TABLE `metrics_submission`
  ADD CONSTRAINT `metrics_submission_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `servers` (`server_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `metrics_submission_representation_id_foreign` FOREIGN KEY (`representation_id`) REFERENCES `publication_galleys` (`galley_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `metrics_submission_submission_file_id_foreign` FOREIGN KEY (`submission_file_id`) REFERENCES `submission_files` (`submission_file_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `metrics_submission_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `metrics_submission_geo_daily`
--
ALTER TABLE `metrics_submission_geo_daily`
  ADD CONSTRAINT `msgd_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `servers` (`server_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `msgd_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `metrics_submission_geo_monthly`
--
ALTER TABLE `metrics_submission_geo_monthly`
  ADD CONSTRAINT `msgm_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `servers` (`server_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `msgm_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `navigation_menu_item_assignments`
--
ALTER TABLE `navigation_menu_item_assignments`
  ADD CONSTRAINT `navigation_menu_item_assignments_navigation_menu_id_foreign` FOREIGN KEY (`navigation_menu_id`) REFERENCES `navigation_menus` (`navigation_menu_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `navigation_menu_item_assignments_navigation_menu_item_id_foreign` FOREIGN KEY (`navigation_menu_item_id`) REFERENCES `navigation_menu_items` (`navigation_menu_item_id`) ON DELETE CASCADE;

--
-- Constraints for table `navigation_menu_item_assignment_settings`
--
ALTER TABLE `navigation_menu_item_assignment_settings`
  ADD CONSTRAINT `assignment_settings_navigation_menu_item_assignment_id` FOREIGN KEY (`navigation_menu_item_assignment_id`) REFERENCES `navigation_menu_item_assignments` (`navigation_menu_item_assignment_id`) ON DELETE CASCADE;

--
-- Constraints for table `navigation_menu_item_settings`
--
ALTER TABLE `navigation_menu_item_settings`
  ADD CONSTRAINT `navigation_menu_item_settings_navigation_menu_id` FOREIGN KEY (`navigation_menu_item_id`) REFERENCES `navigation_menu_items` (`navigation_menu_item_id`) ON DELETE CASCADE;

--
-- Constraints for table `notes`
--
ALTER TABLE `notes`
  ADD CONSTRAINT `notes_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `notifications`
--
ALTER TABLE `notifications`
  ADD CONSTRAINT `notifications_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `servers` (`server_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `notifications_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `notification_settings`
--
ALTER TABLE `notification_settings`
  ADD CONSTRAINT `notification_settings_notification_id_foreign` FOREIGN KEY (`notification_id`) REFERENCES `notifications` (`notification_id`) ON DELETE CASCADE;

--
-- Constraints for table `notification_subscription_settings`
--
ALTER TABLE `notification_subscription_settings`
  ADD CONSTRAINT `notification_subscription_settings_context_foreign` FOREIGN KEY (`context`) REFERENCES `servers` (`server_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `notification_subscription_settings_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `publications`
--
ALTER TABLE `publications`
  ADD CONSTRAINT `publications_author_id` FOREIGN KEY (`primary_contact_id`) REFERENCES `authors` (`author_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `publications_doi_id_foreign` FOREIGN KEY (`doi_id`) REFERENCES `dois` (`doi_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `publications_section_id_foreign` FOREIGN KEY (`section_id`) REFERENCES `sections` (`section_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `publications_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `publication_categories`
--
ALTER TABLE `publication_categories`
  ADD CONSTRAINT `publication_categories_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`category_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `publication_categories_publication_id_foreign` FOREIGN KEY (`publication_id`) REFERENCES `publications` (`publication_id`) ON DELETE CASCADE;

--
-- Constraints for table `publication_galleys`
--
ALTER TABLE `publication_galleys`
  ADD CONSTRAINT `publication_galleys_doi_id_foreign` FOREIGN KEY (`doi_id`) REFERENCES `dois` (`doi_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `publication_galleys_publication_id` FOREIGN KEY (`publication_id`) REFERENCES `publications` (`publication_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `publication_galleys_submission_file_id_foreign` FOREIGN KEY (`submission_file_id`) REFERENCES `submission_files` (`submission_file_id`) ON DELETE SET NULL;

--
-- Constraints for table `publication_galley_settings`
--
ALTER TABLE `publication_galley_settings`
  ADD CONSTRAINT `publication_galley_settings_galley_id_foreign` FOREIGN KEY (`galley_id`) REFERENCES `publication_galleys` (`galley_id`);

--
-- Constraints for table `publication_settings`
--
ALTER TABLE `publication_settings`
  ADD CONSTRAINT `publication_settings_publication_id` FOREIGN KEY (`publication_id`) REFERENCES `publications` (`publication_id`) ON DELETE CASCADE;

--
-- Constraints for table `query_participants`
--
ALTER TABLE `query_participants`
  ADD CONSTRAINT `query_participants_query_id_foreign` FOREIGN KEY (`query_id`) REFERENCES `queries` (`query_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `query_participants_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `review_assignments`
--
ALTER TABLE `review_assignments`
  ADD CONSTRAINT `review_assignments_review_form_id_foreign` FOREIGN KEY (`review_form_id`) REFERENCES `review_forms` (`review_form_id`),
  ADD CONSTRAINT `review_assignments_review_round_id_foreign` FOREIGN KEY (`review_round_id`) REFERENCES `review_rounds` (`review_round_id`),
  ADD CONSTRAINT `review_assignments_reviewer_id_foreign` FOREIGN KEY (`reviewer_id`) REFERENCES `users` (`user_id`),
  ADD CONSTRAINT `review_assignments_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`);

--
-- Constraints for table `review_files`
--
ALTER TABLE `review_files`
  ADD CONSTRAINT `review_files_review_id_foreign` FOREIGN KEY (`review_id`) REFERENCES `review_assignments` (`review_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `review_files_submission_file_id_foreign` FOREIGN KEY (`submission_file_id`) REFERENCES `submission_files` (`submission_file_id`) ON DELETE CASCADE;

--
-- Constraints for table `review_form_elements`
--
ALTER TABLE `review_form_elements`
  ADD CONSTRAINT `review_form_elements_review_form_id` FOREIGN KEY (`review_form_id`) REFERENCES `review_forms` (`review_form_id`) ON DELETE CASCADE;

--
-- Constraints for table `review_form_element_settings`
--
ALTER TABLE `review_form_element_settings`
  ADD CONSTRAINT `review_form_element_settings_review_form_element_id` FOREIGN KEY (`review_form_element_id`) REFERENCES `review_form_elements` (`review_form_element_id`) ON DELETE CASCADE;

--
-- Constraints for table `review_form_responses`
--
ALTER TABLE `review_form_responses`
  ADD CONSTRAINT `review_form_responses_review_form_element_id_foreign` FOREIGN KEY (`review_form_element_id`) REFERENCES `review_form_elements` (`review_form_element_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `review_form_responses_review_id_foreign` FOREIGN KEY (`review_id`) REFERENCES `review_assignments` (`review_id`) ON DELETE CASCADE;

--
-- Constraints for table `review_form_settings`
--
ALTER TABLE `review_form_settings`
  ADD CONSTRAINT `review_form_settings_review_form_id` FOREIGN KEY (`review_form_id`) REFERENCES `review_forms` (`review_form_id`) ON DELETE CASCADE;

--
-- Constraints for table `review_rounds`
--
ALTER TABLE `review_rounds`
  ADD CONSTRAINT `review_rounds_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`);

--
-- Constraints for table `review_round_files`
--
ALTER TABLE `review_round_files`
  ADD CONSTRAINT `review_round_files_review_round_id_foreign` FOREIGN KEY (`review_round_id`) REFERENCES `review_rounds` (`review_round_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `review_round_files_submission_file_id_foreign` FOREIGN KEY (`submission_file_id`) REFERENCES `submission_files` (`submission_file_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `review_round_files_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `sections`
--
ALTER TABLE `sections`
  ADD CONSTRAINT `sections_review_form_id_foreign` FOREIGN KEY (`review_form_id`) REFERENCES `review_forms` (`review_form_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `sections_server_id_foreign` FOREIGN KEY (`server_id`) REFERENCES `servers` (`server_id`) ON DELETE CASCADE;

--
-- Constraints for table `section_settings`
--
ALTER TABLE `section_settings`
  ADD CONSTRAINT `section_settings_section_id_foreign` FOREIGN KEY (`section_id`) REFERENCES `sections` (`section_id`) ON DELETE CASCADE;

--
-- Constraints for table `server_settings`
--
ALTER TABLE `server_settings`
  ADD CONSTRAINT `server_settings_server_id` FOREIGN KEY (`server_id`) REFERENCES `servers` (`server_id`) ON DELETE CASCADE;

--
-- Constraints for table `sessions`
--
ALTER TABLE `sessions`
  ADD CONSTRAINT `sessions_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `stage_assignments`
--
ALTER TABLE `stage_assignments`
  ADD CONSTRAINT `stage_assignments_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `stage_assignments_user_group_id` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`user_group_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `stage_assignments_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `subeditor_submission_group`
--
ALTER TABLE `subeditor_submission_group`
  ADD CONSTRAINT `section_editors_context_id` FOREIGN KEY (`context_id`) REFERENCES `servers` (`server_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `subeditor_submission_group_user_group_id_foreign` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`user_group_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `subeditor_submission_group_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `submissions`
--
ALTER TABLE `submissions`
  ADD CONSTRAINT `submissions_context_id` FOREIGN KEY (`context_id`) REFERENCES `servers` (`server_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `submissions_current_publication_id` FOREIGN KEY (`current_publication_id`) REFERENCES `publications` (`publication_id`) ON DELETE SET NULL;

--
-- Constraints for table `submission_comments`
--
ALTER TABLE `submission_comments`
  ADD CONSTRAINT `submission_comments_author_id_foreign` FOREIGN KEY (`author_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `submission_comments_submission_id` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `submission_files`
--
ALTER TABLE `submission_files`
  ADD CONSTRAINT `submission_files_file_id_foreign` FOREIGN KEY (`file_id`) REFERENCES `files` (`file_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `submission_files_genre_id_foreign` FOREIGN KEY (`genre_id`) REFERENCES `genres` (`genre_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `submission_files_source_submission_file_id_foreign` FOREIGN KEY (`source_submission_file_id`) REFERENCES `submission_files` (`submission_file_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `submission_files_submission_id` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `submission_files_uploader_user_id_foreign` FOREIGN KEY (`uploader_user_id`) REFERENCES `users` (`user_id`) ON DELETE SET NULL;

--
-- Constraints for table `submission_file_revisions`
--
ALTER TABLE `submission_file_revisions`
  ADD CONSTRAINT `submission_file_revisions_file_id_foreign` FOREIGN KEY (`file_id`) REFERENCES `files` (`file_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `submission_file_revisions_submission_file_id_foreign` FOREIGN KEY (`submission_file_id`) REFERENCES `submission_files` (`submission_file_id`) ON DELETE CASCADE;

--
-- Constraints for table `submission_file_settings`
--
ALTER TABLE `submission_file_settings`
  ADD CONSTRAINT `submission_file_settings_submission_file_id_foreign` FOREIGN KEY (`submission_file_id`) REFERENCES `submission_files` (`submission_file_id`) ON DELETE CASCADE;

--
-- Constraints for table `submission_search_objects`
--
ALTER TABLE `submission_search_objects`
  ADD CONSTRAINT `submission_search_object_submission` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `submission_search_object_keywords`
--
ALTER TABLE `submission_search_object_keywords`
  ADD CONSTRAINT `submission_search_object_keywords_keyword_id` FOREIGN KEY (`keyword_id`) REFERENCES `submission_search_keyword_list` (`keyword_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `submission_search_object_keywords_object_id_foreign` FOREIGN KEY (`object_id`) REFERENCES `submission_search_objects` (`object_id`) ON DELETE CASCADE;

--
-- Constraints for table `submission_settings`
--
ALTER TABLE `submission_settings`
  ADD CONSTRAINT `submission_settings_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `temporary_files`
--
ALTER TABLE `temporary_files`
  ADD CONSTRAINT `temporary_files_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `usage_stats_institution_temporary_records`
--
ALTER TABLE `usage_stats_institution_temporary_records`
  ADD CONSTRAINT `usi_institution_id_foreign` FOREIGN KEY (`institution_id`) REFERENCES `institutions` (`institution_id`) ON DELETE CASCADE;

--
-- Constraints for table `usage_stats_total_temporary_records`
--
ALTER TABLE `usage_stats_total_temporary_records`
  ADD CONSTRAINT `ust_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `servers` (`server_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `ust_representation_id_foreign` FOREIGN KEY (`representation_id`) REFERENCES `publication_galleys` (`galley_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `ust_submission_file_id_foreign` FOREIGN KEY (`submission_file_id`) REFERENCES `submission_files` (`submission_file_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `ust_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `usage_stats_unique_item_investigations_temporary_records`
--
ALTER TABLE `usage_stats_unique_item_investigations_temporary_records`
  ADD CONSTRAINT `usii_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `servers` (`server_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `usii_representation_id_foreign` FOREIGN KEY (`representation_id`) REFERENCES `publication_galleys` (`galley_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `usii_submission_file_id_foreign` FOREIGN KEY (`submission_file_id`) REFERENCES `submission_files` (`submission_file_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `usii_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `usage_stats_unique_item_requests_temporary_records`
--
ALTER TABLE `usage_stats_unique_item_requests_temporary_records`
  ADD CONSTRAINT `usir_context_id_foreign` FOREIGN KEY (`context_id`) REFERENCES `servers` (`server_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `usir_representation_id_foreign` FOREIGN KEY (`representation_id`) REFERENCES `publication_galleys` (`galley_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `usir_submission_file_id_foreign` FOREIGN KEY (`submission_file_id`) REFERENCES `submission_files` (`submission_file_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `usir_submission_id_foreign` FOREIGN KEY (`submission_id`) REFERENCES `submissions` (`submission_id`) ON DELETE CASCADE;

--
-- Constraints for table `user_group_settings`
--
ALTER TABLE `user_group_settings`
  ADD CONSTRAINT `user_group_settings_user_group_id_foreign` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`user_group_id`) ON DELETE CASCADE;

--
-- Constraints for table `user_group_stage`
--
ALTER TABLE `user_group_stage`
  ADD CONSTRAINT `user_group_stage_context_id` FOREIGN KEY (`context_id`) REFERENCES `servers` (`server_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `user_group_stage_user_group_id` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`user_group_id`) ON DELETE CASCADE;

--
-- Constraints for table `user_interests`
--
ALTER TABLE `user_interests`
  ADD CONSTRAINT `user_interests_controlled_vocab_entry_id_foreign` FOREIGN KEY (`controlled_vocab_entry_id`) REFERENCES `controlled_vocab_entries` (`controlled_vocab_entry_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `user_interests_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `user_settings`
--
ALTER TABLE `user_settings`
  ADD CONSTRAINT `user_settings_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE;

--
-- Constraints for table `user_user_groups`
--
ALTER TABLE `user_user_groups`
  ADD CONSTRAINT `user_user_groups_user_group_id_foreign` FOREIGN KEY (`user_group_id`) REFERENCES `user_groups` (`user_group_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `user_user_groups_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
