<?php
/**
 * This file is part of osCommerce ecommerce platform.
 * osCommerce the ecommerce
 *
 * @link https://www.oscommerce.com
 * @copyright Copyright (c) 2000-2022 osCommerce LTD
 *
 * Released under the GNU General Public License
 * For the full copyright and license information, please view the LICENSE.TXT file that was distributed with this source code.
 */

namespace backend\design\boxes;

use Yii;
use yii\base\Widget;

class Bestsellers extends Widget
{

    public $id;
    public $params;
    public $settings;
    public $visibility;

    public function init()
    {
        parent::init();
    }

    public function run()
    {
        \common\helpers\Translation::init('admin/categories');
        return $this->render('bestsellers.tpl', [
            'id' => $this->id, 'params' => $this->params, 'settings' => $this->settings,
            'visibility' => $this->visibility,
            'categories' => \common\helpers\Categories::get_category_tree(),
        ]);
    }
}