<?php
namespace FedEx\AsyncService\SimpleType;

use FedEx\AbstractSimpleType;

/**
 * Identifies the type of artifact created.
 *
 * @author      Jeremy Dunn <jeremy@jsdunn.info>
 * @package     PHP FedEx API wrapper
 * @subpackage  ASync Service
 */
class ArtifactType extends AbstractSimpleType
{
    const _AUXILIARY_LABEL = 'AUXILIARY_LABEL';
    const _CERTIFICATE_OF_ORIGIN = 'CERTIFICATE_OF_ORIGIN';
    const _COD_RETURN_LABEL = 'COD_RETURN_LABEL';
    const _COMMERCIAL_INVOICE = 'COMMERCIAL_INVOICE';
    const _COMMODITIES_BY_TRACKING_NUMBER_REPORT = 'COMMODITIES_BY_TRACKING_NUMBER_REPORT';
    const _CONDENSED_CRN_REPORT = 'CONDENSED_CRN_REPORT';
    const _CONSOLIDATED_COMMERCIAL_INVOICE = 'CONSOLIDATED_COMMERCIAL_INVOICE';
    const _CONSOLIDATED_CUSTOMS_LINEHAUL_REPORT = 'CONSOLIDATED_CUSTOMS_LINEHAUL_REPORT';
    const _CONSOLIDATED_SOLD_TO_SUMMARY_REPORT = 'CONSOLIDATED_SOLD_TO_SUMMARY_REPORT';
    const _CRN_REPORT = 'CRN_REPORT';
    const _CUSTOMS_PACKING_LIST = 'CUSTOMS_PACKING_LIST';
    const _CUSTOM_CONSOLIDATION_DOCUMENT = 'CUSTOM_CONSOLIDATION_DOCUMENT';
    const _CUSTOM_PACKAGE_DOCUMENT = 'CUSTOM_PACKAGE_DOCUMENT';
    const _CUSTOM_SHIPMENT_DOCUMENT = 'CUSTOM_SHIPMENT_DOCUMENT';
    const _DANGEROUS_GOODS_SHIPPERS_DECLARATION = 'DANGEROUS_GOODS_SHIPPERS_DECLARATION';
    const _DELIVERY_ON_INVOICE_ACCEPTANCE_RETURN_LABEL = 'DELIVERY_ON_INVOICE_ACCEPTANCE_RETURN_LABEL';
    const _FREIGHT_ADDRESS_LABEL = 'FREIGHT_ADDRESS_LABEL';
    const _GENERAL_AGENCY_AGREEMENT = 'GENERAL_AGENCY_AGREEMENT';
    const _LOW_CUSTOMS_VALUE_EXCEPTION_PARTY_REPORT = 'LOW_CUSTOMS_VALUE_EXCEPTION_PARTY_REPORT';
    const _NAFTA_CERTIFICATE_OF_ORIGIN = 'NAFTA_CERTIFICATE_OF_ORIGIN';
    const _OP_900 = 'OP_900';
    const _OUTBOUND_LABEL = 'OUTBOUND_LABEL';
    const _PRO_FORMA_INVOICE = 'PRO_FORMA_INVOICE';
    const _RETURN_INSTRUCTIONS = 'RETURN_INSTRUCTIONS';
    const _SERVICE_REPLY = 'SERVICE_REPLY';
    const _SERVICE_REQUEST = 'SERVICE_REQUEST';
    const _STANDARD_BROKER_CLEARANCE_PARTY_REPORT = 'STANDARD_BROKER_CLEARANCE_PARTY_REPORT';
    const _TERMS_AND_CONDITIONS = 'TERMS_AND_CONDITIONS';
}
