<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contentwarehouse;

class SafesearchInternalImageSignals extends \Google\Model
{
  /**
   * @var float
   */
  public $imageEntitiesViolenceScore;
  /**
   * @var SafesearchImageOffensiveAnnotation
   */
  public $offensiveAnnotation;
  protected $offensiveAnnotationType = SafesearchImageOffensiveAnnotation::class;
  protected $offensiveAnnotationDataType = '';
  /**
   * @var float
   */
  public $starburstPornScore;
  /**
   * @var float
   */
  public $starburstViolenceScore;

  /**
   * @param float
   */
  public function setImageEntitiesViolenceScore($imageEntitiesViolenceScore)
  {
    $this->imageEntitiesViolenceScore = $imageEntitiesViolenceScore;
  }
  /**
   * @return float
   */
  public function getImageEntitiesViolenceScore()
  {
    return $this->imageEntitiesViolenceScore;
  }
  /**
   * @param SafesearchImageOffensiveAnnotation
   */
  public function setOffensiveAnnotation(SafesearchImageOffensiveAnnotation $offensiveAnnotation)
  {
    $this->offensiveAnnotation = $offensiveAnnotation;
  }
  /**
   * @return SafesearchImageOffensiveAnnotation
   */
  public function getOffensiveAnnotation()
  {
    return $this->offensiveAnnotation;
  }
  /**
   * @param float
   */
  public function setStarburstPornScore($starburstPornScore)
  {
    $this->starburstPornScore = $starburstPornScore;
  }
  /**
   * @return float
   */
  public function getStarburstPornScore()
  {
    return $this->starburstPornScore;
  }
  /**
   * @param float
   */
  public function setStarburstViolenceScore($starburstViolenceScore)
  {
    $this->starburstViolenceScore = $starburstViolenceScore;
  }
  /**
   * @return float
   */
  public function getStarburstViolenceScore()
  {
    return $this->starburstViolenceScore;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SafesearchInternalImageSignals::class, 'Google_Service_Contentwarehouse_SafesearchInternalImageSignals');
