Основное использование
===========

Когда Вы откроете Gii, на главной странице будут отображены генераторы.

![Gii entry page](images/gii-entry.png)

По-умолчанию, доступны следующие генераторы:

- **Model Generator** - Этот генератор генерирует класс ActiveRecord для выбранной таблицы БД.
- **CRUD Generator** - Этот генератор генерирует контроллер и представления, реализующие операции CRUD (Create, Read, Update, Delete)
  для выбранной модели.
- **Controller Generator** - Этот генератор помогает быстро сгенерировать класс контроллера, одно или несколько действий (actions)
  и соответствующие им представления.
- **Form Generator** - Этот генератор генерирует файл представления для отображения html-формы с полями, соответствующими модели.
- **Module Generator** - Этот генератор поможет Вам сгенерировать каркас (skeleton code), необходимый для Yii-модуля.
- **Extension Generator** - Этот генератор помогает сгенерировать файлы, необходимые для Yii-расширений.

После выбора генератора кликом по кнопке "Start" Вы перейдете на форму, которая позволит сконфигурировать
параметры генератора. Заполните форму в соответствии с вашими потребностями и нажмите кнопку "Preview",
чтобы посмотреть код, который Gii собирается сгенерировать. В зависимости от выбранного генератора и наличия
(или отсутствия) генерируемых файлов, Вы увидите что-то подобное изображенному здесь:

![Gii preview](images/gii-preview.png)

Кликая на имени файла, посмотрите превью кода, сгенерированного для данного файла.
Когда генерируемый файл уже существует, Gii также покажет и разницу между имеющимся кодом и тем, который будет сгенерирован.
В этом случае, выбор остается за Вами - какие файлы оставить как есть, а какие перезаписать.

> Tip: При использовании Model-генератора для обновления моделей после изменений в БД, просто скопируйте код из превью и
  встройте его в свой код. Вы можете использовать возможности разных IDE: [сравнение с буфером обмена](https://www.jetbrains.com/phpstorm/webhelp/comparing-files.html) в PHPStorm, [Aptana Studio](https://www.aptana.com/products/studio3/download). В редакторах, основанных на [Eclipse](https://www.eclipse.org/pdt/) можно [сравнивать код с буфером обмена](https://andrei.gmxhome.de/anyedit/examples.html), используя для этого [AnyEdit tools plugin](https://andrei.gmxhome.de/anyedit/). Всё это позволит вам объединить только нужные изменения и пропустить изменения, которые заменят уже существующий полезный код.

После просмотра кода и выбора файлов для генерирования кликните на кнопке "Generate" чтобы создать файлы. Если нет ошибок - на этом всё!
Если появятся ошибки, значит Gii не смог сгенерировать файлы и Вам нужно установить права на запись для директорий, чтобы веб-сервер мог
создать в этих директориях файлы.

> Note: Код, сгенерированный Gii - всего лишь шаблон, который нужно подстраивать под Ваши нужды. Таким образом, Gii помогает
  быстро создавать новый код, но это не полностью готовый к работе код. Часто можно встретить людей, использующих сгенерированные
  посредством Gii модели, которые они не изменяли, а просто расширили их (extend) чтобы скорректировать какие-то моменты. Это не
  тот подход, которому нужно следовать. Код, сгенерированный Gii может быть неполным или неправильным и прежде чем его использовать,
  его необходимо изменить под Ваши потребности.
