<?php
/**
 * Open Source Social Network
 *
 * @package   Open Source Social Network (OSSN)
 * @author    OSSN Core Team <info@openteknik.com>
 * @copyright (C) OpenTeknik LLC
 * @license   Open Source Social Network License (OSSN LICENSE)  http://www.opensource-socialnetwork.org/licence
 * @link      https://www.opensource-socialnetwork.org/
 */

$en = array(
    'home' => 'Home',
    'site:index' => 'Welcome',
    'news:feed' => 'News Feed',
    'new:feed' => 'News Feed',
    'photos:ossn' => 'Photos',
    'admin:view:site' => 'View Site',
    
    'home:top:heading' => "Welcome to %s! Join now to make new friends, create groups, add photos, and much more.",
    'create:account' => 'Create an account',
    'its:free' => "It's free and always will be.",
        
    'copyright' => '&copy; COPYRIGHT',
    'powered' => 'Powered by the Open Source Social Network.',
    
    'name' => 'Name',
    'birthdate' => 'Birthdate',
    'first:name' => 'First Name',
    'last:name' => 'Last Name',
    'email' => 'Email',
    'email:again' => 'Re-enter Email',
    'username' => 'Username',
    'password' => 'Password',
    'day' => 'Day',
    'month' => 'Month',
    'year' => 'Year',
    'male' => 'Male',
    'female' => 'Female',
    'account:create:notice' => 'By clicking Create an account, you agree to our',
    'gender' => 'Gender',
    
    'account:settings' => 'Account Settings',
    'page:error' => 'Page Not Found!',
    'page:error:text' => 'The page you requested is unavailable or may have been deleted.',
    'page:error:heading' => '404',
    
    'search:users' => 'People',
    'admin:logout' => 'Log out',
    'logout' => 'Log out',
    
    'admin:components' => 'Components',
    'admin:dashboard' => 'Dashboard',
    'admin:install' => 'Installer',
    'admin:themes' => 'Themes',
    'admin:basic' => 'Basic',
    'admin:cache' => 'Cache',
    'admin:mode' => 'Mode',
    'configure' => 'Configure',
    'admin:help' => 'Help',
    'admin:support' => 'Support',
    
    'ossn:update:check:error' => 'Error',
    
    'upload' => 'Upload',
    'save' => 'Save',
    'add' => 'Add',
    'edit' => 'Edit',
    'search' => 'Search',
    'delete' => 'Delete',
    
    'admin:users' => 'List Users',
    'admin:add:user' => 'Add User',
    'admin:user:deleted' => 'User has been deleted!',
    'admin:user:delete:error' => 'Unable to delete user. Please try again later.',
    
    'type' => 'Type',
    'normal' => 'Normal',
    'admin' => 'Administrator',
    
    'lastlogin' => 'Last Login',
    
    'my:version' => 'My OSSN Version',
    'online:users' => 'Users Online',
    'themes' => 'Themes',
    'users' => 'Users',
    'components' => 'Components',
    'available:updates' => 'Available Updates',
    'website:name' => 'Website Name',
    'owner:email' => 'Owner Email',
    'default:lang' => 'Default Language',
    
    'timeline' => 'Timeline',
    'photos' => 'Photos',
    'friends' => 'Friends',
    'links' => 'Links',
    'ossn:add:user:mail:subject' => "%s please confirm your email address for %s!",
    'ossn:add:user:mail:body' => "Before you can start using %s, you must confirm your email address.

Please confirm your email address by clicking on the link below:

%s

You may copy and paste the address to your browser manually in case the link does not work.

%s",
    'user:friends' => 'Friends',
    'user:account:validated' => 'The account has been validated!',
    'user:account:validate:fail' => 'Cannot validate account! Please try again later.',
    
    'cache:enabled' => 'Cache enabled!',
    'cache:disabled' => 'Cache disabled!',
    'cache:enable' => 'Enable Cache',
    'cache:disable' => 'Disable Cache',
    
    'cache:1' => 'Enabled',
    'cache:0' => 'Disabled',
    'cache:notice' => 'Stores CSS and JavaScript files in a cache to improve site performance.',
    
    'theme:install:notice' => 'Upload a valid .zip theme package.',
    'com:install:notice' => 'Upload a valid .zip component package.',
    
    'login:error' => 'Invalid username or password!',
    'login:error:sub' => "We couldn't log you in. Please check your username or password and try again.",
    'login:success' => 'You are now logged in!',
    
    'ossn:com:installer:create:tmpdir:error' => 'Cannot create temporary data directory', 
    'ossn:com:installer:upload:error' => 'An error occurred during upload: %s',
    'ossn:com:installer:version:error' => 'This component requires OSSN %s or higher',
    'ossn:com:installer:remove:comdir:error' => 'Component already installed - please delete it from the list on the components page, first',
    'ossn:com:installer:create:comdir:error' => 'Cannot copy files to component directory',
    'ossn:com:installer:xml:incomplete:error' => 'Component description file missing or incomplete',
    'ossn:com:installer:zip:incomplete:error' => 'Component zip-archive incomplete',
    'ossn:com:installer:open:zip:error' => 'Cannot open component zip-archive',
    'ossn:com:installer:move:uploaded:file:error' => 'Invalid zip-archive',
    'ossn:com:installer:com:installation:success' => 'Component uploaded, you can now enable it from components page.',

    'ossn:theme:installer:create:tmpdir:error' => 'Cannot create temporary data directory', 
    'ossn:theme:installer:upload:error' => 'An error occurred during upload: %s',
    'ossn:theme:installer:version:error' => 'This theme requires OSSN %s or higher',
    'ossn:theme:installer:remove:themedir:error' => 'This theme has been installed already - please delete it from the list on the themes page, first',
    'ossn:theme:installer:create:themedir:error' => 'Cannot copy files to theme directory',
    'ossn:theme:installer:xml:incomplete:error' => 'Theme description file missing or incomplete',
    'ossn:theme:installer:zip:incomplete:error' => 'Theme zip-archive incomplete',
    'ossn:theme:installer:open:zip:error' => 'Cannot open theme zip-archive',
    'ossn:theme:installer:move:uploaded:file:error' => 'Invalid zip-archive',
    'ossn:theme:installer:theme:installation:success' => 'Theme uploaded, you can now enable it from themes page.',
    
    'settings:saved' => 'Settings saved',
    'com:deleted' => 'Component deleted!',
    'com:delete:error' => 'Cannot delete component! Please try again later.',
    'com:disabled' => 'Component disabled!',
    'com:enabled' => 'Component enabled!',
    'com:pref' => 'Do you wish to keep preferences for this component? If you are updating component then it is recommended to keep preferences. Press OK to keep it. Press Cancel to remove preferences.',
	
    'theme:delete:active' => 'Cannot delete active theme.',
    'theme:deleted' => 'Theme deleted.',
    'theme:delete:error' => 'Cannot delete theme! Please try again later.',
    'theme:enabled' => 'Theme enabled!',
    'theme:installed' => 'Theme installed!',
    'theme:install:error' => 'Install failed. Make sure it is compatible with the OSSN version you are using.',
    
    'fields:require' => 'All fields are required!',
    'username:error' => 'The username is incorrect. Please use only alphanumeric characters when entering your information. Make certain that there are no spaces or special characters. Only letters A-Z and numbers 0-9 are permitted. The username must have at least 5 characters.',
    'password:error' => 'The password must be more than 5 characters.',
    'account:created' => 'Your account has been created.',
    'account:create:error:admin' => 'Account registration failed! Please try again later.',
    'user:updated' => 'User updated!',
    'logged:out' => 'You are now logged out!',
    'username:inuse' => 'The following username is taken. Please select a different one.',
    'email:inuse' => 'The email address you used already exists in our database. Please try another email address.',
    'email:invalid' => 'Email address is invalid! Make sure the email address you entered is correct.',
    'email:error:matching' => "Email addresses do not match.",
    'account:created:email' => "Your account has been registered! We have sent you an account activation email. If you didn't receive the email, please check your spam/junk folder.",
    
    'administration' => 'Administration',
    
    'privacy' => 'Privacy',
    'close' => 'Closed',
    'open' => 'Open',
    'public' => 'Public',
    'friends' => 'Friends',
    'privacy:public:note' => 'Everyone can see this.',
    'privacy:friends:note' => 'Only your friends can see this.',
    
    'add:friend' => 'Add Friend',
    'cancel:request' => 'Cancel Request',
    'remove:friend' => 'Unfriend',
    'no:friends' => 'No Friends',
    'settings' => 'Settings',
    'ossn:add:friend:error' => 'Cannot add Friend!',
    'ossn:friend:request:submitted' => 'Friend Request Sent',
    
    /* Upgrades */
    'upgrade:file:load:error' => 'Cannot load upgrade file!',
    'upgrade:success' => "Your website has been upgraded to release %s.",
    'upgrade:failed' => "Cannot upgrade your site to release %s.",
    'upgrade:not:available' => 'No upgrades!',
    
    'site:login' => 'Login',
    /* Page errors */
    'system:error:title' => 'Something went wrong!',
    'system:error:text' => 'Something went wrong! Reload this page and try again.',
    
    /* Password Reset */
    'reset:login' => 'Reset Password',
    'reset:password' => 'Reset your password',
    'enter:new:password' => 'Enter your new password below and click reset.',
    'reset' => 'Reset',
    'enter:emai:reset:pwd' => 'Enter the email address of your account in order to reset the password.',
    'ossn:reset:password:subject' => 'Reset your password',
    'ossn:reset:password:body' => "Hello %s,
    
Please click the link below to reset password or copy the link and paste into your browser's address bar:

%s

%s",
    'passord:reset:success' => 'Password changed!',
    'passord:reset:fail' => 'Cannot reset password! Please try again later.',
    'password:reset:email:required' => 'Email cannot be empty!',
    'passord:reset:email:success' => 'Password reset instructions have been sent to your email address.',
    
    'erros:reporting' => 'Error Reporting',
    'erros:off' => 'Off',
    'erros:on' => 'On',
    'basic:settings' => 'Basic Settings',
    
    'ossn:new:version:error' => 'Unknown',
    'ossn:version:avaialbe' => "%s",
    
    'ossn:exception:title' => 'A system error has occurred. Please try again later. You may email the details of this error to the system administrator at %s.',
    'ossn:securitytoken:failed' => 'The action requested is invalid.',
    'ossn:component:delete:exception' => 'Are you sure you want to delete this component?',
    'ossn:user:delete:exception' => 'Are you sure you want to delete this user?',
    
    //access
    'title:access:1' => 'Private',
    'title:access:2' => 'Public',
    'title:access:3' => 'Friends',
    
    'upload:file:error:ini_size' => 'The file is too large.',
    'upload:file:error:form_size' => 'The file is too large.',
    'upload:file:error:partial' => 'The file upload did not complete.',
    'upload:file:error:no_file' => 'No file was selected.',
    'upload:file:error:no_tmp_dir' => 'Cannot save the uploaded file.',
    'upload:file:error:cant_write' => 'Cannot save the uploaded file.',
    'upload:file:error:extension' => 'Cannot save the uploaded file.',
    'upload:file:error:unknown' => 'The file upload failed.',
 	'upload:file:error:multiple' => '%s out of %s uploads failed.',
   
    'ossn:post:size:exceed' => 'The action you requested exceeds the size limit.',
    
    'admin:com:installer' => 'Component Installer',
    'admin:theme:installer' => 'Theme Installer',
    'admin:cache:settings' => 'Cache Settings',
    'admin:user:list' => 'Users List',
    'admin:edit:user' => 'Edit User',
    'admin:login' => 'Login',
    'admin:notification:email' => 'Site Notification Email',
	'admin:email:name' => 'Notification Email Name',
    'notification_email' => 'Notification Email (noreply@domain.com)',
    'owner_email' => 'Owner Email (mysite@domain.com)',
    'ossn:websitename' => 'Name of your website',
    'ossn:user:validation:resend' => 'Your account is not validated! You must validate your account before logging in. Another validation email has been sent to your email address.',
    'site:timepassed:text' => '%s ago',
    // localization of passed time: 16 time elements (even = singular / odd = plural)
    'site:timepassed:data' => 'second|seconds|minute|minutes|hour|hours|day|days|week|weeks|month|months|year|years|decade|decades',
    'ossn:notification:no:notification' => 'Nothing to show',
    'admin:button:enable' => 'Enable',
    'admin:button:enabled' => 'Enabled',
    'admin:button:disable' => 'Disable',
    'admin:button:configure' => 'Configure',
    'admin:button:delete' => 'Delete',
    'admin:component:author' => 'Author',
    'admin:component:website' => 'Website',
    'admin:sidemenu:components' => 'Components',
    'admin:sidemenu:themes' => 'Themes',
    'admin:sidemenu:settings' => 'Site Settings',
    'admin:sidemenu:usermanager' => 'User Manager',
    'cancel' => 'Cancel',
    'ossn:language:complete' => 'Complete',
    'ossn:pagination:first' => 'First',
    'ossn:pagination:last' => 'Last',
    'validate' => 'Validate',
    'admin:users:unvalidated' => 'Unvalidated Users',
    'admin:user:validated' => 'User validated',
    'admin:user:validate:error' => 'Cannot validate user.',
    
    //v3.0
    //admin
    'my:files:version' => 'My OSSN Files Version',
    'cache:flush:error' => 'Cannot flush cache, make sure its enabled in Cache Settings',
    'cache:flushed' => 'Cache flushed',
    'ossn:version' => 'OSSN version', 
    'php:extension' => 'PHP extension',
    'php:version' => 'PHP version',
    'php:function' => 'PHP function',
    'admin:old:com' => "Your ossn_com.xml file is based on old version of OSSN. Please update '%s' component.",
    'admin:old:theme' => "Your ossn_theme.xml file is based on old version of OSSN. Please update '%s' theme.",
    'admin:button:disabled' => 'Disabled',
    'admin:flush:cache' => 'Flush Cache',
    'admin:com:version' => 'Version',
    'admin:com:author' => 'Author',
    'admin:com:author:url' => 'Author URL',
    'admin:com:license' => 'License',
    'admin:com:requirements' => 'Requirements',
    'admin:com:requirement' => 'Requirement',
    'admin:com:fulfilled' => 'Fulfilled',
    'admin:com:used:by' => 'Used by',
    'ossn:exception:make:sure' => 'Are you sure?',
    'ossn:premium' => 'Premium Version',
    'datepicker:days' => "Su, Mo, Tu, We, Th, Fr, Sa",
    'datepicker:months' => "Jan., Feb., Mar., Apr., May, June, July, Aug., Sep., Oct., Nov., Dec.",
    'male:gendercolor' => '#01ADEF',
    'female:gendercolor' => '#ED008C',
    'ossn:admin:settings:off' => 'disabled',
    'ossn:admin:settings:on' => 'enabled',
    'ossn:admin:settings:saved' => 'Settings saved!',
    'ossn:admin:settings:save:error' => 'Cannot save settings! Please check your error_log file.',
    'php:upload_err_ok' => 'File uploaded',
    'php:upload_err_ini_size' => 'The uploaded file exceeds the upload_max_filesize directive in php.ini',
    'php:upload_err_form_size' => 'The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form',
    'php:upload_err_partial' => 'The uploaded file was only partially uploaded',
    'php:upload_err_no_file' => 'No file uploaded',
    'php:upload_err_no_tmp_dir' => 'Missing a temporary folder',
    'php:upload_err_cant_write' => 'Failed to write file to disk',
    'php:upload_err_extension' => 'A PHP extension stopped the file upload',
	'php:extension:notfound' => 'PHP Extension not found!',
	
	'admin:basiccache' => 'Basic Cache',
	'admin:dcache:note' => "The dynamic data is cached using a dynamic cache. which could expedite the processing of your application. Enabling cache won't help if your cache server connection is slower since it will only make your application run more slowly.  It is recommended that you set up the caching server on the same host as your social network. Please refrain from using caching with shared hosting services. Only one cache system can be used at a time.",
	'admin:dcache:cachename' => 'Cache Server Types',
	'admin:dcache:extension:enabled' => 'Extension Enabled',
	'admin:dcache:select:server:type' => 'Select server type',
	'admin:dcache:host' => 'Host',
	'admin:dcache:port' => 'Port',
	'admin:dcache:username' => 'Username (if any)',
	'admin:dcache:password' => 'Password (if any)',
	'admin:dcache:setstatus' => 'Set Status',
	'admin:dcache:extension:tests' => 'Tests',
	'admin:dcache:errorconnection' => 'Unable to confirm connection using given details!',
	'admin:dcache:required:field' =>  'Please fill required fields',
	'admin:dcache:memcached:authnotsupport' => 'Your Memcached php extension does not support authentication!',
	
    /*
     * List of ISO 639-1 language codes
     * http://en.wikipedia.org/wiki/List_of_ISO_639-1_codes
     */
    "aa" => "Afar",
    "ab" => "Abkhazian",
    "af" => "Afrikaans",
    "am" => "Amharic",
    "ar" => "Arabic",
    "as" => "Assamese",
    "ay" => "Aymara",
    "az" => "Azerbaijani",
    "ba" => "Bashkir",
    "be" => "Byelorussian",
    "bg" => "Bulgarian",
    "bh" => "Bihari",
    "bi" => "Bislama",
    "bn" => "Bengali; Bangla",
    "bo" => "Tibetan",
    "br" => "Breton",
    "bs" => "Bosnian",
    "ca" => "Catalan",
    "co" => "Corsican",
    "cs" => "Czech",
    "cy" => "Welsh",
    "da" => "Danish",
    "de" => "German",
    "dz" => "Bhutani",
    "el" => "Greek",
    "en" => "English",
    "eo" => "Esperanto",
    "es" => "Spanish",
    "et" => "Estonian",
    "eu" => "Basque",
    "fa" => "Persian",
    "fi" => "Finnish",
    "fj" => "Fiji",
    "fo" => "Faeroese",
    "fr" => "French",
    "fy" => "Frisian",
    "ga" => "Irish",
    "gd" => "Scots / Gaelic",
    "gl" => "Galician",
    "gn" => "Guarani",
    "gu" => "Gujarati",
    "he" => "Hebrew",
    "ha" => "Hausa",
    "hi" => "Hindi",
    "hr" => "Croatian",
    "hu" => "Hungarian",
    "hy" => "Armenian",
    "ia" => "Interlingua",
    "id" => "Indonesian",
    "ie" => "Interlingue",
    "ik" => "Inupiaq",
    "is" => "Icelandic",
    "it" => "Italian",
    "iu" => "Inuktitut",
    "iw" => "Hebrew (obsolete)",
    "ja" => "Japanese",
    "ji" => "Yiddish (obsolete)",
    "jw" => "Javanese",
    "ka" => "Georgian",
    "kk" => "Kazakh",
    "kl" => "Greenlandic",
    "km" => "Cambodian",
    "kn" => "Kannada",
    "ko" => "Korean",
    "ks" => "Kashmiri",
    "ku" => "Kurdish",
    "ky" => "Kirghiz",
    "la" => "Latin",
    "ln" => "Lingala",
    "lo" => "Lao",
    "lt" => "Lithuanian",
    "lv" => "Latvian/Lettish",
    "mg" => "Malagasy",
    "mi" => "Maori",
    "mk" => "Macedonian",
    "ml" => "Malayalam",
    "mn" => "Mongolian",
    "mo" => "Moldavian",
    "mr" => "Marathi",
    "ms" => "Malay",
    "mt" => "Maltese",
    "my" => "Burmese",
    "na" => "Nauru",
    "ne" => "Nepali",
    "nl" => "Dutch",
    "no" => "Norwegian",
    "oc" => "Occitan",
    "om" => "(Afan) Oromo",
    "or" => "Oriya",
    "pa" => "Punjabi",
    "pl" => "Polish",
    "ps" => "Pashto / Pushto",
    "pt" => "Portuguese",
    "qu" => "Quechua",
    "rm" => "Rhaeto-Romance",
    "rn" => "Kirundi",
    "ro" => "Romanian",
    "ru" => "Russian",
    "rw" => "Kinyarwanda",
    "sa" => "Sanskrit",
    "sd" => "Sindhi",
    "sg" => "Sango",
    "sh" => "Serbo-Croatian",
    "si" => "Sinhalese",
    "sk" => "Slovak",
    "sl" => "Slovenian",
    "sm" => "Samoan",
    "sn" => "Shona",
    "so" => "Somali",
    "sq" => "Albanian",
    "sr" => "Serbian",
    "ss" => "Siswati",
    "st" => "Sesotho",
    "su" => "Sundanese",
    "sv" => "Swedish",
    "sw" => "Swahili",
    "ta" => "Tamil",
    "te" => "Telugu",
    "tg" => "Tajik",
    "th" => "Thai",
    "ti" => "Tigrinya",
    "tk" => "Turkmen",
    "tl" => "Tagalog",
    "tn" => "Setswana",
    "to" => "Tonga",
    "tr" => "Turkish",
    "ts" => "Tsonga",
    "tt" => "Tatar",
    "tw" => "Twi",
    "ug" => "Uigur",
    "uk" => "Ukrainian",
    "ur" => "Urdu",
    "uz" => "Uzbek",
    "vi" => "Vietnamese",
    "vo" => "Volapuk",
    "wo" => "Wolof",
    "xh" => "Xhosa",
    "yi" => "Yiddish",
    "yo" => "Yoruba",
    "za" => "Zuang",
    "zh" => "Chinese",
    "zu" => "Zulu"
);
ossn_register_languages('en', $en);
