<?php
/*************************************************************************************
 * php.php
 * --------
 * Author: Nigel McNie (nigel@geshi.org)
 * Copyright: (c) 2004 Nigel McNie (http://qbnz.com/highlighter/)
 * Release Version: 1.0.9.1
 * Date Started: 2004/06/20
 *
 * PHP language file for GeSHi.
 *
 * CHANGES
 * -------
 * 2008/05/23 (1.0.7.22)
 *  -  Added description of extra language features (SF#1970248)
 * 2004/11/25 (1.0.3)
 *  -  Added support for multiple object splitters
 *  -  Fixed &new problem
 * 2004/10/27 (1.0.2)
 *  -  Added URL support
 *  -  Added extra constants
 * 2004/08/05 (1.0.1)
 *  -  Added support for symbols
 * 2004/07/14 (1.0.0)
 *  -  First Release
 *
 * TODO (updated 2004/07/14)
 * -------------------------
 * * Make sure the last few function I may have missed
 *   (like eval()) are included for highlighting
 * * Split to several files - php4, php5 etc
 *
 *************************************************************************************
 *
 *     This file is part of GeSHi.
 *
 *   GeSHi is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   GeSHi is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with GeSHi; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 ************************************************************************************/

$language_data = array(
    'LANG_NAME' => 'PHP',
    'COMMENT_SINGLE' => array(1 => '//', 2 => '#'),
    'COMMENT_MULTI' => array('/*' => '*/'),
    'COMMENT_REGEXP' => array(
        //Heredoc and Nowdoc syntax
        3 => '/<<<\s*?(\'?)([a-zA-Z0-9]+?)\1[^\n]*?\\n.*\\n\\2(?![a-zA-Z0-9])/siU',
        // phpdoc comments
        4 => '#/\*\*(?![\*\/]).*\*/#sU',
        // Advanced # handling
        2 => "/#.*?(?:(?=\?\>)|^)/smi"
        ),
    'CASE_KEYWORDS' => GESHI_CAPS_NO_CHANGE,
    'QUOTEMARKS' => array('"'),
    'ESCAPE_CHAR' => '',
    'ESCAPE_REGEXP' => array(
        //Simple Single Char Escapes
        1 => "#\\\\[nfrtv\$\"\n\\\\]#i",
        //Hexadecimal Char Specs
        2 => "#\\\\x[\da-fA-F]{1,2}#i",
        //Octal Char Specs
        3 => "#\\\\[0-7]{1,3}#",
        //String Parsing of Variable Names
        4 => "#\\$[a-z0-9_]+(?:\\[[a-z0-9_]+\\]|->[a-z0-9_]+)?|(?:\\{\\$|\\$\\{)[a-z0-9_]+(?:\\[('?)[a-z0-9_]*\\1\\]|->[a-z0-9_]+)*\\}#i",
        //Experimental extension supporting cascaded {${$var}} syntax
        5 => "#\$[a-z0-9_]+(?:\[[a-z0-9_]+\]|->[a-z0-9_]+)?|(?:\{\$|\$\{)[a-z0-9_]+(?:\[('?)[a-z0-9_]*\\1\]|->[a-z0-9_]+)*\}|\{\$(?R)\}#i",
        //Format String support in ""-Strings
        6 => "#%(?:%|(?:\d+\\\\\\\$)?\\+?(?:\x20|0|'.)?-?(?:\d+|\\*)?(?:\.\d+)?[bcdefFosuxX])#"
        ),
    'HARDQUOTE' => array("'", "'"),
    'HARDESCAPE' => array("'", "\\"),
    'HARDCHAR' => "\\",
    'NUMBERS' =>
        GESHI_NUMBER_INT_BASIC | GESHI_NUMBER_OCT_PREFIX | GESHI_NUMBER_HEX_PREFIX |
        GESHI_NUMBER_FLT_SCI_ZERO,
    'KEYWORDS' => array(
        1 => array(
            'as','break','case','continue','default','do','else','elseif',
            'endfor','endforeach','endif','endswitch','endwhile','for',
            'foreach','if','include','include_once','require','require_once',
            'return','switch','throw','while', 'yield','match',

            'echo','print'
            ),
        2 => array(
            '&amp;new','&lt;/script&gt;','&lt;?php','&lt;script language',
            'abstract','class','const','declare','extends','function','global',
            'implements', 'interface','namespace','new','private','protected',
            'public','self','trait','use','var', 'fn',
            ),
        3 => array(
            'abs','acos','acosh','addcslashes','addslashes','aggregate',
            'aggregate_methods','aggregate_methods_by_list',
            'aggregate_methods_by_regexp','aggregate_properties',
            'aggregate_properties_by_list','aggregate_properties_by_regexp',
            'aggregation_info','apache_child_terminate','apache_get_modules',
            'apache_get_version','apache_getenv','apache_lookup_uri',
            'apache_note','apache_request_headers','apache_response_headers',
            'apache_setenv','array','array_change_key_case','array_chunk',
            'array_combine','array_count_values','array_diff',
            'array_diff_assoc','array_diff_key','array_diff_uassoc',
            'array_diff_ukey','array_fill','array_fill_keys','array_filter',
            'array_flip','array_intersect','array_intersect_assoc',
            'array_intersect_key','array_intersect_uassoc',
            'array_intersect_ukey','array_key_exists','array_keys','array_map',
            'array_merge','array_merge_recursive','array_multisort','array_pad',
            'array_pop','array_product','array_push','array_rand',
            'array_reduce','array_reverse','array_search','array_shift',
            'array_slice','array_splice','array_sum','array_udiff',
            'array_udiff_assoc','array_udiff_uassoc','array_uintersect',
            'array_uintersect_assoc','array_uintersect_uassoc','array_unique',
            'array_unshift','array_values','array_walk','array_walk_recursive',
            'arsort','asin','asinh','asort','assert','assert_options','atan',
            'atan2','atanh','base_convert','base64_decode','base64_encode',
            'basename','bcadd','bccomp','bcdiv','bcmod','bcmul',
            'bcompiler_load','bcompiler_load_exe','bcompiler_parse_class',
            'bcompiler_read','bcompiler_write_class','bcompiler_write_constant',
            'bcompiler_write_exe_footer','bcompiler_write_file',
            'bcompiler_write_footer','bcompiler_write_function',
            'bcompiler_write_functions_from_file','bcompiler_write_header',
            'bcompiler_write_included_filename','bcpow','bcpowmod','bcscale',
            'bcsqrt','bcsub','bin2hex','bindec','bindtextdomain',
            'bind_textdomain_codeset','bitset_empty','bitset_equal',
            'bitset_excl','bitset_fill','bitset_from_array','bitset_from_hash',
            'bitset_from_string','bitset_in','bitset_incl',
            'bitset_intersection','bitset_invert','bitset_is_empty',
            'bitset_subset','bitset_to_array','bitset_to_hash',
            'bitset_to_string','bitset_union','blenc_encrypt','bzclose',
            'bzcompress','bzdecompress','bzerrno','bzerror','bzerrstr',
            'bzflush','bzopen','bzread','bzwrite','cal_days_in_month',
            'cal_from_jd','cal_info','cal_to_jd','call_user_func',
            'call_user_func_array','call_user_method','call_user_method_array',
            'ceil','chdir','checkdate','checkdnsrr','chgrp','chmod','chop',
            'chown','chr','chunk_split','class_exists','class_implements',
            'class_parents','classkit_aggregate_methods',
            'classkit_doc_comments','classkit_import','classkit_method_add',
            'classkit_method_copy','classkit_method_redefine',
            'classkit_method_remove','classkit_method_rename','clearstatcache',
            'closedir','closelog','com_create_guid','com_event_sink',
            'com_get_active_object','com_load_typelib','com_message_pump',
            'com_print_typeinfo','compact','confirm_phpdoc_compiled',
            'connection_aborted','connection_status','constant',
            'convert_cyr_string','convert_uudecode','convert_uuencode','copy',
            'cos','cosh','count','count_chars','cpdf_add_annotation',
            'cpdf_add_outline','cpdf_arc','cpdf_begin_text','cpdf_circle',
            'cpdf_clip','cpdf_close','cpdf_closepath',
            'cpdf_closepath_fill_stroke','cpdf_closepath_stroke',
            'cpdf_continue_text','cpdf_curveto','cpdf_end_text','cpdf_fill',
            'cpdf_fill_stroke','cpdf_finalize','cpdf_finalize_page',
            'cpdf_global_set_document_limits','cpdf_import_jpeg','cpdf_lineto',
            'cpdf_moveto','cpdf_newpath','cpdf_open','cpdf_output_buffer',
            'cpdf_page_init','cpdf_rect','cpdf_restore','cpdf_rlineto',
            'cpdf_rmoveto','cpdf_rotate','cpdf_rotate_text','cpdf_save',
            'cpdf_save_to_file','cpdf_scale','cpdf_set_action_url',
            'cpdf_set_char_spacing','cpdf_set_creator','cpdf_set_current_page',
            'cpdf_set_font','cpdf_set_font_directories',
            'cpdf_set_font_map_file','cpdf_set_horiz_scaling',
            'cpdf_set_keywords','cpdf_set_leading','cpdf_set_page_animation',
            'cpdf_set_subject','cpdf_set_text_matrix','cpdf_set_text_pos',
            'cpdf_set_text_rendering','cpdf_set_text_rise','cpdf_set_title',
            'cpdf_set_viewer_preferences','cpdf_set_word_spacing',
            'cpdf_setdash','cpdf_setflat','cpdf_setgray','cpdf_setgray_fill',
            'cpdf_setgray_stroke','cpdf_setlinecap','cpdf_setlinejoin',
            'cpdf_setlinewidth','cpdf_setmiterlimit','cpdf_setrgbcolor',
            'cpdf_setrgbcolor_fill','cpdf_setrgbcolor_stroke','cpdf_show',
            'cpdf_show_xy','cpdf_stringwidth','cpdf_stroke','cpdf_text',
            'cpdf_translate','crack_check','crack_closedict',
            'crack_getlastmessage','crack_opendict','crc32','create_function',
            'crypt','ctype_alnum','ctype_alpha','ctype_cntrl','ctype_digit',
            'ctype_graph','ctype_lower','ctype_print','ctype_punct',
            'ctype_space','ctype_upper','ctype_xdigit','curl_close',
            'curl_copy_handle','curl_errno','curl_error','curl_exec',
            'curl_getinfo','curl_init','curl_multi_add_handle',
            'curl_multi_close','curl_multi_exec','curl_multi_getcontent',
            'curl_multi_info_read','curl_multi_init','curl_multi_remove_handle',
            'curl_multi_select','curl_setopt','curl_setopt_array',
            'curl_version','current','cvsclient_connect','cvsclient_log',
            'cvsclient_login','cvsclient_retrieve','date','date_create',
            'date_date_set','date_default_timezone_get',
            'date_default_timezone_set','date_format','date_isodate_set',
            'date_modify','date_offset_get','date_parse','date_sun_info',
            'date_sunrise','date_sunset','date_time_set','date_timezone_get',
            'date_timezone_set','db_id_list','dba_close','dba_delete',
            'dba_exists','dba_fetch','dba_firstkey','dba_handlers','dba_insert',
            'dba_key_split','dba_list','dba_nextkey','dba_open','dba_optimize',
            'dba_popen','dba_replace','dba_sync','dbase_add_record',
            'dbase_close','dbase_create','dbase_delete_record',
            'dbase_get_header_info','dbase_get_record',
            'dbase_get_record_with_names','dbase_numfields','dbase_numrecords',
            'dbase_open','dbase_pack','dbase_replace_record',
            'dbg_get_all_contexts','dbg_get_all_module_names',
            'dbg_get_all_source_lines','dbg_get_context_name',
            'dbg_get_module_name','dbg_get_profiler_results',
            'dbg_get_source_context','dblist','dbmclose','dbmdelete',
            'dbmexists','dbmfetch','dbmfirstkey','dbminsert','dbmnextkey',
            'dbmopen','dbmreplace','dbx_close','dbx_compare','dbx_connect',
            'dbx_error','dbx_escape_string','dbx_fetch_row','dbx_query',
            'dbx_sort','dcgettext','dcngettext','deaggregate','debug_backtrace',
            'debug_zval_dump','debugbreak','decbin','dechex','decoct','define',
            'defined','define_syslog_variables','deg2rad','dgettext','die',
            'dio_close','dio_open','dio_read','dio_seek','dio_stat','dio_write',
            'dir','dirname','disk_free_space','disk_total_space',
            'diskfreespace','dl','dngettext','docblock_token_name',
            'docblock_tokenize','dom_import_simplexml','domxml_add_root',
            'domxml_attributes','domxml_children','domxml_doc_add_root',
            'domxml_doc_document_element','domxml_doc_get_element_by_id',
            'domxml_doc_get_elements_by_tagname','domxml_doc_get_root',
            'domxml_doc_set_root','domxml_doc_validate','domxml_doc_xinclude',
            'domxml_dump_mem','domxml_dump_mem_file','domxml_dump_node',
            'domxml_dumpmem','domxml_elem_get_attribute',
            'domxml_elem_set_attribute','domxml_get_attribute','domxml_getattr',
            'domxml_html_dump_mem','domxml_new_child','domxml_new_doc',
            'domxml_new_xmldoc','domxml_node','domxml_node_add_namespace',
            'domxml_node_attributes','domxml_node_children',
            'domxml_node_get_content','domxml_node_has_attributes',
            'domxml_node_new_child','domxml_node_set_content',
            'domxml_node_set_namespace','domxml_node_unlink_node',
            'domxml_open_file','domxml_open_mem','domxml_parser',
            'domxml_parser_add_chunk','domxml_parser_cdata_section',
            'domxml_parser_characters','domxml_parser_comment',
            'domxml_parser_end','domxml_parser_end_document',
            'domxml_parser_end_element','domxml_parser_entity_reference',
            'domxml_parser_get_document','domxml_parser_namespace_decl',
            'domxml_parser_processing_instruction',
            'domxml_parser_start_document','domxml_parser_start_element',
            'domxml_root','domxml_set_attribute','domxml_setattr',
            'domxml_substitute_entities_default','domxml_unlink_node',
            'domxml_version','domxml_xmltree','doubleval','each','easter_date',
            'easter_days','empty','end','ereg','ereg_replace','eregi',
            'eregi_replace','error_get_last','error_log','error_reporting',
            'escapeshellarg','escapeshellcmd','eval','event_deschedule',
            'event_dispatch','event_free','event_handle_signal',
            'event_have_events','event_init','event_new','event_pending',
            'event_priority_set','event_schedule','event_set','event_timeout',
            'exec','exif_imagetype','exif_read_data','exif_tagname',
            'exif_thumbnail','exit','exp','explode','expm1','extension_loaded',
            'extract','ezmlm_hash','fbird_add_user','fbird_affected_rows',
            'fbird_backup','fbird_blob_add','fbird_blob_cancel',
            'fbird_blob_close','fbird_blob_create','fbird_blob_echo',
            'fbird_blob_get','fbird_blob_import','fbird_blob_info',
            'fbird_blob_open','fbird_close','fbird_commit','fbird_commit_ret',
            'fbird_connect','fbird_db_info','fbird_delete_user','fbird_drop_db',
            'fbird_errcode','fbird_errmsg','fbird_execute','fbird_fetch_assoc',
            'fbird_fetch_object','fbird_fetch_row','fbird_field_info',
            'fbird_free_event_handler','fbird_free_query','fbird_free_result',
            'fbird_gen_id','fbird_maintain_db','fbird_modify_user',
            'fbird_name_result','fbird_num_fields','fbird_num_params',
            'fbird_param_info','fbird_pconnect','fbird_prepare','fbird_query',
            'fbird_restore','fbird_rollback','fbird_rollback_ret',
            'fbird_server_info','fbird_service_attach','fbird_service_detach',
            'fbird_set_event_handler','fbird_trans','fbird_wait_event','fclose',
            'fdf_add_doc_javascript','fdf_add_template','fdf_close',
            'fdf_create','fdf_enum_values','fdf_errno','fdf_error','fdf_get_ap',
            'fdf_get_attachment','fdf_get_encoding','fdf_get_file',
            'fdf_get_flags','fdf_get_opt','fdf_get_status','fdf_get_value',
            'fdf_get_version','fdf_header','fdf_next_field_name','fdf_open',
            'fdf_open_string','fdf_remove_item','fdf_save','fdf_save_string',
            'fdf_set_ap','fdf_set_encoding','fdf_set_file','fdf_set_flags',
            'fdf_set_javascript_action','fdf_set_on_import_javascript',
            'fdf_set_opt','fdf_set_status','fdf_set_submit_form_action',
            'fdf_set_target_frame','fdf_set_value','fdf_set_version','feof',
            'fflush','fgetc','fgetcsv','fgets','fgetss','file','file_exists',
            'file_get_contents','file_put_contents','fileatime','filectime',
            'filegroup','fileinode','filemtime','fileowner','fileperms',
            'filepro','filepro_fieldcount','filepro_fieldname',
            'filepro_fieldtype','filepro_fieldwidth','filepro_retrieve',
            'filepro_rowcount','filesize','filetype','filter_has_var',
            'filter_id','filter_input','filter_input_array','filter_list',
            'filter_var','filter_var_array','finfo_buffer','finfo_close',
            'finfo_file','finfo_open','finfo_set_flags','floatval','flock',
            'floor','flush','fmod','fnmatch','fopen','fpassthru','fprintf',
            'fputcsv','fputs','fread','frenchtojd','fribidi_charset_info',
            'fribidi_get_charsets','fribidi_log2vis','fscanf','fseek',
            'fsockopen','fstat','ftell','ftok','ftp_alloc','ftp_cdup',
            'ftp_chdir','ftp_chmod','ftp_close','ftp_connect','ftp_delete',
            'ftp_exec','ftp_fget','ftp_fput','ftp_get','ftp_get_option',
            'ftp_login','ftp_mdtm','ftp_mkdir','ftp_nb_continue','ftp_nb_fget',
            'ftp_nb_fput','ftp_nb_get','ftp_nb_put','ftp_nlist','ftp_pasv',
            'ftp_put','ftp_pwd','ftp_quit','ftp_raw','ftp_rawlist','ftp_rename',
            'ftp_rmdir','ftp_set_option','ftp_site','ftp_size',
            'ftp_ssl_connect','ftp_systype','ftruncate','function_exists',
            'func_get_arg','func_get_args','func_num_args','fwrite','gd_info',
            'getallheaders','getcwd','getdate','getenv','gethostbyaddr',
            'gethostbyname','gethostbynamel','getimagesize','getlastmod',
            'getmxrr','getmygid','getmyinode','getmypid','getmyuid','getopt',
            'getprotobyname','getprotobynumber','getrandmax','getrusage',
            'getservbyname','getservbyport','gettext','gettimeofday','gettype',
            'get_browser','get_cfg_var','get_class','get_class_methods',
            'get_class_vars','get_current_user','get_declared_classes',
            'get_defined_constants','get_defined_functions','get_defined_vars',
            'get_extension_funcs','get_headers','get_html_translation_table',
            'get_included_files','get_include_path','get_loaded_extensions',
            'get_magic_quotes_gpc','get_magic_quotes_runtime','get_meta_tags',
            'get_object_vars','get_parent_class','get_required_files',
            'get_resource_type','glob','gmdate','gmmktime','gmp_abs','gmp_add',
            'gmp_and','gmp_clrbit','gmp_cmp','gmp_com','gmp_div','gmp_div_q',
            'gmp_div_qr','gmp_div_r','gmp_divexact','gmp_fact','gmp_gcd',
            'gmp_gcdext','gmp_hamdist','gmp_init','gmp_intval','gmp_invert',
            'gmp_jacobi','gmp_legendre','gmp_mod','gmp_mul','gmp_neg',
            'gmp_nextprime','gmp_or','gmp_perfect_square','gmp_popcount',
            'gmp_pow','gmp_powm','gmp_prob_prime','gmp_random','gmp_scan0',
            'gmp_scan1','gmp_setbit','gmp_sign','gmp_sqrt','gmp_sqrtrem',
            'gmp_strval','gmp_sub','gmp_xor','gmstrftime','gopher_parsedir',
            'gregoriantojd','gzclose','gzcompress','gzdeflate','gzencode',
            'gzeof','gzfile','gzgetc','gzgets','gzgetss','gzinflate','gzopen',
            'gzpassthru','gzputs','gzread','gzrewind','gzseek','gztell',
            'gzuncompress','gzwrite','hash','hash_algos','hash_file',
            'hash_final','hash_hmac','hash_hmac_file','hash_init','hash_update',
            'hash_update_file','hash_update_stream','header','headers_list',
            'headers_sent','hebrev','hebrevc','hexdec','highlight_file',
            'highlight_string','html_doc','html_doc_file','html_entity_decode',
            'htmlentities','htmlspecialchars','htmlspecialchars_decode',
            'http_build_cookie','http_build_query','http_build_str',
            'http_build_url','http_cache_etag','http_cache_last_modified',
            'http_chunked_decode','http_date','http_deflate','http_get',
            'http_get_request_body','http_get_request_body_stream',
            'http_get_request_headers','http_head','http_inflate',
            'http_match_etag','http_match_modified','http_match_request_header',
            'http_negotiate_charset','http_negotiate_content_type',
            'http_negotiate_language','http_parse_cookie','http_parse_headers',
            'http_parse_message','http_parse_params',
            'http_persistent_handles_clean','http_persistent_handles_count',
            'http_persistent_handles_ident','http_post_data','http_post_fields',
            'http_put_data','http_put_file','http_put_stream','http_redirect',
            'http_request','http_request_body_encode',
            'http_request_method_exists','http_request_method_name',
            'http_request_method_register','http_request_method_unregister',
            'http_send_content_disposition','http_send_content_type',
            'http_send_data','http_send_file','http_send_last_modified',
            'http_send_status','http_send_stream','http_support',
            'http_throttle','hypot','i18n_convert','i18n_discover_encoding',
            'i18n_http_input','i18n_http_output','i18n_internal_encoding',
            'i18n_ja_jp_hantozen','i18n_mime_header_decode',
            'i18n_mime_header_encode','ibase_add_user','ibase_affected_rows',
            'ibase_backup','ibase_blob_add','ibase_blob_cancel',
            'ibase_blob_close','ibase_blob_create','ibase_blob_echo',
            'ibase_blob_get','ibase_blob_import','ibase_blob_info',
            'ibase_blob_open','ibase_close','ibase_commit','ibase_commit_ret',
            'ibase_connect','ibase_db_info','ibase_delete_user','ibase_drop_db',
            'ibase_errcode','ibase_errmsg','ibase_execute','ibase_fetch_assoc',
            'ibase_fetch_object','ibase_fetch_row','ibase_field_info',
            'ibase_free_event_handler','ibase_free_query','ibase_free_result',
            'ibase_gen_id','ibase_maintain_db','ibase_modify_user',
            'ibase_name_result','ibase_num_fields','ibase_num_params',
            'ibase_param_info','ibase_pconnect','ibase_prepare','ibase_query',
            'ibase_restore','ibase_rollback','ibase_rollback_ret',
            'ibase_server_info','ibase_service_attach','ibase_service_detach',
            'ibase_set_event_handler','ibase_trans','ibase_wait_event','iconv',
            'iconv_get_encoding','iconv_mime_decode',
            'iconv_mime_decode_headers','iconv_mime_encode',
            'iconv_set_encoding','iconv_strlen','iconv_strpos','iconv_strrpos',
            'iconv_substr','id3_get_frame_long_name','id3_get_frame_short_name',
            'id3_get_genre_id','id3_get_genre_list','id3_get_genre_name',
            'id3_get_tag','id3_get_version','id3_remove_tag','id3_set_tag',
            'idate','ignore_user_abort','image_type_to_extension',
            'image_type_to_mime_type','image2wbmp','imagealphablending',
            'imageantialias','imagearc','imagechar','imagecharup',
            'imagecolorallocate','imagecolorallocatealpha','imagecolorat',
            'imagecolorclosest','imagecolorclosestalpha','imagecolordeallocate',
            'imagecolorexact','imagecolorexactalpha','imagecolormatch',
            'imagecolorresolve','imagecolorresolvealpha','imagecolorset',
            'imagecolorsforindex','imagecolorstotal','imagecolortransparent',
            'imageconvolution','imagecopy','imagecopymerge',
            'imagecopymergegray','imagecopyresampled','imagecopyresized',
            'imagecreate','imagecreatefromgd','imagecreatefromgd2',
            'imagecreatefromgd2part','imagecreatefromgif','imagecreatefromjpeg',
            'imagecreatefrompng','imagecreatefromstring','imagecreatefromwbmp',
            'imagecreatefromxbm','imagecreatetruecolor','imagedashedline',
            'imagedestroy','imageellipse','imagefill','imagefilledarc',
            'imagefilledellipse','imagefilledpolygon','imagefilledrectangle',
            'imagefilltoborder','imagefilter','imagefontheight',
            'imagefontwidth','imageftbbox','imagefttext','imagegammacorrect',
            'imagegd','imagegd2','imagegif','imagegrabscreen','imagegrabwindow',
            'imageinterlace','imageistruecolor','imagejpeg','imagelayereffect',
            'imageline','imageloadfont','imagepalettecopy','imagepng',
            'imagepolygon','imagepsbbox','imagepsencodefont',
            'imagepsextendfont','imagepsfreefont','imagepsloadfont',
            'imagepsslantfont','imagepstext','imagerectangle','imagerotate',
            'imagesavealpha','imagesetbrush','imagesetpixel','imagesetstyle',
            'imagesetthickness','imagesettile','imagestring','imagestringup',
            'imagesx','imagesy','imagetruecolortopalette','imagettfbbox',
            'imagettftext','imagetypes','imagewbmp','imagexbm','imap_8bit',
            'imap_alerts','imap_append','imap_base64','imap_binary','imap_body',
            'imap_bodystruct','imap_check','imap_clearflag_full','imap_close',
            'imap_create','imap_createmailbox','imap_delete',
            'imap_deletemailbox','imap_errors','imap_expunge',
            'imap_fetch_overview','imap_fetchbody','imap_fetchheader',
            'imap_fetchstructure','imap_fetchtext','imap_get_quota',
            'imap_get_quotaroot','imap_getacl','imap_getmailboxes',
            'imap_getsubscribed','imap_header','imap_headerinfo','imap_headers',
            'imap_last_error','imap_list','imap_listmailbox',
            'imap_listsubscribed','imap_lsub','imap_mail','imap_mail_compose',
            'imap_mail_copy','imap_mail_move','imap_mailboxmsginfo',
            'imap_mime_header_decode','imap_msgno','imap_num_msg',
            'imap_num_recent','imap_open','imap_ping','imap_qprint',
            'imap_rename','imap_renamemailbox','imap_reopen',
            'imap_rfc822_parse_adrlist','imap_rfc822_parse_headers',
            'imap_rfc822_write_address','imap_savebody','imap_scan',
            'imap_scanmailbox','imap_search','imap_set_quota','imap_setacl',
            'imap_setflag_full','imap_sort','imap_status','imap_subscribe',
            'imap_thread','imap_timeout','imap_uid','imap_undelete',
            'imap_unsubscribe','imap_utf7_decode','imap_utf7_encode',
            'imap_utf8','implode','import_request_variables','in_array',
            'ini_alter','ini_get','ini_get_all','ini_restore','ini_set',
            'intval','ip2long','iptcembed','iptcparse','isset','is_a',
            'is_array','is_bool','is_callable','is_dir','is_double',
            'is_executable','is_file','is_finite','is_float','is_infinite',
            'is_int','is_integer','is_link','is_long','is_nan','is_null',
            'is_numeric','is_object','is_readable','is_real','is_resource',
            'is_scalar','is_soap_fault','is_string','is_subclass_of',
            'is_uploaded_file','is_writable','is_writeable','iterator_apply',
            'iterator_count','iterator_to_array','java_last_exception_clear',
            'java_last_exception_get','jddayofweek','jdmonthname','jdtofrench',
            'jdtogregorian','jdtojewish','jdtojulian','jdtounix','jewishtojd',
            'join','jpeg2wbmp','json_decode','json_encode','juliantojd','key',
            'key_exists','krsort','ksort','lcg_value','ldap_add','ldap_bind',
            'ldap_close','ldap_compare','ldap_connect','ldap_count_entries',
            'ldap_delete','ldap_dn2ufn','ldap_err2str','ldap_errno',
            'ldap_error','ldap_explode_dn','ldap_first_attribute',
            'ldap_first_entry','ldap_first_reference','ldap_free_result',
            'ldap_get_attributes','ldap_get_dn','ldap_get_entries',
            'ldap_get_option','ldap_get_values','ldap_get_values_len',
            'ldap_list','ldap_mod_add','ldap_mod_del','ldap_mod_replace',
            'ldap_modify','ldap_next_attribute','ldap_next_entry',
            'ldap_next_reference','ldap_parse_reference','ldap_parse_result',
            'ldap_read','ldap_rename','ldap_search','ldap_set_option',
            'ldap_sort','ldap_start_tls','ldap_unbind','levenshtein',
            'libxml_clear_errors','libxml_get_errors','libxml_get_last_error',
            'libxml_set_streams_context','libxml_use_internal_errors','link',
            'linkinfo','list','localeconv','localtime','log','log1p','log10',
            'long2ip','lstat','ltrim','lzf_compress','lzf_decompress',
            'lzf_optimized_for','magic_quotes_runtime','mail','max','mbereg',
            'mberegi','mberegi_replace','mbereg_match','mbereg_replace',
            'mbereg_search','mbereg_search_getpos','mbereg_search_getregs',
            'mbereg_search_init','mbereg_search_pos','mbereg_search_regs',
            'mbereg_search_setpos','mbregex_encoding','mbsplit','mbstrcut',
            'mbstrlen','mbstrpos','mbstrrpos','mbsubstr','mb_check_encoding',
            'mb_convert_case','mb_convert_encoding','mb_convert_kana',
            'mb_convert_variables','mb_decode_mimeheader',
            'mb_decode_numericentity','mb_detect_encoding','mb_detect_order',
            'mb_encode_mimeheader','mb_encode_numericentity','mb_ereg',
            'mb_eregi','mb_eregi_replace','mb_ereg_match','mb_ereg_replace',
            'mb_ereg_search','mb_ereg_search_getpos','mb_ereg_search_getregs',
            'mb_ereg_search_init','mb_ereg_search_pos','mb_ereg_search_regs',
            'mb_ereg_search_setpos','mb_get_info','mb_http_input',
            'mb_http_output','mb_internal_encoding','mb_language',
            'mb_list_encodings','mb_output_handler','mb_parse_str',
            'mb_preferred_mime_name','mb_regex_encoding','mb_regex_set_options',
            'mb_send_mail','mb_split','mb_strcut','mb_strimwidth','mb_stripos',
            'mb_stristr','mb_strlen','mb_strpos','mb_strrchr','mb_strrichr',
            'mb_strripos','mb_strrpos','mb_strstr','mb_strtolower',
            'mb_strtoupper','mb_strwidth','mb_substitute_character','mb_substr',
            'mb_substr_count','mcrypt_cbc','mcrypt_cfb','mcrypt_create_iv',
            'mcrypt_decrypt','mcrypt_ecb','mcrypt_enc_get_algorithms_name',
            'mcrypt_enc_get_block_size','mcrypt_enc_get_iv_size',
            'mcrypt_enc_get_key_size','mcrypt_enc_get_modes_name',
            'mcrypt_enc_get_supported_key_sizes',
            'mcrypt_enc_is_block_algorithm',
            'mcrypt_enc_is_block_algorithm_mode','mcrypt_enc_is_block_mode',
            'mcrypt_enc_self_test','mcrypt_encrypt','mcrypt_generic',
            'mcrypt_generic_deinit','mcrypt_generic_end','mcrypt_generic_init',
            'mcrypt_get_block_size','mcrypt_get_cipher_name',
            'mcrypt_get_iv_size','mcrypt_get_key_size','mcrypt_list_algorithms',
            'mcrypt_list_modes','mcrypt_module_close',
            'mcrypt_module_get_algo_block_size',
            'mcrypt_module_get_algo_key_size',
            'mcrypt_module_get_supported_key_sizes',
            'mcrypt_module_is_block_algorithm',
            'mcrypt_module_is_block_algorithm_mode',
            'mcrypt_module_is_block_mode','mcrypt_module_open',
            'mcrypt_module_self_test','mcrypt_ofb','md5','md5_file',
            'mdecrypt_generic','memcache_add','memcache_add_server',
            'memcache_close','memcache_connect','memcache_debug',
            'memcache_decrement','memcache_delete','memcache_flush',
            'memcache_get','memcache_get_extended_stats',
            'memcache_get_server_status','memcache_get_stats',
            'memcache_get_version','memcache_increment','memcache_pconnect',
            'memcache_replace','memcache_set','memcache_set_compress_threshold',
            'memcache_set_server_params','memory_get_peak_usage',
            'memory_get_usage','metaphone','mhash','mhash_count',
            'mhash_get_block_size','mhash_get_hash_name','mhash_keygen_s2k',
            'method_exists','microtime','mime_content_type','min',
            'ming_keypress','ming_setcubicthreshold','ming_setscale',
            'ming_useconstants','ming_useswfversion','mkdir','mktime',
            'money_format','move_uploaded_file','msql','msql_affected_rows',
            'msql_close','msql_connect','msql_create_db','msql_createdb',
            'msql_data_seek','msql_db_query','msql_dbname','msql_drop_db',
            'msql_dropdb','msql_error','msql_fetch_array','msql_fetch_field',
            'msql_fetch_object','msql_fetch_row','msql_field_flags',
            'msql_field_len','msql_field_name','msql_field_seek',
            'msql_field_table','msql_field_type','msql_fieldflags',
            'msql_fieldlen','msql_fieldname','msql_fieldtable','msql_fieldtype',
            'msql_free_result','msql_freeresult','msql_list_dbs',
            'msql_list_fields','msql_list_tables','msql_listdbs',
            'msql_listfields','msql_listtables','msql_num_fields',
            'msql_num_rows','msql_numfields','msql_numrows','msql_pconnect',
            'msql_query','msql_regcase','msql_result','msql_select_db',
            'msql_selectdb','msql_tablename','mssql_bind','mssql_close',
            'mssql_connect','mssql_data_seek','mssql_execute',
            'mssql_fetch_array','mssql_fetch_assoc','mssql_fetch_batch',
            'mssql_fetch_field','mssql_fetch_object','mssql_fetch_row',
            'mssql_field_length','mssql_field_name','mssql_field_seek',
            'mssql_field_type','mssql_free_result','mssql_free_statement',
            'mssql_get_last_message','mssql_guid_string','mssql_init',
            'mssql_min_error_severity','mssql_min_message_severity',
            'mssql_next_result','mssql_num_fields','mssql_num_rows',
            'mssql_pconnect','mssql_query','mssql_result','mssql_rows_affected',
            'mssql_select_db','mt_getrandmax','mt_rand','mt_srand','mysql',
            'mysql_affected_rows','mysql_client_encoding','mysql_close',
            'mysql_connect','mysql_createdb','mysql_create_db',
            'mysql_data_seek','mysql_dbname','mysql_db_name','mysql_db_query',
            'mysql_dropdb','mysql_drop_db','mysql_errno','mysql_error',
            'mysql_escape_string','mysql_fetch_array','mysql_fetch_assoc',
            'mysql_fetch_field','mysql_fetch_lengths','mysql_fetch_object',
            'mysql_fetch_row','mysql_fieldflags','mysql_fieldlen',
            'mysql_fieldname','mysql_fieldtable','mysql_fieldtype',
            'mysql_field_flags','mysql_field_len','mysql_field_name',
            'mysql_field_seek','mysql_field_table','mysql_field_type',
            'mysql_freeresult','mysql_free_result','mysql_get_client_info',
            'mysql_get_host_info','mysql_get_proto_info',
            'mysql_get_server_info','mysql_info','mysql_insert_id',
            'mysql_listdbs','mysql_listfields','mysql_listtables',
            'mysql_list_dbs','mysql_list_fields','mysql_list_processes',
            'mysql_list_tables','mysql_numfields','mysql_numrows',
            'mysql_num_fields','mysql_num_rows','mysql_pconnect','mysql_ping',
            'mysql_query','mysql_real_escape_string','mysql_result',
            'mysql_selectdb','mysql_select_db','mysql_set_charset','mysql_stat',
            'mysql_tablename','mysql_table_name','mysql_thread_id',
            'mysql_unbuffered_query','mysqli_affected_rows','mysqli_autocommit',
            'mysqli_bind_param','mysqli_bind_result','mysqli_change_user',
            'mysqli_character_set_name','mysqli_client_encoding','mysqli_close',
            'mysqli_commit','mysqli_connect','mysqli_connect_errno',
            'mysqli_connect_error','mysqli_data_seek','mysqli_debug',
            'mysqli_disable_reads_from_master','mysqli_disable_rpl_parse',
            'mysqli_dump_debug_info','mysqli_embedded_server_end',
            'mysqli_embedded_server_start','mysqli_enable_reads_from_master',
            'mysqli_enable_rpl_parse','mysqli_errno','mysqli_error',
            'mysqli_escape_string','mysqli_execute','mysqli_fetch',
            'mysqli_fetch_array','mysqli_fetch_assoc','mysqli_fetch_field',
            'mysqli_fetch_field_direct','mysqli_fetch_fields',
            'mysqli_fetch_lengths','mysqli_fetch_object','mysqli_fetch_row',
            'mysqli_field_count','mysqli_field_seek','mysqli_field_tell',
            'mysqli_free_result','mysqli_get_charset','mysqli_get_client_info',
            'mysqli_get_client_version','mysqli_get_host_info',
            'mysqli_get_metadata','mysqli_get_proto_info',
            'mysqli_get_server_info','mysqli_get_server_version',
            'mysqli_get_warnings','mysqli_info','mysqli_init',
            'mysqli_insert_id','mysqli_kill','mysqli_master_query',
            'mysqli_more_results','mysqli_multi_query','mysqli_next_result',
            'mysqli_num_fields','mysqli_num_rows','mysqli_options',
            'mysqli_param_count','mysqli_ping','mysqli_prepare','mysqli_query',
            'mysqli_real_connect','mysqli_real_escape_string',
            'mysqli_real_query','mysqli_report','mysqli_rollback',
            'mysqli_rpl_parse_enabled','mysqli_rpl_probe',
            'mysqli_rpl_query_type','mysqli_select_db','mysqli_send_long_data',
            'mysqli_send_query','mysqli_set_charset',
            'mysqli_set_local_infile_default','mysqli_set_local_infile_handler',
            'mysqli_set_opt','mysqli_slave_query','mysqli_sqlstate',
            'mysqli_ssl_set','mysqli_stat','mysqli_stmt_affected_rows',
            'mysqli_stmt_attr_get','mysqli_stmt_attr_set',
            'mysqli_stmt_bind_param','mysqli_stmt_bind_result',
            'mysqli_stmt_close','mysqli_stmt_data_seek','mysqli_stmt_errno',
            'mysqli_stmt_error','mysqli_stmt_execute','mysqli_stmt_fetch',
            'mysqli_stmt_field_count','mysqli_stmt_free_result',
            'mysqli_stmt_get_warnings','mysqli_stmt_init',
            'mysqli_stmt_insert_id','mysqli_stmt_num_rows',
            'mysqli_stmt_param_count','mysqli_stmt_prepare','mysqli_stmt_reset',
            'mysqli_stmt_result_metadata','mysqli_stmt_send_long_data',
            'mysqli_stmt_sqlstate','mysqli_stmt_store_result',
            'mysqli_store_result','mysqli_thread_id','mysqli_thread_safe',
            'mysqli_use_result','mysqli_warning_count','natcasesort','natsort',
            'new_xmldoc','next','ngettext','nl2br','nl_langinfo',
            'ntuser_getdomaincontroller','ntuser_getusergroups',
            'ntuser_getuserinfo','ntuser_getuserlist','number_format',
            'ob_clean','ob_deflatehandler','ob_end_clean','ob_end_flush',
            'ob_etaghandler','ob_flush','ob_get_clean','ob_get_contents',
            'ob_get_flush','ob_get_length','ob_get_level','ob_get_status',
            'ob_gzhandler','ob_iconv_handler','ob_implicit_flush',
            'ob_inflatehandler','ob_list_handlers','ob_start','ob_tidyhandler',
            'octdec','odbc_autocommit','odbc_binmode','odbc_close',
            'odbc_close_all','odbc_columnprivileges','odbc_columns',
            'odbc_commit','odbc_connect','odbc_cursor','odbc_data_source',
            'odbc_do','odbc_error','odbc_errormsg','odbc_exec','odbc_execute',
            'odbc_fetch_array','odbc_fetch_into','odbc_fetch_object',
            'odbc_fetch_row','odbc_field_len','odbc_field_name',
            'odbc_field_num','odbc_field_precision','odbc_field_scale',
            'odbc_field_type','odbc_foreignkeys','odbc_free_result',
            'odbc_gettypeinfo','odbc_longreadlen','odbc_next_result',
            'odbc_num_fields','odbc_num_rows','odbc_pconnect','odbc_prepare',
            'odbc_primarykeys','odbc_procedurecolumns','odbc_procedures',
            'odbc_result','odbc_result_all','odbc_rollback','odbc_setoption',
            'odbc_specialcolumns','odbc_statistics','odbc_tableprivileges',
            'odbc_tables','opendir','openlog','openssl_csr_export',
            'openssl_csr_export_to_file','openssl_csr_get_public_key',
            'openssl_csr_get_subject','openssl_csr_new','openssl_csr_sign',
            'openssl_error_string','openssl_free_key','openssl_get_privatekey',
            'openssl_get_publickey','openssl_open','openssl_pkcs12_export',
            'openssl_pkcs12_export_to_file','openssl_pkcs12_read',
            'openssl_pkcs7_decrypt','openssl_pkcs7_encrypt',
            'openssl_pkcs7_sign','openssl_pkcs7_verify','openssl_pkey_export',
            'openssl_pkey_export_to_file','openssl_pkey_free',
            'openssl_pkey_get_details','openssl_pkey_get_private',
            'openssl_pkey_get_public','openssl_pkey_new',
            'openssl_private_decrypt','openssl_private_encrypt',
            'openssl_public_decrypt','openssl_public_encrypt','openssl_seal',
            'openssl_sign','openssl_verify','openssl_x509_checkpurpose',
            'openssl_x509_check_private_key','openssl_x509_export',
            'openssl_x509_export_to_file','openssl_x509_free',
            'openssl_x509_parse','openssl_x509_read','ord',
            'output_add_rewrite_var','output_reset_rewrite_vars','overload',
            'outputdebugstring','pack','parse_ini_file','parse_str','parse_url',
            'parsekit_compile_file','parsekit_compile_string',
            'parsekit_func_arginfo','parsekit_opcode_flags',
            'parsekit_opcode_name','passthru','pathinfo','pclose',
            'pdf_add_bookmark','pdf_add_launchlink','pdf_add_locallink',
            'pdf_add_nameddest','pdf_add_note','pdf_add_pdflink',
            'pdf_add_thumbnail','pdf_add_weblink','pdf_arc','pdf_arcn',
            'pdf_attach_file','pdf_begin_font','pdf_begin_glyph',
            'pdf_begin_page','pdf_begin_pattern','pdf_begin_template',
            'pdf_circle','pdf_clip','pdf_close','pdf_close_image',
            'pdf_close_pdi','pdf_close_pdi_page','pdf_closepath',
            'pdf_closepath_fill_stroke','pdf_closepath_stroke','pdf_concat',
            'pdf_continue_text','pdf_create_gstate','pdf_create_pvf',
            'pdf_curveto','pdf_delete','pdf_delete_pvf','pdf_encoding_set_char',
            'pdf_end_font','pdf_end_glyph','pdf_end_page','pdf_end_pattern',
            'pdf_end_template','pdf_endpath','pdf_fill','pdf_fill_imageblock',
            'pdf_fill_pdfblock','pdf_fill_stroke','pdf_fill_textblock',
            'pdf_findfont','pdf_fit_image','pdf_fit_pdi_page',
            'pdf_fit_textline','pdf_get_apiname','pdf_get_buffer',
            'pdf_get_errmsg','pdf_get_errnum','pdf_get_parameter',
            'pdf_get_pdi_parameter','pdf_get_pdi_value','pdf_get_value',
            'pdf_initgraphics','pdf_lineto','pdf_load_font',
            'pdf_load_iccprofile','pdf_load_image','pdf_makespotcolor',
            'pdf_moveto','pdf_new','pdf_open_ccitt','pdf_open_file',
            'pdf_open_image','pdf_open_image_file','pdf_open_pdi',
            'pdf_open_pdi_page','pdf_place_image','pdf_place_pdi_page',
            'pdf_process_pdi','pdf_rect','pdf_restore','pdf_rotate','pdf_save',
            'pdf_scale','pdf_set_border_color','pdf_set_border_dash',
            'pdf_set_border_style','pdf_set_gstate','pdf_set_info',
            'pdf_set_parameter','pdf_set_text_pos','pdf_set_value',
            'pdf_setcolor','pdf_setdash','pdf_setdashpattern','pdf_setflat',
            'pdf_setfont','pdf_setlinecap','pdf_setlinejoin','pdf_setlinewidth',
            'pdf_setmatrix','pdf_setmiterlimit','pdf_setpolydash','pdf_shading',
            'pdf_shading_pattern','pdf_shfill','pdf_show','pdf_show_boxed',
            'pdf_show_xy','pdf_skew','pdf_stringwidth','pdf_stroke',
            'pdf_translate','pdo_drivers','pfsockopen','pg_affected_rows',
            'pg_cancel_query','pg_clientencoding','pg_client_encoding',
            'pg_close','pg_cmdtuples','pg_connect','pg_connection_busy',
            'pg_connection_reset','pg_connection_status','pg_convert',
            'pg_copy_from','pg_copy_to','pg_dbname','pg_delete','pg_end_copy',
            'pg_errormessage','pg_escape_bytea','pg_escape_string','pg_exec',
            'pg_execute','pg_fetch_all','pg_fetch_all_columns','pg_fetch_array',
            'pg_fetch_assoc','pg_fetch_object','pg_fetch_result','pg_fetch_row',
            'pg_fieldisnull','pg_fieldname','pg_fieldnum','pg_fieldprtlen',
            'pg_fieldsize','pg_fieldtype','pg_field_is_null','pg_field_name',
            'pg_field_num','pg_field_prtlen','pg_field_size','pg_field_table',
            'pg_field_type','pg_field_type_oid','pg_free_result',
            'pg_freeresult','pg_get_notify','pg_get_pid','pg_get_result',
            'pg_getlastoid','pg_host','pg_insert','pg_last_error',
            'pg_last_notice','pg_last_oid','pg_loclose','pg_locreate',
            'pg_loexport','pg_loimport','pg_loopen','pg_loread','pg_loreadall',
            'pg_lounlink','pg_lowrite','pg_lo_close','pg_lo_create',
            'pg_lo_export','pg_lo_import','pg_lo_open','pg_lo_read',
            'pg_lo_read_all','pg_lo_seek','pg_lo_tell','pg_lo_unlink',
            'pg_lo_write','pg_meta_data','pg_numfields','pg_numrows',
            'pg_num_fields','pg_num_rows','pg_options','pg_parameter_status',
            'pg_pconnect','pg_ping','pg_port','pg_prepare','pg_put_line',
            'pg_query','pg_query_params','pg_result','pg_result_error',
            'pg_result_error_field','pg_result_seek','pg_result_status',
            'pg_select','pg_send_execute','pg_send_prepare','pg_send_query',
            'pg_send_query_params','pg_set_client_encoding',
            'pg_set_error_verbosity','pg_setclientencoding','pg_trace',
            'pg_transaction_status','pg_tty','pg_unescape_bytea','pg_untrace',
            'pg_update','pg_version','php_egg_logo_guid','php_ini_loaded_file',
            'php_ini_scanned_files','php_logo_guid','php_real_logo_guid',
            'php_sapi_name','php_strip_whitespace','php_uname','phpcredits',
            'phpdoc_xml_from_string','phpinfo','phpversion','pi','png2wbmp',
            'pop3_close','pop3_delete_message','pop3_get_account_size',
            'pop3_get_message','pop3_get_message_count',
            'pop3_get_message_header','pop3_get_message_ids',
            'pop3_get_message_size','pop3_get_message_sizes','pop3_open',
            'pop3_undelete','popen','pos','posix_ctermid','posix_errno',
            'posix_getcwd','posix_getegid','posix_geteuid','posix_getgid',
            'posix_getgrgid','posix_getgrnam','posix_getgroups',
            'posix_getlogin','posix_getpgid','posix_getpgrp','posix_getpid',
            'posix_getppid','posix_getpwnam','posix_getpwuid','posix_getrlimit',
            'posix_getsid','posix_getuid','posix_get_last_error','posix_isatty',
            'posix_kill','posix_mkfifo','posix_setegid','posix_seteuid',
            'posix_setgid','posix_setpgid','posix_setsid','posix_setuid',
            'posix_strerror','posix_times','posix_ttyname','posix_uname','pow',
            'preg_grep','preg_last_error','preg_match','preg_match_all',
            'preg_quote','preg_replace','preg_replace_callback','preg_split',
            'prev','print_r','printf','proc_close','proc_get_status',
            'proc_open','proc_terminate','putenv','quoted_printable_decode',
            'quotemeta','rad2deg','radius_acct_open','radius_add_server',
            'radius_auth_open','radius_close','radius_config',
            'radius_create_request','radius_cvt_addr','radius_cvt_int',
            'radius_cvt_string','radius_demangle','radius_demangle_mppe_key',
            'radius_get_attr','radius_get_vendor_attr','radius_put_addr',
            'radius_put_attr','radius_put_int','radius_put_string',
            'radius_put_vendor_addr','radius_put_vendor_attr',
            'radius_put_vendor_int','radius_put_vendor_string',
            'radius_request_authenticator','radius_send_request',
            'radius_server_secret','radius_strerror','rand','range',
            'rawurldecode','rawurlencode','read_exif_data','readdir','readfile',
            'readgzfile','readlink','realpath','reg_close_key','reg_create_key',
            'reg_enum_key','reg_enum_value','reg_get_value','reg_open_key',
            'reg_set_value','register_shutdown_function',
            'register_tick_function','rename','res_close','res_get','res_list',
            'res_list_type','res_open','res_set','reset',
            'restore_error_handler','restore_include_path','rewind','rewinddir',
            'rmdir','round','rsort','rtrim','runkit_class_adopt',
            'runkit_class_emancipate','runkit_constant_add',
            'runkit_constant_redefine','runkit_constant_remove',
            'runkit_default_property_add','runkit_function_add',
            'runkit_function_copy','runkit_function_redefine',
            'runkit_function_remove','runkit_function_rename','runkit_import',
            'runkit_lint','runkit_lint_file','runkit_method_add',
            'runkit_method_copy','runkit_method_redefine',
            'runkit_method_remove','runkit_method_rename','runkit_object_id',
            'runkit_return_value_used','runkit_sandbox_output_handler',
            'runkit_superglobals','runkit_zval_inspect','scandir','sem_acquire',
            'sem_get','sem_release','sem_remove','serialize',
            'session_cache_expire','session_cache_limiter','session_commit',
            'session_decode','session_destroy','session_encode',
            'session_get_cookie_params','session_id','session_is_registered',
            'session_module_name','session_name','session_regenerate_id',
            'session_register','session_save_path','session_set_cookie_params',
            'session_set_save_handler','session_start','session_unregister',
            'session_unset','session_write_close','set_content',
            'set_error_handler','set_file_buffer','set_include_path',
            'set_magic_quotes_runtime','set_socket_blocking','set_time_limit',
            'setcookie','setlocale','setrawcookie','settype','sha1','sha1_file',
            'shell_exec','shmop_close','shmop_delete','shmop_open','shmop_read',
            'shmop_size','shmop_write','shm_attach','shm_detach','shm_get_var',
            'shm_put_var','shm_remove','shm_remove_var','show_source','shuffle',
            'similar_text','simplexml_import_dom','simplexml_load_file',
            'simplexml_load_string','sin','sinh','sizeof','sleep','smtp_close',
            'smtp_cmd_data','smtp_cmd_mail','smtp_cmd_rcpt','smtp_connect',
            'snmp_get_quick_print','snmp_get_valueretrieval','snmp_read_mib',
            'snmp_set_quick_print','snmp_set_valueretrieval','snmp2_get',
            'snmp2_getnext','snmp2_real_walk','snmp2_set','snmp2_walk',
            'snmp3_get','snmp3_getnext','snmp3_real_walk','snmp3_set',
            'snmp3_walk','snmpget','snmpgetnext','snmprealwalk','snmpset',
            'snmpwalk','snmpwalkoid','socket_accept','socket_bind',
            'socket_clear_error','socket_close','socket_connect',
            'socket_create','socket_create_listen','socket_create_pair',
            'socket_getopt','socket_getpeername','socket_getsockname',
            'socket_get_option','socket_get_status','socket_iovec_add',
            'socket_iovec_alloc','socket_iovec_delete','socket_iovec_fetch',
            'socket_iovec_free','socket_iovec_set','socket_last_error',
            'socket_listen','socket_read','socket_readv','socket_recv',
            'socket_recvfrom','socket_recvmsg','socket_select','socket_send',
            'socket_sendmsg','socket_sendto','socket_setopt','socket_set_block',
            'socket_set_blocking','socket_set_nonblock','socket_set_option',
            'socket_set_timeout','socket_shutdown','socket_strerror',
            'socket_write','socket_writev','sort','soundex','spl_autoload',
            'spl_autoload_call','spl_autoload_extensions',
            'spl_autoload_functions','spl_autoload_register',
            'spl_autoload_unregister','spl_classes','spl_object_hash','split',
            'spliti','sprintf','sql_regcase','sqlite_array_query',
            'sqlite_busy_timeout','sqlite_changes','sqlite_close',
            'sqlite_column','sqlite_create_aggregate','sqlite_create_function',
            'sqlite_current','sqlite_error_string','sqlite_escape_string',
            'sqlite_exec','sqlite_factory','sqlite_fetch_all',
            'sqlite_fetch_array','sqlite_fetch_column_types',
            'sqlite_fetch_object','sqlite_fetch_single','sqlite_fetch_string',
            'sqlite_field_name','sqlite_has_more','sqlite_has_prev',
            'sqlite_last_error','sqlite_last_insert_rowid','sqlite_libencoding',
            'sqlite_libversion','sqlite_next','sqlite_num_fields',
            'sqlite_num_rows','sqlite_open','sqlite_popen','sqlite_prev',
            'sqlite_query','sqlite_rewind','sqlite_seek','sqlite_single_query',
            'sqlite_udf_decode_binary','sqlite_udf_encode_binary',
            'sqlite_unbuffered_query','sqlite_valid','sqrt','srand','sscanf',
            'ssh2_auth_hostbased_file','ssh2_auth_none','ssh2_auth_password',
            'ssh2_auth_pubkey_file','ssh2_connect','ssh2_exec',
            'ssh2_fetch_stream','ssh2_fingerprint','ssh2_forward_accept',
            'ssh2_forward_listen','ssh2_methods_negotiated','ssh2_poll',
            'ssh2_publickey_add','ssh2_publickey_init','ssh2_publickey_list',
            'ssh2_publickey_remove','ssh2_scp_recv','ssh2_scp_send','ssh2_sftp',
            'ssh2_sftp_lstat','ssh2_sftp_mkdir','ssh2_sftp_readlink',
            'ssh2_sftp_realpath','ssh2_sftp_rename','ssh2_sftp_rmdir',
            'ssh2_sftp_stat','ssh2_sftp_symlink','ssh2_sftp_unlink',
            'ssh2_shell','ssh2_tunnel','stat','stats_absolute_deviation',
            'stats_cdf_beta','stats_cdf_binomial','stats_cdf_cauchy',
            'stats_cdf_chisquare','stats_cdf_exponential','stats_cdf_f',
            'stats_cdf_gamma','stats_cdf_laplace','stats_cdf_logistic',
            'stats_cdf_negative_binomial','stats_cdf_noncentral_chisquare',
            'stats_cdf_noncentral_f','stats_cdf_noncentral_t',
            'stats_cdf_normal','stats_cdf_poisson','stats_cdf_t',
            'stats_cdf_uniform','stats_cdf_weibull','stats_covariance',
            'stats_dens_beta','stats_dens_cauchy','stats_dens_chisquare',
            'stats_dens_exponential','stats_dens_f','stats_dens_gamma',
            'stats_dens_laplace','stats_dens_logistic','stats_dens_normal',
            'stats_dens_pmf_binomial','stats_dens_pmf_hypergeometric',
            'stats_dens_pmf_negative_binomial','stats_dens_pmf_poisson',
            'stats_dens_t','stats_dens_uniform','stats_dens_weibull',
            'stats_harmonic_mean','stats_kurtosis','stats_rand_gen_beta',
            'stats_rand_gen_chisquare','stats_rand_gen_exponential',
            'stats_rand_gen_f','stats_rand_gen_funiform','stats_rand_gen_gamma',
            'stats_rand_gen_ipoisson','stats_rand_gen_iuniform',
            'stats_rand_gen_noncenral_f','stats_rand_gen_noncentral_chisquare',
            'stats_rand_gen_noncentral_t','stats_rand_gen_normal',
            'stats_rand_gen_t','stats_rand_getsd','stats_rand_ibinomial',
            'stats_rand_ibinomial_negative','stats_rand_ignlgi',
            'stats_rand_phrase_to_seeds','stats_rand_ranf','stats_rand_setall',
            'stats_skew','stats_standard_deviation','stats_stat_binomial_coef',
            'stats_stat_correlation','stats_stat_factorial',
            'stats_stat_independent_t','stats_stat_innerproduct',
            'stats_stat_paired_t','stats_stat_percentile','stats_stat_powersum',
            'stats_variance','strcasecmp','strchr','strcmp','strcoll','strcspn',
            'stream_bucket_append','stream_bucket_make_writeable',
            'stream_bucket_new','stream_bucket_prepend','stream_context_create',
            'stream_context_get_default','stream_context_get_options',
            'stream_context_set_default','stream_context_set_option',
            'stream_context_set_params','stream_copy_to_stream',
            'stream_encoding','stream_filter_append','stream_filter_prepend',
            'stream_filter_register','stream_filter_remove',
            'stream_get_contents','stream_get_filters','stream_get_line',
            'stream_get_meta_data','stream_get_transports',
            'stream_get_wrappers','stream_is_local',
            'stream_notification_callback','stream_register_wrapper',
            'stream_resolve_include_path','stream_select','stream_set_blocking',
            'stream_set_timeout','stream_set_write_buffer',
            'stream_socket_accept','stream_socket_client',
            'stream_socket_enable_crypto','stream_socket_get_name',
            'stream_socket_pair','stream_socket_recvfrom',
            'stream_socket_sendto','stream_socket_server',
            'stream_socket_shutdown','stream_supports_lock',
            'stream_wrapper_register','stream_wrapper_restore',
            'stream_wrapper_unregister','strftime','stripcslashes','stripos',
            'stripslashes','strip_tags','stristr','strlen','strnatcasecmp',
            'strnatcmp','strpbrk','strncasecmp','strncmp','strpos','strrchr',
            'strrev','strripos','strrpos','strspn','strstr','strtok',
            'strtolower','strtotime','strtoupper','strtr','strval',
            'str_ireplace','str_pad','str_repeat','str_replace','str_rot13',
            'str_split','str_shuffle','str_word_count','substr',
            'substr_compare','substr_count','substr_replace','svn_add',
            'svn_auth_get_parameter','svn_auth_set_parameter','svn_cat',
            'svn_checkout','svn_cleanup','svn_client_version','svn_commit',
            'svn_diff','svn_export','svn_fs_abort_txn','svn_fs_apply_text',
            'svn_fs_begin_txn2','svn_fs_change_node_prop','svn_fs_check_path',
            'svn_fs_contents_changed','svn_fs_copy','svn_fs_delete',
            'svn_fs_dir_entries','svn_fs_file_contents','svn_fs_file_length',
            'svn_fs_is_dir','svn_fs_is_file','svn_fs_make_dir',
            'svn_fs_make_file','svn_fs_node_created_rev','svn_fs_node_prop',
            'svn_fs_props_changed','svn_fs_revision_prop',
            'svn_fs_revision_root','svn_fs_txn_root','svn_fs_youngest_rev',
            'svn_import','svn_info','svn_log','svn_ls','svn_repos_create',
            'svn_repos_fs','svn_repos_fs_begin_txn_for_commit',
            'svn_repos_fs_commit_txn','svn_repos_hotcopy','svn_repos_open',
            'svn_repos_recover','svn_status','svn_update','symlink',
            'sys_get_temp_dir','syslog','system','tan','tanh','tempnam',
            'textdomain','thread_get','thread_include','thread_lock',
            'thread_lock_try','thread_mutex_destroy','thread_mutex_init',
            'thread_set','thread_start','thread_unlock','tidy_access_count',
            'tidy_clean_repair','tidy_config_count','tidy_diagnose',
            'tidy_error_count','tidy_get_body','tidy_get_config',
            'tidy_get_error_buffer','tidy_get_head','tidy_get_html',
            'tidy_get_html_ver','tidy_get_output','tidy_get_release',
            'tidy_get_root','tidy_get_status','tidy_getopt','tidy_is_xhtml',
            'tidy_is_xml','tidy_parse_file','tidy_parse_string',
            'tidy_repair_file','tidy_repair_string','tidy_warning_count','time',
            'timezone_abbreviations_list','timezone_identifiers_list',
            'timezone_name_from_abbr','timezone_name_get','timezone_offset_get',
            'timezone_open','timezone_transitions_get','tmpfile',
            'token_get_all','token_name','touch','trigger_error',
            'transliterate','transliterate_filters_get','trim','uasort',
            'ucfirst','ucwords','uksort','umask','uniqid','unixtojd','unlink',
            'unpack','unregister_tick_function','unserialize','unset',
            'urldecode','urlencode','user_error','use_soap_error_handler',
            'usleep','usort','utf8_decode','utf8_encode','var_dump',
            'var_export','variant_abs','variant_add','variant_and',
            'variant_cast','variant_cat','variant_cmp',
            'variant_date_from_timestamp','variant_date_to_timestamp',
            'variant_div','variant_eqv','variant_fix','variant_get_type',
            'variant_idiv','variant_imp','variant_int','variant_mod',
            'variant_mul','variant_neg','variant_not','variant_or',
            'variant_pow','variant_round','variant_set','variant_set_type',
            'variant_sub','variant_xor','version_compare','virtual','vfprintf',
            'vprintf','vsprintf','wddx_add_vars','wddx_deserialize',
            'wddx_packet_end','wddx_packet_start','wddx_serialize_value',
            'wddx_serialize_vars','win_beep','win_browse_file',
            'win_browse_folder','win_create_link','win_message_box',
            'win_play_wav','win_shell_execute','win32_create_service',
            'win32_delete_service','win32_get_last_control_message',
            'win32_ps_list_procs','win32_ps_stat_mem','win32_ps_stat_proc',
            'win32_query_service_status','win32_scheduler_delete_task',
            'win32_scheduler_enum_tasks','win32_scheduler_get_task_info',
            'win32_scheduler_run','win32_scheduler_set_task_info',
            'win32_set_service_status','win32_start_service',
            'win32_start_service_ctrl_dispatcher','win32_stop_service',
            'wordwrap','xml_error_string','xml_get_current_byte_index',
            'xml_get_current_column_number','xml_get_current_line_number',
            'xml_get_error_code','xml_parse','xml_parser_create',
            'xml_parser_create_ns','xml_parser_free','xml_parser_get_option',
            'xml_parser_set_option','xml_parse_into_struct',
            'xml_set_character_data_handler','xml_set_default_handler',
            'xml_set_element_handler','xml_set_end_namespace_decl_handler',
            'xml_set_external_entity_ref_handler',
            'xml_set_notation_decl_handler','xml_set_object',
            'xml_set_processing_instruction_handler',
            'xml_set_start_namespace_decl_handler',
            'xml_set_unparsed_entity_decl_handler','xmldoc','xmldocfile',
            'xmlrpc_decode','xmlrpc_decode_request','xmlrpc_encode',
            'xmlrpc_encode_request','xmlrpc_get_type','xmlrpc_is_fault',
            'xmlrpc_parse_method_descriptions',
            'xmlrpc_server_add_introspection_data','xmlrpc_server_call_method',
            'xmlrpc_server_create','xmlrpc_server_destroy',
            'xmlrpc_server_register_introspection_callback',
            'xmlrpc_server_register_method','xmlrpc_set_type','xmltree',
            'xmlwriter_end_attribute','xmlwriter_end_cdata',
            'xmlwriter_end_comment','xmlwriter_end_document',
            'xmlwriter_end_dtd','xmlwriter_end_dtd_attlist',
            'xmlwriter_end_dtd_element','xmlwriter_end_dtd_entity',
            'xmlwriter_end_element','xmlwriter_end_pi','xmlwriter_flush',
            'xmlwriter_full_end_element','xmlwriter_open_memory',
            'xmlwriter_open_uri','xmlwriter_output_memory',
            'xmlwriter_set_indent','xmlwriter_set_indent_string',
            'xmlwriter_start_attribute','xmlwriter_start_attribute_ns',
            'xmlwriter_start_cdata','xmlwriter_start_comment',
            'xmlwriter_start_document','xmlwriter_start_dtd',
            'xmlwriter_start_dtd_attlist','xmlwriter_start_dtd_element',
            'xmlwriter_start_dtd_entity','xmlwriter_start_element',
            'xmlwriter_start_element_ns','xmlwriter_start_pi','xmlwriter_text',
            'xmlwriter_write_attribute','xmlwriter_write_attribute_ns',
            'xmlwriter_write_cdata','xmlwriter_write_comment',
            'xmlwriter_write_dtd','xmlwriter_write_dtd_attlist',
            'xmlwriter_write_dtd_element','xmlwriter_write_dtd_entity',
            'xmlwriter_write_element','xmlwriter_write_element_ns',
            'xmlwriter_write_pi','xmlwriter_write_raw','xpath_eval',
            'xpath_eval_expression','xpath_new_context','xpath_register_ns',
            'xpath_register_ns_auto','xptr_eval','xptr_new_context','yp_all',
            'yp_cat','yp_errno','yp_err_string','yp_first',
            'yp_get_default_domain','yp_master','yp_match','yp_next','yp_order',
            'zend_current_obfuscation_level','zend_get_cfg_var','zend_get_id',
            'zend_loader_current_file','zend_loader_enabled',
            'zend_loader_file_encoded','zend_loader_file_licensed',
            'zend_loader_install_license','zend_loader_version',
            'zend_logo_guid','zend_match_hostmasks','zend_obfuscate_class_name',
            'zend_obfuscate_function_name','zend_optimizer_version',
            'zend_runtime_obfuscate','zend_version','zip_close',
            'zip_entry_close','zip_entry_compressedsize',
            'zip_entry_compressionmethod','zip_entry_filesize','zip_entry_name',
            'zip_entry_open','zip_entry_read','zip_open','zip_read',
            'zlib_get_coding_type', 'get_called_class', 'get_mangled_object_vars',
            'property_exists', 'interface_exists', 'trait_exists', 'class_alias',
            'set_exception_handler', 'restore_exception_handler', 'get_declared_traits',
            'get_declared_interfaces', 'get_resource_id', 'get_resources', 'debug_print_backtrace',
            'gc_mem_caches', 'gc_collect_cycles', 'gc_enabled', 'gc_enable', 'gc_disable',
            'gc_status', 'date_create_immutable', 'date_create_from_format',
            'date_create_immutable_from_format', 'date_parse_from_format', 'date_get_last_errors',
            'date_add', 'date_sub', 'date_diff', 'date_timestamp_set', 'date_timestamp_get',
            'timezone_location_get', 'timezone_version_get', 'date_interval_create_from_date_string',
            'date_interval_format', 'libxml_disable_entity_loader', 'libxml_set_external_entity_loader',
            'openssl_x509_fingerprint', 'openssl_x509_verify', 'openssl_pbkdf2', 'openssl_pkcs7_read',
            'openssl_cms_verify', 'openssl_cms_encrypt', 'openssl_cms_sign', 'openssl_cms_decrypt',
            'openssl_cms_read', 'openssl_get_md_methods', 'openssl_get_cipher_methods',
            'openssl_get_curve_names', 'openssl_digest', 'openssl_encrypt', 'openssl_decrypt',
            'openssl_cipher_iv_length', 'openssl_dh_compute_key', 'openssl_pkey_derive',
            'openssl_random_pseudo_bytes', 'openssl_spki_new', 'openssl_spki_verify',
            'openssl_spki_export', 'openssl_spki_export_challenge', 'openssl_get_cert_locations',
            'preg_filter', 'preg_replace_callback_array', 'preg_last_error_msg', 'zlib_encode',
            'zlib_decode', 'gzdecode', 'deflate_init', 'deflate_add', 'inflate_init', 'inflate_add',
            'inflate_get_status', 'inflate_get_read_len', 'curl_escape', 'curl_unescape',
            'curl_multi_setopt', 'curl_file_create', 'curl_multi_errno', 'curl_multi_strerror',
            'curl_pause', 'curl_reset', 'curl_share_close', 'curl_share_errno', 'curl_share_init',
            'curl_share_setopt', 'curl_share_strerror', 'curl_strerror', 'ftp_mlsd', 'ftp_append',
            'imagepalettetotruecolor', 'imagecreatefromwebp', 'imagecreatefromxpm',
            'imagecreatefrombmp', 'imagecreatefromtga', 'imagewebp', 'imagebmp',
            'imagecolorclosesthwb', 'imageopenpolygon', 'imagesetclip', 'imagegetclip',
            'imageflip', 'imagecrop', 'imagecropauto', 'imagescale', 'imageaffine',
            'imageaffinematrixget', 'imageaffinematrixconcat', 'imagegetinterpolation',
            'imagesetinterpolation', 'imageresolution', '_', 'gmp_import', 'gmp_export',
            'gmp_root', 'gmp_rootrem', 'gmp_perfect_power', 'gmp_lcm', 'gmp_kronecker',
            'gmp_random_seed', 'gmp_random_bits', 'gmp_random_range', 'gmp_testbit', 'gmp_binomial',
            'hash_copy', 'hash_hmac_algos', 'hash_pbkdf2', 'hash_equals', 'hash_hkdf',
            'intlcal_create_instance', 'intlcal_get_keyword_values_for_locale', 'intlcal_get_now',
            'intlcal_get_available_locales', 'intlcal_get', 'intlcal_get_time', 'intlcal_set_time',
            'intlcal_add', 'intlcal_set_time_zone', 'intlcal_after', 'intlcal_before',
            'intlcal_set', 'intlcal_roll', 'intlcal_clear', 'intlcal_field_difference',
            'intlcal_get_actual_maximum', 'intlcal_get_actual_minimum',
            'intlcal_get_day_of_week_type', 'intlcal_get_first_day_of_week',
            'intlcal_get_least_maximum', 'intlcal_get_greatest_minimum',
            'intlcal_get_locale', 'intlcal_get_maximum', 'intlcal_get_minimal_days_in_first_week',
            'intlcal_set_minimal_days_in_first_week', 'intlcal_get_minimum',
            'intlcal_get_time_zone', 'intlcal_get_type', 'intlcal_get_weekend_transition',
            'intlcal_in_daylight_time', 'intlcal_is_lenient', 'intlcal_is_set',
            'intlcal_is_equivalent_to', 'intlcal_is_weekend', 'intlcal_set_first_day_of_week',
            'intlcal_set_lenient', 'intlcal_get_repeated_wall_time_option', 'intlcal_equals',
            'intlcal_get_skipped_wall_time_option', 'intlcal_set_repeated_wall_time_option',
            'intlcal_set_skipped_wall_time_option', 'intlcal_from_date_time', 'intlcal_to_date_time',
            'intlcal_get_error_code', 'intlcal_get_error_message', 'intlgregcal_create_instance',
            'intlgregcal_set_gregorian_change', 'intlgregcal_get_gregorian_change',
            'intlgregcal_is_leap_year', 'collator_create', 'collator_compare', 'collator_get_attribute',
            'collator_set_attribute', 'collator_get_strength', 'collator_set_strength', 'collator_sort',
            'collator_sort_with_sort_keys', 'collator_asort', 'collator_get_locale',
            'collator_get_error_code', 'collator_get_error_message', 'collator_get_sort_key',
            'intl_get_error_code', 'intl_get_error_message', 'intl_is_failure', 'intl_error_name',
            'datefmt_create', 'datefmt_get_datetype', 'datefmt_get_timetype', 'datefmt_get_calendar',
            'datefmt_set_calendar', 'datefmt_get_timezone_id', 'datefmt_get_calendar_object',
            'datefmt_get_timezone', 'datefmt_set_timezone', 'datefmt_set_pattern',
            'datefmt_get_pattern', 'datefmt_get_locale', 'datefmt_set_lenient',
            'datefmt_is_lenient', 'datefmt_format', 'datefmt_format_object', 'datefmt_parse',
            'datefmt_localtime', 'datefmt_get_error_code', 'datefmt_get_error_message',
            'numfmt_create', 'numfmt_format', 'numfmt_parse', 'numfmt_format_currency',
            'numfmt_parse_currency', 'numfmt_set_attribute', 'numfmt_get_attribute',
            'numfmt_set_text_attribute', 'numfmt_get_text_attribute', 'numfmt_set_symbol',
            'numfmt_get_symbol', 'numfmt_set_pattern', 'numfmt_get_pattern', 'numfmt_get_locale',
            'numfmt_get_error_code', 'numfmt_get_error_message', 'grapheme_strlen',
            'grapheme_strpos', 'grapheme_stripos', 'grapheme_strrpos', 'grapheme_strripos',
            'grapheme_substr', 'grapheme_strstr', 'grapheme_stristr', 'grapheme_extract',
            'idn_to_ascii', 'idn_to_utf8', 'locale_get_default', 'locale_set_default',
            'locale_get_primary_language', 'locale_get_script', 'locale_get_region',
            'locale_get_keywords', 'locale_get_display_script', 'locale_get_display_region',
            'locale_get_display_name', 'locale_get_display_language', 'locale_get_display_variant',
            'locale_compose', 'locale_parse', 'locale_get_all_variants', 'locale_filter_matches',
            'locale_canonicalize', 'locale_lookup', 'locale_accept_from_http', 'msgfmt_create',
            'msgfmt_format', 'msgfmt_format_message', 'msgfmt_parse', 'msgfmt_parse_message',
            'msgfmt_set_pattern', 'msgfmt_get_pattern', 'msgfmt_get_locale', 'msgfmt_get_error_code',
            'msgfmt_get_error_message', 'normalizer_normalize', 'normalizer_is_normalized',
            'normalizer_get_raw_decomposition', 'resourcebundle_create', 'resourcebundle_get',
            'resourcebundle_count', 'resourcebundle_locales', 'resourcebundle_get_error_code',
            'resourcebundle_get_error_message', 'intltz_count_equivalent_ids', 'intltz_create_default',
            'intltz_create_enumeration', 'intltz_create_time_zone',
            'intltz_create_time_zone_id_enumeration', 'intltz_from_date_time_zone',
            'intltz_get_canonical_id', 'intltz_get_display_name', 'intltz_get_dst_savings',
            'intltz_get_equivalent_id', 'intltz_get_error_code', 'intltz_get_error_message',
            'intltz_get_gmt', 'intltz_get_id', 'intltz_get_offset', 'intltz_get_raw_offset',
            'intltz_get_region', 'intltz_get_tz_data_version', 'intltz_get_unknown',
            'intltz_get_windows_id', 'intltz_get_id_for_windows_id', 'intltz_has_same_rules',
            'intltz_to_date_time_zone', 'intltz_use_daylight_time', 'transliterator_create',
            'transliterator_create_from_rules', 'transliterator_list_ids',
            'transliterator_create_inverse', 'transliterator_transliterate',
            'transliterator_get_error_code', 'transliterator_get_error_message',
            'json_last_error', 'json_last_error_msg', 'ldap_bind_ext', 'ldap_sasl_bind',
            'ldap_add_ext', 'ldap_delete_ext', 'ldap_modify_batch', 'ldap_mod_add_ext',
            'ldap_mod_replace_ext', 'ldap_mod_del_ext', 'ldap_rename_ext', 'ldap_count_references',
            'ldap_set_rebind_proc', 'ldap_escape', 'ldap_exop', 'ldap_exop_passwd',
            'ldap_exop_whoami', 'ldap_exop_refresh', 'ldap_parse_exop', 'mb_str_split',
            'mb_encoding_aliases', 'mb_scrub', 'mb_ord', 'mb_chr', 'mb_ereg_replace_callback',
            'mysqli_begin_transaction', 'mysqli_error_list', 'mysqli_fetch_all',
            'mysqli_get_connection_stats', 'mysqli_get_client_stats', 'mysqli_get_links_stats',
            'mysqli_poll', 'mysqli_reap_async_query', 'mysqli_release_savepoint', 'mysqli_savepoint',
            'mysqli_stmt_error_list', 'mysqli_stmt_get_result', 'mysqli_stmt_more_results',
            'mysqli_stmt_next_result', 'mysqli_refresh', 'pcntl_fork', 'pcntl_waitpid', 'pcntl_wait',
            'pcntl_signal', 'pcntl_signal_get_handler', 'pcntl_signal_dispatch', 'pcntl_sigprocmask',
            'pcntl_wifexited', 'pcntl_wifstopped', 'pcntl_wifcontinued', 'pcntl_wifsignaled',
            'pcntl_wexitstatus', 'pcntl_wtermsig', 'pcntl_wstopsig', 'pcntl_exec', 'pcntl_alarm',
            'pcntl_get_last_error', 'pcntl_errno', 'pcntl_getpriority', 'pcntl_setpriority',
            'pcntl_strerror', 'pcntl_async_signals', 'class_uses', 'spl_object_id', 'pg_connect_poll',
            'pg_lo_truncate', 'pg_escape_literal', 'pg_escape_identifier', 'pg_socket',
            'pg_consume_input', 'pg_flush', 'posix_mknod', 'posix_access', 'posix_setrlimit',
            'posix_initgroups', 'pspell_new', 'pspell_new_personal', 'pspell_new_config',
            'pspell_check', 'pspell_suggest', 'pspell_store_replacement', 'pspell_add_to_personal',
            'pspell_add_to_session', 'pspell_clear_session', 'pspell_save_wordlist',
            'pspell_config_create', 'pspell_config_runtogether', 'pspell_config_mode',
            'pspell_config_ignore', 'pspell_config_personal', 'pspell_config_dict_dir',
            'pspell_config_data_dir', 'pspell_config_repl', 'pspell_config_save_repl',
            'readline', 'readline_info', 'readline_add_history', 'readline_clear_history',
            'readline_read_history', 'readline_write_history', 'readline_completion_function',
            'readline_callback_handler_install', 'readline_callback_read_char',
            'readline_callback_handler_remove', 'readline_redisplay', 'readline_on_new_line',
            'session_create_id', 'session_gc', 'session_abort', 'session_reset',
            'session_status', 'session_register_shutdown', 'socket_import_stream',
            'socket_export_stream', 'socket_cmsg_space', 'socket_addrinfo_lookup',
            'socket_addrinfo_connect', 'socket_addrinfo_bind', 'socket_addrinfo_explain',
            'sodium_crypto_aead_aes256gcm_is_available', 'sodium_crypto_aead_aes256gcm_decrypt',
            'sodium_crypto_aead_aes256gcm_encrypt', 'sodium_crypto_aead_aes256gcm_keygen',
            'sodium_crypto_aead_chacha20poly1305_decrypt', 'sodium_crypto_aead_chacha20poly1305_encrypt',
            'sodium_crypto_aead_chacha20poly1305_keygen', 'sodium_crypto_aead_chacha20poly1305_ietf_decrypt',
            'sodium_crypto_aead_chacha20poly1305_ietf_encrypt',
            'sodium_crypto_aead_chacha20poly1305_ietf_keygen',
            'sodium_crypto_aead_xchacha20poly1305_ietf_decrypt',
            'sodium_crypto_aead_xchacha20poly1305_ietf_keygen',
            'sodium_crypto_aead_xchacha20poly1305_ietf_encrypt', 'sodium_crypto_auth',
            'sodium_crypto_auth_keygen', 'sodium_crypto_auth_verify', 'sodium_crypto_box',
            'sodium_crypto_box_keypair', 'sodium_crypto_box_seed_keypair',
            'sodium_crypto_box_keypair_from_secretkey_and_publickey', 'sodium_crypto_box_open',
            'sodium_crypto_box_publickey', 'sodium_crypto_box_publickey_from_secretkey',
            'sodium_crypto_box_seal', 'sodium_crypto_box_seal_open', 'sodium_crypto_box_secretkey',
            'sodium_crypto_kx_keypair', 'sodium_crypto_kx_publickey', 'sodium_crypto_kx_secretkey',
            'sodium_crypto_kx_seed_keypair', 'sodium_crypto_kx_client_session_keys',
            'sodium_crypto_kx_server_session_keys', 'sodium_crypto_generichash',
            'sodium_crypto_generichash_keygen', 'sodium_crypto_generichash_init',
            'sodium_crypto_generichash_update', 'sodium_crypto_generichash_final',
            'sodium_crypto_kdf_derive_from_key', 'sodium_crypto_kdf_keygen', 'sodium_crypto_pwhash',
            'sodium_crypto_pwhash_str', 'sodium_crypto_pwhash_str_verify',
            'sodium_crypto_pwhash_str_needs_rehash', 'sodium_crypto_pwhash_scryptsalsa208sha256',
            'sodium_crypto_pwhash_scryptsalsa208sha256_str',
            'sodium_crypto_pwhash_scryptsalsa208sha256_str_verify', 'sodium_crypto_scalarmult',
            'sodium_crypto_secretbox', 'sodium_crypto_secretbox_keygen', 'sodium_crypto_secretbox_open',
            'sodium_crypto_secretstream_xchacha20poly1305_keygen',
            'sodium_crypto_secretstream_xchacha20poly1305_init_push',
            'sodium_crypto_secretstream_xchacha20poly1305_push',
            'sodium_crypto_secretstream_xchacha20poly1305_init_pull',
            'sodium_crypto_secretstream_xchacha20poly1305_pull',
            'sodium_crypto_secretstream_xchacha20poly1305_rekey', 'sodium_crypto_shorthash',
            'sodium_crypto_shorthash_keygen', 'sodium_crypto_sign', 'sodium_crypto_sign_detached',
            'sodium_crypto_sign_ed25519_pk_to_curve25519', 'sodium_crypto_sign_ed25519_sk_to_curve25519',
            'sodium_crypto_sign_keypair', 'sodium_crypto_sign_keypair_from_secretkey_and_publickey',
            'sodium_crypto_sign_open', 'sodium_crypto_sign_publickey', 'sodium_crypto_sign_secretkey',
            'sodium_crypto_sign_publickey_from_secretkey', 'sodium_crypto_sign_seed_keypair',
            'sodium_crypto_sign_verify_detached', 'sodium_crypto_stream', 'sodium_crypto_stream_keygen',
            'sodium_crypto_stream_xor', 'sodium_add', 'sodium_compare', 'sodium_increment', 'sodium_memcmp',
            'sodium_memzero', 'sodium_pad', 'sodium_unpad', 'sodium_bin2hex', 'sodium_hex2bin',
            'sodium_bin2base64', 'sodium_base642bin', 'sodium_crypto_scalarmult_base',
            'header_register_callback', 'array_replace', 'array_replace_recursive', 'array_key_first',
            'array_key_last', 'array_column', 'time_nanosleep', 'time_sleep_until', 'error_clear_last',
            'forward_static_call', 'forward_static_call_array', 'parse_ini_string', 'sys_getloadavg',
            'strptime', 'gethostname', 'dns_check_record', 'dns_get_record', 'dns_get_mx',
            'net_get_interfaces', 'hrtime', 'inet_ntop', 'inet_pton', 'header_remove', 'http_response_code',
            'hex2bin', 'str_contains', 'str_starts_with', 'str_ends_with', 'lcfirst', 'str_getcsv',
            'proc_nice', 'lchown', 'lchgrp', 'realpath_cache_get', 'realpath_cache_size',
            'getimagesizefromstring', 'intdiv', 'fdiv', 'password_get_info', 'password_hash',
            'password_needs_rehash', 'password_verify', 'password_algos', 'quoted_printable_encode',
            'random_bytes', 'random_int', 'stream_context_get_params', 'stream_set_read_buffer',
            'stream_isatty', 'stream_set_chunk_size', 'get_debug_type', 'boolval', 'is_iterable',
            'is_countable', 'msg_get_queue', 'msg_send', 'msg_receive', 'msg_remove_queue',
            'msg_stat_queue', 'msg_set_queue', 'msg_queue_exists', 'shm_has_var', 'tidy_get_opt_doc',
            'fastcgi_finish_request', 'fpm_get_status', 'yaml_parse', 'yaml_parse_file', 'yaml_parse_url',
            'yaml_emit', 'yaml_emit_file', 'opcache_reset', 'opcache_get_status', 'opcache_compile_file',
            'opcache_invalidate', 'opcache_get_configuration', 'opcache_is_script_cached'
            ),
        4 => array(
            'DEFAULT_INCLUDE_PATH', 'DIRECTORY_SEPARATOR', 'E_ALL',
            'E_COMPILE_ERROR', 'E_COMPILE_WARNING', 'E_CORE_ERROR',
            'E_CORE_WARNING', 'E_ERROR', 'E_NOTICE', 'E_PARSE', 'E_STRICT',
            'E_USER_ERROR', 'E_USER_NOTICE', 'E_USER_WARNING', 'E_WARNING',
            'ENT_COMPAT','ENT_QUOTES','ENT_NOQUOTES',
            'false', 'null', 'PEAR_EXTENSION_DIR', 'PEAR_INSTALL_DIR',
            'PHP_BINDIR', 'PHP_CONFIG_FILE_PATH', 'PHP_DATADIR',
            'PHP_EXTENSION_DIR', 'PHP_LIBDIR',
            'PHP_LOCALSTATEDIR', 'PHP_OS',
            'PHP_OUTPUT_HANDLER_CONT', 'PHP_OUTPUT_HANDLER_END',
            'PHP_OUTPUT_HANDLER_START', 'PHP_SYSCONFDIR',
            'PHP_VERSION', 'true', '__CLASS__', '__FILE__', '__FUNCTION__',
            '__LINE__', '__METHOD__', 'E_RECOVERABLE_ERROR', 'E_DEPRECATED',
            'E_USER_DEPRECATED', 'DEBUG_BACKTRACE_PROVIDE_OBJECT',
            'DEBUG_BACKTRACE_IGNORE_ARGS', 'ZEND_THREAD_SAFE', 'ZEND_DEBUG_BUILD',
            'TRUE', 'FALSE', 'NULL', 'PHP_MAJOR_VERSION', 'PHP_MINOR_VERSION',
            'PHP_RELEASE_VERSION', 'PHP_EXTRA_VERSION', 'PHP_VERSION_ID',
            'PHP_ZTS', 'PHP_DEBUG', 'PHP_OS_FAMILY', 'PHP_SAPI', 'PHP_PREFIX',
            'PHP_MANDIR', 'PHP_CONFIG_FILE_SCAN_DIR', 'PHP_SHLIB_SUFFIX',
            'PHP_EOL', 'PHP_MAXPATHLEN', 'PHP_INT_MAX', 'PHP_INT_MIN',
            'PHP_INT_SIZE', 'PHP_FD_SETSIZE', 'PHP_FLOAT_DIG',
            'PHP_FLOAT_EPSILON', 'PHP_FLOAT_MAX', 'PHP_FLOAT_MIN',
            'PHP_BINARY', 'PHP_OUTPUT_HANDLER_WRITE', 'PHP_OUTPUT_HANDLER_FLUSH',
            'PHP_OUTPUT_HANDLER_CLEAN', 'PHP_OUTPUT_HANDLER_FINAL',
            'PHP_OUTPUT_HANDLER_CLEANABLE', 'PHP_OUTPUT_HANDLER_FLUSHABLE',
            'PHP_OUTPUT_HANDLER_REMOVABLE', 'PHP_OUTPUT_HANDLER_STDFLAGS',
            'PHP_OUTPUT_HANDLER_STARTED', 'PHP_OUTPUT_HANDLER_DISABLED',
            'UPLOAD_ERR_OK', 'UPLOAD_ERR_INI_SIZE', 'UPLOAD_ERR_FORM_SIZE',
            'UPLOAD_ERR_PARTIAL', 'UPLOAD_ERR_NO_FILE', 'UPLOAD_ERR_NO_TMP_DIR',
            'UPLOAD_ERR_CANT_WRITE', 'UPLOAD_ERR_EXTENSION', 'DATE_W3C', 'DATE_COOKIE', 'DATE_ISO8601', 'DATE_RFC1036',
            'DATE_RFC850', 'DATE_RSS', 'DATE_RFC7231', 'DATE_RFC3339_EXTENDED',
            'YAML_ANY_BREAK', 'YAML_CR_BREAK', 'YAML_LN_BREAK',
            'LIBXML_LOADED_VERSION', 'LIBXML_DOTTED_VERSION',
            'YAML_LITERAL_SCALAR_STYLE', 'XSL_SECPREF_CREATE_DIRECTORY',
            'XSL_SECPREF_READ_NETWORK', 'XSL_SECPREF_WRITE_NETWORK',
            'TIDY_TAG_MAP', 'AI_ALL', 'AI_ADDRCONFIG',
            'MYSQLI_ON_UPDATE_NOW_FLAG', 'MYSQLI_PART_KEY_FLAG', 'AI_V4MAPPED',
            'TIDY_TAG_COMMAND', 'PASSWORD_ARGON2_DEFAULT_MEMORY_COST',
            'SODIUM_CRYPTO_PWHASH_SCRYPTSALSA208SHA256_OPSLIMIT_INTERACTIVE',
            'MYSQLI_CLIENT_CAN_HANDLE_EXPIRED_PASSWORDS', 'YAML_CRLN_BREAK',
            'OPENSSL_VERSION_TEXT', 'OPENSSL_VERSION_NUMBER',
            'YAML_FOLDED_SCALAR_STYLE', 'XML_ERROR_PARTIAL_CHAR',
            'XML_ERROR_TAG_MISMATCH', 'XML_ERROR_JUNK_AFTER_DOC_ELEMENT',
            'XML_ERROR_PARAM_ENTITY_REF', 'XML_ERROR_RECURSIVE_ENTITY_REF',
            'OPENSSL_DEFAULT_STREAM_CIPHERS', 'SO_REUSEPORT', 'PCRE_VERSION',
            'TIDY_TAG_FORM', 'TIDY_TAG_DL', 'XML_ERROR_BINARY_ENTITY_REF',
            'ZLIB_ENCODING_RAW', 'ZLIB_VERSION', 'ZLIB_VERNUM', 'XSL_CLONE_NEVER',
            'SQL_BINARY', 'SQL_VARBINARY', 'SQL_LONGVARBINARY', 'SQL_BIGINT',
            'SQL_TINYINT', 'TIDY_TAG_LABEL', 'CURLOPT_BINARYTRANSFER',
            'TIDY_TAG_SMALL', 'CURLOPT_CAINFO', 'CURLOPT_CAPATH',
            'TIDY_TAG_OPTGROUP', 'CURLOPT_COOKIE', 'CURLOPT_COOKIEFILE',
            'CURLOPT_COOKIEJAR', 'TIDY_TAG_SERVER', 'TIDY_TAG_DEL',
            'CURLOPT_CUSTOMREQUEST', 'TIDY_TAG_S', 'TIDY_TAG_RUBY',
            'CURLOPT_EGDSOCKET', 'CURLOPT_ACCEPT_ENCODING', 'TIDY_TAG_H6',
            'CURLOPT_FILE', 'TIDY_TAG_MULTICOL', 'TIDY_TAG_IMG',
            'TIDY_TAG_NOSCRIPT', 'TIDY_TAG_NOSAVE', 'TIDY_TAG_IFRAME',
            'TIDY_TAG_HTML', 'CURLOPT_FTPPORT', 'XSD_DURATION', 'TIDY_TAG_Q',
            'TIDY_TAG_H3', 'CURLOPT_HEADERFUNCTION', 'CURLOPT_HTTP200ALIASES',
            'TIDY_TAG_P', 'CURLOPT_HTTPHEADER', 'TIDY_TAG_LI', 'TIDY_TAG_PRE',
            'CURLOPT_READDATA', 'XML_ERROR_BAD_CHAR_REF', 'CURLOPT_INTERFACE',
            'CURLOPT_KRBLEVEL', 'XML_ERROR_INCORRECT_ENCODING',
            'XML_ERROR_UNCLOSED_CDATA_SECTION', 'TIDY_TAG_NOEMBED',
            'TIDY_TAG_META', 'TIDY_TAG_ILAYER', 'XSL_SECPREF_DEFAULT',
            'TIDY_TAG_H4', 'TIDY_TAG_SPACER', 'TIDY_TAG_HR', 'CURLOPT_POSTFIELDS',
            'CURLOPT_POSTQUOTE', 'CURLOPT_PREQUOTE', 'CURLOPT_PRIVATE',
            'CURLOPT_PROGRESSFUNCTION', 'CURLOPT_PROXY', 'TIDY_TAG_LAYER',
            'TIDY_TAG_STRIKE', 'CURLOPT_PROXYUSERPWD', 'TIDY_TAG_INS',
            'CURLOPT_QUOTE', 'CURLOPT_RANDOM_FILE', 'CURLOPT_RANGE',
            'CURLOPT_READFUNCTION', 'CURLOPT_REFERER',
            'XML_ERROR_EXTERNAL_ENTITY_HANDLING', 'CURLOPT_RETURNTRANSFER',
            'CURLOPT_SHARE', 'CURLOPT_SSLCERT', 'CURLOPT_KEYPASSWD',
            'CURLOPT_SSLCERTTYPE', 'CURLOPT_SSLENGINE', 'TIDY_TAG_RTC',
            'CURLOPT_SSLKEY', 'CURLOPT_SSLKEYTYPE', 'CURLOPT_SSL_CIPHER_LIST',
            'TIDY_TAG_PARAM', 'CURLOPT_STDERR', 'CURLOPT_TELNETOPTIONS',
            'TIDY_TAG_EM', 'XML_ERROR_ASYNC_ENTITY', 'TIDY_TAG_EMBED',
            'TIDY_TAG_INPUT', 'TIDY_TAG_SUP', 'TIDY_TAG_HEAD', 'CURLOPT_URL',
            'CURLOPT_USERAGENT', 'CURLOPT_USERPWD', 'TIDY_TAG_H2',
            'CURLOPT_WRITEFUNCTION', 'CURLOPT_WRITEHEADER', 'TIDY_TAG_FONT',
            'TIDY_TAG_DIR', 'XML_ERROR_MISPLACED_XML_PI', 'TIDY_TAG_COMMENT',
            'XML_ERROR_UNKNOWN_ENCODING', 'TIDY_TAG_DIV',
            'XML_ERROR_UNDEFINED_ENTITY', 'TIDY_TAG_CODE', 'TIDY_TAG_FRAME',
            'TIDY_TAG_FRAMESET', 'TIDY_TAG_H1', 'TIDY_TAG_COLGROUP',
            'TIDY_TAG_DFN', 'TIDY_TAG_DD', 'TIDY_TAG_KBD', 'TIDY_TAG_ISINDEX',
            'TIDY_TAG_KEYGEN', 'TIDY_TAG_LEGEND', 'TIDY_TAG_FIELDSET',
            'TIDY_TAG_I', 'TIDY_TAG_COL', 'CURLINFO_CONNECT_TIME',
            'CURLINFO_CONTENT_LENGTH_DOWNLOAD', 'CURLINFO_CONTENT_LENGTH_UPLOAD',
            'CURLINFO_CONTENT_TYPE', 'CURLINFO_EFFECTIVE_URL',
            'CURLINFO_FILETIME', 'CURLINFO_HEADER_SIZE', 'CURLINFO_RESPONSE_CODE',
            'CURLINFO_NAMELOOKUP_TIME', 'CURLINFO_PRETRANSFER_TIME',
            'CURLINFO_PRIVATE', 'CURLINFO_REDIRECT_COUNT',
            'CURLINFO_REDIRECT_TIME', 'CURLINFO_REQUEST_SIZE',
            'CURLINFO_SIZE_DOWNLOAD', 'CURLINFO_SIZE_UPLOAD',
            'CURLINFO_SPEED_DOWNLOAD', 'CURLINFO_SPEED_UPLOAD',
            'CURLINFO_SSL_VERIFYRESULT', 'CURLINFO_STARTTRANSFER_TIME',
            'CURLINFO_TOTAL_TIME', 'AI_NUMERICSERV', 'TIDY_TAG_TABLE',
            'CURLAUTH_ANY', 'CURLAUTH_ANYSAFE', 'CURLINFO_HTTP_CONNECTCODE',
            'TIDY_TAG_TEXTAREA', 'TIDY_TAG_TFOOT', 'TIDY_TAG_LISTING',
            'TIDY_TAG_LINK', 'CURLINFO_HTTPAUTH_AVAIL',
            'CURLINFO_PROXYAUTH_AVAIL', 'TIDY_TAG_TH', 'TIDY_TAG_THEAD',
            'TIDY_TAG_TITLE', 'TIDY_TAG_VAR', 'CURLOPT_NETRC_FILE',
            'TIDY_TAG_XMP', 'XSD_ENTITY', 'CURLOPT_FTP_ACCOUNT',
            'CURLINFO_OS_ERRNO', 'CURLINFO_NUM_CONNECTS', 'CURLINFO_SSL_ENGINES',
            'CURLINFO_COOKIELIST', 'CURLOPT_COOKIELIST', 'TIDY_TAG_HEADER',
            'TIDY_TAG_HGROUP', 'TIDY_TAG_MAIN', 'TIDY_TAG_METER', 'TIDY_TAG_MARK',
            'TIDY_TAG_MENUITEM', 'CURLINFO_FTP_ENTRY_PATH',
            'CURLOPT_FTP_ALTERNATIVE_TO_USER', 'CURLOPT_MAX_RECV_SPEED_LARGE',
            'CURLOPT_MAX_SEND_SPEED_LARGE', 'TIDY_TAG_OL', 'TIDY_TAG_TRACK',
            'TIDY_TAG_OPTION', 'CURLOPT_FTP_SSL_CCC', 'TIDY_TAG_VIDEO',
            'CURLOPT_SSH_PRIVATE_KEYFILE', 'CURLOPT_SSH_PUBLIC_KEYFILE',
            'INTL_MAX_LOCALE_LEN', 'CURLOPT_HTTP_CONTENT_DECODING',
            'CURLOPT_HTTP_TRANSFER_DECODING', 'CURLOPT_TIMEOUT_MS', 'LOG_LOCAL4',
            'CURLOPT_NEW_FILE_PERMS', 'CURLOPT_SSH_HOST_PUBLIC_KEY_MD5',
            'CURLOPT_PROXY_TRANSFER_MODE', 'CURL_WRITEFUNC_PAUSE',
            'CURLINFO_REDIRECT_URL', 'CURLINFO_APPCONNECT_TIME',
            'CURLINFO_PRIMARY_IP', 'CURLOPT_ADDRESS_SCOPE', 'CURLOPT_CRLFILE',
            'CURLOPT_ISSUERCERT', 'CURLINFO_CERTINFO', 'CURLOPT_CERTINFO',
            'CURLOPT_PASSWORD', 'CURLOPT_POSTREDIR', 'CURLOPT_PROXYPASSWORD',
            'CURLOPT_PROXYUSERNAME', 'CURLOPT_USERNAME',
            'CURLINFO_CONDITION_UNMET', 'CURLOPT_NOPROXY', 'CURLOPT_PROTOCOLS',
            'CURLOPT_REDIR_PROTOCOLS', 'CURLOPT_SOCKS5_GSSAPI_NEC',
            'CURLOPT_SOCKS5_GSSAPI_SERVICE', 'CURLOPT_TFTP_BLKSIZE',
            'CURLOPT_SSH_KNOWNHOSTS', 'CURLINFO_RTSP_CLIENT_CSEQ',
            'CURLINFO_RTSP_CSEQ_RECV', 'CURLINFO_RTSP_SERVER_CSEQ',
            'CURLINFO_RTSP_SESSION_ID', 'CURLOPT_FTP_USE_PRET',
            'CURLOPT_MAIL_FROM', 'CURLOPT_MAIL_RCPT', 'CURLOPT_RTSP_CLIENT_CSEQ',
            'CURLOPT_RTSP_REQUEST', 'CURLOPT_RTSP_SERVER_CSEQ',
            'CURLOPT_RTSP_SESSION_ID', 'CURLOPT_RTSP_STREAM_URI',
            'CURLOPT_RTSP_TRANSPORT', 'MYSQLI_GROUP_FLAG',
            'FILTER_FLAG_PATH_REQUIRED', 'CURL_VERSION_GSSAPI',
            'CURLINFO_LOCAL_IP', 'CURLINFO_LOCAL_PORT', 'CURLINFO_PRIMARY_PORT',
            'CURLOPT_FNMATCH_FUNCTION', 'CURLOPT_WILDCARDMATCH',
            'MYSQLI_REFRESH_BACKUP_LOG', 'FILTER_FLAG_NO_PRIV_RANGE',
            'JSON_INVALID_UTF8_IGNORE',
            'SODIUM_CRYPTO_PWHASH_SCRYPTSALSA208SHA256_MEMLIMIT_INTERACTIVE',
            'SODIUM_CRYPTO_PWHASH_SCRYPTSALSA208SHA256_OPSLIMIT_SENSITIVE',
            'CURLAUTH_ONLY', 'CURLOPT_RESOLVE', 'CURLOPT_TLSAUTH_PASSWORD',
            'CURLOPT_TLSAUTH_TYPE', 'CURLOPT_TLSAUTH_USERNAME',
            'CURLOPT_TRANSFER_ENCODING', 'CURLOPT_GSSAPI_DELEGATION',
            'CURLOPT_ACCEPTTIMEOUT_MS', 'CURLOPT_DNS_SERVERS',
            'CURLOPT_MAIL_AUTH', 'CURLOPT_SSL_OPTIONS', 'CURLOPT_TCP_KEEPALIVE',
            'CURLOPT_TCP_KEEPIDLE', 'CURLOPT_TCP_KEEPINTVL',
            'CURLMOPT_CHUNK_LENGTH_PENALTY_SIZE',
            'CURLMOPT_CONTENT_LENGTH_PENALTY_SIZE', 'CURLOPT_SASL_IR',
            'CURLOPT_DNS_INTERFACE', 'CURLOPT_DNS_LOCAL_IP4',
            'CURLOPT_DNS_LOCAL_IP6', 'CURLOPT_XOAUTH2_BEARER',
            'CURLOPT_LOGIN_OPTIONS', 'CURLOPT_EXPECT_100_TIMEOUT_MS',
            'CURLOPT_SSL_ENABLE_ALPN', 'CURLOPT_SSL_ENABLE_NPN',
            'CURLOPT_HEADEROPT', 'CURLOPT_PROXYHEADER', 'CURLOPT_PINNEDPUBLICKEY',
            'CURLOPT_UNIX_SOCKET_PATH',
            'SODIUM_CRYPTO_PWHASH_MEMLIMIT_INTERACTIVE', 'DNS_AAAA',
            'CURLOPT_SSL_VERIFYSTATUS', 'CURLOPT_PATH_AS_IS',
            'CURLOPT_SSL_FALSESTART', 'CURLOPT_PIPEWAIT',
            'CURLOPT_PROXY_SERVICE_NAME', 'CURLOPT_SERVICE_NAME',
            'CURLOPT_DEFAULT_PROTOCOL', 'CURLOPT_STREAM_WEIGHT',
            'CURLMOPT_PUSHFUNCTION', 'CURLOPT_TFTP_NO_OPTIONS',
            'CURLOPT_CONNECT_TO', 'CURLOPT_TCP_FASTOPEN', 'CURLINFO_HTTP_VERSION',
            'MYSQLI_TYPE_JSON', 'CURLINFO_PROTOCOL',
            'CURLINFO_PROXY_SSL_VERIFYRESULT', 'CURLINFO_SCHEME',
            'CURLOPT_PRE_PROXY', 'CURLOPT_PROXY_CAINFO', 'CURLOPT_PROXY_CAPATH',
            'CURLOPT_PROXY_CRLFILE', 'CURLOPT_PROXY_KEYPASSWD',
            'CURLOPT_PROXY_PINNEDPUBLICKEY', 'CURLOPT_PROXY_SSL_CIPHER_LIST',
            'T_INCLUDE_ONCE', 'MYSQLI_TYPE_TINY_BLOB', 'MYSQLI_TYPE_SET',
            'CURLOPT_PROXY_SSLCERT', 'CURLOPT_PROXY_SSLCERTTYPE',
            'CURLOPT_PROXY_SSLKEY', 'CURLOPT_PROXY_SSLKEYTYPE',
            'MYSQLI_TYPE_MEDIUM_BLOB', 'CURLOPT_PROXY_TLSAUTH_PASSWORD',
            'CURLOPT_PROXY_TLSAUTH_TYPE', 'CURLOPT_PROXY_TLSAUTH_USERNAME',
            'CURLOPT_ABSTRACT_UNIX_SOCKET', 'CURL_SSLVERSION_MAX_TLSv1_1',
            'CURL_SSLVERSION_MAX_TLSv1_2', 'CURL_SSLVERSION_MAX_TLSv1_3',
            'T_LOGICAL_XOR', 'CURLINFO_CONTENT_LENGTH_DOWNLOAD_T',
            'CURLINFO_CONTENT_LENGTH_UPLOAD_T', 'CURLINFO_SIZE_DOWNLOAD_T',
            'CURLINFO_SIZE_UPLOAD_T', 'CURLINFO_SPEED_DOWNLOAD_T',
            'CURLINFO_SPEED_UPLOAD_T', 'CURLOPT_REQUEST_TARGET', 'T_PRINT',
            'T_YIELD', 'CURLINFO_FILETIME_T', 'T_PLUS_EQUAL',
            'CURLOPT_TIMEVALUE_LARGE', 'T_CONCAT_EQUAL', 'T_DIV_EQUAL',
            'CURLINFO_APPCONNECT_TIME_T', 'CURLINFO_CONNECT_TIME_T',
            'CURLINFO_NAMELOOKUP_TIME_T', 'CURLINFO_PRETRANSFER_TIME_T',
            'CURLINFO_REDIRECT_TIME_T', 'CURLINFO_STARTTRANSFER_TIME_T',
            'CURLINFO_TOTAL_TIME_T', 'T_OR_EQUAL', 'CURLOPT_PROXY_TLS13_CIPHERS',
            'CURLOPT_TLS13_CIPHERS', 'T_BOOLEAN_OR', 'FILEINFO_MIME',
            'FILTER_VALIDATE_INT', 'T_THROW', 'FILTER_VALIDATE_FLOAT',
            'T_MINUS_EQUAL', 'T_AND_EQUAL', 'T_MUL_EQUAL', 'T_MOD_EQUAL',
            'FILTER_UNSAFE_RAW', 'FILTER_SANITIZE_STRIPPED',
            'FILTER_SANITIZE_ENCODED', 'FILTER_SANITIZE_SPECIAL_CHARS',
            'FILTER_SANITIZE_FULL_SPECIAL_CHARS', 'FILTER_SANITIZE_EMAIL',
            'FILTER_SANITIZE_URL', 'FILTER_SANITIZE_NUMBER_INT',
            'FILTER_SANITIZE_NUMBER_FLOAT', 'FILTER_SANITIZE_ADD_SLASHES',
            'GD_VERSION', 'GD_EXTRA_VERSION', 'GMP_VERSION', 'ICONV_IMPL',
            'ICONV_VERSION', 'INTL_ICU_DATA_VERSION', 'U_ERROR_WARNING_START',
            'U_USING_DEFAULT_WARNING', 'U_SAFECLONE_ALLOCATED_WARNING',
            'U_STATE_OLD_WARNING', 'U_STRING_NOT_TERMINATED_WARNING',
            'U_SORT_KEY_TOO_SHORT_WARNING', 'U_AMBIGUOUS_ALIAS_WARNING',
            'U_DIFFERENT_UCA_VERSION', 'U_ERROR_WARNING_LIMIT',
            'U_MALFORMED_RULE', 'U_MALFORMED_SET', 'U_MALFORMED_SYMBOL_REFERENCE',
            'U_MALFORMED_UNICODE_ESCAPE', 'U_MALFORMED_VARIABLE_DEFINITION',
            'U_MALFORMED_VARIABLE_REFERENCE', 'U_MISMATCHED_SEGMENT_DELIMITERS',
            'U_MISPLACED_ANCHOR_START', 'U_MISPLACED_CURSOR_OFFSET',
            'U_MISPLACED_QUANTIFIER', 'U_MISSING_OPERATOR',
            'U_MISSING_SEGMENT_CLOSE', 'U_MULTIPLE_ANTE_CONTEXTS',
            'U_MULTIPLE_CURSORS', 'U_MULTIPLE_POST_CONTEXTS',
            'U_TRAILING_BACKSLASH', 'U_UNDEFINED_SEGMENT_REFERENCE',
            'U_UNDEFINED_VARIABLE', 'U_UNQUOTED_SPECIAL', 'U_UNTERMINATED_QUOTE',
            'U_RULE_MASK_ERROR', 'U_MISPLACED_COMPOUND_FILTER',
            'U_MULTIPLE_COMPOUND_FILTERS', 'U_INVALID_RBT_SYNTAX',
            'U_INVALID_PROPERTY_PATTERN', 'U_MALFORMED_PRAGMA',
            'U_UNCLOSED_SEGMENT', 'U_ILLEGAL_CHAR_IN_SEGMENT',
            'U_VARIABLE_RANGE_EXHAUSTED', 'U_VARIABLE_RANGE_OVERLAP',
            'U_ILLEGAL_CHARACTER', 'U_INTERNAL_TRANSLITERATOR_ERROR',
            'U_INVALID_ID', 'U_INVALID_FUNCTION', 'U_PARSE_ERROR_LIMIT',
            'U_FMT_PARSE_ERROR_START', 'U_MULTIPLE_DECIMAL_SEPERATORS',
            'U_MULTIPLE_EXPONENTIAL_SYMBOLS', 'U_MALFORMED_EXPONENTIAL_PATTERN',
            'U_MULTIPLE_PERCENT_SYMBOLS', 'U_MULTIPLE_PERMILL_SYMBOLS',
            'U_MULTIPLE_PAD_SPECIFIERS', 'U_PATTERN_SYNTAX_ERROR',
            'U_ILLEGAL_PAD_POSITION', 'U_UNMATCHED_BRACES',
            'U_UNSUPPORTED_PROPERTY', 'U_UNSUPPORTED_ATTRIBUTE',
            'U_FMT_PARSE_ERROR_LIMIT', 'U_BRK_ERROR_START',
            'U_BRK_HEX_DIGITS_EXPECTED', 'U_BRK_SEMICOLON_EXPECTED',
            'U_BRK_RULE_SYNTAX', 'U_BRK_UNCLOSED_SET', 'U_BRK_ASSIGN_ERROR',
            'U_BRK_VARIABLE_REDFINITION', 'U_BRK_MISMATCHED_PAREN',
            'U_BRK_NEW_LINE_IN_QUOTED_STRING', 'U_BRK_UNDEFINED_VARIABLE',
            'U_BRK_INIT_ERROR', 'U_BRK_RULE_EMPTY_SET',
            'U_BRK_UNRECOGNIZED_OPTION', 'U_BRK_MALFORMED_RULE_TAG',
            'U_BRK_ERROR_LIMIT', 'U_REGEX_ERROR_START', 'U_REGEX_RULE_SYNTAX',
            'U_REGEX_INVALID_STATE', 'U_REGEX_BAD_ESCAPE_SEQUENCE',
            'U_REGEX_PROPERTY_SYNTAX', 'U_REGEX_UNIMPLEMENTED',
            'U_REGEX_MISMATCHED_PAREN', 'U_REGEX_NUMBER_TOO_BIG',
            'U_REGEX_BAD_INTERVAL', 'U_REGEX_MAX_LT_MIN',
            'U_REGEX_INVALID_BACK_REF', 'U_REGEX_INVALID_FLAG',
            'U_REGEX_LOOK_BEHIND_LIMIT', 'U_REGEX_SET_CONTAINS_STRING',
            'U_REGEX_ERROR_LIMIT', 'U_STRINGPREP_PROHIBITED_ERROR',
            'U_STRINGPREP_UNASSIGNED_ERROR', 'U_STRINGPREP_CHECK_BIDI_ERROR',
            'U_IDNA_STD3_ASCII_RULES_ERROR', 'U_IDNA_ACE_PREFIX_ERROR',
            'U_IDNA_VERIFICATION_ERROR', 'U_IDNA_LABEL_TOO_LONG_ERROR',
            'U_IDNA_ZERO_LENGTH_LABEL_ERROR', 'U_IDNA_DOMAIN_NAME_TOO_LONG_ERROR',
            'U_IDNA_ERROR_LIMIT', 'U_ERROR_LIMIT', 'LDAP_MODIFY_BATCH_ATTRIB',
            'LDAP_MODIFY_BATCH_MODTYPE', 'LDAP_MODIFY_BATCH_VALUES',
            'LDAP_OPT_NETWORK_TIMEOUT', 'LDAP_OPT_TIMEOUT',
            'LDAP_OPT_DEBUG_LEVEL', 'LDAP_OPT_X_SASL_MECH',
            'LDAP_OPT_X_SASL_REALM', 'LDAP_OPT_X_SASL_AUTHCID',
            'LDAP_OPT_X_SASL_AUTHZID', 'LDAP_OPT_X_SASL_NOCANON',
            'LDAP_OPT_X_SASL_USERNAME', 'LDAP_OPT_X_TLS_REQUIRE_CERT',
            'LDAP_OPT_X_TLS_CACERTDIR', 'LDAP_OPT_X_TLS_CACERTFILE',
            'LDAP_OPT_X_TLS_CERTFILE', 'LDAP_OPT_X_TLS_CIPHER_SUITE',
            'LDAP_OPT_X_TLS_KEYFILE', 'LDAP_OPT_X_TLS_RANDOM_FILE',
            'LDAP_OPT_X_TLS_CRLCHECK', 'LDAP_OPT_X_TLS_DHFILE',
            'LDAP_OPT_X_TLS_CRLFILE', 'LDAP_OPT_X_TLS_PROTOCOL_MIN',
            'LDAP_OPT_X_TLS_PROTOCOL_SSL3', 'LDAP_OPT_X_TLS_PROTOCOL_TLS1_0',
            'LDAP_OPT_X_TLS_PROTOCOL_TLS1_1', 'LDAP_OPT_X_TLS_PROTOCOL_TLS1_2',
            'LDAP_OPT_X_TLS_PACKAGE', 'LDAP_OPT_X_KEEPALIVE_IDLE',
            'LDAP_OPT_X_KEEPALIVE_PROBES', 'LDAP_OPT_X_KEEPALIVE_INTERVAL',
            'LDAP_EXOP_START_TLS', 'LDAP_EXOP_MODIFY_PASSWD', 'LDAP_EXOP_REFRESH',
            'LDAP_EXOP_WHO_AM_I', 'LDAP_EXOP_TURN', 'LDAP_CONTROL_MANAGEDSAIT',
            'LDAP_CONTROL_PROXY_AUTHZ', 'LDAP_CONTROL_SUBENTRIES',
            'LDAP_CONTROL_VALUESRETURNFILTER', 'LDAP_CONTROL_ASSERT',
            'LDAP_CONTROL_PRE_READ', 'LDAP_CONTROL_POST_READ',
            'LDAP_CONTROL_SORTREQUEST', 'LDAP_CONTROL_SORTRESPONSE',
            'LDAP_CONTROL_PAGEDRESULTS', 'LDAP_CONTROL_AUTHZID_REQUEST',
            'LDAP_CONTROL_AUTHZID_RESPONSE', 'LDAP_CONTROL_SYNC',
            'LDAP_CONTROL_SYNC_STATE', 'LDAP_CONTROL_SYNC_DONE',
            'LDAP_CONTROL_DONTUSECOPY', 'LDAP_CONTROL_PASSWORDPOLICYRESPONSE',
            'LDAP_CONTROL_X_INCREMENTAL_VALUES', 'LDAP_CONTROL_X_DOMAIN_SCOPE',
            'LDAP_CONTROL_X_PERMISSIVE_MODIFY', 'LDAP_CONTROL_X_SEARCH_OPTIONS',
            'LDAP_CONTROL_X_TREE_DELETE', 'LDAP_CONTROL_X_EXTENDED_DN',
            'LDAP_CONTROL_VLVREQUEST', 'LDAP_CONTROL_VLVRESPONSE',
            'MB_ONIGURUMA_VERSION', 'CREDITS_ALL', 'TIDY_TAG_CANVAS',
            'SOCKET_EHOSTUNREACH', 'TIDY_TAG_BDI', 'TIDY_TAG_WBR',
            'MYSQLI_REPORT_ALL', 'PASSWORD_DEFAULT', 'PASSWORD_BCRYPT',
            'PASSWORD_ARGON2I', 'PASSWORD_ARGON2ID', 'PASSWORD_ARGON2_PROVIDER',
            'TIDY_TAG_ARTICLE', 'PATH_SEPARATOR',
            'SODIUM_CRYPTO_PWHASH_SCRYPTSALSA208SHA256_MEMLIMIT_SENSITIVE',
            'GLOB_AVAILABLE_FLAGS', 'TIDY_TAG_NOFRAMES', 'TIDY_TAG_PROGRESS',
            'LOG_LOCAL3', 'LOG_LOCAL5', 'LOG_LOCAL6', 'LOG_LOCAL7',
            'SODIUM_CRYPTO_PWHASH_MEMLIMIT_MODERATE', 'DNS_ALL', 'ODBC_TYPE',
            'SQL_BIT', 'TIDY_TAG_SAMP', 'SQL_WCHAR', 'SQL_WVARCHAR',
            'SQL_WLONGVARCHAR', 'PGSQL_LIBPQ_VERSION_STR', 'TIDY_TAG_PLAINTEXT',
            'TIDY_TAG_MENU', 'TIDY_TAG_RBC', 'TIDY_TAG_NOBR', 'TIDY_TAG_OBJECT',
            'PGSQL_DIAG_SOURCE_FUNCTION', 'TIDY_TAG_TR', 'TIDY_TAG_TT',
            'TIDY_TAG_SPAN', 'TIDY_TAG_RB', 'POSIX_S_IFBLK', 'POSIX_S_IFSOCK',
            'POSIX_RLIMIT_INFINITY', 'READLINE_LIB',
            'MYSQLI_OPT_NET_CMD_BUFFER_SIZE', 'MYSQLI_OPT_NET_READ_BUFFER_SIZE',
            'MYSQLI_OPT_INT_AND_FLOAT_NATIVE', 'MYSQLI_TYPE_INTERVAL',
            'MYSQLI_TYPE_LONG_BLOB', 'MYSQLI_TYPE_BLOB', 'MYSQLI_TYPE_VAR_STRING',
            'MYSQLI_TYPE_STRING', 'MYSQLI_TYPE_NEWDECIMAL', 'SOAP_FUNCTIONS_ALL',
            'UNKNOWN_TYPE', 'TIDY_TAG_STRONG', 'TIDY_TAG_STYLE', 'TIDY_TAG_SUB',
            'TIDY_TAG_TBODY', 'TIDY_TAG_TD', 'TIDY_TAG_U', 'TIDY_TAG_UL',
            'XSD_LANGUAGE', 'TIDY_TAG_ASIDE', 'TIDY_TAG_AUDIO',
            'TIDY_TAG_DATALIST', 'TIDY_TAG_DETAILS', 'TIDY_TAG_DIALOG',
            'TIDY_TAG_FIGCAPTION', 'TIDY_TAG_FIGURE', 'TIDY_TAG_FOOTER',
            'TIDY_TAG_NAV', 'TIDY_TAG_OUTPUT', 'TIDY_TAG_SECTION',
            'TIDY_TAG_SUMMARY', 'APACHE_MAP', 'T_OBJECT_CAST', 'T_ARRAY_CAST',
            'T_BAD_CHARACTER', 'XSD_NAMESPACE', 'XSD_1999_NAMESPACE', 'SO_SNDBUF',
            'SO_RCVBUF', 'SO_SNDLOWAT', 'SO_RCVLOWAT', 'SO_SNDTIMEO',
            'SO_RCVTIMEO', 'SO_TYPE', 'SO_ERROR', 'SOL_SOCKET',
            'TIDY_TAG_MARQUEE', 'TIDY_TAG_SERVLET', 'TIDY_TAG_SELECT',
            'TIDY_TAG_SCRIPT', 'SODIUM_LIBRARY_VERSION',
            'SODIUM_CRYPTO_SECRETSTREAM_XCHACHA20POLY1305_MESSAGEBYTES_MAX',
            'SODIUM_CRYPTO_PWHASH_STRPREFIX',
            'SODIUM_CRYPTO_PWHASH_SCRYPTSALSA208SHA256_STRPREFIX',
            'TIDY_TAG_NOLAYER', 'TIDY_TAG_RP', 'TIDY_TAG_RT', 'TIDY_TAG_SOURCE',
            'TIDY_TAG_TEMPLATE', 'TIDY_TAG_TIME', 'T_INCLUDE', 'T_REQUIRE',
            'T_REQUIRE_ONCE', 'T_LOGICAL_OR', 'T_LOGICAL_AND', 'T_DOUBLE_ARROW',
            'T_YIELD_FROM', 'T_XOR_EQUAL', 'T_SL_EQUAL', 'T_SR_EQUAL',
            'T_POW_EQUAL', 'T_COALESCE_EQUAL', 'T_COALESCE', 'T_BOOLEAN_AND',
            'T_IS_EQUAL', 'T_IS_NOT_EQUAL', 'T_IS_IDENTICAL',
            'T_IS_NOT_IDENTICAL', 'T_SPACESHIP', 'T_IS_SMALLER_OR_EQUAL',
            'T_IS_GREATER_OR_EQUAL', 'T_SL', 'T_SR', 'T_INSTANCEOF', 'T_INT_CAST',
            'T_DOUBLE_CAST', 'T_STRING_CAST', 'T_BOOL_CAST', 'T_UNSET_CAST',
            'T_POW', 'T_CLONE', 'T_ELSEIF', 'T_ELSE', 'T_LNUMBER', 'T_DNUMBER',
            'T_STRING', 'T_NAME_FULLY_QUALIFIED', 'T_NAME_RELATIVE',
            'T_NAME_QUALIFIED', 'T_VARIABLE', 'T_INLINE_HTML',
            'T_ENCAPSED_AND_WHITESPACE', 'T_CONSTANT_ENCAPSED_STRING',
            'T_STRING_VARNAME', 'T_NUM_STRING', 'T_EVAL', 'T_NEW', 'T_EXIT',
            'T_IF', 'T_ENDIF', 'T_ECHO', 'T_DO', 'T_WHILE', 'T_ENDWHILE', 'T_FOR',
            'T_ENDFOR', 'T_FOREACH', 'T_ENDFOREACH', 'T_DECLARE', 'T_ENDDECLARE',
            'T_AS', 'T_SWITCH', 'T_ENDSWITCH', 'T_CASE', 'T_DEFAULT', 'T_MATCH',
            'T_BREAK', 'T_CONTINUE', 'T_GOTO', 'T_FUNCTION', 'T_FN', 'T_CONST',
            'T_RETURN', 'T_TRY', 'T_CATCH', 'T_FINALLY', 'T_USE', 'T_INSTEADOF',
            'T_GLOBAL', 'T_STATIC', 'T_ABSTRACT', 'T_FINAL', 'T_PRIVATE',
            'T_PROTECTED', 'T_PUBLIC', 'T_VAR', 'T_UNSET', 'T_ISSET', 'T_EMPTY',
            'T_HALT_COMPILER', 'T_CLASS', 'T_TRAIT', 'T_INTERFACE', 'T_EXTENDS',
            'T_IMPLEMENTS', 'T_NAMESPACE', 'T_LIST', 'T_ARRAY', 'T_CALLABLE',
            'T_LINE', 'T_FILE', 'T_DIR', 'T_CLASS_C', 'T_TRAIT_C', 'T_METHOD_C',
            'T_FUNC_C', 'T_NS_C', 'T_ATTRIBUTE', 'T_INC', 'T_DEC',
            'T_OBJECT_OPERATOR', 'T_NULLSAFE_OBJECT_OPERATOR', 'T_COMMENT',
            'T_DOC_COMMENT', 'T_OPEN_TAG', 'T_OPEN_TAG_WITH_ECHO', 'T_CLOSE_TAG',
            'T_WHITESPACE', 'T_START_HEREDOC', 'T_END_HEREDOC',
            'T_DOLLAR_OPEN_CURLY_BRACES', 'T_CURLY_OPEN', 'T_DOUBLE_COLON',
            'T_NS_SEPARATOR', 'T_ELLIPSIS', 'XML_SAX_IMPL', 'LIBXSLT_VERSION',
            'LIBEXSLT_DOTTED_VERSION', 'LIBEXSLT_VERSION', 'YAML_NULL_TAG',
            'YAML_BOOL_TAG', 'YAML_STR_TAG', 'YAML_INT_TAG', 'YAML_FLOAT_TAG',
            'YAML_TIMESTAMP_TAG', 'YAML_SEQ_TAG', 'YAML_MAP_TAG', 'YAML_PHP_TAG',
            'YAML_MERGE_TAG', 'YAML_BINARY_TAG'
            )
        ),
    'SYMBOLS' => array(
        1 => array(
            '<'.'%', '<'.'%=', '%'.'>', '<'.'?', '<'.'?=', '?'.'>'
            ),
        0 => array(
            '(', ')', '[', ']', '{', '}',
            '!', '@', '%', '&', '|', '/',
            '<', '>',
            '=', '-', '+', '*',
            '.', ':', ',', ';'
            )
        ),
    'CASE_SENSITIVE' => array(
        GESHI_COMMENTS => false,
        1 => false,
        2 => false,
        3 => false,
        4 => false
        ),
    'STYLES' => array(
        'KEYWORDS' => array(
            1 => 'color: #b1b100;',
            2 => 'color: #000000; font-weight: bold;',
            3 => 'color: #990000;',
            4 => 'color: #009900; font-weight: bold;'
            ),
        'COMMENTS' => array(
            1 => 'color: #666666; font-style: italic;',
            2 => 'color: #666666; font-style: italic;',
            3 => 'color: #0000cc; font-style: italic;',
            4 => 'color: #009933; font-style: italic;',
            'MULTI' => 'color: #666666; font-style: italic;'
            ),
        'ESCAPE_CHAR' => array(
            0 => 'color: #000099; font-weight: bold;',
            1 => 'color: #000099; font-weight: bold;',
            2 => 'color: #660099; font-weight: bold;',
            3 => 'color: #660099; font-weight: bold;',
            4 => 'color: #006699; font-weight: bold;',
            5 => 'color: #006699; font-weight: bold; font-style: italic;',
            6 => 'color: #009933; font-weight: bold;',
            'HARD' => 'color: #000099; font-weight: bold;'
            ),
        'BRACKETS' => array(
            0 => 'color: #009900;'
            ),
        'STRINGS' => array(
            0 => 'color: #0000ff;',
            'HARD' => 'color: #0000ff;'
            ),
        'NUMBERS' => array(
            0 => 'color: #cc66cc;',
            GESHI_NUMBER_OCT_PREFIX => 'color: #208080;',
            GESHI_NUMBER_HEX_PREFIX => 'color: #208080;',
            GESHI_NUMBER_FLT_SCI_ZERO => 'color:#800080;',
            ),
        'METHODS' => array(
            1 => 'color: #004000;',
            2 => 'color: #004000;'
            ),
        'SYMBOLS' => array(
            0 => 'color: #339933;',
            1 => 'color: #000000; font-weight: bold;'
            ),
        'REGEXPS' => array(
            0 => 'color: #000088;'
            ),
        'SCRIPT' => array(
            0 => '',
            1 => '',
            2 => '',
            3 => '',
            4 => '',
            5 => ''
            )
        ),
    'URLS' => array(
        1 => '',
        2 => '',
        3 => 'http://www.php.net/{FNAMEL}',
        4 => ''
        ),
    'OOLANG' => true,
    'OBJECT_SPLITTERS' => array(
        1 => '-&gt;',
        2 => '::'
        ),
    'REGEXPS' => array(
        //Variables
        0 => "[\\$]+[a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*"
        ),
    'STRICT_MODE_APPLIES' => GESHI_MAYBE,
    'SCRIPT_DELIMITERS' => array(
        0 => array(
            '<'.'?php' => '?'.'>'
            ),
        1 => array(
            '<'.'?' => '?'.'>'
            ),
        2 => array(
            '<'.'%' => '%'.'>'
            ),
        3 => array(
            '<script language="php">' => '</script>'
            ),
        4 => "/(?P<start><\\?(?>php\b)?)(?:".
            "(?>[^\"'?\\/<]+)|".
            "\\?(?!>)|".
            "(?>'(?>[^'\\\\]|\\\\'|\\\\\\\|\\\\)*')|".
            "(?>\"(?>[^\"\\\\]|\\\\\"|\\\\\\\\|\\\\)*\")|".
            "(?>\\/\\*(?>[^\\*]|(?!\\*\\/)\\*)*\\*\\/)|".
            "\\/\\/(?>.*?(?:\\?>|$))|".
            "#(?>.*?(?:\\?>|$))|".
            "\\/(?=[^*\\/])|".
            "<(?!<<)|".
            "<<<(?P<phpdoc>\w+)\s.*?\s\k<phpdoc>".
            ")*?(?P<end>\\?>|\Z)/sm",
        5 => "/(?P<start><%)(?:".
            "(?>[^\"'%\\/<]+)|".
            "%(?!>)|".
            "(?>'(?>[^'\\\\]|\\\\'|\\\\\\\|\\\\)*')|".
            "(?>\"(?>[^\\\"\\\\]|\\\\\"|\\\\\\\\|\\\\)*\")|".
            "(?>\\/\\*(?>[^\\*]|(?!\\*\\/)\\*)*\\*\\/)|".
            "\\/\\/(?>.*?(?:%>|$))|".
            "#(?>.*?(?:%>|$))|".
            "\\/(?=[^*\\/])|".
            "<(?!<<)|".
            "<<<(?P<phpdoc>\w+)\s.*?\s\k<phpdoc>".
            ")*?(?P<end>%>|\Z)/sm",
        ),
    'HIGHLIGHT_STRICT_BLOCK' => array(
        0 => true,
        1 => true,
        2 => true,
        3 => true,
        4 => true,
        5 => true
        ),
    'TAB_WIDTH' => 4
);
