
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `phoenix1103`
--

-- --------------------------------------------------------

--
-- Table structure for table `action_recorder`
--

CREATE TABLE `action_recorder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `user_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `identifier` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `success` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_action_recorder_module_date` (`module`,`date_added`),
  KEY `idx_action_recorder_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `address_book`
--

CREATE TABLE `address_book` (
  `address_book_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `entry_gender` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `entry_company` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `entry_firstname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `entry_lastname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `entry_street_address` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `entry_suburb` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `entry_postcode` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `entry_city` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `entry_state` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `entry_country_id` int(11) NOT NULL DEFAULT '0',
  `entry_zone_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`address_book_id`),
  KEY `idx_address_book_customers_id` (`customers_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `address_format`
--

CREATE TABLE `address_format` (
  `address_format_id` int(11) NOT NULL AUTO_INCREMENT,
  `address_format` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address_summary` varchar(48) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`address_format_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `address_format`
--

INSERT INTO `address_format` VALUES
(1, '$name$cr$streets$cr$city, $postcode$cr$statecomma$country', '$city / $country'),
(2, '$name$cr$streets$cr$city, $state    $postcode$cr$country', '$city, $state / $country'),
(3, '$name$cr$streets$cr$city$cr$postcode - $statecomma$country', '$state / $country'),
(4, '$name$cr$streets$cr$city ($postcode)$cr$country', '$postcode / $country'),
(5, '$name$cr$streets$cr$postcode $city$cr$country', '$city / $country');

-- --------------------------------------------------------

--
-- Table structure for table `administrators`
--

CREATE TABLE `administrators` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(127) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_administrator_user_name` (`user_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `administrators`
--

INSERT INTO `administrators` VALUES
(1, '[[admin_username]]', '[[admin_pass]]');

-- --------------------------------------------------------

--
-- Table structure for table `advert`
--

CREATE TABLE `advert` (
  `advert_id` int(11) NOT NULL AUTO_INCREMENT,
  `advert_title` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `advert_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `advert_fragment` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `advert_image` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `advert_group` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_added` datetime NOT NULL,
  `date_status_change` datetime DEFAULT NULL,
  `sort_order` int(3) DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`advert_id`),
  KEY `idx_advert_group` (`advert_group`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `advert`
--

INSERT INTO `advert` VALUES
(1, 'Our Farm', 'products_new.php', '', 'our-farm.webp', 'carousel', '[[regtime]]', NULL, 20, 1),
(2, 'Strawberries', '', '', 'strawberry.webp', 'carousel', '[[regtime]]', NULL, 10, 1),
(3, 'Lemons', 'index.php', 'cPath=1_4', 'fruit-8848715_640.webp', 'index', '[[regtime]]', NULL, 30, 1),
(4, 'Easy Ordering', 'privacy.php', '', 'laptop-7723139_640.webp', 'index', '[[regtime]]', NULL, 40, 1);

-- --------------------------------------------------------

--
-- Table structure for table `advert_info`
--

CREATE TABLE `advert_info` (
  `advert_id` int(11) NOT NULL,
  `languages_id` int(11) NOT NULL,
  `advert_html_text` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`advert_id`,`languages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `advert_info`
--

INSERT INTO `advert_info` VALUES
(1, 1, '<p class="fs-2 font-weight-bold fw-semibold mb-1">Fresh fruit direct to your door</p>\r\n<p class="fs-4">Grown with <i class="fas fa-heart fa-beat text-danger"></i> on our Devonshire Farm</p>\r\n<p><span class="btn btn-info">Click here to view our full range</span></p>'),
(2, 1, '<p class="fs-2 font-weight-bold fw-semibold mb-1">Strawberries Coming Soon</p>\r\n<p class="fs-4">Pick Your Own at our Farm or delivered direct to your door</p>'),
(3, 1, '<p class="fs-5 font-weight-bold fw-semibold card-title">If life gives you lemons... make Juice!</p>\r\n<p class="card-text">See our full range of Citrus Fruit now</p>'),
(4, 1, '<p class="fs-5 font-weight-bold fw-semibold card-title">Checkout easily using our 3 step checkout!</p>\r\n<p class="card-text">Your details are kept safe and secure</p>');

-- --------------------------------------------------------

--
-- Table structure for table `categories`
--

CREATE TABLE `categories` (
  `categories_id` int(11) NOT NULL AUTO_INCREMENT,
  `categories_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(3) DEFAULT NULL,
  `date_added` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`categories_id`),
  KEY `idx_categories_parent_id` (`parent_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `categories`
--

INSERT INTO `categories` VALUES
(1, 'sample/fruit.webp', 0, 10, '[[regtime]]', NULL),
(2, 'sample/vegetables-1.webp', 0, 20, '[[regtime]]', NULL),
(3, 'sample/apples-pears.webp', 1, 10, '[[regtime]]', NULL),
(4, 'sample/citrus.webp', 1, 20, '[[regtime]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `categories_description`
--

CREATE TABLE `categories_description` (
  `categories_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `categories_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categories_description` text COLLATE utf8mb4_unicode_ci,
  `categories_seo_description` text COLLATE utf8mb4_unicode_ci,
  `categories_seo_title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`categories_id`,`language_id`),
  KEY `idx_categories_name` (`categories_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `categories_description`
--

INSERT INTO `categories_description` VALUES
(1, 1, 'Fruit', 'Fruit contains many nutrients and vitamins essential to health.  Eating fruit is an essential part of a healthy balanced diet.', NULL, NULL),
(2, 1, 'Vegetables', NULL, NULL, NULL),
(3, 1, 'Apples & Pears', 'Fresh and crisp with a variety of flavours.', NULL, NULL),
(4, 1, 'Citrus Fruit', 'Tart, tangy and full of Vitamin C.', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `configuration`
--

CREATE TABLE `configuration` (
  `configuration_id` int(11) NOT NULL AUTO_INCREMENT,
  `configuration_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `configuration_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `configuration_value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `configuration_description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `configuration_group_id` int(11) NOT NULL,
  `sort_order` int(5) DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  `use_function` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `set_function` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`configuration_id`),
  UNIQUE KEY `uq_configuration_key` (`configuration_key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=623 ;

--
-- Dumping data for table `configuration`
--

INSERT INTO `configuration` VALUES
(1, 'Store Name', 'STORE_NAME', '[[site_name]]', 'The name of my store', 1, 1, NULL, '[[regtime]]', NULL, NULL),
(2, 'Store Owner', 'STORE_OWNER', '[[admin_realname]]', 'The name of my store owner', 1, 2, NULL, '[[regtime]]', NULL, NULL),
(3, 'E-Mail Address', 'STORE_OWNER_EMAIL_ADDRESS', '[[admin_email]]', 'The e-mail address of my store owner', 1, 3, NULL, '[[regtime]]', NULL, NULL),
(4, 'Template Selection', 'TEMPLATE_SELECTION', 'override', 'The template to use to display the shop.', 1, 5, NULL, '[[regtime]]', NULL, 'Config::select_template('),
(5, 'Country', 'STORE_COUNTRY', '223', 'The country my store is located in <br><br><strong>Note: Please remember to update the store zone.</strong>', 1, 6, NULL, '[[regtime]]', 'Country::fetch_name', 'Config::select_country('),
(6, 'Zone', 'STORE_ZONE', '18', 'The zone in which my store is located', 1, 7, NULL, '[[regtime]]', 'Config::get_zone_name', 'Config::select_zone_by(STORE_COUNTRY, '),
(7, 'Switch To Default Language Currency', 'USE_DEFAULT_LANGUAGE_CURRENCY', 'false', 'Automatically switch to the language''s currency when it is changed', 1, 10, NULL, '[[regtime]]', NULL, 'Config::select_one([''true'', ''false''], '),
(8, 'Send Extra Order Emails To', 'SEND_EXTRA_ORDER_EMAILS_TO', '', 'Send extra order emails to the following email addresses, in this format: Name 1 &lt;email@address1&gt;, Name 2 &lt;email@address2&gt;', 1, 11, NULL, '[[regtime]]', NULL, NULL),
(9, 'Display Cart After Adding Product', 'DISPLAY_CART', 'true', 'Display the shopping cart after adding a product (or return back to their origin)', 1, 14, NULL, '[[regtime]]', NULL, 'Config::select_one([''true'', ''false''], '),
(10, 'Default Search Operator', 'ADVANCED_SEARCH_DEFAULT_OPERATOR', 'and', 'Default search operators', 1, 17, NULL, '[[regtime]]', NULL, 'Config::select_one([''and'', ''or''], '),
(11, 'Store Address', 'STORE_ADDRESS', 'Address Line 1\nAddress Line 2\nCountry', 'This is the Address of my store used on printable documents and displayed online', 1, 18, NULL, '[[regtime]]', NULL, 'Config::draw_textarea('),
(12, 'Store Phone', 'STORE_PHONE', '555-1234', 'This is the phone number of my store used on printable documents and displayed online', 1, 19, NULL, '[[regtime]]', NULL, 'Config::draw_textarea('),
(13, 'Store Tax ID', 'STORE_TAX_ID', '', 'This is the Tax ID of my business.', 1, 19, NULL, '[[regtime]]', NULL, NULL),
(14, 'Tax Decimal Places', 'TAX_DECIMAL_PLACES', '0', 'Pad the tax value this amount of decimal places', 1, 20, NULL, '[[regtime]]', NULL, NULL),
(15, 'Display Prices with Tax', 'DISPLAY_PRICE_WITH_TAX', 'false', 'Display prices with tax included (true) or add the tax at the end (false)', 1, 21, NULL, '[[regtime]]', NULL, 'Config::select_one([''true'', ''false''], '),
(16, 'Allow all Reviews?', 'ALLOW_ALL_REVIEWS', 'false', 'Allow customers to leave reviews on all products (true) or only on products they have purchased (false)', 1, 22, NULL, '[[regtime]]', NULL, 'Config::select_one([''true'', ''false''], '),
(17, 'Checkout Redirect', 'CHECKOUT_REDIRECT', 'create_account.php', 'At checkout, redirect a new (not logged in) customer to create_account or login page?', 1, 23, NULL, '[[regtime]]', NULL, 'Config::select_one([''create_account.php'', ''login.php''], '),
(18, 'Address Book Entries', 'MAX_ADDRESS_BOOK_ENTRIES', '5', 'Maximum address book entries a customer is allowed to have', 3, 1, NULL, '[[regtime]]', NULL, NULL),
(19, 'Admin Items Per Page', 'MAX_DISPLAY_SEARCH_RESULTS', '20', 'Amount of items to list', 3, 2, NULL, '[[regtime]]', NULL, NULL),
(20, 'Order History', 'MAX_DISPLAY_ORDER_HISTORY', '10', 'Maximum number of orders to display in the order history page', 3, 18, NULL, '[[regtime]]', NULL, NULL),
(21, 'Product Quantities In Shopping Cart', 'MAX_QTY_IN_CART', '99', 'Maximum number of product quantities that can be added to the shopping cart (0 for no limit)', 3, 19, NULL, '[[regtime]]', NULL, NULL),
(22, 'Image Required', 'IMAGE_REQUIRED', 'true', 'Enable to display broken images. Good for development.', 4, 8, NULL, '[[regtime]]', NULL, 'Config::select_one([''true'', ''false''], '),
(23, 'Default Image', 'DEFAULT_IMAGE', '', 'The default image to show if the image is not a valid file.  Leave blank not to show a default.', 4, 5, NULL, '[[regtime]]', NULL, NULL),
(24, 'Installed Modules', 'MODULE_PAYMENT_INSTALLED', 'cod.php;moneyorder.php', 'List of payment module filenames separated by a semi-colon. This is automatically updated. No need to edit. (Example: cod.php;pm2_checkout.php)', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(25, 'Installed Modules', 'MODULE_ORDER_TOTAL_INSTALLED', 'ot_subtotal.php;ot_shipping.php;ot_tax.php;ot_total.php', 'List of order_total module filenames separated by a semi-colon. This is automatically updated. No need to edit.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(26, 'Installed Modules', 'MODULE_SHIPPING_INSTALLED', 'flat.php', 'List of shipping module filenames separated by a semi-colon. This is automatically updated. No need to edit. (Example: ups.php;flat.php;item.php)', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(27, 'Installed Modules', 'MODULE_ACTION_RECORDER_INSTALLED', 'ar_admin_login.php;ar_contact_us.php;ar_reset_password.php', 'List of action recorder module filenames separated by a semi-colon. This is automatically updated. No need to edit.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(28, 'Installed Modules', 'MODULE_CONTENT_NAVBAR_INSTALLED', 'nb_hamburger_button.php;nb_brand.php;nb_currencies.php;nb_account.php;nb_shopping_cart.php;nb_special_offers.php;nb_search.php', 'List of navbar module filenames separated by a semi-colon. This is automatically updated. No need to edit.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(29, 'Enable Cash On Delivery Module', 'MODULE_PAYMENT_COD_STATUS', 'True', 'Do you want to accept Cash On Delevery payments?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(30, 'Payment Zone', 'MODULE_PAYMENT_COD_ZONE', '0', 'If a zone is selected, only enable this payment method for that zone.', 6, 2, NULL, '[[regtime]]', 'geo_zone::fetch_name', 'Config::select_geo_zone('),
(31, 'Sort order of display.', 'MODULE_PAYMENT_COD_SORT_ORDER', '0', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(32, 'Set Order Status', 'MODULE_PAYMENT_COD_ORDER_STATUS_ID', '0', 'Set the status of orders made with this payment module to this value', 6, 1, NULL, '[[regtime]]', 'order_status::fetch_name', 'Config::select_order_status('),
(33, 'Enable Check/Money Order Module', 'MODULE_PAYMENT_MONEYORDER_STATUS', 'True', 'Do you want to accept Check/Money Order payments?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(34, 'Make Payable to:', 'MODULE_PAYMENT_MONEYORDER_PAYTO', 'Your Store', 'Who should payments be made payable to?', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(35, 'Sort order of display.', 'MODULE_PAYMENT_MONEYORDER_SORT_ORDER', '10', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(36, 'Payment Zone', 'MODULE_PAYMENT_MONEYORDER_ZONE', '0', 'If a zone is selected, only enable this payment method for that zone.', 6, 4, NULL, '[[regtime]]', 'geo_zone::fetch_name', 'Config::select_geo_zone('),
(37, 'Set Order Status', 'MODULE_PAYMENT_MONEYORDER_ORDER_STATUS_ID', '0', 'Set the status of orders made with this payment module to this value', 6, 5, NULL, '[[regtime]]', 'order_status::fetch_name', 'Config::select_order_status('),
(38, 'Enable Flat Shipping', 'MODULE_SHIPPING_FLAT_STATUS', 'True', 'Do you want to offer flat rate shipping?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(39, 'Shipping Cost', 'MODULE_SHIPPING_FLAT_COST', '5.00', 'The shipping cost for all orders using this shipping method.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(40, 'Tax Class', 'MODULE_SHIPPING_FLAT_TAX_CLASS', '0', 'Use the following tax class on the shipping fee.', 6, 3, NULL, '[[regtime]]', 'geo_zone::fetch_name', 'Config::select_tax_class('),
(41, 'Shipping Zone', 'MODULE_SHIPPING_FLAT_ZONE', '0', 'If a zone is selected, only enable this shipping method for that zone.', 6, 4, NULL, '[[regtime]]', 'geo_zone::fetch_name', 'Config::select_geo_zone('),
(42, 'Sort Order', 'MODULE_SHIPPING_FLAT_SORT_ORDER', '0', 'Sort order of display.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(43, 'Default Currency', 'DEFAULT_CURRENCY', 'USD', 'Default Currency', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(44, 'Default Language', 'DEFAULT_LANGUAGE', 'en', 'Default Language', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(45, 'Default Order Status For New Orders', 'DEFAULT_ORDERS_STATUS_ID', '1', 'When a new order is created, this order status will be assigned to it.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(46, 'Display Delivery Cost', 'MODULE_ORDER_TOTAL_SHIPPING_STATUS', 'True', 'Do you want to display the order delivery cost?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(47, 'Sort Order', 'MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER', '20', 'Sort order of display.', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(48, 'Allow Free Delivery', 'MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING', 'False', 'Do you want to allow free delivery?', 6, 3, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(49, 'Free Delivery For Orders Over', 'MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER', '50', 'Provide free delivery for orders over the set amount.', 6, 4, NULL, '[[regtime]]', 'currencies->format', NULL),
(50, 'Provide Free Delivery For Orders Made', 'MODULE_ORDER_TOTAL_SHIPPING_DESTINATION', 'national', 'Provide free delivery for orders sent to the set destination.', 6, 5, NULL, '[[regtime]]', NULL, 'Config::select_one([''national'', ''international'', ''both''], '),
(51, 'Display Sub-Total', 'MODULE_ORDER_TOTAL_SUBTOTAL_STATUS', 'True', 'Do you want to display the order sub-total cost?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(52, 'Sort Order', 'MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER', '10', 'Sort order of display.', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(53, 'Display Tax', 'MODULE_ORDER_TOTAL_TAX_STATUS', 'True', 'Do you want to display the order tax value?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(54, 'Sort Order', 'MODULE_ORDER_TOTAL_TAX_SORT_ORDER', '30', 'Sort order of display.', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(55, 'Display Total', 'MODULE_ORDER_TOTAL_TOTAL_STATUS', 'True', 'Do you want to display the total order value?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(56, 'Sort Order', 'MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER', '40', 'Sort order of display.', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(57, 'Minimum Minutes Per E-Mail', 'MODULE_ACTION_RECORDER_CONTACT_US_EMAIL_MINUTES', '15', 'Minimum number of minutes to allow 1 e-mail to be sent (eg, 15 for 1 e-mail every 15 minutes)', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(58, 'Allowed Minutes', 'MODULE_ACTION_RECORDER_ADMIN_LOGIN_MINUTES', '5', 'Number of minutes to allow login attempts to occur.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(59, 'Allowed Attempts', 'MODULE_ACTION_RECORDER_ADMIN_LOGIN_ATTEMPTS', '3', 'Number of login attempts to allow within the specified period.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(60, 'Allowed Minutes', 'MODULE_ACTION_RECORDER_RESET_PASSWORD_MINUTES', '5', 'Number of minutes to allow password resets to occur.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(61, 'Allowed Attempts', 'MODULE_ACTION_RECORDER_RESET_PASSWORD_ATTEMPTS', '1', 'Number of password reset attempts to allow within the specified period.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(62, 'Enter the Maximum Package Weight you will ship', 'SHIPPING_MAX_WEIGHT', '50', 'Carriers have a max weight limit for a single package. This is a common one for all.', 7, 3, NULL, '[[regtime]]', NULL, NULL),
(63, 'Package Tare weight.', 'SHIPPING_BOX_WEIGHT', '0', 'What is the weight of typical packaging of small to medium packages?', 7, 4, NULL, '[[regtime]]', NULL, NULL),
(64, 'Larger packages - percentage increase.', 'SHIPPING_BOX_PADDING', '0', 'For 10% enter 10', 7, 5, NULL, '[[regtime]]', NULL, NULL),
(65, 'Allow Orders not covered by any shipping modules', 'SHIPPING_ALLOW_UNDEFINED_ZONES', 'False', 'Should orders be allowed to shipping addresses not matching defined shipping module shipping zones?', 7, 5, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(66, 'Products Per Row', 'IS_PRODUCT_PRODUCTS_DISPLAY_ROW', 'row row-cols-2 row-cols-sm-3 row-cols-md-4', 'How many products should display per Row per viewport?  Default:  XS 2, SM 3, MD and above 4', 8, 110, NULL, '[[regtime]]', NULL, NULL),
(67, 'Sort Option: Manufacturer Name (0=disable; 1=enable)', 'PRODUCT_LIST_MANUFACTURER', '0', 'Allow sorting by Manufacturer Name?', 8, 200, NULL, '[[regtime]]', NULL, NULL),
(68, 'Sort Option: Model (0=disable; 1=enable)', 'PRODUCT_LIST_MODEL', '0', 'Allow sorting by Product Model?', 8, 210, NULL, '[[regtime]]', NULL, NULL),
(69, 'Sort Option: Name (0=disable; 1=enable)', 'PRODUCT_LIST_NAME', '1', 'Allow sorting by Product Name?', 8, 220, NULL, '[[regtime]]', NULL, NULL),
(70, 'Sort Option: Price (0=disable; 1=enable)', 'PRODUCT_LIST_PRICE', '1', 'Allow sorting by Product Price', 8, 230, NULL, '[[regtime]]', NULL, NULL),
(71, 'Sort Option: Stock (0=disable; 1=enable)', 'PRODUCT_LIST_QUANTITY', '0', 'Allow sorting by Product Quantity (Stock)?', 8, 240, NULL, '[[regtime]]', NULL, NULL),
(72, 'Sort Option: Weight (0=disable; 1=enable)', 'PRODUCT_LIST_WEIGHT', '0', 'Allow sorting by Product Weight?', 8, 250, NULL, '[[regtime]]', NULL, NULL),
(73, 'Sort Option: Latest Added (0=disable; 1=enable)', 'PRODUCT_LIST_ID', '1', 'Allow sorting by Latest Added?', 8, 260, NULL, '[[regtime]]', NULL, NULL),
(74, 'Sort Option: Sales (0=disable; 1=enable)', 'PRODUCT_LIST_ORDERED', '1', 'Allow sorting by Number of Sales?', 8, 270, NULL, '[[regtime]]', NULL, NULL),
(75, 'Display buttons in product listing', 'PRODUCT_LIST_BUTTONS', 'False', 'Do you want to display buy and view buttons in the product listing', 8, 290, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(76, 'Display Category/Manufacturer Filter (0=disable; 1=enable)', 'PRODUCT_LIST_FILTER', '1', 'Do you want to display the Category/Manufacturer Filter?', 8, 300, NULL, '[[regtime]]', NULL, NULL),
(77, 'Location of Prev/Next Navigation Bar (1-top, 2-bottom, 3-both)', 'PREV_NEXT_BAR_LOCATION', '2', 'Sets the location of the Prev/Next Navigation Bar (1-top, 2-bottom, 3-both)', 8, 310, NULL, '[[regtime]]', NULL, NULL),
(78, 'Products Per Page', 'MAX_DISPLAY_PRODUCTS_PER_PAGE', '20', 'Amount of products to list per page', 8, 292, NULL, '[[regtime]]', NULL, NULL),
(79, 'Page Links', 'MAX_DISPLAY_PAGE_LINKS', '5', 'Number of ''number'' links use for page-sets', 8, 294, NULL, '[[regtime]]', NULL, NULL),
(80, 'Check stock level', 'STOCK_CHECK', 'true', 'Check to see if sufficent stock is available', 9, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''true'', ''false''], '),
(81, 'Subtract stock', 'STOCK_LIMITED', 'true', 'Subtract product in stock by product orders', 9, 2, NULL, '[[regtime]]', NULL, 'Config::select_one([''true'', ''false''], '),
(82, 'Allow Checkout', 'STOCK_ALLOW_CHECKOUT', 'true', 'Allow customer to checkout even if there is insufficient stock', 9, 3, NULL, '[[regtime]]', NULL, 'Config::select_one([''true'', ''false''], '),
(83, 'Mark product out of stock', 'STOCK_MARK_PRODUCT_OUT_OF_STOCK', '<i class="fas fa-times fa-2x text-danger"></i>', 'Display something on screen so customer can see which product has insufficient stock', 9, 4, NULL, '[[regtime]]', NULL, NULL),
(84, 'Stock Re-order level', 'STOCK_REORDER_LEVEL', '5', 'Define when stock needs to be re-ordered', 9, 5, NULL, '[[regtime]]', NULL, NULL),
(85, 'Store Page Parse Time', 'STORE_PAGE_PARSE_TIME', 'false', 'Store the time it takes to parse a page', 10, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''true'', ''false''], '),
(86, 'Log Destination', 'STORE_PAGE_PARSE_TIME_LOG', '/var/log/www/tep/page_parse_time.log', 'Directory and filename of the page parse time log', 10, 2, NULL, '[[regtime]]', NULL, NULL),
(87, 'Log Date Format', 'STORE_PARSE_DATE_TIME_FORMAT', '%d/%m/%Y %H:%M:%S', 'The date format', 10, 3, NULL, '[[regtime]]', NULL, NULL),
(88, 'Display The Page Parse Time', 'DISPLAY_PAGE_PARSE_TIME', 'true', 'Display the page parse time (store page parse time must be enabled)', 10, 4, NULL, '[[regtime]]', NULL, 'Config::select_one([''true'', ''false''], '),
(89, 'Store Database Queries', 'STORE_DB_TRANSACTIONS', 'false', 'Store the database queries in the page parse time log', 10, 5, NULL, '[[regtime]]', NULL, 'Config::select_one([''true'', ''false''], '),
(90, 'E-Mail Transport Method', 'EMAIL_TRANSPORT', 'sendmail', 'Defines if this server uses a local connection to sendmail or uses an SMTP connection via TCP/IP. Servers running on Windows and MacOS should change this setting to SMTP.', 12, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''sendmail'', ''smtp''],'),
(91, 'E-Mail Linefeeds', 'EMAIL_LINEFEED', 'LF', 'Defines the character sequence used to separate mail headers.', 12, 2, NULL, '[[regtime]]', NULL, 'Config::select_one([''LF'', ''CRLF''],'),
(92, 'Use MIME HTML When Sending Emails', 'EMAIL_USE_HTML', 'false', 'Send e-mails in HTML format', 12, 3, NULL, '[[regtime]]', NULL, 'Config::select_one([''true'', ''false''],'),
(93, 'Verify E-Mail Addresses Through DNS', 'ENTRY_EMAIL_ADDRESS_CHECK', 'false', 'Verify e-mail address through a DNS server', 12, 4, NULL, '[[regtime]]', NULL, 'Config::select_one([''true'', ''false''], '),
(94, 'Send E-Mails', 'SEND_EMAILS', 'true', 'Send out e-mails', 12, 5, NULL, '[[regtime]]', NULL, 'Config::select_one([''true'', ''false''], '),
(95, 'E-Mail From', 'EMAIL_FROM', 'root@localhost', 'All e-mails will be sent from this address', 12, 6, NULL, '[[regtime]]', NULL, NULL),
(96, 'Enable download', 'DOWNLOAD_ENABLED', 'true', 'Enable the products download functions.', 13, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''true'', ''false''], '),
(97, 'Download by redirect', 'DOWNLOAD_BY_REDIRECT', 'true', 'Use browser redirection for download. Disable on non-Unix systems.', 13, 2, NULL, '[[regtime]]', NULL, 'Config::select_one([''true'', ''false''], '),
(98, 'Expiry delay (days)', 'DOWNLOAD_MAX_DAYS', '7', 'Set number of days before the download link expires. 0 means no limit.', 13, 3, NULL, '[[regtime]]', NULL, ''),
(99, 'Maximum number of downloads', 'DOWNLOAD_MAX_COUNT', '5', 'Set the maximum number of downloads. 0 means no download authorized.', 13, 4, NULL, '[[regtime]]', NULL, ''),
(100, 'Enable GZip Compression', 'GZIP_COMPRESSION', 'false', 'Enable HTTP GZip compression.', 14, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''true'', ''false''], '),
(101, 'Compression Level', 'GZIP_LEVEL', '5', 'Use this compression level 0-9 (0 = minimum, 9 = maximum).', 14, 2, NULL, '[[regtime]]', NULL, NULL),
(102, 'Force Cookie Use', 'SESSION_FORCE_COOKIE_USE', 'False', 'Force the use of sessions when cookies are only enabled.', 15, 2, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(103, 'Check SSL Session ID', 'SESSION_CHECK_SSL_SESSION_ID', 'False', 'Validate the SSL_SESSION_ID on every secure HTTPS page request.', 15, 3, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(104, 'Check User Agent', 'SESSION_CHECK_USER_AGENT', 'False', 'Validate the clients browser user agent on every page request.', 15, 4, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(105, 'Check IP Address', 'SESSION_CHECK_IP_ADDRESS', 'False', 'Validate the clients IP address on every page request.', 15, 5, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(106, 'Prevent Spider Sessions', 'SESSION_BLOCK_SPIDERS', 'True', 'Prevent known spiders from starting a session.', 15, 6, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(107, 'Recreate Session', 'SESSION_RECREATE', 'True', 'Recreate the session to generate a new session ID when the customer logs on or creates an account.', 15, 7, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(108, 'Last Update Check Time', 'LAST_UPDATE_CHECK_TIME', '', 'Last time a check for new versions of CE Phoenix was run', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(109, 'Store Logo', 'STORE_LOGO', 'store_logo.png', 'This is the filename of your Store Logo.  This should be updated at admin > configuration > Store Logo', 6, 1000, NULL, '[[regtime]]', NULL, NULL),
(110, 'Mini Logo', 'MINI_LOGO', 'mini_logo.png', 'This is the filename of your Mini Logo.  This should be updated at admin > configuration > Store Logo', 6, 1100, NULL, '[[regtime]]', NULL, NULL),
(111, 'Favicon', 'FAVICON_LOGO', 'favicon.png', 'This is the filename of your Favicon.  This should be updated at admin > configuration > Store Logo', 6, 1200, NULL, '[[regtime]]', NULL, NULL),
(112, 'Bootstrap Container', 'BOOTSTRAP_CONTAINER', 'container-xl', 'What type of container should the page content be shown in? See <a target="_blank" rel="noreferrer" href="https://getbootstrap.com/docs/5.3/layout/containers/"><u>layout/#containers</u></a>.', 16, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''container'', ''container-sm'', ''container-md'', ''container-lg'', ''container-xl'', ''container-xxl'', ''container-fluid''], '),
(113, 'Bootstrap Content', 'BOOTSTRAP_CONTENT', '8', 'What width should the page content default to?  (8 = two thirds width, 6 = half width, 4 = one third width) Note that the Side Column(s) will adjust automatically.', 16, 2, NULL, '[[regtime]]', NULL, 'Config::select_one([''10'', ''8'', ''6'', ''5'', ''3'', ''2''], '),
(114, 'Installed Modules', 'MODULE_HEADER_TAGS_INSTALLED', 'ht_category_seo.php;ht_manufacturer_seo.php;ht_pages_seo.php;ht_manufacturer_title.php;ht_category_title.php;ht_product_title.php;ht_robot_noindex.php;ht_table_click_jquery.php;ht_product_meta.php;ht_product_opengraph.php;ht_product_schema.php;ht_outgoing.php;ht_canonical.php', 'List of header tag module filenames separated by a semi-colon. This is automatically updated. No need to edit.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(115, 'Enable Product Meta Module', 'MODULE_HEADER_TAGS_PRODUCT_META_STATUS', 'True', 'Do you want to allow product meta tags to be added to the page header?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(116, 'Enable Keyword Search Engine', 'MODULE_HEADER_TAGS_PRODUCT_META_KEYWORDS_STATUS', 'True', 'Enable Keyword Search Engine', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(117, 'Sort Order', 'MODULE_HEADER_TAGS_PRODUCT_META_SORT_ORDER', '910', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(118, 'Enable Product OpenGraph Module', 'MODULE_HEADER_TAGS_PRODUCT_OPENGRAPH_STATUS', 'True', 'Do you want to allow Open Graph Meta Tags (good for Facebook and Pinterest and other sites) to be added to your product page?  Note that your product thumbnails MUST be at least 200px by 200px.', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(119, 'Sort Order', 'MODULE_HEADER_TAGS_PRODUCT_OPENGRAPH_SORT_ORDER', '900', 'Sort order of display. Lowest is displayed first.', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(120, 'Enable Product Schema Module', 'MODULE_HEADER_TAGS_PRODUCT_SCHEMA_STATUS', 'True', 'Do you want to add a product schema to your product page?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(121, 'Enable Product Schema Module', 'MODULE_HEADER_TAGS_PRODUCT_SCHEMA_PLACEMENT', 'Header', 'Where should the code be placed?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''Header'', ''Footer''], '),
(122, 'Sort Order', 'MODULE_HEADER_TAGS_PRODUCT_SCHEMA_SORT_ORDER', '950', 'Sort order of display. Lowest is displayed first.', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(123, 'Enable Category Meta Module', 'MODULE_HEADER_TAGS_CATEGORY_SEO_STATUS', 'True', 'Do you want to allow Category Meta Tags to be added to the page header?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(124, 'Enable Category Meta Description', 'MODULE_HEADER_TAGS_CATEGORY_SEO_DESCRIPTION_STATUS', 'True', 'These help your site and your sites visitors.', 6, 2, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(125, 'Sort Order', 'MODULE_HEADER_TAGS_CATEGORY_SEO_SORT_ORDER', '210', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(126, 'Enable Manufacturer Meta Module', 'MODULE_HEADER_TAGS_MANUFACTURERS_SEO_STATUS', 'True', 'Do you want to allow Manufacturer meta tags to be added to the page header?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(127, 'Display Manufacturer Meta Description', 'MODULE_HEADER_TAGS_MANUFACTURERS_SEO_DESCRIPTION_STATUS', 'True', 'Manufacturer Descriptions help your site and your sites visitors.', 6, 2, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(128, 'Sort Order', 'MODULE_HEADER_TAGS_MANUFACTURERS_SEO_SORT_ORDER', '110', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(129, 'Enable Pages SEO Module', 'MODULE_HEADER_TAGS_PAGES_SEO_STATUS', 'True', 'Do you want to allow this module to write SEO to your Pages?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(130, 'Sort Order', 'MODULE_HEADER_TAGS_PAGES_SEO_SORT_ORDER', '400', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(131, 'Enable Category Title Module', 'MODULE_HEADER_TAGS_CATEGORY_TITLE_STATUS', 'True', 'Do you want to allow category titles to be added to the page title?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(132, 'Sort Order', 'MODULE_HEADER_TAGS_CATEGORY_TITLE_SORT_ORDER', '200', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(133, 'SEO Title Override?', 'MODULE_HEADER_TAGS_CATEGORY_TITLE_SEO_TITLE_OVERRIDE', 'True', 'Do you want to allow category titles to be over-ridden by your SEO Titles (if set)?', 6, 3, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(134, 'Enable Manufacturer Title Module', 'MODULE_HEADER_TAGS_MANUFACTURER_TITLE_STATUS', 'True', 'Do you want to allow manufacturer titles to be added to the page title?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(135, 'Sort Order', 'MODULE_HEADER_TAGS_MANUFACTURER_TITLE_SORT_ORDER', '100', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(136, 'SEO Title Override?', 'MODULE_HEADER_TAGS_MANUFACTURER_TITLE_SEO_TITLE_OVERRIDE', 'True', 'Do you want to allow manufacturer names to be over-ridden by your SEO Titles (if set)?', 6, 0, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(137, 'Enable Product Title Module', 'MODULE_HEADER_TAGS_PRODUCT_TITLE_STATUS', 'True', 'Do you want to allow product titles to be added to the page title?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(138, 'Sort Order', 'MODULE_HEADER_TAGS_PRODUCT_TITLE_SORT_ORDER', '920', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(139, 'SEO Title Override?', 'MODULE_HEADER_TAGS_PRODUCT_TITLE_SEO_TITLE_OVERRIDE', 'True', 'Do you want to allow product titles to be over-ridden by your SEO Titles (if set)?', 6, 0, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(140, 'Enable Robot NoIndex Module', 'MODULE_HEADER_TAGS_ROBOT_NOINDEX_STATUS', 'True', 'Do you want to enable the Robot NoIndex module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(141, 'Pages', 'MODULE_HEADER_TAGS_ROBOT_NOINDEX_PAGES', 'account.php;account_edit.php;account_history.php;account_history_info.php;account_newsletters.php;account_notifications.php;account_password.php;address_book.php;address_book_process.php;checkout_confirmation.php;checkout_payment.php;checkout_payment_address.php;checkout_process.php;checkout_shipping.php;checkout_shipping_address.php;checkout_success.php;cookie_usage.php;create_account.php;create_account_success.php;login.php;logoff.php;password_forgotten.php;password_reset.php;shopping_cart.php;ssl_check.php', 'The pages to add the meta robot noindex tag to.', 6, 0, NULL, '[[regtime]]', 'page_selection::_show_pages', 'page_selection::_edit_pages('),
(142, 'Sort Order', 'MODULE_HEADER_TAGS_ROBOT_NOINDEX_SORT_ORDER', '500', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(143, 'Enable Clickable Table Rows Module', 'MODULE_HEADER_TAGS_TABLE_CLICK_JQUERY_STATUS', 'True', 'Do you want to enable this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(144, 'Pages', 'MODULE_HEADER_TAGS_TABLE_CLICK_JQUERY_PAGES', 'checkout_payment.php;checkout_shipping.php', 'The pages to add the necessary javascript to.', 6, 2, NULL, '[[regtime]]', 'page_selection::_show_pages', 'page_selection::_edit_pages('),
(145, 'Background Colour', 'MODULE_HEADER_TAGS_TABLE_CLICK_JQUERY_TR_BACKGROUND', 'table-success', 'The background colour of the clicked Row.  See  https://getbootstrap.com/docs/5.3/content/tables/#variants', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(146, 'Sort Order', 'MODULE_HEADER_TAGS_TABLE_CLICK_JQUERY_SORT_ORDER', '800', 'Sort order of display. Lowest is displayed first.', 6, 4, NULL, '[[regtime]]', NULL, NULL),
(147, 'Enable Queued E-mail Module', 'MODULE_HEADER_TAGS_O_STATUS', 'True', 'Do you want to enable the this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(148, 'Sort Order', 'MODULE_HEADER_TAGS_O_SORT_ORDER', '810', 'Sort order of display. Lowest is displayed first.', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(149, 'Enable Canonical Module', 'MODULE_HEADER_TAGS_CANONICAL_STATUS', 'True', 'Do you want to enable the this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(150, 'Sort Order', 'MODULE_HEADER_TAGS_CANONICAL_SORT_ORDER', '820', 'Sort order of display. Lowest is displayed first.', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(151, 'Installed Modules', 'MODULE_ADMIN_DASHBOARD_INSTALLED', 'd_total_revenue.php;d_monthly_sales.php;d_orders.php;d_customers.php;d_phoenix_addons.php;d_addons.php;d_security_checks.php;d_admin_logins.php;d_version_check.php;d_reviews.php', 'List of Administration Tool Dashboard module filenames separated by a semi-colon. This is automatically updated. No need to edit.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(152, 'Enable Module', 'MODULE_ADMIN_DASHBOARD_TOTAL_REVENUE_STATUS', 'True', 'Do you want to show this module on the dashboard?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(153, 'Days', 'MODULE_ADMIN_DASHBOARD_TOTAL_REVENUE_DAYS', '7,30', 'Days to display.  Comma separated list will display each period in a tabbed interface.', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(154, 'Step Size', 'MODULE_ADMIN_DASHBOARD_TOTAL_REVENUE_STEP', '0', 'This is the Y Axis Step Size in Currency Units.  Make this a number that is about half or so of your average daily sales, you can play with this to suit the Graph output.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(155, 'Content Container', 'MODULE_ADMIN_DASHBOARD_TOTAL_REVENUE_CONTENT_WIDTH', 'col-md-6 mb-2', 'What container should the content be shown in? (Default: XS-SM full width, MD and above half width).', 6, 4, NULL, '[[regtime]]', NULL, NULL),
(156, 'Sort Order', 'MODULE_ADMIN_DASHBOARD_TOTAL_REVENUE_SORT_ORDER', '100', 'Sort order of display. Lowest is displayed first.', 6, 5, NULL, '[[regtime]]', NULL, NULL),
(157, 'Enable Module', 'MODULE_ADMIN_DASHBOARD_MONTHLY_SALES_STATUS', 'True', 'Do you want to show this module on the dashboard?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(158, 'Months', 'MODULE_ADMIN_DASHBOARD_MONTHLY_SALES_MONTHS', '3,6,12', 'Months to display.  Comma separated list will display each period in a tabbed interface.', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(159, 'Step Size', 'MODULE_ADMIN_DASHBOARD_MONTHLY_SALES_STEP', '0', 'This is the Y Axis Step Size in Currency Units.  Make this a number that is about half or so of your average monthly sales, you can play with this to suit the Graph output.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(160, 'Content Container', 'MODULE_ADMIN_DASHBOARD_MONTHLY_SALES_CONTENT_WIDTH', 'col-md-6 mb-2', 'What container should the content be shown in? (Default: XS-SM full width, MD and above half width).', 6, 4, NULL, '[[regtime]]', NULL, NULL),
(161, 'Sort Order', 'MODULE_ADMIN_DASHBOARD_MONTHLY_SALES_SORT_ORDER', '50', 'Sort order of display. Lowest is displayed first.', 6, 5, NULL, '[[regtime]]', NULL, NULL),
(162, 'Enable Orders Module', 'MODULE_ADMIN_DASHBOARD_ORDERS_STATUS', 'True', 'Do you want to show the latest orders on the dashboard?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(163, 'Orders to display', 'MODULE_ADMIN_DASHBOARD_ORDERS_DISPLAY', '5', 'This number of Orders will display, ordered by most recent.', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(164, 'Content Container', 'MODULE_ADMIN_DASHBOARD_ORDERS_CONTENT_WIDTH', 'col-md-6 mb-2', 'What container should the content be shown in? (Default: XS-SM full width, MD and above half width).', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(165, 'Sort Order', 'MODULE_ADMIN_DASHBOARD_ORDERS_SORT_ORDER', '300', 'Sort order of display. Lowest is displayed first.', 6, 4, NULL, '[[regtime]]', NULL, NULL),
(166, 'Enable Customers Module', 'MODULE_ADMIN_DASHBOARD_CUSTOMERS_STATUS', 'True', 'Do you want to show the newest customers on the dashboard?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(167, 'Customers to display', 'MODULE_ADMIN_DASHBOARD_CUSTOMERS_DISPLAY', '5', 'This number of Customers will display, ordered by most recent sign up.', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(168, 'Content Container', 'MODULE_ADMIN_DASHBOARD_CUSTOMERS_CONTENT_WIDTH', 'col-md-6 mb-2', 'What container should the content be shown in? (Default: XS-SM full width, MD and above half width).', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(169, 'Sort Order', 'MODULE_ADMIN_DASHBOARD_CUSTOMERS_SORT_ORDER', '400', 'Sort order of display. Lowest is displayed first.', 6, 4, NULL, '[[regtime]]', NULL, NULL),
(170, 'Enable Module', 'MODULE_ADMIN_DASHBOARD_PHOENIX_ADDONS_STATUS', 'True', 'Do you want to show the latest Partner news on the dashboard?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(171, 'Content Container', 'MODULE_ADMIN_DASHBOARD_PHOENIX_ADDONS_CONTENT_WIDTH', 'col-md-6 mb-2', 'What container should the content be shown in? (Default: XS-SM full width, MD and above half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(172, 'Sort Order', 'MODULE_ADMIN_DASHBOARD_PHOENIX_ADDONS_SORT_ORDER', '500', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(173, 'Enable Module', 'MODULE_ADMIN_DASHBOARD_ADDONS_STATUS', 'True', 'Do you want to show this module on the dashboard?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(174, 'Addons to display', 'MODULE_ADMIN_DASHBOARD_ADDONS_DISPLAY', '5', 'This number of Addons will display, ordered by most recent.', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(175, 'Content Container', 'MODULE_ADMIN_DASHBOARD_ADDONS_CONTENT_WIDTH', 'col-md-6 mb-2', 'What container should the content be shown in? (Default: XS-SM full width, MD and above half width).', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(176, 'Sort Order', 'MODULE_ADMIN_DASHBOARD_ADDONS_SORT_ORDER', '550', 'Sort order of display. Lowest is displayed first.', 6, 4, NULL, '[[regtime]]', NULL, NULL),
(177, 'Enable Security Checks Module', 'MODULE_ADMIN_DASHBOARD_SECURITY_CHECKS_STATUS', 'True', 'Do you want to run the security checks for this installation?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(178, 'Content Container', 'MODULE_ADMIN_DASHBOARD_SECURITY_CHECKS_CONTENT_WIDTH', 'col-md-6 mb-2', 'What container should the content be shown in? (Default: XS-SM full width, MD and above half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(179, 'Sort Order', 'MODULE_ADMIN_DASHBOARD_SECURITY_CHECKS_SORT_ORDER', '600', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(180, 'Enable Administrator Logins Module', 'MODULE_ADMIN_DASHBOARD_ADMIN_LOGINS_STATUS', 'True', 'Do you want to show the latest administrator logins on the dashboard?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(181, 'Logins to display', 'MODULE_ADMIN_DASHBOARD_ADMIN_LOGINS_DISPLAY', '5', 'This number of Logins will display, ordered by latest access.', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(182, 'Content Container', 'MODULE_ADMIN_DASHBOARD_ADMIN_LOGINS_CONTENT_WIDTH', 'col-md-6 mb-2', 'What container should the content be shown in? (Default: XS-SM full width, MD and above half width).', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(183, 'Sort Order', 'MODULE_ADMIN_DASHBOARD_ADMIN_LOGINS_SORT_ORDER', '1000', 'Sort order of display. Lowest is displayed first.', 6, 4, NULL, '[[regtime]]', NULL, NULL),
(184, 'Enable Version Check Module', 'MODULE_ADMIN_DASHBOARD_VERSION_CHECK_STATUS', 'True', 'Do you want to show the version check results on the dashboard?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(185, 'Content Container', 'MODULE_ADMIN_DASHBOARD_VERSION_CHECK_CONTENT_WIDTH', 'col-md-6 mb-2', 'What container should the content be shown in? (Default: XS-SM full width, MD and above half width).', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(186, 'Sort Order', 'MODULE_ADMIN_DASHBOARD_VERSION_CHECK_SORT_ORDER', '900', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(187, 'Enable Reviews Module', 'MODULE_ADMIN_DASHBOARD_REVIEWS_STATUS', 'True', 'Do you want to show the latest reviews on the dashboard?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(188, 'Reviews to display', 'MODULE_ADMIN_DASHBOARD_REVIEWS_DISPLAY', '5', 'This number of Reviews will display, ordered by latest added.', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(189, 'Content Container', 'MODULE_ADMIN_DASHBOARD_REVIEWS_CONTENT_WIDTH', 'col-md-6 mb-2', 'What container should the content be shown in? (Default: XS-SM full width, MD and above half width).', 6, 1, NULL, '[[regtime]]', NULL, NULL),
(190, 'Sort Order', 'MODULE_ADMIN_DASHBOARD_REVIEWS_SORT_ORDER', '800', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(191, 'Installed Modules', 'MODULE_BOXES_INSTALLED', '', 'List of box module filenames separated by a semi-colon. This is automatically updated. No need to edit.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(192, 'Installed Template Block Groups', 'TEMPLATE_BLOCK_GROUPS', 'boxes;header_tags', 'This is automatically updated. No need to edit.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(193, 'Installed Modules', 'MODULE_CONTENT_INSTALLED', 'account/cm_account_gdpr;account/cm_account_title;account/cm_account_gdpr_nuke;account/cm_account_set_password;checkout_success/cm_cs_title;checkout_success/cm_cs_redirect_old_order;checkout_success/cm_cs_thank_you;checkout_success/cm_cs_product_notifications;checkout_success/cm_cs_downloads;checkout_success/cm_cs_continue_button;contact_us/cm_cu_title;contact_us/cm_cu_modular;create_account_success/cm_cas_title;create_account_success/cm_cas_message;create_account_success/cm_cas_continue_button;footer/cm_footer_information_links;footer/cm_footer_account;footer/cm_footer_contact_us;footer/cm_footer_text;footer_suffix/cm_footer_extra_copyright;footer_suffix/cm_footer_extra_icons;gdpr/cm_gdpr_intro;gdpr/cm_gdpr_personal_details;gdpr/cm_gdpr_contact_details;gdpr/cm_gdpr_contact_addresses;gdpr/cm_gdpr_site_details;gdpr/cm_gdpr_acceptance_data;gdpr/cm_gdpr_site_actions;gdpr/cm_gdpr_orders;gdpr/cm_gdpr_reviews;gdpr/cm_gdpr_testimonials;gdpr/cm_gdpr_cookies;gdpr/cm_gdpr_ip_addresses;gdpr/cm_gdpr_notifications;gdpr/cm_gdpr_cart;gdpr/cm_gdpr_port_my_data;header/cm_header_messagestack;header/cm_header_breadcrumb;header/cm_header_menu;index/cm_i_slider;index/cm_i_card_products;index/cm_i_modular;index_nested/cm_in_title;index_nested/cm_in_category_description;index_nested/cm_in_category_listing;index_nested/cm_in_card_products;index_products/cm_ip_title;index_products/cm_ip_category_manufacturer_description;index_products/cm_ip_product_listing;info/cm_info_title;info/cm_info_text;login/cm_login_form;login/cm_forgot_password;login/cm_create_account_link;navigation/cm_navbar;product_info/cm_pi_name;product_info/cm_pi_price;product_info/cm_pi_review_stars;product_info/cm_pi_modular;product_info/cm_pi_description;product_info/cm_pi_reviews;product_info_not_found/cm_pinf_message;shopping_cart/cm_sc_title;shopping_cart/cm_sc_no_products;shopping_cart/cm_sc_product_listing;shopping_cart/cm_sc_order_subtotal;shopping_cart/cm_sc_stock_notice;shopping_cart/cm_sc_checkout;testimonials/cm_t_title;testimonials/cm_t_list;testimonials/cm_t_write', 'This is automatically updated. No need to edit.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(194, 'Enable Set Account Password', 'MODULE_CONTENT_ACCOUNT_SET_PASSWORD_STATUS', 'True', 'Do you want to enable the Set Account Password module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(195, 'Allow Local Passwords', 'MODULE_CONTENT_ACCOUNT_SET_PASSWORD_ALLOW_PASSWORD', 'True', 'Allow local account passwords to be set.', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(196, 'Sort Order', 'MODULE_CONTENT_ACCOUNT_SET_PASSWORD_SORT_ORDER', '100', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(197, 'Enable Redirect Old Order Module', 'MODULE_CONTENT_CHECKOUT_SUCCESS_REDIRECT_OLD_ORDER_STATUS', 'True', 'Should customers be redirected when viewing old checkout success orders?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(198, 'Redirect Minutes', 'MODULE_CONTENT_CHECKOUT_SUCCESS_REDIRECT_OLD_ORDER_MINUTES', '60', 'Redirect customers to the My Account page after an order older than this amount is viewed.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(199, 'Sort Order', 'MODULE_CONTENT_CHECKOUT_SUCCESS_REDIRECT_OLD_ORDER_SORT_ORDER', '500', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(200, 'Enable Thank You Module', 'MODULE_CONTENT_CHECKOUT_SUCCESS_THANK_YOU_STATUS', 'True', 'Should the thank you block be shown on the checkout success page?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(201, 'Content Container', 'MODULE_CONTENT_CHECKOUT_SUCCESS_THANK_YOU_CONTENT_WIDTH', 'col-sm-7', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(202, 'Sort Order', 'MODULE_CONTENT_CHECKOUT_SUCCESS_THANK_YOU_SORT_ORDER', '1000', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(203, 'Enable Product Notifications Module', 'MODULE_CONTENT_CHECKOUT_SUCCESS_PRODUCT_NOTIFICATIONS_STATUS', 'True', 'Should the product notifications block be shown on the checkout success page?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(204, 'Content Container', 'MODULE_CONTENT_CHECKOUT_SUCCESS_PRODUCT_NOTIFICATIONS_CONTENT_WIDTH', 'col-sm-5', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(205, 'Sort Order', 'MODULE_CONTENT_CHECKOUT_SUCCESS_PRODUCT_NOTIFICATIONS_SORT_ORDER', '2000', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(206, 'Enable Product Downloads Module', 'MODULE_CONTENT_CHECKOUT_SUCCESS_DOWNLOADS_STATUS', 'True', 'Should ordered product download links be shown on the checkout success page?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(207, 'Content Container', 'MODULE_CONTENT_CHECKOUT_SUCCESS_DOWNLOADS_CONTENT_WIDTH', 'col-sm-12 mt-2', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(208, 'Sort Order', 'MODULE_CONTENT_CHECKOUT_SUCCESS_DOWNLOADS_SORT_ORDER', '3000', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(209, 'Enable Login Form Module', 'MODULE_CONTENT_LOGIN_FORM_STATUS', 'True', 'Do you want to enable the login form module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(210, 'Content Container', 'MODULE_CONTENT_LOGIN_FORM_CONTENT_WIDTH', 'col-sm-6 offset-sm-3', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 1, NULL, '[[regtime]]', NULL, NULL),
(211, 'Sort Order', 'MODULE_CONTENT_LOGIN_FORM_SORT_ORDER', '1000', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(212, 'Enable New User Module', 'MODULE_CONTENT_CREATE_ACCOUNT_LINK_STATUS', 'True', 'Do you want to enable the new user module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(213, 'Content Container', 'MODULE_CONTENT_CREATE_ACCOUNT_LINK_CONTENT_WIDTH', 'col-sm-6 offset-sm-3 mt-4', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 1, NULL, '[[regtime]]', NULL, NULL),
(214, 'Sort Order', 'MODULE_CONTENT_CREATE_ACCOUNT_LINK_SORT_ORDER', '2000', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(215, 'Enable Forgot Password Module', 'MODULE_CONTENT_FORGOT_PASSWORD_STATUS', 'True', 'Do you want to enable this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(216, 'Content Container', 'MODULE_CONTENT_FORGOT_PASSWORD_CONTENT_WIDTH', 'col-sm-6 offset-sm-3 mt-2', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 1, NULL, '[[regtime]]', NULL, NULL),
(217, 'Sort Order', 'MODULE_CONTENT_FORGOT_PASSWORD_SORT_ORDER', '1500', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(218, 'Enable Hamburger Button Module', 'MODULE_NAVBAR_HAMBURGER_BUTTON_STATUS', 'True', 'Do you want to add the module to your Navbar?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(219, 'Content Placement', 'MODULE_NAVBAR_HAMBURGER_BUTTON_CONTENT_PLACEMENT', 'Home', 'This module must be placed in the Home area of the Navbar.', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''Home''], '),
(220, 'Sort Order', 'MODULE_NAVBAR_HAMBURGER_BUTTON_SORT_ORDER', '500', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(221, 'Enable Brand Module', 'MODULE_NAVBAR_BRAND_STATUS', 'True', 'Do you want to add the module to your Navbar?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(222, 'Content Placement', 'MODULE_NAVBAR_BRAND_CONTENT_PLACEMENT', 'Home', 'This module must be placed in the Home area of the Navbar.', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''Home''], '),
(223, 'Sort Order', 'MODULE_NAVBAR_BRAND_SORT_ORDER', '505', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(224, 'Enable Shopping Cart Module', 'MODULE_NAVBAR_SHOPPING_CART_STATUS', 'True', 'Do you want to add the module to your Navbar?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], ');
INSERT INTO `configuration` VALUES
(225, 'Content Placement', 'MODULE_NAVBAR_SHOPPING_CART_CONTENT_PLACEMENT', 'Right', 'Should the module be loaded in the Left or Right or the Home area of the Navbar?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''Home'', ''Left'', ''Center'', ''Right''], '),
(226, 'Sort Order', 'MODULE_NAVBAR_SHOPPING_CART_SORT_ORDER', '550', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(227, 'Enable Currencies Module', 'MODULE_NAVBAR_CURRENCIES_STATUS', 'True', 'Do you want to add the module to your Navbar?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(228, 'Content Placement', 'MODULE_NAVBAR_CURRENCIES_CONTENT_PLACEMENT', 'Right', 'Should the module be loaded in the Left or Right or the Home area of the Navbar?', 6, 2, NULL, '[[regtime]]', NULL, 'Config::select_one([''Home'', ''Left'', ''Center'', ''Right''], '),
(229, 'Sort Order', 'MODULE_NAVBAR_CURRENCIES_SORT_ORDER', '530', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(230, 'Enable Account Module', 'MODULE_NAVBAR_ACCOUNT_STATUS', 'True', 'Do you want to add the module to your Navbar?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(231, 'Content Placement', 'MODULE_NAVBAR_ACCOUNT_CONTENT_PLACEMENT', 'Right', 'Should the module be loaded in the Left or Right or the Home area of the Navbar?', 6, 2, NULL, '[[regtime]]', NULL, 'Config::select_one([''Home'', ''Left'', ''Center'', ''Right''], '),
(232, 'Sort Order', 'MODULE_NAVBAR_ACCOUNT_SORT_ORDER', '540', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(233, 'Enable Special Offers Module', 'MODULE_NAVBAR_SPECIAL_OFFERS_STATUS', 'True', 'Do you want to add the module to your Navbar?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(234, 'Content Placement Group', 'MODULE_NAVBAR_SPECIAL_OFFERS_CONTENT_PLACEMENT', 'Left', 'Where should the module be loaded?  Lowest is loaded first, per Group.', 6, 2, NULL, '[[regtime]]', NULL, 'Config::select_one([''Home'', ''Left'', ''Center'', ''Right''], '),
(235, 'Sort Order', 'MODULE_NAVBAR_SPECIAL_OFFERS_SORT_ORDER', '530', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(236, 'Enable Module', 'MODULE_NAVBAR_SEARCH_STATUS', 'True', 'Do you want to add the module to your Navbar?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(237, 'Content Placement Group', 'MODULE_NAVBAR_SEARCH_CONTENT_PLACEMENT', 'Left', 'Where should the module be loaded?  Lowest is loaded first, per Group.', 6, 2, NULL, '[[regtime]]', NULL, 'Config::select_one([''Home'', ''Left'', ''Center'', ''Right''], '),
(238, 'Sort Order', 'MODULE_NAVBAR_SEARCH_SORT_ORDER', '525', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(239, 'Enable Navbar Module', 'MODULE_CONTENT_NAVBAR_STATUS', 'True', 'Should the Navbar be shown? ', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(240, 'Background Colour Scheme', 'MODULE_CONTENT_NAVBAR_STYLE_BG', 'bg-light navbar-light bg-body-secondary border-bottom', 'What background and foreground colour should the Navbar have?  See <a target="_blank" rel="noreferrer" href="https://getbootstrap.com/docs/5.3/utilities/background/#background-color"><u>background/#background-color</u></a> and <a target="_blank" rel="noreferrer" href="https://getbootstrap.com/docs/5.3/components/navbar/#color-schemes"><u>navbar/#color-schemes</u></a>', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(241, 'Placement', 'MODULE_CONTENT_NAVBAR_FIXED', 'sticky-top', 'Should the Navbar be Fixed/Sticky/Default behaviour? See <a target="_blank" rel="noreferrer" href="https://getbootstrap.com/docs/5.3/components/navbar/#placement"><u>navbar/#placement</u></a>', 6, 4, NULL, '[[regtime]]', NULL, 'Config::select_one([''fixed-top'', ''fixed-bottom'', ''sticky-top'', ''floating''], '),
(242, 'Placement Offset', 'MODULE_CONTENT_NAVBAR_OFFSET', '4rem', 'Offset if using fixed-* Placement.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(243, 'Collapse', 'MODULE_CONTENT_NAVBAR_COLLAPSE', 'navbar-expand-sm', 'When should the Navbar Show? See <a target="_blank" rel="noreferrer" href="https://getbootstrap.com/docs/5.3/components/navbar/#how-it-works"><u>navbar/#how-it-works</u></a>', 6, 6, NULL, '[[regtime]]', NULL, 'Config::select_one([''navbar-expand'', ''navbar-expand-sm'', ''navbar-expand-md'', ''navbar-expand-lg'', ''navbar-expand-xl'', ''navbar-expand-xxl''], '),
(244, 'Sort Order', 'MODULE_CONTENT_NAVBAR_SORT_ORDER', '10', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(245, 'Enable Message Stack Notifications Module', 'MODULE_CONTENT_HEADER_MESSAGESTACK_STATUS', 'True', 'Should the Message Stack Notifications be shown in the header when needed? ', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(246, 'Content Container', 'MODULE_CONTENT_HEADER_MESSAGESTACK_CONTENT_WIDTH', 'col-sm-12', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(247, 'Sort Order', 'MODULE_CONTENT_HEADER_MESSAGESTACK_SORT_ORDER', '30', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(248, 'Enable Header Breadcrumb Module', 'MODULE_CONTENT_HEADER_BREADCRUMB_STATUS', 'True', 'Do you want to enable the Breadcrumb content module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(249, 'Content Container', 'MODULE_CONTENT_HEADER_BREADCRUMB_CONTENT_WIDTH', 'col-sm-12', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 1, NULL, '[[regtime]]', NULL, NULL),
(250, 'Sort Order', 'MODULE_CONTENT_HEADER_BREADCRUMB_SORT_ORDER', '40', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(251, 'Location?', 'MODULE_CONTENT_HEADER_BREADCRUMB_LOCATION', 'Schema', 'Where you want the breadcrumb to be used.  Display in the Header, post as Schema entries, or Both.', 6, 4, NULL, '[[regtime]]', NULL, 'Config::select_one([''Header'', ''Schema'', ''Both''], '),
(252, 'Category SEO Override?', 'MODULE_CONTENT_HEADER_BREADCRUMB_CATEGORY_SEO_OVERRIDE', 'True', 'Do you want to allow category titles to be over-ridden by your SEO Titles (if set)?', 6, 5, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(253, 'Manufacturer SEO Override?', 'MODULE_CONTENT_HEADER_BREADCRUMB_MANUFACTURER_SEO_OVERRIDE', 'True', 'Do you want to allow manufacturer names in the breadcrumb to be over-ridden by your SEO Titles (if set)?', 6, 6, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(254, 'Product SEO Override?', 'MODULE_CONTENT_HEADER_BREADCRUMB_PRODUCT_SEO_OVERRIDE', 'True', 'Do you want to allow product names in the breadcrumb to be over-ridden by your SEO Titles (if set)?', 6, 7, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(255, 'Enable Horizontal Menu Module', 'MODULE_CONTENT_HEADER_MENU_STATUS', 'True', 'Do you want to enable this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(256, 'Content Container', 'MODULE_CONTENT_HEADER_MENU_CONTENT_WIDTH', 'col-sm-12 mb-1', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(257, 'Colour Scheme', 'MODULE_CONTENT_HEADER_MENU_STYLE', '', 'What colour scheme should this Navigation Bar have?  See https://getbootstrap.com/docs/5.3/components/navbar/#color-schemes', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(258, 'Collapse Breakpoint', 'MODULE_CONTENT_HEADER_MENU_COLLAPSE', 'navbar-expand-sm', 'When should this Navigation Bar Show? See https://getbootstrap.com/docs/5.3/components/navbar/#how-it-works', 6, 4, NULL, '[[regtime]]', NULL, 'Config::select_one([''navbar-expand'', ''navbar-expand-sm'', ''navbar-expand-md'', ''navbar-expand-lg'', ''navbar-expand-xl'', ''navbar-expand-xxl''], '),
(259, 'Display Manufacturers', 'MODULE_CONTENT_HEADER_MENU_MANUFACTURERS', 'True', 'Manufacturers will display on the Right Hand Side of the Horizontal Menu, if True', 6, 5, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(260, 'Sort Order', 'MODULE_CONTENT_HEADER_MENU_SORT_ORDER', '900', 'Sort order of display. Lowest is displayed first.', 6, 6, NULL, '[[regtime]]', NULL, NULL),
(261, 'Enable Information Links Footer Module', 'MODULE_CONTENT_FOOTER_INFORMATION_STATUS', 'True', 'Do you want to enable this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(262, 'Content Container', 'MODULE_CONTENT_FOOTER_INFORMATION_CONTENT_WIDTH', 'col-sm-6 col-md-3 mb-2 mb-sm-0', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 1, NULL, '[[regtime]]', NULL, NULL),
(263, 'Sort Order', 'MODULE_CONTENT_FOOTER_INFORMATION_SORT_ORDER', '10', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(264, 'Enable Account Footer Module', 'MODULE_CONTENT_FOOTER_ACCOUNT_STATUS', 'True', 'Do you want to enable this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(265, 'Content Container', 'MODULE_CONTENT_FOOTER_ACCOUNT_CONTENT_WIDTH', 'col-sm-6 col-md-3 mb-2 mb-sm-0', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(266, 'Sort Order', 'MODULE_CONTENT_FOOTER_ACCOUNT_SORT_ORDER', '20', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(267, 'Enable Contact Us Footer Module', 'MODULE_CONTENT_FOOTER_CONTACT_US_STATUS', 'True', 'Do you want to enable this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(268, 'Content Container', 'MODULE_CONTENT_FOOTER_CONTACT_US_CONTENT_WIDTH', 'col-sm-6 col-md-3 mb-2 mb-sm-0', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(269, 'Sort Order', 'MODULE_CONTENT_FOOTER_CONTACT_US_SORT_ORDER', '30', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(270, 'Enable Generic Text Footer Module', 'MODULE_CONTENT_FOOTER_TEXT_STATUS', 'True', 'Do you want to enable this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(271, 'Content Container', 'MODULE_CONTENT_FOOTER_TEXT_CONTENT_WIDTH', 'col-sm-6 col-md-3 mb-2 mb-sm-0', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(272, 'Sort Order', 'MODULE_CONTENT_FOOTER_TEXT_SORT_ORDER', '40', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(273, 'Enable Copyright Details Footer Module', 'MODULE_CONTENT_FOOTER_EXTRA_COPYRIGHT_STATUS', 'True', 'Do you want to enable the Copyright content module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(274, 'Content Container', 'MODULE_CONTENT_FOOTER_EXTRA_COPYRIGHT_CONTENT_WIDTH', 'col-sm-6 text-center text-sm-left text-sm-start', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 1, NULL, '[[regtime]]', NULL, NULL),
(275, 'Sort Order', 'MODULE_CONTENT_FOOTER_EXTRA_COPYRIGHT_SORT_ORDER', '10', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(276, 'Enable Payment Icons Footer Module', 'MODULE_CONTENT_FOOTER_EXTRA_ICONS_STATUS', 'True', 'Do you want to enable the Payment Icons content module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(277, 'Content Container', 'MODULE_CONTENT_FOOTER_EXTRA_ICONS_CONTENT_WIDTH', 'col-sm-6 text-center text-sm-right text-sm-end', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 1, NULL, '[[regtime]]', NULL, NULL),
(278, 'Icons', 'MODULE_CONTENT_FOOTER_EXTRA_ICONS_DISPLAY', 'fab fa-paypal fa-lg,fab fa-cc-visa fa-lg', 'Icons to display.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(279, 'Sort Order', 'MODULE_CONTENT_FOOTER_EXTRA_ICONS_SORT_ORDER', '20', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(280, 'Enable Title Module', 'MODULE_CONTENT_ACCOUNT_TITLE_STATUS', 'True', 'Do you want to enable this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(281, 'Content Container', 'MODULE_CONTENT_ACCOUNT_TITLE_CONTENT_WIDTH', 'col-sm-12 mb-4', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(282, 'Sort Order', 'MODULE_CONTENT_ACCOUNT_TITLE_SORT_ORDER', '10', 'Sort order of display. Lowest is displayed first.', 6, 5, NULL, '[[regtime]]', NULL, NULL),
(283, 'Enable Title Module', 'MODULE_CONTENT_CHECKOUT_SUCCESS_TITLE_STATUS', 'True', 'Do you want to enable this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(284, 'Content Container', 'MODULE_CONTENT_CHECKOUT_SUCCESS_TITLE_CONTENT_WIDTH', 'col-sm-12 mb-4', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(285, 'Sort Order', 'MODULE_CONTENT_CHECKOUT_SUCCESS_TITLE_SORT_ORDER', '50', 'Sort order of display. Lowest is displayed first.', 6, 5, NULL, '[[regtime]]', NULL, NULL),
(286, 'Enable Continue Button', 'MODULE_CONTENT_CS_CONTINUE_BUTTON_STATUS', 'True', 'Should this module be shown on the product info page?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(287, 'Content Container', 'MODULE_CONTENT_CS_CONTINUE_BUTTON_CONTENT_WIDTH', 'col-sm-12 my-2', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 1, NULL, '[[regtime]]', NULL, NULL),
(288, 'Sort Order', 'MODULE_CONTENT_CS_CONTINUE_BUTTON_SORT_ORDER', '5000', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(289, 'Enable Slider Module', 'MODULE_CONTENT_I_SLIDER_STATUS', 'True', 'Do you want to enable this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(290, 'Content Container', 'MODULE_CONTENT_I_SLIDER_CONTENT_WIDTH', 'col-sm-12 mb-4', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(291, 'Advert Group', 'MODULE_CONTENT_I_SLIDER_GRP', 'carousel', 'Choose which Advert Group this module should display..', 6, 3, NULL, '[[regtime]]', 'adverts::advert_get_group', 'adverts::advert_pull_down_groups('),
(292, 'Enable Controls', 'MODULE_CONTENT_I_SLIDER_CONTROLS', 'True', 'Do you want to show Left/Right Arrows?', 6, 4, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(293, 'Enable Indicators', 'MODULE_CONTENT_I_SLIDER_INDICATORS', 'True', 'Do you want to show Left/Right Arrows?', 6, 5, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(294, 'Display Style', 'MODULE_CONTENT_I_SLIDER_FADE', 'Fade', 'Slide from the right or Fade In?', 6, 6, NULL, '[[regtime]]', NULL, 'Config::select_one([''Fade'', ''Slide''], '),
(295, 'Interval', 'MODULE_CONTENT_I_SLIDER_INTERVAL', '10000', 'How long a slide is seen before the next.  10000 = 10 seconds.', 6, 7, NULL, '[[regtime]]', NULL, NULL),
(296, 'Sort Order', 'MODULE_CONTENT_I_SLIDER_SORT_ORDER', '75', 'Sort order of display. Lowest is displayed first.', 6, 8, NULL, '[[regtime]]', NULL, NULL),
(297, 'Enable New Products Module', 'MODULE_CONTENT_CARD_PRODUCTS_STATUS', 'True', 'Do you want to enable this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(298, 'Content Container', 'MODULE_CONTENT_CARD_PRODUCTS_CONTENT_WIDTH', 'col-sm-12 mb-4', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(299, 'Maximum Display', 'MODULE_CONTENT_CARD_PRODUCTS_MAX_DISPLAY', '4', 'Maximum Number of products that should show in this module?', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(300, 'Sort Order', 'MODULE_CONTENT_CARD_PRODUCTS_SORT_ORDER', '300', 'Sort order of display. Lowest is displayed first.', 6, 5, NULL, '[[regtime]]', NULL, NULL),
(301, 'Enable &pi; Modular index', 'MODULE_CONTENT_I_MODULAR_STATUS', 'True', 'Should this module be shown on the index page?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(302, 'Content Container', 'MODULE_CONTENT_I_MODULAR_CONTENT_WIDTH', 'col-sm-12', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(303, 'Slot Width: A', 'MODULE_CONTENT_I_MODULAR_A_WIDTH', 'col-sm-12', 'What width should Slot A be?  Note that Slots in a Row should totalise 12.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(304, 'Slot Width: B', 'MODULE_CONTENT_I_MODULAR_B_WIDTH', 'col-sm-12', 'What width should Slot B be?  Note that Slots in a Row should totalise 12.', 6, 4, NULL, '[[regtime]]', NULL, NULL),
(305, 'Slot Width: C', 'MODULE_CONTENT_I_MODULAR_C_WIDTH', 'col-sm-6', 'What width should Slot C be?  Note that Slots in a Row should totalise 12.', 6, 5, NULL, '[[regtime]]', NULL, NULL),
(306, 'Slot Width: D', 'MODULE_CONTENT_I_MODULAR_D_WIDTH', 'col-sm-6', 'What width should Slot D be?  Note that Slots in a Row should totalise 12.', 6, 6, NULL, '[[regtime]]', NULL, NULL),
(307, 'Slot Width: E', 'MODULE_CONTENT_I_MODULAR_E_WIDTH', 'col-sm-4', 'What width should Slot E be?  Note that Slots in a Row should totalise 12.', 6, 7, NULL, '[[regtime]]', NULL, NULL),
(308, 'Slot Width: F', 'MODULE_CONTENT_I_MODULAR_F_WIDTH', 'col-sm-4', 'What width should Slot F be?  Note that Slots in a Row should totalise 12.', 6, 8, NULL, '[[regtime]]', NULL, NULL),
(309, 'Slot Width: G', 'MODULE_CONTENT_I_MODULAR_G_WIDTH', 'col-sm-4', 'What width should Slot G be?  Note that Slots in a Row should totalise 12.', 6, 9, NULL, '[[regtime]]', NULL, NULL),
(310, 'Slot Width: H', 'MODULE_CONTENT_I_MODULAR_H_WIDTH', 'col-sm-6', 'What width should Slot H be?  Note that Slots in a Row should totalise 12.', 6, 10, NULL, '[[regtime]]', NULL, NULL),
(311, 'Slot Width: I', 'MODULE_CONTENT_I_MODULAR_I_WIDTH', 'col-sm-6', 'What width should Slot I be?  Note that Slots in a Row should totalise 12.', 6, 11, NULL, '[[regtime]]', NULL, NULL),
(312, 'Sort Order', 'MODULE_CONTENT_I_MODULAR_SORT_ORDER', '310', 'Sort order of display. Lowest is displayed first.', 6, 12, NULL, '[[regtime]]', NULL, NULL),
(313, 'Enable Title Module', 'MODULE_CONTENT_IN_TITLE_STATUS', 'True', 'Do you want to enable this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(314, 'Content Container', 'MODULE_CONTENT_IN_TITLE_CONTENT_WIDTH', 'col-sm-12 mb-4', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(315, 'Sort Order', 'MODULE_CONTENT_IN_TITLE_SORT_ORDER', '50', 'Sort order of display. Lowest is displayed first.', 6, 5, NULL, '[[regtime]]', NULL, NULL),
(316, 'Enable Category Description Module', 'MODULE_CONTENT_IN_CATEGORY_DESCRIPTION_STATUS', 'True', 'Should this module be enabled?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(317, 'Content Container', 'MODULE_CONTENT_IN_CATEGORY_DESCRIPTION_CONTENT_WIDTH', 'col-sm-12 mb-4', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(318, 'Sort Order', 'MODULE_CONTENT_IN_CATEGORY_DESCRIPTION_SORT_ORDER', '100', 'Sort order of display. Lowest is displayed first.', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(319, 'Enable Category Listing Module', 'MODULE_CONTENT_IN_CATEGORY_LISTING_STATUS', 'True', 'Should this module be enabled?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(320, 'Content Container', 'MODULE_CONTENT_IN_CATEGORY_LISTING_CONTENT_WIDTH', 'col-sm-12 mb-4', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(321, 'Categories Per Row', 'MODULE_CONTENT_IN_CATEGORY_LISTING_DISPLAY_ROW', 'row row-cols-2 row-cols-sm-3 row-cols-md-4', 'How many categories should display per Row per viewport?  Default:  XS 2, SM 3, MD and above 4', 6, 4, NULL, '[[regtime]]', NULL, NULL),
(322, 'Sort Order', 'MODULE_CONTENT_IN_CATEGORY_LISTING_SORT_ORDER', '200', 'Sort order of display. Lowest is displayed first.', 6, 8, NULL, '[[regtime]]', NULL, NULL),
(323, 'Enable New Products Module', 'MODULE_CONTENT_IN_CARD_PRODUCTS_STATUS', 'True', 'Do you want to enable this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(324, 'Content Container', 'MODULE_CONTENT_IN_CARD_PRODUCTS_CONTENT_WIDTH', 'col-sm-12 mb-4', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(325, 'Maximum Display', 'MODULE_CONTENT_IN_CARD_PRODUCTS_MAX_DISPLAY', '6', 'Maximum Number of products that should show in this module?', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(326, 'Sort Order', 'MODULE_CONTENT_IN_CARD_PRODUCTS_SORT_ORDER', '300', 'Sort order of display. Lowest is displayed first.', 6, 5, NULL, '[[regtime]]', NULL, NULL),
(327, 'Enable Title Module', 'MODULE_CONTENT_IP_TITLE_STATUS', 'True', 'Do you want to enable this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(328, 'Content Container', 'MODULE_CONTENT_IP_TITLE_CONTENT_WIDTH', 'col-sm-12 mb-4', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(329, 'Sort Order', 'MODULE_CONTENT_IP_TITLE_SORT_ORDER', '50', 'Sort order of display. Lowest is displayed first.', 6, 5, NULL, '[[regtime]]', NULL, NULL),
(330, 'Enable Category/Manufacturer Description Module', 'MODULE_CONTENT_IP_CATEGORY_DESCRIPTION_STATUS', 'True', 'Should this module be enabled?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(331, 'Content Container', 'MODULE_CONTENT_IP_CATEGORY_DESCRIPTION_CONTENT_WIDTH', 'col-sm-12 mb-4', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(332, 'Sort Order', 'MODULE_CONTENT_IP_CATEGORY_DESCRIPTION_SORT_ORDER', '100', 'Sort order of display. Lowest is displayed first.', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(333, 'Enable Product Listing Module', 'MODULE_CONTENT_IP_PRODUCT_LISTING_STATUS', 'True', 'Should this module be enabled?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(334, 'Content Container', 'MODULE_CONTENT_IP_PRODUCT_LISTING_CONTENT_WIDTH', 'col-sm-12 mb-4', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(335, 'Sort Order', 'MODULE_CONTENT_IP_PRODUCT_LISTING_SORT_ORDER', '200', 'Sort order of display. Lowest is displayed first.', 6, 4, NULL, '[[regtime]]', NULL, NULL),
(336, 'Enable Message Module', 'MODULE_CONTENT_PINF_MESSAGE_STATUS', 'True', 'Should this module be shown on the product info page?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(337, 'Content Container', 'MODULE_CONTENT_PINF_MESSAGE_CONTENT_WIDTH', 'col-sm-12', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 1, NULL, '[[regtime]]', NULL, NULL),
(338, 'Sort Order', 'MODULE_CONTENT_PINF_MESSAGE_SORT_ORDER', '10', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(339, 'Enable Name Module', 'MODULE_CONTENT_PI_NAME_STATUS', 'True', 'Should this module be shown on the product info page?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(340, 'Content Container', 'MODULE_CONTENT_PI_NAME_CONTENT_WIDTH', 'col-sm-7', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 1, NULL, '[[regtime]]', NULL, NULL),
(341, 'Sort Order', 'MODULE_CONTENT_PI_NAME_SORT_ORDER', '40', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(342, 'Enable Price Module', 'MODULE_CONTENT_PI_PRICE_STATUS', 'True', 'Should this module be shown on the product info page?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(343, 'Content Container', 'MODULE_CONTENT_PI_PRICE_CONTENT_WIDTH', 'col-sm-5 text-start text-sm-end', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 1, NULL, '[[regtime]]', NULL, NULL),
(344, 'Sort Order', 'MODULE_CONTENT_PI_PRICE_SORT_ORDER', '50', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(345, 'Enable Review Stars/Link Module', 'MODULE_CONTENT_PI_REVIEW_STARS_STATUS', 'True', 'Should this module be shown on the product info page?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(346, 'Content Container', 'MODULE_CONTENT_PI_REVIEW_STARS_CONTENT_WIDTH', 'col-sm-12', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(347, 'Sort Order', 'MODULE_CONTENT_PI_REVIEW_STARS_SORT_ORDER', '55', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(348, 'Enable Description Module', 'MODULE_CONTENT_PI_DESCRIPTION_STATUS', 'True', 'Should this module be shown on the product info page?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(349, 'Content Container', 'MODULE_CONTENT_PI_DESCRIPTION_CONTENT_WIDTH', 'col-sm-12', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 1, NULL, '[[regtime]]', NULL, NULL),
(350, 'Sort Order', 'MODULE_CONTENT_PI_DESCRIPTION_SORT_ORDER', '60', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(351, 'Enable Reviews Module', 'MODULE_CONTENT_PRODUCT_INFO_REVIEWS_STATUS', 'True', 'Should the reviews block be shown on the product info page?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(352, 'Content Container', 'MODULE_CONTENT_PRODUCT_INFO_REVIEWS_CONTENT_WIDTH', 'col-sm-12', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 1, NULL, '[[regtime]]', NULL, NULL),
(353, 'Review Container', 'MODULE_CONTENT_PRODUCT_INFO_REVIEWS_CONTENT_WIDTH_EACH', 'col-sm-6', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 1, NULL, '[[regtime]]', NULL, NULL),
(354, 'Number of Reviews', 'MODULE_CONTENT_PRODUCT_INFO_REVIEWS_CONTENT_LIMIT', '99', 'How many reviews should be shown?', 6, 1, NULL, '[[regtime]]', NULL, NULL),
(355, 'Sort Order', 'MODULE_CONTENT_PRODUCT_INFO_REVIEWS_ORDER', 'reviews_rating', 'Display Reviews by Rating (High to Low) or Date Added (New to Old)', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''reviews_rating'', ''date_added''], '),
(356, 'Sort Order', 'MODULE_CONTENT_PRODUCT_INFO_REVIEWS_SORT_ORDER', '120', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(357, 'Enable Shopping Cart Title Module', 'MODULE_CONTENT_SC_TITLE_STATUS', 'True', 'Do you want to enable this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(358, 'Content Container', 'MODULE_CONTENT_SC_TITLE_CONTENT_WIDTH', 'col-sm-12 mb-4', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(359, 'Sort Order', 'MODULE_CONTENT_SC_TITLE_SORT_ORDER', '100', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(360, 'Enable Shopping Cart No Products Message', 'MODULE_CONTENT_SC_NO_PRODUCTS_STATUS', 'True', 'Do you want to add the module to your shop?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(361, 'Content Container', 'MODULE_CONTENT_SC_NO_PRODUCTS_CONTENT_WIDTH', 'col-sm-12', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(362, 'Sort Order', 'MODULE_CONTENT_SC_NO_PRODUCTS_SORT_ORDER', '110', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(363, 'Enable Shopping Cart Product Listing', 'MODULE_CONTENT_SC_PRODUCT_LISTING_STATUS', 'True', 'Do you want to add the module to your shop?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(364, 'Content Container', 'MODULE_CONTENT_SC_PRODUCT_LISTING_CONTENT_WIDTH', 'col-sm-12', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(365, 'Sort Order', 'MODULE_CONTENT_SC_PRODUCT_LISTING_SORT_ORDER', '120', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(366, 'Enable Shopping Cart Order SubTotal', 'MODULE_CONTENT_SC_ORDER_SUBTOTAL_STATUS', 'True', 'Do you want to add the module to your shop?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(367, 'Content Container', 'MODULE_CONTENT_SC_ORDER_SUBTOTAL_CONTENT_WIDTH', 'col-sm-12 mt-2', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(368, 'Sort Order', 'MODULE_CONTENT_SC_ORDER_SUBTOTAL_SORT_ORDER', '130', 'Sort order of display. Lowest is displayed first.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(369, 'Enable Shopping Cart Stock Notice', 'MODULE_CONTENT_SC_STOCK_NOTICE_STATUS', 'True', 'Do you want to add the module to your shop?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(370, 'Content Container', 'MODULE_CONTENT_SC_STOCK_NOTICE_CONTENT_WIDTH', 'col-sm-12 mt-2', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(371, 'Sort Order', 'MODULE_CONTENT_SC_STOCK_NOTICE_SORT_ORDER', '140', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(372, 'Enable Shopping Cart Checkout Button', 'MODULE_CONTENT_SC_CHECKOUT_STATUS', 'True', 'Do you want to add the module to your shop?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(373, 'Content Container', 'MODULE_CONTENT_SC_CHECKOUT_CONTENT_WIDTH', 'col-sm-12', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(374, 'Sort Order', 'MODULE_CONTENT_SC_CHECKOUT_SORT_ORDER', '150', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(375, 'Enable Title Module', 'MODULE_CONTENT_TESTIMONIALS_TITLE_STATUS', 'True', 'Do you want to enable this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(376, 'Content Container', 'MODULE_CONTENT_TESTIMONIALS_TITLE_CONTENT_WIDTH', 'col-sm-12 mb-4', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(377, 'Sort Order', 'MODULE_CONTENT_TESTIMONIALS_TITLE_SORT_ORDER', '100', 'Sort order of display. Lowest is displayed first.', 6, 5, NULL, '[[regtime]]', NULL, NULL),
(378, 'Enable List Module', 'MODULE_CONTENT_TESTIMONIALS_LIST_STATUS', 'True', 'Do you want to enable this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(379, 'Content Container', 'MODULE_CONTENT_TESTIMONIALS_LIST_CONTENT_WIDTH', 'col-sm-12 mb-2', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(380, 'View Testimonials', 'MODULE_CONTENT_TESTIMONIALS_LIST_ALL', 'Language Specific', 'Do you want to show all Testimonials or language specific Testimonials?', 6, 3, NULL, '[[regtime]]', NULL, 'Config::select_one([''All'', ''Language Specific''], '),
(381, 'Number of Testimonials', 'MODULE_CONTENT_TESTIMONIALS_LIST_PAGING', '12', 'How many Testimonials to display per page.', 6, 5, NULL, '[[regtime]]', NULL, NULL),
(382, 'Item Width', 'MODULE_CONTENT_TESTIMONIALS_LIST_CONTENT_WIDTH_EACH', 'col-sm-6 mb-2', 'What container should each Testimonial be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(383, 'Sort Order', 'MODULE_CONTENT_TESTIMONIALS_LIST_SORT_ORDER', '200', 'Sort order of display. Lowest is displayed first.', 6, 5, NULL, '[[regtime]]', NULL, NULL),
(384, 'Enable Write Testimonial Module', 'MODULE_CONTENT_TESTIMONIALS_WRITE_STATUS', 'True', 'Do you want to enable this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(385, 'Content Container', 'MODULE_CONTENT_TESTIMONIALS_WRITE_CONTENT_WIDTH', 'col-sm-6', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(386, 'Sort Order', 'MODULE_CONTENT_TESTIMONIALS_WRITE_SORT_ORDER', '300', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(387, 'Enable &pi; Modular product_info', 'MODULE_CONTENT_PI_MODULAR_STATUS', 'True', 'Should this module be shown on the product info page?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(388, 'Content Container', 'MODULE_CONTENT_PI_MODULAR_CONTENT_WIDTH', 'col-sm-12', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(389, 'Slot Width: A', 'MODULE_CONTENT_PI_MODULAR_A_WIDTH', 'col-sm-12', 'What width should Slot A be?  Note that Slots in a Row should totalise 12.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(390, 'Slot Width: B', 'MODULE_CONTENT_PI_MODULAR_B_WIDTH', 'col-sm-7', 'What width should Slot B be?  Note that Slots in a Row should totalise 12.', 6, 4, NULL, '[[regtime]]', NULL, NULL),
(391, 'Slot Width: C', 'MODULE_CONTENT_PI_MODULAR_C_WIDTH', 'col-sm-5', 'What width should Slot C be?  Note that Slots in a Row should totalise 12.', 6, 5, NULL, '[[regtime]]', NULL, NULL),
(392, 'Slot Width: D', 'MODULE_CONTENT_PI_MODULAR_D_WIDTH', 'col-sm-6', 'What width should Slot D be?  Note that Slots in a Row should totalise 12.', 6, 6, NULL, '[[regtime]]', NULL, NULL),
(393, 'Slot Width: E', 'MODULE_CONTENT_PI_MODULAR_E_WIDTH', 'col-sm-6', 'What width should Slot E be?  Note that Slots in a Row should totalise 12.', 6, 7, NULL, '[[regtime]]', NULL, NULL),
(394, 'Slot Width: F', 'MODULE_CONTENT_PI_MODULAR_F_WIDTH', 'col-sm-12', 'What width should Slot F be?  Note that Slots in a Row should totalise 12.', 6, 8, NULL, '[[regtime]]', NULL, NULL),
(395, 'Slot Width: G', 'MODULE_CONTENT_PI_MODULAR_G_WIDTH', 'col-sm-6', 'What width should Slot G be?  Note that Slots in a Row should totalise 12.', 6, 9, NULL, '[[regtime]]', NULL, NULL),
(396, 'Slot Width: H', 'MODULE_CONTENT_PI_MODULAR_H_WIDTH', 'col-sm-6', 'What width should Slot H be?  Note that Slots in a Row should totalise 12.', 6, 10, NULL, '[[regtime]]', NULL, NULL),
(397, 'Slot Width: I', 'MODULE_CONTENT_PI_MODULAR_I_WIDTH', 'col-sm-12', 'What width should Slot I be?  Note that Slots in a Row should totalise 12.', 6, 11, NULL, '[[regtime]]', NULL, NULL),
(398, 'Sort Order', 'MODULE_CONTENT_PI_MODULAR_SORT_ORDER', '59', 'Sort order of display. Lowest is displayed first.', 6, 12, NULL, '[[regtime]]', NULL, NULL),
(399, 'Installed Modules', 'MODULE_CUSTOMER_DATA_INSTALLED', 'cd_address_book_id.php;cd_firstname.php;cd_lastname.php;cd_email_address.php;cd_street_address.php;cd_city.php;cd_state.php;cd_postcode.php;cd_country.php;cd_date_account_created.php;cd_default_address_id.php;cd_email_username.php;cd_id.php;cd_password.php;cd_matc.php;cd_name_2.php;cd_password_reset.php;cd_sortable_name_2.php;cd_traditional_address.php;cd_traditional_short_name.php', 'This is automatically updated. No need to edit.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(400, 'Enable Address Book ID module', 'MODULE_CUSTOMER_DATA_ADDRESS_BOOK_ID_STATUS', 'True', 'Do you want to add the module to your shop?', 6, 1, NULL, '[[regtime]]', NULL, NULL),
(401, 'Enable First Name module', 'MODULE_CUSTOMER_DATA_FIRSTNAME_STATUS', 'True', 'Do you want to add the module to your shop?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(402, 'Customer data group', 'MODULE_CUSTOMER_DATA_FIRSTNAME_GROUP', '1', 'In what group should this appear?', 6, 2, NULL, '[[regtime]]', 'customer_data_group::fetch_name', 'Config::select_customer_data_group('),
(403, 'Require First Name', 'MODULE_CUSTOMER_DATA_FIRSTNAME_REQUIRED', 'True', 'Do you want the first name to be required in customer registration?', 6, 3, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(404, 'Minimum Length', 'ENTRY_FIRST_NAME_MIN_LENGTH', '2', 'Minimum length of first name', 6, 4, NULL, '[[regtime]]', NULL, NULL),
(405, 'Pages', 'MODULE_CUSTOMER_DATA_FIRSTNAME_PAGES', 'account_edit;address_book;checkout_new_address;create_account;customers', 'On what pages should this appear?', 6, 5, NULL, '[[regtime]]', 'abstract_module::list_exploded', 'Customers::select_pages('),
(406, 'Sort Order', 'MODULE_CUSTOMER_DATA_FIRSTNAME_SORT_ORDER', '2030', 'Sort order of display. Lowest is displayed first.', 6, 6, NULL, '[[regtime]]', NULL, NULL),
(407, 'Template', 'MODULE_CUSTOMER_DATA_FIRSTNAME_TEMPLATE', 'includes/modules/customer_data/cd_whole_row_input.php', 'What template should be used to surround this input?', 6, 7, NULL, '[[regtime]]', NULL, NULL),
(408, 'Enable Last Name module', 'MODULE_CUSTOMER_DATA_LASTNAME_STATUS', 'True', 'Do you want to add the module to your shop?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(409, 'Customer data group', 'MODULE_CUSTOMER_DATA_LASTNAME_GROUP', '1', 'In what group should this appear?', 6, 2, NULL, '[[regtime]]', 'customer_data_group::fetch_name', 'Config::select_customer_data_group('),
(410, 'Require Last Name module (if enabled)', 'MODULE_CUSTOMER_DATA_LASTNAME_REQUIRED', 'True', 'Do you want the last name to be required in customer registration?', 6, 3, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(411, 'Minimum Length', 'ENTRY_LAST_NAME_MIN_LENGTH', '2', 'Minimum length of last name', 6, 4, NULL, '[[regtime]]', NULL, NULL),
(412, 'Pages', 'MODULE_CUSTOMER_DATA_LASTNAME_PAGES', 'account_edit;address_book;checkout_new_address;create_account;customers', 'On what pages should this appear?', 6, 5, NULL, '[[regtime]]', 'abstract_module::list_exploded', 'Customers::select_pages('),
(413, 'Sort Order', 'MODULE_CUSTOMER_DATA_LASTNAME_SORT_ORDER', '2070', 'Sort order of display. Lowest is displayed first.', 6, 6, NULL, '[[regtime]]', NULL, NULL),
(414, 'Template', 'MODULE_CUSTOMER_DATA_LASTNAME_TEMPLATE', 'includes/modules/customer_data/cd_whole_row_input.php', 'What template should be used to surround this input?', 6, 7, NULL, '[[regtime]]', NULL, NULL),
(415, 'Enable Traditional Short Name module', 'MODULE_CUSTOMER_DATA_TRADITIONAL_SHORT_NAME_STATUS', 'True', 'Do you want to add the module to your shop?', 6, 1, NULL, '[[regtime]]', NULL, NULL),
(416, 'Enable Two Part Name module', 'MODULE_CUSTOMER_DATA_NAME_2_STATUS', 'True', 'Do you want to add the module to your shop?', 6, 1, NULL, '[[regtime]]', NULL, NULL),
(417, 'Enable Street Address module', 'MODULE_CUSTOMER_DATA_STREET_ADDRESS_STATUS', 'True', 'Do you want to add the module to your shop?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(418, 'Customer data group', 'MODULE_CUSTOMER_DATA_STREET_ADDRESS_GROUP', '2', 'In what group should this appear?', 6, 2, NULL, '[[regtime]]', 'customer_data_group::fetch_name', 'Config::select_customer_data_group('),
(419, 'Require Street Address module (if enabled)', 'MODULE_CUSTOMER_DATA_STREET_ADDRESS_REQUIRED', 'True', 'Do you want the street address to be required in customer registration?', 6, 3, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(420, 'Minimum Length', 'MODULE_CUSTOMER_DATA_STREET_ADDRESS_MIN_LENGTH', '3', 'Minimum length of street address', 6, 4, NULL, '[[regtime]]', NULL, NULL),
(421, 'Pages', 'MODULE_CUSTOMER_DATA_STREET_ADDRESS_PAGES', 'address_book;checkout_new_address;create_account;customers', 'On what pages should this appear?', 6, 5, NULL, '[[regtime]]', 'abstract_module::list_exploded', 'Customers::select_pages('),
(422, 'Sort Order', 'MODULE_CUSTOMER_DATA_STREET_ADDRESS_SORT_ORDER', '4200', 'Sort order of display. Lowest is displayed first.', 6, 6, NULL, '[[regtime]]', NULL, NULL),
(423, 'Template', 'MODULE_CUSTOMER_DATA_STREET_ADDRESS_TEMPLATE', 'includes/modules/customer_data/cd_whole_row_input.php', 'What template should be used to surround this input?', 6, 7, NULL, '[[regtime]]', NULL, NULL),
(424, 'Enable City module', 'MODULE_CUSTOMER_DATA_CITY_STATUS', 'True', 'Do you want to add the module to your shop?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(425, 'Customer data group', 'MODULE_CUSTOMER_DATA_CITY_GROUP', '2', 'In what group should this appear?', 6, 2, NULL, '[[regtime]]', 'customer_data_group::fetch_name', 'Config::select_customer_data_group('),
(426, 'Require City module (if enabled)', 'MODULE_CUSTOMER_DATA_CITY_REQUIRED', 'True', 'Do you want the city to be required in customer registration?', 6, 3, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(427, 'Minimum Length', 'MODULE_CUSTOMER_DATA_CITY_MIN_LENGTH', '3', 'Minimum length of city', 6, 4, NULL, '[[regtime]]', NULL, NULL),
(428, 'Pages', 'MODULE_CUSTOMER_DATA_CITY_PAGES', 'address_book;checkout_new_address;create_account;customers', 'On what pages should this appear?', 6, 5, NULL, '[[regtime]]', 'abstract_module::list_exploded', 'Customers::select_pages('),
(429, 'Sort Order', 'MODULE_CUSTOMER_DATA_CITY_SORT_ORDER', '4500', 'Sort order of display. Lowest is displayed first.', 6, 6, NULL, '[[regtime]]', NULL, NULL),
(430, 'Template', 'MODULE_CUSTOMER_DATA_CITY_TEMPLATE', 'includes/modules/customer_data/cd_whole_row_input.php', 'What template should be used to surround this input?', 6, 7, NULL, '[[regtime]]', NULL, NULL),
(431, 'Enable Date Account Created module', 'MODULE_CUSTOMER_DATA_DATE_ACCOUNT_CREATED_STATUS', 'True', 'Do you want to add the module to your shop?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(432, 'Enable Default Address ID module', 'MODULE_CUSTOMER_DATA_DEFAULT_ADDRESS_ID_STATUS', 'True', 'Do you want to add the module to your shop?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(433, 'Enable Two Part Sortable Name module', 'MODULE_CUSTOMER_DATA_SORTABLE_NAME_2_STATUS', 'True', 'Do you want to add the module to your shop?', 6, 1, NULL, '[[regtime]]', NULL, NULL),
(434, 'Enable State module', 'MODULE_CUSTOMER_DATA_STATE_STATUS', 'True', 'Do you want to add the module to your shop?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(435, 'Customer data group', 'MODULE_CUSTOMER_DATA_STATE_GROUP', '2', 'In what group should this appear?', 6, 2, NULL, '[[regtime]]', 'customer_data_group::fetch_name', 'Config::select_customer_data_group('),
(436, 'Require State module (if enabled)', 'MODULE_CUSTOMER_DATA_STATE_REQUIRED', 'True', 'Do you want the state to be required in customer registration?', 6, 3, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(437, 'Minimum Length', 'ENTRY_STATE_MIN_LENGTH', '2', 'Minimum length of state', 6, 4, NULL, '[[regtime]]', NULL, NULL),
(438, 'Pages', 'MODULE_CUSTOMER_DATA_STATE_PAGES', 'address_book;checkout_new_address;create_account;customers', 'On what pages should this appear?', 6, 5, NULL, '[[regtime]]', 'abstract_module::list_exploded', 'Customers::select_pages('),
(439, 'Sort Order', 'MODULE_CUSTOMER_DATA_STATE_SORT_ORDER', '4600', 'Sort order of display. Lowest is displayed first.', 6, 6, NULL, '[[regtime]]', NULL, NULL),
(440, 'Template', 'MODULE_CUSTOMER_DATA_STATE_TEMPLATE', 'includes/modules/customer_data/cd_whole_row_input.php', 'What template should be used to surround this input?', 6, 7, NULL, '[[regtime]]', NULL, NULL),
(441, 'Enable Post Code module', 'MODULE_CUSTOMER_DATA_POST_CODE_STATUS', 'True', 'Do you want to add the module to your shop?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(442, 'Customer data group', 'MODULE_CUSTOMER_DATA_POST_CODE_GROUP', '2', 'In what group should this appear?', 6, 2, NULL, '[[regtime]]', 'customer_data_group::fetch_name', 'Config::select_customer_data_group('),
(443, 'Require Post Code module (if enabled)', 'MODULE_CUSTOMER_DATA_POST_CODE_REQUIRED', 'True', 'Do you want the post code to be required in customer registration?', 6, 3, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(444, 'Minimum Length', 'MODULE_CUSTOMER_DATA_POST_CODE_MIN_LENGTH', '3', 'Minimum length of post code', 6, 4, NULL, '[[regtime]]', NULL, NULL),
(445, 'Pages', 'MODULE_CUSTOMER_DATA_POST_CODE_PAGES', 'address_book;checkout_new_address;create_account;customers', 'On what pages should this appear?', 6, 5, NULL, '[[regtime]]', 'abstract_module::list_exploded', 'Customers::select_pages('),
(446, 'Sort Order', 'MODULE_CUSTOMER_DATA_POST_CODE_SORT_ORDER', '4800', 'Sort order of display. Lowest is displayed first.', 6, 6, NULL, '[[regtime]]', NULL, NULL),
(447, 'Template', 'MODULE_CUSTOMER_DATA_POST_CODE_TEMPLATE', 'includes/modules/customer_data/cd_whole_row_input.php', 'What template should be used to surround this input?', 6, 7, NULL, '[[regtime]]', NULL, NULL),
(448, 'Enable Country module', 'MODULE_CUSTOMER_DATA_COUNTRY_STATUS', 'True', 'Do you want to add the module to your shop?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(449, 'Customer data group', 'MODULE_CUSTOMER_DATA_COUNTRY_GROUP', '2', 'In what group should this appear?', 6, 2, NULL, '[[regtime]]', 'customer_data_group::fetch_name', 'Config::select_customer_data_group('),
(450, 'Require Country module (if enabled)', 'MODULE_CUSTOMER_DATA_COUNTRY_REQUIRED', 'True', 'Do you want the country to be required in customer registration?', 6, 3, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(451, 'Pages', 'MODULE_CUSTOMER_DATA_COUNTRY_PAGES', 'address_book;checkout_new_address;create_account;customers', 'On what pages should this appear?', 6, 4, NULL, '[[regtime]]', 'abstract_module::list_exploded', 'Customers::select_pages('),
(452, 'Sort Order', 'MODULE_CUSTOMER_DATA_COUNTRY_SORT_ORDER', '4900', 'Sort order of display. Lowest is displayed first.', 6, 5, NULL, '[[regtime]]', NULL, NULL),
(453, 'Template', 'MODULE_CUSTOMER_DATA_COUNTRY_TEMPLATE', 'includes/modules/customer_data/cd_whole_row_input.php', 'What template should be used to surround this input?', 6, 6, NULL, '[[regtime]]', NULL, NULL),
(454, 'Enable Email Address module', 'MODULE_CUSTOMER_DATA_EMAIL_ADDRESS_STATUS', 'True', 'Do you want to add the module to your shop?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(455, 'Customer data group', 'MODULE_CUSTOMER_DATA_EMAIL_ADDRESS_GROUP', '1', 'In what group should this appear?', 6, 2, NULL, '[[regtime]]', 'customer_data_group::fetch_name', 'Config::select_customer_data_group(');
INSERT INTO `configuration` VALUES
(456, 'Require Email Address module (if enabled)', 'MODULE_CUSTOMER_DATA_EMAIL_ADDRESS_REQUIRED', 'True', 'Do you want the email address to be required in customer registration?', 6, 3, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(457, 'Minimum Length', 'ENTRY_EMAIL_ADDRESS_MIN_LENGTH', '6', 'Minimum length of email address', 6, 4, NULL, '[[regtime]]', NULL, NULL),
(458, 'Pages', 'MODULE_CUSTOMER_DATA_EMAIL_ADDRESS_PAGES', 'account_edit;create_account;customers', 'On what pages should this appear?', 6, 5, NULL, '[[regtime]]', 'abstract_module::list_exploded', 'Customers::select_pages('),
(459, 'Sort Order', 'MODULE_CUSTOMER_DATA_EMAIL_ADDRESS_SORT_ORDER', '2100', 'Sort order of display. Lowest is displayed first.', 6, 6, NULL, '[[regtime]]', NULL, NULL),
(460, 'Template', 'MODULE_CUSTOMER_DATA_EMAIL_ADDRESS_TEMPLATE', 'includes/modules/customer_data/cd_whole_row_input.php', 'What template should be used to surround this input?', 6, 7, NULL, '[[regtime]]', NULL, NULL),
(461, 'Enable Email Username module', 'MODULE_CUSTOMER_DATA_EMAIL_USERNAME_STATUS', 'True', 'Do you want to add the module to your shop?', 6, 1, NULL, '[[regtime]]', NULL, NULL),
(462, 'Enable Password module', 'MODULE_CUSTOMER_DATA_PASSWORD_STATUS', 'True', 'Do you want to add the module to your shop?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(463, 'Customer data group', 'MODULE_CUSTOMER_DATA_PASSWORD_GROUP', '6', 'In what group should this appear?', 6, 2, NULL, '[[regtime]]', 'customer_data_group::fetch_name', 'Config::select_customer_data_group('),
(464, 'Require Password module (if enabled)', 'MODULE_CUSTOMER_DATA_PASSWORD_REQUIRED', 'True', 'Do you want the password to be required in customer registration?', 6, 3, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(465, 'Minimum Length', 'MODULE_CUSTOMER_DATA_PASSWORD_MIN_LENGTH', '5', 'Minimum length of password', 6, 4, NULL, '[[regtime]]', NULL, NULL),
(466, 'Pages', 'MODULE_CUSTOMER_DATA_PASSWORD_PAGES', 'account_password;create_account;customers', 'On what pages should this appear?', 6, 5, NULL, '[[regtime]]', 'abstract_module::list_exploded', 'Customers::select_pages('),
(467, 'Sort Order', 'MODULE_CUSTOMER_DATA_PASSWORD_SORT_ORDER', '6200', 'Sort order of display. Lowest is displayed first.', 6, 6, NULL, '[[regtime]]', NULL, NULL),
(468, 'Template', 'MODULE_CUSTOMER_DATA_PASSWORD_TEMPLATE', 'includes/modules/customer_data/cd_whole_row_input.php', 'What template should be used to surround this input?', 6, 7, NULL, '[[regtime]]', NULL, NULL),
(469, 'Enable Password Reset module', 'MODULE_CUSTOMER_DATA_PASSWORD_RESET_STATUS', 'True', 'Do you want to add the module to your shop?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(470, 'Enable Identifier module', 'MODULE_CUSTOMER_DATA_ID_STATUS', 'True', 'Do you want to add the module to your shop?', 6, 1, NULL, '[[regtime]]', NULL, NULL),
(471, 'Enable Traditional Address module', 'MODULE_CUSTOMER_DATA_TRADITIONAL_ADDRESS_STATUS', 'True', 'Do you want to add the module to your shop?', 6, 1, NULL, '[[regtime]]', NULL, NULL),
(472, 'Enable MATC Module', 'MODULE_CUSTOMER_DATA_MATC_STATUS', 'True', 'Do you want to add the module to your shop?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(473, 'Customer data group', 'MODULE_CUSTOMER_DATA_MATC_GROUP', '6', 'In what group should this appear?', 6, 2, NULL, '[[regtime]]', 'customer_data_group::fetch_name', 'Config::select_customer_data_group('),
(474, 'Pages', 'MODULE_CUSTOMER_DATA_MATC_PAGES', 'create_account', 'On what pages should this appear?', 6, 3, NULL, '[[regtime]]', 'abstract_module::list_exploded', 'Customers::select_pages('),
(475, 'Checkout Page', 'MODULE_CUSTOMER_DATA_MATC_CHECKOUT', 'False', 'Should the MATC also show on checkout_confirmation?', 6, 4, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(476, 'Sort Order', 'MODULE_CUSTOMER_DATA_MATC_SORT_ORDER', '6800', 'Sort order of display. Lowest is displayed first.', 6, 5, NULL, '[[regtime]]', NULL, NULL),
(477, 'Enable GDPR Link', 'MODULE_CONTENT_ACCOUNT_GDPR_STATUS', 'True', 'Do you want to enable this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(478, 'Countries', 'MODULE_CONTENT_ACCOUNT_GDPR_COUNTRIES', '', 'Restrict the Link to Account Holders in these Countries.  Leave Blank to show link to all Countries!', 6, 2, NULL, '[[regtime]]', 'gdpr_show_countries', 'Config::select_multiple(Country::fetch_options(), '),
(479, 'Sort Order', 'MODULE_CONTENT_ACCOUNT_GDPR_SORT_ORDER', '10', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(480, 'Enable Intro Module', 'MODULE_CONTENT_GDPR_INTRO_STATUS', 'True', 'Should this module be shown on the GDPR page?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(481, 'Content Container', 'MODULE_CONTENT_GDPR_INTRO_CONTENT_WIDTH', 'col-sm-12', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(482, 'Sort Order', 'MODULE_CONTENT_GDPR_INTRO_SORT_ORDER', '50', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(483, 'Enable Personal Details Module', 'MODULE_CONTENT_GDPR_PERSONAL_DETAILS_STATUS', 'True', 'Should this module be shown on the GDPR page?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(484, 'Content Container', 'MODULE_CONTENT_GDPR_PERSONAL_DETAILS_CONTENT_WIDTH', 'col-sm-12', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(485, 'Sort Order', 'MODULE_CONTENT_GDPR_PERSONAL_DETAILS_SORT_ORDER', '100', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(486, 'Enable Title Module', 'MODULE_CONTENT_CAS_TITLE_STATUS', 'True', 'Do you want to enable this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(487, 'Enable Module', 'MODULE_CONTENT_GDPR_ACCEPTANCE_DATA_STATUS', 'True', 'Do you want to enable this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(488, 'Content Container', 'MODULE_CONTENT_GDPR_ACCEPTANCE_DATA_CONTENT_WIDTH', 'col-sm-12', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(489, 'Sort Order', 'MODULE_CONTENT_GDPR_ACCEPTANCE_DATA_SORT_ORDER', '205', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(490, 'Content Container', 'MODULE_CONTENT_CAS_TITLE_CONTENT_WIDTH', 'col-sm-12 mb-4', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(491, 'Sort Order', 'MODULE_CONTENT_CAS_TITLE_SORT_ORDER', '10', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(492, 'Enable Message Module', 'MODULE_CONTENT_CAS_MESSAGE_STATUS', 'True', 'Do you want to enable this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(493, 'Content Container', 'MODULE_CONTENT_CAS_MESSAGE_CONTENT_WIDTH', 'col-sm-12', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(494, 'Sort Order', 'MODULE_CONTENT_CAS_MESSAGE_SORT_ORDER', '20', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(495, 'Enable Button Module', 'MODULE_CONTENT_CAS_CONTINUE_BUTTON_STATUS', 'True', 'Do you want to enable this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(496, 'Content Container', 'MODULE_CONTENT_CAS_CONTINUE_BUTTON_CONTENT_WIDTH', 'col-sm-12', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(497, 'Sort Order', 'MODULE_CONTENT_CAS_CONTINUE_BUTTON_SORT_ORDER', '30', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(498, 'Installed Modules', 'MODULE_NOTIFICATIONS_INSTALLED', 'n_checkout.php;n_create_account.php;n_update_order.php', 'This is automatically updated. No need to edit.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(499, 'Enable Checkout Notification module', 'MODULE_NOTIFICATIONS_CHECKOUT_STATUS', 'True', 'Do you want to add the module to your shop?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(500, 'Enable Account Creation Notification module', 'MODULE_NOTIFICATIONS_CREATE_ACCOUNT_STATUS', 'True', 'Do you want to add the module to your shop?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(501, 'Enable Order Status Update Notification module', 'MODULE_NOTIFICATIONS_UPDATE_ORDER_STATUS', 'True', 'Do you want to add the module to your shop?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(502, 'Installed Modules', 'MODULE_CONTENT_I_INSTALLED', 'i_adverts.php;i_brand_icons.php;i_hero.php', 'List of &pi; Index child modules separated by a semi-colon. This is automatically updated. No need to edit.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(503, 'Enable Adverts Module', 'I_ADVERTS_STATUS', 'True', 'Should this module be shown?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(504, 'Module Display', 'I_ADVERTS_GROUP', 'A', 'Where should this module display on the index page?', 6, 2, NULL, '[[regtime]]', NULL, 'Config::select_one([''A'', ''B'', ''C'', ''D'', ''E'', ''F'', ''G'', ''H'', ''I''], '),
(505, 'Content Container', 'I_ADVERTS_CONTENT_WIDTH', 'col-sm-10 mb-2', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(506, 'Advert Group', 'I_ADVERTS_LINK', 'index', 'Choose which Advert Group this module should display..', 6, 4, NULL, '[[regtime]]', 'adverts::advert_get_group', 'adverts::advert_pull_down_groups('),
(507, 'Sort Order', 'I_ADVERTS_SORT_ORDER', '85', 'Sort order of display. Lowest is displayed first.', 6, 5, NULL, '[[regtime]]', NULL, NULL),
(508, 'Enable Brand Icons Module', 'I_BRAND_ICONS_STATUS', 'True', 'Should this module be shown?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(509, 'Module Display', 'I_BRAND_ICONS_GROUP', 'A', 'Where should this module display on the index page?', 6, 2, NULL, '[[regtime]]', NULL, 'Config::select_one([''A'', ''B'', ''C'', ''D'', ''E'', ''F'', ''G'', ''H'', ''I''], '),
(510, 'Content Container', 'I_BRAND_ICONS_CONTENT_WIDTH', 'col-sm-2 mb-2', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(511, 'Brands', 'I_BRAND_ICONS_CSV', '1;2', 'Choose which Brands this module should display..', 6, 4, NULL, '[[regtime]]', 'i_show_brands', 'i_select_brands('),
(512, 'Chunk', 'I_BRAND_ICONS_XS_CHUNK', '2', 'At SM and below, the display will change to a Carousel.  This number determines how many icons are in each slide.', 6, 5, NULL, '[[regtime]]', NULL, NULL),
(513, 'Sort Order', 'I_BRAND_ICONS_SORT_ORDER', '87', 'Sort order of display. Lowest is displayed first.', 6, 5, NULL, '[[regtime]]', NULL, NULL),
(514, 'Enable Hero Module', 'I_HERO_STATUS', 'True', 'Should this module be shown?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(515, 'Module Display', 'I_HERO_GROUP', 'B', 'Where should this module display on the index page?', 6, 2, NULL, '[[regtime]]', NULL, 'Config::select_one([''A'', ''B'', ''C'', ''D'', ''E'', ''F'', ''G'', ''H'', ''I''], '),
(516, 'Content Container', 'I_HERO_CONTENT_WIDTH', 'col-sm-12', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(517, 'Sort Order', 'I_HERO_SORT_ORDER', '89', 'Sort order of display. Lowest is displayed first.', 6, 4, NULL, '[[regtime]]', NULL, NULL),
(518, 'Installed Modules', 'MODULE_CONTENT_PI_INSTALLED', 'pi_gallery.php;pi_gallery_images.php;pi_img_disclaimer.php;pi_options_attributes.php;pi_date_available.php;pi_qty_input.php;pi_buy_button.php', 'List of &pi; Product Info child modules separated by a semi-colon. This is automatically updated. No need to edit.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(519, 'Enable Buy Button', 'PI_BUY_STATUS', 'True', 'Should this module be shown on the product info page?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(520, 'Module Display', 'PI_BUY_GROUP', 'C', 'Where should this module display on the product info page?', 6, 2, NULL, '[[regtime]]', NULL, 'Config::select_one([''A'', ''B'', ''C'', ''D'', ''E'', ''F'', ''G'', ''H'', ''I''], '),
(521, 'Content Container', 'PI_BUY_CONTENT_WIDTH', 'col-sm-12 mb-2', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(522, 'Sort Order', 'PI_BUY_SORT_ORDER', '320', 'Sort order of display. Lowest is displayed first.', 6, 4, NULL, '[[regtime]]', NULL, NULL),
(523, 'Enable Gallery Module', 'PI_GALLERY_STATUS', 'True', 'Should this module be shown on the product info page?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(524, 'Module Display', 'PI_GALLERY_GROUP', 'B', 'Where should this module display on the product info page?', 6, 2, NULL, '[[regtime]]', NULL, 'Config::select_one([''A'', ''B'', ''C'', ''D'', ''E'', ''F'', ''G'', ''H'', ''I''], '),
(525, 'Content Container', 'PI_GALLERY_CONTENT_WIDTH', 'col-sm-12 mb-2', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(526, 'Modal Popup Size', 'PI_GALLERY_MODAL_SIZE', 'modal-md', 'Choose the size of the Popup.  sm = small, md = medium etc.', 6, 5, NULL, '[[regtime]]', NULL, 'Config::select_one([''modal-sm'', ''modal-md'', ''modal-lg'', ''modal-xl''], '),
(527, 'Show Swipe Arrows', 'PI_GALLERY_SWIPE_ARROWS', 'True', 'Swipe Arrows make for a better User Experience in some cases.', 6, 6, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(528, 'Show Indicators', 'PI_GALLERY_INDICATORS', 'True', 'Indicators allow users to jump from image to image without having to swipe.', 6, 7, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(529, 'Sort Order', 'PI_GALLERY_SORT_ORDER', '200', 'Sort order of display. Lowest is displayed first.', 6, 8, NULL, '[[regtime]]', NULL, NULL),
(530, 'Enable Module', 'PI_GALLERY_IMAGES_STATUS', 'True', 'Do you want to enable this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(531, 'Module Display', 'PI_GALLERY_IMAGES_GROUP', 'B', 'Where should this module display on the product info page?', 6, 2, NULL, '[[regtime]]', NULL, 'Config::select_one([''A'', ''B'', ''C'', ''D'', ''E'', ''F'', ''G'', ''H'', ''I''], '),
(532, 'Content Container', 'PI_GALLERY_IMAGES_CONTENT_WIDTH', 'col-12 mb-2', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(533, 'Content Container', 'PI_GALLERY_IMAGES_CONTENT_WIDTH_EACH', 'col-4 col-sm-6 col-lg-4 mb-1', 'What container should each thumbnail be shown in?', 6, 4, NULL, '[[regtime]]', NULL, NULL),
(534, 'Sort Order', 'PI_GALLERY_IMAGES_SORT_ORDER', '210', 'Sort order of display. Lowest is displayed first.', 6, 5, NULL, '[[regtime]]', NULL, NULL),
(535, 'Enable Image Disclaimer Module', 'PI_IMG_DISCLAIMER_STATUS', 'True', 'Should this module be shown on the product info page?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(536, 'Module Display', 'PI_IMG_DISCLAIMER_GROUP', 'B', 'Where should this module display on the product info page?', 6, 2, NULL, '[[regtime]]', NULL, 'Config::select_one([''A'', ''B'', ''C'', ''D'', ''E'', ''F'', ''G'', ''H'', ''I''], '),
(537, 'Content Container', 'PI_IMG_DISCLAIMER_CONTENT_WIDTH', 'col-sm-12 mb-2', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(538, 'Sort Order', 'PI_IMG_DISCLAIMER_SORT_ORDER', '230', 'Sort order of display. Lowest is displayed first.', 6, 4, NULL, '[[regtime]]', NULL, NULL),
(539, 'Enable Options & Attributes', 'PI_OA_STATUS', 'True', 'Should this module be shown on the product info page?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(540, 'Module Display', 'PI_OA_GROUP', 'C', 'Where should this module display on the product info page?', 6, 2, NULL, '[[regtime]]', NULL, 'Config::select_one([''A'', ''B'', ''C'', ''D'', ''E'', ''F'', ''G'', ''H'', ''I''], '),
(541, 'Content Container', 'PI_OA_CONTENT_WIDTH', 'col-sm-12 mb-2', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(542, 'Add Helper Text', 'PI_OA_HELPER', 'True', 'Should first option in dropdown be Helper Text?', 6, 4, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(543, 'Enforce Selection', 'PI_OA_ENFORCE', 'True', 'Should customer be forced to select option(s)?', 6, 5, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(544, 'Sort Order', 'PI_OA_SORT_ORDER', '310', 'Sort order of display. Lowest is displayed first.', 6, 6, NULL, '[[regtime]]', NULL, NULL),
(545, 'Enable Qty Module', 'PI_QTY_INPUT_STATUS', 'True', 'Should this module be shown in the &pi; layout?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(546, 'Module Display', 'PI_QTY_INPUT_GROUP', 'C', 'Where should this module display on the product info page?', 6, 2, NULL, '[[regtime]]', NULL, 'Config::select_one([''A'', ''B'', ''C'', ''D'', ''E'', ''F'', ''G'', ''H'', ''I''], '),
(547, 'Content Container', 'PI_QTY_INPUT_CONTENT_WIDTH', 'col-sm-12 mb-2', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(548, 'Add Spinner Buttons', 'PI_QTY_INPUT_BUTTONS', 'True', 'Add -/+ buttons onto the number input?', 6, 4, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(549, 'Sort Order', 'PI_QTY_INPUT_SORT_ORDER', '319', 'Sort order of display. Lowest is displayed first.', 6, 5, NULL, '[[regtime]]', NULL, NULL),
(550, 'Enable Module', 'PI_DATE_AVAILABLE_STATUS', 'True', 'Do you want to enable this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(551, 'Module Display', 'PI_DATE_AVAILABLE_GROUP', 'C', 'Where should this module display on the product info page?', 6, 2, NULL, '[[regtime]]', NULL, 'Config::select_one([''A'', ''B'', ''C'', ''D'', ''E'', ''F'', ''G'', ''H'', ''I''], '),
(552, 'Content Container', 'PI_DATE_AVAILABLE_CONTENT_WIDTH', 'col-sm-12 mb-2', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(553, 'Date Style', 'PI_DATE_AVAILABLE_STYLE', 'Long', 'How should the date look?', 6, 4, NULL, '[[regtime]]', NULL, 'Config::select_one([''Long'', ''Short''], '),
(554, 'Sort Order', 'PI_DATE_AVAILABLE_SORT_ORDER', '315', 'Sort order of display. Lowest is displayed first.', 6, 5, NULL, '[[regtime]]', NULL, NULL),
(555, 'Enable Title Module', 'MODULE_CONTENT_INFO_TITLE_STATUS', 'True', 'Should this module be shown?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(556, 'Content Container', 'MODULE_CONTENT_INFO_TITLE_CONTENT_WIDTH', 'col-12 mb-4', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(557, 'Sort Order', 'MODULE_CONTENT_INFO_TITLE_SORT_ORDER', '10', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(558, 'Enable Text Module', 'MODULE_CONTENT_INFO_TEXT_STATUS', 'True', 'Should this module be shown?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(559, 'Content Container', 'MODULE_CONTENT_INFO_TEXT_CONTENT_WIDTH', 'col-12', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(560, 'Sort Order', 'MODULE_CONTENT_INFO_TEXT_SORT_ORDER', '20', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(561, 'Enable Title Module', 'MODULE_CONTENT_CU_TITLE_STATUS', 'True', 'Should this module be shown?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(562, 'Content Container', 'MODULE_CONTENT_CU_TITLE_CONTENT_WIDTH', 'col-12 mb-4', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(563, 'Sort Order', 'MODULE_CONTENT_CU_TITLE_SORT_ORDER', '10', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(564, 'Installed Modules', 'MODULE_CONTENT_CU_INSTALLED', 'cu_form.php', 'This is automatically updated. No need to edit.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(565, 'Enable &pi; Modular contact_us', 'MODULE_CONTENT_CU_MODULAR_STATUS', 'True', 'Should this module be shown?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(566, 'Content Container', 'MODULE_CONTENT_CU_MODULAR_CONTENT_WIDTH', 'col-sm-12', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(567, 'Slot Width: A', 'MODULE_CONTENT_CU_MODULAR_A_WIDTH', 'col-sm-12', 'What width should Slot A be?  Note that Slots in a Row should totalise 12.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(568, 'Slot Width: B', 'MODULE_CONTENT_CU_MODULAR_B_WIDTH', 'col-sm-4', 'What width should Slot B be?  Note that Slots in a Row should totalise 12.', 6, 4, NULL, '[[regtime]]', NULL, NULL),
(569, 'Slot Width: C', 'MODULE_CONTENT_CU_MODULAR_C_WIDTH', 'col-sm-4', 'What width should Slot C be?  Note that Slots in a Row should totalise 12.', 6, 5, NULL, '[[regtime]]', NULL, NULL),
(570, 'Slot Width: D', 'MODULE_CONTENT_CU_MODULAR_D_WIDTH', 'col-sm-4', 'What width should Slot D be?  Note that Slots in a Row should totalise 12.', 6, 6, NULL, '[[regtime]]', NULL, NULL),
(571, 'Slot Width: E', 'MODULE_CONTENT_CU_MODULAR_E_WIDTH', 'col-sm-4', 'What width should Slot E be?  Note that Slots in a Row should totalise 12.', 6, 7, NULL, '[[regtime]]', NULL, NULL),
(572, 'Slot Width: F', 'MODULE_CONTENT_CU_MODULAR_F_WIDTH', 'col-sm-4', 'What width should Slot F be?  Note that Slots in a Row should totalise 12.', 6, 8, NULL, '[[regtime]]', NULL, NULL),
(573, 'Slot Width: G', 'MODULE_CONTENT_CU_MODULAR_G_WIDTH', 'col-sm-4', 'What width should Slot G be?  Note that Slots in a Row should totalise 12.', 6, 9, NULL, '[[regtime]]', NULL, NULL),
(574, 'Slot Width: H', 'MODULE_CONTENT_CU_MODULAR_H_WIDTH', 'col-sm-12', 'What width should Slot H be?  Note that Slots in a Row should totalise 12.', 6, 10, NULL, '[[regtime]]', NULL, NULL),
(575, 'Slot Width: I', 'MODULE_CONTENT_CU_MODULAR_I_WIDTH', 'col-sm-12', 'What width should Slot I be?  Note that Slots in a Row should totalise 12.', 6, 11, NULL, '[[regtime]]', NULL, NULL),
(576, 'Sort Order', 'MODULE_CONTENT_CU_MODULAR_SORT_ORDER', '110', 'Sort order of display. Lowest is displayed first.', 6, 12, NULL, '[[regtime]]', NULL, NULL),
(577, 'Installed Modules', 'MODULE_LAYOUT_INSTALLED', '', 'This is automatically updated. No need to edit.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(578, 'Enable Form', 'CU_FORM_STATUS', 'True', 'Should this module be shown?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(579, 'Module Display', 'CU_FORM_GROUP', 'A', 'Where should this module display?', 6, 2, NULL, '[[regtime]]', NULL, 'Config::select_one([''A'', ''B'', ''C'', ''D'', ''E'', ''F'', ''G'', ''H'', ''I''], '),
(580, 'Content Container', 'CU_FORM_CONTENT_WIDTH', 'col-12 mb-3', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(581, 'Sort Order', 'CU_FORM_SORT_ORDER', '115', 'Sort order of display. Lowest is displayed first.', 6, 4, NULL, '[[regtime]]', NULL, NULL),
(582, 'Enable Module', 'MODULE_CONTENT_GDPR_CONTACT_ADDRESSES_STATUS', 'True', 'Do you want to enable this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(583, 'Content Container', 'MODULE_CONTENT_GDPR_CONTACT_ADDRESSES_CONTENT_WIDTH', 'col-sm-12', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(584, 'Sort Order', 'MODULE_CONTENT_GDPR_CONTACT_ADDRESSES_SORT_ORDER', '150', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(585, 'Enable Module', 'MODULE_CONTENT_GDPR_CONTACT_DETAILS_STATUS', 'True', 'Do you want to enable this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(586, 'Content Container', 'MODULE_CONTENT_GDPR_CONTACT_DETAILS_CONTENT_WIDTH', 'col-sm-12', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(587, 'Sort Order', 'MODULE_CONTENT_GDPR_CONTACT_DETAILS_SORT_ORDER', '125', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(588, 'Enable Module', 'MODULE_CONTENT_GDPR_SITE_ACTIONS_STATUS', 'True', 'Do you want to enable this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(589, 'Content Container', 'MODULE_CONTENT_GDPR_SITE_ACTIONS_CONTENT_WIDTH', 'col-sm-12', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(590, 'Sort Order', 'MODULE_CONTENT_GDPR_SITE_ACTIONS_SORT_ORDER', '225', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(591, 'Enable Module', 'MODULE_CONTENT_GDPR_SITE_DETAILS_STATUS', 'True', 'Do you want to enable this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(592, 'Content Container', 'MODULE_CONTENT_GDPR_SITE_DETAILS_CONTENT_WIDTH', 'col-sm-12', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(593, 'Sort Order', 'MODULE_CONTENT_GDPR_SITE_DETAILS_SORT_ORDER', '200', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(594, 'Enable Cart Contents Module', 'MODULE_CONTENT_GDPR_CART_STATUS', 'True', 'Should this module be shown on the GDPR page?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(595, 'Content Container', 'MODULE_CONTENT_GDPR_CART_CONTENT_WIDTH', 'col-sm-12', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(596, 'Sort Order', 'MODULE_CONTENT_GDPR_CART_SORT_ORDER', '800', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(597, 'Enable Cookies Module', 'MODULE_CONTENT_GDPR_COOKIES_STATUS', 'True', 'Should this module be shown on the GDPR page?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(598, 'Content Container', 'MODULE_CONTENT_GDPR_COOKIES_CONTENT_WIDTH', 'col-sm-12', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(599, 'Sort Order', 'MODULE_CONTENT_GDPR_COOKIES_SORT_ORDER', '700', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(600, 'Enable IP Address Module', 'MODULE_CONTENT_GDPR_IP_STATUS', 'True', 'Should this module be shown on the GDPR page?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(601, 'Content Container', 'MODULE_CONTENT_GDPR_IP_CONTENT_WIDTH', 'col-sm-12', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(602, 'Sort Order', 'MODULE_CONTENT_GDPR_IP_SORT_ORDER', '700', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(603, 'Enable Notifications Module', 'MODULE_CONTENT_GDPR_NOTIFICATIONS_STATUS', 'True', 'Should this module be shown on the GDPR page?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(604, 'Content Container', 'MODULE_CONTENT_GDPR_NOTIFICATIONS_CONTENT_WIDTH', 'col-sm-12', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(605, 'Sort Order', 'MODULE_CONTENT_GDPR_NOTIFICATIONS_SORT_ORDER', '750', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(606, 'Enable Orders Module', 'MODULE_CONTENT_GDPR_ORDERS_STATUS', 'True', 'Should this module be shown on the GDPR page?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(607, 'Content Container', 'MODULE_CONTENT_GDPR_ORDERS_CONTENT_WIDTH', 'col-sm-12', 'What width container should the content be shown in?', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(608, 'Sort Order', 'MODULE_CONTENT_GDPR_ORDERS_SORT_ORDER', '450', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(609, 'Enable Port Data (to JSON) Module', 'MODULE_CONTENT_GDPR_PORT_MY_DATA_STATUS', 'True', 'Should this module be shown on the GDPR page?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(610, 'Content Container', 'MODULE_CONTENT_GDPR_PORT_MY_DATA_CONTENT_WIDTH', 'col-sm-12', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(611, 'Sort Order', 'MODULE_CONTENT_GDPR_PORT_MY_DATA_SORT_ORDER', '5000', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(612, 'Enable Reviews Module', 'MODULE_CONTENT_GDPR_REVIEWS_STATUS', 'True', 'Should this module be shown on the GDPR page?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(613, 'Content Container', 'MODULE_CONTENT_GDPR_REVIEWS_CONTENT_WIDTH', 'col-sm-12', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(614, 'Sort Order', 'MODULE_CONTENT_GDPR_REVIEWS_SORT_ORDER', '550', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(615, 'Enable Testimonials Module', 'MODULE_CONTENT_GDPR_TESTIMONIALS_STATUS', 'True', 'Should this module be shown on the GDPR page?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(616, 'Content Container', 'MODULE_CONTENT_GDPR_TESTIMONIALS_CONTENT_WIDTH', 'col-sm-12', 'What container should the content be shown in? (col-*-12 = full width, col-*-6 = half width).', 6, 2, NULL, '[[regtime]]', NULL, NULL),
(617, 'Sort Order', 'MODULE_CONTENT_GDPR_TESTIMONIALS_SORT_ORDER', '555', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(618, 'Enable Nuke Account Module', 'MODULE_CONTENT_ACCOUNT_GDPR_NUKE_STATUS', 'True', 'Do you want to enable this module?', 6, 1, NULL, '[[regtime]]', NULL, 'Config::select_one([''True'', ''False''], '),
(619, 'Countries', 'MODULE_CONTENT_ACCOUNT_GDPR_NUKE_COUNTRIES', '', 'Restrict the Link to Account Holders in these Countries.  Leave Blank to show link to all Countries!', 6, 2, NULL, '[[regtime]]', 'cm_account_gdpr_nuke::show_countries', 'Config::select_multiple(Country::fetch_options(), '),
(620, 'Sort Order', 'MODULE_CONTENT_ACCOUNT_GDPR_NUKE_SORT_ORDER', '50', 'Sort order of display. Lowest is displayed first.', 6, 3, NULL, '[[regtime]]', NULL, NULL),
(621, 'Installed Modules', 'MODULE_CONTENT_INFO_INSTALLED', '', 'List of &pi; Info Pages child modules separated by a semi-colon. This is automatically updated. No need to edit.', 6, 0, NULL, '[[regtime]]', NULL, NULL),
(622, 'Bootstrap Theme', 'BOOTSTRAP_THEME', 'auto', 'What theme (colour mode) should your site default to? See <a target="_blank" rel="noreferrer" href="https://getbootstrap.com/docs/5.3/customize/color-modes/"><u>/customize/color-modes/</u></a>.  <div class="alert alert-danger">This is an option for Bootstrap 5 only.</div>', 16, 3, NULL, '[[regtime]]', NULL, 'Config::select_one([''dark'', ''light'', ''auto''], ');

-- --------------------------------------------------------

--
-- Table structure for table `configuration_group`
--

CREATE TABLE `configuration_group` (
  `configuration_group_id` int(11) NOT NULL AUTO_INCREMENT,
  `configuration_group_title` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `configuration_group_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `configuration_group_help_link` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `configuration_group_addons_links` text COLLATE utf8mb4_unicode_ci,
  `sort_order` int(5) DEFAULT NULL,
  `visible` int(1) DEFAULT '1',
  PRIMARY KEY (`configuration_group_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=17 ;

--
-- Dumping data for table `configuration_group`
--

INSERT INTO `configuration_group` VALUES
(1, 'My Store', 'General information about my store', 'https://phoenixcart.org/phoenixcartwiki/index.php?title=My_Store', '{"ADDONS_FREE":"https://phoenixcart.org/forum/app.php/addons/free/templates-28","ADDONS_COMMERCIAL":"https://phoenixcart.org/forum/app.php/addons/commercial/templates-31","ADDONS_PRO":"https://phoenixcart.org/forum/app.php/addons/supporters/templates-47"}', 1, 1),
(3, 'Maximum Values', 'The maximum values for functions / data', 'https://phoenixcart.org/phoenixcartwiki/index.php?title=Maximum_Values', '', 3, 1),
(4, 'Images', 'Image parameters', 'https://phoenixcart.org/phoenixcartwiki/index.php?title=Images', '', 4, 1),
(6, 'Module Options', 'Hidden from configuration', 'https://phoenixcart.org/phoenixcartwiki/index.php', '', 6, 0),
(7, 'Shipping/Packaging', 'Shipping options available at my store', 'https://phoenixcart.org/phoenixcartwiki/index.php?title=Shipping/Packaging', '', 7, 1),
(8, 'Product Listing', 'Product Listing configuration options', 'https://phoenixcart.org/phoenixcartwiki/index.php?title=Product_Listing', '', 8, 1),
(9, 'Stock', 'Stock configuration options', 'https://phoenixcart.org/phoenixcartwiki/index.php?title=Stock', '', 9, 1),
(10, 'Logging', 'Logging configuration options', 'https://phoenixcart.org/phoenixcartwiki/index.php?title=Logging', '', 10, 1),
(11, 'Cache', 'Caching configuration options', 'https://phoenixcart.org/phoenixcartwiki/index.php?title=Cache', '', 11, 0),
(12, 'E-Mail Options', 'General setting for E-Mail transport and HTML E-Mails', 'https://phoenixcart.org/phoenixcartwiki/index.php?title=E-Mail_Options', '', 12, 1),
(13, 'Download', 'Downloadable products options', 'https://phoenixcart.org/phoenixcartwiki/index.php?title=Download', '', 13, 1),
(14, 'GZip Compression', 'GZip compression options', 'https://phoenixcart.org/phoenixcartwiki/index.php?title=GZip_Compression', '', 14, 1),
(15, 'Sessions', 'Session options', 'https://phoenixcart.org/phoenixcartwiki/index.php?title=Sessions', '', 15, 1),
(16, 'Bootstrap Setup', 'Basic Bootstrap Options', 'https://phoenixcart.org/phoenixcartwiki/index.php?title=Bootstrap_Setup', '', 16, 1);

-- --------------------------------------------------------

--
-- Table structure for table `countries`
--

CREATE TABLE `countries` (
  `countries_id` int(11) NOT NULL AUTO_INCREMENT,
  `countries_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `countries_iso_code_2` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `countries_iso_code_3` char(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address_format_id` int(11) NOT NULL,
  `status` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`countries_id`),
  KEY `IDX_COUNTRIES_NAME` (`countries_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=253 ;

--
-- Dumping data for table `countries`
--

INSERT INTO `countries` VALUES
(1, 'Afghanestan', 'AF', 'AFG', 1, 1),
(2, 'Shqipëria', 'AL', 'ALB', 1, 1),
(3, 'Dzayer', 'DZ', 'DZA', 1, 1),
(4, 'American Samoa', 'AS', 'ASM', 1, 1),
(5, 'Andorra', 'AD', 'AND', 1, 1),
(6, 'Angola', 'AO', 'AGO', 1, 1),
(7, 'Anguilla', 'AI', 'AIA', 1, 1),
(8, 'Antarctica', 'AQ', 'ATA', 1, 1),
(9, 'Antigua and Barbuda', 'AG', 'ATG', 1, 1),
(10, 'Argentina', 'AR', 'ARG', 1, 1),
(11, 'Hayastán', 'AM', 'ARM', 1, 1),
(12, 'Aruba', 'AW', 'ABW', 1, 1),
(13, 'Australia', 'AU', 'AUS', 1, 1),
(14, 'Österreich', 'AT', 'AUT', 5, 1),
(15, 'Azərbaycan', 'AZ', 'AZE', 1, 1),
(16, 'Bahamas', 'BS', 'BHS', 1, 1),
(17, 'Al-Bahrayn', 'BH', 'BHR', 1, 1),
(18, 'Bangladesh', 'BD', 'BGD', 1, 1),
(19, 'Barbados', 'BB', 'BRB', 1, 1),
(20, 'Bielaruś', 'BY', 'BLR', 1, 1),
(21, 'België', 'BE', 'BEL', 1, 1),
(22, 'Belize', 'BZ', 'BLZ', 1, 1),
(23, 'Bénin', 'BJ', 'BEN', 1, 1),
(24, 'Bermuda', 'BM', 'BMU', 1, 1),
(25, 'Druk Yul', 'BT', 'BTN', 1, 1),
(26, 'Bolivia', 'BO', 'BOL', 1, 1),
(27, 'Bosnia I Hercegovína', 'BA', 'BIH', 1, 1),
(28, 'Botswana', 'BW', 'BWA', 1, 1),
(29, 'Bouvet Island', 'BV', 'BVT', 1, 1),
(30, 'Brasil', 'BR', 'BRA', 1, 1),
(31, 'British Indian Ocean Territory', 'IO', 'IOT', 1, 1),
(32, 'Brunei Darussalam', 'BN', 'BRN', 1, 1),
(33, 'Bulgariya', 'BG', 'BGR', 1, 1),
(34, 'Burkina Faso', 'BF', 'BFA', 1, 1),
(35, 'Burundi', 'BI', 'BDI', 1, 1),
(36, 'Kampuchea', 'KH', 'KHM', 1, 1),
(37, 'Cameroon', 'CM', 'CMR', 1, 1),
(38, 'Canada', 'CA', 'CAN', 1, 1),
(39, 'Cabo Verde', 'CV', 'CPV', 1, 1),
(40, 'Cayman Islands', 'KY', 'CYM', 1, 1),
(41, 'République Centrafricaine', 'CF', 'CAF', 1, 1),
(42, 'Tchad', 'TD', 'TCD', 1, 1),
(43, 'Chile', 'CL', 'CHL', 1, 1),
(44, 'Zhōngguó', 'CN', 'CHN', 1, 1),
(45, 'Christmas Island', 'CX', 'CXR', 1, 1),
(46, 'Cocos (Keeling) Islands', 'CC', 'CCK', 1, 1),
(47, 'Colombia', 'CO', 'COL', 1, 1),
(48, 'Comoros', 'KM', 'COM', 1, 1),
(49, 'République du Congo', 'CG', 'COG', 1, 1),
(50, 'Cook Islands', 'CK', 'COK', 1, 1),
(51, 'Costa Rica', 'CR', 'CRI', 1, 1),
(52, 'Côte d''Ivoire', 'CI', 'CIV', 1, 1),
(53, 'Hrvatska', 'HR', 'HRV', 1, 1),
(54, 'Cuba', 'CU', 'CUB', 1, 1),
(55, 'Κύπρος', 'CY', 'CYP', 1, 1),
(56, 'Česko', 'CZ', 'CZE', 1, 1),
(57, 'Danmark', 'DK', 'DNK', 1, 1),
(58, 'Djibouti', 'DJ', 'DJI', 1, 1),
(59, 'Dominica', 'DM', 'DMA', 1, 1),
(60, 'República Dominicana', 'DO', 'DOM', 1, 1),
(61, 'Timor-Lester', 'TL', 'TLS', 1, 1),
(62, 'Ecuador', 'EC', 'ECU', 1, 1),
(63, 'Misr', 'EG', 'EGY', 1, 1),
(64, 'El Salvador', 'SV', 'SLV', 1, 1),
(65, 'Guinea Ecuatorial', 'GQ', 'GNQ', 1, 1),
(66, 'Iritriya', 'ER', 'ERI', 1, 1),
(67, 'Eesti', 'EE', 'EST', 1, 1),
(68, 'Ityop''ia', 'ET', 'ETH', 1, 1),
(69, 'Falkland Islands (Malvinas)', 'FK', 'FLK', 1, 1),
(70, 'Faroe Islands', 'FO', 'FRO', 1, 1),
(71, 'Fiji', 'FJ', 'FJI', 1, 1),
(72, 'Suomi', 'FI', 'FIN', 1, 1),
(73, 'France', 'FR', 'FRA', 1, 1),
(75, 'Guyanne française', 'GF', 'GUF', 1, 1),
(76, 'Polynésie française', 'PF', 'PYF', 1, 1),
(77, 'Terres australes et antarctiques françaises', 'TF', 'ATF', 1, 1),
(78, 'République gabonaise', 'GA', 'GAB', 1, 1),
(79, 'Gambia', 'GM', 'GMB', 1, 1),
(80, 'Sak''art''velo', 'GE', 'GEO', 1, 1),
(81, 'Deutschland', 'DE', 'DEU', 5, 1),
(82, 'Ghana', 'GH', 'GHA', 1, 1),
(83, 'Gibraltar', 'GI', 'GIB', 1, 1),
(84, 'Ελλάς', 'GR', 'GRC', 1, 1),
(85, 'Greenland', 'GL', 'GRL', 1, 1),
(86, 'Grenada', 'GD', 'GRD', 1, 1),
(87, 'Guadeloupe', 'GP', 'GLP', 1, 1),
(88, 'Guam', 'GU', 'GUM', 1, 1),
(89, 'Guatemala', 'GT', 'GTM', 1, 1),
(90, 'Guinée', 'GN', 'GIN', 1, 1),
(91, 'Guiné-Bissau', 'GW', 'GNB', 1, 1),
(92, 'Guyana', 'GY', 'GUY', 1, 1),
(93, 'Haïti', 'HT', 'HTI', 1, 1),
(94, 'Heard and Mc Donald Islands', 'HM', 'HMD', 1, 1),
(95, 'Honduras', 'HN', 'HND', 1, 1),
(96, 'Hong Kong', 'HK', 'HKG', 1, 1),
(97, 'Magyarország', 'HU', 'HUN', 1, 1),
(98, 'Ísland', 'IS', 'ISL', 1, 1),
(99, 'India', 'IN', 'IND', 1, 1),
(100, 'Indonesia', 'ID', 'IDN', 1, 1),
(101, 'Īrān (Islamic Republic of)', 'IR', 'IRN', 1, 1),
(102, 'Al-''Iraq', 'IQ', 'IRQ', 1, 1),
(103, 'Éire', 'IE', 'IRL', 1, 1),
(104, 'Yisrā''el', 'IL', 'ISR', 1, 1),
(105, 'Italia', 'IT', 'ITA', 1, 1),
(106, 'Jamaica', 'JM', 'JAM', 1, 1),
(107, 'Nippon', 'JP', 'JPN', 1, 1),
(108, 'Al-''Urdun', 'JO', 'JOR', 1, 1),
(109, 'Qazaqstan Қазақстан', 'KZ', 'KAZ', 1, 1),
(110, 'Kenya', 'KE', 'KEN', 1, 1),
(111, 'Tungaru', 'KI', 'KIR', 1, 1),
(112, 'Chosŏn', 'KP', 'PRK', 1, 1),
(113, 'Hanguk', 'KR', 'KOR', 1, 1),
(114, 'Dawlat ul-Kuwayt', 'KW', 'KWT', 1, 1),
(115, 'Kyrgyzstan Кыргызстан', 'KG', 'KGZ', 1, 1),
(116, 'Lao', 'LA', 'LAO', 1, 1),
(117, 'Latvija', 'LV', 'LVA', 1, 1),
(118, 'Lubnān', 'LB', 'LBN', 1, 1),
(119, 'Lesotho', 'LS', 'LSO', 1, 1),
(120, 'Liberia', 'LR', 'LBR', 1, 1),
(121, 'Libya', 'LY', 'LBY', 1, 1),
(122, 'Liechtenstein', 'LI', 'LIE', 1, 1),
(123, 'Lietuva', 'LT', 'LTU', 1, 1),
(124, 'Luxembourg', 'LU', 'LUX', 1, 1),
(125, 'Macau', 'MO', 'MAC', 1, 1),
(126, 'North Macedonia', 'MK', 'MKD', 1, 1),
(127, 'Madagascar', 'MG', 'MDG', 1, 1),
(128, 'Malawi', 'MW', 'MWI', 1, 1),
(129, 'Malaysia', 'MY', 'MYS', 1, 1),
(130, 'Dhivehi Raajje', 'MV', 'MDV', 1, 1),
(131, 'Mali', 'ML', 'MLI', 1, 1),
(132, 'Malta', 'MT', 'MLT', 1, 1),
(133, 'Marshall Islands', 'MH', 'MHL', 1, 1),
(134, 'Martinique', 'MQ', 'MTQ', 1, 1),
(135, 'Muritan', 'MR', 'MRT', 1, 1),
(136, 'Mauritius', 'MU', 'MUS', 1, 1),
(137, 'Mayotte', 'YT', 'MYT', 1, 1),
(138, 'México', 'MX', 'MEX', 1, 1),
(139, 'Micronesia, Federated States of', 'FM', 'FSM', 1, 1),
(140, 'Moldova', 'MD', 'MDA', 1, 1),
(141, 'Monaca', 'MC', 'MCO', 1, 1),
(142, 'Mongol Uls Монгол Улс', 'MN', 'MNG', 1, 1),
(143, 'Montserrat', 'MS', 'MSR', 1, 1),
(144, 'Al-maɣréb', 'MA', 'MAR', 1, 1),
(145, 'Moçambique', 'MZ', 'MOZ', 1, 1),
(146, 'Myanma', 'MM', 'MMR', 1, 1),
(147, 'Namibia', 'NA', 'NAM', 1, 1),
(148, 'Naoero', 'NR', 'NRU', 1, 1),
(149, 'Nepāl', 'NP', 'NPL', 1, 1),
(150, 'Nederland', 'NL', 'NLD', 1, 1),
(151, 'Netherlands Antilles', 'AN', 'ANT', 1, 1),
(152, 'Nouvelle-Calédonie', 'NC', 'NCL', 1, 1),
(153, 'New Zealand', 'NZ', 'NZL', 1, 1),
(154, 'Nicaragua', 'NI', 'NIC', 1, 1),
(155, 'Niger', 'NE', 'NER', 1, 1),
(156, 'Nigeria', 'NG', 'NGA', 1, 1),
(157, 'Niue', 'NU', 'NIU', 1, 1),
(158, 'Norfolk Island', 'NF', 'NFK', 1, 1),
(159, 'Northern Mariana Islands', 'MP', 'MNP', 1, 1),
(160, 'Norge', 'NO', 'NOR', 1, 1),
(161, '''Umān', 'OM', 'OMN', 1, 1),
(162, 'Pākistān', 'PK', 'PAK', 1, 1),
(163, 'Palau', 'PW', 'PLW', 1, 1),
(164, 'Panamá', 'PA', 'PAN', 1, 1),
(165, 'Papua New Guinea', 'PG', 'PNG', 1, 1),
(166, 'Paraguay', 'PY', 'PRY', 1, 1),
(167, 'Perú', 'PE', 'PER', 1, 1),
(168, 'Philippines', 'PH', 'PHL', 1, 1),
(169, 'Pitcairn', 'PN', 'PCN', 1, 1),
(170, 'Polska', 'PL', 'POL', 1, 1),
(171, 'Portugal', 'PT', 'PRT', 1, 1),
(172, 'Puerto Rico', 'PR', 'PRI', 1, 1),
(173, 'Qaṭar', 'QA', 'QAT', 1, 1),
(174, 'Reunion', 'RE', 'REU', 1, 1),
(175, 'România', 'RO', 'ROM', 1, 1),
(176, 'Россия', 'RU', 'RUS', 1, 1),
(177, 'Rwanda', 'RW', 'RWA', 1, 1),
(178, 'Saint Kitts and Nevis', 'KN', 'KNA', 1, 1),
(179, 'Saint Lucia', 'LC', 'LCA', 1, 1),
(180, 'Saint Vincent and the Grenadines', 'VC', 'VCT', 1, 1),
(181, 'Samoa', 'WS', 'WSM', 1, 1),
(182, 'San Marino', 'SM', 'SMR', 1, 1),
(183, 'São Tomé e Principe', 'ST', 'STP', 1, 1),
(184, 'Al-''Arabiyyah as Sa''ūdiyyah', 'SA', 'SAU', 1, 1),
(185, 'Sénégal', 'SN', 'SEN', 1, 1),
(186, 'Seychelles', 'SC', 'SYC', 1, 1),
(187, 'Sierra Leone', 'SL', 'SLE', 1, 1),
(188, 'Singapore', 'SG', 'SGP', 4, 1),
(189, 'Slovensko', 'SK', 'SVK', 1, 1),
(190, 'Slovenija', 'SI', 'SVN', 1, 1),
(191, 'Solomon Islands', 'SB', 'SLB', 1, 1),
(192, 'Soomaaliya aş-Şūmāl', 'SO', 'SOM', 1, 1),
(193, 'South Africa', 'ZA', 'ZAF', 1, 1),
(194, 'South Georgia and the South Sandwich Islands', 'GS', 'SGS', 1, 1),
(195, 'España', 'ES', 'ESP', 3, 1),
(196, 'Sri Lankā', 'LK', 'LKA', 1, 1),
(197, 'St. Helena', 'SH', 'SHN', 1, 1),
(198, 'St. Pierre and Miquelon', 'PM', 'SPM', 1, 1),
(199, 'As-Sudan', 'SD', 'SDN', 1, 1),
(200, 'Surinam', 'SR', 'SUR', 1, 1),
(201, 'Svalbard and Jan Mayen Islands', 'SJ', 'SJM', 1, 1),
(202, 'eSwatini', 'SZ', 'SWZ', 1, 1),
(203, 'Sverige', 'SE', 'SWE', 1, 1),
(204, 'Switzerland', 'CH', 'CHE', 1, 1),
(205, 'Suriyah', 'SY', 'SYR', 1, 1),
(206, 'Taiwan', 'TW', 'TWN', 1, 1),
(207, 'Tojikistan', 'TJ', 'TJK', 1, 1),
(208, 'Tanzania, United Republic of', 'TZ', 'TZA', 1, 1),
(209, 'Prathet Thai', 'TH', 'THA', 1, 1),
(210, 'Togo', 'TG', 'TGO', 1, 1),
(211, 'Tokelau', 'TK', 'TKL', 1, 1),
(212, 'Tonga', 'TO', 'TON', 1, 1),
(213, 'Trinidad and Tobago', 'TT', 'TTO', 1, 1),
(214, 'Tunes', 'TN', 'TUN', 1, 1),
(215, 'Türkiye', 'TR', 'TUR', 1, 1),
(216, 'Türkmenistan', 'TM', 'TKM', 1, 1),
(217, 'Turks and Caicos Islands', 'TC', 'TCA', 1, 1),
(218, 'Tuvalu', 'TV', 'TUV', 1, 1),
(219, 'Uganda', 'UG', 'UGA', 1, 1),
(220, 'Ukraїna', 'UA', 'UKR', 1, 1),
(221, 'Al-''Imārat Al-''Arabiyyah Al-Muttaḥidah', 'AE', 'ARE', 1, 1),
(222, 'United Kingdom', 'GB', 'GBR', 1, 1),
(223, 'United States', 'US', 'USA', 2, 1),
(224, 'United States Minor Outlying Islands', 'UM', 'UMI', 1, 1),
(225, 'Uruguay', 'UY', 'URY', 1, 1),
(226, 'O''zbekiston', 'UZ', 'UZB', 1, 1),
(227, 'Vanuatu', 'VU', 'VUT', 1, 1),
(228, 'Città del Vaticano', 'VA', 'VAT', 1, 1),
(229, 'Venezuela', 'VE', 'VEN', 1, 1),
(230, 'Việt Nam', 'VN', 'VNM', 1, 1),
(231, 'Virgin Islands (British)', 'VG', 'VGB', 1, 1),
(232, 'Virgin Islands (U.S.)', 'VI', 'VIR', 1, 1),
(233, 'Wallis and Futuna Islands', 'WF', 'WLF', 1, 1),
(234, 'Western Sahara', 'EH', 'ESH', 1, 1),
(235, 'Al-Yaman', 'YE', 'YEM', 1, 1),
(236, 'Srbija', 'RS', 'SRB', 1, 1),
(237, 'République démocratique du Congo', 'CD', 'COD', 1, 1),
(238, 'Zambia', 'ZM', 'ZMB', 1, 1),
(239, 'Zimbabwe', 'ZW', 'ZWE', 1, 1),
(240, 'Åland Islands', 'AX', 'ALA', 1, 1),
(241, 'Bonaire, Sint Eustatius and Saba', 'BQ', 'BES', 1, 1),
(242, 'Curaçao', 'CW', 'CUW', 1, 1),
(243, 'Crna Gora', 'ME', 'MNE', 1, 1),
(244, 'Filasṭīn', 'PS', 'PSE', 1, 1),
(245, 'Saint Barthélemy', 'BL', 'BLM', 1, 1),
(246, 'Saint Martin (French part)', 'MF', 'MAF', 1, 1),
(247, 'Sint Maarten (Dutch part)', 'SX', 'SXM', 1, 1),
(248, 'South Sudan', 'SS', 'SSD', 1, 1),
(249, 'Timor-Lester', 'TL', 'TLS', 1, 0),
(250, 'Guernsey', 'GG', 'GGY', 1, 1),
(251, 'Jersey', 'JE', 'JEY', 1, 1),
(252, 'Isle of Man', 'IM', 'IMN', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `currencies`
--

CREATE TABLE `currencies` (
  `currencies_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` char(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol_left` varchar(12) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `symbol_right` varchar(12) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `decimal_point` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `thousands_point` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `decimal_places` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` float(13,8) DEFAULT NULL,
  `last_updated` datetime DEFAULT NULL,
  PRIMARY KEY (`currencies_id`),
  KEY `idx_currencies_code` (`code`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `currencies`
--

INSERT INTO `currencies` VALUES
(1, 'U.S. Dollar', 'USD', '$', '', '.', ',', '2', 1.00000000, '[[regtime]]'),
(2, 'Euro', 'EUR', '', '€', '.', ',', '2', 1.00000000, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `customers`
--

CREATE TABLE `customers` (
  `customers_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_gender` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customers_firstname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customers_lastname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customers_dob` date DEFAULT NULL,
  `customers_email_address` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customers_default_address_id` int(11) DEFAULT NULL,
  `customers_telephone` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customers_fax` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customers_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customers_newsletter` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`customers_id`),
  UNIQUE KEY `uq_customers_email_address` (`customers_email_address`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `customers_basket`
--

CREATE TABLE `customers_basket` (
  `customers_basket_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `products_id` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `customers_basket_quantity` int(2) NOT NULL,
  `final_price` decimal(15,4) DEFAULT NULL,
  `customers_basket_date_added` char(8) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`customers_basket_id`),
  KEY `idx_customers_basket_customers_id` (`customers_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `customers_basket_attributes`
--

CREATE TABLE `customers_basket_attributes` (
  `customers_basket_attributes_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `products_id` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `products_options_id` int(11) NOT NULL,
  `products_options_value_id` int(11) NOT NULL,
  PRIMARY KEY (`customers_basket_attributes_id`),
  KEY `idx_customers_basket_att_customers_id` (`customers_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `customers_gdpr`
--

CREATE TABLE `customers_gdpr` (
  `gdpr_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `page` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pages_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pages_text` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `timestamp` datetime NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`gdpr_id`),
  KEY `idx_customers_id` (`customers_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `customers_info`
--

CREATE TABLE `customers_info` (
  `customers_info_id` int(11) NOT NULL,
  `customers_info_date_of_last_logon` datetime DEFAULT NULL,
  `customers_info_number_of_logons` int(5) DEFAULT NULL,
  `customers_info_date_account_created` datetime DEFAULT NULL,
  `customers_info_date_account_last_modified` datetime DEFAULT NULL,
  `global_product_notifications` int(1) DEFAULT '0',
  `password_reset_key` char(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password_reset_date` datetime DEFAULT NULL,
  PRIMARY KEY (`customers_info_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `customer_data_groups`
--

CREATE TABLE `customer_data_groups` (
  `customer_data_groups_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `customer_data_groups_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cdg_vertical_sort_order` int(11) NOT NULL,
  `customer_data_groups_width` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`language_id`,`customer_data_groups_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `customer_data_groups`
--

INSERT INTO `customer_data_groups` VALUES
(1, 1, 'Your Personal Information', 10, 'col-12 col-md-6'),
(2, 1, 'Your Address', 20, 'col-12 col-md-6'),
(3, 1, 'Your Contact Information', 30, 'col-12 col-md-6'),
(4, 1, 'Company Details', 15, 'col-12 col-md-6'),
(5, 1, 'Options', 50, 'col-12 col-md-6'),
(6, 1, 'Your Password', 60, 'col-12 col-md-6');

-- --------------------------------------------------------

--
-- Table structure for table `customer_data_groups_sequence`
--

CREATE TABLE `customer_data_groups_sequence` (
  `customer_data_groups_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`customer_data_groups_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `customer_data_groups_sequence`
--

INSERT INTO `customer_data_groups_sequence` VALUES
(1),
(2),
(3),
(4),
(5),
(6);

-- --------------------------------------------------------

--
-- Table structure for table `geo_zones`
--

CREATE TABLE `geo_zones` (
  `geo_zone_id` int(11) NOT NULL AUTO_INCREMENT,
  `geo_zone_name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `geo_zone_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`geo_zone_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `geo_zones`
--

INSERT INTO `geo_zones` VALUES
(1, 'Florida', 'Florida local sales tax zone', NULL, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `hooks`
--

CREATE TABLE `hooks` (
  `hooks_id` int(11) NOT NULL AUTO_INCREMENT,
  `hooks_site` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hooks_group` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hooks_action` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hooks_code` varchar(127) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hooks_class` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hooks_method` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`hooks_id`),
  KEY `idx_hooks_site_group` (`hooks_site`,`hooks_group`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=87 ;

--
-- Dumping data for table `hooks`
--

INSERT INTO `hooks` VALUES
(1, 'admin', 'system', 'hrefLink', '_01_href_link', '', 'Href::hook'),
(2, 'shop', 'system', 'hrefLink', '_01_href_link', '', 'Href::hook'),
(3, 'shop', 'system', 'startApplication', '_01_project_version', 'application_surface', 'project_version'),
(4, 'shop', 'system', 'startApplication', '_02_request', 'application_surface', 'request'),
(5, 'shop', 'system', 'startApplication', '_03_read_configuration', 'application_surface', 'read_configuration'),
(6, 'shop', 'system', 'startApplication', '_04_linker', 'Loader', 'Linker'),
(7, 'shop', 'system', 'startApplication', '_09_gzip', 'application_surface', 'gzip'),
(8, 'shop', 'system', 'startApplication', '_10_start_session', 'application_surface', 'start_session'),
(9, 'shop', 'system', 'startApplication', '_11_check_ssl_session_id', 'Application', 'check_ssl_session_id'),
(10, 'shop', 'system', 'startApplication', '_12_check_user_agent', 'Application', 'check_user_agent'),
(11, 'shop', 'system', 'startApplication', '_14_check_ip', 'Application', 'check_ip'),
(12, 'shop', 'system', 'startApplication', '_15_cart', 'Application', 'ensure_session_cart'),
(13, 'shop', 'system', 'startApplication', '_16_set_session_language', 'Application', 'set_session_language'),
(14, 'shop', 'system', 'startApplication', '_17_fix_numeric_locale', 'Application', 'fix_numeric_locale'),
(15, 'shop', 'system', 'startApplication', '_18_set_currency', 'currencies', 'set_currency'),
(16, 'shop', 'system', 'startApplication', '_19_ensure_navigation_history', 'Application', 'ensure_navigation_history'),
(17, 'shop', 'system', 'startApplication', '_20_messageStack', 'Loader', 'messageStack'),
(18, 'shop', 'system', 'startApplication', '_21_customer_data', 'Loader', 'customer_data'),
(19, 'shop', 'system', 'startApplication', '_22_customer', 'Application', 'set_customer_if_identified'),
(20, 'shop', 'system', 'startApplication', '_23_parse_actions', 'application_surface', 'parse_actions'),
(21, 'shop', 'system', 'startApplication', '_24_whos_online', '', 'whos_online::update'),
(22, 'shop', 'system', 'startApplication', '_26_template_title', 'Application', 'set_template_title'),
(23, 'shop', 'system', 'startApplication', '_27_expire_specials', '', 'specials::expire'),
(24, 'shop', 'system', 'startApplication', '_29_category_path', 'application_surface', 'category_path'),
(25, 'shop', 'system', 'startApplication', '_30_register_page_hook', 'hooks', 'register_page'),
(26, 'shop', 'siteWide', 'injectProductCard', '_10_inject_product_card', '', 'product_card::inject'),
(27, 'shop', 'checkout', 'checkoutStart', '_01_register_stages', 'Checkout', 'register_stages'),
(28, 'shop', 'checkout', 'startCheckout', '_01_require_login', '', 'Login::require'),
(29, 'shop', 'checkout_confirmation_stage', 'startCheckout', '_01_require_login', 'Checkout', 'require_login'),
(30, 'shop', 'checkout', 'startCheckout', '_02_guarantee_cart', 'Checkout', 'guarantee_cart'),
(31, 'shop', 'checkout_shipping', 'startCheckout', '_03_guarantee_cart_id', 'Checkout', 'guarantee_cart_id'),
(32, 'shop', 'checkout_shipping', 'startCheckout', '_04_validate', 'Checkout', 'validate_sendto'),
(33, 'shop', 'checkout_payment_stage', 'startCheckout', '_04_validate', 'Checkout', 'validate'),
(34, 'shop', 'checkout_payment', 'startCheckout', '_05_validate_payment', 'Checkout', 'validate_billto'),
(35, 'shop', 'checkout_confirmation', 'startCheckout', '_05_validate_payment', 'Checkout', 'guarantee_payment'),
(36, 'shop', 'checkout_process', 'startCheckout', '_05_validate_payment', 'Checkout', 'validate_payment'),
(37, 'shop', 'checkout_confirmation_stage', 'startCheckout', '_06_initialize_payment_module', 'Checkout', 'initialize_payment_module'),
(38, 'shop', 'checkout_confirmation_stage', 'startCheckout', '_07_initialize_shipping_module', 'Checkout', 'initialize_shipping_module'),
(39, 'shop', 'checkout', 'startCheckout', '_08_order', 'Loader', 'order'),
(40, 'shop', 'checkout_payment_stage', 'startCheckout', '_09_check_stock', 'checkout_surface', 'check_stock'),
(41, 'shop', 'checkout_shipping', 'startCheckout', '_10_virtual_shipping', 'Checkout', 'skip_shipping'),
(42, 'shop', 'checkout_shipping_address', 'startCheckout', '_10_virtual_shipping', 'Checkout', 'skip_shipping'),
(43, 'shop', 'checkout_payment', 'startCheckout', '_10_initialize_payment_modules', 'Checkout', 'initialize_payment_modules'),
(44, 'shop', 'checkout_confirmation_stage', 'startCheckout', '_10_update_payment_modules', 'Checkout', 'update_payment_module'),
(45, 'shop', 'checkout_confirmation_stage', 'startCheckout', '_11_set_order_totals', 'Checkout', 'set_order_totals'),
(46, 'shop', 'checkout_confirmation', 'startCheckout', '_12_prepare_payment', 'Checkout', 'preconfirm_payment'),
(47, 'shop', 'checkout_process', 'startCheckout', '_12_prepare_payment', 'Checkout', 'prepare_payment'),
(48, 'shop', 'checkout_process', 'startCheckout', '_14_insert_order', 'checkout_surface', 'insert_order'),
(49, 'shop', 'checkout_process', 'startCheckout', '_20_after', 'pipeline_surface', 'after'),
(50, 'shop', 'after', 'afterStart', '_21_update_stock', 'Checkout', 'update_stock'),
(51, 'shop', 'after', 'afterStart', '_22_update_products_ordered', 'Checkout', 'update_products_ordered'),
(52, 'shop', 'after', 'afterStart', '_23_notify', 'Checkout', 'notify'),
(53, 'shop', 'checkout_process', 'startCheckout', '_30_insert_history', 'checkout_surface', 'insert_history'),
(54, 'shop', 'checkout_process', 'startCheckout', '_31_conclude_payment', 'Checkout', 'conclude_payment'),
(55, 'shop', 'checkout_process', 'startCheckout', '_40_reset', 'pipeline_surface', 'reset'),
(56, 'shop', 'reset', 'resetStart', '_41_reset_cart', 'Checkout', 'reset_cart'),
(57, 'shop', 'reset', 'resetStart', '_42_unset_sendto', 'session_eraser', 'sendto'),
(58, 'shop', 'reset', 'resetStart', '_43_unset_billto', 'session_eraser', 'billto'),
(59, 'shop', 'reset', 'resetStart', '_44_unset_shipping', 'session_eraser', 'shipping'),
(60, 'shop', 'reset', 'resetStart', '_45_unset_payment', 'session_eraser', 'payment'),
(61, 'shop', 'reset', 'resetStart', '_46_unset_comments', 'session_eraser', 'comments'),
(62, 'shop', 'checkout_process', 'startCheckout', 'zz_redirect_success', 'Checkout', 'redirect_success'),
(63, 'shop', 'siteWide', 'postRegistration', '_01_post_login', 'Login', 'hook'),
(64, 'shop', 'siteWide', 'postLogin', '_01_recreate_session', '', 'Session::recreate'),
(65, 'shop', 'create_account', 'postLogin', '_02_set_customer_id', 'Login', 'add_customer_id'),
(66, 'shop', 'login', 'postLogin', '_02_set_customer_id', 'Login', 'set_customer_id'),
(67, 'shop', 'login', 'postLogin', '_03_log', 'Login', 'log'),
(68, 'shop', 'siteWide', 'postLogin', '_04_reset_token', '', 'Form::reset_session_token'),
(69, 'shop', 'login', 'postLogin', '_05_restore_cart', 'cart', 'restore_contents'),
(70, 'shop', 'login', 'postLogin', 'zz_redirect', 'navigation', 'redirect_to_snapshot'),
(71, 'shop', 'create_account', 'postRegistration', '_02_restore_cart', 'cart', 'restore_contents'),
(72, 'shop', 'create_account', 'postRegistration', '_03_notify', 'Login', 'notify'),
(73, 'shop', 'create_account', 'postRegistration', 'zz_redirect', 'Login', 'redirect_success'),
(74, 'shop', 'logoff', 'resetStart', '_40_unset_customer_id', 'session_eraser', 'customer_id'),
(75, 'shop', 'logoff', 'resetStart', '_41_unset_customer', 'global_eraser', 'customer'),
(76, 'shop', 'checkout_success', 'siteWideStart', 'notify', 'cm_cs_product_notifications', 'process'),
(77, 'shop', 'index', 'siteWideStart', 'category_depth', '', 'category_tree::set_global_depth'),
(78, 'shop', 'loginRequired', 'loginRequiredStart', 'zz_redirect', '', 'Login::require'),
(79, 'shop', 'reviewable', 'reviewableStart', '_01_not_reviewed', '', 'Reviews::verify_not_reviewed'),
(80, 'shop', 'reviewable', 'reviewableStart', '_02_bought', '', 'Reviews::verify_buyer'),
(81, 'admin', 'action_recorder', 'expireAction', 'zz_expire', '', 'actionRecorderAdmin::notify_expiration'),
(82, 'admin', 'modules', 'injectBodyStart', 'update_table_definition', '', 'cfg_modules::hook_injectBodyStart'),
(83, 'admin', 'orders', 'updateOrderAction', 'zz_message_update', '', 'Orders::message_update'),
(84, 'shop', 'advanced_search_result', 'productListing', 'filter_category_brand', 'product_searcher', 'hook'),
(85, 'shop', 'checkout_confirmation', 'injectFormDisplay', 'display_matc', 'cd_matc', 'hook'),
(86, 'shop', 'checkout_confirmation', 'injectFormVerify', 'verify_matc', 'cd_matc', 'is_checked');

-- --------------------------------------------------------

--
-- Table structure for table `importers`
--

CREATE TABLE `importers` (
  `importers_id` int(11) NOT NULL AUTO_INCREMENT,
  `importers_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `importers_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importers_address` text COLLATE utf8mb4_unicode_ci,
  `importers_email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_added` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`importers_id`),
  KEY `IDX_IMPORTERS_NAME` (`importers_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `importers_info`
--

CREATE TABLE `importers_info` (
  `importers_id` int(11) NOT NULL,
  `languages_id` int(11) NOT NULL,
  `importers_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `url_clicked` int(5) NOT NULL DEFAULT '0',
  `date_last_click` datetime DEFAULT NULL,
  `importers_description` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`importers_id`,`languages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `languages`
--

CREATE TABLE `languages` (
  `languages_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `directory` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sort_order` int(3) DEFAULT NULL,
  PRIMARY KEY (`languages_id`),
  KEY `IDX_LANGUAGES_NAME` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `languages`
--

INSERT INTO `languages` VALUES
(1, 'English', 'en', 'icon.gif', 'english', 1);

-- --------------------------------------------------------

--
-- Table structure for table `manufacturers`
--

CREATE TABLE `manufacturers` (
  `manufacturers_id` int(11) NOT NULL AUTO_INCREMENT,
  `manufacturers_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `manufacturers_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `manufacturers_address` text COLLATE utf8mb4_unicode_ci,
  `manufacturers_email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_added` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`manufacturers_id`),
  KEY `IDX_MANUFACTURERS_NAME` (`manufacturers_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `manufacturers`
--

INSERT INTO `manufacturers` VALUES
(1, 'Fiacre', 'brands/fiacre.jpg', '', '', '[[regtime]]', NULL),
(2, 'Von Peacock', 'brands/von-peacock.jpg', '', '', '[[regtime]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `manufacturers_info`
--

CREATE TABLE `manufacturers_info` (
  `manufacturers_id` int(11) NOT NULL,
  `languages_id` int(11) NOT NULL,
  `manufacturers_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `url_clicked` int(5) NOT NULL DEFAULT '0',
  `date_last_click` datetime DEFAULT NULL,
  `manufacturers_description` text COLLATE utf8mb4_unicode_ci,
  `manufacturers_seo_description` text COLLATE utf8mb4_unicode_ci,
  `manufacturers_seo_title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`manufacturers_id`,`languages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `manufacturers_info`
--

INSERT INTO `manufacturers_info` VALUES
(1, 1, '', 0, NULL, NULL, NULL, NULL),
(2, 1, '', 0, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `newsletters`
--

CREATE TABLE `newsletters` (
  `newsletters_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `module` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_added` datetime NOT NULL,
  `date_sent` datetime DEFAULT NULL,
  `status` int(1) DEFAULT NULL,
  `locked` int(1) DEFAULT '0',
  PRIMARY KEY (`newsletters_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `orders`
--

CREATE TABLE `orders` (
  `orders_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `customers_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customers_company` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customers_street_address` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customers_suburb` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customers_city` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customers_postcode` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customers_state` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customers_country` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customers_country_id` int(11) NOT NULL,
  `customers_telephone` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customers_email_address` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customers_address_format_id` int(5) NOT NULL,
  `delivery_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `delivery_company` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `delivery_street_address` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `delivery_suburb` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `delivery_city` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `delivery_postcode` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `delivery_state` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `delivery_country` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `delivery_country_id` int(11) NOT NULL,
  `delivery_address_format_id` int(5) NOT NULL,
  `billing_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `billing_company` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `billing_street_address` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `billing_suburb` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `billing_city` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `billing_postcode` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `billing_state` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `billing_country` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `billing_country_id` int(11) NOT NULL,
  `billing_address_format_id` int(5) NOT NULL,
  `payment_method` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cc_type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cc_owner` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cc_number` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cc_expires` varchar(4) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_purchased` datetime DEFAULT NULL,
  `orders_status` int(5) NOT NULL,
  `orders_date_finished` datetime DEFAULT NULL,
  `currency` char(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency_value` decimal(14,6) DEFAULT NULL,
  PRIMARY KEY (`orders_id`),
  KEY `idx_orders_customers_id` (`customers_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `orders_products`
--

CREATE TABLE `orders_products` (
  `orders_products_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `products_id` int(11) NOT NULL,
  `products_model` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `products_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `products_price` decimal(15,4) NOT NULL,
  `final_price` decimal(15,4) NOT NULL,
  `products_tax` decimal(7,4) NOT NULL,
  `products_quantity` int(2) NOT NULL,
  PRIMARY KEY (`orders_products_id`),
  KEY `idx_orders_products_orders_id` (`orders_id`),
  KEY `idx_orders_products_products_id` (`products_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `orders_products_attributes`
--

CREATE TABLE `orders_products_attributes` (
  `orders_products_attributes_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `orders_products_id` int(11) NOT NULL,
  `products_options` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `products_options_values` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `options_values_price` decimal(15,4) NOT NULL,
  `price_prefix` char(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`orders_products_attributes_id`),
  KEY `idx_orders_products_att_orders_id` (`orders_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `orders_products_download`
--

CREATE TABLE `orders_products_download` (
  `orders_products_download_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL DEFAULT '0',
  `orders_products_id` int(11) NOT NULL DEFAULT '0',
  `orders_products_filename` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `download_maxdays` int(2) NOT NULL DEFAULT '0',
  `download_count` int(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`orders_products_download_id`),
  KEY `idx_orders_products_download_orders_id` (`orders_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `orders_status`
--

CREATE TABLE `orders_status` (
  `orders_status_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `orders_status_name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `public_flag` int(11) DEFAULT '1',
  `downloads_flag` int(11) DEFAULT '0',
  PRIMARY KEY (`orders_status_id`,`language_id`),
  KEY `idx_orders_status_name` (`orders_status_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `orders_status`
--

INSERT INTO `orders_status` VALUES
(1, 1, 'Pending', 1, 0),
(2, 1, 'Processing', 1, 1),
(3, 1, 'Delivered', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `orders_status_history`
--

CREATE TABLE `orders_status_history` (
  `orders_status_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `orders_status_id` int(5) NOT NULL,
  `date_added` datetime NOT NULL,
  `customer_notified` int(1) DEFAULT '0',
  `comments` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`orders_status_history_id`),
  KEY `idx_orders_status_history_orders_id` (`orders_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `orders_total`
--

CREATE TABLE `orders_total` (
  `orders_total_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `text` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` decimal(15,4) NOT NULL,
  `class` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sort_order` int(11) NOT NULL,
  PRIMARY KEY (`orders_total_id`),
  KEY `idx_orders_total_orders_id` (`orders_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `outgoing`
--

CREATE TABLE `outgoing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
  `identifier` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `send_at` datetime NOT NULL,
  `fname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_address` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `merge_tags` longtext COLLATE utf8mb4_unicode_ci,
  `date_added` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `outgoing_tpl`
--

CREATE TABLE `outgoing_tpl` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `text` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_added` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `outgoing_tpl`
--

INSERT INTO `outgoing_tpl` VALUES
(1, 'no_checkout', '{{FNAME}}, no checkout?', 'Hi {{FNAME}}\r\n\r\nWe noticed you registered on our site back on the {{SIGN_UP_DAY}} of {{SIGN_UP_MONTH}} but you did not checkout.\r\n\r\nIf you had a problem with our site, please do not hesitate to contact us.', '[[regtime]]', NULL),
(2, 'order_thanks', '{{FNAME}} thank you for Order #{{ORDER_ID}}', 'Hi {{FNAME}}\r\n\r\nThank you for Order #{{ORDER_ID}} made on {{ORDER_DATE}}.  We are working to pick and pack your Order and will update you at each stage of the process.\r\n\r\nYou ordered:\r\n{{ORDER_PRODUCTS}}\r\n\r\nIf you have any questions about this Order or our site, please do not hesitate to contact us.', '[[regtime]]', NULL),
(3, 'winback', '{{FNAME}}, we''ve missed you', 'Hi {{FNAME}}\r\n\r\nWe really hope you enjoyed your products that you ordered back on {{ORDER_DATE}}\r\n\r\nWe have new products we think you might be interested in.', '[[regtime]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `pages`
--

CREATE TABLE `pages` (
  `pages_id` int(11) NOT NULL AUTO_INCREMENT,
  `date_added` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `pages_status` tinyint(1) NOT NULL DEFAULT '1',
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sort_order` int(11) DEFAULT NULL,
  PRIMARY KEY (`pages_id`),
  UNIQUE KEY `uq_slug` (`slug`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `pages`
--

INSERT INTO `pages` VALUES
(1, '[[regtime]]', NULL, 0, 'privacy', 10),
(2, '[[regtime]]', NULL, 0, 'conditions', 20),
(3, '[[regtime]]', NULL, 0, 'shipping', 30),
(4, '[[regtime]]', NULL, 0, 'ssl_check', 40),
(5, '[[regtime]]', NULL, 0, 'cookie_usage', 50);

-- --------------------------------------------------------

--
-- Table structure for table `pages_description`
--

CREATE TABLE `pages_description` (
  `pages_id` int(11) NOT NULL,
  `languages_id` int(11) NOT NULL,
  `pages_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pages_text` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `navbar_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`pages_id`,`languages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `pages_description`
--

INSERT INTO `pages_description` VALUES
(1, 1, 'Privacy & Cookie Policy', 'Put here your Privacy/Cookie Policies Text.', 'Privacy & Cookie Policy'),
(2, 1, 'Terms & Conditions', 'Put here your Terms & Conditions Text.', 'Terms & Conditions'),
(3, 1, 'Shipping & Returns', 'Put here your Shipping & Returns Text.', 'Shipping & Returns'),
(4, 1, 'Security Check', '<div class="row">\r\n<div class="col-md-6">\r\n<div class="card mb-2">\r\n<div class="card-header">Privacy and Security</div>\r\n<div class="card-body">\r\n<p class="card-text">We validate the SSL Session ID automatically generated by your browser on every secure page request made to this server.</p>\r\n<p class="card-text">This validation assures that it is you who is navigating on this site with your profile and not somebody else.</p>\r\n</div>\r\n</div>\r\n</div>\r\n  <div class="col-md-6">\r\n<div class="card mb-2 text-white bg-danger">\r\n<div class="card-body">\r\n<p class="card-text">We have detected that your browser has generated a different SSL Session ID used throughout our secure pages.</p>\r\n<p class="card-text">For security purposes you will need to sign in to your profile again to continue shopping.</p>\r\n<p class="card-text">Some browsers do not have the capability of generating a secure SSL Session ID automatically. If you use such a browser, we recommend switching to a more modern browser such as <a class="alert-link" href="https://www.microsoft.com/en-us/edge/download?form=MA13FJ" target="_blank" rel="noreferrer">Microsoft Edge</a> or <a class="alert-link" href="https://support.google.com/chrome/answer/95346" target="_blank" rel="noreferrer">Google Chrome</a> or <a class="alert-link" href="https://www.mozilla.org/en-GB/firefox/" target="_blank" rel="noreferrer">Mozilla Firefox</a> to continue using our site.</p>\r\n<p class="card-text">We have taken this security measure for your benefit, and apologize for any inconvenience caused.  Please contact us if you have any questions about this requirement.</p>\r\n      </div>\r\n</div>\r\n</div>\r\n</div>', 'Security Check'),
(5, 1, 'Cookie Usage', '<div class="row">\r\n<div class="col-md-6">\r\n<div class="card mb-2">\r\n<div class="card-header">Cookie Privacy and Security</div>\r\n      <div class="card-body">\r\n<p class="card-text">Cookies must be enabled to purchase online on this store to embrace privacy and security related issues regarding your visit to this site.</p>\r\n<p class="card-text">By enabling cookie support on your browser, the communication between you and this site is strengthened to be certain it is you who are making transactions on your own behalf, and to prevent leakage of your privacy information.</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class="col-md-6">\r\n<div class="card mb-2 text-white bg-danger">\r\n<div class="card-body">\r\n<p class="card-text">We have detected that your browser does not support cookies, or has set cookies to be disabled.</p>\r\n<p class="card-text">To continue shopping online, we encourage you to enable cookies on your browser.</p>\r\n<p class="card-text">For <strong>Internet Explorer</strong> browsers, please follow these instructions:</p>\r\n<ol>\r\n<li>Click on the Tools menubar, and select Internet Options</li>\r\n<li>Select the Security tab, and reset the security level to Medium</li>\r\n</ol>\r\n<p class="card-text">We have taken this security measure for your benefit, and apologize for any inconvenience caused.  Please contact us if you have any questions about this requirement.</p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>', 'Cookie Usage');

-- --------------------------------------------------------

--
-- Table structure for table `products`
--

CREATE TABLE `products` (
  `products_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_quantity` int(4) NOT NULL,
  `products_model` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `products_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `products_price` decimal(15,4) NOT NULL,
  `products_date_added` datetime NOT NULL,
  `products_last_modified` datetime DEFAULT NULL,
  `products_date_available` datetime DEFAULT NULL,
  `products_weight` decimal(5,2) NOT NULL,
  `products_status` tinyint(1) NOT NULL,
  `products_tax_class_id` int(11) NOT NULL,
  `manufacturers_id` int(11) DEFAULT NULL,
  `products_ordered` int(11) NOT NULL DEFAULT '0',
  `products_gtin` char(14) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importers_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`products_id`),
  KEY `idx_products_model` (`products_model`),
  KEY `idx_products_date_added` (`products_date_added`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=10 ;

--
-- Dumping data for table `products`
--

INSERT INTO `products` VALUES
(1, 1000, 'ORA-1', 'sample/orange-1.webp', 9.9900, '[[regtime]]', NULL, NULL, 0.30, 1, 1, 1, 0, NULL, NULL),
(2, 1000, 'LEM-1', 'sample/lemon-1.webp', 7.9900, '[[regtime]]', NULL, NULL, 0.30, 1, 1, 1, 0, NULL, NULL),
(3, 1000, 'PEA-1', 'sample/pear-1.webp', 4.9900, '[[regtime]]', NULL, NULL, 0.30, 1, 1, 0, 0, NULL, NULL),
(4, 1000, 'APP-1', 'sample/apple-1.webp', 4.9900, '[[regtime]]', NULL, NULL, 0.30, 1, 1, 2, 0, NULL, NULL),
(5, 1000, 'TOM-1', 'sample/tomatoes-1.webp', 1.9900, '[[regtime]]', NULL, NULL, 0.50, 1, 1, 2, 0, NULL, NULL),
(6, 1, 'GTOM-1', 'sample/green-tomatoes-1.webp', 1.9900, '[[regtime]]', NULL, NULL, 0.50, 1, 0, 2, 0, NULL, NULL),
(7, 10, 'GAPP-1', 'sample/green-apple-1.webp', 4.9900, '[[regtime]]', NULL, NULL, 0.00, 1, 0, 2, 0, NULL, NULL),
(8, 0, 'GPF-1', 'sample/grapefruit-1.webp', 8.9900, '[[regtime]]', NULL, '2025-08-31 03:20:49', 0.40, 1, 0, 2, 0, NULL, NULL),
(9, 1000, 'LIM-1', 'sample/lime-1.webp', 8.4900, '[[regtime]]', NULL, NULL, 0.35, 1, 0, 2, 0, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `products_attributes`
--

CREATE TABLE `products_attributes` (
  `products_attributes_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL,
  `options_id` int(11) NOT NULL,
  `options_values_id` int(11) NOT NULL,
  `options_values_price` decimal(15,4) NOT NULL,
  `price_prefix` char(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`products_attributes_id`),
  KEY `idx_products_attributes_products_id` (`products_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=8 ;

--
-- Dumping data for table `products_attributes`
--

INSERT INTO `products_attributes` VALUES
(1, 4, 1, 1, 0.0000, '+'),
(2, 4, 1, 2, 5.0000, '+'),
(3, 2, 1, 1, 0.0000, '+'),
(4, 2, 1, 2, 4.5000, '+'),
(5, 5, 1, 1, 0.0000, '+'),
(6, 5, 1, 2, 4.9900, '+'),
(7, 7, 2, 3, 0.0000, '+');

-- --------------------------------------------------------

--
-- Table structure for table `products_attributes_download`
--

CREATE TABLE `products_attributes_download` (
  `products_attributes_id` int(11) NOT NULL,
  `products_attributes_filename` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `products_attributes_maxdays` int(2) DEFAULT '0',
  `products_attributes_maxcount` int(2) DEFAULT '0',
  PRIMARY KEY (`products_attributes_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `products_attributes_download`
--

INSERT INTO `products_attributes_download` VALUES
(7, 'apple-pie.zip', 7, 5);

-- --------------------------------------------------------

--
-- Table structure for table `products_description`
--

CREATE TABLE `products_description` (
  `products_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL DEFAULT '1',
  `products_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `products_description` text COLLATE utf8mb4_unicode_ci,
  `products_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `products_viewed` int(5) DEFAULT '0',
  `products_seo_description` text COLLATE utf8mb4_unicode_ci,
  `products_seo_keywords` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `products_seo_title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`products_id`,`language_id`),
  KEY `products_name` (`products_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=10 ;

--
-- Dumping data for table `products_description`
--

INSERT INTO `products_description` VALUES
(1, 1, 'Oranges', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Turpis massa tincidunt dui ut ornare lectus sit amet est. Imperdiet proin fermentum leo vel orci porta. Cursus metus aliquam eleifend mi in nulla posuere. Nunc scelerisque viverra mauris in. Amet risus nullam eget felis eget nunc lobortis mattis aliquam. Blandit volutpat maecenas volutpat blandit aliquam. Fermentum iaculis eu non diam.</p>\r\n\r\n<p>Image by <a href="https://pixabay.com/users/Eelffica-52436/?utm_source=link-attribution&amp;utm_medium=referral&amp;utm_campaign=image&amp;utm_content=756390">Eelffica</a> from <a href="https://pixabay.com/?utm_source=link-attribution&amp;utm_medium=referral&amp;utm_campaign=image&amp;utm_content=756390">Pixabay</a></p>\r\n\r\n<p>Id donec ultrices tincidunt arcu non sodales. Id ornare arcu odio ut sem. Velit sed ullamcorper morbi tincidunt ornare massa eget. Mi eget mauris pharetra et ultrices neque. Pellentesque dignissim enim sit amet venenatis. Pellentesque diam volutpat commodo sed egestas egestas fringilla phasellus. Venenatis cras sed felis eget velit. Justo eget magna fermentum iaculis eu non diam phasellus vestibulum. Sollicitudin aliquam ultrices sagittis orci a scelerisque purus semper eget. Ultrices tincidunt arcu non sodales neque sodales ut. Integer malesuada nunc vel risus.</p>\r\n\r\n<p>Nunc sed id semper risus in hendrerit gravida. In cursus turpis massa tincidunt dui ut ornare lectus. Mattis rhoncus urna neque viverra justo nec ultrices dui. Ac tincidunt vitae semper quis lectus nulla at. Dui vivamus arcu felis bibendum ut. Ultricies tristique nulla aliquet enim tortor. Cras pulvinar mattis nunc sed blandit libero volutpat sed. Nisl nunc mi ipsum faucibus. Quis commodo odio aenean sed adipiscing. Tortor posuere ac ut consequat. Felis eget nunc lobortis mattis aliquam faucibus purus in. Aliquet lectus proin nibh nisl condimentum id venenatis a. Rhoncus mattis rhoncus urna neque viverra. Proin nibh nisl condimentum id. Dolor morbi non arcu risus.</p>', '', 0, 'Oranges are not the only fruit...', NULL, NULL),
(2, 1, 'Lemons', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Turpis massa tincidunt dui ut ornare lectus sit amet est. Imperdiet proin fermentum leo vel orci porta. Cursus metus aliquam eleifend mi in nulla posuere. Nunc scelerisque viverra mauris in. Amet risus nullam eget felis eget nunc lobortis mattis aliquam. Blandit volutpat maecenas volutpat blandit aliquam. Fermentum iaculis eu non diam.</p>\r\n\r\n<p>Images by <a href="https://pixabay.com/users/Eelffica-52436/?utm_source=link-attribution&amp;utm_medium=referral&amp;utm_campaign=image&amp;utm_content=756390">Eelffica</a> from <a href="https://pixabay.com/?utm_source=link-attribution&amp;utm_medium=referral&amp;utm_campaign=image&amp;utm_content=756390">Pixabay</a> and <a href="https://pixabay.com/users/alles-2597842/?utm_source=link-attribution&utm_medium=referral&utm_campaign=image&utm_content=5069648">Alexander Lesnitsky</a> from <a href="https://pixabay.com//?utm_source=link-attribution&utm_medium=referral&utm_campaign=image&utm_content=5069648">Pixabay</a></p>\r\n\r\n<p>Id donec ultrices tincidunt arcu non sodales. Id ornare arcu odio ut sem. Velit sed ullamcorper morbi tincidunt ornare massa eget. Mi eget mauris pharetra et ultrices neque. Pellentesque dignissim enim sit amet venenatis. Pellentesque diam volutpat commodo sed egestas egestas fringilla phasellus. Venenatis cras sed felis eget velit. Justo eget magna fermentum iaculis eu non diam phasellus vestibulum. Sollicitudin aliquam ultrices sagittis orci a scelerisque purus semper eget. Ultrices tincidunt arcu non sodales neque sodales ut. Integer malesuada nunc vel risus.</p>\r\n\r\n<p>Nunc sed id semper risus in hendrerit gravida. In cursus turpis massa tincidunt dui ut ornare lectus. Mattis rhoncus urna neque viverra justo nec ultrices dui. Ac tincidunt vitae semper quis lectus nulla at. Dui vivamus arcu felis bibendum ut. Ultricies tristique nulla aliquet enim tortor. Cras pulvinar mattis nunc sed blandit libero volutpat sed. Nisl nunc mi ipsum faucibus. Quis commodo odio aenean sed adipiscing. Tortor posuere ac ut consequat. Felis eget nunc lobortis mattis aliquam faucibus purus in. Aliquet lectus proin nibh nisl condimentum id venenatis a. Rhoncus mattis rhoncus urna neque viverra. Proin nibh nisl condimentum id. Dolor morbi non arcu risus.</p>', '', 0, 'When life gives you lemons...', NULL, NULL),
(3, 1, 'Pears', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Turpis massa tincidunt dui ut ornare lectus sit amet est. Imperdiet proin fermentum leo vel orci porta. Cursus metus aliquam eleifend mi in nulla posuere. Nunc scelerisque viverra mauris in. Amet risus nullam eget felis eget nunc lobortis mattis aliquam. Blandit volutpat maecenas volutpat blandit aliquam. Fermentum iaculis eu non diam.</p>\r\n\r\n<p>Image by <a href="https://pixabay.com/users/Eelffica-52436/?utm_source=link-attribution&amp;utm_medium=referral&amp;utm_campaign=image&amp;utm_content=756390">Eelffica</a> from <a href="https://pixabay.com/?utm_source=link-attribution&amp;utm_medium=referral&amp;utm_campaign=image&amp;utm_content=756390">Pixabay</a></p>\r\n\r\n<p>Id donec ultrices tincidunt arcu non sodales. Id ornare arcu odio ut sem. Velit sed ullamcorper morbi tincidunt ornare massa eget. Mi eget mauris pharetra et ultrices neque. Pellentesque dignissim enim sit amet venenatis. Pellentesque diam volutpat commodo sed egestas egestas fringilla phasellus. Venenatis cras sed felis eget velit. Justo eget magna fermentum iaculis eu non diam phasellus vestibulum. Sollicitudin aliquam ultrices sagittis orci a scelerisque purus semper eget. Ultrices tincidunt arcu non sodales neque sodales ut. Integer malesuada nunc vel risus.</p>\r\n\r\n<p>Nunc sed id semper risus in hendrerit gravida. In cursus turpis massa tincidunt dui ut ornare lectus. Mattis rhoncus urna neque viverra justo nec ultrices dui. Ac tincidunt vitae semper quis lectus nulla at. Dui vivamus arcu felis bibendum ut. Ultricies tristique nulla aliquet enim tortor. Cras pulvinar mattis nunc sed blandit libero volutpat sed. Nisl nunc mi ipsum faucibus. Quis commodo odio aenean sed adipiscing. Tortor posuere ac ut consequat. Felis eget nunc lobortis mattis aliquam faucibus purus in. Aliquet lectus proin nibh nisl condimentum id venenatis a. Rhoncus mattis rhoncus urna neque viverra. Proin nibh nisl condimentum id. Dolor morbi non arcu risus.</p>', '', 0, 'Best things always come in pairs...', NULL, NULL),
(4, 1, 'Shiny Red Apples', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Turpis massa tincidunt dui ut ornare lectus sit amet est. Imperdiet proin fermentum leo vel orci porta. Cursus metus aliquam eleifend mi in nulla posuere. Nunc scelerisque viverra mauris in. Amet risus nullam eget felis eget nunc lobortis mattis aliquam. Blandit volutpat maecenas volutpat blandit aliquam. Fermentum iaculis eu non diam.</p>\r\n\r\n<p>Image by <a href="https://pixabay.com/users/Eelffica-52436/?utm_source=link-attribution&amp;utm_medium=referral&amp;utm_campaign=image&amp;utm_content=756390">Eelffica</a> from <a href="https://pixabay.com/?utm_source=link-attribution&amp;utm_medium=referral&amp;utm_campaign=image&amp;utm_content=756390">Pixabay</a></p>\r\n\r\n<p>Id donec ultrices tincidunt arcu non sodales. Id ornare arcu odio ut sem. Velit sed ullamcorper morbi tincidunt ornare massa eget. Mi eget mauris pharetra et ultrices neque. Pellentesque dignissim enim sit amet venenatis. Pellentesque diam volutpat commodo sed egestas egestas fringilla phasellus. Venenatis cras sed felis eget velit. Justo eget magna fermentum iaculis eu non diam phasellus vestibulum. Sollicitudin aliquam ultrices sagittis orci a scelerisque purus semper eget. Ultrices tincidunt arcu non sodales neque sodales ut. Integer malesuada nunc vel risus.</p>\r\n\r\n<p>Nunc sed id semper risus in hendrerit gravida. In cursus turpis massa tincidunt dui ut ornare lectus. Mattis rhoncus urna neque viverra justo nec ultrices dui. Ac tincidunt vitae semper quis lectus nulla at. Dui vivamus arcu felis bibendum ut. Ultricies tristique nulla aliquet enim tortor. Cras pulvinar mattis nunc sed blandit libero volutpat sed. Nisl nunc mi ipsum faucibus. Quis commodo odio aenean sed adipiscing. Tortor posuere ac ut consequat. Felis eget nunc lobortis mattis aliquam faucibus purus in. Aliquet lectus proin nibh nisl condimentum id venenatis a. Rhoncus mattis rhoncus urna neque viverra. Proin nibh nisl condimentum id. Dolor morbi non arcu risus.</p>', '', 0, 'An apple a day keeps the doc away...', NULL, NULL),
(5, 1, 'Tomatoes', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Turpis massa tincidunt dui ut ornare lectus sit amet est. Imperdiet proin fermentum leo vel orci porta. Cursus metus aliquam eleifend mi in nulla posuere. Nunc scelerisque viverra mauris in. Amet risus nullam eget felis eget nunc lobortis mattis aliquam. Blandit volutpat maecenas volutpat blandit aliquam. Fermentum iaculis eu non diam.</p>\r\n\r\n<p>Image by <a href="https://pixabay.com/users/Rocky_H-11790006/?utm_source=link-attribution&amp;utm_medium=referral&amp;utm_campaign=image&amp;utm_content=4035459">Rocky_H</a> from <a href="https://pixabay.com/?utm_source=link-attribution&amp;utm_medium=referral&amp;utm_campaign=image&amp;utm_content=4035459">Pixabay</a></p>\r\n\r\n<p>Id donec ultrices tincidunt arcu non sodales. Id ornare arcu odio ut sem. Velit sed ullamcorper morbi tincidunt ornare massa eget. Mi eget mauris pharetra et ultrices neque. Pellentesque dignissim enim sit amet venenatis. Pellentesque diam volutpat commodo sed egestas egestas fringilla phasellus. Venenatis cras sed felis eget velit. Justo eget magna fermentum iaculis eu non diam phasellus vestibulum. Sollicitudin aliquam ultrices sagittis orci a scelerisque purus semper eget. Ultrices tincidunt arcu non sodales neque sodales ut. Integer malesuada nunc vel risus.</p>\r\n\r\n<p>Nunc sed id semper risus in hendrerit gravida. In cursus turpis massa tincidunt dui ut ornare lectus. Mattis rhoncus urna neque viverra justo nec ultrices dui. Ac tincidunt vitae semper quis lectus nulla at. Dui vivamus arcu felis bibendum ut. Ultricies tristique nulla aliquet enim tortor. Cras pulvinar mattis nunc sed blandit libero volutpat sed. Nisl nunc mi ipsum faucibus. Quis commodo odio aenean sed adipiscing. Tortor posuere ac ut consequat. Felis eget nunc lobortis mattis aliquam faucibus purus in. Aliquet lectus proin nibh nisl condimentum id venenatis a. Rhoncus mattis rhoncus urna neque viverra. Proin nibh nisl condimentum id. Dolor morbi non arcu risus.</p>', '', 0, NULL, NULL, NULL),
(6, 1, 'Green Tomatoes', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Turpis massa tincidunt dui ut ornare lectus sit amet est. Imperdiet proin fermentum leo vel orci porta. Cursus metus aliquam eleifend mi in nulla posuere. Nunc scelerisque viverra mauris in. Amet risus nullam eget felis eget nunc lobortis mattis aliquam. Blandit volutpat maecenas volutpat blandit aliquam. Fermentum iaculis eu non diam.</p>\r\n\r\n<p>Image by <a href="https://pixabay.com/users/Rocky_H-11790006/">Rocky_H</a> from <a href="https://pixabay.com/">Pixabay</a></p>\r\n\r\n<p>Id donec ultrices tincidunt arcu non sodales. Id ornare arcu odio ut sem. Velit sed ullamcorper morbi tincidunt ornare massa eget. Mi eget mauris pharetra et ultrices neque. Pellentesque dignissim enim sit amet venenatis. Pellentesque diam volutpat commodo sed egestas egestas fringilla phasellus. Venenatis cras sed felis eget velit. Justo eget magna fermentum iaculis eu non diam phasellus vestibulum. Sollicitudin aliquam ultrices sagittis orci a scelerisque purus semper eget. Ultrices tincidunt arcu non sodales neque sodales ut. Integer malesuada nunc vel risus.</p>\r\n\r\n<p>Nunc sed id semper risus in hendrerit gravida. In cursus turpis massa tincidunt dui ut ornare lectus. Mattis rhoncus urna neque viverra justo nec ultrices dui. Ac tincidunt vitae semper quis lectus nulla at. Dui vivamus arcu felis bibendum ut. Ultricies tristique nulla aliquet enim tortor. Cras pulvinar mattis nunc sed blandit libero volutpat sed. Nisl nunc mi ipsum faucibus. Quis commodo odio aenean sed adipiscing. Tortor posuere ac ut consequat. Felis eget nunc lobortis mattis aliquam faucibus purus in. Aliquet lectus proin nibh nisl condimentum id venenatis a. Rhoncus mattis rhoncus urna neque viverra. Proin nibh nisl condimentum id. Dolor morbi non arcu risus.</p>', '', 0, NULL, NULL, NULL),
(7, 1, 'Green Apples', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Turpis massa tincidunt dui ut ornare lectus sit amet est. Imperdiet proin fermentum leo vel orci porta. Cursus metus aliquam eleifend mi in nulla posuere. Nunc scelerisque viverra mauris in. Amet risus nullam eget felis eget nunc lobortis mattis aliquam. Blandit volutpat maecenas volutpat blandit aliquam. Fermentum iaculis eu non diam.</p>\r\n\r\n<p>Image by <a href="https://pixabay.com/users/Eelffica-52436/">Eelffica</a> from <a href="https://pixabay.com/">Pixabay</a></p>\r\n\r\n<p>Id donec ultrices tincidunt arcu non sodales. Id ornare arcu odio ut sem. Velit sed ullamcorper morbi tincidunt ornare massa eget. Mi eget mauris pharetra et ultrices neque. Pellentesque dignissim enim sit amet venenatis. Pellentesque diam volutpat commodo sed egestas egestas fringilla phasellus. Venenatis cras sed felis eget velit. Justo eget magna fermentum iaculis eu non diam phasellus vestibulum. Sollicitudin aliquam ultrices sagittis orci a scelerisque purus semper eget. Ultrices tincidunt arcu non sodales neque sodales ut. Integer malesuada nunc vel risus.</p>\r\n\r\n<p>Nunc sed id semper risus in hendrerit gravida. In cursus turpis massa tincidunt dui ut ornare lectus. Mattis rhoncus urna neque viverra justo nec ultrices dui. Ac tincidunt vitae semper quis lectus nulla at. Dui vivamus arcu felis bibendum ut. Ultricies tristique nulla aliquet enim tortor. Cras pulvinar mattis nunc sed blandit libero volutpat sed. Nisl nunc mi ipsum faucibus. Quis commodo odio aenean sed adipiscing. Tortor posuere ac ut consequat. Felis eget nunc lobortis mattis aliquam faucibus purus in. Aliquet lectus proin nibh nisl condimentum id venenatis a. Rhoncus mattis rhoncus urna neque viverra. Proin nibh nisl condimentum id. Dolor morbi non arcu risus.</p>', '', 0, 'Green apples, fresh and crisp with a fragrant flavour.', NULL, NULL),
(8, 1, 'Grapefruit', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Turpis massa tincidunt dui ut ornare lectus sit amet est. Imperdiet proin fermentum leo vel orci porta. Cursus metus aliquam eleifend mi in nulla posuere. Nunc scelerisque viverra mauris in. Amet risus nullam eget felis eget nunc lobortis mattis aliquam. Blandit volutpat maecenas volutpat blandit aliquam. Fermentum iaculis eu non diam.</p>\r\n\r\n<p>Image by <a href="https://pixabay.com/users/Eelffica-52436/">Eelffica</a> from <a href="https://pixabay.com/">Pixabay</a></p>\r\n\r\n<p>Id donec ultrices tincidunt arcu non sodales. Id ornare arcu odio ut sem. Velit sed ullamcorper morbi tincidunt ornare massa eget. Mi eget mauris pharetra et ultrices neque. Pellentesque dignissim enim sit amet venenatis. Pellentesque diam volutpat commodo sed egestas egestas fringilla phasellus. Venenatis cras sed felis eget velit. Justo eget magna fermentum iaculis eu non diam phasellus vestibulum. Sollicitudin aliquam ultrices sagittis orci a scelerisque purus semper eget. Ultrices tincidunt arcu non sodales neque sodales ut. Integer malesuada nunc vel risus.</p>\r\n\r\n<p>Nunc sed id semper risus in hendrerit gravida. In cursus turpis massa tincidunt dui ut ornare lectus. Mattis rhoncus urna neque viverra justo nec ultrices dui. Ac tincidunt vitae semper quis lectus nulla at. Dui vivamus arcu felis bibendum ut. Ultricies tristique nulla aliquet enim tortor. Cras pulvinar mattis nunc sed blandit libero volutpat sed. Nisl nunc mi ipsum faucibus. Quis commodo odio aenean sed adipiscing. Tortor posuere ac ut consequat. Felis eget nunc lobortis mattis aliquam faucibus purus in. Aliquet lectus proin nibh nisl condimentum id venenatis a. Rhoncus mattis rhoncus urna neque viverra. Proin nibh nisl condimentum id. Dolor morbi non arcu risus.</p>', '', 0, 'Big and juicy grapefruit', NULL, NULL),
(9, 1, 'Lime', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Turpis massa tincidunt dui ut ornare lectus sit amet est. Imperdiet proin fermentum leo vel orci porta. Cursus metus aliquam eleifend mi in nulla posuere. Nunc scelerisque viverra mauris in. Amet risus nullam eget felis eget nunc lobortis mattis aliquam. Blandit volutpat maecenas volutpat blandit aliquam. Fermentum iaculis eu non diam.</p>\r\n\r\n<p>Image by <a href="https://pixabay.com/users/Eelffica-52436/">Eelffica</a> from <a href="https://pixabay.com/">Pixabay</a></p>\r\n\r\n<p>Id donec ultrices tincidunt arcu non sodales. Id ornare arcu odio ut sem. Velit sed ullamcorper morbi tincidunt ornare massa eget. Mi eget mauris pharetra et ultrices neque. Pellentesque dignissim enim sit amet venenatis. Pellentesque diam volutpat commodo sed egestas egestas fringilla phasellus. Venenatis cras sed felis eget velit. Justo eget magna fermentum iaculis eu non diam phasellus vestibulum. Sollicitudin aliquam ultrices sagittis orci a scelerisque purus semper eget. Ultrices tincidunt arcu non sodales neque sodales ut. Integer malesuada nunc vel risus.</p>\r\n\r\n<p>Nunc sed id semper risus in hendrerit gravida. In cursus turpis massa tincidunt dui ut ornare lectus. Mattis rhoncus urna neque viverra justo nec ultrices dui. Ac tincidunt vitae semper quis lectus nulla at. Dui vivamus arcu felis bibendum ut. Ultricies tristique nulla aliquet enim tortor. Cras pulvinar mattis nunc sed blandit libero volutpat sed. Nisl nunc mi ipsum faucibus. Quis commodo odio aenean sed adipiscing. Tortor posuere ac ut consequat. Felis eget nunc lobortis mattis aliquam faucibus purus in. Aliquet lectus proin nibh nisl condimentum id venenatis a. Rhoncus mattis rhoncus urna neque viverra. Proin nibh nisl condimentum id. Dolor morbi non arcu risus.</p>', '', 0, 'Sharp and juicy, add a twist', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `products_images`
--

CREATE TABLE `products_images` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `htmlcontent` text COLLATE utf8mb4_unicode_ci,
  `sort_order` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `products_images_prodid` (`products_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `products_images`
--

INSERT INTO `products_images` VALUES
(1, 2, 'sample/lemons-2.webp', '', 1);

-- --------------------------------------------------------

--
-- Table structure for table `products_notifications`
--

CREATE TABLE `products_notifications` (
  `products_id` int(11) NOT NULL,
  `customers_id` int(11) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`products_id`,`customers_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `products_options`
--

CREATE TABLE `products_options` (
  `products_options_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `products_options_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sort_order` int(3) DEFAULT NULL,
  PRIMARY KEY (`products_options_id`,`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `products_options`
--

INSERT INTO `products_options` VALUES
(1, 1, 'Box Size', 10),
(2, 1, 'Download', 10);

-- --------------------------------------------------------

--
-- Table structure for table `products_options_values`
--

CREATE TABLE `products_options_values` (
  `products_options_values_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `products_options_values_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sort_order` int(3) DEFAULT NULL,
  PRIMARY KEY (`products_options_values_id`,`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `products_options_values`
--

INSERT INTO `products_options_values` VALUES
(1, 1, '12', 10),
(2, 1, '24', 20),
(3, 1, 'apple-pie.zip', 10);

-- --------------------------------------------------------

--
-- Table structure for table `products_options_values_to_products_options`
--

CREATE TABLE `products_options_values_to_products_options` (
  `products_options_values_to_products_options_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_options_id` int(11) NOT NULL,
  `products_options_values_id` int(11) NOT NULL,
  PRIMARY KEY (`products_options_values_to_products_options_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `products_options_values_to_products_options`
--

INSERT INTO `products_options_values_to_products_options` VALUES
(1, 1, 1),
(2, 1, 2),
(3, 2, 3);

-- --------------------------------------------------------

--
-- Table structure for table `products_to_categories`
--

CREATE TABLE `products_to_categories` (
  `products_id` int(11) NOT NULL,
  `categories_id` int(11) NOT NULL,
  PRIMARY KEY (`products_id`,`categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `products_to_categories`
--

INSERT INTO `products_to_categories` VALUES
(1, 4),
(2, 4),
(3, 3),
(4, 3),
(5, 2),
(6, 2),
(7, 3),
(8, 4),
(9, 4);

-- --------------------------------------------------------

--
-- Table structure for table `reviews`
--

CREATE TABLE `reviews` (
  `reviews_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL,
  `customers_id` int(11) DEFAULT NULL,
  `customers_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reviews_rating` int(1) DEFAULT NULL,
  `date_added` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `reviews_status` tinyint(1) NOT NULL DEFAULT '0',
  `reviews_read` int(5) NOT NULL DEFAULT '0',
  `is_anon` enum('y','n') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`reviews_id`),
  KEY `idx_reviews_products_id` (`products_id`),
  KEY `idx_reviews_customers_id` (`customers_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `reviews`
--

INSERT INTO `reviews` VALUES
(1, 4, 0, 'John Doe', 5, '[[regtime]]', NULL, 1, 0, 'n');

-- --------------------------------------------------------

--
-- Table structure for table `reviews_description`
--

CREATE TABLE `reviews_description` (
  `reviews_id` int(11) NOT NULL,
  `languages_id` int(11) NOT NULL,
  `reviews_text` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`reviews_id`,`languages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `reviews_description`
--

INSERT INTO `reviews_description` VALUES
(1, 1, 'Lovely box of crunchy apples and delivered very quickly.  Thank You!');

-- --------------------------------------------------------

--
-- Table structure for table `sec_directory_whitelist`
--

CREATE TABLE `sec_directory_whitelist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `directory` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `sec_directory_whitelist`
--

INSERT INTO `sec_directory_whitelist` VALUES
(1, 'images'),
(2, 'includes/work'),
(3, 'pub');

-- --------------------------------------------------------

--
-- Table structure for table `sessions`
--

CREATE TABLE `sessions` (
  `sesskey` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiry` int(11) unsigned NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`sesskey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `specials`
--

CREATE TABLE `specials` (
  `specials_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL,
  `specials_new_products_price` decimal(15,4) NOT NULL,
  `specials_date_added` datetime DEFAULT NULL,
  `specials_last_modified` datetime DEFAULT NULL,
  `expires_date` datetime DEFAULT NULL,
  `date_status_change` datetime DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`specials_id`),
  KEY `idx_specials_products_id` (`products_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `specials`
--

INSERT INTO `specials` VALUES
(1, 1, 2.9900, '[[regtime]]', NULL, NULL, NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `tax_class`
--

CREATE TABLE `tax_class` (
  `tax_class_id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_class_title` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tax_class_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`tax_class_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `tax_class`
--

INSERT INTO `tax_class` VALUES
(1, 'Taxable Goods', 'The following types of products are included non-food, services, etc', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `tax_rates`
--

CREATE TABLE `tax_rates` (
  `tax_rates_id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_zone_id` int(11) NOT NULL,
  `tax_class_id` int(11) NOT NULL,
  `tax_priority` int(5) DEFAULT '1',
  `tax_rate` decimal(7,4) NOT NULL,
  `tax_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`tax_rates_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `tax_rates`
--

INSERT INTO `tax_rates` VALUES
(1, 1, 1, 1, 7.0000, 'FL TAX 7.0%', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `testimonials`
--

CREATE TABLE `testimonials` (
  `testimonials_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL DEFAULT '0',
  `customers_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `testimonials_status` tinyint(1) NOT NULL DEFAULT '1',
  `is_anon` enum('y','n') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`testimonials_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `testimonials`
--

INSERT INTO `testimonials` VALUES
(1, 0, 'John Doe', '[[regtime]]', NULL, 1, 'n');

-- --------------------------------------------------------

--
-- Table structure for table `testimonials_description`
--

CREATE TABLE `testimonials_description` (
  `testimonials_id` int(11) NOT NULL,
  `languages_id` int(11) NOT NULL,
  `testimonials_text` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`testimonials_id`,`languages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `testimonials_description`
--

INSERT INTO `testimonials_description` VALUES
(1, 1, 'Amazing service! The products arrived quickly and exceeded my expectations. Will definitely shop here again!');

-- --------------------------------------------------------

--
-- Table structure for table `whos_online`
--

CREATE TABLE `whos_online` (
  `customer_id` int(11) DEFAULT NULL,
  `full_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `session_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ip_address` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time_entry` varchar(14) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time_last_click` varchar(14) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_page_url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `zones`
--

CREATE TABLE `zones` (
  `zone_id` int(11) NOT NULL AUTO_INCREMENT,
  `zone_country_id` int(11) NOT NULL,
  `zone_code` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zone_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`zone_id`),
  KEY `idx_zones_country_id` (`zone_country_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=182 ;

--
-- Dumping data for table `zones`
--

INSERT INTO `zones` VALUES
(1, 223, 'AL', 'Alabama'),
(2, 223, 'AK', 'Alaska'),
(3, 223, 'AS', 'American Samoa'),
(4, 223, 'AZ', 'Arizona'),
(5, 223, 'AR', 'Arkansas'),
(6, 223, 'AF', 'Armed Forces Africa'),
(7, 223, 'AA', 'Armed Forces Americas'),
(8, 223, 'AC', 'Armed Forces Canada'),
(9, 223, 'AE', 'Armed Forces Europe'),
(10, 223, 'AM', 'Armed Forces Middle East'),
(11, 223, 'AP', 'Armed Forces Pacific'),
(12, 223, 'CA', 'California'),
(13, 223, 'CO', 'Colorado'),
(14, 223, 'CT', 'Connecticut'),
(15, 223, 'DE', 'Delaware'),
(16, 223, 'DC', 'District of Columbia'),
(17, 223, 'FM', 'Federated States Of Micronesia'),
(18, 223, 'FL', 'Florida'),
(19, 223, 'GA', 'Georgia'),
(20, 223, 'GU', 'Guam'),
(21, 223, 'HI', 'Hawaii'),
(22, 223, 'ID', 'Idaho'),
(23, 223, 'IL', 'Illinois'),
(24, 223, 'IN', 'Indiana'),
(25, 223, 'IA', 'Iowa'),
(26, 223, 'KS', 'Kansas'),
(27, 223, 'KY', 'Kentucky'),
(28, 223, 'LA', 'Louisiana'),
(29, 223, 'ME', 'Maine'),
(30, 223, 'MH', 'Marshall Islands'),
(31, 223, 'MD', 'Maryland'),
(32, 223, 'MA', 'Massachusetts'),
(33, 223, 'MI', 'Michigan'),
(34, 223, 'MN', 'Minnesota'),
(35, 223, 'MS', 'Mississippi'),
(36, 223, 'MO', 'Missouri'),
(37, 223, 'MT', 'Montana'),
(38, 223, 'NE', 'Nebraska'),
(39, 223, 'NV', 'Nevada'),
(40, 223, 'NH', 'New Hampshire'),
(41, 223, 'NJ', 'New Jersey'),
(42, 223, 'NM', 'New Mexico'),
(43, 223, 'NY', 'New York'),
(44, 223, 'NC', 'North Carolina'),
(45, 223, 'ND', 'North Dakota'),
(46, 223, 'MP', 'Northern Mariana Islands'),
(47, 223, 'OH', 'Ohio'),
(48, 223, 'OK', 'Oklahoma'),
(49, 223, 'OR', 'Oregon'),
(50, 223, 'PW', 'Palau'),
(51, 223, 'PA', 'Pennsylvania'),
(52, 223, 'PR', 'Puerto Rico'),
(53, 223, 'RI', 'Rhode Island'),
(54, 223, 'SC', 'South Carolina'),
(55, 223, 'SD', 'South Dakota'),
(56, 223, 'TN', 'Tennessee'),
(57, 223, 'TX', 'Texas'),
(58, 223, 'UT', 'Utah'),
(59, 223, 'VT', 'Vermont'),
(60, 223, 'VI', 'Virgin Islands'),
(61, 223, 'VA', 'Virginia'),
(62, 223, 'WA', 'Washington'),
(63, 223, 'WV', 'West Virginia'),
(64, 223, 'WI', 'Wisconsin'),
(65, 223, 'WY', 'Wyoming'),
(66, 38, 'AB', 'Alberta'),
(67, 38, 'BC', 'British Columbia'),
(68, 38, 'MB', 'Manitoba'),
(69, 38, 'NL', 'Newfoundland'),
(70, 38, 'NB', 'New Brunswick'),
(71, 38, 'NS', 'Nova Scotia'),
(72, 38, 'NT', 'Northwest Territories'),
(73, 38, 'NU', 'Nunavut'),
(74, 38, 'ON', 'Ontario'),
(75, 38, 'PE', 'Prince Edward Island'),
(76, 38, 'QC', 'Quebec'),
(77, 38, 'SK', 'Saskatchewan'),
(78, 38, 'YT', 'Yukon Territory'),
(79, 81, 'NDS', 'Niedersachsen'),
(80, 81, 'BAW', 'Baden-Württemberg'),
(81, 81, 'BAY', 'Bayern'),
(82, 81, 'BER', 'Berlin'),
(83, 81, 'BRG', 'Brandenburg'),
(84, 81, 'BRE', 'Bremen'),
(85, 81, 'HAM', 'Hamburg'),
(86, 81, 'HES', 'Hessen'),
(87, 81, 'MEC', 'Mecklenburg-Vorpommern'),
(88, 81, 'NRW', 'Nordrhein-Westfalen'),
(89, 81, 'RHE', 'Rheinland-Pfalz'),
(90, 81, 'SAR', 'Saarland'),
(91, 81, 'SAS', 'Sachsen'),
(92, 81, 'SAC', 'Sachsen-Anhalt'),
(93, 81, 'SCN', 'Schleswig-Holstein'),
(94, 81, 'THE', 'Thüringen'),
(95, 14, 'WI', 'Wien'),
(96, 14, 'NO', 'Niederösterreich'),
(97, 14, 'OO', 'Oberösterreich'),
(98, 14, 'SB', 'Salzburg'),
(99, 14, 'KN', 'Kärnten'),
(100, 14, 'ST', 'Steiermark'),
(101, 14, 'TI', 'Tirol'),
(102, 14, 'BL', 'Burgenland'),
(103, 14, 'VB', 'Voralberg'),
(104, 204, 'AG', 'Aargau'),
(105, 204, 'AI', 'Appenzell Innerrhoden'),
(106, 204, 'AR', 'Appenzell Ausserrhoden'),
(107, 204, 'BE', 'Bern'),
(108, 204, 'BL', 'Basel-Landschaft'),
(109, 204, 'BS', 'Basel-Stadt'),
(110, 204, 'FR', 'Freiburg'),
(111, 204, 'GE', 'Genf'),
(112, 204, 'GL', 'Glarus'),
(113, 204, 'JU', 'Graubünden'),
(114, 204, 'JU', 'Jura'),
(115, 204, 'LU', 'Luzern'),
(116, 204, 'NE', 'Neuenburg'),
(117, 204, 'NW', 'Nidwalden'),
(118, 204, 'OW', 'Obwalden'),
(119, 204, 'SG', 'St. Gallen'),
(120, 204, 'SH', 'Schaffhausen'),
(121, 204, 'SO', 'Solothurn'),
(122, 204, 'SZ', 'Schwyz'),
(123, 204, 'TG', 'Thurgau'),
(124, 204, 'TI', 'Tessin'),
(125, 204, 'UR', 'Uri'),
(126, 204, 'VD', 'Waadt'),
(127, 204, 'VS', 'Wallis'),
(128, 204, 'ZG', 'Zug'),
(129, 204, 'ZH', 'Zürich'),
(130, 195, 'A Coruña', 'A Coruña'),
(131, 195, 'Alava', 'Alava'),
(132, 195, 'Albacete', 'Albacete'),
(133, 195, 'Alicante', 'Alicante'),
(134, 195, 'Almeria', 'Almeria'),
(135, 195, 'Asturias', 'Asturias'),
(136, 195, 'Avila', 'Avila'),
(137, 195, 'Badajoz', 'Badajoz'),
(138, 195, 'Baleares', 'Baleares'),
(139, 195, 'Barcelona', 'Barcelona'),
(140, 195, 'Burgos', 'Burgos'),
(141, 195, 'Caceres', 'Caceres'),
(142, 195, 'Cadiz', 'Cadiz'),
(143, 195, 'Cantabria', 'Cantabria'),
(144, 195, 'Castellon', 'Castellon'),
(145, 195, 'Ceuta', 'Ceuta'),
(146, 195, 'Ciudad Real', 'Ciudad Real'),
(147, 195, 'Cordoba', 'Cordoba'),
(148, 195, 'Cuenca', 'Cuenca'),
(149, 195, 'Girona', 'Girona'),
(150, 195, 'Granada', 'Granada'),
(151, 195, 'Guadalajara', 'Guadalajara'),
(152, 195, 'Guipuzcoa', 'Guipuzcoa'),
(153, 195, 'Huelva', 'Huelva'),
(154, 195, 'Huesca', 'Huesca'),
(155, 195, 'Jaen', 'Jaen'),
(156, 195, 'La Rioja', 'La Rioja'),
(157, 195, 'Las Palmas', 'Las Palmas'),
(158, 195, 'Leon', 'Leon'),
(159, 195, 'Lleida', 'Lleida'),
(160, 195, 'Lugo', 'Lugo'),
(161, 195, 'Madrid', 'Madrid'),
(162, 195, 'Malaga', 'Malaga'),
(163, 195, 'Melilla', 'Melilla'),
(164, 195, 'Murcia', 'Murcia'),
(165, 195, 'Navarra', 'Navarra'),
(166, 195, 'Ourense', 'Ourense'),
(167, 195, 'Palencia', 'Palencia'),
(168, 195, 'Pontevedra', 'Pontevedra'),
(169, 195, 'Salamanca', 'Salamanca'),
(170, 195, 'Santa Cruz de Tenerife', 'Santa Cruz de Tenerife'),
(171, 195, 'Segovia', 'Segovia'),
(172, 195, 'Sevilla', 'Sevilla'),
(173, 195, 'Soria', 'Soria'),
(174, 195, 'Tarragona', 'Tarragona'),
(175, 195, 'Teruel', 'Teruel'),
(176, 195, 'Toledo', 'Toledo'),
(177, 195, 'Valencia', 'Valencia'),
(178, 195, 'Valladolid', 'Valladolid'),
(179, 195, 'Vizcaya', 'Vizcaya'),
(180, 195, 'Zamora', 'Zamora'),
(181, 195, 'Zaragoza', 'Zaragoza');

-- --------------------------------------------------------

--
-- Table structure for table `zones_to_geo_zones`
--

CREATE TABLE `zones_to_geo_zones` (
  `association_id` int(11) NOT NULL AUTO_INCREMENT,
  `zone_country_id` int(11) NOT NULL,
  `zone_id` int(11) DEFAULT NULL,
  `geo_zone_id` int(11) DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`association_id`),
  KEY `idx_zones_to_geo_zones_country_id` (`zone_country_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `zones_to_geo_zones`
--

INSERT INTO `zones_to_geo_zones` VALUES
(1, 223, 18, 1, NULL, '[[regtime]]');

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
