<?php
/**
*
* This file is part of the phpBB Forum Software package.
*
* @copyright (c) phpBB Limited <https://www.phpbb.com>
* @translated 2014 phpBBArabia.com
* 2017 Updated and maintained by Saeed Hubaishan <https://phpbb-ar.com>
* @license GNU General Public License, version 2 (GPL-2.0)
*
* For full copyright and license information, please see
* the docs/CREDITS.txt file.
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

// Board Settings
$lang = array_merge($lang, array(
	'ACP_BOARD_SETTINGS_EXPLAIN'	=> 'هنا تحدد العمليات الأساسية في منتداك، أعط منتداك اسمًا وشرحًا مناسبًا ومن ضمن إعددات أخرى حدد الاختيار الافتراضي للتوقيت واللغة',
	'BOARD_INDEX_TEXT'				=> 'نص رئيسية المنتدى',
	'BOARD_INDEX_TEXT_EXPLAIN'		=> 'هذا النص يتم عرضه كرئيسية المنتدى في ملاحة المنتدى. إذا لم يتم تحديد نص، سيتم استخدام "فهرس المنتدى" افتراضيًا.',
	'BOARD_STYLE'					=> 'استايل المنتدى',
	'CUSTOM_DATEFORMAT'				=> 'خاص…',
	'DEFAULT_DATE_FORMAT'			=> 'صيغة التاريخ',
	'DEFAULT_DATE_FORMAT_EXPLAIN'	=> 'صيغة التاريخ مثل الصيغة المستعملة من <a href="https://www.php.net/manual/datetime.format.php">دوال التاريخ</a> للغة PHP',
	'DEFAULT_LANGUAGE'				=> 'اللغة الافتراضية',
	'DEFAULT_STYLE'					=> 'هنا تحدد العمليات الأساسية في منتداك، أعط منتداك اسمًا وشرحًا مناسبًا ومن ضمن إعددات أخرى حدد الاختيار الافتراضي للتوقيت واللغة',
	'DEFAULT_STYLE_EXPLAIN'			=> 'الاستايل الافتراضي للمستخدمين الجدد.',
	'DISABLE_BOARD'					=> 'تعطيل المنتدى',
	'DISABLE_BOARD_EXPLAIN'			=> 'يغلق المنتدى ولن يكون متاحًا للمستخدمين، يمكنك أيضًا وضع رسالة أقصى عدد حروفها 255 لتبين سبب تعطيل المنتدى',
	'DISPLAY_LAST_SUBJECT'			=> 'عرض عنوان آخر مشاركة في فهرس المنتدى',
	'DISPLAY_LAST_SUBJECT_EXPLAIN'	=> 'عنوان آخر مشاركة تم وضعها سيتم عرضه في فهرس المنتدى مع رابط للمشاركة.العناوين من المنتديات المحمية بكلمة مرور أو المنتديات التي لا يملك المستخدم صلاحية القراءة بها لن يتم عرضها.',
	'DISPLAY_UNAPPROVED_POSTS'		=> 'عرض المشاركات الغير معتمدة لكُتَّابها',
	'DISPLAY_UNAPPROVED_POSTS_EXPLAIN'	=> 'تعرض المشاركات الغير معتمدة لكتابها، لتشمل مشاركات الزوار.',
	'GUEST_STYLE'					=> 'استايل الزوار',
	'GUEST_STYLE_EXPLAIN'			=> 'استايل المنتدى الذي يظهر للزوار غير المسجلين.',
	'OVERRIDE_STYLE'				=> 'تجاوز استايل المستخدم',
	'OVERRIDE_STYLE_EXPLAIN'		=> 'استبدال الاستايل المحدد في الاستايل الافتراضي بالاستايل الخاص بالمستخدمين (والزوار)',
	'SITE_DESC'						=> 'وصف الموقع',
	'SITE_HOME_TEXT'				=> 'نص الموقع الرئيسي',
	'SITE_HOME_TEXT_EXPLAIN'		=> 'هذا النص سيتم عرضه كرابط لموقعك الأصلي في ملاحة المنتدى. إذا لم يتم تحديد نص، سيتم استخدام "الرئيسية" افتراضيًا.',
	'SITE_HOME_URL'					=> 'رابط الموقع الرئيسي',
	'SITE_HOME_URL_EXPLAIN'			=> 'إذا تم تحديده، سيتم وضع رابط له في ملاحة المنتدى وسيقوم شعار المنتدى بالربط لهذا الرابط بدلًا من فهرس المنتدى. يجب وضع الرابط كاملًا، مثال <samp>http://www.phpbb.com</samp>.',
	'SITE_NAME'						=> 'اسم الموقع',
	'SYSTEM_TIMEZONE'				=> 'منطقة توقيت النظام',
	'SYSTEM_TIMEZONE_EXPLAIN'			=> 'الوقت المستخدم ليظهر لغير المسجلين ( الزوار، محركات البحث ) الأعضاء المسجلين يقومون بتعين الوقت المستخدم خلال عملية التسجيل في المنتدى ويمكنهم تغير ذلك من خلال لوحة الملف الشخصي الخاص بهم.',
	'WARNINGS_EXPIRE'				=> 'مدة التحذير',
	'WARNINGS_EXPIRE_EXPLAIN'		=> 'عدد الأيام المنقضية التي تبعد التحذير من سجلات المستخدم. اجعل هذه القيمة 0 لجعل التحذيرات دائمة.',
));

// Board Features
$lang = array_merge($lang, array(
	'ACP_BOARD_FEATURES_EXPLAIN'	=> 'من هنا يمكنك تعطيل تفعيل بعض خصائص المنتدى',

	'ALLOW_ATTACHMENTS'			=> 'اسمح بالمرفقات',
	'ALLOW_BIRTHDAYS'			=> 'السماح بعيد الميلاد',
	'ALLOW_BIRTHDAYS_EXPLAIN'	=> 'السماح بإدخال أيام الميلاد وعرض العمر في صفحة الملف الشخصي. يرجى ملاحظة أن قائمة عيد الميلاد في فهرس المنتدى تكون إدارتها بتحميل إعداد منفصل',
	'ALLOW_BOOKMARKS'			=> 'اسمح بإضافة المواضيع إلى المفضلة',
	'ALLOW_BOOKMARKS_EXPLAIN'	=> 'السماح للمستخدم بوضع وصلات خارجية في المفضلة',
	'ALLOW_BBCODE'				=> 'السماح بـ BBCode',
	'ALLOW_FORUM_NOTIFY'		=> 'السماح بالإشتراك في المنتديات',
	'ALLOW_NAME_CHANGE'			=> 'السماح بتغير اسم المستخدم',
	'ALLOW_NO_CENSORS'			=> 'السماح بتعطيل مراقبة الكلمات',
	'ALLOW_NO_CENSORS_EXPLAIN'	=> 'المستخدم يمكنه أن يعطل خاصية مراقبة الكلمات البذيئة فتعرض له فقط',
	'ALLOW_PM_ATTACHMENTS'		=> 'السماح بالمرفقات في الرسائل الخاصة',
	'ALLOW_PM_REPORT'			=> 'السماح للأعضاء بالتبليغ عن الرسائل الخاصة',
	'ALLOW_PM_REPORT_EXPLAIN'	=> 'إذا تفعّل هذا الخيار، سيمكن للأعضاء التبليغ عن أية رسائل خاصة تصلهم، وأية رسائل خاصة يبلّغ عنها ستصبح مسموحة للقراءة من الإداريين.',
	'ALLOW_QUICK_REPLY'			=> 'السماح بالرد السريع',
	'ALLOW_QUICK_REPLY_EXPLAIN'	=> 'هذا الخيار يحدد إذا كان الرد السريع متاحا أم لا. إذا تفعّل هذا الخيار، فينبغي على المنتديات أن يكون الرد السريع فيها متاحًا أيضًا.',
	'ALLOW_QUICK_REPLY_BUTTON'	=> 'تفعيل الرد السريع لجميع المنتديات',
	'ALLOW_SIG'					=> 'السماح بالتواقيع',
	'ALLOW_SIG_BBCODE'			=> 'السماح بشفرة BBCode في التواقيع',
	'ALLOW_SIG_FLASH'			=> '<code>[FLASH]</code> السماح بكود الفلاش في التواقيع',
	'ALLOW_SIG_IMG'				=> '<code>[IMG]</code> السماح بكود الصور في التواقيع',
	'ALLOW_SIG_LINKS'			=> 'السماح بوضع وصلات في التواقيع',
	'ALLOW_SIG_LINKS_EXPLAIN'	=> ' <code>[URL]</code> إذا منع لن يُستطاع الضغط على الوصلة لكن يمكن نسخها ولصقها لشريط العناوين',
	'ALLOW_SIG_SMILIES'			=> 'السماح باستعمال الابتسامات في التواقيع',
	'ALLOW_SMILIES'				=> 'السماح بالابتسامات',
	'ALLOW_TOPIC_NOTIFY'		=> 'السماح بمتابعة المواضيع',
	'BOARD_PM'					=> 'الرسائل الخاصة',
	'BOARD_PM_EXPLAIN'			=> 'تعطيل أو تفعيل الرسائل الخاصة لكل المستخدمين',
	'ALLOW_BOARD_NOTIFICATIONS' => 'السماح بإشعارات المنتدى',
));

// Avatar Settings
$lang = array_merge($lang, array(
	'ACP_AVATAR_SETTINGS_EXPLAIN'	=> 'الصور الرمزية في الغالب صغيرة يمكن للمستخدم أن يربطها بعضويته، على حسب التنيسق المستخدم في الغالب تعرض الصور تحت اسم المستخدم عند عرض الموضوع، هنا تستطيع تحديد هذه الصور الرمزية، الرجاء الانتباه إلى أنك إذا أردت أن يرفع المستخدمون صورا رمزية من جهازهم عليك أن تنشئ ملف مسمى في الأسفل وتتأكد من إعطائه الترخيص اللازم للسماح لخادم الشبكة بالكتابة فيه. أيضًا نحب أن نلفت انتباهك إلى أن تحديد حجم الصور الرمزية يكون على الصورة المحملة على خادم المنتدى ولا يكون على الصور ذات الوصلات الخارجية',

	'ALLOW_AVATARS'					=> 'تفعيل الصور الرمزية',
	'ALLOW_AVATARS_EXPLAIN'			=> 'السماح بالاستخدام العام للصور الرمزية؛<br>إذا ألغيت تفعيل الصور الرمزية بشكل عام أو بمود بمعين، فإن الصور الرمزية الملغاة التفعيل لن تظهر في المنتدى، لكن سيبقى للأعضاء إمكانية تحميل صورهم الرمزية من لوحة التحكم الخاصة بهم.',
	'ALLOW_GRAVATAR'				=> 'تفعيل الصور الرمزية  gravatar',
	'ALLOW_LOCAL'					=> 'تفعيل معرض الصور الرمزية',
	'ALLOW_REMOTE'					=> 'السماح بوصلات الصور الرمزية',
	'ALLOW_REMOTE_EXPLAIN'			=> 'صور رمزية مرتبطة بموقع آخر<br><em><strong class="error">تحذير:</strong> تفعيل هذه الميزة ربما يمكن المستخدمين من تفحص تواجد الملفات والخدمات التي بإمكان الوصول إليها في الخادم المحلي فقط.</em>',
	'ALLOW_REMOTE_UPLOAD'			=> 'تفعيل التحميل الخارجي للصور الرمزية',
	'ALLOW_REMOTE_UPLOAD_EXPLAIN'	=> 'تفعيل تحميل الصور الرمزية من مواقع أخرى.<br><em><strong class="error">تحذير:</strong> تفعيل هذه الميزة ربما يمكن المستخدمين من تفحص تواجد الملفات والخدمات التي بإمكان الوصول إليها في الخادم المحلي فقط.</em>',
	'ALLOW_UPLOAD'					=> 'السماح برفع الصور الرمزية',
	'AVATAR_GALLERY_PATH'			=> 'مسار معرض الصور الرمزية',
	'AVATAR_GALLERY_PATH_EXPLAIN'	=> 'مسار تحت مسار المنتدى إلى معرض الصور الرمزية المحملة مسبقًا مثال <samp>images/avatars/gallery</samp>.<br>النقاط المزدوجة كهذه <samp>..</samp> سوف تحذف من المسار لأسباب أمنية',
	'AVATAR_STORAGE_PATH'			=> 'مسار تخزين الصور الرمزية',
	'AVATAR_STORAGE_PATH_EXPLAIN'	=> 'مسار تحت مسار المنتدى مثال <samp>images/avatars/upload</samp>.<br>سيكون تحميل الصور الرمزية <strong>معطلًا</strong> إذا كان المسار غير قابل للكتابة.<br>النقاط المزدوجة كهذه <samp>..</samp> سوف تحذف من المسار لأسباب أمنية',
	'MAX_AVATAR_SIZE'				=> 'أقصى الأبعاد للصور الرمزية',
	'MAX_AVATAR_SIZE_EXPLAIN'		=> 'الارتفاع × العرض بالبكسل',
	'MAX_FILESIZE'					=> 'أقصى حجم لملف الصورة الرمزية',
	'MAX_FILESIZE_EXPLAIN'			=> 'للصور الرمزية التي سترفع على خادم المنتدى. إذا كانت القيمة 0، فإن حجم الملف سيكون محدودا فقط بإعدادات PHP لديك.',
	'MIN_AVATAR_SIZE'				=> 'أدنى الأبعاد للصور الرمزية',
	'MIN_AVATAR_SIZE_EXPLAIN'		=> 'الارتفاع × العرض بالبكسل',
));

// Message Settings
$lang = array_merge($lang, array(
	'ACP_MESSAGE_SETTINGS_EXPLAIN'		=> 'هنا يمكنك وضع الإعدادت الافتراضية للرسائل الخاصة',

	'ALLOW_BBCODE_PM'			=> 'السماح بـ BBCode في الرسائل الخاصة',
	'ALLOW_FLASH_PM'			=> 'السماح بكود الفلاش في الرسال الخاصة <code>[FLASH]</code>',
	'ALLOW_FLASH_PM_EXPLAIN'	=> 'لاحظ أن تمكين استخدام الفلاش في الرسائل الخاصه يعتمد ايضًا على الصلاحيات',
	'ALLOW_FORWARD_PM'			=> 'السماح بتقديم الرسائل الخاصة',
	'ALLOW_IMG_PM'				=> 'السماح بكود الصور في الرسائل الخاصة <code>[IMG]</code>',
	'ALLOW_MASS_PM'				=> 'السماح بإرسال الرسائل الخاصة لأكثر من عضو أو مجموعة',
	'ALLOW_MASS_PM_EXPLAIN'		=> 'إرسال للمجموعات، يمكن ضبط الخصائص لكل مجموعة على إحدى من صفحة اعدادت المجموعات',
	'ALLOW_PRINT_PM'			=> 'السماح بعرض الطباعة في الرسائل الخاصة',
	'ALLOW_QUOTE_PM'			=> 'السماح بالاقتباس في الرسائل الخاصة',
	'ALLOW_SIG_PM'				=> 'السماح بالتواقيع في الرسائل الخاصة',
	'ALLOW_SMILIES_PM'			=> 'السماح بالابتسامات في الرسائل الخاصة',
	'BOXES_LIMIT'				=> 'أقصى حد من الرسائل في صندوق الرسائل الخاصة',
	'BOXES_LIMIT_EXPLAIN'		=> 'المستخدم لن يستطيع استقبال أي رسائل فوق العدد المحدد. ضع صفر 0 إذا أردت ألا يكون هناك عدد معين',
	'BOXES_MAX'					=> 'أقصى عدد لمجلدات الرسائل الخاصة',
	'BOXES_MAX_EXPLAIN'			=> 'الإعدادت الافتراضية تسمح للمستخدم بعمل مجلدات في الرسائل الخاصة لوضع الرسائل فيها',
	'ENABLE_PM_ICONS'			=> 'السماح باستخدام رموز المواضيع في الرسائل الخاصة',
	'FULL_FOLDER_ACTION'		=> 'الفعل الافتراضي للمجلدات الممتلئة',
	'FULL_FOLDER_ACTION_EXPLAIN'=> 'الفعل الافتراضي إذا امتلأ مجلد المستخدم، إذا كانت خيارات فعل المستخدم غير مطبقة، هذا إذا كان لديه فعل محدد. الاستثناء الوحيد في "الرسائل المرسلة" حيث الخيار الافتراضي هو إلغاء الأقدم',
	'HOLD_NEW_MESSAGES'			=> 'أوقف الرسائل الجديدة',
	'PM_EDIT_TIME'				=> 'حصر وقت التعديل',
	'PM_EDIT_TIME_EXPLAIN'		=> 'تحديد الوقت للرسائل الخاصة التي لم تصل إلى الجهة المعنية. القيمة 0 صفر تعطل هذا التصرف',
	'PM_MAX_RECIPIENTS'			=> 'الحد الاعلى للمستلمين',
	'PM_MAX_RECIPIENTS_EXPLAIN'	=> 'الحد الاعلى لسماح المستقبلين في الرسائل الخاصة، اذا عينت 0 ستكون غير محدده، يمكن تحديد هذه الخاصيه لكل مجموعه على حدى من صفحة خصائص المجموعات',
));

// Post Settings
$lang = array_merge($lang, array(
	'ACP_POST_SETTINGS_EXPLAIN'			=> 'هنا يمكنك تحديد الافتراضيات للمشاركات',
	'ALLOW_POST_LINKS'					=> 'السماح بالوصلات في المشاركات والرسائل الخاصة',
	'ALLOW_POST_LINKS_EXPLAIN'			=> 'إذا منع سيتعطل كود <code>[URL]</code> ولن يتمكن من الضغط المباشر على الوصلة',
	'ALLOWED_SCHEMES_LINKS'				=> 'المخططات مسموح بها في الارتباطات',
	'ALLOWED_SCHEMES_LINKS_EXPLAIN'		=> 'يستطيع المستخدمون إرسال روابط بدون مخطط أو واحدًا من القائمة المخططات المفصولة بفاصلة.',
	'ALLOW_POST_FLASH'					=> 'السماح باستخدام <code>[FLASH]</code> BBCode في المشاركات',
	'ALLOW_POST_FLASH_EXPLAIN'			=> 'إذا منعت استخدام <code>[FLASH]</code> BBCode فسيمنع عرض الفلاش في المشاركات. وفي الأحوال الأخرى سيخضع هذا الأمر لصلاحيات الأعضاء المضبوطة يدويا',

	'BUMP_INTERVAL'					=> 'فترة الرفع',
	'BUMP_INTERVAL_EXPLAIN'			=> 'عدد الدقائق، الساعات أو الأيام بين آخر مشاركة في الموضوع وبين إمكانية رفعه إلى أعلى قائمة المواضيع. ضع القيمة 0 لتعطيل ميزة رفع المواضيع.',
	'CHAR_LIMIT'					=> 'أقصى عدد للحروف في المشاركة',
	'CHAR_LIMIT_EXPLAIN'			=> 'أقصى عدد للحروف في المشاركة. ضع القيمة صفر 0 لجعل الحد الاقصى لا نهائي',
	'DELETE_TIME'					=> 'تحديد وقت الحذف',
	'DELETE_TIME_EXPLAIN'			=> 'تحديد الوقت المتاح لإمكانية حذف المشاركة. ضع 0 لتعطيل هذه الميزة.',
	'DISPLAY_LAST_EDITED'			=> 'عرض معلومات وقت آخر تعديل',
	'DISPLAY_LAST_EDITED_EXPLAIN'	=> 'اختر إذا أردت عرض " آخر مشاركة من قبل" في صفحة المواضيع',
	'EDIT_TIME'						=> 'تحديد وقت التعديل',
	'EDIT_TIME_EXPLAIN'				=> 'يحدد الوقت المسموح به لتعديل المشاركات. القيمة صفر تعطل هذه الخاصية',
	'FLOOD_INTERVAL'				=> 'فترة الإغراق',
	'FLOOD_INTERVAL_EXPLAIN'		=> 'عدد الثواني التي ينبغي انتظارها بين المشاركة والمشاركة الجديدة. للسماح للمستخدمين لتجاهل هذه الخاصية عدل صلاحياتهم',
	'HOT_THRESHOLD'					=> 'بوابة المواضيع النشيطة',
	'HOT_THRESHOLD_EXPLAIN'			=> 'عدد المشاركات في الموضوع التي تؤهله لدخول بوابة المواضيع النشيطة',
	'MAX_POLL_OPTIONS'				=> 'أقصى عدد لخيارات الاستطلاع',
	'MAX_POST_FONT_SIZE'			=> 'أقصى حجم لخط المشاركة',
	'MAX_POST_FONT_SIZE_EXPLAIN'	=> 'الحجم الأقصى للخطوط في المشاركة. عدل القيمة لصفر لجعل حجم الخط بدون حد',
	'MAX_POST_IMG_HEIGHT'			=> 'أقصى ارتفاع للفلاش بالمشاركات',
	'MAX_POST_IMG_HEIGHT_EXPLAIN'	=> 'الحد الأقصى لارتفاع ملف الفلاش في المشاركات. القيمة 0 تعنى أنه لا يوجد حد',
	'MAX_POST_IMG_WIDTH'			=> 'أقصى عرض للفلاش بالمشاركات',
	'MAX_POST_IMG_WIDTH_EXPLAIN'	=> 'الحد الأقصى لعرض ملف الفلاش في المشاركات. القيمة 0 تعنى أنه لا يوجد حد',
	'MAX_POST_URLS'					=> 'أقصى حد للوصلات',
	'MAX_POST_URLS_EXPLAIN'			=> 'أقصى حد للوصلات. ضع القيمة صفر لجعل الحد لا نهائي',
	'MIN_CHAR_LIMIT'				=> 'عدد الأحرف الأدنى في الرسالة أو المشاركة',
	'MIN_CHAR_LIMIT_EXPLAIN'		=> 'العدد الأدنى من الحروف كي يتمكن العضو من إرسال الرسالة أو المشاركة. أقل عدد يمكن وضعه هو 1.',
	'POSTING'						=> 'مشاركة',
	'POSTS_PER_PAGE'				=> 'المشاركات بالصفحة',
	'QUOTE_DEPTH_LIMIT'				=> 'أقصى عدد للاقتباسات في المشاركة',
	'QUOTE_DEPTH_LIMIT_EXPLAIN'		=> 'يمكن للمستخدم اقتباس تشعبي حدد عدد تشعب الاقتباس الواحد. ضع القيمة صفر لجعل الاقتباس لا نهائي',
	'SMILIES_LIMIT'					=> 'أقصى عدد للابتسامات في المشاركة',
	'SMILIES_LIMIT_EXPLAIN'			=> 'الحد الأقصى للابتسامات في المشاركة. ضع 0 لجعل الحد الأقصى لا نهائي',
	'SMILIES_PER_PAGE'				=> 'الابتسامات لكل صفحة',
	'TOPICS_PER_PAGE'				=> 'المواضيع بالصفحة',
));

// Signature Settings
$lang = array_merge($lang, array(
	'ACP_SIGNATURE_SETTINGS_EXPLAIN'	=> 'هنا يمكنك تحديد الإعدادت الافتراضية لتواقيع الأعضاء',

	'MAX_SIG_FONT_SIZE'				=> 'أكبر حجم للحروف',
	'MAX_SIG_FONT_SIZE_EXPLAIN'		=> 'لحد أكبر حجم للخطوط في التوقيع. ضع القيمة صفر 0 لجعل الحد لا نهائي',
	'MAX_SIG_IMG_HEIGHT'			=> 'الطول الأقصى للصور',
	'MAX_SIG_IMG_HEIGHT_EXPLAIN'	=> 'أقصى طول للصور أو الفلاشات التي يدرجها المستخدم في توقيعه ضع القيمة صفر 0 لجعل الحد لا نهائي',
	'MAX_SIG_IMG_WIDTH'				=> 'العرض الأقصى للصورة',
	'MAX_SIG_IMG_WIDTH_EXPLAIN'		=> 'أقصى عرض للصور أو الفلاشات التي يدرجها المستخدم في توقيعه ضع القيمة صفر 0 لجعل الحد لا نهائي',
	'MAX_SIG_LENGTH'				=> 'أقصى طول للتوقيع',
	'MAX_SIG_LENGTH_EXPLAIN'		=> 'الحد الأقصى للحروف المستخدمة بالتوقيع',
	'MAX_SIG_SMILIES'				=> 'أقصى حد للابتسامات',
	'MAX_SIG_SMILIES_EXPLAIN'		=> 'الحد الأقصى للابتسامات في مشاركة الأعضاء',
	'MAX_SIG_URLS'					=> 'أقصى حد للوصلات',
	'MAX_SIG_URLS_EXPLAIN'			=> 'أقصى حد للوصلات التي يمكن للمستخدم إضافتها في التوقيع. القيمة صفر 0 تعنى لا نهائي',
));

// Registration Settings
$lang = array_merge($lang, array(
	'ACP_REGISTER_SETTINGS_EXPLAIN'		=> 'هنا يمكنك تعريف إعدادات ومتعلقات التسجيل والملف الشخصي',

	'ACC_ACTIVATION'				=> 'تفعيل الحساب',
	'ACC_ACTIVATION_EXPLAIN'		=> 'هنا تحدد إذا كان المشاركة يستطيع أن يشارك بالمنتدى فور التسجيل أو يتطلب من المدير الموافقة على تسجيله قبل مشاركته أو أن تبعث رسالة إلى بريد المشترك مع وصلة تفعيل للتأكد من صحة البريد أو تعطيل التسجيل كليًا. <em>يجب تفعيل خاصية المراسلة عن طريق المنتدى لاستخدام التفعيل عن الطريق العضو أو المدير</em>.',
	'ACC_ACTIVATION_WARNING'		=> 'يرجى ملاحظة أن الطريقة المحددة حاليًا للتفعيل تتطلب تفعيل المراسلات، غير ذلك سيتم تعطيل التسجيل. ننصح إما باختيار طريقة مختلفة للتفعيل أو إعادة تفعيل المراسلات البريدية.',
	'NEW_MEMBER_POST_LIMIT'			=> 'تحديد عدد مشاركة العضو الجديد',
	'NEW_MEMBER_POST_LIMIT_EXPLAIN'	=> 'الأعضاء المُسجلين الجُدد سيكونوا ضمن مجموعة <em>الأعضاء المسجلين الجًدد</em> حتى يصل عدد مشاركاتهم إلى هذا العدد. تستطيع استخدام هذه المجموعة لاستبعادهم من استخدام الرسائل الخاصة أو مُراجعة نشاط مشاركاتهم. <strong>القيمة صفر ستعطل هذه الخاصية.</strong>',
	'NEW_MEMBER_GROUP_DEFAULT'		=> 'ضبط مجموعة الأعضاء المسجلين الجًدد إلى الإعدادات الإفتراضية',
	'NEW_MEMBER_GROUP_DEFAULT_EXPLAIN'	=> 'إذا اخترت "نعم" وتحديد عدد مشاركات العضو الجديد، سيضاف الأعضاء المُسجلين الجُدد إلى مجموعة <em>الأعضاء المسجلين الجًدد</em> وستكون هذه المجموعة هي المجموعة الافتراضية لهم. وعند تحديد رُتبة أو صورة رمزية إفتراضية مُخصصة لهذه المجموعة، سيتم ضبطها إفتراضيًا على أعضاء هذه المجموعة.',

	'ACC_ADMIN'					=> 'بواسطة مدير',
	'ACC_DISABLE'				=> 'تعطيل التسجيل',
	'ACC_NONE'					=> 'بدون تفعيل (المشاركة الفورية)',
	'ACC_USER'					=> 'بواسطة العضو (عن طريق البريد)',
//	'ACC_USER_ADMIN'			=> 'User + Admin',
	'ALLOW_EMAIL_REUSE'			=> 'السماح باستخدام البريد أكثر من مرة',
	'ALLOW_EMAIL_REUSE_EXPLAIN'	=> 'أكثر من مستخدم يمكنهم استخدام بريد واحد',
	'COPPA'						=> 'القاصرين (COPPA)',
	'COPPA_FAX'					=> 'رقم فاكس القاصرين',
	'COPPA_MAIL'				=> 'عنوان بريد القاصرين',
	'COPPA_MAIL_EXPLAIN'		=> 'هذا هو العنوان الذي سيبعث ولي أمر القاصر (أقل من 13 سنة) رسالة الموافقة لمشاركة القاصر بالمنتدى',
	'ENABLE_COPPA'				=> 'تفعيل نظام القاصر',
	'ENABLE_COPPA_EXPLAIN'		=> 'تفعيل نظام القاصر يطلب من المستخدم التعريف بأن عمره أكبر من 13 سنة إذا كان عمر المستخدم أقل من 13 سنة يتطلب حسب القانون الأمريكي للقاصرين أن يوافق ولي الأمر على مشاركة القاصر. عند تعطيل هذه الخاصية لن يطلب من المستخدم التعريف بعمره وستتجاوز هذه المرحلة بالتسجيل',
	'MAX_CHARS'					=> 'أقصى',
	'MIN_CHARS'					=> 'أقل',
	'NO_AUTH_PLUGIN'			=> 'لم يتم العثور على إضافات مناسبة',
	'PASSWORD_LENGTH'			=> 'طول كلمة المرور',
	'PASSWORD_LENGTH_EXPLAIN'	=> 'أقصى وأدنى عدد للحروف في كلمة المرور',
	'REG_LIMIT'					=> 'محاولات التسجيل',
	'REG_LIMIT_EXPLAIN'			=> 'المحاولات التي يقدم عليها المستخدم لتسجيل الدخول بعد مشاهدة الصورة الأمنية',
	'USERNAME_ALPHA_ONLY'		=> 'أرقام وحروف فقط',
	'USERNAME_ALPHA_SPACERS'	=> 'أرقام وحروف ومسافة',
	'USERNAME_ASCII'			=> 'ASCII (بدون ترميزات دولية)',
	'USERNAME_LETTER_NUM'		=> 'أي حروف أو أرقام',
	'USERNAME_LETTER_NUM_SPACERS'	=> 'أي حروف أو أرقام أو مساحات',
	'USERNAME_CHARS'			=> 'تحديد حروف اسم المستخدم',
	'USERNAME_CHARS_ANY'		=> 'بدون تحديد',
	'USERNAME_CHARS_EXPLAIN'	=> 'تحديد الحروف المسموح بها في اسم المستخدم، المسافات هي: المسافة و - و + و _ و [ و ]',
	'USERNAME_LENGTH'			=> 'طول اسم المستخدم',
	'USERNAME_LENGTH_EXPLAIN'	=> 'الحد الأقصى والأدنى للحروف المستخدمة في اسم المستخدم',
));

// Feeds
$lang = array_merge($lang, array(
	'ACP_FEED_MANAGEMENT'				=> 'إدارة الإعدادات العامة لتغذية البيانات',
	'ACP_FEED_MANAGEMENT_EXPLAIN'		=> 'هذا الموديل يجعل تغذية ATOM متوفرة وكثيرة، ويعرب أي BBCode في المشاركات لجعلها قابلة للقراءة للتغذيات الخارجية.',

	'ACP_FEED_GENERAL'					=> 'الإعدادت العامة',
	'ACP_FEED_POST_BASED'				=> 'إعدادات التغذية للردود',
	'ACP_FEED_TOPIC_BASED'				=> 'إعدادات التغذية للمواضيع',
	'ACP_FEED_SETTINGS_OTHER'			=> 'إعدادات التغذية الأخرى',

	'ACP_FEED_ENABLE'					=> 'تفعيل تغذية البيانات',
	'ACP_FEED_ENABLE_EXPLAIN'			=> 'تفعيل أو تعطيل تغذية ATOM لكُل المنتدى.<br>تعطيل هذه الخاصية لكُل التغذية، لايؤخذ في الاعتبار ضبط الخيارات أدناه.',
	'ACP_FEED_LIMIT'					=> 'عدد العناصر',
	'ACP_FEED_LIMIT_EXPLAIN'			=> 'العدد الأقصى لعناصر تغذية البيانات لعرضها.',

	'ACP_FEED_OVERALL'					=> 'تمكين التغذية للمنتدى بشكل شامل',
	'ACP_FEED_OVERALL_EXPLAIN'			=> 'تمكين التغذية للمواضيع الجديدة بشكل شامل',
	'ACP_FEED_FORUM'					=> 'تفعيل تغذية البيانات لكل منتدى',
	'ACP_FEED_FORUM_EXPLAIN'			=> 'المشاركات الجديدة لمنتدى واحد.',
	'ACP_FEED_TOPIC'					=> 'تفعيل تغذية البيانات لكل موضوع',
	'ACP_FEED_TOPIC_EXPLAIN'			=> 'المشاركات الجديدة لموضوع واحد.',

	'ACP_FEED_TOPICS_NEW'				=> 'تمكين تغذية المواضيع الجديدة',
	'ACP_FEED_TOPICS_NEW_EXPLAIN'		=> 'تمكين تغذية " المواضيع الجديدة " سيظهر آخر المواضيع الجديدة بالإضافة لأول مشاركة من الموضوع',
	'ACP_FEED_TOPICS_ACTIVE'			=> 'تمكين تغذية المواضيع النشطة',
	'ACP_FEED_TOPICS_ACTIVE_EXPLAIN'	=> 'تمكين تغذية " المواضيع النشطة " سيظهر آخر المواضيع النشطة بالإضافة لآخر الردود',
	'ACP_FEED_NEWS'						=> 'أخبار تغذية البيانات',
	'ACP_FEED_NEWS_EXPLAIN'				=> 'استدعي المشاركة الأولى من هذه المنتديات. اختار " لا منتديات " لتعطيل خاصية التغذية الأخبارية. <br> لتحديد أكثر من منتدى، إضغط باستمرار مُفتاح <samp>CTRL</samp> والنقر على المنتديات المطلوبة.',

	'ACP_FEED_OVERALL_FORUMS'			=> 'تفعيل تغذية البيانات لجميع المنتديات',
	'ACP_FEED_OVERALL_FORUMS_EXPLAIN'	=> 'هذه التغذية تُظهر أحدث المُشاركات لمواضيع المنتديات جميعها .',

	'ACP_FEED_HTTP_AUTH'				=> 'تمكين مصادقة HTTP',
	'ACP_FEED_HTTP_AUTH_EXPLAIN'		=> 'تمكين المصادقة بواسطة HTTP، سيمكن المستخدمين من استقبال محتوى هو مخفي عن الزوار بإضافة <samp>auth=http</samp> على رابط التغذية. من فضلك لاحظ أن بعض اعدادت PHP مطلوبة على ملف .htaccess. يمكن معرفة المزيد من خلال الاطلاع على الملف .',
	'ACP_FEED_ITEM_STATISTICS'			=> 'إحصائيات العنصر',
	'ACP_FEED_ITEM_STATISTICS_EXPLAIN'	=> 'إظهار الإحصائيات المُحددة أسفل عناصر التغذية <br>( بواسطة، وقت وتاريخ، الردود، المشاهدات )',
	'ACP_FEED_EXCLUDE_ID'				=> 'استبعاد هذه المنتديات',
	'ACP_FEED_EXCLUDE_ID_EXPLAIN'		=> 'المُحتوى من هذه <strong> لن تظهر في التغذية</strong>. اختار " لا منتديات " لاستدعاء البيانات من المنتديات جميعها. <br> لتحديد/عدم تحديد أكثر من منتدى، إضغط باستمرار مُفتاح <samp>CTRL</samp> والنقر على المنتديات المطلوبة.',
));

// Visual Confirmation Settings
$lang = array_merge($lang, array(
	'ACP_VC_SETTINGS_EXPLAIN'				=> 'عند تسجيل المستخدم يقوم نظام الكابتشا بعرض صورة فيها نصوص يصعب على الحاسب قراءتها ولكن يسهل للبشر قراءتها. هذه العملية مقدمة للتأكد من أن المسجل هو إنسان وليس برنامج إزعاج يقوم بعمليات تسجيل كثيرة',
	'ACP_VC_EXT_GET_MORE'					=> 'للمزيد (وربما أفضل) من إضافات منع السبام، قم بزيارة <a href="https://www.phpbb.com/go/anti-spam-ext"><strong>قاعدة بيانات إضافات phpBB.com</strong></a>. للمزيد من المعلومات حول الحماية من السبام على منتداك، قم بزيارة <a href="https://www.phpbb.com/go/anti-spam"><strong>قاعدة معلومات phpBB.com</strong></a>.',
	'AVAILABLE_CAPTCHAS'					=> 'إضافات مُتوفرة',
	'CAPTCHA_UNAVAILABLE'					=> 'لا يمكن اختيار الكابتشا، فمتطلباته لا تتوافق.',
	'CAPTCHA_GD'							=> 'كابتشا GD',
	'CAPTCHA_GD_3D'							=> 'كابتشا GD ثلاثي الأبعاد',
	'CAPTCHA_GD_FOREGROUND_NOISE'			=> 'GD CAPTCHA درجة الإزعاج الأمامية',
	'CAPTCHA_GD_EXPLAIN'					=> 'استعمل (CAPTCHA) لتحسين نظام (GD) للتاكد',
	'CAPTCHA_GD_FOREGROUND_NOISE_EXPLAIN'	=> 'الإزعاج الأمامي يصعب عملية القراءة على برامج التسجيل المزعجة',
	'CAPTCHA_GD_X_GRID'						=> 'الإزعاج في خط العرض لنظام GD CAPTCHA',
	'CAPTCHA_GD_X_GRID_EXPLAIN'				=> 'استعمل قيمة أقل لتصعيب العملية. القيمة صفر تعطل عملية الإزعاج في خط العرض',
	'CAPTCHA_GD_Y_GRID'						=> 'الإزعاج في خط الطول GD CAPTCHA',
	'CAPTCHA_GD_Y_GRID_EXPLAIN'				=> 'استعمل قيمة أقل لتصعيب العملية. القيمة صفر تعطل عملية الإزعاج في خط الطول',
	'CAPTCHA_GD_WAVE'						=> 'GD CAPTCHA تشويش الخطوط',
	'CAPTCHA_GD_WAVE_EXPLAIN'				=> 'تطبيق درجة التشويش على الـ CAPTCHA.',
	'CAPTCHA_GD_3D_NOISE'					=> 'اضافة كائن ثلاثي الابعاد',
	'CAPTCHA_GD_3D_NOISE_EXPLAIN'			=> 'يضيف هذا الخيار كائن ثلاثي الابعاد الخاص بالـ CAPTCHA وذلك فوق الحروف',
	'CAPTCHA_GD_FONTS'						=> 'استخدام خط آخر',
	'CAPTCHA_GD_FONTS_EXPLAIN'				=> 'هذا الخيار سيسمح لك بالتحكم في عدد أشكال الحروف المستخدمة، يمكنك اختيار الشكل الافتراضي أو إدخال تغير على ذلك، الحروف الصغيره مسموحة ايضًا',
	'CAPTCHA_FONT_DEFAULT'					=> 'افتراضي',
	'CAPTCHA_FONT_NEW'						=> 'شكل جديد',
	'CAPTCHA_FONT_LOWER'					=> 'ايضًا حروف صغيرة',
	'CAPTCHA_NO_GD'							=> 'كابتشا بدون GD',
	'CAPTCHA_PREVIEW_MSG'					=> 'لم تحفَظ إعدادتك، هذه فقط معاينة، بعد الحصول على حالة مقبولة تأكد من حفظ الإعدادات',
	'CAPTCHA_PREVIEW_EXPLAIN'				=> 'CAPTCHA كما ستظهر باستعمال هذه الإعدادت الحالية اضغط على زر المعاينة لتحديث الصورة. انتبه إلى أن الصورة تتغير عند كل معاينة',

	'CAPTCHA_SELECT'						=> 'تثبيت إضافات نظام الكابتشا CAPTCHA',
	'CAPTCHA_SELECT_EXPLAIN'				=> 'القائمة المُنسدلة تحتوي على إضافات الكابتشا CAPTCHA المُعرفة بواسطة المنتدى. المداخل باللون الرمادي غير متوفرة حاليًا وبحاجة إلى تهئية قبل الإستخدام.',
	'CAPTCHA_CONFIGURE'						=> 'تهيئة نظام الكابتشا CAPTCHA',
	'CAPTCHA_CONFIGURE_EXPLAIN'				=> 'تغيير الإعدادت لنظام الكابتشا CAPTCHA المُحددة.',
	'CONFIGURE'								=> 'تهئية وإعداد',
	'CAPTCHA_NO_OPTIONS'					=> 'لا يملك هذا الكابتشا CAPTCHA خيارات التهيئة.',

	'VISUAL_CONFIRM_POST'					=> 'تفعيل خاصية CAPTCHA لمشاركات الزوار',
	'VISUAL_CONFIRM_POST_EXPLAIN'			=> 'إذا سمحت للأعضاء الغير مسجلين (الزوار) بالمشاركة سيتطلب منهم كتابة رمز أمني عند تقديم مشاركة',
	'VISUAL_CONFIRM_REG'					=> 'تقعيل خاصية CAPTCHA في التسجيل',
	'VISUAL_CONFIRM_REG_EXPLAIN'			=> 'يطلب من المسجلين الجدد كتابة الرمز الأمني من CAPTCHA لتجنب التسجيل الآلي المتكرر',
	'VISUAL_CONFIRM_REFRESH'				=> 'السماح للمستخدمين بتحديث صورة التأكيد البصري',
	'VISUAL_CONFIRM_REFRESH_EXPLAIN'		=> 'السماح للمستخدمين بطلب صورة تأكيد بصرية جديده، ذلك عند عدم قدرتهم على حل أو قراءة الحروف/الرموز داخل الصورة',
));

// Cookie Settings
$lang = array_merge($lang, array(
	'ACP_COOKIE_SETTINGS_EXPLAIN'		=> 'التفاصيل هنا تضبط البيانات التي تستعمل لإرسال الكعكات (الكوكيز) إلى متصفح المستخدم. الإعدادت الافتراضية تفي بالغرض في أغلب الأحوال . لكن إذا أردت أن تقوم بتعديلات اعملها بحذر. الإعدادت الخاطئة قد تمنع المستخدمين من تسجيل الدخول،  إذا كان لديك مشاكل عن أعضاء لا يزالون مسجلي الدخول زُر <strong><a href="https://www.phpbb.com/support/go/cookie-settings">phpBB.com قاعدة معلومات - إصلاح إعدادات كوكي غير سليمة (بالإنجليزية(</a></strong>',

	'COOKIE_DOMAIN'				=> 'نطاق الكعكات (الكوكيز)',
	'COOKIE_DOMAIN_EXPLAIN'		=> 'في معظم الأحوال نطاق الكعكات (الكوكيز) اختياري، اتركه فارغا إذا كنت غير متأكد.<br><br> في حالة إذا كان المنتدى مندمجا مع برامج أخرى أو كان لديه أكثر من نطاق فلكي تعرف نطاق الكعكات افعل الآتي: إذا كان لديك مثلا <i>example.com</i> و <i>forums.example.com</i>، أو <i>forums.example.com</i> و <i>blog.example.com</i>. أزل النطاقات الفرعية حتى يبقى النطاق المشترك <i>example.com</i>.أضف الآن نقطة في بداية النطاق المشترك في مثالنا .example.com (لاحظ النقطة في البداية).',
	'COOKIE_NAME'				=> 'اسم الكعكات (الكوكيز)',
	'COOKIE_NAME_EXPLAIN'		=> 'هذا يمكن أن يكون أي شيء تريده، اجعله أصيلًا، وعندما يتم تتغير إعدادات الكعكات (الكوكيز) فإنه يجب تغيير الاسم.',
	'COOKIE_NOTICE'				=> 'تنبيه الكعكات (الكوكيز)',
	'COOKIE_NOTICE_EXPLAIN'		=> 'عند التفعيل فإن تنبيهًا بالكوكي سوف يظهر للمستخدمين عند زيارة منتداك، ربما يكون هذا الأمر مطلوب قانونيًا اعتمادًا على محتويات منتداك والإضافات المفعلة.',
	'COOKIE_PATH'				=> 'مسار الكعكات (الكوكيز)',
	'COOKIE_PATH_EXPLAIN'		=> 'لاحظ أنها دائمًا شرطة مائلة بغض النظر عن مسار منتداك.',
	'COOKIE_SECURE'				=> 'كعكات (كوكيز) آمنة',
	'COOKIE_SECURE_EXPLAIN'		=> 'إذا كان خادم الموقع لديك يعمل في الوضع الآمن حوّل هذا الخيار إلى فعال وإلا عطل هذا الخيار. إذا قمت بتفعيل هذا الخيار بدون وجود الوضع الآمن ssl سيسبب لك مشاكل عند التحويلات',
	'ONLINE_LENGTH'				=> 'فترة حساب (الموجودون الآن)',
	'ONLINE_LENGTH_EXPLAIN'		=> 'عدد الدقائق التي تمسح الأعضاء من قائمة "الموجودون الآن" بعد انعدام فعاليته بالمنتدى.  إذا كان الرقم أكبر سيكثر عدد الموجودين في فهرس المنتدى',
	'SESSION_LENGTH'			=> 'طول الجلسة',
	'SESSION_LENGTH_EXPLAIN'	=> 'بعد أن يسجل المستخدم تسجيل الدخول وتبدأ الجلسة ستنتهي الجلسة بعد هذا الوقت المحدد',
));

// Contact Settings
$lang = array_merge($lang, array(
	'ACP_CONTACT_SETTINGS_EXPLAIN'		=> 'من هنا يمكنك تفعيل وتعطيل صفحة اتصل بنا وأيضًا إضافة نص ليظهر في الصفحة.',

	'CONTACT_US_ENABLE'				=> 'تفعيل صفحة اتصل بنا',
	'CONTACT_US_ENABLE_EXPLAIN'		=> 'هذه الصفحة تسمح للمستخدمين بإرسال بريد للإدارة، لاحظ أن عليك تفعيل خيار المراسلات البريدية، الذي يوجد في عام &gt; اتصالات العملاء &gt; إعدادات البريد الإلكتروني',

	'CONTACT_US_INFO'				=> 'معلومات التواصل',
	'CONTACT_US_INFO_EXPLAIN'		=> 'الرسالة ستعرض في صفحة اتصل بنا',
	'CONTACT_US_INFO_PREVIEW'		=> 'استعراض - معلومات صفحة اتصل بنا',
	'CONTACT_US_INFO_UPDATED'		=> 'تم تحديث معلومات صفحة اتصل بنا.',
));

// Load Settings
$lang = array_merge($lang, array(
	'ACP_LOAD_SETTINGS_EXPLAIN'	=> 'هنا تستطيع تعطيل أو تفعيل بعض أعمال المنتدى لتقليل الحمل على قاعدة البيانات. في أكثر خوادم المواقع لا تحتاج إلى تعطيل أي خاصية. لكن في الاستضافة المشتركة أو خوادم الشبكة الضعيفة قد يؤدي تعطيل بعض الخصائص إلى تخفيف الحمل على المنتدى. تستطيع أيضا تحديد قدرة الحمل على المنتدى وجلسات الاتصال الفعالة بحيث يتعطل المنتدى عند وصول الحمل إلى مستوى معين',

	'ALLOW_CDN'						=> 'السماح باستخدام شبكات توفير محتوى لأطراف ثالثة',
	'ALLOW_CDN_EXPLAIN'				=> 'إذا تم تفعيل هذا الخيار، بعض الملفات سيتم توفيرها من خوادم خارجية لأطراف ثالثة بدلًا من الخادم الخاص بك. هذا سيقلل من كمية نقل البيانات من خادمك، لكن قد يمثل مشاكل في الخصوصية في بعض الدول. في نسخة phpBB الافتراضية، هذا يشمل تحميل مكتبات ”jQuery“ وخط ”Open Sans“ من شبكة تقديم المحتوى الخاصة بـ Google. وأيضًا خط “Font Awesome”  الذي يستعمله phpBB وكذلك بعض الإضافات لتوليد الأيقونات',
	'ALLOW_LIVE_SEARCHES'			=> 'السماح بالبحث الذكي',
	'ALLOW_LIVE_SEARCHES_EXPLAIN'	=> 'إذا تم تفعيل هذه الخاصية، سيتم توفير اقتراحات خاصة للمستخدمين أثناء كتابتهم في خانات البحث في المنتدى.',
	'CUSTOM_PROFILE_FIELDS'			=> 'حقل الملف الشخصي المخصص',
	'LIMIT_LOAD'					=> 'تحديد حمل النظام',
	'LIMIT_LOAD_EXPLAIN'			=> 'إذا كان حمل النظام في معدل الدقيقة الواحدة تجاوز هذه القيمة فسيتعطل تلقائيًا المنتدى. القيمة 1.0 تساوي تقريبا مائة بالمئة من استعمال معالج جهاز الحاسب المستضيف. هذا فقط يعمل على أنظمة تعمل على Linux وحالة الحصول على هذه المعلومات ممكنة. تعاد القيمة إلى صفر إذا لم يتمكن المنتدى حجم الحمل',
	'LIMIT_SESSIONS'				=> 'تحدد الجلسات',
	'LIMIT_SESSIONS_EXPLAIN'		=> 'إذا تجاوزت عدد الجلسات في خلال دقيقة واحدة سيتم إيقاف المنتدى تلقائيًا. ضع القيمة 0 لتعطيل هذه الخاصية',
	'LOAD_CPF_MEMBERLIST'			=> 'اسمح للاستايلات بعرض الحقول الإضافية في قائمة الأعضاء',
	'LOAD_CPF_PM'					=> 'اعرض الحقول الإضافية في الرسائل الخاصة',
	'LOAD_CPF_VIEWPROFILE'			=> 'اعرض الحقول الأضافية في ملف المستخدم',
	'LOAD_CPF_VIEWTOPIC'			=> 'عرض الحقول الأضافية في صفحة المواضيع',
	'LOAD_USER_ACTIVITY'			=> 'عرض تحركات المستخدم',
	'LOAD_USER_ACTIVITY_EXPLAIN'	=> 'عرض تحركات المستخدم في المشاركات وأقسام المنتديات. يفضل تعطيل هذه الخاصية إذا تجاوز عدد المواضيع المليون موضوع',
	'LOAD_USER_ACTIVITY_LIMIT'		=> 'الحد الأقصى للمواضيع النشطة للعضو',
	'LOAD_USER_ACTIVITY_LIMIT_EXPLAIN'	=> 'المواضيع/المنتديات النشطة لن تعرض على الأعضاء الذين لديهم مشاركات أكثر من هذا الرقم. اضبطه إلى 0 لتجاهل التحديد.',
	'READ_NOTIFICATION_EXPIRE_DAYS'	=> 'انتهاء الإشعارات المقروءة',
	'READ_NOTIFICATION_EXPIRE_DAYS_EXPLAIN' => 'عدد الأيام المنقضية قبل أن يتم حذف الإشعارات المقروءة تلقائيًا. قم بجعلها 0 لجعل الإشعارات دائمة.',
	'RECOMPILE_STYLES'				=> 'إعادة تكوين عناصر الاستايلات',
	'RECOMPILE_STYLES_EXPLAIN'		=> 'افحص التحديثات في الاستايلات وأعِد التكوين',
	'YES_ACCURATE_PM_BUTTON'		=> 'تفعيل زر رسائل خاصة دقيق في صفحة الموضوع',
	'YES_ACCURATE_PM_BUTTON_EXPLAIN'	=> 'عند تمكين هذا الإعداد سيظهر زر رسالة خاصة فقط للأعضاء المسموح لهم بقراءة الرسائل الخاصة .',
	'YES_ANON_READ_MARKING'			=> 'تفعيل تعليم المواضيع للزوار',
	'YES_ANON_READ_MARKING_EXPLAIN'	=> 'تخزن معلومات حالة الزوار القراءة/عدم القراءة. إذا تعطلت فإن حالة الزوار دومًا ستكون بالقراءة',
	'YES_BIRTHDAYS'					=> 'تفعيل اعياد الميلاد',
	'YES_BIRTHDAYS_EXPLAIN'			=> 'إذا عطلت هذا الخيار فسيتوقف عرض لائحة عيد الميلاد. ليعمل هذا الخيار جيدًا ينبغي أن تكون خاصية عيد الميلاد مفعلة ايضًا',
	'YES_JUMPBOX'					=> 'تفعيل عرض صندوق التنقل السريع',
	'YES_MODERATORS'				=> 'تفعيل عرض المشرفين',
	'YES_ONLINE'					=> 'تفعيل خاصية الموجودون الآن',
	'YES_ONLINE_EXPLAIN'			=> 'عرض معلومات وجود الأعضاء على صفحة البداية والمنتديات وقائمة المواضيع',
	'YES_ONLINE_GUESTS'				=> 'عرض معلومات اتصال الزوار',
	'YES_ONLINE_GUESTS_EXPLAIN'		=> 'عرض معلومات الزوار في صفحة الموجودون الآن',
	'YES_ONLINE_TRACK'				=> 'تفعيل خاصية إذا كان العضو متصلا أم لا',
	'YES_ONLINE_TRACK_EXPLAIN'		=> 'عرض معلومات الاتصال للمستخدم في الصفحة الشخصية وفي صفحة المواضيع',
	'YES_POST_MARKING'				=> 'تفعيل المواضيع المنقطة',
	'YES_POST_MARKING_EXPLAIN'		=> 'تبيين هل شارك العضو بالموضوع',
	'YES_READ_MARKING'				=> 'تفعيل تعليم المواضيع في الخادم',
	'YES_READ_MARKING_EXPLAIN'		=> 'تخزين قراءة وإزالة معلومات الحالة في قاعدة البيانات المنتدى بدل وضعها في كوكيز في متصفح المستخدم',
	'YES_UNREAD_SEARCH'				=> 'تمكين البحث عن المشاركات التي لم تُقرأ',
));

// Auth settings
$lang = array_merge($lang, array(
	'ACP_AUTH_SETTINGS_EXPLAIN'	=> 'منتديات phpBB تدعم إضافات وفروع التوثيق. هذه تسمح لك بتحديد طريقة توثيق المستخدمين عند تسجيل دخولهم للمنتدى. افتراضيا هناك ثلاثة إضافات متوفرة. والتي هي DB و LDAP و Apache. ليست كل طرق التوثيق تتطلب منك معلومات إضافية فقط عبّئ الحقول إذا كانت ذات صلة بالطريقة المتبعة',

	'AUTH_METHOD'				=> 'اختر طريقة التوثيق',

	'AUTH_PROVIDER_OAUTH_ERROR_ELEMENT_MISSING'	=> 'المفتاح والسر الخاصة بكل مقدم خدمة OAuth كليهما يجب أن يتم توفيرهما. لقد تم توفير أحدهما فقط لمقدم خدمة OAuth.',
	'AUTH_PROVIDER_OAUTH_EXPLAIN'				=> 'كل مقدم خدمة OAuth يتطلب سر ومفتاح فريدين لتتم المصادقة مع الخادم الخارجي.<br>هذان من المفترض أن يتم توفيرهما عن طريق مقدم خدمة OAuth عند قيامك بتسجيل موقعك لديهم ويجب أن يتم إدخالهما تمامًا كما استلمتهما.<br>أي خدمة لا تحتوي على كلا المفتاح والسر سويًا لن تكون متاحة للاستخدام من مشتركي المنتدى.',
	'AUTH_PROVIDER_OAUTH_KEY'					=> 'المفتاح',
	'AUTH_PROVIDER_OAUTH_TITLE'					=> 'OAuth',
	'AUTH_PROVIDER_OAUTH_SECRET'				=> 'السر',

	'APACHE_SETUP_BEFORE_USE'	=> 'عليك أن تعدّ توثيق Apache قبل أن تحول توثيق المنتدى إلى نظام توثيق Apache. ضع في عين الاعتبار أن اسم المستخدم لتوثيق Apache هو نفس اسم المستخدم  المستعمل في المنتدى يمكنك استخدام Apache. توثيق Apache يمكن أن يستخدم فقط مع mod_php (وليس مع نسخة CGI).',

	'LDAP'							=> 'LDAP',
	'LDAP_DN'						=> 'LDAP أساس <var>dn</var>',
	'LDAP_DN_EXPLAIN'				=> 'هذا الاسم المميز، تحديد معلومات المستخدم مثال <samp>o=My Company,c=US</samp>',
	'LDAP_EMAIL'					=> 'صفة بريد LDAP',
	'LDAP_EMAIL_EXPLAIN'			=> 'حدد هذا لصفات اسم بريد مستخدميك (إذا كان هنا واحد أصلًا) لكي يتعيّن عنوان البريد تلقائيًا للمستخدمين الجدد. إذا تركت هذا فارغًا سيُترك البريد فارغ للمستخدمين الذين يسجلون الدخول للمرة الأولى',
	'LDAP_INCORRECT_USER_PASSWORD'	=> 'الاندماج مع خادم LDAP فشل من اسم وكلمة المرور المعطاه',
	'LDAP_NO_EMAIL'					=> 'صفات البريد المحددة غير موجودة',
	'LDAP_NO_IDENTITY'				=> 'لم نستطع إيجاد هوية تسجيل لـ %s',
	'LDAP_PASSWORD'					=> 'كلمة مرور LDAP',
	'LDAP_PASSWORD_EXPLAIN'			=> 'اتركها فارغة للسماح بالدخول المجهول وإلا فاكتب كلمة المرور للمستخدم. <em><strong>تحذير</strong>: كلمة المرور ستحفظ بقاعدة البيانات بدون تشفير. أي شخص يمكنه الاطلاع على قاعدة البيانات يستطيع معرفة كلمة المرور.</em>',
	'LDAP_PORT'						=> 'منفذ خادم LDAP',
	'LDAP_PORT_EXPLAIN'				=> 'اختياريًا تستطيع تحديد منفذ الذي سيستعمل للإتصال بـخادم LDAP بدلًا عن المنفذ الإفتراضي  389',
	'LDAP_SERVER'					=> 'اسم خادم LDAP',
	'LDAP_SERVER_EXPLAIN'			=> 'إذا استخدمت LDAP اكتب اسم أو رقم IP الخادم',
	'LDAP_UID'						=> 'LDAP <var>uid</var>',
	'LDAP_UID_EXPLAIN'				=> 'هذا هو المفتاح المستعمل للبحث عن هوية أي تسجيل مثال<var>uid</var>، <var>sn</var>، etc',
	'LDAP_USER'						=> 'مستخدم LDAP',
	'LDAP_USER_EXPLAIN'				=> 'اتركها فارغة للسماح بالدخول المجهول.إذا عُبِـّأت سيقوم المنتدى بالاتصال بخادم الـ LDAP بالاسم المحدد',
	'LDAP_USER_FILTER'				=> 'فلتر اعضاء LDAP',
	'LDAP_USER_FILTER_EXPLAIN'		=> 'اختياريًا تستطيع أن تحّد من الكائنات المبحوث عنها بواسطة مرشحات اضافيه. مثلًا: <samp>objectClass=posixGroup</samp> سوف يكون الناتج عن استخدام <samp>(&(uid=$username)(objectClass=posixGroup))</samp>',
));

// Server Settings
$lang = array_merge($lang, array(
	'ACP_SERVER_SETTINGS_EXPLAIN'	=> 'هنا يمكنك وضع إعدادت الخادم والنطاق. الرجاء التأكد من أن المعلومات المعطاه صحيحة، الأخطاء ستنتج رسائل بريدية تحتوى على معلومات خاطئة. تذكر عندما تضع عنوان الموقع لا تسبقه بـ(http) وأيضا تعديل المنفذ - (port) إذا كنت تستعمل منفذ غير المنفذ 80. 80 هو الرقم الأصح في الغالب',

	'ENABLE_GZIP'				=> 'تفعيل ضغط GZip',
	'ENABLE_GZIP_EXPLAIN'		=> 'المواد المرسلة ستضغط قبل إرسالها إلى المستخدم. هذا سيقلل من حجم المعلمات المرسلة لكن سيزيد العباء على جهاز الموقع وجهاز المستخدم عند فك الضغط',
	'FORCE_SERVER_VARS'			=> 'فرض إعدادت وصلة المنتدى',
	'FORCE_SERVER_VARS_EXPLAIN'	=> 'إذا كان الخيار نعم إعدادت الخادم (الخادم) المستخدمة هنا ستستعمل عوضًا عن الخيارات المحددة تلقائيًا',
	'ICONS_PATH'				=> 'ضع مسار تخزين الصور الرمزية',
	'ICONS_PATH_EXPLAIN'		=> 'مسار تحت مجلد المنتدى مثال <samp>images/icons</samp>',
	'MOD_REWRITE_ENABLE'		=> 'تفعيل تغيير الراوبط',
	'MOD_REWRITE_ENABLE_EXPLAIN' => 'عند التفعيل، الروابط التي تحتوي على ’app.php’ سيتم تغييرها لإزالة اسم الملف (مثال app.php/foo ستصبح /foo). <strong>موديول mod_rewrite الخاص بخادم Apache مطلوب لتعمل هذه الميزة؛ إذا تم تفعيل هذا الخيار بدون أن يدعم خادمك موديول mod_rewrite، فقد تتعطل الروابط في المنتدى.</strong>',
	'MOD_REWRITE_DISABLED'		=> 'موديول <strong>mod_rewrite</strong> على خادم Apache الخاص بك معطل. قم بتفعيل الموديول أو اتصل بمقدم خدمة الاستضافة إذا أردت تفعيل هذا الخيار.',
	'MOD_REWRITE_INFORMATION_UNAVAILABLE' => 'لا يمكن تحديد إذا ما كان خادمك يدعم ميزة تغيير الروابط أم لا. قد يتم تفعيل هذا الخيار لكن إذا كانت ميزة تغيير الروابط غير مدعومة، فإن المسارات التي ينتجها المنتدى (لاستخدامها في الروابط مثلًا) قد تصبح معطلة. قم بالاتصال بمقدم خدمة الاستضافة إذا لم تكن متأكدًا إن كان بإمكانك تفعيل هذه الميزة بأمان.',
	'PATH_SETTINGS'				=> 'إعدادت المسار',
	'RANKS_PATH'				=> 'مسار تخزين صور الرتب',
	'RANKS_PATH_EXPLAIN'		=> 'مسار تحت مجلد المنتدى مثال <samp>images/ranks</samp>',
	'SCRIPT_PATH'				=> 'مسار الشفرات',
	'SCRIPT_PATH_EXPLAIN'		=> 'مسار موقع المنتدى مثال <samp>/phpBB3</samp>',
	'SERVER_NAME'				=> 'اسم النطاق',
	'SERVER_NAME_EXPLAIN'		=> 'النطاق الذي يشير إلى المنتدى (مثلا: <samp>example.com</samp>)',
	'SERVER_PORT'				=> 'منفذ الخادم',
	'SERVER_PORT_EXPLAIN'		=> 'المنفذ الذي يعمل منه خادمك على الانترنت، في الغالب يكون 80، غيره فقط إذا علمت أنه غير 80',
	'SERVER_PROTOCOL'			=> 'بروتوكول الخادم',
	'SERVER_PROTOCOL_EXPLAIN'	=> 'سيستخدم بروتوكول الخادم إذا تم فرض هذه الإعدادت. إذا كان فارغا سيتحدد البروتوكل عن طريق إعدادت الكوكيز الآمنة(<samp>http://</samp> or <samp>https://</samp>)',
	'SERVER_URL_SETTINGS'		=> 'إعدادت مسار الخادم',
	'SMILIES_PATH'				=> 'مسار تخزين الابتسامات',
	'SMILIES_PATH_EXPLAIN'		=> 'مسار تحت مجلد المنتدى مثال <samp>images/smilies</samp>',
	'UPLOAD_ICONS_PATH'			=> 'مسار تخزين صور امتدادت الملفات',
	'UPLOAD_ICONS_PATH_EXPLAIN'	=> 'مسار تحت مجلد المنتدى مثال <samp>images/upload_icons</samp>',
	'USE_SYSTEM_CRON'		=> 'تنفيذ مهمات دورية من ملف النظام cron',
	'USE_SYSTEM_CRON_EXPLAIN'		=> 'عندما تكون معطلة، المنتدى سيقوم بتجهيز مهمات دورية ليتم تنفذيها آليًا. عندما تكون مفعلة، المنتدى لن يقوم بوضع أي مهام على جدوله تلقائيًا؛ مدير المنتدى يجب أن يقوم بتجهيز المهام لتنفيذها عن طريق <code>cron.php</code> ليتم تنفذيها على فترات زمنية منتظمة (مثلًا كل 5 دقائق).',
));

// Security Settings
$lang = array_merge($lang, array(
	'ACP_SECURITY_SETTINGS_EXPLAIN'		=> 'هناك يمكنك تعريف الجلسات وإعدادت تسجيل الدخول',

	'ALL'							=> 'الكل',
	'ALLOW_AUTOLOGIN'				=> 'السماح بالدخول التلقائي',
	'ALLOW_AUTOLOGIN_EXPLAIN'		=> 'حدد إذا أمكن الدخول التلقائي للمستخدمين',
	'ALLOW_PASSWORD_RESET'			=> 'السماح باستعادة كلمة المرور ("نسيت كلمة المرور")',
	'ALLOW_PASSWORD_RESET_EXPLAIN'	=> 'تحديد إذا ما كان يمكن للمستخدمين استخدام رابط "نسيت كلمة المرور" في صفحة تسجيل الدخول لاستعادة حساباتهم. إذا كنت تستخدم وسيلة تعريف خارجية قد تود تعطيل هذه الميزة.',
	'AUTOLOGIN_LENGTH'				=> 'تاريخ انتهاء الدخول التلقائي بالأيام',
	'AUTOLOGIN_LENGTH_EXPLAIN'		=> 'الأيام التي يستمر فيها الدخول التلقائي. ضع القيمة 0 للتعطيل',
	'BROWSER_VALID'					=> 'التأكد من المتصفح',
	'BROWSER_VALID_EXPLAIN'			=> 'التأكد من المتصفح لكل جلسة يزيد من درجة الأمان',
	'CHECK_DNSBL'					=> 'افحص رقم الآي بي ضمن القائمة السوداء',
	'CHECK_DNSBL_EXPLAIN'			=> 'إذا تفعلت هذه الخاصية سيتم فحص IP المستخدم ضمن القائمة السوداء في التسجيل وفي المشاركة. قد يأخذ هذا البحث بعض الوقت إذا شعرت بحالة بطء في المنتدى يفضل تعطيل هذه الخاصية',
	'CLASS_B'						=> 'A.B',
	'CLASS_C'						=> 'A.B.C',
	'EMAIL_CHECK_MX'				=> 'التأكد من MX البريد',
	'EMAIL_CHECK_MX_EXPLAIN'		=> 'إذا تفعلت هذه الخاصية سيكون التأكد فعليًا من وجود هذا البريد في قائمة خوادم  MX',
	'FORCE_PASS_CHANGE'				=> 'فرض تغيير كلمة المرور',
	'FORCE_PASS_CHANGE_EXPLAIN'		=> 'يفرض على المستخدم تغيير كلمة المرور بعد عدد معين من الأيام. لتعطيل هذه الخاصية ضع القيمة 0',
	'FORM_TIME_MAX'					=> 'أقصى وقت لإرسال النموذج',
	'FORM_TIME_MAX_EXPLAIN'			=> 'الوقت الذي يستغرقه المستخدم لإرسال الفورم. استخدم -1 للتعطيل. علمًا أنه يمكن تعطيل الإرسال إذا انتهت فترة الجلسة. بغض النظر عن هذا الإعداد',
	'FORM_SID_GUESTS'				=> 'مفتاح حمايه للنماذج في جلسة الزائر',
	'FORM_SID_GUESTS_EXPLAIN'		=> 'لو فعلت هذه فإن مفتاح الحماية للنموذج الخاص بالزائر سوف يكون خاصا فقط للزائر نفسه. مما قد تسبب مشاكل مع بعض مقدمي خدمات الاتصالات',
	'FORWARDED_FOR_VALID'			=> 'التأكد من رئاسة <var>X_FORWARDED_FOR</var>',
	'FORWARDED_FOR_VALID_EXPLAIN'	=> 'ستستمر الجلسة للمستخدم فقط إذا كانت قيمة الـ <var>X_FORWARDED_FOR</var> نفس القيمة السابقة وليست قيمة أخرى',
	'IP_VALID'						=> 'تصديق جلسة IP',
	'IP_VALID_EXPLAIN'				=> 'تحديد عدد خانات IP التي تستخدم في تصديق الجلسة إما الجزء الأول والثاني A.B أو الكل A.B.C أو تعطيل الخاصية None',
	'IP_LOGIN_LIMIT_MAX'			=> 'أقصى عدد من محاولات الدخول للـ IP الواحد',
	'IP_LOGIN_LIMIT_MAX_EXPLAIN'	=> 'أقصى عدد من محاولات تسجيل الدخول المتاحة لنفس الـ IP قبل أن يطلب من المستخدم وضع رمز أمني ضد السبام. ضع القيمة 0 لجعل عدد محاولات التسجيل غير محدودة.',
	'IP_LOGIN_LIMIT_TIME'			=> 'وقت انتهاء محاولة تسجيل دخول الـ IP',
	'IP_LOGIN_LIMIT_TIME_EXPLAIN'	=> 'محاولة تسجيل الدخول تنتهي بعد هذا الوقت.',
	'IP_LOGIN_LIMIT_USE_FORWARDED'	=> 'تحديد تسجيل الدخول باستخدام قيمة <var>X_FORWARDED_FOR</var>',
	'IP_LOGIN_LIMIT_USE_FORWARDED_EXPLAIN'	=> 'بدلا من تحديد محاولات تسجيل الدخول باستخدام الـ IP يتم تحديدها باستخدام قيم <var>X_FORWARDED_FOR</var>. <br><em><strong>تحذير:</strong> قم بتشغيل هذه الخاصية فقط إذا كنت تعمل على خادم يستخدم بروكسي يحدد قيم <var>X_FORWARDED_FOR</var> لقيم موثوقة.</em>',
	'MAX_LOGIN_ATTEMPTS'			=> 'عدد محاولات تسجيل الدخول',
	'MAX_LOGIN_ATTEMPTS_EXPLAIN'	=> 'بعد هذا العدد من محاولات الدخول سيطلب من المستخدم وضع الرمز الأمني بجانب اسم المستخدم وكلمة المرور',
	'NO_IP_VALIDATION'				=> 'لا يوجد',
	'NO_REF_VALIDATION'				=> 'بدون',
	'PASSWORD_TYPE'					=> 'صعوبة كلمة المرور',
	'PASSWORD_TYPE_EXPLAIN'			=> 'تحديد صعوبة كلمة المرور إذا أنشئت أو عدلت. بما في ذلك التغير إلى كلمة المرور السابقة',
	'PASS_TYPE_ALPHA'				=> 'عليها أن تحتوي على حروف وأرقام',
	'PASS_TYPE_ANY'					=> 'لا توجد متطلبات',
	'PASS_TYPE_CASE'				=> 'عليها أن تحتوي على حروف صغرى وكبرى',
	'PASS_TYPE_SYMBOL'				=> 'عليها أن تحتوي على رموز مثل: *$#',
	'REF_HOST'						=> 'خادم صالح فقط',
	'REF_PATH'						=> 'مسار مقبول',
	'REFERRER_VALID'				=> 'التحقق من المرجع',
	'REFERRER_VALID_EXPLAIN'		=> 'إذا تم تفعيلها، فإن مرجع طلبات المشاركة سيتم التحقق منه في مقابل مسار إعدادات المضيف/السكربت. هذا قد يسبب مشاكل في المنتديات التي تستعمل أكثر من اسم دومين أو طرق تسجيل دخول خارجية.',
	'TPL_ALLOW_PHP'					=> 'السماح بكود php في الاستايلات',
	'TPL_ALLOW_PHP_EXPLAIN'			=> 'إذا فعلت هذه الخاصية كود php سينظر إليه وسيشغَل كلغة برمجة. إذا فعلت هذا الخيار واستعملت استايلًا آخر تأكد من مصداقية مصمم الاستايل لكن إذا عطلت هذه الخاصية فلن يضر استعمال الاستايل',
	'UPLOAD_CERT_VALID'				=> 'التحقق من صحة شهادة التحميل',
	'UPLOAD_CERT_VALID_EXPLAIN'		=> 'إذا تم تفعيلها، سيتم التحقق من صحة شهادات الرفع البعيد. وهذا يتطلب أن تكون حزمة CA معرفة في إعداد <samp>openssl.cafile</samp> أو <samp>curl.cainfo</samp> ملف في php.ini.',
));

// Email Settings
$lang = array_merge($lang, array(
	'ACP_EMAIL_SETTINGS_EXPLAIN'	=> 'هذه المعلومات تستخدم عندما يرسل المنتدى بريد للمستخدمين. الرجاء التأكد من أن البريد الذي تضعه يعمل. أي رسالة لا تصل إلى صاحبها سترد إلى البريد المسجل هنا. إذا كان مقدم خدمة الاستضافة لديك لا يقدم خدمة بريد php الإلكتروني تستطيع أن تبعث رسائل باستخدام بروتوكول SMTP. إذا طلب الخادم منك وضع كلمة مرور واسم مستخدم (فقط إذا طلب ذلك) اكتب الاسم وكلمة المرور. الرجاء ملاحظة أن مصداقية بسيطة متطلبة. المصداقيات الأخرى غير مدعومة حاليًا',

	'ADMIN_EMAIL'					=> 'عنوان بريد المرسل',
	'ADMIN_EMAIL_EXPLAIN'			=> 'سيكون هذا بريد المرسل في جميع المراسلات، وأيضًا بريد الصيانة.',
	'BOARD_EMAIL_FORM'				=> 'إرسال البريد للمستخدم عن طريق المنتدى',
	'BOARD_EMAIL_FORM_EXPLAIN'		=> 'بدلا من عرض بريد المستخدمين في الانترنت، يمكن للمستخدمين مراسلة بعضهم إلى بريدهم الشخصي عن طريق المنتدى بدون إظهار عنوان بريد العضو حيث تكون المراسلة بدون معرفة البريد الإلكتروني',
	'BOARD_HIDE_EMAILS'				=> 'إخفاء عناوين البريد',
	'BOARD_HIDE_EMAILS_EXPLAIN'		=> 'هذه الخاصية تجعل البريد الإلكتروني خاص بالكامل',
	'CONTACT_EMAIL'					=> 'بريد الاتصال',
	'CONTACT_EMAIL_EXPLAIN'			=> 'بريد الاتصال هذا سيستعمل في أي حالة تحتاج إلى اتصال مثل التبليغ عن خطأ أو عن حالة خاصة بالمنتدى',
	'CONTACT_EMAIL_NAME'			=> 'اسم الاتصال',
	'CONTACT_EMAIL_NAME_EXPLAIN'	=> 'هذا هو الاسم الذي سيراه مستقبلي البريد الالكتروني. إن لم ترد أن يكون هناك اسم اتصال، فاترك هذا الحقل فارغًا.',
	'EMAIL_FORCE_SENDER'			=> 'فرض بريد المرسل',
	'EMAIL_FORCE_SENDER_EXPLAIN'	=> 'هذا سعين <samp>Return-Path</samp> (مسار العودة) إلى بريد المرسل بدلًا من اسم المستخدم المحلي واسم الاستضافة للخادم. هذا الإعداد لا يعمل عند استخدام SMTP.<br><em><strong>تحذير:</strong> يتطلب هذا أن يكون مستخدم الخادم معتمد لإعداد خدمة sendmail</em>',
	'EMAIL_PACKAGE_SIZE'			=> 'حجم مجموعة البريد الإلكتروني',
	'EMAIL_PACKAGE_SIZE_EXPLAIN'	=> 'هنا عدد البريد الإلكتروني التي تُراسل في حزمة واحدة',
	'EMAIL_MAX_CHUNK_SIZE'			=> 'أقصى إيميلات مستلِمة مسموح بها',
	'EMAIL_MAX_CHUNK_SIZE_EXPLAIN'	=> 'عند الحاجة اضبط هذا الاعداد حتى لا تتجاوز عدد المستلمين في رسالة واحدة المسموح به في سيرفر البريد.',
	'EMAIL_SIG'						=> 'توقيع البريد الإلكتروني',
	'EMAIL_SIG_EXPLAIN'				=> 'هذا التوقيع سيرسل مع كل الرسائل الصادرة من المنتدى',
	'ENABLE_EMAIL'					=> 'تفعيل المراسلات البريدية',
	'ENABLE_EMAIL_EXPLAIN'			=> 'إذا تم تعطيل هذه الميزة فلن يتم إرسال رسائل بريدية عن طريق المنتدى نهائيًا. <em>يرجى ملاحظة أن تفعيل عضويات المستخدمين والمدير يتطلب أن تكون هذه الميزة مفعلة. إذا قمت باختيار "المستخدم" أو "المدير" في إعدادات التسجيل، فإن تعطيل هذه الميزة سيقوم بتعطيل التسجيل.</em>',
	'SEND_TEST_EMAIL'				=> 'إرسال بريد اختبار',
	'SEND_TEST_EMAIL_EXPLAIN'		=> 'هذا سيرسل بريد اختباري إلى عنوان البريد في حسابك.',
	'SMTP_ALLOW_SELF_SIGNED'		=> 'السماح بشهادات SSL الموقعة ذاتيًا',
	'SMTP_ALLOW_SELF_SIGNED_EXPLAIN'=> 'السماح بالاتصالات بخادم SMTP بشهادة SSL موقعه ذاتيا. <em> <strong> تحذير: </strong> السماح لشهادات SSL الموقعة ذاتيًا قد يسبب آثارًا أمنية.</em>',
	'SMTP_AUTH_METHOD'				=> 'طريقة التصديق SMTP',
	'SMTP_AUTH_METHOD_EXPLAIN'		=> 'فقط استعمل اسم المستخدم/كلمة المرور، راسل مستضيفك إذا لم تكن متأكدا من طريقة استعمالهم',
	'SMTP_CRAM_MD5'					=> 'CRAM-MD5',
	'SMTP_DIGEST_MD5'				=> 'DIGEST-MD5',
	'SMTP_LOGIN'					=> 'الدخول',
	'SMTP_PASSWORD'					=> 'كلمة مرور SMTP',
	'SMTP_PASSWORD_EXPLAIN'			=> 'ضع كلمة المرور إذا كانت مطلوبة فقط',
	'SMTP_PLAIN'					=> 'PLAIN',
	'SMTP_POP_BEFORE_SMTP'			=> 'POP-BEFORE-SMTP',
	'SMTP_PORT'						=> 'منفذ خادم SMTP',
	'SMTP_PORT_EXPLAIN'				=> 'غير المنفذ فقط إذا تأكدت أنه منفذ آخر',
	'SMTP_SERVER'					=> 'عنوان خادم SMTP',
	'SMTP_SERVER_EXPLAIN'			=> 'لا تقم بإدخال البروتوكول (<samp>ssl://</samp> or <samp>tls://</samp>) إلا إذا كان مستضيف البريد أخبرك بذلك.',
	'SMTP_SETTINGS'					=> 'إعدادات SMTP',
	'SMTP_USERNAME'					=> 'اسم المستخدم SMTP',
	'SMTP_USERNAME_EXPLAIN'			=> 'ضع اسم المستخدم إذا كان مطلوبًا فقط',
	'SMTP_VERIFY_PEER'				=> 'التحقق من شهادة SSL',
	'SMTP_VERIFY_PEER_EXPLAIN'		=> 'يتطلب التحقق من شهادة SSL المستخدمة من قبل خادم SMTP.<br><em><strong>تحذير:</strong> الاتصال المناظر مع شهادات SSL غير متحقق منها قد يسبب آثارًا أمنية. </em>',
	'SMTP_VERIFY_PEER_NAME'			=> 'التحقق من اسم نظير SMTP',
	'SMTP_VERIFY_PEER_NAME_EXPLAIN'	=> 'يتطلب التحقق من اسم النظير لخادمات SMTP باستخدام اتصالات SSL/TLS.<br><em><strong>تحذير :</strong> الاتصال بالنظائر غير المتحقق منها قد يسبب آثارًا أمنية. </em>',
	'TEST_EMAIL_SENT'				=> 'تم إرسال البريد الاختباري.<br> إذا لم تستلمه فرجاء افحص إعدادات البريد لديك.<br><br>إذا كنت تحتاج إلى مساعدة قم بزيارة <a href="https://www.phpbb.com/community/">منتديات الدعم phpBB (بالإنجليزية)</a>.',

	'USE_SMTP'						=> 'استخدام خادم SMTP للبريد الإلكتروني',
	'USE_SMTP_EXPLAIN'				=> 'اختار نعم إذا أردت أو وجب عليك إرسال الرسائل عن طريق خادم غير الخادم المحلي',
));

// Jabber settings
$lang = array_merge($lang, array(
	'ACP_JABBER_SETTINGS_EXPLAIN'	=> 'من هنا تستطيع تفعيل خاصية المراسلة الفورية وتنبيهات المنتدى بالبروتوكول Jabber، Jabber هو بروتكول مفتوح المصدر ويمكن استخدامه من اي شخص، بعض خدمات Jabber توفر منافذ أو طرق تمكنك من محادثه مستخدمين على شبكات أخرى. ليس كل الخوادم توفر منافذ خارجيه، لذا كن حذرًا من تغيير البروتكول لان التغيير قد تمنع الخدمات من التشغيل. وكن متأكد من وضع معلومات حسابك المسجل، وسوف نستخدمه بالتنبيهات والمراسلة في phpbb',

	'JAB_ALLOW_SELF_SIGNED'			=> 'السماح بشهادات SSL الموقعة ذاتيًا',
	'JAB_ALLOW_SELF_SIGNED_EXPLAIN'	=> 'السماح بالاتصالات بخادم Jabber بشهادة SSL موقعة ذاتيا.<br><em><strong>تحذير:</strong> السماح لشهادات SSL موقعة ذاتيًا قد يسبب آثارًا أمنية.</em>',
	'JAB_ENABLE'					=> 'تفعيل خاصية Jabber',
	'JAB_ENABLE_EXPLAIN'			=> 'تفعيل خاصية Jabber للمحادثة الفورية والتنبيه',
	'JAB_GTALK_NOTE'				=> 'رجاءًا لاحظ أن GTalk لن يعمل لأن الدالة <samp>dns_get_record</samp> لا يمكن إيجادها. هذه الداله غير متوفره في نسخ PHP4  وأيضا غير مضمنة في استضافات الويندوز. وحاليًا هي لاتعمل على انظمة BSD بالاضافه لنظام ماكنتوش',
	'JAB_PACKAGE_SIZE'				=> 'حجم مجموعة Jabber',
	'JAB_PACKAGE_SIZE_EXPLAIN'		=> 'هذا هو عدد الرسائل المرسلة في المره الواحده، اذا وضعتها 0 سترسَل فوريا ولن تنظّم لإرسالها في وقت لاحق',
	'JAB_PASSWORD'					=> 'كلمة مرور Jabber',
	'JAB_PASSWORD_EXPLAIN'			=> '<em><strong>تنويه:</strong> كلمة المرور سيتم تخزينها بدون تشفير في قاعدة البيانات وستكون ظاهره لقرأتها بشكل سهل لأصحاب الصلاحية للدخول إلى قاعدة بيانات المنتدى أو صفحة الإعدادات الخاصة بهذه الجزء</em>',
	'JAB_PORT'						=> 'منفذ Jabber',
	'JAB_PORT_EXPLAIN'				=> 'اتركها فارغة إلا إذا علمت أنه ليس منفذ 5222',
	'JAB_SERVER'					=> 'خادم Jabber',
	'JAB_SERVER_EXPLAIN'			=> 'لعرض الخوادم المتوفرة زر موقع %sjabber.org%s',
	'JAB_SETTINGS_CHANGED'			=> 'تغيرت إعدادت Jabber بنجاح',
	'JAB_USE_SSL'					=> 'استخدام SSL للاتصال',
	'JAB_USE_SSL_EXPLAIN'			=> 'لو كنت مفعّلا للاتصال الآمن سوف نحاول أن نعتمد عليه بالاتصال. منفذ Jabber سوف يتغير إلى 5223 لو كان المنفذ 5222 محدد',
	'JAB_USERNAME'					=> 'اسم مستخدم Jabber',
	'JAB_USERNAME_EXPLAIN'			=> 'حدد اسم المستخدم بدقة. فلن نتأكد من صحة الاسم',
	'JAB_VERIFY_PEER'				=> 'التحقق من شهادة SSL',
	'JAB_VERIFY_PEER_EXPLAIN'		=> 'يتطلب التحقق من شهادة SSL المستخدمة من قبل خادم Jabber.<br><em><strong>تحذير:</strong> الاتصال النظائر مع شهادات SSL غير متحقق منها قد يسبب آثارًا أمنية.</em>',
	'JAB_VERIFY_PEER_NAME'			=> 'التحقق من اسم نظير Jabber',
	'JAB_VERIFY_PEER_NAME_EXPLAIN'	=> 'يتطلب التحقق من اسم النظير لخادمات Jabber باستخدام اتصالات SSL/TLS.<br><em><strong>تحذير :</strong> الاتصال بالنظائر الغير متحقق منها قد يسبب آثارًا أمنية.</em>',
));
