<?php
/**
*
* This file is part of the phpBB Forum Software package.
*
* @copyright (c) phpBB Limited <https://www.phpbb.com>
* @license GNU General Public License, version 2 (GPL-2.0)
*
* For full copyright and license information, please see
* the docs/CREDITS.txt file.
*
* Deutsche Übersetzung durch die Übersetzer-Gruppe von phpBB.de:
* siehe language/de_x_sie/AUTHORS.md und https://www.phpbb.de/go/ubersetzerteam
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste:
// ’ » „ “ — …
//

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'	=> 'Deutsche Übersetzung durch <a href="https://www.phpbb.de/">phpBB.de</a>',
	'DIRECTION'			=> 'ltr',
	'DATE_FORMAT'		=> '|j. M Y|',	// 1. Jan 2007 (with Relative days enabled)
	'DATETIME_FORMAT'	=> '|j. M Y H:i|',	// 1. Jan 2007 13:37 (with Relative days enabled)
	'USER_LANG'			=> 'de-x-sie',

	// You can define different rules for the determination of plural forms here.
	// See https://area51.phpbb.com/docs/dev/3.3.x/language/plurals.html for more information
	// or ask the translation manager for help.
	'PLURAL_RULE'		=> 1,

	'1_DAY'			=> '1 Tag',
	'1_MONTH'		=> '1 Monat',
	'1_YEAR'		=> '1 Jahr',
	'2_WEEKS'		=> '2 Wochen',
	'3_MONTHS'		=> '3 Monate',
	'6_MONTHS'		=> '6 Monate',
	'7_DAYS'		=> '7 Tage',

	'ACCOUNT_ALREADY_ACTIVATED'		=> 'Ihr Benutzerkonto wurde bereits aktiviert.',
	'ACCOUNT_DEACTIVATED'			=> 'Ihr Benutzerkonto wurde manuell deaktiviert und kann nur durch einen Administrator reaktiviert werden.',
	'ACP'							=> 'Administrations-Bereich',
	'ACP_SHORT'						=> 'Adm.',
	'ACTIVATION_ALREADY_SENT'		=> 'Die Aktivierungs-E-Mail wurde bereits an Ihre E-Mail-Adresse gesendet. Sie können sie frühestens nach 24 Stunden erneut anfordern. Sollten Sie weiterhin Probleme mit der Aktivierung Ihres Accounts haben, wenden Sie sich bitte an die Board-Adminstration.',
	'ACTIVE'						=> 'aktiv',
	'ACTIVE_ERROR'					=> 'Der angegebene Benutzer ist momentan inaktiv. Wenn Sie weiterhin Probleme bei der Aktivierung Ihres Benutzerkontos haben, wenden Sie sich bitte an die Board-Administration.',
	'ADMINISTRATOR'					=> 'Administrator',
	'ADMINISTRATORS'				=> 'Administratoren',
	'AGE'							=> 'Alter',
	'AIM'							=> 'AIM',
	'AJAX_ERROR_TITLE'				=> 'AJAX-Fehler',
	'AJAX_ERROR_TEXT'				=> 'Bei der Verarbeitung Ihrer Anfrage ist ein Fehler aufgetreten.',
	'AJAX_ERROR_TEXT_ABORT'			=> 'Der Benutzer hat die Anfrage abgebrochen.',
	'AJAX_ERROR_TEXT_TIMEOUT'		=> 'Bei Ihrer Anfrage ist eine Zeitüberschreitung aufgetreten. Bitte versuchen Sie es erneut.',
	'AJAX_ERROR_TEXT_PARSERERROR'	=> 'Bei Ihrer Anfrage ist etwas falsch gelaufen und der Server hat eine ungültige Antwort zurückgegeben.',
	'ALLOWED'						=> 'Erlaubt',
	'ALL_FILES'						=> 'Alle Dateien',
	'ALL_FORUMS'					=> 'Alle Foren',
	'ALL_MESSAGES'					=> 'Alle Nachrichten',
	'ALL_POSTS'						=> 'Alle Beiträge',
	'ALL_TIMES'						=> 'Alle Zeiten sind <span title="%2$s">%1$s</span>',
	'ALL_TOPICS'					=> 'Alle Themen',
	'ALT_TEXT'						=> 'Alternativer Text',
	'AND'							=> 'und', // PM-Verwaltung
	'ARE_WATCHING_FORUM'			=> 'Sie werden über neue Beiträge in diesem Forum informiert.',
	'ARE_WATCHING_TOPIC'			=> 'Sie werden über neue Beiträge in diesem Thema informiert.',
	'ASCENDING'						=> 'Aufsteigend',
	'ATTACHMENTS'					=> 'Dateianhänge',
	'ATTACHED_IMAGE_NOT_IMAGE'		=> 'Die Bild-Datei, die Sie versucht haben hochzuladen, ist ungültig.',
	'AUTHOR'						=> 'Autor',
	'AUTH_NO_PROFILE_CREATED'		=> 'Die Erstellung eines Mitgliederprofils ist gescheitert.',
	'AUTH_PROVIDER_OAUTH_ERROR_ALREADY_LINKED'				=> 'Dieser externe Service wurde bereits mit einem anderen Benutzerkonto verknüpft.',
	'AUTH_PROVIDER_OAUTH_ERROR_INVALID_ENTRY'				=> 'Ungültiger Datenbank-Eintrag.',
	'AUTH_PROVIDER_OAUTH_ERROR_INVALID_SERVICE_TYPE'		=> 'Es wurde ein ungültiger Dienst-Typ an die OAuth-Dienst-Routine übergeben.',
	'AUTH_PROVIDER_OAUTH_ERROR_REQUEST'						=> 'Bei der OAuth-Abfrage ist ein Fehler aufgetreten.',
	'AUTH_PROVIDER_OAUTH_RETURN_ERROR'						=> 'Der externe Service hat einen falschen Wert zurückgegeben, daher kann Ihre Anfrage nicht verarbeitet werden.',
	'AUTH_PROVIDER_OAUTH_ERROR_SERVICE_NOT_CREATED'			=> 'Der OAuth-Dienst konnte nicht erstellt werden',
	'AUTH_PROVIDER_OAUTH_SERVICE_BITLY'						=> 'Bitly',
	'AUTH_PROVIDER_OAUTH_SERVICE_FACEBOOK'					=> 'Facebook',
	'AUTH_PROVIDER_OAUTH_SERVICE_GOOGLE'					=> 'Google',
	'AUTH_PROVIDER_OAUTH_SERVICE_TWITTER'					=> 'Twitter',
	'AUTH_PROVIDER_OAUTH_TOKEN_ERROR_NOT_STORED'			=> 'Das OAuth-Token wurde nicht gespeichert.',
	'AUTH_PROVIDER_OAUTH_TOKEN_ERROR_INCORRECTLY_STORED'	=> 'Das OAuth-Token wurde fehlerhaft gespeichert.',
	'AVATAR_DISALLOWED_CONTENT'		=> 'Die hochgeladene Datei wurde abgewiesen, da sie als möglicher Angriffsversuch identifiziert wurde.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'Die Datei kann nicht angezeigt werden, da die Dateierweiterung %s nicht erlaubt ist.',
	'AVATAR_EMPTY_REMOTE_DATA'		=> 'Der ausgewählte Avatar konnte nicht hochgeladen werden, da die lokale Datei ungültig oder beschädigt zu sein scheint.',
	'AVATAR_EMPTY_FILEUPLOAD'		=> 'Die hochgeladene Avatar-Datei ist leer.',
	'AVATAR_INVALID_FILENAME'		=> '%s ist ein ungültiger Dateiname.',
	'AVATAR_NOT_UPLOADED'			=> 'Der Avatar konnte nicht hochgeladen werden.',
	'AVATAR_NO_TEMP_DIR'			=> 'Der temporäre Ordner konnte nicht gefunden werden oder ist nicht beschreibbar.',
	'AVATAR_NO_SIZE'				=> 'Die Breite oder die Höhe des verlinkten Avatars konnte nicht ermittelt werden. Bitte geben Sie sie manuell an.',
	'AVATAR_NO_UPLOAD_DIR'			=> 'Der Ordner zur Ablage der Avatare konnte nicht gefunden werden oder ist nicht beschreibbar.',
	'AVATAR_NO_UPLOAD_PATH'			=> 'Das Hochladen von Avataren wurde aktiviert, es wurde aber kein Ablage-Ordner festgelegt.',
	'AVATAR_PARTIAL_UPLOAD'			=> 'Die ausgewählte Datei wurde nur unvollständig hochgeladen.',
	'AVATAR_PHP_SIZE_NA'			=> 'Die Avatar-Datei ist zu groß.<br />Die durch PHP in der php.ini festgelegte maximale Größe konnte nicht ermittelt werden.',
	'AVATAR_PHP_SIZE_OVERRUN'		=> 'Die Avatar-Datei ist zu groß, sie darf maximal %1$d %2$s groß sein.<br />Dieser Wert ist in der php.ini festgelegt und kann nicht überschrieben werden.',
	'AVATAR_REMOTE_UPLOAD_TIMEOUT'		=> 'Der ausgewählte Avatar konnte nicht hochgeladen werden, da bei der Anfrage eine Zeitüberschreitung aufgetreten ist.',
	'AVATAR_PHP_UPLOAD_STOPPED'		=> 'Eine PHP-Erweiterung hat den Hochlade-Vorgang unterbrochen.',
	'AVATAR_URL_INVALID'			=> 'Die angegebene URL ist ungültig.',
	'AVATAR_URL_NOT_FOUND'			=> 'Die angegebene Datei konnte nicht gefunden werden.',
	'AVATAR_WRONG_FILESIZE'			=> 'Der Avatar muss zwischen 0 und %1$d %2$s groß sein.',
	'AVATAR_WRONG_SIZE'				=> 'Der hochgeladene Avatar ist %5$s breit und %6$s hoch. Avatare müssen mindestens %1$s breit und %2$s hoch, aber dürfen maximal %3$s breit und %4$s hoch sein.',

	'BACK_TO_TOP'			=> 'Nach oben',
	'BACK_TO_PREV'			=> 'Zurück zur vorherigen Seite',
	'BAN_TRIGGERED_BY_EMAIL'=> 'Ihre E-Mail-Adresse wurde gesperrt.',
	'BAN_TRIGGERED_BY_IP'	=> 'Ihre IP-Adresse wurde gesperrt.',
	'BAN_TRIGGERED_BY_USER'	=> 'Ihr Benutzername wurde gesperrt.',
	'BBCODE_GUIDE'			=> 'BBCode-Anleitung',
	'BCC'					=> 'BCC',
	'BIRTHDAYS'				=> 'Geburtstage',
	'BOARD_BAN_PERM'		=> 'Sie wurden auf diesem Board <strong>dauerhaft</strong> gesperrt.<br /><br />Bitte kontaktieren Sie die %2$sBoard-Administration%3$s, um weitere Informationen zu erhalten.',
	'BOARD_BAN_REASON'		=> 'Für die Sperre angegebener Grund: <strong>%s</strong>',
	'BOARD_BAN_TIME'		=> 'Sie wurden auf diesem Board bis zum <strong>%1$s</strong> gesperrt.<br /><br />Bitte kontaktieren Sie die %2$sBoard-Administration%3$s, um weitere Informationen zu erhalten.',
	'BOARD_DISABLE'			=> 'Dieses Board ist leider momentan nicht verfügbar.',
	'BOARD_DISABLED'		=> 'Dieses Board ist momentan deaktiviert.',
	'BOARD_UNAVAILABLE'		=> 'Dieses Board ist leider vorübergehend nicht verfügbar, bitte versuchen Sie es in einigen Minuten erneut.',
	'BROWSING_FORUM'		=> 'Mitglieder in diesem Forum: %1$s',
	'BROWSING_FORUM_GUESTS'	=> array(
		1	=> 'Mitglieder in diesem Forum: %2$s und %1$d Gast',
		2	=> 'Mitglieder in diesem Forum: %2$s und %1$d Gäste',
	),
	'BUTTON_DELETE'			=> 'Löschen',
	'BUTTON_EDIT'			=> 'Ändern',
	'BUTTON_FORUM_LOCKED'	=> 'Gesperrt',
	'BUTTON_INFORMATION'	=> 'Information',
	'BUTTON_NEW_TOPIC'		=> 'Neues Thema',
	'BUTTON_PM'				=> 'PN',
	'BUTTON_PM_FORWARD'		=> 'Weiterleiten',
	'BUTTON_PM_NEW'			=> 'Neue PN',
	'BUTTON_PM_REPLY'		=> 'Antworten',
	'BUTTON_PM_REPLY_ALL'	=> 'Allen antworten',
	'BUTTON_POST_REPLY'		=> 'Antworten',
	'BUTTON_QUOTE'			=> 'Zitieren',
	'BUTTON_REPORT'			=> 'Melden',
	'BUTTON_TOPIC_LOCKED'	=> 'Gesperrt',
	'BUTTON_WARN'			=> 'Verwarnen',
	'BYTES'					=> 'Bytes',
	'BYTES_SHORT'			=> 'B',

	'CANCEL'				=> 'Abbrechen',
	'CHANGE'				=> 'Ändern',
	'CHANGE_FONT_SIZE'		=> 'Ändere Schriftgröße',
	'CHANGING_PREFERENCES'	=> 'Ändert Board-Einstellungen',
	'CHANGING_PROFILE'		=> 'Ändert sein Profil',
	'CHARACTERS'			=> array(
		1	=> '%d Zeichen',
		2	=> '%d Zeichen',
	),
	// Special version to be used when describing ranges e.g. "min x characters and max y characters"
	'CHARACTERS_XY'			=> array(
		1	=> '%d Zeichen',
		2	=> '%d Zeichen',
	),
	'COLLAPSE_VIEW'			=> 'Zusammenklappen',
	'CLOSE_WINDOW'			=> 'Fenster schließen',
	'CODE'					=> 'Code',
	'COLOUR_SWATCH'			=> 'Farbpalette',
	'COLON'					=> ':',
	'COMMA_SEPARATOR'		=> ', ',	// Comma used to join lists into a single string, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'				=> 'Bestätigen',
	'CONFIRM_CODE'			=> 'Bestätigungscode',
	'CONFIRM_CODE_EXPLAIN'	=> 'Geben Sie den Code genau so ein, wie Sie ihn sehen; Groß- und Kleinschreibung wird nicht unterschieden.',
	'CONFIRM_CODE_WRONG'	=> 'Der eingegebene Bestätigungscode ist falsch.',
	'CONFIRM_OPERATION'		=> 'Sind Sie sich sicher, dass Sie diesen Vorgang durchführen möchten?',
	'CONFIRM_AVATAR_DELETE' => 'Sind Sie sich sicher, dass Sie diesen Avatar löschen möchten?',
	'CONGRATULATIONS'		=> 'Glückwünsche an',
	'CONNECTION_FAILED'		=> 'Die Verbindung ist gescheitert!',
	'CONNECTION_SUCCESS'	=> 'Die Verbindung war erfolgreich!',
	'CONTACT'				=> 'Kontaktdaten',
	'CONTACT_USER'			=> 'Kontaktdaten von %s', // TODO: Verwendung prüfen
	'CONTACT_US'			=> 'Kontakt',
	'COOKIE_CONSENT_INFO'	=> 'Mehr erfahren',
	'COOKIE_CONSENT_MSG'	=> 'Diese Website nutzt Cookies, um Ihnen den bestmöglichen Komfort bei der Nutzung zu bieten.',
	'COOKIE_CONSENT_OK'		=> 'Verstanden!',
	'COOKIE_CONSENT_HREF'	=> 'https://de.wikipedia.org/wiki/HTTP-Cookie',
	'COOKIES_DELETED'		=> 'Alle Cookies des Boards wurden erfolgreich gelöscht.',
	'CURRENT_TIME'			=> 'Aktuelle Zeit: %s',

	'DAY'					=> 'Tag',
	'DAYS'					=> 'Tage',
	'DELETE'				=> 'Löschen',
	'DELETE_ALL'			=> 'Alle löschen',
	'DELETE_COOKIES'		=> 'Alle Cookies löschen',
	'DELETE_MARKED'			=> 'Markierte löschen',
	'DELETE_POST'			=> 'Beitrag löschen',
	'DELIMITER'				=> 'Trennzeichen',
	'DESCENDING'			=> 'Absteigend',
	'DISABLED'				=> 'Deaktiviert',
	'DISPLAY'				=> 'Anzeigen',
	'DISPLAY_GUESTS'		=> 'Gäste anzeigen',
	'DISPLAY_MESSAGES'		=> 'Nachrichten der letzten Zeit anzeigen',
	'DISPLAY_POSTS'			=> 'Beiträge der letzten Zeit anzeigen',
	'DISPLAY_TOPICS'		=> 'Themen der letzten Zeit anzeigen',
	'DOMAIN_NO_MX_RECORD_EMAIL'	=> 'Die Domain der eingegebenen E-Mail-Adresse hat keinen gültigen MX-Eintrag.',
	'DOWNLOADED'			=> 'Heruntergeladen',
	'DOWNLOADING_FILE'		=> 'Lädt eine Datei herunter',
	'DOWNLOAD_COUNTS'		=> array(
		0	=> 'Noch nie heruntergeladen',
		1	=> '%d-mal heruntergeladen',
		2	=> '%d-mal heruntergeladen',
	),

	'EDIT_POST'							=> 'Beitrag ändern',
	'ELLIPSIS'							=> '…',
	'EMAIL'								=> 'E-Mail', // Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'						=> 'E-Mail-Adresse',
	'EMAIL_INVALID_EMAIL'				=> 'Die angegebene E-Mail-Adresse ist ungültig.',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'Probleme beim Mailversand in <strong>Zeile %1$s</strong>. Antwort: %2$s.',
	'EMPTY_SUBJECT'						=> 'Sie müssen einen Betreff angeben, wenn Sie ein neues Thema erstellen möchten.',
	'EMPTY_MESSAGE_SUBJECT'				=> 'Sie müssen einen Betreff angeben, wenn Sie eine neue Nachricht verfassen möchten.',
	'ENABLED'							=> 'Aktiviert',
	'ENCLOSURE'							=> 'Texterkennungszeichen',
	'ENTER_USERNAME'					=> 'Einen Benutzernamen angeben',
	'ERR_CHANGING_DIRECTORY'			=> 'Das Verzeichnis konnte nicht gewechselt werden.',
	'ERR_CONNECTING_SERVER'				=> 'Fehler beim Verbindungsaufbau zum Server.',
	'ERR_JAB_AUTH'						=> 'Die Anmeldung am Jabber-Server war nicht erfolgreich.',
	'ERR_JAB_CONNECT'					=> 'Es konnte keine Verbindung zum Jabber-Server aufgebaut werden.',
	'ERR_UNABLE_TO_LOGIN'				=> 'Der angegebene Benutzername oder das angegebene Passwort ist falsch.',
	'ERR_UNWATCHING'					=> 'Beim Versuch, Beim Versuch, das Abonnement des Themas zu beenden, ist ein Fehler aufgetreten.',
	'ERR_WATCHING'						=> 'Beim Versuch, das Thema zu abonnieren, ist ein Fehler aufgetreten.',
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'Der angegebene phpBB-Pfad scheint ungültig zu sein.',
	'ERROR'								=> 'Fehler',
	'EXPAND_VIEW'						=> 'Ansicht erweitern',
	'EXTENSION'							=> 'Dateierweiterung',
	'EXTENSION_DISABLED'				=> 'Die Erweiterung <strong>%s</strong> ist nicht aktiviert.',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'Die Dateierweiterung <strong>%s</strong> wurde deaktiviert und kann nicht länger angezeigt werden.',
	'EXTENSION_DOES_NOT_EXIST'			=> 'Die Erweiterung <strong>%s</strong> existiert nicht.',

	'FACEBOOK'				=> 'Facebook',
	'FAQ'					=> 'FAQ',
	'FAQ_EXPLAIN'			=> 'Häufig gestellte Fragen',
	'FEATURE_NOT_AVAILABLE' => 'Die angeforderte Funktion steht auf diesem Board nicht zur Verfügung.',
	'FILENAME'				=> 'Dateiname',
	'FILESIZE'				=> 'Größe',
	'FILEDATE'				=> 'Dateidatum',
	'FILE_COMMENT'			=> 'Dateikommentar',
	'FILE_CONTENT_ERR'		=> 'Dateiinhalt konnte nicht gelesen werden: %s',
	'FILE_JSON_DECODE_ERR'	=> 'JSON-Datei konnte nicht dekodiert werden: %s',
	'FILE_NOT_FOUND'		=> 'Die angegebene Datei konnte nicht gefunden werden: %s',
	'FIND_USERNAME'			=> 'Nach einem Mitglied suchen',
	'FOLDER'				=> 'Ordner',
	'FORGOT_PASS'			=> 'Ich habe mein Passwort vergessen',
	'FORM_INVALID'			=> 'Das übermittelte Formular war ungültig. Versuchen Sie erneut, das Formular abzusenden.',
	'FORUM'					=> 'Forum',
	'FORUMS'				=> 'Foren',
	'FORUMS_MARKED'			=> 'Foren wurden als gelesen markiert.',
	'FORUM_CAT'				=> 'Kategorie',
	'FORUM_INDEX'			=> 'Foren-Übersicht',
	'FORUM_LINK'			=> 'Forums-Link',
	'FORUM_LOCATION'		=> 'Aktuelle Tätigkeit',
	'FORUM_LOCKED'			=> 'Forum gesperrt',
	'FORUM_RULES'			=> 'Forumsregeln',
	'FORUM_RULES_LINK'		=> 'Die Forumsregeln lesen',
	'FROM'					=> 'von',
	'FSOCK_DISABLED'		=> 'Dieser Vorgang kann nicht abgeschlossen werden, da die <var>fsockopen</var>-Funktion deaktiviert wurde oder weil der angegebene Server nicht gefunden werden konnte.',
	'FSOCK_TIMEOUT'			=> 'Beim Lesen des Datenstroms ist eine Zeitüberschreitung aufgetreten.',

	'FILESYSTEM_CANNOT_CHANGE_FILE_GROUP'		=> 'Die Gruppe einer Datei konnte nicht geändert werden.',
	'FILESYSTEM_CANNOT_CHANGE_FILE_PERMISSIONS'	=> 'Die Berechtigungen einer Datei konnten nicht geändert werden.',
	'FILESYSTEM_CANNOT_COPY_FILES'				=> 'Die Dateien konnten nicht kopiert werden.',
	'FILESYSTEM_CANNOT_CREATE_SYMLINK'			=> 'Eine symbolische Verknüpfung (Symlink) konnte nicht erstellt werden.',
	'FILESYSTEM_CANNOT_CREATE_DIRECTORY'		=> 'Ein Verzeichnis konnte nicht angelegt werden.',
	'FILESYSTEM_CANNOT_DELETE_FILES'			=> 'Eine Datei konnte nicht vom Server gelöscht werden.',
	'FILESYSTEM_CANNOT_DUMP_FILE'				=> 'Eine Datei konnte nicht geschrieben werden.',
	'FILESYSTEM_CANNOT_MIRROR_DIRECTORY'		=> 'Ein Verzeichnis konnte nicht gespiegelt werden.',
	'FILESYSTEM_CANNOT_RENAME_FILE'				=> 'Eine Datei konnte auf dem Server nicht umbenannt werden.',
	'FILESYSTEM_CANNOT_TOUCH_FILES'				=> 'Eine Datei konnte nicht erstellt oder ihr Zeitstempel nicht verändert werden.',

	'FTP_FSOCK_HOST'				=> 'FTP-Server',
	'FTP_FSOCK_HOST_EXPLAIN'		=> 'FTP-Server, auf dem sich Ihre Website befindet.',
	'FTP_FSOCK_PASSWORD'			=> 'FTP-Passwort',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'Passwort zu Ihrem FTP-Benutzernamen.',
	'FTP_FSOCK_PORT'				=> 'FTP-Port',
	'FTP_FSOCK_PORT_EXPLAIN'		=> 'Port, der für die Verbindung zu Ihrem Server benutzt wird.',
	'FTP_FSOCK_ROOT_PATH'			=> 'Pfad zur phpBB-Installation',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'Pfad zu Ihrer phpBB-Installation vom Root-Verzeichnis aus.',
	'FTP_FSOCK_TIMEOUT'				=> 'FTP-Timeout',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'		=> 'Zeit in Sekunden, die das System auf eine Antwort Ihres Servers warten wird.',
	'FTP_FSOCK_USERNAME'			=> 'FTP-Benutzername',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'Benutzername, der für die Anmeldung an Ihrem Server verwendet wird.',

	'FTP_HOST'					=> 'FTP-Server',
	'FTP_HOST_EXPLAIN'			=> 'FTP-Server, auf dem sich Ihre Website befindet.',
	'FTP_PASSWORD'				=> 'FTP-Passwort',
	'FTP_PASSWORD_EXPLAIN'		=> 'Passwort zu Ihrem FTP-Benutzernamen.',
	'FTP_PORT'					=> 'FTP-Port',
	'FTP_PORT_EXPLAIN'			=> 'Port, der für die Verbindung zu Ihrem Server benutzt wird.',
	'FTP_ROOT_PATH'				=> 'Pfad zur phpBB-Installation',
	'FTP_ROOT_PATH_EXPLAIN'		=> 'Pfad zu Ihrer phpBB-Installation vom Root-Verzeichnis aus.',
	'FTP_TIMEOUT'				=> 'FTP-Timeout',
	'FTP_TIMEOUT_EXPLAIN'		=> 'Zeit in Sekunden, die das System auf eine Antwort Ihres Servers warten wird.',
	'FTP_USERNAME'				=> 'FTP-Benutzername',
	'FTP_USERNAME_EXPLAIN'		=> 'Benutzername, der für die Anmeldung an Ihrem Server verwendet wird.',

	'GENERAL_ERROR'				=> 'Allgemeiner Fehler',
	'GB'						=> 'GB',
	'GIB'						=> 'GiB',
	'GO'						=> 'Los',
	'GOTO_FIRST_POST'			=> 'Gehe zum ersten Beitrag',
	'GOTO_LAST_POST'			=> 'Gehe zum letzten Beitrag',
	'GOTO_PAGE'					=> 'Gehe zu Seite',
	'GROUP'						=> 'Gruppe',
	'GROUPS'					=> 'Gruppen',
	'GROUP_ERR_TYPE'			=> 'Es wurde ein ungültiger Gruppentyp ausgewählt.',
	'GROUP_ERR_USERNAME'		=> 'Es wurde kein Gruppenname angegeben.',
	'GROUP_ERR_USER_LONG'		=> 'Gruppennamen dürfen nicht länger als 60 Zeichen sein. Der angegebene Gruppenname ist zu lang.',
	'GUEST'						=> 'Gast',
	'GUEST_USERS_ONLINE'		=> array(
		0	=> 'Es ist kein Gast online',
		1	=> 'Es ist 1 Gast online',
		2	=> 'Es sind %d Gäste online',
	),
	'GUEST_USERS_TOTAL'			=>  array(
		1	=> '%d Gast',
		2	=> '%d Gäste',
	),
	'G_ADMINISTRATORS'			=> 'Administratoren',
	'G_BOTS'					=> 'Bots',
	'G_GUESTS'					=> 'Gäste',
	'G_REGISTERED'				=> 'Registrierte Benutzer',
	'G_REGISTERED_COPPA'		=> 'Registrierte COPPA-Benutzer',
	'G_GLOBAL_MODERATORS'		=> 'Globale Moderatoren',
	'G_NEWLY_REGISTERED'		=> 'Kürzlich registrierte Benutzer',

	'HIDDEN_USERS_ONLINE'		=> array(
		1	=> '%d unsichtbares Mitglied',
		2	=> '%d unsichtbare Mitglieder',
	),
	'HIDDEN_USERS_TOTAL'		=> array(
		1	=> '%d unsichtbares Mitglied',
		2	=> '%d unsichtbare Mitglieder',
	),
	'HIDE_GUESTS'					=> 'Gäste ausblenden',
	'HIDE_ME'						=> 'Meinen Online-Status während dieser Sitzung verbergen',
	'HOURS'							=> 'Stunden',
	'HOME'							=> 'Startseite',

	'ICQ'						=> 'ICQ',
	'IF'						=> 'Wenn',
	'IMAGE'						=> 'Bild',
	'IMAGE_FILETYPE_INVALID'	=> 'Der Grafikdateityp %d wird für den MIME-Typ %s nicht unterstützt.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'Fehlerhafter Grafikdateityp: Dateiendung %1$s erwartet, aber Endung %2$s erhalten.',
	'IN'						=> 'in',
	'INACTIVE'					=> 'Inaktiv',
	'INDEX'						=> 'Foren-Übersicht',
	'INFORMATION'				=> 'Information',
	'INSECURE_REDIRECT'			=> 'Es wurde versucht, zu einer möglicherweise unsicheren URL weiterzuleiten.',
	'INTERESTS'					=> 'Interessen',
	'INVALID_DIGEST_CHALLENGE'	=> 'Ungültiger Digest Challenge.',
	'INVALID_EMAIL_LOG'			=> '<strong>%s</strong> ist vermutlich eine ungültige E-Mail-Adresse.',
	'INVALID_FEED_ATTACHMENTS'	=> 'Der ausgewählte Feed versuchte Anhänge mit ungültigen Parametern abzurufen.',
	'INVALID_PLURAL_RULE'		=> 'Die ausgewählte Plural-Regel ist ungültig. Zulässig sind ganzzahlige Werte von 0 bis 15.',
	'IP'						=> 'IP',
	'IP_BLACKLISTED'			=> 'Ihre IP-Adresse %1$s wurde gesperrt, da sie auf der schwarzen Liste steht. Details finden Sie unter <a href="%2$s">%2$s</a>.',

	'JABBER'				=> 'Jabber',
	'JOINED'				=> 'Registriert',
	'JUMP_PAGE'				=> 'Geben Sie die Nummer der Seite an, zu der Sie gehen möchten.',
	'JUMP_TO'				=> 'Gehe zu',
	'JUMP_TO_PAGE'			=> 'Gehe zu Seite',
	'JUMP_TO_PAGE_CLICK'	=> 'Klicken Sie, um auf Seite … zu gehen',

	'KB'					=> 'KB',
	'KIB'					=> 'KiB',

	'LAST_POST'							=> 'Letzter Beitrag',
	'LAST_UPDATED'						=> 'Letzte Aktualisierung',
	'LAST_VISIT'						=> 'Letzter Besuch',
	'LDAP_NO_LDAP_EXTENSION'			=> 'Die LDAP-Erweiterung steht nicht zur Verfügung.',
	'LDAP_NO_SERVER_CONNECTION'			=> 'Es konnte keine Verbindung zum LDAP-Server aufgebaut werden.',
	'LDAP_SEARCH_FAILED'				=> 'Beim Durchsuchen des LDAP-Verzeichnisses ist ein Fehler aufgetreten.',
	'LEGEND'							=> 'Legende',
	'LIVE_SEARCHES_NOT_ALLOWED'			=> 'Suchvorschläge sind nicht zugelassen.',
	'LOADING'							=> 'Lade',
	'LOCATION'							=> 'Wohnort',
	'LOCK_POST'							=> 'Beitrag sperren',
	'LOCK_POST_EXPLAIN'					=> 'verhindert Änderungen',
	'LOCK_TOPIC'						=> 'Thema sperren',
	'LOGIN'								=> 'Anmelden',
	'LOGIN_CHECK_PM'					=> 'Melden Sie sich an, um Ihre Privaten Nachrichten zu prüfen.',
	'LOGIN_CONFIRMATION'				=> 'Bestätigung der Anmeldung',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'Um einen Brute-Force-Angriff auf Benutzerkonten zu verhindern, müssen Sie nach einer bestimmten Anzahl von fehlerhaften Anmeldungen einen Bestätigungscode angeben. Der Code wird im unten stehenden Bild angezeigt. Wenn Sie nur über ein eingeschränktes Sehvermögen verfügen oder aus einem anderen Grund den Code nicht lesen können, kontaktieren Sie bitte die %sBoard-Administration%s.', // unused
	'LOGIN_ERROR_ATTEMPTS'				=> 'Sie haben die maximal zulässige Anzahl von Anmeldeversuchen überschritten. Sie müssen nun Ihren Benutzernamen und Ihr Passwort erneut eingeben sowie ein Sicherheitstest bestehen.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'Sie wurden nicht durch Apache authentifiziert.',
	'LOGIN_ERROR_OAUTH_SERVICE_DOES_NOT_EXIST'	=> 'Es wurde ein nicht existierender OAuth-Dienst angefordert.',
	'LOGIN_ERROR_PASSWORD'				=> 'Sie haben ein falsches Passwort angegeben. Bitte prüfen Sie Ihr Passwort und versuchen Sie es erneut. Wenn Sie weiterhin auf Probleme stoßen, wenden Sie sich bitte an die %sBoard-Administration%s.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'Als dieses Board aktualisiert wurde, konnte Ihr Passwort nicht konvertiert werden. Bitte %sfordern Sie ein neues Passwort an%s. Wenn Sie weiterhin Probleme beim Zugriff auf dieses Board haben, wenden Sie sich bitte an die %sBoard-Administration%s.',
	'LOGIN_ERROR_USERNAME'				=> 'Sie haben einen falschen Benutzernamen angegeben. Bitte prüfen Sie Ihren Benutzernamen und versuchen Sie es erneut. Wenn Sie weiterhin auf Probleme stoßen, wenden Sie sich bitte an die %sBoard-Administration%s.',
	'LOGIN_FORUM'						=> 'Um in diesem Forum einen Beitrag anzusehen oder zu erstellen, müssen Sie das Foren-Passwort eingeben.',
	'LOGIN_INFO'						=> 'Sie müssen in diesem Forum registriert sein, um sich anmelden zu können. Die Registrierung ist in wenigen Augenblicken erledigt und ermöglicht es Ihnen, auf weitere Funktionen zuzugreifen. Die Board-Administration kann registrierten Benutzern auch zusätzliche Berechtigungen zuweisen. Beachten Sie bitte unsere Nutzungsbedingungen und die verwandten Regelungen, bevor Sie sich registrieren. Bitte beachten Sie auch die jeweiligen Forenregeln, wenn Sie sich in diesem Board bewegen.',
	'LOGIN_VIEWFORUM'					=> 'Um Beiträge in diesem Forum anzusehen, müssen Sie auf diesem Board registriert und angemeldet sein.',
	'LOGIN_EXPLAIN_EDIT'				=> 'Um Beiträge in diesem Forum zu ändern, müssen Sie registriert und angemeldet sein.',
	'LOGIN_EXPLAIN_VIEWONLINE'			=> 'Um die Wer-ist-online-Liste anzusehen, müssen Sie auf diesem Board registriert und angemeldet sein.',
	'LOGIN_REQUIRED'					=> 'Sie müssen angemeldet sein, um diesen Vorgang durchzuführen.',
	'LOGOUT'							=> 'Abmelden',
	'LOGOUT_USER'						=> 'Abmelden [ %s ]',
	'LOG_ME_IN'							=> 'Angemeldet bleiben',

	'MAIN'					=> 'Übersicht', // TODO: Übersetzung: Main
	'MARK'					=> 'Markieren',
	'MARK_ALL'				=> 'Alle markieren',
	'MARK_ALL_READ'			=> 'Alle als gelesen markieren',
	'MARK_FORUMS_READ'		=> 'Foren als gelesen markieren',
	'MARK_READ'				=> 'Als gelesen markieren',
	'MARK_SUBFORUMS_READ'	=> 'Unterforen als gelesen markieren',
	'MB'					=> 'MB',
	'MIB'					=> 'MiB',
	'MCP'					=> 'Moderations-Bereich',
	'MCP_SHORT'				=> 'Mod.',
	'MEMBERLIST'			=> 'Mitglieder',
	'MEMBERLIST_EXPLAIN'	=> 'Zeigt eine vollständige Liste aller Mitglieder an',
	'MERGE'					=> 'Zusammenführen',
	'MERGE_POSTS'			=> 'Beiträge verschieben',
	'MERGE_TOPIC'			=> 'Thema zusammenführen',
	'MESSAGE'				=> 'Nachricht',
	'MESSAGES'				=> 'Nachrichten',
	'MESSAGES_COUNT'		=> array(
		0	=> 'beliebig vielen Nachrichten',
		1	=> '%d Nachricht',
		2	=> '%d Nachrichten',
	),
	'MESSAGE_BODY'			=> 'Nachrichtentext',
	'MINUTES'				=> 'Minuten',
	'MODERATE'				=> 'Moderieren',
	'MODERATOR'				=> 'Moderator',
	'MODERATORS'			=> 'Moderatoren',
	'MODULE_NOT_ACCESS'		=> 'Auf das Modul kann nicht zugegriffen werden',
	'MODULE_NOT_FIND'		=> 'Kann Modul %s nicht finden',
	'MODULE_FILE_INCORRECT_CLASS'	=> 'Die Modul-Datei %s beinhaltet nicht die korrekte Klasse [%s]',
	'MONTH'					=> 'Monat',
	'MOVE'					=> 'Verschieben',

	'NA'						=> 'n/a',
	'NEWEST_USER'				=> 'Unser neuestes Mitglied: <strong>%s</strong>',
	'NEW_MESSAGE'				=> 'Neue Nachricht',
	'NEW_MESSAGES'				=> 'Neue Nachrichten',
	'NEW_POST'					=> 'Neuer Beitrag',	// Not used anymore
	'NEW_POSTS'					=> 'Neue Beiträge',	// Not used anymore
	'NEXT'						=> 'Nächste',		// Used in pagination
	'NEXT_STEP'					=> 'Weiter',
	'NEVER'						=> 'Niemals',
	'NO'						=> 'Nein',
	'NO_NOTIFICATIONS'			=> 'Sie haben keine Benachrichtigungen',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'Sie dürfen diese Gruppe nicht verwalten.',
	'NOT_AUTHORISED'			=> 'Sie haben keine Berechtigung, diesen Bereich zu betreten.',
	'NOT_WATCHING_FORUM'		=> 'Sie werden nicht mehr über neue Beiträge in diesem Forum informiert.',
	'NOT_WATCHING_TOPIC'		=> 'Sie werden nicht mehr über neue Beiträge in diesem Thema informiert.',
	'NOTIFICATIONS'				=> 'Benachrichtigungen',
	// This applies for NOTIFICATION_BOOKMARK and NOTIFICATION_POST.
	// %1$s will return a list of users that's concatenated using "," and "and" - see STRING_LIST
	// Once the user count reaches 5 users or more, the list is trimmed using NOTIFICATION_X_OTHERS
	// Once the user count reaches 20 users or more, the list is trimmed using NOTIFICATION_MANY_OTHERS
	// Examples:
	// A replied...
	// A and B replied...
	// A, B and C replied...
	// A, B, C and 2 others replied...
	// A, B, C and others replied...
	'NOTIFICATION_BOOKMARK'				=> array(
		1	=> '<strong>Antwort</strong> von %1$s in Thema mit gesetztem Lesezeichen.',
		2	=> '<strong>Antworten</strong> von %1$s in Thema mit gesetztem Lesezeichen.',
	),
	'NOTIFICATION_FORUM'				=> '<em>Forum:</em> %1$s',
	'NOTIFICATION_GROUP_REQUEST'		=> '<strong>Beitrittsgesuch</strong> von %1$s für Gruppe %2$s.',
	'NOTIFICATION_GROUP_REQUEST_APPROVED'	=> '<strong>Beitrittsgesuch akzeptiert</strong> für Gruppe %1$s.',
	'NOTIFICATION_METHOD_INVALID'		=> 'Die Methode „%s“ bezeichnet keine gültige Benachrichtigungs-Methode.',
	'NOTIFICATION_PM'					=> '<strong>Private Nachricht</strong> von %1$s',
	'NOTIFICATION_POST'					=> array(
		1	=> '<strong>Antwort</strong> von %1$s in Thema:',
		2	=> '<strong>Antworten</strong> von %1$s in Thema:',
	),
	'NOTIFICATION_POST_APPROVED'		=> '<strong>Beitrag freigegeben</strong>:',
	'NOTIFICATION_POST_DISAPPROVED'		=> '<strong>Beitragsfreigabe verweigert</strong>:',
	'NOTIFICATION_POST_IN_QUEUE'		=> '<strong>Beitragsfreigabe</strong> angefordert von %1$s:',
	'NOTIFICATION_QUOTE'				=> array(
		1	=> '<strong>Zitiert</strong> von %1$s in:',
		2	=> '<strong>Zitiert</strong> von %1$s in:',
	),
	'NOTIFICATION_REFERENCE'			=> '„%1$s“',
	'NOTIFICATION_REASON'				=> '<em>Grund:</em> %1$s.',
	'NOTIFICATION_REPORT_PM'			=> '<strong>Private Nachricht gemeldet</strong> von %1$s:',
	'NOTIFICATION_REPORT_PM_CLOSED'		=> '<strong>Meldung zu Privater Nachricht geschlossen</strong> von %1$s:',
	'NOTIFICATION_REPORT_POST'			=> '<strong>Beitrag gemeldet</strong> von %1$s:',
	'NOTIFICATION_REPORT_CLOSED'		=> '<strong>Meldung geschlossen</strong> von %1$s für:',
	'NOTIFICATION_TOPIC'				=> '<strong>Neues Thema</strong> von %1$s:',
	'NOTIFICATION_TOPIC_APPROVED'		=> '<strong>Thema freigegeben</strong>:',
	'NOTIFICATION_TOPIC_DISAPPROVED'	=> '<strong>Themenfreigabe verweigert</strong>:',
	'NOTIFICATION_TOPIC_IN_QUEUE'		=> '<strong>Themenfreigabe</strong> angefordert von %1$s:',
	'NOTIFICATION_TYPE_NOT_EXIST'		=> 'Die notwendige Datei für die Benachrichtigungs-Art „%s“ ist nicht vorhanden.',
	'NOTIFICATION_ADMIN_ACTIVATE_USER'	=> '<strong>Benutzerfreigabe erforderlich</strong> für deaktivierten oder kürzlich registrierten Benutzer: „%1$s“',
	// Used in conjunction with NOTIFICATION_BOOKMARK and NOTIFICATION_POST.
	'NOTIFICATION_MANY_OTHERS'			=> 'viele weitere Mitglieder',
	'NOTIFICATION_X_OTHERS'				=> array(
		2	=> '%d weitere Mitglieder',
	),
	'NOTIFY_ADMIN'				=> 'Bitte informieren Sie die Board-Administration oder den Webmaster.',
	'NOTIFY_ADMIN_EMAIL'		=> 'Bitte informieren Sie die Board-Administration oder den Webmaster: <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'		=> 'Sie haben keine Berechtigung, auf diese Datei zuzugreifen.',
	'NO_ACTION'					=> 'Keine Aktion angegeben.',
	'NO_ADMINISTRATORS'			=> 'Es existieren keine Administratoren.',
	'NO_AUTH_ADMIN'				=> 'Ein Zugriff auf den Administrations-Bereich ist nicht möglich, da Sie keine administrativen Berechtigungen haben.',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'Sie können Ihre Anmeldung nicht mit einem anderen Benutzerkonto bestätigen.',
	'NO_AUTH_OPERATION'			=> 'Sie haben keine ausreichende Berechtigung, um diesen Vorgang durchzuführen.',
	'NO_AVATARS'				=> 'Es stehen keine Avatare zur Verfügung',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'Verbindung zum SMTP-Server kann nicht hergestellt werden: %1$s : %2$s.',
	'NO_BIRTHDAYS'				=> 'Heute hat kein Mitglied Geburtstag',
	'NO_EMAIL_MESSAGE'			=> 'Die E-Mail-Nachricht ist leer.',
	'NO_EMAIL_RESPONSE_CODE'	=> 'Der Antwort-Code des Servers konnte nicht empfangen werden.',
	'NO_EMAIL_SUBJECT'			=> 'Es wurde kein Betreff für die E-Mail angegeben.',
	'NO_FORUM'					=> 'Das von Ihnen ausgewählte Forum existiert nicht.',
	'NO_FORUMS'					=> 'Dieses Board hat keine Foren.',
	'NO_GROUP'					=> 'Die von Ihnen ausgewählte Benutzergruppe existiert nicht.',
	'NO_GROUP_MEMBERS'			=> 'Diese Gruppe hat keine Mitglieder.',
	'NO_IPS_DEFINED'			=> 'Keine IP-Adressen oder Hostnamen festgelegt.',
	'NO_MEMBERS'				=> 'Es wurden keine Mitglieder gefunden, die den Suchkriterien entsprechen.',
	'NO_MESSAGES'				=> 'Keine Nachrichten',
	'NO_MODE'					=> 'Kein Modus angegeben.',
	'NO_MODERATORS'				=> 'Es existieren keine Moderatoren.',
	'NO_NEW_MESSAGES'			=> 'Keine neuen Nachrichten',
	'NO_NEW_POSTS'				=> 'Keine neuen Beiträge',	// Not used anymore
	'NO_ONLINE_USERS'			=> '0 Mitglieder',
	'NO_POSTS'					=> 'Keine Beiträge',
	'NO_POSTS_TIME_FRAME'		=> 'Für den ausgewählten Zeitraum existieren keine Beiträge in diesem Thema.',
	'NO_FEED_ENABLED'			=> 'Auf diesem Board sind keine Feeds verfügbar.',
	'NO_FEED'					=> 'Der angeforderte Feed ist nicht verfügbar.',
	'NO_STYLE_DATA'				=> 'Die Style-Daten für user_style %s von user_id %s konnten nicht abgerufen werden.',
	'NO_STYLE_CFG'				=> 'Die Konfigurationsdatei für folgenden Style konnte nicht geladen werden: %s',
	'NO_SUBJECT'				=> 'Kein Betreff vorhanden',								// Used for posts having no subject defined but displayed within management pages.
	'NO_SUCH_SEARCH_MODULE'		=> 'Das angegebene Such-Backend existiert nicht.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'Keine unterstützte Authentifizierungs-Methode vorhanden.',
	'NO_TOPIC'					=> 'Das von Ihnen ausgewählte Thema existiert nicht.',
	'NO_TOPIC_FORUM'			=> 'Das von Ihnen ausgewählte Thema oder Forum existiert nicht mehr.',
	'NO_TOPICS'					=> 'In diesem Forum gibt es keine Themen oder Beiträge.',
	'NO_TOPICS_TIME_FRAME'		=> 'Für den ausgewählten Zeitraum existieren keine Themen in diesem Forum.',
	'NO_UNREAD_POSTS'			=> 'Keine ungelesenen Beiträge',
	'NO_UPLOAD_FORM_FOUND'		=> 'Ein Datei-Upload wurde angestoßen, aber es wurde kein gültiges Upload-Formular gefunden.',
	'NO_USER'					=> 'Der von Ihnen ausgewählte Benutzer existiert nicht.',
	'NO_USERS'					=> 'Die von Ihnen ausgewählten Benutzer existieren nicht.',
	'NO_USER_SPECIFIED'			=> 'Es wurde kein Benutzername angegeben.',

	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_ATTACHMENTS'		=> array(
		1	=> '%d Dateianhang',
		2	=> '%d Dateianhänge',
	),
	'NUM_POSTS_IN_QUEUE'		=> array(
		0			=> 'Kein Beitrag in der Warteschlange',		// 0
		1			=> '1 Beitrag in der Warteschlange',		// 1
		2			=> '%d Beiträge in der Warteschlange',		// 2+
	),

	'OCCUPATION'				=> 'Tätigkeit',
	'OFFLINE'					=> 'Offline',
	'ONLINE'					=> 'Online',
	'ONLINE_BUDDIES'			=> 'Freunde online',
	// "... :: x registered and y hidden"
	'ONLINE_USERS_TOTAL'		=> array(
		1	=> 'Insgesamt ist <strong>%1$d</strong> Besucher online :: %2$s und %3$s',
		2	=> 'Insgesamt sind <strong>%1$d</strong> Besucher online :: %2$s und %3$s',
	),
	// "... :: x registered, y hidden and z guests"
	'ONLINE_USERS_TOTAL_GUESTS'	=> array(
		1	=> 'Insgesamt ist <strong>%1$d</strong> Besucher online :: %2$s, %3$s und %4$s',
		2	=> 'Insgesamt sind <strong>%1$d</strong> Besucher online :: %2$s, %3$s und %4$s',
	),
	'OPTIONS'					=> 'Optionen',

	'PAGE_NOT_FOUND'		=> 'Die angeforderte Seite konnte nicht gefunden werden.',
	'PAGE_OF'					=> 'Seite <strong>%1$d</strong> von <strong>%2$d</strong>',
	'PAGE_TITLE_NUMBER'		=> 'Seite %s',
	'PASSWORD'					=> 'Passwort',
	'PIXEL'						=> 'px',
	'PIXELS'				=> array(
		1	=> '%d Pixel',
		2	=> '%d Pixel',
	),
	'PLEASE_WAIT'			=> 'Bitte warten Sie.',
	'PM'					=> 'PN',
	'PM_REPORTED'			=> 'Meldung zu dieser Nachricht anzeigen',
	'POSTING_MESSAGE'		=> 'Erstellt eine Nachricht in %s',
	'POSTING_PRIVATE_MESSAGE'=> 'Erstellt eine Private Nachricht',
	'POST'					=> 'Beitrag',
	'POST_ANNOUNCEMENT'		=> 'Bekanntmachung',
	'POST_STICKY'			=> 'Wichtig',
	'POSTED'				=> 'Verfasst',
	'POSTED_IN_FORUM'		=> 'in',
	'POSTED_ON_DATE'		=> 'am',
	'POSTS'					=> 'Beiträge',
	'POSTS_UNAPPROVED'		=> 'Mindestens ein Beitrag in diesem Thema wurde noch nicht freigegeben.',
	'POSTS_UNAPPROVED_FORUM'=> 'Mindestens ein Beitrag in diesem Forum wurde noch nicht freigegeben.',
	'POST_BY_AUTHOR'		=> 'von',
	'POST_BY_FOE'			=> 'Dieser Beitrag wurde von <strong>%1$s</strong>, einem von Ihnen ignorierten Mitglied, erstellt.',
	'POST_DISPLAY'			=> 'Diesen Beitrag anzeigen',
	'POST_DAY'				=> '%.2f Beiträge pro Tag',
	'POST_DELETED_ACTION'	=> 'Gelöschter Beitrag:',
	'POST_DELETED'			=> 'Dieser Beitrag wurde gelöscht.',
	'POST_DELETED_BY'		=> '<strong>%2$s</strong> hat den Beitrag von <strong>%1$s</strong> am %3$s gelöscht.',
	'POST_DELETED_BY_REASON'=> '<strong>%2$s</strong> hat den Beitrag von <strong>%1$s</strong> am %3$s aus folgendem Grund gelöscht: %4$s',
	'POST_DETAILS'			=> 'Beitrags-Details',
	'POST_NEW_TOPIC'		=> 'Ein neues Thema erstellen',
	'POST_PCT'				=> '%.2f%% aller Beiträge',
	'POST_PCT_ACTIVE'		=> '%.2f%% der Beiträge des Benutzers',
	'POST_PCT_ACTIVE_OWN'	=> '%.2f%% Ihrer Beiträge',
	'POST_REPLY'			=> 'Antwort erstellen',
	'POST_REPORTED'			=> 'Meldung zu diesem Beitrag anzeigen',
	'POST_SUBJECT'			=> 'Betreff des Beitrags',
	'POST_TIME'				=> 'Erstellungsdatum',
	'POST_TOPIC'			=> 'Neues Thema erstellen',
	'POST_UNAPPROVED_ACTION'	=> 'Auf Freigabe wartender Beitrag:',
	'POST_UNAPPROVED'		=> 'Dieser Beitrag wurde noch nicht freigegeben.',
	'POST_UNAPPROVED_EXPLAIN'	=> 'Dieser Beitrag kann von anderen Benutzern nicht gelesen werden, bis er von einem Moderator freigegeben wurde.',
	'POWERED_BY'			=> 'Powered by %s',

	'QUOTE'					=> 'Zitat',

	'PREVIEW'				=> 'Vorschau',
	'PREVIOUS'				=> 'Vorherige',		// Used in pagination
	'PREVIOUS_STEP'			=> 'Zurück',
	'PRIVACY'				=> 'Datenschutzerklärung',
	'PRIVACY_LINK'			=> 'Datenschutz',
	'PRIVATE_MESSAGE'		=> 'Private Nachricht',
	'PRIVATE_MESSAGES'		=> 'Private Nachrichten',
	'PRIVATE_MESSAGING'		=> 'Private Nachrichten',
	'PROFILE'				=> 'Persönlicher Bereich',

	'QUICK_LINKS'			=> 'Schnellzugriff',

	'RANK'						=> 'Rang',
	'READING_FORUM'				=> 'Liest Themen in %s',
	'READING_GLOBAL_ANNOUNCE'	=> 'Liest eine globale Bekanntmachung',
	'READING_LINK'				=> 'Folgt dem Forums-Link %s',
	'READING_TOPIC'				=> 'Liest Thema in %s',
	'READ_PROFILE'				=> 'Profil',
	'REASON'					=> 'Grund',
	'RECORD_ONLINE_USERS'		=> 'Der Besucherrekord liegt bei <strong>%1$s</strong> Besuchern, die am %2$s gleichzeitig online waren.',
	'REDIRECT'					=> 'Weiterleiten',
	'REDIRECTS'					=> 'Aufrufe insgesamt',
	'REGISTER'					=> 'Registrieren',
	'REGISTERED_USERS'			=> 'Mitglieder:',
	// "... and 2 hidden users online"
	'REG_USERS_ONLINE'			=> array(
		1	=> 'Es ist %1$d Mitglied und %2$s online',
		2	=> 'Es sind %1$d Mitglieder und %2$s online',
	),
	'REG_USERS_TOTAL'			=> array(
		1	=> '%d sichtbares Mitglied',
		2	=> '%d sichtbare Mitglieder',
	),
	'REMOVE'					=> 'Löschen',
	'REMOVE_INSTALL'			=> 'Bitte löschen, verschieben oder benennen Sie das Installations-Verzeichnis „install“ um, bevor Sie das Board benutzen. Solange dieses Verzeichnis existiert, ist nur der Administrations-Bereich zugänglich.',
	'REPLIES'					=> 'Antworten',
	'REPLY_WITH_QUOTE'			=> 'Mit Zitat antworten',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'Beantwortet eine globale Bekanntmachung',
	'REPLYING_MESSAGE'			=> 'Beantwortet eine Nachricht in %s',
	'REPORT_BY'					=> 'Gemeldet von',
	'REPORT_POST'				=> 'Diesen Beitrag melden',
	'REPORTING_POST'			=> 'Meldet einen Beitrag',
	'RESEND_ACTIVATION'			=> 'Die Aktivierungs-E-Mail erneut senden',
	'RESET'						=> 'Zurücksetzen',
	'RESTORE_PERMISSIONS'		=> 'Berechtigungen wiederherstellen',
	'RETURN_INDEX'				=> '%sZurück zur Foren-Übersicht%s',
	'RETURN_FORUM'				=> '%sZurück zum zuletzt besuchten Forum%s',
	'RETURN_PAGE'				=> '%sZurück zur vorherigen Seite%s',
	'RETURN_TOPIC'				=> '%sZurück zum zuletzt besuchten Thema%s',
	'RETURN_TO'					=> 'Zurück zu „%s“',
	'RETURN_TO_INDEX'			=> 'Zurück zur Foren-Übersicht',

	'ROUTE_NOT_FOUND'				=> 'Die angeforderte Route „%s” konnte nicht gefunden werden.',
	'ROUTE_INVALID_MISSING_PARAMS'	=> 'Die übergebenen Parameter für die Route „%s“ sind ungültig oder fehlen.',

	'FEED'						=> 'Feed',
	'FEED_NEWS'					=> 'Neuigkeiten',
	'FEED_TOPICS_ACTIVE'		=> 'Aktive Themen',
	'FEED_TOPICS_NEW'			=> 'Neue Themen',
	'RULES_ATTACH_CAN'			=> 'Sie <strong>dürfen</strong> Dateianhänge in diesem Forum erstellen.',
	'RULES_ATTACH_CANNOT'		=> 'Sie dürfen <strong>keine</strong> Dateianhänge in diesem Forum erstellen.',
	'RULES_DELETE_CAN'			=> 'Sie <strong>dürfen</strong> Ihre Beiträge in diesem Forum löschen.',
	'RULES_DELETE_CANNOT'		=> 'Sie dürfen Ihre Beiträge in diesem Forum <strong>nicht</strong> löschen.',
	'RULES_DOWNLOAD_CAN'		=> 'Sie <strong>dürfen</strong> Dateianhänge in diesem Forum herunterladen.',
	'RULES_DOWNLOAD_CANNOT'		=> 'Sie dürfen <strong>keine</strong> Dateianhänge in diesem Forum herunterladen.',
	'RULES_EDIT_CAN'			=> 'Sie <strong>dürfen</strong> Ihre Beiträge in diesem Forum ändern.',
	'RULES_EDIT_CANNOT'			=> 'Sie dürfen Ihre Beiträge in diesem Forum <strong>nicht</strong> ändern.',
	'RULES_LOCK_CAN'			=> 'Sie <strong>dürfen</strong> Ihre Themen in diesem Forum sperren.',
	'RULES_LOCK_CANNOT'			=> 'Sie dürfen Ihre Themen in diesem Forum <strong>nicht</strong> sperren.',
	'RULES_POST_CAN'			=> 'Sie <strong>dürfen</strong> neue Themen in diesem Forum erstellen.',
	'RULES_POST_CANNOT'			=> 'Sie dürfen <strong>keine</strong> neuen Themen in diesem Forum erstellen.',
	'RULES_REPLY_CAN'			=> 'Sie <strong>dürfen</strong> Antworten zu Themen in diesem Forum erstellen.',
	'RULES_REPLY_CANNOT'		=> 'Sie dürfen <strong>keine</strong> Antworten zu Themen in diesem Forum erstellen.',
	'RULES_VOTE_CAN'			=> 'Sie <strong>dürfen</strong> an Abstimmungen in diesem Forum teilnehmen.',
	'RULES_VOTE_CANNOT'			=> 'Sie dürfen an Abstimmungen in diesem Forum <strong>nicht</strong> teilnehmen.',

	'SEARCH'					=> 'Suche',
	'SEARCH_MINI'				=> 'Suche…',
	'SEARCH_ADV'				=> 'Erweiterte Suche',
	'SEARCH_ADV_EXPLAIN'		=> 'Zeigt die erweiterten Suchoptionen an',
	'SEARCH_KEYWORDS'			=> 'Suche nach Wörtern',
	'SEARCHING_FORUMS'			=> 'Durchsucht das Forum',
	'SEARCH_ACTIVE_TOPICS'		=> 'Aktive Themen',
	'SEARCH_FOR'				=> 'Suche nach',
	'SEARCH_FORUM'				=> 'Forum durchsuchen…',
	'SEARCH_NEW'				=> 'Neue Beiträge',
	'SEARCH_POSTS_BY'			=> 'Suche Beiträge von',
	'SEARCH_SELF'				=> 'Eigene Beiträge',
	'SEARCH_TOPIC'				=> 'Thema durchsuchen…',
	'SEARCH_UNANSWERED'			=> 'Unbeantwortete Themen',
	'SEARCH_UNREAD'				=> 'Ungelesene Beiträge',
	'SEARCH_USER_POSTS'			=> 'Beiträge des Benutzers suchen',
	'SECONDS'					=> 'Sekunden',
	'SEE_ALL'					=> 'Alle anzeigen',
	'SELECT'					=> 'Auswählen',
	'SELECT_ALL_CODE'			=> 'Alles auswählen',
	'SELECT_DESTINATION_FORUM'	=> 'Wählen Sie bitte ein Zielforum aus',
	'SELECT_FORUM'				=> 'Wählen Sie ein Forum aus',
	'SEND_EMAIL'				=> 'E-Mail senden',				// Used for submit buttons
	'SEND_EMAIL_USER'			=> 'E-Mail an %s senden',
	'SEND_PRIVATE_MESSAGE'		=> 'Private Nachricht senden',
	'SETTINGS'					=> 'Einstellungen',
	'SIGNATURE'					=> 'Signatur',
	'SKIP'						=> 'Zum Inhalt',
	'SKYPE'						=> 'Skype',
	'SMTP_NO_AUTH_SUPPORT'		=> 'Der SMTP-Server unterstützt keine Authentifizierung.',
	'SORRY_AUTH_READ'			=> 'Sie haben keine Berechtigung, dieses Forum zu lesen.',
	'SORRY_AUTH_READ_TOPIC'		=> 'Sie haben keine Berechtigung, dieses Thema zu lesen.',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'Sie haben keine Berechtigung, diesen Dateianhang herunterzuladen.',
	'SORT_BY'					=> 'Sortiere nach',
	'SORT_DIRECTION'			=> 'Richtung',
	'SORT_JOINED'				=> 'Registrierungsdatum',
	'SORT_OPTIONS'				=> 'Anzeige- und Sortierungs-Einstellungen',
	'SORT_LOCATION'				=> 'Wohnort',
	'SORT_RANK'					=> 'Rang',
	'SORT_POSTS'				=> 'Beiträge',
	'SORT_TOPIC_TITLE'			=> 'Betreff des Themas',
	'SORT_USERNAME'				=> 'Benutzername',
	'SPLIT_TOPIC'				=> 'Thema teilen',
	'SQL_ERROR_OCCURRED'		=> 'Beim Laden der Seite ist ein SQL-Fehler aufgetreten. Bitte kontaktieren Sie die %sBoard-Administration%s, falls dieses Problem fortlaufend auftritt.',
	'STATISTICS'				=> 'Statistik',
	'START_WATCHING_FORUM'		=> 'Forum abonnieren',
	'START_WATCHING_TOPIC'		=> 'Thema abonnieren',
	'STOP_WATCHING_FORUM'		=> 'Abonnement des Forums beenden',
	'STOP_WATCHING_TOPIC'		=> 'Abonnement des Themas beenden',
	'STRING_LIST_MULTI'			=> '%1$s und %2$s',
	'STRING_LIST_SIMPLE'		=> '%1$s und %2$s',
	'SUBFORUM'					=> 'Unterforum',
	'SUBFORUMS'					=> 'Unterforen',
	'SUBJECT'					=> 'Betreff',
	'SUBMIT'					=> 'Absenden',

	'TB'				=> 'TB',
	'TERMS_LINK'		=> 'Nutzungsbedingungen',
	'TERMS_USE'			=> 'Nutzungsbedingungen',
	'TEST_CONNECTION'	=> 'Verbindung testen',
	'THE_TEAM'			=> 'Das Team',
	'TIB'				=> 'TiB',
	'TIME'				=> 'Zeit',
	'TIMEOUT_PROCESSING_REQ'			=> 'Bei der Anfrage ist eine Zeitüberschreitung aufgetreten.',

	'TOO_LARGE'						=> 'Der angegebene Wert ist zu groß.',
	'TOO_LARGE_MAX_RECIPIENTS'		=> 'Die Zahl, die als <strong>Maximale Anzahl zulässiger Empfänger pro Privater Nachricht</strong> angegeben wurde, ist zu groß.',

	'TOO_LONG'						=> 'Der angegebene Wert ist zu lang.',

	'TOO_LONG_CONFIRM_CODE'			=> 'Der angegebene Bestätigungscode ist zu lang.',
	'TOO_LONG_DATEFORMAT'			=> 'Das angegebene Datums-Format ist zu lang.',
	'TOO_LONG_JABBER'				=> 'Die angegebene Jabber-ID ist zu lang.',
	'TOO_LONG_NEW_PASSWORD'			=> 'Das angegebene Passwort ist zu lang.',
	'TOO_LONG_PASSWORD_CONFIRM'		=> 'Die angegebene Bestätigung des Passworts ist zu lang.',
	'TOO_LONG_USER_PASSWORD'		=> 'Das angegebene Passwort ist zu lang.',
	'TOO_LONG_USERNAME'				=> 'Der angegebene Benutzername ist zu lang.',
	'TOO_LONG_EMAIL'				=> 'Die angegebene E-Mail-Adresse ist zu lang.',

	'TOO_MANY_VOTE_OPTIONS'			=> 'Sie haben versucht, für zu viele Optionen zu stimmen.',

	'TOO_SHORT'						=> 'Der angegebene Wert ist zu kurz.',

	'TOO_SHORT_CONFIRM_CODE'		=> 'Der angegebene Bestätigungscode ist zu kurz.',
	'TOO_SHORT_DATEFORMAT'			=> 'Das angegebene Datums-Format ist zu kurz.',
	'TOO_SHORT_JABBER'				=> 'Die angegebene Jabber-ID ist zu kurz.',
	'TOO_SHORT_NEW_PASSWORD'		=> 'Das angegebene Passwort ist zu kurz.',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'Die angegebene Bestätigung für das Passwort ist zu kurz.',
	'TOO_SHORT_USER_PASSWORD'		=> 'Das angegebene Passwort ist zu kurz.',
	'TOO_SHORT_USERNAME'			=> 'Der angegebene Benutzername ist zu kurz.',
	'TOO_SHORT_EMAIL'				=> 'Die angegebene E-Mail-Adresse ist zu kurz.',
	'TOO_SHORT_EMAIL_CONFIRM'		=> 'Die angegebene Bestätigung der E-Mail-Adresse ist zu kurz.',
	'TOO_SMALL'						=> 'Der angegebene Wert ist zu klein.',
	'TOO_SMALL_MAX_RECIPIENTS'		=> 'Die Zahl, die als <strong>Maximale Anzahl zulässiger Empfänger pro Privater Nachricht</strong> angegeben wurde, ist zu klein.',

	'TOPIC'				=> 'Thema',
	'TOPICS'			=> 'Themen',
	'TOPICS_UNAPPROVED'	=> 'Mindestens ein Thema in diesem Forum wurde noch nicht freigegeben.',
	'TOPIC_ICON'		=> 'Themen-Symbol',
	'TOPIC_LOCKED'		=> 'Dieses Thema ist gesperrt. Sie können keine Beiträge editieren oder weitere Antworten erstellen.',
	'TOPIC_LOCKED_SHORT'=> 'Thema gesperrt',
	'TOPIC_MOVED'		=> 'Verschobenes Thema',
	'TOPIC_REVIEW'		=> 'Die letzten Beiträge des Themas',
	'TOPIC_TITLE'		=> 'Titel des Themas',
	'TOPIC_UNAPPROVED'	=> 'Dieses Thema wurde noch nicht freigegeben.',
	'TOPIC_UNAPPROVED_FORUM'	=> array(
		1	=> 'Thema wartet auf Freigabe',
		2	=> 'Themen warten auf Freigabe',
	),
	'TOPIC_DELETED'		=> 'Dieses Thema wurde gelöscht.',
	'TOTAL_ATTACHMENTS'	=> 'Dateianhang',
	'TOTAL_LOGS'		=> array(
		1	=> '%d Protokoll-Eintrag',
		2	=> '%d Protokoll-Einträge',
	),
	'TOTAL_PMS'		=> array(
		1	=> '%d Private Nachricht insgesamt',
		2	=> '%d Private Nachrichten insgesamt',
	),
	'TOPIC_POLL'		=> 'Dieses Thema beinhaltet eine Umfrage.',
	'TOTAL_POSTS'		=> 'Beiträge insgesamt',
	'TOTAL_POSTS_COUNT'	=> array(
		2	=> 'Beiträge insgesamt <strong>%d</strong>',
	),
	'TOPIC_REPORTED'	=> 'Dieses Thema wurde gemeldet',
	'TOTAL_TOPICS'		=> array(
		2	=> 'Themen insgesamt <strong>%d</strong>',
	),
	'TOTAL_USERS'		=> array(
		2	=> 'Mitglieder insgesamt <strong>%d</strong>',
	),
	'TRACKED_PHP_ERROR'	=> 'Aufgefangene PHP-Fehler: %s',
	'TWITTER'			=> 'Twitter',

	'UNABLE_GET_IMAGE_SIZE'	=> 'Die Größe des Bildes konnte nicht ermittelt werden. Bitte prüfen Sie, ob die angegebene URL korrekt ist.',
	'UNABLE_TO_DELIVER_FILE'=> 'Die Datei kann nicht übertragen werden.',
	'UNKNOWN_BROWSER'		=> 'Unbekannter Browser',
	'UNMARK_ALL'			=> 'Alle Markierungen entfernen',
	'UNREAD_MESSAGES'		=> 'Ungelesene Nachrichten',
	'UNREAD_POST'			=> 'Ungelesener Beitrag',
	'UNREAD_POSTS'			=> 'Ungelesene Beiträge',
	'UNWATCH_FORUM_CONFIRM'		=> 'Sind Sie sich sicher, dass Sie das Abonnement des Forums beenden möchten?',
	'UNWATCH_FORUM_DETAILED'	=> 'Sind Sie sich sicher, dass Sie das Forum „%s“ nicht mehr abonnieren möchten?',
	'UNWATCH_TOPIC_CONFIRM'		=> 'Sind Sie sich sicher, dass Sie das Abonnement des Themas beenden möchten?',
	'UNWATCH_TOPIC_DETAILED'	=> 'Sind Sie sich sicher, dass Sie das Thema „%s“ nicht mehr abonnieren möchten?',
	'UNWATCHED_FORUMS'			=> 'Die Abonnements für die ausgewählten Foren wurden beendet.',
	'UNWATCHED_TOPICS'			=> 'Die Abonnements für die ausgewählten Themen wurden beendet.',
	'UNWATCHED_FORUMS_TOPICS'	=> 'Die Abonnements für die ausgewählten Elemente wurden beendet.',
	'UPDATE'				=> 'Aktualisieren',
	'UPLOAD_IN_PROGRESS'	=> 'Die Datei wird hochgeladen.',
	'URL_REDIRECT'			=> 'Wenn Ihr Browser keine META-Weiterleitung unterstützt, %sklicken Sie hier, um auf die nächste Seite weitergeleitet zu werden%s.',
	'USERGROUPS'			=> 'Gruppen',
	'USERNAME'				=> 'Benutzername',
	'USERNAMES'				=> 'Benutzernamen',
	'USER_AVATAR'			=> 'Benutzeravatar',
	'USER_CANNOT_READ'		=> 'Sie können keine Beiträge in diesem Forum lesen.',
	'USER_POSTS'			=> array(
		1	=> '%d Beitrag',
		2	=> '%d Beiträge',
	),
	'USERS'					=> 'Benutzer',
	'USE_PERMISSIONS'		=> 'Berechtigungen des Benutzers testen',

	'USER_NEW_PERMISSION_DISALLOWED'	=> 'Leider sind Sie nicht berechtigt, diese Funktion zu nutzen. Sie haben sich vermutlich erst vor kurzem registriert und müssen sich noch mehr an Diskussionen im Board beteiligen, damit Sie diese Funktion nutzen können.',

	'VARIANT_DATE_SEPARATOR'	=> ' / ',	// Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'					=> 'Zugriffe',
	'VIEWED_COUNTS'		=> array(
		0	=> 'Noch nicht betrachtet',
		1	=> '%d mal betrachtet',
		2	=> '%d mal betrachtet',
	),
	'VIEWING_CONTACT_ADMIN'		=> 'Betrachtet die Kontaktseite',
	'VIEWING_FAQ'				=> 'Betrachtet die häufig gestellten Fragen (FAQ)',
	'VIEWING_MEMBERS'			=> 'Betrachtet die Mitgliederliste',
	'VIEWING_ONLINE'			=> 'Betrachtet „Wer ist online?“',
	'VIEWING_MCP'				=> 'Befindet sich im Moderations-Bereich',
	'VIEWING_MEMBER_PROFILE'	=> 'Betrachtet das Profil eines Mitglieds',
	'VIEWING_PRIVATE_MESSAGES'	=> 'Betrachtet Private Nachrichten',
	'VIEWING_REGISTER'			=> 'Registriert sich',
	'VIEWING_UCP'				=> 'Befindet sich im persönlichen Bereich',
	'VIEWS'						=> 'Zugriffe',
	'VIEW_BOOKMARKS'			=> 'Lesezeichen anzeigen',
	'VIEW_FORUM_LOGS'			=> 'Protokoll-Einträge anzeigen',
	'VIEW_LATEST_POST'			=> 'Neuester Beitrag',
	'VIEW_NEWEST_POST'			=> 'Erster ungelesener Beitrag',
	'VIEW_NOTES'				=> 'Notizen zu diesem Benutzer',
	'VIEW_ONLINE_TIMES'			=> array(
		1	=> 'basierend auf den aktiven Besuchern der letzten Minute',
		2	=> 'basierend auf den aktiven Besuchern der letzten %d Minuten',
	),
	'VIEW_TOPIC'				=> 'Thema anzeigen',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'Bekanntmachung: ',
	'VIEW_TOPIC_GLOBAL'			=> 'Globale Bekanntmachung: ',
	'VIEW_TOPIC_LOCKED'			=> 'Gesperrt: ',
	'VIEW_TOPIC_LOGS'			=> 'Protokoll anzeigen',
	'VIEW_TOPIC_MOVED'			=> 'Verschoben: ',
	'VIEW_TOPIC_POLL'			=> 'Umfrage: ',
	'VIEW_TOPIC_STICKY'			=> 'Wichtig: ',
	'VISIT_WEBSITE'				=> 'Besuche Website',

	'WARNINGS'			=> 'Verwarnungen',
	'WARN_USER'			=> 'Benutzer verwarnen',
	'WATCH_FORUM_CONFIRM'	=> 'Sind Sie sich sicher, dass Sie dieses Forum abonnieren möchten?',
	'WATCH_FORUM_DETAILED'	=> 'Sind Sie sich sicher, dass Sie das Forum „%s“ abonnieren möchten?',
	'WATCH_TOPIC_CONFIRM'	=> 'Sind Sie sich sicher, dass Sie dieses Thema abonnieren möchten?',
	'WATCH_TOPIC_DETAILED'	=> 'Sind Sie sich sicher, dass Sie das Thema „%s“ abonnieren möchten?',
	'WELCOME_SUBJECT'	=> 'Willkommen auf %s',
	'WEBSITE'			=> 'Website',
	'WHOIS'				=> 'Whois',
	'WHO_IS_ONLINE'		=> 'Wer ist online?',
	'WRONG_PASSWORD'	=> 'Sie haben ein falsches Passwort angegeben.',

	'WRONG_DATA_COLOUR'			=> 'Der angegebene Farbwert ist nicht gültig.',
	'WRONG_DATA_JABBER'			=> 'Die angegebene ID ist keine gültige Jabber-ID.',
	'WRONG_DATA_LANG'			=> 'Die von Ihnen ausgewählte Sprache ist nicht gültig.',
	'WRONG_DATA_POST_SD'		=> 'Die von Ihnen ausgewählte Sortierreihenfolge für Beiträge ist nicht gültig.',
	'WRONG_DATA_POST_SK'		=> 'Die von Ihnen ausgewählte Sortierungs-Option für Beiträge ist nicht gültig.',
	'WRONG_DATA_TOPIC_SD'		=> 'Die von Ihnen ausgewählte Sortierreihenfolge für Themen ist nicht gültig.',
	'WRONG_DATA_TOPIC_SK'		=> 'Die von Ihnen ausgewählte Sortierungs-Option für Themen ist nicht gültig.',
	'WROTE'						=> 'hat geschrieben',

	'YAHOO'				=> 'Yahoo Messenger',
	'YOUTUBE'			=> 'YouTube',
	'YEAR'				=> 'Jahr',
	'YEAR_MONTH_DAY'	=> '(JJJJ-MM-TT)',
	'YES'				=> 'Ja',
	'YOU_LAST_VISIT'	=> 'Ihr letzter Besuch: %s',

	'datetime'			=> array(
		'TODAY'		=> 'Heute',
		'TOMORROW'	=> 'Morgen',
		'YESTERDAY'	=> 'Gestern',
		'AGO'		=> array(
			0		=> 'vor weniger als einer Minute',
			1		=> 'vor %d Minute',
			2		=> 'vor %d Minuten',
		),

		'Sunday'	=> 'Sonntag',
		'Monday'	=> 'Montag',
		'Tuesday'	=> 'Dienstag',
		'Wednesday'	=> 'Mittwoch',
		'Thursday'	=> 'Donnerstag',
		'Friday'	=> 'Freitag',
		'Saturday'	=> 'Samstag',

		'Sun'		=> 'So',
		'Mon'		=> 'Mo',
		'Tue'		=> 'Di',
		'Wed'		=> 'Mi',
		'Thu'		=> 'Do',
		'Fri'		=> 'Fr',
		'Sat'		=> 'Sa',

		'January'	=> 'Januar',
		'February'	=> 'Februar',
		'March'		=> 'März',
		'April'		=> 'April',
		'May'		=> 'Mai',
		'June'		=> 'Juni',
		'July'		=> 'Juli',
		'August'	=> 'August',
		'September' => 'September',
		'October'	=> 'Oktober',
		'November'	=> 'November',
		'December'	=> 'Dezember',

		'Jan'		=> 'Jan',
		'Feb'		=> 'Feb',
		'Mar'		=> 'Mär',
		'Apr'		=> 'Apr',
		'May_short'	=> 'Mai',	// Short representation of "May". May_short used because in English the short and long date are the same for May.
		'Jun'		=> 'Jun',
		'Jul'		=> 'Jul',
		'Aug'		=> 'Aug',
		'Sep'		=> 'Sep',
		'Oct'		=> 'Okt',
		'Nov'		=> 'Nov',
		'Dec'		=> 'Dez',
	),

	// Timezones can be translated. We use this for the Etc/GMT timezones here,
	// because they are named invers to their offset.
	'timezones'		=> array(
		'UTC'			=> 'UTC',
		'UTC_OFFSET'			=> 'UTC%1$s',
		'UTC_OFFSET_CURRENT'	=> 'UTC%1$s - %2$s',

		'Etc/GMT-12'	=> 'UTC+12',
		'Etc/GMT-11'	=> 'UTC+11',
		'Etc/GMT-10'	=> 'UTC+10',
		'Etc/GMT-9'		=> 'UTC+9',
		'Etc/GMT-8'		=> 'UTC+8',
		'Etc/GMT-7'		=> 'UTC+7',
		'Etc/GMT-6'		=> 'UTC+6',
		'Etc/GMT-5'		=> 'UTC+5',
		'Etc/GMT-4'		=> 'UTC+4',
		'Etc/GMT-3'		=> 'UTC+3',
		'Etc/GMT-2'		=> 'UTC+2',
		'Etc/GMT-1'		=> 'UTC+1',
		'Etc/GMT+1'		=> 'UTC-1',
		'Etc/GMT+2'		=> 'UTC-2',
		'Etc/GMT+3'		=> 'UTC-3',
		'Etc/GMT+4'		=> 'UTC-4',
		'Etc/GMT+5'		=> 'UTC-5',
		'Etc/GMT+6'		=> 'UTC-6',
		'Etc/GMT+7'		=> 'UTC-7',
		'Etc/GMT+8'		=> 'UTC-8',
		'Etc/GMT+9'		=> 'UTC-9',
		'Etc/GMT+10'	=> 'UTC-10',
		'Etc/GMT+11'	=> 'UTC-11',
		'Etc/GMT+12'	=> 'UTC-12',

		'Africa/Abidjan'	=> 'Afrika/Abidjan',
		'Africa/Accra'		=> 'Afrika/Accra',
		'Africa/Addis_Ababa'	=> 'Afrika/Addis Abeba',
		'Africa/Algiers'	=> 'Afrika/Algier',
		'Africa/Asmara'		=> 'Afrika/Asmara',
		'Africa/Bamako'		=> 'Afrika/Bamako',
		'Africa/Bangui'		=> 'Afrika/Bangui',
		'Africa/Banjul'		=> 'Afrika/Banjul',
		'Africa/Bissau'		=> 'Afrika/Bissau',
		'Africa/Blantyre'	=> 'Afrika/Blantyre',
		'Africa/Brazzaville'	=> 'Afrika/Brazzaville',
		'Africa/Bujumbura'	=> 'Afrika/Bujumbura',
		'Africa/Cairo'		=> 'Afrika/Kairo',
		'Africa/Casablanca'	=> 'Afrika/Casablanca',
		'Africa/Ceuta'		=> 'Afrika/Ceuta',
		'Africa/Conakry'	=> 'Afrika/Conakry',
		'Africa/Dakar'		=> 'Afrika/Dakar',
		'Africa/Dar_es_Salaam'	=> 'Afrika/Daressalam',
		'Africa/Djibouti'	=> 'Afrika/Dschibuti',
		'Africa/Douala'		=> 'Afrika/Douala',
		'Africa/El_Aaiun'	=> 'Afrika/El Aaiún',
		'Africa/Freetown'	=> 'Afrika/Freetown',
		'Africa/Gaborone'	=> 'Afrika/Gaborone',
		'Africa/Harare'		=> 'Afrika/Harare',
		'Africa/Johannesburg'	=> 'Afrika/Johannesburg',
		'Africa/Juba'		=> 'Afrika/Juba',
		'Africa/Kampala'	=> 'Afrika/Kampala',
		'Africa/Khartoum'	=> 'Afrika/Khartum',
		'Africa/Kigali'		=> 'Afrika/Kigali',
		'Africa/Kinshasa'	=> 'Afrika/Kinshasa',
		'Africa/Lagos'		=> 'Afrika/Lagos',
		'Africa/Libreville'	=> 'Afrika/Libreville',
		'Africa/Lome'		=> 'Afrika/Lomé',
		'Africa/Luanda'		=> 'Afrika/Luanda',
		'Africa/Lubumbashi'	=> 'Afrika/Lubumbashi',
		'Africa/Lusaka'		=> 'Afrika/Lusaka',
		'Africa/Malabo'		=> 'Afrika/Malabo',
		'Africa/Maputo'		=> 'Afrika/Maputo',
		'Africa/Maseru'		=> 'Afrika/Maseru',
		'Africa/Mbabane'	=> 'Afrika/Mbabane',
		'Africa/Mogadishu'	=> 'Afrika/Mogadishu',
		'Africa/Monrovia'	=> 'Afrika/Monrovia',
		'Africa/Nairobi'	=> 'Afrika/Nairobi',
		'Africa/Ndjamena'	=> 'Afrika/N’Djamena',
		'Africa/Niamey'		=> 'Afrika/Niamey',
		'Africa/Nouakchott'	=> 'Afrika/Nouakchott',
		'Africa/Ouagadougou'	=> 'Afrika/Ouagadougou',
		'Africa/Porto-Novo'	=> 'Afrika/Porto-Novo',
		'Africa/Sao_Tome'	=> 'Afrika/São Tomé',
		'Africa/Tripoli'	=> 'Afrika/Tripolis',
		'Africa/Tunis'		=> 'Afrika/Tunis',
		'Africa/Windhoek'	=> 'Afrika/Windhoek',

		'America/Adak'		=> 'Amerika/Adak',
		'America/Anchorage'	=> 'Amerika/Anchorage',
		'America/Anguilla'	=> 'Amerika/Anguilla',
		'America/Antigua'	=> 'Amerika/Antigua',
		'America/Araguaina'	=> 'Amerika/Araguaína',

		'America/Argentina/Buenos_Aires'	=> 'Amerika/Argentinien/Buenos Aires',
		'America/Argentina/Catamarca'	=> 'Amerika/Argentinien/Catamarca',
		'America/Argentina/Cordoba'		=> 'Amerika/Argentinien/Córdoba',
		'America/Argentina/Jujuy'		=> 'Amerika/Argentinien/Jujuy',
		'America/Argentina/La_Rioja'	=> 'Amerika/Argentinien/La Rioja',
		'America/Argentina/Mendoza'		=> 'Amerika/Argentinien/Mendoza',
		'America/Argentina/Rio_Gallegos'	=> 'Amerika/Argentinien/Río Gallegos',
		'America/Argentina/Salta'		=> 'Amerika/Argentinien/Salta',
		'America/Argentina/San_Juan'	=> 'Amerika/Argentinien/San Juan',
		'America/Argentina/San_Luis'	=> 'Amerika/Argentinien/San Luis',
		'America/Argentina/Tucuman'		=> 'Amerika/Argentinien/Tucumán',
		'America/Argentina/Ushuaia'		=> 'Amerika/Argentinien/Ushuaia',

		'America/Aruba'			=> 'Amerika/Aruba',
		'America/Asuncion'		=> 'Amerika/Asunción',
		'America/Atikokan'		=> 'Amerika/Atikokan',
		'America/Bahia'			=> 'Amerika/Bahia',
		'America/Bahia_Banderas'	=> 'Amerika/Bahía de Banderas',
		'America/Barbados'		=> 'Amerika/Barbados',
		'America/Belem'			=> 'Amerika/Belém',
		'America/Belize'		=> 'Amerika/Belize',
		'America/Blanc-Sablon'	=> 'Amerika/Blanc-Sablon',
		'America/Boa_Vista'		=> 'Amerika/Boa Vista',
		'America/Bogota'		=> 'Amerika/Bogotá',
		'America/Boise'			=> 'Amerika/Boise',
		'America/Cambridge_Bay'	=> 'Amerika/Cambridge Bay',
		'America/Campo_Grande'	=> 'Amerika/Campo Grande',
		'America/Cancun'		=> 'Amerika/Cancún',
		'America/Caracas'		=> 'Amerika/Caracas',
		'America/Cayenne'		=> 'Amerika/Cayenne',
		'America/Cayman'		=> 'Amerika/Cayman Islands',
		'America/Chicago'		=> 'Amerika/Chicago',
		'America/Chihuahua'		=> 'Amerika/Chihuahua',
		'America/Costa_Rica'	=> 'Amerika/Costa Rica',
		'America/Creston'		=> 'Amerika/Creston',
		'America/Cuiaba'		=> 'Amerika/Cuiabá',
		'America/Curacao'		=> 'Amerika/Curaçao',
		'America/Danmarkshavn'	=> 'Amerika/Danmarkshavn',
		'America/Dawson'		=> 'Amerika/Dawson',
		'America/Dawson_Creek'	=> 'Amerika/Dawson Creek',
		'America/Denver'		=> 'Amerika/Denver',
		'America/Detroit'		=> 'Amerika/Detroit',
		'America/Dominica'		=> 'Amerika/Dominica',
		'America/Edmonton'		=> 'Amerika/Edmonton',
		'America/Eirunepe'		=> 'Amerika/Eirunepé',
		'America/El_Salvador'	=> 'Amerika/El Salvador',
		'America/Fortaleza'		=> 'Amerika/Fortaleza',
		'America/Glace_Bay'		=> 'Amerika/Glace Bay',
		'America/Godthab'		=> 'Amerika/Nuuk',
		'America/Goose_Bay'		=> 'Amerika/Happy Valley-Goose Bay',
		'America/Grand_Turk'	=> 'Amerika/Grand Turk',
		'America/Grenada'		=> 'Amerika/Grenada',
		'America/Guadeloupe'	=> 'Amerika/Guadeloupe',
		'America/Guatemala'		=> 'Amerika/Guatemala',
		'America/Guayaquil'		=> 'Amerika/Guayaquil',
		'America/Guyana'		=> 'Amerika/Guyana',
		'America/Halifax'		=> 'Amerika/Halifax',
		'America/Havana'		=> 'Amerika/Havanna',
		'America/Hermosillo'		=> 'Amerika/Hermosillo',
		'America/Indiana/Indianapolis'	=> 'Amerika/Indiana/Indianapolis',
		'America/Indiana/Knox'		=> 'Amerika/Indiana/Knox',
		'America/Indiana/Marengo'	=> 'Amerika/Indiana/Marengo',
		'America/Indiana/Petersburg'	=> 'Amerika/Indiana/Petersburg',
		'America/Indiana/Tell_City'	=> 'Amerika/Indiana/Tell City',
		'America/Indiana/Vevay'		=> 'Amerika/Indiana/Vevay',
		'America/Indiana/Vincennes'	=> 'Amerika/Indiana/Vincennes',
		'America/Indiana/Winamac'	=> 'Amerika/Indiana/Winamac',
		'America/Inuvik'		=> 'Amerika/Inuvik',
		'America/Iqaluit'		=> 'Amerika/Iqaluit',
		'America/Jamaica'		=> 'Amerika/Jamaika',
		'America/Juneau'		=> 'Amerika/Juneau',
		'America/Kentucky/Louisville'	=> 'Amerika/Kentucky/Louisville',
		'America/Kentucky/Monticello'	=> 'Amerika/Kentucky/Monticello',
		'America/Kralendijk'	=> 'Amerika/Kralendijk',
		'America/La_Paz'		=> 'Amerika/La Paz',
		'America/Lima'			=> 'Amerika/Lima',
		'America/Los_Angeles'	=> 'Amerika/Los Angeles',
		'America/Lower_Princes'	=> 'Amerika/Lower Prince’s Quarter',
		'America/Maceio'		=> 'Amerika/Maceió',
		'America/Managua'		=> 'Amerika/Managua',
		'America/Manaus'		=> 'Amerika/Manaus',
		'America/Marigot'		=> 'Amerika/Marigot',
		'America/Martinique'	=> 'Amerika/Martinique',
		'America/Matamoros'		=> 'Amerika/Matamoros',
		'America/Mazatlan'		=> 'Amerika/Mazatlán',
		'America/Menominee'		=> 'Amerika/Menominee',
		'America/Merida'		=> 'Amerika/Mérida',
		'America/Metlakatla'	=> 'Amerika/Metlakatla',
		'America/Mexico_City'	=> 'Amerika/Mexiko-Stadt',
		'America/Miquelon'		=> 'Amerika/Miquelon',
		'America/Moncton'		=> 'Amerika/Moncton',
		'America/Monterrey'		=> 'Amerika/Monterrey',
		'America/Montevideo'	=> 'Amerika/Montevideo',
		'America/Montreal'		=> 'Amerika/Montreal',
		'America/Montserrat'	=> 'Amerika/Montserrat',
		'America/Nassau'		=> 'Amerika/Nassau',
		'America/New_York'		=> 'Amerika/New York',
		'America/Nipigon'		=> 'Amerika/Nipigon',
		'America/Nome'			=> 'Amerika/Nome',
		'America/Noronha'		=> 'Amerika/Fernando de Noronha',
		'America/North_Dakota/Beulah'		=> 'Amerika/North Dakota/Beulah',
		'America/North_Dakota/Center'		=> 'Amerika/North Dakota/Center',
		'America/North_Dakota/New_Salem'	=> 'Amerika/North Dakota/New Salem',
		'America/Ojinaga'		=> 'Amerika/Ojinaga',
		'America/Panama'		=> 'Amerika/Panama',
		'America/Pangnirtung'	=> 'Amerika/Pangnirtung',
		'America/Paramaribo'	=> 'Amerika/Paramaribo',
		'America/Phoenix'		=> 'Amerika/Phoenix',
		'America/Port-au-Prince'	=> 'Amerika/Port-au-Prince',
		'America/Port_of_Spain'	=> 'Amerika/Port of Spain',
		'America/Porto_Velho'	=> 'Amerika/Porto Velho',
		'America/Puerto_Rico'	=> 'Amerika/Puerto Rico',
		'America/Rainy_River'	=> 'Amerika/Rainy River',
		'America/Rankin_Inlet'	=> 'Amerika/Rankin Inlet',
		'America/Recife'		=> 'Amerika/Recife',
		'America/Regina'		=> 'Amerika/Regina',
		'America/Resolute'		=> 'Amerika/Resolute Bay',
		'America/Rio_Branco'	=> 'Amerika/Rio Branco',
		'America/Santa_Isabel'	=> 'Amerika/Santa Isabel',
		'America/Santarem'		=> 'Amerika/Santarém',
		'America/Santiago'		=> 'Amerika/Santiago de Chile',
		'America/Santo_Domingo'	=> 'Amerika/Santo Domingo de Guzmán',
		'America/Sao_Paulo'		=> 'Amerika/São Paulo',
		'America/Scoresbysund'	=> 'Amerika/Ittoqqortoormiit',
		'America/Shiprock'		=> 'Amerika/Shiprock',
		'America/Sitka'			=> 'Amerika/Sitka',
		'America/St_Barthelemy'	=> 'Amerika/Saint-Barthélemy',
		'America/St_Johns'		=> 'Amerika/St. John’s',
		'America/St_Kitts'		=> 'Amerika/St. Kitts',
		'America/St_Lucia'		=> 'Amerika/St. Lucia',
		'America/St_Thomas'		=> 'Amerika/Saint Thomas',
		'America/St_Vincent'	=> 'Amerika/St. Vincent',
		'America/Swift_Current'	=> 'Amerika/Swift Current',
		'America/Tegucigalpa'	=> 'Amerika/Tegucigalpa',
		'America/Thule'			=> 'Amerika/Thule Air Base',
		'America/Thunder_Bay'	=> 'Amerika/Thunder Bay',
		'America/Tijuana'		=> 'Amerika/Tijuana',
		'America/Toronto'		=> 'Amerika/Toronto',
		'America/Tortola'		=> 'Amerika/Tortola',
		'America/Vancouver'		=> 'Amerika/Vancouver',
		'America/Whitehorse'	=> 'Amerika/Whitehorse',
		'America/Winnipeg'		=> 'Amerika/Winnipeg',
		'America/Yakutat'		=> 'Amerika/Yakutat',
		'America/Yellowknife'	=> 'Amerika/Yellowknife',

		'Antarctica/Casey'		=> 'Antarktis/Casey',
		'Antarctica/Davis'		=> 'Antarktis/Davis',
		'Antarctica/DumontDUrville'	=> 'Antarktis/Dumont d’Urville',
		'Antarctica/Macquarie'	=> 'Antarktis/Macquarie',
		'Antarctica/Mawson'		=> 'Antarktis/Mawson',
		'Antarctica/McMurdo'	=> 'Antarktis/McMurdo',
		'Antarctica/Palmer'		=> 'Antarktis/Palmer',
		'Antarctica/Rothera'	=> 'Antarktis/Rothera',
		'Antarctica/South_Pole'	=> 'Antarktis/Südpol',
		'Antarctica/Syowa'		=> 'Antarktis/Shōwa',
		'Antarctica/Vostok'		=> 'Antarktis/Wostok',

		'Arctic/Longyearbyen'	=> 'Arktis/Longyearbyen',

		'Asia/Aden'			=> 'Asien/Aden',
		'Asia/Almaty'		=> 'Asien/Almaty',
		'Asia/Amman'		=> 'Asien/Amman',
		'Asia/Anadyr'		=> 'Asien/Anadyr',
		'Asia/Aqtau'		=> 'Asien/Aqtau',
		'Asia/Aqtobe'		=> 'Asien/Aqtöbe',
		'Asia/Ashgabat'		=> 'Asien/Aşgabat',
		'Asia/Baghdad'		=> 'Asien/Bagdad',
		'Asia/Bahrain'		=> 'Asien/Bahrain',
		'Asia/Baku'			=> 'Asien/Baku',
		'Asia/Bangkok'		=> 'Asien/Bangkok',
		'Asia/Beirut'		=> 'Asien/Beirut',
		'Asia/Bishkek'		=> 'Asien/Bischkek',
		'Asia/Brunei'		=> 'Asien/Brunei',
		'Asia/Choibalsan'	=> 'Asien/Tschoibalsan',
		'Asia/Chongqing'	=> 'Asien/Chongqing',
		'Asia/Colombo'		=> 'Asien/Colombo',
		'Asia/Damascus'		=> 'Asien/Damaskus',
		'Asia/Dhaka'		=> 'Asien/Dhaka',
		'Asia/Dili'			=> 'Asien/Dili',
		'Asia/Dubai'		=> 'Asien/Dubai',
		'Asia/Dushanbe'		=> 'Asien/Duschanbe',
		'Asia/Gaza'			=> 'Asien/Gaza',
		'Asia/Harbin'		=> 'Asien/Harbin',
		'Asia/Hebron'		=> 'Asien/Hebron',
		'Asia/Ho_Chi_Minh'	=> 'Asien/Ho-Chi-Minh-Stadt',
		'Asia/Hong_Kong'	=> 'Asien/Hongkong',
		'Asia/Hovd'			=> 'Asien/Chowd',
		'Asia/Irkutsk'		=> 'Asien/Irkutsk',
		'Asia/Jakarta'		=> 'Asien/Jakarta',
		'Asia/Jayapura'		=> 'Asien/Jayapura',
		'Asia/Jerusalem'	=> 'Asien/Jerusalem',
		'Asia/Kabul'		=> 'Asien/Kabul',
		'Asia/Kamchatka'	=> 'Asien/Kamtschatka',
		'Asia/Karachi'		=> 'Asien/Karatschi',
		'Asia/Kashgar'		=> 'Asien/Kaxgar',
		'Asia/Kathmandu'	=> 'Asien/Kathmandu',
		'Asia/Khandyga'		=> 'Asien/Chandyga',
		'Asia/Kolkata'		=> 'Asien/Kalkutta',
		'Asia/Krasnoyarsk'	=> 'Asien/Krasnojarsk',
		'Asia/Kuala_Lumpur'	=> 'Asien/Kuala Lumpur',
		'Asia/Kuching'		=> 'Asien/Kuching',
		'Asia/Kuwait'		=> 'Asien/Kuwait',
		'Asia/Macau'		=> 'Asien/Macao',
		'Asia/Magadan'		=> 'Asien/Magadan',
		'Asia/Makassar'		=> 'Asien/Makassar',
		'Asia/Manila'		=> 'Asien/Manila',
		'Asia/Muscat'		=> 'Asien/Maskat',
		'Asia/Nicosia'		=> 'Asien/Nikosia',
		'Asia/Novokuznetsk'	=> 'Asien/Nowokusnezk',
		'Asia/Novosibirsk'	=> 'Asien/Nowosibirsk',
		'Asia/Omsk'			=> 'Asien/Omsk',
		'Asia/Oral'			=> 'Asien/Oral',
		'Asia/Phnom_Penh'	=> 'Asien/Phnom Penh',
		'Asia/Pontianak'	=> 'Asien/Pontianak',
		'Asia/Pyongyang'	=> 'Asien/Pjöngjang',
		'Asia/Qatar'		=> 'Asien/Katar',
		'Asia/Qyzylorda'	=> 'Asien/Qysylorda',
		'Asia/Rangoon'		=> 'Asien/Rangun',
		'Asia/Riyadh'		=> 'Asien/Riad',
		'Asia/Sakhalin'		=> 'Asien/Sachalin',
		'Asia/Samarkand'	=> 'Asien/Samarqand',
		'Asia/Seoul'		=> 'Asien/Seoul',
		'Asia/Shanghai'		=> 'Asien/Shanghai',
		'Asia/Singapore'	=> 'Asien/Singapur',
		'Asia/Taipei'		=> 'Asien/Taipeh',
		'Asia/Tashkent'		=> 'Asien/Taschkent',
		'Asia/Tbilisi'		=> 'Asien/Tiflis',
		'Asia/Tehran'		=> 'Asien/Teheran',
		'Asia/Thimphu'		=> 'Asien/Thimphu',
		'Asia/Tokyo'		=> 'Asien/Tokio',
		'Asia/Ulaanbaatar'	=> 'Asien/Ulaanbaatar',
		'Asia/Urumqi'		=> 'Asien/Ürümqi',
		'Asia/Ust-Nera'		=> 'Asien/Ust-Nera',
		'Asia/Vientiane'	=> 'Asien/Vientiane',
		'Asia/Vladivostok'	=> 'Asien/Wladiwostok',
		'Asia/Yakutsk'		=> 'Asien/Jakutsk',
		'Asia/Yekaterinburg'	=> 'Asien/Jekaterinburg',
		'Asia/Yerevan'		=> 'Asien/Jerewan',

		'Atlantic/Azores'		=> 'Atlantik/Azoren',
		'Atlantic/Bermuda'		=> 'Atlantik/Bermuda',
		'Atlantic/Canary'		=> 'Atlantik/Kanarische Inseln',
		'Atlantic/Cape_Verde'	=> 'Atlantik/Kapverdische Inseln',
		'Atlantic/Faroe'		=> 'Atlantik/Färöer',
		'Atlantic/Madeira'		=> 'Atlantik/Madeira',
		'Atlantic/Reykjavik'	=> 'Atlantik/Reykjavík',
		'Atlantic/South_Georgia'	=> 'Atlantik/Südgeorgien',
		'Atlantic/St_Helena'	=> 'Atlantik/St. Helena',
		'Atlantic/Stanley'		=> 'Atlantik/Stanley',

		'Australia/Adelaide'	=> 'Australien/Adelaide',
		'Australia/Brisbane'	=> 'Australien/Brisbane',
		'Australia/Broken_Hill'	=> 'Australien/Broken Hill',
		'Australia/Currie'		=> 'Australien/Currie',
		'Australia/Darwin'		=> 'Australien/Darwin',
		'Australia/Eucla'		=> 'Australien/Eucla',
		'Australia/Hobart'		=> 'Australien/Hobart',
		'Australia/Lindeman'	=> 'Australien/Lindeman Islands',
		'Australia/Lord_Howe'	=> 'Australien/Lord-Howe-Insel',
		'Australia/Melbourne'	=> 'Australien/Melbourne',
		'Australia/Perth'		=> 'Australien/Perth',
		'Australia/Sydney'		=> 'Australien/Sydney',

		'Europe/Amsterdam'	=> 'Europa/Amsterdam',
		'Europe/Andorra'	=> 'Europa/Andorra',
		'Europe/Athens'		=> 'Europa/Athen',
		'Europe/Belgrade'	=> 'Europa/Belgrad',
		'Europe/Berlin'		=> 'Europa/Berlin',
		'Europe/Bratislava'	=> 'Europa/Bratislava',
		'Europe/Brussels'	=> 'Europa/Brüssel',
		'Europe/Bucharest'	=> 'Europa/Bukarest',
		'Europe/Budapest'	=> 'Europa/Budapest',
		'Europe/Busingen'	=> 'Europa/Büsingen',
		'Europe/Chisinau'	=> 'Europa/Chișinău',
		'Europe/Copenhagen'	=> 'Europa/Kopenhagen',
		'Europe/Dublin'		=> 'Europa/Dublin',
		'Europe/Gibraltar'	=> 'Europa/Gibraltar',
		'Europe/Guernsey'	=> 'Europa/Guernsey',
		'Europe/Helsinki'	=> 'Europa/Helsinki',
		'Europe/Isle_of_Man'	=> 'Europa/Isle of Man',
		'Europe/Istanbul'	=> 'Europa/Istanbul',
		'Europe/Jersey'		=> 'Europa/Jersey',
		'Europe/Kaliningrad'	=> 'Europa/Kaliningrad',
		'Europe/Kiev'		=> 'Europa/Kiew',
		'Europe/Lisbon'		=> 'Europa/Lissabon',
		'Europe/Ljubljana'	=> 'Europa/Ljubljana',
		'Europe/London'		=> 'Europa/London',
		'Europe/Luxembourg'	=> 'Europa/Luxemburg',
		'Europe/Madrid'		=> 'Europa/Madrid',
		'Europe/Malta'		=> 'Europa/Malta',
		'Europe/Mariehamn'	=> 'Europa/Mariehamn',
		'Europe/Minsk'		=> 'Europa/Minsk',
		'Europe/Monaco'		=> 'Europa/Monaco',
		'Europe/Moscow'		=> 'Europa/Moskau',
		'Europe/Oslo'		=> 'Europa/Oslo',
		'Europe/Paris'		=> 'Europa/Paris',
		'Europe/Podgorica'	=> 'Europa/Podgorica',
		'Europe/Prague'		=> 'Europa/Prag',
		'Europe/Riga'		=> 'Europa/Riga',
		'Europe/Rome'		=> 'Europa/Rom',
		'Europe/Samara'		=> 'Europa/Samara',
		'Europe/San_Marino'	=> 'Europa/San Marino',
		'Europe/Sarajevo'	=> 'Europa/Sarajevo',
		'Europe/Simferopol'	=> 'Europa/Simferopol',
		'Europe/Skopje'		=> 'Europa/Skopje',
		'Europe/Sofia'		=> 'Europa/Sofia',
		'Europe/Stockholm'	=> 'Europa/Stockholm',
		'Europe/Tallinn'	=> 'Europa/Tallinn',
		'Europe/Tirane'		=> 'Europa/Tirana',
		'Europe/Uzhgorod'	=> 'Europa/Uschhorod',
		'Europe/Vaduz'		=> 'Europa/Vaduz',
		'Europe/Vatican'	=> 'Europa/Vatikan',
		'Europe/Vienna'		=> 'Europa/Wien',
		'Europe/Vilnius'	=> 'Europa/Vilnius',
		'Europe/Volgograd'	=> 'Europa/Wolgograd',
		'Europe/Warsaw'		=> 'Europa/Warschau',
		'Europe/Zagreb'		=> 'Europa/Zagreb',
		'Europe/Zaporozhye'	=> 'Europa/Saporischschja',
		'Europe/Zurich'		=> 'Europa/Zürich',

		'Indian/Antananarivo'	=> 'Indischer Ozean/Antananarivo',
		'Indian/Chagos'		=> 'Indischer Ozean/Chagos-Archipel',
		'Indian/Christmas'	=> 'Indischer Ozean/Weihnachtsinsel',
		'Indian/Cocos'		=> 'Indischer Ozean/Kokos-Insel',
		'Indian/Comoro'		=> 'Indischer Ozean/Komoren',
		'Indian/Kerguelen'	=> 'Indischer Ozean/Kerguelen',
		'Indian/Mahe'		=> 'Indischer Ozean/Mahé',
		'Indian/Maldives'	=> 'Indischer Ozean/Malediven',
		'Indian/Mauritius'	=> 'Indischer Ozean/Mauritius',
		'Indian/Mayotte'	=> 'Indischer Ozean/Mayotte',
		'Indian/Reunion'	=> 'Indischer Ozean/Réunion',

		'Pacific/Apia'		=> 'Pazifik/Apia',
		'Pacific/Auckland'	=> 'Pazifik/Auckland',
		'Pacific/Chatham'	=> 'Pazifik/Chatham Island',
		'Pacific/Chuuk'		=> 'Pazifik/Chuuk',
		'Pacific/Easter'	=> 'Pazifik/Osterinsel',
		'Pacific/Efate'		=> 'Pazifik/Efate',
		'Pacific/Enderbury'	=> 'Pazifik/Enderbury',
		'Pacific/Fakaofo'	=> 'Pazifik/Fakaofo',
		'Pacific/Fiji'		=> 'Pazifik/Fidschi',
		'Pacific/Funafuti'	=> 'Pazifik/Funafuti',
		'Pacific/Galapagos'	=> 'Pazifik/Galapagos',
		'Pacific/Gambier'	=> 'Pazifik/Gambier',
		'Pacific/Guadalcanal'	=> 'Pazifik/Guadalcanal',
		'Pacific/Guam'		=> 'Pazifik/Guam',
		'Pacific/Honolulu'	=> 'Pazifik/Honolulu',
		'Pacific/Johnston'	=> 'Pazifik/Johnston',
		'Pacific/Kiritimati'	=> 'Pazifik/Kiritimati',
		'Pacific/Kosrae'	=> 'Pazifik/Kosrae',
		'Pacific/Kwajalein'	=> 'Pazifik/Kwajalein',
		'Pacific/Majuro'	=> 'Pazifik/Majuro',
		'Pacific/Marquesas'	=> 'Pazifik/Marquesas',
		'Pacific/Midway'	=> 'Pazifik/Midwayinseln',
		'Pacific/Nauru'		=> 'Pazifik/Nauru',
		'Pacific/Niue'		=> 'Pazifik/Niue',
		'Pacific/Norfolk'	=> 'Pazifik/Norfolkinsel',
		'Pacific/Noumea'	=> 'Pazifik/Nouméa',
		'Pacific/Pago_Pago'	=> 'Pazifik/Pago Pago',
		'Pacific/Palau'		=> 'Pazifik/Palau',
		'Pacific/Pitcairn'	=> 'Pazifik/Pitcairn',
		'Pacific/Pohnpei'	=> 'Pazifik/Pohnpei',
		'Pacific/Port_Moresby'	=> 'Pazifik/Port Moresby',
		'Pacific/Rarotonga'	=> 'Pazifik/Rarotonga',
		'Pacific/Saipan'	=> 'Pazifik/Saipan',
		'Pacific/Tahiti'	=> 'Pazifik/Tahiti',
		'Pacific/Tarawa'	=> 'Pazifik/Tarawa',
		'Pacific/Tongatapu'	=> 'Pazifik/Tongatapu',
		'Pacific/Wake'		=> 'Pazifik/Wake',
		'Pacific/Wallis'	=> 'Pazifik/Wallis',
	),

	// The value is only an example and will get replaced by the current time on view
	'dateformats'	=> array(
		'j. M Y, H:i'			=> '1. Jan 2007, 13:57',
		'D j. M Y, H:i'			=> 'Mo 1. Jan 2007, 13:57',
		'j. F Y, H:i'			=> '1. Januar 2007, 13:57',
		'l j. F Y, H:i'			=> 'Montag 1. Januar 2007, 13:57',
		'd.m.Y, H:i'			=> '01.01.2007, 13:57',
		'|j. M Y| H:i'			=> 'Heute, 13:57 / 1. Jan 2007 13:57',
		'|j. F Y| H:i'			=> 'Heute, 13:57 / 1. Januar 2007 13:57',
		'|d.m.Y| H:i'			=> 'Heute, 13:57 / 01.01.2007 13:57',
	),

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'	=> 'D j. M Y, H:i', // Mo 1. Jan 2007, 13:57

));
