<?php
/**
 *
 * This file is part of the phpBB Forum Software package.
 *
 * @copyright (c) phpBB Limited <https://www.phpbb.com>
 * @license GNU General Public License, version 2 (GPL-2.0)
 *
 * For full copyright and license information, please see
 * the docs/CREDITS.txt file.
 *
 * Ελληνική μετάφραση από την ομάδα του phpbbgr.com
 *
 */

/**
 * DO NOT CHANGE
 */
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

// Common installer pages
$lang = array_merge($lang, array(
	'INSTALL_PANEL'	=> 'Πίνακας εγκατάστασης',
	'SELECT_LANG'	=> 'Επιλέξτε γλώσσα',

	'STAGE_INSTALL'	=> 'Εγκατάσταση phpBB',

	// Introduction page
	'INTRODUCTION_TITLE'	=> 'Εισαγωγή',
	'INTRODUCTION_BODY'		=> 'Καλώς ήρθατε στο phpBB3!<br /><br />Το phpBB® είναι η πιο ευρέως χρησιμοποιούμενη λύση συστήματος συζητήσεων ανοικτού κώδικα στον κόσμο. Το phpBB3 είναι η τελευταία έκδοση σε μια σειρά πακέτου που ξεκίνησε το 2000. Όπως και οι προκάτοχοί του, το phpBB3 είναι πλούσιο σε χαρακτηριστικά, φιλικό προς τον χρήστη, και πλήρως υποστηριζόμενο από την ομάδα του phpBB. Το phpBB3 βελτιώνει σε μεγάλο βαθμό ότι έκανε το δημοφιλές phpBB2 και προσθέτει συνήθη αιτούμενα χαρακτηριστικά που δεν υπήρχαν στις προηγούμενες εκδόσεις. Ελπίζουμε ότι ξεπερνά τις προσδοκίες σας.<br /><br />Αυτό το σύστημα εγκατάστασης θα σας καθοδηγήσει στην εγκατάσταση του phpBB3, την ενημέρωση στην πιο πρόσφατη έκδοση του phpBB3 από προηγούμενες εκδόσεις, καθώς επίσης και τη μετατροπή σε phpBB3 από ένα διαφορετικό σύστημα συζητήσεων (συμπεριλαμβανομένου του phpBB2). Για περισσότερες πληροφορίες, σας συνιστούμε να διαβάσετε <a href="%1$s">τον οδηγό εγκατάστασης</a>.<br /><br />Για να διαβάσετε την άδεια χρήσης phpBB3 ή να μάθετε σχετικά με τη λήψη υποστήριξης και τη στάση μας σε αυτό, παρακαλώ επιλέξτε τις αντίστοιχες επιλογές από το πλευρικό μενού. Για να συνεχίσετε, επιλέξτε την κατάλληλη καρτέλα παραπάνω.',

	// Support page
	'SUPPORT_TITLE'		=> 'Υποστήριξη',
	'SUPPORT_BODY'		=> 'Πλήρης υποστήριξη θα παρέχεται για την τρέχουσα σταθερή έκδοση phpBB3, δωρεάν. Αυτό περιλαμβάνει:</p><ul><li>εγκατάσταση</li><li>ρυθμίσεις</li><li>τεχνικές ερωτήσεις</li><li>προβλήματα σχετικά με πιθανά σφάλματα στο λογισμικό</li><li>ενημέρωση από υποψήφια έκδοση (RC) στην πιο πρόσφατη σταθερή έκδοση</li><li>μετατροπή από phpBB 2.0.x σε phpBB3</li><li>μετατροπή από άλλο λογισμικό συστήματος συζητήσεων σε phpBB3 (παρακαλώ δείτε <a href="https://www.phpbb.com/community/viewforum.php?f=486">Μετατροπείς</a>)</li></ul><p>Προτρέπουμε τους χρήστες που εξακολουθούν να τρέχουν beta εκδόσεις του phpBB3 να αντικαταστήσουν την εγκατάστασή τους με ένα φρέσκο αντίγραφο της τελευταίας έκδοσης.</p><h2>Επεκτάσεις / Στυλ</h2><p>Για θέματα που σχετίζονται με Επεκτάσεις, παρακαλούμε να δημοσιεύσετε στο κατάλληλο <a href="https://www.phpbb.com/community/viewforum.php?f=451">Extensions Forum</a>.<br />Για θέματα που σχετίζονται με στυλ, πρότυπα και θέματα, παρακαλούμε να δημοσιεύσετε στο κατάλληλο <a href="https://www.phpbb.com/community/viewforum.php?f=471">Styles Forum</a>.<br /><br />Εάν η ερώτησή σας σχετίζεται με ένα συγκεκριμένο πακέτο, παρακαλώ να δημοσιεύσετε κατευθείαν στο θέμα που έχει οριστεί για το πακέτο.</p><h2>Λήψη Υποστήριξης</h2><p><a href="https://www.phpbb.com/community/viewtopic.php?f=14&amp;t=571070">The phpBB Welcome Package</a><br /><a href="https://www.phpbb.com/support/">Ενότητα υποστήριξης</a><br /><a href="https://www.phpbb.com/support/docs/en/3.1/ug/quickstart/">Οδηγός γρήγορης έναρξης</a><br /><br />Για να διασφαλίσετε ότι είστε πάντα ενημερωμένοι με τα τελευταία νέα και εκδόσεις, γιατί να μην <a href="https://www.phpbb.com/support/">εγγραφείτε στη λίστα αλληλογραφίας μας</a>;<br /><br />',
	
	// License
	'LICENSE_TITLE'		=> 'General Public License',

	// Install page
	'INSTALL_INTRO'			=> 'Καλώς ήρθατε στην εγκατάσταση',
	'INSTALL_INTRO_BODY'	=> 'Με αυτήν την επιλογή, είναι δυνατόν να εγκαταστήσετε το phpBB3 στο διακομιστή σας.</p><p>Προκειμένου να συνεχίσετε, θα χρειαστείτε τις ρυθμίσεις της βάσης δεδομένων σας. Εάν δεν γνωρίζετε τις ρυθμίσεις της βάσης δεδομένων σας, παρακαλούμε να επικοινωνήσετε με τον πάροχο φιλοξενίας σας και ρωτήστε για αυτούς. Δεν θα είστε σε θέση να συνεχίσετε χωρίς αυτούς. Χρειάζεστε:</p>

	<ul>
		<li>Τον τύπο της βάσης δεδομένων - η βάση δεδομένων που θα χρησιμοποιήσετε.</li>
		<li>Το όνομα του διακομιστή βάσης δεδομένων ή DSN - τη διεύθυνση του διακομιστή βάσης δεδομένων.</li>
		<li>Τη θύρα διακομιστή της βάσης δεδομένων - η θύρα του διακομιστή βάσης δεδομένων (τις περισσότερες φορές αυτό δεν είναι αναγκαίο).</li>
		<li>Το όνομα βάσης δεδομένων - το όνομα της βάσης δεδομένων στο διακομιστή.</li>
		<li>Το όνομα χρήστη βάσης δεδομένων και τον κωδικό πρόσβασης βάσης δεδομένων - τα δεδομένα σύνδεσης για την πρόσβαση στη βάση δεδομένων.</li>
	</ul>

	<p><strong>Σημείωση:</strong> αν κάνετε την εγκατάσταση χρησιμοποιώντας SQLite, θα πρέπει να εισάγετε την πλήρη διαδρομή προς το αρχείο της βάσης δεδομένων σας στο πεδίο DSN και αφήστε τα πεδία του ονόματος χρήστη και του κωδικού πρόσβασης κενά. Για λόγους ασφαλείας, θα πρέπει να βεβαιωθείτε ότι το αρχείο της βάσης δεδομένων δεν είναι αποθηκευμένο σε μια θέση προσβάσιμη από τον ιστό.</p>

	<p>Το phpBB3 υποστηρίζει τις ακόλουθες βάσεις δεδομένων:</p>
	<ul>
		<li>MySQL 4.1.3 ή νεότερη (MySQLi απαιτείται)</li>
		<li>PostgreSQL 8.3+</li>
		<li>SQLite 3.6.15+</li>
		<li>MS SQL Server 2000 ή νεώτερο (άμεσα ή μέσω ODBC)</li>
		<li>MS SQL Server 2005 ή νεώτερο (native)</li>
		<li>Oracle</li>
	</ul>

	<p>Μόνον οι τύποι Β. Δεδομένων που υποστηρίζονται από τον διακομιστή σας θα εμφανίζονται.',

	'ACP_LINK'	=> 'Μετάβαση στον <a href="%1$s">ΠΕΔ</a>',

	'INSTALL_PHPBB_INSTALLED'		=> 'Το phpBB είναι ήδη εγκατεστημένο.',
	'INSTALL_PHPBB_NOT_INSTALLED'	=> 'Το phpBB δεν εγκαταστάθηκε ακόμα.',
));

// Requirements translation
$lang = array_merge($lang, array(
	// Filesystem requirements
	'FILE_NOT_EXISTS'						=> 'Το αρχείο δεν υπάρχει',
	'FILE_NOT_EXISTS_EXPLAIN'				=> 'Για να εγκατασταθεί το phpBB το αρχείο %1$s πρέπει να υπάρχει.',
	'FILE_NOT_EXISTS_EXPLAIN_OPTIONAL'		=> 'Συνιστάται το αρχείο %1$s να υπάρχει για καλύτερη εμπειρία των χρηστών της Δ. Συζήτησης.',
	'FILE_NOT_WRITABLE'						=> 'Το αρχείο δεν είναι εγγράψιμο',
	'FILE_NOT_WRITABLE_EXPLAIN'				=> 'Για να εγκατασταθεί το phpBB το αρχείο %1$s πρέπει να είναι εγγράψιμο.',
	'FILE_NOT_WRITABLE_EXPLAIN_OPTIONAL'	=> 'Συνιστάται το αρχείο %1$s να είναι εγγράψιμο για καλύτερη εμπειρία των χρηστών της Δ. Συζήτησης.',

	'DIRECTORY_NOT_EXISTS'						=> 'Ο κατάλογος δεν υπάρχει',
	'DIRECTORY_NOT_EXISTS_EXPLAIN'				=> 'Για να εγκατασταθεί το phpBB ο κατάλογος %1$s πρέπει να υπάρχει.',
	'DIRECTORY_NOT_EXISTS_EXPLAIN_OPTIONAL'		=> 'Συνιστάται ο κατάλογος %1$s να υπάρχει για καλύτερη εμπειρία των χρηστών της Δ. Συζήτησης.',
	'DIRECTORY_NOT_WRITABLE'					=> 'Ο κατάλογος δεν είναι εγγράψιμος',
	'DIRECTORY_NOT_WRITABLE_EXPLAIN'			=> 'Για να εγκατασταθεί το phpBB ο κατάλογος %1$s πρέπει να είναι εγγράψιμος.',
	'DIRECTORY_NOT_WRITABLE_EXPLAIN_OPTIONAL'	=> 'Συνιστάται ο κατάλογος %1$s να είναι εγγράψιμος για καλύτερη εμπειρία των χρηστών της Δ. Συζήτησης.',

	// Server requirements
	'PHP_VERSION_REQD'					=> 'Έκδοση PHP',
	'PHP_VERSION_REQD_EXPLAIN'			=> 'Το phpBB απαιτεί έκδοση PHP 7.2.0 ή νεότερη.',
	'PHP_GETIMAGESIZE_SUPPORT'			=> 'Η λειτουργία PHP getimagesize() απαιτείται',
	'PHP_GETIMAGESIZE_SUPPORT_EXPLAIN'	=> 'Για να λειτουργήσει σωστά το phpBB, η λειτουργία getimagesize πρέπει να είναι διαθέσιμη.',
	'PCRE_UTF_SUPPORT'					=> 'Υποστήριξη PCRE UTF-8',
	'PCRE_UTF_SUPPORT_EXPLAIN'			=> 'Το phpBB δεν θα λειτουργήσει εάν η εγκατάσταση της PHP δεν έχει δημιουργηθεί με υποστήριξη UTF-8 στην επέκταση PCRE.',
	'PHP_JSON_SUPPORT'					=> 'Υποστήριξη PHP JSON',
	'PHP_JSON_SUPPORT_EXPLAIN'			=> 'Για να λειτουργήσει σωστά το phpBB, η επέκταση PHP JSON πρέπει να είναι διαθέσιμη.',
	'PHP_MBSTRING_SUPPORT'				=> 'Υποστήριξη PHP mbstring',
	'PHP_MBSTRING_SUPPORT_EXPLAIN'		=> 'Για να λειτουργήσει σωστά το phpBB, η επέκταση PHP mbstring πρέπει να είναι διαθέσιμη.',
	'PHP_XML_SUPPORT'					=> 'Υποστήριξη PHP XML/DOM',
	'PHP_XML_SUPPORT_EXPLAIN'			=> 'Για να λειτουργεί σωστά το phpBB, η προσθήκη PHP XML/DOM πρέπει να είναι διαθέσιμη.',
	'PHP_SUPPORTED_DB'					=> 'Υποστηριζόμενες βάσεις δεδομένων',
	'PHP_SUPPORTED_DB_EXPLAIN'			=> 'Πρέπει να έχετε υποστήριξη για τουλάχιστον μία συμβατή βάση δεδομένων μέσα σε PHP. Εάν δεν υπάρχουν μονάδες βάσης δεδομένων που εμφανίζονται ως διαθέσιμες, πρέπει να επικοινωνήσετε με τον πάροχο φιλοξενίας σας ή να ανατρέξετε στη σχετική τεκμηρίωση εγκατάστασης της PHP για συμβουλές.',

	'RETEST_REQUIREMENTS'	=> 'Επανέλεχος απαιτήσεων',

	'STAGE_REQUIREMENTS'	=> 'Έλεγχος απαιτήσεων',
));

// General error messages
$lang = array_merge($lang, array(
	'INST_ERR_MISSING_DATA'		=> 'Πρέπει να συμπληρώσετε όλα τα πεδία σε αυτόν τον πίνακα.',

	'TIMEOUT_DETECTED_TITLE'	=> 'The installer detected a timeout',
	'TIMEOUT_DETECTED_MESSAGE'	=> 'The installer has detected a timeout, you may try to refresh the page, which may lead to data corruption. We suggest that you either increase your timeout settings or try to use the CLI.',
));

// Data obtaining translations
$lang = array_merge($lang, array(
	'STAGE_OBTAIN_DATA'	=> 'Ρυθμίσεις βάσης δεδομένων',

	//
	// Admin data
	//
	'STAGE_ADMINISTRATOR'	=> 'Λεπτομέρειες Διαχειριστή',

	// Form labels
	'ADMIN_CONFIG'				=> 'Ρυθμίσεις Διαχειριστή',
	'ADMIN_PASSWORD'			=> 'Κωδικός Διαχειριστή',
	'ADMIN_PASSWORD_CONFIRM'	=> 'Επαλήθευση κωδικού Διαχειριστή',
	'ADMIN_PASSWORD_EXPLAIN'	=> 'Παρακαλώ εισάγετε έναν κωδικό μεταξύ 6 και 30 χαρακτήρων.',
	'ADMIN_USERNAME'			=> 'Όνομα μέλους Διαχειριστή',
	'ADMIN_USERNAME_EXPLAIN'	=> 'Παρακαλώ εισάγετε ένα όνομα μεταξύ 3 και 20 χαρακτήρων.',

	// Errors
	'INST_ERR_EMAIL_INVALID'		=> 'Η διεύθυνση ηλεκτρονικού ταχυδρομείου που εισάγατε δεν είναι έγκυρη.',
	'INST_ERR_PASSWORD_MISMATCH'	=> 'Οι κωδικοί πρόσβασης που εισάγατε δεν ταιριάζουν.',
	'INST_ERR_PASSWORD_TOO_LONG'	=> 'Ο κωδικός πρόσβασης που εισάγατε είναι πολύ μεγάλος. Το μέγιστο μήκος είναι 30 χαρακτήρες.',
	'INST_ERR_PASSWORD_TOO_SHORT'	=> 'Ο κωδικός πρόσβασης που εισάγατε είναι πολύ μικρός. Το ελάχιστο μήκος είναι 6 χαρακτήρες.',
	'INST_ERR_USER_TOO_LONG'		=> 'Το όνομα χρήστη που εισάγατε είναι πολύ μεγάλο. Το μέγιστο μήκος είναι 20 χαρακτήρες.',
	'INST_ERR_USER_TOO_SHORT'		=> 'Το όνομα χρήστη που εισάγατε είναι πολύ μικρό. Το ελάχιστο μήκος είναι 3 χαρακτήρες.',

	//
	// Board data
	//
	// Form labels
	'BOARD_CONFIG'		=> 'Bulletin board configuration',
	'DEFAULT_LANGUAGE'	=> 'Προεπιλεγμένη γλώσσα',
	'BOARD_NAME'		=> 'Τίτλος Δ. Συζήτησης',
	'BOARD_DESCRIPTION'	=> 'Σύντομη περιγραφή Δ. Συζήτησης',

	//
	// Database data
	//
	'STAGE_DATABASE'	=> 'Ρυθμίσεις βάσης δεδομένων',

	// Form labels
	'DB_CONFIG'				=> 'Ρυθμίσεις βάσης δεδομένων',
	'DBMS'					=> 'Τύπος βάσης δεδομένων',
	'DB_HOST'				=> 'Όνομα διακομιστή βάσης δεδομένων ή DSN',
	'DB_HOST_EXPLAIN'		=> 'Το DSN είναι συντομογραφία για Data Source Name και είναι σημαντικό μόνο για εγκαταστάσεις ODBC. Για PostgreSQL, χρησιμοποιήστε localhost για να συνδεθείτε στον τοπικό διακομιστή μέσω UNIX domain socket και 127.0.0.1 για να συνδεθείτε μέσω TCP. Για SQLite, εισάγετε την πλήρη διαδρομή προς το αρχείο της βάσης δεδομένων σας.',
	'DB_PORT'				=> 'Θύρα διακομιστή βάσης δεδομένων',
	'DB_PORT_EXPLAIN'		=> 'Αφήστε κενό εκτός εάν γνωρίζετε ότι ο διακομιστής λειτουργεί σε μια μη τυπική θύρα.',
	'DB_PASSWORD'			=> 'Κωδικός βάσης δεδομένων',
	'DB_NAME'				=> 'Όνομα βάσης δεδομένων',
	'DB_USERNAME'			=> 'Όνομα χρήστη βάσης δεδομένων',
	'DATABASE_VERSION'		=> 'Έκδοση Βάσης Δεδομένων',
	'TABLE_PREFIX'			=> 'Πρόθεμα για τους πίνακες στη βάση δεδομένων',
	'TABLE_PREFIX_EXPLAIN'	=> 'Το πρόθεμα πρέπει να ξεκινάει με ένα γράμμα και πρέπει να περιέχει μόνο γράμματα, αριθμούς και κάτω παύλες.',

	// Database options
	'DB_OPTION_MSSQL_ODBC'	=> 'MSSQL Server 2000+ via ODBC',
	'DB_OPTION_MSSQLNATIVE'	=> 'MSSQL Server 2005+ [ Native ]',
	'DB_OPTION_MYSQLI'		=> 'MySQL with MySQLi Extension',
	'DB_OPTION_ORACLE'		=> 'Oracle',
	'DB_OPTION_POSTGRES'	=> 'PostgreSQL',
	'DB_OPTION_SQLITE3'		=> 'SQLite 3',

	// Errors
	'INST_ERR_DB'					=> 'Σφάλμα εγκατάστασης της βάσης δεδομένων',
	'INST_ERR_NO_DB'				=> 'Δεν είναι δυνατή η φόρτωση του module της PHP για τον επιλεγμένο τύπο βάσης δεδομένων.',
	'INST_ERR_DB_INVALID_PREFIX'	=> 'Το πρόθεμα πίνακα που εισάγατε δεν είναι έγκυρο. Πρέπει να αρχίζει με ένα γράμμα και να περιέχει μόνο γράμματα, αριθμούς και κάτω παύλες.',
	'INST_ERR_PREFIX_TOO_LONG'		=> 'Το πρόθεμα πίνακα που έχετε καθορίσει είναι πολύ μεγάλο. Το μέγιστο μήκος είναι %d χαρακτήρες.',
	'INST_ERR_DB_NO_NAME'			=> 'Δεν ορίστηκε όνομα βάσης δεδομένων.',
	'INST_ERR_DB_FORUM_PATH'		=> 'Το αρχείο της βάσης δεδομένων που καθορίστηκε είναι μέσα στο δέντρο καταλόγου του συστήματος συζητήσεων σας. Θα πρέπει να τοποθετήσετε αυτό το αρχείο σε μια τοποθεσία μη προσβάσιμη μέσω του ιστού.',
	'INST_ERR_DB_CONNECT'			=> 'Αδυναμία σύνδεσης με τη Β. Δεδομένων, δείτε το μήνυμα λάθους παρακάτω.',
	'INST_ERR_DB_NO_WRITABLE'		=> 'Και η Βάση Δεδομένων και ο κατάλογος που την περιέχει, πρέπει να έχουν δικαιώματα εγγραφής.',
	'INST_ERR_DB_NO_ERROR'			=> 'Κανένα μήνυμα λάθους δεν δόθηκε.',
	'INST_ERR_PREFIX'				=> 'Πίνακες με το καθορισμένο πρόθεμα υπάρχουν ήδη, παρακαλώ επιλέξτε ένα άλλο.',
	'INST_ERR_DB_NO_MYSQLI'			=> 'Η έκδοση της MySQL που είναι εγκατεστημένη σε αυτό το μηχάνημα δεν είναι συμβατή με την “MySQL με MySQLi Extension” που έχετε επιλέξει. Παρακαλώ δοκιμάστε την επιλογή “MySQL” αντί αυτού.',
	'INST_ERR_DB_NO_SQLITE3'		=> 'Η έκδοση της επέκτασης SQLite που έχετε εγκατεστημένη είναι πολύ παλαιά, θα πρέπει να αναβαθμιστεί σε τουλάχιστον 3.6.15.',
	'INST_ERR_DB_NO_ORACLE'			=> 'Η έκδοση της Oracle που είναι εγκατεστημένη σε αυτό το μηχάνημα απαιτεί από εσάς να ρυθμίσετε την παράμετρο <var>NLS_CHARACTERSET</var> σε <var>UTF8</var>. Είτε αναβαθμίσετε την εγκατάσταση σας σε 9.2+ ή αλλάξετε την παράμετρο.',
	'INST_ERR_DB_NO_POSTGRES'		=> 'Η βάση δεδομένων που έχετε επιλέξει δεν δημιουργήθηκε σε κωδικοποίηση <var>UNICODE</var> ή σε <var>UTF8</var>. Προσπαθήστε να εγκαταστήσετε σε μια βάση δεδομένων με κωδικοποίηση <var>UNICODE</var> ή <var>UTF8</var>.',
	'INST_SCHEMA_FILE_NOT_WRITABLE'	=> 'Το αρχείο schema δεν είναι εγγράψιμο',

	//
	// Email data
	//
	'EMAIL_CONFIG'	=> 'Ρυθμίσεις ηλεκτρονικού ταχυδρομείου',

	// Package info
	'PACKAGE_VERSION'					=> 'Εγκατεστημένη έκδοση πακέτου',
	'UPDATE_INCOMPLETE'				=> 'Η εγκατάσταση του phpBB δεν έχει ενημερωθεί σωστά.',
	'UPDATE_INCOMPLETE_MORE'		=> 'Παρακαλώ διαβάστε τις παρακάτω πληροφορίες για να διορθώσετε αυτό το σφάλμα.',
	'UPDATE_INCOMPLETE_EXPLAIN'		=> '<h1>Ελειπής ενημέρωση</h1>

		<p>Παρατηρήσαμε ότι η τελευταία ενημέρωση για το phpBB δεν έχει ολοκληρωθεί. Επισκευτείτε το <a href="%1$s" title="%1$s">πρόγραμμα ενημέρωσης βάσης δεδομένων</a>, βεβαιωθείτε ότι είναι επιλεγμένο μόνο η επιλογή <em>Ενημέρωση βάσης μόνο</em> και πατήστε στο <strong>Υποβολή</strong>. Μην ξεχάσετε να διαγράψετε τον φάκελο εγκατάστασης "install" μετά την επιτυχή ενημέρωση της βάσης.</p>',

	//
	// Server data
	//
	// Form labels
	'UPGRADE_INSTRUCTIONS'			=> 'Μια νέα έκδοση δυνατοτήτων <strong>%1$s</strong> είναι διαθέσιμη. Παρακαλώ διαβάστε <a href="%2$s" title="%2$s"><strong>την ανακοίνωση έκδοσης</strong></a> για να μάθετε τι έχει να σας προσφέρει και πώς να αναβαθμίσετε.',
	'SERVER_CONFIG'				=> 'Ρυθμίσεις διακομιστή',
	'SCRIPT_PATH'				=> 'Διαδρομή φακέλου',
	'SCRIPT_PATH_EXPLAIN'		=> 'Η διαδρομή που βρίσκεται το phpBB σε σχέση με το με το όνομα domain, π.χ. <samp>/phpBB3</samp>.',
));

// Default database schema entries...
$lang = array_merge($lang, array(
	'CONFIG_BOARD_EMAIL_SIG'		=> 'Ευχαριστώ, Ο Διαχειριστής',
	'CONFIG_SITE_DESC'				=> 'Ένα σύντομο κείμενο που να περιγράφει τη Δ. Συζήτησή σας',
	'CONFIG_SITENAME'				=> 'yourdomain.com',

	'DEFAULT_INSTALL_POST'			=> '<t>Αυτό είναι ένα παράδειγμα δημοσίευσης στην εγκατάσταση του phpbb3 σας. Όλα φαίνεται ότι δουλεύουν πλήρως. Μπορείτε να διαγράψετε αυτή τη δημοσίευση αν θέλετε και να συνεχίσετε την παραμετροποίηση της Δ. Συζήτησης σας. Κατά τη διαδικασία εγκατάστασης στην πρώτη σας κατηγορία και την πρώτη σας Δ. Συζήτηση έχουν εκχωρηθεί δικαιώματα πρόσβασης για τις προεπιλεγμένες ομάδες διαχειριστών, bots, γενικών συντονιστών, επισκεπτών, εγγεγραμμένων μελών και εγγεγραμμένων μελών COPPA. Αν αποφασίστε να διαγράψετε την πρώτη σας κατηγορία και την πρώτη σας Δ. Συζήτηση μην ξεχάσετε να ορίστε τα δικαιώματα πρόσβασης για όλες αυτές τις ομάδες σε όλες της κατηγορίες και τις Δ. Συζητήσεις που θα δημιουργήσετε. Συνιστάται να μετονομάσετε την πρώτη σας κατηγορία και την πρώτη σας Δ. Συζήτηση και να αντιγράψετε από αυτές τα δικαιώματα πρόσβασης όταν δημιουργείτε νέες κατηγορίες και Δ. Συζητήσεις. Καλή συνέχεια!</t>',

	'FORUMS_FIRST_CATEGORY'			=> 'Η πρώτη κατηγορία σας',
	'FORUMS_TEST_FORUM_DESC'		=> 'Περιγραφή της πρώτης Δ. Συζήτησή σας.',
	'FORUMS_TEST_FORUM_TITLE'		=> 'Η πρώτη Δ. Συζήτησή σας',

	'RANKS_SITE_ADMIN_TITLE'		=> 'Διαχειριστής ιστοσελίδας',
	'REPORT_WAREZ'					=> 'Η δημοσίευση περιέχει συνδέσμους με παράνομο ή πειρατικό λογισμικό.',
	'REPORT_SPAM'					=> 'Η αναφερόμενη δημοσίευση έχει το μόνο σκοπό για να διαφημίσει μια άλλη ιστοσελίδα ή ένα άλλο προϊόν.',
	'REPORT_OFF_TOPIC'				=> 'Η αναφερόμενη δημοσίευση είναι εκτός θέματος.',
	'REPORT_OTHER'					=> 'Η αναφερόμενη δημοσίευση δεν αρμόζει σε οποιαδήποτε άλλη κατηγορία, παρακαλώ χρησιμοποιήστε τον περαιτέρω τομέα περιγραφής.',

	'SMILIES_ARROW'					=> 'Arrow',
	'SMILIES_CONFUSED'				=> 'Confused',
	'SMILIES_COOL'					=> 'Cool',
	'SMILIES_CRYING'				=> 'Crying or Very Sad',
	'SMILIES_EMARRASSED'			=> 'Embarrassed',
	'SMILIES_EVIL'					=> 'Evil or Very Mad',
	'SMILIES_EXCLAMATION'			=> 'Exclamation',
	'SMILIES_GEEK'					=> 'Geek',
	'SMILIES_IDEA'					=> 'Idea',
	'SMILIES_LAUGHING'				=> 'Laughing',
	'SMILIES_MAD'					=> 'Mad',
	'SMILIES_MR_GREEN'				=> 'Mr. Green',
	'SMILIES_NEUTRAL'				=> 'Neutral',
	'SMILIES_QUESTION'				=> 'Question',
	'SMILIES_RAZZ'					=> 'Razz',
	'SMILIES_ROLLING_EYES'			=> 'Rolling Eyes',
	'SMILIES_SAD'					=> 'Sad',
	'SMILIES_SHOCKED'				=> 'Shocked',
	'SMILIES_SMILE'					=> 'Smile',
	'SMILIES_SURPRISED'				=> 'Surprised',
	'SMILIES_TWISTED_EVIL'			=> 'Twisted Evil',
	'SMILIES_UBER_GEEK'				=> 'Uber Geek',
	'SMILIES_VERY_HAPPY'			=> 'Very Happy',
	'SMILIES_WINK'					=> 'Wink',

	'TOPICS_TOPIC_TITLE'			=> 'Καλώς ήρθατε στο phpBB3',
));

// Common navigation items' translation
$lang = array_merge($lang, array(
	'MENU_OVERVIEW'		=> 'Επισκόπηση',
	'MENU_INTRO'		=> 'Εισαγωγή',
	'MENU_LICENSE'		=> 'Άδεια χρήσης',
	'MENU_SUPPORT'		=> 'Υποστήριξη',
));

// Task names
$lang = array_merge($lang, array(
	// Install filesystem
	'TASK_CREATE_CONFIG_FILE'	=> 'Δημιουργία αρχείου διαμόρφωσης',

	// Install database
	'TASK_ADD_CONFIG_SETTINGS'			=> 'Προσθήκη ρυθμίσεων διαμόρφωσης',
	'TASK_ADD_DEFAULT_DATA'				=> 'Προσθήκη προεπιλεγμένων ρυθμίσεων στη βάση δεδομένων',
	'TASK_CREATE_DATABASE_SCHEMA_FILE'	=> 'Δημιουργία αρχείου schema βάσης δεδομένων',
	'TASK_SETUP_DATABASE'				=> 'Ρύθμιση βάσης δεδομένων',
	'TASK_CREATE_TABLES'				=> 'Δημιουργία πινάκων',

	// Install data
	'TASK_ADD_BOTS'				=> 'Εγγραφή bots',
	'TASK_ADD_LANGUAGES'		=> 'Εγκατάσταση διαθέσιμων γλωσσών',
	'TASK_ADD_MODULES'			=> 'Εγκατάσταση μονάδων',
	'TASK_CREATE_SEARCH_INDEX'	=> 'Δημιουργία καταλόγου αναζήτησης',

	// Install finish tasks
	'TASK_INSTALL_EXTENSIONS'	=> 'Εγκατάσταση ενσωματωμένων επεκτάσεων',
	'TASK_NOTIFY_USER'			=> 'Αποστολή ηλεκτρονικού ταχυδρομείου ειδοποίησης',
	'TASK_POPULATE_MIGRATIONS'	=> 'Populating migrations',

	// Installer general progress messages
	'INSTALLER_FINISHED'	=> 'Η εγκατάσταση έχει ολοκληρωθεί επιτυχώς',
));

// Installer's general messages
$lang = array_merge($lang, array(
	'MODULE_NOT_FOUND'				=> 'Η μονάδα δεν βρέθηκε',
	'MODULE_NOT_FOUND_DESCRIPTION'	=> 'Μια μονάδα δεν βρέθηκε διότι η υπηρεσία %s είναι απροσδιόριστη.',

	'TASK_NOT_FOUND'				=> 'Η διαδικασία δε βρέθηκε',
	'TASK_NOT_FOUND_DESCRIPTION'	=> 'Μια διαδικασία δεν ήταν δυνατό να βρεθεί, διότι η υπηρεσία, %s, δεν έχει οριστεί.',

	'SKIP_MODULE'	=> 'Παράκαμψη μονάδας “%s”',
	'SKIP_TASK'		=> 'Παράκαμψη διαδικασίας “%s”',

	'TASK_SERVICE_INSTALLER_MISSING'	=> 'Όλες οι υπηρεσίες διαδικασιών εγκατάστασης πρέπει να ξεκινάνε με “installer”',
	'TASK_CLASS_NOT_FOUND'				=> 'Installer task service definition is invalid. Service name “%1$s” given, the expected class namespace is “%2$s” for that. For more information please see the documentation of task_interface.',

	'INSTALLER_CONFIG_NOT_WRITABLE'	=> 'Το αρχείο ρυθμίσεων εγκατάστασης δεν είναι εγγράψιμο.',
));

// CLI messages
$lang = array_merge($lang, array(
	'CLI_INSTALL_BOARD'				=> 'Εγκατάσταση phpBB',
	'CLI_UPDATE_BOARD'				=> 'Αναβάθμιση phpBB',
	'CLI_INSTALL_SHOW_CONFIG'		=> 'Εμφάνιση της διαμόρφωσης που θα χρησιμοποιηθεί',
	'CLI_INSTALL_VALIDATE_CONFIG'	=> 'Επικύρωση ενός αρχείου διαμόρφωσης',
	'CLI_CONFIG_FILE'				=> 'Αρχείο ρυθμίσεων για χρήση',
	'MISSING_FILE'					=> 'Αδύνατη η πρόσβαση στο αρχείο %1$s',
	'MISSING_DATA'					=> 'Το αρχείο διαμόρφωσης έχει ελλιπή δεδομένα ή περιέχει μη έγκυρες ρυθμίσεις.',
	'INVALID_YAML_FILE'				=> 'Δεν μπορεί να αναλυθεί το αρχείο YAML %1$s',
	'CONFIGURATION_VALID'			=> 'Το αρχείο διαμόργωσης είναι έγκυρο',
));

// Common updater messages
$lang = array_merge($lang, array(
	'UPDATE_INSTALLATION'			=> 'Αναβάθμιση εγκατάστασης phpBB',
	'UPDATE_INSTALLATION_EXPLAIN'	=> 'Με την επιλογή αυτή, μπορείτε να αναβαθμίσετε την εγκατάσταση της phpBB στην πιο πρόσφατη έκδοση.<br />Κατά τη διαδικασία όλα τα αρχεία σας θα πρέπει να ελεγχθούν για την ακεραιότητα τους. Είστε σε θέση να ελέγχετε όλες τις διαφορές και τα αρχεία πριν από την αναβάθμιση.<br /><br />Η αναβάθμιση αρχείου μπορεί να γίνει με δύο διαφορετικούς τρόπους.</p><h2>Χειροκίνητη αναβάθμιση</h2><p>Με αυτή την αναβάθμιση θα μεταφορτώσετε μόνο το προσωπικό σας σύνολο αλλαγμένων αρχείων για να είστε σίγουρος (-η) ότι δεν θα χάσετε τις τροποποιήσεις των αρχείων που ενδεχομένως να έχετε κάνει. Αφού μεταφορτώσετε αυτό το πακέτο θα πρέπει να φορτώσετε χειροκίνητα τα αρχεία στη σωστή θέση κάτω από τον ριζικό κατάλογο της phpBB. Μόλις γίνει αυτό, θα είστε σε θέση να κάνετε εκ νέου το στάδιο ελέγχου αρχείων για να δείτε αν έχετε μετακινήσει τα αρχεία στη σωστή θέση τους.</p><h2>Αυτόματη αναβάθμιση με FTP</h2><p>Αυτή η μέθοδος είναι παρόμοια με την πρώτη, αλλά χωρίς να απαιτείται να μεταφορτώσετε τα αλλαγμένα αρχεία και αποστέλλοντάς τα από μόνοι σας. Αυτό θα γίνει για σας. Για να χρησιμοποιήσετε αυτή τη μέθοδο θα πρέπει να γνωρίζετε τα στοιχεία σύνδεσης FTP, αφού θα ερωτηθείτε για αυτά. Μόλις ολοκληρωθεί θα μεταφερθείτε πάλι στον ελέγχο αρχείων για να βεβαιωθείτε ότι τα πάντα έχουν ενημερωθεί σωστά.<br /><br />',
	'UPDATE_INSTRUCTIONS'			=> '

		<h1>Ανακοίνωση</h1>

		<p>Παρακαλώ διαβάστε την ανακοίνωση κυκλοφορίας για την πιο πρόσφατη έκδοση πριν συνεχίσετε τη διαδικασία αναβάθμισης, μπορεί να περιέχει χρήσιμες πληροφορίες. Περιέχει επίσης πλήρεις συνδέσμους μεταφορτώσεων καθώς επίσης και το ενημερωτικό αρχείο καταγραφής αλλαγών.</p>

		<br />
		
		<h1>Πώς να αναβαθμίσετε την εγκατάστασή σας με το Πλήρες πακέτο αναβάθμισης</h1>

		<p>Ο προτεινόμενος τρόπος αναβάθμισης της εγκατάστασής σας, είναι η χρήση του πλήρους πακέτου αναβάθμισης. Αν τα βασικά αρχεία του phpBB έχουν τροποποιηθεί στην εγκατάστασή σας, ίσως θέλετε να αναβαθμίσετε χρησιμοποιώντας το προηγμένο πακέτο αναβάθμισης για να μην χάσετε όποιες μετατροπές έχετε κάνει. Μπορείτε επίσης να αναβαθμίσετε την εγκατάστασή σας, χρησιμοποιώντας τις υπόλοιπες μεθόδους που αναφέρονται στο έγγραφο INSTALL.html. Τα βήματα για να αναβαθμίσετε το phpBB3 χρησιμοποιώντας το πλήρες πακέτο είναι τα εξής:</p>

		<ol style="margin-left: 20px; font-size: 1.1em;">
			<li><strong class="error">Κρατήστε αντίγραφο ασφαλείας από όλα τα αρχεία του συστήματός σας και την βάση δεδομένων.</strong></li>
			<li>Πηγαίνετε στη <a href="https://www.phpbb.com/downloads/" title="https://www.phpbb.com/downloads/">σελίδα μεταφορτώσεων του phpBB.com</a> και κατεβάστε το πιο πρόσφατο "Full Package" αρχείο.</li>
			<li>Αποσυμπιέστε το συμπιεσμένο αρχείο.</li>
			<li>Αφαιρέστε (διαγράψτε) το αρχείο <code class="inline">config.php</code>, και τους φακέλους <code class="inline">/images</code>, <code class="inline">/store</code> και <code class="inline">/files</code> <em> από το αρχείο που αποσυμπιέσατε στο προηγούμενο βήμα</em> (όχι την σελίδα σας).</li>
			<li>Μεταβείτε στον ΠΕΔ, Ρυθμίσεις συστήματος συζητήσεων και βεβαιωθείτε ότι το prosilver είναι το προεπιλεγμένο στύλ. Αν δεν είναι, θέστε το σε prosilver.</li>
			<li>Διαγράψτε το φάκελο <code class="inline">/vendor</code> και <code class="inline">/cache</code> από το φάκελο της σελίδας σας που βρίσκεται στο server σας.</li>
			<li>Μέσω FTP ή SSH ανεβάστε τα αρχεία και φακέλους (εννοώντας τα αρχεία και φακέλους από το αρχείο που αποσυμπιέσατε στην αρχή) στον κυρίως φάκελο της εγκατάστασης του συστήματος συζητήσεων στο server, με αντικατάσταση των προηγούμενων, όπου απαιτείται. (Σημείωση: προσέξτε να μη διαγράψετε κάποια προσθηκη από το φάκελο <code class="inline">/ext</code> όταν ανεβάζετε τα περιεχόμενα του πακέτου.)</li>
			<li><strong><a href="%1$s" title="%1$s">Τώρα ξεκινήστε την διαδικασία αναβάθμισης βάζοντας τη διεύθυνση του φακέλου εγκατάστασης</a>.</strong></li>
			<li>Ακολουθήστε τα βήματα για να αναβαθμίσετε την βάση δεδομένων και αφήστε το μέχρι να ολοκληρωθεί.</li>
			<li>Μέσω FTP ή SSH διαγράψτε το φάκελο <code class="inline">/install</code> από τον κυρίως φάκελο της εγκατάστασής σας.<br><br></li>
		</ol>
		

		<p>Έχετε πλέον μια ενημερωμένη εγκατάσταση του συστήματος που περιέχει όλους τους χρήστες και τις δημοσιεύσεις. Διαδικασίες για μετά την εγκατάσταση:</p>
		<ul style="margin-left: 20px; font-size: 1.1em;">
			<li>Ενημερώστε το πακέτο γλωσσών</li>
			<li>Ενημερώστε το στύλ<br><br></li>
		</ul>

		<h1>Πώς να αναβαθμίσετε την εγκατάστασή σας με το προηγμένο πακέτο αναβάθμισης</h1>

		<p>Το προηγμένο πακέτο αναβάθμισης προτείνεται για προχωρημένους χρήστες, μόνο όταν έχετε κάνει μετατροπές στα βασικά αρχεία του phpBB. Μπορείτε επίσης να αναβαθμίσετε την εγκατάστασή σας, χρησιμοποιώντας τις υπόλοιπες μεθόδους που αναφέρονται στο έγγραφο INSTALL.html. Τα βήματα για να αναβαθμίσετε το phpBB3 χρησιμοποιώντας το προηγμένο πακέτο αναβάθμισης είναι τα εξής:</p>

		<ol style="margin-left: 20px; font-size: 1.1em;">
			<li>Πηγαίνετε στη <a href="https://www.phpbb.com/downloads/" title="https://www.phpbb.com/downloads/">σελίδα μεταφορτώσεων του phpBB.com</a> και κατεβάστε το πιο πρόσφατο "Advanced Update Package" αρχείο.</li>
			<li>Αποσυμπιέστε το συμπιεσμένο αρχείο.</li>
			<li>Ανεβάστε τους φακέλους "install" και "vendor" στον κυρίως κατάλογο του phpBB (εκεί που βρίσκεται το αρχείο config.php).<br><br></li>
		</ol>

		<p>Μόλις φορτωθεί, το σύστημα συζητήσεων θα είναι εκτός σύνδεσης για τα κανονικά μέλη, επειδή υπάρχει πλέον ο κατάλογος install που φορτώσατε.<br /><br />
		<strong><a href="%1$s" title="%1$s">Τώρα ξεκινήστε την διαδικασία αναβάθμισης βάζοντας τη διεύθυνση του φακέλου εγκατάστασης</a>.</strong><br />
		<br />
		Θα καθοδηγηθείτε στη συνέχεια κατά τη διαδικασία αναβάθμισης. Θα ειδοποιηθείτε μόλις ολοκληρωθεί η αναβάθμιση.
		</p>
	',
));

// Updater forms
$lang = array_merge($lang, array(
	// Updater types
	'UPDATE_TYPE'			=> 'Τύπος αναβάθμισης για εκτέλεση',

	'UPDATE_TYPE_ALL'		=> 'Αναβάθμιση αρχείων και βάσης δεδομένων',
	'UPDATE_TYPE_DB_ONLY'	=> 'Αναβάθμιση βάσης δεδομένων μόνο',

	// File updater methods
	'UPDATE_FILE_METHOD_TITLE'		=> 'Μέθοδοι αναβάθμισης αρχείου',

	'UPDATE_FILE_METHOD'			=> 'Μέθοδος αναβάθμισης αρχείου',
	'UPDATE_FILE_METHOD_DOWNLOAD'	=> 'Μεταφόρτωση τροποποιημένων αρχείων σε ένα αρχείο',
	'UPDATE_FILE_METHOD_FTP'		=> 'Αναβάθμιση αρχείων μέσω FTP (Αυτόματα)',
	'UPDATE_FILE_METHOD_FILESYSTEM'	=> 'Αναβάθμιση αρχείων μέσω απευθείας πρόσβασης αρχείων (Αυτόματα)',

	// File updater archives
	'SELECT_DOWNLOAD_FORMAT'	=> 'Επιλέξτε μορφή αρχείου μεταφόρτωσης',

	// FTP settings
	'FTP_SETTINGS'			=> 'Ρυθμίσεις FTP',
));

// Requirements messages
$lang = array_merge($lang, array(
	'UPDATE_FILES_NOT_FOUND'	=> 'Κανένας έγκυρος κατάλογος αναβάθμισης δεν βρέθηκε, παρακαλούμε σιγουρευτείτε ότι ανεβάσατε τα σχετικά αρχεία.',

	'NO_UPDATE_FILES_UP_TO_DATE'	=> 'Η έκδοσή σας είναι ενημερωμένη. Δεν είναι απαραίτητο να εκτελέσετε το εργαλείο αναβάθμισης. Εάν θέλετε να κάνετε έναν έλεγχο ακεραιότητας στα αρχεία σας, βεβαιωθείτε ότι έχετε φορτώσει τα σωστά αρχεία της ενημερωμένης έκδοσης.',
	'OLD_UPDATE_FILES'				=> 'Τα αρχεία αναβάθμισης είναι παλιά. Τα αρχεία αναβάθμισης που βρέθηκαν είναι για αναβάθμιση από phpBB %1$s σε phpBB %2$s, αλλά η τελευταία έκδοση του phpBB είναι %3$s.',
	'INCOMPATIBLE_UPDATE_FILES'		=> 'Τα αρχεία αναβάθμισης που βρέθηκαν είναι ασύμβατα με την εγκατεστημένη έκδοση. Η εγκατεστημένη έκδοσή σας είναι %1$s και το αρχείο αναβάθμισης είναι για την αναβάθμισης του phpBB %2$s σε %3$s.',
));

// Update files
$lang = array_merge($lang, array(
	'STAGE_UPDATE_FILES'		=> 'Αναβάθμιση αρχείων',

	// Check files
	'UPDATE_CHECK_FILES'	=> 'Έλεγχος αρχείων για αναβάθμιση',

	// Update file differ
	'FILE_DIFFER_ERROR_FILE_CANNOT_BE_READ'	=> 'Το πρόγραμμα ελέγχου διαφορών αρχείων απέτυχε να ανοίξει το %s.',

	'UPDATE_FILE_DIFF'		=> 'Έλεγχος για διαφορές σε τροποποιημένα αρχεία',
	'ALL_FILES_DIFFED'		=> 'Όλα τα τροποποιημένα αρχεία ελέγχθηκαν για διαφορές.',

	// File status
	'UPDATE_CONTINUE_FILE_UPDATE'	=> 'Αναβάθμιση αρχείων',

	'DOWNLOAD'							=> 'Μεταφόρτωση',
	'DOWNLOAD_CONFLICTS'				=> 'Μεταφόρτωση αρχείου συγχώνευσης διενέξεων',
	'DOWNLOAD_CONFLICTS_EXPLAIN'		=> 'Αναζήτηση για &lt;&lt;&lt; στα σημεία διενέξεων',
	'DOWNLOAD_UPDATE_METHOD'			=> 'Μεταφόρτωση του αρχείου τροποποιημένων αρχείων',
	'DOWNLOAD_UPDATE_METHOD_EXPLAIN'	=> 'Μετά τη λήψη θα πρέπει να αποσυμπιέσετε το αρχείο. Θα βρείτε τα τροποποιημένα αρχεία που χρειάζεστε για να τα φορτώσετε μέσα στον ριζικό κατάλογο του phpBB σας. Παρακαλώ να φορτώσετε τα αρχεία στις αντίστοιχες θέσεις τους κατόπιν. Αφού έχετε φορτώσει όλα τα αρχεία, μπορείτε να συνεχίσετε τη διαδικασία αναβάθμισης',

	'FILE_ALREADY_UP_TO_DATE'		=> 'Το αρχείο είναι ήδη αναβαθμισμένο.',
	'FILE_DIFF_NOT_ALLOWED'			=> 'Το αρχείο δεν επιτρέπεται να είναι διαφορετικό.',
	'FILE_USED'						=> 'Πληροφορίες χρησιμοποιούνται από',			// Single file
	'FILES_CONFLICT'				=> 'Συγκρουόμενα αρχεία',
	'FILES_CONFLICT_EXPLAIN'		=> 'Τα παρακάτω αρχεία είναι τροποποιημένα και δεν αντιπροσωπεύουν τα αυθεντικά αρχεία από την παλιά έκδοση. Το phpBB διαπίστωσε ότι τα αρχεία αυτά θα δημιουργήσουν διενέξεις εφόσον γίνει προσπάθεια να συγχωνευθούν. Παρακαλώ διερευνήσετε τις διενέξεις και προσπαθήστε να τις επιλύσετε με μη αυτόματο τρόπο ή να συνεχίστε την αναβάθμιση επιλέγοντας την προτιμώμενη μέθοδο συγχώνευσης. Εάν έχετε επιλύσετε τις διενέξεις χειροκίνητα ελέγξτε τα αρχεία πάλι μετά την τροποποίησή τους. Είστε επίσης σε θέση να επιλέξετε μεταξύ της προτιμώμενης μεθόδου συγχώνευσης για κάθε αρχείο. Η πρώτη θα έχει ως αποτέλεσμα σε ένα αρχείο όπου οι συγκρουόμενες γραμμές από το παλαιό αρχείο σας θα χαθούν, το άλλο θα οδηγήσει στην απώλεια των αλλαγών από το νεότερο αρχείο.',
	'FILES_DELETED'					=> 'Διαγραμμένα αρχεία',
	'FILES_DELETED_EXPLAIN'			=> 'Τα παρακάτω αρχεία δεν υπάρχουν στη νέα έκδοση. Τα αρχεία αυτά πρέπει να διαγραφούν από την εγκατάστασή σας.',
	'FILES_MODIFIED'				=> 'Τροποποιημένα αρχεία',
	'FILES_MODIFIED_EXPLAIN'		=> 'Τα παρακάτω αρχεία είναι τροποποιημένα και δεν αντιπροσωπεύουν τα αυθεντικά αρχεία από την παλιά έκδοση. Το αναβαθμισμένο αρχείο θα είναι μια συγχώνευση μεταξύ των τροποποιήσεών σας και του νέου αρχείου.',
	'FILES_NEW'						=> 'Νέα αρχεία',
	'FILES_NEW_EXPLAIN'				=> 'Τα παρακάτω αρχεία προς το παρόν δεν υπάρχουν στην εγκατάστασή σας. Αυτά τα αρχεία θα προστεθούν στην εγκατάστασή σας.',
	'FILES_NEW_CONFLICT'			=> 'Νέα συγκρουόμενα αρχεία',
	'FILES_NEW_CONFLICT_EXPLAIN'	=> 'Τα παρακάτω αρχεία είναι νέα στην τελευταία έκδοση, αλλά έχει διαπιστωθεί ότι υπάρχει ήδη ένα αρχείο με το ίδιο όνομα στην ίδια θέση. Αυτό το αρχείο θα αντικατασταθεί από το νέο αρχείο.',
	'FILES_NOT_MODIFIED'			=> 'Μη τροποποιημένα αρχεία',
	'FILES_NOT_MODIFIED_EXPLAIN'	=> 'Τα παρακάτω αρχεία δεν έχουν τροποποιηθεί και αντιπροσωπεύουν τα αυθεντικά αρχεία του phpBB της έκδοσης από την οποία θέλετε να αναβαθμίσετε.',
	'FILES_UP_TO_DATE'				=> 'Ήδη αναβαθμισμένα αρχεία',
	'FILES_UP_TO_DATE_EXPLAIN'		=> 'Τα ακόλουθα αρχεία είναι ήδη ενημερωμένα και δεν χρειάζεται να αναβαθμιστούν.',
	'FILES_VERSION'					=> 'Έκδοση αρχείων',
	'TOGGLE_DISPLAY'				=> 'Εμφάνιση/Απόκρυψη λίστας αρχείων',

	// File updater
	'UPDATE_UPDATING_FILES'	=> 'Αναβάθμιση αρχείων',

	'UPDATE_FILE_UPDATER_HAS_FAILED'	=> 'Το πρόγραμμα ενημέρωσης αρχείων “%1$s“ απέτυχε. Το πρόγραμμα εγκατάστασης θα προσπαθήσει να επαναφέρει το “%2$s“.',
	'UPDATE_FILE_UPDATERS_HAVE_FAILED'	=> 'Το πρόγραμμα ενημέρωσης αρχείων απέτυχε. Δεν είναι δυνατή κάποια άλλη μέθοδος επαναφοράς.',

	'UPDATE_CONTINUE_UPDATE_PROCESS'	=> 'Συνέχιση αναβάθμισης σε εξέλιξη',
	'UPDATE_RECHECK_UPDATE_FILES'		=> 'Επανέλεχος αρχείων',
));

// Update database
$lang = array_merge($lang, array(
	'STAGE_UPDATE_DATABASE'		=> 'Αναβάθμιση βάσης δεδομένων',

	'INLINE_UPDATE_SUCCESSFUL'	=> 'Η αναβάθμιση της βάσης δεδομένων ήταν επιτυχής.',
	
	'TASK_UPDATE_EXTENSIONS'	=> 'Ενημέρωση επεκτάσεων',
));

// Converter
$lang = array_merge($lang, array(
	// Common converter messages
	'CONVERT_NOT_EXIST'			=> 'Ο συγκεκριμένος μετατροπέας δεν υπάρχει.',
	'DEV_NO_TEST_FILE'			=> 'Καμία τιμή δεν έχει καθοριστεί για τη μεταβλητή test_file στον μετατροπέα. Αν είστε χρήστης του μετατροπέα, δεν θα πρέπει να βλέπετε το σφάλμα αυτό, παρακαλώ αναφέρετε αυτό το μήνυμα προς τον συγγραφέα του μετατροπέα. Αν είστε ο συγγραφέας του μετατροπέα, πρέπει να καθορίσετε το όνομα ενός αρχείου το οποίο υπάρχει στο πηγαίο σύστημα συζητήσεων για να επιτρέψει τη διαδρομή να επαληθευθεί.',
	'COULD_NOT_FIND_PATH'		=> 'Δεν ήταν δυνατή η εύρεση διαδρομής προς το προηγούμενο σύστημα συζητήσεων. Παρακαλώ ελέγξτε τις ρυθμίσεις σας και δοκιμάστε ξανά.<br />» %s έχει καθοριστεί ως διαδρομή πηγής.',
	'CONFIG_PHPBB_EMPTY'		=> 'Η μεταβλητή phpBB3 config για "%s" είναι κενή.',

	'MAKE_FOLDER_WRITABLE'		=> 'Παρακαλώ διασφαλίστε ότι υπάρχει αυτός ο φάκελος και είναι εγγράψιμος από τον διακομιστή ιστού, μετά προσπαθήστε ξανά:<br />»<strong>%s</strong>.',
	'MAKE_FOLDERS_WRITABLE'		=> 'Παρακαλώ διασφαλίστε ότι υπάρχουν αυτοί οι φάκελοι και είναι εγγράψιμοι από τον διακομιστή ιστού, μετά προσπαθήστε ξανά:<br />»<strong>%s</strong>.',

	'INSTALL_TEST'				=> 'Δοκιμή ξανά',

	'NO_TABLES_FOUND'			=> 'Δεν βρέθηκαν πίνακες.',
	'TABLES_MISSING'			=> 'Δεν ήταν δυνατή η εύρεση αυτών των πινάκων<br />» <strong>%s</strong>.',
	'CHECK_TABLE_PREFIX'		=> 'Παρακαλώ ελέγξτε το πρόθεμα των πινάκων σας και δοκιμάστε ξανά.',

	// Conversion in progress
	'CATEGORY'					=> 'Κατηγορία',
	'CONTINUE_CONVERT'			=> 'Συνέχιση μετατροπής',
	'CONTINUE_CONVERT_BODY'		=> 'Μια προηγούμενη προσπάθεια μετατροπής έχει διαπιστωθεί. Τώρα μπορείτε να επιλέξετε μεταξύ της εκκίνησης μιας νέας μετατροπής ή συνέχιση της μετατροπής.',
	'CONVERT_NEW_CONVERSION'	=> 'Νέα μετατροπή',
	'CONTINUE_OLD_CONVERSION'	=> 'Συνέχιση προηγούμενης μετατροπής',
	'POST_ID'					=> 'ID δημοσίευσης',

	// Start conversion
	'SUB_INTRO'					=> 'Εισαγωγή',
	'CONVERT_INTRO'				=> 'Καλώς ήρθατε στο phpBB Unified Convertor Framework',
	'CONVERT_INTRO_BODY'		=> 'Από εδώ, μπορείτε να εισάγετε δεδομένα από άλλα (εγκατεστημένα) συστήματα συζητήσεων. Η παρακάτω λίστα εμφανίζει όλες τις μονάδες μετατροπής που διατίθενται επί του παρόντος. Αν δεν εμφανίζεται σε αυτή τη λίστα μετατροπέας για το λογισμικό του συστήματος συζητήσεών σας από το οποίο θέλετε να μετατρέψετε, παρακαλούμε να ελέγξετε την ιστοσελίδα μας, όπου περαιτέρω μονάδες μετατροπής μπορεί να είναι διαθέσιμες για λήψη.',
	'AVAILABLE_CONVERTORS'		=> 'Διαθέσιμοι μετατροπείς',
	'NO_CONVERTORS'				=> 'Δεν υπάρχουν διαθέσιμοι μετατροπείς για χρήση.',
	'CONVERT_OPTIONS'			=> 'Επιλογές',
	'SOFTWARE'					=> 'Λογισμικό συστήματος συζητήσεων',
	'VERSION'					=> 'Έκδοση',
	'CONVERT'					=> 'Μετατροπή',

	// Settings
	'STAGE_SETTINGS'			=> 'Ρυθμίσεις',
	'TABLE_PREFIX_SAME'			=> 'Το πρόθεμα πίνακα πρέπει να είναι εκείνο που χρησιμοποιείται στο λογισμικό από το οποίο μετατρέπετε<br />» Το πρόθεμα πίνακα ήταν %s.',
	'DEFAULT_PREFIX_IS'			=> 'Ο μετατροπέας δεν ήταν σε θέση να βρει τους πίνακες με το καθορισμένο πρόθεμα. Παρακαλώ βεβαιωθείτε ότι έχετε εισάγει τα σωστά στοιχεία για το σύστημα συζητήσεων από το οποίο κάνετε τη μετατροπή. Το προεπιλεγμένο πρόθεμα πινάκων για %1$s είναι <strong>%2$s</strong>.',
	'SPECIFY_OPTIONS'			=> 'Καθορίστε επιλογές μετατροπής',
	'FORUM_PATH'				=> 'Διαδρομή συστήματος συζητήσεων',
	'FORUM_PATH_EXPLAIN'		=> 'Αυτή είναι η <strong>σχετική</strong> διαδρομή στο δίσκο του πρώην συστήματος συζητήσεων από τον <strong>ριζικό φάκελο αυτής της εγκατάστασης phpBB3</strong>.',
	'REFRESH_PAGE'				=> 'Ανανεώστε τη σελίδα για να συνεχίσετε τη μετατροπή',
	'REFRESH_PAGE_EXPLAIN'		=> 'Εάν οριστεί σε “Ναι”, ο μετατροπέας θα ανανεώσει τη σελίδα για να συνεχίσετε τη μετατροπή αφού ολοκληρώσει ένα βήμα. Αν αυτή είναι η πρώτη σας μετατροπή, για λόγους δοκιμών και για τον προσδιορισμό τυχόν σφαλμάτων εκ των προτέρων, σας συνιστούμε να ορίσετε σε “Όχι”.',

	// Conversion
	'STAGE_IN_PROGRESS'			=> 'Μετατροπή σε εξέλιξη',

	'AUTHOR_NOTES'				=> 'Σημειώσεις συγγραφέα<br />» %s',
	'STARTING_CONVERT'			=> 'Εκκίνηση διαδικασίας μετατροπής',
	'CONFIG_CONVERT'			=> 'Μετατροπή των ρυθμίσεων',
	'DONE'						=> 'Εντάξει',
	'PREPROCESS_STEP'			=> 'Εκτέλεση προ-επεξεργασμένων λειτουργιών/ερωτημάτων',
	'FILLING_TABLE'				=> 'Συμπλήρωση πίνακα <strong>%s</strong>',
	'FILLING_TABLES'			=> 'Συμπλήρωση πινάκων',
	'DB_ERR_INSERT'				=> 'Σφάλμα κατά τη διαδικασία ερωτήματος <code>INSERT</code>.',
	'DB_ERR_LAST'				=> 'Σφάλμα κατά τη διαδικασία <var>query_last</var>.',
	'DB_ERR_QUERY_FIRST'		=> 'Σφάλμα κατά την εκτέλεση <var>query_first</var>.',
	'DB_ERR_QUERY_FIRST_TABLE'	=> 'Σφάλμα κατά την εκτέλεση <var>query_first</var>, %s (“%s”).',
	'DB_ERR_SELECT'				=> 'Σφάλμα κατά τη λειτουργία ερωτήματος <code>SELECT</code>',
	'STEP_PERCENT_COMPLETED'	=> 'Βήμα <strong>%d</strong> από <strong>%d</strong>',
	'FINAL_STEP'				=> 'Τελικό βήμα διαδικασίας',
	'SYNC_FORUMS'				=> 'Έναρξη συγχρονισμού Δ. Συζητήσεων',
	'SYNC_POST_COUNT'			=> 'Συγχρονισμός post_counts',
	'SYNC_POST_COUNT_ID'		=> 'Συγχρονισμός post_counts από <var>καταχώρηση</var> %1$s σε %2$s.',
	'SYNC_TOPICS'				=> 'Έναρξη συγχρονισμού θεμάτων',
	'SYNC_TOPIC_ID'				=> 'Συγχρονισμός θεμάτων από <var>topic_id</var> %1$s σε %2$s.',
	'PROCESS_LAST'				=> 'Επεξεργασία τελευταίων δηλώσεων',
	'UPDATE_TOPICS_POSTED'		=> 'Δημιουργία πληροφοριών δημοσιευμένων θεμάτων',
	'UPDATE_TOPICS_POSTED_ERR'	=> 'Ένα σφάλμα προέκυψε κατά τη δημιουργία πληροφοριών δημοσιευμένων θεμάτων. Μπορείτε να ξαναδοκιμάσετε αυτό το βήμα από τον Πίνακα Ελέγχου Διαχειριστή μετά την ολοκλήρωση της διαδικασίας μετατροπής.',
	'CONTINUE_LAST'				=> 'Συνέχιση τελευταίας πρότασης',
	'CLEAN_VERIFY'				=> 'Εκκαθάριση και επαλήθευση της τελικής δομής',
	'NOT_UNDERSTAND'			=> 'Αδυναμία κατανόησης %s #%d, πίνακας %s (“%s”)',
	'NAMING_CONFLICT'			=> 'Διένεξη ονομασίας: %s και %s είναι αμφότερα ψευδώνυμα<br /><br />%s',

	// Finish conversion
	'CONVERT_COMPLETE'			=> 'Η μετατροπή ολοκληρώθηκε',
	'CONVERT_COMPLETE_EXPLAIN'	=> 'Έχετε πλέον μετατρέψει με επιτυχία το σύστημα συζητήσεών σας σε phpBB 3.3. Μπορείτε τώρα να συνδεθείτε και <a href="../">να έχετε πρόσβαση στο σύστημα συζητήσεών σας</a>. Παρακαλώ βεβαιωθείτε ότι οι ρυθμίσεις μεταφέρθηκαν σωστά πριν από την ενεργοποίηση του συστήματος συζητήσεών σας διαγράφοντας τον καταλόγου εγκατάστασης. Θυμηθείτε ότι η βοήθεια σχετικά με τη χρήση phpBB είναι διαθέσιμη στο διαδίκτυο μέσω των <a href="https://www.phpbb.com/support/docs/en/3.3/ug/">Εγγράφων</a> και στη <a href="https://www.phpbb.com/community/viewforum.php?f=661">Δ. Συζήτηση υποστήριξης</a>.',

	'COLLIDING_CLEAN_USERNAME'			=> '<strong>%s</strong> είναι το καθαρό όνομα χρήστη για:',
	'COLLIDING_USER'					=> '» user id: <strong>%d</strong> όνομα χρήστη: <strong>%s</strong> (%d posts)',
	'COLLIDING_USERNAMES_FOUND'			=> 'Βρέθηκαν συγκρουόμενα ονόματα χρήστη στο παλιό σας σύστημα. Για να ολοκληρωθεί η μετατροπή παρακαλώ διαγράψτε ή μετονομάστε αυτούς τους χρήστες ώστε να υπάρχει μόνο ένας χρήστης στο παλιό σας σύστημα για κάθε ένα καθαρό όνομα χρήστη.',
	'CONV_ERR_FATAL'					=> 'Μη αναστρέψιμο σφάλμα μετατροπής',
	'CONV_ERROR_ATTACH_FTP_DIR'			=> 'Η φόρτωση συνημμένων αρχείων μέσω FTP είναι ενεργοποιημένη στο παλαιό σας σύστημα συζητήσεων. Παρακαλώ απενεργοποιήστε την επιλογή φόρτωσης FTP και σιγουρευτείτε ότι ένας σωστός κατάλογος για τη φόρτωση έχει καθοριστεί, στη συνέχεια αντιγράψτε όλα τα συνημμένα αρχεία σε αυτόν τον νέο διαδικτυακά προσβάσιμο κατάλογο. Μόλις το κάνετε αυτό, επανεκκινήστε τον μετατροπέα.',
	'CONV_ERROR_CONFIG_EMPTY'			=> 'Δεν υπάρχουν διαθέσιμες πληροφορίες ρύθμισης για αυτή τη μετατροπή.',
	'CONV_ERROR_FORUM_ACCESS'			=> 'Αδύνατη η συλλογή πληροφοριών πρόσβασης για τη Δ. Συζήτηση.',
	'CONV_ERROR_GET_CATEGORIES'			=> 'Αδύνατη η συλλογή πληροφοριών για τις κατηγορίες.',
	'CONV_ERROR_GET_CONFIG'				=> 'Δεν ήταν δυνατή η ανάκτηση διαμόρφωσης του συστήματος συζητήσεων σας.',
	'CONV_ERROR_COULD_NOT_READ'			=> 'Αδυναμία πρόσβασης/ανάγνωσης “%s”.',
	'CONV_ERROR_GROUP_ACCESS'			=> 'Αδυναμία λήψης πληροφοριών πιστοποίησης ομάδας.',
	'CONV_ERROR_INCONSISTENT_GROUPS'	=> 'Ασυνέχεια στον πίνακα των ομάδων ανιχνεύθηκε σε add_bots() - θα πρέπει να προσθέσετε όλες τις ειδικές ομάδες αν το κάνετε με μη αυτόματο τρόπο.',
	'CONV_ERROR_INSERT_BOT'				=> 'Αδυναμία εισαγωγής bot στον πίνακα των μελών.',
	'CONV_ERROR_INSERT_BOTGROUP'		=> 'Αδυναμία εισαγωγής bot στον πίνακα με τα bots.',
	'CONV_ERROR_INSERT_USER_GROUP'		=> 'Αδυναμία εισαγωγής μέλους στον πίνακα user_group.',
	'CONV_ERROR_MESSAGE_PARSER'			=> 'Σφάλμα μηνύματος ανάλυσης',
	'CONV_ERROR_NO_AVATAR_PATH'			=> 'Σημείωση για προγραμματιστή: πρέπει να καθορίσετε $convertor[\'avatar_path\'] για να χρησιμοποιήσετε %s.',
	'CONV_ERROR_NO_FORUM_PATH'			=> 'Η σχετική διαδρομή για το πηγαίο σύστημα συζητήσεων δεν έχει καθοριστεί.',
	'CONV_ERROR_NO_GALLERY_PATH'		=> 'Σημείωση για προγραμματιστή: πρέπει να καθορίσετε $convertor[\'avatar_gallery_path\'] για να χρησιμοποιήσετε %s.',
	'CONV_ERROR_NO_GROUP'				=> 'Η ομάδα “%1$s” δεν βρέθηκε στο %2$s.',
	'CONV_ERROR_NO_RANKS_PATH'			=> 'Σημείωση για προγραμματιστή: πρέπει να καθορίσετε $convertor[\'ranks_path\'] για να χρησιμοποιήσετε %s.',
	'CONV_ERROR_NO_SMILIES_PATH'		=> 'Σημείωση για προγραμματιστή: πρέπει να καθορίσετε $convertor[\'smilies_path\'] για να χρησιμοποιήσετε %s.',
	'CONV_ERROR_NO_UPLOAD_DIR'			=> 'Σημείωση για προγραμματιστή: πρέπει να καθορίσετε $convertor[\'upload_path\'] για να χρησιμοποιήσετε %s.',
	'CONV_ERROR_PERM_SETTING'			=> 'Αδυναμία εισαγωγής/αναβάθμισης ρυθμίσεων δικαιωμάτων.',
	'CONV_ERROR_PM_COUNT'				=> 'Αδυναμία επιλογής φακέλου ΠΜ μέτρησης.',
	'CONV_ERROR_REPLACE_CATEGORY'		=> 'Αδυναμία εισαγωγής νέας Δ. Συζήτησης με αντικατάσταση παλιάς κατηγορίας.',
	'CONV_ERROR_REPLACE_FORUM'			=> 'Αδυναμία εισαγωγής νέας Δ. Συζήτησης με αντικατάσταση παλιάς Δ. Συζήτησης.',
	'CONV_ERROR_USER_ACCESS'			=> 'Αδυναμία λήψης πληροφοριών πιστοποίησης μέλους.',
	'CONV_ERROR_WRONG_GROUP'			=> 'Λάθος ομάδα “%1$s” καθορισμένη σε %2$s.',
	'CONV_OPTIONS_BODY'					=> 'Αυτή η σελίδα συλλέγει τα στοιχεία που απαιτούνται για την πρόσβαση στο πηγαίο σύστημα συζητήσεων. Εισάγετε τα στοιχεία της βάσης δεδομένων του προηγούμενου συστήματος συζητήσεών σας, ο μετατροπέας δεν θα αλλάξει τίποτα στη βάση δεδομένων που δίνεται παρακάτω. Το πηγαίο σύστημα συζητήσεων θα απενεργοποιηθεί για να επιτρέψει μια συνεπή μετατροπή.',
	'CONV_SAVED_MESSAGES'				=> 'Αποθηκευμένα μηνύματα',

	'PRE_CONVERT_COMPLETE'			=> 'Όλα τα στάδια προετοιμασίας της μετατροπής έχουν ολοκληρωθεί με επιτυχία. Μπορείτε τώρα να ξεκινήσετε τη πραγματική διαδικασία μετατροπής. Παρακαλώ σημειώστε ότι μπορεί να χρειαστεί να κάνετε χειροκίνητα και να ρυθμίσετε διάφορα πράγματα. Μετά τη μετατροπή, κυρίως ελέγξτε τα δικαιώματα που έχουν ανατεθεί, ανακατασκευάστε το ευρετήριο αναζήτησης το οποίο δεν μετατρέπεται και επίσης βεβαιωθείτε ότι τα αρχεία έχουν αντιγραφεί σωστά, για παράδειγμα, άβαταρ και smilies.',
));
