<?php
/**
*
* This file is part of the phpBB Forum Software package.
*
* @copyright (c) phpBB Limited <https://www.phpbb.com>
* @license GNU General Public License, version 2 (GPL-2.0)
*
* For full copyright and license information, please see
* the docs/CREDITS.txt file.
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = [];
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste:
// ’ » “ ” …
//

$lang = array_merge($lang, [
	'TRANSLATION_INFO'	=> '<a href="https://www.phpbbguru.net">Русская поддержка phpBB</a>',
	'DIRECTION'			=> 'ltr',
	'DATE_FORMAT'		=> '|d.m.Y|',	// 01 Jan 2007 (with Relative days enabled)
	'DATETIME_FORMAT'	=> '|d M Y, H:i|',	// 01 Jan 2007, 13:37 (with Relative days enabled)
	'USER_LANG'			=> 'ru',

	// You can define different rules for the determination of plural forms here.
	// See https://area51.phpbb.com/docs/dev/3.3.x/language/plurals.html for more information
	// or ask the translation manager for help.
	// Rule #7 Families: Slavic (Bosnian, Croatian, Serbian, Russian, Ukrainian)
	// 0 can be handled special case. If you add a key 0 to your array, that will be used 
	// in case of 0 independent of the plural rule.
	// 1 - ends in 1, not 11: 1, 21, 31, ... 101, 121, ...
	// 2 - ends in 2-4, not 12-14: 2, 3, 4, 22, 23, 24, 32, ...
	// 3 - everything else: 0, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 25, 26, ...
	'PLURAL_RULE'		=> 7,

	'1_DAY'			=> '1 день',
	'1_MONTH'		=> '1 месяц',
	'1_YEAR'		=> '1 год',
	'2_WEEKS'		=> '2 недели',
	'3_MONTHS'		=> '3 месяца',
	'6_MONTHS'		=> '6 месяцев',
	'7_DAYS'		=> '7 дней',

	'ACCOUNT_ALREADY_ACTIVATED'		=> 'Ваша учётная запись уже была активирована.',
	'ACCOUNT_DEACTIVATED'			=> 'Ваша учётная запись была отключена вручную и может быть вновь активирована только администратором конференции.',
	'ACP'							=> 'Администраторский раздел',
	'ACP_SHORT'						=> 'Администрировать',
	'ACTIVATION_ALREADY_SENT'		=> 'Письмо для активации учётной записи уже было выслано на ваш адрес email. Повторная попытка активации возможна не ранее, чем через 24 часа. Если проблемы при активации учётной записи сохранятся, свяжитесь с администратором конференции.',
	'ACTIVE'						=> 'активен',
	'ACTIVE_ERROR'					=> 'Указанное имя пользователя в настоящее время неактивно. Если вы испытываете трудности с активацией своей учётной записи, то свяжитесь с администратором конференции.',
	'ADMINISTRATOR'					=> 'Администратор',
	'ADMINISTRATORS'				=> 'Администраторы',
	'AGE'							=> 'Возраст',
	'AIM'							=> 'AIM',
	'AJAX_ERROR_TITLE'				=> 'Ошибка AJAX',
	'AJAX_ERROR_TEXT'				=> 'При обработке запроса произошла ошибка.',
	'AJAX_ERROR_TEXT_ABORT'			=> 'Запрос прерван пользователем.',
	'AJAX_ERROR_TEXT_TIMEOUT'		=> 'Время запроса истекло; повторите попытку.',
	'AJAX_ERROR_TEXT_PARSERERROR'	=> 'При выполнении запроса возникла непредвиденная ошибка, и сервер вернул неверный ответ.',
	'ALLOWED'						=> 'Разрешено',
	'ALL_FILES'						=> 'Все файлы',
	'ALL_FORUMS'					=> 'Все форумы',
	'ALL_MESSAGES'					=> 'Все сообщения',
	'ALL_POSTS'						=> 'Все сообщения',
	'ALL_TIMES'						=> 'Часовой пояс: <span title="%2$s">%1$s</span>',
	'ALL_TOPICS'					=> 'Все темы',
	'ALT_TEXT'						=> 'Текст для всплывающей подсказки',
	'AND'							=> 'и',
	'ARE_WATCHING_FORUM'			=> 'Вы подписаны на уведомления о новых сообщениях в этом форуме.',
	'ARE_WATCHING_TOPIC'			=> 'Вы подписаны на уведомления о новых сообщениях в этой теме.',
	'ASCENDING'						=> 'по возрастанию',
	'ATTACHMENTS'					=> 'Вложения',
	'ATTACHED_IMAGE_NOT_IMAGE'		=> 'Вы попытались отправить недопустимый тип файла изображения.',
	'AUTHOR'						=> 'Автор',
	'AUTH_NO_PROFILE_CREATED'		=> 'Не удалось создать профиль пользователя.',
	'AUTH_PROVIDER_OAUTH_ERROR_ALREADY_LINKED'				=> 'Данный внешний сервис аутентификации уже привязан к другой учетной записи конференции.',
	'AUTH_PROVIDER_OAUTH_ERROR_INVALID_ENTRY'				=> 'Неверная запись в базу данных.',
	'AUTH_PROVIDER_OAUTH_ERROR_INVALID_SERVICE_TYPE'		=> 'Для обработчика сервиса oAuth предоставлен неверный тип сервиса.',
	'AUTH_PROVIDER_OAUTH_ERROR_REQUEST'						=> 'Произошла ошибка при обработке запроса OAuth.',
	'AUTH_PROVIDER_OAUTH_RETURN_ERROR'						=> 'Данный внешний сервис аутентификации вернул неверный ответ, поэтому запрос не может быть обработан.',
	'AUTH_PROVIDER_OAUTH_ERROR_SERVICE_NOT_CREATED'			=> 'Сервис OAuth не создан',
	'AUTH_PROVIDER_OAUTH_SERVICE_BITLY'						=> 'Bitly',
	'AUTH_PROVIDER_OAUTH_SERVICE_FACEBOOK'					=> 'Facebook',
	'AUTH_PROVIDER_OAUTH_SERVICE_GOOGLE'					=> 'Google',
	'AUTH_PROVIDER_OAUTH_SERVICE_TWITTER'					=> 'Twitter',
	'AUTH_PROVIDER_OAUTH_TOKEN_ERROR_NOT_STORED'			=> 'Пакет данных OAuth не сохранён.',
	'AUTH_PROVIDER_OAUTH_TOKEN_ERROR_INCORRECTLY_STORED'	=> 'Пакет данных OAuth некорректно сохранён.',
	'AVATAR_DISALLOWED_CONTENT'		=> 'Закачка была отклонена, так как вложение было определено как возможная атака.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'Данный файл не может быть отображён, поскольку расширение <strong>%s</strong> не разрешено',
	'AVATAR_EMPTY_REMOTE_DATA'		=> 'Не удалось загрузить указанную аватару. Возможно, данные повреждены или недопустимы.',
	'AVATAR_EMPTY_FILEUPLOAD'		=> 'Загруженный файл аватары пуст.',
	'AVATAR_INVALID_FILENAME'		=> '%s является недопустимым именем файла.',
	'AVATAR_NOT_UPLOADED'			=> 'Загрузка аватары не удалась.',
	'AVATAR_NO_TEMP_DIR'			=> 'Временная папка не найдена или недоступна для записи.',
	'AVATAR_NO_SIZE'				=> 'Не удалось определить размеры указанной аватары. Пожалуйста, введите их вручную.',
	'AVATAR_NO_UPLOAD_DIR'			=> 'Путь к папке для загрузки аватар не существует, либо запись в указанную папку не разрешена.',
	'AVATAR_NO_UPLOAD_PATH'			=> 'Прямая загрузка аватар разрешена, но путь к папкке для загрузки аватар не задан.',
	'AVATAR_PARTIAL_UPLOAD'			=> 'Указанный файл загружен только частично',
	'AVATAR_PHP_SIZE_NA'			=> 'Слишком большой размер файла аватары.<br />Не удалось определить максимальный размер, установленный в php.ini.',
	'AVATAR_PHP_SIZE_OVERRUN'		=> 'Слишком большой размер файла аватары. Максимально допустимый размер — %1$d %2$s.<br />Примечание: это ограничение установлено в файле php.ini и не может быть превышено.',
	'AVATAR_REMOTE_UPLOAD_TIMEOUT'		=> 'Указанная аватара не может быть загружена из-за превышения времени ожидания запроса.',
	'AVATAR_PHP_UPLOAD_STOPPED'		=> 'Загрузка файла остановлена одним из модулей PHP.',
	'AVATAR_URL_INVALID'			=> 'Указанный адрес аватары недопустим.',
	'AVATAR_URL_NOT_FOUND'			=> 'Указанный файл аватары не найден.',
	'AVATAR_WRONG_FILESIZE'			=> 'Размер файла аватары должен находиться в диапазоне от 0 до %1$d %2$s.',
	'AVATAR_WRONG_SIZE'				=> 'Размеры отправленной аватары — %5$s×%6$s. Размеры аватары должны быть не менее %1$s×%2$s, но не более %3$s×%4$s.',

	'BACK_TO_TOP'			=> 'Вернуться к началу',
	'BACK_TO_PREV'			=> 'Вернуться на предыдущую страницу',
	'BAN_TRIGGERED_BY_EMAIL'=> 'Доступ к конференции закрыт для вашего адреса email.',
	'BAN_TRIGGERED_BY_IP'	=> 'Доступ к конференции закрыт для вашего IP-адреса.',
	'BAN_TRIGGERED_BY_USER'	=> 'Доступ к конференции закрыт для вашей учётной записи.',
	'BBCODE_GUIDE'			=> 'Руководство по BBCode',
	'BCC'					=> 'Скрытая копия',
	'BIRTHDAYS'				=> 'Дни рождения',
	'BOARD_BAN_PERM'		=> 'Вам закрыт доступ к конференции.<br /><br />Для получения дополнительной информации %2$sсвяжитесь с администратором конференции%3$s.',
	'BOARD_BAN_REASON'		=> 'Причина: <strong>%s</strong>',
	'BOARD_BAN_TIME'		=> 'Вам закрыт доступ к конференции до <strong>%1$s</strong>.<br /><br />Для получения дополнительной информации %2$sсвяжитесь с администратором конференции%3$s.',
	'BOARD_DISABLE'			=> 'Извините, но конференция в настоящий момент недоступна',
	'BOARD_DISABLED'		=> 'Конференция в настоящий момент отключена.',
	'BOARD_UNAVAILABLE'		=> 'Конференция временно недоступна. Попробуйте зайти через несколько минут.',
	'BROWSING_FORUM'		=> 'Сейчас этот форум просматривают: %1$s',
	'BROWSING_FORUM_GUESTS'	=> array(
		1	=> 'Сейчас этот форум просматривают: %2$s и %1$d гость',
		2	=> 'Сейчас этот форум просматривают: %2$s и %1$d гостя',
		3	=> 'Сейчас этот форум просматривают: %2$s и %1$d гостей',
	),
	'BUTTON_DELETE'         => 'Удалить',
	'BUTTON_EDIT'			=> 'Правка',
	'BUTTON_FORUM_LOCKED'	=> 'Закрыто',
	'BUTTON_INFORMATION'    => 'Информация',
	'BUTTON_NEW_TOPIC'		=> 'Новая тема',
	'BUTTON_PM'				=> 'ЛС',
	'BUTTON_PM_FORWARD'		=> 'Переслать',
	'BUTTON_PM_NEW'			=> 'Новое ЛС',
	'BUTTON_PM_REPLY'		=> 'Ответить',
	'BUTTON_PM_REPLY_ALL'	=> 'Ответить всем',
	'BUTTON_POST_REPLY'		=> 'Ответить',
	'BUTTON_QUOTE'			=> 'Цитата',
	'BUTTON_REPORT'         => 'Жалоба',
	'BUTTON_TOPIC_LOCKED'	=> 'Закрыто',
	'BUTTON_WARN'           => 'Предупредить',
	'BYTES'					=> 'байт',
	'BYTES_SHORT'			=> 'Б',

	'CANCEL'				=> 'Отмена',
	'CHANGE'				=> 'Изменить',
	'CHANGE_FONT_SIZE'		=> 'Изменить размер шрифта',
	'CHANGING_PREFERENCES'	=> 'Изменение личных настроек',
	'CHANGING_PROFILE'		=> 'Изменение настроек профиля',
	'CHARACTERS'			=> [
		0	=> '%d символов',
		1	=> '%d символ',
		2	=> '%d символа',
		3	=> '%d символов',
	],
	// Special version to be used when describing ranges e.g. "min x characters and max y characters"
	'CHARACTERS_XY'			=> [
		0	=> '%d символов',
		1	=> '%d символ',
		2	=> '%d символа',
		3	=> '%d символов',
	],
	'COLLAPSE_VIEW'			=> 'Свернуть',
	'CLOSE_WINDOW'			=> 'Закрыть окно',
	'CODE'					=> 'Код',
	'COLOUR_SWATCH'			=> 'Палитра',
	'COLON'					=> ':',
	'COMMA_SEPARATOR'		=> ', ',	// Comma used to join lists into a single string, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'				=> 'Подтверждение',
	'CONFIRM_CODE'			=> 'Код подтверждения',
	'CONFIRM_CODE_EXPLAIN'	=> 'Введите код в точности так, как вы его видите. Регистр символов не имеет значения.',
	'CONFIRM_CODE_WRONG'	=> 'Вы ввели неверный код подтверждения.',
	'CONFIRM_OPERATION'		=> 'Вы уверены, что хотите выполнить эту операцию?',
	'CONFIRM_AVATAR_DELETE' => 'Вы уверены, что хотите удалить эту аватару?',
	'CONGRATULATIONS'		=> 'Поздравляем',
	'CONNECTION_FAILED'		=> 'Ошибка подключения.',
	'CONNECTION_SUCCESS'	=> 'Подключение успешно установлено.',
	'CONTACT'				=> 'Контактная информация',
	'CONTACT_USER'			=> 'Контактная информация пользователя %s',
	'CONTACT_US'			=> 'Связаться с администрацией',
	'COOKIE_CONSENT_INFO'	=> 'Подробнее',
	'COOKIE_CONSENT_MSG'	=> 'Этот сайт использует cookies для обеспечения своей корректной работы.',
	'COOKIE_CONSENT_OK'		=> 'Согласен',
	'COOKIE_CONSENT_HREF'	=> 'http://cookiesandyou.com',
	'COOKIES_DELETED'		=> 'Все cookies, установленные конференцией, успешно удалены.',
	'CURRENT_TIME'			=> 'Текущее время: %s',

	'DAY'					=> 'День',
	'DAYS'					=> 'дней',
	'DELETE'				=> 'Удалить',
	'DELETE_ALL'			=> 'Удалить все',
	'DELETE_COOKIES'		=> 'Удалить cookies',
	'DELETE_MARKED'			=> 'Удалить отмеченные',
	'DELETE_POST'			=> 'Удалить сообщение',
	'DELIMITER'				=> 'Разделитель',
	'DESCENDING'			=> 'по убыванию',
	'DISABLED'				=> 'Отключено',
	'DISPLAY'				=> 'Показать',
	'DISPLAY_GUESTS'		=> 'Показать гостей',
	'DISPLAY_MESSAGES'		=> 'Показать сообщения за',
	'DISPLAY_POSTS'			=> 'Показать сообщения за',
	'DISPLAY_TOPICS'		=> 'Показать темы за',
	'DOMAIN_NO_MX_RECORD_EMAIL'	=> 'Введённый домен email не имеет корректной почтовой записи в DNS (MX record).',
	'DOWNLOADED'			=> 'Скачиваний:',
	'DOWNLOADING_FILE'		=> 'Скачивание файла',
	'DOWNLOAD_COUNTS'		=> array(
		0	=> '0 скачиваний',
		1	=> '%d скачивание',
		2	=> '%d скачивания',
		3	=> '%d скачиваний',
	),

	'EDIT_POST'							=> 'Редактировать сообщение',
	'ELLIPSIS'							=> '…',
	'EMAIL'								=> 'Email', // Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'						=> 'Адрес email',
	'EMAIL_INVALID_EMAIL'				=> 'Введённый адрес email неверен.',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'Ошибка при отправке email в <strong>строке %1$s</strong>. Ответ сервера: %2$s.',
	'EMPTY_SUBJECT'						=> 'При создании новой темы необходимо указать заголовок.',
	'EMPTY_MESSAGE_SUBJECT'				=> 'Вы должны указать тему нового сообщения.',
	'ENABLED'							=> 'Включено',
	'ENCLOSURE'							=> 'Ограничитель',
	'ENTER_USERNAME'					=> 'Введите имя пользователя',
	'ERR_CHANGING_DIRECTORY'			=> 'Не удалось сменить папку.',
	'ERR_CONNECTING_SERVER'				=> 'Ошибка подключения к серверу.',
	'ERR_JAB_AUTH'						=> 'Не удалось авторизоваться на сервере Jabber.',
	'ERR_JAB_CONNECT'					=> 'Не удалось подключиться к серверу Jabber.',
	'ERR_UNABLE_TO_LOGIN'				=> 'Указано неверное имя пользователя или пароль.',
	'ERR_UNWATCHING'					=> 'При попытке отказаться от подписки возникла ошибка.',
	'ERR_WATCHING'						=> 'При попытке подписаться возникла ошибка.',
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'Указанный путь к конференции неверен.',
	'ERROR'									=> 'Ошибка',
	'EXPAND_VIEW'						=> 'Развернуть',
	'EXTENSION'							=> 'Расширение',
	'EXTENSION_DISABLED'				=> 'Расширение <strong>%s</strong> не включено.',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'Расширение <strong>%s</strong> было запрещено, вложение больше недоступно.',
	'EXTENSION_DOES_NOT_EXIST'			=> 'Расширение <strong>%s</strong> не существует.',

	'FACEBOOK'				=> 'Facebook',
	'FAQ'					=> 'FAQ',
	'FAQ_EXPLAIN'			=> 'Часто задаваемые вопросы',
	'FEATURE_NOT_AVAILABLE' => 'Запрашиваемая функция недоступна на этой конференции.',
	'FILENAME'				=> 'Имя файла',
	'FILESIZE'				=> 'Размер файла',
	'FILEDATE'				=> 'Дата создания файла',
	'FILE_COMMENT'			=> 'Комментарий к файлу',
	'FILE_CONTENT_ERR'		=> 'Не удалось прочесть содержимое файла: %s',
	'FILE_JSON_DECODE_ERR'	=> 'Не удалось расшифровать файл json: %s',
	'FILE_NOT_FOUND'		=> 'Запрашиваемый файл не найден: %s',
	'FIND_USERNAME'			=> 'Найти пользователя',
	'FOLDER'				=> 'Папка',
	'FORGOT_PASS'			=> 'Забыли пароль?',
	'FORM_INVALID'			=> 'Ошибка отправки формы. Попробуйте ещё раз.',
	'FORUM'					=> 'Форум',
	'FORUMS'				=> 'Форумы',
	'FORUMS_MARKED'			=> 'Форумы отмечены как прочтённые',
	'FORUM_CAT'				=> 'Категория',
	'FORUM_INDEX'			=> 'Список форумов',
	'FORUM_LINK'			=> 'Ссылка на форум',
	'FORUM_LOCATION'		=> 'Место в конференции',
	'FORUM_LOCKED'			=> 'Форум закрыт',
	'FORUM_RULES'			=> 'Правила форума',
	'FORUM_RULES_LINK'		=> 'Посмотреть правила форума',
	'FROM'					=> 'из',
	'FSOCK_DISABLED'		=> 'Действие не может быть завершено, поскольку функция <var>fsockopen</var> отключена или запрашиваемый сервер не найден.',
	'FSOCK_TIMEOUT'			=> 'Таймаут соединения.',

	'FILESYSTEM_CANNOT_CHANGE_FILE_GROUP'		=> 'Не удалось изменить группу для файла',
	'FILESYSTEM_CANNOT_CHANGE_FILE_PERMISSIONS'	=> 'Не удалось изменить права доступа для файла',
	'FILESYSTEM_CANNOT_COPY_FILES'				=> 'Не удалось скопировать файлы',
	'FILESYSTEM_CANNOT_CREATE_SYMLINK'			=> 'Не удалось создать символическую ссылку',
	'FILESYSTEM_CANNOT_CREATE_DIRECTORY'		=> 'Не удалось создать папку',
	'FILESYSTEM_CANNOT_DELETE_FILES'			=> 'Не удалось удалить файлы из системы',
	'FILESYSTEM_CANNOT_DUMP_FILE'				=> 'Не удалось выгрузить данные в файл',
	'FILESYSTEM_CANNOT_MIRROR_DIRECTORY'		=> 'Не удалось скопировать папку',
	'FILESYSTEM_CANNOT_RENAME_FILE'				=> 'Не удалось переименовать файл в системе',
	'FILESYSTEM_CANNOT_TOUCH_FILES'				=> 'Не удалось создать файл или изменить дату его создания',

	'FTP_FSOCK_HOST'				=> 'FTP-сервер',
	'FTP_FSOCK_HOST_EXPLAIN'		=> 'FTP-сервер для соединения с сайтом.',
	'FTP_FSOCK_PASSWORD'			=> 'Пароль FTP',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'Пароль для входа на FTP-сервер.',
	'FTP_FSOCK_PORT'				=> 'Порт FTP',
	'FTP_FSOCK_PORT_EXPLAIN'		=> 'Порт для соединения с FTP-сервером.',
	'FTP_FSOCK_ROOT_PATH'			=> 'Путь к phpBB',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'Путь к папке, содержащей phpBB, относительно корня сайта.',
	'FTP_FSOCK_TIMEOUT'				=> 'Тайм-аут FTP',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'		=> 'Время в секундах, в течение которого система будет ожидать ответа от FTP-сервера.',
	'FTP_FSOCK_USERNAME'			=> 'Имя пользователя FTP',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'Имя пользователя для соединения с FTP-сервером.',

	'FTP_HOST'					=> 'FTP-сервер',
	'FTP_HOST_EXPLAIN'			=> 'FTP-сервер для соединения с сайтом.',
	'FTP_PASSWORD'				=> 'Пароль FTP',
	'FTP_PASSWORD_EXPLAIN'		=> 'Пароль для входа на FTP-сервер.',
	'FTP_PORT'					=> 'Порт FTP',
	'FTP_PORT_EXPLAIN'			=> 'Порт для соединения с FTP-сервером.',
	'FTP_ROOT_PATH'				=> 'Путь к phpBB',
	'FTP_ROOT_PATH_EXPLAIN'		=> 'Путь к папке, содержащей phpBB, относительно корня сайта.',
	'FTP_TIMEOUT'				=> 'Тайм-аут FTP',
	'FTP_TIMEOUT_EXPLAIN'		=> 'Время в секундах, в течение которого система будет ожидать ответа от FTP-сервера.',
	'FTP_USERNAME'				=> 'Имя пользователя FTP',
	'FTP_USERNAME_EXPLAIN'		=> 'Имя пользователя для соединения с FTP-сервером.',

	'GENERAL_ERROR'				=> 'Общая ошибка',
	'GB'						=> 'ГБ',
	'GIB'						=> 'ГБ',
	'GO'						=> 'Перейти',
	'GOTO_FIRST_POST'			=> 'Перейти к первому сообщению',
	'GOTO_LAST_POST'			=> 'Перейти к последнему сообщению',
	'GOTO_PAGE'					=> 'На страницу',
	'GROUP'						=> 'Группа',
	'GROUPS'					=> 'Группы',
	'GROUP_ERR_TYPE'			=> 'Выбран несоответствующий тип группы.',
	'GROUP_ERR_USERNAME'		=> 'Не указано имя группы.',
	'GROUP_ERR_USER_LONG'		=> 'Имя группы не может быть длиннее 60 символов. Указанное имя группы слишком длинное.',
	'GUEST'						=> 'Гость',
	'GUEST_USERS_ONLINE'		=> array(
		0	=> 'Сейчас на конференции %d гостей',
		1	=> 'Сейчас на конференции %d гость',
		2	=> 'Сейчас на конференции %d гостя',
		3	=> 'Сейчас на конференции %d гостей',
	),
	'GUEST_USERS_TOTAL'			=> array(
		0	=> '%d гостей',
		1	=> '%d гость',
		2	=> '%d гостя',
		3	=> '%d гостей',
	),
	'G_ADMINISTRATORS'			=> 'Администраторы',
	'G_BOTS'					=> 'Боты',
	'G_GUESTS'					=> 'Гости',
	'G_REGISTERED'				=> 'Зарегистрированные пользователи',
	'G_REGISTERED_COPPA'		=> 'Зарегистрированные пользователи (COPPA)',
	'G_GLOBAL_MODERATORS'		=> 'Супермодераторы',
	'G_NEWLY_REGISTERED'		=> 'Новые пользователи',

	'HIDDEN_USERS_ONLINE'		=> array(
		0	=> '%d скрытых пользователей',
		1	=> '%d скрытый пользователь',
		2	=> '%d скрытых пользователя',
		3	=> '%d скрытых пользователей',
	),
	'HIDDEN_USERS_TOTAL'		=> array(
		0	=> '%d скрытых',
		1	=> '%d скрытый',
		2	=> '%d скрытых',
		3	=> '%d скрытых',
	),
	'HIDE_GUESTS'					=> 'Скрыть гостей',
	'HIDE_ME'						=> 'Скрыть моё пребывание на конференции в этот раз',
	'HOURS'							=> 'часов',
	'HOME'							=> 'На главную',

	'ICQ'						=> 'ICQ',
	'IF'						=> 'Если',
	'IMAGE'						=> 'Изображение',
	'IMAGE_FILETYPE_INVALID'	=> 'Тип файла изображения %d не поддерживается для MIME-типа %s.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'Несовпадение типа изображения: ожидаемое расширение %1$s вместо полученного %2$s.',
	'IN'						=> 'в форуме',
	'INACTIVE'					=> 'Неактивен',
	'INDEX'						=> 'Главная страница',
	'INFORMATION'				=> 'Информация',
	'INSECURE_REDIRECT'			=> 'Попытка перенаправления на потенциально опасный сайт.',
	'INTERESTS'					=> 'Интересы',
	'INVALID_DIGEST_CHALLENGE'	=> 'Неверный запрос аутентификации.',
	'INVALID_EMAIL_LOG'			=> 'Возможно, введён неверный адрес email: <strong>%s</strong>',
	'INVALID_FEED_ATTACHMENTS'	=> 'Выбранный канал новостей использовал неверные параметры для отображения вложений.',
	'INVALID_PLURAL_RULE'		=> 'Выбрано неверное правило для множественного числа. Правильными являются целые числа между 0 и 15.',
	'IP'						=> 'IP',
	'IP_BLACKLISTED'			=> 'Ваш IP-адрес %1$s был внесён в черный список и заблокирован. Для получения дополнительной информации перейдите по ссылке <a href="%2$s">%2$s</a>.',

	'JABBER'				=> 'Jabber',
	'JOINED'				=> 'Зарегистрирован',
	'JUMP_PAGE'				=> 'Введите номер страницы, на которую хотите перейти',
	'JUMP_TO'				=> 'Перейти',
	'JUMP_TO_PAGE'			=> 'Перейти на страницу',
	'JUMP_TO_PAGE_CLICK'	=> 'Щёлкните для перехода на страницу…',

	'KB'					=> 'КБ',
	'KIB'					=> 'КБ',

	'LAST_POST'							=> 'Последнее сообщение',
	'LAST_UPDATED'						=> 'Последнее изменение',
	'LAST_VISIT'						=> 'Последнее посещение',
	'LDAP_NO_LDAP_EXTENSION'			=> 'Расширение LDAP недоступно.',
	'LDAP_NO_SERVER_CONNECTION'			=> 'Не удалось соединиться с сервером LDAP.',
	'LDAP_SEARCH_FAILED'				=> 'Произошла ошибка при поиске в директории LDAP.',
	'LEGEND'							=> 'Легенда',
	'LIVE_SEARCHES_NOT_ALLOWED'			=> 'Поиск «на лету» не разрешён.',
	'LOADING'							=> 'Загрузка',
	'LOCATION'							=> 'Откуда',
	'LOCK_POST'							=> 'Заблокировать сообщение',
	'LOCK_POST_EXPLAIN'					=> 'запрет редактирования',
	'LOCK_TOPIC'						=> 'Закрыть тему',
	'LOGIN'								=> 'Вход',
	'LOGIN_CHECK_PM'					=> 'Войти и проверить личные сообщения.',
	'LOGIN_CONFIRMATION'				=> 'Подтверждение входа',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'Для предотвращения подбора паролей к вашей учётной записи необходимо ввести код подтверждения после максимального количества неудачных входов в систему. Код показан на картинке ниже. Введите код в точности так, как вы его видите. Если вы не видите кода, то обратитесь к %sадминистратору%s.', // больше не используется
	'LOGIN_ERROR_ATTEMPTS'				=> 'Вы превысили максимально допустимое количество попыток входа. Теперь, кроме имени пользователя и пароля, вы должны пройти проверку средством против спам-ботов.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'Apache не смог вас аутентифицировать.',
	'LOGIN_ERROR_OAUTH_SERVICE_DOES_NOT_EXIST'  => 'Был запрошен несуществующий сервис oAuth.',
	'LOGIN_ERROR_PASSWORD'				=> 'Вы ввели неверный пароль. Проверьте его и попробуйте ввести ещё раз. Если проблема со входом останется, то сообщите об этом %sадминистратору%s.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'При обновлении конференции не удалось преобразовать ваш пароль. Вы можете %sзапросить новый пароль%s. Если вы продолжаете испытывать трудности, то свяжитесь с %sадминистратором конференции%s.',
	'LOGIN_ERROR_USERNAME'				=> 'Вы ввели неверное имя пользователя. Проверьте его и попробуйте ввести ещё раз. Если проблема со входом останется, то сообщите об этом %sадминистратору%s.',
	'LOGIN_FORUM'						=> 'Для просмотра или размещения сообщений в этом форуме необходимо ввести пароль.',
	'LOGIN_INFO'						=> 'Для входа на конференцию вы должны быть зарегистрированы. Регистрация занимает всего несколько минут, но предоставляет вам более широкие возможности. Администратором конференции могут быть установлены также дополнительные привилегии для зарегистрированных пользователей. Прежде чем зарегистрироваться, вам следует ознакомиться с правилами и политикой, принятыми на конференции. Помните, что ваше присутствие на форумах означает согласие со всеми правилами.',
	'LOGIN_VIEWFORUM'					=> 'Для просмотра этого форума вы должны быть авторизованы.',
	'LOGIN_EXPLAIN_EDIT'				=> 'Для редактирования сообщений в этом форуме вы должны быть авторизованы.',
	'LOGIN_EXPLAIN_VIEWONLINE'			=> 'Для просмотра списка пользователей, находящихся сейчас на конференции, вы должны быть авторизованы.',
	'LOGIN_REQUIRED'					=> 'Для выполнения данного действия необходимо авторизоваться.',
	'LOGOUT'							=> 'Выход',
	'LOGOUT_USER'						=> 'Выход [ %s ]',
	'LOG_ME_IN'							=> 'Запомнить меня',

	'MAIN'					=> 'Главная',
	'MARK'					=> 'Отметить',
	'MARK_ALL'				=> 'Отметить все',
	'MARK_ALL_READ'			=> 'Отметить всё как прочтённое',
	'MARK_FORUMS_READ'		=> 'Отметить форумы как прочтённые',
	'MARK_READ'				=> 'Отметить как прочтённое',
	'MARK_SUBFORUMS_READ'	=> 'Отметить подфорумы как прочтённые',
	'MB'					=> 'MБ',
	'MIB'					=> 'МБ',
	'MCP'					=> 'Модераторский раздел',
	'MCP_SHORT'				=> 'Модерировать',
	'MEMBERLIST'			=> 'Пользователи',
	'MEMBERLIST_EXPLAIN'	=> 'Просмотр всего списка пользователей',
	'MERGE'					=> 'Объединить',
	'MERGE_POSTS'			=> 'Перенести сообщения',
	'MERGE_TOPIC'			=> 'Объединить тему',
	'MESSAGE'				=> 'Сообщение',
	'MESSAGES'				=> 'Сообщения',
	'MESSAGES_COUNT'		=> array(
		0	=> 'неограниченного лимита',
		1	=> '%d сообщения',
		2	=> '%d сообщений',
		3	=> '%d сообщений',
	),
	'MESSAGE_BODY'			=> 'Текст сообщения',
	'MINUTES'				=> 'минут',
	'MODERATE'				=> 'Модерировать',
	'MODERATOR'				=> 'Модератор',
	'MODERATORS'			=> 'Модераторы',
	'MODULE_NOT_ACCESS'		=> 'Модуль недоступен',
	'MODULE_NOT_FIND'		=> 'Не найден модуль %s',
	'MODULE_FILE_INCORRECT_CLASS'	=> 'Файл модуля %s не содержит необходимого класса [%s]',
	'MONTH'					=> 'Месяц',
	'MOVE'					=> 'Переместить',

	'NA'						=> 'Нет',
	'NEWEST_USER'				=> 'Новый пользователь: <strong>%s</strong>',
	'NEW_MESSAGE'				=> 'Новое сообщение',
	'NEW_MESSAGES'				=> 'Новые сообщения',
	'NEW_POST'					=> 'Новое сообщение', // Больше не используется
	'NEW_POSTS'					=> 'Новые сообщения', // Больше не используется
	'NEXT'						=> 'След.',		// Used in pagination
	'NEXT_STEP'					=> 'Далее',
	'NEVER'						=> 'Никогда',
	'NO'						=> 'Нет',
	'NO_NOTIFICATIONS'			=> 'Нет уведомлений',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'Вы не можете управлять этой группой.',
	'NOT_AUTHORISED'			=> 'У вас нет доступа в эту часть форума.',
	'NOT_WATCHING_FORUM'		=> 'Вы больше не подписаны на обновления в этом форуме.',
	'NOT_WATCHING_TOPIC'		=> 'Вы больше не подписаны на эту тему.',
	'NOTIFICATIONS'				=> 'Уведомления',
	// This applies for NOTIFICATION_BOOKMARK and NOTIFICATION_POST.
	// %1$s will return a list of users that's concatenated using "," and "and" - see STRING_LIST
	// Once the user count reaches 5 users or more, the list is trimmed using NOTIFICATION_X_OTHERS
	// Once the user count reaches 20 users or more, the list is trimmed using NOTIFICATION_MANY_OTHERS
	// Examples:
	// A replied...
	// A and B replied...
	// A, B and C replied...
	// A, B, C and 2 others replied...
	// A, B, C and others replied...
	'NOTIFICATION_BOOKMARK'				=> array(
		1	=> '<strong>Ответ</strong> от пользователя %1$s в теме, находящейся у Вас в закладках:',
		2	=> '<strong>Ответ</strong> от пользователей %1$s в теме, находящейся у Вас в закладках:',
		3	=> '<strong>Ответ</strong> от пользователей %1$s в теме, находящейся у Вас в закладках:',
	),
	'NOTIFICATION_FORUM'				=> '<em>Форум:</em> %1$s',
	'NOTIFICATION_GROUP_REQUEST'		=> '<strong>Запрос</strong> от пользователя %1$s на вступление в группу %2$s.',
	'NOTIFICATION_GROUP_REQUEST_APPROVED'  => '<strong>Одобрен запрос</strong> на вступление в группу %1$s.',
	'NOTIFICATION_METHOD_INVALID'		=> 'Метод «%s» не связан с каким-либо действующим методом уведомления.',
	'NOTIFICATION_PM'					=> '<strong>Личное сообщение</strong> от пользователя %1$s:',
	'NOTIFICATION_POST'					=> array(
		1	=> '<strong>Ответ</strong> от пользователя %1$s в теме:',
		2	=> '<strong>Ответ</strong> от пользователей %1$s в теме:',
		3	=> '<strong>Ответ</strong> от пользователей %1$s в теме:',
	),
	'NOTIFICATION_POST_APPROVED'		=> '<strong>Сообщение одобрено</strong>:',
	'NOTIFICATION_POST_DISAPPROVED'		=> '<strong>Сообщение отклонено</strong>:',
	'NOTIFICATION_POST_IN_QUEUE'		=> '<strong>Ожидает одобрения</strong> сообщение от пользователя %1$s:',
	'NOTIFICATION_QUOTE'				=> array(
		1	=> '<strong>Цитата</strong> от пользователя %1$s в сообщении:',
		2	=> '<strong>Цитата</strong> от пользователей %1$s в сообщении:',
		3	=> '<strong>Цитата</strong> от пользователей %1$s в сообщении:',
	),
	'NOTIFICATION_REFERENCE'			=> '«%1$s»',
	'NOTIFICATION_REASON'				=> '<em>Причина:</em> %1$s.',
	'NOTIFICATION_REPORT_PM'			=> '<strong>Жалоба на личное сообщение</strong> от пользователя %1$s:',
	'NOTIFICATION_REPORT_PM_CLOSED'		=> '<strong>Жалоба на личное сообщение закрыта</strong> пользователем %1$s:',
	'NOTIFICATION_REPORT_POST'			=> '<strong>Жалоба на сообщение</strong> от пользователя %1$s:',
	'NOTIFICATION_REPORT_CLOSED'		=> '<strong>Жалоба закрыта</strong> пользователем %1$s по причине:',
	'NOTIFICATION_TOPIC'				=> '<strong>Новая тема</strong> создана пользователем %1$s:',
	'NOTIFICATION_TOPIC_APPROVED'		=> '<strong>Тема одобрена</strong>:',
	'NOTIFICATION_TOPIC_DISAPPROVED'	=> '<strong>Тема отклонена</strong>:',
	'NOTIFICATION_TOPIC_IN_QUEUE'		=> '<strong>Ожидает одобрения</strong> тема, созданная пользователем %1$s:',
	'NOTIFICATION_TYPE_NOT_EXIST'		=> 'Тип уведомления «%s» отсутствует в файловой системе.',
	'NOTIFICATION_ADMIN_ACTIVATE_USER'	=> '<strong>Ожидает активации</strong> деактивированный или новый пользователь: «%1$s»',
	// Used in conjunction with NOTIFICATION_BOOKMARK and NOTIFICATION_POST.
	'NOTIFICATION_MANY_OTHERS'			=> 'других',
	'NOTIFICATION_X_OTHERS'				=> array(
		1	=> 'ещё %d пользователя',
		2	=> '%d других',
		3	=> '%d других',
	),
	'NOTIFY_ADMIN'				=> 'Уведомите администратора конференции или вебмастера.',
	'NOTIFY_ADMIN_EMAIL'		=> 'Уведомите администратора конференции или вебмастера: <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'		=> 'Вам запрещён доступ к этому файлу.',
	'NO_ACTION'					=> 'Действие не определено.',
	'NO_ADMINISTRATORS'			=> 'Администраторы отсутствуют.',
	'NO_AUTH_ADMIN'				=> 'Вы не имеете прав доступа к администраторскому разделу.',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'Вы не можете повторно авторизоваться как другой пользователь.',
	'NO_AUTH_OPERATION'			=> 'Вы не имеете необходимых прав доступа для завершения этой операции.',
	'NO_AVATARS'				=> 'Нет доступных аватар',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'Не удалось соединиться с SMTP-сервером: %1$s : %2$s',
	'NO_BIRTHDAYS'				=> 'Сегодня нет дней рождения.',
	'NO_EMAIL_MESSAGE'			=> 'Отсутствует текст сообщения.',
	'NO_EMAIL_RESPONSE_CODE'	=> 'Не удалось получить ответ от почтового сервера.',
	'NO_EMAIL_SUBJECT'			=> 'Не указана тема сообщения.',
	'NO_FORUM'					=> 'Запрошенного форума не существует.',
	'NO_FORUMS'					=> 'На этом сайте нет форумов.',
	'NO_GROUP'					=> 'Запрошенной группы не существует.',
	'NO_GROUP_MEMBERS'			=> 'В настоящее время в этой группе нет ни одного пользователя.',
	'NO_IPS_DEFINED'			=> 'Не определён IP-адрес или имя хоста',
	'NO_MEMBERS'				=> 'Не найдено ни одного пользователя по заданным критериям',
	'NO_MESSAGES'				=> 'Нет сообщений',
	'NO_MODE'					=> 'Не указан режим.',
	'NO_MODERATORS'				=> 'Модераторы отсутствуют.',
	'NO_NEW_MESSAGES'			=> 'Нет новых сообщений',
	'NO_NEW_POSTS'				=> 'Нет новых сообщений', // Больше не используется
	'NO_ONLINE_USERS'			=> 'нет зарегистрированных пользователей',
	'NO_POSTS'					=> 'Нет сообщений',
	'NO_POSTS_TIME_FRAME'		=> 'В теме нет сообщений за выбранный период времени.',
	'NO_FEED_ENABLED'			=> 'Каналы новостей недоступны на этой конференции.',
	'NO_FEED'					=> 'Запрашиваемый канал новостей недоступен.',
	'NO_STYLE_DATA'				=> 'Не удалось получить данные о стиле: идентификатор стиля - %s (user_style), идентификатор пользователя - %s (user_id)',
	'NO_STYLE_CFG'				=> 'Не удалось загрузить файл конфигурации для стиля: %s',
	'NO_SUBJECT'				=> 'Не указана тема',								// Used for posts having no subject defined but displayed within management pages.
	'NO_SUCH_SEARCH_MODULE'		=> 'Указанный поисковый механизм отсутствует.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'Метод аутентификации не поддерживается.',
	'NO_TOPIC'					=> 'Запрошенной темы не существует.',
	'NO_TOPIC_FORUM'			=> 'Данная тема или форум больше не существует.',
	'NO_TOPICS'					=> 'В этом форуме нет сообщений.',
	'NO_TOPICS_TIME_FRAME'		=> 'В форуме нет тем за выбранный период времени.',
	'NO_UNREAD_POSTS'			=> 'Нет непрочитанных сообщений',
	'NO_UPLOAD_FORM_FOUND'		=> 'Закачивание файла инициировано, но доступный для закачки файл не найден.',
	'NO_USER'					=> 'Запрашиваемого пользователя не существует.',
	'NO_USERS'					=> 'Запрашиваемых пользователей не существует.',
	'NO_USER_SPECIFIED'			=> 'Имя пользователя не определено.',

	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_ATTACHMENTS'		=> array(
		1	=> '%d вложение',
		2	=> '%d вложения',
		3	=> '%d вложений',
	),
	'NUM_POSTS_IN_QUEUE'	=> array(
		0		=> 'Нет сообщений в очереди',
		1		=> '%d сообщение в очереди',
		2		=> '%d сообщения в очереди',
		3		=> '%d сообщений в очереди',
	),

	'OCCUPATION'				=> 'Род занятий',
	'OFFLINE'					=> 'Не в сети',
	'ONLINE'					=> 'В сети',
	'ONLINE_BUDDIES'			=> 'Друзья',
	// "... :: x registered and y hidden"
	'ONLINE_USERS_TOTAL'		=> array(
		1	=> 'Всего <strong>%1$d</strong> посетитель :: %2$s и %3$s',
		2	=> 'Всего <strong>%1$d</strong> посетителя :: %2$s и %3$s',
		3	=> 'Всего <strong>%1$d</strong> посетителей :: %2$s и %3$s',
	),
	// "... :: x registered, y hidden and z guests"
	'ONLINE_USERS_TOTAL_GUESTS'	=> array(
		1	=> 'Всего <strong>%1$d</strong> посетитель :: %2$s, %3$s и %4$s',
		2	=> 'Всего <strong>%1$d</strong> посетителя :: %2$s, %3$s и %4$s',
		3	=> 'Всего <strong>%1$d</strong> посетителей :: %2$s, %3$s и %4$s',
	),
	'OPTIONS'					=> 'Настройки',

	'PAGE_NOT_FOUND'		=> 'Запрошенная страница не найдена.',
	'PAGE_OF'				=> 'Страница <strong>%1$d</strong> из <strong>%2$d</strong>',
	'PAGE_TITLE_NUMBER'		=> 'Страница %s',
	'PASSWORD'				=> 'Пароль',
 	'PIXEL'					=> 'пикс.',
	'PIXELS'				=> array(
		1	=> '%d пиксель',
		2	=> '%d пикселя',
		3	=> '%d пикселей',
	),
	'PLEASE_WAIT'			=> 'Пожалуйста, подождите.',
	'PM'					=> 'Личное сообщение',
	'PM_REPORTED'			=> 'Нажмите для просмотра жалобы',
	'POSTING_MESSAGE'		=> 'Размещение сообщения в форуме «%s»',
	'POSTING_PRIVATE_MESSAGE'	=> 'Создание личного сообщения',
	'POST'					=> 'Сообщение',
	'POST_ANNOUNCEMENT'		=> 'Объявление',
	'POST_STICKY'			=> 'Прилепленная',
	'POSTED'				=> 'Добавлено',
	'POSTED_IN_FORUM'		=> 'в',
	'POSTED_ON_DATE'		=> '',
	'POSTS'					=> 'Сообщения',
	'POSTS_UNAPPROVED'		=> 'сообщение, требующее одобрения:',
	'POSTS_UNAPPROVED_FORUM'=> 'По крайней мере одно сообщение в этом форуме ожидает одобрения.',
	'POST_BY_AUTHOR'		=> '',
	'POST_BY_FOE'			=> 'Автором этого сообщения является <strong>%1$s</strong>, находящийся в вашем чёрном списке.',
	'POST_DISPLAY'			=> 'Показать это сообщение',
	'POST_DAY'				=> '%.2f сообщений в день',
	'POST_DELETED_ACTION'	=> 'Удалённое сообщение:',
	'POST_DELETED'			=> 'Сообщение удалено.',
	'POST_DELETED_BY'		=> '<strong>%2$s</strong> удалил сообщение автора <strong>%1$s</strong> %3$s.',
	'POST_DELETED_BY_REASON'=> '<strong>%2$s</strong> удалил сообщение автора <strong>%1$s</strong> %3$s по следующей причине: %4$s',
	'POST_DETAILS'			=> 'Информация о сообщении',
	'POST_NEW_TOPIC'		=> 'Начать новую тему',
	'POST_PCT'				=> '%.2f%% всех сообщений',
	'POST_PCT_ACTIVE'		=> '%.2f%% сообщений пользователя',
	'POST_PCT_ACTIVE_OWN'	=> '%.2f%% ваших сообщений',
	'POST_REPLY'			=> 'Ответить',
	'POST_REPORTED'			=> 'Просмотреть жалобу',
	'POST_SUBJECT'			=> 'Заголовок сообщения',
	'POST_TIME'				=> 'Время размещения',
	'POST_TOPIC'			=> 'Новая тема',
	'POST_UNAPPROVED_ACTION'	=> 'Сообщение ожидает проверки:',
	'POST_UNAPPROVED'		=> 'Сообщение одобрено.',
	'POST_UNAPPROVED_EXPLAIN'	=> 'Данное сообщение не будет показано другим пользователям до его одобрения модератором.',
	'POWERED_BY'			=> 'Создано на основе %s',

	'QUOTE'					=> 'Цитата',

	'PREVIEW'				=> 'Предпросмотр',
	'PREVIOUS'				=> 'Пред.',		// Used in pagination
	'PREVIOUS_STEP'			=> 'Назад',
	'PRIVACY'				=> 'Соглашение о конфиденциальности',
	'PRIVACY_LINK'			=> 'Конфиденциальность',
	'PRIVATE_MESSAGE'		=> 'Личное сообщение',
	'PRIVATE_MESSAGES'		=> 'Личные сообщения',
	'PRIVATE_MESSAGING'		=> 'Личные сообщения',
	'PROFILE'				=> 'Личный раздел',

	'QUICK_LINKS'			=> 'Ссылки',

	'RANK'						=> 'Звание',
	'READING_FORUM'				=> 'Просмотр форума «%s»',
	'READING_GLOBAL_ANNOUNCE'	=> 'Чтение важного объявления',
	'READING_LINK'				=> 'Переход по ссылке форума «%s»',
	'READING_TOPIC'				=> 'Просмотр темы в форуме «%s»',
	'READ_PROFILE'				=> 'Профиль',
	'REASON'					=> 'Причина',
	'RECORD_ONLINE_USERS'		=> 'Больше всего посетителей (<strong>%1$s</strong>) здесь было %2$s',
	'REDIRECT'					=> 'Перенаправление',
	'REDIRECTS'					=> 'Переходов по ссылке',
	'REGISTER'					=> 'Регистрация',
	'REGISTERED_USERS'			=> 'Зарегистрированные пользователи:',
	// "... and 2 hidden users online"
	'REG_USERS_ONLINE'			=> array(
		1	=> '%1$d зарегистрированный пользователь и %2$s',
		2	=> '%1$d зарегистрированных пользователя и %2$s',
		3	=> '%1$d зарегистрированных пользователей и %2$s',
	),
	'REG_USERS_TOTAL'			=> array(
		1	=> '%d зарегистрированный',
		2	=> '%d зарегистрированных',
		3	=> '%d зарегистрированных',
	),
	'REMOVE'					=> 'Удалить',
	'REMOVE_INSTALL'			=> 'Пожалуйста, удалите, переместите или переименуйте папку install, прежде чем начнёте пользоваться конференцией. В противном случае будет доступен только администраторский раздел.',
	'REPLIES'					=> 'Ответы',
	'REPLY_WITH_QUOTE'			=> 'Ответить с цитатой',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'Размещение ответа на важное объявление',
	'REPLYING_MESSAGE'			=> 'Размещение ответа в форуме «%s»',
	'REPORT_BY'					=> 'Источник',
	'REPORT_POST'				=> 'Пожаловаться на это сообщение',
	'REPORTING_POST'			=> 'Размещение жалобы на сообщение',
	'RESEND_ACTIVATION'			=> 'Повторно выслать письмо для активации учётной записи',
	'RESET'						=> 'Вернуть',
	'RESTORE_PERMISSIONS'		=> 'Восстановить права доступа',
	'RETURN_INDEX'				=> '%sВернуться на главную страницу%s',
	'RETURN_FORUM'				=> '%sВернуться в форум%s',
	'RETURN_PAGE'				=> '%sВернуться на предыдущую страницу%s',
	'RETURN_TOPIC'				=> '%sВернуться в тему%s',
	'RETURN_TO'					=> 'Вернуться в «%s»',
	'RETURN_TO_INDEX'			=> 'Вернуться к списку форумов',

	'ROUTE_NOT_FOUND'				=> 'Запрошенный путь «%s» не найден.',
	'ROUTE_INVALID_MISSING_PARAMS'	=> 'Неверные или отсутствующие параметры пути «%s».',

	'FEED'						=> 'Канал',
	'FEED_NEWS'					=> 'Новости',
 	'FEED_TOPICS_ACTIVE'		=> 'Активные темы',
 	'FEED_TOPICS_NEW'			=> 'Новые темы',
	'RULES_ATTACH_CAN'			=> 'Вы <strong>можете</strong> добавлять вложения',
	'RULES_ATTACH_CANNOT'		=> 'Вы <strong>не можете</strong> добавлять вложения',
	'RULES_DELETE_CAN'			=> 'Вы <strong>можете</strong> удалять свои сообщения',
	'RULES_DELETE_CANNOT'		=> 'Вы <strong>не можете</strong> удалять свои сообщения',
	'RULES_DOWNLOAD_CAN'		=> 'Вы <strong>можете</strong> скачивать вложения',
	'RULES_DOWNLOAD_CANNOT'		=> 'Вы <strong>не можете</strong> скачивать вложения',
	'RULES_EDIT_CAN'			=> 'Вы <strong>можете</strong> редактировать свои сообщения',
	'RULES_EDIT_CANNOT'			=> 'Вы <strong>не можете</strong> редактировать свои сообщения',
	'RULES_LOCK_CAN'			=> 'Вы <strong>можете</strong> закрывать свои темы',
	'RULES_LOCK_CANNOT'			=> 'Вы <strong>не можете</strong> закрывать свои темы',
	'RULES_POST_CAN'			=> 'Вы <strong>можете</strong> начинать темы',
	'RULES_POST_CANNOT'			=> 'Вы <strong>не можете</strong> начинать темы',
	'RULES_REPLY_CAN'			=> 'Вы <strong>можете</strong> отвечать на сообщения',
	'RULES_REPLY_CANNOT'		=> 'Вы <strong>не можете</strong> отвечать на сообщения',
	'RULES_VOTE_CAN'			=> 'Вы <strong>можете</strong> голосовать в опросах',
	'RULES_VOTE_CANNOT'			=> 'Вы <strong>не можете</strong> голосовать в опросах',

	'SEARCH'					=> 'Поиск',
	'SEARCH_MINI'				=> 'Поиск…',
	'SEARCH_ADV'				=> 'Расширенный поиск',
	'SEARCH_ADV_EXPLAIN'		=> 'Параметры расширенного поиска',
	'SEARCH_KEYWORDS'			=> 'Ключевые слова',
	'SEARCHING_FORUMS'			=> 'Поиск в форумах',
	'SEARCH_ACTIVE_TOPICS'		=> 'Активные темы',
	'SEARCH_FOR'				=> 'Найти',
	'SEARCH_FORUM'				=> 'Поиск в форуме…',
	'SEARCH_NEW'				=> 'Новые сообщения',
	'SEARCH_POSTS_BY'			=> 'Искать сообщения',
	'SEARCH_SELF'				=> 'Ваши сообщения',
	'SEARCH_TOPIC'				=> 'Поиск в теме…',
	'SEARCH_UNANSWERED'			=> 'Темы без ответов',
	'SEARCH_UNREAD'				=> 'Непрочитанные сообщения',
	'SEARCH_USER_POSTS'			=> 'Найти сообщения пользователя',
	'SECONDS'					=> 'секунд',
	'SEE_ALL'					=> 'Показать все',
	'SELECT'					=> 'Выбор',
	'SELECT_ALL_CODE'			=> 'Выделить всё',
	'SELECT_DESTINATION_FORUM'	=> 'Выберите форум назначения',
	'SELECT_FORUM'				=> 'Выберите форум',
	'SEND_EMAIL'				=> 'Отправить email',				// Used for submit buttons
	'SEND_EMAIL_USER'			=> 'Отправить email пользователю %s',
	'SEND_PRIVATE_MESSAGE'		=> 'Отправить личное сообщение',
	'SETTINGS'					=> 'Настройки',
	'SIGNATURE'					=> 'Подпись',
	'SKIP'						=> 'Пропустить',
	'SKYPE'						=> 'Skype',
	'SMTP_NO_AUTH_SUPPORT'		=> 'SMTP-сервер не поддерживает аутентификацию.',
	'SORRY_AUTH_READ'			=> 'Вы не авторизованы для чтения данного форума.',
	'SORRY_AUTH_READ_TOPIC'		=> 'Вы не авторизованы для чтения данной темы.',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'Вы не авторизованы для скачивания этого вложения.',
	'SORT_BY'					=> 'Поле сортировки',
	'SORT_DIRECTION'			=> 'Порядок',
	'SORT_JOINED'				=> 'Дата регистрации',
	'SORT_LOCATION'				=> 'Откуда',
	'SORT_OPTIONS'				=> 'Настройки отображения и сортировки',
	'SORT_RANK'					=> 'Звание',
	'SORT_POSTS'				=> 'Сообщения',
	'SORT_TOPIC_TITLE'			=> 'Название темы',
	'SORT_USERNAME'				=> 'Имя пользователя',
	'SPLIT_TOPIC'				=> 'Разделить тему',
	'SQL_ERROR_OCCURRED'		=> 'Произошла ошибка SQL при выборке на этой странице. Пожалуйста, сообщите %sадминистратору%s, если ошибка будет повторяться.',
	'STATISTICS'				=> 'Статистика',
	'START_WATCHING_FORUM'		=> 'Подписаться на форум',
	'START_WATCHING_TOPIC'		=> 'Подписаться на тему',
	'STOP_WATCHING_FORUM'		=> 'Отписаться от форума',
	'STOP_WATCHING_TOPIC'		=> 'Отписаться от темы',
	'STRING_LIST_MULTI'			=> '%1$s и %2$s',
	'STRING_LIST_SIMPLE'		=> '%1$s и %2$s',
	'SUBFORUM'					=> 'Подфорум',
	'SUBFORUMS'					=> 'Подфорумы',
	'SUBJECT'					=> 'Заголовок',
	'SUBMIT'					=> 'Отправить',

	'TB'				=> 'ТБ',
	'TERMS_LINK'		=> 'Правила',
	'TERMS_USE'			=> 'Общие правила',
	'TEST_CONNECTION'	=> 'Проверить подключение',
	'THE_TEAM'			=> 'Наша команда',
	'TIB'				=> 'ТБ',
	'TIME'				=> 'Время',

	'TIMEOUT_PROCESSING_REQ'			=> 'Время выполнения запроса истекло.',

	'TOO_LARGE'					=> 'Введённое значение слишком велико.',
	'TOO_LARGE_MAX_RECIPIENTS'	=> 'Введённое значение настройки <strong>Максимальное разрешённое число получателей ЛС</strong> слишком велико.',

	'TOO_LONG'			=> 'Введённое значение слишком длинное.',

	'TOO_LONG_CONFIRM_CODE'			=> 'Введённый код подтверждения слишком длинный.',
	'TOO_LONG_DATEFORMAT'			=> 'Введённый формат даты слишком длинный.',
	'TOO_LONG_JABBER'				=> 'Имя учётной записи Jabber слишком длинное.',
	'TOO_LONG_NEW_PASSWORD'			=> 'Введённый пароль слишком длинный.',
	'TOO_LONG_PASSWORD_CONFIRM'		=> 'Подтверждение пароля слишком длинное.',
	'TOO_LONG_USER_PASSWORD'		=> 'Пароль слишком длинный.',
	'TOO_LONG_USERNAME'				=> 'Имя пользователя слишком длинное.',
	'TOO_LONG_EMAIL'				=> 'Адрес email слишком длинный.',

	'TOO_MANY_VOTE_OPTIONS'			=> 'Вы выбрали слишком много вариантов ответа при голосовании.',

	'TOO_SHORT'						=> 'Введённое значение слишком короткое.',

	'TOO_SHORT_CONFIRM_CODE'		=> 'Введённый код подтверждения слишком короткий.',
	'TOO_SHORT_DATEFORMAT'			=> 'Введённый формат даты слишком короткий.',
	'TOO_SHORT_JABBER'				=> 'Имя учётной записи Jabber слишком короткое.',
	'TOO_SHORT_NEW_PASSWORD'		=> 'Введённый пароль слишком короткий.',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'Подтверждение пароля слишком короткое.',
	'TOO_SHORT_USER_PASSWORD'		=> 'Пароль слишком короткий.',
	'TOO_SHORT_USERNAME'			=> 'Имя пользователя слишком короткое.',
	'TOO_SHORT_EMAIL'				=> 'Адрес email слишком короткий.',
	'TOO_SHORT_EMAIL_CONFIRM'		=> 'Подтверждение адреса email слишком короткое.',
	'TOO_SMALL'						=> 'Введённое значение слишком мало.',
	'TOO_SMALL_MAX_RECIPIENTS'		=> 'Введённое значение настройки <strong>Максимальное разрешённое число получателей ЛС</strong> слишком мало.',

	'TOPIC'				=> 'Тема',
	'TOPICS'			=> 'Темы',
	'TOPICS_UNAPPROVED'	=> 'По крайне мере одна тема в этом форуме не была одобрена.',
	'TOPIC_ICON'		=> 'Значок',
	'TOPIC_LOCKED'		=> 'Эта тема закрыта, вы не можете редактировать и оставлять сообщения в ней.',
	'TOPIC_LOCKED_SHORT'=> 'Закрыто',
	'TOPIC_MOVED'		=> 'Перенесённая',
	'TOPIC_REVIEW'		=> 'Обзор темы',
	'TOPIC_TITLE'		=> 'Название темы',
	'TOPIC_UNAPPROVED'	=> 'Данная тема не была одобрена.',
	'TOPIC_UNAPPROVED_FORUM'	=> array(
		1	=> 'Имеется тема, ожидающая одобрения',
		2	=> 'Имеются темы, ожидающие одобрения',
		3	=> 'Имеются темы, ожидающие одобрения',
	),
	'TOPIC_DELETED'		=> 'Данная тема была удалена.',
	'TOTAL_ATTACHMENTS'	=> 'Вложения',
	'TOTAL_LOGS'		=> array(
		1	=> '%d лог',
		2	=> '%d лога',
		3	=> '%d логов',
	),
	'TOTAL_PMS'			=> array(
		1	=> 'Всего %d личное сообщение',
		2	=> 'Всего %d личных сообщения',
		3	=> 'Всего %d личных сообщений',
	),
	'TOPIC_POLL'		=> 'Данная тема содержит опрос.',
	'TOTAL_POSTS'		=> 'Всего сообщений',
	'TOTAL_POSTS_COUNT'	=> array(
		1	=> 'Всего сообщений: <strong>%d</strong>',
		2	=> 'Всего сообщений: <strong>%d</strong>',
		3	=> 'Всего сообщений: <strong>%d</strong>',
	),
	'TOPIC_REPORTED'	=> 'На данную тему поступили жалобы',
	'TOTAL_TOPICS'		=> array(
		1	=> 'Всего тем: <strong>%d</strong>',
		2	=> 'Всего тем: <strong>%d</strong>',
		3	=> 'Всего тем: <strong>%d</strong>',
	),
	'TOTAL_USERS'		=> array(
		1	=> 'Всего пользователей: <strong>%d</strong>',
		2	=> 'Всего пользователей: <strong>%d</strong>',
		3	=> 'Всего пользователей: <strong>%d</strong>',
	),
	'TRACKED_PHP_ERROR'	=> 'Отслеженные ошибки PHP: %s',
	'TWITTER'			=> 'Twitter',

	'UNABLE_GET_IMAGE_SIZE'	=> 'Не удалось определить размеры изображения. Удостоверьтесь, что ссылка на изображение правильная.',
	'UNABLE_TO_DELIVER_FILE'=> 'Не удалось доставить файл.',
	'UNKNOWN_BROWSER'		=> 'Неизвестный браузер',
	'UNMARK_ALL'			=> 'Снять выделение',
	'UNREAD_MESSAGES'		=> 'Непрочитанные сообщения',
	'UNREAD_POST'			=> 'Непрочитанное сообщение',
	'UNREAD_POSTS'			=> 'Непрочитанные сообщения',
	'UNWATCH_FORUM_CONFIRM'		=> 'Вы действительно хотите отписаться от данного форума?',
	'UNWATCH_FORUM_DETAILED'	=> 'Вы действительно хотите отписаться от форума «%s»?',
	'UNWATCH_TOPIC_CONFIRM'		=> 'Вы действительно хотите отписаться от данной темы?',
	'UNWATCH_TOPIC_DETAILED'	=> 'Вы действительно хотите отписаться от темы «%s»?',
	'UNWATCHED_FORUMS'			=> 'Вы больше не подписаны на выбранные форумы.',
	'UNWATCHED_TOPICS'			=> 'Вы больше не подписаны на выбранные темы.',
	'UNWATCHED_FORUMS_TOPICS'	=> 'Вы больше не подписаны на выбранное.',
	'UPDATE'				=> 'Обновить',
	'UPLOAD_IN_PROGRESS'	=> 'Производится закачка.',
	'URL_REDIRECT'			=> 'Если ваш браузер не поддерживает автоматическое перенаправление, %sнажмите эту ссылку для перехода%s.',
	'USERGROUPS'			=> 'Группы',
	'USERNAME'				=> 'Имя пользователя',
	'USERNAMES'				=> 'Имена пользователей',
	'USER_AVATAR'			=> 'Аватара пользователя',
	'USER_CANNOT_READ'		=> 'Вы не можете читать сообщения в этом форуме.',
	'USER_POSTS'			=> array(
		1	=> '%d сообщение',
		2	=> '%d сообщения',
		3	=> '%d сообщений',
	),
	'USERS'					=> 'Пользователи',
	'USE_PERMISSIONS'		=> 'Проверить права пользователя',

	'USER_NEW_PERMISSION_DISALLOWED'	=> 'Вам не разрешено использовать данную возможность. Возможно, вы недавно зарегистрировались на конференции или вам необходимо проявить больше активности в обсуждениях, чтобы получить такое право.',

	'VARIANT_DATE_SEPARATOR'	=> ' / ',	// Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'					=> 'Просмотров:',
	'VIEWED_COUNTS'		=> array(
		0	=> 'Нет просмотров',
		1	=> '%d просмотр',
		2	=> '%d просмотра',
		3	=> '%d просмотров',
	),
	'VIEWING_CONTACT_ADMIN'		=> 'Просмотр страницы связи с администрацией',
	'VIEWING_FAQ'				=> 'Просмотр FAQ',
	'VIEWING_MEMBERS'			=> 'Просмотр списка пользователей',
	'VIEWING_ONLINE'			=> 'Просмотр страницы «Кто сейчас на конференции»',
	'VIEWING_MCP'				=> 'Просмотр модераторского раздела',
	'VIEWING_MEMBER_PROFILE'	=> 'Просмотр профиля пользователя',
	'VIEWING_PRIVATE_MESSAGES'	=> 'Просмотр личных сообщений',
	'VIEWING_REGISTER'			=> 'Регистрация учётной записи',
	'VIEWING_UCP'				=> 'Просмотр личного раздела',
	'VIEWS'						=> 'Просмотры',
	'VIEW_BOOKMARKS'			=> 'Просмотреть закладки',
	'VIEW_FORUM_LOGS'			=> 'Просмотреть логи',
	'VIEW_LATEST_POST'			=> 'Перейти к последнему сообщению',
	'VIEW_NEWEST_POST'			=> 'Перейти к первому непрочитанному сообщению',
	'VIEW_NOTES'				=> 'Заметки о пользователе',
	'VIEW_ONLINE_TIMES'			=> array(
		1	=> 'основано на активности пользователей за последнюю %d минуту',
		2	=> 'основано на активности пользователей за последние %d минуты',
		3	=> 'основано на активности пользователей за последние %d минут',
	),
	'VIEW_TOPIC'				=> 'Просмотр темы',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'Объявление: ',
	'VIEW_TOPIC_GLOBAL'			=> 'Важная: ',
	'VIEW_TOPIC_LOCKED'			=> 'Закрыто: ',
	'VIEW_TOPIC_LOGS'			=> 'Просмотр логов',
	'VIEW_TOPIC_MOVED'			=> 'Перемещена: ',
	'VIEW_TOPIC_POLL'			=> 'Опрос: ',
	'VIEW_TOPIC_STICKY'			=> 'Прилепленная: ',
	'VISIT_WEBSITE'				=> 'Перейти на сайт',

	'WARNINGS'			=> 'Предупреждения',
	'WARN_USER'			=> 'Вынести предупреждение',
	'WATCH_FORUM_CONFIRM'	=> 'Вы действительно хотите подписаться на данный форум?',
	'WATCH_FORUM_DETAILED'	=> 'Вы действительно хотите подписаться на форум «%s»?',
	'WATCH_TOPIC_CONFIRM'	=> 'Вы действительно хотите подписаться на данную тему?',
	'WATCH_TOPIC_DETAILED'	=> 'Вы действительно хотите подписаться на тему «%s»?',
	'WELCOME_SUBJECT'	=> 'Добро пожаловать на конференцию «%s»',
	'WEBSITE'			=> 'Сайт',
	'WHOIS'				=> 'Информация об IP-адресе',
	'WHO_IS_ONLINE'		=> 'Кто сейчас на конференции',
	'WRONG_PASSWORD'	=> 'Вы ввели неверный пароль.',

	'WRONG_DATA_COLOUR'			=> 'Введено неверное значение цвета.',
	'WRONG_DATA_JABBER'			=> 'Введённое имя не является правильным именем Jabber.',
	'WRONG_DATA_LANG'			=> 'Указан неправильный язык.',
	'WRONG_DATA_POST_SD'		=> 'Выбран неверный метод сортировки сообщений.',
	'WRONG_DATA_POST_SK'		=> 'Выбрано неверное поле сортировки сообщений.',
	'WRONG_DATA_TOPIC_SD'		=> 'Выбран неверный метод сортировки тем.',
	'WRONG_DATA_TOPIC_SK'		=> 'Выбрано неверное поле сортировки тем.',
	'WROTE'						=> 'писал(а)',

	'YAHOO'				=> 'Yahoo Messenger',
	'YOUTUBE'			=> 'YouTube',
	'YEAR'				=> 'Год',
	'YEAR_MONTH_DAY'	=> '(ГГГГ-ММ-ДД)',
	'YES'				=> 'Да',
	'YOU_LAST_VISIT'	=> 'Предыдущее посещение: %s',

	'datetime'			=> array(
		'TODAY'		=> 'Сегодня',
		'TOMORROW'	=> 'Завтра',
		'YESTERDAY'	=> 'Вчера',
		'AGO'		=> array(
			0		=> 'менее минуты назад',
			1		=> '%d минуту назад',
			2		=> '%d минуты назад',
			3		=> '%d минут назад',
		),

		'Sunday'	=> 'Воскресенье',
		'Monday'	=> 'Понедельник',
		'Tuesday'	=> 'Вторник',
		'Wednesday'	=> 'Среда',
		'Thursday'	=> 'Четверг',
		'Friday'	=> 'Пятница',
		'Saturday'	=> 'Суббота',

		'Sun'		=> 'Вс',
		'Mon'		=> 'Пн',
		'Tue'		=> 'Вт',
		'Wed'		=> 'Ср',
		'Thu'		=> 'Чт',
		'Fri'		=> 'Пт',
		'Sat'		=> 'Сб',

		'January'	=> 'Январь',
		'February'	=> 'Февраль',
		'March'		=> 'Март',
		'April'		=> 'Апрель',
		'May'		=> 'Май',
		'June'		=> 'Июнь',
		'July'		=> 'Июль',
		'August'	=> 'Август',
		'September'	=> 'Сентябрь',
		'October'	=> 'Октябрь',
		'November'	=> 'Ноябрь',
		'December'	=> 'Декабрь',

		'Jan'		=> 'янв',
		'Feb'		=> 'фев',
		'Mar'		=> 'мар',
		'Apr'		=> 'апр',
		'May_short'	=> 'май',	// Short representation of "May". May_short used because in English the short and long date are the same for May.
		'Jun'		=> 'июн',
		'Jul'		=> 'июл',
		'Aug'		=> 'авг',
		'Sep'		=> 'сен',
		'Oct'		=> 'окт',
		'Nov'		=> 'ноя',
		'Dec'		=> 'дек',
	),

	// Timezones can be translated. We use this for the Etc/GMT timezones here,
	// because they are named invers to their offset.
	'timezones'		=> array(
		'UTC'					=> 'UTC',
		'UTC_OFFSET'			=> 'UTC%1$s',
		'UTC_OFFSET_CURRENT'	=> 'UTC%1$s - %2$s',

		'Etc/GMT-12'	=> 'UTC+12',
		'Etc/GMT-11'	=> 'UTC+11',
		'Etc/GMT-10'	=> 'UTC+10',
		'Etc/GMT-9'		=> 'UTC+9',
		'Etc/GMT-8'		=> 'UTC+8',
		'Etc/GMT-7'		=> 'UTC+7',
		'Etc/GMT-6'		=> 'UTC+6',
		'Etc/GMT-5'		=> 'UTC+5',
		'Etc/GMT-4'		=> 'UTC+4',
		'Etc/GMT-3'		=> 'UTC+3',
		'Etc/GMT-2'		=> 'UTC+2',
		'Etc/GMT-1'		=> 'UTC+1',
		'Etc/GMT+1'		=> 'UTC-1',
		'Etc/GMT+2'		=> 'UTC-2',
		'Etc/GMT+3'		=> 'UTC-3',
		'Etc/GMT+4'		=> 'UTC-4',
		'Etc/GMT+5'		=> 'UTC-5',
		'Etc/GMT+6'		=> 'UTC-6',
		'Etc/GMT+7'		=> 'UTC-7',
		'Etc/GMT+8'		=> 'UTC-8',
		'Etc/GMT+9'		=> 'UTC-9',
		'Etc/GMT+10'	=> 'UTC-10',
		'Etc/GMT+11'	=> 'UTC-11',
		'Etc/GMT+12'	=> 'UTC-12',

		'Africa/Abidjan'	=> 'Африка/Абиджан',
 		'Africa/Accra'		=> 'Африка/Аккра',
 		'Africa/Addis_Ababa'	=> 'Африка/Аддис-Абеба',
 		'Africa/Algiers'	=> 'Африка/Алжир',
 		'Africa/Asmara'		=> 'Африка/Асмара',
 		'Africa/Bamako'		=> 'Африка/Бамако',
 		'Africa/Bangui'		=> 'Африка/Банги',
 		'Africa/Banjul'		=> 'Африка/Банджул',
 		'Africa/Bissau'		=> 'Африка/Бисау',
 		'Africa/Blantyre'	=> 'Африка/Блантайр',
 		'Africa/Brazzaville'	=> 'Африка/Браззавиль',
 		'Africa/Bujumbura'	=> 'Африка/Бужумбура',
 		'Africa/Cairo'		=> 'Африка/Каир',
 		'Africa/Casablanca'	=> 'Африка/Касабланка',
 		'Africa/Ceuta'		=> 'Африка/Сеута',
 		'Africa/Conakry'	=> 'Африка/Конакри',
 		'Africa/Dakar'		=> 'Африка/Дакар',
 		'Africa/Dar_es_Salaam'	=> 'Африка/Дар-эс-Салам',
 		'Africa/Djibouti'	=> 'Африка/Джибути',
 		'Africa/Douala'		=> 'Африка/Дуала',
 		'Africa/El_Aaiun'	=> 'Африка/Эль-Аюн',
 		'Africa/Freetown'	=> 'Африка/Фритаун',
 		'Africa/Gaborone'	=> 'Африка/Габороне',
 		'Africa/Harare'		=> 'Африка/Хараре',
 		'Africa/Johannesburg'	=> 'Африка/Йоханнесбург',
 		'Africa/Juba'		=> 'Африка/Джуба',
 		'Africa/Kampala'	=> 'Африка/Кампала',
 		'Africa/Khartoum'	=> 'Африка/Хартум',
 		'Africa/Kigali'		=> 'Африка/Кигали',
 		'Africa/Kinshasa'	=> 'Африка/Киншаса',
 		'Africa/Lagos'		=> 'Африка/Лагос',
 		'Africa/Libreville'	=> 'Африка/Либревиль',
 		'Africa/Lome'		=> 'Африка/Ломе',
 		'Africa/Luanda'		=> 'Африка/Луанда',
 		'Africa/Lubumbashi'	=> 'Африка/Лубумбаши',
 		'Africa/Lusaka'		=> 'Африка/Лусака',
 		'Africa/Malabo'		=> 'Африка/Малабо',
 		'Africa/Maputo'		=> 'Африка/Мапуту',
 		'Africa/Maseru'		=> 'Африка/Масеру',
 		'Africa/Mbabane'	=> 'Африка/Мбабане',
 		'Africa/Mogadishu'	=> 'Африка/Могадишо',
 		'Africa/Monrovia'	=> 'Африка/Монровия',
 		'Africa/Nairobi'	=> 'Африка/Найроби',
 		'Africa/Ndjamena'	=> 'Африка/Нджамена',
 		'Africa/Niamey'		=> 'Африка/Ниамей',
 		'Africa/Nouakchott'	=> 'Африка/Нуакшот',
 		'Africa/Ouagadougou'	=> 'Африка/Уагадугу',
 		'Africa/Porto-Novo'	=> 'Африка/Порто-Ново',
 		'Africa/Sao_Tome'	=> 'Африка/Сан-Томе',
 		'Africa/Tripoli'	=> 'Африка/Триполи',
 		'Africa/Tunis'		=> 'Африка/Тунис',
 		'Africa/Windhoek'	=> 'Африка/Виндхук',
 
 		'America/Adak'		=> 'Америка/Адак',
 		'America/Anchorage'	=> 'Америка/Анкоридж',
 		'America/Anguilla'	=> 'Америка/Ангилья',
 		'America/Antigua'	=> 'Америка/Антигуа',
 		'America/Araguaina'	=> 'Америка/Арагуаина',

 		'America/Argentina/Buenos_Aires'	=> 'Америка/Аргентина/Буэнос-Айрес',
 		'America/Argentina/Catamarca'	=> 'Америка/Аргентина/Катамарка',
 		'America/Argentina/Cordoba'		=> 'Америка/Аргентина/Кордова',
 		'America/Argentina/Jujuy'		=> 'Америка/Аргентина/Жужуй',
 		'America/Argentina/La_Rioja'	=> 'Америка/Аргентина/Ла-Риоха',
 		'America/Argentina/Mendoza'		=> 'Америка/Аргентина/Мендоса',
 		'America/Argentina/Rio_Gallegos'	=> 'Америка/Аргентина/Рио-Гальегос',
 		'America/Argentina/Salta'		=> 'Америка/Аргентина/Сальта',
 		'America/Argentina/San_Juan'	=> 'Америка/Аргентина/Сан-Хуан',
 		'America/Argentina/San_Luis'	=> 'Америка/Аргентина/Сан-Луис',
 		'America/Argentina/Tucuman'		=> 'Америка/Аргентина/Тукуман',
 		'America/Argentina/Ushuaia'		=> 'Америка/Аргентина/Ушуая',
 
 		'America/Aruba'			=> 'Америка/Аруба',
 		'America/Asuncion'		=> 'Америка/Асунсьон',
 		'America/Atikokan'		=> 'Америка/Атикокан',
 		'America/Bahia'			=> 'Америка/Баия',
 		'America/Bahia_Banderas'	=> 'Америка/Баия-де-Бандерас',
 		'America/Barbados'		=> 'Америка/Барбадос',
 		'America/Belem'			=> 'Америка/Белен',
 		'America/Belize'		=> 'Америка/Белиз',
 		'America/Blanc-Sablon'	=> 'Америка/Блан-Саблон',
 		'America/Boa_Vista'		=> 'Америка/Боа-Виста',
 		'America/Bogota'		=> 'Америка/Богота',
 		'America/Boise'			=> 'Америка/Бойсе',
 		'America/Cambridge_Bay'	=> 'Америка/Кеймбридж-Бей',
 		'America/Campo_Grande'	=> 'Америка/Кампу-Гранди',
 		'America/Cancun'		=> 'Америка/Канкун',
 		'America/Caracas'		=> 'Америка/Каракас',
 		'America/Cayenne'		=> 'Америка/Кайенна',
 		'America/Cayman'		=> 'Америка/Кайман',
 		'America/Chicago'		=> 'Америка/Чикаго',
 		'America/Chihuahua'		=> 'Америка/Чиуауа',
 		'America/Costa_Rica'	=> 'Америка/Коста-Рика',
 		'America/Creston'		=> 'Америка/Крестон',
 		'America/Cuiaba'		=> 'Америка/Куяба',
 		'America/Curacao'		=> 'Америка/Кюрасао',
 		'America/Danmarkshavn'	=> 'Америка/Данмарксхавн',
 		'America/Dawson'		=> 'Америка/Доусон',
 		'America/Dawson_Creek'	=> 'Америка/Досон-Крик',
 		'America/Denver'		=> 'Америка/Денвер',
 		'America/Detroit'		=> 'Америка/Детройт',
 		'America/Dominica'		=> 'Америка/Доминика',
 		'America/Edmonton'		=> 'Америка/Эдмонтон',
 		'America/Eirunepe'		=> 'Америка/Эйрунепе',
 		'America/El_Salvador'	=> 'Америка/Сальвадор',
 		'America/Fortaleza'		=> 'Америка/Форталеза',
 		'America/Glace_Bay'		=> 'Америка/Глейс-Бей',
 		'America/Godthab'		=> 'Америка/Готхоб',
 		'America/Goose_Bay'		=> 'Америка/Гус-Бей',
 		'America/Grand_Turk'	=> 'Америка/Гранд-Терк',
 		'America/Grenada'		=> 'Америка/Гренада',
 		'America/Guadeloupe'	=> 'Америка/Гваделупа',
 		'America/Guatemala'		=> 'Америка/Гватемала',
 		'America/Guayaquil'		=> 'Америка/Гуаякиль',
 		'America/Guyana'		=> 'Америка/Гайана',
 		'America/Halifax'		=> 'Америка/Галифакс',
 		'America/Havana'		=> 'Америка/Гавана',
 		'America/Hermosillo'		=> 'Америка/Эрмосильо',
 		'America/Indiana/Indianapolis'	=> 'Америка/Индиана/Индианаполис',
 		'America/Indiana/Knox'		=> 'Америка/Индиана/Нокс',
 		'America/Indiana/Marengo'	=> 'Америка/Индиана/Маренго',
 		'America/Indiana/Petersburg'	=> 'Америка/Индиана/Петерсберг',
 		'America/Indiana/Tell_City'	=> 'Америка/Индиана/Телл Сити',
 		'America/Indiana/Vevay'		=> 'Америка/Индиана/Вевей',
 		'America/Indiana/Vincennes'	=> 'Америка/Индиана/Винсенс',
 		'America/Indiana/Winamac'	=> 'Америка/Индиана/Уинамак',
 		'America/Inuvik'		=> 'Америка/Инувик',
 		'America/Iqaluit'		=> 'Америка/Икалуит',
 		'America/Jamaica'		=> 'Америка/Ямайка',
 		'America/Juneau'		=> 'Америка/Джуно',
 		'America/Kentucky/Louisville'	=> 'Америка/Кентукки/Луисвилл',
 		'America/Kentucky/Monticello'	=> 'Америка/Кентукки/Монтиселло',
 		'America/Kralendijk'	=> 'Америка/Кралендейк',
 		'America/La_Paz'		=> 'Америка/Ла-Пас',
 		'America/Lima'			=> 'Америка/Лима',
 		'America/Los_Angeles'	=> 'Америка/Лос-Анджелес',
 		'America/Lower_Princes'	=> 'Америка/Лоуэр-Принсес',
 		'America/Maceio'		=> 'Америка/Масейо',
 		'America/Managua'		=> 'Америка/Манагуа',
 		'America/Manaus'		=> 'Америка/Манаус',
 		'America/Marigot'		=> 'Америка/Мариго',
 		'America/Martinique'	=> 'Америка/Мартиника',
 		'America/Matamoros'		=> 'Америка/Матаморос',
 		'America/Mazatlan'		=> 'Америка/Масатлан',
 		'America/Menominee'		=> 'Америка/Меномини',
 		'America/Merida'		=> 'Америка/Мерида',
 		'America/Metlakatla'	=> 'Америка/Метлакатла',
 		'America/Mexico_City'	=> 'Америка/Мехико',
 		'America/Miquelon'		=> 'Америка/Микелон',
 		'America/Moncton'		=> 'Америка/Монктон',
 		'America/Monterrey'		=> 'Америка/Монтеррей',
 		'America/Montevideo'	=> 'Америка/Монтевидео',
 		'America/Montreal'		=> 'Америка/Монреаль',
 		'America/Montserrat'	=> 'Америка/Монтсеррат',
 		'America/Nassau'		=> 'Америка/Нассау',
 		'America/New_York'		=> 'Америка/Нью-Йорк',
 		'America/Nipigon'		=> 'Америка/Нипигон',
 		'America/Nome'			=> 'Америка/Ном',
 		'America/Noronha'		=> 'Америка/Норонья',
 		'America/North_Dakota/Beulah'		=> 'Америка/Северная Дакота/Бойла',
 		'America/North_Dakota/Center'		=> 'Америка/Северная Дакота/Центр',
 		'America/North_Dakota/New_Salem'	=> 'Америка/Северная Дакота/Новый Салем',
 		'America/Ojinaga'		=> 'Америка/Охинага',
 		'America/Panama'		=> 'Америка/Панама',
 		'America/Pangnirtung'	=> 'Америка/Пангниртанг',
 		'America/Paramaribo'	=> 'Америка/Парамарибо',
 		'America/Phoenix'		=> 'Америка/Финикс',
 		'America/Port-au-Prince'	=> 'Америка/Порт-о-Пренс',
 		'America/Port_of_Spain'	=> 'Америка/Порт-оф-Спейн',
 		'America/Porto_Velho'	=> 'Америка/Порту-Велью',
 		'America/Puerto_Rico'	=> 'Америка/Пуэрто-Рико',
 		'America/Rainy_River'	=> 'Америка/Рейни-Ривер',
 		'America/Rankin_Inlet'	=> 'Америка/Залив Ранкин',
 		'America/Recife'		=> 'Америка/Ресифи',
 		'America/Regina'		=> 'Америка/Риджайна',
 		'America/Resolute'		=> 'Америка/Резольют',
 		'America/Rio_Branco'	=> 'Америка/Риу-Бранку',
 		'America/Santa_Isabel'	=> 'Америка/Санта-Исабель',
 		'America/Santarem'		=> 'Америка/Сантарен',
 		'America/Santiago'		=> 'Америка/Сантьяго',
 		'America/Santo_Domingo'	=> 'Америка/Санто-Доминго',
 		'America/Sao_Paulo'		=> 'Америка/Сан-Паулу',
 		'America/Scoresbysund'	=> 'Америка/Скорсбисунн',
 		'America/Shiprock'		=> 'Америка/Шипрок',
 		'America/Sitka'			=> 'Америка/Ситка',
 		'America/St_Barthelemy'	=> 'Америка/Сент-Бартелеми',
 		'America/St_Johns'		=> 'Америка/Сент-Джонс',
 		'America/St_Kitts'		=> 'Америка/Сент-Китс',
 		'America/St_Lucia'		=> 'Америка/Сент-Люсия',
 		'America/St_Thomas'		=> 'Америка/Сент-Томас',
 		'America/St_Vincent'	=> 'Америка/Сент-Винсент',
 		'America/Swift_Current'	=> 'Америка/Суифт-Каррент',
 		'America/Tegucigalpa'	=> 'Америка/Тегусигальпа',
 		'America/Thule'			=> 'Америка/Туле',
 		'America/Thunder_Bay'	=> 'Америка/Тандер-Бей',
 		'America/Tijuana'		=> 'Америка/Тихуана',
 		'America/Toronto'		=> 'Америка/Торонто',
 		'America/Tortola'		=> 'Америка/Тортола',
 		'America/Vancouver'		=> 'Америка/Ванкувер',
 		'America/Whitehorse'	=> 'Америка/Уайтхорс',
 		'America/Winnipeg'		=> 'Америка/Виннипег',
 		'America/Yakutat'		=> 'Америка/Якутат',
 		'America/Yellowknife'	=> 'Америка/Йеллоунайф',
 
 		'Antarctica/Casey'		=> 'Антарктика/Кейси',
 		'Antarctica/Davis'		=> 'Антарктика/Дейвис',
 		'Antarctica/DumontDUrville'	=> 'Антарктика/Дюмон-д’Юрвиль',
 		'Antarctica/Macquarie'	=> 'Антарктика/Маккуари',
 		'Antarctica/Mawson'		=> 'Антарктика/Моусон',
 		'Antarctica/McMurdo'	=> 'Антарктика/Мак-Мердо',
 		'Antarctica/Palmer'		=> 'Антарктика/Палмер',
 		'Antarctica/Rothera'	=> 'Антарктика/Ротера',
 		'Antarctica/South_Pole'	=> 'Антарктика/Южный полюс',
 		'Antarctica/Syowa'		=> 'Антарктика/Сёва',
 		'Antarctica/Vostok'		=> 'Антарктика/Восток',
 
 		'Arctic/Longyearbyen'	=> 'Арктика/Шпицберген',
 
 		'Asia/Aden'			=> 'Азия/Аден',
 		'Asia/Almaty'		=> 'Азия/Алматы',
 		'Asia/Amman'		=> 'Азия/Амман',
 		'Asia/Anadyr'		=> 'Азия/Анадырь',
 		'Asia/Aqtau'		=> 'Азия/Актау',
 		'Asia/Aqtobe'		=> 'Азия/Актобе',
 		'Asia/Ashgabat'		=> 'Азия/Ашгабат',
 		'Asia/Baghdad'		=> 'Азия/Багдад',
 		'Asia/Bahrain'		=> 'Азия/Бахрейн',
 		'Asia/Baku'			=> 'Азия/Баку',
 		'Asia/Bangkok'		=> 'Азия/Бангкок',
 		'Asia/Beirut'		=> 'Азия/Бейрут',
 		'Asia/Bishkek'		=> 'Азия/Бишкек',
 		'Asia/Brunei'		=> 'Азия/Бруней',
 		'Asia/Choibalsan'	=> 'Азия/Чойбалсан',
 		'Asia/Chongqing'	=> 'Азия/Чунцин',
 		'Asia/Colombo'		=> 'Азия/Коломбо',
 		'Asia/Damascus'		=> 'Азия/Дамаск',
 		'Asia/Dhaka'		=> 'Азия/Дакка',
 		'Asia/Dili'			=> 'Азия/Дили',
 		'Asia/Dubai'		=> 'Азия/Дубай',
 		'Asia/Dushanbe'		=> 'Азия/Душанбе',
 		'Asia/Gaza'			=> 'Азия/Газа',
 		'Asia/Harbin'		=> 'Азия/Харбин',
 		'Asia/Hebron'		=> 'Азия/Хеврон',
 		'Asia/Ho_Chi_Minh'	=> 'Азия/Хо Ши Мин',
 		'Asia/Hong_Kong'	=> 'Азия/Гонконг',
 		'Asia/Hovd'			=> 'Азия/Ховд',
 		'Asia/Irkutsk'		=> 'Азия/Иркутск',
 		'Asia/Jakarta'		=> 'Азия/Джакарта',
 		'Asia/Jayapura'		=> 'Азия/Джаяпура',
 		'Asia/Jerusalem'	=> 'Азия/Иерусалим',
 		'Asia/Kabul'		=> 'Азия/Кабул',
 		'Asia/Kamchatka'	=> 'Азия/Камчатка',
 		'Asia/Karachi'		=> 'Азия/Карачи',
 		'Asia/Kashgar'		=> 'Азия/Кашгар',
 		'Asia/Kathmandu'	=> 'Азия/Катманду',
 		'Asia/Khandyga'		=> 'Азия/Хандыга',
 		'Asia/Kolkata'		=> 'Азия/Калькутта',
 		'Asia/Krasnoyarsk'	=> 'Азия/Красноярск',
 		'Asia/Kuala_Lumpur'	=> 'Азия/Куала-Лумпур',
 		'Asia/Kuching'		=> 'Азия/Кучинг',
 		'Asia/Kuwait'		=> 'Азия/Кувейт',
 		'Asia/Macau'		=> 'Азия/Макао',
 		'Asia/Magadan'		=> 'Азия/Магадан',
 		'Asia/Makassar'		=> 'Азия/Макасар',
 		'Asia/Manila'		=> 'Азия/Манила',
 		'Asia/Muscat'		=> 'Азия/Маскат',
 		'Asia/Nicosia'		=> 'Азия/Никосия',
 		'Asia/Novokuznetsk'	=> 'Азия/Новокузнецк',
 		'Asia/Novosibirsk'	=> 'Азия/Новосибирск',
 		'Asia/Omsk'			=> 'Азия/Омск',
 		'Asia/Oral'			=> 'Азия/Уральск',
 		'Asia/Phnom_Penh'	=> 'Азия/Пномпень',
 		'Asia/Pontianak'	=> 'Азия/Понтианак',
 		'Asia/Pyongyang'	=> 'Азия/Пхеньян',
 		'Asia/Qatar'		=> 'Азия/Катар',
 		'Asia/Qyzylorda'	=> 'Азия/Кызылорда',
 		'Asia/Rangoon'		=> 'Азия/Рангун',
 		'Asia/Riyadh'		=> 'Азия/Эр-Рияд',
 		'Asia/Sakhalin'		=> 'Азия/Сахалин',
 		'Asia/Samarkand'	=> 'Азия/Самарканд',
 		'Asia/Seoul'		=> 'Азия/Сеул',
 		'Asia/Shanghai'		=> 'Азия/Шанхай',
 		'Asia/Singapore'	=> 'Азия/Сингапур',
 		'Asia/Taipei'		=> 'Азия/Тайбэй',
 		'Asia/Tashkent'		=> 'Азия/Ташкент',
 		'Asia/Tbilisi'		=> 'Азия/Тбилиси',
 		'Asia/Tehran'		=> 'Азия/Тегеран',
 		'Asia/Thimphu'		=> 'Азия/Тхимпху',
 		'Asia/Tokyo'		=> 'Азия/Токио',
 		'Asia/Ulaanbaatar'	=> 'Азия/Улан-Батор',
 		'Asia/Urumqi'		=> 'Азия/Урумчи',
 		'Asia/Ust-Nera'		=> 'Азия/Усть-Нера',
 		'Asia/Vientiane'	=> 'Азия/Вьентьян',
 		'Asia/Vladivostok'	=> 'Азия/Владивосток',
 		'Asia/Yakutsk'		=> 'Азия/Якутск',
 		'Asia/Yekaterinburg'	=> 'Азия/Екатеринбург',
 		'Asia/Yerevan'		=> 'Азия/Ереван',
 
 		'Atlantic/Azores'		=> 'Атлантический океан/Азорские Острова',
 		'Atlantic/Bermuda'		=> 'Атлантический океан/Бермудские Острова',
 		'Atlantic/Canary'		=> 'Атлантический океан/Канарские Острова',
 		'Atlantic/Cape_Verde'	=> 'Атлантический океан/Острова Зеленого Мыса',
 		'Atlantic/Faroe'		=> 'Атлантический океан/Фарерские Острова',
 		'Atlantic/Madeira'		=> 'Атлантический океан/Мадейра',
 		'Atlantic/Reykjavik'	=> 'Атлантический океан/Рейкьявик',
 		'Atlantic/South_Georgia'	=> 'Атлантический океан/Южная Георгия',
 		'Atlantic/St_Helena'	=> 'Атлантический океан/Остров Святой Елены',
 		'Atlantic/Stanley'		=> 'Атлантический океан/Стэнли',
 
 		'Australia/Adelaide'	=> 'Австралия/Аделаида',
 		'Australia/Brisbane'	=> 'Австралия/Брисбен',
 		'Australia/Broken_Hill'	=> 'Австралия/Брокен-Хилл',
 		'Australia/Currie'		=> 'Австралия/Керри',
 		'Australia/Darwin'		=> 'Австралия/Дарвин',
 		'Australia/Eucla'		=> 'Австралия/Юкла',
 		'Australia/Hobart'		=> 'Австралия/Хобарт',
 		'Australia/Lindeman'	=> 'Австралия/Линдман',
 		'Australia/Lord_Howe'	=> 'Австралия/Остров Лорд-Хау',
 		'Australia/Melbourne'	=> 'Австралия/Мельбурн',
 		'Australia/Perth'		=> 'Австралия/Перт',
 		'Australia/Sydney'		=> 'Австралия/Сидней',
 
 		'Europe/Amsterdam'	=> 'Европа/Амстердам',
 		'Europe/Andorra'	=> 'Европа/Андорра',
 		'Europe/Athens'		=> 'Европа/Афины',
 		'Europe/Belgrade'	=> 'Европа/Белград',
 		'Europe/Berlin'		=> 'Европа/Берлин',
 		'Europe/Bratislava'	=> 'Европа/Братислава',
 		'Europe/Brussels'	=> 'Европа/Брюссель',
 		'Europe/Bucharest'	=> 'Европа/Бухарест',
 		'Europe/Budapest'	=> 'Европа/Будапешт',
 		'Europe/Busingen'	=> 'Европа/Бюзинген',
 		'Europe/Chisinau'	=> 'Европа/Кишинёв',
 		'Europe/Copenhagen'	=> 'Европа/Копенгаген',
 		'Europe/Dublin'		=> 'Европа/Дублин',
 		'Europe/Gibraltar'	=> 'Европа/Гибралтар',
 		'Europe/Guernsey'	=> 'Европа/Гернси',
 		'Europe/Helsinki'	=> 'Европа/Хельсинки',
 		'Europe/Isle_of_Man'	=> 'Европа/Остров Мэн',
 		'Europe/Istanbul'	=> 'Европа/Стамбул',
 		'Europe/Jersey'		=> 'Европа/Джерси',
 		'Europe/Kaliningrad'	=> 'Европа/Калининград',
 		'Europe/Kiev'		=> 'Европа/Киев',
 		'Europe/Lisbon'		=> 'Европа/Лиссабон',
 		'Europe/Ljubljana'	=> 'Европа/Любляна',
 		'Europe/London'		=> 'Европа/Лондон',
 		'Europe/Luxembourg'	=> 'Европа/Люксембург',
 		'Europe/Madrid'		=> 'Европа/Мадрид',
 		'Europe/Malta'		=> 'Европа/Мальта',
 		'Europe/Mariehamn'	=> 'Европа/Маарианхамина',
 		'Europe/Minsk'		=> 'Европа/Минск',
 		'Europe/Monaco'		=> 'Европа/Монако',
 		'Europe/Moscow'		=> 'Европа/Москва',
 		'Europe/Oslo'		=> 'Европа/Осло',
 		'Europe/Paris'		=> 'Европа/Париж',
 		'Europe/Podgorica'	=> 'Европа/Подгорица',
 		'Europe/Prague'		=> 'Европа/Прага',
 		'Europe/Riga'		=> 'Европа/Рига',
 		'Europe/Rome'		=> 'Европа/Рим',
 		'Europe/Samara'		=> 'Европа/Самара',
 		'Europe/San_Marino'	=> 'Европа/Сан-Марино',
 		'Europe/Sarajevo'	=> 'Европа/Сараево',
 		'Europe/Simferopol'	=> 'Европа/Симферополь',
 		'Europe/Skopje'		=> 'Европа/Скопье',
 		'Europe/Sofia'		=> 'Европа/София',
 		'Europe/Stockholm'	=> 'Европа/Стокгольм',
 		'Europe/Tallinn'	=> 'Европа/Таллин',
 		'Europe/Tirane'		=> 'Европа/Тирана',
 		'Europe/Uzhgorod'	=> 'Европа/Ужгород',
 		'Europe/Vaduz'		=> 'Европа/Вадуц',
 		'Europe/Vatican'	=> 'Европа/Ватикан',
 		'Europe/Vienna'		=> 'Европа/Вена',
 		'Europe/Vilnius'	=> 'Европа/Вильнюс',
 		'Europe/Volgograd'	=> 'Европа/Волгоград',
 		'Europe/Warsaw'		=> 'Европа/Варшава',
 		'Europe/Zagreb'		=> 'Европа/Загреб',
 		'Europe/Zaporozhye'	=> 'Европа/Запорожье',
 		'Europe/Zurich'		=> 'Европа/Цюрих',
 
 		'Indian/Antananarivo'	=> 'Индийский океан/Антананариву',
 		'Indian/Chagos'		=> 'Индийский океан/Чагос',
 		'Indian/Christmas'	=> 'Индийский океан/Кристмас',
 		'Indian/Cocos'		=> 'Индийский океан/Кокосовые острова',
 		'Indian/Comoro'		=> 'Индийский океан/Коморские Острова',
 		'Indian/Kerguelen'	=> 'Индийский океан/Кергелен',
 		'Indian/Mahe'		=> 'Индийский океан/Маэ',
 		'Indian/Maldives'	=> 'Индийский океан/Мальдивы',
 		'Indian/Mauritius'	=> 'Индийский океан/Маврикий',
 		'Indian/Mayotte'	=> 'Индийский океан/Майотта',
 		'Indian/Reunion'	=> 'Индийский океан/Реюньон',
 
 		'Pacific/Apia'		=> 'Тихий океан/Апиа',
 		'Pacific/Auckland'	=> 'Тихий океан/Окленд',
 		'Pacific/Chatham'	=> 'Тихий океан/Чатем',
 		'Pacific/Chuuk'		=> 'Тихий океан/Чуук',
 		'Pacific/Easter'	=> 'Тихий океан/Остров Пасхи',
 		'Pacific/Efate'		=> 'Тихий океан/Эфате',
 		'Pacific/Enderbury'	=> 'Тихий океан/Эндербери',
 		'Pacific/Fakaofo'	=> 'Тихий океан/Факаофо',
 		'Pacific/Fiji'		=> 'Тихий океан/Фиджи',
 		'Pacific/Funafuti'	=> 'Тихий океан/Фунафути',
 		'Pacific/Galapagos'	=> 'Тихий океан/Галапагос',
 		'Pacific/Gambier'	=> 'Тихий океан/Острова Гамбье',
 		'Pacific/Guadalcanal'	=> 'Тихий океан/Гуадалканал',
 		'Pacific/Guam'		=> 'Тихий океан/Гуам',
 		'Pacific/Honolulu'	=> 'Тихий океан/Гонолулу',
 		'Pacific/Johnston'	=> 'Тихий океан/Джонстон',
 		'Pacific/Kiritimati'	=> 'Тихий океан/Кирибати',
 		'Pacific/Kosrae'	=> 'Тихий океан/Кусаие',
 		'Pacific/Kwajalein'	=> 'Тихий океан/Кваджалейн',
 		'Pacific/Majuro'	=> 'Тихий океан/Маджуро',
 		'Pacific/Marquesas'	=> 'Тихий океан/Маркизские острова',
 		'Pacific/Midway'	=> 'Тихий океан/Мидуэй',
 		'Pacific/Nauru'		=> 'Тихий океан/Науру',
 		'Pacific/Niue'		=> 'Тихий океан/Ниуэ',
 		'Pacific/Norfolk'	=> 'Тихий океан/Норфолк',
 		'Pacific/Noumea'	=> 'Тихий океан/Нумеа',
 		'Pacific/Pago_Pago'	=> 'Тихий океан/Паго-Паго',
 		'Pacific/Palau'		=> 'Тихий океан/Палау',
 		'Pacific/Pitcairn'	=> 'Тихий океан/Питкэрн',
 		'Pacific/Pohnpei'	=> 'Тихий океан/Понпеи',
 		'Pacific/Port_Moresby'	=> 'Тихий океан/Порт-Морсби',
 		'Pacific/Rarotonga'	=> 'Тихий океан/Раротонга',
 		'Pacific/Saipan'	=> 'Тихий океан/Сайпан',
 		'Pacific/Tahiti'	=> 'Тихий океан/Таити',
 		'Pacific/Tarawa'	=> 'Тихий океан/Тарава',
 		'Pacific/Tongatapu'	=> 'Тихий океан/Тонгатапу',
 		'Pacific/Wake'		=> 'Тихий океан/Уэйк',
 		'Pacific/Wallis'	=> 'Тихий океан/Уоллис',
	),

	// The value is only an example and will get replaced by the current time on view
	'dateformats'	=> array(
		'd M Y, H:i'			=> '10 янв 2005, 17:57',
		'd M Y H:i'				=> '10 янв 2005 17:57',
		'M j, \'y, H:i'			=> 'Янв 1, \'07, 13:37',
		'D M d, Y g:i a'		=> 'Пн янв 10, 2005 5:57 pm',
		'F j, Y, g:i a'			=> 'Январь 1, 2007, 1:37 pm',
		'|d M Y|, H:i'			=> 'Сегодня, 13:37 / 01 Янв 2007, 13:37',
		'|F j, Y|, g:i a'		=> 'Сегодня, 1:37 pm / Январь 1, 2007, 1:37 pm',
	),

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'	=>'|d M Y|, H:i', // Сегодня, 13:37 / 01 Янв 2007, 13:37

]);
