<?php
/**
 * This file is part of the French language pack for the
 * phpBB forum software.
 *
 * @copyright (c) phpBB Limited <https://www.phpbb.com>
 * @copyright (c) Qiaeru <https://www.qiaeru.com>
 * @license GNU General Public License, version 2 (GPL-2.0)
 *
 * For more information about the language pack, please visit
 * https://www.phpbb.com/customise/db/translation/french/
 */

/**
 * DO NOT CHANGE
 */
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = [];
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

$lang = array_merge($lang, [
	'CONTROLLER_ARGUMENT_VALUE_MISSING' => 'Valeur manquante concernant l’argument #%1$s : « %3$s » dans la classe « %2$s »',
	'CONTROLLER_NOT_SPECIFIED'          => 'Aucun contrôleur n’a été spécifié.',
	'CONTROLLER_METHOD_NOT_SPECIFIED'   => 'Aucune méthode concernant le contrôleur n’a été spécifiée.',
	'CONTROLLER_SERVICE_UNDEFINED'      => 'Le service du contrôleur « %s » n’est pas défini dans « ./config/services.yml ».',
]);
