<?php
/**
 * phpwcms content management system
 *
 * @author Oliver Georgi <og@phpwcms.org>
 * @copyright Copyright (c) 2002-2025, Oliver Georgi
 * @license http://opensource.org/licenses/GPL-2.0 GNU GPL-2
 * @link http://www.phpwcms.org
 *
 **/

$phpwcms['mime_types'] = array(

	'*'			=>	'application/octet-stream',
	'3dmf'		=>	'x-world/x-3dmf',
	'3g2'		=>	'video/3gpp2',
	'3gp2'		=>	'video/3gpp2',
	'3gp'		=>	'video/3gpp',
	'3gpp'		=>	'video/3gpp',
	'abs'		=>	'audio/x-mpeg',
	'aac'		=>	'audio/acc',
	'adts'		=>	'audio/acc',
	'ai'		=>	'application/postscript',
	'aif'		=>	'audio/x-aiff',
	'aifc'		=>	'audio/x-aiff',
	'aiff'		=>	'audio/x-aiff',
	'asc'		=>	'text/plain',
	'asf'		=>	'video/x-ms-asf',
	'au'		=>	'audio/basic',
	'avi'		=>	'video/x-msvideo',
	'axs'		=>	'application/x-olescript',
	'bcpio'		=>	'application/x-bcpio',
	'bin'		=>	'application/octet-stream',
	'bmp'		=>	'image/x-ms-bmp',
	'bwf'		=>	'audio/wav',
	'bz2'		=>	'application/x-bzip2',
	'c'			=>	'text/plain',
	'c++'		=>	'text/plain',
	'cal'		=>	'image/x-cals',
	'cc'		=>	'text/plain',
	'cdda'		=>	'audio/aiff',
	'cgm'		=>	'image/cgm',
	'chrt'		=>	'application/x-kchart',
	'cmx'		=>	'image/x-cmx',
	'com'		=>	'application/octet-stream',
	'cpio'		=>	'application/x-cpio',
	'cpt'		=>	'application/mac-compactpro',
	'csh'		=>	'application/x-csh',
	'css'		=>	'text/css',
	'dll'		=>	'application/octet-stream',
	'doc'		=>	'application/msword',
	'dot'		=>	'application/msword',
	'dsf'		=>	'image/x-mgx-dsf',
	'dvi'		=>	'application/x-dvi',
	'dwf'		=>	'drawing/x-dwf',
	'dwg'		=>	'image/x-dwg',
	'dxf'		=>	'image/x-dxf',
	'eps'		=>	'application/postscript',
	'es'		=>	'audio/echospeech',
	'evy'		=>	'application/envoy',
	'exe'		=>	'application/octet-stream',

	'f4a'		=>	'audio/mp4',
	'f4b'		=>	'audio/mp4',
	'f4p'		=>	'video/mp4',
	'f4v'		=>	'video/mp4',

	'fif'		=>	'image/fif',
	'flac'		=>	'audio/flac',
	'flv'		=>	'video/x-flv',
	'fm'		=>	'application/x-framemaker',
	'frame'		=>	'application/x-framemaker',
	'frm'		=>	'application/x-framemaker',
	'g3f'		=>	'image/g3fax',
	'gif'		=>	'image/gif',
	'gtar'		=>	'application/x-gtar',
	'gz'		=>	'application/x-gzip',
	'h'			=>	'text/plain',
	'hdf'		=>	'application/hdf',
	'hqx'		=>	'application/mac-binhex40',
	'htm'		=>	'text/html',
	'html'		=>	'text/html',
	'ice'		=>	'x-conference/x-cooltalk',
	'ief'		=>	'image/ief',
	'jpe'		=>	'image/jpeg',
	'jpeg'		=>	'image/jpeg',
	'jpg'		=>	'image/jpeg',
	'js'		=>	'text/javascript',
	'kar'		=>	'audio/midi',
	'kpr'		=>	'application/x-kpresenter',
	'kpt'		=>	'application/x-kpresenter',
	'ksp'		=>	'application/x-kspread',
	'kwd'		=>	'application/x-kword',
	'kwt'		=>	'application/x-kword',
	'latex'		=>	'application/x-latex',
	'lcc'		=>	'application/fastman',
	'ls'		=>	'text/javascript',
	'm1a'		=>	'video/mpeg',
	'm1s'		=>	'video/mpeg',
	'm1v'		=>	'video/mpeg',
	'm15'		=>	'video/mpeg',
	'm4a'		=>	'audio/mp4',
	'm4v'		=>	'video/mp4',
	'm75'		=>	'video/mpeg',
	'man'		=>	'application/x-troff-man',
	'me'		=>	'application/x-troff-me',
	'mid'		=>	'audio/midi',
	'midi'		=>	'audio/midi',
	'mif'		=>	'application/x-mif',
	'mil'		=>	'image/x-cals',
	'mmid'		=>	'x-music/x-midi',
	'mocha'		=>	'text/javascript',
	'mov'		=>	'video/quicktime',
	'movie'		=>	'video/x-sgi-movie',
	'mp2'		=>	'audio/mpeg',
	'mp2a'		=>	'audio/x-mpeg-2',
	'mp2v'		=>	'video/mpeg-2',
	'mp3'		=>	'audio/mpeg',
	'mp4'		=>	'video/mp4',
	'mpa'		=>	'audio/x-mpeg',
	'mpa2'		=>	'audio/x-mpeg-2',
	'mpe'		=>	'video/mpeg',
	'mpeg'		=>	'video/mpeg',
	'mpega'		=>	'audio/x-mpeg',
	'mpg'		=>	'video/mpeg',
	'mpg4'		=>	'video/mp4',
	'mpga'		=>	'audio/mpeg',
	'mpm'		=>	'video/mpeg',
	'mpv'		=>	'video/mpeg',
	'mpv2'		=>	'video/mpeg-2',
	'ms'		=>	'application/x-troff-ms',
	'oda'		=>	'application/oda',

	// Open Office
	'odt'		=>	'application/vnd.oasis.opendocument.text',
	'ott'		=>	'application/vnd.oasis.opendocument.text-template',
	'odg'		=>	'application/vnd.oasis.opendocument.graphics',
	'otg'		=>	'application/vnd.oasis.opendocument.graphics-template',
	'odp'		=>	'application/vnd.oasis.opendocument.presentation',
	'otp'		=>	'application/vnd.oasis.opendocument.presentation-template',
	'ods'		=>	'application/vnd.oasis.opendocument.spreadsheet',
	'ots'		=>	'application/vnd.oasis.opendocument.spreadsheet-template',
	'odc'		=>	'application/vnd.oasis.opendocument.chart',
	'otc'		=>	'application/vnd.oasis.opendocument.chart-template',
	'odi'		=>	'application/vnd.oasis.opendocument.image',
	'oti'		=>	'application/vnd.oasis.opendocument.image-template',
	'odf'		=>	'application/vnd.oasis.opendocument.formula',
	'otf'		=>	'application/vnd.oasis.opendocument.formula-template',
	'odm'		=>	'application/vnd.oasis.opendocument.text-master',
	'oth'		=>	'application/vnd.oasis.opendocument.text-web',

	// Office 2007
	'docx'			=>	'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
	'docm'			=>	'application/vnd.ms-word.document.macroEnabled.12',
	'dotx'			=>	'application/vnd.openxmlformats-officedocument.wordprocessingml.template',
	'dotm'			=>	'application/vnd.ms-word.template.macroEnabled.12',
	'xlsx'			=>	'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
	'xlsm'			=>	'application/vnd.ms-excel.sheet.macroEnabled.12',
	'xltx'			=>	'application/vnd.openxmlformats-officedocument.spreadsheetml.template',
	'xltm'			=>	'application/vnd.ms-excel.template.macroEnabled.12',
	'xlsb'			=>	'application/vnd.ms-excel.sheet.binary.macroEnabled.12',
	'xlam'			=>	'application/vnd.ms-excel.addin.macroEnabled.12',
	'pptx'			=>	'application/vnd.openxmlformats-officedocument.presentationml.presentation',
	'pptm'			=>	'application/vnd.ms-powerpoint.presentation.macroEnabled.12',
	'ppsx'			=>	'application/vnd.openxmlformats-officedocument.presentationml.slideshow',
	'ppsm'			=>	'application/vnd.ms-powerpoint.slideshow.macroEnabled.12',
	'potx'			=>	'application/vnd.openxmlformats-officedocument.presentationml.template',
	'potm'			=>	'application/vnd.ms-powerpoint.template.macroEnabled.12',
	'ppam'			=>	'application/vnd.ms-powerpoint.addin.macroEnabled.12',
	'sldx'			=>	'application/vnd.openxmlformats-officedocument.presentationml.slide',
	'sldm'			=>	'application/vnd.ms-powerpoint.slide.macroEnabled.12',
	'thmx'			=>	'application/vnd.ms-officetheme',
	'onetoc'		=>	'application/onenote',
	'onetoc2'		=>	'application/onenote',
	'onetmp'		=>	'application/onenote',
	'onepkg'		=>	'application/onenote',

	'oga'		=>	'audio/ogg',
	'ogg'		=>	'audio/ogg',
	'ogv'		=>	'video/ogg',
	'ogx'		=>	'application/ogg',
	'pac'		=>	'application/x-ns-proxy-autoconfig',
	'pbm'		=>	'image/x-portable-bitmap',
	'pcd'		=>	'image/x-photo-cd',
	'pdf'		=>	'application/pdf',
	'pgm'		=>	'image/x-portable-graymap',
	'php'		=>	'text/plain',
	'phps'		=>	'text/plain',
	'pict'		=>	'image/x-pict',
	'pl'		=>	'text/plain',
	'png'		=>	'image/png',
	'pnm'		=>	'image/x-portable-anymap',
	'ppm'		=>	'image/x-portable-pixmap',
	'ppt'		=>	'application/mspowerpoint',
	'ps'		=>	'application/postscript',
	'qt'		=>	'video/quicktime',
	'ra'		=>	'application/x-pn-realaudio',
	'ram'		=>	'application/x-pn-realaudio',
	'ras'		=>	'image/x-cmu-raster',
	'rgb'		=>	'image/rgb',
	'roff'		=>	'application/x-troff',
	'rtf'		=>	'application/rtf',
	'rtx'		=>	'text/richtext',
	'sdv'		=>	'video/sd-video',
	'sea'		=>	'application/x-stuffit',
	'sgm'		=>	'text/sgml',
	'sgml'		=>	'text/sgml',
	'sh'		=>	'application/x-sh',
	'shar'		=>	'application/x-shar',
	'sit'		=>	'application/x-stuffit',
	'skp'		=>	'application/x-koan',
	'smf'		=>	'audio/midi',
	'snd'		=>	'audio/basic',
	'spl'		=>	'application/futuresplash',
	'spx'		=>	'audio/ogg',
	'src'		=>	'application/x-wais-source',
	'svf'		=>	'vector/x-svf',
	'swa'		=>	'audio/mp3',
	'swf'		=>	'application/x-shockwave-flash',
	't'			=>	'application/x-troff',
	'talk'		=>	'text/x-speech',
	'tar'		=>	'application/x-tar',
	'tcl'		=>	'application/x-tcl',
	'tex'		=>	'application/x-tex',
	'texi'		=>	'application/x-texinfo',
	'texinfo'	=>	'application/x-texinfo',
	'tgz'		=>	'application/x-gzip',
	'tif'		=>	'image/tiff',
	'tiff'		=>	'image/tiff',
	'tr'		=>	'application/x-troff',
	'txt'		=>	'text/plain',
	'ustar'		=>	'application/x-ustar',
	'uu'		=>	'application/octet-stream',
	'vbs'		=>	'text/vbscript',
	'vdo'		=>	'video/vdo',
	'video'		=>	'video/x-msvideo',
	'viv'		=>	'video/vivo',
	'vox'		=>	'audio/voxware',
	'wav'		=>	'audio/wav',
	'wax'		=>	'audio/x-ms-wax',
	'webm'		=>	'video/webm',
	'wi'		=>	'image/wavelet',
	'wm'		=>	'video/x-ms-wm',
	'wma'		=>	'audio/x-ms-wma',
	'wmv'		=>	'video/x-ms-wmv',
	'wp'		=>	'application/wordperfect5.1',
	'wsrc'		=>	'application/x-wais-source',
	'wvx'		=>	'video/x-ms-wvx',
	'xbm'		=>	'image/x-xbitmap',
	'xls'		=>	'application/msexcel',
	'xml'		=>	'text/xml',
	'xpm'		=>	'image/x-xpixmap',
	'xwd'		=>	'image/x-xwindowdump',
	'zip'		=>	'application/zip'

);

/*
 * Return Mime-Type of file extension
 *
 * @param string file extension
 * @return strin mime-type
 */
function get_mimetype_by_extension($ext='') {

	if(empty($ext) || !isset($GLOBALS['phpwcms']['mime_types'][$ext])) {
		$ext = '*';
	}

	return $GLOBALS['phpwcms']['mime_types'][$ext];
}

function is_mimetype_by_extension($ext) {
	return !(empty($ext) || !isset($GLOBALS['phpwcms']['mime_types'][$ext]));
}

/**
 * Check a given MimeType against type/subtype format
 * It is mainly based to handle problemes related to mimeTypes.rdf in FireFox
 */
function is_mimetype_format($mimetype='') {

	if(empty($mimetype)) {
		return false;
	}

	// we do not test against 'examples' type
	return preg_match('/^(application|audio|image|text|video|message|model|multipart)\/([a-z0-9\-\.\+]+)$/i', $mimetype);
}
