
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `phpwcms1109`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_address`
--

CREATE TABLE `[[dbprefix]]phpwcms_address` (
  `address_id` int(11) NOT NULL AUTO_INCREMENT,
  `address_key` varchar(255) NOT NULL DEFAULT '',
  `address_email` text NOT NULL,
  `address_name` text NOT NULL,
  `address_verified` int(1) NOT NULL DEFAULT '0',
  `address_tstamp` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `address_subscription` blob NOT NULL,
  `address_iddetail` int(11) NOT NULL DEFAULT '0',
  `address_url1` varchar(255) NOT NULL DEFAULT '',
  `address_url2` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`address_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_ads_campaign`
--

CREATE TABLE `[[dbprefix]]phpwcms_ads_campaign` (
  `adcampaign_id` int(11) NOT NULL AUTO_INCREMENT,
  `adcampaign_created` datetime DEFAULT NULL,
  `adcampaign_changed` datetime DEFAULT NULL,
  `adcampaign_status` int(1) NOT NULL DEFAULT '0',
  `adcampaign_title` varchar(255) NOT NULL DEFAULT '',
  `adcampaign_comment` text NOT NULL,
  `adcampaign_datestart` datetime DEFAULT NULL,
  `adcampaign_dateend` datetime DEFAULT NULL,
  `adcampaign_maxview` int(11) NOT NULL DEFAULT '0',
  `adcampaign_maxclick` int(11) NOT NULL DEFAULT '0',
  `adcampaign_maxviewuser` int(11) NOT NULL DEFAULT '0',
  `adcampaign_curview` int(11) NOT NULL DEFAULT '0',
  `adcampaign_curclick` int(11) NOT NULL DEFAULT '0',
  `adcampaign_curviewuser` int(11) NOT NULL DEFAULT '0',
  `adcampaign_type` int(11) NOT NULL DEFAULT '0',
  `adcampaign_place` int(11) NOT NULL DEFAULT '0',
  `adcampaign_data` mediumtext NOT NULL,
  PRIMARY KEY (`adcampaign_id`),
  KEY `adcampaign_status` (`adcampaign_status`,`adcampaign_datestart`,`adcampaign_dateend`,`adcampaign_type`,`adcampaign_place`),
  KEY `adcampaign_maxview` (`adcampaign_maxview`,`adcampaign_maxclick`,`adcampaign_maxviewuser`),
  KEY `adcampaign_curview` (`adcampaign_curview`,`adcampaign_curclick`,`adcampaign_curviewuser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_ads_formats`
--

CREATE TABLE `[[dbprefix]]phpwcms_ads_formats` (
  `adformat_id` int(11) NOT NULL AUTO_INCREMENT,
  `adformat_created` datetime DEFAULT NULL,
  `adformat_changed` datetime DEFAULT NULL,
  `adformat_status` int(1) NOT NULL DEFAULT '0',
  `adformat_title` varchar(25) NOT NULL DEFAULT '',
  `adformat_width` int(5) NOT NULL DEFAULT '0',
  `adformat_height` int(5) NOT NULL DEFAULT '0',
  `adformat_comment` text NOT NULL,
  PRIMARY KEY (`adformat_id`),
  KEY `adformat_status` (`adformat_status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=24 ;

--
-- Dumping data for table `[[dbprefix]]phpwcms_ads_formats`
--

INSERT INTO `[[dbprefix]]phpwcms_ads_formats` VALUES
(1, '[[regtime]]', '[[regtime]]', 1, 'Leaderboard', 728, 90, ''),
(2, '[[regtime]]', '[[regtime]]', 1, 'Banner', 468, 60, ''),
(3, '[[regtime]]', '[[regtime]]', 1, 'Small Square', 200, 200, ''),
(4, '[[regtime]]', '[[regtime]]', 1, 'Square', 250, 250, ''),
(5, '[[regtime]]', '[[regtime]]', 1, 'Medium Rectangle', 300, 250, ''),
(6, '[[regtime]]', '[[regtime]]', 1, 'Large Rectangle', 336, 280, ''),
(7, '[[regtime]]', '[[regtime]]', 1, 'Skyscraper', 120, 600, ''),
(8, '[[regtime]]', '[[regtime]]', 1, 'Wide Skyscraper', 160, 600, ''),
(10, '[[regtime]]', '[[regtime]]', 1, 'Half Banner', 234, 60, ''),
(11, '[[regtime]]', '[[regtime]]', 1, 'Square Button', 125, 125, ''),
(12, '[[regtime]]', '[[regtime]]', 1, 'Small Rectangle', 180, 150, ''),
(13, '[[regtime]]', '[[regtime]]', 1, 'Vertical Banner', 120, 240, ''),
(14, '[[regtime]]', '[[regtime]]', 1, 'Mini Square', 120, 120, ''),
(15, '[[regtime]]', '[[regtime]]', 1, 'Medium Scyscraper', 120, 450, ''),
(16, '[[regtime]]', '[[regtime]]', 1, 'Micro Bar', 88, 31, ''),
(17, '[[regtime]]', '[[regtime]]', 1, 'Vertical Rectangle', 240, 400, ''),
(18, '[[regtime]]', '[[regtime]]', 1, 'Vertical Button', 120, 90, ''),
(19, '[[regtime]]', '[[regtime]]', 1, 'Half Mini Square', 120, 60, ''),
(20, '[[regtime]]', '[[regtime]]', 1, 'Half Page Ad', 300, 600, ''),
(21, '[[regtime]]', '[[regtime]]', 1, 'Universal Flash Layer', 400, 400, ''),
(22, '[[regtime]]', '[[regtime]]', 1, 'PopUp', 250, 300, ''),
(23, '[[regtime]]', '[[regtime]]', 1, 'Target Button', 120, 150, '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_ads_place`
--

CREATE TABLE `[[dbprefix]]phpwcms_ads_place` (
  `adplace_id` int(11) NOT NULL AUTO_INCREMENT,
  `adplace_created` datetime DEFAULT NULL,
  `adplace_changed` datetime DEFAULT NULL,
  `adplace_status` int(1) NOT NULL DEFAULT '0',
  `adplace_title` varchar(255) NOT NULL DEFAULT '',
  `adplace_format` int(11) NOT NULL DEFAULT '0',
  `adplace_width` int(11) NOT NULL DEFAULT '0',
  `adplace_height` int(11) NOT NULL DEFAULT '0',
  `adplace_prefix` varchar(255) NOT NULL DEFAULT '',
  `adplace_suffix` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`adplace_id`),
  KEY `adplace_status` (`adplace_status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_ads_tracking`
--

CREATE TABLE `[[dbprefix]]phpwcms_ads_tracking` (
  `adtracking_id` int(11) NOT NULL AUTO_INCREMENT,
  `adtracking_created` datetime DEFAULT NULL,
  `adtracking_campaignid` int(11) NOT NULL DEFAULT '0',
  `adtracking_ip` varchar(30) NOT NULL DEFAULT '',
  `adtracking_cookieid` varchar(50) NOT NULL DEFAULT '',
  `adtracking_countclick` int(11) NOT NULL DEFAULT '0',
  `adtracking_countview` int(11) NOT NULL DEFAULT '0',
  `adtracking_useragent` varchar(255) NOT NULL DEFAULT '',
  `adtracking_ref` text NOT NULL,
  `adtracking_catid` int(11) NOT NULL DEFAULT '0',
  `adtracking_articleid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`adtracking_id`),
  KEY `adtracking_campaignid` (`adtracking_campaignid`,`adtracking_ip`,`adtracking_countclick`,`adtracking_countview`),
  KEY `adtracking_cookieid` (`adtracking_cookieid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_article`
--

CREATE TABLE `[[dbprefix]]phpwcms_article` (
  `article_id` int(11) NOT NULL AUTO_INCREMENT,
  `article_cid` int(11) NOT NULL DEFAULT '0',
  `article_tid` int(11) NOT NULL DEFAULT '0',
  `article_uid` int(11) NOT NULL DEFAULT '0',
  `article_tstamp` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `article_username` varchar(255) NOT NULL DEFAULT '',
  `article_title` text NOT NULL,
  `article_alias` varchar(1000) NOT NULL DEFAULT '',
  `article_keyword` text NOT NULL,
  `article_public` int(1) NOT NULL DEFAULT '1',
  `article_deleted` int(1) NOT NULL DEFAULT '0',
  `article_begin` datetime DEFAULT NULL,
  `article_end` datetime DEFAULT NULL,
  `article_aktiv` int(1) NOT NULL DEFAULT '0',
  `article_subtitle` text NOT NULL,
  `article_summary` mediumtext NOT NULL,
  `article_redirect` text NOT NULL,
  `article_sort` int(11) NOT NULL DEFAULT '0',
  `article_notitle` int(1) NOT NULL DEFAULT '0',
  `article_hidesummary` int(1) NOT NULL DEFAULT '0',
  `article_image` blob NOT NULL,
  `article_created` varchar(14) NOT NULL DEFAULT '',
  `article_cache` varchar(10) NOT NULL DEFAULT '0',
  `article_nosearch` char(1) NOT NULL DEFAULT '0',
  `article_nositemap` int(1) NOT NULL DEFAULT '0',
  `article_aliasid` int(11) NOT NULL DEFAULT '0',
  `article_headerdata` int(1) NOT NULL DEFAULT '0',
  `article_morelink` int(1) NOT NULL DEFAULT '1',
  `article_noteaser` int(1) unsigned NOT NULL DEFAULT '0',
  `article_pagetitle` varchar(2000) NOT NULL DEFAULT '',
  `article_paginate` int(1) NOT NULL DEFAULT '0',
  `article_serialized` blob NOT NULL,
  `article_priorize` int(5) NOT NULL DEFAULT '0',
  `article_norss` int(1) NOT NULL DEFAULT '1',
  `article_archive_status` int(1) NOT NULL DEFAULT '1',
  `article_menutitle` varchar(255) NOT NULL DEFAULT '',
  `article_description` text NOT NULL,
  `article_lang` varchar(255) NOT NULL DEFAULT '',
  `article_lang_type` varchar(255) NOT NULL DEFAULT '',
  `article_lang_id` int(11) unsigned NOT NULL DEFAULT '0',
  `article_opengraph` int(1) unsigned NOT NULL DEFAULT '1',
  `article_canonical` varchar(2000) NOT NULL DEFAULT '',
  `article_meta` mediumtext NOT NULL,
  PRIMARY KEY (`article_id`),
  KEY `article_aktiv` (`article_aktiv`),
  KEY `article_public` (`article_public`),
  KEY `article_deleted` (`article_deleted`),
  KEY `article_nosearch` (`article_nosearch`),
  KEY `article_begin` (`article_begin`),
  KEY `article_end` (`article_end`),
  KEY `article_cid` (`article_cid`),
  KEY `article_tstamp` (`article_tstamp`),
  KEY `article_priorize` (`article_priorize`),
  KEY `article_sort` (`article_sort`),
  KEY `article_alias` (`article_alias`(768)),
  KEY `article_archive_status` (`article_archive_status`),
  KEY `article_lang` (`article_lang`),
  KEY `article_lang_type` (`article_lang_type`),
  KEY `article_lang_id` (`article_lang_id`),
  KEY `article_noteaser` (`article_noteaser`),
  KEY `article_opengraph` (`article_opengraph`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_articlecat`
--

CREATE TABLE `[[dbprefix]]phpwcms_articlecat` (
  `acat_id` int(11) NOT NULL AUTO_INCREMENT,
  `acat_name` text NOT NULL,
  `acat_title` varchar(2000) NOT NULL DEFAULT '',
  `acat_info` text NOT NULL,
  `acat_public` int(1) NOT NULL DEFAULT '1',
  `acat_tstamp` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `acat_aktiv` int(1) NOT NULL DEFAULT '0',
  `acat_uid` int(11) NOT NULL DEFAULT '0',
  `acat_trash` int(1) NOT NULL DEFAULT '0',
  `acat_struct` int(11) NOT NULL DEFAULT '0',
  `acat_sort` int(11) NOT NULL DEFAULT '0',
  `acat_alias` varchar(255) NOT NULL DEFAULT '',
  `acat_hidden` int(1) NOT NULL DEFAULT '0',
  `acat_template` int(11) NOT NULL DEFAULT '0',
  `acat_ssl` int(1) NOT NULL DEFAULT '0',
  `acat_regonly` int(1) NOT NULL DEFAULT '0',
  `acat_topcount` int(11) NOT NULL DEFAULT '0',
  `acat_redirect` text NOT NULL,
  `acat_order` int(2) NOT NULL DEFAULT '0',
  `acat_cache` varchar(10) NOT NULL DEFAULT '',
  `acat_nosearch` char(1) NOT NULL DEFAULT '',
  `acat_nositemap` int(1) NOT NULL DEFAULT '0',
  `acat_permit` text NOT NULL,
  `acat_maxlist` int(11) NOT NULL DEFAULT '0',
  `acat_cntpart` varchar(255) NOT NULL DEFAULT '',
  `acat_pagetitle` varchar(2000) NOT NULL DEFAULT '',
  `acat_paginate` int(1) NOT NULL DEFAULT '0',
  `acat_overwrite` varchar(255) NOT NULL DEFAULT '',
  `acat_archive` int(1) NOT NULL DEFAULT '0',
  `acat_class` varchar(255) NOT NULL DEFAULT '',
  `acat_keywords` varchar(255) NOT NULL DEFAULT '',
  `acat_cpdefault` int(10) unsigned NOT NULL DEFAULT '0',
  `acat_lang` varchar(255) NOT NULL DEFAULT '',
  `acat_lang_type` varchar(255) NOT NULL DEFAULT '',
  `acat_lang_id` int(11) unsigned NOT NULL DEFAULT '0',
  `acat_disable301` int(1) unsigned NOT NULL DEFAULT '0',
  `acat_opengraph` int(1) unsigned NOT NULL DEFAULT '1',
  `acat_canonical` varchar(2000) NOT NULL DEFAULT '',
  `acat_breadcrumb` int(1) unsigned NOT NULL DEFAULT '0',
  `acat_onepage` int(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`acat_id`),
  KEY `acat_struct` (`acat_struct`),
  KEY `acat_sort` (`acat_sort`),
  KEY `acat_alias` (`acat_alias`),
  KEY `acat_archive` (`acat_archive`),
  KEY `acat_lang` (`acat_lang`),
  KEY `acat_lang_type` (`acat_lang_type`),
  KEY `acat_lang_id` (`acat_lang_id`),
  KEY `acat_opengraph` (`acat_opengraph`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_articlecontent`
--

CREATE TABLE `[[dbprefix]]phpwcms_articlecontent` (
  `acontent_id` int(11) NOT NULL AUTO_INCREMENT,
  `acontent_aid` int(11) NOT NULL DEFAULT '0',
  `acontent_uid` int(11) NOT NULL DEFAULT '0',
  `acontent_created` timestamp NULL DEFAULT NULL,
  `acontent_tstamp` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `acontent_title` text NOT NULL,
  `acontent_text` mediumtext NOT NULL,
  `acontent_type` int(10) NOT NULL DEFAULT '0',
  `acontent_sorting` int(11) NOT NULL DEFAULT '0',
  `acontent_image` text NOT NULL,
  `acontent_files` text NOT NULL,
  `acontent_visible` int(1) NOT NULL DEFAULT '0',
  `acontent_subtitle` text NOT NULL,
  `acontent_before` varchar(10) NOT NULL DEFAULT '',
  `acontent_after` varchar(10) NOT NULL DEFAULT '',
  `acontent_top` int(1) NOT NULL DEFAULT '0',
  `acontent_redirect` text NOT NULL,
  `acontent_html` mediumtext NOT NULL,
  `acontent_trash` int(1) NOT NULL DEFAULT '0',
  `acontent_alink` text NOT NULL,
  `acontent_media` mediumtext NOT NULL,
  `acontent_form` mediumtext NOT NULL,
  `acontent_newsletter` mediumtext NOT NULL,
  `acontent_block` varchar(200) NOT NULL DEFAULT 'CONTENT',
  `acontent_anchor` int(1) NOT NULL DEFAULT '0',
  `acontent_template` varchar(255) NOT NULL DEFAULT '',
  `acontent_spacer` int(1) NOT NULL DEFAULT '0',
  `acontent_tid` int(11) NOT NULL DEFAULT '0',
  `acontent_livedate` datetime DEFAULT NULL,
  `acontent_killdate` datetime DEFAULT NULL,
  `acontent_module` varchar(255) NOT NULL DEFAULT '',
  `acontent_comment` text NOT NULL,
  `acontent_paginate_page` int(5) NOT NULL DEFAULT '0',
  `acontent_paginate_title` varchar(2000) NOT NULL DEFAULT '',
  `acontent_category` varchar(255) NOT NULL DEFAULT '',
  `acontent_granted` int(11) NOT NULL DEFAULT '0',
  `acontent_tab` varchar(2000) NOT NULL DEFAULT '',
  `acontent_lang` varchar(255) NOT NULL DEFAULT '',
  `acontent_attr_class` varchar(255) NOT NULL DEFAULT '',
  `acontent_attr_id` varchar(255) NOT NULL DEFAULT '',
  `acontent_setting` mediumtext,
  `acontent_type_setting` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`acontent_id`),
  KEY `acontent_aid` (`acontent_aid`),
  KEY `acontent_sorting` (`acontent_sorting`),
  KEY `acontent_type` (`acontent_type`),
  KEY `acontent_livedate` (`acontent_livedate`,`acontent_killdate`),
  KEY `acontent_paginate` (`acontent_paginate_page`),
  KEY `acontent_granted` (`acontent_granted`),
  KEY `acontent_lang` (`acontent_lang`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_cache`
--

CREATE TABLE `[[dbprefix]]phpwcms_cache` (
  `cache_id` int(11) NOT NULL AUTO_INCREMENT,
  `cache_hash` varchar(50) NOT NULL DEFAULT '',
  `cache_uri` text NOT NULL,
  `cache_cid` int(11) NOT NULL DEFAULT '0',
  `cache_aid` int(11) NOT NULL DEFAULT '0',
  `cache_timeout` varchar(20) NOT NULL DEFAULT '0',
  `cache_isprint` int(1) NOT NULL DEFAULT '0',
  `cache_changed` int(14) DEFAULT NULL,
  `cache_use` int(1) NOT NULL DEFAULT '0',
  `cache_searchable` int(1) NOT NULL DEFAULT '0',
  `cache_page` longtext NOT NULL,
  `cache_stripped` longtext NOT NULL,
  PRIMARY KEY (`cache_id`),
  KEY `cache_hash` (`cache_hash`),
  FULLTEXT KEY `cache_stripped` (`cache_stripped`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_calendar`
--

CREATE TABLE `[[dbprefix]]phpwcms_calendar` (
  `calendar_id` int(11) NOT NULL AUTO_INCREMENT,
  `calendar_created` datetime DEFAULT NULL,
  `calendar_changed` datetime DEFAULT NULL,
  `calendar_status` int(1) NOT NULL DEFAULT '0',
  `calendar_start` datetime DEFAULT NULL,
  `calendar_end` datetime DEFAULT NULL,
  `calendar_allday` int(1) NOT NULL DEFAULT '0',
  `calendar_range` int(1) NOT NULL DEFAULT '0',
  `calendar_range_start` date DEFAULT NULL,
  `calendar_range_end` date DEFAULT NULL,
  `calendar_title` varchar(255) NOT NULL DEFAULT '',
  `calendar_where` varchar(255) NOT NULL DEFAULT '',
  `calendar_teaser` text NOT NULL,
  `calendar_text` mediumtext NOT NULL,
  `calendar_tag` varchar(255) NOT NULL DEFAULT '',
  `calendar_object` longtext NOT NULL,
  `calendar_refid` varchar(1000) NOT NULL DEFAULT '',
  `calendar_lang` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`calendar_id`),
  KEY `calendar_status` (`calendar_status`),
  KEY `calendar_start` (`calendar_start`),
  KEY `calendar_end` (`calendar_end`),
  KEY `calendar_tag` (`calendar_tag`),
  KEY `calendar_refid` (`calendar_refid`(768)),
  KEY `calendar_range` (`calendar_range`),
  KEY `calendar_lang` (`calendar_lang`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_categories`
--

CREATE TABLE `[[dbprefix]]phpwcms_categories` (
  `cat_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cat_type` varchar(255) NOT NULL DEFAULT '',
  `cat_pid` int(11) NOT NULL DEFAULT '0',
  `cat_status` int(1) NOT NULL DEFAULT '0',
  `cat_createdate` datetime DEFAULT NULL,
  `cat_changedate` datetime DEFAULT NULL,
  `cat_name` varchar(255) NOT NULL DEFAULT '',
  `cat_info` text NOT NULL,
  `cat_sort` int(11) NOT NULL DEFAULT '0',
  `cat_opengraph` int(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`cat_id`),
  KEY `cat_type` (`cat_type`,`cat_status`),
  KEY `cat_pid` (`cat_pid`),
  KEY `cat_sort` (`cat_sort`),
  KEY `cat_opengraph` (`cat_opengraph`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_chat`
--

CREATE TABLE `[[dbprefix]]phpwcms_chat` (
  `chat_id` int(11) NOT NULL AUTO_INCREMENT,
  `chat_uid` int(11) NOT NULL DEFAULT '0',
  `chat_name` varchar(30) NOT NULL DEFAULT '',
  `chat_tstamp` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `chat_text` varchar(255) NOT NULL DEFAULT '',
  `chat_cat` int(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`chat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_content`
--

CREATE TABLE `[[dbprefix]]phpwcms_content` (
  `cnt_id` int(11) NOT NULL AUTO_INCREMENT,
  `cnt_pid` int(11) NOT NULL DEFAULT '0',
  `cnt_created` int(11) NOT NULL DEFAULT '0',
  `cnt_changed` int(11) NOT NULL DEFAULT '0',
  `cnt_status` int(1) NOT NULL DEFAULT '0',
  `cnt_type` varchar(255) NOT NULL DEFAULT '',
  `cnt_module` varchar(255) NOT NULL DEFAULT '',
  `cnt_group` int(11) NOT NULL DEFAULT '0',
  `cnt_owner` int(11) NOT NULL DEFAULT '0',
  `cnt_livedate` datetime DEFAULT NULL,
  `cnt_killdate` datetime DEFAULT NULL,
  `cnt_archive_status` int(11) NOT NULL DEFAULT '0',
  `cnt_sort` int(11) NOT NULL DEFAULT '0',
  `cnt_prio` int(11) NOT NULL DEFAULT '0',
  `cnt_alias` varchar(255) NOT NULL DEFAULT '',
  `cnt_name` varchar(255) NOT NULL DEFAULT '',
  `cnt_title` varchar(255) NOT NULL DEFAULT '',
  `cnt_subtitle` varchar(255) NOT NULL DEFAULT '',
  `cnt_editor` varchar(255) NOT NULL DEFAULT '',
  `cnt_place` varchar(255) NOT NULL DEFAULT '',
  `cnt_teasertext` text NOT NULL,
  `cnt_text` text NOT NULL,
  `cnt_lang` varchar(10) NOT NULL DEFAULT '',
  `cnt_object` text NOT NULL,
  `cnt_opengraph` int(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`cnt_id`),
  KEY `cnt_livedate` (`cnt_livedate`),
  KEY `cnt_killdate` (`cnt_killdate`),
  KEY `cnt_module` (`cnt_module`),
  KEY `cnt_type` (`cnt_type`),
  KEY `cnt_group` (`cnt_group`),
  KEY `cnt_owner` (`cnt_owner`),
  KEY `cnt_alias` (`cnt_alias`),
  KEY `cnt_pid` (`cnt_pid`),
  KEY `cnt_sort` (`cnt_sort`),
  KEY `cnt_prio` (`cnt_prio`),
  KEY `cnt_opengraph` (`cnt_opengraph`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_country`
--

CREATE TABLE `[[dbprefix]]phpwcms_country` (
  `country_id` int(4) NOT NULL AUTO_INCREMENT,
  `country_updated` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `country_iso` char(2) NOT NULL DEFAULT '',
  `country_iso3` char(3) NOT NULL DEFAULT '',
  `country_isonum` int(11) NOT NULL DEFAULT '0',
  `country_continent_code` char(2) NOT NULL DEFAULT '',
  `country_name` varchar(255) NOT NULL DEFAULT '',
  `country_name_de` varchar(255) NOT NULL DEFAULT '',
  `country_continent` varchar(255) NOT NULL DEFAULT '',
  `country_continent_de` varchar(255) NOT NULL DEFAULT '',
  `country_region` varchar(255) NOT NULL DEFAULT '',
  `country_region_de` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`country_id`),
  UNIQUE KEY `country_iso` (`country_iso`),
  UNIQUE KEY `country_name` (`country_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=249 ;

--
-- Dumping data for table `[[dbprefix]]phpwcms_country`
--

INSERT INTO `[[dbprefix]]phpwcms_country` VALUES
(1, '[[regtime]]', 'AF', 'AFG', 4, 'AS', 'Afghanistan, Islamic Republic of', 'Afghanistan', 'Asia', 'Asien', '', ''),
(2, '[[regtime]]', 'AL', 'ALB', 8, 'EU', 'Albania, Republic of', 'Albanien', 'Europe', 'Europa', '', ''),
(3, '[[regtime]]', 'DZ', 'DZA', 12, 'AF', 'Algeria, People''s Democratic Republic of', 'Algerien', 'Africa', 'Afrika', '', ''),
(4, '[[regtime]]', 'AS', 'ASM', 16, 'OC', 'American Samoa', 'Amerikanisch Samoa', 'Oceania', 'Ozeanien', '', ''),
(5, '[[regtime]]', 'AD', 'AND', 20, 'EU', 'Andorra, Principality of', 'Andorra', 'Europe', 'Europa', '', ''),
(6, '[[regtime]]', 'AO', 'AGO', 24, 'AF', 'Angola, Republic of', 'Angola', 'Africa', 'Afrika', '', ''),
(7, '[[regtime]]', 'AI', 'AIA', 660, 'NA', 'Anguilla', 'Anguilla', 'North America', 'Nordamerika', '', ''),
(8, '[[regtime]]', 'AQ', 'ATA', 10, 'AN', 'Antarctica (the territory South of 60 deg S)', 'Antarktis', 'Antarctica', 'Antarktis', '', ''),
(9, '[[regtime]]', 'AG', 'ATG', 28, 'NA', 'Antigua and Barbuda', 'Antigua und Barbuda', 'North America', 'Nordamerika', '', ''),
(10, '[[regtime]]', 'AR', 'ARG', 32, 'SA', 'Argentina, Argentine Republic', 'Argentinien', 'South America', 'Südamerika', '', ''),
(11, '[[regtime]]', 'AM', 'ARM', 51, 'AS', 'Armenia, Republic of', 'Armenien', 'Asia', 'Asien', '', ''),
(12, '[[regtime]]', 'AW', 'ABW', 533, 'NA', 'Aruba', 'Aruba', 'North America', 'Nordamerika', '', ''),
(13, '[[regtime]]', 'AU', 'AUS', 36, 'OC', 'Australia, Commonwealth of', 'Australien', 'Oceania', 'Ozeanien', '', ''),
(14, '[[regtime]]', 'AT', 'AUT', 40, 'EU', 'Austria, Republic of', 'Österreich', 'Europe', 'Europa', '', ''),
(15, '[[regtime]]', 'AZ', 'AZE', 31, 'AS', 'Azerbaijan, Republic of', 'Aserbaidschan', 'Asia', 'Asien', '', ''),
(16, '[[regtime]]', 'BS', 'BHS', 44, 'NA', 'Bahamas, Commonwealth of the', 'Bahamas', 'North America', 'Nordamerika', '', ''),
(17, '[[regtime]]', 'BH', 'BHR', 48, 'AS', 'Bahrain, Kingdom of', 'Bahrain', 'Asia', 'Asien', '', ''),
(18, '[[regtime]]', 'BD', 'BGD', 50, 'AS', 'Bangladesh, People''s Republic of', 'Bangladesch', 'Asia', 'Asien', '', ''),
(19, '[[regtime]]', 'BB', 'BRB', 52, 'NA', 'Barbados', 'Barbados', 'North America', 'Nordamerika', '', ''),
(20, '[[regtime]]', 'BY', 'BLR', 112, 'EU', 'Belarus, Republic of', 'Belarus', 'Europe', 'Europa', '', ''),
(21, '[[regtime]]', 'BE', 'BEL', 56, 'EU', 'Belgium, Kingdom of', 'Belgien', 'Europe', 'Europa', '', ''),
(22, '[[regtime]]', 'BZ', 'BLZ', 84, 'NA', 'Belize', 'Belize', 'North America', 'Nordamerika', '', ''),
(23, '[[regtime]]', 'BJ', 'BEN', 204, 'AF', 'Benin, Republic of', 'Benin', 'Africa', 'Afrika', '', ''),
(24, '[[regtime]]', 'BM', 'BMU', 60, 'NA', 'Bermuda', 'Bermuda', 'North America', 'Nordamerika', '', ''),
(25, '[[regtime]]', 'BT', 'BTN', 64, 'AS', 'Bhutan, Kingdom of', 'Bhutan', 'Asia', 'Asien', '', ''),
(26, '[[regtime]]', 'BO', 'BOL', 68, 'SA', 'Bolivia, Republic of', 'Bolivien', 'South America', 'Südamerika', '', ''),
(27, '[[regtime]]', 'BA', 'BIH', 70, 'EU', 'Bosnia and Herzegovina', 'Bosnien und Herzegowina', 'Europe', 'Europa', '', ''),
(28, '[[regtime]]', 'BW', 'BWA', 72, 'AF', 'Botswana, Republic of', 'Botsuana', 'Africa', 'Afrika', '', ''),
(29, '[[regtime]]', 'BV', 'BVT', 74, 'AN', 'Bouvet Island (Bouvetoya)', 'Bouvet-Insel', 'Antarctica', 'Antarktis', '', ''),
(30, '[[regtime]]', 'BR', 'BRA', 76, 'SA', 'Brazil, Federative Republic of', 'Brasilien', 'South America', 'Südamerika', '', ''),
(31, '[[regtime]]', 'IO', 'IOT', 86, 'AS', 'British Indian Ocean Territory (Chagos Archipelago)', 'Britisches Territorium Im Indischen Ozean', 'Asia', 'Asien', '', ''),
(32, '[[regtime]]', 'BN', 'BRN', 96, 'AS', 'Brunei Darussalam', 'Brunei Darussalam', 'Asia', 'Asien', '', ''),
(33, '[[regtime]]', 'BG', 'BGR', 100, 'EU', 'Bulgaria, Republic of', 'Bulgarien', 'Europe', 'Europa', '', ''),
(34, '[[regtime]]', 'BF', 'BFA', 854, 'AF', 'Burkina Faso', 'Burkina Faso', 'Africa', 'Afrika', '', ''),
(35, '[[regtime]]', 'BI', 'BDI', 108, 'AF', 'Burundi, Republic of', 'Burundi', 'Africa', 'Afrika', '', ''),
(36, '[[regtime]]', 'KH', 'KHM', 116, 'AS', 'Cambodia, Kingdom of', 'Kambodscha', 'Asia', 'Asien', '', ''),
(37, '[[regtime]]', 'CM', 'CMR', 120, 'AF', 'Cameroon, Republic of', 'Kamerun', 'Africa', 'Afrika', '', ''),
(38, '[[regtime]]', 'CA', 'CAN', 124, 'NA', 'Canada', 'Kanada', 'North America', 'Nordamerika', '', ''),
(39, '[[regtime]]', 'CV', 'CPV', 132, 'AF', 'Cape Verde, Republic of', 'Kap Verde', 'Africa', 'Afrika', '', ''),
(40, '[[regtime]]', 'KY', 'CYM', 136, 'NA', 'Cayman Islands', 'Kaimaninseln', 'North America', 'Nordamerika', '', ''),
(41, '[[regtime]]', 'CF', 'CAF', 140, 'AF', 'Central African Republic', 'Zentralafrikanische Republik', 'Africa', 'Afrika', '', ''),
(42, '[[regtime]]', 'TD', 'TCD', 148, 'AF', 'Chad, Republic of', 'Tschad', 'Africa', 'Afrika', '', ''),
(43, '[[regtime]]', 'CL', 'CHL', 152, 'SA', 'Chile, Republic of', 'Chile', 'South America', 'Südamerika', '', ''),
(44, '[[regtime]]', 'CN', 'CHN', 156, 'AS', 'China, People''s Republic of', 'China', 'Asia', 'Asien', '', ''),
(45, '[[regtime]]', 'CX', 'CXR', 162, 'AS', 'Christmas Island', 'Weihnachtsinsel', 'Asia', 'Asien', '', ''),
(46, '[[regtime]]', 'CC', 'CCK', 166, 'AS', 'Cocos (Keeling) Islands', 'Kokosinseln (Keelingsinseln)', 'Asia', 'Asien', '', ''),
(47, '[[regtime]]', 'CO', 'COL', 170, 'SA', 'Colombia, Republic of', 'Kolumbien', 'South America', 'Südamerika', '', ''),
(48, '[[regtime]]', 'KM', 'COM', 174, 'AF', 'Comoros, Union of the', 'Komoren', 'Africa', 'Afrika', '', ''),
(49, '[[regtime]]', 'CG', 'COG', 178, 'AF', 'Congo, Republic of the', 'Kongo', 'Africa', 'Afrika', '', ''),
(50, '[[regtime]]', 'CD', 'COD', 180, 'AF', 'Congo, Democratic Republic of the', 'Kongo, Demokratische Republik', 'Africa', 'Afrika', '', ''),
(51, '[[regtime]]', 'CK', 'COK', 184, 'OC', 'Cook Islands', 'Cook-Inseln', 'Oceania', 'Ozeanien', '', ''),
(52, '[[regtime]]', 'CR', 'CRI', 188, 'NA', 'Costa Rica, Republic of', 'Costa Rica', 'North America', 'Nordamerika', '', ''),
(53, '[[regtime]]', 'CI', 'CIV', 384, 'AF', 'Cote d''Ivoire, Republic of', 'Côte D''Ivoire', 'Africa', 'Afrika', '', ''),
(54, '[[regtime]]', 'HR', 'HRV', 191, 'EU', 'Croatia, Republic of', 'Kroatien', 'Europe', 'Europa', '', ''),
(55, '[[regtime]]', 'CU', 'CUB', 192, 'NA', 'Cuba, Republic of', 'Kuba', 'North America', 'Nordamerika', '', ''),
(56, '[[regtime]]', 'CY', 'CYP', 196, 'AS', 'Cyprus, Republic of', 'Zypern', 'Asia', 'Asien', '', ''),
(57, '[[regtime]]', 'CZ', 'CZE', 203, 'EU', 'Czech Republic', 'Tschechische Republik', 'Europe', 'Europa', '', ''),
(58, '[[regtime]]', 'DK', 'DNK', 208, 'EU', 'Denmark, Kingdom of', 'Dänemark', 'Europe', 'Europa', '', ''),
(59, '[[regtime]]', 'DJ', 'DJI', 262, 'AF', 'Djibouti, Republic of', 'Dschibuti', 'Africa', 'Afrika', '', ''),
(60, '[[regtime]]', 'DM', 'DMA', 212, 'NA', 'Dominica, Commonwealth of', 'Dominica', 'North America', 'Nordamerika', '', ''),
(61, '[[regtime]]', 'DO', 'DOM', 214, 'NA', 'Dominican Republic', 'Dominikanische Republik', 'North America', 'Nordamerika', '', ''),
(63, '[[regtime]]', 'EC', 'ECU', 218, 'SA', 'Ecuador, Republic of', 'Ecuador', 'South America', 'Südamerika', '', ''),
(64, '[[regtime]]', 'EG', 'EGY', 818, 'AF', 'Egypt, Arab Republic of', 'Ägypten', 'Africa', 'Afrika', '', ''),
(65, '[[regtime]]', 'SV', 'SLV', 222, 'NA', 'El Salvador, Republic of', 'El Salvador', 'North America', 'Nordamerika', '', ''),
(66, '[[regtime]]', 'GQ', 'GNQ', 226, 'AF', 'Equatorial Guinea, Republic of', 'Äquatorialguinea', 'Africa', 'Afrika', '', ''),
(67, '[[regtime]]', 'ER', 'ERI', 232, 'AF', 'Eritrea, State of', 'Eritrea', 'Africa', 'Afrika', '', ''),
(68, '[[regtime]]', 'EE', 'EST', 233, 'EU', 'Estonia, Republic of', 'Estland', 'Europe', 'Europa', '', ''),
(69, '[[regtime]]', 'ET', 'ETH', 231, 'AF', 'Ethiopia, Federal Democratic Republic of', 'Äthiopien', 'Africa', 'Afrika', '', ''),
(70, '[[regtime]]', 'FK', 'FLK', 238, 'SA', 'Falkland Islands (Malvinas)', 'Falkland-Inseln (Malvinen)', 'South America', 'Südamerika', '', ''),
(71, '[[regtime]]', 'FO', 'FRO', 234, 'EU', 'Faroe Islands', 'Färöer', 'Europe', 'Europa', '', ''),
(72, '[[regtime]]', 'FJ', 'FJI', 242, 'OC', 'Fiji, Republic of the Fiji Islands', 'Fidschi', 'Oceania', 'Ozeanien', '', ''),
(73, '[[regtime]]', 'FI', 'FIN', 246, 'EU', 'Finland, Republic of', 'Finnland', 'Europe', 'Europa', '', ''),
(74, '[[regtime]]', 'FR', 'FRA', 250, 'EU', 'France, French Republic', 'Frankreich', 'Europe', 'Europa', '', ''),
(75, '[[regtime]]', 'GF', 'GUF', 254, 'SA', 'French Guiana', 'Französisch Guayana', 'South America', 'Südamerika', '', ''),
(76, '[[regtime]]', 'PF', 'PYF', 258, 'OC', 'French Polynesia', 'Französisch Polynesien', 'Oceania', 'Ozeanien', '', ''),
(77, '[[regtime]]', 'TF', 'ATF', 260, 'AN', 'French Southern Territories', 'Französische Südgebiete', 'Antarctica', 'Antarktis', '', ''),
(78, '[[regtime]]', 'GA', 'GAB', 266, 'AF', 'Gabon, Gabonese Republic', 'Gabun', 'Africa', 'Afrika', '', ''),
(79, '[[regtime]]', 'GM', 'GMB', 270, 'AF', 'Gambia, Republic of the', 'Gambia', 'Africa', 'Afrika', '', ''),
(80, '[[regtime]]', 'GE', 'GEO', 268, 'AS', 'Georgia', 'Georgien', 'Asia', 'Asien', '', ''),
(81, '[[regtime]]', 'DE', 'DEU', 276, 'EU', 'Germany, Federal Republic of', 'Deutschland', 'Europe', 'Europa', '', ''),
(82, '[[regtime]]', 'GH', 'GHA', 288, 'AF', 'Ghana, Republic of', 'Ghana', 'Africa', 'Afrika', '', ''),
(83, '[[regtime]]', 'GI', 'GIB', 292, 'EU', 'Gibraltar', 'Gibraltar', 'Europe', 'Europa', '', ''),
(84, '[[regtime]]', 'GR', 'GRC', 300, 'EU', 'Greece, Hellenic Republic', 'Griechenland', 'Europe', 'Europa', '', ''),
(85, '[[regtime]]', 'GL', 'GRL', 304, 'NA', 'Greenland', 'Grönland', 'North America', 'Nordamerika', '', ''),
(86, '[[regtime]]', 'GD', 'GRD', 308, 'NA', 'Grenada', 'Grenada', 'North America', 'Nordamerika', '', ''),
(87, '[[regtime]]', 'GP', 'GLP', 312, 'NA', 'Guadeloupe', 'Guadeloupe', 'North America', 'Nordamerika', '', ''),
(88, '[[regtime]]', 'GU', 'GUM', 316, 'OC', 'Guam', 'Guam', 'Oceania', 'Ozeanien', '', ''),
(89, '[[regtime]]', 'GT', 'GTM', 320, 'NA', 'Guatemala, Republic of', 'Guatemala', 'North America', 'Nordamerika', '', ''),
(90, '[[regtime]]', 'GN', 'GIN', 324, 'AF', 'Guinea, Republic of', 'Guinea', 'Africa', 'Afrika', '', ''),
(91, '[[regtime]]', 'GW', 'GNB', 624, 'AF', 'Guinea-Bissau, Republic of', 'Guinea-Bissau', 'Africa', 'Afrika', '', ''),
(92, '[[regtime]]', 'GY', 'GUY', 328, 'SA', 'Guyana, Co-operative Republic of', 'Guyana', 'South America', 'Südamerika', '', ''),
(93, '[[regtime]]', 'HT', 'HTI', 332, 'NA', 'Haiti, Republic of', 'Haiti', 'North America', 'Nordamerika', '', ''),
(94, '[[regtime]]', 'HM', 'HMD', 334, 'AN', 'Heard Island and McDonald Islands', 'Heard und McDonald', 'Antarctica', 'Antarktis', '', ''),
(95, '[[regtime]]', 'VA', 'VAT', 336, 'EU', 'Holy See (Vatican City State)', 'Vatikanstadt, Staat (Heiliger Stuhl)', 'Europe', 'Europa', '', ''),
(96, '[[regtime]]', 'HN', 'HND', 340, 'NA', 'Honduras, Republic of', 'Honduras', 'North America', 'Nordamerika', '', ''),
(97, '[[regtime]]', 'HK', 'HKG', 344, 'AS', 'Hong Kong, Special Administrative Region of China', 'Hongkong', 'Asia', 'Asien', '', ''),
(98, '[[regtime]]', 'HU', 'HUN', 348, 'EU', 'Hungary, Republic of', 'Ungarn', 'Europe', 'Europa', '', ''),
(99, '[[regtime]]', 'IS', 'ISL', 352, 'EU', 'Iceland, Republic of', 'Island', 'Europe', 'Europa', '', ''),
(100, '[[regtime]]', 'IN', 'IND', 356, 'AS', 'India, Republic of', 'Indien', 'Asia', 'Asien', '', ''),
(101, '[[regtime]]', 'ID', 'IDN', 360, 'AS', 'Indonesia, Republic of', 'Indonesien', 'Asia', 'Asien', '', ''),
(102, '[[regtime]]', 'IR', 'IRN', 364, 'AS', 'Iran, Islamic Republic of', 'Iran (Islamische Republik)', 'Asia', 'Asien', '', ''),
(103, '[[regtime]]', 'IQ', 'IRQ', 368, 'AS', 'Iraq, Republic of', 'Irak', 'Asia', 'Asien', '', ''),
(104, '[[regtime]]', 'IE', 'IRL', 372, 'EU', 'Ireland', 'Irland', 'Europe', 'Europa', '', ''),
(105, '[[regtime]]', 'IL', 'ISR', 376, 'AS', 'Israel, State of', 'Israel', 'Asia', 'Asien', '', ''),
(106, '[[regtime]]', 'IT', 'ITA', 380, 'EU', 'Italy, Italian Republic', 'Italien', 'Europe', 'Europa', '', ''),
(107, '[[regtime]]', 'JM', 'JAM', 388, 'NA', 'Jamaica', 'Jamaika', 'North America', 'Nordamerika', '', ''),
(108, '[[regtime]]', 'JP', 'JPN', 392, 'AS', 'Japan', 'Japan', 'Asia', 'Asien', '', ''),
(109, '[[regtime]]', 'JO', 'JOR', 400, 'AS', 'Jordan, Hashemite Kingdom of', 'Jordanien', 'Asia', 'Asien', '', ''),
(110, '[[regtime]]', 'KZ', 'KAZ', 398, 'AS', 'Kazakhstan, Republic of', 'Kasachstan', 'Asia', 'Asien', '', ''),
(111, '[[regtime]]', 'KE', 'KEN', 404, 'AF', 'Kenya, Republic of', 'Kenia', 'Africa', 'Afrika', '', ''),
(112, '[[regtime]]', 'KI', 'KIR', 296, 'OC', 'Kiribati, Republic of', 'Kiribati', 'Oceania', 'Ozeanien', '', ''),
(113, '[[regtime]]', 'KP', 'PRK', 408, 'AS', 'Korea, Democratic People''s Republic of', 'Korea, Demokratische Volksrepublik', 'Asia', 'Asien', '', ''),
(114, '[[regtime]]', 'KR', 'KOR', 410, 'AS', 'Korea, Republic of', 'Korea, Republik', 'Asia', 'Asien', '', ''),
(115, '[[regtime]]', 'KW', 'KWT', 414, 'AS', 'Kuwait, State of', 'Kuwait', 'Asia', 'Asien', '', ''),
(116, '[[regtime]]', 'KG', 'KGZ', 417, 'AS', 'Kyrgyz Republic', 'Kirgisistan', 'Asia', 'Asien', '', ''),
(117, '[[regtime]]', 'LA', 'LAO', 418, 'AS', 'Lao People''s Democratic Republic', 'Laos, Demokratische Volksrepublik', 'Asia', 'Asien', '', ''),
(118, '[[regtime]]', 'LV', 'LVA', 428, 'EU', 'Latvia, Republic of', 'Lettland', 'Europe', 'Europa', '', ''),
(119, '[[regtime]]', 'LB', 'LBN', 422, 'AS', 'Lebanon, Lebanese Republic', 'Libanon', 'Asia', 'Asien', '', ''),
(120, '[[regtime]]', 'LS', 'LSO', 426, 'AF', 'Lesotho, Kingdom of', 'Lesotho', 'Africa', 'Afrika', '', ''),
(121, '[[regtime]]', 'LR', 'LBR', 430, 'AF', 'Liberia, Republic of', 'Liberia', 'Africa', 'Afrika', '', ''),
(122, '[[regtime]]', 'LY', 'LBY', 434, 'AF', 'Libyan Arab Jamahiriya', 'Libysch-Arabische Dschamahirija', 'Africa', 'Afrika', '', ''),
(123, '[[regtime]]', 'LI', 'LIE', 438, 'EU', 'Liechtenstein, Principality of', 'Liechtenstein', 'Europe', 'Europa', '', ''),
(124, '[[regtime]]', 'LT', 'LTU', 440, 'EU', 'Lithuania, Republic of', 'Litauen', 'Europe', 'Europa', '', ''),
(125, '[[regtime]]', 'LU', 'LUX', 442, 'EU', 'Luxembourg, Grand Duchy of', 'Luxembourg', 'Europe', 'Europa', '', ''),
(126, '[[regtime]]', 'MO', 'MAC', 446, 'AS', 'Macao, Special Administrative Region of China', 'Macau', 'Asia', 'Asien', '', ''),
(127, '[[regtime]]', 'MK', 'MKD', 807, 'EU', 'Macedonia, the former Yugoslav Republic of', 'Mazedonien, Ehemalige Jugoslawische Republik', 'Europe', 'Europa', '', ''),
(128, '[[regtime]]', 'MG', 'MDG', 450, 'AF', 'Madagascar, Republic of', 'Madagaskar', 'Africa', 'Afrika', '', ''),
(129, '[[regtime]]', 'MW', 'MWI', 454, 'AF', 'Malawi, Republic of', 'Malawi', 'Africa', 'Afrika', '', ''),
(130, '[[regtime]]', 'MY', 'MYS', 458, 'AS', 'Malaysia', 'Malaysia', 'Asia', 'Asien', '', ''),
(131, '[[regtime]]', 'MV', 'MDV', 462, 'AS', 'Maldives, Republic of', 'Malediven', 'Asia', 'Asien', '', ''),
(132, '[[regtime]]', 'ML', 'MLI', 466, 'AF', 'Mali, Republic of', 'Mali', 'Africa', 'Afrika', '', ''),
(133, '[[regtime]]', 'MT', 'MLT', 470, 'EU', 'Malta, Republic of', 'Malta', 'Europe', 'Europa', '', ''),
(134, '[[regtime]]', 'MH', 'MHL', 584, 'OC', 'Marshall Islands, Republic of the', 'Marshallinseln', 'Oceania', 'Ozeanien', '', ''),
(135, '[[regtime]]', 'MQ', 'MTQ', 474, 'NA', 'Martinique', 'Martinique', 'North America', 'Nordamerika', '', ''),
(136, '[[regtime]]', 'MR', 'MRT', 478, 'AF', 'Mauritania, Islamic Republic of', 'Mauretanien', 'Africa', 'Afrika', '', ''),
(137, '[[regtime]]', 'MU', 'MUS', 480, 'AF', 'Mauritius, Republic of', 'Mauritius', 'Africa', 'Afrika', '', ''),
(138, '[[regtime]]', 'YT', 'MYT', 175, 'AF', 'Mayotte', 'Mayotte', 'Africa', 'Afrika', '', ''),
(139, '[[regtime]]', 'MX', 'MEX', 484, 'NA', 'Mexico, United Mexican States', 'Mexiko', 'North America', 'Nordamerika', '', ''),
(140, '[[regtime]]', 'FM', 'FSM', 583, 'OC', 'Micronesia, Federated States of', 'Mikronesien, Föderierte Staaten Von', 'Oceania', 'Ozeanien', '', ''),
(141, '[[regtime]]', 'MD', 'MDA', 498, 'EU', 'Moldova, Republic of', 'Moldau, Republik', 'Europe', 'Europa', '', ''),
(142, '[[regtime]]', 'MC', 'MCO', 492, 'EU', 'Monaco, Principality of', 'Monaco', 'Europe', 'Europa', '', ''),
(143, '[[regtime]]', 'MN', 'MNG', 496, 'AS', 'Mongolia', 'Mongolei', 'Asia', 'Asien', '', ''),
(144, '[[regtime]]', 'MS', 'MSR', 500, 'NA', 'Montserrat', 'Montserrat', 'North America', 'Nordamerika', '', ''),
(145, '[[regtime]]', 'MA', 'MAR', 504, 'AF', 'Morocco, Kingdom of', 'Marokko', 'Africa', 'Afrika', '', ''),
(146, '[[regtime]]', 'MZ', 'MOZ', 508, 'AF', 'Mozambique, Republic of', 'Mosambik', 'Africa', 'Afrika', '', ''),
(147, '[[regtime]]', 'MM', 'MMR', 104, 'AS', 'Myanmar, Union of', 'Myanmar', 'Asia', 'Asien', '', ''),
(148, '[[regtime]]', 'NA', 'NAM', 516, 'AF', 'Namibia, Republic of', 'Namibia', 'Africa', 'Afrika', '', ''),
(149, '[[regtime]]', 'NR', 'NRU', 520, 'OC', 'Nauru, Republic of', 'Nauru', 'Oceania', 'Ozeanien', '', ''),
(150, '[[regtime]]', 'NP', 'NPL', 524, 'AS', 'Nepal, State of', 'Nepal', 'Asia', 'Asien', '', ''),
(151, '[[regtime]]', 'NL', 'NLD', 528, 'EU', 'Netherlands, Kingdom of the', 'Niederlande', 'Europe', 'Europa', '', ''),
(152, '[[regtime]]', 'AN', 'ANT', 530, 'NA', 'Netherlands Antilles', 'Niederländische Antillen', 'North America', 'Nordamerika', '', ''),
(153, '[[regtime]]', 'NC', 'NCL', 540, 'OC', 'New Caledonia', 'Neukaledonien', 'Oceania', 'Ozeanien', '', ''),
(154, '[[regtime]]', 'NZ', 'NZL', 554, 'OC', 'New Zealand', 'Neuseeland', 'Oceania', 'Ozeanien', '', ''),
(155, '[[regtime]]', 'NI', 'NIC', 558, 'NA', 'Nicaragua, Republic of', 'Nicaragua', 'North America', 'Nordamerika', '', ''),
(156, '[[regtime]]', 'NE', 'NER', 562, 'AF', 'Niger, Republic of', 'Niger', 'Africa', 'Afrika', '', ''),
(157, '[[regtime]]', 'NG', 'NGA', 566, 'AF', 'Nigeria, Federal Republic of', 'Nigeria', 'Africa', 'Afrika', '', ''),
(158, '[[regtime]]', 'NU', 'NIU', 570, 'OC', 'Niue', 'Niue', 'Oceania', 'Ozeanien', '', ''),
(159, '[[regtime]]', 'NF', 'NFK', 574, 'OC', 'Norfolk Island', 'Norfolk-Insel', 'Oceania', 'Ozeanien', '', ''),
(160, '[[regtime]]', 'MP', 'MNP', 580, 'OC', 'Northern Mariana Islands, Commonwealth of the', 'Nördliche Marianen', 'Oceania', 'Ozeanien', '', ''),
(161, '[[regtime]]', 'NO', 'NOR', 578, 'EU', 'Norway, Kingdom of', 'Norwegen', 'Europe', 'Europa', '', ''),
(162, '[[regtime]]', 'OM', 'OMN', 512, 'AS', 'Oman, Sultanate of', 'Oman', 'Asia', 'Asien', '', ''),
(163, '[[regtime]]', 'PK', 'PAK', 586, 'AS', 'Pakistan, Islamic Republic of', 'Pakistan', 'Asia', 'Asien', '', ''),
(164, '[[regtime]]', 'PW', 'PLW', 585, 'OC', 'Palau, Republic of', 'Palau', 'Oceania', 'Ozeanien', '', ''),
(165, '[[regtime]]', 'PS', 'PSE', 275, 'AS', 'Palestinian Territory, Occupied', 'Palästina', 'Asia', 'Asien', '', ''),
(166, '[[regtime]]', 'PA', 'PAN', 591, 'NA', 'Panama, Republic of', 'Panama', 'North America', 'Nordamerika', '', ''),
(167, '[[regtime]]', 'PG', 'PNG', 598, 'OC', 'Papua New Guinea, Independent State of', 'Papua-Neuguinea', 'Oceania', 'Ozeanien', '', ''),
(168, '[[regtime]]', 'PY', 'PRY', 600, 'SA', 'Paraguay, Republic of', 'Paraguay', 'South America', 'Südamerika', '', ''),
(169, '[[regtime]]', 'PE', 'PER', 604, 'SA', 'Peru, Republic of', 'Peru', 'South America', 'Südamerika', '', ''),
(170, '[[regtime]]', 'PH', 'PHL', 608, 'AS', 'Philippines, Republic of the', 'Philippinen', 'Asia', 'Asien', '', ''),
(171, '[[regtime]]', 'PN', 'PCN', 612, 'OC', 'Pitcairn Islands', 'Pitcairn', 'Oceania', 'Ozeanien', '', ''),
(172, '[[regtime]]', 'PL', 'POL', 616, 'EU', 'Poland, Republic of', 'Polen', 'Europe', 'Europa', '', ''),
(173, '[[regtime]]', 'PT', 'PRT', 620, 'EU', 'Portugal, Portuguese Republic', 'Portugal', 'Europe', 'Europa', '', ''),
(174, '[[regtime]]', 'PR', 'PRI', 630, 'NA', 'Puerto Rico, Commonwealth of', 'Puerto Rico', 'North America', 'Nordamerika', '', ''),
(175, '[[regtime]]', 'QA', 'QAT', 634, 'AS', 'Qatar, State of', 'Katar', 'Asia', 'Asien', '', ''),
(176, '[[regtime]]', 'RE', 'REU', 638, 'AF', 'Reunion', 'Réunion', 'Africa', 'Afrika', '', ''),
(177, '[[regtime]]', 'RO', 'ROU', 642, 'EU', 'Romania', 'Rumänien', 'Europe', 'Europa', '', ''),
(178, '[[regtime]]', 'RU', 'RUS', 643, 'EU', 'Russian Federation', 'Russische Föderation', 'Europe', 'Europa', '', ''),
(179, '[[regtime]]', 'RW', 'RWA', 646, 'AF', 'Rwanda, Republic of', 'Ruanda', 'Africa', 'Afrika', '', ''),
(180, '[[regtime]]', 'SH', 'SHN', 654, 'AF', 'Saint Helena', 'St. Helena', 'Africa', 'Afrika', '', ''),
(181, '[[regtime]]', 'KN', 'KNA', 659, 'NA', 'Saint Kitts and Nevis, Federation of', 'Saint Kitts und Nevis', 'North America', 'Nordamerika', '', ''),
(182, '[[regtime]]', 'LC', 'LCA', 662, 'NA', 'Saint Lucia', 'Santa Lucia', 'North America', 'Nordamerika', '', ''),
(183, '[[regtime]]', 'PM', 'SPM', 666, 'NA', 'Saint Pierre and Miquelon', 'Saint-Pierre und Miquelon', 'North America', 'Nordamerika', '', ''),
(184, '[[regtime]]', 'VC', 'VCT', 670, 'NA', 'Saint Vincent and the Grenadines', 'Saint Vincent und die Grenadinen', 'North America', 'Nordamerika', '', ''),
(185, '[[regtime]]', 'WS', 'WSM', 882, 'OC', 'Samoa, Independent State of', 'Samoa', 'Oceania', 'Ozeanien', '', ''),
(186, '[[regtime]]', 'SM', 'SMR', 674, 'EU', 'San Marino, Republic of', 'San Marino', 'Europe', 'Europa', '', ''),
(187, '[[regtime]]', 'ST', 'STP', 678, 'AF', 'Sao Tome and Principe, Democratic Republic of', 'São Tomé und Príncipe', 'Africa', 'Afrika', '', ''),
(188, '[[regtime]]', 'SA', 'SAU', 682, 'AS', 'Saudi Arabia, Kingdom of', 'Saudi-Arabien', 'Asia', 'Asien', '', ''),
(189, '[[regtime]]', 'SN', 'SEN', 686, 'AF', 'Senegal, Republic of', 'Senegal', 'Africa', 'Afrika', '', ''),
(190, '[[regtime]]', 'SC', 'SYC', 690, 'AF', 'Seychelles, Republic of', 'Seychellen', 'Africa', 'Afrika', '', ''),
(191, '[[regtime]]', 'SL', 'SLE', 694, 'AF', 'Sierra Leone, Republic of', 'Sierra Leone', 'Africa', 'Afrika', '', ''),
(192, '[[regtime]]', 'SG', 'SGP', 702, 'AS', 'Singapore, Republic of', 'Singapur', 'Asia', 'Asien', '', ''),
(193, '[[regtime]]', 'SK', 'SVK', 703, 'EU', 'Slovakia (Slovak Republic)', 'Slowakei (Slowakische Republik)', 'Europe', 'Europa', '', ''),
(194, '[[regtime]]', 'SI', 'SVN', 705, 'EU', 'Slovenia, Republic of', 'Slowenien', 'Europe', 'Europa', '', ''),
(195, '[[regtime]]', 'SB', 'SLB', 90, 'OC', 'Solomon Islands', 'Salomonen', 'Oceania', 'Ozeanien', '', ''),
(196, '[[regtime]]', 'SO', 'SOM', 706, 'AF', 'Somalia, Somali Republic', 'Somalia', 'Africa', 'Afrika', '', ''),
(197, '[[regtime]]', 'ZA', 'ZAF', 710, 'AF', 'South Africa, Republic of', 'Südafrika', 'Africa', 'Afrika', '', ''),
(198, '[[regtime]]', 'GS', 'SGS', 239, 'AN', 'South Georgia and the South Sandwich Islands', 'Südgeorgien und Südliche Sandwichinseln', 'Antarctica', 'Antarktis', '', ''),
(199, '[[regtime]]', 'ES', 'ESP', 724, 'EU', 'Spain, Kingdom of', 'Spanien', 'Europe', 'Europa', '', ''),
(200, '[[regtime]]', 'LK', 'LKA', 144, 'AS', 'Sri Lanka, Democratic Socialist Republic of', 'Sri Lanka', 'Asia', 'Asien', '', ''),
(201, '[[regtime]]', 'SD', 'SDN', 736, 'AF', 'Sudan, Republic of', 'Sudan', 'Africa', 'Afrika', '', ''),
(202, '[[regtime]]', 'SR', 'SUR', 740, 'AF', 'Suriname, Republic of', 'Suriname', 'Africa', 'Afrika', '', ''),
(203, '[[regtime]]', 'SJ', 'SJM', 744, 'EU', 'Svalbard & Jan Mayen Islands', 'Svalbard und Jan Mayen', 'Europe', 'Europa', '', ''),
(204, '[[regtime]]', 'SZ', 'SWZ', 748, 'AF', 'Swaziland, Kingdom of', 'Swasiland', 'Africa', 'Afrika', '', ''),
(205, '[[regtime]]', 'SE', 'SWE', 752, 'EU', 'Sweden, Kingdom of', 'Schweden', 'Europe', 'Europa', '', ''),
(206, '[[regtime]]', 'CH', 'CHE', 756, 'EU', 'Switzerland, Swiss Confederation', 'Schweiz', 'Europe', 'Europa', '', ''),
(207, '[[regtime]]', 'SY', 'SYR', 760, 'AS', 'Syrian Arab Republic', 'Syrien, Arabische Republik', 'Asia', 'Asien', '', ''),
(208, '[[regtime]]', 'TW', 'TWN', 158, 'AS', 'Taiwan', 'Taiwan (China)', 'Asia', 'Asien', '', ''),
(209, '[[regtime]]', 'TJ', 'TJK', 762, 'AS', 'Tajikistan, Republic of', 'Tadschikistan', 'Asia', 'Asien', '', ''),
(210, '[[regtime]]', 'TZ', 'TZA', 834, 'AF', 'Tanzania, United Republic of', 'Tansania, Vereinigte Republik', 'Africa', 'Afrika', '', ''),
(211, '[[regtime]]', 'TH', 'THA', 764, 'AS', 'Thailand, Kingdom of', 'Thailand', 'Asia', 'Asien', '', ''),
(212, '[[regtime]]', 'TG', 'TGO', 768, 'AF', 'Togo, Togolese Republic', 'Togo', 'Africa', 'Afrika', '', ''),
(213, '[[regtime]]', 'TK', 'TKL', 772, 'OC', 'Tokelau', 'Tokelau', 'Oceania', 'Ozeanien', '', ''),
(214, '[[regtime]]', 'TO', 'TON', 776, 'OC', 'Tonga, Kingdom of', 'Tonga', 'Oceania', 'Ozeanien', '', ''),
(215, '[[regtime]]', 'TT', 'TTO', 780, 'NA', 'Trinidad and Tobago, Republic of', 'Trinidad und Tobago', 'North America', 'Nordamerika', '', ''),
(216, '[[regtime]]', 'TN', 'TUN', 788, 'AF', 'Tunisia, Tunisian Republic', 'Tunesien', 'Africa', 'Afrika', '', ''),
(217, '[[regtime]]', 'TR', 'TUR', 792, 'AS', 'Turkey, Republic of', 'Türkei', 'Asia', 'Asien', '', ''),
(218, '[[regtime]]', 'TM', 'TKM', 795, 'AS', 'Turkmenistan', 'Turkmenistan', 'Asia', 'Asien', '', ''),
(219, '[[regtime]]', 'TC', 'TCA', 796, 'NA', 'Turks and Caicos Islands', 'Turks- und Caicosinseln', 'North America', 'Nordamerika', '', ''),
(220, '[[regtime]]', 'TV', 'TUV', 798, 'OC', 'Tuvalu', 'Tuvalu', 'Oceania', 'Ozeanien', '', ''),
(221, '[[regtime]]', 'UG', 'UGA', 800, 'AF', 'Uganda, Republic of', 'Uganda', 'Africa', 'Afrika', '', ''),
(222, '[[regtime]]', 'UA', 'UKR', 804, 'EU', 'Ukraine', 'Ukraine', 'Europe', 'Europa', '', ''),
(223, '[[regtime]]', 'AE', 'ARE', 784, 'AS', 'United Arab Emirates', 'Vereinigte Arabische Emirate', 'Asia', 'Asien', '', ''),
(224, '[[regtime]]', 'GB', 'GBR', 826, 'EU', 'United Kingdom of Great Britain & Northern Ireland', 'United Kingdom', 'Europe', 'Europa', '', ''),
(225, '[[regtime]]', 'US', 'USA', 840, 'NA', 'United States of America', 'Vereinigte Staaten', 'North America', 'Nordamerika', '', ''),
(226, '[[regtime]]', 'UM', 'UMI', 581, 'OC', 'United States Minor Outlying Islands', 'Kleinere entlegene Inseln der Vereinigten Staaten', 'Oceania', 'Ozeanien', '', ''),
(227, '[[regtime]]', 'UY', 'URY', 858, 'SA', 'Uruguay, Eastern Republic of', 'Uruguay', 'South America', 'Südamerika', '', ''),
(228, '[[regtime]]', 'UZ', 'UZB', 860, 'AS', 'Uzbekistan, Republic of', 'Usbekistan', 'Asia', 'Asien', '', ''),
(229, '[[regtime]]', 'VU', 'VUT', 548, 'OC', 'Vanuatu, Republic of', 'Vanuatu', 'Oceania', 'Ozeanien', '', ''),
(230, '[[regtime]]', 'VE', 'VEN', 862, 'SA', 'Venezuela, Bolivarian Republic of', 'Venezuela', 'South America', 'Südamerika', '', ''),
(231, '[[regtime]]', 'VN', 'VNM', 704, 'AS', 'Vietnam, Socialist Republic of', 'Vietnam', 'Asia', 'Asien', '', ''),
(232, '[[regtime]]', 'VG', 'VGB', 92, 'NA', 'British Virgin Islands', 'Jungferninseln (Britische)', 'North America', 'Nordamerika', '', ''),
(233, '[[regtime]]', 'VI', 'VIR', 850, 'NA', 'United States Virgin Islands', 'Jungferninseln (Amerikanische)', 'North America', 'Nordamerika', '', ''),
(234, '[[regtime]]', 'WF', 'WLF', 876, 'OC', 'Wallis and Futuna', 'Wallis und Futuna', 'Oceania', 'Ozeanien', '', ''),
(235, '[[regtime]]', 'EH', 'ESH', 732, 'AF', 'Western Sahara', 'Westsahara', 'Africa', 'Afrika', '', ''),
(236, '[[regtime]]', 'YE', 'YEM', 887, 'AS', 'Yemen', 'Jemen', 'Asia', 'Asien', '', ''),
(237, '[[regtime]]', 'YU', 'YUG', 891, 'EU', 'Yugoslavia', 'Jugoslawien', 'Europe', 'Europa', '', ''),
(238, '[[regtime]]', 'ZM', 'ZMB', 894, 'AF', 'Zambia, Republic of', 'Sambia', 'Africa', 'Afrika', '', ''),
(239, '[[regtime]]', 'ZW', 'ZWE', 716, 'AF', 'Zimbabwe, Republic of', 'Simbabwe', 'Africa', 'Afrika', '', ''),
(240, '[[regtime]]', 'AX', 'ALA', 248, 'EU', 'Åland Islands', 'Åland Inseln', 'Europe', 'Europa', '', ''),
(241, '[[regtime]]', 'GG', 'GGY', 831, 'EU', 'Guernsey, Bailiwick of', 'Guernsey, Vogtei', 'Europe', 'Europa', '', ''),
(242, '[[regtime]]', 'IM', 'IMN', 833, 'EU', 'Isle of Man', 'Insel Man', 'Europe', 'Europa', '', ''),
(243, '[[regtime]]', 'JE', 'JEY', 832, 'EU', 'Jersey, Bailiwick of', 'Jersey, Vogtei', 'Europe', 'Europa', '', ''),
(244, '[[regtime]]', 'ME', 'MNE', 499, 'EU', 'Montenegro, Republic of', 'Montenegro', 'Europe', 'Europa', '', ''),
(245, '[[regtime]]', 'BL', 'BLM', 652, 'NA', 'Saint Barthelemy', 'Sankt Bartholomäus', 'North America', 'Nordamerika', '', ''),
(246, '[[regtime]]', 'MF', 'MAF', 663, 'NA', 'Saint Martin', 'Saint-Martin', 'North America', 'Nordamerika', '', ''),
(247, '[[regtime]]', 'RS', 'SRB', 688, 'EU', 'Serbia, Republic of', 'Serbien', 'Europe', 'Europa', '', ''),
(248, '[[regtime]]', 'TL', 'TLS', 626, 'AS', 'Timor-Leste, Democratic Republic of', 'Osttimor (Timor-Leste)', 'Asia', 'Asien', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_crossreference`
--

CREATE TABLE `[[dbprefix]]phpwcms_crossreference` (
  `cref_id` int(11) NOT NULL AUTO_INCREMENT,
  `cref_type` varchar(255) NOT NULL DEFAULT '',
  `cref_module` varchar(255) NOT NULL DEFAULT '',
  `cref_rid` int(11) NOT NULL DEFAULT '0',
  `cref_int` int(11) NOT NULL DEFAULT '0',
  `cref_str` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`cref_id`),
  KEY `cref_type` (`cref_type`),
  KEY `cref_rid` (`cref_rid`),
  KEY `cref_int` (`cref_int`),
  KEY `cref_str` (`cref_str`),
  KEY `cref_module` (`cref_module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_file`
--

CREATE TABLE `[[dbprefix]]phpwcms_file` (
  `f_id` int(11) NOT NULL AUTO_INCREMENT,
  `f_pid` int(11) NOT NULL DEFAULT '0',
  `f_uid` int(11) NOT NULL DEFAULT '0',
  `f_kid` int(2) NOT NULL DEFAULT '0',
  `f_is_variation` int(11) NOT NULL DEFAULT '0',
  `f_order` int(11) NOT NULL DEFAULT '0',
  `f_trash` int(1) NOT NULL DEFAULT '0',
  `f_aktiv` int(1) NOT NULL DEFAULT '0',
  `f_public` int(1) NOT NULL DEFAULT '0',
  `f_tstamp` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `f_name` varchar(255) NOT NULL DEFAULT '',
  `f_cat` varchar(255) NOT NULL DEFAULT '',
  `f_created` int(11) NOT NULL DEFAULT '0',
  `f_changed` int(11) NOT NULL DEFAULT '0',
  `f_size` int(15) unsigned NOT NULL DEFAULT '0',
  `f_type` varchar(200) NOT NULL DEFAULT '',
  `f_ext` varchar(50) NOT NULL DEFAULT '',
  `f_svg` int(1) unsigned NOT NULL DEFAULT '0',
  `f_image_width` varchar(20) NOT NULL DEFAULT '',
  `f_image_height` varchar(20) NOT NULL DEFAULT '',
  `f_shortinfo` varchar(1000) NOT NULL DEFAULT '',
  `f_longinfo` text NOT NULL,
  `f_keywords` varchar(1000) NOT NULL DEFAULT '',
  `f_hash` varchar(255) NOT NULL DEFAULT '',
  `f_dlstart` int(11) NOT NULL DEFAULT '0',
  `f_dlfinal` int(11) NOT NULL DEFAULT '0',
  `f_refid` int(11) NOT NULL DEFAULT '0',
  `f_copyright` varchar(1000) NOT NULL DEFAULT '',
  `f_tags` varchar(1000) NOT NULL DEFAULT '',
  `f_granted` int(11) NOT NULL DEFAULT '0',
  `f_gallerystatus` int(1) NOT NULL DEFAULT '0',
  `f_vars` blob NOT NULL,
  `f_sort` int(11) NOT NULL DEFAULT '0',
  `f_title` varchar(1000) NOT NULL DEFAULT '',
  `f_alt` varchar(1000) NOT NULL DEFAULT '',
  PRIMARY KEY (`f_id`),
  KEY `f_granted` (`f_granted`),
  KEY `f_sort` (`f_sort`),
  KEY `f_pid` (`f_pid`),
  KEY `f_is_variation` (`f_is_variation`),
  FULLTEXT KEY `f_name` (`f_name`),
  FULLTEXT KEY `f_shortinfo` (`f_shortinfo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_filecat`
--

CREATE TABLE `[[dbprefix]]phpwcms_filecat` (
  `fcat_id` int(11) NOT NULL AUTO_INCREMENT,
  `fcat_name` varchar(255) NOT NULL DEFAULT '',
  `fcat_aktiv` int(1) NOT NULL DEFAULT '0',
  `fcat_deleted` int(1) NOT NULL DEFAULT '0',
  `fcat_needed` int(1) NOT NULL DEFAULT '0',
  `fcat_sort` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`fcat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_filekey`
--

CREATE TABLE `[[dbprefix]]phpwcms_filekey` (
  `fkey_id` int(11) NOT NULL AUTO_INCREMENT,
  `fkey_cid` int(11) NOT NULL DEFAULT '0',
  `fkey_name` varchar(255) NOT NULL DEFAULT '',
  `fkey_aktiv` int(1) NOT NULL DEFAULT '0',
  `fkey_deleted` int(1) NOT NULL DEFAULT '0',
  `fkey_sort` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`fkey_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_formresult`
--

CREATE TABLE `[[dbprefix]]phpwcms_formresult` (
  `formresult_id` int(11) NOT NULL AUTO_INCREMENT,
  `formresult_pid` int(11) NOT NULL DEFAULT '0',
  `formresult_createdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `formresult_ip` varchar(50) NOT NULL DEFAULT '',
  `formresult_content` mediumblob NOT NULL,
  PRIMARY KEY (`formresult_id`),
  KEY `formresult_pid` (`formresult_pid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_formtracking`
--

CREATE TABLE `[[dbprefix]]phpwcms_formtracking` (
  `formtracking_id` int(11) NOT NULL AUTO_INCREMENT,
  `formtracking_hash` varchar(50) NOT NULL DEFAULT '',
  `formtracking_ip` varchar(20) NOT NULL DEFAULT '',
  `formtracking_created` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `formtracking_sentdate` varchar(20) NOT NULL DEFAULT '',
  `formtracking_sent` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`formtracking_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_glossary`
--

CREATE TABLE `[[dbprefix]]phpwcms_glossary` (
  `glossary_id` int(11) NOT NULL AUTO_INCREMENT,
  `glossary_created` datetime DEFAULT NULL,
  `glossary_changed` datetime DEFAULT NULL,
  `glossary_title` text NOT NULL,
  `glossary_tag` varchar(255) NOT NULL DEFAULT '',
  `glossary_keyword` varchar(255) NOT NULL DEFAULT '',
  `glossary_text` mediumtext NOT NULL,
  `glossary_highlight` int(1) NOT NULL DEFAULT '0',
  `glossary_object` mediumtext NOT NULL,
  `glossary_status` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`glossary_id`),
  KEY `glossary_status` (`glossary_status`),
  KEY `glossary_tag` (`glossary_tag`),
  KEY `glossary_keyword` (`glossary_keyword`),
  KEY `glossary_highlight` (`glossary_highlight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_guestbook`
--

CREATE TABLE `[[dbprefix]]phpwcms_guestbook` (
  `guestbook_id` int(11) NOT NULL AUTO_INCREMENT,
  `guestbook_cid` int(11) NOT NULL DEFAULT '0',
  `guestbook_msg` text NOT NULL,
  `guestbook_name` text NOT NULL,
  `guestbook_email` text NOT NULL,
  `guestbook_created` int(11) NOT NULL DEFAULT '0',
  `guestbook_trashed` int(1) NOT NULL DEFAULT '0',
  `guestbook_url` text NOT NULL,
  `guestbook_show` int(1) NOT NULL DEFAULT '0',
  `guestbook_ip` varchar(20) NOT NULL DEFAULT '',
  `guestbook_useragent` varchar(255) NOT NULL DEFAULT '',
  `guestbook_image` varchar(255) NOT NULL DEFAULT '',
  `guestbook_imagename` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`guestbook_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_keyword`
--

CREATE TABLE `[[dbprefix]]phpwcms_keyword` (
  `keyword_id` int(11) NOT NULL AUTO_INCREMENT,
  `keyword_name` varchar(255) NOT NULL DEFAULT '',
  `keyword_created` varchar(14) NOT NULL DEFAULT '',
  `keyword_trash` int(1) NOT NULL DEFAULT '0',
  `keyword_updated` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `keyword_description` text NOT NULL,
  `keyword_link` varchar(255) NOT NULL DEFAULT '',
  `keyword_sort` int(11) NOT NULL DEFAULT '0',
  `keyword_important` int(1) NOT NULL DEFAULT '0',
  `keyword_abbr` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`keyword_id`),
  KEY `keyword_abbr` (`keyword_abbr`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_language`
--

CREATE TABLE `[[dbprefix]]phpwcms_language` (
  `lang_id` varchar(255) NOT NULL DEFAULT '',
  `lang_html` int(1) NOT NULL DEFAULT '1',
  `lang_type` int(1) NOT NULL DEFAULT '0',
  `EN` text NOT NULL,
  `DE` text NOT NULL,
  `BG` text NOT NULL,
  `CA` text NOT NULL,
  `CZ` text NOT NULL,
  `DA` text NOT NULL,
  `EE` text NOT NULL,
  `ES` text NOT NULL,
  `FI` text NOT NULL,
  `FR` text NOT NULL,
  `GR` text NOT NULL,
  `HU` text NOT NULL,
  `IT` text NOT NULL,
  `LT` text NOT NULL,
  `NL` text NOT NULL,
  `NO` text NOT NULL,
  `PL` text NOT NULL,
  `PT` text NOT NULL,
  `RO` text NOT NULL,
  `SE` text NOT NULL,
  `SK` text NOT NULL,
  `VN` text NOT NULL,
  PRIMARY KEY (`lang_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_log`
--

CREATE TABLE `[[dbprefix]]phpwcms_log` (
  `log_id` int(11) NOT NULL AUTO_INCREMENT,
  `log_created` datetime DEFAULT NULL,
  `log_type` varchar(50) NOT NULL DEFAULT '',
  `log_ip` varchar(30) NOT NULL DEFAULT '',
  `log_user_agent` varchar(255) NOT NULL DEFAULT '',
  `log_user_id` int(11) NOT NULL DEFAULT '0',
  `log_user_name` varchar(255) NOT NULL DEFAULT '',
  `log_referrer_id` int(11) NOT NULL DEFAULT '0',
  `log_referrer_url` text NOT NULL,
  `log_data1` varchar(255) NOT NULL DEFAULT '',
  `log_data2` varchar(255) NOT NULL DEFAULT '',
  `log_data3` varchar(255) NOT NULL DEFAULT '',
  `log_msg` text NOT NULL,
  PRIMARY KEY (`log_id`),
  KEY `log_referrer_id` (`log_referrer_id`),
  KEY `log_type` (`log_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_log_seo`
--

CREATE TABLE `[[dbprefix]]phpwcms_log_seo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `create_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `domain` varchar(255) NOT NULL DEFAULT '',
  `query` varchar(255) NOT NULL DEFAULT '',
  `pos` int(11) NOT NULL DEFAULT '0',
  `referrer` text NOT NULL,
  `hash` char(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_map`
--

CREATE TABLE `[[dbprefix]]phpwcms_map` (
  `map_id` int(11) NOT NULL AUTO_INCREMENT,
  `map_cid` int(11) NOT NULL DEFAULT '0',
  `map_x` int(5) NOT NULL DEFAULT '0',
  `map_y` int(5) NOT NULL DEFAULT '0',
  `map_title` text NOT NULL,
  `map_zip` varchar(255) NOT NULL DEFAULT '',
  `map_city` text NOT NULL,
  `map_deleted` int(1) NOT NULL DEFAULT '0',
  `map_entry` text NOT NULL,
  `map_vars` text NOT NULL,
  PRIMARY KEY (`map_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_message`
--

CREATE TABLE `[[dbprefix]]phpwcms_message` (
  `msg_id` int(11) NOT NULL AUTO_INCREMENT,
  `msg_pid` int(11) NOT NULL DEFAULT '0',
  `msg_uid` int(11) NOT NULL DEFAULT '0',
  `msg_tstamp` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `msg_subject` varchar(150) NOT NULL DEFAULT '',
  `msg_text` blob NOT NULL,
  `msg_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `msg_read` tinyint(1) NOT NULL DEFAULT '0',
  `msg_to` blob NOT NULL,
  `msg_from` int(11) NOT NULL DEFAULT '0',
  `msg_from_del` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`msg_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_newsletter`
--

CREATE TABLE `[[dbprefix]]phpwcms_newsletter` (
  `newsletter_id` int(11) NOT NULL AUTO_INCREMENT,
  `newsletter_created` timestamp NULL DEFAULT NULL,
  `newsletter_lastsending` timestamp NULL DEFAULT NULL,
  `newsletter_subject` text NOT NULL,
  `newsletter_changed` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `newsletter_vars` mediumblob NOT NULL,
  `newsletter_trashed` int(1) NOT NULL DEFAULT '0',
  `newsletter_active` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`newsletter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_newsletterqueue`
--

CREATE TABLE `[[dbprefix]]phpwcms_newsletterqueue` (
  `queue_id` int(11) NOT NULL AUTO_INCREMENT,
  `queue_created` timestamp NULL DEFAULT NULL,
  `queue_changed` timestamp NULL DEFAULT NULL,
  `queue_status` int(11) NOT NULL DEFAULT '0',
  `queue_pid` int(11) NOT NULL DEFAULT '0',
  `queue_rid` int(11) NOT NULL DEFAULT '0',
  `queue_errormsg` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`queue_id`),
  KEY `nlqueue` (`queue_pid`,`queue_status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_pagelayout`
--

CREATE TABLE `[[dbprefix]]phpwcms_pagelayout` (
  `pagelayout_id` int(11) NOT NULL AUTO_INCREMENT,
  `pagelayout_name` varchar(255) NOT NULL DEFAULT '',
  `pagelayout_default` int(1) NOT NULL DEFAULT '0',
  `pagelayout_var` mediumblob NOT NULL,
  `pagelayout_trash` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pagelayout_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]phpwcms_pagelayout`
--

INSERT INTO `[[dbprefix]]phpwcms_pagelayout` VALUES
(1, 'Sample Pagelayout', 1, 'a:62:{s:2:"id";i:1;s:11:"layout_name";s:17:"Sample Pagelayout";s:14:"layout_default";i:1;s:12:"layout_align";i:0;s:11:"layout_type";i:0;s:17:"layout_border_top";s:0:"";s:20:"layout_border_bottom";s:0:"";s:18:"layout_border_left";s:0:"";s:19:"layout_border_right";s:0:"";s:15:"layout_noborder";i:1;s:12:"layout_title";s:9:"Pagetitle";s:18:"layout_title_order";i:4;s:19:"layout_title_spacer";s:3:" | ";s:14:"layout_bgcolor";b:0;s:14:"layout_bgimage";s:0:"";s:15:"layout_jsonload";s:0:"";s:16:"layout_textcolor";b:0;s:16:"layout_linkcolor";b:0;s:13:"layout_vcolor";b:0;s:13:"layout_acolor";b:0;s:16:"layout_all_width";s:0:"";s:18:"layout_all_bgcolor";b:0;s:18:"layout_all_bgimage";s:0:"";s:16:"layout_all_class";s:0:"";s:20:"layout_content_width";s:0:"";s:22:"layout_content_bgcolor";b:0;s:22:"layout_content_bgimage";s:0:"";s:20:"layout_content_class";s:0:"";s:17:"layout_left_width";s:0:"";s:19:"layout_left_bgcolor";b:0;s:19:"layout_left_bgimage";s:0:"";s:17:"layout_left_class";s:0:"";s:18:"layout_right_width";s:0:"";s:20:"layout_right_bgcolor";b:0;s:20:"layout_right_bgimage";s:0:"";s:18:"layout_right_class";s:0:"";s:22:"layout_leftspace_width";s:0:"";s:24:"layout_leftspace_bgcolor";b:0;s:24:"layout_leftspace_bgimage";s:0:"";s:22:"layout_leftspace_class";s:0:"";s:23:"layout_rightspace_width";s:0:"";s:25:"layout_rightspace_bgcolor";b:0;s:25:"layout_rightspace_bgimage";s:0:"";s:23:"layout_rightspace_class";s:0:"";s:20:"layout_header_height";s:0:"";s:21:"layout_header_bgcolor";b:0;s:21:"layout_header_bgimage";s:0:"";s:19:"layout_header_class";s:0:"";s:22:"layout_topspace_height";s:0:"";s:23:"layout_topspace_bgcolor";b:0;s:23:"layout_topspace_bgimage";s:0:"";s:21:"layout_topspace_class";s:0:"";s:25:"layout_bottomspace_height";s:0:"";s:26:"layout_bottomspace_bgcolor";b:0;s:26:"layout_bottomspace_bgimage";s:0:"";s:24:"layout_bottomspace_class";s:0:"";s:20:"layout_footer_height";s:0:"";s:21:"layout_footer_bgcolor";b:0;s:21:"layout_footer_bgimage";s:0:"";s:19:"layout_footer_class";s:0:"";s:13:"layout_render";i:2;s:19:"layout_customblocks";s:0:"";}', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_profession`
--

CREATE TABLE `[[dbprefix]]phpwcms_profession` (
  `prof_id` int(4) NOT NULL AUTO_INCREMENT,
  `prof_name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`prof_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=259 ;

--
-- Dumping data for table `[[dbprefix]]phpwcms_profession`
--

INSERT INTO `[[dbprefix]]phpwcms_profession` VALUES
(1, 'academic'),
(2, 'accountant'),
(3, 'actor'),
(4, 'administrative services department manager'),
(5, 'administrator'),
(6, 'administrator, IT'),
(7, 'agricultural advisor'),
(8, 'air steward'),
(9, 'air-conditioning installer or mechanic'),
(10, 'aircraft service technician'),
(11, 'ambulance driver (non paramedic)'),
(12, 'animal carer (not in farms)'),
(13, 'animator'),
(14, 'arable farm manager, field crop or vegetable'),
(15, 'arable farmer, field crop or vegetable'),
(16, 'architect'),
(17, 'architect, landscape'),
(18, 'artist'),
(19, 'asbestos removal worker'),
(20, 'assembler'),
(21, 'assembly team leader'),
(22, 'assistant'),
(23, 'author'),
(24, 'baker'),
(25, 'bank clerk (back-office)'),
(26, 'beauty therapist'),
(27, 'beverage production process controller'),
(28, 'biologist'),
(29, 'blogger'),
(30, 'boring machine operator'),
(31, 'bricklayer'),
(32, 'builder'),
(33, 'butcher'),
(34, 'car mechanic'),
(35, 'career counsellor'),
(36, 'caretaker'),
(37, 'carpenter'),
(38, 'charge nurse'),
(39, 'check-out operator'),
(40, 'chef'),
(41, 'child-carer'),
(42, 'civil engineering technician'),
(43, 'civil servant'),
(44, 'cleaning supervisor'),
(45, 'clerk'),
(46, 'climatologist'),
(47, 'cloak room attendant'),
(48, 'cnc operator'),
(49, 'comic book writer'),
(50, 'community health worker'),
(51, 'company director'),
(52, 'computer programmer'),
(53, 'confectionery maker'),
(54, 'construction operative'),
(55, 'cook'),
(56, 'cooling or freezing installer or mechanic'),
(57, 'critic'),
(58, 'database designer'),
(59, 'decorator'),
(60, 'dental hygienist'),
(61, 'dental prosthesis technician'),
(62, 'dentist'),
(63, 'department store manager'),
(64, 'designer'),
(65, 'designer, graphic'),
(66, 'designer, industrial'),
(67, 'designer, interface'),
(68, 'designer, interior'),
(69, 'designer, screen'),
(70, 'designer, web'),
(71, 'dietician'),
(72, 'diplomat'),
(73, 'director'),
(74, 'display designer'),
(75, 'doctor'),
(76, 'domestic housekeeper'),
(77, 'economist'),
(78, 'editor'),
(79, 'education advisor'),
(80, 'electrical engineer'),
(81, 'electrical mechanic or fitter'),
(82, 'electrician'),
(83, 'engineer'),
(84, 'engineering maintenance supervisor'),
(85, 'estate agent'),
(86, 'executive'),
(87, 'executive secretary'),
(88, 'farmer'),
(89, 'felt roofer'),
(90, 'filing clerk'),
(91, 'film director'),
(92, 'financial clerk'),
(93, 'financial services manager'),
(94, 'fire fighter'),
(95, 'first line supervisor beverages workers'),
(96, 'first line supervisor of cleaning workers'),
(97, 'fisherman'),
(98, 'fishmonger'),
(99, 'flight attendant'),
(100, 'floral arranger'),
(101, 'food scientist'),
(102, 'garage supervisor'),
(103, 'garbage man'),
(104, 'gardener, all other'),
(105, 'general practitioner'),
(106, 'geographer'),
(107, 'geologist'),
(108, 'hairdresser'),
(109, 'head groundsman'),
(110, 'head teacher'),
(111, 'horse riding instructor'),
(112, 'hospital nurse'),
(113, 'hotel manager'),
(114, 'house painter'),
(115, 'hr manager'),
(116, 'it applications programmer'),
(117, 'it systems administrator'),
(118, 'jeweller'),
(119, 'journalist'),
(120, 'judge'),
(121, 'juggler'),
(122, 'kitchen assistant'),
(123, 'lathe setter-operator'),
(124, 'lawyer'),
(125, 'lecturer'),
(126, 'legal secretary'),
(127, 'lexicographer'),
(128, 'library assistant'),
(129, 'local police officer'),
(130, 'logistics manager'),
(131, 'machine tool operator'),
(132, 'magician'),
(133, 'makeup artist'),
(134, 'manager'),
(135, 'manager, all other health services'),
(136, 'marketing manager'),
(137, 'meat processing operator'),
(138, 'mechanical engineering technician'),
(139, 'medical laboratory technician'),
(140, 'medical radiography equipment operator'),
(141, 'metal moulder'),
(142, 'metal production process operator'),
(143, 'meteorologist'),
(144, 'midwifery professional'),
(145, 'miner'),
(146, 'mortgage clerk'),
(147, 'musical instrument maker'),
(148, 'musician'),
(149, 'non-commissioned officer armed forces'),
(150, 'nurse'),
(151, 'nursery school teacher'),
(152, 'nursing aid'),
(153, 'ophthalmic optician'),
(154, 'optician'),
(155, 'painter'),
(156, 'payroll clerk'),
(157, 'personal assistant'),
(158, 'personal carer in an institution for the elderly'),
(159, 'personal carer in an institution for the handicapped'),
(160, 'personal carer in private homes'),
(161, 'personnel clerk'),
(162, 'pest controller'),
(163, 'photographer'),
(164, 'physician assistant'),
(165, 'pilot'),
(166, 'pipe fitter'),
(167, 'plant maintenance mechanic'),
(168, 'plumber'),
(169, 'police inspector'),
(170, 'police officer'),
(171, 'policy advisor'),
(172, 'politician'),
(173, 'porter'),
(174, 'post secondary education teacher'),
(175, 'post sorting or distributing clerk'),
(176, 'power plant operator'),
(177, 'primary school head'),
(178, 'primary school teacher'),
(179, 'printer'),
(180, 'printing machine operator'),
(181, 'prison officer / warder'),
(182, 'product manager'),
(183, 'professional gambler'),
(184, 'project manager'),
(185, 'programmer'),
(186, 'psychologist'),
(187, 'puppeteer'),
(188, 'quality inspector, all other products'),
(189, 'receptionist'),
(190, 'restaurant cook'),
(191, 'road paviour'),
(192, 'roofer'),
(193, 'sailor'),
(194, 'sales assistant, all other'),
(195, 'sales or marketing manager'),
(196, 'sales representative'),
(197, 'sales support clerk'),
(198, 'salesperson'),
(199, 'scientist'),
(200, 'seaman (armed forces)'),
(201, 'secondary school manager'),
(202, 'secondary school teacher'),
(203, 'secretary'),
(204, 'security guard'),
(205, 'sheet metal worker'),
(206, 'ship mechanic'),
(207, 'shoe repairer, leather repairer'),
(208, 'shop assistant'),
(209, 'sign language Interpreter'),
(210, 'singer'),
(211, 'social media manager'),
(212, 'socialphotographer'),
(213, 'software analyst'),
(214, 'software developer'),
(215, 'software engineer'),
(216, 'soldier'),
(217, 'solicitor'),
(218, 'speech therapist'),
(219, 'steel fixer'),
(220, 'stockman'),
(221, 'structural engineer'),
(222, 'student'),
(223, 'surgeon'),
(224, 'surgical footwear maker'),
(225, 'swimming instructor'),
(226, 'system operator'),
(227, 'tailor'),
(228, 'tailor, seamstress'),
(229, 'tax inspector'),
(230, 'taxi driver'),
(231, 'teacher'),
(232, 'telephone operator'),
(233, 'telephonist'),
(234, 'theorist'),
(235, 'tile layer'),
(236, 'translator'),
(237, 'transport clerk'),
(238, 'travel agency clerk'),
(239, 'travel agent'),
(240, 'truck driver long distances'),
(241, 'trucker'),
(242, 'TV cameraman'),
(243, 'TV presenter'),
(244, 'university professor'),
(245, 'university researcher'),
(246, 'vet'),
(247, 'veterinary practitioner'),
(248, 'vocational education teacher'),
(249, 'waiter'),
(250, 'waiting staff'),
(251, 'web designer'),
(252, 'web developer'),
(253, 'webmaster'),
(254, 'welder, all other'),
(255, 'wood processing plant operator'),
(256, 'writer'),
(257, 'other'),
(258, 'n/a');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_redirect`
--

CREATE TABLE `[[dbprefix]]phpwcms_redirect` (
  `rid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `changed` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `aid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `alias` varchar(255) NOT NULL DEFAULT '',
  `link` varchar(255) NOT NULL DEFAULT '',
  `views` bigint(20) unsigned NOT NULL DEFAULT '0',
  `active` int(1) unsigned NOT NULL DEFAULT '0',
  `shortcut` int(1) unsigned NOT NULL DEFAULT '0',
  `type` varchar(255) NOT NULL DEFAULT '',
  `code` varchar(255) NOT NULL DEFAULT '',
  `target` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`rid`),
  KEY `id` (`id`,`aid`,`alias`),
  KEY `active` (`active`),
  KEY `link` (`link`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_shop_orders`
--

CREATE TABLE `[[dbprefix]]phpwcms_shop_orders` (
  `order_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_number` varchar(20) NOT NULL DEFAULT '',
  `order_date` datetime DEFAULT NULL,
  `order_name` varchar(255) NOT NULL DEFAULT '',
  `order_firstname` varchar(255) NOT NULL DEFAULT '',
  `order_email` varchar(255) NOT NULL DEFAULT '',
  `order_net` float NOT NULL DEFAULT '0',
  `order_gross` float NOT NULL DEFAULT '0',
  `order_payment` varchar(255) NOT NULL DEFAULT '',
  `order_data` mediumtext NOT NULL,
  `order_status` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`order_id`),
  KEY `order_number` (`order_number`,`order_status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_shop_products`
--

CREATE TABLE `[[dbprefix]]phpwcms_shop_products` (
  `shopprod_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `shopprod_createdate` datetime DEFAULT NULL,
  `shopprod_changedate` datetime DEFAULT NULL,
  `shopprod_status` int(1) unsigned NOT NULL DEFAULT '0',
  `shopprod_uid` int(10) unsigned NOT NULL DEFAULT '0',
  `shopprod_ordernumber` varchar(255) NOT NULL DEFAULT '',
  `shopprod_model` varchar(255) NOT NULL DEFAULT '',
  `shopprod_name1` varchar(255) NOT NULL DEFAULT '',
  `shopprod_name2` varchar(255) NOT NULL DEFAULT '',
  `shopprod_tag` varchar(255) NOT NULL DEFAULT '',
  `shopprod_vat` float unsigned NOT NULL DEFAULT '0',
  `shopprod_netgross` int(1) unsigned NOT NULL DEFAULT '0',
  `shopprod_price` float NOT NULL DEFAULT '0',
  `shopprod_maxrebate` float NOT NULL DEFAULT '0',
  `shopprod_description0` text NOT NULL,
  `shopprod_description1` text NOT NULL,
  `shopprod_description2` text NOT NULL,
  `shopprod_description3` text NOT NULL,
  `shopprod_var` mediumtext NOT NULL,
  `shopprod_category` varchar(255) NOT NULL DEFAULT '',
  `shopprod_weight` float NOT NULL DEFAULT '0',
  `shopprod_color` varchar(255) NOT NULL DEFAULT '',
  `shopprod_size` varchar(255) NOT NULL DEFAULT '',
  `shopprod_listall` int(1) unsigned DEFAULT '0',
  `shopprod_special_price` text NOT NULL,
  `shopprod_track_view` int(11) NOT NULL DEFAULT '0',
  `shopprod_lang` varchar(255) NOT NULL DEFAULT '',
  `shopprod_overwrite_meta` int(1) NOT NULL DEFAULT '1',
  `shopprod_opengraph` int(1) unsigned NOT NULL DEFAULT '1',
  `shopprod_unit` varchar(100) NOT NULL DEFAULT '',
  `shopprod_inventory` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`shopprod_id`),
  KEY `shopprod_status` (`shopprod_status`),
  KEY `category` (`shopprod_category`),
  KEY `tag` (`shopprod_tag`),
  KEY `all` (`shopprod_listall`),
  KEY `shopprod_track_view` (`shopprod_track_view`),
  KEY `shopprod_lang` (`shopprod_lang`),
  KEY `shopprod_opengraph` (`shopprod_opengraph`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_subscription`
--

CREATE TABLE `[[dbprefix]]phpwcms_subscription` (
  `subscription_id` int(11) NOT NULL AUTO_INCREMENT,
  `subscription_name` text NOT NULL,
  `subscription_info` blob NOT NULL,
  `subscription_active` int(1) NOT NULL DEFAULT '0',
  `subscription_lang` varchar(100) NOT NULL DEFAULT '',
  `subscription_tstamp` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`subscription_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_sysvalue`
--

CREATE TABLE `[[dbprefix]]phpwcms_sysvalue` (
  `sysvalue_key` varchar(255) NOT NULL DEFAULT '',
  `sysvalue_group` varchar(255) NOT NULL DEFAULT '',
  `sysvalue_lastchange` int(11) NOT NULL DEFAULT '0',
  `sysvalue_status` int(1) NOT NULL DEFAULT '0',
  `sysvalue_vartype` varchar(255) NOT NULL DEFAULT '',
  `sysvalue_value` mediumtext NOT NULL,
  PRIMARY KEY (`sysvalue_key`),
  KEY `sysvalue_group` (`sysvalue_group`),
  KEY `sysvalue_status` (`sysvalue_status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `[[dbprefix]]phpwcms_sysvalue`
--

INSERT INTO `[[dbprefix]]phpwcms_sysvalue` VALUES
('structure_array_vmode_admin', 'frontend_render', [[timestamp]], 1, 'string', ''),
('structure_array_vmode_all', 'frontend_render', [[timestamp]], 1, 'string', ''),
('structure_array_vmode_editor', 'frontend_render', [[timestamp]], 1, 'string', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_template`
--

CREATE TABLE `[[dbprefix]]phpwcms_template` (
  `template_id` int(11) NOT NULL AUTO_INCREMENT,
  `template_type` int(11) NOT NULL DEFAULT '1',
  `template_name` varchar(255) NOT NULL DEFAULT '',
  `template_default` int(1) NOT NULL DEFAULT '0',
  `template_var` mediumblob NOT NULL,
  `template_trash` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`template_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]phpwcms_template`
--

INSERT INTO `[[dbprefix]]phpwcms_template` VALUES
(1, 1, 'Sample Template (very basic)', 1, 'a:14:{s:4:"name";s:28:"Sample Template (very basic)";s:7:"default";i:1;s:6:"layout";i:1;s:3:"css";a:1:{i:0;s:12:"frontend.css";}s:8:"htmlhead";s:0:"";s:8:"jsonload";s:0:"";s:10:"headertext";s:0:"";s:8:"maintext";s:677:"<!-- very basic DIV based template -->\r\n<div style="padding:10px;border-bottom:1px solid #CC3300;margin:0 0 12px 0;background-color:#DDDDDD;">\r\n<h3>My sample header</h3>\r\n</div>\r\n<div style="position:relative;top:-12px;float:right;padding:10px;border-bottom:1px solid #CC3300;border-left:1px solid #CC3300;margin:0 0 15px 15px;background-color:#DDDDDD;width:150px;">\r\n<h6>navigation:</h6>\r\n{NAV_LIST_UL:P,0}\r\n</div>\r\n<p style="margin: 0 0 10px 0">you are here: {BREADCRUMB}</p>\r\n{CONTENT}\r\n\r\n<div style="border-top:1px solid #CC3300;margin:15px 0 0 0;text-align:center;padding:7px;">\r\ncopyright &copy; 2007 <a href="http://www.phpwcms.de" target="_blank">phpwcms.de</a>\r\n</div>";s:10:"footertext";s:0:"";s:8:"lefttext";s:0:"";s:9:"righttext";s:0:"";s:9:"errortext";s:42:"<h1>404 error page</h1>\r\n<p>No content</p>";s:10:"feloginurl";s:0:"";s:2:"id";i:1;}', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_user`
--

CREATE TABLE `[[dbprefix]]phpwcms_user` (
  `usr_id` int(11) NOT NULL AUTO_INCREMENT,
  `usr_login` varchar(30) NOT NULL DEFAULT '',
  `usr_pass` varchar(255) NOT NULL DEFAULT '',
  `usr_email` varchar(150) NOT NULL DEFAULT '',
  `usr_tstamp` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `usr_rechte` tinyint(4) NOT NULL DEFAULT '0',
  `usr_admin` tinyint(1) NOT NULL DEFAULT '0',
  `usr_avatar` varchar(50) NOT NULL DEFAULT '',
  `usr_aktiv` int(1) NOT NULL DEFAULT '0',
  `usr_name` varchar(100) NOT NULL DEFAULT '',
  `usr_var_structure` blob NOT NULL,
  `usr_var_publicfile` blob NOT NULL,
  `usr_var_privatefile` blob NOT NULL,
  `usr_lang` varchar(50) NOT NULL DEFAULT '',
  `usr_wysiwyg` int(2) NOT NULL DEFAULT '0',
  `usr_fe` int(1) NOT NULL DEFAULT '0',
  `usr_vars` mediumtext NOT NULL,
  PRIMARY KEY (`usr_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]phpwcms_user`
--

INSERT INTO `[[dbprefix]]phpwcms_user` VALUES
(1, '[[admin_username]]', '[[admin_pass]]', '[[admin_email]]', '[[regtime]]', 0, 1, '', 1, '[[admin_realname]]', '', '', '', '[[language]]', 2, 2, '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_userdetail`
--

CREATE TABLE `[[dbprefix]]phpwcms_userdetail` (
  `detail_id` int(11) NOT NULL AUTO_INCREMENT,
  `detail_regkey` varchar(255) NOT NULL DEFAULT '',
  `detail_pid` int(11) NOT NULL DEFAULT '0',
  `detail_formid` int(11) NOT NULL DEFAULT '0',
  `detail_tstamp` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `detail_title` varchar(255) NOT NULL DEFAULT '',
  `detail_salutation` varchar(255) NOT NULL DEFAULT '',
  `detail_firstname` varchar(255) NOT NULL DEFAULT '',
  `detail_lastname` varchar(255) NOT NULL DEFAULT '',
  `detail_company` varchar(255) NOT NULL DEFAULT '',
  `detail_street` varchar(255) NOT NULL DEFAULT '',
  `detail_add` varchar(255) NOT NULL DEFAULT '',
  `detail_city` varchar(255) NOT NULL DEFAULT '',
  `detail_zip` varchar(255) NOT NULL DEFAULT '',
  `detail_region` varchar(255) NOT NULL DEFAULT '',
  `detail_country` varchar(255) NOT NULL DEFAULT '',
  `detail_fon` varchar(255) NOT NULL DEFAULT '',
  `detail_fax` varchar(255) NOT NULL DEFAULT '',
  `detail_mobile` varchar(255) NOT NULL DEFAULT '',
  `detail_signature` varchar(255) NOT NULL DEFAULT '',
  `detail_prof` varchar(255) NOT NULL DEFAULT '',
  `detail_notes` blob NOT NULL,
  `detail_public` int(1) NOT NULL DEFAULT '1',
  `detail_aktiv` int(1) NOT NULL DEFAULT '1',
  `detail_newsletter` int(11) NOT NULL DEFAULT '0',
  `detail_website` varchar(255) NOT NULL DEFAULT '',
  `detail_userimage` varchar(255) NOT NULL DEFAULT '',
  `detail_gender` varchar(255) NOT NULL DEFAULT '',
  `detail_birthday` date DEFAULT NULL,
  `detail_varchar1` varchar(255) NOT NULL DEFAULT '',
  `detail_varchar2` varchar(255) NOT NULL DEFAULT '',
  `detail_varchar3` varchar(255) NOT NULL DEFAULT '',
  `detail_varchar4` varchar(255) NOT NULL DEFAULT '',
  `detail_varchar5` varchar(255) NOT NULL DEFAULT '',
  `detail_text1` text NOT NULL,
  `detail_text2` text NOT NULL,
  `detail_text3` text NOT NULL,
  `detail_text4` text NOT NULL,
  `detail_text5` text NOT NULL,
  `detail_email` varchar(255) NOT NULL DEFAULT '',
  `detail_login` varchar(255) NOT NULL DEFAULT '',
  `detail_password` varchar(255) NOT NULL DEFAULT '',
  `userdetail_lastlogin` datetime DEFAULT NULL,
  `detail_int1` bigint(20) NOT NULL DEFAULT '0',
  `detail_int2` bigint(20) NOT NULL DEFAULT '0',
  `detail_int3` bigint(20) NOT NULL DEFAULT '0',
  `detail_int4` bigint(20) NOT NULL DEFAULT '0',
  `detail_int5` bigint(20) NOT NULL DEFAULT '0',
  `detail_float1` double NOT NULL DEFAULT '0',
  `detail_float2` double NOT NULL DEFAULT '0',
  `detail_float3` double NOT NULL DEFAULT '0',
  `detail_float4` double NOT NULL DEFAULT '0',
  `detail_float5` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`detail_id`),
  KEY `detail_pid` (`detail_pid`),
  KEY `detail_formid` (`detail_formid`),
  KEY `detail_password` (`detail_password`),
  KEY `detail_aktiv` (`detail_aktiv`),
  KEY `detail_regkey` (`detail_regkey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_usergroup`
--

CREATE TABLE `[[dbprefix]]phpwcms_usergroup` (
  `group_id` int(11) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(200) NOT NULL DEFAULT '',
  `group_member` mediumtext NOT NULL,
  `group_value` longblob NOT NULL,
  `group_timestamp` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `group_trash` int(1) NOT NULL DEFAULT '0',
  `group_active` int(1) NOT NULL DEFAULT '0',
  `group_modkey` varchar(20) NOT NULL,
  `group_syskey` varchar(10) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `group_member` (`group_member`(255))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]phpwcms_userlog`
--

CREATE TABLE `[[dbprefix]]phpwcms_userlog` (
  `userlog_id` int(11) NOT NULL AUTO_INCREMENT,
  `logged_user` varchar(30) NOT NULL DEFAULT '',
  `logged_username` varchar(100) NOT NULL DEFAULT '',
  `logged_start` int(11) unsigned NOT NULL DEFAULT '0',
  `logged_change` int(11) unsigned NOT NULL DEFAULT '0',
  `logged_in` int(1) NOT NULL DEFAULT '0',
  `logged_ip` varchar(24) NOT NULL DEFAULT '',
  `logged_section` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`userlog_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
