<?php
declare(strict_types=1);

/**
 * Pimcore
 *
 * This source file is available under two different licenses:
 * - GNU General Public License version 3 (GPLv3)
 * - Pimcore Commercial License (PCL)
 * Full copyright and license information is available in
 * LICENSE.md which is distributed with this source code.
 *
 *  @copyright  Copyright (c) Pimcore GmbH (http://www.pimcore.org)
 *  @license    http://www.pimcore.org/license     GPLv3 and PCL
 */

namespace Pimcore\Event\Model\DataObject\ClassificationStore;

use Pimcore\Model\DataObject\Classificationstore\CollectionConfig;
use Symfony\Contracts\EventDispatcher\Event;

class CollectionConfigEvent extends Event
{
    protected CollectionConfig $collectionConfig;

    /**
     * DocumentEvent constructor.
     *
     */
    public function __construct(CollectionConfig $collectionConfig)
    {
        $this->collectionConfig = $collectionConfig;
    }

    public function getCollectionConfig(): CollectionConfig
    {
        return $this->collectionConfig;
    }

    public function setCollectionConfig(CollectionConfig $collectionConfig): void
    {
        $this->collectionConfig = $collectionConfig;
    }
}
