# Pimcore Admin Classic Bundle

The Admin Classic Bundle provides a Backend UI for Pimcore.
It is based on the [ExtJS](https://www.sencha.com/products/extjs/) framework.

The Admin Bundle is a core bundle of Pimcore and is shipped with every Pimcore installation. 
Therefore, it is not necessary to install it separately.

## Provided Functionality in a Nutshell
- Documents: Content Management System for managing and editing content for your website.
- Data Objects: Manage and edit data objects for PIM, MDM, DAM, CRM, ERP, etc.
- Assets: Data Asset Management for managing and editing files, images, videos, etc.
- Settings: Generic settings for data types, system settings, etc.
- Users & Roles: Manage users and roles for granting access to the system.
- Reports: Create and Manage reports for your data.
- Search: Search across all elements in the system.
- Workflows: Create and manage workflows for your data.
And much more ...


For a first impression have a look at our [Demo App](https://demo.pimcore.fun/admin) with credentials `user: admin` and `pass: demo`.

## Working With Admin Interface

Following topics are short-cuts into the documentation for admin interface:

- [Getting Started](https://github.com/pimcore/pimcore/blob/11.x/doc/01_Getting_Started/06_Create_a_First_Project.md)
- [User & Roles](https://github.com/pimcore/pimcore/blob/11.x/doc/22_Administration_of_Pimcore/07_Users_and_Roles.md)
- [Deeplinks](https://github.com/pimcore/pimcore/blob/11.x/doc/20_Extending_Pimcore/23_Deeplinks_into_Admin_Interface.md)
- [Admin Translations](https://github.com/pimcore/pimcore/blob/11.x/doc/06_Multi_Language_i18n/07_Admin_Translations.md)
- [Extending Admin UI](https://github.com/pimcore/pimcore/blob/11.x/doc/20_Extending_Pimcore/13_Bundle_Developers_Guide/06_Event_Listener_UI.md)

