# Release 2023.3

Here you will find all the important new features and release notes of the Platform Version 2023.3 release.

## Most Important New Features

### Admin UX/UI Improvements

Besides the ongoing development for the all new Admin UI, we decided also to improve the existing Admin UI with following aspects:
- Changing to a light theme
- Refactoring of the main navigation
- Refactoring of the editor toolbar

These changes come in an enterprise extension and thus can be activated on instance level. Details see [extension documentation](../../Light_Theme_Admin_UI/).


### Workflow Automation Integration

The new enterprise extension **Workflow Automation Integration** allows the download of templates of configuration templates for
workflow automation engines to easily set up different use cases and tailor them to your specific
needs and so speed-up integration of Pimcore with any third party system.

In its first version, the Workflow Automation Integration will be shipped with templates for [N8N](https://n8n.io/), generated based
on existing Datahub configurations.

More Details see [Workflow Automation Integration documentation](../../Workflow_Automation/).


### Alternative Elements Trees

An addition to the Backend Power Tools extension that allows you to configure different views of your data objects and so display additional trees with
virtual folder structures and hierarchies based on groupings of data attributes.
The configuration takes place in an easy-to-use configuration window.

Some usage examples for the Alternative Elements Trees would be:
- Group and organize data based on technical attributes.
- Organize data in multiple classification hierarchies.
- Catalog management for specific output channels.
- Overview for variants management (e.g. products of a specific color or size).
- Data governance. Check values regarding consistency.

More Details see [Alternative Elements Trees documentation](../../Backend_Power_Tools/Alternative_Element_Trees/).

### Core Framework

Alongside ongoing product maintenance, this platform releases includes a new minor version of the Core Framework which introduces the following new features:

#### Centralized Select Options definition via Backend Admin UI
Manage select and multiselect fields within data objects using predefined options created and maintained in the Backend Admin UI. With this new feature,
users can easily define a master set of select options that can be used in multiple fields across various definitions, such as Class definitions, Field collections,
and Object bricks.
Furthermore, these options can be managed and secured according to specific user permissions.

Similar to Class definitions, you can create Select Option definitions that are easily deployable and rebuildable.

Big thank you to K J Kooistra from our partner youwe for that contribution.

More Details see [Select Options Documentation](../../Pimcore/Objects/Object_Classes/Data_Types/Select_Options).


#### Quantity value unit definitions - Export/Import
This feature introduces support for exporting Quantity Value unit definitions into JSON files, which can then be imported into other environments. This functionality
resolves the issue of repeatedly defining QV units across different environments and contributes to better deployment scenarios.

There's also a command for importing unit definitions `pimcore:definition:import:units`

Thank you to Purshottam Nepal from our partner Javra Software for that contribution.


#### Improved Security
Allover security was improved by
- adding sanitizing checks for PDFs to remove potential unsafe Javascript codes.
- making Password Recovery Token to be one time use only.
- checking if new password is NOT the same as the old one when resetting.

#### Improved Performance
Performance was improved
- by introducing options to disable some asset background job like counting pages, extract text & generating thumbs.
- for opening assets by precalculating spherical data in background processes.
- by saving DataObject properties are with dirty state only (not on every save anymore).


More Details see [11.1.0 Milestone](https://github.com/pimcore/pimcore/milestone/189?closed=1)


## Upgrade Notes
Before updating, have a look at all the upgrade notes relevant to your system:
- Pimcore Core Framework [Upgrade Notes](../../Pimcore/Installation_and_Upgrade/Upgrade_Notes/#pimcore-1110)
- Admin UI Classic Bundle [CHANGELOG](https://github.com/pimcore/admin-ui-classic-bundle/blob/1.x/CHANGELOG.md#v120)

