# Release 2024.3
Here you will find all the important new features and release notes of the Platform Version 2024.3 release.

## Most Important New Features

### Pimcore Copilot enhancements

The Pimcore Platform Version 2024.3 includes the following Copilot enhancements:

- **Automation action step: AI text classification with fine-tuned models**:
  This action step leverages fine-tuned models for data object classification by assigning attributes such as
  select, multi-select, and tags. It offers a more flexible and precise approach compared to the traditional 'Hugging
  Face Zero-Shot Text Classification' as the fine-tuned models are optimized for the specific needs of your data.
  Details see [docs](https://pimcore.com/docs/platform/Copilot/Included_Actions/AI_Integrations_Powered_By_Hugging_Face/Hugging_Face_Text_Classification).

- **Automation action step: AI image classification with fine-tuned models**
  This action step leverages fine-tuned models for image classification by assigning tags to images. It offers a more
  flexible and precise approach compared to the traditional 'Hugging Face Zero-Shot Image Classification' as the
  fine-tuned models are optimized for the specific needs of your data.
  Details see [docs](https://pimcore.com/docs/platform/Copilot/Included_Actions/AI_Integrations_Powered_By_Hugging_Face/Hugging_Face_Image_Classification).

- **Showcase for fine-tuning classification models**
  The Copilot Showcase bundle features a diverse array of action steps designed to assist you in the process of
  fine-tuning your own Hugging Face model.
  Whether your focus is on text classification or image classification, these step implementations will provide you with
  the guidance to effectively develop and refine your model to meet your specific needs.

  The showcase includes steps for:
  - Start/Stop a specific Hugging Face Space for the training.
  - Prepare Training data for texts:
    - This step creates a csv file of data objects based on a twig template to train the model. In our showcase, we are
      training the model based on the carClass by using the name, the type, and the color of the car.
  - Prepare Training data for assets:
    - This step creates a zip file with thumbnails in a defined folder structure. The folder structure reflects the tags
      of the existing images for training purposes.
  - Debug data to send job run context, environment variables, and selected elements to the log.
  - Start training for assets/texts.
  - Clean up temporary files.

  Details see [docs](https://pimcore.com/docs/platform/Copilot_Showcases/Included_Actions/AI_Integrations_Powered_By_Hugging_Face/Hugging_Face_Fine-tune_Models).

- **Automation action step: Apply workflow transition**: This action step allows you to apply a workflow transition to 
  data elements. Details see [docs](https://pimcore.com/docs/platform/next/Copilot/Included_Actions/Change_Workflow_State).

- **Automation action Step: Change the parent of assets**: Also allow changing the parent of assets, analog for the existing 
  functionality for data objects. Details see [docs](https://pimcore.com/docs/platform/Copilot_Showcases/Included_Actions/Link_To_Parent).

- **PQL result as scope for subsequent automation action steps**: The results from Filter Data Objects and Filter Assets action
  steps can be utilized as scope for the subsequent action steps.
  Details see [docs](https://pimcore.com/docs/platform/Copilot/Included_Actions/Filter_Data_Objects#detailed-configuration-options).

  Use case: filter assets based on a specific condition and then apply image-to-text action step on the filtered assets.

- **Additional triggers for automation actions**: System events like add/update/delete of assets, data object and
  documents, as well as workflow transitions can now be used as triggers for automation actions. Details see
  [docs](https://pimcore.com/docs/platform/Copilot/Configuration/Automation_Actions/#event-triggers).

- **Use PQL query for workspace precondition**: This enhancement allows to define a workspace precondition via a PQL
  query instead of writing a precondition service in code, see
  [filter data objects](https://pimcore.com/docs/platform/Copilot/Included_Actions/Filter_Data_Objects#configuration-options)
  and [filter assets](https://pimcore.com/docs/platform/Copilot/Included_Actions/Filter_Assets#detailed-configuration-options).

- **Environment variables in step configuration**: Environment variables can now be used in action step configurations,
  see [details](https://pimcore.com/docs/platform/next/Pimcore/Development_Tools_and_Details/Generic_Execution_Engine/Jobs_and_Jobruns/Step_Configuration#configuration). 
  This enables the users of an action to easily adjust configuration options when executing an action which leads to even
  more flexibility for the Pimcore Copilot actions.

  Use cases:
  - Enter a PQL query dynamically - and not preconfigure it in the action.
  - Select model to be used for certain AI tasks.
  - Select workflow transition to be executed.
  - Select the ID of a parent for reassigning the parent of data objects or assets.

- **Grouping of action configurations**: action configurations can now be grouped into folders.

More Details see [Pimcore Copilot Documentation](https://pimcore.com/docs/platform/Copilot/).

## Further improvements and housekeeping

In addition to the enhancements made to the Pimcore Copilot, the following improvements and housekeeping have been
implemented:

### Core Framework
- Generic Execution Engine
    - Implementation of an execution mode to switch between processing each individual item or handling all items
      at once, see [docs](https://pimcore.com/docs/platform/Pimcore/Development_Tools_and_Details/Generic_Execution_Engine/Jobs_and_Jobruns/Step_Configuration#selection-processing-mode).
    - Allow configuration via job execution environment variables, see [docs](https://pimcore.com/docs/platform/Pimcore/Development_Tools_and_Details/Generic_Execution_Engine/Jobs_and_Jobruns/Step_Configuration#configuration).
- Tinymce: Add `advlist`, `charmap`, `searchreplace`, `visualblocks` plugins.
- Added events for website settings changes, see [docs](https://pimcore.com/docs/platform/Pimcore/Tools_and_Features/Website_Settings#events).
- Prepare for twig >= 3.9.0, this consists of the following parts:
    - Deprecated `pimcore_cache` extension, use new twig extension `pimcorecache` (based on nodes) instead,
      see [docs](https://pimcore.com/docs/platform/Pimcore/MVC/Template/Template_Extensions/#pimcorecache).
    - Deprecated `pimcore_placeholder` `captureStart()`/`captureEnd()` methods and update docs with alternative approach
      based on `set`.
    - Deprecated `pimcore_head_script` `captureStart()`/`captureEnd()` methods and update docs with alternative approach
      based on `set`.
    - Deprecated `pimcore_head_link` `captureStart()`/`captureEnd()` methods and update docs with alternative approach
      based on `set`.
- Removed `rybakit/twig-deferred-extension` dependency and `Twig\DeferredExtension\DeferredExtension` service. If you use
  deferred twig blocks, please add the dependency to your own `composer.json` and the service to your own `service.yaml`.
- Deprecated `key_value_table.html.twig` template, was moved to personalization bundle.

### Admin UI classic bundle
- Data Objects:
  - Added grid preview for field collections.
  - Add confirmation prompt for Quantity Value.
  - Relational fields' grid: remember column widths.
  - Relational fields: Add column filtering.
  - Add optimized admin loading to reverse relations.
  - Case-insensitive search for object title and key in filter grid view.
  - Field type Table: add button to clone row.
  - Field type Video: optimize regex to match more YouTube url cases like "shorts".
  - Add missing label defaults to numeric control.
- Assets:
  - Upload zip archive-option to overwrite files.
- General:
  - Prevent accidental removal of whole folder instead of deleting selected assets / data objects.
  - Show tree search if paging is not necessary.

### Data Hub
- Add all definitions button and multi drag and drop.
- Add try/catch to catch duplicate path + general exceptions.
- Dropped support for Pimcore core framework 10, minimum requirement for pimcore/pimcore now 11.2.

### Datahub Webhooks
- Adding project-side expandability.

### Ecommerce Framework
- Add the possibility to disable the order detail tab via JS.
- Lazy load products in CatalogProduct condition.
- Removed the package `rybakit/twig-deferred-extension`. If you extend the twig layout from the E-Commerce Framework,
  please check if custom CSS/JS code added by `pimcore_head_script` and `pimcore_head_link` is still working.

### Generic Data Index
- The PQL (Pimcore Query Language) has been extended with new operators (!=, not like) and support for null/empty values.

### Workflow designer
- Show ID of the transition and workflow state in the GUI.
- Bump `symfony/webpack-encore` to 5.0.0.


## Upgrade Notes
Before updating, also have a look at the following upgrade notes if relevant to your system:
- [Pimcore Core Framework](https://pimcore.com/docs/platform/Pimcore/Installation_and_Upgrade/Upgrade_Notes/#pimcore-1140)
- [Pimcore Datahub](https://pimcore.com/docs/platform/Datahub/Installation_and_Upgrade/Upgrade_Notes#180)
- [Ecommerce Framework](https://pimcore.com/docs/platform/Ecommerce_Framework/Installation/Upgrade_Notes)


:::warning

Also, please keep in mind, that Pimcore is again compatible with Twig >= 3.14.0. Please consider updating as 
Twig < 3.14.0 has some security issues.

:::
